class VendorSummaryController{
     constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService,$rootScope) {
    'ngInject'
    this.API = API
    $rootScope.$broadcast('pageurl', $state.current.url);
    this.$uibModal = $uibModal 
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
   let vendor_id = $stateParams.vendor_id
    this.alerts = []
 if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

}

      let Joborders = API.service('vendorsummary', API.all('jobsorders'))
      Joborders.one(vendor_id).get()
      .then((response) => {
        let dataSet = response.plain()
        $scope.p_worked=dataSet.data.vendorsummary[0].jobs_worked.length;
        $scope.p_sub=dataSet.data.vendorsummary[0].profiles_submitted;
        $scope.p_closed=dataSet.data.vendorsummary[0].profiles_closed;

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet.data.vendorsummary[0].jobs_worked)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
         DTColumnBuilder.newColumn('id').withTitle('ID'),
        DTColumnBuilder.newColumn('vendor_id').withTitle('Recruiter ID'),
        DTColumnBuilder.newColumn(null).renderWith(jobname).withTitle('Name'),
        DTColumnBuilder.newColumn(null).renderWith(exp).withTitle('Experience'),
        DTColumnBuilder.newColumn(null).renderWith(vendorCreated).withTitle('Created Date')
        ]

        this.displayTable = true
      })

      let createdRow = (row) => {
        $compile(angular.element(row).contents())($scope)
      }
      let actionId = (data) => {
        return `<a title="View This Vendor Details" ui-sref="app.vendordescview({vendorId: ${data.vendor_id}})">
                     ${data.vendor.id}
                     </a>`
      }
   
      let jobname = (data) => {
        if(data.job){ return `${data.job.name}` }
          else {return `NA`}
      }

      let exp = (data) => {
        if(data.job) {
          if(data.job.experience != null) {
            return `${data.job.experience} Years`  
          } else { return `NA`   }
        } else { return `NA` }
      }

      let vendorCreated = (data) => {
        return `${data.created_at}`
      }

      let vendorEmail = (data) => {
        return `${data.vendor.email}`
      }
  } // constructor

    $onInit(){}
} //VendorSummaryController

export const VendorSummaryComponent = {
    templateUrl: './views/app/components/vendor-summary/vendor-summary.component.html',
    controller: VendorSummaryController,
    controllerAs: 'vm',
    bindings: {}
};
