class VendorTalentpoolDashboardController{
   constructor ($scope, $state, $rootScope, AclService, ContextService, API, $compile, DTOptionsBuilder, DTColumnBuilder,  $uibModal,  $log, $stateParams) {
    'ngInject'
    this.$state = $state
    this.$scope=$scope 
    this.$uibModal = $uibModal
    this.$log = $log
    this.alerts = []
    let dashboard = this
    this.API = API
    this.can = AclService.can
    this.$state = $state
    this.$log = $log 
    if ($stateParams.alerts) {this.alerts.push($stateParams.alerts)}
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    
    $scope.isChildVendor=false;
    //$scope.selectedDateObj = null;
    $scope.reschedule_association_id = null;
    $scope.labels = ['Skills Required Match', 'Qualification Match', 'Location Match', 'Experience Match', 'Position Match', 'Skills Prefered Match']
    $scope.series = ['Series A']
    $scope.data = [[65, 59, 80, 81, 56, 55, 40],[28, 48, 40, 19, 86, 27, 90]]
    $scope.value = 1.5;
    $scope.upperLimit = 6;
    $scope.lowerLimit = 0;
    $scope.unit = "kW";
    $scope.precision = 2;
    $scope.eventSource = null;
    $scope.successMessage = null;
    $scope.ranges = [
        {min: 0,max: 1.5,color: '#DEDEDE'},
        {min: 1.5,max: 2.5,color: '#8DCA2F'},
        {min: 2.5,max: 3.5,color: '#FDC702'},
        {min: 3.5,max: 4.5,color: '#FF7700'},
        {min: 4.5,max: 6.0,color: '#C50200'}
    ];
    ContextService.me(function (data) {
      dashboard.userData = data
      if(data){ $scope.isChildVendor = data.user.parent_id; }
    });
    
    $scope.onEventSelected = function (event) {
          swal({
            title: event.swal_title,
            text: event.popup_message,
            html: true
          })
      //swal(event.swal_title, event.popup_message , 'success')
    };
     function renderer(api, rowIdx, columns) {
      var data = $.map( columns, function ( col, i ) {
            return col.hidden ?
            '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
            '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
      return retVal;
  }
   let talentpools_data = API.service('vendortalentpoolsdata', API.all('dashboard'))
           talentpools_data.getList()
        .then((response) => {
          dashboard.vendorDashboardTalentpools = response.plain();
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
          
        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Talentpool Code').notSortable()
            .renderWith(talentpool_code),
            DTColumnBuilder.newColumn(null).withTitle('Talentpool Name').notSortable()
            .renderWith(talentpool_name),
            DTColumnBuilder.newColumn(null).withTitle('Profile Name').notSortable()
            .renderWith(profile_name),
             DTColumnBuilder.newColumn(null).withTitle('For Job').notSortable()
            .renderWith(job_name),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true

      })
      let talentpool_name = (data) => {
        return `${data.talentpools.name}</a>`  
      }
      let talentpool_code = (data) => {
        return `${data.talentpools.talentpool_code}</a>`  
      }

      let profile_name = (data) => {
        return `${data.talentpools.resume_name}`  
      }
      let job_name = (data) => {
        return `${data.job.name}`  
      }
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `<a class="btn btn-xs btn-success">
                    <i class="fa fa-check" title="Submit This Request to Vendor"></i>
                </a>
                <a class="btn btn-xs btn-warning">
                    <i class="fa fa-pause" title="Hold This Request to Vendor"></i>
                </a>
                <a class="btn btn-xs btn-danger">
                    <i class="fa fa-remove" aria-hidden="true" title="Cancel This Request"></i>
                </a>
                `
    }
     let amDashboardTlntpoolnumbers = API.service('vendortplnumbers', API.all('dashboard'))
    amDashboardTlntpoolnumbers.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.amTlntpoolnumbers=dataSet[0];
    })

    let vendorinterschedule = API.service('vendorinterschedule', API.all('joborders'))
    vendorinterschedule.getList()
      .then((response) => {
        let dataSet = response.plain()
        angular.forEach(dataSet, function(value, key) {
          if(value.interview_schedule_date) {
            let date_time=value.interview_schedule_date,
            slices = date_time.split(' '),
            date_from_string = slices[0],
            time_from_string = slices[1],
            apm = slices[2],
            date_string_split = date_from_string.split('-'),
            ds = date_string_split[0].replace(/\b0+/g, ''),
            ms = date_string_split[1].replace(/\b0+/g, ''),
            ys = date_string_split[2].replace(/\b0+/g, ''),
            time_string_split=time_from_string.split(':'),
            hs = time_string_split[0].replace(/\b0+/g, ''),
            mins = time_string_split[1].replace(/\b0+/g, '');
            ms = ms-1;
            ds = ds-1;
            if(apm == "PM"){hs = 12+parseInt(hs);}
            let startTime = new Date(ys, ms, ds, hs, mins),
            endDate = new Date(ys, ms, ds, hs, 59);
            dataSet[key]['startTime']=startTime;
            dataSet[key]['endTime']=endDate;
          }
        });
        $scope.eventSource = dataSet;

        setTimeout(function(){ 
          document.querySelectorAll('.calendar-event-inner').forEach(function (element, index) {
              element.title = element.innerHTML;
              let str=element.innerHTML;
              element.innerHTML = str.substr(0, 20) + "...";
          });
        }, 1000);
    })

  $scope.changeDate = function (assocId) { $scope.reschedule_association_id=assocId; }
    $scope.dateOpts = {
        enableTime: true,
        dateFormat: "d-m-Y h:i K",
        position: "below",
        animate: true,
        closeOnSelect: true,
        static: true,
        time_24hr: false,
        onChange: function(selectedDates, dateStr, instance) {
          $scope.selectedDateObj=dateStr;
        },
        onOpen: [
          function(selectedDates, dateStr, instance){
            instance.setDate(instance.element.attributes[6].nodeValue);
            instance.redraw();
            var existingElem = angular.element(document.getElementsByClassName('flatpickr-button'));
            existingElem.remove();
            var newEl = angular.element('<div class="flatpickr-button"><button class="btn btn-default dateSubmit" ng-click="submitNewDate()" type="submit">Submit</button></div>');
            var pageElement = angular.element(document.getElementsByClassName('flatpickr-calendar open'));
            pageElement.append(newEl);
            $compile(pageElement)($scope); // Double compilation
          }
        ],
    };

  $scope.submitNewDate = function() {
      $state.go($state.current, {}, { alerts: 'test' })
      let reschedule = API.service('reschedulevendor', API.all('joborders'))
      reschedule.post({
        'newDateTime': $scope.selectedDateObj,
        'assocId': $scope.reschedule_association_id,
      }).then((response) => {
        let alert = { type: 'success', msg: "Interview has been rescheduled successfully."}
        $state.go($state.current, {alerts: alert},{reload:true})
        setTimeout(function(){ $(".alert-success").hide() }, 10000);
      }, function (response) {
        let alert = { type: 'error', msg: response.data.message }
        $state.go($state.current, { alerts: alert},{reload:true})
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      });
  };

    let vendorNotes = API.service('vendortalentpoolactivitydata', API.all('dashboard'))
    vendorNotes.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorNotes = dataSet

    })
    let Amdeviationresponse = API.service('amdeviationresponse', API.all('joborders'))
    Amdeviationresponse.getList()
    .then((response) => {
      dashboard.amdeviationresponse = response.plain()
    })
    let vendorDashboardRev = API.service('talentpooljobrevenues', API.all('dashboard'))
    vendorDashboardRev.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.pieLabels = []
        $scope.pieData = []
        angular.forEach(dataSet, function(value, key) {
          if(value.vendor_bill_rate) {
            $scope.pieLabels.push(value.job.name)
            $scope.pieData.push(value.vendor_bill_rate)
          }
        });
    })
      /* It fetches all the metric values It will return 16 different values like jobs pending, Profiles rejcted .. etc
        Joborders controller
        vendorametrics        
    */  
    let vendormetrics = API.service('vendormetricsall', API.all('joborders'))
    vendormetrics.getList()
      .then((response) => { 
        let dataSet = response.plain()
        $scope.vendormetrics =dataSet;
    })      
    let vendorDashboard = API.service('vendornumbers', API.all('dashboard'))
    vendorDashboard.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorDashboard=dataSet[0];
        $scope.pieLabels1 = ['CVs Submitted','Selected Profiles']
        $scope.pieData1 =   [dashboard.vendorDashboard.candidates,dashboard.vendorDashboard.selectedprofiles]
        $scope.pieColors1 = ['#dddddd','#ff8b31']
        $scope.pieLabels2 = ['Jobs Assigned','Jobs Closed']
        $scope.pieData2 =   [dashboard.vendorDashboard.jobs,dashboard.vendorDashboard.jobsclosed]
        $scope.pieColors2 = ['#dddddd','#407fc5']
    })

    let team = API.service('vendorusernumber', API.all('dashboard'))
    team.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.team=dataSet;
    })

    let vendorJobAlerts = API.service('vendordashboardalerts', API.all('joborders'))
    vendorJobAlerts.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorJobAlerts=dataSet;
         /*$("#myModalData").modal('hide');*/
    })
     $scope.acceptJob=function(id){
        $state.go($state.current, {}, { alerts: 'test' })
        let vendorJobAlerts1 = API.service('jobacceptuser-show', API.all('joborders'))
        vendorJobAlerts1.one(id).put()
        .then((response) => {
          let alert = { type: 'success', msg: 'Job has been Accepted successfully.' }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $state.go('app.vassignedjobs');
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      }
      $scope.rejectJob=function(id){
        $state.go($state.current, {}, { alerts: 'test' })
        let vendorJobAlerts1 = API.service('jobrejectuser-show', API.all('joborders'))
        vendorJobAlerts1.one(id).put()
        .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorJobAlerts=dataSet;
          let alert = { type: 'success', msg: 'Job has been Rejected successfully.' }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      }
      var toggled;
      $scope.expandtoggle = function(e) {
          if($(e.currentTarget).hasClass('showing')) {toggled = true;}
            else {toggled = false;}
          $scope[toggled ? "deleterow" : "expandrow"](e);
      };
      $scope.expandrow = function (e) {
        var clientinfo = $(e.currentTarget).closest('.client-info');
        $(e.currentTarget).addClass('showing');
        var content = $(e.currentTarget).parent().parent().find('.fade-in').html();
        $('<div>'+content+'</div>').insertAfter(clientinfo);
      };
      $scope.deleterow = function (e) {
        $(e.currentTarget).removeClass('showing');
         var clientinfo = $(e.currentTarget).closest('.client-info').next().remove();;
      };
}  //constructor
modalOpen (assignedjobs, closedjobs, profilesselected, numberofemployers) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let jobs      = assignedjobs
    let jobsclosed = closedjobs
    let selectedprofiles = profilesselected
    let employersnumber = numberofemployers
    let API = this.API
    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: { 
        jobs: function () {return jobs;},
        jobsclosed: function () {return jobsclosed;},
        selectedprofiles: function () {return selectedprofiles;},
        employersnumber: function () {return employersnumber;}
       }
    })
    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => { 
      $log.info('Modal dismissed at: ' + new Date()) 
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
} // modalopen
modalcontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, jobs, jobsclosed, selectedprofiles, employersnumber) {
    'ngInject'
    this.$state=$state
    $scope.jobs = jobs;
    $scope.jobsclosed = jobsclosed;
    $scope.selectedprofiles = selectedprofiles;
    $scope.employersnumber = employersnumber;
    $scope.assetId = null
    this.alerts = []
    if ($stateParams.alerts) {this.alerts.push($stateParams.alerts)}
    this.ok = () => {$uibModalInstance.close($scope.selected.item)}
    this.cancel = () => {$uibModalInstance.dismiss('cancel')}
  }//modal controller
  toggleModalAnimation () {this.animationsEnabled = !this.animationsEnabled}
  $onInit(){}
}

export const VendorTalentpoolDashboardComponent = {
    templateUrl: './views/app/components/vendor-talentpool-dashboard/vendor-talentpool-dashboard.component.html',
    controller: VendorTalentpoolDashboardController,
    controllerAs: 'vm',
    bindings: {}
};
