class VendorTalentpoolListController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API,$rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</.0000000000000span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }
    let Talentpoolslist =this.API.service('talentpools')
    Talentpoolslist.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.count=dataSet.length;
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
        this.dtColumns = [
         // DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn('talentpool_code').withTitle('Talentpool Code'),
          DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(fullName),
          //DTColumnBuilder.newColumn('description').withTitle('Description'),
          DTColumnBuilder.newColumn(null).withTitle('Skills').notSortable()
            .renderWith(skills_data),
             DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml),
            
        ]
        this.displayTable = true
      })

    let fullName = (data) => {
      return `<a title="View This Pool Details" ui-sref="app.talentpoolview({id: ${data.id}})">${data.name} </a>`}
    let createdRow = (row) => {$compile(angular.element(row).contents())($scope)}
    let actionsHtml = (data) => {
      return `<a class="btn btn-xs btn-warning" title="Edit this Talent Pool" ui-sref="app.talentpooledit({id: ${data.id}})"><i class="fa fa-edit"></i></a>`}
let skills_data = (data) => {
      return `
      ${data.skills_data.skills}`}
    
  let status = (data) => {

        if(data.status ==1){
            return `Active`
        }else{
            return `In-Active`
        }
      }    
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }
  $onInit () {}
}

export const VendorTalentpoolListComponent = {
    templateUrl: './views/app/components/vendor-talentpool-list/vendor-talentpool-list.component.html',
    controller: VendorTalentpoolListController,
    controllerAs: 'vm',
    bindings: {}
};
