class VendorUsersListController{
 constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API,$rootScope,ContextService) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</.0000000000000span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }
    ContextService.me(function (data) {
    
     $scope.vendor_name=data.user.first_name;
     $scope.vendorId = data.id;
    });
    let Users = API.service('vendorusers', API.all('users'))
    Users.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
        this.dtColumns = [
          //DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
          DTColumnBuilder.newColumn(null).withTitle('Mobile').renderWith(Mobile),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]
        this.displayTable = true
      })

    let fullName = (data) => {
      return `<a title="View This Vendor Details" ui-sref="app.vendorteamview({vendoruserId: ${data.id}})">${data.first_name} </a>`}
    let Mobile = (data) => {
      if(data.country_code != null)
      {
      return `<div> <span>${data.country_code}</span> <span style="word-spacing: 5px;">${data.mobile}</span> <div>`
      }
      else
      {
         return `<div> <span>+44</span> <span style="word-spacing: 5px;">${data.mobile}</span> <div>`
      }
      }
    let createdRow = (row) => {$compile(angular.element(row).contents())($scope)}
    let actionsHtml = (data) => {
      return `<a class="btn btn-xs" style="float: left; width: 50%;" ui-sref="app.vendorusersedit({vendorUserId: ${data.id}})"><img src="/user_assets/assets/emp_dashboard/edit.svg" width="18" class="img-q"></a>
       <a class="btn btn-xs" style="float: left; width: 50%;" ui-sref="app.kpi_agency_recruiter({vendorUserId: ${data.id}})"><img src="/user_assets/KPI-Icon2.png" width="33" class="kpi_icon"></a>
      `}
  }
    delete (userId) {
    let API = this.API
    let $state = this.$state
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }
  $onInit () {}
}
export const VendorUsersListComponent = {
    templateUrl: './views/app/components/vendor-users-list/vendor-users-list.component.html',
    controller: VendorUsersListController,
    controllerAs: 'vm',
    bindings: {}
}
