class VendorsEditController{
  constructor ($stateParams,$scope,AclService,ContextService,$timeout, $state, API,Upload,$rootScope) {
    'ngInject'
    this.Upload=Upload
    this.API = API
    this.$state = $state
    this.$scope = $scope
    this.formSubmitted = false
    this.alerts = []
    this.userRolesSelected = []
    this.countries=null
    $scope.existingAm = null
    $scope.masterAm = null
    $scope.countries = null
    this.validVendor_code = false;


    $rootScope.$broadcast('pageurl', this.$state.current.url);
    let navSideBar = this
    this.can = AclService.can
    ContextService.me(function (data) {
      navSideBar.userData = data
    })
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)   
    }
    let allCountries = API.service('locations')
      allCountries.getList()
      .then((response) => {
        $scope.countries = response.plain();
       });
       $scope.getcities=function(countryId) {
          let allCities = API.service('citiesof', API.all('locations'))
          allCities.one(countryId).getList()
        .then((response) => {
          $scope.masterlocations = null
          $scope.masterlocations = response.plain()
        })
      }


    let vendorId = $stateParams.userId;
    $scope.getCitys=function(){
      let Cities = API.service('cities', API.all('locations'))
      Cities.getList()
        .then((response) => {
          $scope.Cities = response.plain()
      })
   }//getCitys

    let Existingam = API.service('existingam', API.all('users'))
    Existingam.one(vendorId).getList()
      .then((response) => {
        $scope.existingAm = response.plain()
    });//accountmanager

    let Accountmanagers = API.service('amremaining', API.all('users'))
    Accountmanagers.one(vendorId).getList()
      .then((response) => {
        let systemVendors = []
        $scope.masterAm = response.plain()
    });//accountmanager  


    let UserData = API.service('vendordata', API.all('users'))
    UserData.one(vendorId).get()
      .then((response) => {
        this.userdata = API.copy(response)
        $scope.ProfilePath=this.userdata.data.path;
        $scope.ProfileName=this.userdata.data.file_name;
        this.Ams=this.userdata.data.accountmanager_id;
        this.payroll = this.userdata.data.payroll;
        this.country=this.userdata.data.countryid;
        $scope.country_code=this.userdata.data.country_code_id;
        $timeout(function() { 
          angular.element("#accM button").triggerHandler('click');
          angular.element("#accM button").triggerHandler('click');
         }, 1000);
        let company = API.service('companyn', API.all('users'))
        company.one(this.userdata.data.company_id).get()
        .then((response) => {
        $scope.company = API.copy(response)
        this.company=$scope.company;
        $scope.getcities(this.userdata.data.countryid);
      })
       var short_country_code = $scope.country_code;
        var countryCode = document.querySelector("#phone");
         window.intlTelInput(countryCode, {
          hiddenInput: "full_number",
          initialCountry: short_country_code,
            onlyCountries: ['GB', 'IN', 'US', 'DE', 'IT','FR','ES','NL','SE','PL','MT','GR','AT','PT','DK','CZ','HR','FI','BE','CY','HU','RO','IE','BG','LT','EE','SI','SK','LV','CHE'],
            separateDialCode: true,
          utilsScript: "/user_assets/css/utils.js?1562189064761",
        });
       
      })
  }

  save (isValid, userForm) {
    let $state = this.$state
    let $scope = this.$scope
  
    if (isValid) {
      $scope.amIds=[] 
      this.validVendor_code = false;
      this.userdata.data.cityPin=this.company.data.city_id;
      function countOf (text) {
          var s = text ? text.split(/\s+/) : 0; // it splits the text on space/tab/enter
          return s ? s.length : '';
      };

      var no_of_words = countOf(this.company.data.name);
      var acronym = null;

      if (no_of_words > 0) {
        var str = this.company.data.name;
        var matches = str.match(/\b(\w)/g);              // ['J','S','O','N']
        acronym = matches.join(''); 
      }

      if(acronym.toUpperCase() == this.userdata.data.vendor_code.toUpperCase()){
        this.validVendor_code = true;
      } else {
          $state.go(this.$state.current, {}, { alerts: 'test' },{reload:true})

          this.userdata.data.companyData=this.company.data;
          this.userdata.data.payroll = this.payroll

          angular.forEach(this.Ams, function (value, key) {
            $scope.amIds.push(value.id)
          });
          this.userdata.data.accountmanager_id = $scope.amIds;
          this.userdata.put()
            .then((response) => {
              let alert = { type: 'success', msg: 'Vendor profile has been updated.' }
              $state.go($state.current, { alerts: alert},{reload:true})
              setTimeout(function(){ $(".alert-success").hide() }, 7000);
              setTimeout(function(){ $state.go('app.vendorslist'); }, 7000);
              
            }, (response) => {
              let formErrors = []
              if (angular.isDefined(response.data.errors.message)) {
                  formErrors = response.data.errors.message[0];
                  let alert = { type: 'error', msg: response.data.errors.message[0] }
                  $state.go($state.current, { alerts: alert},{reload:true})
                  setTimeout(function(){ $(".alert-error").hide() }, 10000);
              } else {
                formErrors = response.data.errors;
                let alert = { type: 'error', msg: response.data.errors }
                $state.go($state.current, { alerts: alert},{reload:true})
                setTimeout(function(){ $(".alert-error").hide() }, 10000);
              }
              angular.forEach(formErrors, function (value, key) {
                let varkey = key.replace('data.', '')
                userForm[varkey].$invalid = true
                userForm[varkey].customError = value[0]
              })
              this.formSubmitted = true
            })
      }// else
    } else {this.formSubmitted = true}
  } //save

delete (Id) { 
    let API = this.API
    let $state = this.$state
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, Remove it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('vendoram',Id).remove()
        .then(() => {
          swal({
            title: 'Removed!',
            text: 'Removed accountmanager.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
} //delete

$onInit () {
    $(".numberValid").keypress(function (e) {
      if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
        return false;
      }
    });
}//init
}//constructor

export const VendorsEditComponent = {
    templateUrl: './views/app/components/vendors-edit/vendors-edit.component.html',
    controller: VendorsEditController,
    controllerAs: 'vm',
    bindings: {}
};
