class VendorsListController{
constructor ($scope, $state, $compile, $stateParams, DTOptionsBuilder, DTColumnBuilder, API,$rootScope, $uibModal, $log, AclService, $timeout, $auth) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    this.animationsEnabled = true

    let Users = API.service('vendors', API.all('users'))
$rootScope.$broadcast('pageurl', this.$state.current.url);

function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

}
    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
		  DTColumnBuilder.newColumn(null).withTitle('Vendor Type').renderWith(vendorType),
          //DTColumnBuilder.newColumn('country_code').withTitle('Country Code'),
          DTColumnBuilder.newColumn('company.name').withTitle('Company Name'),
          DTColumnBuilder.newColumn(null).withTitle('Mobile').renderWith(mobilenumber),
          DTColumnBuilder.newColumn(null).withTitle('Email').renderWith(emailid),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let mobilenumber = (data) => {
      return `
      <a class="mobile_font_color" href="tel:${data.mobile}">
        ${data.country_code} ${data.mobile}
      </a>
      `;
    }

     let emailid = (data) => {
      return `
      <a class="mobile_font_color" href="mailto:${data.email}">
      ${data.email}
      </a>
      `;
    }

    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" title="Edit" ui-sref="app.vendorsedit({userId: ${data.id}})">
                     <img src="/user_assets/assets/emp_dashboard/edit.svg" width="18" class="img-q">
                </a>
                &nbsp
                <!-- <button class="btn btn-xs" ng-click="vm.delete(${data.id})">
                    <img src="/user_assets/assets/emp_dashboard/delete.svg" width="18" class="img-q">
                </button> -->
                <a class="btn btn-xs" title="Assign" ui-sref="app.vendorsamedit({vendorId: ${data.id}})">
                    <img src="/user_assets/assets/emp_dashboard/Account-manager.svg" width="18" class="img-q">
                </a>`
    }
    let vendorType = (data) => {
		if(data.vendor_type==1) {
		   data.vendor_type = 'Agency  Recruiter';
		 } else if(data.vendor_type==2) {
		   data.vendor_type = 'Preferred Agency Recruite';
		 } else  if(data.vendor_type==3) {
			 data.vendor_type = 'Cost Plus Agency Recruiter';
		 } else if(data.vendor_type==null || data.vendor_type==""){data.vendor_type = 'Agency  Recruiter';}
			
      return `${data.vendor_type}`
    }
    let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`
    }
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }
   modalAssigntouser (job_id) {
  let $uibModal = this.$uibModal
  let $scope = this.$scope
  let $log = this.$log
  let API = this.API
  let jobId = job_id

  var modalInstance = $uibModal.open({
    animation: this.animationsEnabled,
    templateUrl: 'myModalContentavu.html',
    windowClass : "assign-to-vendor-user",
    controller: this.modalcontrolleravu,
    controllerAs: 'mvm',
    resolve: { jobId: function () {return jobId;}}
  });
    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => { 
      $log.info('Modal dismissed at: ' + new Date()) 
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
} // modalAssigntouser
modalcontrolleravu ($scope, $filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, jobId) {
    'ngInject'
    this.$state=$state
    this.API=API
    $scope.jobId=jobId
    $scope.masterAm = null
    this.alerts=[]
     if ($stateParams.alerts) {this.alerts.push($stateParams.alerts)}
      let Accountmanagers = API.service('accountmanagers', API.all('users'))
    Accountmanagers.getList()
      .then((response) => {
        let systemVendors = []
        $scope.masterAm = response.plain()
    })
      this.assign=() => { 
        let $state = this.$state;
        $state.go($state.current, {}, { alerts: 'test' })
         let Employer = this.API.service('registervendordashboard', this.API.all('users'))
            Employer.post({
                'personId': $scope.jobId,
                'aManager': this.Ams[0]['id']

        }) .then((response) => {
              let alert = { type: 'success', msg: 'Accountmanager has been updated.' }
              $state.go($state.current, { alerts: alert},{reload:true})
              setTimeout(function(){ $(".alert-success").hide() }, 10000);
              
          })
      }
    this.ok = () => {$uibModalInstance.close($scope.selected.item)}
    this.cancel = () => {$uibModalInstance.dismiss('cancel')}
  }//modalcontrollervs

  $onInit () {}
}

export const VendorsListComponent = {
    templateUrl: './views/app/components/vendors-list/vendors-list.component.html',
    controller: VendorsListController,
    controllerAs: 'vm',
    bindings: {}
}
