export function RoutesConfig ($stateProvider, $urlRouterProvider) {
  'ngInject'

  var getView = (viewName) => {
    return `./views/app/pages/${viewName}/${viewName}.page.html`
  }
 var getpublicView = (viewName) => {
    return `./views/app/pages/${viewName}/${viewName}.page.html`
  }
  var getLayout = (layout) => {
    return `./views/app/pages/layout/${layout}.page.html`
  }

  var getpublicLayout = (publiclayout) => {
    return `./views/app/pages/publiclayout/${publiclayout}.page.html`
  }
  $urlRouterProvider.otherwise('/')

  $stateProvider
    .state('app', {
      abstract: true,
      views: {
        'layout': {
          templateUrl: getLayout('layout')
        },
        'header@app': {
          templateUrl: getView('header')
        },
        'footer@app': {
          templateUrl: getView('footer')
        },
        main: {}
      },
      data: {
        bodyClass: 'hold-transition skin-blue sidebar-mini'
      }
    })
    .state('app1', {
      abstract: true,
      views: {
        'layout': {
          templateUrl: getpublicLayout('publiclayout')
        },
        'header@app1': {
          templateUrl: getpublicView('publicheader')
        },
        'footer@app1': {
          templateUrl: getpublicView('publicfooter')
        },
        main: {}
      },
      data: {
        bodyClass: 'hold-transition skin-blue sidebar-mini'
      }
    })
    .state('app.landing', {
      url: '/',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          templateUrl: getView('landing')
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empdashboard', {
      url: '/emp-dashboard',
      data: {
        auth:true
      },
      views: {
        'main@app': {
          template: '<emp-dashboard></emp-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.dashboard', {
      url: '/dashboard',
      data: {
        auth:true
      },
      views: {
        'main@app': {
          template: '<dashboard></dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.emptalentpooldashboard', {
      url: '/emp-talentpool-dashboard',
      data: {
        auth:true
      },
      views: {
        'main@app': {
          template: '<emp-talentpool-dashboard></emp-talentpool-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empteamdashboard', {
      url: '/emp-team-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-team-dashboard></emp-team-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendorgdprdetails', {
      cache: false,
      url: '/Vendor-GDPR-Details/:JoborderId/:typeId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendorgdprdetails></vendorgdprdetails>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.shareafreind', {
      cache: false,
      url: '/shareafreind',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<shareafreind></shareafreind>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.amgdprsdetails', {
      cache: false,
      url: '/Am-GDPR-Details',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<amgdprdetails></amgdprdetails>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.amgdprspendingdetails', {
      cache: false,
      url: '/Am-GDPR-Pending-Details',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<amgdprspendingdetails></amgdprspendingdetails>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    
    .state('app.vendorgdprresultview', {
      cache: false,
      url: '/Vendor-GDPR-Result-View/:gdprId/:flag',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-gdpr-result-view></vendor-gdpr-result-view>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.jobgdprcandidates', {
      cache: false,
      url: '/Job-GDPR-Candiddates/:JoborderId/:typeId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobgdprcandidates></jobgdprcandidates>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.empgdprsdetails', {
      cache: false,
      url: '/Emp-GDPR-Details',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<empgdprdetails></empgdprdetails>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.customersupportuserdashboard', {
      url: '/customersupportuser-dashboard',
      data: {
        auth:true
      },
      views: {
        'main@app': {
          template: '<customersupportuser-dashboard></customersupportuser-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empjoborderview', {
      cache: false,
      url: '/Emp-Job-Order-View/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-joborderview></emp-joborderview>'
        }
      },
      params: {
        alerts: null,
      }
    })
  .state('app.userjoborderview', {
      cache: false,
      url: '/User-Job-Order-View/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<userjoborderview></userjoborderview>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.vendorrevenuerule', {
      cache: false,
      url: '/vendor-revenue-rule',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-revenue-rule></vendor-revenue-rule>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.amjobview', {
      cache: false,
      url: '/am-job-view/:joborderId/:vendorId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-job-view></am-job-view>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.amjobviewsub', {
      cache: false,
      url: '/am-job-viewsub/:joborderId/:vendorId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<amjobviewsub></amjobviewsub>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.amtalentpooljobview', {
      cache: false,
      url: '/am-talentpool-job-view/:joborderId/:talentpoolrequestId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-talentpool-job-view></am-talentpool-job-view>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.adminjobview', {
      cache: false,
      url: '/admin-job-view/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-job-view></admin-job-view>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.amalltalentpooldevrequests', {
      cache: false,
      url: '/All-Deviations-Requests',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-all-talentpool-dev-requests></am-all-talentpool-dev-requests>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.ammodetalentpooldevrequests', {
      cache: false,
      url: '/AM-Talentpool-Requests/:flag_id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-mode-talentpool-dev-requests></am-mode-talentpool-dev-requests>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
    .state('app.amdashboard', {
      url: '/am-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-dashboard></am-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.kanban', {
      url: '/kanban/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<kanban></kanban>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.sourceingtool', {
      url: '/sourceingtool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<sourceingtool></sourceingtool>'
        }
      },
      params: {
        alerts: null
      }
    })
       .state('app.searchhistory', {
      url: '/searchhistory',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<searchhistory></searchhistory>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.activity_log', {
      url: '/activity_logs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<activity_log></activity_log>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amtalentpooldashboard', {
      url: '/Am-Talentpool-Dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-talentpool-dashboard></am-talentpool-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.addProcessUser', {
      url: '/process-user',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<process-user></process-user>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.manageProcess', {
      url: '/process-manage-all',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-process></manage-process>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.manageQuestions', {
      url: '/manage-survey',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-survey></manage-survey>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.manageQuestionsedit', {
      url: '/manage-questions-edit/:questionId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-questions-edit></manage-questions-edit>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.executiveActivity', {
      url: '/manage-activity',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-activity></manage-activity>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.selectcaller', {
      url: '/select-caller',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<select-first-call></select-first-call>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.takefirstcall', {
      url: '/take-first-survey',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<take-first-call></take-first-call>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.firstCall', {
      url: '/first-survey/:employerId/:roleName',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<first-call></first-call>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.employerQuestion', {
      url: '/create-survey',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<create-survey></create-survey>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.vendorQuestion', {
      url: '/create-survey',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-survey></vendor-survey>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.processleaddashboard', {
      url: '/processlead-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<processlead-dashboard></processlead-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.processexedashboard', {
      url: '/processexe-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<processexecutive-dashboard></processexecutive-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.processuserdashboard', {
      url: '/processuser-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<processuser-dashboard></processuser-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.manageAllProcessUsers', {
      url: '/manage-process-users',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-process></manage-process>'
        }
      },
      params: {
        alerts: null
      }
    })

 .state('app.industries', {
      url: '/Industries',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<industries></industries>'
        }
      },
      params: {
        alerts: null
      }
    })
 .state('app.industriesadd', {
      url: '/Industries-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<industries-add></industries-add>'
        }
      },
       params: {
        alerts: null,
       
      }
    })
       .state('app.industriesedit', {
      url: '/Industries-edit/:industriesId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<industries-edit></industries-edit>'
        }
      },
      params: {
        alerts: null,
      }
    })
    
    .state('app.sourcing', {
      url: '/sourcing/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<sorcing></sorcing>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.farming', {
      url: '/farming/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<farming></farming>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.paymentgetway', {
      url: '/paymentgetway',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<paymentgetway></paymentgetway>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.profileview', {
      url: '/profileview/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<profileview></profileview>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.hunting', {
      url: '/hunting/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<hunting></hunting>'
        }
      },
      params: {
        alerts: null,
      }
    })

       .state('app.languages', {
      url: '/Languages',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<languages></languages>'
        }
      },
      params: {
        alerts: null
      }
    })

      .state('app.languagesadd', {
      url: '/Languages-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<languages-add></languages-add>'
        }
      },
       params: {
        alerts: null,
       
      }
    })

 .state('app.languagesedit', {
      url: '/Languages-edit/:languagesId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<languages-edit></languages-edit>'
        }
      },
      params: {
        alerts: null,
      }
    })


       .state('app.education_qualifications', {
      url: '/education_qualifications',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<education_qualifications></education_qualifications>'
        }
      },
      params: {
        alerts: null
      }
    })

      .state('app.education_qualificationsadd', {
      url: '/education_qualifications-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<education_qualifications-add></education_qualifications-add>'
        }
      },
       params: {
        alerts: null,
       
      }
    })

 .state('app.education_qualificationsedit', {
      url: '/education_qualifications-edit/:education_qualificationsId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<education_qualifications-edit></education_qualifications-edit>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.vendordashboard', {
      url: '/vendor-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-dashboard></vendor-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendortalentpooldashboard', {
      url: '/vendor-talentpool-dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-dashboard></vendor-talentpool-dashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.leadaccessdashboard', {
      url: '/Lead-Access-Dashboard',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<leadaccessdashboard></leadaccessdashboard>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amemployers', {
      url: '/am-employers',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-employers></am-employers>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amvendors', {
      url: '/am-vendors',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-vendors></am-vendors>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app1.publicprofile', {
      url: '/Public-Profile/:profilename',
      /*data: {
        auth: true
      },*/
      views: {
         'publiclayout': {
          templateUrl: getpublicLayout('publiclayout')
        },
        'publicheader@app1': {
          templateUrl: getView('publicheader')
        },
        'publicfooter@app1': {
          templateUrl: getView('publicfooter')
        },
        'main11@app1': {
          templateUrl: getView('publicprofile')
        }
      }
    })
    .state('app.tablessimple', {
      url: '/tables-simple',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<tables-simple></tables-simple>'
        }
      }
    })
    .state('app.uiicons', {
      url: '/ui-icons',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<ui-icons></ui-icons>'
        }
      }
    })
    .state('app.uimodal', {
      url: '/ui-modal',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<ui-modal></ui-modal>'
        }
      }
    })
    .state('app.uitimeline', {
      url: '/ui-timeline',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<ui-timeline></ui-timeline>'
        }
      }
    })
    .state('app.uibuttons', {
      url: '/ui-buttons',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<ui-buttons></ui-buttons>'
        }
      }
    })
    .state('app.uigeneral', {
      url: '/ui-general',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<ui-general></ui-general>'
        }
      }
    })
    .state('app.formsgeneral', {
      url: '/forms-general',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<forms-general></forms-general>'
        }
      }
    })
    .state('app.chartjs', {
      url: '/charts-chartjs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<charts-chartjs></charts-chartjs>'
        }
      }
    })
    .state('app.comingsoon', {
      url: '/comingsoon',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<coming-soon></coming-soon>'
        }
      }
    })
    .state('app.profile', {
      url: '/profile',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-profile></user-profile>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.profile_details', {
      url: '/profile_details',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<profile_details></profile_details>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.profile_password', {
      url: '/profile_password',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<profile_password></profile_password>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.kpi_agency_recruiter', {
      url: '/kpi_agency_recruiter/:vendorUserId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<kpi_agency_recruiter></kpi_agency_recruiter>'
        }
      },
      params: {
        alerts: null
      }
    })
  .state('app.kpi', {
        url: '/kpi/:JoborderId',
        data: {
          auth: true
        },
        views: {
          'main@app': {
            template: '<kpi></kpi>'
          }
        },
        params: {
          alerts: null
        }
      })
     .state('app.hirextraLeadEmployer', {
      url: '/Leads-Employer',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<hirextra-leads-employer></hirextra-leads-employer>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.hirextraLeadVendor', {
      url: '/Leads-Vendor',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<hirextra-leads-vendor></hirextra-leads-vendor>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.processExe', {
      url: '/Process-Executive',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<process-executive></process-executive>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.processLead', {
      url: '/Process-Lead',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<process-lead></process-lead>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.manageProcessLead', {
      url: '/Manage-Process-Lead',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-process-lead></manage-process-lead>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.userlists', {
      url: '/user-lists',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-lists></user-lists>'
        }
      }
    })
    .state('app.changepassword', {
      url: '/Password-Change',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-password-change></manage-password-change>'
        }
      },
      params: {
        alerts: null
      }
    })
    
      .state('app.jobtype', {
      url: '/Job-Types',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobtype></jobtype>'
        }
      }
    })
     .state('app.jobtypecreate', {
      url: '/Job-Type-Create',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobtypecreate></jobtypecreate>'
        }
      },
       params: {
        alerts: null,
      }
    })
      .state('app.jobtypesedit', {
      url: '/Job-Type-edit/:jobtypeId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobtypeedit></jobtypeedit>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
 

 .state('app.countries', {
      url: '/Countries',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<countries></countries>'
        }
      }
    })

     .state('app.countriecreate', {
      url: '/Countries-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<countriecreate></countriecreate>'
        }
      },
       params: {
        alerts: null,
       
      }
    })      
      .state('app.countriesedit', {
      url: '/Countries-edit/:countrieId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<countriesedit></countriesedit>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
       .state('app.selectedcandidateactivity', {
      url: '/Selected-Candidate-Activity/:candidateId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<selected-candidate-activity></selected-candidate-activity>'
        }
      },
      params: {
        alerts: null,
      }
    })
  .state('app.cities', {
      url: '/Cities',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<cities></cities>'
        }
      }
    })
  .state('app.citiecreate', {
      url: '/City-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<citiecreate></citiecreate>'
        }
      },
       params: {
        alerts: null,
       
      }
    })
      .state('app.citiedit', {
      url: '/City-edit/:cityId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<citiedit></citiedit>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })

     .state('app.examplelist', {
      url: '/example-list',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<example-list></example-lists>'
        }
      }
    })
    .state('app.useredit', {
      url: '/user-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-edit></user-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendoruseredit', {
      url: '/vendor-user-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-user-edit></vendor-user-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.resumeupload', {
      url: '/resumeupload',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<resume-upload></resume-upload>'
        }
      },
       params: {
        alerts: null,
      }
    })
    .state('app.jobordermanage', {
      url: '/employer-jobs/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobordermanager></jobordermanager>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.resumematch', {
      url: '/resumematch/:candidateId/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<resumematch></resumematch>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.chatgpt', {
      url: '/HireGpt/:candidateId/:text',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-am-summary></admin-am-summary>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.skill_map', {
      url: '/skill_map/:candidateId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<skill_map></skill_map>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employeralljobs', {
      url: '/employer-all-jobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-alljobs></employer-alljobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
     .state('app.empgdprcandidates', {
      url: '/Emp-Gdpr-Candidates/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<empgdprcandidates></empgdprcandidates>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.employerinprogress', {
      url: '/employer-inprogressjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-inprogressjobs></employer-inprogressjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employerinactive', {
      url: '/employer-inactivejobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-inactivejobs></employer-inactivejobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employeraccepted', {
      url: '/employer-acceptedjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-acceptedjobs></employer-acceptedjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employerpending', {
      url: '/employer-pendingjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-pendingjobs></employer-pendingjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employerclosed', {
      url: '/employer-closedjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-closedjobs></employer-closedjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.employerhold', {
      url: '/employer-holdjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-holdjobs></employer-holdjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.employerrejected', {
      url: '/employer-rejectedjobs/:tabValue/:is_talentpool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-rejectedjobs></employer-rejectedjobs>'
        }
      },
      params: {
        alerts: null,
      }
    })
     .state('app.jobordercreate', {
      url: '/jobordercreate',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<jobordercreate></jobordercreate>'
        }
      },
      params: {
        alerts: null,
        alerts1:null,
      }
    })
    .state('app.coresignal', {
      url: '/farming/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-emp-summary></admin-emp-summary>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.talentpoolresults', {
      cache: false,
      url: '/Talentpool-Results/:id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpool-results></talentpool-results>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })

    .state('app.joborderedit', {
      url: '/Job-Order-edit/:joborderId/:statusId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<joborderedit></joborderedit>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.joborderview', {
      cache: false,
      url: '/Job-Order-View/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<joborderview></joborderview>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.talentpooljoborderview', {
      cache: false,
      url: '/TalentPool-Job-Order-View/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpooljoborderview></talentpooljoborderview>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.candidateprofileview', {
      url: '/Candidate-Profile-View/:candidateId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-candidates-view></manage-candidates-view>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.candidateprofile', {
      url: '/Candidate-Profile-View/:candidateId/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidateprofile-detail-view></candidateprofile-detail-view>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
     .state('app.empcandidatedetails', {
      url: '/Emp-Candidate-Details/:employerId/:statusname',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-candidate-details></emp-candidate-details>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
      .state('app.vendorcandidatedetails', {
      url: '/Vendor-Candidate-Details/:vendorId/:statusname',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-candidate-details></vendor-candidate-details>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
       .state('app.vendorempcandidatedetails', {
      url: '/Vendor-Emp-Candidate-Details/:employerId/:statusname',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-emp-candidate-details></vendor-emp-candidate-details>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.empcandidateprofile', {
      url: '/Candidate-Profile-View/:candidateId/:JoborderId/:candidateStatus/:Personality_traits',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidateprofileview></candidateprofileview>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.profiledetails', {
      url: '/Vendor-Profile-Details/:profilestatus/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<profiles></profiles>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.employerprofiledetails', {
      url: '/Employer-Profile-Details/:employerprofilestatus/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-profiles></employer-profiles>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.amprofiledetails', {
      url: '/AM-Profile-Details/:amprofilestatus/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profilesdetails></am-profilesdetails>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.status', {
      url: '/Status-list',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<status></status>'
        }
      }
    })
    .state('app.peopledata', {
      url: '/peopledata',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<core-signal></core-signal>'
        }
      }
    })
        .state('app.statuscreate', {
      url: '/Status-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<statuscreate></statuscreate>'
        }
      },
       params: {
        alerts: null,
        permissionId: null
      }
    })
         .state('app.statusedit', {
      url: '/Status-Edit/:statusId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<statusedit></statusedit>'
        }
      },
       params: {
        alerts: null,
        permissionId: null
      }
    })
        
         .state('app.grade', {
      url: '/Grade-list',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<grade></grade>'
        }
      }
    })
        .state('app.gradeadd', {
      url: '/Grade-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<grade-add></grade-add>'
        }
      },
       params: {
        alerts: null,
        permissionId: null
      }
    })
         .state('app.gradeedit', {
      url: '/Grade-Edit/:gradeId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<grade-edit></grade-edit>'
        }
      },
       params: {
        alerts: null,
        permissionId: null
      }
    })
   
    .state('app.userroles', {
      url: '/user-roles',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-roles></user-roles>'
        }
      }
    })
    .state('app.userpermissions', {
      url: '/user-permissions',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-permissions></user-permissions>'
        }
      }
    })
    .state('app.userpermissionsadd', {
      url: '/user-permissions-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-permissions-add></user-permissions-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.userpermissionsedit', {
      url: '/user-permissions-edit/:permissionId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-permissions-edit></user-permissions-edit>'
        }
      },
      params: {
        alerts: null,
        permissionId: null
      }
    })
    .state('app.userrolesadd', {
      url: '/user-roles-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-roles-add></user-roles-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.userrolesedit', {
      url: '/user-roles-edit/:roleId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user-roles-edit></user-roles-edit>'
        }
      },
      params: {
        alerts: null,
        roleId: null
      }
    })
    .state('app.widgets', {
      url: '/widgets',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<widgets></widgets>'
        }
      }
    })
    .state('login', {
      url: '/login',
      views: {
        'layout': {
          templateUrl: getView('login')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      },
      params: {
        registerSuccess: null,
        successMsg: null
      }
    })
    .state('loginloader', {
      url: '/login-loader',
      views: {
        'layout': {
          templateUrl: getView('login-loader')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
    .state('register', {
      url: '/register',
      views: {
        'layout': {
          templateUrl: getView('register')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition register-page'
      }
    })
    .state('registeruser', {
      url: '/registeruser/:invitation_Code',
      views: {
        'layout': {
          templateUrl: getView('registeruser')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition register-page'
      }
    })
    .state('userverification', {
      url: '/userverification/:status',
      views: {
        'layout': {
          templateUrl: getView('user-verification')
        }
      },
      data: {
        bodyClass: 'hold-transition login-page'
      },
      params: {
        status: null
      }
    })
    .state('forgot_password', {
      url: '/forgot-password',
      views: {
        'layout': {
          templateUrl: getView('forgot-password')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
    .state('reset_password', {
      url: '/reset-password/:email/:token',
      views: {
        'layout': {
          templateUrl: getView('reset-password')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
    .state('activate_email', {
      url: '/activate-email/:email/:token',
      views: {
        'layout': {
          templateUrl: getView('activate-email')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
     .state('gdprhome', {
      url: '/gdpr_home',
      views: {
        'layout': {
          templateUrl: getView('gdpr-home')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
     .state('gdprform', {
      url: '/gdpr-form/:encrypt_code',
      views: {
        'layout': {
          templateUrl: getView('gdpr-form')
        },
        'header@app': {},
        'footer@app': {}
      },
      params: {
        alerts: null
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
     .state('predefined_questions', {
      url: '/predefined-questions/:jobid/:canid',
      views: {
        'layout': {
          template: '<predefined_questions></predefined_questions>'
        },
        'header@app': {},
        'footer@app': {}
      },
      params: {
        alerts: null
      }
    })
    .state('login-reset-password', {
      url: '/login-reset-password/:email/:token',
      views: {
        'layout': {
          templateUrl: getView('login-reset-password')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })
    .state('app.logout', {
      url: '/logout',
      views: {
        'main@app': {
          controller: function ($rootScope, $scope, $auth, $state, AclService,Idle) {
            $auth.logout().then(function () {
              Idle.unwatch();
              delete $rootScope.me
              AclService.flushRoles()
              AclService.setAbilities({})
              $state.go('login')
            })
          }
        }
      }
    })
    .state('app.employerslist', {
      url: '/employers',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employers-list></employers-list>'
        }
      },
       params: {
        alerts: null
      }
    })
    .state('app.empvendorsassigned', {
      url: '/Vendors-Assigned',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-vendors-assigned></emp-vendors-assigned>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empjobsclosed', {
      url: '/Jobs-Closed',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-jobs-closed></emp-jobs-closed>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empselectedprofiles', {
      url: '/Selected-Profiles',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-selected-profiles></emp-selected-profiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empprofilesreceived', {
      url: '/Profiles-Received',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-profiles-received></emp-profiles-received>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.predefined_list', {
      url: '/predefined_list',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<predefined_list></predefined_list>'
        }
      },
       params: {
        alerts: null
      }
    })
    .state('app.predefined_question_show', {
      url: '/predefined_question_show/:jobId/:candidateId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<predefined_question_show></predefined_question_show>'
        }
      },
       params: {
        alerts: null
      }
    })
    .state('app.empprofilesrejected', {
      url: '/Profiles-Rejected',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-profiles-rejected></emp-profiles-rejected>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.employersadd', {
      url: '/employers-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employers-add></employers-add>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.customersupportuserslist', {
      url: '/customersupportusers',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<customersupportusers></customersupportusers>'
        }
      }
    })
     .state('app.customersupportusersadd', {
      url: '/customersupportusers-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<customersupportusers-add></customersupportusers-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorfileupload', {
      url: '/vendor-file-upload',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-file-upload></vendor-file-upload>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.privatearea', {
      url: '/private-area/:Skills/:Prefferedskills',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-private-area></vendor-private-area>'
        }
      },
      params: {
        alerts: null
      }
    })
      .state('app.talentpoollist', {
      url: '/Talent-Pool',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-list></vendor-talentpool-list>'
        }
      },
      params: {
        alerts: null
      }
    })
      .state('app.employertalentpoollist', {
      url: '/Employer-Talentpool/:id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-talentpool-view></employer-talentpool-view>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.emptalentpoolview', {
      url: '/Emp-Talentpool-View/:id/:jobid',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-talentpool-view></emp-talentpool-view>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendortalentpoolviewlist', {
      url: '/Vendor-Talentpool-View-List',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-view-list></vendor-talentpool-view-list>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.amtalentpoolview', {
      url: '/Talentpool-View/:id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-talentpool-view></am-talentpool-view>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.talentpoolview', {
      url: '/Talentpool-View/:id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-view></vendor-talentpool-view>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.talentpoolacceptview', {
      url: '/Talentpool-Requests-Accepted',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpool-request-accepted></talentpool-request-accepted>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
     
    .state('app.talentpoolrejectview', {
      url: '/Talentpool-Requests-Rejected',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpool-request-rejected></talentpool-request-rejected>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })

    .state('app.talentpoolpendingview', {
      url: '/Talentpool-Requests-Pending',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpool-request-pending></talentpool-request-pending>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
        .state('app.vendoraccepttalentpool', {
      url: '/Talentpool-Request-Accepted',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-profile-accepted></vendor-profile-accepted>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendorprofilerejected', {
      url: '/Talentpool-Request-Rejected',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-profile-rejected></vendor-profile-rejected>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendorpendingtalentpool', {
      url: '/Talentpool-Request-Pending',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-profile-pending></vendor-profile-pending>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })    

       .state('app.talentpoolcreate', {
      url: '/Talent-Pool-Add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-create></vendor-talentpool-create>'
        }
      },
      params: {
        alerts: null
      }
    })
      .state('app.talentpooledit', {
      url: '/Talentpool-Edit/:id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-update></vendor-talentpool-update>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendorslist', {
      url: '/vendors',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendors-list></vendors-list>'
        }
      }
    })
    .state('app.vendorsadd', {
      url: '/vendors-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendors-add></vendors-add>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendorsJobsClosed', {
      url: '/vendor-jobs-closed',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-jobs-closed></vendor-jobs-closed>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendorteamjobclosed', {
      url: '/Vendor-Team-Closed-Jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendorteamjobclosed></vendorteamjobclosed>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendorSelectedProfiles', {
      url: '/vendor-selected-profiles',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-selected-profiles></vendor-selected-profiles>'
        }
      },
      params: {
        alerts: null
      }
    })
      .state('app.vendorUserSelectedProfiles', {
      url: '/vendor-user-selected-profiles',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendoruserselectedprofiles></vendoruserselectedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.accountmanagerlist', {
      url: '/account-managers',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<account-manager-list></account-manager-list>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.accountmanagersadd', {
      url: '/account-managers-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<account-managers-add></account-managers-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.accountmanagersedit', {
      url: '/account-managers-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<account-managers-edit></account-managers-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.amactivity', {
      url: '/account-managers-activity/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<account-managers-activity></account-managers-activity>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.employersedit', {
      url: '/employers-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employers-edit></employers-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.editam', {
      url: '/Edit-Account-Manager/:employerId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<editam></editam>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.vendorsedit', {
      url: '/vendors-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendors-edit></vendors-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
     .state('app.vendorsamedit', {
      url: '/vendors-am-edit/:vendorId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendors-am-edit></vendors-am-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.customersupportedit', {
      url: '/customersupport-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<customersupport-edit></customersupport-edit>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
    .state('app.employeruserslist', {
      url: '/employer-team',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-users-list></employer-users-list>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.amprofiles', {
      url: '/Account-Manager-Profiles',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profiles></am-profiles>'
        }
      },
      params: {
        alerts: null
      }
    })
        .state('app.amassignvendors', {
      url: '/Yet-to-Assign-Vendors',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-assign-vendors></am-assign-vendors>'
        }
      },
      params: {
        alerts: null
      }
    })
         .state('app.ampositionsclosed', {
      url: '/Overall-Positions-Closed',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-positions-closed></am-positions-closed>'
        }
      },
      params: {
        alerts: null
      }
    })
     
      .state('app.amvendorworking', {
      url: '/Vendors-Working-Jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-vendor-working></am-vendor-working>'
        }
      },
      params: {
        alerts: null
      }
    })
     
    .state('app.employerusersadd', {
      url: '/employer-team-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-users-add></employer-users-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendoruserslist', {
      url: '/vendor-team',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-users-list></vendor-users-list>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorusersadd', {
      url: '/vendor-team-add',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-users-add></vendor-users-add>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorusersedit', {
      url: '/Vendor-Team-Edit/:vendorUserId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-users-edit></vendor-users-edit>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorusersettings', {
      url: '/Vendor-Team-Settings/:vendorUserId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-users-settings></vendor-users-settings>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.employerusersedit', {
      url: '/employer-team-edit/:vendorUserId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-users-edit></employer-users-edit>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.puseredit', {
      url: '/process-user-edit/:userId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<process-user-edit></process-user-edit>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.candidatelist', {
      url: '/manage-candidates',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-list></candidates-list>'
        }
      },
      params: {
        alerts: null,
      }
    })
     .state('app.user_activity', {
      url: '/users-activity',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<user_activity></user_activity>'
        }
      },
      params: {
        alerts: null,
      }
    })
     .state('app.covertemplate', {
      url: '/covertemplate/:candidateId/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<covertemplate></covertemplate>'
        }
      }
    })
    .state('app.cvssubmitted', {
      url: '/Cvs-submitted',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<cvs-submitted></cvs-submitted>'
        }
      },
      params: {
        alerts: null,
      }
    })
     .state('app.usercandidatelist', {
      url: '/manage-user-candidates',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<usercandidatelist></usercandidatelist>'
        }
      },
      params: {
        alerts: null,
      } 
    })
    .state('app.assignedjobs', {
      url: '/all-jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<assigned-jobs></assigned-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.talentpooljobs', {
      url: '/talentpool-jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<talentpool-jobs></talentpool-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amalljobs', {
      url: '/all-jobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-alljobs></am-alljobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.ampendingjobs', {
      url: '/am-pendingjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-pendingjobs></am-pendingjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.yettoacceptbyvendor', {
      url: '/am-yettoacceptbyvendor/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-yettoacceptbyvendor></am-yettoacceptbyvendor>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.aminprogressjobs', {
      url: '/am-inprogressjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-inprogress></am-inprogress>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amclosedjobs', {
      url: '/am-closedjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-closedjobs></am-closedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.jobsrejectedbyam', {
      url: '/am-jobsrejectedbyam/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-jobsrejectedbyam></am-jobsrejectedbyam>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.jobsrejectedbyvendor', {
      url: '/am-jobsrejectedbyvendor/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-jobsrejectedbyvendor></am-jobsrejectedbyvendor>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.adminassignedjobs', {
      url: '/admin-all-jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-assigned-jobs></admin-assigned-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.adminpendingjobs', {
      url: '/admin-pendingjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-pendingjobs></admin-pendingjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.adminyettoacceptbyvendor', {
      url: '/admin-yettoacceptbyvendor',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-yettoacceptbyvendor></admin-yettoacceptbyvendor>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.admininprogressjobs', {
      url: '/admin-inprogressjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-inprogressjobs></admin-inprogressjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.adminholdjobs', {
      url: '/admin-holdjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-holdjobs></admin-holdjobs>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.adminclosedjobs', {
      url: '/admin-closedjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-closedjobs></admin-closedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vassignedjobs', {
      url: '/assigned-jobs-vendor/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-assigned-jobs></vendor-assigned-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendoracceptedjobsall', {
      url: '/accepted-jobs-vendor/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-acceptedjobs></vendor-acceptedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorsubmittedjobs', {
      url: '/vendorsubmittedjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-submittedjobs></vendor-submittedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorpendingjobs', {
      url: '/vendorpendingjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-pendingjobs></vendor-pendingjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorclosedjobs', {
      url: '/vendorclosedjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-closedjobs></vendor-closedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorholdjobs', {
      url: '/vendor-holdjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-holdjobs></vendor-holdjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amholdjobs', {
      url: '/am-holdjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-holdjobs></am-holdjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorrejectedjobs', {
      url: '/vendorrejectedjobs/:tabValue',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-rejectedjobs></vendor-rejectedjobs>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vuserassignedjobs', {
      url: '/assigned-jobs-vendor-user',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-user-assigned-jobs></vendor-user-assigned-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vassignedjobsclosed', {
      url: '/assigned-jobs-vendor/:status',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-assigned-jobs></vendor-assigned-jobs>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.empsummary', {
      url: '/Employee-Summary',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-summary></emp-summary>'
        }
      },
      params: {
        alerts: null
      }
    })
      
      .state('app.vendorsummary', {
      url: '/vendor-Summary/:vendor_id',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-summary></vendor-summary>'
        }
      },
      params: {
        alerts: null
      }
    })

  
      
     .state('app.userempsummary', {
      url: '/Vendor-User-Employee-Summary',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<userempsummary></userempsummary>'
        }
      },
      params: {
        alerts: null
      }
    })
     
      .state('app.empdescview', {
      url: '/Employee-Description/:employerId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-description></emp-description>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
      .state('app.vendorteamview', {
      url: '/vendorteam-summary/:vendoruserId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-team-summary></vendor-team-summary>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
   .state('app.userempdesc', {
      url: '/Team-Employee-Description',
      data: {
        auth: true
      },
      views: {
        'main@app': {

          template: '<userempdesc></userempdesc>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })

  .state('app.faqs', {
      url: '/faqs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<faq></faq>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendoruseractions', {
      url: '/team-actions/:joborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-user-actions></vendor-user-actions>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
.state('app.employers-faq', {
      url: '/employers-faq',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employers-faq></employers-faq>'
        }
      },
      params: {
        alerts: null
      }
    })
.state('app.am-faq', {
      url: '/am-faq',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-faq></am-faq>'
        }
      },
      params: {
        alerts: null
      }
    })
.state('app.vendor-faq', {
      url: '/vendor-faq',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-faq></vendor-faq>'
        }
      },
      params: {
        alerts: null

  }
  })

  .state('app.pricingview', {
      url: '/pricing-view',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<pricing-view></pricing-view>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.editpricing', {
      url: '/edit-pricing/:employerId/:default_country',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<edit-pricing></edit-pricing>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.freecvs', {
      cache: false,
      url: '/free-cvs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<free-cvs></free-cvs>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.viewall', {
      url: '/view-all',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<view-all></view-all>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amviewall', {
      url: '/am-view-all',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-view-all></am-view-all>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorviewall', {
      url: '/vendor-view-all',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-view-all></vendor-view-all>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendoractivityreadmore', {
      url: '/vendor-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-activity-readmore></vendor-activity-readmore>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendortopactivityreadmore', {
      url: '/vendor-top-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-top-activity-readmore></vendor-top-activity-readmore>'
        }
      },
      params: {
        alerts: null
      }
    })

     .state('app.employerviewall', {
      url: '/employer-view-all',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employee-view-all></employee-view-all>'
        }
      },
      params: {
        alerts: null
      }
    })
       .state('app.employeractivityreadmore', {
      url: '/Employer-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employer-activity-readmore></employer-activity-readmore>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.employertopactivityreadmore', {
      url: '/Employer-top-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<employertopactivityreadmore></employertopactivityreadmore>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.accountmanageractivityreadmore', {
      url: '/Account_Manager-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<accountmanageractivityreadmore></accountmanageractivityreadmore>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.accountmanagertopactivityreadmore', {
      url: '/Account_Manager-top-comments',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<accountmanagertopactivityreadmore></accountmanagertopactivityreadmore>'
        }
      },
      params: {
        alerts: null
      }
    })

    
    .state('app.vendorprofilesReceived', {
      url: '/vendor-profilesReceived/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-profilesreceived></vendor-profilesreceived>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorshortlistedProfiles', {
      url: '/vendor-shortlistedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-shortlistedprofiles></vendor-shortlistedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorrejectedProfiles', {
      url: '/vendor-rejectedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-rejectedprofiles></vendor-rejectedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorprofilesClosed', {
      url: '/vendor-profilesClosed/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-closedprofiles></vendor-closedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.vendorpendingProfiles', {
      url: '/vendor-profilesPending/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-pendingprofiles></vendor-pendingprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empprofilesReceived', {
      url: '/employer-profilesReceived/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-profilesreceived></emp-profilesreceived>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empshortlistedProfiles', {
      url: '/employer-shortlistedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-shortlistedprofiles></emp-shortlistedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.emprejectedProfiles', {
      url: '/employer-rejectedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-rejectedprofiles></emp-rejectedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.empclosedProfiles', {
      url: '/employer-closedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-closedprofiles></emp-closedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.emppendingProfiles', {
      url: '/employer-pendingProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<emp-pendingprofiles></emp-pendingprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amprofilesReceived', {
      url: '/am-profilesReceived/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profilesreceived></am-profilesreceived>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amshortlistedProfiles', {
      url: '/am-shortlistedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-shortlistedprofiles></am-shortlistedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amrejectedProfiles', {
      url: '/am-rejectedProfiles/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-rejectedprofiles></am-rejectedprofiles>'
        }
      },
      params: {
        alerts: null
      }
    })
     .state('app.vendorteamjobdetails', {
      cache: false,
      url: '/Vendor-Team-Job-Details/:vendorId/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendorteam-joborderview></vendorteam-joborderview>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.vendorviewallpages', {
      url: '/vendor-view-all-pages',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-view-all-pages></vendor-view-all-pages>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.ampendingProfiles', {
      url: '/am-profilesPending/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profilespending></am-profilespending>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amclosedProfiles', {
      url: '/am-profilesClosed/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profilesclosed></am-profilesclosed>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.amsentProfiles', {
      url: '/am-profilesSent/:JoborderId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<am-profilessent></am-profilessent>'
        }
      },
      params: {
        alerts: null
      }
    })
    .state('app.companyinformation', {
      url: '/Manage-Company-information',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<manage-company-information></manage-company-information>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.shortlistedforphone', {
      cache: false,
      url: '/shortlisted-for-phone',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-phone></candidates-phone>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.shortlistedforf2f', {
      cache: false,
      url: '/shortlisted-for-f2f',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-facetoface></candidates-facetoface>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.shortlistedforfinal', {
      cache: false,
      url: '/shortlisted-for-final',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-finalinterview></candidates-finalinterview>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.shortlistedforwalkin', {
      cache: false,
      url: '/shortlisted-for-walkin',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-walkin></candidates-walkin>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.shortlistedforskype', {
      cache: false,
      url: '/shortlisted-for-skype',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-skypeinterview></candidates-skypeinterview>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.shortlistedfordirect', {
      cache: false,
      url: '/shortlisted-for-direct-interview',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-directinterview></candidates-directinterview>'
        }
      },
      params: {
        alerts: null,
      }
    })

      .state('app.candidatesheld', {
      cache: false,
      url: '/candidates-held',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-hold></candidates-hold>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.candidatesselected', {
      cache: false,
      url: '/candidates-selected',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-selected></candidates-selected>'
        }
      },
      params: {
        alerts: null,
      }
    })

    .state('app.candidatesrequestdirectjoin', {
      cache: false,
      url: '/candidates-requestdirectjoin',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-requestdirectjoin></candidates-requestdirectjoin>'
        }
      },
      params: {
        alerts: null,
      }
    })    
    
    .state('app.candidatesrejectedaftershortlisted', {
      cache: false,
      url: '/candidates-rejectedaftershortlisted',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<candidates-rejectedaftershortlisted></candidates-rejectedaftershortlisted>'
        }
      },
      params: {
        alerts: null,
      }
    })   
    .state('app.adminjobclosed', {
      cache: false,
      url: '/admin-closedjobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<admin-jobs-closed></admin-jobs-closed>'
        }
      },
      params: {
        alerts: null,
      }
    })        

     .state('app1.cookies', {
      url: '/Cookies',
      /*data: {
        auth: true
      },*/
      views: {
         'publiclayout': {
          templateUrl: getpublicLayout('publiclayout')
        },
        'publicheader@app1': {
          templateUrl: getView('publicheader')
        },
        'publicfooter@app1': {
          templateUrl: getView('publicfooter')
        },
        'main11@app1': {
          templateUrl: getView('cookies')
        }
      }
    })

    .state('newprofileaccess', {
      url: '/new-profile-access/:token',
      /*data: {
        auth: true
      },*/
      views: {
        'layout': {
          templateUrl: getView('newprofileaccess')
        },
        'header@app': {},
        'footer@app': {}
      },
      data: {
        bodyClass: 'hold-transition login-page'
      }
    })

    .state('app.vendoralljobsrevenue', {
      url: '/revenue-all-jobs',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-all-job-revenues></vendor-all-job-revenues>'
        }
      },
      params: {
        alerts: null
      }
    })

    .state('app.completedCallsData', {
      url: '/Firstcall-Survey-Report/:employerId',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<survey-report-data></survey-report-data>'
        }
      },
      params: {
        alerts: null,
        userId: null
      }
    })
     .state('app.vendortalentpooldeviations', {
      cache: false,
      url: '/Vendor-talentpool-deviations',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-deviations></vendor-talentpool-deviations>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.vendortalentpooldeviationsaccepted', {
      cache: false,
      url: '/Vendor-talentpool-deviations-accepted',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-deviations-accepted></vendor-talentpool-deviations-accepted>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.vendortalentpooldeviationsrejected', {
      cache: false,
      url: '/Vendor-talentpool-deviations-rejected',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-deviations-rejected></vendor-talentpool-deviations-rejected>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
     .state('app.vendortalentpooldeviationspending', {
      cache: false,
      url: '/Vendor-talentpool-deviations-pending',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<vendor-talentpool-deviations-pending></vendor-talentpool-deviations-pending>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })

      .state('app.subscribeemaildata', {
      cache: false,
      url: '/subscribeemaildata',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<subscribeemaildata></subscribeemaildata>'
        }
      },
      params: {
        alerts: null,
        alerts1: null,
        permissionId: null
      }
    })
      .state('app.rejectlistadmin', {
      cache: false,
      url: '/Rejected_Leads',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<rejectlistadmin></rejectlistadmin>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.pendinglistadmin', {
      cache: false,
      url: '/Pending_Leads',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<pendinglistadmin></pendinglistadmin>'
        }
      },
      params: {
        alerts: null,
      }
    })
    .state('app.skills', {
      url: '/skills/:JoborderId/:skillType/:isPrivateareaChecked',
      data: {
        auth: true
      },
      views: {
        'main@app': {
          template: '<skills></skills>'
        }
      },
      params: {
        alerts: null
      }
    })


    //Route::get('/joborders', "JobOrderController@index");

}
