import {CamelcaseFilter} from './filters/camelcase.filter';
import { DateMillisFilter } from './filters/date_millis.filter'
import { CapitalizeFilter } from './filters/capitalize.filter'
import { TextFormate } from './filters/textformate.filter'
import {ReverseFilter } from './filters/reverse.filter'
import { HumanReadableFilter } from './filters/human_readable.filter'
import { TruncatCharactersFilter } from './filters/truncate_characters.filter'
import { TruncateWordsFilter } from './filters/truncate_words.filter'
import { TrustHtmlFilter } from './filters/trust_html.filter'
import { UcFirstFilter } from './filters/ucfirst.filter'
import { ParseIntFilter } from './filters/parseint.filter'
import { Filter} from './filters/utctolocal.filter'

angular.module('app.filters')
	.filter('camelcase', CamelcaseFilter)
  .filter('datemillis', DateMillisFilter)
  .filter('capitalize', CapitalizeFilter)
  .filter('textformate',TextFormate)
  .filter('reverse', ReverseFilter)
  .filter('humanreadable', HumanReadableFilter)
  .filter('truncateCharacters', TruncatCharactersFilter)
  .filter('truncateWords', TruncateWordsFilter)
  .filter('trustHtml', TrustHtmlFilter)
  .filter('ucfirst', UcFirstFilter)
  .filter('parseint', ParseIntFilter)
  .filter('utcToLocal', Filter)
