<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model 
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'position_id', 'person_id', 'resume_id', 'requirement_id', 'company_id', 'name','accountmanager_id','employer_id','employer_user_id','vendor_id','job_id','activity_by','admin_id','candidate_id','candidate_status','commentprivate', 'note', 'vendor_user_id'
        //'person_id', 'name'
    ];

    public function admin(){
        return $this->belongsTo('App\User','admin_id');
    }
    public function activityuser(){
        return $this->belongsTo('App\User','activity_by');
    }
    public function accountmanager(){
        return $this->belongsTo('App\User','accountmanager_id');
    }

    public function employer(){
        return $this->belongsTo('App\User','employer_id');
    }

    public function vendor(){
        return $this->belongsTo('App\User','vendor_id');
    }

    public function employeruser(){
        return $this->belongsTo('App\User','employer_user_id');
    }

    public function vendoruser(){
        return $this->belongsTo('App\User','vendor_user_id');
    }

    public function job(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function employeesummery(){
        return $this->belongsTo('App\JobOrders','vendor_id')->distinct('employer_id');
    }
    public function job_closed(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
     public function job_assigned(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function job_status(){
        return $this->belongsTo('App\Status','job_status');
    }
    public function JobType()
    {
        return $this->belongsTo('App\JobType');
    }
    public function candidate(){
        return $this->belongsTo('App\Candidate','candidate_id');
    }

    public function status(){
        return $this->belongsTo('App\Status','candidate_status');
    }

    public function sourcingStatus(){
        return $this->belongsTo('App\Status','status_id');
    }

    public function actionby(){
        return $this->belongsTo('App\User','activity_by');

    }
    public function reason(){
        return $this->belongsTo('App\Reason','reason_id');
    }
 
}
