<?php

namespace App;


use Illuminate\Database\Eloquent\Model;

class Association extends Model
{
    public function association(){
        return $this->hasMany('App\Association','job_id');
    }
    public function admin(){
   	    return $this->belongsTo('App\User','admin_id');
	}
    public function activityuser(){
        return $this->belongsTo('App\User','activity_by');
    }
	public function accountmanager(){
   	    return $this->belongsTo('App\User','accountmanager_id');
	}
	public function employer(){
    	return $this->belongsTo('App\User','employer_id');
	}
	public function vendor(){
   	    return $this->belongsTo('App\User','vendor_id');
	}
	public function employeruser(){
    	return $this->belongsTo('App\User','employer_user_id');
	}
	public function vendoruser(){
   	    return $this->belongsTo('App\User','vendor_user_id');
	}
	public function job(){
    	return $this->belongsTo('App\JobOrders','job_id');
	}
   /* public function sharelinkactivitys(){
        return $this->belongsTo('App\ShareLinkActivitys','candidate_id');
    }*/
    public function employeesummery(){
        return $this->belongsTo('App\JobOrders','vendor_id')->distinct('employer_id');
    }
    public function job_closed(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function job_assigned(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
	public function job_status(){
    	return $this->belongsTo('App\Status','job_status');
	}
    public function JobType(){
        return $this->belongsTo('App\JobType');
    }
	public function candidate(){
    	return $this->belongsTo('App\Candidate','candidate_id');
	}
    public function CandidatePoints(){
        return $this->belongsTo('App\CandidatePoints','candidate_id','candidate_id');
    }
    public function CandidateSkills(){
        return $this->belongsTo('App\CandidateSkills','candidate_id','candidate_id');
    }public function CandidateOperationalSkills(){
        return $this->belongsTo('App\CandidateOperationalSkills','candidate_id','candidate_id');
    }
    public function CandidateSkillsets(){
        return $this->belongsTo('App\CandidateSkillsets','candidate_id','candidate_id');
    }
    public function CandidateSoftSkills(){
        return $this->belongsTo('App\CandidateSoftSkills','candidate_id','candidate_id');
    }
    public function sharelinkactivitys(){
        return $this->belongsTo('App\ShareLinkActivitys','candidate_id','candidate_id');
    }
	public function status(){
    	return $this->belongsTo('App\Status','candidate_status');
	}
    public function vendorRevenue(){
        return $this->belongsTo('App\VendorRevenue','vendor_id','vendor_id');
    }
	public function actionby(){
    	return $this->belongsTo('App\User','status_updated_by');
	}
    public function company(){
        return $this->belongsTo('App\Company','company_id');
    }
    public function CandidateNotes(){
        return $this->belongsTo('App\VendorCandidateNotes','candidate_id','candidate_id');
    }
     public function CandidateDetails(){
        return $this->belongsTo('App\CandidateDetails','candidate_id','candidate_id');
    }
    public function SegregatedSkill(){
        return $this->belongsTo('App\SegregatedSkill','candidate_id','candidate_id');
    }
    public function GdprData(){
        return $this->belongsTo('App\GdprData','candidate_id','vendor_id');
    }
     public function Predefinedquestionsanswers(){
        return $this->belongsTo('App\Predefinedquestionsanswers','candidate_id','job_id');
    }

	public function getAccountManagerId($vendor_id) {
		$vendorassociation = Association::where('vendor_id',$vendor_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('updated_at')
                            ->first();
        return $vendorassociation->accountmanager_id;
	}
}