<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Illuminate\Database\Eloquent\Model;

use App\Models\TalentMine;
use App\Employeespectrums;
use App\CandidateExperiences;

class Candidate extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [

        'full_name',
        'email',
        'phone',
        'mobile',
        'country_code',
        'date_of_birth',
        'gender',
        'job_profile',
        'address',
        'city',
        'state',
        'country',
        'zip',
        'current_salary',
        'expected_salary',
        'total_experience_in_year',
        'summary',
        'path',
        'vendor_id',
        'vendor_user_id',
        'asset_id',
        'note',
        'title',
        'first_name',
        'middle_name',
        'last_name',
        'father_name',
        'mother_name',
        'marital_status',
        'nationality',
        'language_known',
        'unique_id',
        'license_no',
        'passport_no',
        'pan_no',
        'visa_status',
        'alternate_email',
        'cover_letter',
        'certification',
        'publication',
        'current_location',
        'preferred_location',
        'availability',
        'objectives',
        'candidate_references',
        'parsing_date',
        'resume_language',
        'resume_file_name',
        'formatted_address',
        'permanent_address',
        'permanent_city',
        'permanent_state',
        'permanent_country',
        'permanent_zip_code',
        'formatted_permanent_address',
        'industry_category',
        'industry_sub_category',
        'qualification',
        'executive_summary',
        'management_summary',
        'skills',
        'soft_skills',
        'operational_skills',
        'hobbies',
        'candidate_achievements',
        'is_privatearea',
        'html_code',
        'created_at',
        'is_active_private',
        'preferred_country',
        'present_country',
        'nationality',
        'work_autherization',
        'currency',
        'loomembeded'

    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
       // 'password', 'remember_token', 'oauth_provider_id', 'oauth_provider',
    ];

    public function getCandidateDetails()
    {
        return $this->belongsTo(CandidateDetails::class,  'id','candidate_id');
    }


    public function getSpectrums() {
        return $this->hasMany(Employeespectrums::class, 'candidate', 'id');
    }



   public function getTalentMine()
    {
        return $this->hasMany(TalentMine::class, 'candidate_id', 'id');
    }

    public function experiences() {
        return $this->hasMany(CandidateExperiences::class, 'candidate_id', 'id');
    }

    public function getExperience()
    {
        return $this->hasMany(CandidateExperiences::class, 'candidate_id', 'id');
    }

    public function first_association() {
        return $this->hasMany('App\Association')->with('status');
    }
    public function skill() {
        return $this->hasOne('App\CandidateSkillsets');
    }
    public function candidate_skill() {
        return $this->hasOne('App\CandidateSkills');
    }
    public function vendorcandidatenotes() {
        return $this->hasOne('App\vendorcandidatenotes');
    }
    public function educations() {
        return $this->hasMany('App\CandidateEducations');
    }
    public function candidate_soft_skill() {
        return $this->hasMany('App\CandidateSoftSkills');
    }
    public function vendor(){
        return $this->belongsTo('App\User','vendor_id');
    }
    public function vendoruser(){
        return $this->belongsTo('App\User','vendor_user_id');
    }
    public function candidate_operational_skill() {
        return $this->hasMany('App\CandidateOperationalSkills');
    }
    public function asset() {
        return $this->belongsTo('App\UserAsset','asset_id');
    }
    public function SkillblockResume() {
        return $this->belongsTo('App\Models\SkillblockResume','candidate_id');
    }
    public function CandidatePoints(){
        return $this->belongsTo('App\CandidatePoints','candidate_id','candidate_id');
    }
    public function status(){
        return $this->belongsTo('App\Status','candidate_status');
    }
    public function CandidateNotes(){
        return $this->belongsTo('App\VendorCandidateNotes','candidate_id','candidate_id');
    }
     public function CandidateDetails(){
        return $this->belongsTo('App\CandidateDetails','candidate_id','candidate_id');
    }


}
