<?php

namespace App;

use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class EmployerUserJobs extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['employer_id','employer_user_id','job_id'];
    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function employeruser(){
        return $this->belongsTo('App\User','employer_user_id');
    }
      public function assingnedJob(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }
}
