<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Model;

class GdprData extends Model implements AuthenticatableContract
{
    use Authenticatable;
    protected $table = 'gdpr_datas';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */ 
    protected $fillable = [
        'job_id','job_name','candidate_id','status','name','ip_address','agreed_period','vendor_name','vendor_id','vendor_email','candidate_no','candidate_email','other_details','signature','created_at','updated_at','encrypt_code'
    ];

    public function job(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function candidate(){
        return $this->belongsTo('App\Candidate','candidate_id');
    }
       public function Predefinedquestionsanswers(){
        return $this->belongsTo('App\Predefinedquestionsanswers','job_id');
    }
    public function company(){
        return $this->belongsTo('App\Company','company_id');
    }
   
    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        //'path', 'remember_token', 'oauth_provider_id', 'oauth_provider',
    ];
}
