<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\PasswordReset;
use App\User;
use Illuminate\Http\Request;
use Mail;

use Illuminate\Foundation\Auth\ResetsPasswords;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function sendResetLinkEmail(Request $request)
    {
        $tokenData = User::whereEmail($request->email)->get();
       /* print_r($tokenData[0]['email_verification_code']);
        exit;*/
        $this->validate($request, [
            'email' => 'required|email|exists:users,email', 
        ]);

        //invalidate old tokens
        PasswordReset::whereEmail($request->email)->delete();

        $email = $request->email;
        $reset = PasswordReset::create([
            'email' => $email,
            'token' => $tokenData[0]['email_verification_code'] != ''?$tokenData[0]['email_verification_code']:str_random(40),
        ]);

        $token = $reset->token;
        $id=$reset['id'];

        Mail::send('emails.reset_link', compact('email', 'token','id'), function ($mail) use ($email) {
            $mail->to($email)
            ->from('no-reply@hirextra.com')
            ->subject('Password create link');
        });

        return response()->success(true);

    }

    public function sendFPResetLinkEmailvalidate(Request $request)
    {
        $email = PasswordReset::whereEmail($request->email)->get();
        $email1 = user::select('email_verified')->whereEmail($request->email)->get();

            $datetime1 = date_create($email[0]['created_at']); 
            $datetime2 = date_create(date('Y-m-d H:i:s')); 
              
            // calculates the difference between DateTime objects 
            $interval['interval'] = date_diff($datetime1, $datetime2);
            $interval['email_verified'] = $email1[0]['email_verified'];
              
        return response()->success($interval);
    }
    public function sendFPResetLinkEmailvalidatecreate(Request $request)
    {
        $email = user::whereEmail($request->email)->get();
        $email1 = user::select('email_verified')->whereEmail($request->email)->get();

            $datetime1 = date_create($email[0]['created_at']); 
            $datetime2 = date_create(date('Y-m-d H:i:s')); 
              
            // calculates the difference between DateTime objects 
            $interval['interval'] = date_diff($datetime1, $datetime2);
            $interval['email_verified'] = $email1[0]['email_verified'];
              
        return response()->success($interval);
    }
    public function sendFPResetLinkEmail(Request $request)
    {
        $tokenData = User::whereEmail($request->email)->get();
       /*print_r($tokenData[0]['email_verification_code']);
        exit;*/
        $user = User::whereEmail($request->email)->first();
       // print_r($user); exit;
        if($user){
            $user->email_verified = 0;
            $user->save();
            $this->validate($request, [
                'email' => 'required|email|exists:users,email', 
            ]);

            //invalidate old tokens
            PasswordReset::whereEmail($request->email)->delete();

            $email = $request->email;
            $reset = PasswordReset::create([
                'email' => $email,
                'token' => $tokenData[0]['email_verification_code'] != ''?$tokenData[0]['email_verification_code']:str_random(40),
            ]);

            $token = $reset->token;
            $id=$reset->id;

            Mail::send('emails.forgot_password_link', compact('email', 'token','id'), function ($mail) use ($email) {
                $mail->to($email)
                ->from('no-reply@hirextra.com')
                ->subject('Password reset link');
            });
            return response()->success(true);
        }

        
        return response()->error(true);
    }

    public function verify(Request $request)
    {

        $this->validate($request, [
            'email' => 'required|email',
            'token' => 'required',
        ]);

        $check = User::whereEmail($request->email)
        ->where('email_verification_code',$request->token)
       //->where('email_verified',0)
        ->first();
        if (!$check) {
            return response()->error('Email does not exist', 422);
        }
        return response()->success(true);
    }
    public function verifyps(Request $request)
    {

        $this->validate($request, [
            'email' => 'required|email',
            'token' => 'required'
        ]);

        $check = PasswordReset::where('Email',$request->email)
        ->where('token',$request->token)
        ->first();

        if (!$check) {
            return response()->error('Email does not exist', 422);
        }
        
        return response()->success(true);
    }
    public function reset(Request $request)
    {
        $this->validate($request, [
            'email'    => 'required|email',
            'email_verification_code'    => "required|exists:users,email_verification_code,email,{$request->email}",
            'password' => 'required|min:8|confirmed',
        ]);

        $user = User::whereEmail($request->email)->firstOrFail();
        $user->password = bcrypt($request->password);
        $user->email_verified = 1;
        $user->save();

        //delete pending resets
        //PasswordReset::whereEmail($request->email)->delete();

        return response()->success(true);
    }

    public function activate(Request $request)
    {
        $this->validate($request, [
            'email'    => 'required|email',
            'email_verification_code'    => "required|exists:users,email_verification_code,email,{$request->email}"
        ]);

        $user = User::whereEmail($request->email)->firstOrFail();
        $user->email_verified = 1;
        $user->save();
        return response()->success(true);
    }
}