<?php

namespace App\Http\Controllers;

use DB;
use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\Activity;
use App\TalentpoolDeviationRequests;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use App\UserAssociation;
use App\BellNotifications;
use App\TalentpoolRequests;
use App\Talentpools;
use App\JobUsers;
use App\JobResumes;
use App\Candidate;
use App\Association;
use App\Guests;
use App\Country;
use App\VendorRevenue;
use App\VendorUserJob;
use App\VendorActivities;
use App\EmployerUserJobs;
use App\Company;
use App\City;
use App\Reason;
use Mail;
use Response;
use File;
use Carbon\Carbon;
use App\DashboardSorting;
use App\UserThemeSetting;
use App\Models\CandidateDetails;
use App\Predefinedquestionsanswers;
use App\GdprData;
use DateTime;
use DateInterval;

class DashboardController extends Controller
{
    public function getNumbers()
    {
        $jobs = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','!=',7);
                            })->count();
        $employers = User::where('role_id',5)->count();

        $vendors = User::where('role_id',6)->count();
        $jobsclosed = JobOrders::where('status',6)->where('is_talentpool',0)->count();
        $profiles = Association::whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->groupBy('candidate_id')
                            ->get();
        $profiles   =   count($profiles);
        $sel = Association::whereNotNull('job_id')->whereIn('candidate_status',array(27,28))
                            ->whereNotNull('candidate_id')->groupby('candidate_id')
                            ->get();
        $selected=count($sel);
        $numbers[] = array('jobs'=>$jobs,'employers'=>$employers, 'vendors'=>$vendors, 'jobsclosed'=>$jobsclosed,'profiles' => $profiles, 'selected' => $selected);
        return response()->success(compact('numbers'));
    }

    public function getEmpnumbers()
    {
            $authuser = Auth::user();
            $authId = null;
            $empjobids = array();
            if($authuser->parent_id){
                $authId = $authuser->parent_id;
                $empjobs = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)

                            ->lists('job_id');
                $jobsclosed=JobOrders::whereIn('id',$empjobs)->where('status',6)->where('is_talentpool',0)->where('user_id',$authId)->count();
            } else {
                $authId = $authuser->id;
                $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',0)->get();
                foreach($empjobs as $job){array_push($empjobids, $job->id);}

                $jobsclosed=JobOrders::where('status',6)->where('is_talentpool',0)->where('user_id',$authId)->count();
            }

            $amId = Association::where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->get();

            $activityes = Activity::where('activity_by',$amId[0]['accountmanager_id'])->whereIn('candidate_status',array(1,2))->get();
            $activityData = array();

            foreach($activityes as $activityesdata) {
                array_push($activityData, $activityesdata->candidate_id);
            }

            if($authuser->parent_id){
                 $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                 ->where('is_talentpool',0)
                ->where('employer_user_id',$authuser->id)
                ->lists('job_id');
                $totalcandidates = Association::whereIn('job_id',$empActIds)
                                    ->where('employer_id',$authuser->parent_id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->count();
                /*$totalcandidates=Association::whereIn('job_id',$empjobs)
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_status')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->count(); */
              /*  reach($empjobs as $job){array_push($empjobids, $job->id);}
            $empprofilesreceived = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->get();
                                    */
                $candidatesCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidateEmpCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->where('status_updated_by',$authId)
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesInvalidCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesRejectCount = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1,30])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $profilesSelected=Association::whereIn('job_id',$empjobs)
                                        ->whereIn('candidate_status',[27,28])
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('job_id')
                                        ->count();
            } else {

                 $empjobs = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',0)->get();
            $empjobids = array();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}
            $totalcandidates = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->count();

                /*$totalcandidates=Association::whereIn('job_id',$empjobids)
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_status')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->count();*/

                $candidatesCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidateEmpCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->where('status_updated_by',$authId)
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesInvalidCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesRejectCount = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1,30])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $profilesSelected=Association::whereIn('job_id',$empjobids)
                                        ->whereIn('candidate_status',[27,28])
                                        ->where('employer_id',$authId)
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('job_id')
                                        ->count();
            }
            $vendors = Association::where('employer_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('vendor_id')
                                ->with('employer.company')
                                ->get();

            //$candidates = $candidateEmpCount + $candidatesCount;

            $empnumbers[] = array('jobs'=>count($empjobs),'vendors'=>$vendors,'candidates'=>$candidatesCount,'jobsclosed'=>$jobsclosed, 'profilesselected' => $profilesSelected,'candidatesReject'=>$candidatesRejectCount,'candidatesinvalid' => $candidatesInvalidCount,'totalcandidates' => $totalcandidates);
            return response()->success(compact('empnumbers'));
    }
     public function getEmptalentpoolnumbers()
    {
            $authuser = Auth::user();
            $authId = null;
            $empjobids = array();
            if($authuser->parent_id){
                $authId = $authuser->parent_id;
                $empjobs = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
                $jobsclosed=JobOrders::whereIn('id',$empjobs)->where('status',6)->where('is_talentpool',1)->where('user_id',$authId)->count();
            } else {
                $authId = $authuser->id;
                $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->get();
                foreach($empjobs as $job){array_push($empjobids, $job->id);}

                $jobsclosed=JobOrders::where('status',6)->where('is_talentpool',1)->where('user_id',$authId)->count();
            }

            $amId = Association::where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->get();

            $activityes = Activity::where('activity_by',$amId[0]['accountmanager_id'])->whereIn('candidate_status',array(1,2))->get();
            $activityData = array();

            foreach($activityes as $activityesdata) {
                array_push($activityData, $activityesdata->candidate_id);
            }

            if($authuser->parent_id){
                 $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                 ->where('is_talentpool',1)
                ->where('employer_user_id',$authuser->id)
                ->lists('job_id');
                $totalcandidates = Association::whereIn('job_id',$empActIds)
                                    ->where('employer_id',$authuser->parent_id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->count();
                /*$totalcandidates=Association::whereIn('job_id',$empjobs)
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_status')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->count(); */
              /*  reach($empjobs as $job){array_push($empjobids, $job->id);}
            $empprofilesreceived = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->get();
                                    */
                $candidatesCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidateEmpCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->where('status_updated_by',$authId)
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesInvalidCount = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesRejectCount = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $profilesSelected=Association::whereIn('job_id',$empjobs)
                                        ->whereIn('candidate_status',[27,28])
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('job_id')
                                        ->count();
            } else {

                 $empjobs = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->get();
            $empjobids = array();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}
            $totalcandidates = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotIn('candidate_status',[2,1,19])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                                    ->count();

                /*$totalcandidates=Association::whereIn('job_id',$empjobids)
                                        ->where('employer_id',$authId)
                                        ->whereNotNull('candidate_status')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->count();*/

                $candidatesCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidateEmpCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->where('status_updated_by',$authId)
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesInvalidCount = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $candidatesRejectCount = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $profilesSelected=Association::whereIn('job_id',$empjobids)
                                        ->whereIn('candidate_status',[27,28])
                                        ->where('employer_id',$authId)
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('job_id')
                                        ->count();
            }
            $vendors = Association::where('employer_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('vendor_id')
                                ->with('employer.company')
                                ->get();

            //$candidates = $candidateEmpCount + $candidatesCount;

            $emptalentpoolnumbers[] = array('jobs'=>count($empjobs),'vendors'=>$vendors,'candidates'=>$candidatesCount,'jobsclosed'=>$jobsclosed, 'profilesselected' => $profilesSelected,'candidatesReject'=>$candidatesRejectCount,'candidatesinvalid' => $candidatesInvalidCount,'totalcandidates' => $totalcandidates);
            return response()->success(compact('emptalentpoolnumbers'));
    }


    public function getEmpratios()
    {
        $authuser = Auth::user();
        $authId = null;
        $empjobids = array();

        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->get();
            $totalJobsCount = count($empActIds);
            $allJobs = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',0)->where('user_id',$authId)->get();
            foreach($empActIds as $job){array_push($empjobids, $job->job_id);}
        }else {
            $authId = $authuser->id;
            $totalJobsCount = JobOrders::where('user_id',$authId)->where('is_talentpool',0)->count();
            $allJobs = JobOrders::where('user_id',$authId)->where('is_talentpool',0)->get();
            foreach($allJobs as $job){array_push($empjobids, $job->id);}
        }

        $submittedProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->groupby('job_id')
                            ->get();

        $totalProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->groupby('job_id','candidate_id')
                            ->get();

        $interviwedProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->with('status')
                            ->whereHas('status',function($query){
                                $query->where('parent_id','=',5);
                            })
                            ->whereNotNull('vendor_id')
                            ->count();
        $totalcandidatesn = Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNotNull('candidate_status')
                            ->whereNotIn('candidate_status',[19,7,2,1])
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->count();

        $jobsclosed=JobOrders::whereIn('id',$empjobids)->where('is_talentpool',0)->where('status',6)->where('user_id',$authId)->count();
        //Calculate percentages
        $submittedPercentage=(count($submittedProfiles)/$totalJobsCount ) * 100;
        $closedPercentage= ($jobsclosed/$totalJobsCount ) * 100;
        $allprofilesPercentage = (count($totalProfiles)/($totalJobsCount*3)) * 100;
        $interviewprofilesPercentage = ($interviwedProfiles/($totalJobsCount*3)) * 100;

        $empratios[] = array('totalJobsCount'=>$totalJobsCount,'allJobs'=>$allJobs,'submittedProfiles'=>count($submittedProfiles),'submittedProfilesPercentage'=>$submittedPercentage,'closedPercentage'=>$closedPercentage,'jobsclosed'=>$jobsclosed,'noofprofiles'=>count($totalProfiles), 'noofprofilespercentage'=>$allprofilesPercentage, 'jobmaxprofiles'=>($totalJobsCount*3), 'interviwedProfiles'=>$interviwedProfiles, 'candidatescountnew'=>$totalcandidatesn, 'interviwedPercentage'=>$interviewprofilesPercentage);

        return response()->success(compact('empratios'));
    }
    public function getEmptalenpoolratios()
    {
        $authuser = Auth::user();
        $authId = null;
        $empjobids = array();

        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->get();
            $totalJobsCount = count($empActIds);
            $allJobs = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('user_id',$authId)->get();
            foreach($empActIds as $job){array_push($empjobids, $job->job_id);}
        }else {
            $authId = $authuser->id;
            $totalJobsCount = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->count();
            $allJobs = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->get();
            foreach($allJobs as $job){array_push($empjobids, $job->id);}
        }

        $submittedProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->groupby('job_id')
                            ->whereHas('job',function($query){
                                $query->where('is_talentpool','=',1);
                            })
                            ->get();

        $totalProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->groupby('job_id','candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('is_talentpool','=',1);
                            })
                            ->get();

        $interviwedProfiles=Association::whereIn('job_id',$empjobids)
                            ->where('employer_id',$authId)
                            ->whereNull('employer_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->with('status')
                            ->whereHas('status',function($query){
                                $query->where('parent_id','=',5);
                            })
                            ->whereHas('job',function($query){
                                $query->where('is_talentpool','=',1);
                            })
                            ->whereNotNull('vendor_id')
                            ->count();

        $jobsclosed=JobOrders::whereIn('id',$empjobids)->where('is_talentpool',1)->where('status',6)->where('user_id',$authId)->count();
        //Calculate percentages
        $submittedPercentage=(count($submittedProfiles)/$totalJobsCount ) * 100;
        $closedPercentage= ($jobsclosed/$totalJobsCount ) * 100;
        $allprofilesPercentage = (count($totalProfiles)/($totalJobsCount*3)) * 100;
        $interviewprofilesPercentage = ($interviwedProfiles/($totalJobsCount*3)) * 100;

        $emptalenpoolratios[] = array('totalJobsCount'=>$totalJobsCount,'allJobs'=>$allJobs,'submittedProfiles'=>count($submittedProfiles),'submittedProfilesPercentage'=>$submittedPercentage,'closedPercentage'=>$closedPercentage,'jobsclosed'=>$jobsclosed,'noofprofiles'=>count($totalProfiles), 'noofprofilespercentage'=>$allprofilesPercentage, 'jobmaxprofiles'=>($totalJobsCount*3), 'interviwedProfiles'=>$interviwedProfiles, 'interviwedPercentage'=>$interviewprofilesPercentage);

        return response()->success(compact('emptalenpoolratios'));
    }

    public function getVendornumbers()
    {
        $authuser = Auth::user();
        $authId =null;
        $date_data = new DateTime();
        $count_value = "P" . '5000' . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id) {
			
            $authId=$authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->with('assingnedJob')
                            ->whereHas('assingnedJob',function($query){ $query->where('status','=',8); })
                            ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach($a as $c){array_push($b, $c);}

            $j = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $d = array();
            foreach ($j as $c) {
                array_push($d, $c);
            }

            $jobs = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->with('job_closed.status')->whereHas('job_closed',function($query){ $query->where('status','=',8); })->count();
            $selectedprofiles = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNotNull('candidate_id')->where('candidate_status',27)->count();
            $candidates = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereIn('job_id',$b)->whereNotNull('candidate_id')->count();
            $jobsclosed = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->with('job_closed.status')->whereHas('job_closed',function($query){ $query->where('status','=',6); })->count();
            $employers = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->groupBy('employer_id')->with('employer.company')->get();
            $uplodedprofiles=Association::where('vendor_user_id',$authuser->id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->count();
            $amId = Association::where('vendor_id', $authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('candidate_id')->first()->accountmanager_id;
            $closed_jobs = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $d)->whereNull('candidate_id')->where('job_status', 3)->with('job.JobType')->with('job_closed.status', 'job_assigned.vendorrevenues')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->count();

            /*$est0=VendorRevenue::where('vendor_id',$authuser->parent_id)->whereIn('job_id',$b)->whereNotNull('est_revenue_1')->whereNotNull('est_revenue_2')->whereNotNull('est_revenue_3')->where('default_revenue',0)->with('joborder')->whereHas('joborder',function($query){ $query->where('status','=',8); })->get();
            $est1=VendorRevenue::where('vendor_id',$authuser->parent_id)->whereIn('job_id',$b)->whereNotNull('est_revenue_1')->whereNotNull('est_revenue_2')->whereNotNull('est_revenue_3')->where('default_revenue',1)->with('joborder')->whereHas('joborder',function($query){ $query->where('status','=',8); })->get();
            $est2=VendorRevenue::where('vendor_id',$authuser->parent_id)->whereIn('job_id',$b)->whereNotNull('est_revenue_1')->whereNotNull('est_revenue_2')->whereNotNull('est_revenue_3')->where('default_revenue',2)->with('joborder')->whereHas('joborder',function($query){ $query->where('status','=',8); })->get();
            $est3=VendorRevenue::where('vendor_id',$authuser->parent_id)->whereIn('job_id',$b)->whereNotNull('est_revenue_1')->whereNotNull('est_revenue_2')->whereNotNull('est_revenue_3')->where('default_revenue',3)->with('joborder')->whereHas('joborder',function($query){ $query->where('status','=',8); })->get();
            */
			$vendoruserCount = $actionsCount = array();


        } else {
            $authId=$authuser->id;
            /*$jobs=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                 ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                                 ->count();*/
            $jobs=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->count();
            $selectedprofiles=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNotNull('candidate_id')
                                ->where('candidate_status',27)
                                ->count();
            $candidates=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('job_id')
                                ->whereNotNull('candidate_id')
                                ->count();
            $jobsclosed=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',6); })
                                 ->count();
         $closed_jobs = Association::where('vendor_id', $authuser->id)
                                 ->whereNotNull('accountmanager_id')
                                 ->whereNotNull('employer_id')
                                 ->whereNull('vendor_user_id')
                                 ->whereNull('employer_user_id')
                                 ->whereNotNull('job_id')
                                 ->whereNull('candidate_id')
                                 ->where('job_status', 3)//->where('created_at','>=',$diff_date)
                                 ->with('job.JobType')
                                 ->with('job_closed.status', 'job_assigned.vendorrevenues')
                                 ->whereHas('job_closed', function ($query) {
                                     $query->where('status', '=', 6);
                                 })->count();

            $uplodedprofiles=Candidate::where('vendor_id',$authuser->id)
                                ->where('is_privatearea',0)
                                ->where('is_alive',1)
                                ->count();
            $employers=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                                ->get();
            //$talentpool_request=TalentpoolRequests::where('vendor_id',$authuser->id)
                                //->where('vendor_seen',1)->count();
            /*$est0=VendorRevenue::where('vendor_id',$authuser->id)
                                ->whereNotNull('est_revenue_1')
                                ->whereNotNull('est_revenue_2')
                                ->whereNotNull('est_revenue_3')
                                ->where('default_revenue',0)
                                ->with('joborder')
                                ->whereHas('joborder',function($query){ $query->where('status','=',8); })
                                ->get();
            $est1 = VendorRevenue::where('vendor_id',$authuser->id)
                                ->whereNotNull('est_revenue_1')
                                ->whereNotNull('est_revenue_2')
                                ->whereNotNull('est_revenue_3')
                                ->where('default_revenue',1)
                                ->with('joborder')
                                ->whereHas('joborder',function($query){ $query->where('status','=',8); })
                                ->get();
            $est2 = VendorRevenue::where('vendor_id',$authuser->id)
                                ->whereNotNull('est_revenue_1')
                                ->whereNotNull('est_revenue_2')
                                ->whereNotNull('est_revenue_3')
                                ->where('default_revenue',2)
                                ->with('joborder')
                                ->whereHas('joborder',function($query){ $query->where('status','=',8); })
                                ->get();
            $est3 = VendorRevenue::where('vendor_id',$authuser->id)
                                ->whereNotNull('est_revenue_1')
                                ->whereNotNull('est_revenue_2')
                                ->whereNotNull('est_revenue_3')
                                ->where('default_revenue',3)
                                ->with('joborder')
                                ->whereHas('joborder',function($query){ $query->where('status','=',8); })
                                ->get();
			*/
            $vendoruserCount = User::where('parent_id',$authuser->id)->get();

            $actionsCount = Association::where( 'vendor_id',intval($authuser->id) )
                                        ->where('admin_id',1)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('job_id')
                                        ->where('vendor_approval',0)
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status', 19)
                                        ->get();
        }//else

        $possiblerevenue = null ;
        /*foreach ($est0 as $est) {
            $assocCheck=Association::where('vendor_id',$authId)->whereNotNull('accountmanager_id')
			->whereNotNull('employer_id')->whereNull('vendor_user_id')->whereNull('employer_user_id')
			->where('job_id',$est->job_id)->whereNull('candidate_id')->whereNotIn('job_status',[2,6])->count();
            if($assocCheck){$possiblerevenue = $possiblerevenue + $est->est_revenue_1;}
        }
        foreach ($est1 as $est) {
            $assocCheck=Association::where('vendor_id',$authId)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('vendor_user_id')->whereNull('employer_user_id')->where('job_id',$est->job_id)->whereNull('candidate_id')->whereNotIn('job_status',[2,6])->count();
            if($assocCheck){$possiblerevenue = $possiblerevenue + $est->est_revenue_1;}
        }
        foreach ($est2 as $est) {
            $assocCheck=Association::where('vendor_id',$authId)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('vendor_user_id')->whereNull('employer_user_id')->where('job_id',$est->job_id)->whereNull('candidate_id')->whereNotIn('job_status',[2,6])->count();
            if($assocCheck){$possiblerevenue = $possiblerevenue + $est->est_revenue_2;}
        }
        foreach ($est3 as $est) {
            $assocCheck=Association::where('vendor_id',$authId)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('vendor_user_id')->whereNull('employer_user_id')->where('job_id',$est->job_id)->whereNull('candidate_id')->whereNotIn('job_status',[2,6])->count();
            if($assocCheck){$possiblerevenue = $possiblerevenue + $est->est_revenue_3;}
        }
		*/
		// mukesh
		
		$revenues = DB::table('vendor_accountmanager_share')->where('vendor_id', $authId)->get();
		
		if(is_array($revenues) && count($revenues)>0) {
			foreach($revenues as $key => $value) {
				$possiblerevenue += $value->vendor_price;
			}
			$possiblerevenue = round($possiblerevenue);
		}
        if($possiblerevenue == null){
            $possiblerevenue = 0;
        }
        $vendornumbers[] = array('jobs'=>$jobs,'candidates'=>$candidates, 'uplodedprofiles'=>$uplodedprofiles, 'employersnumber'=>$employers,'jobsclosed'=>$closed_jobs,'selectedprofiles'=>$selectedprofiles, 'possiblerevenue' => $possiblerevenue,'no_of_vendor_users'=>count($vendoruserCount),'actions_to_take'=>count($actionsCount));
        return response()->success(compact('vendornumbers'));
    }
//'talentpool_request'=>$talentpool_request,
    /*public function getCvssubmited()
    {
      $authuser = Auth::user();
      $cvssubmited = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->with('job')
                            ->with('candidate')
                            ->get();
        foreach ($cvssubmited as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canid = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canid];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('cvssubmited'));
    }*/

    public function getCvssubmited()
    {
        $authuser = Auth::user();
        $query = Association::whereNotNull('candidate_id')
            ->with('job')
            ->with('candidate');
    
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $jobIds = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->with('assingnedJob')
                ->whereHas('assingnedJob', function ($query) {
                    $query->where('status', 8);
                })
                ->pluck('job_id')
                ->toArray();
    
            $query->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('job_id', $jobIds);
        } else {
            $query->where('associations.vendor_id', $authuser->id)
                ->whereNotNull('associations.accountmanager_id')
                ->whereNotNull('associations.employer_id')
                ->whereNotNull('associations.job_id');
        }
    
        $cvssubmited = $query->get();
    
        $cvssubmited->each(function ($job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job->job->id);
            $encrypted_canid = base64_encode($timestamp . $randomKey . $job->candidate->id);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canid];
            $job->numbers = $numbers;
        });
    
        return response()->success(compact('cvssubmited'));
    }
    

    public function getVendorusernumbers()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $candidatesteam = array();
        $vendoractivitycandidate=VendorActivities::whereNotNull('job_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        foreach($vendoractivitycandidate as $can)
            {array_push($candidatesteam, $can->candidate_id);}
        $jobs = Association::where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->with('job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->count();
        $selectedprofiles=Association::whereIn('candidate_id',$candidatesteam)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',6)
                            ->count();
        $candidates = Candidate::where('vendor_id',$authuser->id)->count();
        $jobsclosed = Association::whereIn('candidate_id',$candidatesteam)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->count();
        $employers = Association::where('vendor_id',$supervendor[0]->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->groupBy('employer_id')
                            ->with('employer.company')
                            ->get();
        $est0 = VendorRevenue::where('vendor_id',$authuser->id)
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->where('default_revenue',0)
                        ->with('joborder')
                        ->whereHas('joborder',function($query){
                            $query->where('status','=',8);
                        })
                        ->get();
        $est1 = VendorRevenue::where('vendor_id',$authuser->id)
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->where('default_revenue',1)
                        ->with('joborder')
                        ->whereHas('joborder',function($query){
                            $query->where('status','=',8);
                        })
                        ->get();

        $est2 = VendorRevenue::where('vendor_id',$authuser->id)
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->where('default_revenue',2)
                        ->with('joborder')
                        ->whereHas('joborder',function($query){
                            $query->where('status','=',8);
                        })
                        ->get();

        $est3 = VendorRevenue::where('vendor_id',$authuser->id)
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->where('default_revenue',3)
                        ->with('joborder')
                        ->whereHas('joborder',function($query){
                            $query->where('status','=',8);
                        })
                        ->get();

        $possiblerevenue = null ;
        foreach ($est0 as $est) {$possiblerevenue = $possiblerevenue + $est->est_revenue_1;}
        foreach ($est1 as $est) {$possiblerevenue = $possiblerevenue + $est->est_revenue_1;}
        foreach ($est2 as $est) {$possiblerevenue = $possiblerevenue + $est->est_revenue_2;}
        foreach ($est3 as $est) {$possiblerevenue = $possiblerevenue + $est->est_revenue_3;}

      $vendorusernumbers[] = array('jobs'=>$jobs,'candidates'=>$candidates,'employersnumber'=>$employers,'jobsclosed'=>$jobsclosed,'selectedprofiles'=>$selectedprofiles, 'possiblerevenue' => $possiblerevenue);
      return response()->success(compact('vendorusernumbers'));
    }
 public function getVendorusernumber()
    {
   $authuser = Auth::user();
   //$vendoruser = User::where('parent_id', $authuser->id)->where('role_id', 9)->orderBy('first_name', 'asc') ->with('company')->get();
   $vendorusernumber=User::where('role_id', 9)->where('parent_id',$authuser->id)->orderBy('first_name', 'asc')->with('company')->get();
   $vendorteam = array();
    foreach($vendorusernumber as $vusers){
      $candidates = Candidate::where('vendor_id',$vusers->id)->count();
      $candidatesteam = array();
      $candidates = Candidate::where('vendor_id',$vusers->id)->get();
      foreach($candidates as $can){array_push($candidatesteam, $can->id);}
        $jobs = Association::where('vendor_user_id',$vusers->id)
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->with('job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->count();
        $selectedprofiles = Association::whereIn('candidate_id',$candidatesteam)->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_user_id')
                            ->where('candidate_status',6)
                            ->count();
        $jobsclosed = Association::whereIn('candidate_id',$candidatesteam)->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->count();
        $employers = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->groupBy('employer_id')
                            ->with('employer.company')
                            ->get();
                           $employers= count($employers);
        $numbers = array('jobs'=>$jobs,'employersnumber'=>$employers,'jobsclosed'=>$jobsclosed,'selectedprofiles'=>$selectedprofiles);
        $vusers['numbers'] = $numbers;
       }
      return response()->success(compact('vendorusernumber'));
    }



    public function getTeam()
    {
        $authuser = Auth::user();
        $team = Association::Where('vendor_id',$authuser->id)
                                      ->whereNull('candidate_id')
                                      ->whereNull('job_id')
                                      ->whereNotNull('vendor_user_id')
                                      ->with('vendor')
                                      ->get();
        return response()->success(compact('team'));
    }

    public function getAmteamnum()
    {
        $authuser = Auth::user();
        $amteamnum = Association::Where('admin_id',$authuser->id)
                                      ->whereNull('candidate_id')
                                      ->whereNull('job_id')
                                      ->whereNull('vendor_id')
                                      ->whereNull('employer_id')
                                      ->whereNotNull('accountmanager_id')
                                      ->with('accountmanager')
                                      ->get();
        $amjobids = array();
        foreach($amteamnum as $am) {//print_r("start");
            $amjobids=Association::where('accountmanager_id', $am->accountmanager->id)
                                ->whereNotNull('job_id')
                                ->whereNotNull('employer_id')
                                ->groupBy('job_id')
                                ->lists('job_id');

                          //      print_r($amjobids);
            $submittedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->accountmanager->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();

            $rejectedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->accountmanager->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[2,1])
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $selectedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->accountmanager->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[27,28])
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $shorlistedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->accountmanager->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',array(5,17,18,20,22,23,24,25,26))
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $totalProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->accountmanager->id)
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->groupby('job_id','candidate_id')
                                ->count();
            $jobsrejectedbyam = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',2)
                                ->count();
            $inactivejobs = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',7)
                                ->count();
            $jobsaccepted = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',3)
                                ->count();
            $jobspending = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',4)
                                ->count();
            $jobsclosed = JobOrders::whereIn('id',$amjobids)
                                ->where('status',6)->where('is_talentpool',0)
                                ->count();
            $jobsheld = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',24)
                                ->count();
            $empuserNumber=array('totalJobs' => count($amjobids), 'closedJobs' => $jobsclosed,  'rejectedJobs' => $jobsrejectedbyam, 'inactiveJobs' => $inactivejobs ,'jobsaccepted' =>$jobsaccepted , 'jobspending' => $jobspending, 'heldjobs' => $jobsheld , 'submittedProfiles' => $submittedProfiles, 'rejectedProfiles' => $rejectedProfiles ,'selectedProfiles' => $selectedProfiles ,'shorlistedProfiles' => $shorlistedProfiles);
            $am['empuserNumber'] = $empuserNumber;
        }
        return response()->success(compact('amteamnum'));
    }

     public function getAdminamteams()
    {
        $authuser = Auth::user();
        $adminamteams = Association::Where('admin_id',$authuser->id)
                                      ->whereNull('candidate_id')
                                      ->whereNull('job_id')
                                      ->whereNull('vendor_id')
                                      ->whereNull('employer_id')
                                      ->whereNotNull('accountmanager_id')
                                      ->with('accountmanager')
                                      ->get();
        return response()->success(compact('adminamteams'));
    }

    public function postCandidateactivity()
    {
      $canId = Input::get('candidateId');
      $jobId = Input::get('jobId');

      $authuser = Auth::user();
      $candidateactivity = Activity::Where('vendor_id',$authuser->id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->with('activityuser.role','status')
                                      ->get();

      return response()->success($candidateactivity);
    }

    public function postAmcandidateactivity()
    {
      $canId = Input::get('candidateId');
      $jobId = Input::get('jobId');

      $authuser = Auth::user();
      $amcandidateactivity = Activity::Where('accountmanager_id',$authuser->id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->whereNotNull('vendor_id')
                                      ->with('activityuser.role','status')
                                      ->get();

      return response()->success($amcandidateactivity);
    }

    public function postEmpcandidateactivity()
    {
      $canId = Input::get('candidateId');
      $jobId = Input::get('jobId');

      $authuser = Auth::user();
      $empcandidateactivity = Activity::Where('employer_id',$authuser->id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->whereNotNull('vendor_id')
                                      ->with('activityuser.role','status')
                                      ->get();

      return response()->success($empcandidateactivity);
    }

    public function postAllcandidateactivity()
    {
        $authuser = Auth::user();
        $canId = Input::get('candidateId');
        $jobId = Input::get('jobId');

        if($authuser->role_id == 1) {
            $allcandidateactivity = Activity::where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->with('activityuser.role','status')
                                      ->get();
        }

        if($authuser->role_id == 5 || $authuser->role_id == 8) {
            $allcandidateactivity = Activity::Where('employer_id',$authuser->id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->whereNotNull('vendor_id')
                                      ->with('activityuser.role','status')
                                      ->get();
        }

        if($authuser->role_id == 6 || $authuser->role_id == 9) {
            ($authuser->parent_id!=null) ? $authId=$authuser->parent_id : $authId=$authuser->id;
            $allcandidateactivity = Activity::Where('vendor_id',$authId)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->whereNull('vendor_user_id')
                                      ->with('activityuser.role','status')
                                      ->get();
        }

        if($authuser->role_id == 10) {
            $allcandidateactivity = Activity::Where('accountmanager_id',$authuser->id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->whereNotNull('vendor_id')
                                      ->with('activityuser.role','status')
                                      ->get();
        }

        return response()->success($allcandidateactivity);

    }

     public function postUsercandidateactivity()
    {
      $authuser = Auth::user();
      $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
      $canId = Input::get('candidateId');
      $jobId = Input::get('jobId');

      $authuser = Auth::user();
      $usercandidateactivity = Activity::Where('vendor_id',$supervendor[0]->parent_id)
                                      ->where('candidate_id',$canId)
                                      ->where('job_id',$jobId)
                                      ->with('activityuser.role','status')
                                      ->get();

      return response()->success($usercandidateactivity);
    }
    public function getAmnumbers()
    {
        $authuser = Auth::user();
        $pending_profiles_count =0;
        $rejected_profiles_count =0;

          $jobs = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->count();
        $profiles_gdpr = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                             ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })

                            ->count();
        $profiles_gdpr_yes = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })
                            ->where('gdpr_status',1)
                            ->count();
        $profiles = $profiles_gdpr+$profiles_gdpr_yes;
        $amemployers = Association::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->count();
        $amvendors = Association::where('accountmanager_id',$authuser->id)
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->with('vendor.company')
                                    ->count();
        $vendorassigned = Association::select('id')
                            ->where('accountmanager_id',$authuser->id)
                            ->with('job_closed.status')
                            ->with('job_closed.JobType')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',3);
                            })
                            ->groupby('job_id')
                            ->havingRaw('count(vendor_id) < 1')
                            ->get();
        $amvendorworking = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->count();
        $jobsclosed = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->count();
        $bellCount = BellNotifications::where('accountmanager_id',$authuser->id)
                            ->where('status',0)
                            ->count();
        $talentpoolreqs = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->where('talentpool_status',0)->where('am_seen',1)
                            ->count();
        $jobs_pending = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->with('job_closed.status')
                            ->whereNotNull('updated_at')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                            })
                            ->orderBy('job_id', 'ASC')
                            ->groupby('job_id')
                            ->get();

            foreach ($jobs_pending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }

        $jobs_progress = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                            })
                            ->count();

        $pending_profiles = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')/*->where('gdpr_status',1)*/
                            ->where('candidate_status',19)
                            ->with('job')
                            ->whereHas('job',function($query){
                                $query->where('status','!=',6);
                            })
                            ->orderBy('updated_at', 'ASC')
                            ->groupby('job_id')
                            ->get();

            foreach ($pending_profiles as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
                $pending_profiles_count += $job['number_of_profiles'];
            }
            $rejected_profiles = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->with('job_closed.status')
                                ->where('job_status','=',2)
                                ->whereNotNull('updated_at')
                                ->whereHas('job_closed',function($query){
                                    $query->where('status','!=',215);
                                })
                                ->orderBy('job_id', 'ASC')
                                ->groupby('job_id')
                                ->get();
                                
            foreach ($rejected_profiles as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
                $rejected_profiles_count += $job['number_of_profiles'];
            }


             $alldeviationrequests = \App\DeviationRequests::where('vendor_deviation_request',1)
                               ->where('accountmanager_id',$authuser->id)
                                ->with('job')->with('vendor')->with('vendor.company')
                                ->get();
        foreach ($alldeviationrequests as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }

      $amnotifications = \App\BellNotifications::where('accountmanager_id',$authuser->id)
                            ->where('status',0)->with('job')
                            ->get();
         foreach ($amnotifications as $ambell) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $ambell['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $ambell['numbers'] = $numbers;
            }

          $arrayjobpending = count($jobs_pending);
          $arraypending = count($pending_profiles);
          $arrayrejected = count($rejected_profiles);
          $arraydeviationrequests = count($alldeviationrequests);
          $arraypendingprofile = count($amnotifications);
          $arr = array($arrayjobpending,$arraypending,$arrayrejected,$arraydeviationrequests,$bellCount);
          $sumarray = array_sum($arr);
          
        $amnumbers[] = array('jobs'=>$jobs,'employers'=>$amemployers,'vendors'=>$amvendors,'profiles'=>$profiles,'jobs_closed'=>$jobsclosed,'jobs_pending'=>$jobs_pending,'jobs_progress'=>$jobs_progress, 'pending_profiles' => $pending_profiles, 'rejected_profiles' => $rejected_profiles, 'bellCount'=>$bellCount,'vendorassigned'=>$vendorassigned, 'amvendorsworking'=>$amvendorworking, 'talentpoolreqs'=>$talentpoolreqs,'noofprofiles' =>$sumarray,'pendingprofilesnotifications' =>$amnotifications,'pending_profiles_count'=>$pending_profiles_count, 'rejected_profiles_count'=>$rejected_profiles_count);
        return response()->success(compact('amnumbers'));
    }
    public function getAmtplnumbers()
    {
        $authuser = Auth::user();
        $alltalentpools = JobOrders::where('is_talentpool',1)->count();
        $alltalentpoolreqs = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->count();
        $dectalentpoolreqs = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                             ->where('vendor_status',2)
                            ->count();
        $acctalentpoolreqs = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                             ->where('vendor_status',1)
                            ->count();
        $pentalentpoolreqs = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                             ->where('vendor_status',0)
                            ->count();
        $alltplreq = TalentpoolDeviationRequests::whereNotNull('id')->count();
        $allpendingtplreq = TalentpoolDeviationRequests::where('am_deviation_status', '=','Pending')->count();
        $allacceptedtplreq = TalentpoolDeviationRequests::where('am_deviation_status', '=','Accepted')->count();
        $allrejectedtplreq = TalentpoolDeviationRequests::where('am_deviation_status', '=','Rejected')->count();

        $amtplnumbers[] = array('alltalentpools'=>$alltalentpools , 'alltalentpoolreqs'=>$alltalentpoolreqs,'dectalentpoolreqs'=>$dectalentpoolreqs,'acctalentpoolreqs'=>$acctalentpoolreqs,'pentalentpoolreqs' =>$pentalentpoolreqs,'all_acceptedtpldevreq' =>$allacceptedtplreq,'all_rejecteddevtplreq' =>$allrejectedtplreq,'all_pendingdevtplreq' =>$allpendingtplreq,'all_devtplreq' =>$alltplreq);
        return response()->success(compact('amtplnumbers'));
    }
     public function getVendortplnumbers()
    {
        $authuser = Auth::user();
        $alltalentpoolreqs = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('is_enabled',0)
                            ->count();
        $dectalentpoolreqs = TalentpoolRequests::where('vendor_id',$authuser->id)
                             ->where('vendor_status',2)->where('is_enabled',0)
                            ->count();
        $acctalentpoolreqs = TalentpoolRequests::where('vendor_id',$authuser->id)
                             ->where('vendor_status',1)->where('is_enabled',0)
                            ->count();
        $pentalentpoolreqs = TalentpoolRequests::where('vendor_id',$authuser->id)
                             ->where('vendor_status',0)->where('is_enabled',0)
                            ->count();
        $vendortplnumbers[] = array('alltalentpoolreqs'=>$alltalentpoolreqs,'dectalentpoolreqs'=>$dectalentpoolreqs,'acctalentpoolreqs'=>$acctalentpoolreqs,'pentalentpoolreqs' =>$pentalentpoolreqs);
        return response()->success(compact('vendortplnumbers'));
    }
    public function getTalentpoolsdata()
    {
    $authuser = Auth::user();
    $talentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->where('am_seen',1)
                            ->with('talentpools')
                            ->with('job')
                            ->get();
    return response()->success(compact('talentpoolsdata'));
    }
    public function getVendortalentpoolsdata()
    {
        $authuser = Auth::user();
        if($authuser->role_id == 10){
        $vendortalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->where('am_seen',1)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        }else if($authuser->role_id == 6){
        $vendortalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('vendor_seen',1)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        }
        foreach ($vendortalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted=base64_encode($timestamp . $randomKey . $value['job_id']);
            $value['encrypted_jobId'] = $encrypted;
        }
        return response()->success(compact('vendortalentpoolsdata'));
    }
     public function getVendortalentpoolsrequestdata()
    {
        $authuser = Auth::user();
        $vendortalentpoolsrequestdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('is_enabled',0)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        foreach ($vendortalentpoolsrequestdata as $value) {
            $value['role_id'] = $authuser->role_id;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted=base64_encode($timestamp . $randomKey . $value['job_id']);
            $value['encrypted_jobId'] = $encrypted;
        }
        return response()->success(compact('vendortalentpoolsrequestdata'));
    }
    public function getVendorpendingtalentpoolsdata()
    {
        $authuser = Auth::user();
        $vendorpendingtalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('vendor_status',0)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        foreach ($vendorpendingtalentpoolsdata as $value) {
             $first_name = $value['job']['user']['first_name'];
        if(strlen($first_name) > 3){$parts1 = str_split($first_name, 3);}
        if(strlen($first_name) <= 3){ $parts1 = str_split($first_name, 2);}
        for ($x = 0; $x < count($parts1); $x++) {
          if($x%2==0)
          {}
          else
          {
            if(strlen($parts1[$x]) == 1){$parts1[$x] = 'x';}else if(strlen($parts1[$x]) == 2){
              $parts[$x] = 'xx';
            }else if(strlen($parts1[$x]) == 3){$parts1[$x] = 'xxx';}else if(strlen($parts1[$x]) == 4){
              $parts1[$x] = 'xxxx';}else{$parts1[$x] = 'xxx';}
          }
        }
        $value['job']['user']['first_name'] = implode($parts1);
         $last_name = $value['job']['user']['last_name'];
        if(strlen($last_name) > 3){$parts1 = str_split($last_name, 3);}
        if(strlen($last_name) <= 3){ $parts1 = str_split($last_name, 2);}
        for ($x = 0; $x < count($parts1); $x++) {
          if($x%2==0)
          {}
          else
          {
            if(strlen($parts1[$x]) == 1){$parts1[$x] = 'x';}else if(strlen($parts1[$x]) == 2){
              $parts[$x] = 'xx';
            }else if(strlen($parts1[$x]) == 3){$parts1[$x] = 'xxx';}else if(strlen($parts1[$x]) == 4){
              $parts1[$x] = 'xxxx';}else{$parts1[$x] = 'xxx';}
          }
        }
        $value['job']['user']['last_name'] = implode($parts1);
        //print_r($value['job']['user']['company']['name']);exit;
         $name = $value['job']['user']['company']['name'];
        if(strlen($name) > 3){$parts1 = str_split($name, 3);}
        if(strlen($name) <= 3){ $parts1 = str_split($name, 2);}
        for ($x = 0; $x < count($parts1); $x++) {
          if($x%2==0)
          {}
          else
          {
            if(strlen($parts1[$x]) == 1){$parts1[$x] = 'x';}else if(strlen($parts1[$x]) == 2){
              $parts[$x] = 'xx';
            }else if(strlen($parts1[$x]) == 3){$parts1[$x] = 'xxx';}else if(strlen($parts1[$x]) == 4){
              $parts1[$x] = 'xxxx';}else{$parts1[$x] = 'xxx';}
          }
        }
        $value['job']['user']['company']['name'] = implode($parts1);
                $value['role_id'] = $authuser->role_id;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted=base64_encode($timestamp . $randomKey . $value['job_id']);
            $value['encrypted_jobId'] = $encrypted;
        }
        return response()->success(compact('vendorpendingtalentpoolsdata'));
    }
    public function getVendoracceptedtalentpoolsdata()
    {
        $authuser = Auth::user();
        $vendoracceptedtalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('vendor_status',1)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        foreach ($vendoracceptedtalentpoolsdata as $value) {
                 $is_submitted = Association::where('vendor_id',$authuser->id)
                                                    ->where('job_id',$value['job_id'])
                                                    ->whereNotNull('candidate_id')
                                                    ->count();
                $value['role_id'] = $authuser->role_id;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted=base64_encode($timestamp . $randomKey . $value['job_id']);
                $value['encrypted_jobId'] = $encrypted;
                $value['is_submitted_profile'] = $is_submitted;
                //print_r($is_submitted);
        }//exit;
        return response()->success(compact('vendoracceptedtalentpoolsdata'));
    }

    public function getVendorrejectedtalentpoolsdata()
    {
        $authuser = Auth::user();
        $vendorrejectedtalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('vendor_status',2)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->get();
        foreach ($vendorrejectedtalentpoolsdata as $value) {
                $value['role_id'] = $authuser->role_id;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted=base64_encode($timestamp . $randomKey . $value['job_id']);
            $value['encrypted_jobId'] = $encrypted;
        }
        return response()->success(compact('vendorrejectedtalentpoolsdata'));
    }

    public function postTalentpoolrequesthold(){
    $authuser = Auth::user();
       $talentpoolreqdata = ['note' => Input::get('note'),'is_enabled' => 1];
        if($authuser->role_id == 10){
          $talentpools_req_updat = TalentpoolRequests::where('id',Input::get('talentpool_req_id'))->update($talentpoolreqdata);
        }
        return  response()->success("Updated Successfully");
    }
    public function postTalentpoolrequestreject(){
    $authuser = Auth::user();
       $talentpoolreqdata = ['vendor_note' => Input::get('note'),'vendor_status' => 2];
          $talentpools_req_updat = TalentpoolRequests::where('id',Input::get('talentpool_req_id'))->update($talentpoolreqdata);
        return  response()->success("Updated Successfully");
    }
    public function getAcceptrequest($id){
    $authuser = Auth::user();
       $talentpoolreqdata = ['vendor_status' => 1];
          $talentpools_req_updat = TalentpoolRequests::where('id',$id)->update($talentpoolreqdata);
        return  response()->success("Updated Successfully");
    }

    public function getSpecifictpltalentpoolsdata()
    {
        $authuser = Auth::user();
        $specifictpltalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            /*->where('vendor_seen',1)*/
                            ->with('talentpools')

                            ->groupBy('talentpool_id')
                            ->with('job.user.company')
                            ->get();
        foreach ($specifictpltalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('specifictpltalentpoolsdata'));
    }
    public function getAcceptedtalentpoolsdata()
    {
        $authuser = Auth::user();
        $acceptedtalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',1)
                            ->with('job.user.company')
                            ->get();
        foreach ($acceptedtalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('acceptedtalentpoolsdata'));
    }
    public function getAcceptedvendortalentpoolsdata()
    {
        $authuser = Auth::user();
        $acceptedvendortalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',1)
                            ->with('job.user.company')
                            ->get();
        foreach ($acceptedvendortalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('acceptedvendortalentpoolsdata'));
    }
     public function getRejectedtalentpoolsdata()
    {
        $authuser = Auth::user();
        $rejectedtalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',2)
                            ->with('job.user.company')
                            ->get();
        foreach ($rejectedtalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('rejectedtalentpoolsdata'));
    }
    public function getRejectedvendortalentpoolsdata()
    {
        $authuser = Auth::user();
        $rejectedvendortalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',2)
                            ->with('job.user.company')
                            ->get();
        foreach ($rejectedvendortalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('rejectedvendortalentpoolsdata'));
    }
         public function getPendingtalentpoolsdata()
    {
        $authuser = Auth::user();
        $pendingtalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',0)
                            ->with('job.user.company')
                            ->get();
        foreach ($pendingtalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('pendingtalentpoolsdata'));
    }
     public function getPendingvendortalentpoolsdata()
    {
        $authuser = Auth::user();
        $pendingvendortalentpoolsdata = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->with('talentpools')
                            ->where('vendor_status',0)
                            ->with('job.user.company')
                            ->get();
        foreach ($pendingvendortalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('pendingvendortalentpoolsdata'));
    }

    public function getAmtalentpoolsjobdata()
    {
        $authuser = Auth::user();
        $amtalentpoolsjobdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->groupBy('job_id')
                            ->get();
        foreach ($amtalentpoolsjobdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('amtalentpoolsjobdata'));
    }
    public function getSpecificvendortalentpoolsdata()
    {
        $authuser = Auth::user();
        $specificvendortalentpoolsdata = TalentpoolRequests::where('accountmanager_id',$authuser->id)
                            ->with('talentpools')
                            ->with('job.user.company')
                            ->with('vendor.company')
                            ->groupBy('vendor_id')
                            ->get();
        foreach ($specificvendortalentpoolsdata as $value) {
            $value['role_id'] = $authuser->role_id;
        }
        return response()->success(compact('specificvendortalentpoolsdata'));
    }

    public function getAdminamnumbers($userId)
    {
        $authuser = Auth::user();
        $jobs = Association::where('accountmanager_id',$userId)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->count();
        $profiles = Association::where('accountmanager_id',$userId)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->count();
        $amemployers = Association::where('accountmanager_id',$userId)
                                    ->whereNotNull('employer_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->count();
/*        $amvendors = Association::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->count();*/

        $amvendors = Association::where('accountmanager_id',$userId)
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->with('vendor.company')
                                    ->count();

        $jobsclosed = Association::where('accountmanager_id',$userId)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->count();
        $bellCount = BellNotifications::where('accountmanager_id',$userId)
                            ->where('status',0)
                            ->count();

        $jobs_pending = Association::where('accountmanager_id',$userId)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->with('job_closed.status')
                            ->whereNotNull('updated_at')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                            })
                             ->get();

            foreach ($jobs_pending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }

        $jobs_progress = Association::where('accountmanager_id',$userId)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                             ->count();

        $pending_profiles = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                            ->where('accountmanager_id',$userId)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',19)
                            ->with('job')
                            ->whereHas('job',function($query){
                                $query->where('status','!=',6);
                            })
                            ->groupby('job_id')
                            ->get();

            foreach ($pending_profiles as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }

        $adminamnumbers[] = array('jobs'=>$jobs,'employers'=>$amemployers,'vendors'=>$amvendors,'profiles'=>$profiles,'jobs_closed'=>$jobsclosed,'jobs_pending'=>$jobs_pending,'jobs_progress'=>$jobs_progress, 'pending_profiles' => $pending_profiles,'bellCount'=>$bellCount);
        return response()->success(compact('adminamnumbers'));
    }

function getAmnotifications() {
	
      $authuser = Auth::user();
      $amnotifications = BellNotifications::where('accountmanager_id',$authuser->id)
                            ->where('status',0)->with('job')
                            ->get();
							
            foreach ($amnotifications as $ambell) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $ambell['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $ambell['numbers'] = $numbers;
            }
      return response()->success(compact('amnotifications'));
    }
    function getAdminamnotifications($userId) {
      $authuser = Auth::user();
      $amnotifications = BellNotifications::where('accountmanager_id',$userId)
                            ->where('status',0)->with('job')
                            ->get();
                            foreach ($amnotifications as $ambell) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $ambell['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $ambell['numbers'] = $numbers;
            }
      return response()->success(compact('adminamnotifications'));
    }
   public function getVendorjobrevenues() {
      $authuser = Auth::user();
	  $vendorjobrevenues = array();
        if($authuser->parent_id){
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
              $b = array();
              foreach($a as $c){array_push($b, $c);}
			  
			  $vendorjobrevenues = DB::table('vendor_accountmanager_share as vas')
					->select('jo.name', 'vas.vendor_price')
					->where('vas.vendor_id', $authuser->id)
					->whereIn('vas.job_id', $b)
					->join('job_orders as jo', 'jo.id', '=', 'vas.job_id')
					->get();
			
        } else {
          /*$vendorjobrevenues = Association::where('vendor_id',$authuser->id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('employer_id')
                    ->whereNull('vendor_user_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNotNull('job_id')
                    ->whereNull('candidate_id')
                    ->where('job_status',3)
                    ->with('job_assigned.status','job_assigned.vendorrevenues')
                    ->whereHas('job_assigned',function($query){
                        $query->where('status','=',8);
                    })
                            ->orderBy('created_at', 'desc')
                            ->limit(25)
                            ->get();
			*/
		
		$vendorjobrevenues = DB::table('vendor_accountmanager_share as vas')
			->select('jo.name','jo.currency', 'vas.vendor_price')
			->where('vas.vendor_id', $authuser->id)
			->join('job_orders as jo', 'jo.id', '=', 'vas.job_id')
			->get();
        }
		
      return response()->success(compact('vendorjobrevenues'));
    }
     function getVendortalentpooljobrevenues() {
      $authuser = Auth::user();
        if($authuser->parent_id){
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
              $b = array();
              foreach($a as $c){array_push($b, $c);}
                $vendortalentpooljobrevenues=Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                                $query->where('is_talentpool','=',1);
                            })
                            ->orderBy('created_at', 'desc')
                            ->limit(25)
                            ->get();
        } else {
          $vendortalentpooljobrevenues = Association::where('vendor_id',$authuser->id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('employer_id')
                    ->whereNull('vendor_user_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNotNull('job_id')
                    ->whereNull('candidate_id')
                    ->where('job_status',3)
                    ->with('job_assigned.status','job_assigned.vendorrevenues')
                    ->whereHas('job_assigned',function($query){
                        $query->where('status','=',8);
                        $query->where('is_talentpool','=',1);
                    })
                            ->orderBy('created_at', 'desc')
                            ->limit(25)
                            ->get();
        }
      return response()->success(compact('vendortalentpooljobrevenues'));
    }
     function getTalentpooljobrevenues() {
      $authuser = Auth::user();
          $talentpooljobrevenues = TalentpoolRequests::where('vendor_id',$authuser->id)
                            ->where('vendor_status',1)
                            ->with('job')
                            ->limit(25)
                            ->get();
      return response()->success(compact('talentpooljobrevenues'));
    }

     function getVendoralljobrevenues() {
        $authuser = Auth::user();
        if($authuser->parent_id){
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
              $b = array();
              foreach($a as $c){array_push($b, $c);}
                /*$vendoralljobrevenues=Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('employer.company','job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->orderBy('created_at', 'desc')
                            ->get();
			*/
                $jobrevenues = DB::table('vendor_accountmanager_share as vas')
                                    ->select('jo.id', 'jo.name', 'jo.currency', 'jo.is_private', 'vas.vendor_price', 'c.name as company_name')
                                    ->where('vas.vendor_id', $authuser->parent_id)
                                    ->whereIn('vas.job_id', $b)
                                    ->join('job_orders as jo', 'jo.id', '=', 'vas.job_id')
                                    ->join('users as u', 'u.id', '=', 'vas.vendor_id')
                                    ->join('companies as c', 'c.id', '=', 'u.company_id')
                                    ->get();
            if(is_array($jobrevenues) && count($jobrevenues)>0) {
                foreach($jobrevenues as $key =>$value) {
                    
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $value->encryptedslug = base64_encode($timestamp . $randomKey . $value->id);
                    $vendoralljobrevenues[] = $value;
                }
            }

        } else {
        /*
        $vendoralljobrevenues = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('employer.company','job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();

		*/
		$jobrevenues = DB::table('vendor_accountmanager_share as vas')
									->select('jo.id', 'jo.name', 'jo.currency', 'jo.is_private', 'vas.vendor_price', 'c.name as company_name')
									->where('vas.vendor_id', $authuser->id)
									->join('job_orders as jo', 'jo.id', '=', 'vas.job_id')
									->join('users as u', 'u.id', '=', 'vas.vendor_id')
									->join('companies as c', 'c.id', '=', 'u.company_id')
									->get();
									
		
			if(is_array($jobrevenues) && count($jobrevenues)>0) {
				foreach($jobrevenues as $key =>$value) {
					
					$timestamp = 129346161081;
					$randomKey = '-';
					$value->encryptedslug = base64_encode($timestamp . $randomKey . $value->id);
					$vendoralljobrevenues[] = $value;
				}
			}

        }
      return response()->success(compact('vendoralljobrevenues'));
    }

    function getActivitydata() {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $empjobids = array();
            foreach($empActIds as $job){array_push($empjobids, $job);}
            $activitydata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authId)
                          ->whereNull('employer_user_id')
                          //->where('activity_by',"!=",$authId)
                          ->where('name',"!=","Commented by vendor")
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->limit(3)
                          ->get();
            foreach ($activitydata as $key => $job) {
                //  if($activitydata[$key]['job']['blindhire'] == 1 || $activitydata[$key]['candidate']['mask'] == 1)
                // {
                    if($activitydata[$key]['job']['blindhire'] == 1)
                    {
                  if(($activitydata[$key]['activityuser']['role']['id'] != 5 || ($activitydata[$key]['activityuser']['role']['id'] == 5 && $activitydata[$key]['status']['id'] == 1 || $activitydata[$key]['status']['id'] == 2 ))) 
                  {
                $full_name = $activitydata[$key]['candidate']['full_name'];
                $activitydata[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", mb_strlen($full_name)), 2, mb_strlen($full_name)-4);
                }
                }
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid];
                $job['numbers'] = $numbers;
            }
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',0)->get();

            $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
            //$city = City::select('country_id')->where('id',$empCompanyID[0]['city_id'])->get();
            //echo '<pre>'; print_r($empCompanyID); die;
            $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

            $empjobids = array();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}
            $activitydata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authId)
                          ->whereNull('employer_user_id')
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->where('name',"!=","Commented by vendor")
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->limit(3)
                          ->get();
            $reasons_arr = array();
            foreach ($activitydata as $key => $job) {
                if($activitydata[$key]['job']['blindhire'] == 1 || $activitydata[$key]['candidate']['mask'] == 1)
                {
                  if(($activitydata[$key]['activityuser']['role']['id'] != 5 || ($activitydata[$key]['activityuser']['role']['id'] == 5 && $activitydata[$key]['status']['id'] == 1 || $activitydata[$key]['status']['id'] == 2 ))) 
                  {
                $full_name = $activitydata[$key]['candidate']['full_name'];
                $activitydata[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", mb_strlen($full_name)), 2, mb_strlen($full_name)-4);
                }
                }
                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                if (in_array($job['candidate_status'], $candidate_status_arr)){
                    foreach($reasons_arr as $reason){
                        $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                    }
                }else{
                        $reasonsData = [];
                }
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid,'reasonsData'=>$reasonsData];

                $created_date = date('Y-m-d-H-i-s', strtotime($job['created_at']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $job['created_at'] = $date->format('Y-m-d H:i:s');

                $job['timezone'] = $empTimezone[0]['GMT_offset'];

                $job['numbers'] = $numbers;
                $scheduled_date=Association::where('employer_id',$authId)
                          //->where('vendor_id',$job['vendor_id'])
                    ->where('candidate_id', $job['candidate_id'])
                    // ->where('candidate_status',$job['candidate_status'])
                    ->where('job_id', $job['job_id'])
                    ->where('employer_id', $job['employer_id'])
                    ->whereNotNull('interview_schedule_date')
                    ->first();

            if($scheduled_date) {
                $created_date = date('Y-m-d-H-i-s', strtotime($scheduled_date['interview_schedule_date']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($scheduled_date['interview_schedule_date'], new \DateTimeZone('UTC'));

                $date->format('Y-m-d H:i:s');
                $statusData= $scheduled_date['status_updated_by'];
                $StatusRoleId = User::select('role_id')->where('id',$statusData)->get();
                foreach ($StatusRoleId as $value) {
                    $getRoleId = $value['role_id'];
                }
                $assignName = "";
                if($getRoleId == 10 )
                {
                    $assignName = "Account manager";
                    
                }
                else if($getRoleId == 5)
                {
                    $assignName = "Employer";              
                
                
                }

                 else if($getRoleId == 6)
                 {
                     $assignName = "Vendor";
                  
                 }

                $job['status_updated_by'] = $assignName;
               
                $job['interview_schedule_date'] = $date->format('Y-m-d H:i:s');

                $job['association_id'] = $scheduled_date['id']; }
            else { $job['association_id'] = $job['interview_schedule_date'] = null;}
            }
        }
        return response()->success(compact('activitydata'));
    }
    function getActivitytalentpooldata() {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $empjobids = array();
            foreach($empActIds as $job){array_push($empjobids, $job);}

            $activitytalentpooldata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authId)
                          ->whereNull('employer_user_id')
                          //->where('activity_by',"!=",$authId)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->limit(3)
                          ->get();

            foreach ($activitytalentpooldata as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
                $job['numbers'] = $numbers;
            }
        } else {
            $authId = $authuser->id;
             $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->get();
            $empjobids = array();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}

            $activitytalentpooldata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authId)
                          ->whereNull('employer_user_id')
                          //->where('activity_by',"!=",$authId)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->limit(3)
                          ->get();

            foreach ($activitytalentpooldata as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
                $job['numbers'] = $numbers;
            }
        }

          return response()->success(compact('activitytalentpooldata'));
    }

    function getActivityviewalldata() {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $empjobids = array();
            foreach($empActIds as $job){array_push($empjobids, $job);}

            $activityviewalldata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authId)
                          ->where('activity_by',"!=",$authId)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->get();

            foreach ($activityviewalldata as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }
        } else {
            $empjobs = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',0)->get();
            $empjobids = array();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}

            $activityviewalldata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authuser->id)
                          ->where('activity_by',"!=",$authuser->id)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->get();

            foreach ($activityviewalldata as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }
        }
      return response()->success(compact('activityviewalldata'));
    }

    function getAmactivitydata() {
      $authuser = Auth::user();
      $empjobs = Association::where('accountmanager_id',$authuser->id)
                             /* ->whereNull('vendor_id')
                              ->whereNull('candidate_id')*/
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();
      $empjobids = array();
      foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

        $amactivitydata = Activity::whereIn('job_id',$empjobids)
                          ->where('accountmanager_id',$authuser->id)
                          /*->where('activity_by',"!=",$authuser->id)*/
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->limit(3)
                          ->get();

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        $reasons_arr = array();
            foreach ($amactivitydata as $key => $job) {
                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                if (in_array($job['candidate_status'], $candidate_status_arr)){
                    foreach($reasons_arr as $reason){
                        $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                    }
                }else{
                        $reasonsData = [];
                }


            $created_date = date('Y-m-d-H-i-s', strtotime($job['updated_at']));
            $created_at = explode('-', $created_date);
            
            $date = new \DateTime($job['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            $job['updated_at'] = $date->format('Y-m-d H:i:s');

            $job['timezone'] = $empTimezone[0]['GMT_offset'];

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid,'reasonsData'=>$reasonsData];

            $scheduled_date = Association::where('accountmanager_id', $authuser->id)
                    //->where('vendor_id',$job['vendor_id'])
                    ->where('candidate_id', $job['candidate_id'])
                    // ->where('candidate_status',$job['candidate_status'])
                    ->where('job_id', $job['job_id'])
                    ->where('employer_id', $job['employer_id'])
                    ->whereNotNull('interview_schedule_date')
                    ->first();

            if($scheduled_date) {
                $created_date = date('Y-m-d-H-i-s', strtotime($scheduled_date['interview_schedule_date']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($scheduled_date['interview_schedule_date'], new \DateTimeZone('UTC'));

                $date->format('Y-m-d H:i:s');
                $statusData= $scheduled_date['status_updated_by'];
                $StatusRoleId = User::select('role_id')->where('id',$statusData)->get();
                foreach ($StatusRoleId as $value) {
                    $getRoleId = $value['role_id'];
                }
                
                if($getRoleId == 10 )
                {
                    $assignName = "Account manager";
                    
                }
                else if($getRoleId == 5)
                {
                    $assignName = "Employer";
                 
                }
                else if($getRoleId == 6)
                {
                    $assignName = "Vendor";
                 
                }
                $job['status_updated_by'] = $assignName;
               
                $job['interview_schedule_date'] = $date->format('Y-m-d H:i:s');

                $job['association_id'] = $scheduled_date['id']; }
            else { $job['association_id'] = $job['interview_schedule_date'] = null;}
            $job['numbers'] = $numbers;

        }

        return response()->success(compact('amactivitydata'));
    }
    function getAmtalentpoolactivitydata() {
      $authuser = Auth::user();
      $empjobs = Association::where('accountmanager_id',$authuser->id)
                              ->whereNull('vendor_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')->whereHas('job',function($query) {
                                $query->where('is_talentpool',1);
                            })->get();
      $empjobids = array();
      foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

      $amtalentpoolactivitydata = Activity::whereIn('job_id',$empjobids)
                          ->where('accountmanager_id',$authuser->id)
                          ->where('activity_by',"!=",$authuser->id)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                           ->limit(3)
                          ->get();
        foreach ($amtalentpoolactivitydata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
            $job['numbers'] = $numbers;

            $scheduled_date=Association::where('accountmanager_id',$authuser->id)
                          ->where('vendor_id',$job['vendor_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->where('employer_id',$job['employer_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
            if($scheduled_date) {
                $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                $job['association_id'] = $scheduled_date['id']; }
            else { $job['association_id'] = $job['interview_schedule_date'] = null;}

        }
      return response()->success(compact('amtalentpoolactivitydata'));
    }
   function getAdminamactivitydata($userId) {
      $authuser = Auth::user();
      $empjobs = Association::where('accountmanager_id',$userId)
                              ->whereNull('vendor_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();
      $empjobids = array();
      foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

      $adminamactivitydata = Activity::whereIn('job_id',$empjobids)
                          ->where('accountmanager_id',$userId)
                          ->where('activity_by',"!=",$userId)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                           ->limit(3)
                          ->get();
        foreach ($adminamactivitydata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('adminamactivitydata'));
    }

  function getAmactivityviewalldata() {

     $authuser = Auth::user();
      $empjobs = Association::where('accountmanager_id',$authuser->id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();
      $empjobids = array();
      foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

      $amactivityviewalldata = Activity::whereIn('job_id',$empjobids)
                          ->where('accountmanager_id',$authuser->id)
                          /*->where('activity_by',"!=",$authuser->id)*/
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->groupBy('job_id')
                          ->get();
 foreach ($amactivityviewalldata as $vactivity) {
                $vendoractivitycount = Activity::where('accountmanager_id',$authuser->id)
                          ->where('job_id',$vactivity['job_id'])
                          /*->where('activity_by',"!=",$authuser->id)*/
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->count();
                $numbers = ['activity_count'=>$vendoractivitycount];
                $vactivity['numbers'] = $numbers;
            }//foreach
        return response()->success(compact('amactivityviewalldata'));
    }
    function getAmtopvendors() {
      $authuser = Auth::user();
      $amtopvendors = Association::select(DB::raw("COUNT(*) as profiles"),"vendor_id")
                      ->where('accountmanager_id',$authuser->id)
                      ->whereNotNull('vendor_id')
                      ->whereNotNull('candidate_id')
                      ->whereNotNull('job_id')
                      ->whereNotNull('employer_id')
                      ->with('vendor.company')
                      ->groupby(DB::raw('vendor_id'))
                      ->orderBy('profiles', 'desc')
                      ->limit(5)
                      ->get();
      return response()->success(compact('amtopvendors'));
    }

     function getAdminamtopvendors($userId) {
      $authuser = Auth::user();
      $adminamtopvendors = Association::select(DB::raw("COUNT(*) as profiles"),"vendor_id")
                      ->where('accountmanager_id',$userId)
                      ->whereNotNull('vendor_id')
                      ->whereNotNull('candidate_id')
                      ->whereNotNull('job_id')
                      ->whereNotNull('employer_id')
                      ->with('vendor.company')
                      ->groupby(DB::raw('vendor_id'))
                      ->orderBy('profiles', 'desc')
                      ->limit(5)
                      ->get();
      return response()->success(compact('adminamtopvendors'));
    }

    function getTopvendors($count = 7) {
      $authuser = Auth::user();
      $topvendors = Association::select(DB::raw("COUNT(*) as profiles"),"vendor_id")
                      ->whereNotNull('vendor_id')
                      ->whereNotNull('candidate_id')
                      ->whereNotNull('job_id')
                      ->whereNotNull('employer_id')
                      ->with('vendor.company')
                      ->groupby(DB::raw('vendor_id'))
                      ->orderBy('profiles', 'desc')
                      ->limit($count)
                      ->get();
      return response()->success(compact('topvendors'));
    }

    function getFutureinterviews($count = 7) {
      $authuser = Auth::user();
      $futureinterviews = Association::whereNotNull('interview_schedule_date')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('candidate_status')
                          ->groupby(DB::raw('interview_schedule_date'))
                           ->orderBy('interview_schedule_date', 'desc')
                           ->limit($count)
                            ->get()

                            ->groupBy(function($val) {
                                if($val->interview_schedule_date != '' && $val->interview_schedule_date != null && $val->interview_schedule_date != 0 ){
                                   // print_r($val->interview_schedule_date);
            return Carbon::parse($val->interview_schedule_date)->format('m');
    } });
       $futureinterviews =  array($futureinterviews);
      return response()->success(compact('futureinterviews'));
    }

    function getVendoractivitydata() {
        $authuser=Auth::user();

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

        if($authuser->parent_id){
            $empjobs=Association::where('vendor_id',$authuser->parent_id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();

              $empjobids = array();
              foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

              $vendoractivitydata=Activity::whereIn('job_id',$empjobids)
                                  ->where('vendor_id',$authuser->parent_id)
                                  ->orwhere('vendor_id',$authuser->id)
                                 /*   ->where('vendor_id',$authuser->parent_id)
                                 ->where('activity_by',"!=",$authuser->parent_id) */
                                  ->whereNotNull('candidate_id')
                                  ->whereNotNull('note')
                                  ->with('job','candidate','activityuser.role','status')
                                  ->orderBy('created_at', 'desc')
                                  ->limit(3)
                                  ->get();
         $reasons_arr = array();
                   foreach ($vendoractivitydata as $key => $job) {
                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                if (in_array($job['candidate_status'], $candidate_status_arr)){
                    foreach($reasons_arr as $reason){
                        $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                    }
                }else{
                        $reasonsData = [];
                }

                    $created_date = date('Y-m-d-H-i-s', strtotime($job['created_at']));
                    $created_at = explode('-', $created_date);
                    
                    $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');

                    $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                    $job['created_at'] = $date->format('Y-m-d H:i:s');

                    $job['timezone'] = $empTimezone[0]['GMT_offset'];

                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId,'reasonsData'=>$reasonsData];
                    $job['numbers'] = $numbers;
                    $scheduled_date=Association::where('vendor_id',$authuser->parent_id)
                          ->where('accountmanager_id',$job['accountmanager_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->where('employer_id',$job['employer_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
                    if($scheduled_date) {
                        //$job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];

                        $created_date = date('Y-m-d-H-i-s', strtotime($scheduled_date['interview_schedule_date']));
                        $created_at = explode('-', $created_date);
                        
                        $date = new \DateTime($scheduled_date['interview_schedule_date'], new \DateTimeZone('UTC'));
                        $date->format('Y-m-d H:i:s');

                        $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                        $job['interview_schedule_date'] = $date->format('Y-m-d H:i:s');

                        $job['association_id'] = $scheduled_date['id']; }
                    else { $job['association_id'] = $job['interview_schedule_date'] = null;}
                }//foreach
        } else {
            $empjobs=Association::where('vendor_id',$authuser->id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();

              $empjobids = array();
              foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

              $vendoractivitydata=Activity::whereIn('job_id',$empjobids)
                                  ->where('vendor_id',$authuser->id)
                                  /* ->where('activity_by',"!=",$authuser->id) */
                                  ->whereNotNull('candidate_id')
                                  ->whereNotNull('note')
                                  ->with('job','candidate','activityuser.role','status')
                                  ->orderBy('created_at', 'desc')
                                  ->limit(3)
                                  ->get();
                $reasons_arr = array();
                   foreach ($vendoractivitydata as $key => $job) {
                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                if (in_array($job['candidate_status'], $candidate_status_arr)){
                    foreach($reasons_arr as $reason){
                        $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                    }
                }else{
                        $reasonsData = [];
                }

                    $created_date = date('Y-m-d-H-i-s', strtotime($job['created_at']));
                    $created_at = explode('-', $created_date);
                    
                    $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');

                    $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                    $job['created_at'] = $date->format('Y-m-d H:i:s');

                    $job['timezone'] = $empTimezone[0]['GMT_offset'];

                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId,'reasonsData'=>$reasonsData];
                    $job['numbers'] = $numbers;
                    $scheduled_date=Association::where('vendor_id',$authuser->id)
                          ->where('accountmanager_id',$job['accountmanager_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->where('employer_id',$job['employer_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
                    if($scheduled_date) {
                        //$job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];

                        $created_date = date('Y-m-d-H-i-s', strtotime($scheduled_date['interview_schedule_date']));
                        $created_at = explode('-', $created_date);
                        
                        $date = new \DateTime($scheduled_date['interview_schedule_date'], new \DateTimeZone('UTC'));
                        $date->format('Y-m-d H:i:s');

                        $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                        $job['interview_schedule_date'] = $date->format('Y-m-d H:i:s');

                        $job['association_id'] = $scheduled_date['id']; }
                    else { $job['association_id'] = $job['interview_schedule_date'] = null;}
                }
        }

      return response()->success(compact('vendoractivitydata'));
    }
    function getVendortalentpoolactivitydata() {
        $authuser=Auth::user();
        if($authuser->parent_id){
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');

              $b = array();
              foreach($a as $c){array_push($b, $c);}

            if(count($b)):
                $vendoractivitydata=Activity::where('vendor_id',$authuser->parent_id)
                                  ->whereNull('vendor_user_id')
                                  ->whereIn('job_id',$b)
                                  ->whereNotIn('activity_by',[$authuser->id,$authuser->parent_id])
                                  ->whereNotNull('note')
                                  ->whereNotNull('job_id')
                                  ->whereNotNull('candidate_id')
                                  //->whereNotNull('name')
                                  //->orWhere('activity_by',"!=",$authuser->parent_id)
                                  ->with('job','candidate','activityuser.role','status')
                                  ->orderBy('created_at', 'desc')
                                  ->limit(3)
                                  ->get();
            else:
                $vendoractivitydata = array();
            endif;

                foreach ($vendoractivitydata as $job) {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
                    $job['numbers'] = $numbers;


                     $scheduled_date=Association::where('vendor_id',$authuser->parent_id)
                          ->where('accountmanager_id',$job['accountmanager_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->where('employer_id',$job['employer_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
                    if($scheduled_date) {
                        $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                        $job['association_id'] = $scheduled_date['id']; }
                    else { $job['association_id'] = $job['interview_schedule_date'] = null;}
                }//foreach
        }
        else {
            $empjobs=Association::where('vendor_id',$authuser->id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->whereHas('job',function($query) {
                                $query->where('is_talentpool',1);
                            })
                              ->get();
              $empjobids = array();
              foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

              $vendortalentpoolactivitydata=Activity::whereIn('job_id',$empjobids)
                                  ->where('vendor_id',$authuser->id)
                                  ->where('activity_by',"!=",$authuser->id)
                                  ->whereNotNull('candidate_id')
                                  ->whereNotNull('note')
                                  ->with('job','candidate','activityuser.role','status')
                                  ->orderBy('created_at', 'desc')
                                  ->limit(3)
                                  ->get();
                foreach ($vendortalentpoolactivitydata as $job) {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId];
                    $job['numbers'] = $numbers;
                     $scheduled_date=Association::where('vendor_id',$authuser->id)
                          ->where('accountmanager_id',$job['accountmanager_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->where('employer_id',$job['employer_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
                    if($scheduled_date) {
                        $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                        $job['association_id'] = $scheduled_date['id']; }
                    else { $job['association_id'] = $job['interview_schedule_date'] = null;}
                }
        }

      return response()->success(compact('vendortalentpoolactivitydata'));
    }

    function getJobsvsprofiles($count = 7) {
      $authuser = Auth::user();
      $jobs = Activity::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->with('status')
                            ->whereHas('status',function($query){
                                $query->where('parent_id','=',5);
                            })
                            ->whereNotNull('vendor_id')
                            ->groupBy('date')
                            ->orderBy('date', 'DESC')
                            ->limit($count)
                            ->get(array(
                                DB::raw('Date(created_at) as date'),
                                DB::raw('COUNT(*) as "jobs"')
                                //DB::raw('"jobs"')
                            ));
        $candidates = Association::whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->groupBy('date')
                            ->orderBy('date', 'DESC')
                            ->limit($count)
                            ->get(array(
                                DB::raw('Date(created_at) as date'),
                                DB::raw('COUNT(*) as "profiles"')
                            ));
      $jobsvsprofiles[] = array('jobs' => $jobs, 'candidates' => $candidates);
      return response()->success(compact('jobsvsprofiles'));
    }

    function getInterviewsvsrejections($count = 7) {
      $authuser = Auth::user();

      $ints = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                            ->groupBy('date')
                            ->orderBy('date', 'DESC')
                            ->limit($count)
                            ->get(array(
                                DB::raw('Date(created_at) as date'),
                                DB::raw('COUNT(*) as "ints"')
                            ));
        $rejs = Association::whereNotNull('employer_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->groupBy('date')
                            ->orderBy('date', 'DESC')
                            ->limit($count)
                            ->get(array(
                                DB::raw('Date(created_at) as date'),
                                DB::raw('COUNT(*) as "rejs"')
                            ));
      $interviewsvsrejections[] = array('ints' => $ints, 'rejs' => $rejs);
      return response()->success(compact('interviewsvsrejections'));
    }

    public function getAdminratios()
    {
            $authuser = Auth::user();
            $totalJobsCount = JobOrders::where('is_talentpool',0)->count();
            $allJobs = JobOrders::where('is_talentpool',0)->get();


            $submittedProfiles=Association::whereNotNull('job_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->groupby('job_id')
                                ->get();

            $totalProfiles=Association::whereNotNull('job_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->groupby('job_id','candidate_id')
                                ->get();

            $interviwedProfiles=Association::whereNotNull('job_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('candidate_status')
                                ->with('status')
                                ->whereHas('status',function($query){
                                    $query->where('parent_id','=',5);
                                })
                                ->whereNotNull('vendor_id')
                                ->count();

            $jobsclosed=JobOrders::where('status',6)->where('is_talentpool',0)->count();
            //Calculate percentages
            $submittedPercentage=(count($submittedProfiles)/$totalJobsCount ) * 100;
            $closedPercentage= ($jobsclosed/$totalJobsCount ) * 100;
            $allprofilesPercentage = (count($totalProfiles)/($totalJobsCount*3)) * 100;
            $interviewprofilesPercentage = ($interviwedProfiles/($totalJobsCount*3)) * 100;

            $adminratios[] = array('totalJobsCount'=>$totalJobsCount,'allJobs'=>$allJobs,'submittedProfiles'=>count($submittedProfiles),'submittedProfilesPercentage'=>$submittedPercentage,'closedPercentage'=>$closedPercentage,'jobsclosed'=>$jobsclosed,'noofprofiles'=>count($totalProfiles), 'noofprofilespercentage'=>$allprofilesPercentage, 'jobmaxprofiles'=>($totalJobsCount*3), 'interviwedProfiles'=>$interviwedProfiles, 'interviwedPercentage'=>$interviewprofilesPercentage);

            return response()->success(compact('adminratios'));
    }

    function getVendoractivityviewalldata() {
      $authuser = Auth::user();
        if($authuser->parent_id){
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
              $b = array();
              foreach($a as $c){array_push($b, $c);}
              $vendoractivityviewalldata=Activity::whereIn('job_id',$b)
                                    ->whereNotNull('candidate_id')
                                    ->where('vendor_id',$authuser->parent_id)
                                    ->whereNotNull('note')
                                    ->where('admin_id',1)
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->with('job','candidate','activityuser.role','status')
                                    ->orderBy('created_at', 'desc')
                                    ->groupBy('job_id')
                                    ->get();

            foreach ($vendoractivityviewalldata as $vactivity) {
                $id = $vactivity['job_id'];
                // $vendoractivitycount=Activity::where(function ($query) use ($authuser,$id) {
                //         $query->where('job_id',$id)
                //         ->where('is_vendor_sourcing_activity',0)
                //         ->where('vendor_id',$authuser->parent_id);
                //     })
                //     ->orWhere(function($query)  use ($id) {
                //         $query->where('job_id',$id)
                //         ->where('is_vendor_sourcing_activity',0)
                //         ->whereIn('job_status', [6,24]);
                //     })
                //     ->where('admin_id',1)
                //     ->whereNotNull('note')
                //     ->whereNotNull('candidate_id')
                //     ->whereNull('vendor_user_id')
                //     ->get();
                $vendoractivitycount = Activity::where('job_id',$id)
                            ->where('is_vendor_sourcing_activity',0)
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('note')
                            ->whereNull('vendor_user_id')
                            ->where('admin_id',1)
                            ->get();
                $numbers = ['activity_count'=>count($vendoractivitycount)];
                $vactivity['numbers'] = $numbers;
            }//foreach

        } else {
              $empjobs = Association::where('vendor_id',$authuser->id)
                                      ->whereNotNull('accountmanager_id')
                                      ->whereNull('candidate_id')
                                      ->whereNotNull('job_id')
                                      ->whereNotNull('employer_id')
                                      ->get();
              $empjobids = array();
              foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

              $vendoractivityviewalldata = Activity::whereIn('job_id',$empjobids)
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('note')
                                    ->whereNull('vendor_user_id')
                                    ->where('admin_id',1)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->with('job','candidate','activityuser.role','status')
                                    ->orderBy('created_at', 'desc')
                                    ->groupBy('job_id')
                                    ->get();

                    foreach ($vendoractivityviewalldata as $vactivity) {
                        $id = $vactivity['job_id'];
                        // $vendoractivitycount = Activity::where(function ($query) use ($authuser,$id) {
                        //         $query->where('job_id',$id)
                        //         ->where('is_vendor_sourcing_activity',0)
                        //         ->where('vendor_id',$authuser->id);
                        //     })
                        //     ->orWhere(function($query)  use ($id) {
                        //         $query->where('job_id',$id)
                        //         ->where('is_vendor_sourcing_activity',0)
                        //         ->whereIn('job_status', [6,24]);
                        //     })
                        //     ->count();
                        $vendoractivitycount = Activity::where('job_id',$id)
                                ->where('is_vendor_sourcing_activity',0)
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('note')
                                ->whereNull('vendor_user_id')
                                ->where('admin_id',1)
                                ->get();
                        $numbers = ['activity_count'=>count($vendoractivitycount)];
                        $vactivity['numbers'] = $numbers;
                    }//foreach
        } //else
      return response()->success(compact('vendoractivityviewalldata'));
    }

    function getEmployeractivityviewalldata() {
        $authuser = Auth::user();
        $authId = null;
        $empjobs = Association::where('employer_id',$authuser->id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();
        $empjobids = array();
        foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

        $employeractivityviewalldata = Activity::whereIn('job_id',$empjobids)
                          ->where('employer_id',$authuser->id)
                          ->where('activity_by',"!=",$authuser->id)
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->groupBy('job_id')
                          ->get();

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

        foreach ($employeractivityviewalldata as $vactivity) {
            /*$vendoractivitycount = Activity::where('employer_id',$authuser->id)
                      ->where('job_id',$vactivity['job_id'])
                      ->where('activity_by',"!=",$authuser->id)
                      ->whereNotNull('candidate_id')
                      ->whereNotNull('note')
                      ->count();*/
            if($authuser->parent_id){$authId=$authuser->parent_id;}
            else {$authId=$authuser->id;}

            $vendoractivitycount = Activity::where('job_id',$vactivity['job_id'])
                                    ->where('employer_id',$authId)
                                   /* ->whereNotIn('vendor_id', $vendorids)*/
                                    ->where('name', '!=', 'Job assigned to vendor User')
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNotNull('note')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->count();

            $numbers = ['activity_count'=>$vendoractivitycount];
            $vactivity['numbers'] = $numbers;

            $date = new \DateTime($vactivity['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            $vactivity['created_at'] = $date->format('Y-m-d H:i:s');
            $vactivity['timezone'] = $empTimezone[0]['GMT_offset'];
            //$vactivity['timezoneName'] = $empTimezone[0]['timezone'];
        }//foreach
        return response()->success(compact('employeractivityviewalldata'));
    }

    function getAmactivityalldata() {
      $authuser = Auth::user();
      $empjobs = Association::where('accountmanager_id',$authuser->id)
                              ->whereNotNull('accountmanager_id')
                              ->whereNull('candidate_id')
                              ->whereNotNull('job_id')
                              ->whereNotNull('employer_id')
                              ->get();
      $empjobids = array();
      foreach($empjobs as $job){array_push($empjobids, $job->job_id);}

      $amactivityalldata = Activity::whereIn('job_id',$empjobids)
                          ->where('accountmanager_id',$authuser->id)
                          /*->where('activity_by',"!=",$authuser->id)*/
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->orderBy('created_at', 'desc')
                          ->groupBy('job_id')
                          ->get();
 foreach ($amactivityalldata as $vactivity) {
                $vendoractivitycount = Activity::where('accountmanager_id',$authuser->id)
                          ->where('job_id',$vactivity['job_id'])
                          /*->where('activity_by',"!=",$authuser->id)*/
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->count();
                $numbers = ['activity_count'=>$vendoractivitycount];
                $vactivity['numbers'] = $numbers;
            }//foreach
      return response()->success(compact('amactivityalldata'));
    }

    function getCandidateallactivities($id) {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
            else{$authId=$authuser->id;}
        $candidateallactivities = Activity::Where('vendor_id',intval($authId))
                              ->where('candidate_id',intval($id))
                              ->with('status','job')
                              ->get();
        return response()->success(compact('candidateallactivities'));
    }

    function getCandidatejobwiserating($id) {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
            else{$authId=$authuser->id;}

        $candidatejobwiserating=Association::Where('vendor_id',intval($authId))
                              ->where('candidate_id',intval($id))
                              ->whereNotNull('job_id')
                              ->whereNotNull('candidate_status')
                              ->groupBy('job_id')
                              ->with('job','status')
                              ->get();
        return response()->success(compact('candidatejobwiserating'));
        }
    function getTalentpooldeviationdata() {
      $authuser = Auth::user();
      $talentpooldeviationdata = TalentpoolDeviationRequests::whereNotNull('id')
                                ->with('job')
                                ->with('vendor.company')
                                ->with('talentpool')
                                ->with('talentpoolrequest')
                                ->get();
        foreach ($talentpooldeviationdata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('talentpooldeviationdata'));
    }
    function getTalentpoolaccepteddeviationdata() {
      $authuser = Auth::user();
      $talentpoolaccepteddeviationdata = TalentpoolDeviationRequests::whereNotNull('id')
                                ->where('am_deviation_status','=','Accepted')
                                ->with('job')
                                ->with('vendor.company')
                                ->with('talentpool')
                                ->with('talentpoolrequest')
                                ->get();
        foreach ($talentpoolaccepteddeviationdata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('talentpoolaccepteddeviationdata'));
    }
    function getTalentpooldeviationpendingdata() {
      $authuser = Auth::user();
      $talentpooldeviationpendingdata = TalentpoolDeviationRequests::whereNotNull('id')
                                ->where('am_deviation_status','=','Pending')
                                ->with('job')
                                ->with('vendor.company')
                                ->with('talentpool')
                                ->with('talentpoolrequest')
                                ->get();
        foreach ($talentpooldeviationpendingdata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('talentpooldeviationpendingdata'));
    }
     function getTalentpoolrejecteddeviationdata() {
      $authuser = Auth::user();
      $talentpoolrejecteddeviationdata = TalentpoolDeviationRequests::whereNotNull('id')
                                ->where('am_deviation_status','=','Rejected')
                                ->with('job')
                                ->with('vendor.company')
                                ->with('talentpool')
                                ->with('talentpoolrequest')
                                ->get();
        foreach ($talentpoolrejecteddeviationdata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
      return response()->success(compact('talentpoolrejecteddeviationdata'));
    }


public function postEmpsortingp(Request $request)
    {
        $reponceData = array();
        $userId = auth()->user()->id;
        $userRole_id = auth()->user()->role_id;
        $userDateArray = array();
        if (count($request->sortData) > 0) {
            foreach ($request->sortData as $boxitem) {
                if (count($boxitem) > 0) {
                    foreach ($boxitem as $item) {
                        $dashboardLocalArray = array();
                        $dashboardLocalArray['user_id'] = $userId;
                        $dashboardLocalArray['user_role_id'] = $userRole_id;
                        $dashboardLocalArray['box_no'] = $item['box_no'];
                        $dashboardLocalArray['box_item'] = $item['box_item'];
                        $dashboardLocalArray['item_sort'] = $item['item_sort'];
                        $userDateArray[] = $dashboardLocalArray;
                    }
                }
            }
        }
        $remove = DashboardSorting::where('user_id', $userId)->delete();
        $reponce = DashboardSorting::insert($userDateArray);
        $reponceData['action']= 'updated';
        return response()->success($reponceData);
    }

    public function getEmpsorting(Request $request){
        $reponceData = array();
        $userId = auth()->user()->id;
        $userRole_id = auth()->user()->role_id;
        $getData= DashboardSorting::where('user_id', $userId)->orderBy('item_sort', 'ASC')->get();
        $reponceData['box_1'] = $getData->where('box_no', 1)->values()->all();
        $reponceData['box_2'] = $getData->where('box_no', 2)->values()->all();
        $reponceData['box_3'] = $getData->where('box_no', 3)->values()->all();
        return response()->success(compact('reponceData'));
    }


     public function getNavcustomization(Request $request)
    {
        $reponceData = array();
        $userId = Auth::user()->id;
        $record = UserThemeSetting::where('user_id',$userId)->first();
        $reponceData['record'] = $record;
        return response()->success($reponceData);
    }
    

    public function postNavcustomization(Request $request)
    {
        $reponceData = array();
        $userId = Auth::user()->id;
        $parseData =$request->customnav;
        $record = UserThemeSetting::where('user_id',$userId)->first();
        $parseData = array_filter( $parseData );
        if(!empty( $record)){
           $recordUopdate= $record->update( $parseData );
         }else{
            $parseData['user_id'] =$userId;
            $recordUopdate= UserThemeSetting::create( $parseData );
         }
        $reponceData['record'] =$recordUopdate;
        $reponceData['action']= 'updated';
        return response()->success($reponceData);
    }

    public function getLastlogin()
    {
        $authuser = Auth::user();
        $empCompanyID = Company::select('timezone')->where('id',$authuser['company_id'])->get();
        $timezone = Country::select('GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        $lastlogintime = DB::table("activities as a")
                  ->select('a.person_id','a.id','a.name','a.updated_at','u.role_id')
                  ->join('users as u', 'u.id', '=', 'a.person_id')
                  ->where('u.role_id', 5)
                  ->orderBy('a.id', 'DESC')->limit(2)
                  ->get();
        $lastlogin[] = array('timezone'=>$timezone,'time'=>$lastlogintime);
        return response()->success(compact('lastlogin'));
    }

    public function getLastloginven()
    {
        $authuser = Auth::user();
        $empCompanyID = Company::select('timezone')->where('id',$authuser['company_id'])->get();
        $timezone = Country::select('GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        $lastlogintime = DB::table("activities as a")
                  ->select('a.person_id','a.id','a.name','a.updated_at','u.role_id')
                  ->join('users as u', 'u.id', '=', 'a.person_id')
                  ->where('u.role_id', 6)
                  ->orderBy('a.id', 'DESC')->limit(2)
                  ->get();
        $lastlogin[] = array('timezone'=>$timezone,'time'=>$lastlogintime);
        return response()->success(compact('lastlogin'));
    }

    public function getLastloginam()
    {
        $authuser = Auth::user();
        $empCompanyID = Company::select('timezone')->where('id',$authuser['company_id'])->get();
        $timezone = Country::select('GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        $lastlogintime = DB::table("activities as a")
                  ->select('a.person_id','a.id','a.name','a.updated_at','u.role_id')
                  ->join('users as u', 'u.id', '=', 'a.person_id')
                  ->where('u.role_id', 10)
                  ->orderBy('a.id', 'DESC')->limit(2)
                  ->get();
        $lastlogin[] = array('timezone'=>$timezone,'time'=>$lastlogintime);
        return response()->success(compact('lastlogin'));
    }

	public function postDownloadcandidatedata() {
		$authuser = Auth::user();
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		$opt = Input::get('opt');
		$filename = Input::get('filename');
        if($authuser->role_id == 10)
        {
            $whereid = "accountmanager_id";
        }
         else if($authuser->role_id == 5)
        {
            $whereid = "employer_id";
        }
        else if($authuser->role_id == 6)
        {
            $whereid = "vendor_id";
        }
        else if($authuser->role_id == 9)
        {
            $whereid = "vendor_user_id";
        }
		$candidateInfo = Association::where('job_id',$job_id)
                                ->where($whereid,$authuser->id)
                                ->whereIn('candidate_id',$candidate_id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                //->whereIn('candidate_id', $candidate_id)
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor'))
                                ->with('CandidateDetails')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->whereHas('CandidatePoints',function($query) use ($job_id){
                                    $query->where('job_id','=',$job_id);
                                })
                                ->get()
								->toArray();


				$headers = array(
						'Content-Type' => 'application/vnd.ms-excel; charset=utf-8',
						'Cache-Control' => 'must-revalidate, post-check=0, pre-check=0',
						'Content-Disposition' => 'attachment;',
						'Expires' => '0',
						'Pragma' => 'public',
					);


				$uploadsDir = public_path('uploads');

				$uploadsDirUlr = '/uploads';

				if(!File::isDirectory($uploadsDir)){
					//make the directory because it doesn't exists
					File::makeDirectory($uploadsDir);
				}
				$jobInfo = DB::table("job_orders")->where('id', $job_id)->get();
				$job_name = str_replace(' ', '_', $jobInfo[0]->name);

				
				if(empty($filename)) {
					$filenamee = $uploadsDir.'/'.$job_name.'_'.date("d-m-Y").'.xls';
                   $filenameUrl = $uploadsDirUlr.'/'.$job_name.'_'.date("d-m-Y").'.xls';
				} else if (!empty($filename)) {
                    if($filename)
                    {
                        $empty_filename= $filename;
                    }
					$filenamee = $uploadsDir.'/'.$empty_filename.'.xls';
                    $filenameUrl = $uploadsDirUlr.'/'.$empty_filename.'.xls';
				}
				 $handle = fopen($filenamee, 'w');
				 $headingData = array();
                if(isset($opt['full_name']) && $opt['full_name'] == 'true') {
                   $headingData[] = "Candidate Name";
                }
                if(isset($opt['total_experience_in_year']) && $opt['total_experience_in_year'] == 'true') {
                    $headingData[] = "Experience in Years";
                }
                if(isset($opt['hirextra_ai_job_match']) && $opt['hirextra_ai_job_match'] == 'true') {
                    $headingData[] = "Hirextra AI JobMatch";
                }
                if(isset($opt['summary']) && $opt['summary'] == 'true') {
                    $headingData[] = "Summary";
                }
                if(isset($opt['status']) && $opt['status'] == 'true') {
                    $headingData[] = "Status";
                }
                if(isset($opt['mobile']) && $opt['mobile'] == 'true') {
                    $headingData[] = "Mobile";
                }
                if(isset($opt['email']) && $opt['email'] == 'true') {
                    $headingData[] = "Email";
                }
                if(isset($opt['location']) && $opt['location'] == 'true') {
                     $headingData[] = "Location";
                }
                if(isset($opt['averate_stay']) && $opt['averate_stay'] == 'true') {
                    $headingData[] = "Average Stay";
                }
                if(isset($opt['LongestStay']) && $opt['LongestStay'] == 'true') {
                    $headingData[] = "Longest Stay";
                }
                if(isset($opt['gaps']) && $opt['gaps'] == 'true') {
                   $headingData[] = "Gaps";
                }
                if(isset($opt['recruiters']) && $opt['recruiters'] == 'true') {
                    $headingData[] = "Recruiter";
                }
                if(isset($opt['note']) && $opt['note'] == 'true') {
                    $headingData[] = "Note";
                }
                if(isset($opt['skill_scan']) && $opt['skill_scan'] == 'true') {
                     $headingData[] = "Skill Scan";
                }
                if(isset($opt['talent_mining']) && $opt['talent_mining'] == 'true') {
                    $headingData[] = "Talent Mining";
                }
                if(isset($opt['employer_spec']) && $opt['employer_spec'] == 'true') {
                    $headingData[] = "Employer Spec";
                }


                fputcsv($handle, $headingData, "\t");

if(is_array($candidateInfo) && count($candidateInfo)>0) {
            $candDataInfo = array();

            foreach($candidateInfo as $key => $candInfo) {
                $candData = array();
               
                if(isset($opt['full_name'])  && $opt['full_name'] == 'true') {
                    $candData[] = $candInfo['candidate']['full_name'];
                    
                }
                if(isset($opt['total_experience_in_year'])  && $opt['total_experience_in_year'] == 'true') {
                    $candData[] = $candInfo['candidate']['total_experience_in_year'];
                   
                }
                if(isset($opt['hirextra_ai_job_match']) && $opt['hirextra_ai_job_match'] == 'true') {
                    $candData[] = $candInfo['candidate_points']['over_all_status'];
                   
                }
                if(isset($opt['summary']) && $opt['summary'] == 'true') {
                    $candData[] = $candInfo['candidate']['summary'];
                    
                }
                if(isset($opt['status']) && $opt['status'] == 'true') {
                    $candData[] = $candInfo['status']['name'];
                   
                }
                if(isset($opt['mobile']) && $opt['mobile'] == 'true') {
                    $candData[] = $candInfo['candidate']['mobile'];
                   
                }
                if(isset($opt['email']) && $opt['email'] == 'true') {
                    $candData[] = $candInfo['candidate']['email'];
                   
                }
                if(isset($opt['location']) && $opt['location'] == 'true') {
                    $candData[] = $candInfo['candidate']['current_location'];
                   
                }
                if(isset($opt['averate_stay']) && $opt['averate_stay'] == 'true') {
                    $candData[] = $candInfo['candidate_details']['averageStay'];
                   
                }
                if(isset($opt['LongestStay']) && $opt['LongestStay'] == 'true') {
                    $candData[] = $candInfo['candidate_details']['LongestStay'];
                   
                }
                if(isset($opt['gaps']) && $opt['gaps'] == 'true') {
                    $candData[] = $candInfo['candidate_details']['gapperiod'];
                    
                }
                if(isset($opt['recruiters']) && $opt['recruiters'] == 'true') {
                    $candData[] = $candInfo['vendor']['first_name'].' '.$candInfo['vendor']['last_name'];
                   
                }
                if(isset($opt['note']) && $opt['note'] == 'true') {
                    $candData[] = $candInfo['candidate']['note'];
                   
                }
                if(isset($opt['skill_scan']) && $opt['skill_scan'] == 'true') {
                    $candData[] = $_SERVER['HTTP_ORIGIN']."/#/resumematch/".base64_encode($candInfo['candidate']['id']);
                   
                }
                if(isset($opt['talent_mining']) && $opt['talent_mining'] == 'true') {
                    $candData[] = $_SERVER['HTTP_ORIGIN']."/#/Emp-Job-Order-View/".base64_encode($job_id);
                    
                }
                if(isset($opt['employer_spec']) && $opt['employer_spec'] == 'true') {
                    $candData[] = $_SERVER['HTTP_ORIGIN']."/#/Job-Order-View/".base64_encode($job_id);
                    
                }
                fputcsv($handle, $candData, "\t");
 
                $candDataInfo[] = $candData;
            }
            
         
}


fclose($handle);


return array('fileUrl'=> asset($filenameUrl));
	
}

        public function getPredefineven($job_id)
    {
        $authuser = Auth::user();
       if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $predefineven = GdprData::where('job_id', $job_id)->where('vendor_id', $authuser->parent_id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
               foreach ($predefineven as $key => $value) {
            $preDefinedQues = DB::table('predefined_questions_answers')->where('job_id', $value->job_id)->where('candidate_id', $value->candidate_id)->get();
           $value['Predefinedquestionsanswers'] = $preDefinedQues;
        }

        } else {
            $authId = $authuser->id;
            $predefineven = GdprData::where('job_id', $job_id)->where('vendor_id', $authuser->id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();

        foreach ($predefineven as $key => $value) {
            $preDefinedQues = DB::table('predefined_questions_answers')->where('job_id', $value->job_id)->where('candidate_id', $value->candidate_id)->get();
           $value['Predefinedquestionsanswers'] = $preDefinedQues;
        }
        }
         
        return response()->success($predefineven);
    }
    
       public function getEmppredefineddata()
    {
        $authuser = Auth::user();
        $empjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('gdprmandatory', 1)->get();
        $empjobids = array();
        foreach ($empjobs as $job) {
            array_push($empjobids, $job->id);
        }
        $empgdprdatas = Association::whereIn('job_id', $empjobids)
            ->where('employer_id', $authuser->id)
            ->whereNotIn('candidate_status', [2, 1, 19])
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')->with('candidate')->with('job')
            ->get();
             $empgdprdatas ->map(function($q) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $q->job_id);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $q->candidate_id);
                $eempgdprdataa = DB::table('job_orders_question_answers')->where('job_id', $q->job_id)->get();
                $gdpr = GdprData::where('candidate_id', $q->candidate_id)
                                ->where('job_id', $q->job_id)
                                ->get()->toArray();
                $eempgdprdata = DB::table('predefined_questions_answers')->where('job_id', $q->job_id)->where('candidate_id', $q->candidate_id)->get();
                 $localArray = array('encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'emppredefineddata' => $eempgdprdata, 'GdprData' => $gdpr);
                                $q->numbers = $localArray;
             });
            $empgdprdatas =  $empgdprdatas->filter(function ($item, $key) {
                    return count($item->numbers['emppredefineddata'])> 0;
            });
            $emppredefineddata = array();
            foreach ($empgdprdatas as $empgdprdataItem) {
                $emppredefineddata[]=$empgdprdataItem;
            }
       return response()->success(compact('emppredefineddata'));
    }

    public function getAmpredefineddata()
    {
         $authuser = Auth::user();
         $empjobs = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->groupBy('job_id')
            ->get(['job_id']);
       $empjobids = array();
        foreach ($empjobs as $jobdata) {
            array_push($empjobids, $jobdata->job_id);
        }
        $empgdprdatas = Association::whereIn('job_id', $empjobids)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotIn('candidate_status', [2, 1])
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')->with('candidate')->with('job')
            ->get();

             $empgdprdatas ->map(function($q) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $q->job_id);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $q->candidate_id);
                $eempgdprdata = DB::table('job_orders_question_answers')->where('job_id', $q->job_id)->get();
                $gdpr = GdprData::where('candidate_id', $q->candidate_id)
                                ->where('job_id', $q->job_id)
                                ->get()->toArray();
                $ampredefined = DB::table('predefined_questions_answers')->where('job_id', $q->job_id)->where('candidate_id', $q->candidate_id)->get();
                 $localArray = array('encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'ampredefineddata' => $eempgdprdata, 'GdprData' => $gdpr,'statuspredefined' =>$ampredefined);
                                $q->numbers = $localArray;
             });
            $empgdprdatas =  $empgdprdatas->filter(function ($item, $key) {
                    return count($item->numbers['ampredefineddata'])> 0;
            });
            $ampredefineddata = array();
            foreach ($empgdprdatas as $empgdprdataItem) {
                $ampredefineddata[]=$empgdprdataItem;
            }
        return response()->success(compact('ampredefineddata'));
    }
	
}//Dashboard controller
 