<?php

namespace App\Http\Controllers;

use App\Models\EmployerQuestion;
use App\Models\JobOrdersQuestionAnswer;
use DB;
use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\JobCitys;
use App\Activity;
use App\EmployerUserJobs;
use App\VendorUserJob;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use App\Talentpools;
use App\TalentpoolSkill;
use App\TalentpoolLocation;
use App\TalentpoolRequests;
use Illuminate\Http\Request;
use Input;
use Validator;
use DateTime;
use DateInterval;
use date_add;
use date_interval_create_from_date_string;
use App\UserAssociation;
use App\VendorActivities;
use App\JobUsers;
use App\JobResumes;
use App\VendorChecklists;
use App\EmployerChecklists;
use App\SegregatedSkill;
use App\UniversityGroup;
use App\ManagementWord;
use App\Models\WorldTopCompany;
use App\Models\TalentMine;
use App\Models\WorldUniversity;
use App\CandidateApiInfo;
use App\Recommendations;
use App\EmailInfo;
use App\SegregatedPublication;
use App\SegregatedCertification;
use App\CandidateAchievements;
use App\Candidate;
use App\CandidateSkillsets;
use App\CandidateOperationalSkills;
use App\CandidateSkills;
use App\CandidateExperiences;
use App\BellNotifications;
use App\CandidatePoints;
use App\CandidateEducations;
use App\CandidateSoftSkills;
use App\Company;
use App\JobSkills;
use App\Jobtitle;
use App\GdprData;
use App\City;
use App\Country;
use App\Association;
use App\Reason;
use App\Status;
use App\Industry;
use App\Language;
use App\Colors;
use App\JobLanguage;
use App\Pricing;
use App\EducationQualification;
use App\EducationAssociations;
use App\VendorRevenue;
use App\VendorRevenueRule;
use App\SharableUrls;
use App\VendorUserSetting;
use App\ShareLinkActivitys;
use Mail;
use App\Models\ClearBitCompany;
use GuzzleHttp\Client;
use Carbon\Carbon;
use App\VendorCandidateNotes;
use App\ReferFriends;
use App\DeviationRequests;
use App\Employeespectrums;
use App\CompaniesEmployer;
use App\SoftSkills;
use App\CollageNames;
use App\ActionWords;
use App\Http\Controllers\RchilliController;
use App\Models\SkillblockResume;
use App\CandidateDetails;
use App\Continents;
use App\Predefinedquestionsanswers;
use Cache;

class JobOrderController extends Controller
{
    public function getDecryption($id)
    {
        $authuser = Auth::user();
        $decryption = base64_decode($id);
        return response()->success(compact('decryption'));
    }
 
    public function getCandidateiddecryption($id)
    {
        $authuser = Auth::user();
        $candidateiddecryption = base64_decode($id);
        return response()->success(compact('candidateiddecryption'));
    }

    public function getCandidatestatusdecryption($id)
    {
        $authuser = Auth::user();
        $candidatestatusdecryption = base64_decode($id);
        return response()->success(compact('candidatestatusdecryption'));
    }

    public function getIndex()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $authId = null;
            if ($authuser->parent_id) {
                $authId = $authuser->parent_id;
            } else {
                $authId = $authuser->id;
            }
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $joborders = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($joborders as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            }//foreach
        } else {
            $joborders = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($joborders as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            } // foreach
        } //else
        return response()->success(compact('joborders'));
    }

    public function getEmployerjobsfirst($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = null;
            if ($authuser->parent_id) {
                $authId = $authuser->parent_id;
            } else {
                $authId = $authuser->id;
            }
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $employerjobsfirst = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($employerjobsfirst as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            }//foreach
        } else {
            $employerjobsfirst = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($employerjobsfirst as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            } // foreach
        } //else
        return response()->success(compact('employerjobsfirst'));
    }

    public function postSendsms()
    {
        $authuser = Auth::user();
        if (Input::get('count_no') == 1) {
            $can_id = Input::get('candidate_id');
            $job_id = Input::get('job_id');
            $number = str_replace("+91", "", Input::get('can_id'));
            $number = str_replace("91-", "", Input::get('can_id'));
            $number = str_replace("-", "", $number);
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $canId = Candidate::select('full_name')->where('id', $can_id)->get();
            $candidate_name = $canId[0]->full_name;
            $jobId = JobOrders::select('name')->where('id', $job_id)->get();
            $job_name = $jobId[0]->name;
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hi " . $candidate_name . " ,Your application through your Recruiter for " . $job_name . " position is in-progress with Hirextra!You are important to us and we will get back to you as soon as we have information on your candidature. Thanks for your patience!-Hirextra Team.";
            /*$msgtxt="Hey There! We would like to congratulate you on reaching this far with HireXtra.com and we would like to keep interacting with you so that you are truly enjoying the HireXtra Process - The HireXtra Team :)".$association_info[0]->job->name;*/
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            return response()->success("Successfully Submitted. ");
        }
        if (Input::get('count_no') == 2) {
            $can_id = Input::get('candidate_id');
            $job_id = Input::get('job_id');
            $number = str_replace("+91", "", Input::get('can_id'));
            $number = str_replace("91-", "", Input::get('can_id'));
            $number = str_replace("-", "", $number);
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $canId = Candidate::select('full_name')->where('id', $can_id)->get();
            $candidate_name = $canId[0]->full_name;
            $jobId = JobOrders::select('name')->where('id', $job_id)->get();
            $job_name = $jobId[0]->name;
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hi " . $candidate_name . " ,Your application through your Recruiter for " . $job_name . " position is in-progress with Hirextra! We are looking for more such talented individuals like you. Refer your friends, email their details to support@hirextra.com . Thanks, Hirextra Team.";
            /*$msgtxt="Hey There! This is HireXtra.com we are happy to see that you are enjoying the hirextra journey and we would like to  see if any of your buddies are interested in any of our open positions https://www.hirextra.com/jobs.php Please do share to all your buddies :)".$canId;*/
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            return response()->success("Successfully Submitted. ");
        }
        if (Input::get('count_id') == 3) {
            $number = str_replace("+91", "", Input::get('candidate_id'));
            $number = str_replace("91-", "", Input::get('candidate_id'));
            $number = str_replace("-", "", $number);
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = Input::get('name') . " Regards-HireXtra Team";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            return response()->success("Successfully Submitted. ");
        }
        if (Input::get('count_id') == 4) {
            $can_id = Input::get('cand_id');
            $job_id = Input::get('job_id');
            $vendor_id = Input::get('vendor_id');
            $number = str_replace("+91", "", Input::get('candidate_id'));
            $number = str_replace("91-", "", Input::get('candidate_id'));
            $number = str_replace("-", "", $number);
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $canId = Candidate::select('full_name')->where('id', $can_id)->get();
            $candidate_name = $canId[0]->full_name;
            $jobId = JobOrders::select('name')->where('id', $job_id)->get();
            $job_name = $jobId[0]->name;
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = Input::get('name');
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            return response()->success("Successfully Submitted Thanks. ");
        }
    }

    public function getJobordersdata()
    {
        $authuser = Auth::user();
        $jobordersdata = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->get();
        foreach ($jobordersdata as $job) {
            $receivedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(17, 26))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('jobordersdata'));
    }

    public function getQualifications()
    {
        $qualifications = EducationQualification::all();
        return response()->success(compact('qualifications'));
    }

    public function getIndustries()
    {
        $industries = Industry::whereNotNull('name')->get();
        return response()->success(compact('industries'));
    }

    public function getLanguages()
    {
        $languages = Language::all();
        return response()->success(compact('languages'));
    }

    public function getEducations()
    {
        $educations = EducationQualification::all();
        return response()->success(compact('educations'));
    }

    public function getFilterjobsaccepted($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsaccepted = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('user_id', $authuser->parent_id)->where('status', 3)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsaccepted as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobsaccepted = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('status', 3)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsaccepted as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsaccepted'));
    }

    public function getFilterjobsacceptedall()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsacceptedall = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 3)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsacceptedall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobsacceptedall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 3)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsacceptedall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsacceptedall'));
    }

    public function getFilterjobsall()
    {
        $authuser = Auth::user();
        $filterjobsall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->get();
        return response()->success(compact('filterjobsall'));
    }

    public function getFilterjobspending($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobspending = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('user_id', $authuser->parent_id)->where('status', 4)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobspending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobspending = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('status', 4)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobspending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobspending'));
    }

    public function getFilterjobspendingall()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobspendingall = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 4)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobspendingall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobspendingall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 4)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobspendingall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobspendingall'));
    }

    public function getEmployerholdjobs($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_user_job_ids = $jobids = array();
            foreach ($empActIds as $job) {
                array_push($emp_user_job_ids, $job);
            }
            $employerholdjobs = Association::whereIn('job_id', $emp_user_job_ids)->where('created_at', '>=', $diff_date)
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status', 'job_id')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->get();
            foreach ($employerholdjobs as $job) {
                array_push($jobids, $job->job_id);
            }
            $employerholdjobs = JobOrders::whereIn('id', $jobids)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)
                ->where('status', 24)
                ->with(array('JobType', 'company', 'Industry', 'status'))
                ->get();
            foreach ($employerholdjobs as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $jobids = array();
            $employerholdjobs = Association::whereNotNull('job_id')->where('created_at', '>=', $diff_date)
                ->where('employer_id', $authuser->id)
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->get();
            foreach ($employerholdjobs as $job) {
                array_push($jobids, $job->job_id);
            }
            $employerholdjobs = JobOrders::whereIn('id', $jobids)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 24)
                ->with(array('JobType', 'company', 'Industry', 'status'))
                ->get();
            foreach ($employerholdjobs as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } // else
        return response()->success(compact('employerholdjobs'));
    }

    public function getEmployerholdjobsall()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_user_job_ids = $jobids = array();
            foreach ($empActIds as $job) {
                array_push($emp_user_job_ids, $job);
            }
            $employerholdjobsall = Association::whereIn('job_id', $emp_user_job_ids)
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status', 'job_id')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->get();
            foreach ($employerholdjobsall as $job) {
                array_push($jobids, $job->job_id);
            }
            $employerholdjobsall = JobOrders::whereIn('id', $jobids)->where('is_talentpool', 0)
                ->where('status', 24)
                ->with(array('JobType', 'company', 'Industry', 'status'))
                ->get();
            foreach ($employerholdjobsall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $jobids = array();
            $employerholdjobsall = Association::whereNotNull('job_id')
                ->where('employer_id', $authuser->id)
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->get();
            foreach ($employerholdjobsall as $job) {
                array_push($jobids, $job->job_id);
            }
            $employerholdjobsall = JobOrders::whereIn('id', $jobids)->where('is_talentpool', 0)
                ->where('status', 24)
                ->with(array('JobType', 'company', 'Industry', 'status'))
                ->get();
            foreach ($employerholdjobsall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } // else
        return response()->success(compact('employerholdjobsall'));
    }

    public function getFilterjobsinactive($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsinactive = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('user_id', $authuser->parent_id)->where('status', 7)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinactive as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobsinactive = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('status', 7)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinactive as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsinactive'));
    }

    public function getFilterjobsinactiveall()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsinactiveall = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 7)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinactiveall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobsinactiveall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 7)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinactiveall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsinactiveall'));
    }

    public function getFilterjobsinprogress($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = null;
            if ($authuser->parent_id) {
                $authId = $authuser->parent_id;
            } else {
                $authId = $authuser->id;
            }
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsinprogress = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogress as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            }
        } else {
            $filterjobsinprogress = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('status', 8)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogress as $job) {
                $amIdData = Association::where('job_id', $job['id'])
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->whereNull('vendor_id')
                    ->get(['accountmanager_id']);
                if (count($amIdData) >= 1) {
                    $amId = Association::where('job_id', $job['id'])
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('candidate_id')
                        ->whereNull('vendor_id')
                        ->first()->accountmanager_id;
                    $candidates = Association::where('job_id', $job['id'])
                        ->where('candidate_status', '<>', 19)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($candidates as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $activityes = Activity::where('activity_by', $amId)->where('job_id', $job['id'])->whereIn('candidate_status', array(1, 2))->get();
                    $activityData = array();
                    foreach ($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);
                    }
                    $assingedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->with(array('Status', 'Candidate'))
                        ->count();
                    $rejectedids = Association::where('job_id', $job['id'])
                        ->whereIn('candidate_status', array(1, 2, 30))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status', 'Candidate'))
                        ->get();
                    $associationsIds = array();
                    foreach ($rejectedids as $candidate) {
                        if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                            array_push($associationsIds, $candidate->id);
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id', $associationsIds)
                        ->whereNotIn('candidate_id', $activityData)
                        ->count();
                    $shortlistedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $selectedcandidates = Association::where('job_id', $job['id'])->whereNotIn('candidate_id', $activityData)
                        ->whereIn('candidate_status', [27, 28])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->count();
                    $offeredProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(27, 28))
                        ->count();
                    $interviwedProfiles = Association::where('job_id', $job['id'])
                        ->where('employer_id', $authuser->id)
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('vendor_id')
                        ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                        ->count();
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => $assingedcandidates, 'rejectedProfiles' => $rejectedcandidates, 'shortlistedProfiles' => $shortlistedcandidates, 'selectedcandidates' => $selectedcandidates, 'encrypted_jobId' => $encrypted, 'offeredProfiles' => $offeredProfiles, 'interviwedProfiles' => $interviwedProfiles];
                    $job['numbers'] = $numbers;
                } else {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived' => 0, 'rejectedProfiles' => 0, 'shortlistedProfiles' => 0, 'offeredProfiles' => 0, 'holdProfiles' => 0, 'interviwedProfiles' => 0, 'encrypted_jobId' => $encrypted];
                    $job['numbers'] = $numbers;
                }
            }
        }
        return response()->success(compact('filterjobsinprogress'));
    }

    public function getFilterjobsinprogressall()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsinprogressall = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 8)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogressall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $filterjobsinprogressall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 8)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogressall as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsinprogressall'));
    }

    public function getFilterjobsclosed($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsclosed = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('user_id', $authuser->parent_id)->where('status', 6)->with('status')->with('JobType')->with('Industry')->get();
        } else {
            $filterjobsclosed = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->where('status', 6)->with('status')->with('JobType')->with('Industry')->get();
        }
        foreach ($filterjobsclosed as $job) {
            $commentData = Activity::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->where('job_status', 6)
                ->where('activity_by', $authuser->id)
                ->get(['note']);
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
            $receivedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(17, 26))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'commentData' => $commentData];
            $job['numbers'] = $numbers;
        }//foreach
        return response()->success(compact('filterjobsclosed'));
    }

    public function getFilterjobsclosedall()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $filterjobsclosedall = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 6)->with('status')->with('JobType')->with('Industry')->get();
        } else {
            $filterjobsclosedall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 6)->with('status')->with('JobType')->with('Industry')->get();
        }
        foreach ($filterjobsclosedall as $job) {
            $commentData = Activity::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->where('job_status', 6)
                ->where('activity_by', $authuser->id)
                ->get(['note']);
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
            $receivedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(17, 26))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['id'])
                ->where('employer_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'commentData' => $commentData];
            $job['numbers'] = $numbers;
        }//foreach
        return response()->success(compact('filterjobsclosedall'));
    }

    public function getJobsrejectedbyempam($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_usr_ids = array();
            foreach ($empActIds as $job) {
                array_push($emp_usr_ids, $job);
            }
            $jobsrejectedbyempam = JobOrders::whereIn('id', $emp_usr_ids)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)
                ->where('user_id', $authId)
                ->where('status', 2)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->get();
            foreach ($jobsrejectedbyempam as $job) {
                $accountmanager_id = Association::where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->whereNotNull('accountmanager_id')
                    ->where('job_id', intval($job['id']))
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $commentData = Activity::where('job_id', $job['id'])
                    ->where('admin_id', 1)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->where('activity_by', $accountmanager_id)
                    ->where('is_vendor_sourcing_activity', 0)
                    ->whereNotNull('comment')
                    ->whereNotNull('name')
                    ->whereNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->whereNull('job_status')
                    ->whereNull('candidate_id')
                    ->whereNull('candidate_status')
                    ->whereNull('note')
                    ->whereNull('reason_id')
                    ->whereNull('status_id')
                    ->whereNull('resume_id')
                    ->whereNull('requirement_id')
                    ->whereNull('company_id')
                    ->whereNull('vendor_checklist_id')
                    ->first()->comment;
                $note_data = ['note' => $commentData];
                $job['note'] = $note_data;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } else {
            $jobsrejectedbyempam = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)
                ->where('status', 2)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->get();
            foreach ($jobsrejectedbyempam as $job) {
                $accountmanager_id = Association::where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->whereNotNull('accountmanager_id')
                    ->where('job_id', intval($job['id']))
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $commentData = Activity::where('job_id', $job['id'])
                    ->where('admin_id', 1)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->where('activity_by', $accountmanager_id)
                    ->where('is_vendor_sourcing_activity', 0)
                    ->whereNotNull('comment')
                    ->whereNotNull('name')
                    ->whereNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->whereNull('job_status')
                    ->whereNull('candidate_id')
                    ->whereNull('candidate_status')
                    ->whereNull('note')
                    ->whereNull('reason_id')
                    ->whereNull('status_id')
                    ->whereNull('resume_id')
                    ->whereNull('requirement_id')
                    ->whereNull('company_id')
                    ->whereNull('vendor_checklist_id')
                    ->first()->comment;
                $note_data = ['note' => $commentData];
                $job['note'] = $note_data;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } // else
        return response()->success(compact('jobsrejectedbyempam'));
    }

    public function getJobsrejectedbyempamall()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_usr_ids = array();
            foreach ($empActIds as $job) {
                array_push($emp_usr_ids, $job);
            }
            $jobsrejectedbyempamall = JobOrders::whereIn('id', $emp_usr_ids)->where('is_talentpool', 0)
                ->where('user_id', $authId)
                ->where('status', 2)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->get();
            foreach ($jobsrejectedbyempamall as $job) {
                $accountmanager_id = Association::where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->whereNotNull('accountmanager_id')
                    ->where('job_id', intval($job['id']))
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $commentData = Activity::where('job_id', $job['id'])
                    ->where('admin_id', 1)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->where('activity_by', $accountmanager_id)
                    ->where('is_vendor_sourcing_activity', 0)
                    ->whereNotNull('comment')
                    ->whereNotNull('name')
                    ->whereNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->whereNull('job_status')
                    ->whereNull('candidate_id')
                    ->whereNull('candidate_status')
                    ->whereNull('note')
                    ->whereNull('reason_id')
                    ->whereNull('status_id')
                    ->whereNull('resume_id')
                    ->whereNull('requirement_id')
                    ->whereNull('company_id')
                    ->whereNull('vendor_checklist_id')
                    ->first()->comment;
                $note_data = ['note' => $commentData];
                $job['note'] = $note_data;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } else {
            $jobsrejectedbyempamall = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 2)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->get();
            foreach ($jobsrejectedbyempamall as $job) {
                $accountmanager_id = Association::where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->whereNotNull('accountmanager_id')
                    ->where('job_id', intval($job['id']))
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $commentData = Activity::where('job_id', $job['id'])
                    ->where('admin_id', 1)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->where('employer_id', JobOrders::where('id', intval($job['id']))->first()->user_id)
                    ->where('activity_by', $accountmanager_id)
                    ->where('is_vendor_sourcing_activity', 0)
                    ->whereNotNull('comment')
                    ->whereNotNull('name')
                    ->whereNull('vendor_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->whereNull('job_status')
                    ->whereNull('candidate_id')
                    ->whereNull('candidate_status')
                    ->whereNull('note')
                    ->whereNull('reason_id')
                    ->whereNull('status_id')
                    ->whereNull('resume_id')
                    ->whereNull('requirement_id')
                    ->whereNull('company_id')
                    ->whereNull('vendor_checklist_id')
                    ->first()->comment;
                $note_data = ['note' => $commentData];
                $job['note'] = $note_data;
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->count();
                $rejectedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', [1, 2, 30])
                    ->count();
                $shorlistedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(17, 26))
                    ->count();
                $offeredProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(27, 28))
                    ->count();
                $holdProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereBetween('candidate_status', array(24, 26))
                    ->count();
                $interviwedProfiles = Association::where('job_id', $job['id'])
                    ->where('employer_id', $authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                    ->count();
                $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } // else
        return response()->success(compact('jobsrejectedbyempamall'));
    }

    public function getFilterjobsadminclosed()
    {
        $authuser = Auth::user();
        $filterjobsadminclosed = JobOrders::where('status', 6)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->get();
        foreach ($filterjobsadminclosed as $job) {
            $commentData = Activity::where('job_id', $job['id'])
                ->where('candidate_status', 6)
                ->get();
            $numbers = ['note' => $commentData];
            $job['note'] = $numbers;
        }//foreach
        return response()->success(compact('filterjobsadminclosed'));
    }

    public function getFilterprofilesselected()
    {
        $authuser = Auth::user();
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobids = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
        }
        $filterprofilesselected = Association::whereIn('job_id', $empjobids)
            ->whereIn('candidate_status', [27, 28])
            ->where('employer_id', $authId)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('job_id')->with('job')
            ->with(array('Status', 'Candidate'))
            ->get();
        foreach ($filterprofilesselected as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('filterprofilesselected'));
    }

    public function getEmpprofilesreceived()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $empprofilesreceived = Association::whereIn('job_id', $empActIds)
                ->where('employer_id', $authuser->parent_id)
                ->whereNotIn('candidate_status', [2, 1, 19])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                ->get();
            foreach ($empprofilesreceived as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId];
                $job['numbers'] = $numbers;
            }
        } else {
            $empjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->get();
            $empjobids = array();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $empprofilesreceived = Association::whereIn('job_id', $empjobids)
                ->where('employer_id', $authuser->id)
                ->whereNotIn('candidate_status', [2, 1, 19])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
                ->get();
            foreach ($empprofilesreceived as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('empprofilesreceived'));
    }

    public function getEmpprofilesrejected()
    {
        $authuser = Auth::user();
        $authId = null;
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobids = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $empprofilesrejected = Association::whereIn('job_id', $empjobids)
            ->whereNotIn('candidate_id', $activityData)
            ->where('employer_id', $authId)
            ->whereIn('candidate_status', [2, 1, 30])
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')
            ->get();
        foreach ($empprofilesrejected as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('empprofilesrejected'));
    }

//Job order is getting created here @neyaz

   public function postJoborders()
    {  
        $authuser = Auth::user();
        $authId = null;
        $employerName = $authuser->first_name;
        $employerEmail = $authuser->email;
        
        $file_names = array();
        if(Input::hasFile('resumes')) { 
            foreach(Input::hasFile('resumes') as $file)
            {
                $fileName = time().rand(0, 1000).pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
                $fileName = $fileName.'.'.$file->getClientOriginalExtension();
                $file->move(public_path('resumes\\'), $fileName);
                $file_names[] = $fileName;
            }
        }         

        if($authuser->parent_id){$authId = $authuser->parent_id;}

            else {$authId = $authuser->id;}

            $salaryType = Input::get('salaryType');
            $job_type_new = Input::get('job_type_new');
            $cityPin = Input::get('cityPin');
            $city_ids = array();
            if(is_array($cityPin) && count($cityPin)>0) {
                foreach($cityPin as $key=>$value) {
                    $city_ids[] = $value['id'];
                }
            }

           $continentsId = !empty(Input::get('continents_id'))?(Input::get('continents_id')): null ;
            {
            $continents = Input::get('continents_id');
            $continents_id = array();
            if(is_array($continents) && count($continents)>0) {
                foreach($continents as $key=>$value) {
                    $continents_id[] = $value;
                }
                 $continentsId = $continents_id[0];
            }
            }
            $travel_percent_v=Input::get('travel_percent');
            $travel_percent_value=str_replace("%", "", $travel_percent_v);
            if (Input::get('job_type_id') == 1) {

                $salaryMax = Input::get('salaryInput');

                $salaryMin = Input::get('salaryInputMin');

                if($salaryType=='Per Year')

                {

                    $salaryMax = $salaryMax * 1;

                    $salaryMin = $salaryMin * 1;

                    $salaryType = "Per Year";

                }
                $gdprmain = Input::get('gdpr');
                if(is_null($gdprmain))
                {
                    $gdprmain = "2";
                }
        
                $bind_hire = Input::get('blindhire');
                // print_r($bind_hire);
                // die;
                if(empty($bind_hire))
                {

                    $bind_hire = "1";
                } 
                
                $JobOrders = JobOrders::create([
                    'name' => Input::get('name'),
                    'currency' => Input::get('currency'),
                    'salary' => $salaryMax,
                    'salary_min' => $salaryMin,
                    'level' => Input::get('level'),
                    'salaryType' => $salaryType,
                    'experience' => Input::get('experience'),
                    'experience_to' => Input::get('experience_to'),
                    'vacancies' => Input::get('vacancies'),
                    'educationLevel' => '',
                    /*'experiencetype' => Input::get('experienceType'),*/
                    'language_id' => '',
                    'industry_id' => 0,
                    'deadline' => Input::get('deadline'),
                    'job_type_id' => Input::get('job_type_id'),
                    'user_id' => $authId,
                    'requirement_id' => 1,
                    'status' => 7,
                    'gdprmandatory' => 1,
                    'job_internal_code' => Input::get('internalCode'),
                    'description' => Input::get('description'),
                    'skills_preferred' => Input::get('preferredSkills'),
                    'skills_required' => Input::get('requiredSkills'),
                    'is_private' => Input::get('is_private'),
                    'joborder_number' => '',
                    'min_contract_term' => Input::get('min_contract_term'),
                    'max_contract_term' => Input::get('max_contract_term'),
                    'contract_term_type' => Input::get('contract_term_type'),
                    'is_talentpool' => Input::get('is_talentpool'),
                    'gdpr' => $gdprmain,
                    'notice_period'=>Input::get('notice_period'),
                    'expectedjoingdate' => date('Y-m-d',strtotime(Input::get('expectedjoingdate'))),
                    'work_autherization' => Input::get('workAuth'),
                    'freshers_apply' => Input::get('freshers'),
                    'questions' => Input::get('isQuestions'),
                    'open_to_travel' => Input::get('openTravel'),
                    'travel_percent' => $travel_percent_value,
                    'relocate'=>Input::get('relocate'),
                    'targated_company'=>Input::get('targated_company'),
                    'resumes'=>implode('~', $file_names),
                    'note'=>Input::get('note'),
                    'url'=>Input::get('url'),
                    'work_question'=>Input::get('work_question'),
                    'work_question_2'=>Input::get('work_question_2'),
                    'location_id' =>implode(',', $city_ids),
                    'job_type_new'=>$job_type_new,
                    'continents_id'=>$continentsId,
					'blindhire' =>$bind_hire

                ]);

            } else if (Input::get('job_type_id') == 2) {
                $bind_hire = Input::get('blindhire');
                if(is_null($bind_hire))
                {
                    $bind_hire = "1";
                }
                $am_billRate = Input::get('am_billRate');
                $vendor_billRate = Input::get('vendor_billRate');
                $billrate = Input::get('billRate');  
                $salaryType = Input::get('salaryType');
                $gdprmain = Input::get('gdpr');
                $JobOrders = JobOrders::create([
                    'name' => Input::get('name'),
                    'currency' => Input::get('currency'),
                    'billrate' => $billrate,
                    'am_billRate' => $am_billRate,
                    'vendor_billRate' => $vendor_billRate,
                    'level' => Input::get('level'),
                    'salaryType' => $salaryType,
                    'experience' => Input::get('experience'),
                    'experience_to' => Input::get('experience_to'),
                    'vacancies' => Input::get('vacancies'),
                    'educationLevel' => '',
                    'language_id' => '',
                    'industry_id' => 0,
                    'deadline' => Input::get('deadline'),
                    'job_type_id' => Input::get('job_type_id'),
                    'user_id' => $authId,
                    'requirement_id' => 1,
                    'status' => 7,
                    'gdprmandatory' => 1,
                    'notice_period'=>Input::get('notice_period'),
                    'job_internal_code' => Input::get('internalCode'),
                    'description' => Input::get('description'),
                    'skills_preferred' => Input::get('preferredSkills'),
                    'skills_required' => Input::get('requiredSkills'),
                    'is_private' => Input::get('is_private'),
                    'joborder_number' => '',
                    'min_contract_term' => Input::get('min_contract_term'),
                    'max_contract_term' => Input::get('max_contract_term'),
                    'contract_term_type' => Input::get('contract_term_type'),
                    'expectedjoingdate' => date('Y-m-d',strtotime(Input::get('expectedjoingdate'))),
                    'payment_mode' => Input::get('paymentMode'),
                    'gdpr' => $gdprmain,
                    'payment_terms' => Input::get('paymentTerms'),
                    'work_autherization'=>Input::get('workAuth'),
                    'freshers_apply'=>Input::get('freshers'),
                    'questions'=>Input::get('isQuestions'),
                    'open_to_travel'=>Input::get('openTravel'),
                    'travel_percent'=>$travel_percent_value,
                    'relocate'=>Input::get('relocate'),
                    'targated_company'=>Input::get('targated_company'),
                    'resumes'=>implode('~', $file_names),
                    'note'=>Input::get('note'),
                    'url'=>Input::get('url'),
                    'work_question'=>Input::get('work_question'),
                    'work_question_2'=>Input::get('work_question_2'),
                    'location_id' =>implode(',', $city_ids),
                    'job_type_new'=>$job_type_new,
                    'continents_id'=>$continentsId,
					'blindhire' =>$bind_hire

                ]);

            }

           $item = collect(Input::get('item'));
           $isQuestions = Input::get('isQuestions');
           if($isQuestions == "YES")
           {
                if (count($item) > 0) {
                 foreach ($item as $value) {

                $qALOcalArray = array();
                $qALOcalArray['job_id'] = $JobOrders->id;
                $qALOcalArray['question_id'] = $value['Q_id'];
                $qALOcalArray['user_id'] = Auth::id();
                $qALOcalArray['question_generate'] = $value['Q_description'];
                $qALOcalArray['answer'] = $value['is_must'];
                $qALOcalArray['original_queestions'] = $value['description'];
                $qALOcalArray['question_type'] = $value['type'];
                $qALOcalArray['flag'] = $value['flag'];
                JobOrdersQuestionAnswer::create($qALOcalArray);
            }
        }

           }
            if(Input::get('flag') == 1){
                $joborderData = ['status' => 4,];
                $actiavteJob = JobOrders::where('id', '=', intval($JobOrders->id))->where('is_talentpool',0)->update($joborderData);
            }

            $langIds = Input::get('languageId');
            if(count($langIds)){
                foreach ($langIds as $value) {
                    JobLanguage::create([
                        'language_id'=>$value['id'],
                        'job_id' => $JobOrders->id,
                    ]);
                }
            }

            $prefSkills=Input::get('preferredSkillsGraph');

            $reqSkills=Input::get('requiredSkillsGraph');

            if(count($prefSkills)) {

                foreach ($prefSkills as $value) {

                    JobSkills::create([

                        'skill_name'=>$value['text'],

                        'skill_percentage'=>$value['percentage'],

                        'skill_nooftimes'=>$value['noOfTimes'],

                        'is_requiredskill'=>0,

                        'job_id' => $JobOrders->id,

                    ]);

                }

            }

            if(count($reqSkills)) {

                foreach ($reqSkills as $value) {

                    JobSkills::create([

                        'skill_name'=>$value['text'],

                        'skill_percentage'=>$value['percentage'],

                        'skill_nooftimes'=>$value['noOfTimes'],

                        'is_requiredskill'=>1,

                        'job_id' => $JobOrders->id,

                    ]);

                }

            }

            $cityIds = collect(Input::get('cityPin'));
          
            if(count($cityIds)>0){

                foreach ($cityIds as $value) {

                    JobCitys::create([

                        'city_id'=>$value['id'],

                        'city_name'=>$value['name'],

                        'job_id' => $JobOrders->id,

                    ]);

                }

            }
            else{

            }

            $eduQual = Input::get('educationLevel');

            if(count($eduQual)){

                foreach ($eduQual as $qual) {

                    $id = isset($qual['id']) ? $qual['id'] : '';

                    if($id) {

                        EducationAssociations::create(['qualification_id'=>$qual['id'],'job_id' => $JobOrders->id]);

                    } else {

                        $newedu = EducationQualification::create(['qualification'=>$qual['name']]);

                        EducationAssociations::create(['qualification_id'=>$newedu->id,'job_id' => $JobOrders->id]);

                    }

                }

            }

            $company = Company::where('id',$authuser->company_id)->get();

            $city = City::where('id',$company[0]->city_id)->get();

            $country = Country::where('id',$city[0]->country_id)->get();

            $jobNumber = $country[0]->country_code.'-'.$authId.'-'.Input::get('internalCode').'-'.$JobOrders->id;



            $jobOrder = JobOrders::where('is_talentpool',0)->find($JobOrders->id);

            $jobOrder->joborder_number = $jobNumber;

            if( Input::get('industry') == 0 ) {

                $newindustry=Industry::create(['name'=> Input::get('custom_industry_name')]);

                $jobOrder->industry_id = $newindustry->id;

            }
             else 
            {
                $ind = Input::get('industry');
                if(isset($ind['id'])){
                $jobOrder->industry_id=$ind['id']; 
                }
                else{
                $jobOrder->industry_id=Input::get('industry');
                }

                
            }

            $jobOrder->save();

            $jobOrderNumberResponse=response()->success(compact('jobOrder'));

            $amassociation = Association::where('employer_id',$authId)

                                ->whereNotNull('accountmanager_id')

                                ->whereNull('vendor_id')

                                ->whereNull('employer_user_id')

                                ->whereNull('vendor_id')

                                ->whereNull('vendor_user_id')

                                ->whereNull('job_id')

                                ->whereNull('candidate_id')

                                ->first();

            $jobassociation = new Association();

            $jobassociation->admin_id = 1;

            $jobassociation->accountmanager_id = $amassociation->accountmanager_id;

            $jobassociation->employer_id = $authId;

            $jobassociation->job_id = $JobOrders->id;

            $jobassociation->status_updated_by = $authId;

            $jobassociation->save();

            
            if(Input::get('flag') == 1)

            {
        
                $job_id = $JobOrders->id;

                $job = JobOrders::where('id', '=', intval($job_id))->where('is_talentpool',0)->with('JobCitys')->with('JobType')->with('Industry')->get();

                $contract = $job[0]->JobType->name;

                $country = Country::where('id',intval(Input::get('countryId')))->first();

              

                $countryId = $country->id;

                $monthlyPay = $job[0]->salary_min;

                // by mukesh

                $countryPrices = Pricing::where('emp_id', $authId)

                            ->where('country_id',$countryId)

                            ->get();

                            
                
                $priceValue="";

                $flatPriceValue="";

                $flag=0;

                $created_at = date('Y-m-d h:i:s');

                if($job[0]->job_type_id != 2) {

                    foreach($countryPrices as $key =>$value){

                        

                        if($value->price!='8.33' && !empty($value->price) && $value->type_of_emp=="Flat Rate"){

           

                            $flatPriceValue = ($monthlyPay * $value->price)/100;

                            $flag=1;

                        } else {

                            

                            if($value->starting_range <= $monthlyPay && $value->ending_range >= $monthlyPay) {

                                $priceValue = ($monthlyPay * $value->price)/100;

                            }

                        }

                    }

                    if($flag==1) {

                        DB::insert("insert into vendor_accountmanager_share set job_id='".intval($job_id)."', vendor_accountmanager_original_price='".$flatPriceValue."',account_manager_price='".$flatPriceValue."', created_at='".$created_at."', updated_at='".$created_at."'");

                        DB::insert("insert into vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', job_id='".intval($job_id)."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");

                    } else {

                         DB::insert("insert into vendor_accountmanager_share set job_id='".intval($job_id)."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."'");

                        DB::insert("insert into vendor_pricing_revenue set permanent_price='".$priceValue."', job_id='".intval($job_id)."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");

                    }

                } else if($job[0]->job_type_id == 2){

                    $billrate = Input::get('billRate');

                    $salaryType = Input::get('salaryType');

                    

                    if($salaryType=='Per Year')

                    {

                        $yearlyPay = $billrate * 1;

                    }

                    else if($salaryType=='Per Month')

                    {

                        $yearlyPay = $billrate * 12;

                    }

                    else if($salaryType=='Per Week')

                    {

                        $yearlyPay = $billrate * 52;

                    }

                    else if($salaryType=='Per Day')

                    {

                        $yearlyPay = $billrate * 365;

                    }

                    else if($salaryType=='Per Hour')

                    {

                        $yearlyPay = $billrate * 8 * 365;

                    }

                    

                    $contractMonthlyPay = $yearlyPay / 12;

                    $priceValue = "";

                        

                    foreach($countryPrices as $ky => $val) {

                        if($val->type_of_emp=="Contract To Hire") {

                            $priceValue = round(($contractMonthlyPay * $val->price)/100);

                        }

                    }
                     DB::insert("insert into vendor_accountmanager_share set job_id='".intval($job_id)."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."'");
                    DB::insert("insert into vendor_pricing_revenue set contract_price='".$priceValue."', job_id='".intval($job_id)."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");

                    

                }

    

                if($authuser->parent_id){

                    $jobactivity = new Activity();

                    $jobactivity->name = "Job Created & Activated";

                    $jobactivity->admin_id = 1;

                    $jobactivity->accountmanager_id = $amassociation->accountmanager_id;

                    $jobactivity->employer_id = $authId;

                    $jobactivity->employer_user_id = $authuser->id;

                    $jobactivity->job_id = $JobOrders->id;

                    $jobactivity->activity_by = $authuser->id;

                    $jobactivity->save();



                    $empuserjobactivity = new EmployerUserJobs();

                    $empuserjobactivity->employer_id = $authId;

                    $empuserjobactivity->employer_user_id = $authuser->id;

                    $empuserjobactivity->job_id = $JobOrders->id;

                    $empuserjobactivity->save();

                } else {

                    $jobactivity = new Activity();

                    $jobactivity->name = "Job Created & Activated";

                    $jobactivity->admin_id = 1;

                    $jobactivity->accountmanager_id = $amassociation->accountmanager_id;

                    $jobactivity->employer_id = $authId;

                    $jobactivity->job_id = $JobOrders->id;

                    $jobactivity->activity_by = $authId;

                    $jobactivity->save();

                }

                //Email and SMS send functionality for job activation

                $amassociation = Association::where('employer_id',$authId)

                            ->whereNotNull('accountmanager_id')

                            ->where('job_id', intval($JobOrders->id))

                            ->whereNull('vendor_id')

                            ->with('accountmanager')

                            ->get();

                $hrs =date('H');

                $msg = "";

                //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early

                if ($hrs >  0) $msg = "Good morning";      // After 6am

                if ($hrs > 12) $msg = "Good afternoon";    // After 12pm

                if ($hrs > 17) $msg = "Good evening";      // After 5pm

                if ($hrs > 23) $msg = "Go to bed!";        // After 10pm

                foreach ($job[0]['JobCitys'] as $key => $value) {

                    if(!empty($cities)) {$cities=$cities.', '.$value['city_name'];    }

                    else { $cities=$value['city_name'];  }

                }

                $company = Company::select('name')->where('id',$authuser->company_id)->get();

                Mail::send('emails.reachingOutPersonally', ['msg' => $msg, 'name' => $amassociation[0]->accountmanager->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'employerName'=>$company[0]->name, 'CityPin' => $cities, 'toggle' => false], function ($m) use($amassociation){

                    $m->to($amassociation[0]->accountmanager->email, 'New job post')->subject('New Job in your account pocket.. Let\'s Bash It!');

                });

                

                $country = Country::where('is_enabled',1)->first();

                $number = $amassociation[0]->accountmanager->mobile;

                $city = \App\City::where('id',$authuser->city_id)->get();

                if(count($city) > 0) {

                    $country = Country::where('id',$city[0]->country_id)->get();

                    $countryCode = $country[0]->ISD_code;

                } else {

                    $countryCode = 91;

                }

                $ch = curl_init();

                $user="kv@hirextra.com";

                $password="Kumar786%";

                $receipientno = $countryCode.$number;

                $originator = "HireXtra";

                $msgtxt="Hello ".$amassociation[0]->accountmanager->first_name." Your employer ".$employerName. " posted a new Job ".$job[0]->name. " Please check your dashboard for further details.";



                curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");

                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

                curl_setopt($ch, CURLOPT_POST, 1);

                curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");

                $buffer = curl_exec($ch);

                $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                curl_close($ch);

                if($authuser->user_type!=1) {

                     Mail::send('emails.reachingOutPersonallyemp', ['msg' => $msg, 'name' => $employerName, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $cities, 'toggle' => false], function ($m) use($employerEmail){

                        $m->to($employerEmail, 'New job post')->subject('Gotcha! We’ve started Hiring!');

                    });

                }

                

            } //Input::get('flag') == 1



            if(Input::get('flag') == 0) {

                if($authuser->parent_id){

                    $jobactivity = new Activity();

                    $jobactivity->name = "Job Created";

                    $jobactivity->admin_id = 1;

                    $jobactivity->accountmanager_id = $amassociation->accountmanager_id;

                    $jobactivity->employer_id = $authId;

                    $jobactivity->employer_user_id = $authuser->id;

                    $jobactivity->job_id = $JobOrders->id;

                    $jobactivity->activity_by = $authuser->id;

                    $jobactivity->save();



                    $empuserjobactivity = new EmployerUserJobs();

                    $empuserjobactivity->employer_id = $authId;

                    $empuserjobactivity->employer_user_id = $authuser->id;

                    $empuserjobactivity->job_id = $JobOrders->id;

                    $empuserjobactivity->save();

                } else {

                    $jobactivity = new Activity();

                    $jobactivity->name = "Job Created";

                    $jobactivity->admin_id = 1;

                    $jobactivity->accountmanager_id = $amassociation->accountmanager_id;

                    $jobactivity->employer_id = $authId;

                    $jobactivity->job_id = $JobOrders->id;

                    $jobactivity->activity_by = $authId;

                    $jobactivity->save();

                }

            } //Input::get('flag') == 0

            $JobOrders =$JobOrders->id;



            return response()->success(compact('JobOrders'));

    }


    public function getJjoborderShow($id)
    {
        $authuser = Auth::user();
        $jjoborders = JobOrders::where('is_talentpool', 0)
            ->with('status')
            ->with('JobType')
            ->with('JobCitys')
            ->with('Industry')
            ->with('Education.educations')
            ->with('JobLanguages.languages')
            ->with('Industry')->find($id);
        $jjoborders['new_updated_at'] = $jjoborders->updated_at;
        $jjoborders['current_time'] = Carbon::now();
        return response()->success($jjoborders);
    }

    public function getFetchskillsgraph($id)
    {
        $authuser = Auth::user();
        $fetchskillsgraph = JobSkills::where('job_id', $id)->get();
        return response()->success($fetchskillsgraph);
    }

    public function getJobadminestimaterevenue($job_id)
    {
        $authuser = Auth::user();
        $jobadminestimaterevenue = VendorRevenue::where('job_id', $job_id)->get();
        return response()->success(compact('jobadminestimaterevenue'));
    }

    public function getAdmintimeline($job_id)
    {
        $authuser = Auth::user();
        $admintimeline = Activity::where('job_id', $job_id)
            ->where('is_vendor_sourcing_activity', 0)
            ->with(array('candidate', 'status'))->with('job')->get();
        return response()->success(compact('admintimeline'));
    }

    public function postClosejoborder()
    {
        $authuser = Auth::user();
        $authId = null;
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $joborderId = Input::get('job_id');
        $note = Input::get('closenote');
        $joborderData = [
            'status' => 6];
        $associationData = [
            'candidate_status' => 6,
            'note' => $note,
            'status_updated_by' => $authId
        ];
        $accountmanager_id = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->where('job_id', intval($joborderId))
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $closejoborder = JobOrders::where('id', $joborderId)->where('is_talentpool', 0)
            ->where('user_id', $authId)
            ->whereNotNull('status')
            ->update($joborderData);
        $association_update = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $candidateactivity = new Activity();
        $candidateactivity->name = "Employer has closed the job";
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->job_status = 6;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Employer has closed the job";
            $candidateactivity->accountmanager_id = $accountmanager_id;
            $candidateactivity->note = $note;
            $candidateactivity->admin_id = 1;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_status = 6;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        //Get all the required info to send sms & email.
        $association_info = Association::where('job_id', $joborderId)
            // ->where('candidate_status',6)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->first();
        $association_vendor_info = Association::where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->groupBy('vendor_id')
            ->with('vendor')
            ->with('accountmanager')
            ->with('job')
            ->get();
        //Get the enabled country
        $country = Country::where('is_enabled', 1)->first();
        $subjectVenAm = "Job " . $joborderId . " is now closed.";
        //Foreach to send emails and
        /* foreach ($association_vendor_info as $vendor) {*/
        //TODO Send Email to vendor stating that job is closed.
        $countryCode = User::select('country_code')->where('email', $association_info['accountmanager']['email'])->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info['accountmanager']['mobile'];
        Mail::send('emails.notifyClosedJobtoVen', ['userName' => $association_info['vendor']['first_name'], 'jobName' => $association_info['job']['name'], 'jobid' => $association_info['job']['id'], 'amEmail' => $association_info['accountmanager']['email'], 'amMobile' => $mobileNumber, 'amName' => $association_info['accountmanager']['first_name'], 'jobInternalCode' => $joborderId, 'jobTitle' => $association_info['job']['name']], function ($m) use ($association_info, $subjectVenAm) {
            $m->to($association_info['vendor']['email'], 'Job is closed')->subject($subjectVenAm);
        });
        $number = $association_info['vendor']['mobile'];
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info['job']['name'] . " has been closed by " . $employerParent->first_name;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        /* }*/ // foreach close
        //TODO Send Email to Am stating that job is closed.
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        Mail::send('emails.notifyClosedJobtoAm', ['userName' => $association_info['accountmanager']['first_name'], 'company_name' => $company_name[0]->name, 'jobName' => $association_info['job']['name'], 'jobid' => $association_info['job']['id'], 'jobInternalCode' => $joborderId, 'jobTitle' => $association_info['job']['name']], function ($m) use ($association_info, $subjectVenAm) {
            $m->to($association_info['accountmanager']['email'], 'Job is closed')->subject($subjectVenAm);
        });
        $number = $association_info['accountmanager']['mobile'];
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info['job']['name'] . " has been closed by " . $employerParent->first_name;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $empsubject = "Thanks for letting us know! Job " . $association_info->job->id . "-" . $association_info->job->name . " is now closed.";
        //TODO Send Email to Employer stating that profile is duplicate.
        if ($authuser->user_type != 1) {
            Mail::send('emails.notifyClosedJobtoEmp', ['userName' => $employerParent->first_name, 'jobName' => $association_info['job']['name'], 'jobid' => $association_info['job']['id'], 'jobInternalCode' => $joborderId, 'jobTitle' => $association_info['job']['name']], function ($m) use ($employerParent, $association_info, $empsubject) {
                $m->to($employerParent->email, 'Job is closed')->subject($empsubject);
            });
            $number = $employerParent->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The Job role  " . $association_info['job']['name'] . " has been closed by you.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        return response()->success(compact('success'));
    }

    public function deleteJoborder($id)
    {
        $user = JobOrders::where('is_talentpool', 0)->find($id);
        $user->delete();
        $authuser = Auth::user();
        //Insert Successfull job order delete activity record
        return response()->success('success');
    }

    public function getJoborderdetailsShow($id)
    {
        $joborderdetails = JobOrders::where('id', $id)->get(['name', 'billrate', 'skills_preferred', 'skills_required', 'payment_mode', 'payment_terms', 'contract_term_type', 'salaryType']);
        $joblocations = JobCitys::where('job_id', $id)->get(['city_name']);
        $locations = array();
        foreach ($joblocations as $j_name) {
            array_push($locations, $j_name->city_name);
        }
        $joborderdetails[0]['citys'] = implode(",", $locations);
        if ($joborderdetails[0]['contract_term_type'] == 1) {
            $joborderdetails[0]['term_duration'] = "Less than 3 months";
        } else if ($joborderdetails[0]['contract_term_type'] == 2) {
            $joborderdetails[0]['term_duration'] = "3-6 months";
        } else if ($joborderdetails[0]['contract_term_type'] == 3) {
            $joborderdetails[0]['term_duration'] = "6-9 months";
        } else if ($joborderdetails[0]['contract_term_type'] == 4) {
            $joborderdetails[0]['term_duration'] = "9-12 months";
        } else if ($joborderdetails[0]['contract_term_type'] == 4) {
            $joborderdetails[0]['term_duration'] = "More than 12 months";
        }
        $joborderdetails[0]['skills_preferred'] = str_replace(",", " , ", $joborderdetails[0]['skills_preferred']);
        $joborderdetails[0]['skills_required'] = str_replace(",", " , ", $joborderdetails[0]['skills_required']);
        return response()->success($joborderdetails);
    }

    public function getJoborderShow($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationcount = Association::where('job_id', $id)
            ->where('vendor_id', $authId)
            ->count();
        if ($associationcount >= 1) {
            $joborders = JobOrders::with('status')->with('JobType')->with('JobCitys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->find($id);
            $joborders['new_updated_at'] = $joborders->updated_at;
            $joborders['current_time'] = Carbon::now();
            $acceptedJob = Association::where('job_id', $id)
                ->where('vendor_id', $authId)
                ->where('job_status', 3)
                ->count();
            $closedjobProfileCount = (int)Association::where('job_id', $id)
                ->whereIn('candidate_status', array(27, 28))
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->count();
            $positions = (int)JobOrders::where('id', $id)->first()->vacancies;
            $joborders['checkifposclosed'] = ($positions == $closedjobProfileCount) ? 0 : 1;
            $joborders['positions_closed'] = $closedjobProfileCount;
            $joborders['ifJobaccepted'] = $acceptedJob;
            $joborders['predefined'] = DB::table("job_orders_question_answers")->select('job_id','question_id','answer as is_must', 'question_generate as Q_description', 'flag','updated_at')->where('job_id',$id)->get();
            $employer_id = JobOrders::where('id', $id)->first()->user_id;
            $accountmanager_id = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->where('employer_id', $employer_id)
                ->whereNull('employer_user_id')
                ->whereNull('vendor_user_id')
                ->where('job_id', $id)
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $joborders['countResumes'] = Association::where('vendor_id', $authId)
                ->where('accountmanager_id', $accountmanager_id)
                ->where('employer_id', $employer_id)
                ->where('job_id', $id)
                ->whereNotNull('candidate_id')
                ->count();
            if ($authuser->parent_id) {
                $joborders['DeviationRequests'] = DeviationRequests::where('job_id', $id)
                    ->where('vendor_id', $authuser->parent_id)
                    ->get();
            } else {
                $joborders['DeviationRequests'] = DeviationRequests::where('job_id', $id)
                    ->where('vendor_id', $authuser->id)
                    ->get();
            }
        } else {
            $joborders = "No data Found";
        }
        return response()->success($joborders);
    }

    public function getJobordertalentpoolShow($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationcount = Association::where('job_id', $id)
            ->count();
        if ($associationcount >= 1) {
            $joborders = JobOrders::where('is_talentpool', 0)->with('JobCitys')->with('Education.educations')->with('Industry')->find($id);
        } else {
            $joborders = "No data Found";
        }
        return response()->success($joborders);
    }

    public function getUserjoborderShow($id)
    {
        $authuser = Auth::user();
        $associationcount = VendorActivities::where('job_id', $id)->where('vendor_user_id', $authuser->id)->count();
        if ($associationcount >= 1) {
            $joborders = JobOrders::where('is_talentpool', 0)->with('status')->with('JobType')->with('JobCitys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->find($id);
            $joborders['new_updated_at'] = $joborders->updated_at;
            $joborders['current_time'] = Carbon::now();
            return response()->success($joborders);
        } else {
            $joborders = "No data Found";
            return response()->success($joborders);
        }
    }

    public function getEmpjoborderShow($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationcount = Association::where('job_id', $id)
            ->where('employer_id', $authId)
            ->count();
        if ($associationcount >= 1) {
            $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
            $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
            $joborders = JobOrders::with('status')->with('JobType')->with('JobCitys.citys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Continents')->with('Industry')->with('user')->find($id);
            $date = new \DateTime($joborders->created_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $joborders['created_at'] = $date->format('Y-m-d');
            $date = new \DateTime($joborders->expectedjoingdate, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $joborders['predefined'] = DB::table("job_orders_question_answers")->select('job_id','question_id','answer as is_must', 'question_generate as Q_description', 'flag','updated_at')->where('job_id',$id)->get();
            $joborders['skills_updated_by'] = User::select('first_name','last_name')->where('id', '=', $joborders->	skills_updated_by)->first();
            $joborders['expectedjoingdate'] = $date->format('Y-m-d');
            $joborders['new_updated_at'] = $joborders->updated_at;
            $joborders['current_time'] = Carbon::now();
            $closedjobProfileCount = (int)Association::where('job_id', intval($id))
                ->where('employer_id', $authId)
                ->whereIn('candidate_status', array(27, 28))
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->count();
            $joborders['positions_closed'] = $closedjobProfileCount;
            return response()->success($joborders);
        } else {
            $joborders = "No data Found";
            return response()->success($joborders);
        }
    }


    public function getTalentpooljoborderShow($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $joborders = JobOrders::with('status')->with('JobType')->with('JobCitys.citys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->with('user')->find($id);
        $joborders['new_updated_at'] = $joborders->updated_at;
        $joborders['current_time'] = Carbon::now();
        $closedjobProfileCount = (int)Association::where('job_id', intval($id))
            ->where('employer_id', $authId)
            ->whereIn('candidate_status', array(27, 28))
            ->whereNotNull('accountmanager_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('candidate_id')
            ->count();
        $joborders['positions_closed'] = $closedjobProfileCount;
        return response()->success($joborders);
    }

    public function postEmpjoborderShow1()
    {
        $authuser = Auth::user();
        $authId = null;
        $joborderId = Input::get('JobOrderId');
        $canId = Input::get('canId');
        $decryption_canid = base64_decode($canId);
        $can_id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);
        $decryption_jobid = base64_decode($joborderId);
        $job_id = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationcount = Association::where('job_id', $job_id)
            ->where('employer_id', $authId)
            ->where('candidate_id', $can_id)
            ->get();
        if (count($associationcount) >= 1) {
            $joborders = JobOrders::where('is_talentpool', 0)->with('status')->with('JobType')->with('JobCitys.citys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->with('user')->find($job_id);
            $joborders['new_updated_at'] = $joborders->updated_at;
            $joborders['current_time'] = Carbon::now();
            $closedjobProfileCount = (int)Association::where('job_id', intval($job_id))
                ->where('employer_id', $authId)
                ->whereIn('candidate_status', array(27, 28))
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->count();
            $joborders['positions_closed'] = $closedjobProfileCount;
            return response()->success($joborders);
        } else {
            $joborders = "No data Found";
            return response()->success($joborders);
        }
    }

    public function getAmjoborderShow($id)
    {
        $authuser = Auth::user();
        $associationcount = Association::where('job_id', $id)
            ->where('accountmanager_id', $authuser->id)
            ->count();
        if ($associationcount >= 1) {
            $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
            $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
            $joborders = JobOrders::with('status')->with('JobType')->with('JobCitys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->with('vendorcustomrevenues')->find($id);
            $date = new \DateTime($joborders->created_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $date1 = new \DateTime(date('Y-m-d H:i:s'), new \DateTimeZone('UTC'));
            $joborders['newdate'] = $date1->format('Y-m-d H:i:s');
            $date = new \DateTime($joborders->expectedjoingdate, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            $joborders['predefined'] = DB::table("job_orders_question_answers")->select('job_id','question_id','answer as is_must', 'question_generate as Q_description', 'flag','updated_at')->where('job_id',$id)->get();
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $joborders['expectedjoingdate'] = $date->format('Y-m-d');
            $joborders['new_updated_at'] = $joborders->created_at;
            $joborders['current_time'] = Carbon::now();
            $closedjobProfileCount = (int)Association::where('job_id', $id)
                ->where('accountmanager_id', $authuser->id)
                ->whereIn('candidate_status', array(27, 28))
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->count();
            $positions = (int)JobOrders::where('id', $id)->first()->vacancies;
            $joborders['checkifposclosed'] = ($positions == $closedjobProfileCount) ? 0 : 1;
            $joborders['positions_closed'] = $closedjobProfileCount;
        } else {
            $joborders = "No data Found";
        }
        return response()->success($joborders);
    }

    public function getAmjoborderdiviationrequest($id)
    {
        $amjoborderdiviationrequest = DeviationRequests::where('job_id', '=', intval($id))->with('vendor')->get();
        return response()->success($amjoborderdiviationrequest);
    }

    public function getJoborderlanguagesShow($id)
    {
        $languagen = JobLanguage::where('job_id', '=', intval($id))->with('languages')->lists('language_id');
        $languages=$languagen[0];
        $language = language::select('id','name')->where('id','=',$languages)->get();
        return response()->success($language);
    }

    public function getJobordercitysShow($id)
    {
        $city = JobCitys::where('job_id', '=', intval($id))->with('citys')->lists('city_id');
        return response()->success($city);
    }

    public function getJobordereducationsShow($id)
    {
        $educationn = EducationAssociations::where('job_id', '=', intval($id))->with('educations')->lists('qualification_id');
        //print_r($education[0]); exit;
        $educations =$educationn[0];
        $education = EducationQualification::select('id','qualification as name')->where('id','=',$educations)->get();
        return response()->success($education);
    }

    public function getAssociationstatusShow($id)
    {
        $authuser = Auth::user();
        $associationstatus = Association::where('job_id', $id)
            ->where('vendor_id', $authuser->id)
            ->whereNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->where('job_status', 4)
            ->get();
        return response()->success($associationstatus);
    }

    public function getCandidateShow($id)
    {  
        $authuser = Auth::user();
		$candInfo = Association::where('candidate_id', $id)->first();
		$jobInfo = DB::table('job_orders')->where('id',$candInfo->job_id)->get();
		
        $candidates = Candidate::where('id', $id)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('getCandidateDetails')->first();
		
        $candidates['newpath'] = \config('app.newSitePath');
        $gdprData = DB::table('gdpr_datas')->where('candidate_id', $id)->first();
            $candidates['gdprData'] = $gdprData;
		 $candidates = $candidates->toArray();
         $candidates['otherdetails'] = VendorCandidateNotes::where('job_id', $candInfo->job_id)
                            ->where('candidate_id', $id)->first();
         $ven_name = DB::table('users')->select('first_name','last_name')->where('id', $candInfo->vendor_id)->first();
           $candidates['vendor_name'] = $ven_name->first_name . ' '. $ven_name->last_name;
           $association = Association::where('candidate_id', $id)->with('vendor', 'vendor.company')->first();
           
           $vendorID = User::where('id', $association->vendor_id)->with('company')->get();
            //echo '<pre>'; print_r($vendorID); echo '</pre>';
            $vendorTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $vendorID[0]->company->timezone)->get();
            $candidates['vendorTimezone'] = $vendorTimezone[0]['timezone'];
            $candidates['vendorTimezoneOffset'] = $vendorTimezone[0]['GMT_offset'];
            $candidates['interview_schedule_date'] = $association->interview_schedule_date;
            $candidates['candidate_status'] = $association->candidate_status;
            $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
            $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();

            $candidates['timezone'] = $empTimezone[0]['GMT_offset'];
            $predefinedInfo = DB::table('job_orders')->select('questions')->where('id',$candInfo->job_id)->get();
                  if ($predefinedInfo[0]->questions == "NO" || $predefinedInfo[0]->questions == null || $predefinedInfo[0]->questions == '' )
                    {
                        $candidates['PredefinedquestionsanswersData'] = 1;
                    }
                else{
                  $Predefinedquestionsanswers = Predefinedquestionsanswers::where('candidate_id', $id)->get();
                  
                 if(($Predefinedquestionsanswers) && count($Predefinedquestionsanswers)>0) {
                    $candidates['PredefinedquestionsanswersData'] = 1;
                 } else {
                          $candidates['PredefinedquestionsanswersData'] = 0;
                        }
                }
           
         if($authuser->role_id==5) {

            if($jobInfo[0]->blindhire==1 && $candidates['mask']==1) {
                $candidates['full_name'] = substr_replace($candidates['full_name'], str_repeat("X", strlen($candidates['full_name'])), 2, strlen($candidates['full_name'])-4);
                $candidates['email'] = substr_replace($candidates['email'], str_repeat("X", strlen($candidates['email'])), 2, strlen($candidates['email'])-6); 
                $candidates['phone'] = substr_replace($candidates['phone'], str_repeat("X", strlen($candidates['phone'])-3), 2, strlen($candidates['phone'])-3);
                $candidates['total_experience_in_year'] = substr_replace($candidates['total_experience_in_year'], str_repeat("X", strlen($candidates['total_experience_in_year'])), 0, strlen($candidates['total_experience_in_year']));
                $candidates['job_profile'] = substr_replace($candidates['job_profile'], str_repeat("X", strlen($candidates['job_profile'])), 0, strlen($candidates['job_profile']));
                $candidates['gender'] = substr_replace($candidates['gender'], str_repeat("X", strlen($candidates['gender'])), 0, strlen($candidates['gender'])-0);
                $mask_summary = substr_replace($candidates['first_name'], str_repeat("X", strlen($candidates['first_name'])-1), 1, strlen($candidates['first_name'])-2); 
                $candidates['management_summary'] = preg_replace('/'.$candidates['first_name'].'/', $mask_summary, $candidates['management_summary']);
                $mask_summary = substr_replace($candidates['first_name'], str_repeat("X", strlen($candidates['first_name'])-1), 1, strlen($candidates['first_name'])-2);
                $candidates['executive_summary'] = preg_replace('/'.$candidates['first_name'].'/', $mask_summary, $candidates['executive_summary']);
            }
            }
		
        return response()->success(compact('candidates'));
    }

    public function getCandidatedetShow($id)
    {
        $authuser = Auth::user();
        $candidates = Candidate::where('id', $id)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('experiences')->get();
        foreach ($candidates as $val) {
            if (count($val['experiences']) >= 2) {
                $val->last_company_name = $val['experiences'][1]['employer_name'];
            } else if (count($val['experiences']) == 1) {
                $val->last_company_name = $val['experiences'][0]['employer_name'];
            } else {
                $val->last_company_name = "";
            }
            $val->candidate_note = VendorCandidateNotes::where('candidate_id', $val->id)
                        ->first();
        }
        return response()->success(compact('candidates'));
    }

    public function getJobdata($id)
    {
        $authuser = Auth::user();


        $jobdata = JobOrders::where('id', $id)->where('is_talentpool', 0)->with('user')->get();
        foreach ($jobdata as $job_data) {
            $job_data->am_name = $authuser->first_name . ' ' . $authuser->first_name;
            $job_data->am_mobileno = $authuser->mobile;//->mobile_number;
        }
        
        return response()->success(compact('jobdata'));
    }

    public function putEmpjoborderShow()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $joborderForm = Input::get('data');

        $jobskillsdelete = JobSkills::where('job_id', '=', intval($joborderForm['id']))->delete();
        $prefSkills = $joborderForm['preferredSkillsGraph'];
        $reqSkills = $joborderForm['requiredSkillsGraph'];
        if (count($prefSkills)) {
            foreach ($prefSkills as $value) {
                JobSkills::create([
                    'skill_name' => $value['text'],
                    'skill_percentage' => $value['percentage'],
                    'skill_nooftimes' => $value['noOfTimes'],
                    'is_requiredskill' => 0,
                    'job_id' => $joborderForm['id'],
                ]);
            }
        }
        if (count($reqSkills)) {
            foreach ($reqSkills as $value) {
                JobSkills::create([
                    'skill_name' => $value['text'],
                    'skill_percentage' => $value['percentage'],
                    'skill_nooftimes' => $value['noOfTimes'],
                    'is_requiredskill' => 1,
                    'job_id' => $joborderForm['id'],
                ]);
            }
        }
        if (!empty($joborderForm['job_internal_code'])) {
            $checkifInternal = JobOrders::where('id', '!=', $joborderForm['id'])->where('is_talentpool', 0)
                ->where('job_internal_code', 'LIKE BINARY', '%' . $joborderForm['job_internal_code'] . '%')
                ->where('user_id', $authId)
                ->count();
        } else {
            $checkifInternal = false;
        }
        $item = collect($joborderForm['items']);
        if (count($item) > 0) {
            foreach ($item as $value) {
               // print_r($value['question_id']);exit;
                $qALOcalArray = array();
                $qALOcalArray['job_id'] = $joborderForm['id'];
                $qALOcalArray['question_id'] = $value['question_id'];
                $qALOcalArray['user_id'] = Auth::id();
                $qALOcalArray['question_generate'] = $value['Q_description'];
                $qALOcalArray['answer'] = $value['is_must'];
                $qALOcalArray['original_queestions'] = $value['Q_description'];
                $qALOcalArray['question_type'] = $value['question_type'];
                $qALOcalArray['flag'] = $value['flag'];
                
                $checkQues = JobOrdersQuestionAnswer::where('question_id',$value['question_id'])->where('job_id', $joborderForm['id'])->get()->toArray();
                if(is_array($checkQues) && count($checkQues)>0) {
                    JobOrdersQuestionAnswer::where('id', $checkQues[0]['id'])->update($qALOcalArray);
                } else {
                    JobOrdersQuestionAnswer::create($qALOcalArray);
                }
                
            }
        }
         //print_r($joborderForm['items']); exit();
        if (!$checkifInternal) {
            if ($joborderForm['job_type_id'] == 1) {
                $salaryType = $joborderForm['salaryType'];
                $salaryMax = $joborderForm['salary'];
                $salaryMin = $joborderForm['salary_min'];
                if ($salaryType == 'per month') {
                    $salaryMax = $salaryMax * 12;
                    $salaryMin = $salaryMin * 12;
                    $salaryType = "per year";
                } else if ($salaryType == 'per week') {
                    $salaryMax = $salaryMax * 52;
                    $salaryMin = $salaryMin * 52;
                    $salaryType = "per year";
                } else if ($salaryType == 'per day') {
                    $salaryMax = $salaryMax * 365;
                    $salaryMin = $salaryMin * 365;
                    $salaryType = "per year";
                }
                $continentsId = !empty(Input::get('continents_id'))?(Input::get('continents_id')): null ;
            {
            $continents =$joborderForm['continents_id'];          
            $continents_id = array();
            if(is_array($continents) && count($continents)>0) {
                foreach($continents as $key=>$value) {
                    $continents_id[] = $value;
                }
                 $continentsId = $continents_id[0];
            }
            }
            $travel_percent_v= $joborderForm['travel_percent'];
            $travel_percent_value=str_replace("%", "", $travel_percent_v);
                $joborderData = [
                    'currency' => $joborderForm['currency'],
                    'salary_min' => $salaryMin,
                    'level' => $joborderForm['level'],
                    'industry_id' => $joborderForm['industryId'],
                    'job_internal_code' => $joborderForm['job_internal_code'],
                    'name' => $joborderForm['name'],
                    'vacancies' => $joborderForm['vacancies'],
                    'salary' => $salaryMax,
                    'salaryType' => $salaryType,
                    'experience' => $joborderForm['experience'],
                    'experience_to' => $joborderForm['experience_to'],
                    /*'experiencetype' => $joborderForm['experienceType'],*/
                    'educationlevel' => $joborderForm['educationLevel'],
                    'expectedjoingdate' => date('Y-m-d', strtotime($joborderForm['expectedjoingdate'])),
                    'language_id' => '',
                    'deadline' => $joborderForm['deadline'],
                    'job_type_id' => $joborderForm['job_type_id'],
                    'notice_period' =>$joborderForm['notice_period']['name'],
                    'requirement_id' => $joborderForm['requirement_id'],
                    'description' => $joborderForm['description'],
                    'skills_preferred' => $joborderForm['preferredSkills'],
                    'skills_required' => $joborderForm['requiredSkills'],
                    'is_private' => $joborderForm['is_private'],
                    'min_contract_term' => $joborderForm['min_contract_term'],
                    'max_contract_term' => $joborderForm['max_contract_term'],
                    'contract_term_type' => $joborderForm['contract_term_type'],
                    'gdpr' => $joborderForm['gdpr'],
                    //'payment_terms' => $joborderForm['paymentTerms'],
                    //'work_autherization'=>$joborderForm['workAuth'],
                    'freshers_apply'=>$joborderForm['freshers_apply'],
                    'questions'=>$joborderForm['questions'],
                    'open_to_travel'=>$joborderForm['open_to_travel'],
                    'travel_percent'=>$joborderForm['travel_percent'],
                    'relocate'=>$joborderForm['relocate'],
                    'targated_company'=>$joborderForm['targated_company'],
                    //'resumes'=>implode('~', $file_names),
                    'note'=>$joborderForm['note'],
                    'url'=>$joborderForm['url'],
                    'work_question'=>$joborderForm['work_question'],
                    'work_question_2'=>$joborderForm['work_question_2'],
                    //'location_id' =>implode(',', $city_ids),
                    'job_type_new'=>$joborderForm['job_type_new'],
                    'continents_id'=> $continents,

                ];
            } 
            else if ($joborderForm['job_type_id'] == 2) {
                $continents =$joborderForm['continents_id'];
                $billrate = $joborderForm['billrate'];
                $am_billRate = $joborderForm['am_billRate'];
                $vendor_billRate = $joborderForm['vendor_billRate'];
                $salaryType = $joborderForm['salaryType'];
                $joborderData = [
                    'currency' => $joborderForm['currency'],
                    'level' => $joborderForm['level'],
                    'industry_id' => $joborderForm['industryId'],
                    'job_internal_code' => $joborderForm['job_internal_code'],
                    'name' => $joborderForm['name'],
                    'vacancies' => $joborderForm['vacancies'],
                    'billrate' => $billrate,
                    'am_billRate' => $am_billRate,
                    'vendor_billRate' => $vendor_billRate,
                    'salaryType' => $salaryType,
                    'experience' => $joborderForm['experience'],
                    'experience_to' => $joborderForm['experience_to'],
                    'educationlevel' => $joborderForm['educationLevel'],
                    'expectedjoingdate' => date('Y-m-d', strtotime($joborderForm['expectedjoingdate'])),
                    'language_id' => '',
                    'deadline' => $joborderForm['deadline'],
                    'notice_period' =>$joborderForm['notice_period']['name'],
                    'job_type_id' => $joborderForm['job_type_id'],
                    'requirement_id' => $joborderForm['requirement_id'],
                    'description' => $joborderForm['description'],
                    'skills_preferred' => $joborderForm['preferredSkills'],
                    'skills_required' => $joborderForm['requiredSkills'],
                    'is_private' => $joborderForm['is_private'],
                    'min_contract_term' => $joborderForm['min_contract_term'],
                    'max_contract_term' => $joborderForm['max_contract_term'],
                    'contract_term_type' => $joborderForm['contract_term_type'],
                    'payment_mode' => $joborderForm['payment_mode'],
                    'payment_terms' => $joborderForm['payment_terms'],
                    'gdpr' => $joborderForm['gdpr'],
                    //'payment_terms' => $joborderForm['paymentTerms'],
                    //'work_autherization'=>$joborderForm['workAuth'],
                    'freshers_apply'=>$joborderForm['freshers_apply'],
                    'questions'=>$joborderForm['questions'],
                    'open_to_travel'=>$joborderForm['open_to_travel'],
                    'travel_percent'=>$joborderForm['travel_percent'],
                    'relocate'=>$joborderForm['relocate'],
                    'targated_company'=>$joborderForm['targated_company'],
                    //'resumes'=>implode('~', $file_names),
                    'note'=>$joborderForm['note'],
                    'url'=>$joborderForm['url'],
                    'work_question'=>$joborderForm['work_question'],
                    'work_question_2'=>$joborderForm['work_question_2'],
                    //'location_id' =>implode(',', $city_ids),
                    'job_type_new'=>$joborderForm['job_type_new'],
                    'continents_id'=> $continents,
                ];
            }
            $cityAssociationIds = JobCitys::where('job_id', '=', intval($joborderForm['id']))->delete();
           
            $cityIds = $joborderForm['loc_id'];
            foreach ($cityIds as $city ) {
                if(!empty($city['id']) && !empty($city['name'])){
                    JobCitys::create([
                        'city_id' => $city['id'],
                        'city_name' => $city['name'],
                        'job_id' => intval($joborderForm['id']),
                    ]);
            }
            if(!empty($city['city_id']) && !empty($city['city_name'])){
                JobCitys::create([
                    'city_id' => $city['city_id'],
                    'city_name' => $city['city_name'],
                    'job_id' => intval($joborderForm['id']),
                ]);
            }
            }
                //By Mukesh
                if(!empty($cityIds[0]['citys'])){
                $country_id = $cityIds[0]['citys']['country_id'];
                }
                else if($cityIds[0]['country_id']){
                    $country_id = $cityIds[0]['country_id'];
                }
            
                $countryPrices = Pricing::where('emp_id', $authId)
                            ->where('country_id',$country_id)
                            ->get();
                            // print_r($countryPrices);
                            // die;
                $jobb = JobOrders::where('id', '=', intval($joborderForm['id']))->where('is_talentpool',0)->with('JobCitys')->with('JobType')->with('Industry')->get();

                $contract = $jobb[0]->JobType->name;


                $monthlyPay = $jobb[0]->salary_min;

				
                $priceValue="";

                $flatPriceValue="";

                $flag=0;

                $created_at = date('Y-m-d h:i:s');

                if($joborderForm['job_type_id'] != 2) {

                    foreach($countryPrices as $key =>$value){
						
                        if($value->price!="8.33" && !empty($value->price) && $value->type_of_emp=="Flat Rate"){
                            $flatPriceValue = ($monthlyPay * $value->price)/100;
                            $flag=1;
                        } else {
							
                            if($value->starting_range <= $monthlyPay && $value->ending_range >= $monthlyPay) {
                                if (is_numeric($monthlyPay) && is_numeric($value->price)) {
                                    $priceValue = ($monthlyPay * $value->price)/100;
                                }
                            }
                        }
                    }

                    if($flag==1) {

                        DB::insert("insert into vendor_accountmanager_share set job_id='".intval($joborderForm['id'])."', vendor_accountmanager_original_price='".$flatPriceValue."',account_manager_price='".$flatPriceValue."', created_at='".$created_at."', updated_at='".$created_at."'");

                        DB::insert("insert into vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', job_id='".intval($joborderForm['id'])."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");

                    } else {

                         DB::insert("insert into vendor_accountmanager_share set job_id='".intval($joborderForm['id'])."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."'");

                        DB::insert("insert into vendor_pricing_revenue set permanent_price='".$priceValue."', job_id='".intval($joborderForm['id'])."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");

                    }

                } else if($joborderForm['job_type_id'] == 2){

                    $billrate = $joborderForm['billrate'];

                    $salaryType = $joborderForm['salaryType'];
                    if($salaryType=='Per Year')
                    {
                        $yearlyPay = $billrate * 1;
                    }
                    else if($salaryType=='Per Month')
                    {
                        $yearlyPay = $billrate * 12;
                    }
                    else if($salaryType=='Per Week')
                    {
                        $yearlyPay = $billrate * 52;
                    }
                    else if($salaryType=='Per Day')
                    {
                        $yearlyPay = $billrate * 365;
                    }
                    else if($salaryType=='Per Hour')
                    {
                        $yearlyPay = $billrate * 8 * 365;
                    }

                    $contractMonthlyPay = $yearlyPay / 12;
                    $priceValue = "";

                    foreach($countryPrices as $ky => $val) {

                        if($val->type_of_emp=="Contract To Hire") {

                            $priceValue = round(($contractMonthlyPay * $val->price)/100);

                        }
                    }
                     DB::insert("insert into vendor_accountmanager_share set job_id='".intval($joborderForm['id'])."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."'");
                    DB::insert("insert into vendor_pricing_revenue set contract_price='".$priceValue."', job_id='".intval($joborderForm['id'])."', emp_id='".$authId."', created_at='".$created_at."', updated_at='".$created_at."'");
                }
			// end of mukesh
            $languageAssociationIds = JobLanguage::where('job_id', '=', intval($joborderForm['id']))->delete();
            $langIds = $joborderForm['job_languages'];
            foreach ($langIds as $key => $lang) {
                     JobLanguage::create([
                    'language_id' => $lang['id'],
                    'job_id' => intval($joborderForm['id']),
                ]);   
            }
            $deleteEduIds = EducationAssociations::where('job_id', '=', intval($joborderForm['id']))->delete();
            $eduQual = $joborderForm['eduLevel'];
            foreach ($eduQual as $qual) {
                EducationAssociations::create([
                    'qualification_id' => $qual['id'],
                    'job_id' => intval($joborderForm['id']),
                ]);
            }
            $affectedRows = JobOrders::where('id', '=', intval($joborderForm['id']))->where('is_talentpool', 0)->update($joborderData);
            $joborders = JobOrders::where('is_talentpool', 0)->find($joborderForm['id']);
            $candidateactivity = new Activity();
            $candidateactivity->name = 'Job is updated.';
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = null;
            $candidateactivity->vendor_id = null;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->job_id = $joborderForm['id'];
            $candidateactivity->candidate_id = null;
            $candidateactivity->candidate_status = 0;
            $candidateactivity->activity_by = $authId;
            $candidateactivity->save();
            return response()->success('success');
        } else {
            return response()->error("There is an existing job with same Internal Job Code.");
        }
    }

    public function putJoborderactivate($id)
    {
        $authuser = Auth::user();
        $authId = null;
        $parentUser = null;
        $employerName = $authuser->first_name;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $joborderData = ['status' => 4];
        $affectedRows = JobOrders::where('id', '=', intval($id))->where('is_talentpool', 0)->update($joborderData);
        //Revenue calculation START
        $job_id = $id;
        $job = JobOrders::where('id', '=', intval($job_id))->where('is_talentpool', 0)->with('JobCitys')->with('JobType')->with('Industry')->get();
        $city_names_data = array();
        foreach ($job[0]->JobCitys as $job_cities) {
            array_push($city_names_data, $job_cities->city_name);
        }
        $contract = $job[0]->JobType->name;
        $city = JobCitys::where('job_id', '=', intval($id))->with('citys')->lists('city_id');
        $citiesof = City::where('id', intval($city[0]))->with('Country')->get();
        $countryId = $citiesof[0]['country_id'];
        if (!($countryId == 1 || $countryId == 3 || ($countryId >= 25 && $countryId <= 50))) {
            $countryId = Country::where('id', 2)->first()->id;
        }
        $checkRevised = Pricing::where('emp_id', JobOrders::where('id', $job_id)->first()->user_id)
            ->whereNotNull('revised_price')
            ->count();
        $monthlyPay = $job[0]->salary_min;
        $price = array();
        $timeLimit = array();
        if ($checkRevised) {
            $price = Pricing::where('emp_id', JobOrders::where('id', $job_id)->first()->user_id)
                ->where('type_of_emp', $contract)
                ->where(function ($query) use ($monthlyPay) {
                    $query->where('ending_range', '>=', $monthlyPay)
                        ->orWhereNull('ending_range');
                })
                ->whereNotNull('revised_price')
                ->with('country')
                ->first();
            $revenue = VendorRevenueRule::where('country_id', $countryId)
                ->whereNotNull('time_limit')
                ->orderBy('time_limit', 'ASC')
                ->with('country')
                ->get();
            $contractMonthlyPay = $monthlyPay / 12;
            foreach ($revenue as $key => $value) {
                if ($job[0]->job_type_id != 2) { // If permanent
                    if ($price->price_type == 'percentage') {
                        $priceShare = ($price->revised_price * $monthlyPay) / 100;
                        $price[$key] = ((100 - $value->price) * $priceShare) / 100;
                        $timeLimit[$key] = $value->time_limit;
                    } else {
                        $price[$key] = round(((100 - $value->price) * $price->revised_price) / 100, 0);
                        $timeLimit[$key] = $value->time_limit;
                    }
                } else if ($job[0]->job_type_id == 2) { // If contract to hire
                    if ($price->price_type == 'percentage') {
                        $priceShare = ($price->revised_price * $contractMonthlyPay) / 100;
                        $price[$key] = $contractMonthlyPay - $priceShare;
                        $timeLimit[$key] = $value->time_limit;
                    } else {
                        $price[$key] = $contractMonthlyPay - $price->revised_price;
                        $timeLimit[$key] = $value->time_limit;
                    }
                }// if ($job[0]->job_type_id != 2)
            }// foreach
        } else {
            if ($job[0]->job_type_id == 2) {
                $price = Pricing::where('country_id', $countryId)
                    ->where('type_of_emp', $contract)
                    ->with('country')
                    ->first();
            } else {
                $price = Pricing::where('country_id', $countryId)
                    ->where('type_of_emp', $contract)
                    ->where(function ($query) use ($monthlyPay) {
                        $query->where('ending_range', '>=', $monthlyPay)
                            ->orWhereNull('ending_range');
                    })
                    ->with('country')
                    ->first();
            }
            $revenue = VendorRevenueRule::where('country_id', $countryId)
                ->whereNotNull('time_limit')
                ->orderBy('time_limit', 'ASC')
                ->with('country')
                ->get();
            $priceShare = ($price->price * $monthlyPay) / 100;
            $contractMonthlyPay = $monthlyPay / 12;
            foreach ($revenue as $key => $value) {
                if ($job[0]->job_type_id != 2) { // If permanent
                    $price[$key] = ((100 - $value->price) * $priceShare) / 100;
                    $timeLimit[$key] = $value->time_limit;
                } else if ($job[0]->job_type_id == 2) { // If contract to hire
                    $hxShare = ($price->price * $contractMonthlyPay) / 100;
                    $price[$key] = $contractMonthlyPay - $hxShare;
                    $timeLimit[$key] = $value->time_limit;
                }
            }//foreach
        } // else
        $vendorrevenue = new VendorRevenue();
        $vendorrevenue->job_id = (int)$job_id;
        $vendorrevenue->vendor_id = null;
        $vendorrevenue->default_revenue = 0;
        $vendorrevenue->est_revenue_1 = $price[0];
        $vendorrevenue->est_revenue_2 = $price[1];
        $vendorrevenue->est_revenue_3 = $price[2];
        $vendorrevenue->est_revenue_4 = $price[3];
        $vendorrevenue->est_revenue_5 = $price[4];
        $vendorrevenue->save();
        //Revenu calculation END
        $amassociation = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->where('job_id', intval($id))
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->get();
        $jobactivity = new Activity();
        $jobactivity->name = "Job Activated";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $amassociation[0]->accountmanager_id;
        $jobactivity->employer_id = $authId;
        $jobactivity->job_id = intval($id);
        $jobactivity->activity_by = $authId;
        $jobactivity->save();
        $hrs = date('H');
        $msg = "";
        if ($authuser->parent_id) {
            $employerName = User::where('id', '=', intval($authuser->parent_id))->first()->first_name;
            $employerUser = new Activity();
            $employerUser->name = "Job Activated";
            $employerUser->admin_id = 1;
            $employerUser->accountmanager_id = $amassociation[0]->accountmanager_id;
            $employerUser->employer_id = $authId;
            $employerUser->employer_user_id = $authuser->id;
            $employerUser->job_id = intval($id);
            $employerUser->activity_by = $authuser->id;
            $employerUser->save();
        }
        //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
        if ($hrs > 0) $msg = "Good morning";      // After 6am
        if ($hrs > 12) $msg = "Good afternoon";    // After 12pm
        if ($hrs > 17) $msg = "Good evening";      // After 5pm
        if ($hrs > 23) $msg = "Go to bed!";        // After 10pm
        //TODO Send Email to employer and vendor stating that new job has been Posted.
        $cities = '';
        foreach ($job[0]['JobCitys'] as $key => $value) {
            if (!empty($cities)) {
                $cities = $cities . ', ' . $value['city_name'];
            } else {
                $cities = $value['city_name'];
            }
        }
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        Mail::send('emails.reachingOutPersonally', ['msg' => $msg, 'name' => $amassociation[0]->accountmanager->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'employerName' => $company_name[0]->name, 'jobName' => $job[0]->name, 'CityPin' => $cities, 'toggle' => false], function ($m) use ($amassociation, $company_name) {
            $m->to($amassociation[0]->accountmanager->email, 'New job post')->subject('Posted new job');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $amassociation[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $amassociation[0]->accountmanager->first_name . " your employer " . $employerName . " posted a new job " . $job[0]->name . " please check your dashboard for complete details.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success('success');
    }

    public function postDuplicatejob()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $note = Input::get('note');
        $dupcandId = Input::get('dupcandId');
        $authuser = Auth::user();
        $authId = null;
        $employerName = $authuser->first_name;
        $employerEmail = $authuser->email;
        if ($authuser->parent_id) {
            $employerName = User::where('id', '=', intval($authuser->parent_id))->first()->first_name;
            $employerEmail = User::where('id', '=', intval($authuser->parent_id))->first()->email;
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationData = [
            'candidate_status' => 1,
            'note' => $note,
            'status_updated_by' => $authId,
        ];
        $dupcandidate = Association::where('job_id', $joborderId)
            ->where('candidate_status', 31)
            ->where('candidate_id', $dupcandId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $dupcandidateValue = Association::where('job_id', $joborderId)
            ->where('candidate_status', 1)
            ->where('candidate_id', $dupcandId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile marked as duplicate by Employer";
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $dupcandidateValue->accountmanager_id;
        $candidateactivity->vendor_id = $dupcandidateValue->vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $dupcandId;
        $candidateactivity->candidate_status = 1;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Profile marked as duplicate by Employer";
            $candidateactivity->note = $note;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $dupcandidateValue->accountmanager_id;
            $candidateactivity->vendor_id = $dupcandidateValue->vendor_id;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $dupcandId;
            $candidateactivity->candidate_status = 1;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 1)
            ->where('candidate_id', $dupcandId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->with('company')
            ->get();
        //$vendorSubject = "Opps!! " .$association_info[0]->job->id. " - " .$association_info[0]->candidate->full_name. " Seems it was a Duplicate!";
        $vendorSubject = "Oops!! Seems " . $association_info[0]->candidate->full_name . " was a Duplicate Profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name . "!";
        //TODO Send Email to vendor stating that profile is duplicate.
        //print_r($association_info[0]->accountmanager->email);exit;
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangetovenn', ['userName' => $association_info[0]->vendor->first_name, 'amName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'jobid' => $association_info[0]->job->id, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'amName' => $association_info[0]->accountmanager->first_name, 'text' => 'This profile is Duplicate one.'], function ($m) use ($association_info, $vendorSubject) {
            $m->to($association_info[0]->vendor->email, 'Duplicate profile')->subject($vendorSubject);
        });
        //print_r($association_info[0]->accountmanager->email);exit;
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        // $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " Marked as duplicate.";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") was marked as Duplicate for the [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by Employer-" . $employerName;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        $companyid = User::select('company_id')->where('email', $association_info[0]->vendor->email)->get();
        $vendor_company_name = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        $accountmanagerSubject = "Oops!! " . $company_name[0]->name . " has Duplicated a profile from " . $vendor_company_name[0]->name . " !";
        //$accountmanagerSubject = "Oops!! You’ve Duplicated profile for role " .$association_info[0]->job->id. "-" .$association_info[0]->job->name;
        //TODO Send Email to Am stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangetoam', ['userName' => $association_info[0]->accountmanager->first_name, 'venName' => $association_info[0]->vendor->first_name, 'userNamerecruiter' => $company_name[0]->name, 'vendor_company_name' => $vendor_company_name[0]->name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'jobid' => $association_info[0]->job->id, 'venEmail' => $association_info[0]->vendor->email, 'venMobile' => $mobileNumber, 'text' => 'This profile is duplicate one.'], function ($m) use ($association_info, $accountmanagerSubject, $company_name) {
            $m->to($association_info[0]->accountmanager->email, 'Duplicate profile')->subject($accountmanagerSubject);
        });
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        //$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " Marked as duplicate.";
        $msgtxt = "Hello " . $association_info[0]->accountmanager->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") was marked as Duplicate for the [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by Employer-" . $employerName;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $employerSubject = "Oops!! You’ve Duplicated profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name;
        //TODO Send Email to Employer stating that profile is duplicate.
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangetoemp', ['userName' => $employerName, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'amName' => $association_info[0]->accountmanager->first_name, 'jobid' => $association_info[0]->job->id, 'text' => 'This profile is Duplicate one.'], function ($m) use ($employerEmail, $association_info, $employerSubject) {
            $m->to($employerEmail, 'Duplicate profile')->subject($employerSubject);
        });
        return response()->success(compact('dupcandidate'));
    }

    public function postReasonstoreject()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $reasonIds = Input::get('reasonIds');
        $candId = Input::get('candId');
        $note = Input::get('note');
        $authuser = Auth::user();
        $authId = null;
        $employerName = $authuser->first_name;
        $employerEmail = $authuser->email;
        if ($authuser->parent_id) {
            $employerName = User::where('id', '=', intval($authuser->parent_id))->first()->first_name;
            $employerEmail = User::where('id', '=', intval($authuser->parent_id))->first()->email;
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationData = [
            'candidate_status' => 2,
            'reason_id' => $reasonIds,
            'status_updated_by' => $authId,
            'note' => $note,
        ];
        $reasonstoreject = Association::where('job_id', $joborderId)
            ->where('candidate_status', 31)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $reasonstorejectValue = Association::where('job_id', $joborderId)
            ->where('candidate_status', 2)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile rejected by Employer";
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
        $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = 2;
        $candidateactivity->note = $note;
        $candidateactivity->reason_id = $reasonIds;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Profile rejected by Employer";
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
            $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
            $candidateactivity->employer_id = $authuser->parent_id;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = 2;
            $candidateactivity->note = $note;
            $candidateactivity->reason_id = $reasonIds;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 2)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        /* Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been Rejected.'], function ($m) use($association_info){
             $m->to($association_info[0]->vendor->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
         });*/
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonVen', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'amName' => $association_info[0]->accountmanager->first_name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->vendor->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        //$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been rejected.";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") has been rejected for the job [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by Employer-" . $employerName;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Am stating that profile is duplicate.
        /* Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been Rejected.'], function ($m) use($association_info){
             $m->to($association_info[0]->accountmanager->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
         });*/
        $companyid = User::select('company_id')->where('id', $association_info[0]->vendor_id)->get();
        $vendorcompanyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        $countryCode = User::select('country_code')->where('email', $association_info[0]->vendor->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->vendor->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonAm', ['userName' => $association_info[0]->accountmanager->first_name, 'vendor_company_name' => $vendorcompanyname[0]->name, 'candidateName' => $association_info[0]->candidate->full_name, 'venName' => $association_info[0]->vendor->first_name, 'venEmail' => $association_info[0]->vendor->email, 'venMobile' => $mobileNumber, 'company_name' => $company_name[0]->name, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info, $company_name) {
            $m->to($association_info[0]->accountmanager->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $association_info[0]->accountmanager->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") has been rejected for the job [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by Employer-" . $employerName;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Employer stating that profile is duplicate.
        /* Mail::send('emails.notifyCandidateJobStatusChangesemp', ['userName' => $employerName, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been Rejected.'], function ($m) use($employerEmail){
             $m->to($employerEmail, 'Rejected profile')->subject("Unfortunately, wasn't a match this time!");
         });*/
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonEmp', ['userName' => $employerName, 'candidateName' => $association_info[0]->candidate->full_name, 'amName' => $association_info[0]->accountmanager->first_name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($employerEmail) {
            $m->to($employerEmail, 'Rejected profile')->subject("Unfortunately, wasn't a match this time!");
        });
        return response()->success(compact('reasonstoreject'));
    }

    public function postReasonstorejectas()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $reasonIdsAs = Input::get('reasonIdsAs');
        $candId = Input::get('candId');
        $note = Input::get('note');
        $authuser = Auth::user();
        $authId = null;
        $employerParent = $authuser;
        $employerEmail = $authuser->email;
		
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationData = [
            'candidate_status' => 30,
            'reason_id' => $reasonIdsAs,
            'status_updated_by' => $authId,
            'note' => $note,
        ];
        $reasonstorejectas = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_status')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $reasonstorejectasValue = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->where('candidate_status', 30)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile rejected by Employer";
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $reasonstorejectasValue->accountmanager_id;
        $candidateactivity->vendor_id = $reasonstorejectasValue->vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = 30;
        $candidateactivity->reason_id = $reasonIdsAs;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Profile rejected by Employer";
            $candidateactivity->note = $note;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $reasonstorejectasValue->accountmanager_id;
            $candidateactivity->vendor_id = $reasonstorejectasValue->vendor_id;
            $candidateactivity->employer_id = $authuser->parent_id;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = 30;
            $candidateactivity->reason_id = $reasonIdsAs;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 30)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonVen', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'amName' => $association_info[0]->accountmanager->first_name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->vendor->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile " . $association_info[0]->candidate->full_name . " for the Job (" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . ") has been rejected by Account Manager (" . $employerParent->firstName . ").";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $companyid = User::select('company_id')->where('id', $association_info[0]->vendor_id)->get();
        $vendorcompanyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        $countryCode = User::select('country_code')->where('email', $association_info[0]->vendor->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->vendor->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonAm', ['userName' => $association_info[0]->accountmanager->first_name, 'vendor_company_name' => $vendorcompanyname[0]->name, 'candidateName' => $association_info[0]->candidate->full_name, 'venName' => $association_info[0]->vendor->first_name, 'venEmail' => $association_info[0]->vendor->email, 'venMobile' => $mobileNumber, 'company_name' => $company_name[0]->name, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info, $company_name) {
            $m->to($association_info[0]->accountmanager->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been rejected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyCandidateJobStatusChangeReasonEmp', ['userName' => $employerParent->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'amName' => $association_info[0]->accountmanager->first_name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($employerEmail) {
            $m->to($employerEmail, 'Rejected profile')->subject("Unfortunately, wasn't a match this time!");
        });
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been rejected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('reasonstorejectas'));
    }

    public function postAmreasonstorejectas()
    {
        $joborderId = Input::get('joborderId');
        $reasonIdsAs = Input::get('reasonIdsAs');
        $candId = Input::get('candId');
        $note = Input::get('note');
        $authuser = Auth::user();
        $associationData = [
            'candidate_status' => 30,
            'reason_id' => $reasonIdsAs,
            'status_updated_by' => $authuser->id,
            'note' => $note,
        ];
        $amreasonstorejectas = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('candidate_status')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $reasonstorejectasValue = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->where('candidate_status', 30)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile rejected by Account Manager";
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $authuser->id;
        $candidateactivity->vendor_id = $reasonstorejectasValue->vendor_id;
        $candidateactivity->employer_id = $reasonstorejectasValue->employer_id;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = 30;
        $candidateactivity->activity_by = $authuser->id;
        $candidateactivity->save();
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 30)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with('employer')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been selected.'], function ($m) use ($association_info) {
            +$m->to($association_info[0]->vendor->email, 'Selected profile')->subject('Voila! Your Candidate is Shortlisted');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile " . $association_info[0]->candidate->full_name . " for the Job (" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . ") has been rejected by Account Manager (" . $authuser->firstName . ").";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Am stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $authuser->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info) {
            $m->to($authuser->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $number = $authuser->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been rejected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('amreasonstorejectas'));
    }

    public function postShortlistedids()
    {
        $authuser = Auth::user();
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $shortlistIds = Input::get('shortlistIds');
        $candId = Input::get('candId');
        $mobile = Input::get('shrtListNote');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $shrtListNote = $email;
        $mobile_n = Input::get('addressAsNote');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile_n);
        $mobile_s = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email_n = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile_s);
        //$email_n=preg_replace('/ [a-zA-Z]\w*/', '', $email_n);
        $addressAsNote = $email_n;
        $interview_schedule_date = Input::get('interview_schedule_date');
        
        $can_detail = Candidate::where('id', $candId)->get(['phone']);
        $type_int = Status::where('id', $shortlistIds)->get(['name']);
        $client_name = Company::where('id', $authuser->company_id)->get(['name']);
        $can_name = Candidate::where('id', $candId)->get(['full_name']);
        $country = Country::where('is_enabled', 1)->get();
        $number = $can_detail[0]['phone'];
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hi " . $can_name[0]['full_name'] . ", Congratulations ! Your profile has been  shortlisted for initilal  stage of interview of this (" . $type_int[0]['name'] . ") and is located In " . $addressAsNote . " and is with client " . $client_name[0]['name'] . " at following date/time " . $interview_schedule_date . " Best of Luck!- HireXtra Team";
        /* $msgtxt="Congratulation ! You have been selected for an interview of this type ".$type_int[0]['name']." and is located in ".$addressAsNote."  and is with client ".$client_name[0]['name']." at following date/time ".$interview_schedule_date." - HireXtra Team";*/
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $authuser = Auth::user();
        $authId = null;
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationData = [
            'candidate_status' => $shortlistIds,
            'note' => $shrtListNote,
            'status_updated_by' => $authId,
            'interview_schedule_date' => $interview_schedule_date,
            'addressAsNote' => $addressAsNote,
        ];
        $shortlistedids = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $shortlistedidsValue = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->where('candidate_status', $shortlistIds)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Shortlisted by Employer";
        $candidateactivity->note = $shrtListNote;
        $candidateactivity->addressAsNote = $addressAsNote;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $shortlistedidsValue->accountmanager_id;
        $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = $shortlistIds;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Shortlisted by Employer";
            $candidateactivity->note = $shrtListNote;
            $candidateactivity->addressAsNote = $addressAsNote;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $shortlistedidsValue->accountmanager_id;
            $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
            $candidateactivity->employer_id = $authuser->parent_id;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = $shortlistIds;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', $shortlistIds)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //$employerSubject = "We're glad you found a match! You've Shortlisted a Candidate for " .$type_int[0]['name'];
        $employerSubject = "We're glad you found a match for " . $joborderId . "-" . $association_info[0]->job->name . " role!";
        $accountmanagerSubject = "Voila! A Candidate is " . $type_int[0]['name'];
        $vendorSubject = "Voila! Your Candidate is " . $type_int[0]['name'];
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeShortListVen', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($association_info, $vendorSubject) {
            $m->to($association_info[0]->vendor->email, 'Shortlisted profile')->subject($vendorSubject);
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The profile " . $association_info[0]->candidate->full_name . " submitted by you for Job role (" . $association_info[0]->job->name . ") has been Shortlisted by " . $employerParent->first_name . " for  initilal stage of interview. Please check your dashboard for additional details.";
        /*$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";*/
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $companyid = User::select('company_id')->where('id', $association_info[0]->vendor_id)->get();
        $vendorcompanyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        //TODO Send Email to Am stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeShortListAm', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'vendor_company_name' => $vendorcompanyname[0]->name, 'jobid' => $joborderId, 'company_name' => $company_name[0]->name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($association_info, $accountmanagerSubject, $company_name) {
            $m->to($association_info[0]->accountmanager->email, 'Shortlisted profile')->subject($accountmanagerSubject);
        });
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The profile (" . $association_info[0]->candidate->full_name . ") which you submitted for " . $association_info[0]->job->name . " position has been Shortlisted by " . $employerParent->first_name . " for " . $type_int[0]['name'];
        /*$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";*/
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangesemp', ['userName' => $employerParent->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'amName' => $association_info[0]->accountmanager->first_name, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($employerParent, $employerSubject) {
            $m->to($employerParent->email, 'Shortlisted profile')->subject($employerSubject);
        });
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The profile (" . $association_info[0]->candidate->full_name . ") submitted for " . $association_info[0]->job->name . " position has been Shortlisted for " . $type_int[0]['name'];
        /*$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";*/
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('shortlistedids'));
    }

    public function postAmshortlistedids()
    {
        $joborderId = Input::get('joborderId');
        $shortlistIds = Input::get('shortlistIds');
        $candId = Input::get('candId');
        $shrtListNote = Input::get('shrtListNote');
        $type_int = Status::where('id', $shortlistIds)->get(['name']);
        $authuser = Auth::user();
        $associationData = [
            'candidate_status' => $shortlistIds,
            'note' => $shrtListNote,
            'status_updated_by' => $authuser->id,
        ];
        $amshortlistedids = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('candidate_status')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $shortlistedidsValue = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->where('candidate_status', $shortlistIds)
            ->whereNotNull('candidate_status')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Shortlisted by Account Manager";
        $candidateactivity->note = $shrtListNote;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $authuser->id;
        $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
        $candidateactivity->employer_id = $shortlistedidsValue->employer_id;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = $shortlistIds;
        $candidateactivity->activity_by = $authuser->id;
        $candidateactivity->save();
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', $shortlistIds)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->vendor->email, 'Shortlisted profile')->subject('Shortlisted profile');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "h1PglGOpC6B44";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        /*$msgtxt="The profile ".$association_info[0]->candidate->full_name ." submitted by you for Job role (".$association_info[0]->job->name.") has been shortlisted by ".$employerParent->first_name." for  initilal stage of interview. Please check your dashboard for additional details.";*/
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " your submitted profile " . $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->employer->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->employer->email, 'Shortlisted profile')->subject('Shortlisted profile');
        });
        $number = $association_info[0]->employer->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        /* $msgtxt = "The profile (".$association_info[0]->candidate->full_name.") submitted for ".$association_info[0]->job->name." position has been shortlisted for ".$type_int[0]['name'];*/
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Accountmanager stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $authuser->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Shortlisted.'], function ($m) use ($authuser) {
            $m->to($authuser->email, 'Shortlisted profile')->subject('Shortlisted profile');
        });
        $number = $authuser->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        /*$msgtxt = "The profile (".$association_info[0]->candidate->full_name.") which you submitted for ".$association_info[0]->job->name." position has been shortlisted by ".$employerParent->first_name." for ".$type_int[0]['name'];*/
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('amshortlistedids'));
    }

    public function postSelectedids()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $shortlistIds = Input::get('shortlistIds');
        $candId = Input::get('candId');
        $shrtListNote = Input::get('shrtListNote');
        $mobile_n = Input::get('addressAsNote');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile_n);
        $mobile_s = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email_n = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile_s);
        //$email_n=preg_replace('/ [a-zA-Z]\w*/', '', $email_n);
        $addressAsNote = $email_n;
        $interview_schedule_date = Input::get('interview_schedule_date');
        $authuser = Auth::user();
        $authId = null;
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $associationData = [
            'candidate_status' => $shortlistIds,
            'note' => $shrtListNote,
            'status_updated_by' => $authId,
            'addressAsNote' => $addressAsNote,
            'interview_schedule_date' => $interview_schedule_date
        ];
        $selectedids = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->update($associationData);
        $shortlistedidsValue = Association::where('job_id', $joborderId)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->where('candidate_status', $shortlistIds)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('status_updated_by')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile selected by Employer";
        $candidateactivity->note = $shrtListNote;
        $candidateactivity->addressAsNote = $addressAsNote;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $shortlistedidsValue->accountmanager_id;
        $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = $shortlistIds;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Profile selected by Employer";
            $candidateactivity->note = $shrtListNote;
            $candidateactivity->addressAsNote = $addressAsNote;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $shortlistedidsValue->accountmanager_id;
            $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
            $candidateactivity->employer_id = $authuser->parent_id;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = $shortlistIds;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', $shortlistIds)
            ->where('candidate_id', $candId)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been selected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->vendor->email, 'Selected profile')->subject('Selected profile');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HRXTRA";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Am stating that profile is duplicate.
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
		
        $company_id = User::select('company_id')->where('id', $association_info[0]->vendor_id)->get(['company_id']);
		
        $vendor_company_name = Company::select('name')->where('id', $company_id[0]->company_id)->get(['name']);
		
        Mail::send('emails.notifyCandidateJobStatusChangeVendor', ['userName' => $association_info[0]->accountmanager->first_name, 'vendor_company_name' => $vendor_company_name[0]->name, 'company_name' => $company_name[0]->name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been selected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->accountmanager->email, 'Selected profile')->subject('Voila! A Candidate is Shortlisted');
        }); 
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HRXTRA";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeEmp', ['userName' => $employerParent->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $joborderId, 'jobName' => $association_info[0]->job->name, 'amEmail' => $association_info[0]->accountmanager->email, 'countrycode_am' => $receipientno, 'amMobile' => $association_info[0]->accountmanager->mobile, 'amName' => $association_info[0]->accountmanager->first_name, 'text' => 'This profile has been selected.'], function ($m) use ($employerParent) {
            $m->to($employerParent->email, 'Selected profile')->subject('Selected profile');
        });
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HRXTRA";
        $msgtxt = "Your submitted profile " . $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        // Check if positions are still open
        $closedjobProfileCount = (int)Association::where('job_id', $joborderId)
            ->where('employer_id', $authuser)
            ->whereIn('candidate_status', array(27, 28))
            ->whereNotNull('accountmanager_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('candidate_id')
            ->count();
        $positions = (int)JobOrders::where('id', $joborderId)->where('is_talentpool', 0)
            ->where('user_id', $authId)
            ->first()->vacancies;
        //Close job if all the positions are filled.
        if ($positions == $closedjobProfileCount) {
            $joborderData = ['status' => 6];
            $note = 'Closing this job due to all the positions are filled';
            $associationData = [
                'candidate_status' => 6,
                'note' => $note,
                'status_updated_by' => $authId,
            ];
            $closejoborder = JobOrders::where('id', $joborderId)->where('is_talentpool', 0)
                ->where('user_id', $authId)
                ->whereNotNull('status')
                ->update($joborderData);
            $association_update = Association::where('employer_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('employer_user_id')
                ->whereNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->where('job_id', $joborderId)
                ->whereNull('candidate_id')
                ->whereNotNull('status_updated_by')
                ->update($associationData);
            $candidateactivity = new Activity();
            $candidateactivity->name = 'Closed the job.';
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
            $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = 0;
            $candidateactivity->activity_by = $authId;
            $candidateactivity->save();
            if ($authuser->parent_id) {
                $candidateactivity = new Activity();
                $candidateactivity->name = 'Closed the job.';
                $candidateactivity->admin_id = 1;
                $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
                $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
                $candidateactivity->employer_id = $authuser->parent_id;
                $candidateactivity->employer_user_id = $authuser->id;
                $candidateactivity->job_id = $joborderId;
                $candidateactivity->candidate_id = $candId;
                $candidateactivity->candidate_status = 0;
                $candidateactivity->activity_by = $authuser->id;
                $candidateactivity->save();
            }
            //Get all the required info to send sms & email.
            $association_info = Association::where('job_id', $joborderId)
                ->where('candidate_status', 6)
                ->whereNull('candidate_id')
                ->where('employer_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('employer_user_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->with('accountmanager')
                ->with('candidate')
                ->with('job')
                ->first();
            $association_vendor_info = Association::where('job_id', $joborderId)
                ->whereNull('candidate_id')
                ->where('employer_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('employer_user_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->groupBy('vendor_id')
                ->with('vendor')
                ->with('job')
                ->get();
            //Get the enabled country
            $country = Country::where('is_enabled', 1)->first();
            //Foreach to send emails and
            foreach ($association_vendor_info as $vendor) {
                //TODO Send Email to vendor stating that job is closed.
                Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $joborderId, 'jobTitle' => $association_info->job->name], function ($m) use ($vendor) {
                    $m->to($vendor->vendor->email, 'Job is closed')->subject('Job is closed');
                });
                $number = $vendor->vendor->mobile;
                $city = \App\City::where('id', $authuser->city_id)->get();
                if (count($city) > 0) {
                    $country = Country::where('id', $city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
                $ch = curl_init();
                $user = "kv@hirextra.com";
                $password = "Kumar786%";
                $receipientno = $countryCode . $number;
                $originator = "HRXTRA";
                $msgtxt = "Job Title: " . $association_info->job->name . " has been closed due to all the position are filled.";
                curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                $buffer = curl_exec($ch);
                $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
            } // foreach close
            //TODO Send Email to Am stating that job is closed.
            Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $joborderId, 'jobTitle' => $association_info->job->name], function ($m) use ($association_info) {
                $m->to($association_info->accountmanager->email, 'Job is closed')->subject('Job is closed');
            });
            $number = $association_info->accountmanager->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HRXTRA";
            $msgtxt = "Job Title: " . $association_info->job->name . " has been closed due to all the position are filled";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            //TODO Send Email to Employer stating that profile is duplicate.
            Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $joborderId, 'jobTitle' => $association_info->job->name], function ($m) use ($employerParent) {
                $m->to($employerParent->email, 'Job is closed')->subject('Job is closed');
            });
            $number = $employerParent->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HRXTRA";
            $msgtxt = "Job Title: " . $association_info->job->name . " has been closed due to all the position are filled";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } // Check if all positions are filled.
        return response()->success(compact('selectedids'));
    }

    public function getAssignedjobs($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $assignedjobs = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->with('job.JobType', 'job.status')
            ->with('employer')
            ->with('employer.company')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 3);
            })
            ->groupby('job_id')
            ->havingRaw('count(vendor_id) < 1')
            ->get();
        foreach ($assignedjobs as $job) {
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
            if (count($vendorAcceptedAt)) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
        }
        return response()->success(compact('assignedjobs'));
    }

    public function getAssignedjobsall()
    {
        $authuser = Auth::user();
        $assignedjobsall = Association::where('accountmanager_id', $authuser->id)
            ->with('job.JobType', 'job.status')
            ->with('employer')
            ->with('employer.company')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 3);
            })
            ->groupby('job_id')
            ->get();
        /* Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',3);
                            })
                             ->get();*/
        foreach ($assignedjobsall as $job) {
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            $vendorAcceptedAtsss = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
            if ($vendorAcceptedAtsss > 0) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
        }
        return response()->success(compact('assignedjobsall'));
    }

    public function getAdminassignedjobs()
    {
        $authuser = Auth::user();
        $adminassignedjobs = Association::whereNotNull('job_id')->where('job_status', 4)
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })->with('job_status')
            ->groupBy('job_id')->get();
        foreach ($adminassignedjobs as $job) {
            $vendorAcceptedAt = Activity::where('admin_id', 1)
                ->where('accountmanager_id', intval($job['accountmanager_id']))
                ->where('employer_id', intval($job['employer_id']))
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', intval($job['accountmanager_id']))
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
           $receivedProfiles=Association::where('job_id',$job->job['id'])
                    ->where('admin_id',$authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNotNull('employer_id')
                    ->count();
            $rejectedProfiles=Association::where('job_id',$job->job['id'])
                            ->where('admin_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->count();
            $shorlistedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'encrypted_jobId' => $encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;
            if (($vendorAcceptedAt)) {
                $job['am_job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['am_job_accept_time'] = 0;
            }
        }
        return response()->success(compact('adminassignedjobs'));
    }

    public function getAssignedalljobs($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $gdprJobId = array();
        $nongdprJobId = array();
        $gdprAssoStats = array();
        $nongdprAssoStats = array();
        $gdprSuccessJob = array();
        $vendorAccepted = array();
        $assignedalljobs = Association::where('accountmanager_id', $authuser->id)->where('created_at', '>=', $diff_date)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->get();
        //});
        foreach ($assignedalljobs as $job) {
            if ($job->job->gdprmandatory) {
                $gdprJobId[] = $job->job_id;
            } else {
                $nongdprJobId[] = $job->job_id;
            }
        }
        $gdprAssoStatsRaw = Association::whereIn('job_id', $gdprJobId)->where('created_at', '>=', $diff_date)
            ->where('accountmanager_id', $authuser->id)
			//->where('gdpr_status', 1)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        //});
        foreach ($gdprAssoStatsRaw as $stats) {
            $gdprAssoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        $nongdprAssoStatsRaw = Association::whereIn('job_id', $nongdprJobId)->where('created_at', '>=', $diff_date)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        foreach ($nongdprAssoStatsRaw as $stats) {
            $nongdprAssoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        $bothgdprJobId = array_merge($gdprJobId, $nongdprJobId);
        $gdprPen = GdprData::whereIn('job_id', $bothgdprJobId)
            ->where('status', 0)
            ->select('job_id', DB::raw('count(id) AS gdpr'))
            ->groupBy('job_id')
            ->get();
        foreach ($gdprPen as $stats) {
            $gdprSuccesspen[$stats->job_id] = $stats->gdpr;
        }
        
        $gdprSuccessRaw = GdprData::whereIn('job_id', $bothgdprJobId)->where('created_at', '>=', $diff_date)
            ->where('status', 1)
            ->select('job_id', DB::raw('count(id) AS gdpr'))
            ->groupBy('job_id')
            ->get();
        foreach ($gdprSuccessRaw as $stats) {
            $gdprSuccessJob[$stats->job_id] = $stats->gdpr;
        }
        $vendorAcceptedAtRaw = Activity::where('accountmanager_id', $authuser->id)->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->where('admin_id', 1)
            ->whereNull('job_status')
            ->whereIn('job_id', $bothgdprJobId)
            ->whereNull('vendor_id')
            ->where('activity_by', $authuser->id)
            ->whereNull('status_id')
            ->where('is_vendor_sourcing_activity', 0)
            ->select('job_id', 'created_at')
            ->groupBy('job_id')
            ->get();
        foreach ($vendorAcceptedAtRaw as $stats) {
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }
        reset($assignedalljobs);
        foreach ($assignedalljobs as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            $numbers['gdprSuccess'] = isset($gdprSuccessJob[$job['job_id']]) ? $gdprSuccessJob[$job['job_id']] : 0;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']]) ? $vendorAccepted[$job['job_id']] : 0;
            $numbers['profilesReceived'] = 0;
            $numbers['rejectedProfiles'] = 0;
            $numbers['shortlistedProfiles'] = 0;
            $numbers['offeredProfiles'] = 0;
            $numbers['holdProfiles'] = 0;
            $numbers['interviwedProfiles'] = 0;
            $numbers['gdprPending'] = isset($gdprSuccesspen[$job['job_id']]) ? $gdprSuccesspen[$job['job_id']] : 0;

            if (!$authuser->parent_id) {
                $assigntovUser = Activity::select('first_name')->where('job_id', intval($job['job_id']))
                ->join('users as u', 'u.id', '=', 'activities.vendor_id')
                ->whereNotNull('vendor_id')->distinct('vendor_id')
                ->groupBy('first_name')
                ->distinct('first_name')                
                ->get();
                if (count($assigntovUser)) {
                    foreach ($assigntovUser as $user) {
                        $assigntovUser = $user['first_name'];
                        $assigntovUser1[] = $user['first_name'];
                    }
                } else {
                    $assigntovUser = null;
                    $assigntovUser1 = [];
                }
            } else {
                $assigntovUser = null;
                $assigntovUser1 = [];
            }
            $activityUsers1 = Activity::select('vendor_id','job_id', 'name')
                ->where('accountmanager_id', $authuser->id)
                ->where('name', 'Job assigned to vendor')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->distinct('vendor_id')
                ->get()->count();

               // echo'count'.$activityUsers1;
      
           $numbers['activityUsers'] = isset($activityUsers1) ? $activityUsers1 : 0;
           $numbers['assigntovUser'] = isset($assigntovUser) ? $assigntovUser : '';
           $numbers['assigntovUser1'] = isset($assigntovUser1) ? $assigntovUser1 : '';
            
            if ($job->job->gdprmandatory) {
                if (!empty($gdprAssoStats[$job['job_id']])) {
                    $numbers['profilesReceived'] = $gdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $gdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $gdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $gdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $gdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $gdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            } else {
                if (!empty($nongdprAssoStats[$job['job_id']])) {
                    $numbers['profilesReceived'] = $nongdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $nongdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $nongdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $nongdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $nongdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $nongdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            }
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('assignedalljobs'));
    }
   
    public function getAssignedalljobsall()
    {
        $authuser = Auth::user();
        $gdprJobId = array();
        $nongdprJobId = array();
        $gdprAssoStats = array();
        $nongdprAssoStats = array();
        $gdprSuccessJob = array();
        $vendorAccepted = array();
        $assignedalljobsall = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->get();
        foreach ($assignedalljobsall as $job) {
            if ($job->job->gdprmandatory) {
                $gdprJobId[] = $job->job_id;
            } else {
                $nongdprJobId[] = $job->job_id;
            }
        }
        $gdprAssoStatsRaw = Association::whereIn('job_id', $gdprJobId)
            ->where('accountmanager_id', $authuser->id)/*->where('gdpr_status', 1)*/
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1, 2, 30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        foreach ($gdprAssoStatsRaw as $stats) {
            $gdprAssoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        $nongdprAssoStatsRaw = Association::whereIn('job_id', $nongdprJobId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1, 2, 30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        foreach ($nongdprAssoStatsRaw as $stats) {
            $nongdprAssoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        $bothgdprJobId = array_merge($gdprJobId, $nongdprJobId);
       $gdprPen = GdprData::whereIn('job_id', $bothgdprJobId)
            ->where('status', 0)
            ->select('job_id', DB::raw('count(id) AS gdpr'))
            ->groupBy('job_id')
            ->get();
        foreach ($gdprPen as $stats) {
            $gdprSuccesspen[$stats->job_id] = $stats->gdpr;
        }
        $gdprSuccessRaw = GdprData::whereIn('job_id', $bothgdprJobId)
            ->where('status', 1)
            ->select('job_id', DB::raw('count(id) AS gdpr'))
            ->groupBy('job_id')
            ->get();
        foreach ($gdprSuccessRaw as $stats) {
            $gdprSuccessJob[$stats->job_id] = $stats->gdpr;
        }
        $vendorAcceptedAtRaw = Activity::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->where('admin_id', 1)
            ->whereNull('job_status')
            ->whereIn('job_id', $bothgdprJobId)
            ->whereNull('vendor_id')
            ->where('activity_by', $authuser->id)
            ->whereNull('status_id')
            ->where('is_vendor_sourcing_activity', 0)
            ->select('job_id', 'created_at')
            ->groupBy('job_id')
            ->get();
        foreach ($vendorAcceptedAtRaw as $stats) {
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }
        reset($assignedalljobsall);
        foreach ($assignedalljobsall as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            $numbers['gdprSuccess'] = isset($gdprSuccessJob[$job['job_id']]) ? $gdprSuccessJob[$job['job_id']] : 0;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']]) ? $vendorAccepted[$job['job_id']] : 0;
            $numbers['profilesReceived'] = 0;
            $numbers['rejectedProfiles'] = 0;
            $numbers['shortlistedProfiles'] = 0;
            $numbers['offeredProfiles'] = 0;
            $numbers['holdProfiles'] = 0;
            $numbers['interviwedProfiles'] = 0;
            $numbers['gdprPending'] = isset($gdprSuccesspen[$job['job_id']]) ? $gdprSuccesspen[$job['job_id']] : 0;
            $assigntovUser1 = [];
            if (!$authuser->parent_id) {
                  $assigntovUser = Activity::select('first_name')->where('job_id', intval($job['job_id']))
                ->where('accountmanager_id', $authuser->id)
                ->leftjoin('users as u', 'u.id', '=', 'activities.vendor_id')
                ->whereNotNull('vendor_id')
                ->groupBy('u.id','activities.job_id')               
                ->distinct('u.id')
                ->get();
              
                if (count($assigntovUser)) {
                    foreach ($assigntovUser as $user) {
                        $assigntovUser = $user['first_name'];
                        $assigntovUser1[] = $user['first_name'];
                    }
                } else {
                    $assigntovUser = null;
                    $assigntovUser1 = [];
                }
            } else {
                $assigntovUser = null;
                $assigntovUser1 = [];
            }
            $activityUsers1 = Activity::select('vendor_id', 'job_id', 'name')
                ->where('accountmanager_id', $authuser->id)
                ->where('name', 'Job assigned to vendor')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->distinct('vendor_id')
                ->get()->count();

               // echo'count'.$activityUsers1;
      
           $numbers['activityUsers'] = isset($activityUsers1) ? $activityUsers1 : 0;
           $numbers['assigntovUser'] = isset($assigntovUser) ? $assigntovUser : '';
           $numbers['assigntovUser1'] = isset($assigntovUser1) ? $assigntovUser1 : '';
            if ($job->job->gdprmandatory) {
                if (!empty($gdprAssoStats[$job['job_id']])) {
                    $numbers['profilesReceived'] = $gdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $gdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $gdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $gdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $gdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $gdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            } else {
                if (!empty($nongdprAssoStats[$job['job_id']])) {
                    $numbers['profilesReceived'] = $nongdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $nongdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $nongdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $nongdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $nongdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $nongdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            }
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('assignedalljobsall'));
    }

    public function getAdminassignedalljobs()
    {
        $authuser = Auth::user();
        $adminassignedalljobs = Association::whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->get();
        foreach ($adminassignedalljobs as $association) {
            $receivedProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(17, 26))
                ->count();
            $offeredProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $association->job['id'])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $vendorAcceptedAt = Activity::where('accountmanager_id', intval($association['accountmanager_id']))
                ->where('employer_id', intval($association['employer_id']))
                ->whereNull('job_status')
                ->where('job_id', intval($association->job['id']))
                ->whereNull('vendor_id')
                ->where('activity_by', intval($association['accountmanager_id']))
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $association->job['id']);
            if (($vendorAcceptedAt)) {
                $association['am_job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $association['am_job_accept_time'] = 0;
            }
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'encrypted_jobId' => $encrypted];
            $association['numbers'] = $numbers;
        }//foreach
        return response()->success(compact('adminassignedalljobs'));
    }

    /**
     * Get all account managers.
     *
     * @return JSON
     */
    public function getReasontoreject()
    {
        $reasontoreject = Reason::where('status_id', 2)->get();
        return response()->success(compact('reasontoreject'));
    }

    public function getSuccessdummy()
    {
        $successdummy = Country::where('is_enabled', 1)->get();
        return response()->success(compact('successdummy'));
    }

    public function getReasontorejectas()
    {
        $reasontorejectas = Reason::where('status_id', 30)->get();
        return response()->success(compact('reasontorejectas'));
    }

    public function getShorlistedstatus()
    {
        $shorlistedstatus = Status::where('parent_id', 5)->get();
        return response()->success(compact('shorlistedstatus'));
    }

    public function getAmdashboardalerts()
    {
        $authuser = Auth::user();
        $clients = UserAssociation::where('assigned_to', $authuser->id)->get();
        $amclients = array();
        foreach ($clients as $client) {
            array_push($amclients, $client->user_id);
        }
        $amdashboardalerts = JobOrders::whereIn('user_id', $amclients)->where('is_talentpool', 0)
            ->where('status', 4)
            ->get();
        return response()->success(compact('amdashboardalerts'));
    }

    public function postAssignvendors()
    {
        $authuser = Auth::user();
        $vendors = Input::get('vendors');
        $job_id = Input::get('jobOrderId');
        $vendoruserID = '';
        if (is_array($vendors) && count($vendors) > 0) {
            foreach ($vendors as $key => $value) {
                if (is_array($value) && count($value) > 0) {
                    $vendor_id = $value['vendor']['id'];
                } else {
                    $vendor_id = $value;
                }
                $users = User::where('id', $vendor_id)->select('vendor_price_percent', 'user_type', 'company_id')->get();
                $companyInfo = Company::where('id', $users[0]->company_id)->select('city_id')->get();
                $cityInfo = City::where('id', $companyInfo[0]->city_id)->select('country_id')->get();
                //print_r($cityInfo[0]->country_id);exit;
                if ($users[0]->user_type == 1) {
                    $vendor_price_percent = 50;
                    $account_manager_percent = 50;
                } else {
                    $vendor_price_percent = $users[0]->vendor_price_percent;
                    $account_manager_percent = 100 - $vendor_price_percent;
                }
                $jobInfo = DB::table("associations as a")
                    ->select('a.job_id', 'vpr.permanent_price', 'vpr.contract_price', 'vpr.flat_rate')
                    ->join('vendor_pricing_revenue as vpr', 'vpr.job_id', '=', 'a.job_id')
                    ->where('a.job_id', $job_id)
                    ->get();
                if (is_array($jobInfo) && count($jobInfo) > 0) {
                    $vendor_price = "";
                    $accountm_price = "";
                    foreach ($jobInfo as $key => $info) {
                        if (!empty($info->flat_rate)) {
                            $vendor_price = ($info->flat_rate * $vendor_price_percent) / 100;
                            $accountm_price = ($info->flat_rate * $account_manager_percent) / 100;
                        } else if (!empty($info->contract_price)) {
                            $vendor_price = ($info->contract_price * $vendor_price_percent) / 100;
                            $accountm_price = ($info->contract_price * $account_manager_percent) / 100;
                        } else if (!empty($info->permanent_price)) {
                            $vendor_price = ($info->permanent_price * $vendor_price_percent) / 100;
                            $accountm_price = ($info->permanent_price * $account_manager_percent) / 100;
                        }
                        $created_at = date('Y-m-d h:i:s');
                        $vendorAccInfo = DB::select("select * from vendor_accountmanager_share where job_id='" . $job_id . "' and vendor_id='" . $vendor_id . "'");
                        if (is_array($vendorAccInfo) && count($vendorAccInfo) > 0) {
                            DB::table('vendor_accountmanager_share')
                                ->where('id', $vendorAccInfo[0]->id)
                                ->update([
                                    'vendor_price' => $vendor_price,
                                    'account_manager_price' => $accountm_price
                                ]);
                        } else {
                            DB::insert("insert into vendor_accountmanager_share set vendor_id='" . $vendor_id . "', job_id='" . $job_id . "', vendor_price='" . $vendor_price . "', account_manager_price='" . $accountm_price . "', created_at='" . $created_at . "', updated_at='" . $created_at . "'");
                        }
                    }
                }
            }
        }
        $association_info = Association::where('job_id', $job_id)
            ->whereNull('candidate_id')
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->first();
        $job = JobOrders::where('id', '=', intval($job_id))->where('is_talentpool', 0)
            ->with('JobCitys')
            ->with('Industry')
            ->with('JobType')
            ->get();
        $citysData = NULL;
        $citys = $job[0]->JobCitys;
        foreach ($citys as $key => $value) {
            $citysData[$key] = $value->city_name;
        }// foreach
        if ($citysData != NULL) {
            $citys = implode(",", $citysData);
        }
        //$country = Country::where('is_enabled',1)->first();
        $countryId = $cityInfo[0]->country_id;
        $country = Country::where('id', $countryId)->get();
        //        if(! ( $countryId == 1 || $countryId == 3 || ( $countryId >= 25 && $countryId <= 50)) )
        //            { $countryId = Country::where('id',2)->first()->id;
        //            print_r($countryId); exit;
        // }
        $price = array();
        $timeLimit = array();
        $revenue = VendorRevenueRule::where('country_id', $countryId)
            ->whereNotNull('time_limit')
            ->orderBy('time_limit', 'ASC')
            ->with('country')
            ->get();
        // foreach ($revenue as $key => $value) {
        //     $timeLimit[$key] = $value->time_limit;
        //     $price[$key] = $value->price;
        // }// foreach
        // $vendorRevenueValues = VendorRevenue::where("job_id",$job_id)
        //                 ->where('default_revenue',0)
        //                 ->whereNull('vendor_id')
        //                 ->whereNotNull('est_revenue_1')
        //                 ->whereNotNull('est_revenue_2')
        //                 ->whereNotNull('est_revenue_3')
        //                 ->whereNotNull('est_revenue_4')
        //                 ->whereNotNull('est_revenue_5')
        //                 ->first();
        foreach ($vendors as $vendor) {
            //print_r($vendor); exit;
            $vendorassociation = new Association();
            $vendorassociation->admin_id = 1;
            $vendorassociation->accountmanager_id = $authuser->id;
            $vendorassociation->employer_id = JobOrders::where('id', $job_id)->where('is_talentpool', 0)->first()->user_id;
            $vendorassociation->vendor_id = $vendor;
            $vendorassociation->job_id = $job_id;
            $vendorassociation->job_status = 4;
            $vendorassociation->status_updated_by = $authuser->id;
            $vendorassociation->is_talentpool = 0;
            $vendorassociation->save();
            $amassociation = User::where('id', $vendor)->first();
            if ($job[0]->job_type_id == 2) {
                $bill_rates = JobOrders::where('id', $job_id)->get(['billrate', 'am_billRate', 'vendor_billRate']);
                $deviation_create = DeviationRequests::create([
                    'job_id' => $job_id,
                    'accountmanager_id' => $authuser->id,
                    'vendor_id' => $vendor,
                    'vendor_user_id' => $vendoruserID,
                    'billrate' => $bill_rates[0]['billrate'],
                    'am_billRate' => $bill_rates[0]['am_billRate'],
                    'vendor_billRate' => $bill_rates[0]['vendor_billRate'],
                    'vendor_deviation_rate' => 0,
                    'vendor_deviation_request' => 0,
                    'vendor_deviation_note' => ' '
                ]);
            }
            $vendoractivity = new Activity();
            $vendoractivity->name = "Job assigned to vendor";
            $vendoractivity->admin_id = 1;
            $vendoractivity->accountmanager_id = $authuser->id;
            $vendoractivity->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendoractivity->vendor_id = $vendor;
            $vendoractivity->job_id = $job_id;
            $vendoractivity->job_status = 4;
            $vendoractivity->activity_by = $authuser->id;
            $vendoractivity->is_vendor_sourcing_activity = 0;
            //$vendoractivity->is_talentpool = 0;
            $vendoractivity->save();
            $vendoractivity_vsa = new Activity();
            $vendoractivity_vsa->name = "Job assigned to vendor";
            $vendoractivity_vsa->admin_id = 1;
            $vendoractivity_vsa->accountmanager_id = $authuser->id;
            $vendoractivity_vsa->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendoractivity_vsa->vendor_id = $vendor;
            $vendoractivity_vsa->job_id = $job_id;
            $vendoractivity_vsa->job_status = 4;
            $vendoractivity_vsa->activity_by = $authuser->id;
            $vendoractivity_vsa->is_vendor_sourcing_activity = 1;
            $vendoractivity_vsa->save();
            $hrs = date('H');
            $msg = "";
            //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
            if ($hrs > 0) $msg = "Good Morning";      // After 6am
            if ($hrs > 12) $msg = "Good Afternoon";    // After 12pm
            if ($hrs > 17) $msg = "Good Evening";      // After 5pm
            if ($hrs > 23) $msg = "Good Day";        // After 10pm
            // $vendorrevenue = new VendorRevenue();
            // $vendorrevenue->job_id = (int) $job_id;
            // $vendorrevenue->vendor_id = (int) $vendor;
            // $vendorrevenue->default_revenue = 0;
            // $vendorrevenue->est_revenue_1 = $vendorRevenueValues->est_revenue_1;
            // $vendorrevenue->est_revenue_2 = $vendorRevenueValues->est_revenue_2;
            // $vendorrevenue->est_revenue_3 = $vendorRevenueValues->est_revenue_3;
            // $vendorrevenue->est_revenue_4 = $vendorRevenueValues->est_revenue_4;
            // $vendorrevenue->est_revenue_5 = $vendorRevenueValues->est_revenue_5;
            // $vendorrevenue->save();
            // $within5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[0]." minutes"));
            // $after5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[1]." minutes"));
            // $after24hours = date('H:i d-m-Y', strtotime("now ".$timeLimit[2]." minutes"));
            // $after7d = date('H:i d-m-Y', strtotime("now ".$timeLimit[3]." minutes"));
            // $after30d = date('H:i d-m-Y', strtotime("now ".$timeLimit[4]." minutes"));
            $currency = $country[0]->currency;
            //print_r("ok");exit;
            //$subject = "Good Selection! " .$job_id. " assigned to " .$amassociation->first_name;
            $companyid = User::select('company_id')->where('id', $vendor)->get();
            $vendorcompanyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
            $subject = "Good Selection! Job " . $job_id . "-" . $association_info['job']['name'] . " assigned to " . $vendorcompanyname[0]->name;
            if ($job[0]->job_type_id == 2) {
                // $amassociation->email = 'nagarjuna.ddgam@gmail.com';
                Mail::send('emails.makeMoneyContractType', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys, 'currencySymbol' => $currency], function ($m) use ($amassociation) {
                    $m->to($amassociation->email, 'New job assignment')->subject('New Job..As We Promised!');
                });
                Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info['accountmanager']['first_name'], 'candidateName' => '', 'vendorName' => $amassociation->first_name, 'jobName' => $association_info['job']['name'],'industry' => $job[0]->Industry->name, 'jobId' => $job_id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'Job Assigned to Vendor'], function ($m) use ($association_info, $subject) {
                    $m->to($association_info['accountmanager']['email'], 'Job Assigned to Vendor')->subject($subject);
                });
            } else {
                // $amassociation->email = 'nagarjuna.ddgam@gmail.com';
                Mail::send('emails.makeMoney', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys, 'currencySymbol' => $currency], function ($m) use ($amassociation) {
                    $m->to($amassociation->email, 'New job assignment')->subject('New Job..As We Promised!');
                });
                Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info['accountmanager']['first_name'],'industry' => $job[0]->Industry->name, 'candidateName' => '', 'vendorName' => $amassociation->first_name, 'jobName' => $association_info['job']['name'], 'industry' => $job[0]->Industry->name, 'jobId' => $job_id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'Job Assigned to Vendor'], function ($m) use ($association_info, $subject) {
                    $m->to($association_info['accountmanager']['email'], 'Job Assigned to Vendor')->subject($subject);
                });
            } //else
            $number = $amassociation->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hello " . $amassociation->first_name . ", Your account manager " . $authuser->first_name . " assigned a new job. Please check dashboard for more details.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        $job[0]->status = 8;
        $job[0]->save();
        return response()->success(compact('vendorassociation'));
    }

    public function postAssignvendorsview()
    {
        $authuser = Auth::user();
        $vendors = Input::get('vendors');
        $job_id = Input::get('jobOrderId');
        $vendoruserID = '';
        // mukesh
        if (is_array($vendors) && count($vendors) > 0) {
            foreach ($vendors as $key => $value) {
                if (is_array($value) && count($value) > 0) {
                    $vendor_id = $value['vendor']['id'];
                } else {
                    $vendor_id = $value;
                }
                $users = User::where('id', $vendor_id)->select('vendor_price_percent', 'user_type')->get();
                if ($users[0]->user_type == 1) {
                    $vendor_price_percent = 50;
                    $account_manager_percent = 50;
                } else {
                    $vendor_price_percent = $users[0]->vendor_price_percent;
                    $account_manager_percent = 100 - $vendor_price_percent;
                }
                $jobInfo = DB::table("associations as a")
                    ->select('a.job_id', 'vpr.permanent_price', 'vpr.contract_price', 'vpr.flat_rate')
                    ->join('vendor_pricing_revenue as vpr', 'vpr.job_id', '=', 'a.job_id')
                    ->where('a.job_id', $job_id)
                    ->get();
					
                if (is_array($jobInfo) && count($jobInfo) > 0) {
                    $vendor_price = "";
                    $accountm_price = "";
                    foreach ($jobInfo as $key => $info) {
                        if (!empty($info->flat_rate)) {
                            $vendor_price = ($info->flat_rate * $vendor_price_percent) / 100;
                            $accountm_price = ($info->flat_rate * $account_manager_percent) / 100;
                        } else if (!empty($info->contract_price)) {
                            $vendor_price = ($info->contract_price * $vendor_price_percent) / 100;
                            $accountm_price = ($info->contract_price * $account_manager_percent) / 100;
                        } else if (!empty($info->permanent_price)) {
                            $vendor_price = ($info->permanent_price * $vendor_price_percent) / 100;
                            $accountm_price = ($info->permanent_price * $account_manager_percent) / 100;
                        }
						
                        $created_at = date('Y-m-d h:i:s');
                        $vendorAccInfo = DB::select("select * from vendor_accountmanager_share where job_id='" . $job_id . "' and vendor_id='" . $vendor_id . "'");
                        if (is_array($vendorAccInfo) && count($vendorAccInfo) > 0) {
                            DB::table('vendor_accountmanager_share')
                                ->where('id', $vendorAccInfo[0]->id)
                                ->update([
                                    'vendor_price' => $vendor_price,
                                    'account_manager_price' => $accountm_price
                                ]);
                        } else {
                            DB::insert("insert into vendor_accountmanager_share set vendor_id='" . $vendor_id . "', job_id='" . $job_id . "', vendor_price='" . $vendor_price . "', account_manager_price='" . $accountm_price . "', created_at='" . $created_at . "', updated_at='" . $created_at . "'");
                        }
                    }
                }
            }
        }
        //end mukesh
        $association_info = Association::where('job_id', $job_id)
            ->whereNull('candidate_id')
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->first();
        $job = JobOrders::where('id', '=', intval($job_id))->where('is_talentpool', 0)
            ->with('JobCitys')
            ->with('Industry')
            ->with('JobType')
            ->get();
        $citysData = NULL;
        $citys = $job[0]->JobCitys;
        foreach ($citys as $key => $value) {
            $citysData[$key] = $value->city_name;
        }// foreach
        if ($citysData != NULL) {
            $citys = implode(",", $citysData);
        }
        $city = JobCitys::where('job_id', '=', intval($job_id))->with('citys')->lists('city_id');
        $citiesof = City::where('id', intval($city[0]))->with('Country')->get();
        $countryId = $citiesof[0]['country_id'];
        // $country = Country::where('is_enabled',1)->first();
        $country = Country::where('id', intval($countryId))->first();
        // $countryId = $country->id;
        if (!($countryId == 1 || $countryId == 3 || ($countryId >= 25 && $countryId <= 50))) {
            $countryId = Country::where('id', 2)->first()->id;
        }
        $price = array();
        $timeLimit = array();
        $revenue = VendorRevenueRule::where('country_id', $countryId)
            ->whereNotNull('time_limit')
            ->orderBy('time_limit', 'ASC')
            ->with('country')
            ->get();
        foreach ($revenue as $key => $value) {
            $timeLimit[$key] = $value->time_limit;
            $price[$key] = $value->price;
        }// foreach
        $vendorRevenueValues = VendorRevenue::where("job_id", intval($job_id))
            ->where('default_revenue', 0)
            ->whereNull('vendor_id')
            ->whereNotNull('est_revenue_1')
            ->whereNotNull('est_revenue_2')
            ->whereNotNull('est_revenue_3')
            ->whereNotNull('est_revenue_4')
            ->whereNotNull('est_revenue_5')
            ->first();
        foreach ($vendors as $vendor) {
            $country = Country::where('id', intval($countryId))->first();
            $vendorassociation = new Association();
            $vendorassociation->admin_id = 1;
            $vendorassociation->accountmanager_id = $authuser->id;
            $vendorassociation->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendorassociation->vendor_id = $vendor['vendor']['id'];
            $vendorassociation->job_id = $job_id;
            $vendorassociation->job_status = 4;
            $vendorassociation->status_updated_by = $authuser->id;
            $vendorassociation->save();
            $amassociation = User::where('id', $vendor['vendor']['id'])->first();
            if ($job[0]->job_type_id == 2) {
                $bill_rates = JobOrders::where('id', $job_id)->get(['billrate', 'am_billRate', 'vendor_billRate']);
                $deviation_create = DeviationRequests::create([
                    'job_id' => $job_id,
                    'accountmanager_id' => $authuser->id,
                    'vendor_id' => $vendor['vendor']['id'],
                    'vendor_user_id' => $vendoruserID,
                    'billrate' => $bill_rates[0]['billrate'],
                    'am_billRate' => $bill_rates[0]['am_billRate'],
                    'vendor_billRate' => $bill_rates[0]['vendor_billRate'],
                    'vendor_deviation_rate' => 0,
                    'vendor_deviation_request' => 0,
                    'vendor_deviation_note' => ' '
                ]);
            }
            $vendoractivity = new Activity();
            $vendoractivity->name = "Job assigned to vendor";
            $vendoractivity->admin_id = 1;
            $vendoractivity->accountmanager_id = $authuser->id;
            $vendoractivity->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendoractivity->vendor_id = $vendor['vendor']['id'];
            $vendoractivity->job_id = $job_id;
            $vendoractivity->job_status = 4;
            $vendoractivity->activity_by = $authuser->id;
            $vendoractivity->is_vendor_sourcing_activity = 0;
            $vendoractivity->save();
            $vendoractivity_vsa = new Activity();
            $vendoractivity_vsa->name = "Job assigned to vendor";
            $vendoractivity_vsa->admin_id = 1;
            $vendoractivity_vsa->accountmanager_id = $authuser->id;
            $vendoractivity_vsa->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendoractivity_vsa->vendor_id = $vendor['vendor']['id'];
            $vendoractivity_vsa->job_id = $job_id;
            $vendoractivity_vsa->job_status = 4;
            $vendoractivity_vsa->activity_by = $authuser->id;
            $vendoractivity_vsa->is_vendor_sourcing_activity = 1;
            $vendoractivity_vsa->save();
            $hrs = date('H');
            $msg = "";
            //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
            if ($hrs > 0) $msg = "Good morning";      // After 6am
            if ($hrs > 12) $msg = "Good afternoon";    // After 12pm
            if ($hrs > 17) $msg = "Good evening";      // After 5pm
            if ($hrs > 23) $msg = "Go to bed!";        // After 10pm
            /* $vendorrevenue = new VendorRevenue();
            $vendorrevenue->job_id = (int) $job_id;
            $vendorrevenue->vendor_id = (int) $vendor['vendor']['id'];
            $vendorrevenue->default_revenue = 0;
            $vendorrevenue->est_revenue_1 = $vendorRevenueValues->est_revenue_1;
            $vendorrevenue->est_revenue_2 = $vendorRevenueValues->est_revenue_2;
            $vendorrevenue->est_revenue_3 = $vendorRevenueValues->est_revenue_3;
            $vendorrevenue->est_revenue_4 = $vendorRevenueValues->est_revenue_4;
            $vendorrevenue->est_revenue_5 = $vendorRevenueValues->est_revenue_5;
            $vendorrevenue->save();
            */
            $within5hrs = date('H:i d-m-Y', strtotime("now " . $timeLimit[0] . " minutes"));
            $after5hrs = date('H:i d-m-Y', strtotime("now " . $timeLimit[1] . " minutes"));
            $after24hours = date('H:i d-m-Y', strtotime("now " . $timeLimit[2] . " minutes"));
            $after7d = date('H:i d-m-Y', strtotime("now " . $timeLimit[3] . " minutes"));
            $after30d = date('H:i d-m-Y', strtotime("now " . $timeLimit[4] . " minutes"));
            $currency = $country->currency;
            $companyid = User::select('company_id')->where('id', $vendor['vendor']['id'])->get();
            $companyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
            //$subject = "Good Selection! " .$job_id. " assigned to " .$amassociation->first_name;
            $subject = "Good Selection! Job " . $job_id . "-" . $association_info['job']['name'] . " assigned to " . $companyname[0]->name;
            //$country = Country::where('is_enabled',1)->first();
            if ($job[0]->job_type_id == 2) {
                Mail::send('emails.makeMoneyContractType', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys, 'price1' => '', 'price2' => '', 'price3' => '', 'price4' => '', 'price5' => '', 'within5hrs' => $within5hrs, 'after5hrs' => $after5hrs, 'after24hours' => $after24hours, 'after7d' => $after7d, 'after30d' => $after30d, 'currencySymbol' => $currency], function ($m) use ($amassociation) {
                    $m->to($amassociation->email, 'New job assignment')->subject('New Job, As We Promised!');
                });
                Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info['accountmanager']['first_name'], 'industry' => $job[0]->Industry->name, 'candidateName' => '', 'vendorName' => $companyname[0]->name, 'jobName' => $association_info['job']['name'], 'jobId' => $job_id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'Job Assigned to Vendor'], function ($m) use ($association_info, $subject) {
                    $m->to($association_info['accountmanager']['email'], 'Job Assigned to Vendor')->subject($subject);
                });
            } else {
                // $amassociation->email = 'nagarjuna.ddgam@gmail.com';
                Mail::send('emails.makeMoney', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys, 'price1' => '', 'price2' => '', 'price3' => '', 'price4' => '', 'price5' => '', 'within5hrs' => $within5hrs, 'after5hrs' => $after5hrs, 'after24hours' => $after24hours, 'after7d' => $after7d, 'after30d' => $after30d, 'currencySymbol' => $currency], function ($m) use ($amassociation) {
                    $m->to($amassociation->email, 'New job assignment')->subject('New Job, As We Promised!');
                });
                Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info['accountmanager']['first_name'], 'industry' => $job[0]->Industry->name, 'candidateName' => '', 'vendorName' => $companyname[0]->name, 'jobName' => $association_info['job']['name'], 'jobId' => $job_id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'Job Assigned to Vendor'], function ($m) use ($association_info, $subject) {
                    $m->to($association_info['accountmanager']['email'], 'Job Assigned to Vendor')->subject($subject);
                });
            } //else
            $number = $amassociation->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hello " . $amassociation->first_name . ", Your account manager" . $authuser->first_name . " Allocated a new  assignment . Please check your dashboard for more details.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        $job[0]->status = 8;
        $job[0]->save();
        return response()->success(compact('vendorassociation'));
    }

    public function getEmpdashboardalerts()
    {
        $authuser = Auth::user();
        $empdashboardalerts = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 'inactive')->get();
        return response()->success(compact('empdashboardalerts'));
    }

    public function getVendordashboardalerts()

    {

        $authuser = Auth::user();

        $vendorjobs = array();

        if($authuser->parent_id) {

            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)

                            ->where('vendor_user_id',$authuser->id)

                            ->whereNotNull('job_id')

                            ->groupBy('job_id')->lists('job_id');

            $b=$vuseraccept=array();

            foreach($a as $c){array_push($b, $c);}

            $vendordashboard=Association::where('vendor_id',$authuser->parent_id)

                                                ->whereIn('job_id',$b)

                                                ->whereIn('job_status',[3,4])

                                                ->whereNotNull('accountmanager_id')

                                                ->whereNotNull('employer_id')

                                                ->whereNull('vendor_user_id')

                                                ->whereNull('employer_user_id')

                                                ->whereNull('candidate_id')

                                                ->where('is_talentpool',0)

                                                ->with('job_assigned.vendorrevenues')

                                                ->get();



            foreach($vendordashboard as $job){



                if($job['job_status'] == 3) {

                    $profiles_submitted=Activity::where('vendor_id',$authuser->parent_id)

                                            ->where('vendor_user_id',$authuser->id)

                                            ->where('job_id',$job['job_id'])

                                            ->whereNotNull('candidate_id')

                                            ->where('is_vendor_sourcing_activity',0)

                                            ->whereNull('status_id')

                                            ->whereNull('job_status')

                                            ->groupBy(array('candidate_id','job_id'))

                                            ->get();

                    if(!count($profiles_submitted) )

                    {

                        array_push($vendorjobs,$job->job_id);

                        if($job['job_status'] == 3)

                            array_push($vuseraccept,$job->job_id);

                    }

                } else { array_push($vendorjobs,$job->job_id); }

            }//foreach

            $vendordashboard=JobOrders::whereIn('id',$vendorjobs)->where('is_talentpool',0)

                                            ->where('status',8)

                                            ->where('notificationvendoruser', 0)

                                            ->with('vendorrevenues')

                                            ->get();

            foreach ($vendordashboard as $job) {

                $timestamp = 129346161081;

                $randomKey = '-';

                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                $check = in_array($job['id'], $vuseraccept);

                if($check){

                    //if(){}

                    $numbers = ['encrypted_jobId'=>$encrypted,'assignedToVendorUser'=>false,'vUserprofile'=>false];

                } else { $numbers = ['encrypted_jobId'=>$encrypted,'assignedToVendorUser'=>false,'vUserprofile'=>true];}



                $job['numbers'] = $numbers;

            }//foeach

        } else {



            $vendordashboard=Association::where('vendor_id',$authuser->id)

                                ->whereNotNull('accountmanager_id')

                                ->whereNotNull('employer_id')

                                ->whereNull('vendor_user_id')

                                ->whereNull('employer_user_id')

                                ->whereNotNull('job_id')

                                ->whereNull('candidate_id')

                                ->where('job_status',4)

                                ->where('is_talentpool',0)

                                ->with('JobType')

                                ->with('job_assigned.vendorrevenues')

                                ->get();



            foreach($vendordashboard as $job)

                {array_push($vendorjobs, $job->job_id);}



            $vendordashboard=JobOrders::whereIn('id',$vendorjobs)->where('is_talentpool',0)

                                ->where('status',8)

                                ->with('vendorrevenues')

                                ->get();

            $vendordashboard->map(function($q) use ($authuser){
             $possibleRevenues = DB::table('vendor_accountmanager_share')
                                            ->select('vendor_price')
                                            ->where('vendor_id', $authuser->id)
                                            ->where('job_id', $q->id)
                                            ->first();

            $q->possibleRevenues = $possibleRevenues;
 });



            foreach ($vendordashboard as $job) {

                $timestamp = 129346161081;

                $randomKey = '-';

                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                $assignVUser = VendorUserJob::where('job_id',$job['id'])->with('vendoruser')->get();



                if(count($assignVUser)){

                    $numbers = ['encrypted_jobId'=>$encrypted,'assignedToVendorUser'=>$assignVUser[0]['vendoruser']['first_name'],'vUserprofile'=>true];

                } else {

                    $numbers = ['encrypted_jobId'=>$encrypted,'assignedToVendorUser'=>false,'vUserprofile'=>true];

                }



                $job['numbers'] = $numbers;

            }//foeach

        }//else

        $ven = DeviationRequests::whereIn('vendor_deviation_request',[2,3,4])

                                                    ->where('vendor_id',$authuser->id)

                                                    ->with('job')

                                                    ->get();

            foreach ($ven as $job) {

                $timestamp = 129346161081;

                $randomKey = '-';

                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);

                $numbers = ['encrypted_jobId'=>$encrypted];

                $job['numbers'] = $numbers;

            }
           

              

          $arrayjobpending = count($ven);

          $arraypending = count($vendordashboard);

          $arr = array($arrayjobpending,$arraypending);

          $sumarray = array_sum($arr);




          $vendordashboardalerts[] = array('vendordashboardalerts'=>$vendordashboard,'noofprofiles' =>$sumarray);

        return response()->success(compact('vendordashboardalerts'));

    }

    public function getInprogressjobs()
    {
        $authuser = Auth::user();
        $authId = null;
		$no_of_profiles = 0;
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_user_id = array();
            foreach ($empActIds as $key => $value) {
                array_push($emp_user_id, $value);
            }
            $inprogressjob = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->whereIn('job_id', $emp_user_id)
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                })->orderBy('job_id', 'desc')
                ->get();
            foreach ($inprogressjob as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        } else {
            $inprogressjob = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                    $query->where('is_talentpool', '=', 0);
                })->orderBy('job_id', 'desc')
                ->get();
				
            $inprogresstalentpooljobs = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                    $query->where('is_talentpool', '=', 1);
                })
                ->get();
				
            foreach ($inprogressjob as $job) {
				
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId' => $encrypted, 'talentpool_notifications' => count($inprogresstalentpooljobs)];
                $job['numbers'] = $numbers;
				$no_of_profiles += $job['number_of_profiles'];
				
            }
        }
        $arrayjobpending = count($inprogressjob);
        $inprogressjobs[] = array('inprogressjobs' => $inprogressjob, 'noofprofiles' => $no_of_profiles);
        return response()->success(compact('inprogressjobs'));
    }

    public function getInprogresstalentpooljobs()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $empActIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $emp_user_id = array();
            foreach ($empActIds as $key => $value) {
                array_push($emp_user_id, $value);
            }
            $inprogresstalentpooljobs = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->whereIn('job_id', $emp_user_id)
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                    $query->where('is_talentpool', '=', 1);
                })
                ->get();
            foreach ($inprogresstalentpooljobs as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId' => $encrypted];
                $job['numbers'] = $numbers;
            }
        } else {
            $inprogresstalentpooljobs = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                    $query->where('is_talentpool', '=', 1);
                })
                ->get();
            $inprogressjobs = Association::select('job_id', DB::raw('count(*) as number_of_profiles'))
                ->where('candidate_status', 31)
                ->where('employer_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->groupBy('job_id')
                ->with('job')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 6);
                    $query->where('is_talentpool', '=', 0);
                })
                ->get();
            foreach ($inprogresstalentpooljobs as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId' => $encrypted, 'job_notifications' => count($inprogressjobs)];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('inprogresstalentpooljobs'));
    }

    public function getAssingedcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $candidates = Association::where('job_id', $id)
            ->where('candidate_status', '<>', 19)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->with('CandidatePoints')
            ->with('CandidateDetails')
            ->get();
        $associationsIds = array();
        foreach ($candidates as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
            // $assingedcandidates['colors'] =Colors::get();
        }
        $assingedcandidates = Association::whereIn('id', $associationsIds)
            ->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate'))
            ->with('CandidatePoints')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get()->toArray();

            
        $colors =Colors::get();	
    
        foreach($assingedcandidates as $key=>$value) {           
			$assingedcandidates[$key]['color'] = $colors[$key]->name;           
        
        }  
        
         //for job candidate selected status is 27
         $selectedcandidates= Association::whereIn('id', $associationsIds)
         ->where('candidate_status', '27')
         ->where('job_id', '=', $id)->get()->toArray();
       //get no of postions for that job
       $getpositions = JobOrders::select('vacancies')->where('id', $id)->get();         
       $position=array();
       if($getpositions[0]->vacancies >= count($selectedcandidates)){
         $position['position']='required position is fulfilled';
       } else {
         $position['position']='';
       }
        
        return response()->success(compact('assingedcandidates','position'));
    }

    public function postAssingedvendoruserjobcandidates()
    {
        $authuser = Auth::user();
        $vendorId = Input::get('vendorId');
        $id = Input::get('joborderId');
        $assingedvendoruserjobcandidates = Association::where('job_id', $id)->where('vendor_user_id', $vendorId)
            ->whereNotNull('candidate_status')
            ->whereNotNull('employer_id')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('assingedvendoruserjobcandidates'));
    }

    public function getAssingedvendorcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;

        } 
        else {
            $authId = $authuser->id;
        }
        $assingedvendorcandidates = Association::where('job_id', $id)
            ->where('vendor_id', $authId)
            ->whereNotNull('candidate_status')
            ->whereNotNull('employer_id')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with(array('CandidatePoints', 'Status', 'Candidate', 'job', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($assingedvendorcandidates as $candidate) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
            $candidate['talentmoning'] = $candidateTalentMine;
            $candidate['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;

            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
            $job_skills_required = explode(',', $candidate['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $candidate['candidate_id'])
                ->select('note_description')->get();
            $created_date = date('Y-m-d-H-i-s', strtotime($candidatenotes[0]['created_at']));
            $created_at = explode('-', $created_date);
            $date = new \DateTime($candidatenotes[0]['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidatenotes[0]['created_at'] = $date->format('Y-m-d H:i:s');
            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $colors =Colors::get();
            foreach($assingedvendorcandidates as $key=>$value) {
                $value['color'] = $colors[$key]->name;
            }

        }
        return response()->success(compact('assingedvendorcandidates'));
    }

    public function getRejectedvendorcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)
            ->where('vendor_id', $authuser->id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $rejectedids = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->where('vendor_id', $authuser->id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $associationsIds = array();
        foreach ($rejectedids as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedvendorcandidates = Association::whereIn('id', $associationsIds)
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('rejectedvendorcandidates'));
    }

    public function getAssingedvendorusercandidates($id)
    {
        $authuser = Auth::user();
        $assingedvendorusercandidates = Association::where('job_id', $id)->where('vendor_user_id', $authuser->id)
            ->whereNotNull('candidate_status')
            ->whereNotNull('employer_id')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('assingedvendorusercandidates'));
    }

    public function getRejectedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $amId = Association::where('job_id', $id)
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $rejectedids = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->get();
        $associationsIds = array();
        foreach ($rejectedids as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id', $associationsIds)
            ->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))->with('CandidatePoints')->with('CandidateDetails')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
		$jobInfo = DB::table('job_orders')->where('id',$id)->get();
		
        foreach ($rejectedcandidates as $job) {
			
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($job['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($job['candidate_id']);
            if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
                foreach($candidateTalentMine as $tkey =>$tvalue){
                    $note_name[1] = $job['Candidate']['full_name'];
                    $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                    $candidateTalentMine[$tkey]['description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $tvalue['description']);
                }
            }
            $job['talentmoning'] = $candidateTalentMine;
            $job['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $job['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $job['skils_block'] = $skils_block;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $job['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $job['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $job['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $job['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $job['job']['skills_preferred']);
            $job_skills_required = explode(',', $job['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $job['marge_skills'] = $obj;
            $job['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get()->toArray();
				
			if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
				if(is_array($candidatenotes) && count($candidatenotes)>0) {
					foreach($candidatenotes as $keys => $notes) {
						
						$note_name = str_word_count($notes['note_description'],1);	
						$note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
						$notes['note_description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $notes['note_description']);
						
						$pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
						preg_match_all($pattern, $notes['note_description'], $matches);
						
						$mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6); 
						$notes['note_description'] = preg_replace('/'.$matches[0][0].'/', $mask_email, $notes['note_description']);
						
						$phonePattern ='/[0-9]{3}[\-][0-9]{6}|[0-9]{3}[\s][0-9]{6}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{4}/';
						preg_match_all($phonePattern, $notes['note_description'], $phonematches);
						
                        if(!empty($phonematches[0][0])){
                            $phone_matches =$phonematches[0][0];
                        }else{
                            $phone_matches='0'; 
                        }
                    
						$mask_phone = substr_replace($phone_matches, str_repeat("x", strlen($phone_matches)), 2, strlen($phone_matches)-3); 
						$notes['note_description'] = preg_replace('/'.$phone_matches.'/', $mask_phone, $notes['note_description']);
						$candidatenotes[$keys]['note_description'] =$notes['note_description'];
					}
				}
		 	}
            $job['vendorcandidatenotes'] = $candidatenotes;
        }
		$rejectedcandidates = $rejectedcandidates->toArray();
		foreach($rejectedcandidates as $ky => $value) {
			if($jobInfo[0]->blindhire==1 && $value['candidate']['mask']==1) {
				$rejectedcandidates[$ky]['candidate']['full_name'] = substr_replace($value['candidate']['full_name'], str_repeat("X", strlen($value['candidate']['full_name'])), 2, strlen($value['candidate']['full_name'])-4);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $value['candidate']['executive_summary'], $notename);
                $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                $value['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $value['candidate']['executive_summary']);
                $note_name[1] = $value['candidate']['first_name'];
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $rejectedcandidates[$ky]['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $value['candidate']['executive_summary']); 
			}
		}
        return response()->success(compact('rejectedcandidates'));
    }

    public function getVendorrejectedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $amId = Association::where('job_id', $id)
            ->where('vendor_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $vendorrejectedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->where('vendor_id', $authId)
            ->where('accountmanager_id', $amId)
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->with(array('CandidatePoints', 'Status', 'Candidate', 'job', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })
            ->get();
			
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($vendorrejectedcandidates as $candidate) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
            $candidate['talentmoning'] = $candidateTalentMine;
            $candidate['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
            $job_skills_required = explode(',', $candidate['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $candidate['candidate_id'])
                ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $date = new \DateTime($candidate['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate['updated_at'] = $date->format('Y-m-d H:i:s');
            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
            $vendorID = User::where('id', $candidate['vendor_id'])->with('company')->get();
            //echo '<pre>'; print_r($vendorID); echo '</pre>';
            $vendorTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $vendorID[0]->company->timezone)->get();
            $candidate['vendorTimezone'] = $vendorTimezone[0]['timezone'];
            $candidate['vendorTimezoneOffset'] = $vendorTimezone[0]['GMT_offset'];
        }
        return response()->success(compact('vendorrejectedcandidates'));
    }

    public function getVendoruserrejectedcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)->where('vendor_id', $authuser->parent_id)->first()->accountmanager_id;
        $vendoruserrejectedcandidates = Association::where('job_id', $id)->whereIn('candidate_status', array(1, 2, 30))
            ->where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)
            ->whereNotNull('candidate_id')->whereNotNull('employer_id')->whereNotNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))->get();
        return response()->success(compact('vendoruserrejectedcandidates'));
    }

    public function postVendoruserjobrejectedcandidates()
    {
        $authuser = Auth::user();
        $vendorId = Input::get('vendorId');
        $id = Input::get('joborderId');
        $amId = Association::where('job_id', $id)
            ->where('vendor_id', $vendorId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $rejectedids = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->where('vendor_id', $vendorId)
            ->where('accountmanager_id', $amId)
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $associationsIds = array();
        foreach ($rejectedids as $candidate) {
            array_push($associationsIds, $candidate->id);
        }
        $vendoruserjobrejectedcandidates = Association::whereIn('id', $associationsIds)
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendoruserjobrejectedcandidates'));
    }

    public function getVendorpendingcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $amId = Association::where('job_id', $id)
            ->where('vendor_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $vendorpendingcandidates = Association::where('job_id', $id)
            ->where('candidate_status', 19)
            ->where('vendor_id', $authId)
            ->where('accountmanager_id', $amId)
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->with(array('CandidatePoints', 'Status', 'Candidate', 'job', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($vendorpendingcandidates as $candidate) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
            $candidate['talentmoning'] = $candidateTalentMine;
            $candidate['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
            $job_skills_required = explode(',', $candidate['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $candidate['candidate_id'])
                ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $date = new \DateTime($candidate['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate['updated_at'] = $date->format('Y-m-d H:i:s');
            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
            //echo $job->vendor_id;
            $vendorID = User::where('id', $candidate['vendor_id'])->with('company')->get();
            //echo '<pre>'; print_r($vendorID); echo '</pre>';
            $vendorTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $vendorID[0]->company->timezone)->get();
            $candidate['vendorTimezone'] = $vendorTimezone[0]['timezone'];
            $candidate['vendorTimezoneOffset'] = $vendorTimezone[0]['GMT_offset'];
        }
        return response()->success(compact('vendorpendingcandidates'));
    }

    public function postVendoruserjobpendingcandidates()
    {
        $authuser = Auth::user();
        $vendorId = Input::get('vendorId');
        $id = Input::get('joborderId');
        $amId = Association::where('job_id', $id)
            ->where('vendor_id', $vendorId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $vendoruserjobpendingcandidates = Association::where('job_id', $id)
            ->where('candidate_status', 19)
            ->where('vendor_id', $vendorId)
            ->where('accountmanager_id', $amId)
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendoruserjobpendingcandidates'));
    }

    /*Get All Account manager short listed jobs(Pending Jobs)*/
    public function getAllpendingcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $candidates = Association::where('job_id', $id)
            ->where('candidate_status', 31)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $associationsIds = array();
        foreach ($candidates as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $allpendingcandidates = Association::whereIn('id', $associationsIds)->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations'))->with('CandidatePoints')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
        foreach ($allpendingcandidates as $job) {
                $jobInfo = DB::table('job_orders')->where('id', $id)->get();
            if($jobInfo[0]->blindhire==1 && $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }

            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $id);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get();
            $job['vendorcandidatenotes'] = $candidatenotes;
        }
        return response()->success(compact('allpendingcandidates'));
    }

    public function getAllcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;      
        $candidates = Association::where('job_id', $id)
            ->where('candidate_status', '<>', 19)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        $associationsIds = array();
        foreach ($candidates as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
            /*echo '<pre>'; print_r(date_format($candidate['candidate']['updated_at'], 'Y-m-d H:i:s')); echo '</pre>';*/

            $date = new \DateTime($candidate->candidate->updated_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate->candidate->updated_at = $date->format('Y-m-d H:i:s');
            $candidate->candidate->timezoneName = $empTimezone[0]['timezone'];
            //$candidate->timezone = $empTimezone[0]['GMT_offset'];
        }
        //print_r($vendorCompanyID);
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $allcandidates = Association::whereIn('id', $associationsIds)->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))->with('CandidatePoints', 'vendor', 'vendor.company')->with('CandidateDetails')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
		$jobInfo = DB::table('job_orders')->where('id',$id)->get();
		
        foreach ($allcandidates as $ky => $job) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($job['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($job['candidate_id']);
            if($jobInfo[0]->blindhire==1 || $job['Candidate']['mask']==1) {
                foreach($candidateTalentMine as $tkey =>$tvalue){
                    $note_name[1] = $job['Candidate']['full_name'];
                    $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                    $candidateTalentMine[$tkey]['description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $tvalue['description']);
                }
            }
            $job['talentmoning'] = $candidateTalentMine;
            $job['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $job['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $job['skils_block'] = $skils_block;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $id);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $job['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $job['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $job['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $job['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $job['job']['skills_preferred']);
            $job_skills_required = explode(',', $job['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $job['marge_skills'] = $obj;
            $job['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get()->toArray();
				
			if($jobInfo[0]->blindhire==1 || $job['Candidate']['mask']==1) {
				if(is_array($candidatenotes) && count($candidatenotes)>0) {
					foreach($candidatenotes as $keys => $notes) {
						
						$note_name = str_word_count($notes['note_description'],1);	
						$note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
						$notes['note_description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $notes['note_description']);
						
						$pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
						preg_match_all($pattern, $notes['note_description'], $matches);
						
						$mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6); 
						$notes['note_description'] = preg_replace('/'.$matches[0][0].'/', $mask_email, $notes['note_description']);
						
						$phonePattern ='/[0-9]{3}[\-][0-9]{6}|[0-9]{3}[\s][0-9]{6}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{4}/';
						preg_match_all($phonePattern, $notes['note_description'], $phonematches);
                        if(!empty($phonematches[0][0])){
                            $phone_matches =$phonematches[0][0];
                        }else{
                            $phone_matches='0'; 
                        }
						
						$mask_phone = substr_replace($phone_matches, str_repeat("x", strlen($phone_matches)), 2, strlen($phone_matches)-3); 
						$notes['note_description'] = preg_replace('/'.$phone_matches.'/', $mask_phone, $notes['note_description']);
						$candidatenotes[$keys]['note_description'] =$notes['note_description'];
					}
				}
		 	}
            $job['vendorcandidatenotes'] = $candidatenotes;
            $date = new \DateTime($job['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $job['updated_at'] = $date->format('Y-m-d H:i:s');
            $job['timezone'] = $empTimezone[0]['GMT_offset'];
            //echo $job->vendor_id;
            $vendorID = User::where('id', $job->vendor_id)->with('company')->get();
            //echo '<pre>'; print_r($vendorID); echo '</pre>';
            $vendorTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $vendorID[0]->company->timezone)->get();
            $job['vendorTimezone'] = $vendorTimezone[0]['timezone'];
            $job['vendorTimezoneOffset'] = $vendorTimezone[0]['GMT_offset'];
        }
		$allcandidates = $allcandidates->toArray();
		foreach($allcandidates as $ky => $value) {
			if($jobInfo[0]->blindhire==1 || $value['candidate']['mask']==1) {
				
				$allcandidates[$ky]['candidate']['full_name'] = substr_replace($value['candidate']['full_name'], str_repeat("X", strlen($value['candidate']['full_name'])), 2, strlen($value['candidate']['full_name'])-4);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $value['candidate']['executive_summary'], $notename);
                $allcandidates[$ky]['candidate']['email'] = substr_replace($value['candidate']['email'], str_repeat("X", strlen($value['candidate']['email'])), 2, strlen($value['candidate']['email'])-4);
                $allcandidates[$ky]['candidate']['phone'] = substr_replace($value['candidate']['phone'], str_repeat("X", strlen($value['candidate']['phone'])), 2, strlen($value['candidate']['phone'])-4);
                /*$note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                $value['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $value['candidate']['executive_summary']);*/
                $note_name[1] = $value['candidate']['first_name'];
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $allcandidates[$ky]['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $value['candidate']['executive_summary']); 
			}
		}
		//print_r($allcandidates);exit;
        return response()->success(compact('allcandidates'));
    }

    public function postAllcandidates1()
    {
        $authuser = Auth::user();
        $joborderId = Input::get('JobOrderId');
        $canId = Input::get('canId');
        $decryption_canid = base64_decode($canId);
        $can_id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);
        $decryption_jobid = base64_decode($joborderId);
        $id = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        $amId = Association::where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $candidates = Association::where('job_id', $id)
            ->where('candidate_status', '<>', 19)
            ->where('candidate_id', $can_id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $associationsIds = array();
        foreach ($candidates as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $allcandidates = Association::whereIn('id', $associationsIds)->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations'))->with('CandidatePoints')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
        foreach ($allcandidates as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $id);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid, 'role_id' => $authuser->role_id];
            $job['numbers'] = $numbers;
            preg_match_all('!\d+!', $job['Candidate']['html_code'], $matches);
            $longest = 0;
            for ($i = 0; $i < count($matches[0]); $i++) {
                if ($i > 0) {
                    if (strlen($matches[0][$i]) > strlen($matches[0][$longest])) {
                        $longest = $i;
                        if ($matches[0][$longest] >= 10) {
                            $mobile_number = $matches[0][$longest];
                        } else {
                        }
                    }
                }
            }
            $job['Candidate']['html_code'] = str_replace($mobile_number, "xxxxxxxxxxxx", $job['Candidate']['html_code']);
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get();
            $job['vendorcandidatenotes'] = $candidatenotes;
        }
		
        return response()->success(compact('allcandidates'));
    }

    public function getShortlistedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $shortlistedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26))
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate', 'candidate.candidate_operational_skill', 'candidate.educations', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))->with('CandidatePoints')
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
		$jobInfo = DB::table('job_orders')->where('id',$id)->get();
		
        foreach ($shortlistedcandidates as $job) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($job['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($job['candidate_id']);
            if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
                foreach($candidateTalentMine as $tkey =>$tvalue){
                    $note_name[1] = $job['Candidate']['full_name'];
                    $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                    $candidateTalentMine[$tkey]['description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $tvalue['description']);
                }
            }
            $job['talentmoning'] = $candidateTalentMine;
            $job['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $job['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $job['skils_block'] = $skils_block;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $job['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $job['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $job['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $job['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $job['job']['skills_preferred']);
            $job_skills_required = explode(',', $job['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $job['marge_skills'] = $obj;
            $job['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description', 'created_at', 'updated_at')->get()->toArray();
			if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
				if(is_array($candidatenotes) && count($candidatenotes)>0) {
					foreach($candidatenotes as $keys => $notes) {
						
						$note_name = str_word_count($notes['note_description'],1);	
						$note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
						$notes['note_description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $notes['note_description']);
						
						$pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
						preg_match_all($pattern, $notes['note_description'], $matches);
						
						$mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6); 
						$notes['note_description'] = preg_replace('/'.$matches[0][0].'/', $mask_email, $notes['note_description']);
						
						$phonePattern ='/[0-9]{3}[\-][0-9]{6}|[0-9]{3}[\s][0-9]{6}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{4}/';
						preg_match_all($phonePattern, $notes['note_description'], $phonematches);
						
                        if(!empty($phonematches[0][0])){
                            $phone_matches =$phonematches[0][0];
                        }else{
                            $phone_matches='0'; 
                        }                    
						$mask_phone = substr_replace($phone_matches, str_repeat("x", strlen($phone_matches)), 2, strlen($phone_matches)-3); 
						$notes['note_description'] = preg_replace('/'.$phone_matches.'/', $mask_phone, $notes['note_description']);
						
						$candidatenotes[$keys]['note_description'] =$notes['note_description'];
					}
				}
		 	}
            $created_date = date('Y-m-d-H-i-s', strtotime($candidatenotes[0]['created_at']));
            $created_at = explode('-', $created_date);
            $date = new \DateTime($candidatenotes[0]['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidatenotes[0]['created_at'] = $date->format('Y-m-d H:i:s');
            $candidatenotes[0]['timezone'] = $empTimezone[0]['GMT_offset'];
            $job['vendorcandidatenotes'] = $candidatenotes;
        }
		$shortlistedcandidates = $shortlistedcandidates->toArray();
		foreach($shortlistedcandidates as $ky => $value) {
			if($jobInfo[0]->blindhire==1 && $value['candidate']['mask']==1) {
				
				$shortlistedcandidates[$ky]['candidate']['full_name'] = substr_replace($value['candidate']['full_name'], str_repeat("X", strlen($value['candidate']['full_name'])), 2, strlen($value['candidate']['full_name'])-4);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $value['candidate']['executive_summary'], $notename);
                $note_name_mask = substr_replace(isset($notename[0][0])?$notename[0][0]:'', str_repeat("X", strlen(isset($notename[0][0])?$notename[0][0]:'')), 0, strlen(isset($notename[0][0])?$notename[0][0]:'')-0); 
                $notename=isset($notename[0][0])?$notename[0][0]:'';
                $value['candidate']['executive_summary'] = preg_replace('/'.$notename.'/', $note_name_mask, $value['candidate']['executive_summary']);
                $note_name[1] = $value['candidate']['first_name'];
                $note_name_mask = substr_replace(isset($note_name[1])?$note_name[1]:'', str_repeat("X", strlen(isset($note_name[1])?$note_name[1]:'')), 2, strlen(isset($note_name[1])?$note_name[1]:'')-4);
                $note_name=isset($note_name[1])?$note_name[1]:'';
                $shortlistedcandidates[$ky]['candidate']['executive_summary'] = preg_replace('/'.$note_name.'/', $note_name_mask, $value['candidate']['executive_summary']); 
			}
		}
        return response()->success(compact('shortlistedcandidates'));
    }

    public function getVendorshortlistedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $vendorshortlistedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26, 31))
            ->where('vendor_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('CandidatePoints', 'Status', 'Candidate', 'job', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($vendorshortlistedcandidates as $candidate) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
            $candidate['talentmoning'] = $candidateTalentMine;
            $candidate['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
            $job_skills_required = explode(',', $candidate['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $candidate['candidate_id'])
                ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
            $created_at = explode('-', $created_date);
            $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');
            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
        }
        return response()->success(compact('vendorshortlistedcandidates'));
    }

    public function getVendorusershortlistedcandidates($id)
    {
        $authuser = Auth::user();
        $vendorusershortlistedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26, 31))
            ->where('vendor_id', $authuser->parent_id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendorusershortlistedcandidates'));
    }

    public function postVendoruserjobshortlistedcandidates()
    {
        $authuser = Auth::user();
        $id = Input::get('joborderId');
        $vendorId = Input::get('vendorId');
        $vendoruserjobshortlistedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(5, 17, 18, 20, 21, 22, 23, 24, 25, 26, 31))
            ->where('vendor_id', $vendorId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendoruserjobshortlistedcandidates'));
    }

    public function getSelectedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $selectedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', [27, 28])
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))
            ->with('CandidatePoints')
            ->with('CandidateDetails')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            /*->with(['CandidateNotes' => function($query) {
                                return $query->select(['note_description', 'updated_at']);
                            }])*/
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
		
		$jobInfo = DB::table('job_orders')->where('id',$id)->get();
        foreach ($selectedcandidates as $job) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($job['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($job['candidate_id']);
            if($jobInfo[0]->blindhire==1 || $job['Candidate']['mask']==1) {
                foreach($candidateTalentMine as $tkey =>$tvalue){
                    $note_name[1] = $job['Candidate']['full_name'];
                    $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                    $candidateTalentMine[$tkey]['description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $tvalue['description']);
                }
            }
            $job['talentmoning'] = $candidateTalentMine;
            $job['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $job['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $job['skils_block'] = $skils_block;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $job['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $job['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $job['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $job['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $job['job']['skills_preferred']);
            $job_skills_required = explode(',', $job['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $job['marge_skills'] = $obj;
            $job['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get()->toArray();
			
			if($jobInfo[0]->blindhire==1 || $job['Candidate']['mask']==1) {
				if(is_array($candidatenotes) && count($candidatenotes)>0) {
					foreach($candidatenotes as $keys => $notes) {
						
						$note_name = str_word_count($notes['note_description'],1);	
						$note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
						$notes['note_description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $notes['note_description']);
						
						$pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
						preg_match_all($pattern, $notes['note_description'], $matches);
						
						$mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6); 
						$notes['note_description'] = preg_replace('/'.$matches[0][0].'/', $mask_email, $notes['note_description']);
						
						$phonePattern ='/[0-9]{3}[\-][0-9]{6}|[0-9]{3}[\s][0-9]{6}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{4}/';
						preg_match_all($phonePattern, $notes['note_description'], $phonematches);
                        if(!empty($phonematches[0][0])){
                            $phone_matches =$phonematches[0][0];
                        }else{
                            $phone_matches='0'; 
                        }
						
						$mask_phone = substr_replace($phone_matches, str_repeat("X", strlen($phone_matches)), 2, strlen($phone_matches)-3); 
						$notes['note_description'] = preg_replace('/'.$phone_matches.'/', $mask_phone, $notes['note_description']);
						$candidatenotes[$keys]['note_description'] =$notes['note_description'];
					}
				}
		 	}
            $job['vendorcandidatenotes'] = $candidatenotes;
            $created_date = date('Y-m-d-H-i-s', strtotime($job['CandidateNotes']['updated_at']));
            $created_at = explode('-', $created_date);
            $date = new \DateTime($job['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $job['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');
            $job['timezone'] = $empTimezone[0]['GMT_offset'];
        }
		$selectedcandidates = $selectedcandidates->toArray();
		foreach($selectedcandidates as $ky => $value) {
			if($jobInfo[0]->blindhire==1 || $value['candidate']['mask']==1) {
				
				$selectedcandidates[$ky]['candidate']['full_name'] = substr_replace($value['candidate']['full_name'], str_repeat("X", strlen($value['candidate']['full_name'])), 2, strlen($value['candidate']['full_name'])-4);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $value['candidate']['executive_summary'], $notename);
                $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                $value['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $value['candidate']['executive_summary']);
                $note_name[1] = $value['candidate']['first_name'];
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $selectedcandidates[$ky]['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $value['candidate']['executive_summary']); 
			}
		}
        return response()->success(compact('selectedcandidates'));
    }

    public function getVendorselectedcandidates($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $vendorselectedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', [27, 28])
            ->where('vendor_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('CandidatePoints', 'Status', 'Candidate', 'job', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills','vendor'))
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->with('CandidateNotes')
            ->with('CandidateDetails')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($vendorselectedcandidates as $candidate) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
            $candidate['talentmoning'] = $candidateTalentMine;
            $candidate['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
            $job_skills_required = explode(',', $candidate['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $candidate['candidate_id'])
                ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $created_date = date('Y-m-d-H-i-s', strtotime($candidatenotes[0]['created_at']));
            $created_at = explode('-', $created_date);
            $date = new \DateTime($candidatenotes[0]['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidatenotes[0]['created_at'] = $date->format('Y-m-d H:i:s');
            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
        }
        return response()->success(compact('vendorselectedcandidates'));
    }

    public function getVendoruserjobselectedcandidates($id)
    {
        $authuser = Auth::user();
        $vendoruserjobselectedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', [27, 28])
            ->where('vendor_id', $authuser->parent_id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('vendor_user_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendoruserjobselectedcandidates'));
    }

    public function getGdprdata($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $gdprdata = GdprData::where('job_id', $job_id)->where('vendor_id', $authuser->parent_id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        } else {
            $authId = $authuser->id;
            $gdprdata = GdprData::where('job_id', $job_id)->where('vendor_id', $authuser->id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        }
        return response()->success($gdprdata);
    }

        public function getGdprdataam($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        $assignedalljobs = Association::where('accountmanager_id', $authuser->id)
            ->where('job_id',$job_id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNotNull('candidate_id')
            ->get();
            foreach ($assignedalljobs as $key ) {
            $gdprdataam = GdprData::where('job_id', $key['job_id'])->where('vendor_id',$key['vendor_id'])->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
         }
        return response()->success($gdprdataam);
    }

    public function getJobgdprcandidates($job_id)
    {
        $authuser = Auth::user();
        $job_data = JobOrders::where('id', $job_id)->get(['gdprmandatory']);
        if ($job_data[0]['gdprmandatory']) {
            $jobgdprdata = GdprData::where('job_id', $job_id)->whereIn('status', [0, 2])->with('job.JobType')->with('job.industry')->with('job.JobCitys')->get();
            return response()->success($jobgdprdata);
        } else {
            $receivedProfiles = Association::where('job_id', $job_id)
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')->with('candidate')
                ->whereNotNull('vendor_id')->with('vendor.company')
                ->get();
            foreach ($receivedProfiles as $candidatedata) {
                $gdpr_count = GdprData::where('job_id', $job_id)
                    ->where('candidate_id', $candidatedata['candidate']['id'])
                    ->where('vendor_id', $candidatedata['vendor']['id'])
                    ->count();
                if ($gdpr_count == 0) {
                    $job_data = JobOrders::where('id', $job_id)->get(['name']);
                    $gdprdata = new GdprData();
                    $gdprdata->job_id = $job_id;
                    $gdprdata->job_name = $job_data[0]['name'];
                    $gdprdata->candidate_id = $candidatedata['candidate']['id'];
                    $gdprdata->name = $candidatedata['candidate']['full_name'];
                    $gdprdata->vendor_id = $candidatedata['vendor']['id'];
                    $gdprdata->vendor_name = $candidatedata['vendor']['company']['name'];
                    $gdprdata->vendor_email = $candidatedata['vendor']['email'];
                    $gdprdata->candidate_no = $candidatedata['candidate']['phone'];
                    $gdprdata->candidate_email = $candidatedata['candidate']['email'];
                    $gdprdata->agreed_period = "3 Months";
                    $gdprdata->ip_address = "This is System Generated GDPR";
                    $gdprdata->status = 1;
                    $gdprdata->save();
                }
            }
            $jobgdprdata = GdprData::where('job_id', $job_id)->whereIn('status', [0, 2])->with('job.JobType')->with('job.industry')->with('job.JobCitys')->get();
            return response()->success($jobgdprdata);
        }
    }

    public function getAmgdprdata()
    {
        $authuser = Auth::user();
        $job_data = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->groupBy('job_id')
            ->get(['job_id']);
        $jobIds = array();
        foreach ($job_data as $jobdata) {
            array_push($jobIds, $jobdata->job_id);
        }
        $vendordata = Association::where('accountmanager_id', $authuser->id)
            ->where('is_removed', 0)
            ->whereNotNull('vendor_id')
            ->whereNull('employer_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('job_id')
            ->whereNull('candidate_id')
            ->get(['vendor_id']);
        $vendorsId = array();
        foreach ($vendordata as $joborderdata) {
            array_push($vendorsId, $joborderdata->vendor_id);
        }
        $amvendors = array_unique($vendorsId);
        $amgdprdata = GdprData::with('job.JobType')
            ->with('job.industry')
            ->with('job.JobCitys')
            ->with('candidate')
            ->where('status', 1)
            ->whereIn('vendor_id', $amvendors)
            ->whereIn('job_id', $jobIds)
            ->get();
        return response()->success(compact('amgdprdata'));
    }

    public function getAmgdprpendingdata()
    {
        $authuser = Auth::user();
        $job_data = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->groupBy('job_id')
            ->get(['job_id']);
        $jobIds = array();
        foreach ($job_data as $jobdata) {
            array_push($jobIds, $jobdata->job_id);
        }
        $vendordata = Association::where('accountmanager_id', $authuser->id)
            ->where('is_removed', 0)
            ->whereNotNull('vendor_id')
            ->whereNull('employer_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('job_id')
            ->whereNull('candidate_id')
            ->get(['vendor_id']);
        $vendorsId = array();
        foreach ($vendordata as $joborderdata) {
            array_push($vendorsId, $joborderdata->vendor_id);
        }
        $amvendors = array_unique($vendorsId);
        $gdprstatus = DB::table("job_orders")->whereIn('id', $jobIds)->where('gdpr',1)->get(['id']);
         $jobIdss = array();
        foreach ($gdprstatus as $jobdata) {
            array_push($jobIdss, $jobdata->id);
        }
        $amgdprpendingdata = GdprData::with('job.JobType')
            ->with('job.industry')
            ->with('job.JobCitys')
            ->with('candidate')
            ->where('status', 0)
            ->whereIn('vendor_id', $amvendors)
            ->whereIn('job_id', $jobIdss)
            ->get();
        return response()->success(compact('amgdprpendingdata'));
    }

    public function getEmpgdprcandidatesdata($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $empgdprcandidatesdata = Association::where('job_id', $job_id)
            ->where('employer_id', $authuser->id)
            ->whereNotIn('candidate_status', [2, 1, 19])
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')->with('vendor')
            ->get();
        foreach ($empgdprcandidatesdata as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $eempgdprdata = GdprData::with('job.JobType')
                ->with('job.industry')
                ->with('job.JobCitys')
                /* ->where('status', 1) */
                ->where('candidate_id', $job['candidate_id'])
                ->where('job_id', $job['job_id'])
                ->get();
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'empgdprdata' => $eempgdprdata];
            $job['numbers'] = $numbers;
        }
        return response()->success($empgdprcandidatesdata);
    }

   public function getEmpgdprdata()
    {
        $authuser = Auth::user();
        $empjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('gdprmandatory', 1)->get();
        $empjobids = array();
        foreach ($empjobs as $job) {
            array_push($empjobids, $job->id);
        }
        $empgdprdatas = Association::whereIn('job_id', $empjobids)
            ->where('employer_id', $authuser->id)
            ->whereNotIn('candidate_status', [2, 1, 19])
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')->with('candidate')->with('status')->with('job')->with('vendor')
            ->get();

             $empgdprdatas ->map(function($q) {
                 $timestamp = 129346161081;
                 $randomKey = '-';
                 $encrypted = base64_encode($timestamp . $randomKey . $q->job_id);
                 $encrypted_canId = base64_encode($timestamp . $randomKey . $q->candidate_id);
                 $eempgdprdata = GdprData::with('job.JobType')
                                ->with('job.industry')
                                ->with('job.JobCitys')
                                ->where('status', 1)
                                ->where('candidate_id', $q->candidate_id)
                                ->where('job_id', $q->job_id)
                                ->get();
                 $localArray = array('encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'empgdprdata' => $eempgdprdata);
                                $q->numbers = $localArray;
             });
            $empgdprdatas =  $empgdprdatas->filter(function ($item, $key) {
                    return count($item->numbers['empgdprdata'])> 0;
            });
            $empgdprdata = array();
            foreach ($empgdprdatas as $empgdprdataItem) {
                $empgdprdata[]=$empgdprdataItem;
            }
       return response()->success(compact('empgdprdata'));
    }

    public function getGdprdataaccept($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $gdprdataaccept = GdprData::where('job_id', $job_id)->where('status', 1)->where('vendor_id', $authuser->parent_id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        } else {
            $authId = $authuser->id;
            $gdprdataaccept = GdprData::where('job_id', $job_id)->where('status', 1)->where('vendor_id', $authuser->id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        }
        return response()->success($gdprdataaccept);
    }

    public function getGdprdataacceptam($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        $assignedalljobs = Association::where('accountmanager_id', $authuser->id)
            ->where('job_id',$job_id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNotNull('candidate_id')
            ->get();
            foreach ($assignedalljobs as $key ) {
            $gdprdataacceptam = GdprData::where('job_id', $key['job_id'])->where('status', 1)->where('vendor_id',$key['vendor_id'])->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        
         }
        return response()->success(compact('gdprdataacceptam'));
    }

    public function getGdprdatareject($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $gdprdatareject = GdprData::where('job_id', $job_id)->whereIn('status', [0, 2])->where('vendor_id', $authuser->parent_id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        } else {
            $authId = $authuser->id;
            $gdprdatareject = GdprData::where('job_id', $job_id)->whereIn('status', [0, 2])->where('vendor_id', $authuser->id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        }
        return response()->success($gdprdatareject);
    }

    public function getGdprdatarejectam($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        $assignedalljobs = Association::where('accountmanager_id', $authuser->id)
            ->where('job_id',$job_id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNotNull('candidate_id')
            ->get();
            foreach ($assignedalljobs as $key ) {
           
            $gdprdatarejectam = GdprData::where('job_id', $key['job_id'])->whereIn('status', [0,2])->where('vendor_id',$key['vendor_id'])->with('job.JobType')->with('job.industry')->with('job.JobCitys')->with('candidate')->get();
        
         }
        return response()->success(compact('gdprdatarejectam'));
    }

    public function postVendoruserjobselectedcandidates()
    {
        $authuser = Auth::user();
        $id = Input::get('joborderId');
        $vendorId = Input::get('vendorId');
        $vendoruserjobselectedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', [27, 28])
            ->where('vendor_id', $vendorId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendoruserjobselectedcandidates'));
    }

    public function getVendorassingedcandidates($id)
    {
        $authuser = Auth::user();
        $vendorassingedcandidates = Association::where('job_id', $id)
            ->whereIn('candidate_status', array(1, 2, 3, 5, 6, 17, 18, 31, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30))
            ->where('vendor_id', $authuser->id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        return response()->success(compact('vendorassingedcandidates'));
    }

    public function getVendorassignedjobsall()
    {
        $authuser = Auth::user();
        $authId = null;
        $assigntovUser = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $vendorassignedjobsall = Association::whereIn('job_id', $b)
                ->where('vendor_id', $authuser->parent_id)
                ->whereNull('candidate_id')
                //->where('created_at','>=',$diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                //->whereNotNull('candidate_status')
                ->whereNull('employer_user_id')
                ->where('status_updated_by', $authuser->parent_id)
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedjobsall = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        }
        foreach ($vendorassignedjobsall as $job) {
            $amId = Association::select('job_id')->where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $candidates = Association::where('job_id', $job['job_id'])
                // select('id', 'admin_id', 'accountmanager_id', 'employer_id', 'employer_user_id', 'vendor_id', 'vendor_user_id', 'job_id', 'job_status', 'gdpr_status', 'candidate_id', 'candidate_status', 'is_removed')
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('vendor_user_id')
                ->with(array('Status', 'Candidate'))
                ->get();
            $associationsIds = array();
            foreach ($candidates as $candidate) {
                if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                }
            } //foreach
            $assingedcandidates = Association::whereIn('id', $associationsIds)->count();
            $vacancies = $job['job_assigned']['vacancies'];
            $a = (int)$vacancies;
            $expectedProfiles = $a * 3;
            $allProfiles = Association::select('candidate_status')
                ->where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                //->whereNotNull('candidate_status')
                ->whereNull('employer_user_id')
                ->select('candidate_status')
                ->where('status_updated_by', $authId)
                ->where('job_status', 3)
                ->get();
            $gdprPendingD = GdprData::select('job_id')->where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 0)
                ->count();
            $gdprRejected = GdprData::select('job_id')->where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 2)
                ->count();
            $gdprPending = $gdprPendingD + $gdprRejected;
            $gdprSuccess = GdprData::select('job_id')->where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 1)
                ->count();
            $gdprData = GdprData::select('job_id')->where('job_id', $job['job_id'])->where('vendor_id', $authId)->get();
            $rejectedProfiles = $shorlistedProfiles = $offeredProfiles = $holdProfiles = $interviwedProfiles = 0;
            if ($allProfiles) {
                foreach ($allProfiles as $allProfile) {
                    if (in_array($allProfile->candidate_status, array(1, 2, 30)))
                        $rejectedProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31)))
                        $shorlistedProfiles++;
                    if (in_array($allProfile->candidate_status, array(27, 28)))
                        $offeredProfiles++;
                    if (in_array($allProfile->candidate_status, array(24, 26)))
                        $holdProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30)))
                        $interviwedProfiles++;
                }
            }
            $vendorSourcingStatus = Activity::select('vendor_id')->where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('accountmanager_id')
                ->where('activity_by', $authId)
                ->whereNotNull('status_id')
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            if (!$authuser->parent_id) {
                $assigntovUser = Activity::where('vendor_id', $authuser->id)
                    ->whereNotNull('vendor_user_id')
                    ->where('job_id', intval($job['job_id']))
                    ->get();
                if (count($assigntovUser)) {
                    foreach ($assigntovUser as $user) {
                        $assigntovUser = $user['vendoruser']['first_name'];
                        $assigntovUser1[] = $user['vendoruser']['first_name'];
                    }
                } else {
                    $assigntovUser = null;
                    $assigntovUser1 = [];
                }
            } else {
                $assigntovUser = null;
                $assigntovUser1 = [];
            }
            $activityUsers = Activity::select('vendor_id', 'vendor_user_id', 'job_id', 'name')
                ->where('vendor_id', intval($authuser->id))
                ->where('name', 'Job assigned to vendor user')
                ->whereNotNull('vendor_user_id')
                ->where('job_id', intval($job['job_id']))
                ->distinct('vendor_user_id')
                ->get()->toArray();
            $checkifsourcingfinished = null;
            $count10 = null;
            $checkifsourcingfinished1 = 0;
            $checkifsourcingfinished1 = Activity::select('vendor_id')->where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->where('accountmanager_id', $amId)
                ->where('activity_by', $authId)
                ->where('status_id', intval(41))
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            if ($checkifsourcingfinished1) {
                $count10 = 10;
            }
            if ($count10 >= 10) {
                $checkifsourcingfinished = true;
            } else {
                $checkifsourcingfinished = false;
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            //Flipping effect numbers end
            $numbers = ['profilesReceived' => count($allProfiles), 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'vsaFlag' => $checkifsourcingfinished, 'encrypted_jobId' => $encrypted, 'assigntovUser' => $assigntovUser, 'assigntovUser1' => $assigntovUser1, 'gdprPending' => $gdprPending, 'gdprSuccess' => $gdprSuccess, 'gdprData' => $gdprData, 'activityUsers' => $activityUsers];
            $job['numbers'] = $numbers;
            $to = \Carbon\Carbon::parse($job->created_at);
            $from = Carbon::now();
            $diff_in_minutes = $to->diffInMinutes($from);
            $job['time_diff'] = $diff_in_minutes;
        }//foreach
        return response()->success(compact('vendorassignedjobsall'));
    }

    public function getVendorassignedjobs($count)
    {
        set_time_limit(300);
		//$count = 5000;
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $assigntovUser = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $vendorassignedjobs = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedjobs = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        }
        foreach ($vendorassignedjobs as $job) {
            $amId = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $candidates = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('vendor_user_id')
                ->with(array('Status', 'Candidate'))
                ->get();
            $associationsIds = array();
            foreach ($candidates as $candidate) {
                if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                }
            } //foreach
            $assingedcandidates = Association::whereIn('id', $associationsIds)->count();
            $vacancies = $job['job_assigned']['vacancies'];
            $a = (int)$vacancies;
            $expectedProfiles = $a * 3;
            // Get the flipping numbers start
            $allProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                //->whereNotNull('candidate_status')
                ->select('candidate_status')
                ->get();
            $gdprPendingD = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 0)
                ->count();
            $gdprRejected = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 2)
                ->count();
            $gdprPending = $gdprPendingD + $gdprRejected;
            $gdprSuccess = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 1)
                ->count();
            $gdprData = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->get();
            $rejectedProfiles = $shorlistedProfiles = $offeredProfiles = $holdProfiles = $interviwedProfiles = 0;
            if ($allProfiles) {
                foreach ($allProfiles as $allProfile) {
                    if (in_array($allProfile->candidate_status, array(1, 2, 30)))
                        $rejectedProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31)))
                        $shorlistedProfiles++;
                    if (in_array($allProfile->candidate_status, array(27, 28)))
                        $offeredProfiles++;
                    if (in_array($allProfile->candidate_status, array(24, 26)))
                        $holdProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30)))
                        $interviwedProfiles++;
                }
            }
            $vendorSourcingStatus = Activity::where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('accountmanager_id')
                ->where('activity_by', $authId)
                ->whereNotNull('status_id')
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            $vendorAcceptedAt = Activity::where('vendor_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_status', 3)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('accountmanager_id')
                ->where('activity_by', $authId)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->select('created_at')
                ->first();
            if (!$authuser->parent_id) {
                $assigntovUser = VendorUserJob::where('vendor_id', $authuser->id)
                    ->whereNotNull('vendor_user_id')
                    ->where('job_id', intval($job['job_id']))
                    ->get();
                if (count($assigntovUser)) {
                    foreach ($assigntovUser as $user) {
                        $assigntovUser = $user['vendoruser']['first_name'];
                        $assigntovUser1[] = $user['vendoruser']['first_name'];
                    }
                } else {
                    $assigntovUser = null;
                    $assigntovUser1 = [];
                }
            } else {
                $assigntovUser = null;
                $assigntovUser1 = [];
            }
            $activityUsers = Activity::select('vendor_id', 'vendor_user_id', 'job_id', 'name')
                ->where('vendor_id', intval($authuser->id))
                ->where('name', 'Job assigned to vendor user')
                ->whereNotNull('vendor_user_id')
                ->where('job_id', intval($job['job_id']))
                ->distinct('vendor_user_id')
                ->get()->toArray();
            $checkifsourcingfinished = null;
            $count10 = null;
            $checkifsourcingfinished1 = 0;
            $checkifsourcingfinished1 = Activity::where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->where('accountmanager_id', $amId)
                ->where('activity_by', $authId)
                ->where('status_id', intval(41))
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            if ($checkifsourcingfinished1) {
                $count10 = 10;
            }
            if ($count10 >= 10) {
                $checkifsourcingfinished = true;
            } else {
                $checkifsourcingfinished = false;
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            //Flipping effect numbers end
            $possibleRevenues = DB::table('vendor_accountmanager_share')
                ->select('vendor_price')
                ->where('vendor_id', $authId)
                ->where('job_id', $job['job_id'])
                ->get();
            //Flipping effect numbers end
            $numbers = ['profilesReceived' => count($allProfiles), 'possibleRevenues' => $possibleRevenues, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'vsaFlag' => $checkifsourcingfinished, 'encrypted_jobId' => $encrypted, 'assigntovUser' => $assigntovUser, 'assigntovUser1' => $assigntovUser1, 'gdprPending' => $gdprPending, 'gdprSuccess' => $gdprSuccess, 'gdprData' => $gdprData, 'activityUsers' => count($activityUsers)];
            $job['numbers'] = $numbers;
            if ($vendorAcceptedAt) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
            $to = \Carbon\Carbon::parse($job->created_at);
            $from = Carbon::now();
            $diff_in_minutes = $to->diffInMinutes($from);
            $job['time_diff'] = $diff_in_minutes;
        }//foreach
        return response()->success(compact('vendorassignedjobs'));
    }

    public function getVendoracceptedjobs()
    {
        $authuser = Auth::user();
        $authId = null;
        $assigntovUser = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $vendoracceptedjobs = Association::where('vendor_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        } else {
            $authId = $authuser->id;
            $vendoracceptedjobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
        }
        foreach ($vendoracceptedjobs as $job) {
            $amId = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $candidates = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('vendor_user_id')
                ->with(array('Status', 'Candidate'))
                ->get();
            $associationsIds = array();
            foreach ($candidates as $candidate) {
                if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                }
            } //foreach
            $assingedcandidates = Association::whereIn('id', $associationsIds)->count();
            $vacancies = $job['job_assigned']['vacancies'];
            $a = (int)$vacancies;
            $expectedProfiles = $a * 3;
            $allProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authId)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                //->whereNotNull('candidate_status')
                ->select('candidate_status')
                ->get();
            $gdprPendingD = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 0)
                ->count();
            $gdprRejected = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 2)
                ->count();
            $gdprPending = $gdprPendingD + $gdprRejected;
            $gdprSuccess = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->where('status', 1)
                ->count();
            $gdprData = GdprData::where('job_id', $job['job_id'])->where('vendor_id', $authId)->get();
            $rejectedProfiles = $shorlistedProfiles = $offeredProfiles = $holdProfiles = $interviwedProfiles = 0;
            if ($allProfiles) {
                foreach ($allProfiles as $allProfile) {
                    if (in_array($allProfile->candidate_status, array(1, 2, 30)))
                        $rejectedProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31)))
                        $shorlistedProfiles++;
                    if (in_array($allProfile->candidate_status, array(27, 28)))
                        $offeredProfiles++;
                    if (in_array($allProfile->candidate_status, array(24, 26)))
                        $holdProfiles++;
                    if (in_array($allProfile->candidate_status, array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30)))
                        $interviwedProfiles++;
                }
            }
            $vendorSourcingStatus = Activity::where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('accountmanager_id')
                ->where('activity_by', $authId)
                ->whereNotNull('status_id')
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            $vendorAcceptedAt = Activity::where('vendor_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_status', 3)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('accountmanager_id')
                ->where('activity_by', $authId)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->select('created_at')
                ->first();
            if (!$authuser->parent_id) {
                $assigntovUser = Activity::where('vendor_id', $authuser->id)
                    ->whereNotNull('vendor_user_id')
                    ->where('job_id', intval($job['job_id']))
                    ->get();
                if (count($assigntovUser)) {
                    $assigntovUser = $assigntovUser[0]['vendoruser']['first_name'];
                } else {
                    $assigntovUser = null;
                }
            } else {
                $assigntovUser = null;
            }
            $checkifsourcingfinished = null;
            $count10 = null;
            $checkifsourcingfinished1 = 0;
            $checkifsourcingfinished1 = Activity::where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->where('job_id', intval($job['job_id']))
                ->where('accountmanager_id', $amId)
                ->where('activity_by', $authId)
                ->where('status_id', intval(41))
                ->where('is_vendor_sourcing_activity', 1)
                ->count();
            if ($checkifsourcingfinished1) {
                $count10 = 10;
            }
            if ($count10 >= 10) {
                $checkifsourcingfinished = true;
            } else {
                $checkifsourcingfinished = false;
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            //Flipping effect numbers end
            $numbers = ['profilesReceived' => count($allProfiles), 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'vsaFlag' => $checkifsourcingfinished, 'encrypted_jobId' => $encrypted, 'assigntovUser' => $assigntovUser, 'gdprPending' => $gdprPending, 'gdprSuccess' => $gdprSuccess, 'gdprData' => $gdprData];
            $job['numbers'] = $numbers;
            if ($vendorAcceptedAt) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
            $to = \Carbon\Carbon::parse($job->created_at);
            $from = Carbon::now();
            $diff_in_minutes = $to->diffInMinutes($from);
            $job['time_diff'] = $diff_in_minutes;
        }//foreach
        return response()->success(compact('vendoracceptedjobs'));
    }

    public function getVendorassignedjobsclosed()
    {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $vendorassignedjobsclosed = Association::where('vendor_id', $authuser->parent_id)
                //->where('created_at','>=',$diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
            foreach ($vendorassignedjobsclosed as $job) {
                $amId = Association::where('job_id', $job['job_id'])
                    ->where('vendor_id', $authuser->parent_id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $candidates = Association::where('job_id', $job['job_id'])
                    ->where('vendor_id', $authuser->parent_id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->with(array('Status', 'Candidate'))
                    ->get();
                $associationsIds = array();
                foreach ($candidates as $candidate) {
                    if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                        array_push($associationsIds, $candidate->id);
                    } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                        array_push($associationsIds, $candidate->id);
                    }
                }
                $assingedcandidates = Association::whereIn('id', $associationsIds)
                    ->with(array('Status', 'Candidate'))
                    ->count();
                $vacancies = $job['job_assigned']['vacancies'];
                $a = (int)$vacancies;
                $expectedProfiles = $a * 3;
                $numbers = ['countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } else {
            $jobordersData = JobOrders::select('id')->where('status', 6)->get();
            $jobIds = array();
            foreach ($jobordersData as $joborderdata) {
                $candInfo = Association::where('job_id', $joborderdata->id)->whereNotNull('candidate_id')->get();
                if (count($candInfo) == 0) {
                    array_push($jobIds, $joborderdata->id);
                }
            }
            $vendorassignedjobsclosed = Association::select('job_id')->where('vendor_id', $authuser->id)
                ->whereNotIn('job_id', $jobIds)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->with('employer')
                ->with('employer.company')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->get();
            foreach ($vendorassignedjobsclosed as $job) {
                $amId = Association::where('job_id', $job['job_id'])
                    ->where('vendor_id', $authuser->id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNull('candidate_id')
                    ->first()->accountmanager_id;
                $candidates = Association::where('job_id', $job['job_id'])
                    ->where('vendor_id', $authuser->id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->with(array('Status', 'Candidate'))
                    ->get();
                $associationsIds = array();
                foreach ($candidates as $candidate) {
                    if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                        array_push($associationsIds, $candidate->id);
                    } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                        array_push($associationsIds, $candidate->id);
                    }
                }
                $assingedcandidates = Association::whereIn('id', $associationsIds)
                    ->with(array('Status', 'Candidate'))
                    ->count();
                $vacancies = $job['job_assigned']['vacancies'];
                $a = (int)$vacancies;
                $expectedProfiles = $a * 3;
                $numbers = ['countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        }
        return response()->success(compact('vendorassignedjobsclosed'));
    }

    public function getVendoruserassignedjobs()
    {
        $authuser = Auth::user();
        $vendoruserassignedjobs = Association::where('vendor_user_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_assigned.status', 'job_assigned.vendorrevenues')
            ->whereHas('job_assigned', function ($query) {
                $query->where('status', '=', 8);
            })
            ->get();
        foreach ($vendoruserassignedjobs as $job) {
            $amId = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $candidates = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->with(array('Status', 'Candidate'))
                ->get();
            $associationsIds = array();
            foreach ($candidates as $candidate) {
                if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                    array_push($associationsIds, $candidate->id);
                }
            }
            $assingedcandidates = Association::whereIn('id', $associationsIds)
                ->with(array('Status', 'Candidate'))
                ->count();
            $vacancies = $job['job_assigned']['vacancies'];
            $a = (int)$vacancies;
            $expectedProfiles = $a * 3;
            // Get the flipping numbers start
            $receivedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->parent_id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            //Flipping effect numbers end
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'countResumes' => $assingedcandidates, 'expectedProfiles' => $expectedProfiles, 'encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
        }//foreach
        return response()->success(compact('vendoruserassignedjobs'));
    }

    public function getAmverifyvendoralerts()
    {
        $authuser = Auth::user();
        $vendorIds = UserAssociation::where('assigned_to', $authuser->id)->get();
        $amVendorIds = array();
        foreach ($vendorIds as $vendorId) {
            array_push($amVendorIds, $vendorId->user_id);
        }
        $assignedJobIds = JobUsers::whereIn('user_id', $amVendorIds)->get();
        $amJobIds = array();
        foreach ($assignedJobIds as $assignedJobId) {
            array_push($amJobIds, $assignedJobId->job_orders_id);
        }
        $amverifyvendoralerts = JobResumes::whereIn('job_id', $amJobIds)->where('is_verified', 0)->get();
        return response()->success(compact('amverifyvendoralerts'));
    }

    public function checklistofvendor($jobid, $candid, $empid, $amid, $checklistid, $vendorId, $canStatus, $activityName, $vUserId)
    {
        $checklistassociation = new Association();
        $checklistassociation->admin_id = 1;
        $checklistassociation->job_id = $jobid;
        $checklistassociation->candidate_id = $candid;
        $checklistassociation->employer_id = $empid;
        $checklistassociation->accountmanager_id = $amid;
        $checklistassociation->vendor_user_id = $vUserId;
        $checklistassociation->vendor_checklist_id = $checklistid;
        $checklistassociation->save();
        $checklistactivity = new Activity();
        $checklistactivity->name = $activityName;
        $checklistactivity->admin_id = 1;
        $checklistactivity->accountmanager_id = $amid;
        $checklistactivity->employer_id = $empid;
        $checklistactivity->vendor_id = $vendorId;
        $checklistactivity->job_id = $jobid;
        $checklistactivity->candidate_id = $candid;
        $checklistactivity->candidate_status = $canStatus;
        $checklistactivity->activity_by = $vendorId;
        $checklistactivity->vendor_checklist_id = $checklistid;
        $checklistactivity->save();
        if ($vUserId) :
            $checklistactivity = new Activity();
            $checklistactivity->name = $activityName;
            $checklistactivity->admin_id = 1;
            $checklistactivity->accountmanager_id = $amid;
            $checklistactivity->employer_id = $empid;
            $checklistactivity->vendor_id = $vendorId;
            $checklistactivity->vendor_user_id = $vUserId;
            $checklistactivity->job_id = $jobid;
            $checklistactivity->candidate_id = $candid;
            $checklistactivity->candidate_status = $canStatus;
            $checklistactivity->activity_by = $vendorId;
            $checklistactivity->vendor_checklist_id = $checklistid;
            $checklistactivity->save();
        endif;
        return true;
    }

    public function directprofilesubmit($jobid, $candid, $empid, $amid, $vendorId, $canStatus, $vUserId, $msg, $check, $is_tpl)
    {
        $candidateassociation = new Association();
        $candidateassociation->admin_id = 1;
        $candidateassociation->accountmanager_id = $amid;
        $candidateassociation->employer_id = $empid;
        $candidateassociation->vendor_id = $vendorId;
        $candidateassociation->job_id = $jobid;
        $candidateassociation->candidate_id = $candid;
        $authuser = Auth::user();
        if($authuser->role_id ==9)
        {
            $candidateassociation->vendor_user_id = $vUserId;
        }
        if (!$check) :
            $candidateassociation->vendor_approval = 0;
        endif;
        if ($is_tpl == 1) {
            $candidateassociation->candidate_status = 31;
        } else {
            $candidateassociation->candidate_status = $canStatus;
        }
       // $candidateassociation->status_updated_by = $vendorId;
        $candidateassociation->save();
        $candidateactivity = new Activity();
        $candidateactivity->name = $msg;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $amid;
        $candidateactivity->employer_id = $empid;
        $candidateactivity->vendor_id = $vendorId;
        $candidateactivity->job_id = $jobid;
        $candidateactivity->candidate_id = $candid;
        $candidateactivity->candidate_status = $canStatus;
        $candidateactivity->activity_by = $vendorId;
        //$candidateactivity->vendor_user_id = $vUserId;
        $candidateactivity->save();
        if ($vUserId) :
            $candidateactivity = new Activity();
            $candidateactivity->name = $msg;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $amid;
            $candidateactivity->employer_id = $empid;
            $candidateactivity->vendor_id = $vendorId;
            $candidateactivity->vendor_user_id = $vUserId;
            $candidateactivity->job_id = $jobid;
            $candidateactivity->candidate_id = $candid;
            $candidateactivity->candidate_status = $canStatus;
            $candidateactivity->activity_by = $vendorId;
            $candidateactivity->save();
        endif;
        return true;
    }

    public function postCheckuserprofilevalidity()
    {
        $authuser = Auth::user();
        $job_id = Input::get('jobs');
        $vacancies = Input::get('positions');
        $candidate_id = Input::get('candidateId');
        $canskills = CandidateSkillsets::where('candidate_id', $candidate_id)->get();
        $candidate_operational_skills = CandidateOperationalSkills::where('candidate_id', $candidate_id)->get();
        $jobskills = JobOrders::where('id', $job_id)->get();
        $prefered_skills = $jobskills[0]['skills_preferred'];
        $prefered_skills = str_replace(",", " ", $prefered_skills);
        $prefered_skills = str_replace(" ,", " ", $prefered_skills);
        $prefered_skills = str_replace(", ", " ", $prefered_skills);
        $prefered_skills = str_replace("-", " ", $prefered_skills);
        $prefered_skills = strtolower(str_replace(array("&", "!", '"', ".", "'", "?", "\r", "\n"), '', $prefered_skills));
        $prefered_skills = explode(" ", $prefered_skills);
        $prefered_skills = array_unique($prefered_skills);
        $prefered_skills = array_filter($prefered_skills);
        //Filtering Candidate Data
        $paragraph2 = $canskills[0]['skill_set'];
        $paragraph2 = strtolower(str_replace(array("&", "!", '"', ".", "'", "?", "\r", "\n"), '', $paragraph2));
        $paragraph2 = str_replace(",", " ", $paragraph2);
        $paragraph2 = str_replace(" ,", " ", $paragraph2);
        $paragraph2 = str_replace(", ", " ", $paragraph2);
        $paragraph2 = str_replace("-", " ", $paragraph2);
        $paragraph2data = explode(" ", $paragraph2);
        $matches = array_intersect($prefered_skills, $paragraph2data);
        $similarity = round(count($matches) / (count($prefered_skills)) * 100);
        $employer_id = JobOrders::where('id', $job_id)->first()->user_id;
        $accountmanager_id = Association::where('vendor_id', $authuser->parent_id)
            ->whereNotNull('accountmanager_id')
            ->where('employer_id', $employer_id)
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->where('job_id', $job_id)
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $assignedJob = association::where('vendor_id', $authuser->parent_id)
            ->where('accountmanager_id', $accountmanager_id)
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->where('candidate_id', $candidate_id)
            ->count();
        if ($similarity >= 80) {
            $number = 1;
            return response()->success(compact('assignedJob', 'number'));
        } else if ($similarity >= 50) {
            $number = 2;
            return response()->success(compact('assignedJob', 'number'));
        } else if ($similarity < 50) {
            $number = 3; 
            return response()->success(compact('assignedJob', 'number'));
        }
    }


    public function postSubmitcandidates()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $settings = VendorUserSetting::where('vendor_user_id', intval($authuser->id))->first();
        } else {
            $authId = $authuser->id;
        }
        $job_id = Input::get('jobs');
		$json = Input::get('json');
        $fullname = Input::get('full_name');
        $work_autherization = Input::get('workautherization');
        $buy_out= Input::get('buyout');
        $getjobname = JobOrders::where('id', $job_id)->first()->name;
        $companyemail = Input::get('companyemail');
            $summary = '';
            $executiveSummary=null;
            $managementSummary=null;
            if( $json["Summary"] )
            { 
                $summary = (String) $json["Summary"]; }
            elseif( $json["ExecutiveSummary"] )
            { $executiveSummary = (String) $json["ExecutiveSummary"]; }
            elseif( $json["ManagementSummary"] )
            { $managementSummary = (String) $json["ManagementSummary"]; }
            $executiveSummary = (String) $json["ExecutiveSummary"];
            $managementSummary = (String) $json["ManagementSummary"];

            if($json["DateOfBirth"]){
                $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
            }
            if($json["CurrentLocation"]){
                $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
            }else{
                $curentlocation="";
            }
            if($json["PreferredLocation"]){
                $PreferredLocation=$json["PreferredLocation"];
            }else{
                $PreferredLocation="";
            }
            $alternate_email="";
            $recomon="";
            $SkillSet=$json["SegregatedSkill"];
            $allSkills = null;
            $operationalSkills = null;
            $softSkills=null;
            $operationalSkills=null;
            //concatenate all the skills and assign to a variable.
            foreach($SkillSet as $skill)
            {
                if( $allSkills)  {

                    $allSkills = $allSkills.', '. $skill["Skill"];
                    if($skill["Type"] == "SoftSkill"){
                        $softSkills = $softSkills.', '. $skill["Skill"];
                    }
                    if($skill["Type"] == "OperationalSkill"){
                        $operationalSkills = $operationalSkills.' '. $skill["Skill"];
                    }
                }
                else  {
                    $allSkills = $skill["Skill"];
                }
            }
            if((String) $json["WorkedPeriod"]["TotalExperienceInYear"] =='' || (String) $json["WorkedPeriod"]["TotalExperienceInYear"]==null){
                $tot_exp=0;
            }else{
                $tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            }

            if( ($summary == '' || $summary == null) && ($executiveSummary == '' || $executiveSummary == null)){
                $summary = (String) $json["Name"]["FullName"] ." is having ". $tot_exp ." years experience with following skills ".$allSkills;
            }

            /* if($json["PhoneNumber"]){
                $country_code = $json["PhoneNumber"][0]["ISDCode"];

            }else{
                $country_code = "";
            }*/
            //print_r($json); exit();
            if($json["CurrentLocation"]){
                $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
            }else{
                $curentlocation="";
            }
            if($json["PreferredLocation"]){
                $PreferredLocation=$json["PreferredLocation"];
            }else{
                $PreferredLocation="";
            }
            $alternate_email="";
         /*   if($json["Email"]){
                $email_new=$json["Email"][0]["EmailAddress"];
            }else{
                $email_new="";
            }*/
               if(!empty($json["Nationality"]) ){
                $nationality=$json["Nationality"];
            }else{
                $nationality=Input::get('nationality');
            }
            $phone_no = Input::get('phone');
            if($phone_no){
                $mobileNo=$phone_no;                
                $number = str_replace("-", "", $mobileNo);
                $number = str_replace(" ", "", $mobileNo);
                $mobile_new = $number;
            }else{
                $mobile_new="";
            }
            $recomon="";
            foreach ($json["Recommendations"] as $recomondation) {
                if(strlen($recomon) > 0){
                    $recomon = $recomon.', ';
                }
                $recomon = $recomon.$recomondation["PersonName"];
            }
            $languages_known="";
            foreach ($json["LanguageKnown"] as $recomondation) {
                if(strlen($languages_known) > 0){
                    $languages_known = $languages_known.', ';
                }
                $languages_known = $languages_known.$recomondation["Language"];
            }
            
            $note_description = Input::get('note_description');
            $email_new = Input::get('email');
            $country_code = Input::get('country_code');
            //print_r($json);
            $candidate = Candidate::create([
                'full_name' => (String) $fullname,
                'email' => (String) $email_new,
                'phone' => (String) $mobile_new,
                'mobile' => (String) $mobile_new,
                'country_code' => $country_code,
                'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                'gender' => (String) $json["Gender"],
                'job_profile' => $getjobname,
                'address' => (String) $json["Address"][0]["State"],
                'city' => (String) $json["Address"][0]["City"],
                'state' => (String) $json["Address"][0]["State"],
                'country' => (String) $json["Address"][0]["Country"],
                'zip' => (String) $json["Address"][0]["ZipCode"],
                'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                'total_experience_in_year' => $tot_exp,
                'asset_id' => $json["assetId"]["user_id"],
                'vendor_id' => $authuser->id,
                'summary' => $summary,
                'path' =>  $json["path"],
                'title' => (String) $json["Name"]["TitleName"],
                'first_name' => (String) $json["Name"]["FirstName"],
                'middle_name' => (String) $json["Name"]["MiddleName"],
                'last_name' => (String) $json["Name"]["LastName"],
                'father_name' => (String) $json["FatherName"],
                'mother_name' => (String) $json["MotherName"],
                'marital_status' => (String) $json["MaritalStatus"],
                'nationality' =>  $nationality,
                'language_known' => (String) $languages_known,
                'unique_id' => (String) $json["UniqueID"],
                'license_no' => (String) $json["LicenseNo"],
                'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                'pan_no' => (String) $json["PanNo"],
                'buyout' =>(String) $buy_out,
                'visa_status' => (String) $json["VisaStatus"],
                'alternate_email' =>(String) $alternate_email,
                'cover_letter' => (String) $json["Coverletter"],
                'certification' => (String) $json["Certification"],
                'publication' => (String) $json["Publication"],
                'current_location' =>(String) $curentlocation,
                'preferred_location' =>(String) $PreferredLocation,
                'availability' => (String) $json["Availability"],
                'objectives' => (String) $json["Objectives"],
                'candidate_references' => (String) $json["References"],
                'parsing_date' => (String) $json["ParsingDate"],
                'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                'resume_file_name' => (String) $json["ResumeFileName"],
                'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                'work_autherization' => $work_autherization,
                //'permanent_address' => (String) $dummy,
                // 'permanent_city' => (String) $dummy,
                // 'permanent_state' => (String) $dummy,
                // 'permanent_country' => (String) $dummy,
                // 'permanent_zip_code' => (String) $dummy,
                // 'formatted_permanent_address' =>(String) $dummy,
                'industry_category' => (String) $json["Category"],
                'industry_sub_category' => (String) $json["SubCategory"],
                'executive_summary' => $executiveSummary,
                'management_summary' => $managementSummary,
                'hobbies'=>$json['Hobbies'],
                'candidate_achievements'=>$json['Achievements'],
                'html_code'=>$json['HtmlResume'],
                'qualification'=>$json['Qualification'],
                'note' => $note_description,
                'is_privatearea'=>1
            ]);
             $SkillBlock = $json["SkillKeywords"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $SkillBlock = preg_replace('/[^a-zA-Z0-9]+ /','~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);

                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    $SkillBlock = $json["SkillBlock"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $SkillBlock = preg_replace('/[^a-zA-Z0-9]+ /','~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    // print_r( $skillsResumes);
                    //             die;
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } 
                            else {
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
                                
                        if(is_array($skillData) && count($skillData)>0) {
                            foreach($skillData as $ky => $val) {
                                $keyval = $val->keyval;
								if(!empty($keyval)){
									if($val->keyword=="skills") {
										DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
									} else {
											DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

									}
								}
                            }
                        }
                        DB::delete('delete from skillblock_temp');
                    }
            

            $candidate_response = response()->success(compact('candidate'));

            // Assign last candidate ID
            $lastCandidateId = $candidate->id;
            if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"] as $exp)
                {
                    if($exp['Employer'] != null && $exp["JobProfile"]["Title"] != null) {
                        $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                        //print_r($startDate);
                        $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'2 print_r le ke print karo
                        //print_r($endDate);kya problem hi
                        $candidate_exp = CandidateExperiences::create([
                            'employer_name' => $exp["Employer"]["EmployerName"],
                            'job_title' => $exp["JobProfile"]["Title"],
                            'empoyer_city' => $exp["Location"]["City"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' =>  date('Y-m-d', strtotime($endDate)),
                            'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                            'current_employer_name' => $json["CurrentEmployer"],
                            'total_experienceIn_months' => $json["WorkedPeriod"]["TotalExperienceInMonths"],
                            'total_experienceIn_year' => $json["WorkedPeriod"]["TotalExperienceInYear"],
                             'total_experienceIn_range' => $json["WorkedPeriod"]["TotalExperienceRange"],
                             'custom_fields' => $json["CustomFields"],

                            'candidate_id' => $lastCandidateId,
                        ]);
                        //print_r("ok");
                        $candidate_exp_response = response()->success(compact('candidate_exp'));
                    }
                }
                //candidate work history foreach
            } //if


            //Insert a record into candidateskillssets table
            $candidate_skill = CandidateSkillsets::create([
                'skill_set' => (string) $allSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_Set_response = response()->success(compact('candidate_skill'));
            $skills_new = '';
            $candidate_skills = CandidateSkills::create([
                'skills' => (string) $json["SkillKeywords"],//isko for each lagake aur implode karna hi
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_response = response()->success(compact('candidate_skills'));

            $candidate_operational_skills = CandidateOperationalSkills::create([
                'operational_skills' => (string) $operationalSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
            $candidate_soft_skills = CandidateSoftSkills::create([
                'soft_skills' => (string) $softSkills,
                'candidate_id' => $lastCandidateId,
            ]);

            $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
            // for only now
            foreach ($json["SegregatedQualification"] as $edu)
            {
                if(isset($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);
                    //print_r($edu["Degree"]["DegreeName"]);exit;
                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["Location"]["City"],
                        'degree' => $edu["Degree"]["DegreeName"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'measure_type' => $edu["Aggregate"]["MeasureType"],

                        'institution_type' => $edu["Institution"]["Type"],
                        'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                        'state' => $edu["Institution"]["Location"]["State"],
                        'country' => $edu["Institution"]["Location"]["Country"],
                        'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                        'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_educations_response = response()->success(compact('candidate_educations'));
                }
            } //foreach
            ///candidate-details//need to create model and send it to database
            $recomon="";
            foreach ($json["Recommendations"] as $recomondation) {
                if(strlen($recomon) > 0){
                    $recomon = $recomon.', ';
                }
                $recomon = $recomon.$recomondation["PersonName"];
            }
            $websites="";
            foreach ($json["WebSite"] as $recomondation) {
                if(strlen($websites) > 0){
                    $websites = $websites.', ';
                }
                $websites = $websites.$recomondation["Url"];
            }
            
            $candidate_details = CandidateDetails::create([
                'gapperiod' => (string) $json["GapPeriod"],
                'current_working_email' => (string) $companyemail,
                'averageStay' =>(string) $json["AverageStay"],
                'LongestStay' =>(string) $json["LongestStay"],
                'recommendations' =>(string) $recomon,
                'detail_resume' =>(string) $json["DetailResume"],
                'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                'websites' => (string) $websites,
                //'overalldata' => (string) $json,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_details_response = response()->success(compact('candidate_details'));

            foreach ($json["SegregatedSkill"] as $edu)
            {
                $segregatedskills = SegregatedSkill::create([
                    'type' => (string) $edu["Type"],
                    'skill' =>(string) $edu["Skill"],
                    'Ontology' =>(string) $edu["Ontology"],
                    'alias' =>(string) $edu["Alias"],
                    'formattedname' =>(string) $edu["FormattedName"],
                    'evidence' =>(string) $edu["Evidence"],
                    'lastused' => $edu["LastUsed"] == ''?DateTime::createFromFormat('d/m/Y h:i:s', $json["ParsingDate"])->format('d/m/Y'):(string) $edu["LastUsed"],
                    'experienceinmonths' => $edu['ExperienceInMonths'] == 0?$json["WorkedPeriod"]["TotalExperienceInMonths"]:$edu['ExperienceInMonths'],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregatedskills_response = response()->success(compact('segregatedskills'));

            }


            
            foreach ($json["SegregatedPublication"] as $edui)
            {
                $segregated_publication = SegregatedPublication::create([
                    'publication_title' => (string) $edui["PublicationTitle"],
                    'publisher_name' =>(string) $edui["Publisher"],
                    'publication_number' =>$edui["PublicationNumber"],
                    'publication_url' =>(string) $edui["PublicationUrl"],
                    'authors' =>(string) $edui["Authors"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id1' => $lastCandidateId,
                ]);
                $segregated_publication_response = response()->success(compact('segregated_publication'));

            }

            foreach ($json["Recommendations"] as $edui)
            {
                $recommendations = Recommendations::create([
                    'person_name' => (string) $edui["PersonName"],
                    'company_name' =>(string) $edui["CompanyName"],
                    'relation' =>$edui["Relation"],
                    'position_title' =>(string) $edui["PositionTitle"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $recommendations_response = response()->success(compact('recommendations'));

            }

            foreach ($json["SegregatedCertification"] as $edui)
            {
                $segregated_certification = SegregatedCertification::create([
                   'certification_title' => $edui["CertificationTitle"],
                    'authority' => $edui["Authority"],
                    'certification_code' =>$edui["CertificationCode"],
                    'is_expiry' => $edui["IsExpiry"],
                    'start_date' => $edui["StartDate"],
                    'end_date' =>$edui["EndDate"],
                    'certificationUrl' =>  $edui["CertificationUrl"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_certification_response = response()->success(compact('segregated_certification'));

            }


            foreach ($json["SegregatedAchievement"] as $edui)
            {
                $candidate_achievements = CandidateAchievements::create([
                    'award_title' => $edui["AwardTitle"],
                    'issuer' =>$edui["Issuer"],
                    'experience' =>  $json["Experience"],
                    'associated_with' => $edui["AssociatedWith"],
                    'issuing_date' => $edui["IssuingDate"],
                    'description' =>$edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
               $candidate_achievements_response = response()->success(compact('candidate_achievements'));

            }

            //Insert Successfull resume posting activity record
            $candidateResumePostIn = Activity::create([
                'person_id' => $authuser->id,
                'resume_id' => $lastCandidateId,
                'name' => 'Uploaded resume successfully',
            ]);
            $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
           //end mukesh	

        $present_salary = Input::get('present_salary');
        $expected_salary = Input::get('expected_salary');
        $present_location = Input::get('present_location');
        $citys = Input::get('relocate_locations');
        $notice_period_others = Input::get('notice_period_others');
        $relocate_locations1 = array();
        foreach($citys as $job_cities)
            {
               array_push($relocate_locations1, $job_cities['name']);
            }
        $relocate_locations = implode(",",$relocate_locations1);
        $notice_period = Input::get('notice_period');
        
        $candidate_id = $candidate->id;
        $job_id = Input::get('jobs');

        $candidate_json = DB::update("update  candidate_json  set flag='1' where job_id='".$job_id."' AND email='".$json["Email"][0]["EmailAddress"]."' ");
        $candidate_jsonn =  response()->success(compact('candidate_json'));
        $vendor_notes_data = new VendorCandidateNotes();
        $vendor_notes_data->present_salary = $present_salary;
        $vendor_notes_data->expected_salary = $expected_salary;
        $vendor_notes_data->note_description = $note_description;
        $vendor_notes_data->present_location = $present_location[0]['name'];
        $vendor_notes_data->relocate_locations = $relocate_locations;
        $vendor_notes_data->notice_period = $notice_period;
        $vendor_notes_data->candidate_id = $lastCandidateId;
        $vendor_notes_data->job_id = $job_id;
        $vendor_notes_data->notice_period_others = $notice_period_others;
        $vendor_notes_data->save();
        $vendor_notes_data =  response()->success(compact('vendor_notes_data'));
		
        //$job_id = Input::get('jobs');
        $vacancies = Input::get('positions');
        $candidate_id = $candidate->id;
        $ven_answer_emp_questions = Input::get('ven_answer_emp_questions');
        // if(is_array($ven_answer_emp_questions) && count($ven_answer_emp_questions)>0) {
        //     foreach($ven_answer_emp_questions as $key =>$value) {
        //         //print_r($value);exit;
        //         $sql = "insert into ven_emp_ques_ans set user_id='".$authId."', candidate_id='".$candidate_id."', job_id='".$job_id."',question_id='".$value['id']."',is_must='".$value['is_must']."'";
        //         DB::insert($sql);
        //     }
        // }
        $note = Input::get('note');
        $employer_id = JobOrders::where('id', $job_id)->first()->user_id;
        $position_name = JobOrders::where('id', $job_id)->first()->name;
        $is_tpl = JobOrders::where('id', $job_id)->first()->is_talentpool;
        $employer_country = User::where('id', $employer_id)->with('company')->get();
        $accountmanager_id = Association::where('vendor_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->where('employer_id', $employer_id)
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->where('job_id', $job_id)
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $assignedJob = association::where('vendor_id', $authId)
            ->where('accountmanager_id', $accountmanager_id)
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->where('candidate_id', $candidate_id)
            ->count();
        $countResumes = association::where('vendor_id', $authId)
            ->where('accountmanager_id', $accountmanager_id)
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->whereNotNull('candidate_id')
            ->whereNull('vendor_user_id')
            ->count();
        $a = (int)$vacancies;
        if ($countResumes < ($a * 9999)) {

            if ($assignedJob == 0) {
                if (!$authuser->parent_id) :
                    $res = self::directprofilesubmit($job_id, $candidate_id, $employer_id, $accountmanager_id, $authId, 19, "", "", 1, $is_tpl);
                else :
                    if ($settings['direct_submission_to_am'] == 1) :
                        $res = self::directprofilesubmit($job_id, $candidate_id, $employer_id, $accountmanager_id, $authId, 19, $authuser->id, "Profile Submitted to Account Manager", 1, $is_tpl);
                    elseif ($settings['direct_submission_to_am'] == 0) :
                        $res = self::directprofilesubmit($job_id, $candidate_id, $employer_id, $accountmanager_id, $authId, 19, $authuser->id, "Vendor user submitted profile for approval", 0, $is_tpl);
                    endif;
                endif;
                $jobresume = new JobResumes();
                $jobresume->job_id = $job_id;
                $jobresume->candidate_id = $candidate_id;
                $jobresume->is_verified = 0;
                $jobresume->save();
                $jobResumeResponse = response()->success(compact('jobresume'));
                // Update vendor revenue table default revenue value.
                $vendorRevenue = VendorRevenue::where('vendor_id', $authId)
                    ->where('job_id', $job_id)
                    ->where('default_revenue', 0)
                    ->whereNotNull('est_revenue_1')
                    ->whereNotNull('est_revenue_2')
                    ->whereNotNull('est_revenue_3')
                    ->whereNotNull('est_revenue_4')
                    ->whereNotNull('est_revenue_5')
                    ->first();

                $newjobResume = Activity::create([
                    'person_id' => $authId,
                    'resume_id' => $candidate_id,
                    'name' => 'Profile submitted successfully.',
                ]);
                if (Input::get('vendorchecklist')):
                    $vendorchecklist = Input::get('vendorchecklist');
                    foreach ($vendorchecklist as $emp):
                        if (!$authuser->parent_id) :
                            $res = self::checklistofvendor($job_id, $candidate_id, $employer_id, $accountmanager_id, $emp['id'], $authId, 19, $emp['name'], '');
                        else :
                            if ($settings['direct_submission_to_am'] == 1) :
                                $res = self::checklistofvendor($job_id, $candidate_id, $employer_id, $accountmanager_id, $emp['id'], $authId, 19, $emp['name'], $authuser->id);
                            elseif ($settings['direct_submission_to_am'] == 0) :
                                $res = self::checklistofvendor($job_id, $candidate_id, $employer_id, $accountmanager_id, $emp['id'], $authId, 19, $emp['name'], $authuser->id);
                            endif;
                        endif;
                    endforeach;
                endif;
                $empAm = Association::where('vendor_id', $authId)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->whereNotNull('employer_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->where('job_id', $job_id)
                    ->whereNull('candidate_id')
                    ->with('accountmanager')
                    ->get();
                $candidateDetails = ['note' => $note];
                $affectedRows = Candidate::where('id', '=', intval($candidate_id))
                    ->update($candidateDetails);
                $vendor_name = User::where('id', $authId)->with('company')->get();
                $candidate_info = Candidate::where('id', $candidate_id)->get();
                $assignedJob = Candidate::where('id', $candidate_id)->get();
                $d = mktime(11, 14, 54, 8, 12, 2014);
                $encript_cotent = $job_id . $candidate_info[0]['phone'];
                $encript_code = base64_encode($encript_cotent);
                $enc_availability = GdprData::where('encrypt_code', $encript_code)->get();
                if (count($enc_availability) == 0) {
                    $gdprdata = new GdprData();
                    $gdprdata->job_id = $job_id;
                    $gdprdata->job_name = $position_name;
                    $gdprdata->candidate_id = $candidate_id;
                    $gdprdata->name = $candidate_info[0]['full_name'];
                    $gdprdata->vendor_id = $authId;
                    $gdprdata->vendor_name = $vendor_name[0]['company']['name'];
                    $gdprdata->vendor_email = $vendor_name[0]['email'];
                    $gdprdata->candidate_no = $candidate_info[0]['phone'];
                    $gdprdata->candidate_email = $candidate_info[0]['email'];
                    $gdprdata->encrypt_code = $encript_code . $candidate_id;
                    $gdprdata->save();
                } else {
                    $encript_code = base64_encode($candidate_info[0]['phone'] . count($enc_availability));
                    $gdprdata = new GdprData();
                    $gdprdata->job_id = $job_id;
                    $gdprdata->job_name = $position_name;
                    $gdprdata->candidate_id = $candidate_id;
                    $gdprdata->name = $candidate_info[0]['full_name'];
                    $gdprdata->vendor_id = $authId;
                    $gdprdata->vendor_name = $vendor_name[0]['company']['name'];
                    $gdprdata->vendor_email = $vendor_name[0]['email'];
                    $gdprdata->candidate_no = $candidate_info[0]['phone'];
                    $gdprdata->candidate_email = $candidate_info[0]['email'];
                    $gdprdata->encrypt_code = $encript_code . $candidate_id;
                    $gdprdata->save();
                }
                $timestamp = 129346161081;
                $randomKey = '-';
                $question_encr_jobid = base64_encode($timestamp . $randomKey . $job_id);
                $question_encr_candidateid = base64_encode($timestamp . $randomKey . $candidate_id);
                $gdprInfo = DB::table('job_orders')->select('gdpr')->where('id', $job_id)->get();
                $predefinedInfo = DB::table('job_orders_question_answers')->select('job_id')->where('job_id',$job_id)->count();
                if ($gdprInfo[0]->gdpr == 1) {
                    Mail::send('emails.gdprTemplate', ['candidatename' => $candidate_info[0]['full_name'], 'vendorname' => $vendor_name[0]['company']['name'],
                        'employername' => $employer_country[0]['company']['name'], 'encript_code' => $encript_code . $candidate_id], function ($m) use ($candidate_info) {
                        $m->to($candidate_info[0]['email'], 'Candidate Acceptance Confirmation Email')->subject('Status about your recent Job Appication!');
                    });
                    if(($predefinedInfo > 0))
                    {
                         Mail::send('emails.questionsTemplate', ['candidatename' => $candidate_info[0]['full_name'], 'vendorname' => $vendor_name[0]['company']['name'],
                        'employername' => $employer_country[0]['company']['name'], 'candidate_id' =>$question_encr_candidateid, 'job_id'=>$question_encr_jobid, 'job_name'=>$position_name], function ($m) use ($candidate_info) {
                        $m->to($candidate_info[0]['email'], 'Candidate predefined questions email')->subject('Candidate predefined questions email  Job Appication!');
                        });
                    }
                    else {
                    }
                }
                if ($gdprInfo[0]->gdpr == 2) {
                    $ven_data = Association::where('vendor_id', $authId)->where('job_id', $job_id)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('employer_id')
                        ->whereNull('vendor_user_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('employer_user_id')
                        ->whereNull('candidate_id')
                        //->where('job_status',3)
                        ->with('accountmanager')
                        ->with('employer')
                        ->with('vendor')
                        ->with('job')
                        ->get();
                    $am_data = User::where('id', $empAm[0]['accountmanager_id'])->get(['email', 'first_name']);
                    $company_data = User::where('email', $ven_data[0]->vendor->email)->with('company')->get();
                    $gdprupdate = ['gdpr_status' => 1];
                    $association_update = Association::where('candidate_id', '=', intval($candidate_id))
                        ->where('job_id', $job_id)
                        ->update($gdprupdate);
                    $candidate_info = Candidate::where('id', $candidate_id)->get();
                    $companyid = User::select('company_id')->where("email", $am_data[0]['email'])->get();
                    $vendorCompany = Company::select('name')->where('id', $companyid[0]->company_id)->get();
                    $accountmanagerSubject = "Gears On!! " . $company_data[0]->company->name . " Submitted profile for role " . $job_id . "-" . $position_name;
                    Mail::send('emails.notifyInterestingCandidates', ['profileName' => $candidate_info[0]['full_name'], 'profileLocation' => $candidate_info[0]['city'], 'name' => $am_data[0]->first_name, 'profileIndustry' => $candidate_info[0]['job_profile'], 'job_name' => $position_name, 'job_id' => $job_id, 'vendor_name' => $vendorCompany[0]->name, 'company_name' => $company_data[0]->company->name], function ($m) use ($am_data, $accountmanagerSubject) {
                        $m->to($am_data[0]['email'], 'New Profile Submitted')->subject($accountmanagerSubject);
                    });
                    $vendorSubject = "Bravo! Keep Going! You’ve Submitted profile for role " . $job_id . " - " . $position_name;
                    Mail::send('emails.notifyInterestingCandidatesven', ['profileName' => $candidate_info[0]['full_name'], 'profileLocation' => $candidate_info[0]['city'], 'name' => $am_data[0]->first_name, 'profileIndustry' => $candidate_info[0]['job_profile'], 'job_name' => $position_name, 'job_id' => $job_id, 'vendor_name' => $ven_data[0]->vendor->first_name, 'company_name' => $company_data[0]->company->name], function ($m) use ($am_data, $vendorSubject, $ven_data) {
                        $m->to($ven_data[0]->vendor->email, 'New Profile Submitted')->subject($vendorSubject);
                    });
                    $candidateSubject = "Gears On!! " . $vendorCompany[0]->name . " Submitted profile for role " . $job_id . " - " . $position_name;
                  
                    if(($predefinedInfo > 0))
                    {
                         Mail::send('emails.questionsTemplate', ['candidatename' => $candidate_info[0]['full_name'], 'vendorname' => $vendor_name[0]['company']['name'],
                        'employername' => $employer_country[0]['company']['name'], 'candidate_id' =>$question_encr_candidateid, 'job_id'=>$question_encr_jobid, 'job_name'=>$position_name], function ($m) use ($candidate_info) {
                        $m->to($candidate_info[0]['email'], 'Candidate predefined questions email')->subject('Candidate predefined questions email  Job Appication!');
                        });
                    }
                    else {
                    }
                }
                $country = Country::where('is_enabled', 1)->get();
                $number = $candidate_info[0]['phone'];
                $number = str_replace("+91", "", $number);
                $city = \App\City::where('id', $authuser->city_id)->get();
                if (count($city) > 0) {
                    $country = Country::where('id', $city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
                if ($gdprInfo[0]->gdpr == 1) {
                    $ch = curl_init();
                    $user = "kv@hirextra.com";
                    $password = "Kumar786%";
                    $receipientno = $countryCode . $number;
                    $originator = "HireXtra";
                    //$msgtxt = "Job Title: ".$association_info->job->name." has held.";
                    $msgtxt = "Hello " . $candidate_info[0]['full_name'] . "Your profile is under consideration. GDPR approval link, https://apps.hirextra.com/#/gdpr-form/" . $encript_code . $candidate_id;
                    curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                    $buffer = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                }
                $newjobResumeResponse = response()->success(compact('newjobResume'));
                return $jobResumeResponse;
            } else {
                return response()->error("This Profile Already Submitted to Employer ,Please Try With different profile");
            }
        } else {
            return response()->error("You've already submitted the maximum number of profiles for this job");
        }
    }


    public function postSubmitcandidatesassign()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $settings = VendorUserSetting::where('vendor_user_id', intval($authuser->id))->first();
        } else {
            $authId = $authuser->id;
        }
       // $can_detail = Candidate::where('id', $candidateId)->first();   
        $job_id = Input::get('jobs');
		$json = Input::get('json');
        $candidateId = Input::get('candidateId');
        $amId = Association::select('accountmanager_id','employer_id')->where('vendor_id', $authId)
        ->whereNotNull('accountmanager_id')
        ->whereNotNull('employer_id')
        ->get();       
        $acmId=$amId[0]['accountmanager_id'];
        $empId=$amId[0]['employer_id'];
        try {
            $candidateassociation = new Association();
            $candidateassociation->admin_id = 1;
            $candidateassociation->accountmanager_id = $acmId;
            $candidateassociation->employer_id = $empId;
            $candidateassociation->vendor_id = $authId;
            $candidateassociation->job_id = $job_id;
            $candidateassociation->candidate_id = $candidateId;
            $candidateassociation->status_updated_by = $authId;
            $candidateassociation->candidate_status = 19;
            $candidateassociation->save();
            $candidate=['success'=>'Candidate Successfully assigned to the job!'];
        } catch (\Throwable $th) {
            throw $th;
            $candidate=['success'=>'Candidate Not assigned to the job!'];
        }
      
        
        return response()->success(compact('candidate'));
    }

    public function postSubmitcandidatesuser()
    {
        $job_id = Input::get('jobs');
        $vacancies = Input::get('positions');
        $vendorno = Input::get('vendorId');
        $candidate_id = Input::get('candidateId');
        $canDetails = Candidate::where('id', $candidate_id)->get();
        $authuser = Auth::user();
        $employer_id = JobOrders::where('id', $job_id)->first()->user_id;
        $accountmanager_id = Association::where('vendor_id', $authuser->parent_id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->whereNull('candidate_id')
            ->first()->accountmanager_id;
        $assignedJob = association::where('vendor_id', $authuser->parent_id)
            ->where('accountmanager_id', $accountmanager_id)
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->where('candidate_id', $candidate_id)
            ->count();
        $countResumes = association::where('vendor_id', $authuser->parent_id)
            ->where('accountmanager_id', $accountmanager_id)
            ->where('employer_id', $employer_id)
            ->where('job_id', $job_id)
            ->whereNotNull('candidate_id')
            ->whereNull('vendor_user_id')
            ->count();
        $a = (int)$vacancies;
        if ($countResumes < ($a * 3)) {
            if ($assignedJob == 0) {
                $candidateassociation = new Association();
                $candidateassociation->admin_id = 1;
                $candidateassociation->accountmanager_id = $accountmanager_id;
                $candidateassociation->employer_id = $employer_id;
                $candidateassociation->vendor_id = $authuser->parent_id;
                //$candidateassociation->vendor_user_id = $authuser->id;
                $candidateassociation->job_id = $job_id;
                $candidateassociation->candidate_id = $candidate_id;
                $candidateassociation->candidate_status = 19;
                $candidateassociation->status_updated_by = $authuser->parent_id;
                $candidateassociation->save();
                $candidateactivity = new Activity();
                $candidateactivity->name = "Profile Submitted to Account Manager";
                $candidateactivity->admin_id = 1;
                $candidateactivity->accountmanager_id = $accountmanager_id;
                $candidateactivity->employer_id = $employer_id;
                $candidateactivity->vendor_id = $authuser->parent_id;
                $candidateactivity->job_id = $job_id;
                $candidateactivity->candidate_id = $candidate_id;
                $candidateactivity->candidate_status = 19;
                $candidateactivity->activity_by = $vendorno;
                $candidateactivity->save();
                $candidateassociation = new Association();
                $candidateassociation->admin_id = 1;
                $candidateassociation->accountmanager_id = $accountmanager_id;
                $candidateassociation->employer_id = $employer_id;
                $candidateassociation->vendor_id = $authuser->parent_id;
                $candidateassociation->vendor_user_id = $authuser->id;
                $candidateassociation->job_id = $job_id;
                $candidateassociation->candidate_id = $candidate_id;
                $candidateassociation->candidate_status = 19;
                $candidateassociation->status_updated_by = $authuser->id;
                $candidateassociation->save();
                $candidateactivity = new Activity();
                $candidateactivity->name = "Profile Submitted to Account Manager";
                $candidateactivity->admin_id = 1;
                $candidateactivity->accountmanager_id = $accountmanager_id;
                $candidateactivity->employer_id = $employer_id;
                $candidateassociation->vendor_id = $authuser->parent_id;
                $candidateactivity->vendor_user_id = $authuser->id;
                $candidateactivity->job_id = $job_id;
                $candidateactivity->candidate_id = $candidate_id;
                $candidateactivity->candidate_status = 19;
                $candidateactivity->activity_by = $authuser->id;
                $candidateactivity->save();
                $jobresume = new JobResumes();
                $jobresume->job_id = $job_id;
                $jobresume->candidate_id = $candidate_id;
                $jobresume->is_verified = 0;
                $jobresume->save();
                $jobResumeResponse = response()->success(compact('jobresume'));
                // Update vendor revenue table default revenue value.
                $vendorRevenue = VendorRevenue::where('vendor_id', $vendorno)
                    ->where('job_id', $job_id)
                    ->where('default_revenue', 0)
                    ->whereNotNull('est_revenue_1')
                    ->whereNotNull('est_revenue_2')
                    ->whereNotNull('est_revenue_3')
                    ->whereNotNull('est_revenue_4')
                    ->whereNotNull('est_revenue_5')
                    ->first();
                if (count($vendorRevenue) == 1) {
                    $carbon_date = Carbon::parse($vendorRevenue->created_at);
                    $dateCopy5 = Carbon::parse($vendorRevenue->created_at);
                    $dateCopy24 = Carbon::parse($vendorRevenue->created_at);
                    $dateCopy7d = Carbon::parse($vendorRevenue->created_at);
                    $dateCopy30d = Carbon::parse($vendorRevenue->created_at);
                    $dateCopy5->addHours(5);
                    $dateCopy24->addHours(24);
                    $dateCopy7d->addHours(168);
                    $dateCopy30d->addHours(720);
                    if (Carbon::now()->gt($dateCopy30d)) {
                        //After 30 days
                        $revenueData = ['default_revenue' => 5];
                        $vendorassignedjobs = VendorRevenue::where('job_id', $job_id)
                            ->where('vendor_id', $authuser->id)
                            ->whereNotNull('est_revenue_1')
                            ->whereNotNull('est_revenue_2')
                            ->whereNotNull('est_revenue_3')
                            ->whereNotNull('est_revenue_4')
                            ->whereNotNull('est_revenue_5')
                            ->update($revenueData);
                    } else if ((Carbon::now()->gt($dateCopy7d)) && (Carbon::now()->lt($dateCopy30d))) {
                        //After 7 Days
                        $revenueData = ['default_revenue' => 4];
                        $vendorassignedjobs = VendorRevenue::where('job_id', $job_id)
                            ->where('vendor_id', $authuser->id)
                            ->whereNotNull('est_revenue_1')
                            ->whereNotNull('est_revenue_2')
                            ->whereNotNull('est_revenue_3')
                            ->whereNotNull('est_revenue_4')
                            ->whereNotNull('est_revenue_5')
                            ->update($revenueData);
                    } else if ((Carbon::now()->gt($dateCopy24)) && (Carbon::now()->lt($dateCopy7d))) {
                        //After 24 hrs
                        $revenueData = ['default_revenue' => 3];
                        $vendorassignedjobs = VendorRevenue::where('job_id', $job_id)
                            ->where('vendor_id', $authuser->id)
                            ->whereNotNull('est_revenue_1')
                            ->whereNotNull('est_revenue_2')
                            ->whereNotNull('est_revenue_3')
                            ->whereNotNull('est_revenue_4')
                            ->whereNotNull('est_revenue_5')
                            ->update($revenueData);
                    } else if ((Carbon::now()->gt($dateCopy5)) && (Carbon::now()->lt($dateCopy24))) {
                        //After 5 hrs before 24 hrs
                        $revenueData = ['default_revenue' => 2];
                        $vendorassignedjobs = VendorRevenue::where('job_id', $job_id)
                            ->where('vendor_id', $vendorno)
                            ->whereNotNull('est_revenue_1')
                            ->whereNotNull('est_revenue_2')
                            ->whereNotNull('est_revenue_3')
                            ->whereNotNull('est_revenue_4')
                            ->whereNotNull('est_revenue_5')
                            ->update($revenueData);
                    } else if (Carbon::now()->lt($dateCopy5)) {
                        //Within 5 hrs
                        $revenueData = ['default_revenue' => 1];
                        $vendorassignedjobs = VendorRevenue::where('job_id', $job_id)
                            ->where('vendor_id', $vendorno)
                            ->whereNotNull('est_revenue_1')
                            ->whereNotNull('est_revenue_2')
                            ->whereNotNull('est_revenue_3')
                            ->whereNotNull('est_revenue_4')
                            ->whereNotNull('est_revenue_5')
                            ->update($revenueData);
                    }
                }// Check if records are empty
                //Insert Successfull candidate submission activity record
                $newjobResume = Activity::create([
                    'person_id' => $vendorno,
                    'resume_id' => $candidate_id,
                    'name' => 'Profile submitted successfully.',
                ]);
                if (Input::get('vendorchecklist')):
                    $vendorchecklist = Input::get('vendorchecklist');
                    foreach ($vendorchecklist as $emp):
                        $checklistassociation = new Association();
                        $checklistassociation->admin_id = 1;
                        $checklistassociation->job_id = $job_id;
                        $checklistassociation->candidate_id = $candidate_id;
                        $checklistassociation->employer_id = $employer_id;
                        $checklistassociation->accountmanager_id = $accountmanager_id;
                        $checklistassociation->vendor_checklist_id = $emp['id'];
                        $checklistassociation->save();
                        $checklistactivity = new Activity();
                        $checklistactivity->name = $emp['name'];
                        $checklistactivity->admin_id = 1;
                        $checklistactivity->accountmanager_id = $accountmanager_id;
                        $checklistactivity->employer_id = $employer_id;
                        $checklistactivity->vendor_id = $authuser->parent_id;
                        $checklistactivity->vendor_user_id = $authuser->id;
                        $checklistactivity->job_id = $job_id;
                        $checklistactivity->candidate_id = $candidate_id;
                        $checklistactivity->candidate_status = 19;
                        $checklistactivity->activity_by = $authuser->parent_id;
                        $checklistactivity->vendor_checklist_id = $emp['id'];
                        $checklistactivity->save();
                    endforeach;
                endif;
                $empAm = Association::where('vendor_id', $vendorno)
                    ->where('accountmanager_id', $accountmanager_id)
                    ->whereNotNull('employer_id')
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->where('job_id', $job_id)
                    ->whereNull('candidate_id')
                    ->with('accountmanager')
                    ->with('vendor')
                    ->with('job')
                    ->get();
                $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
                $candidate_info = Candidate::where('id', $candidate_id)->first();
                // $accountmanagerSubject = "Gears On!! " .$empAm[0]->vendor->first_name. " Submitted profile for " .$association_info[0]->job->id;
                $accountmanagerSubject = "Gears On!! " . $empAm[0]->vendor->first_name . " Submitted profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name;
                // $vendorSubject = "Bravo! Keep Going! You’ve Submitted profile for " .$association_info[0]->job->id;
                $vendorSubject = "Bravo! Keep Going! You’ve Submitted profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name;
                Mail::send('emails.notifyInterestingCandidates', ['profileName' => $candidate_info->full_name, 'profileLocation' => $candidate_info->city, 'vendor_name' => $empAm[0]->vendor->first_name, 'job_id' => $association_info[0]->job->id, 'job_name' => $association_info[0]->job->name, 'company_name' => $company_name[0]->name, 'profileIndustry' => $candidate_info->job_profile], function ($m) use ($empAm, $accountmanagerSubject, $company_name) {
                    $m->to($empAm[0]->accountmanager->email, 'New Profile Submitted')->subject($accountmanagerSubject);
                });
                Mail::send('emails.notifyInterestingCandidatesven', ['profileName' => $candidate_info->full_name, 'profileLocation' => $candidate_info->city, 'job_id' => $association_info[0]->job->id, 'job_name' => $association_info[0]->job->name, 'profileIndustry' => $candidate_info->job_profile], function ($m) use ($empAm, $vendorSubject) {
                    $m->to($empAm[0]->vendor->email, 'New Profile Submitted')->subject($vendorSubject);
                });
                $newjobResumeResponse = response()->success(compact('newjobResume'));
                return $jobResumeResponse;
            } else {
                return response()->error("This Profile Already Submitted to Employer ,Please Try With different profile");
            }
        } else {
            return response()->error("You've already submitted the maximum number of profiles for the job ($job_id)");
        }
    }

    public function postJobrejectuser()
    {
        $authuser = Auth::user();
        $id = Input::get('joborderId');
        $comment = Input::get('note');
        $companyDetails = company::where('id', $authuser->company_id)->get();
        $a = $companyDetails[0]['name'];
        $namesada = "Vendor Rejected a job";
        $joborderData = [
            'job_status' => 2,
            'status_updated_by' => $authuser->id,
            'note' => $comment,
        ];
        $vendorassignedjobs = Association::where('job_id', $id)->where('vendor_id', $authuser->id)->update($joborderData);
        $vendordashboardalerts = Association::where('vendor_id', $authuser->id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->where('job_status', 4)
            ->get();
        $vendorjobs = array();
        foreach ($vendordashboardalerts as $job) {
            array_push($vendorjobs, $job->job_id);
        }
        $vendordashboardalerts = JobOrders::whereIn('id', $vendorjobs)
            ->where('status', 8)
            ->get();
        $association_info = Association::where('vendor_id', $authuser->id)->where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->where('job_status', 2)
            ->with('accountmanager')
            ->with('employer')
            ->with('vendor')
            ->with('job')
            ->get();
        $association_info_emp = Association::where('vendor_id', $authuser->id)->where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->where('job_status', 2)
            ->with('employer')
            ->with('company')
            ->with('job')
            ->get();
        $companyDetails = Company::select('name')->where('id', $association_info[0]->employer->company_id)->get();
        $vendoractivity = new Activity();
        $vendoractivity->name = $namesada;
        $vendoractivity->admin_id = 1;
        $vendoractivity->accountmanager_id = $association_info[0]->accountmanager_id;
        $vendoractivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $vendoractivity->vendor_id = $authuser->id;
        $vendoractivity->job_id = $id;
        $vendoractivity->note = $a;
        $vendoractivity->comment = $comment;
        $vendoractivity->job_status = 3;
        $vendoractivity->activity_by = $authuser->id;
        $vendoractivity->is_vendor_sourcing_activity = 0;
        $vendoractivity->save();
        $vendoractivity = new Activity();
        $vendoractivity->name = $namesada;
        $vendoractivity->admin_id = 1;
        $vendoractivity->accountmanager_id = $association_info[0]->accountmanager_id;
        $vendoractivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $vendoractivity->vendor_id = $authuser->id;
        $vendoractivity->job_id = $id;
        $vendoractivity->note = $a;
        $vendoractivity->comment = $comment;
        $vendoractivity->is_vendor_sourcing_activity = 1;
        $vendoractivity->job_status = 3;
        $vendoractivity->activity_by = $authuser->id;
        $vendoractivity->save();
        $companyid = User::select('company_id')->where('email', $association_info[0]->vendor->email)->get();
        $vendorCompany = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        //print_r($vendorCompany);exit;
        //$accountmanagerSubject = "Same Plan..Slight Detour! " .$id. " Rejected By " .$association_info[0]->vendor->first_name;
        $accountmanagerSubject = "Same Plan..Slight Detour! Job " . $id . "-" . $association_info[0]->job->name . " Rejected By " . $vendorCompany[0]->name;
        //$vendorSubject = "Everything Happens For A Reason! You Rejected " .$id;
        $vendorSubject = "Everything Happens For A Reason! You Rejected Job " . $id . " - " . $association_info[0]->job->name;
        //TODO Send Email to vendor stating that profile is duplicate.
        $countryCode = User::select('country_code')->where('email', $association_info[0]->vendor->email)->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
        Mail::send('emails.notifyJobRejectingApplicationstoam', ['userName' => $association_info[0]->vendor->first_name, 'mobileNumber' => $mobileNumber, 'accountManagerEmail' => $association_info[0]->accountmanager->email, 'accountManagerName' => $association_info[0]->accountmanager->first_name, 'candidateName' => '', 'jobName' => $association_info[0]->job->name, 'jobId' => $id, 'jobCode' => $association_info[0]->job->job_internal_code, 'recruiterName' => $association_info[0]->vendor->first_name, 'companyname' => $companyDetails[0]->name, 'text' => 'This Job is Rejected by Vendor.'], function ($m) use ($association_info, $vendorSubject) {
            $m->to($association_info[0]->vendor->email, 'Job Rejected By Vendor')->subject($vendorSubject);
            //$m->to($association_info[0]->accountmanager->email, 'Job Rejected By Vendor')->subject('Job Rejected By Vendor');
            //$m->to($association_info[0]->employer->email, 'Job Rejected By Vendor')->subject('Job Rejected By Vendor');
        });
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $mobile_n = Input::get('addressAsNote');
        //$type_int = Status::where('id',$shortlistIds)->get(['name']);
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile_n);
        $mobile_s = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The job order for the " . $association_info[0]->job->name . " has been rejected by Vendor";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyJobRejectingApplications', ['userName' => $association_info[0]->accountmanager->first_name, 'recruiter_email' => $association_info[0]->vendor->email, 'candidateName' => '', 'jobName' => $association_info[0]->job->name, 'jobId' => $id, 'jobCode' => $association_info[0]->job->job_internal_code, 'recruiterName' => $vendorCompany[0]->name, 'companyname' => $companyDetails[0]->name, 'text' => 'This Job is Rejected by Vendor.'], function ($m) use ($association_info, $accountmanagerSubject) {
            //$m->to($association_info[0]->vendor->email, 'Job Rejected By Vendor')->subject('Job Rejected By Vendor');
            $m->to($association_info[0]->accountmanager->email, 'Job Rejected By Vendor')->subject($accountmanagerSubject);
            //$m->to($association_info[0]->employer->email, 'Job Rejected By Vendor')->subject('Job Rejected By Vendor');
        });
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $mobile_n = Input::get('addressAsNote');
        //$type_int = Status::where('id',$shortlistIds)->get(['name']);
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile_n);
        $mobile_s = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The job order for the " . $association_info[0]->job->name . " has been withdrawl by Vendor";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to vendor stating that profile is duplicate.
        /* Mail::send('emails.notifyJobRejectingApplications', ['userName' => $association_info[0]->employer->first_name, 'candidateName' => '', 'jobName' => $association_info[0]->job->name, 'jobId' => $id,'jobCode' => $association_info[0]->job->job_internal_code, 'recruiterName' => $association_info[0]->vendor->first_name, 'companyname'=> $companyDetails[0]->name,'text' => 'This Job is Rejected by Vendor.'], function ($m) use($association_info) {
             $m->to($association_info[0]->employer->email, 'Job Rejected By Vendor')->subject('Job Rejected By Vendor');
         });*/
        //mail portion close
        return response()->success(compact('vendordashboardalerts'));
    }

    public function putJobacceptuserShow($id)
    {
        $authuser = Auth::user();
        $joborderData = [
            'job_status' => 3,
            'status_updated_by' => $authuser->id,
        ];
        $vendorassignedjobs = Association::where('job_id', $id)->where('vendor_id', $authuser->id)->update($joborderData);
        $vendordashboardalerts = Association::where('vendor_id', $authuser->id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->where('job_status', 4)
            ->get();
        $vendorjobs = array();
        foreach ($vendordashboardalerts as $job) {
            array_push($vendorjobs, $job->job_id);
        }
        $vendordashboardalerts = JobOrders::whereIn('id', $vendorjobs)->where('is_talentpool', 0)
            ->where('status', 8)
            ->get();
        $association_info = Association::where('vendor_id', $authuser->id)->where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->where('job_status', 3)
            ->with('accountmanager')
            ->with('employer')
            ->with('vendor')
            ->with('job')
            ->get();
        $companyid = User::select('company_id')->where('email', $association_info[0]->vendor->email)->get();
        $companyDetails = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $vendoractivity = new Activity();
        $vendoractivity->name = "Vendor accepted job";
        $vendoractivity->admin_id = 1;
        $vendoractivity->accountmanager_id = $association_info[0]->accountmanager_id;
        $vendoractivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $vendoractivity->vendor_id = $authuser->id;
        $vendoractivity->job_id = $id;
        $vendoractivity->job_status = 3;
        $vendoractivity->activity_by = $authuser->id;
        $vendoractivity->save();
        // $accountmanagerSubject ="Get Ready For CV Hurricane! " .$id. " Accepted By " .$association_info[0]->vendor->first_name;
        $accountmanagerSubject = "Get Ready For CV Hurricane! Job " . $id . "-" . $association_info[0]->job->name . " Accepted By " . $companyDetails[0]->name;
        //$vendorSubject ="We are ready to get drenched in Profiles! You Accepted " .$id;
        $vendorSubject = "We are ready to get drenched in Profiles! You Accepted Job " . $id . "-" . $association_info[0]->job->name;
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyJobAcceptingApplications', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => '', 'jobName' => $association_info[0]->job->name, 'jobId' => $id, 'jobCode' => $association_info[0]->job->job_internal_code, 'company_details' => $companyDetails[0]->name, 'text' => 'This Job is Accepted by Vendor.'], function ($m) use ($association_info, $accountmanagerSubject) {
            /*$m->to($association_info[0]->vendor->email, 'Job Accepted By Vendor')->subject('Job Accepted By Vendor');*/
            $m->to($association_info[0]->accountmanager->email, 'Job Accepted By Vendor')->subject($accountmanagerSubject);
            /*$m->to($association_info[0]->employer->email, 'Job Accepted By Vendor')->subject('Job Accepted By Vendor');*/
        });
        Mail::send('emails.notifyJobAcceptingApplicationsvendor', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => '', 'jobName' => $association_info[0]->job->name, 'jobId' => $id, 'jobCode' => $association_info[0]->job->job_internal_code, 'company_details' => $companyDetails[0]->name, 'text' => 'This Job is Accepted by Vendor.'], function ($m) use ($association_info, $vendorSubject) {
            $m->to($association_info[0]->vendor->email, 'Job Accepted By Vendor')->subject($vendorSubject);
        });
        //mail portion close
        return response()->success(compact('vendordashboardalerts'));
    }

    public function putChagnestatusnotificationusers($id)
    {
        $authuser = Auth::user();
        $notificationdata = [
            'notificationvendoruser' => '1',
        ];
        //print_r($authuser->id); exit;
        $vendorassignedjobs = JobOrders::where('id', $id)->update($notificationdata);
        $vendorassignedjobs->save();
        return response()->success(compact('vendorassignedjobs'));
    }

    public function postResendemailam()
    {
        $jobId = Input::get('job_id');
        $candidate_id = Input::get('candidate_id');
        $Gdpr_data = GdprData::where('job_id', $jobId)->where('candidate_id', $candidate_id)->with('job')->get();
        $employer_country = User::where('id', $Gdpr_data[0]['job']['user_id'])->with('company')->get();
        Mail::send('emails.gdprTemplate', ['candidatename' => $Gdpr_data[0]['name'], 'vendorname' => $Gdpr_data[0]['vendor_name'],
            'employername' => $employer_country[0]['company']['name'], 'encript_code' => $Gdpr_data[0]['encrypt_code']], function ($m) use ($Gdpr_data) {
            $m->to($Gdpr_data[0]['candidate_email'], 'Candidate Acceptance Confirmation Email')->subject('Status about your recent Job Appication!');
        });
        return response()->success("Email Sent successfully");
    }

    public function putResendemail($id)
    {
        $authuser = Auth::user();
        $Gdpr_data = GdprData::where('id', $id)->with('job')->get();
        $employer_country = User::where('id', $Gdpr_data[0]['job']['user_id'])->with('company')->get();
        $country = Country::where('is_enabled', 1)->get();
        $number = $Gdpr_data[0]['candidate_no'];
        $number = str_replace("+91", "", $number);
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $Gdpr_data[0]['name'] . " , Your profile is under Commencement. Here’s GDPR approval link, https://apps.hirextra.com/#/gdpr-form/" . $Gdpr_data[0]['encrypt_code'] . ". Kindly Approve.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        Mail::send('emails.gdprTemplate', ['candidatename' => $Gdpr_data[0]['name'], 'vendorname' => $Gdpr_data[0]['vendor_name'],
            'employername' => $employer_country[0]['company']['name'], 'encript_code' => $Gdpr_data[0]['encrypt_code']], function ($m) use ($Gdpr_data) {
            $m->to($Gdpr_data[0]['candidate_email'], 'Candidate Acceptance Confirmation Email')->subject('Status about your recent Job Appication!');
        });
        return response()->success("Email Sent successfully");
    }

    public function postAcceptedprofile()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $empDetails = JobOrders::where('id', $joborderId)->with('user')->get();
        $note = Input::get('note');
        $mobile = Input::get('name');
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $note);
        $email = preg_replace('/[^@\s]*@[^@\s]*\.[^@\s]*/', '', $mobile);
        $note = $email;
        $dupcandId = Input::get('dupcandId');
        $authuser = Auth::user();
        $date = date('Y-m-d H:i:s');
        $associationData = [
            'candidate_status' => 31,
            'note' => $note,
            'status_updated_by' => $authuser->id,
            'updated_at' => $date,
        ];
        $dupcandidate = Association::where('job_id', $joborderId)
            ->where('candidate_status', 19)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->update($associationData);
        $dupcandidateVal = Association::where('job_id', $joborderId)
            ->where('candidate_status', 31)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile Accepted by Account Manager";
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $authuser->id;
        $candidateactivity->vendor_id = $dupcandidateVal->vendor_id;
        $candidateactivity->employer_id = $dupcandidateVal->employer_id;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $dupcandId;
        $candidateactivity->note = $note;
        $candidateactivity->candidate_status = 31;
        $candidateactivity->activity_by = $authuser->id;
        $candidateactivity->save();
        $sharelinkactivity = new ShareLinkActivitys();
        $sharelinkactivity->job_id = $joborderId;
        $sharelinkactivity->candidate_id = $dupcandId;
        $sharelinkactivity->accountmanager_id = $authuser->id;
        $sharelinkactivity->save();
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 31)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('employer')
            ->with('candidate')
            ->with('job')
            ->with('company')
            ->get();
        //TODO Send Email to vendor stating that profile is Accepted.
        if ($authuser->user_type != 1) {
            Mail::send('emails.notifyCandidateJobStatusChangeven', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'text' => 'The profile is Accepted and sent to Employer.'], function ($m) use ($association_info) {
                $m->to($association_info[0]->vendor->email, 'Accepted profile')->subject('Bravo..Your Account Manager Accepted a Profile!');
            });
        }
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($authuser->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hello " . $association_info[0]->vendor->first_name . ", The  profile submitted by you (" . $association_info[0]->candidate->full_name . ") was accepted by Account Manager" . $authuser->first_name . "and sent to Employer.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            //TODO Send Email to Am stating that profile is Accepted.
            $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
            $companyid = User::select('company_id')->where('id', $association_info[0]->vendor_id)->get();
            $vendor_company_name = Company::select('name')->where('id', $companyid[0]->company_id)->get();
            Mail::send('emails.notifyCandidateJobStatusChangeamm', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'venName' => $association_info[0]->vendor->first_name, 'vendor_company_name' => $vendor_company_name[0]->name, 'jobName' => $association_info[0]->job->name, 'jobid' => $association_info[0]->job->id, 'companyName' => $company_name[0]->name, 'text' => 'The profile is Accepted and sent to Employer.'], function ($m) use ($association_info, $company_name) {
                $m->to($association_info[0]->accountmanager->email, 'Accepted profile')->subject('You Accepted A Profile..Fingers Crossed!');
            });
        }
        $number = $association_info[0]->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($authuser->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hello" . $association_info[0]->accountmanager->first_name . ", You have submitted new profile (" . $association_info[0]->candidate->full_name . ") to Employer " . $empDetails[0]['user']['first_name'] . ", Received from " . $association_info[0]->vendor->first_name . " for the Job role (" . $association_info[0]->job->name . ").";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $subjectEmployer = "We’ve found an excellent match for " . $association_info[0]->job->id . "-" . $association_info[0]->job->name . " role!";
            //TODO Send Email to Employer stating that profile is Accepted
            $countryCode = User::select('country_code')->where('email', $association_info[0]->accountmanager->email)->get();
            $mobileNumber = $countryCode[0]->country_code . $association_info[0]->accountmanager->mobile;
            Mail::send('emails.notifyCandidateJobStatusChangeempp', ['userName' => $association_info[0]->employer->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobid' => $association_info[0]->job->id, 'jobName' => $association_info[0]->job->name, 'amName' => $association_info[0]->accountmanager->first_name, 'countrycode_new' => $receipientno, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $mobileNumber, 'text' => 'You have received a new profile'], function ($m) use ($association_info) {
                $m->to($association_info[0]->employer->email, 'Accepted profile')->subject("We’ve found an excellent match for " . $association_info[0]->job->id . "-" . $association_info[0]->job->name . " role!");
            });
        }
        $number = $empDetails[0]['user']['mobile'];
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($authuser->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "Hello " . $empDetails[0]['user']['first_name'] . ", You have recived a new profile ( " . $association_info[0]->candidate->full_name . ") for " . $association_info[0]->job->name . " from " . $association_info[0]->accountmanager->first_name . ". Please check your dashboard for more details.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        return response()->success(compact('dupcandidate'));
    }

    public function getAmprofilenumbers($id)
    {
        $authuser = Auth::user();
        $job_details = JobOrders::where('id', $id)->where('is_talentpool', 0)->get(['gdprmandatory']);
        if ($job_details[0]['gdprmandatory']) {
            $amassignedpendingcandidates = Association::where('job_id', $id)
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_status')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->where('gdpr_status', 1)
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->where('vendor_approval', 1)
                ->whereNull('vendor_user_id')
                ->count();
            $amshortlistedcandidates = Association::where('job_id', $id)
                ->where('accountmanager_id', $authuser->id)
                ->whereNotIn('candidate_status', array(1, 2, 30, 6, 19))
                ->whereNotNull('candidate_status')->where('gdpr_status', 1)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereHas('CandidatePoints', function ($query) use ($id) {
                    $query->where('job_id', '=', $id);
                })
                ->count();
            $amrejectedcandidates = Association::where('job_id', $id)->where('accountmanager_id', $authuser->id)
                ->whereIn('candidate_status', array(1, 2, 30))
                ->whereNotNull('candidate_status')->where('gdpr_status', 1)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereHas('CandidatePoints', function ($query) use ($id) {
                    $query->where('job_id', '=', $id);
                })->count();
        } else {
            $amassignedpendingcandidates = Association::where('job_id', $id)
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_status')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->where('vendor_approval', 1)
                ->whereNull('vendor_user_id')
                ->whereHas('CandidatePoints', function ($query) use ($id) {
                    $query->where('job_id', '=', $id);
                })
                ->count();
            $amshortlistedcandidates = Association::where('job_id', $id)
                ->where('accountmanager_id', $authuser->id)
                ->whereNotIn('candidate_status', array(1, 2, 30, 6, 19))
                ->whereNotNull('candidate_status')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereHas('CandidatePoints', function ($query) use ($id) {
                    $query->where('job_id', '=', $id);
                })
                ->count();
            $amrejectedcandidates = Association::where('job_id', $id)->where('accountmanager_id', $authuser->id)
                ->whereIn('candidate_status', array(1, 2, 30))
                ->whereNotNull('candidate_status')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereHas('CandidatePoints', function ($query) use ($id) {
                    $query->where('job_id', '=', $id);
                })
                ->count();
        }
        $aminactivecandidates_wgdpr = Association::where('job_id', $id)->where('accountmanager_id', $authuser->id)
            ->where('candidate_status', 19)
            ->whereNotNull('candidate_status')
            ->where('gdpr_status', 1)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 1);
            })->get();
        $aminactivecandidates_wogdpr = Association::where('job_id', $id)->where('accountmanager_id', $authuser->id)
            ->where('candidate_status', 19)
            ->whereNotNull('candidate_status')
            //->where('gdpr_status',1)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 0);
            })->get();
        $aminactivecandidates = $aminactivecandidates_wgdpr->merge($aminactivecandidates_wogdpr);
        $aminactivecandidates = count($aminactivecandidates);
        $numbers = ['assingedcandidates' => $amassignedpendingcandidates, 'shortlistedcandidates' => $amshortlistedcandidates, 'inactivecandidates' => $aminactivecandidates, 'rejectedcandidates' => $amrejectedcandidates];
        $amprofilenumbers['numbers'] = $numbers;
        return response()->success(compact('amprofilenumbers'));
    }

    public function postAmreasonstoreject()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $reasonIds = Input::get('reasonIds');
        $candId = Input::get('candId');
        $note = Input::get('note');
        $authuser = Auth::user();
        $associationData = [
            'candidate_status' => 2,
            'reason_id' => $reasonIds,
            'note' => $note,
            'status_updated_by' => $authuser->id,
        ];
        $reasonstoreject = Association::where('job_id', $joborderId)
            ->where('candidate_status', 19)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->update($associationData);
        $reasonstorejectValue = Association::where('job_id', $joborderId)
            ->where('candidate_status', 2)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile rejected by Account Manager";
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $authuser->id;
        $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
        $candidateactivity->employer_id = $reasonstorejectValue->employer_id;
        $candidateactivity->reason_id = $reasonIds;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = 2;
        $candidateactivity->note = $note;
        $candidateactivity->activity_by = $authuser->id;
        $candidateactivity->save();
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 2)
            ->where('candidate_id', $candId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeRejectPro', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->vendor->email, 'Rejected profile')->subject('Oops!! Better Luck next time');
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        //$msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been rejected.";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") has been rejected for the job [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by [" . $association_info[0]->accountmanager->first_name . "].";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Am stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeRejectPro', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'text' => 'This profile has been Rejected.'], function ($m) use ($association_info) {
            $m->to($association_info[0]->accountmanager->email, 'Rejected profile')->subject(' Oops!! Better Luck next time');
        });
        return response()->success(compact('reasonstoreject'));
    }

    public function postAmduplicatejob()
    {
        $joborderId = Input::get('joborderId');
        $decryption = base64_decode($joborderId);
        $joborderId = substr($decryption, strpos($decryption, "-") + 1);
        $note = Input::get('note');
        $mobile = Input::get('name');
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $note);
        $email = preg_replace('/[^@\s]*@[^@\s]*\.[^@\s]*/', '', $mobile);
        $note = $email;
        $dupcandId = Input::get('dupcandId');
        $authuser = Auth::user();
        $employerName = $authuser->first_name;
        $employerEmail = $authuser->email;
        $associationData = [
            'candidate_status' => 1,
            'note' => $note,
            'status_updated_by' => $authuser->id,
        ];
        $dupcandidate = Association::where('job_id', $joborderId)
            ->where('candidate_status', 19)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->update($associationData);
        $dupcandidateValue = Association::where('job_id', $joborderId)
            ->where('candidate_status', 1)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->first();
        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile Marked as duplicate by Account Manager";
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $authuser->id;
        $candidateactivity->vendor_id = $dupcandidateValue->vendor_id;
        $candidateactivity->employer_id = $dupcandidateValue->employer_id;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $dupcandId;
        $candidateactivity->candidate_status = 1;
        $candidateactivity->activity_by = $authuser->id;
        $candidateactivity->save();
        $association_info = Association::where('job_id', $joborderId)
            ->where('candidate_status', 1)
            ->where('candidate_id', $dupcandId)
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with('accountmanager')
            ->with('vendor')
            ->with('candidate')
            ->with('job')
            ->get();
        //TODO Send Email to vendor stating that profile is duplicate.
        /*Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile is Duplicate one.'], function ($m) use($association_info) {
             $m->to($association_info[0]->vendor->email, 'Duplicate profile')->subject('Duplicate profile');
         });*/
        //$vendorSubject = "Opps!! " .$association_info[0]->job->id. " - " .$association_info[0]->candidate->full_name. " Seems it was a Duplicate!";
        $vendorSubject = "Oops!! Seems " . $association_info[0]->candidate->full_name . " was a Duplicate Profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name . "!";
        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeduplicatevenn', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'jobid' => $association_info[0]->job->id, 'amEmail' => $association_info[0]->accountmanager->email, 'amMobile' => $association_info[0]->accountmanager->mobile, 'amName' => $association_info[0]->accountmanager->first_name, 'text' => 'This profile is Duplicate one.'], function ($m) use ($association_info, $vendorSubject) {
            $m->to($association_info[0]->vendor->email, 'Duplicate profile')->subject($vendorSubject);
        });
        $country = Country::where('is_enabled', 1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "Hello " . $association_info[0]->vendor->first_name . " Your submitted profile (" . $association_info[0]->candidate->full_name . ") was marked as Duplicate for the [" . $association_info[0]->job->name . "-" . $association_info[0]->job->id . "] by " . $association_info[0]->accountmanager->first_name;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //$accountmanagerSubject = "Oops!! You’ve Duplicated profile for " .$association_info[0]->job->id. " - " .$association_info[0]->job->name;
        $accountmanagerSubject = "Oops!! You’ve Duplicated profile for role " . $association_info[0]->job->id . "-" . $association_info[0]->job->name;
        //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChangeduplicateam', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name, 'venEmail' => $association_info[0]->vendor->email, 'venMobile' => $association_info[0]->vendor->mobile, 'venName' => $association_info[0]->vendor->first_name, 'jobid' => $association_info[0]->job->id, 'text' => 'This profile is Duplicate one.'], function ($m) use ($association_info, $accountmanagerSubject) {
            $m->to($association_info[0]->accountmanager->email, 'Duplicate profile')->subject($accountmanagerSubject);
        });
        //TODO Send Email to Am stating that profile is duplicate.
        /* Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile is Duplicate one.'], function ($m) use($association_info){
             $m->to($association_info[0]->accountmanager->email, 'Duplicate profile')->subject('Duplicate profile');
         });*/
        return response()->success(compact('dupcandidate'));
    }

    function getAmtimeline($job_id)
    {
        $authuser = Auth::user();
        /*$vendorusers = User::where('role_id',9)
                            ->get();
        $vendorids = array();
        foreach($vendorusers as $vids){array_push($vendorids, $vids->id);}*/
        $associationcount = Association::where('job_id', $job_id)
            ->where('accountmanager_id', $authuser->id)
            ->count();
        /*->whereNotIn('vendor_id', $vendorids)*/
        if ($associationcount >= 1) {
            $amtimeline = Activity::where('job_id', $job_id)
                /*->where('activity_by', "!=", $authuser->id)*/
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('note')
                ->with('activityuser.role', 'status', 'candidate', 'job')->get();
            $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
            $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
            foreach ($amtimeline as $job) {
            $candidate_status_arr = [2, 30];
            $reasons_arr[] = explode(',', $job['reason_id']);
            if (in_array($job['candidate_status'], $candidate_status_arr)) {
                foreach ($reasons_arr as $reason) {
                    $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                }
            } else {
                $reasonsData = [];
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid, 'reasonsData' => $reasonsData];
            $job['numbers'] = $numbers;
            $scheduled_date = Association::where('accountmanager_id', $authuser->id)
                // ->where('vendor_id',$job['vendor_id'])
                ->where('candidate_id', $job['candidate_id'])
                // ->where('candidate_status',$job['candidate_status'])
                ->where('job_id', $job['job_id'])
                //->where('employer_id',$job['employer_id'])
                ->whereNotNull('interview_schedule_date')
                ->first();
            if ($scheduled_date) {
                $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                $job['association_id'] = $scheduled_date['id'];
            } else {
                $job['association_id'] = $job['interview_schedule_date'] = null;
            }
            $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $job['created_at'] = $date->format('Y-m-d H:i:s');
            $job['timezone'] = $empTimezone[0]['GMT_offset'];
            $job['timezoneName'] = $empTimezone[0]['timezone'];
            }
            return response()->success(compact('amtimeline'));
        } else {
            return response()->success('No Data Found');
        }
    }

    function getVendortimeline($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        $associationcount = Association::where('job_id', $job_id)
            ->where('vendor_id', $authId)
            ->count();
        if ($authuser->parent_id) {
            if ($associationcount >= 1) {
                $vendortimeline = Activity::where('vendor_id', $authId)
                    // ->where('admin_id',1)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('employer_id')
                    //->where('activity_by',"!=",$authuser->id)
                    ->where('job_id', intval($job_id))
                    //->whereNull('vendor_user_id')
                    ->whereNotNull('note')
                    ->whereNotNull('candidate_id')
                    ->with('activityuser.role', 'status', 'candidate', 'job')
                    ->get();
                // print_r($vendortimeline);exit();
                $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
                $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
                foreach ($vendortimeline as $job) {
                    $candidate_status_arr = [2, 30];
                    $reasons_arr[] = explode(',', $job['reason_id']);
                    if (in_array($job['candidate_status'], $candidate_status_arr)) {
                        foreach ($reasons_arr as $reason) {
                            $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                        }
                    } else {
                        $reasonsData = [];
                    }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                    $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid, 'reasonsData' => $reasonsData];
                    $job['numbers'] = $numbers;
                    $scheduled_date = Association::where('vendor_id', $authId)
                        //->where('vendor_id',$job['vendor_id'])
                        ->where('candidate_id', $job['candidate_id'])
                        // ->where('candidate_status',$job['candidate_status'])
                        ->where('job_id', $job['job_id'])
                        ->where('employer_id', $job['employer_id'])
                        ->whereNotNull('interview_schedule_date')
                        ->first();
                    if ($scheduled_date) {
                        $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                        $job['association_id'] = $scheduled_date['id'];
                    } else {
                        $job['association_id'] = $job['interview_schedule_date'] = null;
                    }
                    //$timestamp = 129346161081;
                    // $randomKey = '-';
                    //$encrypted_id = base64_encode($timestamp . $randomKey . $job['candidate']['id']);
                    // $job['candidate']['encrypted_canId'] = $encrypted_id;
                    $created_date = date('Y-m-d-H-i-s', strtotime($job['created_at']));
                    $created_at = explode('-', $created_date);
                    $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');
                    //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
                    $job['created_at'] = $date->format('Y-m-d H:i:s');
                    $job['timezone'] = $empTimezone[0]['GMT_offset'];
                    $job['timezoneName'] = $empTimezone[0]['timezone'];
                }
                return response()->success(compact('vendortimeline'));
            } else {
                return response()->success('No Data Found');
            }
        } else {
            if ($associationcount >= 1) {
                $vendortimeline = Activity::where('vendor_id', $authId)
                    ->where('admin_id', 1)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('employer_id')
                    //->where('activity_by',"!=",$authuser->id)
                    ->where('job_id', intval($job_id))
                    ->whereNull('vendor_user_id')
                    ->whereNotNull('note')
                    ->whereNotNull('candidate_id')
                    ->with('activityuser.role', 'status', 'candidate', 'job')
                    ->get();
                //print_r($vendortimeline);exit();
                foreach ($vendortimeline as $job) {
                    $candidate_status_arr = [2, 30];
                    $reasons_arr[] = explode(',', $job['reason_id']);
                    if (in_array($job['candidate_status'], $candidate_status_arr)) {
                        foreach ($reasons_arr as $reason) {
                            $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                        }
                    } else {
                        $reasonsData = [];
                    }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                    $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                    $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid, 'reasonsData' => $reasonsData];
                    $job['numbers'] = $numbers;
                    $scheduled_date = Association::where('vendor_id', $authId)
                        //->where('vendor_id',$job['vendor_id'])
                        ->where('candidate_id', $job['candidate_id'])
                        // ->where('candidate_status',$job['candidate_status'])
                        ->where('job_id', $job['job_id'])
                        ->where('employer_id', $job['employer_id'])
                        ->whereNotNull('interview_schedule_date')
                        ->first();
                    if ($scheduled_date) {
                        $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                        $job['association_id'] = $scheduled_date['id'];
                    } else {
                        $job['association_id'] = $job['interview_schedule_date'] = null;
                    }
                    // $timestamp = 129346161081;
                    // $randomKey = '-';
                    // $encrypted_id = base64_encode($timestamp . $randomKey . $job['candidate']['id']);
                    // $job['candidate']['encrypted_canId'] = $encrypted_id;
                    $created_date = date('Y-m-d-H-i-s', strtotime($job['created_at']));
                    $created_at = explode('-', $created_date);
                    $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');
                    //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
                    $job['created_at'] = $date->format('Y-m-d H:i:s');
                    $job['timezone'] = $empTimezone[0]['GMT_offset'];
                    $job['timezoneName'] = $empTimezone[0]['timezone'];
                }
                return response()->success(compact('vendortimeline'));
            } else {
                return response()->success('No Data Found');
            }
        }
    }

    function getVendorusertimeline($job_id)
    {
        $authuser = Auth::user();
        $supervendor = User::where('id', $authuser->id)->get(['first_name', 'parent_id']);
        $vendorusertimeline = Activity::where('job_id', $job_id)->where('vendor_user_id', $authuser->id)->with('activityuser.role', 'status', 'candidate')->with('job')->get();
        return response()->success(compact('vendorusertimeline'));
    }

    function getEstimaterevenue($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $estimaterevenue = VendorRevenue::where('job_id', $job_id)->get();
        if (count($estimaterevenue) > 1) {
            $finalRev = VendorRevenue::where('job_id', $job_id)->where('vendor_id', NULL)->first()->final_revenue;
            $estimaterevenue = VendorRevenue::where('job_id', $job_id)->where('vendor_id', $authId)->get();
            $jobassign = Activity::where('job_id', $job_id)
                ->where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('candidate_id')
                ->orderBy('created_at', 'asc')
                ->get();
            $firstprofile = Activity::where('job_id', $job_id)
                ->where('vendor_id', $authId)
                ->whereNotNull('employer_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->orderBy('created_at', 'asc')
                ->get();
            foreach ($estimaterevenue as $rev) {
                // print_r(count($firstprofile));exit;
                if (count($firstprofile) > 0) {
                    $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                    $from = \Carbon\Carbon::now();
                    $diff_in_minutes = $to->diffInMinutes($from);
                    //print_r($from);exit;
                    if (!$diff_in_minutes) {
                        $diff_in_minutes = $to->diffInSeconds($from);
                        if ($diff_in_minutes <= 59) $diff_in_minutes = 1;
                    }
                    $estimaterevenue[0]['first_profile_submitted_in'] = $diff_in_minutes;
                    if ($finalRev) {
                        $estimaterevenue[0]['final_revenue'] = $finalRev;
                    }
                } else {
                    $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                    $from = \Carbon\Carbon::now();
                    $ass_diff_in_minutes = $to->diffInMinutes($from);
                    $estimaterevenue[0]['first_profile_submitted_in'] = $ass_diff_in_minutes;
                    if ($finalRev) {
                        $estimaterevenue[0]['final_revenue'] = $finalRev;
                    }
                }
            }
        }
        return response()->success(compact('estimaterevenue'));
    }

    function getJobestimaterevenue($job_id)
    {
        $authuser = Auth::user();
        if($authuser->role_id ==6){
             $jobestimaterevenue = DB::table("vendor_accountmanager_share")
            ->where("vendor_id", $authuser->id)
            ->where('job_id', $job_id)
            ->get();
        }
        elseif($authuser->role_id ==9){
            $jobestimaterevenue = DB::table("vendor_accountmanager_share")
           ->where("vendor_id", $authuser->parent_id)
           ->where('job_id', $job_id)
           ->get();
       }
        else{
        $jobestimaterevenue = DB::table("vendor_accountmanager_share")
            //->where("vendor_id", $authuser->id)
            ->where('job_id', $job_id)
            ->get();
            }
        return response()->success(compact('jobestimaterevenue'));
        /*$associationcount = Association::where('job_id',$job_id)
                            ->where('accountmanager_id',$authuser->id)
                            ->count();
        if($associationcount >= 1){
            $estimaterevenue = VendorRevenue::where('job_id',$job_id)->where('vendor_id',NULL)->get();
            if(count($estimaterevenue) == 0) {
                $jobestimaterevenue = VendorRevenue::where('job_id',$job_id)->get();
            } else {
                $jobestimaterevenue = VendorRevenue::where('job_id',$job_id)->where('vendor_id',NULL)->get();
            }
            return response()->success(compact('jobestimaterevenue'));
        }else{
            $jobestimaterevenue = array();
            return response()->success(compact('jobestimaterevenue'));
        }
        */
    }

    function getEmployertimeline($job_id)
    {
        $authuser = Auth::user();
        $authId = null;
        $vendorusers = User::where('role_id', 9)->get();
        $vendorids = array();
        foreach ($vendorusers as $vids) {
            array_push($vendorids, $vids->id);
        }
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $employertimeline = Activity::where('job_id', $job_id)
            ->where('employer_id', $authId)
            ->where('name', '!=', 'Job assigned to vendor User')
            ->whereNull('employer_user_id')
            ->where('is_vendor_sourcing_activity', 0)
            ->whereNotNull('candidate_id')
            ->whereNotNull('note')
            ->with('job', 'candidate', 'activityuser.role', 'status')
            ->get();
        /*->where('name', '!=', 'Job assigned to vendor User')
                          ->where('is_vendor_sourcing_activity',0)
                          ->whereNull('employer_user_id')
                          ->whereNotNull('candidate_id')
                          ->whereNotNull('note')
                          ->with('job','candidate','activityuser.role','status')
                          ->get();*/
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        foreach ($employertimeline as $key => $job) {
            if($employertimeline[$key]['job']['blindhire'] == 1 || $employertimeline[$key]['candidate']['mask'] == 1)
                {
                  if(($employertimeline[$key]['activityuser']['role']['id'] != 5 || ($employertimeline[$key]['activityuser']['role']['id'] == 5 && $employertimeline[$key]['status']['id'] == 1 || $employertimeline[$key]['status']['id'] == 2 ))) 
                  {
                $full_name = $employertimeline[$key]['candidate']['full_name'];
                $employertimeline[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", strlen($full_name)), 2, strlen($full_name)-4);
                }
                }
            //Fetching reasons based on rejected candidate data.
            $candidate_status_arr = [2, 30];
            $reasons_arr[] = explode(',', $job['reason_id']);
            if (in_array($job['candidate_status'], $candidate_status_arr)) {
                foreach ($reasons_arr as $reason) {
                    $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                }
            } else {
                $reasonsData = [];
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid, 'reasonsData' => $reasonsData];
            $job['numbers'] = $numbers;
            $scheduled_date = Association::where('employer_id', $authId)
                // ->where('vendor_id',$job['vendor_id'])
                ->where('candidate_id', $job['candidate_id'])
                // ->where('candidate_status',$job['candidate_status'])
                ->where('job_id', $job['job_id'])
                //->where('employer_id',$job['employer_id'])
                ->whereNotNull('interview_schedule_date')
                ->first();
            if ($scheduled_date) {
                $job['interview_schedule_date'] = $scheduled_date['interview_schedule_date'];
                $job['association_id'] = $scheduled_date['id'];
            } else {
                $job['association_id'] = $job['interview_schedule_date'] = null;
            }
            $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $job['created_at'] = $date->format('Y-m-d H:i:s');
            $job['timezone'] = $empTimezone[0]['GMT_offset'];
            $job['timezoneName'] = $empTimezone[0]['timezone'];
        }
        return response()->success(compact('employertimeline'));
    }

    public function getVendorchecklist()
    {
        $vendorchecklist = VendorChecklists::get();
        return response()->success(compact('vendorchecklist'));
    }

    public function postEmployerquestions(Request $request)
    {
        $PREFERED_SKILL = $request->SKILL_PREFFERED;
		$INDUSTRY = $request->INDUSTRY;
		$IT = $request->IT;
		$CLIENT = $request->CLIENT;
		$JOB_RELATED_METHOD = $request->JOB_RELATED_METHOD;
		$LOCATION = $request->LOCATION;
		$TRAVEL_PERCENT = $request->TRAVEL_PERCENT;
		
		$replaceArray = array();
        $replaceArray['{COUNTRY}'] = '';
        $replaceArray['{RELAVENT_INDUSTRY}'] = '';
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = '';
        $replaceArray['{LOCALL_LANGUAGE}'] = '';
        $replaceArray['{DESIRED_TIMEPERIOD}'] = '';
        $replaceArray['{EXPERIENCE}'] = '';
//        $replaceArray['{SKILLS_REQUIRED}'] = '';
        $replaceArray['{SKILL_PREFFERED}'] = '';
        $replaceArray['{SKILLS}'] = '';
        $replaceArray['{CITY_NAME}'] = '';
        $getCountryData = Country::where('id', $request->COUNTRY)->first();
        if (!empty($getCountryData)) {
            $replaceArray['{COUNTRY}'] = $getCountryData->name;
        }
        $getIndustryData = Industry::where('id', $request->RELAVENT_INDUSTRY)->first();
        if (!empty($getIndustryData)) {
            $replaceArray['{RELAVENT_INDUSTRY}'] = $getIndustryData->name;
        }
        $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE = collect($request->REQUIRED_PREFFERED_EDUCATIONAL_DEGREE);
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE->pluck('name')->implode(',');
        $LOCALL_LANGUAGE = collect($request->LOCALL_LANGUAGE);
        $replaceArray['{LOCALL_LANGUAGE}'] = $LOCALL_LANGUAGE->pluck('name')->implode(',');
        $replaceArray['{DESIRED_TIMEPERIOD}'] = ($request->DESIRED_TIMEPERIOD > 0) ? $request->DESIRED_TIMEPERIOD . ' Days' : 'Immediate Joining';
        $replaceArray['{EXPERIENCE}'] = ($request->EXPERIENCE > 0) ? $request->EXPERIENCE . ' Years' : 'Fresher';

        $SKILL_PREFFERED = collect($request->SKILL_PREFFERED);
        $SKILL_PREFFERED = $SKILL_PREFFERED->pluck('text')->toArray();
//        $replaceArray['{SKILL_PREFFERED}'] = implode(',', $SKILL_PREFFERED);

        $SKILLS_REQUIRED = collect($request->SKILLS_REQUIRED);
        $SKILLS_REQUIRED = $SKILLS_REQUIRED->pluck('text')->toArray();
//        $replaceArray['{SKILLS_REQUIRED}'] = implode(',', $SKILLS_REQUIRED);

        $CITY_NAME = collect($request->CITY_NAME);


        $CITY_NAME = $CITY_NAME->pluck('name')->implode(',');
        $replaceArray['{CITY_NAME}'] = $CITY_NAME;

        $EmployerQuestionLists = EmployerQuestion::get();

        $collectSkilsArray = array_merge($SKILL_PREFFERED, $SKILLS_REQUIRED);


        $replaceArray['{SKILLS}'] = implode(',', $collectSkilsArray);

       // dd($SKILL_PREFFERED);

        $RespoceQtions = array();

        if (count($EmployerQuestionLists) > 0) {
            foreach ($EmployerQuestionLists as $EmployerQuestionList) {
                $localArray = array();


                if (strpos($EmployerQuestionList->description, '{SKILL_PREFFERED}') !== false) {
                    if (count($SKILL_PREFFERED) > 0) {
                        foreach ($SKILL_PREFFERED as $SKILL_PREFFERED_ITEM) {

                            $replaceArray['{SKILL_PREFFERED}'] = $SKILL_PREFFERED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['Q_id'] = $EmployerQuestionList->id;
                            $localArray['type'] = 'SKILL_PREFFERED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
							$localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->description, '{SKILLS_REQUIRED}') !== false) {
                    if (count($SKILLS_REQUIRED) > 0) {
                        foreach ($SKILLS_REQUIRED as $SKILLS_REQUIRED_ITEM) {

                            $replaceArray['{SKILLS_REQUIRED}'] = $SKILLS_REQUIRED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['Q_id'] = $EmployerQuestionList->id;
                            $localArray['type'] = 'SKILLS_REQUIRED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
							$localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->name, '[PREFERED_SKILL]') !== false) {
                    //print_r($PREFERED_SKILL); exit;
					foreach($PREFERED_SKILL as $skill) {
						//print_r($skill); exit;
						$localArray['description'] = $EmployerQuestionList->name;
						$localArray['Q_description'] = str_replace('[PREFERED_SKILL]', $skill['text'], $EmployerQuestionList->name);
						$localArray['Q_id'] = $EmployerQuestionList->id;
						$localArray['type'] = 'PREFERED_SKILL';
                        $localArray['is_must'] = $EmployerQuestionList->is_must;
						$localArray['flag'] = $EmployerQuestionList->flag;
						$RespoceQtions[] = $localArray;
					}
				} else if (strpos($EmployerQuestionList->name, '[INDUSTRY]') !== false) {
					//echo $INDUSTRY;exit;
                    $indInfo = Industry::where('name',$INDUSTRY)->get();
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[INDUSTRY]', $name, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'INDUSTRY';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
					
				} else if (strpos($EmployerQuestionList->name, '[IT]') !== false) {
					$indInfo = Industry::where('name',$IT)->get();
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[IT]', $name, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'IT';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
				} else if (strpos($EmployerQuestionList->name, '[CLIENT]') !== false) {
					$authuser = Auth::user();
					$authInfo = User::find($authuser->id);
					$companyInfo = Company::find($authInfo->company_id);
					
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[CLIENT]', $companyInfo->name, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'CLIENT';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
					
				} else if (strpos($EmployerQuestionList->name, '[JOB_RELATED_METHOD]') !== false) {
					
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[JOB_RELATED_METHOD]', $JOB_RELATED_METHOD, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'JOB_RELATED_METHOD';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
					
				} else if (strpos($EmployerQuestionList->name, '[LOCATION]') !== false) {
					$countryInfo = Country::find($LOCATION);
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[LOCATION]', $countryInfo->name, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'LOCATION';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
					
				} else if (strpos($EmployerQuestionList->name, '[TRAVEL_PERCENT]') !== false) {
					$localArray['description'] = $EmployerQuestionList->name;
					$localArray['Q_description'] = str_replace('[TRAVEL_PERCENT]', $TRAVEL_PERCENT, $EmployerQuestionList->name);
					$localArray['Q_id'] = $EmployerQuestionList->id;
					$localArray['type'] = 'TRAVEL_PERCENT';
					$localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
					$RespoceQtions[] = $localArray;
				} else {
					if(empty($EmployerQuestionList->description)) {
						$description = $EmployerQuestionList->name;
					} else {
						$description = $EmployerQuestionList->description;
					}
                    $localArray['description'] = $description;
                    $localArray['Q_description'] = strtr($description, $replaceArray);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = '';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
					$localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                }


//                dd($replaceArray);

//                dd($EmployerQuestionList->description);


//                dd($EmployerQuestionList->description);

            }
        }

        return response()->success(compact('RespoceQtions'));

//        dump($replaceArray);
//        dump($RespoceQtions);
//        dump($EmployerQuestionLists);
//
//        dd($request->all());

    }
    public function postEmployerquestionscreatenews(Request $request)
    {
        $PREFERED_SKILL = $request->SKILL_PREFFERED;
        $INDUSTRY = $request->INDUSTRY;
        $IT = $request->IT;
        $CLIENT = $request->CLIENT;
        $JOB_RELATED_METHOD = $request->JOB_RELATED_METHOD;
        $LOCATION = $request->LOCATION;
        $TRAVEL_PERCENT = $request->TRAVEL_PERCENT;
        
        $replaceArray = array();
        $replaceArray['{COUNTRY}'] = '';
        $replaceArray['{RELAVENT_INDUSTRY}'] = '';
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = '';
        $replaceArray['{LOCALL_LANGUAGE}'] = '';
        $replaceArray['{DESIRED_TIMEPERIOD}'] = '';
        $replaceArray['{EXPERIENCE}'] = '';
//        $replaceArray['{SKILLS_REQUIRED}'] = '';
        $replaceArray['{SKILL_PREFFERED}'] = '';
        $replaceArray['{SKILLS}'] = '';
        $replaceArray['{CITY_NAME}'] = '';
        $getCountryData = Country::where('id', $request->COUNTRY)->first();
        if (!empty($getCountryData)) {
            $replaceArray['{COUNTRY}'] = $getCountryData->name;
        }
        $getIndustryData = Industry::where('id', $request->RELAVENT_INDUSTRY)->first();
        if (!empty($getIndustryData)) {
            $replaceArray['{RELAVENT_INDUSTRY}'] = $getIndustryData->name;
        }
        $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE = collect($request->REQUIRED_PREFFERED_EDUCATIONAL_DEGREE);
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE->pluck('name')->implode(',');
        $LOCALL_LANGUAGE = collect($request->LOCALL_LANGUAGE);
        $replaceArray['{LOCALL_LANGUAGE}'] = $LOCALL_LANGUAGE->pluck('name')->implode(',');
        $replaceArray['{DESIRED_TIMEPERIOD}'] = ($request->DESIRED_TIMEPERIOD > 0) ? $request->DESIRED_TIMEPERIOD . ' Days' : 'Immediate Joining';
        $replaceArray['{EXPERIENCE}'] = ($request->EXPERIENCE > 0) ? $request->EXPERIENCE . ' Years' : 'Fresher';

        $SKILL_PREFFERED = collect($request->SKILL_PREFFERED);
        $SKILL_PREFFERED = $SKILL_PREFFERED->pluck('text')->toArray();
//        $replaceArray['{SKILL_PREFFERED}'] = implode(',', $SKILL_PREFFERED);

        $SKILLS_REQUIRED = collect($request->SKILLS_REQUIRED);
        $SKILLS_REQUIRED = $SKILLS_REQUIRED->pluck('text')->toArray();
//        $replaceArray['{SKILLS_REQUIRED}'] = implode(',', $SKILLS_REQUIRED);

        $CITY_NAME = collect($request->CITY_NAME);


        $CITY_NAME = $CITY_NAME->pluck('name')->implode(',');
        $replaceArray['{CITY_NAME}'] = $CITY_NAME;

        $EmployerQuestionLists = EmployerQuestion::get();

        $collectSkilsArray = array_merge($SKILL_PREFFERED, $SKILLS_REQUIRED);


        $replaceArray['{SKILLS}'] = implode(',', $collectSkilsArray);

       // dd($SKILL_PREFFERED);

        $RespoceQtions = array();

        if (count($EmployerQuestionLists) > 0) {
            foreach ($EmployerQuestionLists as $EmployerQuestionList) {
                $localArray = array();


                if (strpos($EmployerQuestionList->description, '{SKILL_PREFFERED}') !== false) {
                    if (count($SKILL_PREFFERED) > 0) {
						
                        foreach ($SKILL_PREFFERED as $SKILL_PREFFERED_ITEM) {

                            $replaceArray['{SKILL_PREFFERED}'] = $SKILL_PREFFERED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['question_id'] = $EmployerQuestionList->id;
                            $localArray['question_type'] = 'SKILL_PREFFERED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
                            $localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->description, '{SKILLS_REQUIRED}') !== false) {
                    if (count($SKILLS_REQUIRED) > 0) {
                        foreach ($SKILLS_REQUIRED as $SKILLS_REQUIRED_ITEM) {

                            $replaceArray['{SKILLS_REQUIRED}'] = $SKILLS_REQUIRED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['question_id'] = $EmployerQuestionList->id;
                            $localArray['question_type'] = 'SKILLS_REQUIRED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
                            $localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->name, '[PREFERED_SKILL]') !== false) {
                    //print_r($PREFERED_SKILL); exit;
                    foreach($PREFERED_SKILL as $skill) {
                        //print_r($skill); exit;
                        $localArray['description'] = $EmployerQuestionList->name;
                        $localArray['Q_description'] = str_replace('[PREFERED_SKILL]', $skill['text'], $EmployerQuestionList->name);
                        $localArray['question_id'] = $EmployerQuestionList->id;
                        $localArray['question_type'] = 'PREFERED_SKILL';
                        $localArray['is_must'] = $EmployerQuestionList->is_must;
                        $localArray['flag'] = $EmployerQuestionList->flag;
                        $RespoceQtions[] = $localArray;
                    }
                } else if (strpos($EmployerQuestionList->name, '[INDUSTRY]') !== false) {
                    //echo $INDUSTRY;exit;
                    $indInfo = Industry::where('id',$INDUSTRY)->get();
					
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[INDUSTRY]', $name, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'INDUSTRY';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[IT]') !== false) {
                    $indInfo = Industry::where('id',$IT)->get();
					//	print_r($indInfo);exit;				
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
					//echo $name;exit;
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[IT]', $name, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'IT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                } else if (strpos($EmployerQuestionList->name, '[CLIENT]') !== false) {
                    $authuser = Auth::user();
                    $authInfo = User::find($authuser->id);
                    $companyInfo = Company::find($authInfo->company_id);
                    
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[CLIENT]', $companyInfo->name, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'CLIENT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[JOB_RELATED_METHOD]') !== false) {
                    
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[JOB_RELATED_METHOD]', $JOB_RELATED_METHOD, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'JOB_RELATED_METHOD';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[LOCATION]') !== false) {
                    $countryInfo = Country::find($LOCATION);
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[LOCATION]', $countryInfo->name, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'LOCATION';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[TRAVEL_PERCENT]') !== false) {
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[TRAVEL_PERCENT]', $TRAVEL_PERCENT, $EmployerQuestionList->name);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = 'TRAVEL_PERCENT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                } else {
                    if(empty($EmployerQuestionList->description)) {
                        $description = $EmployerQuestionList->name;
                    } else {
                        $description = $EmployerQuestionList->description;
                    }
                    $localArray['description'] = $description;
                    $localArray['Q_description'] = strtr($description, $replaceArray);
                    $localArray['question_id'] = $EmployerQuestionList->id;
                    $localArray['question_type'] = '';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                }


//                dd($replaceArray);

//                dd($EmployerQuestionList->description);


//                dd($EmployerQuestionList->description);

            }
        }

        return response()->success(compact('RespoceQtions'));

//        dump($replaceArray);
//        dump($RespoceQtions);
//        dump($EmployerQuestionLists);
//
//        dd($request->all());

    }
    public function postEmployerquestionscreate(Request $request)
    {
        $PREFERED_SKILL = $request->SKILL_PREFFERED;
        $INDUSTRY = $request->INDUSTRY;
        $IT = $request->IT;
        $CLIENT = $request->CLIENT;
        $JOB_RELATED_METHOD = $request->JOB_RELATED_METHOD;
        $LOCATION = $request->LOCATION;
        $TRAVEL_PERCENT = $request->TRAVEL_PERCENT;
        
        $replaceArray = array();
        $replaceArray['{COUNTRY}'] = '';
        $replaceArray['{RELAVENT_INDUSTRY}'] = '';
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = '';
        $replaceArray['{LOCALL_LANGUAGE}'] = '';
        $replaceArray['{DESIRED_TIMEPERIOD}'] = '';
        $replaceArray['{EXPERIENCE}'] = '';
//        $replaceArray['{SKILLS_REQUIRED}'] = '';
        $replaceArray['{SKILL_PREFFERED}'] = '';
        $replaceArray['{SKILLS}'] = '';
        $replaceArray['{CITY_NAME}'] = '';
        $getCountryData = Country::where('id', $request->COUNTRY)->first();
        if (!empty($getCountryData)) {
            $replaceArray['{COUNTRY}'] = $getCountryData->name;
        }
        $getIndustryData = Industry::where('id', $request->RELAVENT_INDUSTRY)->first();
        if (!empty($getIndustryData)) {
            $replaceArray['{RELAVENT_INDUSTRY}'] = $getIndustryData->name;
        }
        $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE = collect($request->REQUIRED_PREFFERED_EDUCATIONAL_DEGREE);
        $replaceArray['{REQUIRED_PREFFERED_EDUCATIONAL_DEGREE}'] = $REQUIRED_PREFFERED_EDUCATIONAL_DEGREE->pluck('name')->implode(',');
        $LOCALL_LANGUAGE = collect($request->LOCALL_LANGUAGE);
        $replaceArray['{LOCALL_LANGUAGE}'] = $LOCALL_LANGUAGE->pluck('name')->implode(',');
        $replaceArray['{DESIRED_TIMEPERIOD}'] = ($request->DESIRED_TIMEPERIOD > 0) ? $request->DESIRED_TIMEPERIOD . ' Days' : 'Immediate Joining';
        $replaceArray['{EXPERIENCE}'] = ($request->EXPERIENCE > 0) ? $request->EXPERIENCE . ' Years' : 'Fresher';

        $SKILL_PREFFERED = collect($request->SKILL_PREFFERED);
        $SKILL_PREFFERED = $SKILL_PREFFERED->pluck('text')->toArray();
//        $replaceArray['{SKILL_PREFFERED}'] = implode(',', $SKILL_PREFFERED);

        $SKILLS_REQUIRED = collect($request->SKILLS_REQUIRED);
        $SKILLS_REQUIRED = $SKILLS_REQUIRED->pluck('text')->toArray();
//        $replaceArray['{SKILLS_REQUIRED}'] = implode(',', $SKILLS_REQUIRED);

        $CITY_NAME = collect($request->CITY_NAME);


        $CITY_NAME = $CITY_NAME->pluck('name')->implode(',');
        $replaceArray['{CITY_NAME}'] = $CITY_NAME;

        $EmployerQuestionLists = EmployerQuestion::get();

        $collectSkilsArray = array_merge($SKILL_PREFFERED, $SKILLS_REQUIRED);


        $replaceArray['{SKILLS}'] = implode(',', $collectSkilsArray);

       // dd($SKILL_PREFFERED);

        $RespoceQtions = array();

        if (count($EmployerQuestionLists) > 0) {
            foreach ($EmployerQuestionLists as $EmployerQuestionList) {
                $localArray = array();


                if (strpos($EmployerQuestionList->description, '{SKILL_PREFFERED}') !== false) {
                    if (count($SKILL_PREFFERED) > 0) {
                        foreach ($SKILL_PREFFERED as $SKILL_PREFFERED_ITEM) {

                            $replaceArray['{SKILL_PREFFERED}'] = $SKILL_PREFFERED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['Q_id'] = $EmployerQuestionList->id;
                            $localArray['type'] = 'SKILL_PREFFERED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
                            $localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->description, '{SKILLS_REQUIRED}') !== false) {
                    if (count($SKILLS_REQUIRED) > 0) {
                        foreach ($SKILLS_REQUIRED as $SKILLS_REQUIRED_ITEM) {

                            $replaceArray['{SKILLS_REQUIRED}'] = $SKILLS_REQUIRED_ITEM;
                            $localArray['description'] = $EmployerQuestionList->description;
                            $localArray['Q_description'] = strtr($EmployerQuestionList->description, $replaceArray);
                            $localArray['Q_id'] = $EmployerQuestionList->id;
                            $localArray['type'] = 'SKILLS_REQUIRED';
                            $localArray['is_must'] = $EmployerQuestionList->is_must;
                            $localArray['flag'] = $EmployerQuestionList->flag;
                            $RespoceQtions[] = $localArray;

                        }
                    }
                } else if (strpos($EmployerQuestionList->name, '[PREFERED_SKILL]') !== false) {
                    //print_r($PREFERED_SKILL); exit;
                    foreach($PREFERED_SKILL as $skill) {
                        //print_r($skill); exit;
                        $localArray['description'] = $EmployerQuestionList->name;
                        $localArray['Q_description'] = str_replace('[PREFERED_SKILL]', $skill['text'], $EmployerQuestionList->name);
                        $localArray['Q_id'] = $EmployerQuestionList->id;
                        $localArray['type'] = 'PREFERED_SKILL';
                        $localArray['is_must'] = $EmployerQuestionList->is_must;
                        $localArray['flag'] = $EmployerQuestionList->flag;
                        $RespoceQtions[] = $localArray;
                    }
                } else if (strpos($EmployerQuestionList->name, '[INDUSTRY]') !== false) {
                    //echo $INDUSTRY;exit;
                    if(isset($INDUSTRY['id'])){
                        $indInfo = Industry::find($INDUSTRY['id'])->get();
                    }
                    else{
                        $indInfo = Industry::find($INDUSTRY)->get();
                    }
                    
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[INDUSTRY]', $name, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'INDUSTRY';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[IT]') !== false) {
                    if(isset($IT['id'])){
                        $indInfo = Industry::find($IT['id'])->get();
                    }
                    else{
                        $indInfo = Industry::find($IT)->get();
                    }                   
                    if(is_array($indInfo) && count($indInfo)>0) {
                        $name = $indInfo[0]->name;
                    } else {
                        $name = $indInfo[0]->name;
                    }
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[IT]', $name, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'IT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                } else if (strpos($EmployerQuestionList->name, '[CLIENT]') !== false) {
                    $authuser = Auth::user();
                    $authInfo = User::find($authuser->id);
                    $companyInfo = Company::find($authInfo->company_id);
                    
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[CLIENT]', $companyInfo->name, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'CLIENT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[JOB_RELATED_METHOD]') !== false) {
                    
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[JOB_RELATED_METHOD]', $JOB_RELATED_METHOD, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'JOB_RELATED_METHOD';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[LOCATION]') !== false) {
                    $countryInfo = Country::find($LOCATION);
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[LOCATION]', $countryInfo->name, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'LOCATION';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                    
                } else if (strpos($EmployerQuestionList->name, '[TRAVEL_PERCENT]') !== false) {
                    $localArray['description'] = $EmployerQuestionList->name;
                    $localArray['Q_description'] = str_replace('[TRAVEL_PERCENT]', $TRAVEL_PERCENT, $EmployerQuestionList->name);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = 'TRAVEL_PERCENT';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                } else {
                    if(empty($EmployerQuestionList->description)) {
                        $description = $EmployerQuestionList->name;
                    } else {
                        $description = $EmployerQuestionList->description;
                    }
                    $localArray['description'] = $description;
                    $localArray['Q_description'] = strtr($description, $replaceArray);
                    $localArray['Q_id'] = $EmployerQuestionList->id;
                    $localArray['type'] = '';
                    $localArray['is_must'] = $EmployerQuestionList->is_must;
                    $localArray['flag'] = $EmployerQuestionList->flag;
                    $RespoceQtions[] = $localArray;
                }


//                dd($replaceArray);

//                dd($EmployerQuestionList->description);


//                dd($EmployerQuestionList->description);

            }
        }

        return response()->success(compact('RespoceQtions'));

//        dump($replaceArray);
//        dump($RespoceQtions);
//        dump($EmployerQuestionLists);
//
//        dd($request->all());

    }

    public function getVendorjobvcheck($id)
    {

//        $vendorjobvcheck = JobOrders::select('work_question', 'work_question_2', 'freshers_apply', 'getCity')->with('getCity')->where('id', $id)->first();



        $vendorjobvcheckData = JobOrders::where('id', $id)->first();


//        dd($vendorjobvcheck[0]->getCity->Country);

// dd($vendorjobvcheckData->JobCitys->first()->citys->Country);


        $vendorjobvcheckData->countryName = isset($vendorjobvcheckData->JobCitys->first()->citys->Country)? $vendorjobvcheckData->JobCitys->first()->citys->Country->name: '';

        $vendorjobvcheck = [
            'countryName'=>$vendorjobvcheckData->countryName,
            'work_question'=>$vendorjobvcheckData->work_question,
            'work_question_2'=>$vendorjobvcheckData->work_question_2,
            'freshers_apply'=>$vendorjobvcheckData->freshers_apply,
        ];


        return response()->success(compact('vendorjobvcheck'));
    }

// Need @todo

///@neyaz for rejection 


private  function jobReject($job_id){
	
		$authuser = Auth::user();
        $id = $job_id;  
        $comment = 'Account Manager rejected job';
        $joborderData = ['status' => 2];
        $bellStatus = ['status' => 1];
		
        $supervendor = User::where('id', $authuser->id)->get(['first_name']);
		
        $amjobrejectusershow = JobOrders::where('id', $id)->update($joborderData);
		
        $amjobrejectusershow = JobOrders::where('id', $id)->get();
		
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
       
	   $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobrejectusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->first();
			
        $countryCode = User::select('country_code')->where('email', $association_info['employer']['email'])->get();
        
		$mobileNumber = $countryCode[0]->country_code . $association_info['accountmanager']['mobile'];
        
		$user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        
		/*if ($user[0]->user_type != 1) {
            Mail::send('emails.notifyAmJobRejectingApplications', ['userName' => $association_info['employer']['first_name'], 'accountmanager_name' => $association_info['accountmanager']['first_name'], 'candidateName' => '', 'jobName' => $association_info['job']['name'], 'jobId' => $id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Rejected by Accountmanager.', 'accountmanager_email' => $association_info['accountmanager']['email'], 'accountmanager_mobile' => $mobileNumber], function ($m) use ($association_info) {
                 $m->to($association_info['employer']['email'], 'Job Rejected By Accountmanager')->subject('We may have to connect with you on this!');
            });
        }*/
		
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
		
        $client_name = Company::where('id', $authuser->company_id)->get(['name']);
        $country = Country::where('is_enabled', 1)->get();
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
		
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($user[0]->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The job order for the " . $association_info['job']['name'] . " has been rejected by Account Manager";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }  
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager rejected job";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $jobactivity->job_id = intval($id);
        $jobactivity->comment = $comment;
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
        return response()->success('Account manager has  rejected the job');
}


public function postChangejobstatus(Request $request){
		
		$authuser = Auth::user();
		 
		$data = $request->job_id;
		
		$id = $data['joborderId'];
		
		$am_status =$data['sts'];
		
		if($am_status==2){ // reject condition
			return $this->jobReject($id);
		}
		
		$joborderData = ['status' => $am_status];
		
        $bellStatus = ['status' => 1];
		
		
        $amjobacceptusershow = JobOrders::where('id', $id)->update($joborderData);
		
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
		
        $amjobacceptusershow = JobOrders::where('id', $id)->get();
		
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager Accepted job";
		
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
		
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id; // need change here 
        $jobactivity->job_id = intval($id);
		
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
		
        $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobacceptusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->with('company')
            ->first();
			
        $companyid 		= 	User::select('company_id')->where('email', $association_info['employer']['email'])->get();
		
        $companyname 	= 	Company::select('name')->where('id', $companyid[0]->company_id)->get();
		
        $company_name 	= 	Company::select('name')->where('id', $authuser->company_id)->get(['name']);
		
        $subject = "You accepted job " . $association_info['job']['id'] . "-" . $association_info['job']['name'] . " | " . $companyname[0]->name . " !";
              
		 
		
	 	if ($authuser->user_type != 1) {
			
            Mail::send('emails.notifyAmJobAcceptingApplications', 
					['userName' => $association_info['accountmanager']['first_name'], 
					'jobId' 	=> $association_info['job']['id'], 
					'jobName' 	=> $association_info['job']['name'], 
					'company_name' => $companyname[0]->name, 
					'jobCode' 	=> $association_info['job']['job_internal_code'], 
					'text' 		=> 'This Job is Accepted by Accountmanager.'], 
							function ($m) use ($association_info, $subject, $company_name) {
										$m->to($association_info['accountmanager']['email'], 
										'Job Accepted By Accountmanager')->subject($subject);
            });
        }
		
        $user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        
		$subject_emp = $association_info['job']['id'] . " - " . $association_info['job']['name'] . " Accepted..Happy to Assist You!";

		if ($user[0]->user_type != 1) {
			
            Mail::send('emails.notifyAmJobAcceptingApplicationstoemp', 
				['userName' => $association_info['employer']['first_name'], 
				'jobId' => $association_info['job']['id'], 
				'jobName' => $association_info['job']['name'], 
				'jobCode' => $association_info['job']['job_internal_code'], 
				'text' => 'This Job is Accepted by Accountmanager.'],
				function ($m) use ($association_info, $subject_emp) {
                 $m->to($association_info['employer']['email'], 'Job Accepted By Accountmanager')->subject($subject_emp);
            });
        }  
		 	
      //  return response()->success(compact('amjobacceptusershow'));
	          return response()->success('Account manager has  accepted the job');

		
		
		
}

    public function putAmjobacceptuserShow($id)
    {
        $authuser = Auth::user();
        $joborderData = ['status' => 3];
        $bellStatus = ['status' => 1];
        $amjobacceptusershow = JobOrders::where('id', $id)->update($joborderData);
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
        $amjobacceptusershow = JobOrders::where('id', $id)->get();
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager Accepted job";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $jobactivity->job_id = intval($id);
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
        $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobacceptusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->with('company')
            ->first();
        $companyid = User::select('company_id')->where('email', $association_info['employer']['email'])->get();
        $companyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        // $subject = "You Accepted " .$association_info['job']['id']. " - " .$association_info['job']['name']. " - " .$company_name[0]->name." !" ;
        $subject = "You Accepted Job " . $association_info['job']['id'] . "-" . $association_info['job']['name'] . " | " . $companyname[0]->name . " !";
        $subject1 = $association_info['job']['id'] . " - " . $association_info['job']['name'] . " Accepted..Happy to Assist You!";
        if ($authuser->user_type != 1) {
            Mail::send('emails.notifyAmJobAcceptingApplications', ['userName' => $association_info['accountmanager']['first_name'], 'jobId' => $association_info['job']['id'], 'jobName' => $association_info['job']['name'], 'company_name' => $companyname[0]->name, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Accepted by Accountmanager.'], function ($m) use ($association_info, $subject, $company_name) {
                $m->to($association_info['accountmanager']['email'], 'Job Accepted By Accountmanager')->subject($subject);
                // $m->to($association_info['employer']['email'], 'Job Accepted By Accountmanager')->subject('Job Accepted By Accountmanager');
            });
        }
        $user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        if ($user[0]->user_type != 1) {
            Mail::send('emails.notifyAmJobAcceptingApplicationstoemp', ['userName' => $association_info['employer']['first_name'], 'jobId' => $association_info['job']['id'], 'jobName' => $association_info['job']['name'], 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Accepted by Accountmanager.'], function ($m) use ($association_info, $subject1) {
                // $m->to($association_info['accountmanager']['email'], 'Job Accepted By Accountmanager')->subject('Job Accepted By Accountmanager');
                $m->to($association_info['employer']['email'], 'Job Accepted By Accountmanager')->subject($subject1);
            });
        }
        return response()->success(compact('amjobacceptusershow'));
    }

    public function putAllamjobacceptuserShow($id)
    {
        $authuser = Auth::user();
        $joborderData = ['status' => 3];
        $bellStatus = ['status' => 1];        
        $jobids = explode (",", $id); 
        foreach($jobids as $jobid){

         $allamjobacceptusershow = self::jobacceptuserShow($jobid);

        }      
     
    
        return response()->success(compact('allamjobacceptusershow'));
    }

    public function jobacceptuserShow($id)
    {
        $authuser = Auth::user();
        $joborderData = ['status' => 3];
        $bellStatus = ['status' => 1];
        $amjobacceptusershow = JobOrders::where('id', $id)->update($joborderData);
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
        $amjobacceptusershow = JobOrders::where('id', $id)->get();
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager Accepted job";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $jobactivity->job_id = intval($id);
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
        $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobacceptusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->with('company')
            ->first();
        $companyid = User::select('company_id')->where('email', $association_info['employer']['email'])->get();
        $companyname = Company::select('name')->where('id', $companyid[0]->company_id)->get();
        $company_name = Company::select('name')->where('id', $authuser->company_id)->get(['name']);
        // $subject = "You Accepted " .$association_info['job']['id']. " - " .$association_info['job']['name']. " - " .$company_name[0]->name." !" ;
        $subject = "You Accepted Job " . $association_info['job']['id'] . "-" . $association_info['job']['name'] . " | " . $companyname[0]->name . " !";
        $subject1 = $association_info['job']['id'] . " - " . $association_info['job']['name'] . " Accepted..Happy to Assist You!";
        if ($authuser->user_type != 1) {
            Mail::send('emails.notifyAmJobAcceptingApplications', ['userName' => $association_info['accountmanager']['first_name'], 'jobId' => $association_info['job']['id'], 'jobName' => $association_info['job']['name'], 'company_name' => $companyname[0]->name, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Accepted by Accountmanager.'], function ($m) use ($association_info, $subject, $company_name) {
                $m->to($association_info['accountmanager']['email'], 'Job Accepted By Accountmanager')->subject($subject);
                // $m->to($association_info['employer']['email'], 'Job Accepted By Accountmanager')->subject('Job Accepted By Accountmanager');
            });
        }
        $user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        if ($user[0]->user_type != 1) {
            Mail::send('emails.notifyAmJobAcceptingApplicationstoemp', ['userName' => $association_info['employer']['first_name'], 'jobId' => $association_info['job']['id'], 'jobName' => $association_info['job']['name'], 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Accepted by Accountmanager.'], function ($m) use ($association_info, $subject1) {
                // $m->to($association_info['accountmanager']['email'], 'Job Accepted By Accountmanager')->subject('Job Accepted By Accountmanager');
                $m->to($association_info['employer']['email'], 'Job Accepted By Accountmanager')->subject($subject1);
            });
        }
        return true;
    }


    public function getAmjobacceptuserdataShow($id)
    {
        $authuser = Auth::user();
        $amjobacceptuserdatashow = JobOrders::where('id', $id)->with('status')->get();
        return response()->success(compact('amjobacceptuserdatashow'));
    }

    public function postAmjobrejectuser()
    {
        $authuser = Auth::user();
        $id = Input::get('joborderId');
        $comment = Input::get('note');
        $joborderData = ['status' => 2];
        $bellStatus = ['status' => 1];
        $supervendor = User::where('id', $authuser->id)->get(['first_name']);
        $amjobrejectusershow = JobOrders::where('id', $id)->update($joborderData);
        $amjobrejectusershow = JobOrders::where('id', $id)->get();
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
        $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobrejectusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->first();
        $countryCode = User::select('country_code')->where('email', $association_info['employer']['email'])->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info['accountmanager']['mobile'];
        $user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        if ($user[0]->user_type != 1) {
            Mail::send('emails.notifyAmJobRejectingApplications', ['userName' => $association_info['employer']['first_name'], 'accountmanager_name' => $association_info['accountmanager']['first_name'], 'candidateName' => '', 'jobName' => $association_info['job']['name'], 'jobId' => $id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Rejected by Accountmanager.', 'accountmanager_email' => $association_info['accountmanager']['email'], 'accountmanager_mobile' => $mobileNumber], function ($m) use ($association_info) {
                // $m->to($association_info['accountmanager']['email'], 'Job Rejected By Accountmanager')->subject('Job Rejected By Accountmanager');
                $m->to($association_info['employer']['email'], 'Job Rejected By Accountmanager')->subject('We may have to connect with you on this!');
            });
        }
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $client_name = Company::where('id', $authuser->company_id)->get(['name']);
        $country = Country::where('is_enabled', 1)->get();
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($user[0]->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The job order for the " . $association_info['job']['name'] . " has been rejected by Account Manager";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager rejected job";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $jobactivity->job_id = intval($id);
        $jobactivity->comment = $comment;
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
        return response()->success(compact('amjobrejectusershow'));
    }

    public function putAllamrejectjobs($id)
    {
        $authuser = Auth::user();
        $joborderData = ['status' => 3];
        $bellStatus = ['status' => 1];        
        $jobids = explode (",", $id); 

       
       foreach($jobids as $jobid){

         $allamjobsreject = self::allamjobrejectuser($jobid);

        }     
       
    
        return response()->success(compact('allamjobsreject'));
    }
    public function allamjobrejectuser($jobid)
    {
        $authuser = Auth::user();
        $id = $jobid;
        $comment = Input::get('note');
        $joborderData = ['status' => 2];
        $bellStatus = ['status' => 1];
        $supervendor = User::where('id', $authuser->id)->get(['first_name']);
        $amjobrejectusershow = JobOrders::where('id', $id)->update($joborderData);
        $amjobrejectusershow = JobOrders::where('id', $id)->get();
        $bellStatusUpdate = BellNotifications::where('job_id', $id)->where('accountmanager_id', $authuser->id)->update($bellStatus);
        $association_info = Association::where('job_id', $id)
            ->whereNull('candidate_id')
            ->where('employer_id', $amjobrejectusershow[0]['user_id'])
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('employer')
            ->with('job')
            ->first();
        $countryCode = User::select('country_code')->where('email', $association_info['employer']['email'])->get();
        $mobileNumber = $countryCode[0]->country_code . $association_info['accountmanager']['mobile'];
        $user = DB::table('users')->select('user_type')->where('email', $association_info['employer']['email'])->get();
        if ($user[0]->user_type != 1) {
            Mail::send('emails.notifyAmJobRejectingApplications', ['userName' => $association_info['employer']['first_name'], 'accountmanager_name' => $association_info['accountmanager']['first_name'], 'candidateName' => '', 'jobName' => $association_info['job']['name'], 'jobId' => $id, 'jobCode' => $association_info['job']['job_internal_code'], 'text' => 'This Job is Rejected by Accountmanager.', 'accountmanager_email' => $association_info['accountmanager']['email'], 'accountmanager_mobile' => $mobileNumber], function ($m) use ($association_info) {
                // $m->to($association_info['accountmanager']['email'], 'Job Rejected By Accountmanager')->subject('Job Rejected By Accountmanager');
                $m->to($association_info['employer']['email'], 'Job Rejected By Accountmanager')->subject('We may have to connect with you on this!');
            });
        }
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $client_name = Company::where('id', $authuser->company_id)->get(['name']);
        $country = Country::where('is_enabled', 1)->get();
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        if ($user[0]->user_type != 1) {
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The job order for the " . $association_info['job']['name'] . " has been rejected by Account Manager";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        }
        $jobactivity = new Activity();
        $jobactivity->name = "Account Manager rejected job";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $authuser->id;
        $jobactivity->employer_id = JobOrders::where('id', $id)->first()->user_id;
        $jobactivity->job_id = intval($id);
        $jobactivity->comment = $comment;
        $jobactivity->activity_by = $authuser->id;
        $jobactivity->save();
        return true;
    }


    public function getAmjobrejectuserdataShow($id)
    {
        $authuser = Auth::user();
        $amjobrejectuserdatashow = JobOrders::where('id', $id)->with('status')->get();
        return response()->success(compact('amjobrejectuserdatashow'));
    }

    public function getAmprofiles()
    {
        $authuser = Auth::user();
        $profiles_gdpr = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 0);
            })->with(array('Status', 'Candidate', 'vendor','job'))
            ->get()->toArray();
        $profiles_gdpr_yes = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 1);
            })->with(array('Status', 'Candidate', 'vendor','job'))
            ->where('gdpr_status', 1)
            ->get()->toArray();
        $amprofiles = array_merge($profiles_gdpr, $profiles_gdpr_yes);
        foreach ($amprofiles as $candidate) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $candidate['numbers'] = $numbers;
            $amprofiles1[] = $candidate;
        }
        $amprofiles = $amprofiles1;
        return response()->success(compact('amprofiles'));
    }

    public function getAmvendorworking()
    {
        $authuser = Auth::user();
        $amvendorworking = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 8);
            })
            ->get();
        foreach ($amvendorworking as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amvendorworking'));
    }

    public function getAmassignvendors()
    {
        $authuser = Auth::user();
        $amassignvendors = Association::where('accountmanager_id', $authuser->id)
            ->with('job_closed.status')
            ->with('job_closed.JobType')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 3);
            })
            ->groupby('job_id')
            ->havingRaw('count(vendor_id) < 1')
            ->get();
        foreach ($amassignvendors as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amassignvendors'));
    }

    public function getAmpositionsclosed()
    {
        $authuser = Auth::user();
        $ampositionsclosed = Association::where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->where('vendor_approval',1)
                                ->where('candidate_status', 27)
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor','vendor.company','job','candidate.candidate_operational_skill','candidate.educations','CandidateSkills','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                                ->with('CandidateNotes')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->get();
        foreach ($ampositionsclosed as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidatenotes = VendorCandidateNotes::where('job_id', $job['job_id'])
                            ->where('candidate_id', $job['candidate_id'])
                            ->select('note_description')->get();
            $job['vendorcandidatenotes'] = $candidatenotes;
        }
        
        
        //print_r($ampositionsclosed);exit;
        return response()->success(compact('ampositionsclosed'));
    }

    public function getAmpendingjobs($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$ampendingjobs = Cache::remember('getAmpendingjobs_ampendingjobs', 60, function() use ($authuser) {
        $ampendingjobs = Association::where('accountmanager_id', $authuser->id)->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_closed.status')
            ->with('job.JobType')
            ->with('job_closed.JobType')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })
            ->get();
        //});
        foreach ($ampendingjobs as $job) {
            $jobId[] = $job->job_id;
        }
        //$assoStatsRaw = Cache::remember('getAmpendingjobs_assoStatsRaw', 60, function() use ($authuser, $jobId) {
        $assoStatsRaw = Association::whereIn('job_id', $jobId)
            ->where('accountmanager_id', $authuser->id)->where('gdpr_status', 1)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        //});
        foreach ($assoStatsRaw as $stats) {
            $assoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        //$assignedToRaw = Cache::remember('getAmpendingjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereIn('job_id', $jobId)
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->select('job_id', DB::raw('count(id) AS assignedTo'))
            ->groupBy("job_id")
            ->get();
        //});
        foreach ($assignedToRaw as $stats) {
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }
        //$rejectedByRaw = Cache::remember('getAmpendingjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('candidate_id')
            ->whereIn('job_id', $jobId)
            ->where('job_status', 2)
            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
            ->groupBy('job_id')
            ->groupBy('vendor_id')
            ->get();
        ///});
        foreach ($rejectedByRaw as $stats) {
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }
        //$vendorAcceptedAtRaw = Cache::remember('getAmpendingjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId) {
        $vendorAcceptedAtRaw = Activity::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->where('admin_id', 1)
            ->whereNull('job_status')
            ->whereIn('job_id', $jobId)
            ->whereNull('vendor_id')
            ->where('activity_by', $authuser->id)
            ->whereNull('status_id')
            ->where('is_vendor_sourcing_activity', 0)
            ->select('job_id', 'created_at')
            ->groupBy('job_id')
            ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats) {
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }
        reset($ampendingjobs);
        foreach ($ampendingjobs as $key => $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            if (isset($assoStats[$job['job_id']])) {
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('ampendingjobs'));
    }

    public function getAmpendingjobsall()
    {
        $authuser = Auth::user();
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$ampendingjobs = Cache::remember('getAmpendingjobs_ampendingjobs', 60, function() use ($authuser) {
        $ampendingjobsall = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_closed.status')
            ->with('job_closed.JobType')
            ->with('job.JobType')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })
            ->get();
        //});
        foreach ($ampendingjobsall as $job) {
            $jobId[] = $job->job_id;
        }
        //$assoStatsRaw = Cache::remember('getAmpendingjobs_assoStatsRaw', 60, function() use ($authuser, $jobId) {
        $assoStatsRaw = Association::whereIn('job_id', $jobId)
            ->where('accountmanager_id', $authuser->id)->where('gdpr_status', 1)
            ->whereNotNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->select('job_id',
                DB::raw('count(id) AS profilesReceived'),
                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
            )
            ->groupBy('job_id')
            ->get();
        //});
        foreach ($assoStatsRaw as $stats) {
            $assoStats[$stats->job_id] = array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        //$assignedToRaw = Cache::remember('getAmpendingjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereIn('job_id', $jobId)
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->select('job_id', DB::raw('count(id) AS assignedTo'))
            ->groupBy("job_id")
            ->get();
        //});
        foreach ($assignedToRaw as $stats) {
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }
        //$rejectedByRaw = Cache::remember('getAmpendingjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('candidate_id')
            ->whereIn('job_id', $jobId)
            ->where('job_status', 2)
            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
            ->groupBy('job_id')
            ->groupBy('vendor_id')
            ->get();
        ///});
        foreach ($rejectedByRaw as $stats) {
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }
        //$vendorAcceptedAtRaw = Cache::remember('getAmpendingjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId) {
        $vendorAcceptedAtRaw = Activity::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->where('admin_id', 1)
            ->whereNull('job_status')
            ->whereIn('job_id', $jobId)
            ->whereNull('vendor_id')
            ->where('activity_by', $authuser->id)
            ->whereNull('status_id')
            ->where('is_vendor_sourcing_activity', 0)
            ->select('job_id', 'created_at')
            ->groupBy('job_id')
            ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats) {
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }
        reset($ampendingjobsall);
        foreach ($ampendingjobsall as $key => $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            if (isset($assoStats[$job['job_id']])) {
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('ampendingjobsall'));
    }

    public function getAdminpendingjobs()
    {
        $authuser = Auth::user();
        $adminpendingjobs = Association::whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_closed.JobType')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })->with('job_closed.status')
            ->get();
        foreach ($adminpendingjobs as $job) {
            $receivedProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(17, 26))
                ->count();
            $offeredProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job->job['id'])
                ->where('admin_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'encrypted_jobId' => $encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('adminpendingjobs'));
    }

    public function getEmpassignedvendors()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $empassignedvendors = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->where('job_status', 3)
            ->groupBy('vendor_id')
            ->with('vendor.company')
            ->get();
        return response()->success(compact('empassignedvendors'));
    }

    public function getEmpjobvendors($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $empjobvendors = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->where('job_id', $id)
            ->whereNull('candidate_id')
            ->whereIn('job_status', [4, 3, 2])
            ->groupBy('vendor_id')
            ->with('vendor.company')
            ->get();
        return response()->success(compact('empjobvendors'));
    }

    public function getJobsclosed()
    {
        $authuser = Auth::user();
        $jobsclosed = JobOrders::where('status', 6)->where('user_id', $authuser->id)->where('is_talentpool', 0)->with('JobType')->with('status')->with('Industry')->get();
        return response()->success(compact('jobsclosed'));
    }

    public function getFetchindustry($name)
    {
        $fetchIndustry = Industry::where('name', $name)->first();
        // print_r($fetchIndustry);
        return response()->success(compact('fetchIndustry'));
    }

    public function getFetchindustrybyid($id)
    {
        $fetchindustrybyid = Industry::where('id', $id)->first();
        return response()->success(compact('fetchindustrybyid'));
    }

    public function getAlltalentpools($id)
    {
        $alltalentpools = Talentpools::where('status', 1)->count();
        return response()->success(compact('alltalentpools'));
    }

    public function getFetchjobtypeid($name)
    {
        $fetchjobtypeid = JobType::where('name', $name)->first();
        return response()->success(compact('fetchjobtypeid'));
    }

    public function postFetchprefqual()
    {
        $arr = Input::get('preferredSkills');
        $fetchprefqual = EducationQualification::whereIn('qualification', $arr)
            ->select('id', 'qualification')
            ->lists('qualification');
        return response()->success(compact('fetchprefqual'));
    }

    public function getJobassignvendors($id)
    {
        $authuser = Auth::user();
        $vendorusers = User::where('role_id', 9)
            ->get();
        $vendorids = array();
        foreach ($vendorusers as $vids) {
            array_push($vendorids, $vids->id);
        }
        $amassignvendors = Association::where('accountmanager_id', $authuser->id)->where('job_id', $id)
            ->whereNotIn('vendor_id', $vendorids)
            ->whereNotNull('admin_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('vendor')
            ->get();
        foreach ($amassignvendors as $key => $vendor) {
            $submitted = Association::where('accountmanager_id', $authuser->id)
                ->where('vendor_id',$vendorids)
                ->where('job_id', $id)
                ->whereNotNull('employer_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
                 $amassignvendors[$key]['submitted'] = $submitted;
            }

        return response()->success(compact('amassignvendors'));
    }

    public function postAssignvendorsteamview()
    {
        $authuser = Auth::user();
        $vendors = Input::get('vendors');
        $job_id = Input::get('jobOrderId');
        /* $job = JobOrders::where('id', '=', intval($job_id))->with('JobCity')->get();*/
        foreach ($vendors as $vendor) {
            $amassignvendors = Association::where('vendor_id', $authuser->id)->where('job_id', $job_id)
                ->whereNotNull('admin_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->with('vendor')
                ->get();
            $vendorassociation = new Association();
            $vendorassociation->admin_id = 1;
            $vendorassociation->accountmanager_id = $amassignvendors[0]['accountmanager_id'];
            $vendorassociation->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendorassociation->vendor_id = $authuser->id;
            $vendorassociation->vendor_user_id = $vendor['id'];
            $vendorassociation->job_id = $job_id;
            $vendorassociation->save();
            $vendoractivity = new Activity();
            $vendoractivity->name = "Job assigned to vendor User";
            $vendoractivity->admin_id = 1;
            $vendoractivity->accountmanager_id = $amassignvendors[0]['accountmanager_id'];
            $vendoractivity->employer_id = JobOrders::where('id', $job_id)->first()->user_id;
            $vendoractivity->vendor_id = $authuser->id;
            $vendoractivity->vendor_user_id = $vendor['id'];
            $vendoractivity->job_id = $job_id;
            $vendoractivity->job_status = 3;
            $vendoractivity->activity_by = $authuser->id;
            $vendoractivity->save();
            $vendoractivity = new VendorActivities();
            $vendoractivity->vendor_id = $authuser->id;
            $vendoractivity->vendor_user_id = $vendor['id'];
            $vendoractivity->job_id = $job_id;
            /*$vendoractivity->note = "Job assigned to vendor User";;*/
            $vendoractivity->save();
        }
        return response()->success(compact('success'));
    }

    public function getJobalert($id)
    {
        $authuser = Auth::user();
        $jobalert = Association::where('vendor_id', $authuser->id)->where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->where('job_status', 4)
            ->count();
        return response()->success(compact('jobalert'));
    }

    public function getJobstatus($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $jobstatus = Association::where('vendor_id', $authId)->where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->whereNotNull('job_status')
            ->with('job_status')
            ->with('vendor')
            ->get();
        //echo '<pre>'; print_r($jobstatus); die;
        return response()->success(compact('jobstatus'));
    }

    public function getAmassignedvendorsnumbers($job_id)
    {
        $authuser = Auth::user();
        $amassignedvendorsnumbers = Association::where('accountmanager_id', $authuser->id)
            ->where('job_id', $job_id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('candidate_id')
            ->whereNotNull('job_status')
            ->with('job_status')
            ->with('vendor.company')
            ->get();
        foreach ($amassignedvendorsnumbers as $key => $vendor) {
            $submitted = Association::where('accountmanager_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereNotNull('employer_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $shortlisted = Association::where('accountmanager_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereNotIn('candidate_status', [1, 2, 19, 30, 31])
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $rejected = Association::where('accountmanager_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereIn('candidate_status', [1, 2, 30])
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $custom_revenue = VendorRevenue::where('vendor_id', NULL)->where('job_id', $job_id)->count();
            if ($custom_revenue > 0) {
                $vendor_revenue = VendorRevenue::where('vendor_id', NULL)->where('job_id', $job_id)->first();
            } else {
                $vendor_revenue = VendorRevenue::where('vendor_id', $vendor->vendor_id)->where('job_id', $job_id)->first();
            }
            $amassignedvendorsnumbers[$key]['submitted'] = $submitted;
            $amassignedvendorsnumbers[$key]['shortlisted'] = $shortlisted;
            $amassignedvendorsnumbers[$key]['rejected'] = $rejected;
            $amassignedvendorsnumbers[$key]['vendor_revenue'] = $vendor_revenue;
        }
        return response()->success(compact('amassignedvendorsnumbers'));
    }

    public function postVendorcustomrevenue()
    {
        $joborderId = Input::get('joborderId');
        $vendorId = Input::get('vendorId');
        $revenue = Input::get('newRevenue');
        $vendorrevenue = VendorRevenue::where('job_id', $joborderId)
            ->where('vendor_id', $vendorId)
            ->first();
        if (!is_numeric($revenue)) {
            $vendorcustomrevenue = array('revenue' => 'The revenue must be numeric');
            return response()->error($vendorcustomrevenue);
        }
        if ($revenue > $vendorrevenue->est_revenue_1) {
            $vendorcustomrevenue = array('revenue' => 'The revenue must be less than the Slot 1 revenue');
            return response()->error($vendorcustomrevenue);
        }
        $finalRevenue = [
            'final_revenue' => $revenue
        ];
        $vendorcustomrevenue = VendorRevenue::where('job_id', $joborderId)
            ->where('vendor_id', $vendorId)
            ->update($finalRevenue);
        return response()->success(compact('vendorcustomrevenue'));
    }

    public function getJobsrejectedbyam($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $jobsrejectedbyam = Association::where('accountmanager_id', $authuser->id)->where('created_at', '>=', $diff_date)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')->with('job_status')
            ->with('employer')->with('employer.company')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 2);
            })->get();
        foreach ($jobsrejectedbyam as $job) {
            /*$note=Activity::where('job_id',intval($job['job_id']))->where('job_status',2)
                                        ->get(['note']);*/
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            $commentData = Activity::where('job_id', $job['job_id'])
                ->where('admin_id', 1)
                ->where('accountmanager_id', $authuser->id)
                ->where('employer_id', JobOrders::where('id', intval($job['job_id']))->first()->user_id)
                ->where('activity_by', $authuser->id)
                ->where('is_vendor_sourcing_activity', 0)
                ->whereNotNull('comment')
                ->whereNotNull('name')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('vendor_user_id')
                ->whereNull('job_status')
                ->whereNull('candidate_id')
                ->whereNull('candidate_status')
                ->whereNull('note')
                ->whereNull('reason_id')
                ->whereNull('status_id')
                ->whereNull('resume_id')
                ->whereNull('requirement_id')
                ->whereNull('company_id')
                ->whereNull('vendor_checklist_id')
                ->first()->comment;
            $note_data = ['note' => $commentData];
            $job['note'] = $note_data;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
            $job['numbers'] = $numbers;
            if (count($vendorAcceptedAt)) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
        }
        return response()->success(compact('jobsrejectedbyam'));
    }

    public function getJobsrejectedbyamall()
    {
        $authuser = Auth::user();
        $jobsrejectedbyamall = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')->with('job_status')
            ->with('employer')->with('employer.company')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 2);
            })->get();
        foreach ($jobsrejectedbyamall as $job) {
            /*$note=Activity::where('job_id',intval($job['job_id']))->where('job_status',2)
                                        ->get(['note']);*/
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            $commentData = Activity::where('job_id', $job['job_id'])
                ->where('admin_id', 1)
                ->where('accountmanager_id', $authuser->id)
                ->where('employer_id', JobOrders::where('id', intval($job['job_id']))->first()->user_id)
                ->where('activity_by', $authuser->id)
                ->where('is_vendor_sourcing_activity', 0)
                ->whereNotNull('comment')
                ->whereNotNull('name')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('vendor_user_id')
                ->whereNull('job_status')
                ->whereNull('candidate_id')
                ->whereNull('candidate_status')
                ->whereNull('note')
                ->whereNull('reason_id')
                ->whereNull('status_id')
                ->whereNull('resume_id')
                ->whereNull('requirement_id')
                ->whereNull('company_id')
                ->whereNull('vendor_checklist_id')
                ->first();
            $note_data = ['note' => $commentData];
            $job['note'] = $note_data;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['job_id'])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $numbers = ['encrypted_jobId' => $encrypted, 'profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles];
            $job['numbers'] = $numbers;
            if (($vendorAcceptedAt)) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
        }
        return response()->success(compact('jobsrejectedbyamall'));
    }

    public function getJobsrejectedbyvendor($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $jobsrejectedbyvendor = Association::where('accountmanager_id', $authuser->id)->where('created_at', '>=', $diff_date)
            ->whereNull('candidate_id')
            ->whereNotNull('job_id')
            ->with('job')->with('employer')
            ->with('employer.company')
            ->with('job.JobType', 'job.status')
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->where('job_status', 2)
            ->get();
        foreach ($jobsrejectedbyvendor as $job) {
            $receivedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $assignedTo = Association::where('accountmanager_id', $authuser->id)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 7);
                })
                ->groupBy("job_id")
                ->count();
            $rejectedBy = Association::where('accountmanager_id', $authuser->id)
                ->whereNull('candidate_id')
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->where('job_status', 2)
                ->groupBy('vendor_id')
                ->count();
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            if (count($vendorAcceptedAt)) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
        }
        return response()->success(compact('jobsrejectedbyvendor'));
    }

    public function getJobsrejectedbyvendorall()
    {
        $authuser = Auth::user();
        $jobsrejectedbyvendorall = Association::where('accountmanager_id', $authuser->id)
            ->whereNull('candidate_id')
            ->whereNotNull('job_id')
            ->with('job')
            ->with('employer')
            ->with('employer.company')
            ->with('job.JobType', 'job.status')
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->where('job_status', 2)
            ->with('employer')
            ->with('employer.company')
            ->get();
        foreach ($jobsrejectedbyvendorall as $job) {
            $receivedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $rejectedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', [1, 2, 30])
                ->count();
            $shorlistedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31))
                ->count();
            $offeredProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(27, 28))
                ->count();
            $holdProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereBetween('candidate_status', array(24, 26))
                ->count();
            $interviwedProfiles = Association::where('job_id', $job['job_id'])
                ->where('accountmanager_id', $authuser->id)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereIn('candidate_status', array(17, 18, 19, 20, 21, 22, 23, 27, 28, 30))
                ->count();
            $assignedTo = Association::where('accountmanager_id', $authuser->id)
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 7);
                })
                ->groupBy("job_id")
                ->count();
            $rejectedBy = Association::where('accountmanager_id', $authuser->id)
                ->whereNull('candidate_id')
                ->where('job_id', intval($job['job_id']))
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->where('job_status', 2)
                ->groupBy('vendor_id')
                ->count();
            $vendorAcceptedAt = Activity::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->where('admin_id', 1)
                ->whereNull('job_status')
                ->where('job_id', intval($job['job_id']))
                ->whereNull('vendor_id')
                ->where('activity_by', $authuser->id)
                ->whereNull('status_id')
                ->where('is_vendor_sourcing_activity', 0)
                ->first();
            if (($vendorAcceptedAt)) {
                $job['job_accept_time'] = $vendorAcceptedAt['created_at'];
            } else {
                $job['job_accept_time'] = 0;
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived' => $receivedProfiles, 'rejectedProfiles' => $rejectedProfiles, 'shortlistedProfiles' => $shorlistedProfiles, 'offeredProfiles' => $offeredProfiles, 'holdProfiles' => $holdProfiles, 'interviwedProfiles' => $interviwedProfiles, 'encrypted_jobId' => $encrypted];
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
        }
        return response()->success(compact('jobsrejectedbyvendorall'));
    }

    public function getAdminassignedvendorsnumbers($job_id)
    {
        $authuser = Auth::user();
        $adminassignedvendorsnumbers = Association::where('admin_id', $authuser->id)
            ->where('job_id', $job_id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('candidate_id')
            ->with('job_status')
            ->with('vendor.company')
            ->get();
        foreach ($adminassignedvendorsnumbers as $key => $vendor) {
            $submitted = Association::where('admin_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereNotNull('employer_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $shortlisted = Association::where('admin_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereNotIn('candidate_status', [1, 2, 19, 30, 31])
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $rejected = Association::where('admin_id', $authuser->id)
                ->where('vendor_id', $vendor->vendor_id)
                ->where('job_id', $job_id)
                ->whereIn('candidate_status', [1, 2, 30])
                ->whereNotNull('employer_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('candidate_id')
                ->distinct('candidate_id')
                ->count('candidate_id');
            $vendor_revenue = VendorRevenue::where('vendor_id', $vendor->vendor_id)->where('job_id', $job_id)->first();
            $adminassignedvendorsnumbers[$key]['submitted'] = $submitted;
            $adminassignedvendorsnumbers[$key]['shortlisted'] = $shortlisted;
            $adminassignedvendorsnumbers[$key]['rejected'] = $rejected;
            $adminassignedvendorsnumbers[$key]['vendor_revenue'] = $vendor_revenue;
        }
        return response()->success(compact('adminassignedvendorsnumbers'));
    }

    public function getAdminassignedpendingcandidates($id)
    {
        $authuser = Auth::user();
        $adminassignedpendingcandidates = Association::where('job_id', $id)->where('admin_id', $authuser->id)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate', 'Vendor'))
            ->get();
        foreach ($adminassignedpendingcandidates as $key => $value) {
           $skils_block = SkillblockResume::where('candidate_id', $value['candidate_id'])->whereNotIn('found_id', [3,2])->get();
           $value['skils_block'] = $skils_block;
           $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $value['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $value['candidate_status']);
            $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
            $value['numbers'] = $numbers;
            }
       
        return response()->success(compact('adminassignedpendingcandidates'));
    }

    public function getAdmininactivecandidates($id)
    {
        $authuser = Auth::user();
        $admininactivecandidates = Association::where('job_id', $id)->where('admin_id', $authuser->id)
            ->where('candidate_status', 19)
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate', 'Vendor'))
            ->get();
       foreach ($admininactivecandidates as $key => $value) {
           $skils_block = SkillblockResume::where('candidate_id', $value['candidate_id'])->whereNotIn('found_id', [3,2])->get();
          $value['skils_block'] = $skils_block;
          $timestamp = 129310611081;
          $randomKey = '-';
          $encrypted = base64_encode($timestamp . $randomKey . $value['candidate_id']);
          $encrypted_statusid = base64_encode($timestamp . $randomKey . $value['candidate_status']);
          $numbers = ['encrypted_canId' => $encrypted, 'encrypted_canStatus' => $encrypted_statusid];
          $value['numbers'] = $numbers;

            }
        return response()->success(compact('admininactivecandidates'));
    }

    public function getAdminrejectedcandidates($id)
    {
        $authuser = Auth::user();
        $adminrejectedcandidates = Association::where('job_id', $id)->where('admin_id', $authuser->id)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate', 'Vendor'))
            ->get();
        foreach ($adminrejectedcandidates as $key => $value) {
           $skils_block = SkillblockResume::where('candidate_id', $value['candidate_id'])->whereNotIn('found_id', [3,2])->get();
          $value['skils_block'] = $skils_block;
            }
        return response()->success(compact('adminrejectedcandidates'));
    }

    public function getAdminshortlistedcandidates($id)
    {
        $authuser = Auth::user();
        $adminshortlistedcandidates = Association::where('job_id', $id)
            ->where('admin_id', $authuser->id)
            ->whereNotIn('candidate_status', array(1, 2, 30, 6, 19))
            ->whereNotNull('candidate_status')
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->with(array('Status', 'Candidate', 'Vendor'))
            ->get();
        return response()->success(compact('adminshortlistedcandidates'));
    }

    public function postHoldjob()
    {
        $authuser = Auth::user();
        $authId = null;
        $employerParent = $authuser;
        if ($authuser->parent_id) {
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $joborderId = Input::get('id');
        $jobstatusId = Input::get('statusId');
        $decryption = base64_decode($joborderId);
        $joborderId = $decryption;
        $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
        $accountmanager_id = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->where('job_id', intval($joborderId))
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;
        $joborderData = ['status' => 24, 'prev_status' => $jobstatusId];
        //print_r($joborderData);
        $holdjob = JobOrders::where('id', $joborderId)
            ->where('user_id', $authId)
            ->whereNotNull('status')
            //->whereNotNull('prev_status')
            ->update($joborderData);
        //print_r($holdjob);exit;
        $candidateactivity = new Activity();
        $candidateactivity->name = "Employer held a job";
        $candidateactivity->note = '';
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->admin_id = 1;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->job_status = 24;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Employer held a job";
            $candidateactivity->accountmanager_id = $accountmanager_id;
            $candidateactivity->note = '';
            $candidateactivity->admin_id = 1;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->job_status = 24;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        //Get all the required info to send sms & email.
        $association_info = Association::where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('candidate')
            ->with('job')
            ->first();
        $association_vendor_info = Association::where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->groupBy('vendor_id')
            ->with('vendor')
            ->with('job')
            ->get();
        //Get the enabled country
        $country = Country::where('is_enabled', 1)->first();
        //Foreach to send emails and
        foreach ($association_vendor_info as $vendor) {
            //TODO Send Email to vendor stating that job is closed.
            /* Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $association_info->job->job_internal_code, 'jobTitle' => $association_info->job->name], function ($m) use($vendor) {
                 $m->to($vendor->vendor->email, 'Held a job')->subject('Held a job');
             });*/
            $number = $vendor->vendor->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The Job role " . $association_info->job->name . " has been held by " . $employerParent->first_name;
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } // foreach close
        //TODO Send Email to Am stating that job is closed.
        /* Mail::send('emails.notifyClosedJob',['jobInternalCode'=>$association_info->job->job_internal_code, 'jobTitle'=>$association_info->job->name],function ($m) use($association_info) {
            $m->to($association_info->accountmanager->email, 'Held a job')->subject('Held a job');
         });
        */
        $number = $association_info->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info->job->name . " has been held by " . $employerParent->first_name;
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Employer stating that profile is duplicate.
        /*Mail::send('emails.notifyClosedJob',['jobInternalCode'=>$association_info->job->job_internal_code, 'jobTitle'=>$association_info->job->name],function ($m) use($employerParent) {
             $m->to($employerParent->email, 'Held a job')->subject('Held a job');
         })*/;
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info->job->name . " has been held by you.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('holdjob'));
    }

    public function postResumejob()
    {
        $jdstatusId = Input::get('statId');
        // echo "<pre>"; print_r($jdstatusId); exit;
        if ($jdstatusId == '8') {
            $authuser = Auth::user();
            $authId = null;
            $employerParent = $authuser;
            if ($authuser->parent_id) {
                $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
                $authId = $authuser->parent_id;
            } else {
                $authId = $authuser->id;
            }
            $joborderId = Input::get('id');
            $decryption = base64_decode($joborderId);
            $joborderId = $decryption;
            $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
            $joborderData = [
                'status' => 8
            ];
        } elseif ($jdstatusId == '4') {
            $authuser = Auth::user();
            $authId = null;
            $employerParent = $authuser;
            if ($authuser->parent_id) {
                $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
                $authId = $authuser->parent_id;
            } else {
                $authId = $authuser->id;
            }
            $joborderId = Input::get('id');
            $decryption = base64_decode($joborderId);
            $joborderId = $decryption;
            $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
            $joborderData = [
                'status' => 4
            ];
        }
        $resumejob = JobOrders::where('id', $joborderId)
            ->where('user_id', $authId)
            ->whereNotNull('status')
            ->update($joborderData);
        $candidateactivity = new Activity();
        $candidateactivity->name = "Employer resumed a job";
        $candidateactivity->note = '';
        $candidateactivity->admin_id = 1;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->job_status = 3;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();
        if ($authuser->parent_id) {
            $candidateactivity = new Activity();
            $candidateactivity->name = "Employer resumed a job";
            $candidateactivity->note = '';
            $candidateactivity->admin_id = 1;
            $candidateactivity->employer_id = $authId;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->job_status = 3;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        //Get all the required info to send sms & email.
        $association_info = Association::where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('accountmanager')
            ->with('candidate')
            ->with('job')
            ->first();
        $association_vendor_info = Association::where('job_id', $joborderId)
            ->whereNull('candidate_id')
            ->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->groupBy('vendor_id')
            ->with('vendor')
            ->with('job')
            ->get();
        //Get the enabled country
        $country = Country::where('is_enabled', 1)->first();
        //Foreach to send emails and
        foreach ($association_vendor_info as $vendor) {
            //TODO Send Email to vendor stating that job is closed.
            /*Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $association_info->job->job_internal_code, 'jobTitle' => $association_info->job->name], function ($m) use($vendor) {
                 $m->to($vendor->vendor->email, 'Resumed a job')->subject('Resumed a job');
             })*/;
            $number = $vendor->vendor->mobile;
            $city = \App\City::where('id', $authuser->city_id)->get();
            if (count($city) > 0) {
                $country = Country::where('id', $city[0]->country_id)->get();
                $countryCode = $country[0]->ISD_code;
            } else {
                $countryCode = 91;
            }
            $ch = curl_init();
            $user = "kv@hirextra.com";
            $password = "Kumar786%";
            $receipientno = $countryCode . $number;
            $originator = "HireXtra";
            $msgtxt = "The Job role " . $association_info->job->name . " has been resumed by " . $employerParent->first_name . ". Please check your dashboard for more details.";
            curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } // foreach close
        //TODO Send Email to Am stating that job is closed.
        /*  Mail::send('emails.notifyClosedJob',['jobInternalCode'=>$association_info->job->job_internal_code, 'jobTitle'=>$association_info->job->name],function ($m) use($association_info) {
            $m->to($association_info->accountmanager->email, 'Resumed a job')->subject('Resumed a job');
         });
        */
        $number = $association_info->accountmanager->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info->job->name . " has been resumed by " . $employerParent->first_name . ". Please check your dashboard for more details.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyClosedJob', ['userName' => $association_info['employer']['first_name'], 'jobInternalCode' => $association_info->job->job_internal_code, 'jobTitle' => $association_info->job->name], function ($m) use ($employerParent) {
            $m->to($employerParent->email, 'Resumed a job')->subject('Resumed a job');
        });
        $number = $employerParent->mobile;
        $city = \App\City::where('id', $authuser->city_id)->get();
        if (count($city) > 0) {
            $country = Country::where('id', $city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;
        } else {
            $countryCode = 91;
        }
        $ch = curl_init();
        $user = "kv@hirextra.com";
        $password = "Kumar786%";
        $receipientno = $countryCode . $number;
        $originator = "HireXtra";
        $msgtxt = "The Job role " . $association_info->job->name . "  has been resumed by you. Please check your dashboard for more details.";
        curl_setopt($ch, CURLOPT_URL, "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('resumejob'));
    }

    public function postVendorjobrevenue()
    {
        $joborderId = Input::get('jobOrderId');
        $revenue = Input::get('newRevenue');
        $customtimes = Input::get('addtimes');
        if (!is_numeric($revenue)) {
            $vendorcustomrevenue = array('revenue' => 'The revenue must be numeric');
            return response()->error($vendorcustomrevenue);
        }
        $updateRevenue = ['final_revenue' => $revenue, 'customtimes' => $customtimes];
        $vendorjobrevenue = VendorRevenue::where("job_id", $joborderId)
            ->where('default_revenue', 0)
            ->whereNull('vendor_id')
            ->whereNotNull('est_revenue_1')
            ->whereNotNull('est_revenue_2')
            ->whereNotNull('est_revenue_3')
            ->whereNotNull('est_revenue_4')
            ->whereNotNull('est_revenue_5')
            ->update($updateRevenue);
        return response()->success(compact('vendorjobrevenue'));
    }

    public function getVendorjobsnumber()
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $date_data->sub(new DateInterval('P7D'));
        $diff_date = $date_data->format('Y-m-d');
        $b = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $vendorRejected = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 2)
                ->with('job.JobType')
                ->with('job_status')
                ->with('job.status')
                ->count();
            $vendorPending = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 4)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->count();
            $vendorassignedjobs = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->count();
            $vendorclosed = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $holdjobs = Association::whereIn('job_id', $b)
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->count();
        } else {
            $authId = $authuser->id;
            $jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->whereNotNull('job_id')->where('created_at', '>=', $diff_date)
                ->with('employer')
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->groupBy('job_id')
                ->get();
            foreach ($jobs as $job) {
                array_push($b, $job->job_id);
            }
            $vendorRejected = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')->where('created_at', '>=', $diff_date)
                ->where('job_status', 2)
                ->with('job.JobType')
                ->with('job_status')
                ->with('job.status')
                ->count();
            $vendorPending = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')->where('created_at', '>=', $diff_date)
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 4)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->count();
            $vendorassignedjobs = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')->where('created_at', '>=', $diff_date)
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->count();
            $vendorassignedjobslast30days = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->count();
            $vendorclosed = Association::where('vendor_id', $authId)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')->where('created_at', '>=', $diff_date)
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $holdjobs = Association::whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')->where('created_at', '>=', $diff_date)
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->count();
        }//else
        $vendorjobsnumber[0]['numbers'] = array('Assignedjobs' => $vendorassignedjobs, 'Assignedjobs30days' => $vendorassignedjobslast30days, 'Rejected' => $vendorRejected, 'Pending' => $vendorPending, 'closed' => $vendorclosed, 'holdjobs' => $holdjobs);
        return response()->success(compact('vendorjobsnumber'));
    } //getVendorjobsnumber

    public function getJobscountnumbers()
    {
        $authuser = Auth::user();
        $alljobs = Cache::remember('getJobscountnumbers_alljobs', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '!=', 7);
                })
                ->count();
        });
        $pendingjobs = Cache::remember('getJobscountnumbers_pendingjobs', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('employer_id')
                ->whereNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->with('job_closed.status')
                ->with('job_closed.JobType')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 4);
                })
                ->count();
        });
        $yet_to_accept = Cache::remember('getJobscountnumbers_yet_to_accept', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 3);
                })
                ->count();
        });
        $in_progress = Cache::remember('getJobscountnumbers_in_progress', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->count();
        });
        $closedJobs = Cache::remember('getJobscountnumbers_closedJobs', 60, function () use ($authuser) {
            return Association::whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
        });
        $rejected_by_am = Cache::remember('getJobscountnumbers_rejected_by_am', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 2);
                })
                ->count();
        });
        $rejected_by_vendor = Cache::remember('getJobscountnumbers_rejected_by_vendor', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNull('candidate_id')
                ->whereNotNull('job_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('employer_id')
                ->where('job_status', 2)
                ->count();
        });
        $amholdjobs = Cache::remember('getJobscountnumbers_amholdjobs', 60, function () use ($authuser) {
            return Association::where('accountmanager_id', $authuser->id)
                ->whereNotNull('job_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNull('candidate_id')
                ->with('job.JobType', 'job.status')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 24);
                })
                ->count();
        });
        $jobscountnumbers[0]['numbers'] = array('alljobs' => $alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor,
            'amholdjobs' => $amholdjobs);
        return response()->success(compact('jobscountnumbers'));
    } //Jobscountnumbers

    public function getEmployerjobsnumbers()
    {
        $authuser = Auth::user();
        $authId = null;
        if ($authuser->parent_id) {
            $empIds = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $empActIds = array();
            foreach ($empIds as $job) {
                array_push($empActIds, $job);
            }
            $alljobs = JobOrders::whereIn('id', $empActIds)->with('status')->with('JobType')->with('Industry')->count();
            $inactivejobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 7)->count();
            $acceptedjobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 3)->count();
            $pendingjobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 4)->count();
            $inprogressjobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 8)->count();
            $closedjobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 6)->count();
            $holdjobs = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)->where('user_id', $authuser->parent_id)->where('status', 24)->count();
            $rejected_by_am = JobOrders::whereIn('id', $empActIds)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 2);
                })
                ->count();
        } else {
            $alljobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->with('status')->with('JobType')->with('Industry')->count();
            $inactivejobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 7)->count();
            $acceptedjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 3)->count();
            $pendingjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 4)->count();
            $inprogressjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('is_talentpool', 0)->where('status', 8)->count();
            $closedjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 6)->count();
            $holdjobs = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)->where('status', 24)->count();
            $rejected_by_am = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->with('status')
                ->with('JobType')
                ->with('Industry')
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 2);
                })
                ->count();
        }
        $employerjobsnumbers[0]['numbers'] = array('alljobs' => $alljobs, 'inprogressjobs' => $inprogressjobs, 'inactive' => $inactivejobs, 'acceptedjobs' => $acceptedjobs, 'pendingjobs' => $pendingjobs, 'closedjobs' => $closedjobs, 'rejected_by_am' => $rejected_by_am, 'holdjobs' => $holdjobs);
        return response()->success(compact('employerjobsnumbers'));
    } //Employerjobsnumbers

    public function getAdminjobscountnumbers()
    {
        $authuser = Auth::user();
        $authId = null;
        $alljobs = Association::whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->count();
        $pendingjobs = Association::where('admin_id', 1)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_closed.JobType')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })->with('job_closed.status')
            ->count();
        $yet_to_accept = Association::where('admin_id', 1)
            ->whereNotNull('job_id')
            ->where('job_status', 4)
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })->with('job_status')
            ->count();
        $in_progress = Association::whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 8);
            })
            ->count();
        $closedjobs = Association::whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 6);
            })
            ->count();
        $holdjobs = Association::whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 24);
            })
            ->count();
        $adminjobscountnumbers[0]['numbers'] = array('alljobs' => $alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedjobs' => $closedjobs, 'holdjobs' => $holdjobs);
        return response()->success(compact('adminjobscountnumbers'));
    } //adminjobscountnumbers

    public function getEmpmetricsno()
    {
        $authuser = Auth::user();
        $authId = null;
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::select('job_id')->where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::select('id')->where('user_id', $authId)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)->where('user_id', $authId)->where('is_talentpool', 0)->count();
        }
        $amId = Association::select('accountmanager_id')->where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::select('candidate_id')->where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $jobspending = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 4)
                ->count();
            $jobsinprogress = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 8)
                ->count();
            $jobsinactive = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 7)
                ->count();
            $jobsaccepted = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 3)
                ->count();
            $jobsclosed = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 6)
                ->count();
            /*$profiles_received=Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                     ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                            })
                                    ->count();*/
            $profiles_received = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                /*->whereNotIn('candidate_status',[2,1,19])*/
                ->whereIn('candidate_status', [2, 1, 17, 18, 20, 21, 22, 23, 27, 28, 30, 31])
                ->whereNotNull('candidate_id')
                ->with('candidate')
                ->with('status')
                ->with('job')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_rejected = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_phone = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_f2f = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_final = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_interview = Association::whereIn('job_id', $empjobs)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotIn('candidate_status', [19, 7, 2, 1])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_directinterview = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_skype = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_walkin = Association::whereIn('job_id', $empjobs)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_selected = Association::whereIn('job_id', $empjobs)
                ->whereIn('candidate_status', [27, 28])
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('job_id')
                ->count();
        } else {
            $jobspending = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 4)
                ->count();
            $jobsinprogress = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 8)
                ->count();
            $jobsinactive = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 7)
                ->count();
            $jobsaccepted = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 3)
                ->count();
            $jobsclosed = JobOrders::where('user_id', $authuser->id)->where('is_talentpool', 0)
                ->where('status', 6)
                ->count();
            /*$profiles_received=Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                    ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                            })
                                    ->count();*/
            $profiles_received = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereIn('candidate_status', [2, 1, 17, 18, 20, 21, 22, 23, 27, 28, 30, 31])
                /*->whereNotIn('candidate_status',[2,1,19])*/
                ->whereNotNull('candidate_id')
                ->with('candidate')
                ->with('status')
                ->with('job')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_rejected = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_phone = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_f2f = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_final = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_interview = Association::whereIn('job_id', $empjobids)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotIn('candidate_status', [19, 7, 2, 1])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_directinterview = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_skype = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_walkin = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_selected = Association::whereIn('job_id', $empjobids)
                ->whereNotIn('candidate_id', $activityData)
                ->whereIn('candidate_status', [27, 28])
                ->where('employer_id', $authId)
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('job_id')
                ->count();
        }
        $jobsrejected = JobOrders::where('user_id', $authId)->where('is_talentpool', 0)
            ->where('status', 2)
            ->with('status')
            ->with('JobType')
            ->with('Industry')
            ->count();
        $vendorassignedholdjobs = JobOrders::where('user_id', $authId)->where('is_talentpool', 0)
            ->where('status', 24)
            ->count();
        $empmetricsno[] = array('jobs_submitted' => count($empjobs), 'inprogress_jobs' => $jobsinprogress, 'inactive_jobs' => $jobsinactive, 'pending_jobs' => $jobspending, 'accepted_jobs' => $jobsaccepted, 'rejected_jobs' => $jobsrejected, 'closed_jobs' => $jobsclosed, 'jobs_held' => $vendorassignedholdjobs, 'profiles_interview' => $profiles_interview, 'profiles_rejected' => $profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_received' => $profiles_received, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected);
        return response()->success(compact('empmetricsno'));
        // print_r(count($empjobs));
    }

    public function getEmpmetrics($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::select('id')->where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            //$jobsclosed=JobOrders::whereIn('id',$empjobs)->where('is_talentpool',0)->where('created_at','>=',$diff_date)->where('status',6)->where('user_id',$authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::select('id')->where('user_id', $authId)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            //$jobsclosed=JobOrders::where('status',6)->where('is_talentpool',0)->where('created_at','>=',$diff_date)->where('user_id',$authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $jobspending = JobOrders::whereIn('id', $empjobs)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 4)
                ->count();
            $jobsinprogress = JobOrders::whereIn('id', $empjobs)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 8)
                ->count();
            $jobsinactive = JobOrders::whereIn('id', $empjobs)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 7)
                ->count();
            $jobsaccepted = JobOrders::whereIn('id', $empjobs)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 3)
                ->count();
            $jobsclosed = JobOrders::whereIn('id', $empjobs)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('user_id', $authuser->parent_id)
                ->where('status', 6)
                ->count();
            $profiles_received = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                /*->with('job.status')*/
                ->whereHas('job', function ($query) {
                    $query->where('status', '=', 3);
                })
                ->count();
            $employereceivedprofiles = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->where('employer_id', $authId)
                ->whereNotIn('candidate_status', [2, 1, 19])
                ->whereNotNull('candidate_id')
                /*->with('candidate')
                                    ->with('status')
                                    ->with('job')*/
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_rejected = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_phone = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_f2f = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_final = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_interview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotIn('candidate_status', [19, 7, 2, 1])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_directinterview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_skype = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_walkin = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_selected = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereIn('candidate_status', [27, 28])
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('job_id')
                ->count();
        } else {
            $jobspending = JobOrders::where('user_id', $authuser->id)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 4)
                ->count();
            $jobsinprogress = JobOrders::where('user_id', $authuser->id)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 8)
                ->count();
            $jobsinactive = JobOrders::where('user_id', $authuser->id)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 7)
                ->count();
            $jobsaccepted = JobOrders::where('user_id', $authuser->id)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 3)
                ->count();
            $jobsclosed = JobOrders::where('user_id', $authuser->id)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
                ->where('status', 6)
                ->count();
            $profiles_received = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->with('job.status')
                ->whereIn('candidate_status', [2, 1, 17, 18, 20, 21, 22, 23, 27, 28, 30, 31])
                /*->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                            })*/
                ->count();
            $profiles_rejected = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_phone = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_f2f = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_srt_final = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_interview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereNotIn('candidate_status', [19, 7, 2, 1])
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_directinterview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_skype = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_walkin = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->count();
            $profiles_selected = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereIn('candidate_status', [27, 28])
                ->where('employer_id', $authId)
                ->whereNull('employer_user_id')
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('job_id')
                ->count();
        }
        $jobsrejected = JobOrders::where('user_id', $authId)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
            ->where('status', 2)
            ->with('status')
            ->with('JobType')
            ->with('Industry')
            ->count();
        $vendorassignedholdjobs = JobOrders::where('user_id', $authId)->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)
            ->where('status', 24)
            ->count();
		
			$selected_candidates=Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNull('employer_user_id')
							->whereNotNull('candidate_id')
							->whereNotNull('vendor_id')
							->whereNotNull('accountmanager_id')
							->whereNotNull('job_id')
                            ->where('candidate_status',44)
                            ->count(); 
		$onboarded_closer = Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNull('employer_user_id')
							->whereNotNull('candidate_id')
							->whereNotNull('vendor_id')
							->whereNotNull('accountmanager_id')
							->whereNotNull('job_id')
							->where('candidate_status',45)
                            ->count(); 
		$invoices = Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNull('employer_user_id')
							->whereNotNull('candidate_id')
							->whereNotNull('vendor_id')
							->whereNotNull('accountmanager_id')
							->whereNotNull('job_id')
							->where('candidate_status',46)
                            ->count(); 
	
        $empmetrics[] = array('jobs_submitted' => count($empjobs), 'inprogress_jobs' => $jobsinprogress, 'inactive_jobs' => $jobsinactive, 'pending_jobs' => $jobspending, 'accepted_jobs' => $jobsaccepted, 'rejected_jobs' => $jobsrejected, 'closed_jobs' => $jobsclosed, 'jobs_held' => $vendorassignedholdjobs, 'profiles_interview' => $profiles_interview, 'profiles_rejected' => $profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_received' => $profiles_received, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected, 'selected_candidates' => $selected_candidates, 'onboarded_closer'=>$onboarded_closer,'invoices'=>$invoices);
        return response()->success(compact('empmetrics'));
    }

    public function getEmployereceivedprofiles($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            /*$jobsclosed=JobOrders::whereIn('id',$empjobs)->where('is_talentpool',0)->where('status',6)->where('user_id',$authId)->count();*/
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            /*$jobsclosed=JobOrders::where('status',6)->where('is_talentpool',0)->where('user_id',$authId)->count();*/
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
          
            $employereceivedprofiles = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authuser->parent_id)
                /*->whereNotIn('candidate_status',[2,1,19])*/
                ->whereIn('candidate_status', [2, 1, 17, 18, 20, 21, 22, 23, 26, 27, 28, 30, 31])
                ->whereNotNull('candidate_id')
                ->with('candidate')
                ->with('status')
                ->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {           
            $employereceivedprofiles = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                /*->whereNotIn('candidate_status',[2,1,19])*/
                ->whereIn('candidate_status', [2, 1, 17, 18, 20, 21, 22, 23, 26, 27, 28, 30, 31])
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employereceivedprofiles as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                //$job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", mb_strlen($job['candidate']['full_name'])), 2, mb_strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", mb_strlen($job['candidate']['total_experience_in_year'])), 0, mb_strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", mb_strlen($note_name[1])), 2, mb_strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);              
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", mb_strlen($notename[0][0])), 0, mb_strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }           

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }        
        return response()->success(compact('employereceivedprofiles'));
    }

    public function getEmployerrejectedprofiles($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerrejectedprofiles = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerrejectedprofiles = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->whereIn('candidate_status', [2, 1, 30])
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerrejectedprofiles as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerrejectedprofiles'));
    }

    public function getEmployerprofilessrtphone($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilessrtphone = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilessrtphone = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 17)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilessrtphone as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilessrtphone'));
    }

    public function getEmployerprofilesforinterview($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)->where('is_talentpool', 0)
                ->where('created_at', '>=', $diff_date)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)->where('created_at', '>=', $diff_date)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)->where('is_talentpool', 0)->where('created_at', '>=', $diff_date)
                ->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilesforinterview = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                /*->whereNotIn('candidate_status',[19,7,2,1])*/
                ->whereIn('candidate_status', [27, 28])
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilesforinterview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                /*->whereNotIn('candidate_status',[19,7,2,1])*/
                ->whereIn('candidate_status', [27, 28])
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilesforinterview as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0);
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilesforinterview'));
    }

    public function getEmployerprofilessrtfinal($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilessrtfinal = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilessrtfinal = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 20)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilessrtfinal as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilessrtfinal'));
    }

    public function getEmployerprofilessrtf2f($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilessrtf2f = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilessrtf2f = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 18)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilessrtf2f as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilessrtf2f'));
    }

    public function getEmployerprofilesdirectinterview($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilesdirectinterview = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilesdirectinterview = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 23)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilesdirectinterview as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilesdirectinterview'));
    }

    public function getEmployerprofilesskype($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofilesskype = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofilesskype = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 22)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofilesskype as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofilesskype'));
    }

    public function getEmployerprofileswalkin($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerprofileswalkin = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerprofileswalkin = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 21)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerprofileswalkin as $job) {
            $jobInfo = DB::table('job_orders')->where('id', $job['job_id'])->get();
            if($jobInfo[0]->blindhire==1 || $job['candidate']['mask']==1) {
                $full_name = $job['candidate']['first_name'];
                $job['candidate']['full_name'] = substr_replace($job['candidate']['full_name'], str_repeat("X", strlen($job['candidate']['full_name'])), 2, strlen($job['candidate']['full_name'])-4);
                $job['candidate']['total_experience_in_year'] = substr_replace($job['candidate']['total_experience_in_year'], str_repeat("X", strlen($job['candidate']['total_experience_in_year'])), 0, strlen($job['candidate']['total_experience_in_year']));
                $note_name[1] = $full_name;
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $job['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $job['candidate']['executive_summary']);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $job['candidate']['executive_summary'], $notename);
                if(!empty($notename[0][0])){
                    $note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                    $job['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $job['candidate']['executive_summary']);
                }
            }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerprofileswalkin'));
    }

    public function getAmmetrics($count)

    {
            
        $authuser = Auth::user();

        $date_data =new DateTime();

        $count_value = "P".$count."D";

        $date_data->sub(new DateInterval($count_value));

        $diff_date = $date_data->format('Y-m-d');

        $associated_emp_Ids = array();

        $associated_emps = Association::where('accountmanager_id',$authuser->id)

                            ->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->with('employer')

                            ->groupBy('employer_id')

                            ->whereHas('job',function($query){

                                $query->where('status','=',6);

                            })

                            ->select('employer_id')

                            ->get();



        foreach($associated_emps as $job) {array_push($associated_emp_Ids, $job->employer_id);}

        $alljobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',7);

                            })

                            ->count();

        $pendingjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('employer_user_id')

                            ->whereNotNull('job_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job_closed',function($query){

                                $query->where('status','=',4);

                            })

                             ->count();

        /*$yet_to_accept = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query){

                                $query->where('status','=',3);

                            })

                            ->count(); */

       /* $yet_to_accept = Association::where('accountmanager_id',$authuser->id)

                            ->where('created_at','>=',$diff_date)

                            ->whereHas('job_closed',function($query){

                                $query->where('status','=',3);

                            })

                            ->groupby('job_id')

                            ->havingRaw('count(vendor_id) < 1')

                            ->count();*/

        $yet_to_accept = Association::where('accountmanager_id',$authuser->id)

                            ->whereNotNull('job_id')

                            ->where('created_at','>=',$diff_date)

                            ->with('employer')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query){

                                $query->where('status','=',3);

                            })

                            ->count();

        $assignedprogressjobs_dummy =  Association::select('job_id')->where('accountmanager_id',$authuser->id)

                            ->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->with('employer')

                            ->with('employer.company')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->with('job.JobType','job.status')

                            ->whereHas('job',function($query){

                                $query->where('status','=',8);

                            })

                            ->get();



        foreach ($assignedprogressjobs_dummy as $job){

            $jobId[] = $job->job_id;

        }

        

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {

        $assignedToRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)

                            ->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNull('candidate_id')

                            ->whereNotNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('vendor_user_id')

                           // ->whereIn('job_id',$jobId)

                            ->with('job.JobType','job.status')

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',7);

                            })

                            ->select('job_id', DB::raw('count(id) AS assignedTo'))

                            ->groupBy("job_id")

                            ->get();

        //});



        foreach ($assignedToRaw as $stats){   

            $assignedToStats[$stats->job_id] = $stats->assignedTo;   

        }



        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {

        $rejectedByRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)

                            ->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNull('candidate_id')

                            //->whereIn('job_id',$jobId)

                            ->where('job_status',2)

                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))

                            ->groupBy('job_id')

                            ->groupBy('vendor_id')

                            ->get();

        //});



        foreach ($rejectedByRaw as $stats){   

            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;   

        }



        $i = 0;

        reset($assignedprogressjobs_dummy);

        foreach ($assignedprogressjobs_dummy as $key => $job) {

            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;

            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;



            

            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;

            



            if($assignedTo == $rejectedBy){

                $i--;

                $assignedprogressjobs_dummy->forget($key);

            }

            $i++;

        }

        //$assignedprogressjobsall = $assignedprogressjobs_dummy->values(); 

        //print_r($assignedprogressjobs_dummy->values()); die;

        //echo $i; die;

        $in_progress = $i;



        /*$in_progress = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query){

                                $query->where('status','=',8);

                            })

                            ->count();*/ 

        $closedJobs = Association::where('accountmanager_id',$authuser->id)

                            //->whereIn('employer_id', $associated_emp_Ids)

                            ->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->with('employer')

                            ->whereHas('job',function($query){

                                $query->where('status','=',6);

                            })

                            ->count();

        $rejected_by_am = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query) {

                                $query->where('status','=',2);

                            })

                            ->count();

        $rejected_by_vendor = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNull('candidate_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('employer_id')

                            ->where('job_status',2)

                            ->count();



        $amholdjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('job_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            ->whereHas('job',function($query){

                                $query->where('status','=',24);

                            })

                            ->count();  



$profiles_gdpr=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })
                            ->count();
       
        $profiles_gdpr_yes=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            //->where('gdpr_status',1)
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })
							->whereHas('job', function ($query) use ($diff_date) {
								$query->where('created_at', '>=', $diff_date);
							})
                            ->count();
        // print_r($profiles_gdpr_yes);exit;
        $profiles = $profiles_gdpr + $profiles_gdpr_yes;
        
        $pending_profiles=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',19)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })

                            ->groupby('job_id')

                            ->get();

        $profiles_rejected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')
							//->where('gdpr_status',1)

                            ->whereIn('candidate_status',array(1,2,30))

                            ->with('job')

                            ->whereHas('job',function($query) {

                                $query->where('status', "!=", 6);

                            })
							->whereHas('job', function ($query) use ($diff_date) {
								$query->where('created_at', '>=', $diff_date);
							})
							//->groupby('job_id')

                            ->get(); 
		
        $profiles_srt_phone=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',17)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get(); 

        $profiles_srt_f2f=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',18)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get(); 

        $profiles_srt_final=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',20)

                            // ->with('job')

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get();

        $profiles_interview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->whereNotIn('candidate_status',[19,7,2,1,30])

                            // ->with('job')

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get();

        $profiles_directinterview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',23)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get(); 

        $profiles_skype=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',22)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get(); 



        $profiles_walkin=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->where('candidate_status',21)

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->get();



        $profiles_selected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)

                            ->whereNotNull('employer_id')

                            ->whereNotNull('vendor_id')

                            ->whereNotNull('job_id')

                            ->whereNotNull('candidate_id')->where('gdpr_status',1)

                            ->whereIn('candidate_status',[27,28])

                            /*->with('job')*/

                            ->whereHas('job',function($query) {

                                $query->where('status','!=',6);

                            })->groupby('job_id')

                            ->count();                            

		$selected_candidates=Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
							->where('gdpr_status',1)
                            ->where('candidate_status',44)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count(); 
		$onboarded_closer = Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
							->where('gdpr_status',1)
                            ->where('candidate_status',45)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count(); 
		$invoices = Association::where('accountmanager_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
							->where('gdpr_status',1)
                            ->where('candidate_status',46)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count(); 

        $ammetrics[]=array('jobs_submitted'=>$alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor, 'amholdjobs' => $amholdjobs, 'profiles_received'=>$profiles,'profiles_pending'=>count($pending_profiles), 'profiles_rejected'=>$profiles_rejected , 'profiles_srt_phone'=>$profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected,'profiles_interview'=>$profiles_interview, 'selected_candidates' => $selected_candidates, 'onboarded_closer'=>$onboarded_closer,'invoices'=>$invoices);

        return response()->success(compact('ammetrics'));                            

    }

    public function getAmmetricsall()
    {
        $authuser = Auth::user();
        $associated_emp_Ids = array();
        $associated_emps = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->groupBy('employer_id')
            ->select('employer_id')
            ->get();
        foreach ($associated_emps as $job) {
            array_push($associated_emp_Ids, $job->employer_id);
        }
        $alljobs = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->count();
        $pendingjobs = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })
            ->count();
        /*$yet_to_accept = Association::where('accountmanager_id',$authuser->id)
                            ->with('job_closed.status')
                            ->with('job_closed.JobType')
                            ->whereHas('job_closed',function($query){
                            $query->where('status','=',3);
                            })
                            ->groupby('job_id')
                            ->havingRaw('count(vendor_id) < 1')
                            ->count();*/
        $yet_to_accept = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 3);
            })
            ->count();
        $assignedprogressjobs_dummy = Association::select('job_id')
            ->where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->with('employer')
            ->with('employer.company')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 8);
            })
            ->get();
        //});
        $jobId = [];
        foreach ($assignedprogressjobs_dummy as $job) {
            $jobId[] = $job->job_id;
        }
        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw = Association::select('job_id')->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('candidate_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('vendor_user_id')
            ->whereIn('job_id', $jobId)
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 7);
            })
            ->select('job_id', DB::raw('count(id) AS assignedTo'))
            ->groupBy("job_id")
            ->get();
        //});
        foreach ($assignedToRaw as $stats) {
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }
        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw = Association::select('job_id')->where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('candidate_id')
            ->whereIn('job_id', $jobId)
            ->where('job_status', 2)
            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
            ->groupBy('job_id')
            ->groupBy('vendor_id')
            ->get();
        //});
        foreach ($rejectedByRaw as $stats) {
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }
        $i = 0;
        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']]) ? $assignedToStats[$job['job_id']] : 0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']]) ? $rejectedByStats[$job['job_id']] : 0;
            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;
            if ($assignedTo == $rejectedBy) {
                $i--;
                $assignedprogressjobs_dummy->forget($key);
            }
            $i++;
        }
        //$assignedprogressjobsall = $assignedprogressjobs_dummy->values();
        //print_r($assignedprogressjobs_dummy->values()); die;
        //echo $i; die;
        $in_progress = $i;
        $closedJobs = Association::where('accountmanager_id', $authuser->id)
            ->whereIn('employer_id', $associated_emp_Ids)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 6);
            })
            ->count();
        $rejected_by_am = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 2);
            })
            ->count();
        $rejected_by_vendor = Association::where('accountmanager_id', $authuser->id)
            ->whereNull('candidate_id')
            ->whereNotNull('job_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->where('job_status', 2)
            ->count();
        $amholdjobs = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 24);
            })
            ->count();
        $profiles_gdpr = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 0);
            })
            ->get();
        $profiles_gdpr_yes = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('gdpr_status', 1)
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 1);
            })
            ->get();
        $profileses = $profiles_gdpr->merge($profiles_gdpr_yes);
        $profiles = count($profileses);

        $pending_profiles = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 19)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })
            ->groupby('job_id')
            ->get();
        $profiles_rejected = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->whereIn('candidate_status', array(1, 2, 30))
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_phone = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 17)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_f2f = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 18)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_final = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 20)
            // ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_interview = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->whereNotIn('candidate_status', [19, 7, 2, 1])
            // ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_directinterview = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 23)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_skype = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 22)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_walkin = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->where('candidate_status', 21)
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_selected = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->where('gdpr_status', 1)
            ->whereIn('candidate_status', [27, 28])
            /*->with('job')*/
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->count();
        $ammetricsall[] = array('jobs_submitted' => $alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor, 'amholdjobs' => $amholdjobs, 'profiles_received' => $profiles, 'profiles_pending' => count($pending_profiles), 'profiles_rejected' => $profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected, 'profiles_interview' => $profiles_interview);
        return response()->success(compact('ammetricsall'));
    }

    public function getAdminammetrics($userId)
    {
        $authuser = Auth::user();
        $associated_emp_Ids = array();
        $associated_emps = Association::where('accountmanager_id', $userId)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->groupBy('employer_id')
            ->select('employer_id')
            ->get();
        foreach ($associated_emps as $job) {
            array_push($associated_emp_Ids, $job->employer_id);
        }
        $jobs_submitted = Association::where('accountmanager_id', $userId)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->count();
        $jobs_pending = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->with('job_closed.status')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 4);
            })->get();
        $jobsaccepted = Association::where('accountmanager_id', $userId)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 8);
            })->count();
        $jobsrejectedbyam = Association::where('accountmanager_id', $userId)
            ->whereNotNull('job_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNull('candidate_id')
            ->with('job.JobType', 'job.status')
            ->whereHas('job', function ($query) {
                $query->where('status', '=', 2);
            })->get();
        $jobsrejectedbyvendor = Association::where('accountmanager_id', $userId)
            ->whereNull('candidate_id')
            ->whereNotNull('job_id')->with('job')->with('job.JobType', 'job.status')
            ->whereNotNull('vendor_id')
            ->whereNotNull('employer_id')
            ->where('job_status', 2)
            ->get();
        $vendorassignedclosedjobs = Association::where('vendor_id', $userId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNull('candidate_id')
            ->where('job_status', 3)
            ->with('job.JobType')
            ->with('job_closed.status', 'job_assigned.vendorrevenues')
            ->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->get();
        $vendorassignedholdjobs = JobOrders::whereIn('user_id', $associated_emp_Ids)->where('is_talentpool', 0)
            ->where('status', 24)->count();
        $profiles = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->get();
        $pending_profiles = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 19)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })
            ->groupby('job_id')
            ->get();
        $profiles_rejected = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereIn('candidate_status', array(1, 2, 30))
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_phone = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 17)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_f2f = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 18)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_srt_final = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 20)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_interview = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereNotIn('candidate_status', [19, 7, 2, 1])
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_directinterview = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 23)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_skype = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 22)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_walkin = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->where('candidate_status', 21)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        $profiles_selected = Association::where('accountmanager_id', $userId)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereIn('candidate_status', [27, 28])
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->count();
        $adminammetrics[] = array('jobs_submitted' => $jobs_submitted, 'pending_jobs' => count($jobs_pending), 'accepted_jobs' => $jobsaccepted, 'rejected_jobs_am' => count($jobsrejectedbyam), 'rejected_jobs_vendor' => count($jobsrejectedbyvendor), 'vendor_assigned_closed_jobs' => count($vendorassignedclosedjobs), 'jobs_held' => $vendorassignedholdjobs, 'profiles_received' => $profiles, 'profiles_pending' => count($pending_profiles), 'profiles_rejected' => $profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected, 'profiles_interview' => $profiles_interview);
        return response()->success(compact('adminammetrics'));
    }

    public function getAmreceivedprofiles($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $profiles_gdpr = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
             ->where('created_at', '>=', $diff_date)
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 0);
            })->with(array('Status', 'Candidate', 'vendor','job'))
            ->get()->toArray();
        $profiles_gdpr_yes = Association::where('accountmanager_id', $authuser->id)
            ->whereNotNull('employer_id')
             ->where('created_at', '>=', $diff_date)
            ->whereNull('vendor_user_id')
            ->whereNotNull('vendor_id')
            ->whereNull('employer_user_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')
            ->whereHas('job', function ($query) {
                $query->where('gdprmandatory', '=', 1);
            })->with(array('Status', 'Candidate', 'vendor','job'))
            ->where('gdpr_status', 1)
            ->get()->toArray();
        $amreceivedprofiles = array_merge($profiles_gdpr, $profiles_gdpr_yes);
        foreach ($amreceivedprofiles as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $amprofiles1[] = $job;
        }
        $amreceivedprofiles = $amprofiles1;
        return response()->success(compact('amreceivedprofiles'));
    }

    public function getAmrejectedprofiles($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amrejectedprofiles = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->whereIn('candidate_status', array(1, 2, 30))
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->whereNotIn('status', array(6,7,1,2,30));
            })
			->whereHas('job', function ($query) use ($diff_date) {
                $query->where('created_at', '>=', $diff_date);
            })
			//->groupby('job_id')
            ->get();
        foreach ($amrejectedprofiles as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amrejectedprofiles'));
    }

    public function getAmprofilessrtphone($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilessrtphone = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 17)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilessrtphone as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilessrtphone'));
    }

    public function getAmprofilesforinterview($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilesforinterview = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->whereNotIn('candidate_status', [19, 7, 2, 1,30])
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilesforinterview as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilesforinterview'));
    }

    public function getAmprofilessrtfinal($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilessrtfinal = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 20)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilessrtfinal as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilessrtfinal'));
    }

    public function getAmprofilessrtf2f($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilessrtf2f = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 18)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilessrtf2f as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilessrtf2f'));
    }

    public function getAmprofilesdirectinterview($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilesdirectinterview = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 23)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilesdirectinterview as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilesdirectinterview'));
    }

    public function getAmprofilesskype($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofilesskype = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 22)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofilesskype as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofilesskype'));
    }

    public function getAmprofileswalkin($count)
    {
        $authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofileswalkin = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 21)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofileswalkin as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofileswalkin'));
    }

    public function getVendormetricsall()
    {
        $authuser = Auth::user();
        $jobids = array();
        if ($authuser->parent_id) {
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $amId = Association::where('vendor_id', $authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('candidate_id')->first()->accountmanager_id;
            $JobSkills = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job_closed.status')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 8);
            })->count();
            $selectedprofiles = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNotNull('candidate_id')->where('candidate_status', 27)->count();
            /*$candidates=Association::where('vendor_id',$authuser->parent_id)->where('accountmanager_id',$amId)->whereNotNull('employer_id')->whereIn('job_id',$b)->whereNotNull('candidate_id')->count();*/
            $vendorassignedjobsall = Association::select('job_id')
                ->where('vendor_id', $authuser->parent_id)
                //->where('created_at','>=',$diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
            $candidates = Association::where('vendor_id', $authuser->parent_id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('job_id')
                ->whereNotNull('candidate_id')
                ->count();
            $jobsclosed = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job_closed.status')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->count();
            $pending_jobs = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 4)->with('job.JobType')->with('job_closed.status', 'job_assigned.vendorrevenues')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 8);
            })->count();
            $jobsaccepted = Association::whereIn('job_id', $b)
                ->where('vendor_id', $authuser->parent_id)
                ->whereNull('candidate_id')
                ->whereNotNull('accountmanager_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('employer_id')
                //->whereNotNull('candidate_status')
                ->whereNull('employer_user_id')
                ->select('candidate_status')
                ->where('status_updated_by', $authuser->parent_id)
                ->where('job_status', 3)
                ->count();
            $rejected_jobs = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 2)->count();
            $closed_jobs = Association::where('vendor_id', $authuser->parent_id)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job.JobType')->with('job_closed.status', 'job_assigned.vendorrevenues')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->count();
            $vendorassignedholdjobs = JobOrders::whereIn('id', $b)->where('is_talentpool', 0)->where('status', 24)->count();
            $vendorrejectedcandidates = Association::whereIn('candidate_status', array(1, 2, 30))->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->whereNotNull('employer_id')->count();
            $profiles_srt_phone = Association::where('candidate_status', 17)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_srt_f2f = Association::where('candidate_status', 18)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_srt_final = Association::where('candidate_status', 20)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_directinterview = Association::where('candidate_status', 23)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_skype = Association::where('candidate_status', 22)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_interview = Association::whereNotIn('candidate_status', [19, 7, 2, 1])->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_walkin = Association::where('candidate_status', 21)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
        } else {
            $amId = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                /*->whereNotNull('employer_id')*/
                ->whereNull('employer_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('job_closed.status')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                //->where('created_at','>=',$diff_date)
                ->count();
            $selectedprofiles = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNotNull('candidate_id')
                //->where('created_at','>=',$diff_date)
                ->where('candidate_status', 27)
                ->count();
            $vendorassignedjobsall = Association::select('job_id')
                ->where('vendor_id', $authuser->id)
                //->where('created_at','>=',$diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
            $candidates = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNotNull('job_id')
                ->whereNotNull('candidate_id')
                ->count();
            $jobsclosed = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')//->where('created_at','>=',$diff_date)
                ->where('job_status', 3)
                ->with('job_closed.status')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $pending_jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 4)//->where('created_at','>=',$diff_date)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->count();
            $jobsaccepted = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)//->where('created_at','>=',$diff_date)
                ->where('status_updated_by', $authuser->id)
                ->count();
            $rejected_jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')//->where('created_at','>=',$diff_date)
                ->whereNull('candidate_id')
                ->where('job_status', 2)
                ->count();
            $closed_jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)//->where('created_at','>=',$diff_date)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $vendorjobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')//->where('created_at','>=',$diff_date)
                ->groupBy('job_id')
                ->get();
            foreach ($vendorjobs as $job) {
                array_push($jobids, $job->job_id);
            }
            $vendorassignedholdjobs = JobOrders::whereIn('id', $jobids)->where('is_talentpool', 0)
                ->where('status', 24)//->where('created_at','>=',$diff_date)
                ->count();
            $vendorrejectedcandidates = Association::whereIn('candidate_status', array(1, 2, 30))
                ->where('vendor_id', $authuser->id)
                ->where('accountmanager_id', $amId)
                ->whereNotNull('candidate_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_srt_phone = Association::where('candidate_status', 17)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_srt_f2f = Association::where('candidate_status', 18)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_srt_final = Association::where('candidate_status', 20)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_directinterview = Association::where('candidate_status', 23)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_skype = Association::where('candidate_status', 22)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_interview = Association::whereNotIn('candidate_status', [19, 7, 2, 1])
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
            $profiles_walkin = Association::where('candidate_status', 21)
                ->where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')//->where('created_at','>=',$diff_date)
                ->whereNotNull('candidate_id')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
        }//else
        if ($authuser->parent_id) {
            $iscUser = 1;
        } else {
            $iscUser = 0;
        }
        $vendormetricsall[] = array('profiles_received' => $candidates, 'jobsclosed' => $jobsclosed, 'profiles_selected' => $selectedprofiles, 'pending_jobs' => $pending_jobs, 'accepted_jobs' => $jobsaccepted, 'rejected_jobs' => $rejected_jobs, 'closed_jobs' => $closed_jobs, 'jobs_held' => $vendorassignedholdjobs, 'profiles_rejected' => $vendorrejectedcandidates, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_interview' => $profiles_interview, 'isVendorUser' => $iscUser);
        return response()->success(compact('vendormetricsall'));
        // print_r($jobs);
    }

    public function getVendormetrics($count)
    {
        $authuser = Auth::user();
        $jobids = array();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $a = VendorUserJob::where('vendor_id', $authuser->parent_id)
                ->where('vendor_user_id', $authuser->id)
                ->whereNotNull('job_id')
                ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach ($a as $c) {
                array_push($b, $c);
            }
            $amId = Association::where('vendor_id', $authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('candidate_id')->first()->accountmanager_id;
            $jobs = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job_closed.status')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 8);
            })->count();
            $selectedprofiles = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNotNull('candidate_id')->where('candidate_status', 27)->count();
            $candidates = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereIn('job_id', $b)->whereNotNull('candidate_id')->count();
            $jobsclosed = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job_closed.status')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->count();
            $pending_jobs = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 4)->with('job.JobType')->with('job_closed.status', 'job_assigned.vendorrevenues')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 8);
            })->count();
            $jobsaccepted = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereIn('job_id', $b)
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->count();
            $rejected_jobs = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 2)
                ->count();
            $closed_jobs = Association::where('vendor_id', $authuser->parent_id)->where('created_at', '>=', $diff_date)->where('accountmanager_id', $amId)->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id', $b)->whereNull('candidate_id')->where('job_status', 3)->with('job.JobType')->with('job_closed.status', 'job_assigned.vendorrevenues')->whereHas('job_closed', function ($query) {
                $query->where('status', '=', 6);
            })->count();
            $vendorassignedholdjobs = JobOrders::whereIn('id', $b)->where('is_talentpool', 0)->where('status', 24)->count();
            $vendorrejectedcandidates = Association::whereIn('candidate_status', array(1, 2, 30))->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->whereNotNull('employer_id')->count();
            $profiles_srt_phone = Association::where('candidate_status', 17)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_srt_f2f = Association::where('candidate_status', 18)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_srt_final = Association::where('candidate_status', 20)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_directinterview = Association::where('candidate_status', 23)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_skype = Association::where('candidate_status', 22)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_interview = Association::whereNotIn('candidate_status', [19, 7, 2, 1])->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
            $profiles_walkin = Association::where('candidate_status', 21)->where('created_at', '>=', $diff_date)->where('vendor_id', $authuser->parent_id)->whereIn('job_id', $b)->where('accountmanager_id', $amId)->whereNotNull('candidate_id')->count();
        } else {
            //by mukesh
            $amId = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('candidate_id')
                ->first()->accountmanager_id;
            $jobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNotNull('vendor_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('job_closed.status')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->where('created_at', '>=', $diff_date)
                ->count();
				
            $selectedprofiles = Association::where('vendor_id', $authuser->id)
                ->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNotNull('candidate_id')
                ->where('candidate_status', 27)
                ->count();
			
            $vendorassignedjobsall = Association::select('job_id')
                ->where('vendor_id', $authuser->id)
                //->where('created_at','>=',$diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('created_at', '>=', $diff_date)
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
            $vendorassignedjobs = Association::select('job_id')
                ->where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')
                ->get();
            $candidates = $vendorassignedholdjobs = $vendorrejectedcandidates = $profiles_srt_phone = $profiles_srt_f2f = $profiles_srt_final = $profiles_directinterview = $profiles_skype = $profiles_interview = $profiles_walkin = 0;
            foreach ($vendorassignedjobs as $job) {
                $allprofiles = Association::select('id')
                    ->where('job_id', $job['job_id'])
                    ->where('created_at', '>=', $diff_date)
                    ->where('vendor_id', $authuser->id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('employer_id')
                    ->whereNotNull('candidate_id')
                    ->select('candidate_status')
                    ->count();
                if ($allprofiles) {
                    $candidates += $allprofiles;
                }
                $vendor_assigned_hold_jobs = JobOrders::select('id')
                    ->where('id', $job['job_id'])->where('is_talentpool', 0)
                    ->where('status', 24)->where('created_at', '>=', $diff_date)
                    ->count();
                if ($vendor_assigned_hold_jobs) {
                    $vendorassignedholdjobs += $vendor_assigned_hold_jobs;
                }
                $vendor_rejected_candidates = Association::select('id')
                    ->whereIn('candidate_status', array(1, 2, 30))
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->where('accountmanager_id', $amId)
                    ->whereNotNull('candidate_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('employer_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($vendor_rejected_candidates) {
                    $vendorrejectedcandidates += $vendor_rejected_candidates;
                }
                $profiles_srt_phonee = Association::select('id')
                    ->where('candidate_status', 17)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')
                    ->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_srt_phonee) {
                    $profiles_srt_phone += $profiles_srt_phonee;
                }
                $profiles_srt_f2ff = Association::select('id')
                    ->where('candidate_status', 18)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_srt_f2ff) {
                    $profiles_srt_f2f += $profiles_srt_f2ff;
                }
                $profiles_srt_finall = Association::select('id')
                    ->where('candidate_status', 20)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_srt_finall) {
                    $profiles_srt_final += $profiles_srt_finall;
                }
                $profiles_directintervieww = Association::select('id')
                    ->where('candidate_status', 23)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_directintervieww) {
                    $profiles_directinterview += $profiles_directintervieww;
                }
                $profiles_skypee = Association::select('id')
                    ->where('candidate_status', 22)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_skypee) {
                    $profiles_skype += $profiles_skypee;
                }
                $profiles_walkinn = Association::select('id')
                    ->where('candidate_status', 21)
                    ->where('vendor_id', $authuser->id)
                    ->where('job_id', $job['job_id'])
                    ->whereNotNull('accountmanager_id')->where('created_at', '>=', $diff_date)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNull('vendor_user_id')
                    ->count();
                if ($profiles_walkinn) {
                    $profiles_walkin += $profiles_walkinn;
                }
            }
            $profiles_interview = Association::where('candidate_status', 31)
                ->where('vendor_id', $authuser->id)
                ->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('candidate_id')
                ->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->whereNull('vendor_user_id')
                ->count();
				
            $jobsclosed = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $pending_jobs = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 4)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 8);
                })
                ->count();
            $jobsaccepted = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->where('status_updated_by', $authuser->id)
                ->count();
            $rejected_jobs = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('created_at', '>=', $diff_date)
                            ->whereIn('job_status',[1,2,30])
                            ->count();

            $closed_jobs = Association::where('vendor_id', $authuser->id)->where('created_at', '>=', $diff_date)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('vendor_user_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->whereNull('candidate_id')
                ->where('job_status', 3)
                ->with('job.JobType')
                ->with('job_closed.status', 'job_assigned.vendorrevenues')
                ->whereHas('job_closed', function ($query) {
                    $query->where('status', '=', 6);
                })
                ->count();
            $vendorjobs = Association::where('vendor_id', $authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->whereNull('employer_user_id')
                ->whereNotNull('job_id')
                ->with('employer.company')
                ->with('job_assigned.status', 'job_assigned.vendorrevenues')
                ->with('job.JobType')->where('created_at', '>=', $diff_date)
                ->groupBy('job_id')
                ->get();
        }//else
		$selected_candidates=Association::where('vendor_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('job_id')
                            ->where('candidate_status',44)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count(); 
		$onboarded_closer = Association::where('vendor_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('job_id')
                            ->where('candidate_status',45)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count(); 
		$invoices = Association::where('vendor_id',$authuser->id)
							->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('job_id')
                            ->where('candidate_status',44)
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count();
        if ($authuser->parent_id) {
            $iscUser = 1;
        } else {
            $iscUser = 0;
        }
		
        $vendormetrics[] = array('jobs_submitted' => $jobs, 'profiles_received' => $candidates, 'jobsclosed' => $jobsclosed, 'profiles_selected' => $selectedprofiles, 'pending_jobs' => $pending_jobs, 'accepted_jobs' => $jobsaccepted, 'rejected_jobs' => $rejected_jobs, 'closed_jobs' => $closed_jobs, 'jobs_held' => $vendorassignedholdjobs, 'profiles_rejected' => $vendorrejectedcandidates, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f' => $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype, 'profiles_walkin' => $profiles_walkin, 'profiles_interview' => $profiles_interview, 'isVendorUser' => $iscUser, 'selected_candidates' => $selected_candidates, 'onboarded_closer'=>$onboarded_closer,'invoices'=>$invoices);
        return response()->success(compact('vendormetrics'));
    }

    public function getVendorreceivedprofiles($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        /*        $vendorreceivedprofiles=Association::select('job_id')
                                ->where('vendor_id',$authuser->id)->where('created_at','>=',$diff_date)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)->with('employer.company')
                                ->with('job_assigned.status','job_assigned.vendorrevenues')
                                ->with('job.JobType')
                                ->get();
            $vendorreceivedprofiles=array();
        foreach($vendorreceivedprofiles as $job) {
                $vendorreceivedprofiles = Association::where('vendor_id',$authId)
                            ->where('job_id',$job['job_id'])
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                            ->get();
                if($allprofiles) {
                    $vendorreceivedprofiles[] = $allprofiles;
                }
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid];
            $job['numbers'] = $numbers;
            }*/
        /* $vendorreceivedprofiles = Association::where('vendor_id',$authId)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                            ->get();*/
        /* print_r($vendorreceivedprofilesss);die;*/
        /*$vendorreceivedprofiles=Association::select('job_id')
                                ->where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)->with('employer.company')
                                ->with('job_assigned.status','job_assigned.vendorrevenues')
                                ->with('job.JobType')
                                ->with('candidate')
                                ->get();
        foreach ($vendorreceivedprofiles as $k => $job) {
            $vendorreceivedprofiless = Association::where('vendor_id',$authId)
                            ->where('created_at','>=',$diff_date)
                            ->where('job_id',$job['job_id'])
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                            ->get();
                        }*/
        $vendorreceivedprofiles = Association::where('vendor_id', $authId)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('accountmanager_id')
			->whereNotNull('employer_id')
			->whereNull('vendor_user_id')
			->whereNull('employer_user_id')
			->whereNotNull('job_id')
			//->where('candidate_status', 27)
			->whereHas('job', function ($query) use ($diff_date) {
                $query->where('created_at', '>=', $diff_date);
            })
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->get();
		
        foreach ($vendo