<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\User;
use App\Activity;
use Auth;
use Input;
use DB;
use DateTime;
use DateInterval;
use date_add;
use date_interval_create_from_date_string;
use App\Association;
use App\Industry;
use App\Company; 
use App\Country;
use App\VendorUserJob;
use App\CandidatePoints;
use App\Candidate;
use App\JobOrders;
use App\Models\SkillblockResume;
use App\VendorCandidateNotes;
class JobsManagerController extends Controller
{
    public function postRemovingvendor() {
		
		$authuser = Auth::user();
		$vendorid = Input::get('vendorid');
		$jobid = Input::get('jobid');
		
		Association::where(['accountmanager_id' => $authuser->id, 'vendor_id'=>$vendorid, 'job_id'=>$jobid])->delete();
		$deleted = "Deleted";
		return response()->success($deleted);
	}
	public function postEmployerquestions() {
		$PREFERED_SKILL = Input::get('PREFERED_SKILL');
		$INDUSTRY = Input::get('INDUSTRY');
		$IT = Input::get('IT');
		$CLIENT = Input::get('CLIENT');
		$JOB_RELATED_METHOD = Input::get('JOB_RELATED_METHOD');
		$LOCATION = Input::get('LOCATION');
		$TRAVEL_PERCENT = Input::get('TRAVEL_PERCENT');
		
		$empQuestions = DB::select("select * from employer_threeshold_questions order by id ASC");
		if(is_array($empQuestions) && count($empQuestions)>0) {
			$questions = array();
			foreach($empQuestions as $key => $value) {
				$quest = array();
				//print_r($PREFERED_SKILL[0]['text']);exit;
				if (strpos($value->question, '[PREFERED_SKILL]') !== false) {
					for($i=0; $i<4; $i++) {
						
						$quest['question'] = str_replace('[PREFERED_SKILL]', $PREFERED_SKILL[$i]['text'], $value->question);
						$quest['id'] = $value->id;
						$quest['is_must'] = 1;
						$questions[] = $quest;
					}
				} else if (strpos($value->question, '[INDUSTRY]') !== false) {
					
					$indInfo = Industry::find($INDUSTRY); 
					$quest['question'] = str_replace('[INDUSTRY]', $indInfo->name, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 1;
					$questions[] = $quest;
				} else if (strpos($value->question, '[IT]') !== false) {
					$indInfo = Industry::find($IT); 
					$quest['question'] = str_replace('[IT]', $indInfo->name, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 1;
					$questions[] = $quest;
				} else if (strpos($value->question, '[CLIENT]') !== false) {
					$authuser = Auth::user();
					$authInfo = User::find($authuser->id);
					$companyInfo = Company::find($authInfo->company_id);

					$quest['question'] = str_replace('[CLIENT]', $companyInfo->name, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 1;
					$questions[] = $quest;
				} else if (strpos($value->question, '[JOB_RELATED_METHOD]') !== false) {
					$quest['question'] = str_replace('[JOB_RELATED_METHOD]', $JOB_RELATED_METHOD, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 1;
					$questions[] = $quest;
				} else if (strpos($value->question, '[LOCATION]') !== false) {
					$countryInfo = Country::find($LOCATION);
					$quest['question'] = str_replace('[LOCATION]', $countryInfo->name, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 1;
					$questions[] = $quest;
				} else if (strpos($value->question, '[TRAVEL_PERCENT]') !== false) {
					$quest['question'] = str_replace('[TRAVEL_PERCENT]', $TRAVEL_PERCENT, $value->question);
					$quest['id'] = $value->id;
					$quest['is_must'] = 4;
					$questions[] = $quest;
				} else if($value->id==19) {
					$quest['question'] = $value->question;
					$quest['id'] = $value->id;
					$quest['is_must'] = 2;
					$questions[] = $quest;
				} else if($value->id==20) {
					$quest['question'] = $value->question;
					$quest['id'] = $value->id;
					$quest['is_must'] = 3;
					$questions[] = $quest;
				} else if($value->id==23) {
					$quest['question'] = $value->question;
					$quest['id'] = $value->id;
					$quest['is_must'] = 5;
					$questions[] = $quest;
				}  else {
					$quest['question'] = $value->question;
					$quest['id'] = $value->id;
					$quest['is_must'] = 6;
					$questions[] = $quest;
				}
			}
		}
		return response()->success(compact('questions'));
	}

	
	
	public function postAmrecruiterperformance() {
		$job_id_n =Input::get('job_id');
		//$vendor_id =Input::get('vendor_id');
		$decryption = base64_decode($job_id_n);
        $joborderId = $decryption;
        $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
		$authuser = Auth::user();
		$job_id =$joborderId;
		//echo $job_id;exit;
		$recruiterPerform = Association::where('job_id',$job_id)
								->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('admin_id')
					            ->whereNotNull('employer_id')
					            ->whereNotNull('vendor_id')
					            ->whereNull('vendor_user_id')
					            ->whereNull('employer_user_id')
					            ->whereNotNull('job_id')
					            ->whereNull('candidate_id')
					             ->with(array('Vendor'))
                                ->get()->toArray();
		
		if(is_array($recruiterPerform) && count($recruiterPerform)>0) {
			foreach($recruiterPerform as $key=>$value) {
				
				$recruterInfo[] = Association::where('vendor_id',$value['vendor']['id'])
								->where('job_id',$job_id)
								->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('admin_id')
					            ->whereNotNull('employer_id')
					            ->whereNotNull('vendor_id')
					            ->whereNull('vendor_user_id')
					            ->whereNull('employer_user_id')
					            ->whereNotNull('job_id')
					            ->whereNull('candidate_id')
                                ->get()->toArray();
			}
		}
		//print_r($recruterInfo);exit;
		$countIndex = count($recruterInfo)-1;
		$first_profile_date = $recruterInfo[0][0]['created_at']; 
		$last_profile_date = $recruterInfo[$countIndex][0]['created_at']; 
		//echo $first_profile_date.'=='.$last_profile_date;exit;
		$start = new DateTime($first_profile_date);
		$end = new DateTime($last_profile_date);
		
		$interval = $start->diff($end);
		$noOfWorkingDay = 0;
		for($k=0; $k<=$interval->days; $k++) {
			
			$start->modify('+1 day');
			$weekday = $start->format('w');
			if($weekday !== "0" && $weekday !== "6"){ // 0 for Sunday and 6 for Saturday
				$noOfWorkingDay++;  
			}
		}
		foreach($recruiterPerform as $key =>$value) {
			
			$kpiInfo = DB::table('kpi_weight')->where('vendor_id', $value['vendor']['id'])->get();
			$totalSubmit = Association::where('vendor_id', $value['vendor']['id'])
							->where('job_id',$job_id)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			//print_r($totalSubmit);exit;
			$submition_ratio = (!empty($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
			$submitiongreen = $submition_ratio;
			$submitionyellow = $submition_ratio/2;
			$submitionred = 0;
			$submitioncolor ="";
			if($totalSubmit!=0) {
				$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
			}else {
				$submitionRatio = 0;
			}
			
			if($submitionRatio >= $submitiongreen) {
				$submitioncolor = "#03d410";
				$url_main = "user_assets/Excellent.gif"; 
			} else if($submitionRatio >= $submitionyellow && $submitionRatio < $submitiongreen) {

				$submitioncolor = "#ffcd00 ";
				$url_main = "user_assets/Moderate.gif";
			} else {
				$submitioncolor = "#fc0c01";
				$url_main = "user_assets/Poor.gif";
			}
			
			$totalShortlist = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->where('candidate_status',5)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$shortlisted_ratio = (isset($kpiInfo[0]->shortlisted_ratio)) ? $kpiInfo[0]->shortlisted_ratio : '1';
			
			$shortlistgreen = $shortlisted_ratio;
			$shortlistyellow = ((int)$shortlisted_ratio/2);
			$shortlistred = 0;
			$shortlistcolor ="";
			if($totalShortlist!=0) {
				$shortlistToSubmitionRatio = $totalShortlist/$totalSubmit;
			}else {
				$shortlistToSubmitionRatio = 0;
			}
			if($shortlistToSubmitionRatio >= $shortlistgreen) {
				$shortlistcolor = "#03d410";
				$url_main1 = "user_assets/Excellent.gif";
			} else if($shortlistToSubmitionRatio >= $shortlistyellow && $shortlistToSubmitionRatio < $shortlistgreen) {

				$shortlistcolor = "#ffcd00";
				$url_main1 = "user_assets/Moderate.gif";
			} else {
				$shortlistcolor = "#fc0c01";
				$url_main1 = "user_assets/Poor.gif";
			}
			$totInterview = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->whereIn('candidate_status',[9,10,13,17,18,20, 21, 22, 23])
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$interview_ratio = (!empty($kpiInfo[0]->interview_ratio)) ? $kpiInfo[0]->interview_ratio : '1';

			$interviewgreen = $interview_ratio;
			$interviewyellow = (!empty($interview_ratio)) ? $interview_ratio/2 : "0";
			$interviewred = 0;
			$interviewcolor ="";
			if($totInterview!=0) {
				$interviewToSubmitionRatio = round($totInterview/$totalSubmit,2);
			} else {
				$interviewToSubmitionRatio = 0;
			}
			if($interviewToSubmitionRatio >= $interviewgreen) {
				$interviewcolor = "#03d410";
				$url_main2 = "user_assets/Excellent.gif";
			} else if($interviewToSubmitionRatio >= $interviewyellow && $interviewToSubmitionRatio < $interviewgreen) {

				$interviewcolor = "#ffcd00 ";
				$url_main2 = "user_assets/Moderate.gif";
			} else {
				$interviewcolor = "#fc0c01";
				$url_main2 = "user_assets/Poor.gif";
			}
			
			$totSelect = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->whereIn('candidate_status', [27, 28])
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$selection_ratio = (isset($kpiInfo[0]->selection_ratio)) ? $kpiInfo[0]->selection_ratio : '1';
			$selectiongreen = $selection_ratio;
			$selectionyellow = $selection_ratio/2;
			$selectionred = 0;
			$selectioncolor ="";
			if($totSelect!=0) {
				$selectionToSubmitionRatio = round($totSelect/$totalSubmit,2);
			} else {
				$selectionToSubmitionRatio = 0;
			}
			if($selectionToSubmitionRatio >= $selectiongreen) {
				$selectioncolor = "#03d410";
				$url_main3 = "user_assets/Excellent.gif";
			} else if($selectionToSubmitionRatio >= $selectionyellow && $selectionToSubmitionRatio < $selectiongreen) {

				$selectioncolor = "#ffcd00 ";
				$url_main3 = "user_assets/Moderate.gif";
			} else {
				$selectioncolor = "#fc0c01";
				$url_main3 = "user_assets/Poor.gif";
			}
			
			$totCloser = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->where('candidate_status', 44)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$closer_ratio = (isset($kpiInfo[0]->closer_ratio)) ? $kpiInfo[0]->closer_ratio : '1';
			
			$closergreen = $closer_ratio;
			$closeryellow = $closer_ratio/2;
			$closerred = 0;
			$closercolor ="";
			if($totCloser!=0) {
				$closerToSubmitionRatio = round($totCloser/$totalSubmit,2);
			} else {
				$closerToSubmitionRatio = 0;
			}
			if($closerToSubmitionRatio >= $closergreen) {
				$closercolor = "#03d410";
				$url_main4 = "user_assets/Excellent.gif";
			} else if($closerToSubmitionRatio >= $closeryellow && $closerToSubmitionRatio < $closergreen) {

				$closercolor = "#ffcd00 ";
				$url_main4 = "user_assets/Moderate.gif";
			} else {
				$closercolor = "#fc0c01";
				$url_main4 = "user_assets/Poor.gif";
			}
			
			$totJoin = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->where('candidate_status', 45)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$joining_ratio = (isset($kpiInfo[0]->joining_ratio)) ? $kpiInfo[0]->joining_ratio : '1';
			$joininggreen = $joining_ratio;
			$joiningyellow = $joining_ratio/2;
			$joiningred = 0;
			$joiningcolor ="";
			if($totJoin!=0) {
				$joiningToSubmitionRatio = round($totJoin/$totalSubmit,2);
			} else {
				$joiningToSubmitionRatio = 0;
			}
			if($joiningToSubmitionRatio >= $joininggreen) {
				$joiningcolor = "#03d410";
				$url_main5 = "user_assets/Excellent.gif";
			} else if($joiningToSubmitionRatio >= $joiningyellow && $joiningToSubmitionRatio < $joininggreen) {

				$joiningcolor = "#ffcd00";
				$url_main5 = "user_assets/Moderate.gif";
			} else {
				$joiningcolor = "#fc0c01";
				$url_main5 = "user_assets/Poor.gif";
			}
			
			$totalReject = Association::where('vendor_id',$value['vendor']['id'])
							->where('job_id',$job_id)
							->whereIn('candidate_status',array(1,2,30))
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			if($totalReject!=0) {
				$totalRejectRatio = round(($totalReject *100)/$totalSubmit,2);
			} else {
				$totalRejectRatio = 0;
			}
			$rejectionratio = (isset($kpiInfo[0]->rejection_ratio)) ? $kpiInfo[0]->rejection_ratio : '20';	
			
			$rejectiongreen = $rejectionratio;
			$rejectionyellow = $rejectionratio/2;
			$rejectionred = 0;
			$rejectioncolor ="";
			if($totalRejectRatio >= $rejectiongreen) {
				$rejectioncolor = "#fc0c01";
				$url_main6 = "user_assets/Poor.gif";
			} else if($totalRejectRatio >= $rejectionyellow && $totalRejectRatio < $rejectiongreen) {

				$rejectioncolor = "#ffcd00";
				$url_main6 = "user_assets/Moderate.gif";
			} else {
				$rejectioncolor = "#03d410";
				$url_main6 = "user_assets/Excellent.gif"; 
			}
			
			$vendorInformation[] = array('name'=>$value['vendor']['first_name'],
										'vendor_id'=>$value['vendor']['id'], 
										'total_submition' =>array('submition_ratio'=>$submition_ratio,
																  'weight'=>$submition_ratio,
																  'red' =>$submitionred,
																  'yellow' =>$submitionyellow,
																  'green' =>$submitiongreen, 
																  'color'=>$submitioncolor,
																  'url_main'=>$url_main
																),
										'total_shortlisted' =>array('shortlisted_ratio'=>$shortlisted_ratio,
																  'weight'=>$shortlisted_ratio,
																  'red' =>$shortlistred,
																  'yellow' =>$shortlistyellow,
																  'green' =>$shortlistgreen, 
																  'color'=>$shortlistcolor,
																  'url_main'=>$url_main1
																),
										'total_interview' =>array('interview_ratio'=>$interview_ratio,
																  'weight'=>$interview_ratio,
																  'red' =>$interviewred,
																  'yellow' =>$interviewyellow,
																  'green' =>$interviewgreen, 
																  'color'=>$interviewcolor,
																  'url_main'=>$url_main2
																),
										'total_selection' =>array('interview_ratio'=>$selection_ratio,
																  'weight'=>$selection_ratio,
																  'red' =>$selectionred,
																  'yellow' =>$selectionyellow,
																  'green' =>$selectiongreen, 
																  'color'=>$selectioncolor,
																  'url_main'=>$url_main3
																),
										'total_closer' =>array('closer_ratio'=>$closer_ratio,
																  'weight'=>$closer_ratio,
																  'red' =>$closerred,
																  'yellow' =>$closeryellow,
																  'green' =>$closergreen, 
																  'color'=>$closercolor,
																  'url_main'=>$url_main4
																),
										'total_joining' =>array('joining_ratio'=>$joining_ratio,
																  'weight'=>$joining_ratio,
																  'red' =>$joiningred,
																  'yellow' =>$joiningyellow,
																  'green' =>$joininggreen, 
																  'color'=>$joiningcolor,
																  'url_main'=>$url_main5
																),
										'total_rejection' =>array('rejectionratio'=>$rejectionratio,
																  'weight'=>$rejectionratio,
																  'red' =>$rejectionred,
																  'yellow' =>$rejectionyellow,
																  'green' =>$rejectiongreen, 
																  'color'=>$rejectioncolor,
																  'url_main'=>$url_main6
																),
										'submitionRatio' =>$submitionRatio,
										'shortlistToSubmitionRatio' =>$shortlistToSubmitionRatio,
										'interviewToSubmitionRatio' =>$interviewToSubmitionRatio,
										'selectionToSubmitionRatio' =>$selectionToSubmitionRatio,
										'closerToSubmitionRatio' =>$closerToSubmitionRatio,
										'joiningToSubmitionRatio' =>$joiningToSubmitionRatio,
										'totalRejectRatio' =>$totalRejectRatio
										);
									
			
		}
		$amrecruiterperformance['vendorInformation'] = $vendorInformation;
		
        return response()->success(compact('amrecruiterperformance'));
	}
	
	
	// public function postAmrecruiterperformancetwo() {
	// 	$job_id_n =Input::get('job_id');
	// 	$vendor_id =Input::get('vendor_id');
	// 	$decryption = base64_decode($job_id_n);
 //        $joborderId = $decryption;
 //        $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
	// 	$authuser = Auth::user();
	// 	$job_id =$joborderId;
		
	// 	$recruiterPerform = Association::where('job_id',$job_id)
	// 							->where('accountmanager_id',$authuser->id)
 //                                ->whereNotNull('admin_id')
	// 				            ->whereNotNull('employer_id')
	// 				            ->whereNotNull('vendor_id')
	// 				            ->whereNull('vendor_user_id')
	// 				            ->whereNull('employer_user_id')
	// 				            ->whereNotNull('job_id')
	// 				            ->whereNull('candidate_id')
	// 				             ->with(array('Vendor'))
 //                                ->get()->toArray();
	// 	//print_r($recruiterPerform);exit;						
	// 	if(is_array($recruiterPerform) && count($recruiterPerform)>0) {
			
	// 		$vendorNames = array();
	// 		$vendor_ids = array();
	// 		foreach($recruiterPerform as $key =>$value) {
	// 			if(!in_array($value['vendor']['first_name'], $vendorNames)) {
	// 				$vendorNames[] = array('name'=>$value['vendor']['first_name'], 'vendor_id'=>$value['vendor']['id']);
	// 				$vendor_ids[] = $value['vendor']['id'];
	// 			}
				
	// 		}
	// 	}
	// 	//print_r($vendor_ids);EXIT;
	// 	if(is_array($vendor_ids) && count($vendor_ids)>0) {
			
	// 		for($i=0; $i<count($vendor_ids); $i++) {
				
	// 			$recruterInfo[$i] = Association::where('vendor_id',$vendor_ids[$i])
	// 							->where('job_id',$job_id)
	// 							->where('accountmanager_id',$authuser->id)
 //                                ->whereNotNull('admin_id')
	// 				            ->whereNotNull('employer_id')
	// 				            ->whereNotNull('vendor_id')
	// 				            ->whereNull('vendor_user_id')
	// 				            ->whereNull('employer_user_id')
	// 				            ->whereNotNull('job_id')
	// 				            ->whereNull('candidate_id')
 //                                ->get()->toArray();
	// 		}
	// 	}
	// 	$countIndex = count($recruterInfo)-1;
	// 	$first_profile_date = $recruterInfo[0][0]['created_at']; 
	// 	$last_profile_date = $recruterInfo[$countIndex][0]['created_at']; 
	// 	//echo $first_profile_date.'=='.$last_profile_date;exit;
	// 	$start = new DateTime($first_profile_date);
	// 	$end = new DateTime($last_profile_date);
		
	// 	$interval = $start->diff($end); 
	// 	$noOfWorkingDay = 0;
	// 	for($k=0; $k<=$interval->days; $k++) {
			
	// 		$start->modify('+1 day');
	// 		$weekday = $start->format('w');
	// 		if($weekday !== "0" && $weekday !== "6"){ // 0 for Sunday and 6 for Saturday
	// 			$noOfWorkingDay++;  
	// 		}
	// 	}
		
	// 	$noOfWorkingDays = array('no_of_working_days' =>$noOfWorkingDay, 'vendor_id'=>$vendor_id);
		
	// 	$kpiInfo = DB::table('kpi_weight')->where('vendor_id', $vendor_id)->get();
		
	// 	$totalSubmit = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
	// 	$submition_ratio = (isset($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
	// 	$green = $submition_ratio;
	// 	$yellow = $submition_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totalSubmit >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totalSubmit >= $yellow && $totalSubmit < $green) {
	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}$totalSubmitions = array('total_submition' =>$totalSubmit, 'weight'=>$submition_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$totalShortlist = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('candidate_status',5)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
	// 	$shortlisted_ratio = (isset($kpiInfo[0]->shortlisted_ratio)) ? $kpiInfo[0]->shortlisted_ratio : '1';
	// 	$green = $shortlisted_ratio;
	// 	$yellow = $shortlisted_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totalShortlist >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totalShortlist >= $yellow && $totalShortlist < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}

	// 	$totalShorlisted = array('total_shortlisted' =>$totalShortlist, 'weight'=>$shortlisted_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$totInterview = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->whereIn('candidate_status',[9,10,13,17,18,20, 21, 22, 23])
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();

	// 	$interview_ratio = (!empty($kpiInfo[0]->interview_ratio)) ? $kpiInfo[0]->interview_ratio : '1';
	// 	$green = $interview_ratio;
	// 	$yellow = $interview_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totInterview >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totInterview >= $yellow && $totInterview < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}
	// 	$totalInterview = array('total_interview' =>$totInterview, 'weight'=>$interview_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$totSelect = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('candidate_status', 3)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
	// 	$selection_ratio = (isset($kpiInfo[0]->selection_ratio)) ? $kpiInfo[0]->selection_ratio : '1';
	// 	$green = $selection_ratio;
	// 	$yellow = $selection_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totSelect >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totSelect >= $yellow && $totSelect < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}
		
	// 	$totalSelection = array('total_selection' =>$totSelect, 'weight'=>$selection_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$totCloser = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('candidate_status', 44)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
	// 	$closer_ratio = (isset($kpiInfo[0]->closer_ratio)) ? $kpiInfo[0]->closer_ratio : '1';
	// 	$green = $closer_ratio;
	// 	$yellow = $closer_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totCloser >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totCloser >= $yellow && $totCloser < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}
		
	// 	$totalCloser = array('total_closer' =>$totCloser,  'weight'=>$closer_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
	// 	$totJoin = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('candidate_status', 45)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
	// 	$joining_ratio = (isset($kpiInfo[0]->joining_ratio)) ? $kpiInfo[0]->joining_ratio : '1';
	// 	$green = $joining_ratio;
	// 	$yellow = $joining_ratio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totJoin >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totJoin >= $yellow && $totJoin < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}
	// 	$totalJoining = array('total_joining' =>$totJoin, 'weight'=>$joining_ratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
	// 	$shortlistToSubmitionRatio = $totalShortlist/$totalSubmit;
	// 	$interviewToSubmitionRatio = round($totInterview/$totalSubmit,2);
	// 	$selectionToSubmitionRatio = round($totSelect/$totalSubmit,2);
	// 	$closerToSubmitionRatio = round($totCloser/$totalSubmit,2);
	// 	$joiningToSubmitionRatio = round($totJoin/$totalSubmit,2);
		
	// 	$totalReject = Association::where('vendor_id',$vendor_id)
	// 					->where('job_id',$job_id)
	// 					->where('candidate_status', 3)
	// 					->where('accountmanager_id',$authuser->id)
	// 					->count();
						
	// 	$totalRejectRatio = round(($totalReject *100)/$totalSubmit,2);
	// 	$rejectionratio = (isset($kpiInfo[0]->rejection_ratio)) ? $kpiInfo[0]->rejection_ratio : '20';	
		
	// 	$green = $totalRejectRatio;
	// 	$yellow = $totalRejectRatio/2;
	// 	$red = 0;
	// 	$color ="";
	// 	if($totalReject >= $green) {
	// 		$color = "#03d410";
	// 	} else if($totalReject >= $yellow && $totalReject < $green) {

	// 		$color = "#ffcd00 ";
	// 	} else {
	// 		$color = "#fc0c01";
	// 	}
	// 	$totalRejectRatio = array('total_rejection' =>$totalRejectRatio, 'weight'=>$rejectionratio,'red' =>$red,'yellow' =>$yellow,'green' =>$green, 'color'=>$color);
		
	// 	$numbers = ['vendorNames' => $vendorNames, 'noOfWorkingDays' => $noOfWorkingDays, 'totalSubmitions' => $totalSubmitions, 'totalShorlisted' => $totalShorlisted, 'totalInterview'=>$totalInterview, 'totalSelection'=>$totalSelection, 'totalCloser'=>$totalCloser, 'totalJoining'=>$totalJoining, 'submitionRatio'=>$submitionRatio, 'shortlistToSubmitionRatio'=>$shortlistToSubmitionRatio, 'interviewToSubmitionRatio'=>$interviewToSubmitionRatio, 'selectionToSubmitionRatio'=>$selectionToSubmitionRatio, 'closerToSubmitionRatio'=>$closerToSubmitionRatio, 'joiningToSubmitionRatio'=>$joiningToSubmitionRatio, 'totalRejectRatio'=>$totalRejectRatio];
        
	// 	$amrecruiterperformance['numbers'] = $numbers;
 //        return response()->success(compact('amrecruiterperformance'));
	// }
	public function postAmrecruiterperformancethree() {
		$job_id_n =Input::get('job_id');
		$vendor_id =Input::get('vendor_id');
		$decryption = base64_decode($job_id_n);
        $joborderId = $decryption;
        $joborderId = substr($joborderId, strpos($joborderId, "-") + 1);
		$authuser = Auth::user();
		$job_id =$joborderId;
		$submition_ratio = Input::get('submition_ratio');
		$shortlisted_ratio = Input::get('shortlisted_ratio');
		$interview_ratio = Input::get('interview_ratio');
		$selection_ratio = Input::get('selection_ratio');
		$closer_ratio = Input::get('closer_ratio');
		$joining_ratio =Input::get('joining_ratio');
		$totalRejectRatio =Input::get('totalRejectRatio');

		$user = DB::select(" select * from kpi_weight where vendor_id=".$vendor_id."");
		if ($user === null) {
			DB::insert("insert into  kpi_weight  set submition_ratio='".$submition_ratio."', shortlisted_ratio='".$shortlisted_ratio."', interview_ratio='".$interview_ratio."', selection_ratio='".$selection_ratio."', closer_ratio='".$closer_ratio."',joining_ratio='".$joining_ratio."', vendor_id=".$vendor_id." ");
		   // user doesn't exist
		}
		else{
		
		DB::update("update  kpi_weight  set submition_ratio='".$submition_ratio."', shortlisted_ratio='".$shortlisted_ratio."', interview_ratio='".$interview_ratio."', selection_ratio='".$selection_ratio."', closer_ratio='".$closer_ratio."',joining_ratio='".$joining_ratio."' where vendor_id='".$vendor_id."' ");
		}
		$amrecruiterperformance="succesfulluy inserted";
        return response()->success(compact('amrecruiterperformance'));
	}
	public function postAmrecruiterperformancefour() {
		
        $vendor_id=Input::get('vendor_id');
		$venInfo = DB::table('users')->where('id', $vendor_id)->get();
		$authuser = Auth::user();
		$vendoruserjobs = VendorUserJob::where('vendor_user_id',$vendor_id)->with('job')->groupBy('job_id')->get()->toArray();
		if (count($vendoruserjobs) != 0 )
		{
			$noOfJobs = (is_array($vendoruserjobs)) ? count($vendoruserjobs) : "0";
			foreach($vendoruserjobs as $key =>$jobs) {
				$job_ids[] = $jobs['job_id'];
			}
			/*$kpiInfo = DB::table('kpi_weight')->where('vendor_id', $vendor_id)->get();*/
			
			$totalSubmit = Association::where('vendor_id', $vendor_id)
								->whereIn('job_id',$job_ids)
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				//print_r($totalSubmit);exit;
				/*$submition_ratio = (!empty($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
				$submitiongreen = $submition_ratio;
				$submitionyellow = $submition_ratio/2;
				$submitionred = 0;
				$submitioncolor ="";
				if($totalSubmit!=0) {
					$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
				}else {
					$submitionRatio = 0;
				}
				
				if($submitionRatio >= $submitiongreen) {
					$submitioncolor = "#03d410";
				} else if($submitionRatio >= $submitionyellow && $submitionRatio < $submitiongreen) {

					$submitioncolor = "#ffcd00 ";
				} else {
					$submitioncolor = "#fc0c01";
				}*/
				
			$submition_ratio = (!empty($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
			$submitiongreen = $submition_ratio;
			$submitionyellow = $submition_ratio/2;
			$submitionred = 0;
			$submitioncolor ="";
			if($totalSubmit!=0) {
				$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
			}else {
				$submitionRatio = 0;
			}
			
			if($submitionRatio >= $submitiongreen) {
				$submitioncolor = "#03d410";
				$url_main = "user_assets/Excellent.gif"; 
			} else if($submitionRatio >= $submitionyellow && $submitionRatio < $submitiongreen) {

				$submitioncolor = "#ffcd00 ";
				$url_main = "user_assets/Moderate.gif";
			} else {
				$submitioncolor = "#fc0c01";
				$url_main = "user_assets/Poor.gif";
			}
				$totalShortlist = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->where('candidate_status',5)
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				$shortlisted_ratio = (isset($kpiInfo[0]->shortlisted_ratio)) ? $kpiInfo[0]->shortlisted_ratio : '1';
				
				$shortlistgreen = $shortlisted_ratio;
				$shortlistyellow = ((int)$shortlisted_ratio/2);
				$shortlistred = 0;
				$shortlistcolor ="";
				if($totalShortlist!=0) {
					$shortlistToSubmitionRatio = $totalShortlist/$totalSubmit;
				}else {
					$shortlistToSubmitionRatio = 0;
				}
				if($shortlistToSubmitionRatio >= $shortlistgreen) {
					$shortlistcolor = "#03d410";
				} else if($shortlistToSubmitionRatio >= $shortlistyellow && $shortlistToSubmitionRatio < $shortlistgreen) {

					$shortlistcolor = "#ffcd00 ";
				} else {
					$shortlistcolor = "#fc0c01";
				}
				$totInterview = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->whereIn('candidate_status',[9,10,13,17,18,20, 21, 22, 23])
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				$interview_ratio = (!empty($kpiInfo[0]->interview_ratio)) ? $kpiInfo[0]->interview_ratio : '1';

				$interviewgreen = $interview_ratio;
				$interviewyellow = (!empty($interview_ratio)) ? $interview_ratio/2 : "0";
				$interviewred = 0;
				$interviewcolor ="";
				if($totInterview!=0) {
					$interviewToSubmitionRatio = round($totInterview/$totalSubmit,2);
				} else {
					$interviewToSubmitionRatio = 0;
				}
				if($interviewToSubmitionRatio >= $interviewgreen) {
					$interviewcolor = "#03d410";
				} else if($interviewToSubmitionRatio >= $interviewyellow && $interviewToSubmitionRatio < $interviewgreen) {

					$interviewcolor = "#ffcd00 ";
				} else {
					$interviewcolor = "#fc0c01";
				}
				
				$totSelect = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->where('candidate_status', 3)
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				$selection_ratio = (isset($kpiInfo[0]->selection_ratio)) ? $kpiInfo[0]->selection_ratio : '1';
				$selectiongreen = $selection_ratio;
				$selectionyellow = $selection_ratio/2;
				$selectionred = 0;
				$selectioncolor ="";
				if($totSelect!=0) {
					$selectionToSubmitionRatio = round($totSelect/$totalSubmit,2);
				} else {
					$selectionToSubmitionRatio = 0;
				}
				if($selectionToSubmitionRatio >= $selectiongreen) {
					$selectioncolor = "#03d410";
				} else if($selectionToSubmitionRatio >= $selectionyellow && $selectionToSubmitionRatio < $selectiongreen) {

					$selectioncolor = "#ffcd00 ";
				} else {
					$selectioncolor = "#fc0c01";
				}
				
				$totCloser = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->where('candidate_status', 44)
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				$closer_ratio = (isset($kpiInfo[0]->closer_ratio)) ? $kpiInfo[0]->closer_ratio : '1';
				
				$closergreen = $closer_ratio;
				$closeryellow = $closer_ratio/2;
				$closerred = 0;
				$closercolor ="";
				if($totCloser!=0) {
					$closerToSubmitionRatio = round($totCloser/$totalSubmit,2);
				} else {
					$closerToSubmitionRatio = 0;
				}
				if($closerToSubmitionRatio >= $closergreen) {
					$closercolor = "#03d410";
				} else if($closerToSubmitionRatio >= $closeryellow && $closerToSubmitionRatio < $closergreen) {

					$closercolor = "#ffcd00 ";
				} else {
					$closercolor = "#fc0c01";
				}
				
				$totJoin = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->where('candidate_status', 45)
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				$joining_ratio = (isset($kpiInfo[0]->joining_ratio)) ? $kpiInfo[0]->joining_ratio : '1';
				$joininggreen = $joining_ratio;
				$joiningyellow = $joining_ratio/2;
				$joiningred = 0;
				$joiningcolor ="";
				if($totJoin!=0) {
					$joiningToSubmitionRatio = round($totJoin/$totalSubmit,2);
				} else {
					$joiningToSubmitionRatio = 0;
				}
				if($joiningToSubmitionRatio >= $joininggreen) {
					$joiningcolor = "#03d410";
				} else if($joiningToSubmitionRatio >= $joiningyellow && $joiningToSubmitionRatio < $joininggreen) {

					$joiningcolor = "#ffcd00 ";
				} else {
					$joiningcolor = "#fc0c01";
				}
				
				$totalReject = Association::where('vendor_id',$vendor_id)
								->whereIn('job_id',$job_ids)
								->whereIn('candidate_status',array(1,2,30))
								->where('accountmanager_id',$authuser->id)
								->whereNotNull('candidate_status')
								->whereNotNull('accountmanager_id')
								->whereNotNull('candidate_id')
								->whereNotNull('employer_id')
								->whereNotNull('vendor_id')
								->whereNull('vendor_user_id')
								->count();
				if($totalReject!=0) {
					$totalRejectRatio = round(($totalReject *100)/$totalSubmit,2);
				} else {
					$totalRejectRatio = 0;
				}
				$rejectionratio = (isset($kpiInfo[0]->rejection_ratio)) ? $kpiInfo[0]->rejection_ratio : '20';	
				
				$rejectiongreen = $rejectionratio;
				$rejectionyellow = $rejectionratio/2;
				$rejectionred = 0;
				$rejectioncolor ="";
				if($totalRejectRatio >= $rejectiongreen) {
					$rejectioncolor = "#03d410";
				} else if($totalRejectRatio >= $rejectionyellow && $totalRejectRatio < $rejectiongreen) {

					$rejectioncolor = "#ffcd00 ";
				} else {
					$rejectioncolor = "#fc0c01";
				}
				
				$vendorInformation[] = array('name'=>$venInfo[0]->first_name,
											'vendor_id'=>$venInfo[0]->id, 
											'total_submition' =>array('submition_ratio'=>$submition_ratio,
																	  'weight'=>$submition_ratio,
																	  'red' =>$submitionred,
																	  'yellow' =>$submitionyellow,
																	  'green' =>$submitiongreen, 
																	  'color'=>$submitioncolor,
																	  'url_main' =>$url_main
																	),
											'total_shortlisted' =>array('shortlisted_ratio'=>$shortlisted_ratio,
																	  'weight'=>$shortlisted_ratio,
																	  'red' =>$shortlistred,
																	  'yellow' =>$shortlistyellow,
																	  'green' =>$shortlistgreen, 
																	  'color'=>$shortlistcolor,
																	  'url_main' =>$url_main
																	),
											'total_interview' =>array('interview_ratio'=>$interview_ratio,
																	  'weight'=>$interview_ratio,
																	  'red' =>$interviewred,
																	  'yellow' =>$interviewyellow,
																	  'green' =>$interviewgreen, 
																	  'color'=>$interviewcolor,
																	  'url_main' =>$url_main
																	),
											'total_selection' =>array('interview_ratio'=>$selection_ratio,
																	  'weight'=>$selection_ratio,
																	  'red' =>$selectionred,
																	  'yellow' =>$selectionyellow,
																	  'green' =>$selectiongreen, 
																	  'color'=>$selectioncolor,
																	  'url_main' =>$url_main
																	),
											'total_closer' =>array('closer_ratio'=>$closer_ratio,
																	  'weight'=>$closer_ratio,
																	  'red' =>$closerred,
																	  'yellow' =>$closeryellow,
																	  'green' =>$closergreen, 
																	  'color'=>$closercolor,
																	  'url_main' =>$url_main
																	),
											'total_joining' =>array('joining_ratio'=>$joining_ratio,
																	  'weight'=>$joining_ratio,
																	  'red' =>$joiningred,
																	  'yellow' =>$joiningyellow,
																	  'green' =>$joininggreen, 
																	  'color'=>$joiningcolor,
																	  'url_main' =>$url_main
																	),
											'total_rejection' =>array('rejectionratio'=>$rejectionratio,
																	  'weight'=>$rejectionratio,
																	  'red' =>$rejectionred,
																	  'yellow' =>$rejectionyellow,
																	  'green' =>$rejectiongreen, 
																	  'color'=>$rejectioncolor,
																	  'url_main' =>$url_main
																	),
											'submitionRatio' =>$submitionRatio,
											'shortlistToSubmitionRatio' =>$shortlistToSubmitionRatio,
											'interviewToSubmitionRatio' =>$interviewToSubmitionRatio,
											'selectionToSubmitionRatio' =>$selectionToSubmitionRatio,
											'closerToSubmitionRatio' =>$closerToSubmitionRatio,
											'joiningToSubmitionRatio' =>$joiningToSubmitionRatio,
											'totalRejectRatio' =>$totalRejectRatio
											);
			return response()->success(compact('vendorInformation'));
		}
		else{
			return response()->error("There are no jobs to show kpi.");

		}
        
		
	}
	public function postAllcomments() {
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		$candInfo = Candidate::where('id', $candidate_id)->first();
		$jobInfo = DB::table('job_orders')->where('id',$job_id)->get();
		$authuser = Auth::user();

		$accountmComments = Activity::where('candidate_id', $candidate_id)
							->where('job_id', $job_id)
							->whereNotNull('accountmanager_id')
							->whereNotNull('note')->with('job','candidate','activityuser.role','status')
							//->whereNull('employer_id')
							//->whereNull('vendor_id')
							->get()
							->toArray();
		if($authuser->role_id != 10)
		{
		// if($jobInfo[0]->blindhire==1 || $candInfo->mask==1) {
			if($jobInfo[0]->blindhire==1) {
			if(is_array($accountmComments) && count($accountmComments)>0) {
				foreach ($accountmComments as $key => $value) {
				$full_name = $accountmComments[$key]['candidate']['full_name'];
				$accountmComments[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", strlen($full_name)), 2, strlen($full_name)-4);
			}
			}
		}
		}
		$employerComments = Activity::where('candidate_id', $candidate_id)
							->where('job_id', $job_id)
							->whereNotNull('employer_id')
							->whereNotNull('note')->with('job','candidate','activityuser.role','status')
							//->whereNull('accountmanager_id')
							//->whereNull('vendor_id')
							->get()
							->toArray();
		if($authuser->role_id != 10)
		{
		// if($jobInfo[0]->blindhire==1 || $candInfo->mask==1) {
			if($jobInfo[0]->blindhire==1) {
			if(is_array($employerComments) && count($employerComments)>0) {
				foreach ($employerComments as $key => $value) {
				$full_name = $employerComments[$key]['candidate']['full_name'];
				$employerComments[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", strlen($full_name)), 2, strlen($full_name)-4);
			}
			}
		}
	   }
		$vendorComments = Activity::where('candidate_id', $candidate_id)
							->where('job_id', $job_id)
							->whereNotNull('vendor_id')
							->whereNotNull('note')->with('job','candidate','activityuser.role','status')
							//->whereNull('accountmanager_id')
							//->whereNull('employer_id')
							->get()
							->toArray();
		if($authuser->role_id != 10)
		{
		// if($jobInfo[0]->blindhire==1 || $candInfo->mask==1) {
			if($jobInfo[0]->blindhire==1) {
			if(is_array($vendorComments) && count($vendorComments)>0) {
				foreach ($vendorComments as $key => $value) {
				$full_name = $vendorComments[$key]['candidate']['full_name'];
				$vendorComments[$key]['candidate']['full_name'] = substr_replace($full_name, str_repeat("X", strlen($full_name)), 2, strlen($full_name)-4);
			}
			}
		}
	  }
		$speedometer = CandidatePoints::where('job_id', $job_id)
            ->where('candidate_id', $candidate_id)
            ->get()->toArray();
        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
            $created_date = date('Y-m-d-H-i-s', strtotime($jobInfo[0]->updated_at));
            $created_at = explode('-', $created_date);
            
            $date = new \DateTime($jobInfo[0]->updated_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            $job['updated_at'] = $date->format('Y-m-d H:i:s');

            $timezone = $empTimezone[0]['GMT_offset'];
		$numbers = array('accountmComments'=>$accountmComments, 
						'employerComments'=>$employerComments, 
						'vendorComments'=>$vendorComments, 
						'speedometer'=>$speedometer,
						'timezone'=>$timezone);
		$allcomments = $numbers;
		return response()->success(compact('allcomments'));
	}
	public function postUpdatecomments() {
		//$candidate_id = Input::get('candidate_id');
		//$job_id = Input::get('job_id');
		$comment = Input::get('comment');
		$accountmanager_id = Input::get('accountmanager_id');
		$employer_id = Input::get('employer_id');
		$vendor_id = Input::get('vendor_id');
		$activity_id = Input::get('activity_id');
		
		if(!empty($accountmanager_id)) {
			$comments = array('accountmanager_id'=>$accountmanager_id,
							  'comment' => $comment);
		}
		if(!empty($employer_id)) {
			$comments = array('employer_id'=>$employer_id,
							  'comment' => $comment);
		}
		if(!empty($vendor_id)) {
			$comments = array('vendor_id'=>$vendor_id,
							  'comment' => $comment);
		}
		
		Activity::where('id', $activity_id)->update($comments);
		
		$success = "Comment updated successfully.";
		
		return response()->success(compact('success'));
	}
	
	public function getAmprofileselectedcandidates($count) {
		$authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofileselectedcandidates = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 44)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofileselectedcandidates as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofileselectedcandidates'));

	}
	public function getAmprofileonboardedclosers($count) {
		//echo "Jai Guru Dev";exit;
		$authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofileonboardedcloser = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 45)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofileonboardedcloser as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofileonboardedcloser'));

	}
	public function getAmprofileinvoices($count) {
		$authuser = Auth::user();
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $amprofileinvoices = Association::where('accountmanager_id', $authuser->id)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNotNull('job_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->where('candidate_status', 46)
            ->with('job')
            ->whereHas('job', function ($query) {
                $query->where('status', '!=', 6);
            })->groupby('job_id')
            ->get();
        foreach ($amprofileinvoices as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amprofileinvoices'));

	}
	public function getEmployerselectedcandidates($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerselectedcandidates = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 44)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerselectedcandidates = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 44)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerselectedcandidates as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerselectedcandidates'));
    }
	public function getEmployeronboardedcloser($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employeronboardedcloser = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 45)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employeronboardedcloser = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 45)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employeronboardedcloser as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employeronboardedcloser'));
    }
	public function getEmployerenvoices($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id', $authuser->parent_id)
                ->where('employer_user_id', $authuser->id)
                ->lists('job_id');
            $jobsclosed = JobOrders::whereIn('id', $empjobs)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('status', 6)->where('user_id', $authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id', $authId)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->get();
            foreach ($empjobs as $job) {
                array_push($empjobids, $job->id);
            }
            $jobsclosed = JobOrders::where('status', 6)
                ->where('created_at', '>=', $diff_date)->where('is_talentpool', 0)->where('user_id', $authId)->count();
        }
        $amId = Association::where('employer_id', $authId)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('employer_id')
            ->get();
        $activityes = Activity::where('activity_by', $amId[0]['accountmanager_id'])->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        if ($authuser->parent_id) {
            $employerenvoices = Association::whereIn('job_id', $empjobs)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 46)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        } else {
            $employerenvoices = Association::whereIn('job_id', $empjobids)->where('created_at', '>=', $diff_date)
                ->whereNotIn('candidate_id', $activityData)
                ->where('employer_id', $authId)
                ->whereNotNull('candidate_status')
                ->where('candidate_status', 46)
                ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
                ->whereNotNull('vendor_id')
                ->get();
        }
        foreach ($employerenvoices as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('employerenvoices'));
    }
	public function getVendorprofilesselectedcandidates($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $vendorprofilesselectedcandidates = Association::where('candidate_status', 44)
            ->where('vendor_id', $authId)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->get();
        foreach ($vendorprofilesselectedcandidates as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('vendorprofilesselectedcandidates'));
    }
	public function getVendorprofilesonboardedcloser($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $vendorprofilesonboardedcloser = Association::where('candidate_status', 45)
            ->where('vendor_id', $authId)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->get();
        foreach ($vendorprofilesonboardedcloser as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('vendorprofilesonboardedcloser'));
    }
	public function getVendorprofilesinvoices($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data = new DateTime();
        $count_value = "P" . $count . "D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if ($authuser->parent_id) {
            $authId = $authuser->parent_id;
        } else {
            $authId = $authuser->id;
        }
        $vendorprofilesinvoices = Association::where('candidate_status', 46)
            ->where('vendor_id', $authId)
            ->where('created_at', '>=', $diff_date)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')->with('candidate')->with('status')->with('job')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->get();
        foreach ($vendorprofilesinvoices as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('vendorprofilesinvoices'));
    }
	public function postCandidatenotes() {
		$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$note = Input::get('note');
		$skill = Input::get('skill');
		$authuser = Auth::user();
		if($authuser->role_id == 10)
		{
			 $candidateInfo = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', notes='".$note."',skills='".$skill."',accountmanager_id='".$authuser->id."'");
		}
		else if($authuser->role_id == 5)
		{
			$candidateInfo = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', notes='".$note."',skills='".$skill."',employer_id='".$authuser->id."'");
		}
		else if($authuser->role_id == 6)
		{
			$candidateInfo = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', notes='".$note."',skills='".$skill."',vendor_id='".$authuser->id."'");
		}
		return response()->success(compact('candidateInfo'));				
	}

	public function postCandidatematchskills()
	{
		$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$authuser = Auth::user();
		if($authuser->role_id == 10)
		{
			$candidatematchskills = DB::table('candidate_interview_notes')->where('candidate_id',$candidate_id)->where('job_id',$job_id)->where('accountmanager_id',$authuser->id)->get();
		}
		else if($authuser->role_id == 5)
		{
			$candidatematchskills = DB::table('candidate_interview_notes')->where('candidate_id',$candidate_id)->where('job_id',$job_id)->where('employer_id',$authuser->id)->get();
		}
		else if($authuser->role_id == 6)
		{
			$candidatematchskills = DB::table('candidate_interview_notes')->where('candidate_id',$candidate_id)->where('job_id',$job_id)->where('vendor_id',$authuser->id)->get();
		}
		
		return response()->success(compact('candidatematchskills'));
	}
	public function getCandidateinterviewnotes() {
		$job_id = Input::get('job_id');
		
		$candidateInfo = DB::table('candidate_interview_notes')
						->where('job_id', $job_id)
						->get();
		return response()->success(compact('candidateInfo'));				
	}

	 public function postProfilepic()
    {   
        $authuser = Auth::user();
        $files = Input::file('file');
        $job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
        //print_r($files) ; exit;
        if ( Input::hasFile('file') && count($files) == 1)
        {
            $file_name = $files[0]->getClientOriginalName();
            $file_type = $files[0]->getmimeType();
            $path = base_path()."/public/user_assets/candidate_pic/".$authuser->id;
            $destinationPath = 'user_assets/candidate_pic/'.$authuser->id;
            $url = "/user_assets/candidate_pic/".$authuser->id;
            $files[0]->move($destinationPath, $files[0]->getClientOriginalName());
            $userData = ['path' => $path,'file_name'=>$file_name];
            if($authuser->role_id == 10)
            {
            $candidatedata = DB::table('candidate_interview_notes')->where('accountmanager_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->count();
            if($candidatedata != 0)
            {
            	$affectedRows = DB::table('candidate_interview_notes')->where('accountmanager_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->update($userData);
            }
            else{
            	$affectedRows = DB::insert("insert into candidate_interview_notes set candidate_id='".$candidate_id."', accountmanager_id='".$authuser->id."', job_id='".$job_id."', path='".$path."', file_name='".$file_name."'");
            }
            
       		}
       		 else if($authuser->role_id == 5)
       		 {
       		   $candidatedata = DB::table('candidate_interview_notes')->where('employer_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->count();

            if($candidatedata != 0)
            {
            	$affectedRows = DB::table('candidate_interview_notes')->where('employer_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->update($userData);
            }
            else{
            	$affectedRows = DB::insert("insert into candidate_interview_notes set candidate_id='".$candidate_id."', employer_id='".$authuser->id."', job_id='".$job_id."', path='".$path."', file_name='".$file_name."'");
            }
       		}
       		 else if($authuser->role_id == 6)
       		 {
       		  $candidatedata = DB::table('candidate_interview_notes')->where('vendor_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->count();

            if($candidatedata != 0)
            {
            	$affectedRows = DB::table('candidate_interview_notes')->where('vendor_id', '=', intval($authuser->id))->where('job_id', '=', $job_id)->where('candidate_id', '=', $candidate_id)->update($userData);
            }
            else{
            	$affectedRows = DB::insert("insert into candidate_interview_notes set candidate_id='".$candidate_id."', vendor_id='".$authuser->id."', job_id='".$job_id."', path='".$path."', file_name='".$file_name."'");
            }	
       		}
            if($affectedRows == 1){
               /* $assetId = $assets_create->id;*/
                $candidateResumePostIn = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Saved Uploaded profile pic in private drive.',
                ]);
                $Profileupload =  response()->success('Image submitted successfully');
                return $Profileupload;
            }
            else{
                $Profileupload =  response()->success('Profile Not submitted please try again');
                return $Profileupload;
            }

        }
        else
        {
            return response()->error("Image Not Found Please Try Again.");
        }
    }

    public function postCommentspopup()
    {
    	$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$interview_notes = Input::get('interview_notes');
		$authuser = Auth::user();
		if($authuser->role_id == 10)
		{
			 $commentspopup = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', interview_notes='".$interview_notes."',accountmanager_id='".$authuser->id."'");
		}
		else if($authuser->role_id == 5)
		{
			 $commentspopup = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', interview_notes='".$interview_notes."',employer_id='".$authuser->id."'");
		}
		else if($authuser->role_id == 6)
		{
			 $commentspopup = DB::insert("insert into candidate_interview_notes set job_id='".$job_id."', candidate_id='".$candidate_id."', interview_notes='".$interview_notes."',vendor_id='".$authuser->id."'");
		}
		return response()->success(compact('commentspopup'));
    }
	public function getAllcandidates($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id', $id)
            ->whereNotNull('accountmanager_id')
            ->whereNull('candidate_id')
            ->whereNull('vendor_id')
            ->first()->accountmanager_id;      
        $candidates = Association::where('job_id', $id)
            ->where('candidate_status', '<>', 19)
            ->whereNotNull('accountmanager_id')
            ->whereNotNull('candidate_id')
            ->whereNotNull('employer_id')
            ->whereNotNull('vendor_id')
            ->whereNull('vendor_user_id')
            ->with(array('Status', 'Candidate'))
            ->get();
        $empCompanyID = Company::select('timezone')->where('id', $authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $empCompanyID[0]->timezone)->get();
        $associationsIds = array();
        foreach ($candidates as $candidate) {
            if (!($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            } else if (!($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId)) {
                array_push($associationsIds, $candidate->id);
            }
            /*echo '<pre>'; print_r(date_format($candidate['candidate']['updated_at'], 'Y-m-d H:i:s')); echo '</pre>';*/

            $date = new \DateTime($candidate->candidate->updated_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            //$date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate->candidate->updated_at = $date->format('Y-m-d H:i:s');
            $candidate->candidate->timezoneName = $empTimezone[0]['timezone'];
            //$candidate->timezone = $empTimezone[0]['GMT_offset'];
        }
        //print_r($vendorCompanyID);
        $activityes = Activity::where('activity_by', $amId)->where('job_id', $id)->whereIn('candidate_status', array(1, 2))->get();
        $activityData = array();
        foreach ($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $allcandidates = Association::whereIn('id', $associationsIds)->whereNotIn('candidate_id', $activityData)
            ->with(array('Status', 'Candidate', 'job', 'candidate.candidate_operational_skill', 'candidate.educations', 'CandidateSkills', 'CandidateOperationalSkills', 'CandidateSkillsets', 'CandidateSoftSkills'))->with('CandidatePoints', 'vendor', 'vendor.company')->with('CandidateDetails')
            ->with(['candidate.experiences' => function ($query) {
                return $query;
            }])
            ->whereHas('CandidatePoints', function ($query) use ($id) {
                $query->where('job_id', '=', $id);
            })->get();
		$jobInfo = DB::table('job_orders')->where('id',$id)->get();
		
        foreach ($allcandidates as $ky => $job) {
            $Rchilcntl = new RchilliController();
            $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($job['candidate_id']);
            $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($job['candidate_id']);
            if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
                foreach($candidateTalentMine as $tkey =>$tvalue){
                    $note_name[1] = $job['Candidate']['full_name'];
                    $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
                    $candidateTalentMine[$tkey]['description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $tvalue['description']);
                }
            }
            $job['talentmoning'] = $candidateTalentMine;
            $job['candidateSpectrum'] = $candidateSpectrum;
            $skils_block = SkillblockResume::where('candidate_id', $job['candidate_id'])->whereNotIn('found_id', [3,2])->get();
            $job['skils_block'] = $skils_block;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $id);
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
            $numbers = ['encrypted_jobId' => $encrypted, 'encrypted_canId' => $encrypted_canId, 'encrypted_canStatus' => $encrypted_statusid];
            $job['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $job['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $job['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $job['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $job['CandidateSoftSkills']['soft_skills']);
            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
            foreach ($mergedCandidateSkills as $key => $item) {
                $candidateSkills[$key] = trim(strtolower($item));
            }
            $job_skills_preferred = explode(',', $job['job']['skills_preferred']);
            $job_skills_required = explode(',', $job['job']['skills_required']);
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            foreach ($mergedJobSkills as $key => $item) {
                $jobSkills[$key] = trim(strtolower($item));
            }
            $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
            $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);
            $i = 0;
            $obj = new \stdClass;
            foreach ($mached_skills_preferred as $item) {
                $obj->$i = (object)array($item);
                $i++;
            }
            $j = 0;
            $obj2 = new \stdClass;
            foreach ($mached_skills_preferred2 as $item2) {
                $obj2->$j = (object)array($item2);
                $j++;
            }
            $job['marge_skills'] = $obj;
            $job['marge_skills2'] = $obj2;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                ->where('candidate_id', $job['candidate_id'])
                ->select('note_description')->get()->toArray();
				
			if($jobInfo[0]->blindhire==1 && $job['Candidate']['mask']==1) {
				if(is_array($candidatenotes) && count($candidatenotes)>0) {
					foreach($candidatenotes as $keys => $notes) {
						
						$note_name = str_word_count($notes['note_description'],1);	
						$note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4); 
						$notes['note_description'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $notes['note_description']);
						
						$pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
						preg_match_all($pattern, $notes['note_description'], $matches);
						
						$mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6); 
						$notes['note_description'] = preg_replace('/'.$matches[0][0].'/', $mask_email, $notes['note_description']);
						
						$phonePattern ='/[0-9]{3}[\-][0-9]{6}|[0-9]{3}[\s][0-9]{6}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{4}/';
						preg_match_all($phonePattern, $notes['note_description'], $phonematches);
                        if(!empty($phonematches[0][0])){
                            $phone_matches =$phonematches[0][0];
                        }else{
                            $phone_matches='0'; 
                        }
						
						$mask_phone = substr_replace($phone_matches, str_repeat("x", strlen($phone_matches)), 2, strlen($phone_matches)-3); 
						$notes['note_description'] = preg_replace('/'.$phone_matches.'/', $mask_phone, $notes['note_description']);
						$candidatenotes[$keys]['note_description'] =$notes['note_description'];
					}
				}
		 	}
            $job['vendorcandidatenotes'] = $candidatenotes;
            $date = new \DateTime($job['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');
            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $job['updated_at'] = $date->format('Y-m-d H:i:s');
            $job['timezone'] = $empTimezone[0]['GMT_offset'];
            //echo $job->vendor_id;
            $vendorID = User::where('id', $job->vendor_id)->with('company')->get();
            //echo '<pre>'; print_r($vendorID); echo '</pre>';
            $vendorTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id', $vendorID[0]->company->timezone)->get();
            $job['vendorTimezone'] = $vendorTimezone[0]['timezone'];
            $job['vendorTimezoneOffset'] = $vendorTimezone[0]['GMT_offset'];
        }
		$allcandidates = $allcandidates->toArray();
		foreach($allcandidates as $ky => $value) {
			if($jobInfo[0]->blindhire==1 && $value['candidate']['mask']==1) {
				
				$allcandidates[$ky]['candidate']['full_name'] = substr_replace($value['candidate']['full_name'], str_repeat("X", strlen($value['candidate']['full_name'])), 2, strlen($value['candidate']['full_name'])-4);
                $phonePattern ='/[0-9\.]{3}[0-9]{1}|[0-9\.]{1}[0-9]{1}/';
                preg_match_all($phonePattern, $value['candidate']['executive_summary'], $notename);
                $allcandidates[$ky]['candidate']['email'] = substr_replace($value['candidate']['email'], str_repeat("X", strlen($value['candidate']['email'])), 2, strlen($value['candidate']['email'])-4);
                $allcandidates[$ky]['candidate']['phone'] = substr_replace($value['candidate']['phone'], str_repeat("X", strlen($value['candidate']['phone'])), 2, strlen($value['candidate']['phone'])-4);
                /*$note_name_mask = substr_replace($notename[0][0], str_repeat("X", strlen($notename[0][0])), 0, strlen($notename[0][0])-0); 
                $value['candidate']['executive_summary'] = preg_replace('/'.$notename[0][0].'/', $note_name_mask, $value['candidate']['executive_summary']);*/
                $note_name[1] = $value['candidate']['first_name'];
                $note_name_mask = substr_replace($note_name[1], str_repeat("X", strlen($note_name[1])), 2, strlen($note_name[1])-4);
                $allcandidates[$ky]['candidate']['executive_summary'] = preg_replace('/'.$note_name[1].'/', $note_name_mask, $value['candidate']['executive_summary']); 
			}
		}
		//print_r($allcandidates);exit;
        return response()->success(compact('allcandidates'));
    }

    public function postGetskillmatch()
    {
    	$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$authuser = Auth::user();
		
			 $getskillmatch = DB::table('candidate_interview_notes')->where('job_id',$job_id)->where('candidate_id',$candidate_id)->whereNotNull('skills')->whereNotNull('notes')->get();
		return response()->success(compact('getskillmatch'));

    }

    public function postGetinterviewdata()
    {
    	$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$authuser = Auth::user();
			 $getinterviewdata = DB::table('candidate_interview_notes')->where('job_id',$job_id)->where('candidate_id',$candidate_id)->whereNotNull('interview_notes')->get();
		return response()->success(compact('getinterviewdata'));

    }
	public function getCovernotes() {
		
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		
		$coverInfo = DB::select("select * from cover_notes where job_id='".$job_id."' and candidate_id='".$candidate_id."'");
		return response()->success(compact('coverInfo'));
	}
	public function postCovernotes() {
       
        $candidate_id = Input::get('candidate_id');
        $job_id = Input::get('job_id');
        $coverInfoCheck = DB::select("select * from cover_notes where job_id='".$job_id."' and candidate_id='".$candidate_id."'");
       
        $name = Input::get('name');
        $experience = Input::get('experience');
        $skill = Input::get('skill');
        $abc = $skill[0];
        $current_salary = Input::get('current_salary');
        $expected_salary = Input::get('expected_salary');
        $previous_company  = Input::get('previous_company');
        $present_company  = Input::get('present_company');
        $serving_notice = Input::get('serving_notice');
        $notice_period = Input::get('notice_period');
        $willing_to_relocate = Input::get('willing_to_relocate');
        $any_offers = Input::get('any_offers');
        $willing_to_travel = Input::get('willing_to_travel');
        $career_gaps = Input::get('career_gaps');
        $planned_vacation = Input::get('planned_vacation');
       
        $work_from_office = Input::get('work_from_office');
        $work_from_home = Input::get('work_from_home');
        $education = Input::get('education');
        $location = Input::get('location');
        $note = Input::get('note');
        $currency = Input::get('currency');
        	//print_r($skill); exit;
        if(is_array($skill)) {
        	foreach($skill as $key=>$value) {
        	 $skills[] = $value['text'];
        	}
        }
        $cover_details = array( 'name'=>$name,
                                'experience'=>$experience,
                                'skill' =>implode(',',$skills),
                                'current_salary'=>$current_salary,
                                'expected_salary' =>$expected_salary,
                                'previous_company'=>$previous_company,
                                'present_company'=>$present_company,
                                'serving_notice' => $serving_notice,
                                'notice_period' =>$notice_period,
                                'willing_to_relocate'=>$willing_to_relocate,
                                'any_offers'=>$any_offers,
                                'willing_to_travel'=>$willing_to_travel,
                                'career_gaps' =>$career_gaps,
                                'planned_vacation' =>$planned_vacation,
                                'work_from_office' =>$work_from_office,
                                'work_from_home' =>$work_from_home,
                                'education' =>$education,
                                'location' =>$location,
                                'note' =>$note,
                                'currency' =>$currency,
                                'created_at'=>date('Y-m-d h:i:s'),
                                'updated_at'=>date('Y-m-d h:i:s')
                         );
        if(is_array($coverInfoCheck) && count($coverInfoCheck)>0) {
            $affectedRows = DB::table('cover_notes')
            ->where('candidate_id', '=', $candidate_id)
            ->where('job_id', $job_id)
            ->update($cover_details);
            $success="Cover note updated successfully.";
        } else {
            $cover_details['candidate_id'] = $candidate_id;
            $cover_details['job_id'] = $job_id;
            DB::table('cover_notes')->insert($cover_details);
            $success="Cover note inserted successfully.";
        }
       
        return response()->success(compact('success'));
    }
	public function postFetchcomment() {
        $job_id = Input::get('job_id');
        $candidate_id = Input::get('candidate');
        if(!empty($job_id)) {
            $jobInfo = DB::select("select name from job_orders where id='".$job_id."'");
        }
        if(!empty($candidate_id)) {
            $canInfo = DB::select("select full_name as name from candidates where id='".$candidate_id."'");
        }
        $jobname = $jobInfo[0]->name;
        $candidatename = $canInfo[0]->name; 
        $shortlist[2]['name'] = "Shortlisted";
        $rejected[3]['name'] = "Rejected";
        $duplicate[4]['name'] = "Duplicate";
        $shorlistedname[5]['name'] =  "".$candidatename. " is Shortlisted for ".$jobname;
        $rejectedname[6]['name'] =   "".$candidatename. " is Rejected for ".$jobname; 
        $duplicatename[7]['name'] =  "".$candidatename. " is Duplicate for ".$jobname; 
        $commentInfo['name'] = array_merge($canInfo,$shortlist,$jobInfo,$rejected,$duplicate,$shorlistedname,$rejectedname,$duplicatename);
        return response()->success(compact('commentInfo'));
    }
    public function postCandiatesdetailsnote() {
        $candidate_id = Input::get('candidate_id');
        $job_id = Input::get('job_id');
       
        $candidateInfo = DB::table('candidates as c')
                            ->select('c.full_name','c.total_experience_in_year','vcn.present_location', 'vcn.present_salary','vcn.expected_salary', 'vcn.notice_period', 'ce.degree','cs.skills')
                            ->leftjoin('candidate_educations as ce', 'ce.candidate_id', '=', 'c.id')
                            ->leftjoin('candidate_skills as cs', 'cs.candidate_id', '=', 'c.id')
                            ->leftjoin('vendor_candidate_notes as vcn', 'vcn.candidate_id', '=', 'c.id')
                            ->where('c.id', $candidate_id)
                            ->get();

          $job = JobOrders::select('currency')->where('id',$job_id)->first()->toArray(); 
    
        $candidateData = array();
        foreach($candidateInfo as $key=>$value){
           
            $candExp = DB::select("select * from candidate_experiences where candidate_id='".$candidate_id."'");
           
            if($candExp[0]->is_current_employer==1) {
                $value->present_company = $candExp[0]->employer_name;
            } else if($candExp[0]->is_current_employer==0) {
                $value->previous_company = $candExp[0]->employer_name;
            }
            $value->total_experience = $candExp[0]->total_experienceIn_months;
            $value->willing_to_relocate = 'yes';
            $value->willing_to_travel = 'yes';
            $value->career_gaps = 'yes';
            $value->planned_vacation = 'yes';
            $value->work_from_home = 'yes';
            $value->work_from_office = 'yes';
            $candidateData[] = $value;
        }
        return response()->success(compact('candidateData','job'));
    }

    public function getAllemployerdetails()
    {
    	$allemployerdetails = User::select('id','first_name','last_name','email','mobile','country_code','company_id')->where('role_id', 5)->whereNull("parent_id")->orderBy('first_name', 'asc')->get();
    	$i =0;
    	$j = 0;
    	$k= 0;
    	foreach ($allemployerdetails as  $value) {
    	$empjobs[] = JobOrders::select('id', DB::raw('count(*) as number_of_profiles'))->where('user_id',$value->id)->where('is_talentpool',0)->count();    	
        $empCompanyID = Company::select('timezone')->where('id',$value->company_id)->get();
        $timezone[] = Country::select('GMT_offset')->where('id',$empCompanyID[0]->timezone)->first();
        if(isset($timezone))
        {
        $value->GMT_offset = $timezone[$k++];
        }
        $lastlogintime[] = DB::table("activities as a")
                  ->select('a.updated_at')
                  ->join('users as u', 'u.id', '=', 'a.person_id')
                  ->where('a.person_id',$value->id)
                  ->where('u.role_id', 5)
                  ->orderBy('a.id', 'desc')
                  ->first();
        $value->time = $lastlogintime[$j++]; 
        $value->no_of_job =  $empjobs[$i++];
    	}
        return response()->success(compact('allemployerdetails'));
    }

     public function getAllvendordetails()
    {
        $allvendordetails = User::select('id','first_name','last_name','email','mobile','country_code','company_id')->where('role_id', 6)->whereNull('parent_id')->orderBy('first_name', 'asc')->get();
        $i =0;
    	$j = 0;
    	$k= 0;
    	foreach ($allvendordetails as  $value) {
    	 $venjobs[]=Association::select('id', DB::raw('count(*) as number_of_profiles'))->where('vendor_id',$value->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->count();

        $venCompanyID = Company::select('timezone')->where('id',$value->company_id)->get();
        $timezone[] = Country::select('GMT_offset')->where('id',$venCompanyID[0]->timezone)->first();
        if(isset($timezone))
        {
        $value->GMT_offset = $timezone[$k++];
        }
        $lastlogintime[] = DB::table("activities as a")
                  ->select('a.updated_at')
                  ->join('users as u', 'u.id', '=', 'a.person_id')
                  ->where('a.person_id',$value->id)
                  ->where('u.role_id', 6)
                  ->orderBy('a.id', 'desc')
                  ->first();
        $value->time = $lastlogintime[$j++]; 
        $value->no_of_job =  $venjobs[$i++];
    	}
        return response()->success(compact('allvendordetails'));
    }
    public function postCovernotesinfo() {
       
        $candidate_id = Input::get('candidate_id');
        $job_id = Input::get('job_id');
       
        $covernotesinfo = DB::select("select * from cover_notes where job_id='".$job_id."' and candidate_id='".$candidate_id."'");
        return response()->success(compact('covernotesinfo'));
    }
    public function postPredectivetxet() {
        $job_id = Input::get('jobid');
        $candidate_id = Input::get('candidate_id');
       $jobinfo = JobOrders::select('name')->where('id', $job_id)->get()->toArray();
        $predectInfo = DB::select("select * from predective_analysis where Title='".$jobinfo[0]['name']."'");
       
        if(is_array($predectInfo) && count($predectInfo)==0) {
            $textArr = explode(" ", $jobinfo[0]['name']);
            if(is_array($textArr) && count($textArr)>0) {
                foreach($textArr as $key=> $serachText) {
                    if(strlen($serachText)>3) {
                        $predectData = DB::select("select * from predective_analysis where Title like '".trim($serachText)."%'");
                       
                        if(is_array($predectData) && count($predectData)>0) {
                            foreach($predectData as $ky=>$val) {
                               
                                $predectInfo[] = str_replace($serachText,'', $val->Task);
                            }
                        }
                    }
                }
            }
        }
        return response()->success(compact('predectInfo'));
    }
}
