<?php

namespace App\Http\Controllers;
use DB;
use App\User;
use Auth;
use TCPDF;
use App\JobOrders;
use GuzzleHttp\Client;
use App\JobType;
use App\JobCitys;
use App\Activity;
use App\EmployerUserJobs;
use App\VendorUserJob;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Input;
use DateTime;
use DateInterval;
use App\VendorActivities;
use App\JobUsers;
use App\JobResumes;
use App\Candidate;
use App\CandidateSkillsets;
use App\CandidateOperationalSkills;
use App\CandidateSkills;
use App\CandidateExperiences;
use App\BellNotifications;
use App\CandidatePoints;
use App\CandidateEducations;
use App\CandidateSoftSkills;
use App\Company;
use App\JobSkills;
use App\Jobtitle;
use App\GdprData;
use App\City;
use App\Country;
use App\Association;
use App\Reason;
use App\Status;
use App\Industry;
use App\Language;
use App\JobLanguage;
use App\Pricing;
use App\EducationQualification;
use App\EducationAssociations;
use App\VendorRevenue;
use App\VendorRevenueRule;
use App\SharableUrls;
use App\VendorUserSetting;
use App\ShareLinkActivitys;
use Mail;
use Carbon\Carbon;
use App\VendorCandidateNotes;
use App\ReferFriends;
use App\DeviationRequests;
use App\Employeespectrums;
use App\CompaniesEmployer;
use App\SoftSkills;
use App\Colors;
use App\CollageNames;
use App\ActionWords;
use App\Http\Controllers\RchilliController;
use App\Models\SkillblockResume;
use App\Models\CandidateDetails;
// use Illuminate\Support\Facades\Http;
use App\Predefinedquestionsanswers;
use App\Models\JobOrdersQuestionAnswer;
use Cache;

class JobsOrdersController extends Controller
{
    const KENDU_API_KEY = '6058e1584cc3a95e164d6d07';
    const CUSTOM_SEARCH_ENGINE_API_KEY = 'AIzaSyAt5fxQ5H9Nl7J9dnwyj4HvPZadftfhuJM';
    const CUSTOM_SEARCH_CX = '125b2a09162254306';

     public function postCheckprofilevalidity()
    {
        //Getting Present Logged in User Details
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId = $authuser->parent_id;}
        else {$authId = $authuser->id;}
        //Getting Job Id from URL
        $job_id = Input::get('jobs');
        //Getting No of Vacancies available for the job from URL
        $vacancies=Input::get('positions');
        //Getting Candidate Id from URL
        $candidate_id = Input::get('candidateId');

        //Getting Joborder Data and filtering procedure
        $jobskills = JobOrders::where('id',$job_id)->get();
        //Job Title spliting for search in skills of candidate
        $job_title= !empty($jobskills[0]['name'])?$jobskills[0]['name']:'';

        //Filtering Prefered Skills From JD
        $prefered_skills= !empty($jobskills[0]['skills_preferred'])?$jobskills[0]['skills_preferred']:'';
        $prefered_skills = str_replace(",", " ", $prefered_skills);
        $prefered_skills = str_replace(" ,", " ", $prefered_skills);
        $prefered_skills = str_replace(", ", " ", $prefered_skills);
        $prefered_skills = str_replace("-", " ", $prefered_skills);
        $prefered_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $prefered_skills));
        //Creating array
        $prefered_skills = explode(" ", $prefered_skills);
        //Fitered Data after removing duplicates
        $prefered_skills = array_unique($prefered_skills);
        //Fitered Data after removing Empty keys
        $prefered_skills = array_filter($prefered_skills);
        //Max weightage calculatin
        if(count($prefered_skills) != 0){
        $max_weightage= (100/count($prefered_skills));
        }
        $pref_skills_count=sizeof($prefered_skills);

        //Filtering required Skills From JD
        $required_skills= !empty($jobskills[0]['skills_required'])?$jobskills[0]['skills_required']:'';
        $required_skills = str_replace(",", " ", $required_skills);
        $required_skills = str_replace(" ,", " ", $required_skills);
        $required_skills = str_replace(", ", " ", $required_skills);
        $required_skills = str_replace("-", " ", $required_skills);
        $required_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $required_skills));
        //Creating array
        $required_skills = explode(" ", $required_skills);
        //Fitered Data after removing duplicates
        $required_skills = array_unique($required_skills);
        //Fitered Data after removing Empty keys
        $required_skills = array_filter($required_skills);
        //Max weigtage for req skills
        if(count($required_skills) != 0){
        $max_req_weightage= (100/count($required_skills));
        }
        $req_skills_count=count($required_skills);
        //JD QUALITY Calculation
        $jd_quality_number=$req_skills_count + $pref_skills_count;
        if($jd_quality_number >= 15){
            $jd_quality_status='Very Detailed';
        }elseif ($jd_quality_number >= 9) {
            $jd_quality_status='Detailed';
        }elseif ($jd_quality_number >= 20) {
            $jd_quality_status='Excellent';
        }elseif ($jd_quality_number < 9) {
            $jd_quality_status='Not Detailed';
        }
        //JD Qualifications
        $jobqualifications=EducationAssociations::where('job_id',$job_id)->with('educations')->get();
        $job_qualification = array();
        foreach($jobqualifications as $qlfctions) {
            array_push($job_qualification, $qlfctions->educations->qualification);
        }
        //JobCitys data
        $jobcitys=JobCitys::where('job_id',$job_id)->with('citys')->get();

        $job_city = array();
        foreach($jobcitys as $j_citys) {
            array_push($job_city, $j_citys->citys->name);
        }
      
        //Job Qualification data
        $job_edu_sets = EducationAssociations::where('job_id',$job_id)->with("educations")->get();
         $job_edu_deatils = array();
        foreach($job_edu_sets as $j_edu) {
            array_push($job_edu_deatils, $j_edu->educations->qualification);
        }

        //All candidate_skill_sets
        $candidate_skill_sets = CandidateSkillsets::where('candidate_id',$candidate_id)->get();
        $candidate_skill_sets = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_skill_sets));
        $candidate_skill_sets = str_replace(",", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace(" ,", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace(", ", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace("-", " ", $candidate_skill_sets);
        //Creating array
        $candidate_skill_sets = explode(" ", $candidate_skill_sets);
         //Fitered Data after removing duplicates
        $candidate_skill_sets = array_unique($candidate_skill_sets);
        //Fitered Data after removing Empty keys
        $candidate_skill_sets = array_filter($candidate_skill_sets);
        //Getting Candidate Operational Skills
        $candidate_operational_skills = CandidateOperationalSkills::where('candidate_id',$candidate_id)->get(['operational_skills']);

        //Getting Candidate Skills
        $candidate_skills = CandidateSkills::where('candidate_id',$candidate_id)->get(['skills']);
        //Getting Candidate Summary
        $candidate_summarys = Candidate::where('id',$candidate_id)->get(['full_name','email','job_profile','city','summary','executive_summary','management_summary','objectives','preferred_location','total_experience_in_year','qualification']);
        if(!empty($candidate_summarys[0]['total_experience_in_year']) && isset($candidate_summarys[0]['total_experience_in_year'])){
        $candidateExp=$candidate_summarys[0]['total_experience_in_year'];
        }else{
            $candidateExp = '';
        }

        //Getting Candidate Quaification
        $candidate_qualif=CandidateEducations::where('candidate_id',$candidate_id)->get(['degree']);
        $candidate_qualification = array();
            foreach($candidate_qualif as $can_qlfctions) {
                array_push($candidate_qualification, $can_qlfctions['degree']);
            }
        //Getting Candidate Experiences
        $candidate_titles=CandidateExperiences::where('candidate_id',$candidate_id)->get(['job_title']);
        $candidate_title_data = array();
            foreach($candidate_titles as $can_titls) {
                array_push($candidate_title_data, $can_titls['job_title']);
            }

        //Getting candidate summery Data
        $candidate_summary_data = !empty($candidate_summarys[0]['summary'])?$candidate_summarys[0]['summary']:'';

        //Getting executive summery Data
        $candidate_executive_summary_data = !empty($candidate_summarys[0]['executive_summary'])?$candidate_summarys[0]['executive_summary']:'';

        //Getting Candidate Preffered Location
        $candidate_prefered= !empty($candidate_summarys[0]['preferred_location'])?$candidate_summarys[0]['preferred_location']:'';
        $candidate_prefered = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_prefered));
        $candidate_prefered = str_replace(",", " ", $candidate_prefered);
        $candidate_prefered = str_replace(" ,", " ", $candidate_prefered);
        $candidate_prefered = str_replace(", ", " ", $candidate_prefered);
        $candidate_prefered = str_replace("-", " ", $candidate_prefered);
        //Creating array
        $candidate_prefered = explode(" ", $candidate_prefered);
         //Fitered Data after removing duplicates
        $candidate_prefered = array_unique($candidate_prefered);
        //Fitered Data after removing Empty keys
        $candidate_prefered = array_filter($candidate_prefered);

        //Filtering Candidate operational_skills Data
        $operational_skills =  !empty($candidate_operational_skills[0]['operational_skills'])?$candidate_operational_skills[0]['operational_skills']:'';
        $operational_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $operational_skills));
        $operational_skills = str_replace(",", " ", $operational_skills);
        $operational_skills = str_replace(" ,", " ", $operational_skills);
        $operational_skills = str_replace(", ", " ", $operational_skills);
        $operational_skills = str_replace("-", " ", $operational_skills);
        //Creating array
        $operational_skills = explode(" ", $operational_skills);
         //Fitered Data after removing duplicates
        $operational_skills = array_unique($operational_skills);
        //Fitered Data after removing Empty keys
        $operational_skills = array_filter($operational_skills);

        //Filtering candidate skills Data
        $candidate_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_skills));
        $candidate_skills = str_replace(",", " ", $candidate_skills);
        $candidate_skills = str_replace(". ", " ", $candidate_skills);
        $candidate_skills = str_replace(".", " ", $candidate_skills);
        $candidate_skills = str_replace(" ,", " ", $candidate_skills);
        $candidate_skills = str_replace(", ", " ", $candidate_skills);
        $candidate_skills = str_replace("-", " ", $candidate_skills);
        //Creating array
        $candidate_skills = explode(" ", $candidate_skills);
         //Fitered Data after removing duplicates
        $candidate_skills = array_unique($candidate_skills);
        //Fitered Data after removing Empty keys
        $candidate_skills = array_filter($candidate_skills);
        
        //Filtering candidate summary Data
        $candidate_summary=$candidate_summary_data;
        $candidate_summary = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_summary));
        $candidate_summary = str_replace(",", " ", $candidate_summary);
        $candidate_summary = str_replace(". ", " ", $candidate_summary);
        $candidate_summary = str_replace(".", " ", $candidate_summary);
        $candidate_summary = str_replace(" ,", " ", $candidate_summary);
        $candidate_summary = str_replace(", ", " ", $candidate_summary);
        $candidate_summary = str_replace("-", " ", $candidate_summary);
        //Creating array
        $candidate_summary = explode(" ", $candidate_summary);
         //Fitered Data after removing duplicates
        $candidate_summary = array_unique($candidate_summary);
        //Fitered Data after removing Empty keys
        $candidate_summary = array_filter($candidate_summary);
        //Filtering candidate executive summary_data Data
        $candidate_exe_summary=$candidate_executive_summary_data;
        $candidate_exe_summary = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_exe_summary));
        $candidate_exe_summary = str_replace(",", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(". ", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(".", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(" ,", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(", ", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace("-", " ", $candidate_exe_summary);
        //Creating array
        $candidate_exe_summary = explode(" ", $candidate_exe_summary);
         //Fitered Data after removing duplicates
        $candidate_exe_summary = array_unique($candidate_exe_summary);
        //Fitered Data after removing Empty keys
        $candidate_exe_summary = array_filter($candidate_exe_summary);
        //Filtering candidate Objective Data
        $candidate_objectives = !empty($candidate_summarys[0]['objectives'])?$candidate_summarys[0]['objectives']:'';
        $candidate_objectives = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_objectives));
        $candidate_objectives = str_replace(",", " ", $candidate_objectives);
        $candidate_objectives = str_replace(". ", " ", $candidate_objectives);
        $candidate_objectives = str_replace(".", " ", $candidate_objectives);
        $candidate_objectives = str_replace(" ,", " ", $candidate_objectives);
        $candidate_objectives = str_replace(", ", " ", $candidate_objectives);
        $candidate_objectives = str_replace("-", " ", $candidate_objectives);
        //Creating array
        $candidate_objectives = explode(" ", $candidate_objectives);
         //Fitered Data after removing duplicates
        $candidate_objectives = array_unique($candidate_objectives);
        //Fitered Data after removing Empty keys
        $candidate_objectives = array_filter($candidate_objectives);
        $lst_count = array();
        $lst_count_req = array();
        $a=0;
             reset($required_skills);
             foreach($required_skills as $key=>$val){
            $weigtage_req=0;
            $req_opr_skills=0;
            $req_can_skills=0;
            $req_summ_skills=0;
            $req_objective_skills=0;
            $req_exe_summary_skills=0;
            $req_skill_value=$val;
            $req_skill_key=$key;
             if(count($operational_skills) > 0) {
             reset($operational_skills);
             foreach($operational_skills as $key=>$val){
                    $operational_skill_value=$val;
                    $operational_skill_key=$key;
                    if(strcasecmp($operational_skill_value,$req_skill_value)==0 ||
                         strcasecmp($req_skill_value,$operational_skill_value)==0)
                    {
                        $req_opr_skills=1;
                    }
                }
            }
             foreach($candidate_skills as $key=>$val){
                $candidate_skill_value=$val;
                $candidate_skill_key=$key;
                if(strcasecmp($candidate_skill_value,$req_skill_value)==0 ||
                  strcasecmp($req_skill_value,$candidate_skill_value)==0)
                {
                 $req_can_skills=1;

                }
            }
            reset($candidate_summary);

            foreach($candidate_summary as $key=>$val){
                $candidate_summary_value=$val;
                $candidate_summary_key=$key;
                if(strcasecmp($candidate_summary_value,$req_skill_value)==0 ||
                  strcasecmp($req_skill_value,$candidate_summary_value)==0)
                {
                   $req_summ_skills=1;

                }
            }
            if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                reset($candidate_exe_summary);
                foreach($candidate_exe_summary as $key=>$val)
                {
                    $candidate_exe_summary_value=$val;
                    $candidate_exe_summary_key=$key;
                if(strcasecmp($candidate_exe_summary_value,$req_skill_value) ==0 || strcasecmp($req_skill_value,$candidate_exe_summary_value) == 0)
                    {
                        $req_exe_summary_skills=1;
                    }
                }
            }
            if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                reset($candidate_objectives);
                foreach($candidate_objectives as $key=>$val)
                {
                    $candidate_objectives_value=$val;
                    $candidate_objectives_key=$key;
                    if(strcasecmp($candidate_objectives_value,$req_skill_value)==0 ||
                      strcasecmp($req_skill_value,$candidate_objectives_value)==0)
                    {
                        $req_objective_skills=1;
                    }
                }
            }

            if($req_opr_skills ==1 && $req_can_skills == 1 && $req_summ_skills ==1)
            {
                $weigtage_req=$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 1 && $req_summ_skills ==1)
            {
                $weigtage_req=(75/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==1)
            {
                $weigtage_req=(50/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 1 && $req_summ_skills ==0)
            {
                $weigtage_req=(50/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                $weigtage_req=(85/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 0 && $req_summ_skills ==1)
            {
                $weigtage_req=(93/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 1 && $req_summ_skills ==0)
            {
                $weigtage_req=(93/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_objective_skills == 1)
            {
                $weigtage_req=(15/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_exe_summary_skills == 1)
            {
                $weigtage_req=(15/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_exe_summary_skills == 0)
            {
                $weigtage_req="No data found in any of the tables ";
            }else{
                $weigtage_req="Please Contact Admin";
            }

          unset($required_skills[$req_skill_key]);
          $lst_count_req[] = $weigtage_req;
        }
        $required_skills_percentage=array_sum($lst_count_req);
        reset($prefered_skills);
        foreach($prefered_skills as $key=>$val){
            $weigtage=0;
            $pref_opr_skills=0;
            $pref_can_skills=0;
            $pref_summ_skills=0;
            $pref_objective_skills=0;
            $pref_exe_summary_skills=0;
            $prefered_skill_value=$val;
            $prefered_skill_key=$key;
            if(count($operational_skills) > 0) {
                reset($operational_skills);
                foreach($operational_skills as $key=>$val){
                    $operational_skill_value=$val;
                    $operational_skill_key=$key;
                    if(strcasecmp($operational_skill_value,$prefered_skill_value)==0 ||
                         strcasecmp($prefered_skill_value,$operational_skill_value)==0)
                    {
                        $pref_opr_skills=1;
                    }
                }
            }
          
                  foreach($candidate_skills as $key=>$val)
                {
                    $candidate_skill_value=$val;
                    $candidate_skill_key=$key;
                    if(strcasecmp($candidate_skill_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_skill_value)==0)
                    {
                     $pref_can_skills=1;
                    }
                }

                  reset($candidate_summary);
                  foreach($candidate_summary as $key=>$val){
                    $candidate_summary_value=$val;
                    $candidate_summary_key=$key;
                    if(strcasecmp($candidate_summary_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_summary_value)==0)
                    {
                       $pref_summ_skills=1;
                    }
                }
            
            if(count($candidate_exe_summary) > 0 && $pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
                reset($candidate_exe_summary);
                foreach($candidate_exe_summary as $key=>$val)
                {
                    $candidate_exe_summary_value=$val;
                    $candidate_exe_summary_key=$key;
                    if(strcasecmp($candidate_exe_summary_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_exe_summary_value)==0)
                    {
                        $pref_exe_summary_skills=1;
                    }
                }
           }
           if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
                reset($candidate_objectives);
               foreach($candidate_objectives as $key=>$val) 
                {
                    $candidate_objectives_value=$val;
                    $candidate_objectives_key=$key;
                    if(strcasecmp($candidate_objectives_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_objectives_value)==0)
                    {
                        $pref_objective_skills=1;
                    }
                }
           }

           if($pref_opr_skills ==1 && $pref_can_skills == 1 && $pref_summ_skills ==1)
           {
            $weigtage=$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 1 && $pref_summ_skills ==1)
           {
            $weigtage=(75/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==1)
           {
            $weigtage=(50/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 1 && $pref_summ_skills ==0)
           {
            $weigtage=(50/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
            $weigtage=(85/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 0 && $pref_summ_skills ==1)
           {
            $weigtage=(93/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 1 && $pref_summ_skills ==0)
           {
            $weigtage=(93/100)*$max_weightage;
           }
           else if(($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_objective_skills == 1) ||($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_exe_summary_skills == 1))
           {
            $weigtage=(15/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_exe_summary_skills == 0)
           {
            $weigtage="No data found in any of the tables";
           }

          unset($prefered_skills[$prefered_skill_key]);
          $lst_count[] = $weigtage;
        }

        $prefered_skills_percentage=array_sum($lst_count);
        $job_city_match=0;
        if(count($candidate_prefered)!=0){
            foreach($job_city as $key=>$val) {
                $job_city_value=$val;
                reset($candidate_prefered);
                foreach($candidate_prefered as $key=>$val) {
                    $candidate_prefered_value=$val;
                    $candidate_prefered_key=$key;
                    if(strcasecmp($candidate_prefered_value, $job_city_value)==0)
                    {
                        $job_city_match=1;
                    }
                    if(strcasecmp($job_city_value,$candidate_prefered_value)==0)
                    {
                        $job_city_match=1;
                    }
                }
            }
        }

        //After Adding candidate qualification when user submit candidate for Vendor assigned job
        $qualification_point_value=0;
        $qualification_points=0;
        if(count($job_edu_deatils) > 0 ) {
            reset($job_edu_deatils);
             foreach($job_edu_deatils as $key=>$val) {
               $job_edu_deatils_value=$val;
              $job_edu_deatils_key=$key;
              $cand_summary_quali  = !empty($candidate_summarys[0]['qualification'])?$candidate_summarys[0]['qualification']:'';
              if((strcasecmp($job_edu_deatils_value,$cand_summary_quali)== 0 )|| 
                         (strcasecmp($cand_summary_quali,$job_edu_deatils_value)== 0))
                      {

                        $qualification_points=$qualification_points+20;
                      }elseif($qualification_points == 0){
                        $qualification_points=8;

                }
                }
        }
        if($qualification_points >20){
            $qualification_points=20;
        }
        
        //Experiance Points
        if($candidateExp != null || $candidateExp != 0){
            if($jobskills[0]['experience'] <= $candidateExp){
            $exp_match_points=20;
            }else{$exp_match_points=5;}
        }else{
            $exp_match_points=5;
        }

        //Required Skills Points
        if($required_skills_percentage){
            $req_skills_points=0;
            if($required_skills_percentage < 20){
             $req_skills_points=5;
            }elseif ($required_skills_percentage >= 20 && $required_skills_percentage <= 50) {
                $req_skills_points=10;
            }elseif ($required_skills_percentage > 50 && $required_skills_percentage <= 80) {
                $req_skills_points=15;
            }elseif ($required_skills_percentage > 80 && $required_skills_percentage <= 100) {
                $req_skills_points=20;
            }
        }else{$req_skills_points=0;}

        //Preffered City( Location) Points
        if($job_city_match==1){
        $location_match_points=20;
        }else{
            $location_match_points=10;
        }

        //Preffered skills Points
        if($prefered_skills_percentage){
            $pref_skills_points=0;
            if($prefered_skills_percentage < 20){
             $pref_skills_points=5;
            }elseif ($prefered_skills_percentage >= 20 && $prefered_skills_percentage <= 50) {
                $pref_skills_points=10;
            }elseif ($prefered_skills_percentage > 50 && $prefered_skills_percentage <= 80) {
                $pref_skills_points=15;
            }elseif ($prefered_skills_percentage > 80 && $prefered_skills_percentage <= 100) {

                $pref_skills_points=20;
            }
        }
        else{$pref_skills_points=5;}

        //Position Matching Points
        $position_point_value=0;
        $job_title_points=0;
        if(count($candidate_title_data) > 0) {
            reset($candidate_title_data);

            foreach($candidate_title_data as $key=>$val) {
               $candidate_title_data_sets_value=$val;
              $candidate_title_data_sets_key=$key;
                $job_title = strtolower(str_replace( array( " /","*"," *","* ", "/ ","/", '[', "]", " [","[ ","(",")" ), '', $job_title));
                    if(strpos($job_title, $candidate_title_data_sets_value) > 0 || strpos($candidate_title_data_sets_value, $job_title) > 0)
                      {
                        $job_title_points=$job_title_points+20;
                      }
                      if($job_title_points == 0){
                        $job_title_points=10;
                      }
                }
        }else{
               $job_title_points=5;
        }
        if($job_title_points > 20){
           $job_title_points=20;
        }
        $required_skills_points=$req_skills_points;
        $preferred_skills_points=$pref_skills_points;
        $location_points=$location_match_points;
        $position_points=$job_title_points;
        $experience_points=$exp_match_points;

        $total_points=$req_skills_points+$pref_skills_points+$location_match_points+$job_title_points+$exp_match_points+$qualification_points;
        if($total_points >=100 && $total_points <= 120 ){
        //If no of total points are more then 100 but below 120:  Excellent Match
          $over_all_status="Excellent Match";
        }elseif ($total_points <=99 && $total_points >= 70 ) {
        //If no of points are less than or equal 99 but more then 70 : Good Match

          $over_all_status="Good Match";
        }elseif ($total_points <=69 && $total_points >= 50 ) {
        //If no of points is less or equal to 69 or equalling   but less than 50 :  Moderate Match
         $over_all_status="Moderate Match";
        }elseif ($total_points <=49 && $total_points >= 30 ) {
        //If no of points is less or equal 49 or but not less than 30 : Average  Match
        $over_all_status="Average Match";
        }
        elseif ($total_points <=29) {
        //If no of points is less, then or equalling   29:  Poor Match
         $over_all_status="Poor Match";
        }
        $skills_data_array=array($pref_skills_points,$req_skills_points,$location_match_points,$job_title_points,$exp_match_points,$qualification_points);
        $skills_matched  = count( array_keys( $skills_data_array, 20 ));

        $can_edu=!empty($candidate_summarys[0]['qualification'])?$candidate_summarys[0]['qualification']:'';
        $can_skills_count=count($operational_skills);
        $can_name=!empty($candidate_summarys[0]['full_name'])?$candidate_summarys[0]['full_name']:'';
        $can_email=!empty($candidate_summarys[0]['email'])?$candidate_summarys[0]['email']:'';
        $can_title=!empty($candidate_summarys[0]['job_profile'])?$candidate_summarys[0]['job_profile']:'';
        $can_location=!empty($candidate_summarys[0]['city'])?$candidate_summarys[0]['city']:'';
        $can_summary= !empty($candidate_summarys[0]['summary'])?$candidate_summarys[0]['summary']:'';
        $can_exe_summ=!empty($candidate_summarys[0]['executive_summary'])?$candidate_summarys[0]['executive_summary']:'';
        $can_mngmnt_summ=!empty($candidate_summarys[0]['management_summary'])?$candidate_summarys[0]['management_summary']:'';
        
        if($can_edu != '' && $can_skills_count > 10 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && $can_summary != '' && $can_mngmnt_summ != '' && $can_exe_summ != ''){
            $cv_quality ='Excellent';
        }elseif ($can_edu != '' && $can_skills_count > 5 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && ($can_summary != '' || $can_mngmnt_summ != '' || $can_exe_summ != '')) {
            $cv_quality='Moderate';
        }elseif ($can_edu != '' && $can_skills_count > 3 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && ($can_summary != '' || $can_mngmnt_summ != '' || $can_exe_summ != '')) {
           $cv_quality='Fair';
        }else{
            $cv_quality='Poor';
        }

        $candidatepoints = new CandidatePoints();
                            $candidatepoints->job_id = $job_id;
                            $candidatepoints->candidate_id = $candidate_id;
                            $candidatepoints->required_skills_points = $required_skills_points;
                            $candidatepoints->preferred_skills_points = $preferred_skills_points;
                            $candidatepoints->location_points = $location_points;
                            $candidatepoints->experience_points = $experience_points;
                            $candidatepoints->position_points = $position_points;
                            $candidatepoints->qualification_points = $qualification_points;
                            $candidatepoints->total_points = $total_points;
                            $candidatepoints->over_all_status = $over_all_status;
                            $candidatepoints->jd_required_skills_count=$req_skills_count;
                            $candidatepoints->jd_preferred_skills_count=$pref_skills_count;
                            $candidatepoints->jd_all_skills_count=$jd_quality_number;
                            $candidatepoints->jd_quality_status=$jd_quality_status;
                            //$candidatepoints->cv_quality_status=$cv_quality;
        $candidatepoints->save();
        $employer_id = JobOrders::where('id',$job_id)->first()->user_id;
        $accountmanager_id = Association::where('vendor_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->where('employer_id',$employer_id)
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->where('job_id',$job_id)
                                    ->whereNull('candidate_id')
                                    ->first()->accountmanager_id;

        $assignedJob= association::where('vendor_id',$authId)
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('employer_id',$employer_id)
                                    ->where('job_id',$job_id)
                                    ->where('candidate_id',$candidate_id)
                                    ->count();
          return response()->success(compact('assignedJob'));
    }

    public function postSubmitcandidatesuserlist()
    {
        $authuser = Auth::user();
        $job_id = Input::get('jobs');
        $vacancies=Input::get('positions');
        $candidate_id = Input::get('candidateId');
        $employer_id = JobOrders::where('id',$job_id)->first()->user_id;

        $accountmanager_id = Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;

         $assignedJob= association::where('vendor_id',$authuser->parent_id)
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            ->where('candidate_id',$candidate_id)
                            ->count();
         $countResumes= association::where('vendor_id',$authuser->parent_id)
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            /*->where('job_id',$job_id)*/
                            ->whereNotNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->count();


                       $a= (int)$vacancies;
        if($countResumes<($a * 3)) {
            if($assignedJob==0) {
                    $candidateassociation = new Association();
                    $candidateassociation->admin_id = 1;
                    $candidateassociation->accountmanager_id = $accountmanager_id;
                    $candidateassociation->employer_id = $employer_id;
                    $candidateassociation->vendor_id =$authuser->parent_id;
                    $candidateassociation->job_id = $job_id;
                    $candidateassociation->candidate_id = $candidate_id;
                    $candidateassociation->candidate_status = 19;
                    $candidateassociation->status_updated_by = $authuser->parent_id;
                    $candidateassociation->save();


                    $candidateactivity = new Activity();
                    $candidateactivity->name = "Profile Submitted to Account Manager";
                    $candidateactivity->admin_id = 1;
                    $candidateactivity->accountmanager_id = $accountmanager_id;
                    $candidateactivity->employer_id = $employer_id;
                    $candidateactivity->vendor_id = $authuser->parent_id;
                    $candidateactivity->job_id = $job_id;
                    $candidateactivity->candidate_id = $candidate_id;
                    $candidateactivity->candidate_status = 19;
                    $candidateactivity->activity_by = $authuser->parent_id;
                    $candidateactivity->save();

                    $candidateassociation = new Association();
                    $candidateassociation->admin_id = 1;
                    $candidateassociation->accountmanager_id = $accountmanager_id;
                    $candidateassociation->employer_id = $employer_id;
                    $candidateassociation->vendor_id =$authuser->id;
                    $candidateassociation->job_id = $job_id;
                    $candidateassociation->candidate_id = $candidate_id;
                    $candidateassociation->candidate_status = 19;
                    $candidateassociation->status_updated_by = $authuser->id;
                    $candidateassociation->save();


                    $candidateactivity = new Activity();
                    $candidateactivity->name = "Profile Submitted to Account Manager";
                    $candidateactivity->admin_id = 1;
                    $candidateactivity->accountmanager_id = $accountmanager_id;
                    $candidateactivity->employer_id = $employer_id;
                    $candidateactivity->vendor_id = $authuser->id;
                    $candidateactivity->job_id = $job_id;
                    $candidateactivity->candidate_id = $candidate_id;
                    $candidateactivity->candidate_status = 19;
                    $candidateactivity->activity_by = $authuser->id;
                    $candidateactivity->save();

                    $jobresume = new JobResumes();
                    $jobresume->job_id = $job_id;
                    $jobresume->candidate_id = $candidate_id;
                    $jobresume->is_verified = 0;
                    $jobresume->save();
                    $jobResumeResponse = response()->success(compact('jobresume'));

                    // Update vendor revenue table default revenue value.
                     $vendorRevenue = VendorRevenue::where('vendor_id',$authuser->parent_id)
                                        ->where('job_id',$job_id)
                                        ->where('default_revenue',0)
                                        ->whereNotNull('est_revenue_1')
                                        ->whereNotNull('est_revenue_2')
                                        ->whereNotNull('est_revenue_3')
                                        ->whereNotNull('est_revenue_4')
                                        ->whereNotNull('est_revenue_5')
                                        ->first();

                    if(count($vendorRevenue) == 1) {
                        $carbon_date = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy5 = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy24 = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy7d = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy30d = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy5->addHours(5);
                        $dateCopy24->addHours(24);
                        $dateCopy7d->addHours(168);
                        $dateCopy30d->addHours(720);
                        if(Carbon::now()->gt($dateCopy30d)) {
                            //After 30 days
                             $revenueData = ['default_revenue' => 5];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if((Carbon::now()->gt($dateCopy7d)) && (Carbon::now()->lt($dateCopy30d))) {
                            //After 7 Days
                             $revenueData = ['default_revenue' => 4];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if((Carbon::now()->gt($dateCopy24)) && (Carbon::now()->lt($dateCopy7d))) {
                            //After 24 hrs
                             $revenueData = ['default_revenue' => 3];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if ( (Carbon::now()->gt($dateCopy5)) && (Carbon::now()->lt($dateCopy24))) {
                            //After 5 hrs before 24 hrs
                            $revenueData = ['default_revenue' => 2];
                            $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->parent_id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if (Carbon::now()->lt($dateCopy5)) {
                            //Within 5 hrs
                            $revenueData = ['default_revenue' => 1];
                            $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->parent_id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        }

                    }// Check if records are empty

                   //Insert Successfull candidate submission activity record
                     $newjobResume = Activity::create([
                        'person_id' => $authuser->parent_id,
                        'resume_id' => $candidate_id,
                        'name' => 'Profile submitted successfully.',
                     ]);

                        if(Input::get('vendorchecklist')):
                           $vendorchecklist = Input::get('vendorchecklist');
                           foreach($vendorchecklist as $emp):
                            $checklistassociation = new Association();
                            $checklistassociation->admin_id = 1;
                            $checklistassociation->job_id = $job_id;
                            $checklistassociation->candidate_id = $candidate_id;
                            $checklistassociation->employer_id = $employer_id;
                            $checklistassociation->accountmanager_id = $accountmanager_id;
                            $checklistassociation->vendor_checklist_id = $emp['id'];
                            $checklistassociation->save();

                            $checklistactivity = new Activity();
                            $checklistactivity->name = $emp['name'];
                            $checklistactivity->admin_id = 1;
                            $checklistactivity->accountmanager_id = $accountmanager_id;
                            $checklistactivity->employer_id = $employer_id;
                            $checklistactivity->vendor_id = $authuser->parent_id;
                            $checklistactivity->job_id = $job_id;
                            $checklistactivity->candidate_id = $candidate_id;
                            $checklistactivity->candidate_status = 19;
                            $checklistactivity->activity_by = $authuser->parent_id;
                            $checklistactivity->vendor_checklist_id = $emp['id'];
                            $checklistactivity->save();

                            $checklistactivity = new Activity();
                            $checklistactivity->name = $emp['name'];
                            $checklistactivity->admin_id = 1;
                            $checklistactivity->accountmanager_id = $accountmanager_id;
                            $checklistactivity->employer_id = $employer_id;
                            $checklistactivity->vendor_id = $authuser->id;
                            $checklistactivity->job_id = $job_id;
                            $checklistactivity->candidate_id = $candidate_id;
                            $checklistactivity->candidate_status = 19;
                            $checklistactivity->activity_by = $authuser->id;
                            $checklistactivity->vendor_checklist_id = $emp['id'];
                            $checklistactivity->save();
                           endforeach;
                         endif;


                $empAm = Association::where('vendor_id',$authuser->parent_id)
                                ->where('accountmanager_id',$accountmanager_id)
                                ->whereNotNull('employer_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_user_id')
                                ->where('job_id',$job_id)
                                ->whereNull('candidate_id')
                                ->with('accountmanager')
                                ->get();

                $candidate_info = Candidate::where('id', $candidate_id)->first();

                 Mail::send('emails.notifyInterestingCandidates', ['profileName' => $candidate_info->full_name, 'profileLocation' => $candidate_info->city, 'profileIndustry' => $candidate_info->job_profile], function ($m) use($empAm){
                 $m->to($empAm[0]->accountmanager->email, 'New Profile Submitted')->subject('New profile has been submitted');
                  });

                 $newjobResumeResponse = response()->success(compact('newjobResume'));
                 return $jobResumeResponse;
            }
            else{
                return response()->error("This Profile Already Submitted to Employer ,Please Try With different profile");
            }
        } else{
            return response()->error("You've already submitted the maximum number of profiles for the job ($job_id)");
        }
    }

    public function postEmployeespectrum(){
        $authuser = Auth::user();
        $candidate_id = Input::get('candidateId');
        $candidaname = Candidate::select('full_name')->where('id',$candidate_id)->get();
        $Rchilcntl = new RchilliController();
        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate_id);

        $invvotor = [
            "With an innovator score of ".$candidateSpectrum['innovator_points']."% , how do you think ".$candidaname[0]->full_name." creative thinking and problem-solving abilities will contribute to our organization? ", 
            "What specific skills or abilities does ".$candidaname[0]->full_name." possess that contribute to their innovative behaviour? ", 
            "having innovative behaviour ".$candidaname[0]->full_name." having   continuous reflection on whether he suits to hire ?",
            "How does ".$candidaname[0]->full_name." having innovative behaviour 46% approach problem-solving and generating new ideas? ",
            "How do you envision ".$candidaname[0]->full_name." having innovative behaviour 46% and continuous reflection benefiting our company and the specific role they are being ? "
        ];
        $leadership =[
            "".$candidaname[0]->full_name." having Leadership behaviour ".$candidateSpectrum['leader']."% Describe a time when you successfully led a team or project. How did you motivate and guide your team members?",
            "Can you provide specific examples or instances where ".$candidaname[0]->full_name." having Leadership behaviour ".$candidateSpectrum['leader']."% has demonstrated leadership qualities, despite having a low score in this attribute in the assessment?",
            "How does ".$candidaname[0]->full_name." having Leadership behaviour ".$candidateSpectrum['leader']."% interact with team members and stakeholders? Can you provide feedback on their communication skills, conflict resolution techniques and ability to build relationships?",
            "Have you considered external factors that could contribute to ".$candidaname[0]->full_name." having Leadership behaviour ".$candidateSpectrum['leader']."% low score in the Leader attribute? Could their assessment results be impacted by other external factors that may ",
            "What steps can be taken to reduce the impact of ".$candidaname[0]->full_name." having Leadership behaviour ".$candidateSpectrum['leader']."% lack of self-awareness in the leader role, such as delegating certain tasks, providing specific guidance or implementing regular "
        ];

        $plannedone =[
          "Can you provide specific examples or instances where ".$candidaname[0]->full_name." having Planned one ".$candidateSpectrum['planned_one']."% has demonstrated planning and self-motivation skills, despite having a low score in these attributes in the assessment?",
          "Is there a potential for ".$candidaname[0]->full_name." having Planned one ".$candidateSpectrum['planned_one']."% to develop their planning and self-motivation skills through access to training, mentorship, or coaching? How receptive are they to such opportunities?",
          "What strategies can be employed to support ".$candidaname[0]->full_name." having Planned one ".$candidateSpectrum['planned_one']."% in strengthening their planning and self-motivation skills, such as regular feedback, goal-setting, or providing additional structure or resources?",
          "What specific methods or approaches to planning and self-motivation are required for the position, and how does ".$candidaname[0]->full_name." having Planned one ".$candidateSpectrum['planned_one']."% profile align with these requirements?",
          "How do you prioritize tasks and manage your time effectively when not heavily relying on detailed planning?"
        ];
        $problemsolver=[
            "How do you approach problem-solving within a team environment? Do you seek input from others or prefer to work independently?",
            "What strategies can be employed to support ".$candidaname[0]->full_name." having Problem solver ".$candidateSpectrum['problem_solver_percentage']."% in strengthening their problem-solving, adaptability, and flexibility?",
            "Can you provide specific examples or instances where ".$candidaname[0]->full_name." having Problem solver ".$candidateSpectrum['problem_solver_percentage']."% has demonstrated effective problem-solving skills, despite having a low score in this attribute in the assessment?",
            "What specific methods or approaches to problem-solving,adaptability, and flexibility are required for the position, and how does ".$candidaname[0]->full_name." having a Problem solver ".$candidateSpectrum['problem_solver_percentage']."% profile align with these requirements?",
            "How does ".$candidaname[0]->full_name." having Problem solver ".$candidateSpectrum['problem_solver_percentage']."% approach tasks or assignments? Are they open to new ideas and feedback and willing to adapt to changing circumstances?"
        ];
        $optimist=[
            "Have you assessed whether there could be external factors or specific circumstances that may have influenced ".$candidaname[0]->full_name." having Optimist points ".$candidateSpectrum['optimist_points']."% motivation and level of commitment, leading to a lower score in the assessment?",
            "How does ".$candidaname[0]->full_name." having Optimist points  ".$candidateSpectrum['optimist_points']."% approach their work and responsibilities? Are they proactive in seeking opportunities, taking ownership, and demonstrating a high level of commitment?",
            "Can you provide specific examples or instances where ".$candidaname[0]->full_name." having Optimist points ".$candidateSpectrum['optimist_points']."% has demonstrated strong motivation and commitment, despite having a low score in the Optimistic attribute in the assessment?",
            "Is there potential for ".$candidaname[0]->full_name." having Optimist points ".$candidateSpectrum['optimist_points']."% to develop their motivation and commitment through exposure to meaningful projects, additional responsibilities, or mentoring from senior team members? How receptive are they to such opportunities?",
            "Can you identify any other strengths in ".$candidaname[0]->full_name." having Optimist points ".$candidateSpectrum['optimist_points']."% to a profile that may compensate for a lower score in the Optimistic attribute, such as strong technical skills, creativity, or problem-solving abilities?"
        ];
        $yesMan =[
            "Can you provide specific examples or instances where".$candidaname[0]->full_name."having yes man behaviour ".$candidateSpectrum['yesman']."% tendency to be a 'yesman' has impacted their ability to contribute independently and think critically?",
            "How would you anticipate ".$candidaname[0]->full_name." having yes man behaviour ".$candidateSpectrum['yesman']."% low score in the 'Being a Cultural Fit' attribute and their tendency to be a 'yesman' may impact their potential for growth and success within the role? Are there strategies or support mechanisms that can be put in place to address these concerns?",
            "Have you assessed whether there are any external factors or circumstances that may have influenced ".$candidaname[0]->full_name." having yes man behaviour ".$candidateSpectrum['yesman']."%  low score in the 'Being a Cultural Fit' attribute?",
            "Is there potential for ".$candidaname[0]->full_name." having yes man behaviour ".$candidateSpectrum['yesman']."%  to adapt their approach and enhance their ability to provide independent perspectives, think critically, and contribute more assertively in a way that aligns with the organization's culture?",
            "sHave you assessed whether there are any external factors or circumstances that may have influenced ".$candidaname[0]->full_name." having yes man behaviour ".$candidateSpectrum['yesman']."%  low score in the 'Being a Cultural Fit' attribute?"
        ];
        $all =[
            "With an innovator score of approximately ".$candidateSpectrum['innovator_points']."%, how do you foresee ".$candidaname[0]->full_name."'s creative thinking and problem-solving skills enhancing our organization?",
            "With a leadership behavior score of ".$candidateSpectrum['leader']."%, should candidate be considered a suitable fit for our organization?",
            "Assess ".$candidaname[0]->full_name."'s approach to tasks and assignments in light of their 'Problem Solver' score of ".$candidateSpectrum['problem_solver_percentage']."%. Explore their problem identification, analytical skills, solution generation, collaboration preferences, resource utilization, decision-making, adaptability, and communication?",
            "Assess ".$candidaname[0]->full_name."'s work approach given their 'Optimist' score of ".$candidateSpectrum['optimist_points']."%. Explore their attitude, resilience, and impact on team dynamics, decision-making, goal setting, adaptability, and conflict resolution. Request examples where their optimism played a notable role in past work experiences?",
            "Consider the potential for ".$candidaname[0]->full_name."'s to adapt their approach, given their 'Yes Man' behavior score of ".$candidateSpectrum['yesman']."%. Evaluate their capacity to provide independent perspectives, think critically, and contribute assertively in alignment with the organization's culture. Discuss strategies for fostering a more balanced approach and nurturing a culture of open dialogue and diverse viewpoints."
        ];
        $candidatesummary = ["Assume you are a evaluator of  my future employee".$candidaname[0]->full_name." who have innovator score ".$candidateSpectrum['innovator_points']."% , leader ship score".$candidateSpectrum['leader']."% , plannedone score ".$candidateSpectrum['planned_one']."% , problemsolver score ".$candidateSpectrum['problem_solver_percentage']."% , optimistic score ".$candidateSpectrum['optimist_points']."% ,yesMan score ".$candidateSpectrum['yesman']."% "];
        $candidateSpectrum['Innovatorpoints']= $invvotor;
        $candidateSpectrum['The leader']= $leadership;
        $candidateSpectrum['The planned_one']= $plannedone;
        $candidateSpectrum['The problem_solver_percentage']= $problemsolver;
        $candidateSpectrum['The optimist_points']= $optimist;
        $candidateSpectrum['The yesman']= $yesMan;
        $candidateSpectrum['all']=$all;
        $candidateSpectrum['candidatesummary'] = $candidatesummary;
        return response()->success(compact('candidateSpectrum'));
    }

  
    public function postTalentmining(){
        $authuser = Auth::user();
        $candidate_id = Input::get('candidateId');
        $candidaname = Candidate::select('full_name')->where('id',$candidate_id)->get();
        $Rchilcntl = new RchilliController();
        $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate_id);
        return response()->success(compact('candidateTalentMine'));
        
        $BenefitsPerks =[
            "1.Assess if ".$candidaname[0]->full_name." having benefits perks ".$candidateTalentMine[0]->value." expectations align with the benefits and perks offered by the project. Consider if she values the benefits and perks provided and if they motivate her to perform well.?",
            "2.Evaluate if there are additional benefits or perks that could be offered to better cater to ".$candidaname[0]->full_name."having benefits perks ".$candidateTalentMine[0]->value." preferences. Consider if customizing the benefits package or introducing new perks can enhance her satisfaction and engagement.?",
            "3.Assess the potential impact of the project's benefits and perks on ".$candidaname[0]->full_name."having benefits perks ".$candidateTalentMine[0]->value."overall motivation and job satisfaction. Consider if the current offerings are sufficient to retain her interest and commitment to the project ?",
            "4.Evaluate if ".$candidaname[0]->full_name."having benefits perks ".$candidateTalentMine[0]->value." attitudes towards benefits and perks align with the company's culture and values. Consider if her expectations are in line with what the organization typically provides to employees ?",
            "5.Assess if the benefits and perks offered by the project are competitive compared to other similar projects or companies in the industry. Consider if the offerings are attractive enough to keep ".$candidaname[0]->full_name."having benefits perks ".$candidateTalentMine[0]->value." engaged and motivated, especially considering the possibility of her being lured away by other opportunities ?"
        ];
        $BusinessReputation =  [
            "1.Assess the potential impact of ".$candidaname[0]->full_name."having a Business Reputation ".$candidateTalentMine[1]->value." reputation on any regulatory or compliance requirements for your project. Consider if her score could impact your ability to adhere to any legal or ethical requirements in your industry. ?",
            "2.Evaluate if there are any opportunities for ".$candidaname[0]->full_name." having a Business Reputation ".$candidateTalentMine[1]->value." to demonstrate her commitment to professionalism, ethical standards, or corrective actions. Consider if she is willing to take steps to address any concerns and demonstrate a commitment to continuous improvement. ?",
            "3.Assess if there are any specific stakeholders impacted by ".$candidaname[0]->full_name." having a Business Reputation ".$candidateTalentMine[1]->value." such as clients or partners. Consider if her reputation could affect your ability to attract or retain key stakeholders for your project. ?",
            "4.Evaluate if ".$candidaname[0]->full_name."having Business Reputation ".$candidateTalentMine[1]->value." is consistent with other information you have gathered about her, such as references or previous work experience. Consider if there are any inconsistencies or concerns that need to be addressed. ?",
            "5.Assess if there are any specific steps or requirements that need to be taken related to ".$candidaname[0]->full_name." having Business Reputation ".$candidateTalentMine[1]->value.", such as additional communication with stakeholders or regular performance evaluations. ?"
        ];
        $InnovationTechnology = [
          "1.Assess the specific requirements of your project related to Innovation Technology. Consider if ".$candidaname[0]->full_name." having Innovation Technology ".$candidateTalentMine[1]->value." score aligns with the level of expertise needed for those requirements.?",
          "2.Evaluate if ".$candidaname[0]->full_name." having Innovation Technology ".$candidateTalentMine[1]->value." skills match the specific technologies or tools that will be utilized in your project. Consider if she has experience with the technologies that are critical to your project's success.?",
          "3.Assess if ".$candidaname[0]->full_name." having Innovation Technology ".$candidateTalentMine[1]->value." reflects a strong understanding of emerging trends or advancements in the industry. Consider if she can bring fresh perspectives or innovative ideas to your project.?",
          "4.Evaluate if ".$candidaname[0]->full_name." having Innovation Technology ".$candidateTalentMine[1]->value." score aligns with the overall skill set required for your project. Consider if she possesses the necessary technical abilities, problem-solving skills, and creativity to contribute effectively.?",
          "5.Assess if there are any potential gaps in ".$candidaname[0]->full_name." having Innovation Technology ".$candidateTalentMine[1]->value." skills that can be mitigated through additional training or resources. Consider if she has a willingness to learn and adapt to new technologies.?"
        ];
        $Jobsatisfication = [
            "1.Evaluate if ".$candidaname[0]->full_name." having Job satisfaction <".$candidateTalentMine[2]->value." job satisfaction score is consistent with her stated career goals or aspirations. Consider if the project aligns with her long-term objectives and if it can provide her with the job satisfaction she desires.?",
            "2.Assess if there are any support mechanisms or resources available within your organization to improve job satisfaction. Consider if you can provide mentorship, training, or any other initiatives that could positively impact ".$candidaname[0]->full_name." having Job satisfaction ".$candidateTalentMine[2]->value." job satisfaction.?",
            "3.Evaluate if there are any potential mitigating factors that can offset ".$candidaname[0]->full_name." having Job satisfaction ".$candidateTalentMine[2]->value." job dissatisfaction. Consider if her skills, experience, or expertise make her a valuable asset to the project, irrespective of her current level of job satisfaction.?",
            "4.Assess if there are alternative candidates available with higher job satisfaction scores. Consider if there are potential candidates who may be more motivated and engaged in the project, leading to better overall outcomes.?",
            "5.Evaluate the potential for measuring and tracking job satisfaction during the project. Consider if you can monitor and address any changes in ".$candidaname[0]->full_name." having Job satisfaction ".$candidateTalentMine[2]->value." job satisfaction to ensure her continued engagement and productivity.?"
        ];
        $Globalization = [
            "1.Evaluate if the Globalization score ".$candidateTalentMine[3]->value."reflects a lack of experience or exposure in international business. Consider if there are other indicators, such as previous international projects or cross-cultural understanding, that could compensate for the lower score.?",
            "2.Evaluate if the role ".$candidaname[0]->full_name." having Globalization ".$candidateTalentMine[3]->value." would play in the project requires a higher level of Globalization expertise. Consider if there are other team members who can compensate for the lower score or if additional training and support can bridge the gap.?",
            "3.Assess ".$candidaname[0]->full_name." having Globalization ".$candidateTalentMine[3]->value." Globalization score reflects a lack of language skills, cultural awareness, or experience navigating global markets. Consider if these aspects are crucial for the success of the project and if she can develop these skills over time.?",
            "4.Evaluate if the project allows for opportunities to enhance ".$candidaname[0]->full_name." having Globalization ".$candidateTalentMine[3]->value." Globalization skills. Consider if there are cross-cultural collaboration opportunities or exposure to international clients that could help her develop a stronger understanding of Globalization.?",
            "5.Assess if ".$candidaname[0]->full_name."having Globalization ".$candidateTalentMine[3]->value." score reflects a lack of language skills, cultural awareness, or experience navigating global markets. Consider if these aspects are crucial for the success of the project and if she can develop these skills over time.?"
        ];
        $BalanceWellBeing =[
            "1.Evaluate if ".$candidaname[0]->full_name."having Balance Well Being ".$candidateTalentMine[4]->value." other skills and qualifications compensate for the lower Balance and Well-being score. Consider if she possesses strong technical skills, domain knowledge, or other relevant expertise that can contribute to the project's success.?",
            "2.Assess if there are resources or support available within your organization to help ".$candidaname[0]->full_name." having Balance Well Being ".$candidateTalentMine[4]->value." improve her Balance and Well-being skills. Consider if there are wellness programs, flexible work arrangements, or other initiatives that can support her in maintaining a healthy work-life balance.?",
            "3.Evaluate if the lower Balance and Well-being score aligns with the overall objectives and requirements of the project. Consider if the project's focus is primarily on achieving specific outcomes and if the lower score would have minimal impact on those outcomes.?",
            "4.Assess if there are opportunities within the project for promoting a healthy work-life balance and well-being. Consider if there are initiatives or policies that can be implemented to support ".$candidaname[0]->full_name." aving Balance Well Being ".$candidateTalentMine[4]->value." and the entire team in maintaining work-life balance and well-being throughout the project.?",
            "5.Evaluate if ".$candidaname[0]->full_name."having Balance Well Being ".$candidateTalentMine[4]->value." attitudes and mindset towards work-life balance and well-being align with the culture of your organization. Consider if her approach can be positively influenced by the values and practices within your organization.?"
        ];
        $Remuneration = [
            "1.Assess the budget and financial constraints of your project. Consider if you have the flexibility to accommodate ".$candidaname[0]->full_name." having< Remuneration-50%>salary expectations and if it aligns with the available resources.?",
            "2.Evaluate if ".$candidaname[0]->full_name." having< Remuneration-50%> skills, experience, and qualifications justify the remuneration she is seeking. Consider if her expertise and contributions can add significant value to your project and if the budget allows for a higher remuneration.?",
            "3.Assess the competitiveness of the job market for similar roles. Consider if the Remuneration score of 50% could be a reflection of market trends and if adjusting your budget to match market rates is feasible.?",
            "4.Evaluate if ".$candidaname[0]->full_name." having< Remuneration-50%> is open to flexible compensation structures, such as performance-based bonuses or other non-traditional forms of remuneration. Consider if these alternative arrangements can help align her expectations with available resources.?",
            "5.Assess the potential impact of hiring ".$candidaname[0]->full_name." having< Remuneration<50%> with a lower remuneration on team morale and company culture. Consider if it could create disparities or affect motivation within the team.?"
        ];
        $Changestability =[
            "1.Evaluate if there are opportunities for ".$candidaname[0]->full_name."having change stability<50%> to enhance her change management skills and improve her Change Stability score through training, mentorship, or professional development programs.?",
            "2.Assess the potential impact of ".$candidaname[0]->full_name."having change stability<50%> lower Change Stability score on stakeholder management. Consider if her ability to effectively communicate and engage with stakeholders may be affected, and if strategies can be put in place to address this. ?",
            "3.Evaluate if there are other project management or leadership skills that ".$candidaname[0]->full_name." having change stability<50%> possesses, which can help compensate for her lower Change Stability score. Consider if her overall fit, problem-solving abilities, or domain knowledge can contribute positively to the project's.?",
            "4.Assess the potential impact of ".$candidaname[0]->full_name." having change stability<50%> lower Change Stability score on team dynamics and collaboration. Consider if the team's ability to adapt and work together effectively may be affected, and if steps can be taken to foster a supportive and agile work environment.?",
            "5.Evaluate if the project's timeline and budget allow for additional resources or contingency plans to manage change effectively, regardless of ".$candidaname[0]->full_name." having change stability<50%> Change Stability score.?"
        ];
        $TeamPeople = [
            "1.Seek feedback from relevant stakeholders who have worked with ".$candidaname[0]->full_name." having Team People<50%> in a team setting. Consider their insights on her teamwork skills, such as her ability to be an active listener, respect diversity in opinions and approaches, and leverage each team member's strengths.?",
            "2.Assess the potential benefits of hiring someone with a lower Team People-50% score. Consider if ".$candidaname[0]->full_name." having Team People<50%> ability to bring unique perspectives, help resolve conflicts, and foster an environment of innovation and creativity, could outweigh the potential limitations of her score.?",
            "3.Evaluate if there are opportunities for ".$candidaname[0]->full_name." having Team People<50%> to develop her teamwork skills. Consider if there are team-building or interpersonal skills training available, if mentors or coaches can provide guidance, or if team members can provide feedback, suggestions, and support.?",
            "4.Assess if there are specific project requirements or milestones that may require a high level of teamwork and collaboration. Consider if ".$candidaname[0]->full_name." having Team People<50%> score may impact the project's success if she were to manage these requirements.?",
            "5.Evaluate if there are other factors beyond teamwork skills that contribute to ".$candidaname[0]->full_name." having Team People<50%> overall fit and attractiveness as a candidate. Consider if she possesses domain knowledge, technical skills, problem-solving abilities, or leadership qualities that can make a positive impact on the project's success.?"
        ];
        $CareerProgression = [
            "1.Evaluate the larger context around ".$candidaname[0]->full_name." career progression score. Consider if there were any factors that could have impacted her growth, such as a tough job market or a focus on work-life balance.?",
            "2.Does the ".$candidaname[0]->full_name." having career progression <50%> align with the level of expertise and experience required for the project? Consider other qualifications, skills, and experiences needed to ensure a comprehensive fit.?",
            "3.Assess any opportunities for professional development or training that could help bridge the gap between ".$candidaname[0]->full_name." career progression and the project's requirements. Determine if there is an opportunity to provide her with additional training or mentorship to improve her chances of success.?",
            "4.Determine what risks or benefits are associated with hiring ".$candidaname[0]->full_name." given her career progression score. Think about the potential impact, opportunity, or other factors that may apply to your specific project. ?",
            "5.Is there a need for the ".$candidaname[0]->full_name." to collaborate with other team members or stakeholders in the project? Evaluate how their career progression demonstrates effective communication, relationship building, and collaboration skills. ?"
        ];
        $candidateTalentMine['Innovatorpoints']= $BenefitsPerks;
        $candidateTalentMine['Innovatorpoints']= $BusinessReputation;
        $candidateTalentMine['Innovatorpoints']= $InnovationTechnology;
        $candidateTalentMine['Innovatorpoints']= $Jobsatisfication;
        $candidateTalentMine['Innovatorpoints']= $Globalization;
        $candidateTalentMine['Innovatorpoints']= $BalanceWellBeing;
        $candidateTalentMine['Innovatorpoints']= $Remuneration;
        $candidateTalentMine['Innovatorpoints']= $TeamPeople;
        $candidateTalentMine['Innovatorpoints']=$CareerProgression;
        $candidateTalentMine['Innovatorpoints']=$Changestability;

    }
    public function postChatgpt(){
    
$authuser = auth()->user();
$candidate_id = request('candidateId');
$content = request('content');
$user_message = $content;

$messages = [
    [
        "role" => "user",
        "content" => $user_message
    ]
];

$data = [
    "model" => "gpt-3.5-turbo",
    "messages" => $messages,
    "temperature" => 0.7
];

$client = new Client();

$response = $client->request('POST', 'https://api.openai.com/v1/chat/completions', [
    'headers' => [
        'Authorization' => 'Bearer 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',
        'Content-Type' => 'application/json',
    ],
    'json' => $data,
]);

if ($response->getStatusCode() === 200) {
    $apiResponse = json_decode($response->getBody(), true);
    echo json_encode($apiResponse);
} else {
    echo 'API request failed: ' . $response->getStatusCode();
}

    }

    public function postFindcandidateids(){     

        $authuser = auth()->user();
        $ExpTit = request('experience_title');
        $ExpCom = request('experience_company_name');
        $ExpLoc = request('location');
        $Activ = request('active_experience');
        $data =  [
            "experience_title" => $ExpTit,
            "experience_company_name" => $ExpCom ,
            "location" => $ExpLoc,
            "active_experience" =>  $Activ
        ];
        
        $client = new Client();
        $response = $client->request('POST','https://api.coresignal.com/cdapi/v1/linkedin/member/search/filter', [
            'headers' => [
                'Authorization' => 'Bearer eyJhbGciOiJFZERTQSIsImtpZCI6Ijg0OWRkZWVlLWQ2NjItNTYzMy1lNTYwLWZhMmQ2YzU0OGQ0NyJ9.eyJhdWQiOiJoaXJleHRyYSIsImV4cCI6MTczMDMxNjMxMywiaWF0IjoxNjk4NzU5MzYxLCJpc3MiOiJodHRwczovL29wcy5jb3Jlc2lnbmFsLmNvbTo4MzAwL3YxL2lkZW50aXR5L29pZGMiLCJuYW1lc3BhY2UiOiJyb290IiwicHJlZmVycmVkX3VzZXJuYW1lIjoiaGlyZXh0cmEiLCJzdWIiOiJmYTBjNGM5Yy1jMjFjLWZmZGYtYzBiOS00OGFlZDVhZjljMTYiLCJ1c2VyaW5mbyI6eyJzY29wZXMiOiJjZGFwaSJ9fQ.idQHF8JedHNRr6VJI_SxqATCyo_JrL-yCHRCsm-EmQqNx7eqOJf5f-tY72r66gbIzVUHe7YM1HQ7At1BSS0bCQ',
                'Content-Type' => 'application/json',
            ],
            'json' => $data,
        ]);
       
if ($response->getStatusCode() === 200) {
    $apiResponse = json_decode($response->getBody(), true);
    return response()->success(compact('apiResponse'));
} else {
    echo 'API request failed: ' . $response->getStatusCode();
}
        

    }
	public function getFindacandidatedetails($id){
        $domain = $id;
        $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://api.coresignal.com/cdapi/v1/linkedin/member/collect/'. $domain,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => array(
       'Authorization: Bearer eyJhbGciOiJFZERTQSIsImtpZCI6Ijg0OWRkZWVlLWQ2NjItNTYzMy1lNTYwLWZhMmQ2YzU0OGQ0NyJ9.eyJhdWQiOiJoaXJleHRyYSIsImV4cCI6MTczMDMxNjMxMywiaWF0IjoxNjk4NzU5MzYxLCJpc3MiOiJodHRwczovL29wcy5jb3Jlc2lnbmFsLmNvbTo4MzAwL3YxL2lkZW50aXR5L29pZGMiLCJuYW1lc3BhY2UiOiJyb290IiwicHJlZmVycmVkX3VzZXJuYW1lIjoiaGlyZXh0cmEiLCJzdWIiOiJmYTBjNGM5Yy1jMjFjLWZmZGYtYzBiOS00OGFlZDVhZjljMTYiLCJ1c2VyaW5mbyI6eyJzY29wZXMiOiJjZGFwaSJ9fQ.idQHF8JedHNRr6VJI_SxqATCyo_JrL-yCHRCsm-EmQqNx7eqOJf5f-tY72r66gbIzVUHe7YM1HQ7At1BSS0bCQ'
    ),
    ));

$response = curl_exec($curl);
$jsonResult = json_decode($response, true);
          $id = ($jsonResult['id']);
          $name = ($jsonResult['name']);
          $title = ($jsonResult['title']);
          $url = ($jsonResult['url']);
          $hash = ($jsonResult['hash']);
          $location = ($jsonResult['location']);
          $industry = ($jsonResult['industry']);
          $summary = ($jsonResult['summary']);
          if ($jsonResult && isset($jsonResult['id'])) 
          {
            // Store the data in an array
            $data = [
                'coresignalprofiles_id' => $jsonResult['id'],
                'name' => $jsonResult['name'],
                'first_name' => $jsonResult['first_name'],
                'last_name' => $jsonResult['last_name'],
                'title' => $jsonResult['title'],
                'url' => $jsonResult['url'],
                'hash' => $jsonResult['hash'],
                'location' => $jsonResult['location'],
                'industry' => $jsonResult['industry'],
                'summary' => $jsonResult['summary'],
            ];
            DB::table('coresignalprofiles')->updateOrInsert(
                ['coresignalprofiles_id' => $jsonResult['id'],
                'name' => $jsonResult['name'],
                'first_name' => $jsonResult['first_name'],
                'last_name' => $jsonResult['last_name'],
                'title' => $jsonResult['title'],
                'url' => $jsonResult['url'],
                'hash' => $jsonResult['hash'],
                'location' => $jsonResult['location'],
                'industry' => $jsonResult['industry'],
                'summary' => $jsonResult['summary']]
            );
        }

curl_close($curl);
echo $response;
    }

    public function getVendorassignedclosedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $b = array();
        $authId = $assigntovUser = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');

              foreach($a as $c){array_push($b, $c);}
              $vendorassignedclosedjobs=Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',6);})
                            ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedclosedjobs = Association::where('vendor_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        }
        foreach ($vendorassignedclosedjobs as $job) {
            $note=Activity::where('job_id',intval($job['job_id']))->where('job_status',6)
                                ->get(['note']);
            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                ->whereNotNull('employer_id')
                                ->where('admin_id',1)
                                ->where('job_id',intval($job['job_id']))
                                ->whereNotNull('accountmanager_id')
                                ->where('activity_by',$authuser->id)
                                ->whereNotNull('status_id')
                                ->where('is_vendor_sourcing_activity',1)
                                ->with('activityuser.role','status','candidate')
                                ->with('job')
                                ->with('sourcingStatus')
                                ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted ,'note'=>$note];
            $job['numbers'] = $numbers;
        } //foreach
        return response()->success(compact('vendorassignedclosedjobs'));
    }

    public function getVendorassignedclosedjobsall()
    {
        $authuser = Auth::user();
        $b = array();
        $authId = $assigntovUser = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');

              foreach($a as $c){array_push($b, $c);}
              $vendorassignedclosedjobsall=Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',6);})
                            ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedclosedjobsall = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        }
        foreach ($vendorassignedclosedjobsall as $job) {
            $note=Activity::where('job_id',intval($job['job_id']))->where('job_status',6)
                                ->get(['note']);
            $vendorSourcingStatus=Activity::select('vendor_id')->where('vendor_id',$authuser->id)
                                ->whereNotNull('employer_id')
                                ->where('admin_id',1)
                                ->where('job_id',intval($job['job_id']))
                                ->whereNotNull('accountmanager_id')
                                ->where('activity_by',$authuser->id)
                                ->whereNotNull('status_id')
                                ->where('is_vendor_sourcing_activity',1)
                                ->with('activityuser.role','status','candidate')
                                ->with('job')
                                ->with('sourcingStatus')
                                ->count();
            /*$vendorAcceptedAt=Activity::select('vendor_id')->where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();*/
            $receivedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
            $rejectedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            /*if(count($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}*/
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted ,'note'=>$note];
            $job['numbers'] = $numbers;
        } //foreach
        return response()->success(compact('vendorassignedclosedjobsall'));
    }

    public function getVendorassignedrejectedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $vendorassignedrejectedjobs = Association::where('vendor_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_status',[1,2,30])
                            ->with('job.JobType')
                            ->with('job_status')
                            ->with('job.status')
                            ->get();
        foreach ($vendorassignedrejectedjobs as $job) {
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->get();
            if(count($estimaterevenue) == 1) {
            foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
            }}

            if(count($estimaterevenue) > 1) {
                $finalRev=0;
                $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->where('vendor_id',$authId)->get();
                $jobassign=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                                   // print_r($jobassign);
                $firstprofile=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
                    if(count($firstprofile) > 0) {
                        $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                        $from = \Carbon\Carbon::parse($firstprofile[0]->created_at);
                        $diff_in_minutes = $to->diffInMinutes($from);
                        if(!$diff_in_minutes) {
                            $diff_in_minutes=$to->diffInSeconds($from);
                            if($diff_in_minutes<=59) $diff_in_minutes=1;
                        }
                        $estimaterevenue[0]['first_profile_submitted_in'] = $diff_in_minutes;
                        if($finalRev)
                            {$estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    } else {
                        $estimaterevenue[0]['first_profile_submitted_in'] = 0;
                        if($finalRev)
                            { $estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    }
                }
            }

            $acceptDate1=Activity::where('name','Vendor Rejected job')
                                    ->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->get(['created_at']);

            if(count($acceptDate1) > 0){$acceptDate= $acceptDate1[0]['created_at'];}
            else{$acceptDate=null; }

            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('employer_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}

            $job['numbers'] = array('vendorSourcing'=>$vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'est'=>$estimaterevenue,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles);$rejecteddate = ['rejecteddate'=>$acceptDate];$job['rejecteddate']=$rejecteddate;
        }//foreach
        return response()->success(compact('vendorassignedrejectedjobs'));
    }

    public function getVendorassignedrejectedjobsall($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $vendorassignedrejectedjobsall = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_status',[1,2,30])
                            ->with('job.JobType')
                            ->with('job_status')
                            ->with('job.status')
                            ->get();
        foreach ($vendorassignedrejectedjobsall as $job) {
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->get();
            if(count($estimaterevenue) == 1) {
            foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
            }}

            if(count($estimaterevenue) > 1) {
                $finalRev=0;
                $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->where('vendor_id',$authId)->get();
                $jobassign=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                                   // print_r($jobassign);
                $firstprofile=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
                    if(count($firstprofile) > 0) {
                        $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                        $from = \Carbon\Carbon::parse($firstprofile[0]->created_at);
                        $diff_in_minutes = $to->diffInMinutes($from);
                        if(!$diff_in_minutes) {
                            $diff_in_minutes=$to->diffInSeconds($from);
                            if($diff_in_minutes<=59) $diff_in_minutes=1;
                        }
                        $estimaterevenue[0]['first_profile_submitted_in'] = $diff_in_minutes;
                        if($finalRev)
                            {$estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    } else {
                        $estimaterevenue[0]['first_profile_submitted_in'] = 0;
                        if($finalRev)
                            { $estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    }
                }
            }

            $acceptDate1=Activity::where('name','Vendor Rejected job')
                                    ->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->get(['created_at']);

            if(count($acceptDate1) > 0){$acceptDate= $acceptDate1[0]['created_at'];}
            else{$acceptDate=null; }

            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('employer_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}

            $job['numbers'] = array('vendorSourcing'=>$vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'est'=>$estimaterevenue,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles);$rejecteddate = ['rejecteddate'=>$acceptDate];$job['rejecteddate']=$rejecteddate;
        }//foreach
        return response()->success(compact('vendorassignedrejectedjobsall'));
    }

    public function getVendorassignedpendingjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $authId= $assigntovUser = null;
        $b = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
            foreach($a as $c){array_push($b, $c);}
            $vendorassignedpendingjobs = Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();

        } else {$authId = $authuser->id;
            $vendorassignedpendingjobs = Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)

                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        }

        foreach ($vendorassignedpendingjobs as $job) {

            $vendorSourcingStatus=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
                $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                    ->count();
                $offeredProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count();
                if(!$authuser->parent_id) {
                    $assigntovUser=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_user_id')
                                    ->where('job_id',intval($job['job_id']))
                                    ->with('vendoruser')
                                    ->get();
                    if(count($assigntovUser)) {
                        $assigntovUser=$assigntovUser[0]['vendoruser']['first_name'];
                    } else { $assigntovUser=null;}
                } else { $assigntovUser=null; }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);

                if($vendorAcceptedAt)
                    {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['job_accept_time'] = 0;}
                $possibleRevenues = DB::table('vendor_accountmanager_share')
                ->select('vendor_price')
                ->where('vendor_id', $authId)
                ->where('job_id', $job['job_id'])
                ->get();
                $numbers = ['profilesReceived'=>$receivedProfiles,'possibleRevenues' => $possibleRevenues,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'assigntovUser'=>$assigntovUser ];

                $job['numbers'] = $numbers;
        } //foreach


        return response()->success(compact('vendorassignedpendingjobs'));
    }

    public function getVendorassignedpendingjobsall()
    {
        $authuser = Auth::user();
        $authId= $assigntovUser = null;
        $b = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
            foreach($a as $c){array_push($b, $c);}
            $vendorassignedpendingjobsall = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        } else {$authId = $authuser->id;
            $vendorassignedpendingjobsall = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        }

        foreach ($vendorassignedpendingjobsall as $job) {

            $vendorSourcingStatus=Activity::select('vendor_id')->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            /*$vendorAcceptedAt=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();*/
            $receivedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
                $rejectedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
                $shorlistedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                    ->count();
                $offeredProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count();
                if(!$authuser->parent_id) {
                    $assigntovUser=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_user_id')
                                    ->where('job_id',intval($job['job_id']))
                                    ->with('vendoruser')
                                    ->get();
                    if(count($assigntovUser)) {
                        $assigntovUser=$assigntovUser[0]['vendoruser']['first_name'];
                    } else { $assigntovUser=null;}
                } else { $assigntovUser=null; }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);

                /*if($vendorAcceptedAt)
                    {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['job_accept_time'] = 0;}*/
                $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'assigntovUser'=>$assigntovUser ];

                $job['numbers'] = $numbers;
        } //foreach


        return response()->success(compact('vendorassignedpendingjobsall'));
    }

    public function getAssignedprogressjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$assignedprogressjobs_dummy = Cache::remember('getAssignedprogressjobs_assignedprogressjobs_dummy', 60, function() use ($authuser,$diff_date) {
        $assignedprogressjobs_dummy =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        //});

        foreach ($assignedprogressjobs_dummy as $job) {
            $jobId[] = $job->job_id;
            // echo "<pre>"; print_r($job); exit;
        }
        // echo "<pre>"; print_r($jobId);
        // DB::connection()->enableQueryLog();
        $assoStatsRaw =  Association::whereIn('job_id',$jobId)->where('created_at','>=',$diff_date)
                            ->where('accountmanager_id',$authuser->id)/*->where('gdpr_status','1')*/
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
                            /*$query = DB::getQueryLog();
                            $last_query = end($query);
        print_r($last_query); exit;*/
        foreach ($assoStatsRaw as $stats){
            $assoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        // print_r($assoStats[$stats->job_id], '1081aaaaaaaaaaaa');exit;
        //print_r($assoStats[$job['job_id']], '1081sdfjksdfankl');exit;

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $assignedToRaw =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $rejectedByRaw =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        //$vendorAcceptedAtRaw = Cache::remember('getAssignedprogressjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $vendorAcceptedAtRaw =  Activity::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->whereIn('job_id',$jobId)
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->select('job_id', 'created_at')
                                    ->groupBy('job_id')
                                    ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats){
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }

        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            // echo "<pre>"; print_r(count(($assoStats[$job['job_id']])));
            if(isset($assoStats[$job['job_id']])) {
                // echo "<pre>"; echo "i am here"; exit;
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;

            if($assignedTo == $rejectedBy){
                $assignedprogressjobs_dummy->forget($key);
            }
        }
        $assignedprogressjobs = $assignedprogressjobs_dummy->values();
        return response()->success(compact('assignedprogressjobs'));
    }
    public function getAssignedprogressjobsall()
    {
        $authuser = Auth::user();
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$assignedprogressjobs_dummy = Cache::remember('getAssignedprogressjobs_assignedprogressjobs_dummy', 60, function() use ($authuser) {
        $assignedprogressjobs_dummy =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        //});

        foreach ($assignedprogressjobs_dummy as $job){
            $jobId[] = $job->job_id;
        }

        //$assoStatsRaw = Cache::remember('getAssignedprogressjobs_assoStatsRaw', 60, function() use ($authuser, $jobId) {
        $assoStatsRaw =  Association::whereIn('job_id',$jobId)
                            ->where('accountmanager_id',$authuser->id)/*->where('gdpr_status',1)*/
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
        //});

        foreach ($assoStatsRaw as $stats){
            $assoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        //$vendorAcceptedAtRaw = Cache::remember('getAssignedprogressjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId) {
        $vendorAcceptedAtRaw =  Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->whereIn('job_id',$jobId)
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->select('job_id', 'created_at')
                                    ->groupBy('job_id')
                                    ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats){
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }

        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;

            if(isset($assoStats[$job['job_id']])){
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;

            if($assignedTo == $rejectedBy){
                $assignedprogressjobs_dummy->forget($key);
            }
        }
        $assignedprogressjobsall = $assignedprogressjobs_dummy->values();
        //print_r($assignedprogressjobs_dummy->values());
        return response()->success(compact('assignedprogressjobsall'));
    }
    public function getAdminassignedprogressjobs()
    {
        $authuser = Auth::user();
        $adminassignedprogressjobs = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        foreach ($adminassignedprogressjobs as $job) {
            $vendorAcceptedAt=Activity::where('admin_id',1)
                                ->where('accountmanager_id',intval($job['accountmanager_id']))
                                ->where('employer_id',intval($job['employer_id']))
                                ->whereNull('job_status')
                                ->where('job_id',intval($job['job_id']))
                                ->whereNull('vendor_id')
                                ->where('activity_by',intval($job['accountmanager_id']))
                                ->whereNull('status_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->first();
            $receivedProfiles=Association::where('job_id',$job->job['id'])
                    ->where('admin_id',$authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNotNull('employer_id')
                    ->count();
            $rejectedProfiles=Association::where('job_id',$job->job['id'])
                            ->where('admin_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->count();
            $shorlistedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'encrypted_jobId'=>$encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;

                if(($vendorAcceptedAt))
                    {$job['am_job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['am_job_accept_time'] = 0;}
        }

        return response()->success(compact('adminassignedprogressjobs'));
    }

    public function getAssignedclosedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $assignedclosedjobs = Association::whereNotNull('job_id')->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->where('accountmanager_id',$authuser->id)
                            ->with('employer')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();

        foreach ($assignedclosedjobs as $job) {
            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->where('job_id',intval($job['job_id']))
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();

            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles,'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles,  'encrypted_jobId'=>$encrypted, ];
            $job['numbers'] = $numbers;
            if(count($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
        }
        return response()->success(compact('assignedclosedjobs'));
    }

    public function getAssignedclosedjobsall()
    {
        $authuser = Auth::user();
        $assignedclosedjobsall = Association:: where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        foreach ($assignedclosedjobsall as $job) {
            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->where('job_id',intval($job['job_id']))
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();

            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles,'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles,  'encrypted_jobId'=>$encrypted, ];
            $job['numbers'] = $numbers;
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
        }
        return response()->success(compact('assignedclosedjobsall'));
    }

    public function getAdminassignedclosedjobs()
    {
        $authuser = Auth::user();
        $adminassignedclosedjobs = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        foreach ($adminassignedclosedjobs as $job) {
            $vendorAcceptedAt=Activity::where('admin_id',1)
                                ->where('accountmanager_id',intval($job['accountmanager_id']))
                                ->where('employer_id',intval($job['employer_id']))
                                ->whereNull('job_status')
                                ->where('job_id',intval($job['job_id']))
                                ->whereNull('vendor_id')
                                ->where('activity_by',intval($job['accountmanager_id']))
                                ->whereNull('status_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->first();
            $receivedProfiles=Association::where('job_id',$job->job['id'])
                    ->where('admin_id',$authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNotNull('employer_id')
                    ->count();
            $rejectedProfiles=Association::where('job_id',$job->job['id'])
                            ->where('admin_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->count();
            $shorlistedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'encrypted_jobId'=>$encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;
                if($vendorAcceptedAt)
                    {$job['am_job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['am_job_accept_time'] = 0;}
        }

        return response()->success(compact('adminassignedclosedjobs'));
    }

    public function getEmployersummery()
    {
        $authuser = Auth::user();
        if($authuser->parent_id) {
            $authId=$authuser->parent_id;

            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->with('assingnedJob')
                            ->whereHas('assingnedJob',function($query){ $query->where('status','=',8); })
                            ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach($a as $c){array_push($b, $c);}

            $employersummery = Association::where('vendor_id',$authuser->parent_id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                                ->get();

                                foreach($employersummery as $employee)
                                {
                                    $vendorselectedcandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',27)
                                                ->count();
                                    $vendordirectjoincandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',28)
                                                ->count();
                                    $vendorphonecandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',17)
                                                ->count();
                                    $vendorftfcandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',18)
                                                ->count();
                                     $vendorfintcandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',20)
                                                ->count();
                                    $vendorwalkincandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',21)
                                                ->count();
                                    $vendorskypecandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',22)
                                                ->count();
                                     $vendordirectcandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',23)
                                                ->count();
                                    $vendorholecandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',24)
                                                ->count();
                                    $vendorrascandidates = Association::where('vendor_id',$authuser->parent_id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',30)
                                                ->count();
                                    $numbers = ['vendorselectedcandidates'=>$vendorselectedcandidates,'vendordirectjoincandidates'=>$vendordirectjoincandidates,'vendorphonecandidates'=>$vendorphonecandidates,'vendorftfcandidates'=>$vendorftfcandidates,'vendorfintcandidates'=>$vendorfintcandidates,'vendorwalkincandidates'=>$vendorwalkincandidates,'vendorskypecandidates'=>$vendorskypecandidates,'vendordirectcandidates'=>$vendordirectcandidates,'vendorholecandidates'=>$vendorholecandidates,'vendorrascandidates'=>$vendorrascandidates];
                                    $employee['numbers'] = $numbers;
                    
                                    //echo ''; print_r($employee); echo '';
                                }

        } else {
            $authId=$authuser->id;


            /*$employersummery = Association::where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                               ->get();*/

            /*$employersummery = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->groupBy('employer_id')->with('employer.company')->get();*/

            $employersummery=Association::where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                                ->get();
            
                                foreach($employersummery as $employee)
                                {
                                    $vendorselectedcandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',27)
                                                ->count();
                                    $vendordirectjoincandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',28)
                                                ->count();
                                    $vendorphonecandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',17)
                                                ->count();
                                    $vendorftfcandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',18)
                                                ->count();
                                     $vendorfintcandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',20)
                                                ->count();
                                    $vendorwalkincandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',21)
                                                ->count();
                                    $vendorskypecandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',22)
                                                ->count();
                                     $vendordirectcandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',23)
                                                ->count();
                                    $vendorholecandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',24)
                                                ->count();
                                    $vendorrascandidates = Association::where('vendor_id',$authuser->id)
                                                ->where('employer_id',$employee->employer_id)
                                                ->whereNotNull('vendor_id')
                                                ->whereNotNull('employer_id')
                                                ->whereNull('vendor_user_id')
                                                ->whereNull('employer_user_id')
                                                ->whereNotNull('job_id')
                                                ->whereNotNull('candidate_id')
                                                ->where('candidate_status',30)
                                                ->count();
                                    $numbers = ['vendorselectedcandidates'=>$vendorselectedcandidates,'vendordirectjoincandidates'=>$vendordirectjoincandidates,'vendorphonecandidates'=>$vendorphonecandidates,'vendorftfcandidates'=>$vendorftfcandidates,'vendorfintcandidates'=>$vendorfintcandidates,'vendorwalkincandidates'=>$vendorwalkincandidates,'vendorskypecandidates'=>$vendorskypecandidates,'vendordirectcandidates'=>$vendordirectcandidates,'vendorholecandidates'=>$vendorholecandidates,'vendorrascandidates'=>$vendorrascandidates];
                                    $employee['numbers'] = $numbers;
                    
                                    //echo ''; print_r($employee); echo '';
                                }
        }

            //die;
        return response()->success(compact('employersummery'));
    }

    public function getUseremployersummery()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $useremployersummery = Association::where('vendor_id',$supervendor[0]->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->groupBy('employer_id')
                            ->with('employer.company')
                           ->get();
        return response()->success(compact('useremployersummery'));
    }

    public function getEmpsummarydesc($id)
    {
        $authuser = Auth::user();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
             $profiles_submitted = Association::where('vendor_id',$authuser->parent_id)
                                ->whereNotNull('accountmanager_id')
                                /*->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*/
                                ->where('job_status',3)
                                 ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',8); })
                                //->where('created_at','>=',$diff_date)
                                 ->count();
                                

        $profiles_closed=Association::where('vendor_id',$authuser->parent_id)
                                ->whereNotNull('accountmanager_id')
                               /* ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*///->where('created_at','>=',$diff_date)
                                ->where('job_status',3)
                                ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',6); })
                                 ->count();
           
        } else {$authId = $authuser->id;
             $profiles_submitted = Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                /*->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*/
                                ->where('job_status',3)
                                 ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',8); })
                                //->where('created_at','>=',$diff_date)
                                 ->count();
                                

        $profiles_closed=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                               /* ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*///->where('created_at','>=',$diff_date)
                                ->where('job_status',3)
                                ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',6); })
                                 ->count();
            
        }
        $supervendor = User::where('id',$authuser)->get(['first_name','parent_id']);
        $candidates = array();
       

       

       
        $jobs_worked = Association::where('employer_id',$id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        $empsummarydesc[] = array('profiles_submitted'=>$profiles_submitted,'profiles_closed'=>$profiles_closed,'employer_id'=>$id,'jobs_worked'=>$jobs_worked);
        return response()->success(compact('empsummarydesc'));
    }
    
	public function PostSubvendorperformance() {
        $vendor_id=Input::get('vendor_id');
		$venInfo = DB::table('users')->where('id', $vendor_id)->get();
		
		$vendoruserjobs = VendorUserJob::where('vendor_user_id',$vendor_id)->with('job')->groupBy('job_id')->get()->toArray();
		$noOfJobs = (is_array($vendoruserjobs)) ? count($vendoruserjobs) : "0";
		foreach($vendoruserjobs as $key =>$jobs) {
			$job_ids[] = $jobs['job_id'];
		}
		$kpiInfo = DB::table('kpi_weight')->where('vendor_id', $vendor_id)->get();
		
		$totalSubmit = Association::where('vendor_id', $vendor_id)
							->whereIn('job_id',$job_ids)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			//print_r($totalSubmit);exit;
			$submition_ratio = (!empty($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
			$submitiongreen = $submition_ratio;
			$submitionyellow = $submition_ratio/2;
			$submitionred = 0;
			$submitioncolor ="";
			if($totalSubmit!=0) {
				$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
			}else {
				$submitionRatio = 0;
			}
			
			if($submitionRatio >= $submitiongreen) {
				$submitioncolor = "#03d410";
			} else if($submitionRatio >= $submitionyellow && $submitionRatio < $submitiongreen) {

				$submitioncolor = "#ffcd00 ";
			} else {
				$submitioncolor = "#fc0c01";
			}
			
			$totalShortlist = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status',5)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$shortlisted_ratio = (isset($kpiInfo[0]->shortlisted_ratio)) ? $kpiInfo[0]->shortlisted_ratio : '1';
			
			$shortlistgreen = $shortlisted_ratio;
			$shortlistyellow = ((int)$shortlisted_ratio/2);
			$shortlistred = 0;
			$shortlistcolor ="";
			if($totalShortlist!=0) {
				$shortlistToSubmitionRatio = $totalShortlist/$totalSubmit;
			}else {
				$shortlistToSubmitionRatio = 0;
			}
			if($shortlistToSubmitionRatio >= $shortlistgreen) {
				$shortlistcolor = "#03d410";
			} else if($shortlistToSubmitionRatio >= $shortlistyellow && $shortlistToSubmitionRatio < $shortlistgreen) {

				$shortlistcolor = "#ffcd00 ";
			} else {
				$shortlistcolor = "#fc0c01";
			}
			$totInterview = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->whereIn('candidate_status',[9,10,13,17,18,20, 21, 22, 23])
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$interview_ratio = (!empty($kpiInfo[0]->interview_ratio)) ? $kpiInfo[0]->interview_ratio : '1';

			$interviewgreen = $interview_ratio;
			$interviewyellow = (!empty($interview_ratio)) ? $interview_ratio/2 : "0";
			$interviewred = 0;
			$interviewcolor ="";
			if($totInterview!=0) {
				$interviewToSubmitionRatio = round($totInterview/$totalSubmit,2);
			} else {
				$interviewToSubmitionRatio = 0;
			}
			if($interviewToSubmitionRatio >= $interviewgreen) {
				$interviewcolor = "#03d410";
			} else if($interviewToSubmitionRatio >= $interviewyellow && $interviewToSubmitionRatio < $interviewgreen) {

				$interviewcolor = "#ffcd00 ";
			} else {
				$interviewcolor = "#fc0c01";
			}
			
			$totSelect = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 3)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$selection_ratio = (isset($kpiInfo[0]->selection_ratio)) ? $kpiInfo[0]->selection_ratio : '1';
			$selectiongreen = $selection_ratio;
			$selectionyellow = $selection_ratio/2;
			$selectionred = 0;
			$selectioncolor ="";
			if($totSelect!=0) {
				$selectionToSubmitionRatio = round($totSelect/$totalSubmit,2);
			} else {
				$selectionToSubmitionRatio = 0;
			}
			if($selectionToSubmitionRatio >= $selectiongreen) {
				$selectioncolor = "#03d410";
			} else if($selectionToSubmitionRatio >= $selectionyellow && $selectionToSubmitionRatio < $selectiongreen) {

				$selectioncolor = "#ffcd00 ";
			} else {
				$selectioncolor = "#fc0c01";
			}
			
			$totCloser = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 44)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$closer_ratio = (isset($kpiInfo[0]->closer_ratio)) ? $kpiInfo[0]->closer_ratio : '1';
			
			$closergreen = $closer_ratio;
			$closeryellow = $closer_ratio/2;
			$closerred = 0;
			$closercolor ="";
			if($totCloser!=0) {
				$closerToSubmitionRatio = round($totCloser/$totalSubmit,2);
			} else {
				$closerToSubmitionRatio = 0;
			}
			if($closerToSubmitionRatio >= $closergreen) {
				$closercolor = "#03d410";
			} else if($closerToSubmitionRatio >= $closeryellow && $closerToSubmitionRatio < $closergreen) {

				$closercolor = "#ffcd00 ";
			} else {
				$closercolor = "#fc0c01";
			}
			
			$totJoin = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 45)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$joining_ratio = (isset($kpiInfo[0]->joining_ratio)) ? $kpiInfo[0]->joining_ratio : '1';
			$joininggreen = $joining_ratio;
			$joiningyellow = $joining_ratio/2;
			$joiningred = 0;
			$joiningcolor ="";
			if($totJoin!=0) {
				$joiningToSubmitionRatio = round($totJoin/$totalSubmit,2);
			} else {
				$joiningToSubmitionRatio = 0;
			}
			if($joiningToSubmitionRatio >= $joininggreen) {
				$joiningcolor = "#03d410";
			} else if($joiningToSubmitionRatio >= $joiningyellow && $joiningToSubmitionRatio < $joininggreen) {

				$joiningcolor = "#ffcd00 ";
			} else {
				$joiningcolor = "#fc0c01";
			}
			
			$totalReject = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->whereIn('candidate_status',array(1,2,30))
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			if($totalReject!=0) {
				$totalRejectRatio = round(($totalReject *100)/$totalSubmit,2);
			} else {
				$totalRejectRatio = 0;
			}
			$rejectionratio = (isset($kpiInfo[0]->rejection_ratio)) ? $kpiInfo[0]->rejection_ratio : '20';	
			
			$rejectiongreen = $rejectionratio;
			$rejectionyellow = $rejectionratio/2;
			$rejectionred = 0;
			$rejectioncolor ="";
			if($totalRejectRatio >= $rejectiongreen) {
				$rejectioncolor = "#03d410";
			} else if($totalRejectRatio >= $rejectionyellow && $totalRejectRatio < $rejectiongreen) {

				$rejectioncolor = "#ffcd00 ";
			} else {
				$rejectioncolor = "#fc0c01";
			}
			
			$vendorInformation[] = array('name'=>$venInfo[0]->first_name,
										'vendor_id'=>$venInfo[0]->id, 
										'total_submition' =>array('submition_ratio'=>$submition_ratio,
																  'weight'=>$submition_ratio,
																  'red' =>$submitionred,
																  'yellow' =>$submitionyellow,
																  'green' =>$submitiongreen, 
																  'color'=>$submitioncolor
																),
										'total_shortlisted' =>array('shortlisted_ratio'=>$shortlisted_ratio,
																  'weight'=>$shortlisted_ratio,
																  'red' =>$shortlistred,
																  'yellow' =>$shortlistyellow,
																  'green' =>$shortlistgreen, 
																  'color'=>$shortlistcolor
																),
										'total_interview' =>array('interview_ratio'=>$interview_ratio,
																  'weight'=>$interview_ratio,
																  'red' =>$interviewred,
																  'yellow' =>$interviewyellow,
																  'green' =>$interviewgreen, 
																  'color'=>$interviewcolor
																),
										'total_selection' =>array('interview_ratio'=>$selection_ratio,
																  'weight'=>$selection_ratio,
																  'red' =>$selectionred,
																  'yellow' =>$selectionyellow,
																  'green' =>$selectiongreen, 
																  'color'=>$selectioncolor
																),
										'total_closer' =>array('closer_ratio'=>$closer_ratio,
																  'weight'=>$closer_ratio,
																  'red' =>$closerred,
																  'yellow' =>$closeryellow,
																  'green' =>$closergreen, 
																  'color'=>$closercolor
																),
										'total_joining' =>array('joining_ratio'=>$joining_ratio,
																  'weight'=>$joining_ratio,
																  'red' =>$joiningred,
																  'yellow' =>$joiningyellow,
																  'green' =>$joininggreen, 
																  'color'=>$joiningcolor
																),
										'total_rejection' =>array('rejectionratio'=>$rejectionratio,
																  'weight'=>$rejectionratio,
																  'red' =>$rejectionred,
																  'yellow' =>$rejectionyellow,
																  'green' =>$rejectiongreen, 
																  'color'=>$rejectioncolor
																),
										'submitionRatio' =>$submitionRatio,
										'shortlistToSubmitionRatio' =>$shortlistToSubmitionRatio,
										'interviewToSubmitionRatio' =>$interviewToSubmitionRatio,
										'selectionToSubmitionRatio' =>$selectionToSubmitionRatio,
										'closerToSubmitionRatio' =>$closerToSubmitionRatio,
										'joiningToSubmitionRatio' =>$joiningToSubmitionRatio,
										'totalRejectRatio' =>$totalRejectRatio
										);
		//print_r($vendorInformation);exit;
		return response()->success(compact('subvendorInformation'));
		
	}
    public function getVendorteamsummary($id)
    {	
		//$this->getSubvendorperformance($id);
		//exit;
        $authuser = Auth::user();
        $candidatesteam = $vendorUserjobIds = array();

        $vendoruserjobs=VendorUserJob::where('vendor_user_id',$id)->with('job')->groupBy('job_id')->get();

        foreach($vendoruserjobs as $job)
            {
                $thisJob = 0;
                array_push($vendorUserjobIds, $job->job_id);
                $thisJob=Association::where('job_id',intval($job->job_id))
                            ->whereNotNull('accountmanager_id')
                            ->where('candidate_status',19)
                            ->where('vendor_approval',0)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->where('vendor_id',$authuser->id)
                            ->whereNull('vendor_user_id')
                            ->get();
                if(count($thisJob)) :
                    $job['job']['activate_action_check'] = 1;
                else:
                    $job['job']['activate_action_check'] = 0;
                endif;
            }
        $vendoractivitycandidate = Association::where('vendor_id',$authuser->id)
                                ->whereIn('job_id',$vendorUserjobIds)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->get();
        foreach($vendoractivitycandidate as $can)
            {array_push($candidatesteam, $can->candidate_id);}

            $alljobs=Association::where('vendor_id',$authuser->id)
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNull('candidate_id')
                            ->with('job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->count();

            // $profiles_submitted=Association::where('vendor_id',$authuser->id)
            //                 ->whereIn('job_id',$vendorUserjobIds)
            //                 ->whereNotNull('candidate_id')
            //                 ->distinct('candidate_id')
            //                 ->count();

            $profiles_submitted=Activity::where('vendor_id',$authuser->id)
                                ->where('vendor_user_id',$id)
                                ->whereIn('job_id',$vendorUserjobIds)
                                ->whereNotNull('candidate_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->whereNull('status_id')
                                ->whereNull('job_status')
                                ->groupBy(array('candidate_id','job_id'))
                                ->get();

            $selectedprofiles = Association::whereIn('candidate_id',$candidatesteam)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->count();

            //$candidates = Candidate::where('vendor_id',$authuser->id)->count();

            $candidates = Association::where('vendor_id',$authuser->id)
                                    ->whereIn('job_id',$vendorUserjobIds)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->get();

            $jobsclosed = Association::whereIn('candidate_id',$candidatesteam)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->count();

      $vendorteamsummary[] = array('jobs'=>$vendoruserjobs,'profiles_submitted'=>count($profiles_submitted),'alljobs'=>$alljobs,'candidates'=>count($candidates),'jobsclosed'=>$jobsclosed,'selectedprofiles'=>$selectedprofiles);
        return response()->success(compact('vendorteamsummary'));
    }

    public function postGetvendoruservsa()
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else{$authId=$authuser->id;}
        /*$authuser = Auth::user();
        $authId = $authuser->id;*/
        $jobId=Input::get('jobIds');
        $vendoruserId=Input::get('vendorId');

        $accountmanager_id=Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        foreach ($jobId as $key => $value) {
            $a=false;
            $a=Activity::where('vendor_id',$authId)
                        ->whereNotNull('employer_id')
                        ->where('vendor_user_id',$vendoruserId)
                        ->where('job_id',intval($value))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->where('activity_by',$authId)
                        /*->whereNotNull('status_id')*/
                        /*->where('is_vendor_sourcing_activity',1)*/
                        /*->with('activityuser.role','status','candidate')
                        ->with('job')
                        ->with('sourcingStatus')*/
                        ->get();
            if(count($a)){
                $getvendoruservsa[$key]=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('vendor_user_id',$vendoruserId)
                                    ->where('job_id',intval($value))
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('activity_by',$authId)
                                    /*->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)*/
                                    /*->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')*/
                                    ->get();
            }
        }//foreach

        // if ($authuser->parent_id) :
        //     $vendorstattimeline=Activity::where('vendor_id',$authId)
        //                 ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
        //                 ->where('admin_id',1)
        //                 ->where('vendor_user_id',$authuser->id)
        //                 ->where('job_id',intval($jobId))
        //                 ->where('accountmanager_id',$accountmanager_id)
        //                 ->where('activity_by',$authId)
        //                 ->whereNotNull('status_id')
        //                 ->where('is_vendor_sourcing_activity',1)
        //                 ->with('activityuser.role','status','candidate')
        //                 ->with('job')
        //                 ->with('sourcingStatus')
        //                 ->get();
        // else :
        //     $vendorstattimeline=Activity::where('vendor_id',$authId)
        //                 ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
        //                 ->where('admin_id',1)
        //                 ->where('job_id',intval($jobId))
        //                 ->where('accountmanager_id',$accountmanager_id)
        //                 ->whereNull('vendor_user_id')
        //                 ->where('activity_by',$authId)
        //                 ->whereNotNull('status_id')
        //                 ->where('is_vendor_sourcing_activity',1)
        //                 ->with('activityuser.role','status','candidate')
        //                 ->with('job')
        //                 ->with('sourcingStatus')
        //                 ->get();
        // endif;
        return response()->success(compact('getvendoruservsa'));
    }

    public function getVendorsummary($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){
            $authId=$authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');

            $profiles_submitted=Association::whereIn('job_id',$empActIds)
                                        ->where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->count();

            $profiles_closed = Association::whereIn('job_id',$empActIds)
                                            ->where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->where('candidate_status',6)
                                            ->count();

            $jobs_worked = Association::whereIn('job_id',$empActIds)
                                        ->where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNull('candidate_id')->with('job')
                                        ->groupBy('job_id')
                                        ->get();
        } else {
            $authId=$authuser->id;
            $profiles_submitted=Association::where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->where('candidate_status', 31)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->count();
                                            
            $profiles_closed = Association::where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->where('candidate_status',6)
                                            ->count();

            $jobs_worked = Association::where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNull('candidate_id')->with('job')
                                        ->groupBy('job_id')
                                        ->get();
        }
        $vendorsummary[] = array('profiles_submitted'=>$profiles_submitted,'profiles_closed'=>$profiles_closed,'vendor_id'=>$id,'jobs_worked'=>$jobs_worked);
        return response()->success(compact('vendorsummary'));
    }


    public function getAmprofilescount($id)
    {
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        $amprofilescount = [];
        if($job_details[0]['gdprmandatory']){
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                /*->where('gdpr_status',1)*/
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->count();
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')/*->where('gdpr_status',1)*/
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereIn('candidate_status',array(1,2,30))
                                ->whereNotNull('candidate_status')/*->where('gdpr_status',1)*/
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
        } else{
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                               // ->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })
                                ->count();
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereIn('candidate_status',array(1,2,30))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
        }

        $aminactivecandidates_wgdpr = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            /*->where('gdpr_status',1)*/
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })->count();
        $aminactivecandidates_wogdpr= Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            //->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })->count();
        $aminactivecandidates = $aminactivecandidates_wgdpr + $aminactivecandidates_wogdpr;

        $numbers = ['amassignedpendingcandidates'=>$amassignedpendingcandidates,
                    'amshortlistedcandidates'=>$amshortlistedcandidates,
                    'amrejectedcandidates'=>$amrejectedcandidates,
                    'aminactivecandidates'=>$aminactivecandidates];
        $amprofilescount['numbers'] = $numbers;
        return response()->success(compact('amprofilescount'));
    }
    public function getAmassignedpendingcandidates($id)
    {	//$this->postAmrecruiterperformancethree();
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']){
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                /*->where('gdpr_status',1)*/
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor','vendor.company','job','candidate.candidate_operational_skill','candidate.educations','CandidateSkills','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                                ->with('CandidateDetails')
                                ->with('CandidateNotes')
                                ->with('GdprData')
                                //->with('Predefinedquestionsanswers')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->get();
        } else{
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor','vendor.company','job','candidate.candidate_operational_skill','candidate.educations','CandidateSkills','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills','GdprData'))
                                ->with('CandidateDetail')
                                ->with('CandidateNotes')
                                //->with('Predefinedquestionsanswers')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })
                                ->get();
        }
        //echo '<pre>'; print_r($amassignedpendingcandidates); die;

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        //echo $empTimezone.'empTimezone';
        foreach ($amassignedpendingcandidates as $candidate) {

            //echo '<pre>'; print_r($candidate['CandidateNotes']['updated_at']); echo '</pre>';

            // $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
            // $created_at = explode('-', $created_date);
            
            // $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
            // $date->format('Y-m-d H:i:s');

            // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            // $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

            // $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
                
            //echo '<pre>'; print_r($candidate->candidate['phone']); echo '</pre>----'; //die;
            if(isset($candidate->candidate['phone']) && !empty($candidate->candidate['phone']))
            {
                $candidate->candidate['phone']=str_replace("91-","",$candidate->candidate['phone']);
                $candidate->candidate['phone']=str_replace("+91","",$candidate->candidate['phone']);
                $candidate->candidate['phone']=str_replace("+91 ","",$candidate->candidate['phone']);
            }
            $shareData = ShareLinkActivitys::where('job_id',$id)
                        ->where('candidate_id',$candidate['candidate_id'])
                        ->where('accountmanager_id',$authuser->id)
                        ->get();



        $Rchilcntl = new RchilliController();
        $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);

        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);


        $candidate['talentmoning']= $candidateTalentMine;
        $candidate['candidateSpectrum']= $candidateSpectrum;
         $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

          $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
             $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidate['sharealink'] = $shareData;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                            ->where('candidate_id', $candidate['candidate_id'])
                            ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
			$candidateSkillblock = DB::table('skillblock_resume')->where('candidate_id', $candidate['candidate_id'])->get();
            $gdprData = DB::table('gdpr_datas')->where('candidate_id', $candidate['candidate_id'])->where('job_id', $id)->first();
			$candidate['candidateskillblocks'] = $candidateSkillblock;
            $candidate['gdprData'] = $gdprData;
             $predefinedInfo = DB::table('job_orders')->select('questions')->where('id',$id)->get();
                  if ($predefinedInfo[0]->questions == "NO" || $predefinedInfo[0]->questions == null || $predefinedInfo[0]->questions == '' )
                    {
                        $candidate['PredefinedquestionsanswersData'] = 1;
                    }
                else{
                  $Predefinedquestionsanswers = Predefinedquestionsanswers::where('candidate_id', $candidate['candidate_id'])->get();
                 if(($Predefinedquestionsanswers) && count($Predefinedquestionsanswers)>0) {
                    $candidate['PredefinedquestionsanswersData'] = 1;
                 } else {
                          $candidate['PredefinedquestionsanswersData'] = 0;
                        }
                }
            $colors =Colors::get();
            foreach($amassignedpendingcandidates as $key=>$value) {
                $value['color'] = $colors[$key]->name;
            }

        }
        return response()->success(compact('amassignedpendingcandidates'));
    }

    public function getAminactivecandidates($id)
    {
        $authuser = Auth::user();
        $aminactivecandidates_wgdpr = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            /*->where('gdpr_status',1)*/
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with('CandidatePoints')
                            ->with('gdprData')
                            ->with('Predefinedquestionsanswers')
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                            ->with('CandidateNotes')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })->get();
        $aminactivecandidates_wogdpr= Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            //->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with('CandidatePoints')
                            ->with('gdprData')
                            ->with('Predefinedquestionsanswers')
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                            ->with('CandidateNotes')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })->get();
        $aminactivecandidates = $aminactivecandidates_wgdpr->merge($aminactivecandidates_wogdpr);
         $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
         $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
           
        foreach ($aminactivecandidates as $candidate) {
            $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

                $candidate['timezone'] = $empTimezone[0]['GMT_offset'];

        $Rchilcntl = new RchilliController();
        $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);

        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);


        $candidate['talentmoning']= $candidateTalentMine;
        $candidate['candidateSpectrum']= $candidateSpectrum;
         $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

          $candidate['skils_block'] = $skils_block;
          $gdprData = DB::table('gdpr_datas')->where('candidate_id', $candidate['candidate_id'])->where('job_id', $id)->first();
            $candidate['gdprData'] = $gdprData;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted_jobId = base64_encode($timestamp . $randomKey . $id);
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
             $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                            ->where('candidate_id', $candidate['candidate_id'])
                            ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid,'encrypted_jobId'=>$encrypted_jobId];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $predefinedInfo = DB::table('job_orders')->select('questions')->where('id',$id)->get();
                  if ($predefinedInfo[0]->questions == "NO" || $predefinedInfo[0]->questions == null || $predefinedInfo[0]->questions == '' )
                    {
                        $candidate['PredefinedquestionsanswersData'] = 1;
                    }
                    else{
                  $Predefinedquestionsanswers = Predefinedquestionsanswers::where('candidate_id', $candidate['candidate_id'])->first();
                  if(($Predefinedquestionsanswers) && count(array($Predefinedquestionsanswers))>0) {
                    $candidate['PredefinedquestionsanswersData'] = 1;
                 } else {
                     $candidate['PredefinedquestionsanswersData'] = 0;
                 }
                    }
        }
		//print_r($aminactivecandidates);exit;
        return response()->success(compact('aminactivecandidates'));
    }

    public function getAmshortlistedcandidates($id)
    {
        $authuser = Auth::user();
		//$this->getAmrecruiterperformance();
		//exit;
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']) {
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')->where('gdpr_status',1)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->with(array('Status','Candidate','Vendor',
'vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->with('CandidateNotes')
                                 ->with('CandidatePoints')
                                 ->with('CandidateDetails')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->get();
		//print_r($amshortlistedcandidates);exit;
        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
           
            foreach ($amshortlistedcandidates as $candidate) {
                $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                // $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

                $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
                $shareData = ShareLinkActivitys::where('job_id',$id)
                            ->where('candidate_id',$candidate['candidate_id'])
                            ->where('accountmanager_id',$authuser->id)
                            ->get();
                $Rchilcntl = new RchilliController();
                $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
                $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
                $candidate['talentmoning']= $candidateTalentMine;
                $candidate['candidateSpectrum']= $candidateSpectrum;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
                $candidate['skils_block'] = $skils_block;
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidate['sharealink'] = $shareData;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();

                $candidate['vendorcandidatenotes'] = $candidatenotes;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

                $candidate['skils_block'] = $skils_block;
            }
        } else {
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                        ->whereNotIn('candidate_status',array(1,2,30,6,19))
                        ->whereNotNull('candidate_status')
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job'))
                        ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                        ->with('CandidateNotes')
                         ->with('CandidatePoints')
                         ->with('CandidateDetails')
                        ->whereHas('CandidatePoints',function($query) use ($id){
                            $query->where('job_id','=',$id);
                        })->get();
			
            foreach ($amshortlistedcandidates as $candidate) {
                $shareData = ShareLinkActivitys::where('job_id',$id)
                            ->where('candidate_id',$candidate['candidate_id'])
                            ->where('accountmanager_id',$authuser->id)
                            ->get();
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills = explode(',', $candidate['CandidateSkills']['skills']);

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mached_skills_preferred = array_intersect($job_skills_preferred, $candidate_skills);
                $mached_skills_required = array_intersect($job_skills_required, $candidate_skills);
                $candidates_merge = array_merge($mached_skills_preferred, $mached_skills_required);

                $i = 0;
                $obj = new \stdClass;
                foreach($candidates_merge as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['sharealink'] = $shareData;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();
                $candidate['vendorcandidatenotes'] = $candidatenotes;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

                $candidate['skils_block'] = $skils_block;
            }
        }
        return response()->success(compact('amshortlistedcandidates'));
    }

    public function getAmrejectedcandidates($id)
    {
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']){
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->whereNotNull('candidate_status')->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                             ->with('CandidatePoints')
                             ->with('CandidateDetails')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->get();
            foreach ($amrejectedcandidates as $candidate) {
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
                $Rchilcntl = new RchilliController();
                $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
                $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
                $candidate['talentmoning']= $candidateTalentMine;
                $candidate['candidateSpectrum']= $candidateSpectrum;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
                $candidate['skils_block'] = $skils_block;

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();

                $candidate['vendorcandidatenotes'] = $candidatenotes;
            }
        } else {
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                             ->with('CandidatePoints')
                             ->with('CandidateDetails')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->get();
            foreach ($amrejectedcandidates as $candidate) {
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();
                $candidate['vendorcandidatenotes'] = $candidatenotes;
            }
        }
        return response()->success(compact('amrejectedcandidates'));
    }

    public function postActivitycomment()
    {
        $authuser = Auth::user();
        $AdminData = explode(",", Input::get('admin_id'));
    //  print_r($AdminData[]);
if(count($AdminData) == 6){
    $adminId=$AdminData[0];
    $accountmanagerId=$AdminData[1];
    $employerId=$AdminData[2];
    $vendorId=$AdminData[3];
    $jobId=$AdminData[4];
    $candidateId=$AdminData[5];
}else {
    $adminId=Input::get('admin_id');
    $accountmanagerId=Input::get('accountmanager_id');
    $employerId=Input::get('employer_id');
    $vendorId=Input::get('vendor_id');
    $jobId=Input::get('job_id');
    $candidateId=Input::get('candidate_id');
}
    //    $adminId=$AdminData[0];
    //     $accountmanagerId=$AdminData[1];
    //     $employerId=$AdminData[2];
    //     $vendorId=$AdminData[3];
    //     $jobId=$AdminData[4];
    //     $candidateId=$AdminData[5];
//echo $adminId.'--'$accountmanagerId.'---'.$employerId.'----'.$vendorId.'----'.$jobId.'----'$candidateId;

      /*   $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id'); */

        $mobile = Input::get('name');
        $mobile = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile);
        $mobile = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $mobile,
            'accountmanager_id' => $accountmanagerId,
            'employer_id' => $employerId,
            'vendor_id' => $vendorId,
            'job_id' => $jobId,
            'name' => "Commented by vendor",
            'admin_id' => $adminId,
            'activity_by' => $authuser->id,
            'candidate_id' => $candidateId,
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivitycommentvendor()
    {
        $authuser = Auth::user();
        $AdminData = explode(",", Input::get('admin_id'));
        $adminId=$AdminData[0];
        $accountmanagerId=$AdminData[1];
        $employerId=$AdminData[2];
        $vendorId=$AdminData[3];
        $jobId=$AdminData[4];
        $candidateId=$AdminData[5];
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycommentvendor = Activity::create([
            'note' => $email,
            'accountmanager_id' => $accountmanagerId,
            'employer_id' => $employerId,
            'vendor_id' => $vendorId,
            'job_id' => $jobId,
            'name' => "Commented by vendor",
            'admin_id' => $adminId,
            'activity_by' => $authuser->id,
            'candidate_id' => $candidateId,
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivityusercomment()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->parent_id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->parent_id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivitydata()
    {
        $authuser = Auth::user();
        $adminId=Input::get('admin_id');     
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id ');
        $vendorId = Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');
        $activitydata = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }

    public function postActivitydatabyvendor()
    {
        $authuser = Auth::user();
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitydatabyvendor = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        return response()->success(compact('activitydatabyvendor'));
    }

    public function postActivitydatavendor()
    {
        $authuser = Auth::user();
        $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');
        $activitydatavendor = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydatavendor'));
    }

    public function postActivitydataam()
    {
        $authuser = Auth::user();
        $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');
        $status = Input::get('status');
        $activitydataam = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('name',"!=","Commented by vendor")
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->with('candidate')
                            ->get();
            $reasons_arr = array();
            foreach ($activitydataam as $job) {

                $accManagerCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
                $accManagerTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$accManagerCompanyID[0]->timezone)->get();

                $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                $date->setTimezone(new \DateTimeZone($accManagerTimezone[0]['timezone'])); 
                $job['created_at'] = $date->format('Y-m-d H:i:s');

                $job['timezone'] = $accManagerTimezone[0]['GMT_offset'];
                $job['accManagerTimezoneOffset'] = $accManagerTimezone[0]['GMT_offset'];

                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                    if (in_array($job['candidate_status'], $candidate_status_arr)){
                        foreach($reasons_arr as $reason){
                            $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                        }
                    }else{
                            $reasonsData = [];
                    }
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid,'reasonsData'=>$reasonsData];
                $job['numbers'] = $numbers;
                 $scheduled_date=Association::where('employer_id',$authuser->id)
                          ->where('vendor_id',$job['vendor_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
            if($scheduled_date) {
                $job['interview_schedule_date'] = $scheduled_date->interview_schedule_date;
                $job['association_id'] = $scheduled_date->id;
            }
            else {
             $job['association_id'] = $job['interview_schedule_date'] = null;
            }
        }
            // echo '<pre>';  print_r($reasons_arr);exit;
        return response()->success(compact('activitydataam'));
    }

    public function postActivityuserdata()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $activitydata = Activity::where('vendor_id',$supervendor[0]->parent_id)
                            ->where('admin_id',Input::get('admin_id'))
                            ->where('accountmanager_id',Input::get('accountmanager_id'))
                            ->where('employer_id',Input::get('employer_id'))
                            ->where('job_id',Input::get('job_id'))
                            ->where('candidate_id',Input::get('candidate_id'))
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }
    public function postUseractivitydata()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $vendoractivitycandidate = VendorActivities::where('job_id',Input::get('job_id'))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        $candidates = array();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
            $activitydata = Activity::whereIn('candidate_id',$candidates)->where('vendor_id',$supervendor[0]->parent_id)
                            ->where('admin_id',Input::get('admin_id'))
                            ->where('accountmanager_id',Input::get('accountmanager_id'))
                            ->where('employer_id',Input::get('employer_id'))
                            ->where('job_id',Input::get('job_id'))
                            ->where('candidate_id',Input::get('candidate_id'))
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }

    public function postActivitycommentemployer()
    {
        $authuser = Auth::user();
        $authId = null;
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        if($authuser->parent_id) {
             $mobile = $email;
             $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
             $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
             $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
             //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
             $activitycomment = Activity::create([
                'note' => $email,
                'accountmanager_id' => Input::get('accountmanager_id'),
                'employer_id' => $authuser->parent_id,
                'employer_user_id' => $authuser->id,
                'vendor_id' => Input::get('vendor_id'),
                'job_id' => Input::get('job_id'),
                'name' => "Commented by employer",
                'admin_id' => Input::get('admin_id'),
                'activity_by' => Input::get('employer_id'),
                'candidate_id' => Input::get('candidate_id'),
                'candidate_status' => Input::get('status'),
                'commentprivate' => Input::get('commentprivate')                
            ]);
        } else {
            $mobile = Input::get('name');
            $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
            $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
            $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
            //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
            $activitycomment = Activity::create([
                'note' => $email,
                'accountmanager_id' => Input::get('accountmanager_id'),
                'employer_id' => Input::get('employer_id'),
                'vendor_id' => Input::get('vendor_id'),
                'job_id' => Input::get('job_id'),
                'name' => "Commented by employer",
                'admin_id' => Input::get('admin_id'),
                'activity_by' => Input::get('employer_id'),
                'candidate_id' => Input::get('candidate_id'),
                'candidate_status' => Input::get('status'),
                'commentprivate' => Input::get('commentprivate')              
            ]);
        } //if   else
        return response()->success('Comment Has been added');
    }

    public function postActivitycommentam()
    {
        $authuser = Auth::user();
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $Activitycommentam = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => Input::get('vendor_id'),
            'job_id' => Input::get('job_id'),
            'name' => "Commented by account manager",
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id'),
        ]);
        return response()->success('Comment Has been added');
    }

    public function getVendorjobsclosed()
    {
        $authuser = Auth::user();
        $vendorjobsclosed = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->get();
        return response()->success(compact('vendorjobsclosed'));
    }

    public function getVendorteamjobsclosed()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $candidates = array();
        $vendoractivitycandidate = VendorActivities::whereNotNull('job_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
        $vendorteamjobsclosed = Association::whereIn('candidate_id',$candidates)->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->get();
        return response()->success(compact('vendorteamjobsclosed'));
    }

    public function getVendorselectedprofiles()
    {
        $authuser = Auth::user();
        if($authuser->parent_id){
            $authId=$authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->with('assingnedJob')
                            ->whereHas('assingnedJob',function($query){ $query->where('status','=',8); })
                            ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach($a as $c){array_push($b, $c);}
            $vendorselectedprofiles = Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$b)
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        } else {
            $vendorselectedprofiles = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        }

        foreach ($vendorselectedprofiles as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_id = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_id];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('vendorselectedprofiles'));
    }

    public function getVendoruserselectedprofiles()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $candidates = array();
        $vendoractivitycandidate = VendorActivities::whereNotNull('job_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
        $vendoruserselectedprofiles = Association::whereIn('candidate_id',$candidates)->where('vendor_id',$supervendor[0]->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',6)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        return response()->success(compact('vendoruserselectedprofiles'));
    }

    public function getCandidatenumbers($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        $amId = Association::where('job_id',$id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('candidate_status', '<>', 19)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by',$amId)->where('job_id',$id)->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();
        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)
                                            ->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $pendingcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->where('candidate_status',31)
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $candidatenumbers['totalcandidates'] = $assingedcandidates;
        $candidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $candidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $candidatenumbers['selectedcandidates'] = $selectedcandidates;
        $candidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('candidatenumbers'));
    }

    public function getVendorusercandidatenumbers($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id',$id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('vendor_user_id')
                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendorcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendorcandidatenumbers['rejectedcandidates'] = $rejectedids;
        $vendorcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendorcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendorcandidatenumbers['pendingcandidates'] = $pendingcandidates;

        return response()->success(compact('vendorcandidatenumbers'));
    }

    public function getVendorcandidatenumbers($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else{$authId=$authuser->id;}
        $amId = Association::where('job_id',$id)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);    }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $assingedcandidates=Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);    }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);}
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendorcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendorcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $vendorcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendorcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendorcandidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('vendorcandidatenumbers'));
    }
   

    public function postVendoruserjobcandidatenumbers()
    {
        $authuser = Auth::user();
        $vendorId= Input::get('vendorId');
        $id= Input::get('joborderId');
        $amId = Association::where('job_id',$id)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_id',$vendorId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            array_push($associationsIds, $candidate->id);
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)->where('vendor_id',$vendorId)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)->whereIn('id',$associationsIds)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$vendorId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendoruserjobcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendoruserjobcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $vendoruserjobcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendoruserjobcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendoruserjobcandidatenumbers['pendingcandidates'] = $pendingcandidates;

        return response()->success(compact('vendoruserjobcandidatenumbers'));
    }

    public function getAmcandidatenumbers($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id',$id)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by',$amId)->where('job_id',$id)->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();
        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        /* $allcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->get();*/
        $assingedcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $amcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $amcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $amcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $amcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $amcandidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('amcandidatenumbers'));
    }

    public function getAmmetrics($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $associated_emp_Ids = array();
        $associated_emps = Association::where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('employer')
                            ->groupBy('employer_id')
                            ->select('employer_id')
                            ->get();
        foreach($associated_emps as $job) {array_push($associated_emp_Ids, $job->employer_id);}
        $alljobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->count();
        $pendingjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                            })
                             ->count();
        /*$yet_to_accept = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                            })
                            ->count();*/
    $yet_to_accept = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->where('created_at','>=',$diff_date)
                            ->with('employer')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                            })
                            ->count();
   /* $yet_to_accept = Association::where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',3);
                            })
                            ->groupby('job_id')
                            ->havingRaw('count(vendor_id) < 1')
                            ->count();*/


        $assignedprogressjobs_dummy=Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();

        $jobId = array();
        foreach ($assignedprogressjobs_dummy as $job){
            $jobId[] = $job->job_id;
        }

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        $i = 0;
        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;


            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;


            if($assignedTo == $rejectedBy){
                $i--;
                $assignedprogressjobs_dummy->forget($key);
            }
            $i++;
        }
        //$assignedprogressjobsall = $assignedprogressjobs_dummy->values();
        //print_r($assignedprogressjobs_dummy->values()); die;
        //echo $i; die;
        $in_progress = $i;



        /*$in_progress = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->count(); */
        $closedJobs = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->where('created_at','>=',$diff_date)
                            ->with('employer')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->count();
        $rejected_by_am = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','=',2);
                            })
                            ->count();
        $rejected_by_vendor = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNull('candidate_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->where('job_status',2)
                            ->count();

        $amholdjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',24);
                            })
                            ->count();

        $profiles_gdpr=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })
                            ->get();
        $profiles_gdpr_yes=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('gdpr_status',1)
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })
                            ->get();
        $profiles = $profiles_gdpr->merge($profiles_gdpr_yes);
        $pending_profiles=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            //->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',19)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })
                            ->groupby('job_id')
                            ->get();
        $profiles_rejected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                           ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_phone=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',17)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_f2f=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',18)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_final=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',20)
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_interview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereNotIn('candidate_status',[19,7,2,1])
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_directinterview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',23)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_skype=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',22)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();

        $profiles_walkin=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',21)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();

        $profiles_selected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereIn('candidate_status',[27,28])
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count();

        $ammetrics[]=array('jobs_submitted'=>$alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor, 'amholdjobs' => $amholdjobs, 'profiles_received'=>$profiles,'profiles_pending'=>count($pending_profiles), 'profiles_rejected'=>$profiles_rejected , 'profiles_srt_phone'=>$profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected,'profiles_interview'=>$profiles_interview);
        return response()->success(compact('ammetrics'));
    }

    public function getVendordeviationrequest($id)
    {
        $authuser = Auth::user();

        if($authuser->parent_id) {
            $vendordeviationrequest = DeviationRequests::where('job_id', $id)
                                    ->where('vendor_user_id', $authuser->parent_id)
                                    ->get();
        } else {
            $vendordeviationrequest = DeviationRequests::where('job_id', $id)
                                    ->where('vendor_id', $authuser->id)
                                    ->get();
        }

        return response()->success(compact('vendordeviationrequest'));
    }

    public function postAmdeviationrequest()
    {
        $authuser = Auth::user();
        $vendor_id = Input::get('vendor_id');
        $job_id = Input::get('job_id');

        $amdeviationrequest = DeviationRequests::where('job_id', $job_id)
                                    ->where('vendor_id', $vendor_id)
                                    ->where('accountmanager_id', $authuser->id)
                                    ->get();

        return response()->success(compact('amdeviationrequest'));
    }

    public function getDatafromapi($id)
    {
        $apiUrl = "https://api.peopledatalabs.com/v5/person/enrich?pdl_id=" . $id;
        $apiKey = "d0615b66b3bffa3b1103ed140c56210dc988dc5c707e149bcaf045bf4b0fb523";

        try {
                $client = new Client();
                $response = $client->get($apiUrl, [
                    'headers' => [
                        'X-Api-Key' => $apiKey,
                    ],
                ]);
                if ($response->getStatusCode() === 200) {
                    //$responseData = $response->getBody()->getContents();
                    $responseData = json_decode($response->getBody()->getContents(), true);
                    if (isset($responseData['data'])) {
                        $data = [
                            'full_name' => $responseData['data']['full_name'],
                                'datalab_id' => $responseData['data']['id'],
                                'gender' => $responseData['data']['gender'],
                                'linkedin_url' => $responseData['data']['linkedin_url'],
                                'industry' => $responseData['data']['industry'],
                                'job_title' => $responseData['data']['job_title'],
                                'job_title_role' => $responseData['data']['job_title_role'],
                                'job_title_sub_role' => $responseData['data']['job_title_sub_role'],
                                'job_company_website' => $responseData['data']['job_company_website'],
                                'location_name' => $responseData['data']['location_name'],
                                'birth_date' => $responseData['data']['birth_date'],
                                'birth_year' => $responseData['data']['birth_year'],
                                'countries' => $responseData['data']['countries'],
                                'education' => $responseData['data']['education'],
                                'emails' => $responseData['data']['emails'],
                                'experience' => $responseData['data']['experience'],
                                'facebook_id' => $responseData['data']['facebook_id'],
                                'facebook_url' => $responseData['data']['facebook_url'],
                                'facebook_username' => $responseData['data']['facebook_username'],
                                'first_name' => $responseData['data']['first_name'],
                                'github_url' => $responseData['data']['github_url'],
                                'github_username' => $responseData['data']['github_username'],
                                'interests' => $responseData['data']['interests'],
                                'job_company_facebook_url' => $responseData['data']['job_company_facebook_url'],
                                'job_company_founded' => $responseData['data']['job_company_founded'],
                                'job_company_id' => $responseData['data']['job_company_id'],
                                'job_company_industry' => $responseData['data']['job_company_industry'],
                                'job_company_linkedin_id' => $responseData['data']['job_company_linkedin_id'],
                                'job_company_linkedin_url' => $responseData['data']['job_company_linkedin_url'],
                                'job_company_location_address_line_2' => $responseData['data']['job_company_location_address_line_2'],
                                'job_company_location_continent' => $responseData['data']['job_company_location_continent'],
                                'job_company_location_country' => $responseData['data']['job_company_location_country'],
                                'job_company_location_geo' => $responseData['data']['job_company_location_geo'],
                                'job_company_location_locality' => $responseData['data']['job_company_location_locality'],
                                'job_company_location_metro' => $responseData['data']['job_company_location_metro'],
                                'job_company_location_name' => $responseData['data']['job_company_location_name'],
                                'job_company_location_postal_code' => $responseData['data']['job_company_location_postal_code'],
                                'job_company_location_region' => $responseData['data']['job_company_location_region'],
                                'job_company_location_street_address' => $responseData['data']['job_company_location_street_address'],
                                'job_company_size' => $responseData['data']['job_company_size'],
                                'job_company_twitter_url' => $responseData['data']['job_company_twitter_url'],
                                'job_last_updated' => $responseData['data']['job_last_updated'],
                                'job_start_date' => $responseData['data']['job_start_date'],
                                'last_initial' => $responseData['data']['last_initial'],
                                'last_name' => $responseData['data']['last_name'],
                                'linkedin_id' => $responseData['data']['linkedin_id'],
                                'linkedin_username' => $responseData['data']['linkedin_username'],
                                'location_address_line_2' => $responseData['data']['location_address_line_2'],
                                'location_continent' => $responseData['data']['location_continent'],
                                'location_country' => $responseData['data']['location_country'],
                                'location_geo' => $responseData['data']['location_geo'],
                                'location_last_updated' => $responseData['data']['location_last_updated'],
                                'location_locality' => $responseData['data']['location_locality'],
                                'location_metro' => $responseData['data']['location_metro'],
                                'location_names' => $responseData['data']['location_names'],
                                'location_postal_code' => $responseData['data']['location_postal_code'],
                                'location_region' => $responseData['data']['location_region'],
                                'location_street_address' => $responseData['data']['location_street_address'],
                                'middle_initial' => $responseData['data']['middle_initial'],
                                'middle_name' => $responseData['data']['middle_name'],
                                'mobile_phone' => $responseData['data']['mobile_phone'],
                                'personal_emails' => $responseData['data']['personal_emails'],
                                'phone_numbers' => $responseData['data']['phone_numbers'],
                                'profiles' => $responseData['data']['profiles'],
                                'regions' => $responseData['data']['regions'],
                                'skills' => $responseData['data']['skills'],
                                'street_addresses' => $responseData['data']['street_addresses'],
                                'twitter_url' => $responseData['data']['twitter_url'],
                                'twitter_username' => $responseData['data']['twitter_username'],
                                'work_email' => $responseData['data']['work_email']
                                
                        ];
                        
                    
                        $uniqueIdentifier = ['datalab_id' => $id];
                    
                        DB::table('user_data')->updateOrInsert($uniqueIdentifier, $data);
                    } 
                    //
                    //
                    
                    return response()->json($responseData);
                } 

             else {
                return response()->json(['error' => 'API request failed'], $response->getStatusCode());
            }
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    public function postDatalabs()
    {
        $apiUrl = "https://api.peopledatalabs.com/v5/person/search";
        $apiKey = "d0615b66b3bffa3b1103ed140c56210dc988dc5c707e149bcaf045bf4b0fb523";
        $location_name = Input::get('location_name');
        $skills = Input::get('skills');

        if(is_array($skills)){
            $skills_array =  $skills;
        } 
        else {
         $skills_array = explode(',', $skills);
        }
       

        $client = new Client();

        $query = [
            "bool" => [
                "must" => [
                    [
                        "term" => [
                            "location_name" => $location_name,
                        ],
                    ],
                    [
                        "terms" => [
                            "skills" => $skills_array,
                        ],
                    ],
                    [
                        "exists" => [
                            "field" => "mobile_phone",
                        ],
                    ],
                    [
                        "exists" => [
                            "field" => "recommended_personal_email",
                        ],
                    ],
                    [
                        "exists" => [
                            "field" => "linkedin_username",
                        ],
                    ],
                ],
            ],
        ];

        $apiParameters = [
            "size" => 2,
            "query" => $query,
        ];

        try {
            $response = $client->post($apiUrl, [
                'headers' => [
                    'X-Api-Key' => $apiKey,
                ],
                'json' => $apiParameters,
            ]);
            $client = new Client();
            $response = $client->get($apiUrl, [
                'headers' => [
                    'X-Api-Key' => $apiKey,
                ],
                'json' => $apiParameters,
            ]);

            if ($response->getStatusCode() === 200) {
                $data = json_decode($response->getBody(), true);
                // Process the $data as needed
                //return response()->json($data);
                if (isset($data['data'])) {
                    foreach ($data['data'] as $record) {
                // Use the 'id' field from the API response to check if the record exists2023-11-09
                $birthDate = ($record['birth_date'] === '0') ? '0000-00-00' : $record['birth_date'];
                $job_last_updated = ($record['job_last_updated'] === '0') ? '0000-00-00' : $record['job_last_updated'];
                $id = $record['id'];

                DB::table('user_data')->updateOrInsert(
                    ['datalab_id' => $id], // The unique identifier for your records (use your own unique identifier)
                    [
                        'full_name' => $record['full_name'],
                        'datalab_id' => $record['id'],
                        'gender' => $record['gender'],
                        'linkedin_url' => $record['linkedin_url'],
                        'industry' => $record['industry'],
                        'job_title' => $record['job_title'],
                        'job_title_role' => $record['job_title_role'],
                        'job_title_sub_role' => $record['job_title_sub_role'],
                        'job_company_website' => $record['job_company_website'],
                        'location_name' => $record['location_name'],
                        'birth_date' => $birthDate,
                        'birth_year' => $record['birth_year'],
                        'countries' => $record['countries'],
                        'education' => $record['education'],
                        'emails' => $record['emails'],
                        'experience' => $record['experience'],
                        'facebook_id' => $record['facebook_id'],
                        'facebook_url' => $record['facebook_url'],
                        'facebook_username' => $record['facebook_username'],
                        'first_name' => $record['first_name'],
                        'github_url' => $record['github_url'],
                        'github_username' => $record['github_username'],
                        'interests' => $record['interests'],
                        'job_company_facebook_url' => $record['job_company_facebook_url'],
                        'job_company_founded' => $record['job_company_founded'],
                        'job_company_id' => $record['job_company_id'],
                        'job_company_industry' => $record['job_company_industry'],
                        'job_company_linkedin_id' => $record['job_company_linkedin_id'],
                        'job_company_linkedin_url' => $record['job_company_linkedin_url'],
                        'job_company_location_address_line_2' => $record['job_company_location_address_line_2'],
                        'job_company_location_continent' => $record['job_company_location_continent'],
                        'job_company_location_country' => $record['job_company_location_country'],
                        'job_company_location_geo' => $record['job_company_location_geo'],
                        'job_company_location_locality' => $record['job_company_location_locality'],
                        'job_company_location_metro' => $record['job_company_location_metro'],
                        'job_company_location_name' => $record['job_company_location_name'],
                        'job_company_location_postal_code' => $record['job_company_location_postal_code'],
                        'job_company_location_region' => $record['job_company_location_region'],
                        'job_company_location_street_address' => $record['job_company_location_street_address'],
                        'job_company_size' => $record['job_company_size'],
                        'job_company_twitter_url' => $record['job_company_twitter_url'],
                        'job_last_updated' => $job_last_updated,
                        'job_start_date' => $record['job_start_date'],
                        'last_initial' => $record['last_initial'],
                        'last_name' => $record['last_name'],
                        'linkedin_id' => $record['linkedin_id'],
                        'linkedin_username' => $record['linkedin_username'],
                        'location_address_line_2' => $record['location_address_line_2'],
                        'location_continent' => $record['location_continent'],
                        'location_country' => $record['location_country'],
                        'location_geo' => $record['location_geo'],
                        'location_last_updated' => $record['location_last_updated'],
                        'location_locality' => $record['location_locality'],
                        'location_metro' => $record['location_metro'],
                        'location_names' => $record['location_names'],
                        'location_postal_code' => $record['location_postal_code'],
                        'location_region' => $record['location_region'],
                        'location_street_address' => $record['location_street_address'],
                        'middle_initial' => $record['middle_initial'],
                        'middle_name' => $record['middle_name'],
                        'mobile_phone' => $record['mobile_phone'],
                        'personal_emails' => $record['personal_emails'],
                        'phone_numbers' => $record['phone_numbers'],
                        'profiles' => $record['profiles'],
                        'regions' => $record['regions'],
                        'skills' => $record['skills'],
                        'street_addresses' => $record['street_addresses'],
                        'twitter_url' => $record['twitter_url'],
                        'twitter_username' => $record['twitter_username'],
                        'work_email' => $record['work_email']
                        //
                        
                        // Add more fields here
                    ]
                );
            }

            return response()->json($data);
        } else {
            return response()->json(['error' => 'No data found in the API response'], 400);
        }
            } else {
                return response()->json(['error' => 'API request failed'], 500);
            }
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function getDatafromapis($id) {
        $apiUrl = "https://api.peopledatalabs.com/v5/person/enrich?pdl_id=" . $id;
        $apiKey = "d0615b66b3bffa3b1103ed140c56210dc988dc5c707e149bcaf045bf4b0fb523";
        try {
            $client = new \GuzzleHttp\Client();
            $response = $client->get($apiUrl, [
                'headers' => [
                    'X-Api-Key' => $apiKey,
                ],
            ]);
            if ($response->getStatusCode() === 200) {
                $responseData = json_decode($response->getBody()->getContents(), true);
                if (isset($responseData['data'])) {
                    $pdf = PDF::loadView('pdf.view', ['data' => $responseData['data']]);
                    return $pdf->download('output.pdf');
                }
            } else {
                return response()->json(['error' => 'API request failed'], $response->getStatusCode());
            }
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    private function createPdfFromData($data, $pdf = null) {
        if ($pdf === null) {
            $pdf = new TCPDF();
            $pdf->AddPage();
        }
        // Iterate through the data and add to the PDF
        foreach ($data as $key => $value) {
            $pdf->Cell(0, 10, $key . ': ' . $value, 0, 1);
        }
        return $pdf;
    }

    public function getJobtitle($id) {
        $getJobtile = DB::table('job_orders')
        ->select('job_orders.name as title','job_orders.skills_required as skillsrequired','job_orders.skills_preferred as skillspreferred','countries.name as countryname','cities.name')
        ->join('job_citys','job_citys.job_id' ,'=','job_orders.id')
        ->join('cities','job_citys.city_id' ,'=','cities.id')
        ->join('countries','cities.country_id' ,'=','countries.id')
        ->where('job_orders.id', $id)
        ->first();
        return response()->success(compact('getJobtile'));
    }


    public function getCustomsearchprofile($id) {
        $apiKey = self::CUSTOM_SEARCH_ENGINE_API_KEY;
        $cx = self::CUSTOM_SEARCH_CX;
        $skills = Input::get('jobid');
        $candidatedetails = DB::table('job_orders')
        ->select('job_orders.name as title','job_orders.skills_required as skillsrequired','job_orders.skills_preferred as skillspreferred','countries.name as countryname','cities.name')
        ->join('job_citys','job_citys.job_id' ,'=','job_orders.id')
        ->join('cities','job_citys.city_id' ,'=','cities.id')
        ->join('countries','cities.country_id' ,'=','countries.id')
        ->where('job_orders.id', $id)
        ->first();
        $jobtitle = $candidatedetails->title;
        $locations = $candidatedetails->name;
        // Set the search query
        $query = $jobtitle.' jobs ' .$locations;
        $resultsPerPage = 10;
        $totalPages = 5; // Define how many pages you want to fetch
        $items = [];
        
        for ($i = 0; $i < $totalPages; $i++) {
            $start = $i * $resultsPerPage + 1;
            $requestUrl = 'https://www.googleapis.com/customsearch/v1?key=' . $apiKey . '&cx=' . $cx . '&q=' . urlencode($query) . '&start=' . $start;
        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $requestUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
            $response = curl_exec($ch);
            curl_close($ch);
        
            if ($response === false) {
                die('Error occurred while fetching data');
            }
        
            $data = json_decode($response, true);
        
            if (isset($data['error'])) {
                die('API Error: ' . $data['error']['message']);
            }
        
            if (isset($data['items'])) {
                $items = array_merge($items, $data['items']);
            }
        }
        // Extract and display search results
        // print_r(json_encode($items));
        // exit;
        foreach ($items as $item) {
            // foreach ($data['items'] as $item) {
                $title_array = explode('-', $item['title']);
                $fullname = explode(' ',$title_array[0]);
                $fname = $fullname[0];
                $lname = $fullname[1];
                $name=  $fname;
                $job_title = trim($title_array[1]);
                $domains = explode('|', $title_array[2]);
                $domain_name = $domains[1];
                $name_icon = array(
                    "full_name" => array(), // Initialize key1 with an empty array
                    "icon" => array()  // Initialize key2 with an empty array
                );
                array_push($name_icon["full_name"],$title_array[0]);
                $domain_name = 'LinkedIn';
                $male_icon = './farmingicons/male_icon.png';
                $female_icon ='./farmingicons/female_icon.png';
                $transgender = './farmingicons/transgender_icon.png';
                $link = str_replace(' ','',$name);
                // Make the API request
                $url = 'https://api.genderize.io?name='.$link;
                //After making API request the response we are fetching by using php method
                $response = file_get_contents($url);
                $js_decode = json_decode($response);
                if($js_decode->gender == 'male') {
                    array_push($name_icon["icon"],$male_icon);
                } else if($js_decode->gender == 'female') {
                    array_push($name_icon["icon"],$female_icon);
                } else {
                    array_push($name_icon["icon"],$transgender);
                }
                $linkedin_id = explode('-', $item['link']);
                $random_id = array_pop($linkedin_id);
                $getIndustryIds = DB::table('job_orders')
                    ->select(DB::raw('GROUP_CONCAT(DISTINCT industry_id) as industry_ids'))
                    ->where('name', $job_title)
                    ->groupBy('name')
                    ->first();
                    $industry_ids = $getIndustryIds->industry_ids;
                    $dataValue = array_column($name_icon, '0');
                    $data = [
                        'full_name' => $dataValue[0],
                        'linkedin_url' => $item['link'],
                        'industry' => $industry_ids,
                        'job_title' => $job_title,
                        'linkedin_id' => $random_id,
                        'domain' => $domain_name,
                        'icon_value' => $dataValue[1]
                    ];
                    DB::table('hx_people_data')->updateOrInsert(['linkedin_url' => $item['link']], $data);
                    $tableData = DB::table('hx_people_data')->select('id', 'full_name', 'icon_value', 'linkedin_url', 'job_title', 'company_name', 'summary', 'skills', 'mobile_phone', 'work_email')->orderby('id', 'desc')->take(50)->get();
            // }
        }
        return response()->success(compact('tableData'));
    }

    public function getEmail($id) {
        $kendo_apiKey = self::KENDU_API_KEY;
        // get profile link based on id
        
        $linkedin_profile = DB::table('hx_people_data')
                ->select('linkedin_url')
                ->where('id', $id)
                ->first();
           $link = $linkedin_profile->linkedin_url;
        // linkedin static for testing link
        $link = 'https://in.linkedin.com/in/ravi-kumar-noolu-15742850';
        // find Email through API
        $email_url = 'https://kendoemailapp.com/emailbylinkedin?apikey=' . $kendo_apiKey . '&linkedin=' . $link;
        $context = stream_context_create([
            'http' => [
                'ignore_errors' => true, // Allows file_get_contents to fetch error response
            ],
        ]);
        $response = file_get_contents($email_url, false, $context);
        $email_array = [];
        if ($response === FALSE) {
            // Handle error, e.g., print an error message or log the error
            $work_email = "";
            $private_email = "";
            $error_message = error_get_last();
            echo "Error: " . $error_message['message'];
        } else {
            $res = json_decode($response, true);
            $work_email = $res['work_email'];
            $private_email = $res['private_email'];
            // Find Mobile Number through API
            $mobile_url = 'https://kendoemailapp.com/mobilebylinkedin?apikey=' . $kendo_apiKey . '&linkedin=' . $link;
            $context = stream_context_create([
                'http' => [
                    'ignore_errors' => true, // Allows file_get_contents to fetch error response
                ],
            ]);
            $response = file_get_contents($email_url, false, $context);
            if ($response === FALSE) {
                // Handle error, e.g., print an error message or log the error
                $error_message = error_get_last();
                echo "Error: " . $error_message['message'];
                $phone = "";
            } else {
                $res = json_decode($response, true);
                $phone = $res['phone'];
            }
            $email_array = array('work_email' => $work_email, 'private_email' => $private_email, 'phone' => $phone);
            $update_email_phone = DB::table('hx_people_data')->where('id', $id)->update(array('emails' => $private_email, 'mobile_phone' => $phone, 'work_email' => $work_email,));
            //echo "<pre>"; print_r($email_array); exit;
        }
        return response()->success(compact('email_array'));
    }
    
    public function getLinkedinscrabber($id) {
        $profiletype='profile';
        $LinkedInUrl = DB::table('hx_people_data')->select('linkedin_url')->where('id', $id)->first();
        $Linkedin = json_encode($LinkedInUrl);
        $link = json_decode($Linkedin)->linkedin_url;
        $apikey = '6579b06170f2d6711f211167';
        $ScrabberLInkedinUrl = 'https://api.scrapingdog.com/linkedin?type=' .$profiletype. '&linkId=' .$link. '&api_key=' .$apikey;
        $response = file_get_contents($ScrabberLInkedinUrl);
        $data = json_decode($response, true);
        foreach ($data as $dataValue) {
            $location = $dataValue['location'];
            if ($dataValue['about'] == '') {
                // code...
                $summary = 'My self '.$dataValue["fullName"].' with'.$dataValue["headline"].' , Specializing in the accurate analysis of finanacial information and the preparation of clear and complaint finanacial statements. Proficient in adhering to GAAP and staying abreast of updates from the FASB to ensure consistent regulatory compliance. Adept in utilizing various accounting software to manage general ledger account, ensuring precise and reliable finanacial reporting.';
            } else {
                $summary = $dataValue['about'];
            }
            foreach ($dataValue['experience'] as $itemExp) {
                $companyName = $itemExp['company_name'];
            }
        }
        // Update the data in table
        DB::table('hx_people_data')->where('id', $id)->update(array('summary' => $summary, 'company_name' => $companyName, 'location_name' => $location));
        $tableResponseData = DB::table('hx_people_data')->select('id', 'full_name', 'icon_value', 'linkedin_url', 'job_title', 'company_name', 'summary', 'skills', 'mobile_phone', 'work_email')->orderby('id', 'desc')->take(10)->get();
        // Check for API errors
        if (isset($data['error'])) {
            die('API Error: ' . $data['error']['message']);
        }
        return response()->success(compact('tableResponseData'));
    }

    public function getCandidatedatapdfdownload($id) {
        $candidateDataPDF = DB::table('hx_people_data')->where('id', $id)->get();
        return response()->success(compact('candidateDataPDF'));
    }

}
