<?php
namespace App\Http\Controllers;

use App\JobOrders;
use App\JobType;
use App\Country;
use App\Currency;
use App\City;
use App\Activity;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use Illuminate\Support\Facades\Cache;
use DB;
use App\User;
use App\Guests;
use Auth;
use App\EducationQualification;
use App\Continents;

class LocationController extends Controller
{
  
    public function getIndex(Request $req)
    {	
		$authuser = Auth::User();
		$locations = array();
		if(!empty($authuser->id)) {
			$countriesInfo = DB::table('pricings')
						->select('country_id')
						->groupBy('country_id')
						->where('emp_id', $authuser->id)
						->get();
			
			if(is_array($countriesInfo)	&& count($countriesInfo)>0) {
				foreach($countriesInfo as $key => $value) {
					$locations[] = $this->get_country_info($value->country_id);
				}
			} 
		} else {
		
			$locations = Country::all();
		}
        return response()->success(compact('locations'));
    }
	public function get_country_info($country_id) {
		$countryInfo = Country::where('id',$country_id)->get();
		return $countryInfo;
	}
    public function getCountry()
    {
        $country = Country::all();
        return response()->success(compact('country'));
    }

    public function getFetchlocation($id)
    {
        $fetchlocation = City::where('id',$id)->first();
        return response()->success(compact('fetchlocation'));
    }

    public function getFetchlocationid($name)
    {
        $fetchlocationid = City::where('name',$name)->first();
        return response()->success(compact('fetchlocationid'));
    }

    public function getFetchcityid($name)
    {
        $fetchcityid = City::select('id','country_id') -> where('name',$name)->first();

        $continentid = Country::select('continents')->where('id',$fetchcityid['country_id'])->first();
        if($fetchcityid!=null || $fetchcityid != ''){
            return response()->success(compact('fetchcityid','continentid'));
        } 
        else{
            return response()->success(compact(''));
        }     
        
    }

    public function getFetchcountryid($name)
    {
        $fetchcountryid = City::select('country_id')->where('name',$name)->first();
        if(isset($fetchcountryid['country_id'])){
         $country = Country::select('id','name as country')->where('id',$fetchcountryid['country_id'])->first();
        }
        else{
            $country = Country::select('id','name as country')->where('name',$name)->first();
        }
        

        return response()->success(compact('country'));
    }
    public function getFetchcountryidonly($name)
    {      
        $country = Country::select('id','name as country')->where('name',$name)->first();

        return response()->success(compact('country'));
    }

    public function getFetchcontinentid($name)
    {
        $continentid = Country::select('continents')->where('name',$name)->first();
        if(isset($continentid->continents)){
            $continent = Continents::select('id','continents_name')->where('id',$continentid->continents)->first();
        }
        else{
            $continent = Continents::select('id','continents_name')->where('id',$continentid->continents)->first();
        }
       

        return response()->success(compact('continent'));
    }
    public function getCurrencycountry()
    {
        $currencycountry = Currency::select('country','code','symbol')->get();
        return response()->success(compact('currencycountry'));
    }
    public function postCountries() 
    {
        $countries = Country::create([
            'name' => Input::get('name'),
            'country_code' => str_slug(Input::get('country_code'), '.'),
            'ISD_code' => str_slug(Input::get('ISD_code'), '.'),
            'currency' => str_slug(Input::get('currency'), '.'),
            'timezone' => str_slug(Input::get('timezone'), '.'),
            'GMT_offset' => str_slug(Input::get('GMT_offset'), '.'),
            'timezone_1' => str_slug(Input::get('timezone_1'), '.'),
            'fa_icon_class' => str_slug(Input::get('fa_icon_class'), '.'),
        ]);
         $authuser = Auth::user();
        //Insert Successfull new country create activity record
        $createCountry = Activity::create([
                // 'person_id' => $authuser->id,
                'name' => 'Added new country.',
        ]);
        $createCountryResponse =  response()->success(compact('createCountry'));
        return response()->success(compact('Countries'));
    }
     public function postCountriesverify() 
    {
       $countriesverify=Country::where('name', Input::get('name'))->where('ISD_code', Input::get('ISD_code'))->where('currency', Input::get('currency'))
        ->get();
        $countriesverify['count']=count($countriesverify);
       return response()->success(compact('countriesverify'));
    }

    public function getCountriesnameShow($name)
    {
        $countries=Country::where('name', Input::get('name'))
        ->orWhere('name', 'like', '%' . $name . '%')->select('id', 'name AS text')->get();
         return response()->success($countries);
    }
	public function postCitiesnameShow()
    { 
     $cities=City::where('name', Input::get('keyword'))
        ->orWhere('name', 'like', '%' . Input::get('keyword') . '%')->select('id', 'name AS text')->get();
         return response()->success($cities);
    }
    public function getCitiesnameShow($name)
    {
     $cities=City::where('name', Input::get('name'))
        ->orWhere('name', 'like', '%' . $name . '%')->select('id', 'name AS text')->get();
         return response()->success($cities);
    }
     public function deleteCountries($id)
    {
         $countries = Country::find($id);
         $countries->delete();
         $authuser = Auth::user();
        //Insert Successfull country delete activity record
        $deleteCountry = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted an existing country.',
        ]);
        $deleteCountryResponse =  response()->success(compact('deleteCountry'));
        return response()->success('success');
    }

     public function getCountriesShow($id)
    {
        $countries = Country::find($id);

        return response()->success($countries);
    }
      public function putCountriesShow()
    {
        $countriesForm = Input::get('data');
        $countriesData = [
            'name' => $countriesForm['name'],
            'country_code' => $countriesForm['country_code'],
            'ISD_code' => $countriesForm['ISD_code'],
            'currency' => $countriesForm['currency'],
            'timezone' => $countriesForm['timezone'],
            'GMT_offset' => $countriesForm['GMT_offset'],
            'timezone_1' => $countriesForm['timezone_1'],
            'fa_icon_class' => $countriesForm['fa_icon_class'],
            
        ];

        $affectedRows = Country::where('id', '=', intval($countriesForm['id']))->update($countriesData);
        $countries = Country::find($countriesForm['id']);

        $authuser = Auth::user();
        //Insert Successfull country update activity record

        $updateCountry = Activity::create([
                // 'person_id' => $authuser->id,
                'name' => 'Updated country details.',
        ]);
        $updateCountryResponse =  response()->success(compact('updateCountry'));

      return response()->success('success');
    }


    public function getCities()
    {
        $country = Country::where('is_enabled',1)->first();
        // print_r($country);
        // die;
        $cities = City::from('cities as ci')->select('ci.city_state as citystate','ci.country_id','ci.id','ci.name as cityname','co.name as countryname')->where('country_id',$country->id)
        ->join('countries as co','co.id','=','ci.country_id')
        ->get();

        return response()->success(compact('cities'));
    }
 
    public function postCitiesverify() 
    {
       $citiesverify=City::where('name', Input::get('name'))->where('country_id', Input::get('country_id'))

        ->get();
        $citiesverify['count']=count($citiesverify);
       return response()->success(compact('citiesverify'));
    }
    public function postCities() 
    {
        $cities = City::create([
            'name' => Input::get('name'),
            'city_state' => str_slug(Input::get('city_state'), '.'),
            'country_id' => str_slug(Input::get('country_id'), '.'),
        ]);

        $authuser = Auth::user();
        //Insert Successfull city create activity record
        $createCity = Activity::create([
             
                'name' => 'Created new city.'
        ]);
        $createCityResponse =  response()->success(compact('createCity'));
        return response()->success(compact('cities'));
    }
     public function deleteCities($id)
    {
         $cities = City::find($id);
         $cities->delete();
         $authuser = Auth::user();
        //Insert Successfull city delete activity record
        $deleteCity = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted an existing city.',
        ]);
        $deletecityResponse =  response()->success(compact('deleteCity'));
        Cache::forget('indian_cities');
        return response()->success('success');
    }

    public function getCitiesshow($id)
    {
        $citiesshow = City::with('Country')->find($id);
        return response()->success(compact('citiesshow'));
    }

    public function putCitiesshow()
    {
        $citiesForm = Input::get('data');
        $citiesData = [
            'name' => $citiesForm['name'],
            'country_id' => $citiesForm['country_id'],
        ];
        $affectedRows = City::where('id', '=', intval($citiesForm['id']))->update($citiesData);
        $cities = City::find($citiesForm['id']);

        $authuser = Auth::user();
        //Insert Successfull city update activity record
        $updateCity = Activity::create([

                'name' => 'Updated city Details.',
        ]);
        $updateCityResponse =  response()->success(compact('updateCity'));
        Cache::forget('indian_cities');
        return response()->success('success');
    }

    public function getCitiesof($id)
    {
        $citiesof = City::where('country_id',$id)->with('Country')->get();
        foreach ($citiesof as $city) {
            $completeDetails = $city['name'] .' / '. $city['city_state'] .' / '. $city['Country']['name'] ;
            $city['citydetails'] = $completeDetails;
        }    
        return response()->success(compact('citiesof'));
    }
    public function getCitiesofjob($id)
    {
        $citiesofjob = City::where('country_id',$id)->with('Country')->get();
        foreach ($citiesofjob as $city) {
            $completeDetails = $city['name'] .'/'. $city['city_state'] ;
            $city['name'] = $completeDetails;
        }    
        return response()->success(compact('citiesofjob'));
    }
        public function getCitiesofjobb($id)
    {
        $citiesofjobb = City::where('country_id',$id)->with('Country')->get();
        foreach ($citiesofjobb as $city) {
            $completeDetails = $city['name'];
            $city['name'] = $completeDetails;
        }    
        return response()->success(compact('citiesofjobb'));
    }
    public function getCitiesofind($id) 
    {
        $citiesofind = City::where('country_id',$id)->with('Country')->get();
        foreach ($citiesofind as $city) {
            $completeDetails = $city['name'] .' / '. $city['city_state'] .' / '. $city['Country']['name'] ;
            $city['citydetails'] = $completeDetails;
        }   
        return response()->success(compact('citiesofind'));
    }
    public function postCitiesofjobnew() {
    $countryId = Input::get('countryId');
    $cityname = Input::get('citysearch');
    $citiesofjob = City::where('country_id',$countryId)
                    ->where('name', 'like', '%'.$cityname.'%')
                    ->with('Country')->orderBy('name', 'desc')->get();
        foreach ($citiesofjob as $city) {
            $completeDetails = $city['name'] .'/'. $city['city_state'] ;
            $city['name'] = $completeDetails;
        }    
        return response()->success(compact('citiesofjob'));
    }
    public function postEducationsdata() {
    $countryId = Input::get('countryId');
    $cityname = Input::get('citysearch');
    $qualification = EducationQualification::where('qualification', 'like', '%'.$cityname.'%')
                    ->orderBy('qualification', 'desc')->get();
        // foreach ($citiesofjob as $city) {
        //     $completeDetails = $city['name'] .'/'. $city['city_state'] ;
        //     $city['name'] = $completeDetails;
        // }    
        return response()->success(compact('qualification'));
    }
    public function postCitiesofjobnew1() {
            $countryId = Input::get('countryId');
            $cityname = Input::get('citysearch');
            $cityInfo = DB::table("select * from cities where country_id='".$countryId."' and name like '%".$cityname."%'  order by name desc");
            return response()->success(compact('cityInfo'));
    }
    public function getUserdata($id)
    {
         $userdata = DB::table("guests as a")
                    ->select('a.name', 'a.email','a.phone_number','a.id','a.invitation_Code','vpr.name', 'vpr.mobile', 'vpr.email')
                    ->join('users as vpr', 'vpr.email', '=', 'a.email')
                    ->where('a.invitation_Code',$id)
                    ->count();
        return response()->success(compact('userdata'));
    }
}