<?php

namespace App\Http\Controllers;

use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\Activity;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use App\UserAssociation;
use App\Pricing;
use App\JobUsers;
use App\JobResumes;
use App\Candidate;
use App\Association;
use App\Guests;
use App\Country;
use App\VendorRevenue;
use App\VendorActivities;
use App\VendorRevenueRule;
use Illuminate\Support\Facades\Log;
use DB;
use Mail;
use Route;

class PricingController extends Controller
{
  	public function getEmppricing()
  	{
      $authuser = Auth::user();

      $country = Country::where('is_enabled',1)->first();

  		$checkRevised = Pricing::where('country_id',$country->id)
                        ->where('emp_id', $authuser->id)
                        ->whereNotNull('revised_price')
                        ->count();
        if($checkRevised) {
            $emppricing = Pricing::where('country_id',$country->id)
                        ->where('emp_id', $authuser->id)
                        ->whereNotNull('revised_price')
                        ->with('country')
                        ->get();
        } else {

            $emppricing = Pricing::where('country_id',$country->id)
                        ->whereNull('emp_id')
                        ->whereNull('revised_price')
                        ->with('country')
                        ->get();

        } // else
  		return response()->success(compact('emppricing'));
  	}

    public function getEditvendorrule()
    {
      $country = Country::where('is_enabled',1)->first();
      $editvendorrule = VendorRevenueRule::where('country_id',$country->id)
                        ->whereNotNull('time_limit')
                        ->whereNotNull('price')
                        ->with('country')
                        ->get();
        
      return response()->success(compact('editvendorrule'));
    //   Route::get('/', function()
    //   {
    //       return view('greeting', ['name' => 'James']);
    //   });
    }    
    

    public function getEmpidpricing($id)
    {
		$authuser = Auth::user();
		$this->pricing_change_manipulation();
		Log::info('Showing default pricing for user: '.$id);
		$empidpricing = Pricing::where('emp_id', $id)
						->whereNotNull('default_country')
						->get()
						->toArray();
                      
        return response()->success(compact('empidpricing'));
    }

    

    public function postEmppricing()
    {
      $authuser = Auth::user();
      $pricingForm = Input::get('data');

      $pricingForm = $pricingForm['data']['empidpricing'];
      $empId = Input::get('emp_id');
      $check = 0;

      foreach ($pricingForm as $price) {
        if($price['revised_price']) {
          $check = 1;
        } 
      }

      foreach ($pricingForm as $price) {
        if($check){

            $priceData = [
              'revised_price' => $price['revised_price'],
              'price_type' => $price['price_type'],
              'starting_range'=>$price['starting_range'],
              'ending_range' => $price['ending_range']
            ];
          $emppricing=Pricing::where('id',$price['id'])
                              ->where('emp_id',$empId)
                              ->whereNotNull('price')
                              ->whereNotNull('revised_price')
                              ->update($priceData);
        } else {
          
          $emppricing = Pricing::create([
                'country_id'=>$price['country_id'],
                'type_of_emp' => $price['type_of_emp'],
                'starting_range'=>$price['starting_range'],
                'ending_range' => $price['ending_range'],
                'price'=>$price['price'],
                'revised_price' => $price['price'],
                'price_type'=>$price['price_type'],
                'emp_id' => intval($empId),
            ]);
        } 
      }      

      return response()->success(compact('emppricing'));
    }

    public function postVendorrevenue()
    {
      $authuser = Auth::user();
      $pricingForm = Input::get('data');
      $country = Country::where('is_enabled',1)->first();
      foreach ($pricingForm as $price) {
        $priceData = [
          'price' => $price['price'],
          'time_limit' => $price['time_limit'],
        ];
        $vendorrevenue=VendorRevenueRule::where('country_id',$country->id)
                              ->where('id',$price['id'])
                              ->whereNotNull('price')
                              ->update($priceData);
      }      
      return response()->success(compact('emppricing'));
    }
    public function postEmployerpricing() {
		
		$emp_id = Input::get('emp_id');
        $country_id = Input::get('country_id');
		$country = Country::select('id', 'currency','name')->where('id', $country_id)->get();
		$contries = json_decode($country);
		
		$countryPrice = DB::table('country_pricing')
							->select('id', 'country_slap1','country_slap2','country_slap3', 'country_slap4', 'country_slap5', 'country_slap6')
							->where('country_id', $contries[0]->id)->get();
		
		$count_id = $countryPrice[0]->id;
		unset($countryPrice[0]->id);
		unset($countryPrice[0]->country_slap1);
		$countryPrice = array_values((array) $countryPrice[0]);
		
		$countryPricePercents = DB::table('country_pricing_percent')
								->select('country_slap2','country_slap3','country_slap4','country_slap5','country_slap6')
								->where('country_id', $count_id)->get();
		$countryPricePercents = array_values((array) $countryPricePercents[0]);
		
		$priceCheck = DB::table('pricings')->where('emp_id', $emp_id)->whereNull('default_country')->where('country_id', $country_id)->count();
		if($priceCheck==0) {
			for($i=0; $i<count($countryPricePercents); $i++) {
				$prices = explode("-", $countryPrice[$i]);
				$price = new Pricing();
				$price->country_id = $country_id;
				$price->type_of_emp = 'Permanent';
				$price->starting_range = $prices[0];
				$price->ending_range = $prices[1];
				$price->price = $countryPricePercents[$i];
				$price->price_type = 'percentage';
				$price->emp_id = $emp_id;
				$price->save();
			}
			$countryPrice = DB::table('country_pricing')
								->select('country_slap1','contract_percent')
								->where('country_id', $contries[0]->id)->get();
								
			$priceCon = new Pricing();
			$priceCon->country_id = $country_id;
			$priceCon->type_of_emp = 'Contract To Hire';
			$priceCon->flat_rate = "";//$countryPrice[0]->country_slap1;
			$priceCon->price = $countryPrice[0]->contract_percent;
			$priceCon->price_type = 'percentage';
			$priceCon->emp_id = $emp_id;
			$priceCon->save();
		
			
			$cnPricePercents = DB::table('country_pricing_percent')
									->select('country_slap1')
									->where('country_id',  $contries[0]->id)->get();
			$priceFlat = new Pricing();
			$priceFlat->country_id = $country_id;
			$priceFlat->type_of_emp = 'Flat Rate';
			$priceFlat->flat_rate = ""; //$countryPrice[0]->country_slap1;
			$priceFlat->price = $cnPricePercents[0]->country_slap1;
			$priceFlat->price_type = 'percentage';
			$priceFlat->emp_id = $emp_id;
			$priceFlat->save();
		}
		
		$allCountries = DB::table('pricings as p')
			->select('p.id', 'p.country_id', 'c.name')
			->groupBy('p.country_id')
			->where('p.emp_id', $emp_id)
			->join('countries as c', 'c.id', '=', 'p.country_id')
			->get();
			
		  $priceInfo = array();	
		  if(is_array($allCountries) && count($allCountries)>0) {
			  foreach($allCountries as $key => $pricing) {
				  
				$empCountryPrice = Pricing::where('emp_id', $emp_id)
							->where('country_id', $pricing->country_id)
							->get()->toArray();
				$priceInfo[] = array('country_id'=>$pricing->country_id,
												  'country_name'=>$pricing->name,
												  'priceList' =>$empCountryPrice
												);
			
			  }
		  }
		
		return response()->success(compact('priceInfo'));

	}
	public function postEmployerpricingdelete() {
		
		$emp_id = Input::get('emp_id');
        $country_id = Input::get('country_id');
		
		$delete = Pricing::where('emp_id', $emp_id)
							->where('country_id', $country_id)->delete();
		$countryInfo = array('success'=>'Successfully country deleted');				
		
	return response()->success(compact('countryInfo'));
	}
    public function activity_logging($emp_id, $country_id) {
		
		$country = DB::table('countries')->select('name')->where('id', $country_id)->get();
		if(is_array($country) && count($country)>0) {
			$message = "Pricing has been updated by $emp_id for ". $country[0]->name;
			$date = date('Y-m-d h:i:s');
			DB::insert("insert into activity_log set emp_id='".$emp_id."', country_id='".$country_id."', log_message='".$message."', created_at='".$date."', updated_at='".$date."'");
		}
	}
	public function postPricingchangemanipulation(Request $req) {
		$pricings = $req->all();
		
		$emp_id = 0;
		$country_id = 0;
		if(is_array($pricings) && count($pricings)>0) {
			foreach($pricings as $ky => $val) {
				if(is_array($val) && count($val)>0) {
					$this->activity_logging($val['emp_id'], $val['country_id']);
					$emp_id = $val['emp_id'];
					$country_id = $val['country_id'];
					$priceObj = Pricing::find($val['id']);
					if($val['type_of_emp']=="Flat Rate") {
						$priceObj->flat_rate = "";
					} else if($val['type_of_emp']=="Contract To Hire") {
						$priceObj->flat_rate = "";
					}else if($val['type_of_emp']=="Permanent") {
						$priceObj->starting_range = $val['starting_range'];
						$priceObj->ending_range = $val['ending_range'];
					}
					$priceObj->price = $val['price'];
					$priceObj->save();
				}
				else {
					$this->activity_logging($pricings['emp_id'], $pricings['country_id']);
					$emp_id = $pricings['emp_id'];
					$country_id = $pricings['country_id'];
					$priceObj = Pricing::find($pricings['id']);
					if($pricings['type_of_emp']=="Flat Rate") {
						$priceObj->flat_rate = "";
					} else if($pricings['type_of_emp']=="Contract To Hire") {
						$priceObj->flat_rate = "";
					}else if($pricings['type_of_emp']=="Permanent") {
						$priceObj->starting_range = $pricings['starting_range'];
						$priceObj->ending_range = $pricings['ending_range'];
					}
					$priceObj->price = $pricings['price'];
					$priceObj->save();
				}
			}
		}
		
		$jobs = DB::table('pricings')->where('pricings.emp_id', $emp_id)
					->where('pricings.country_id', $country_id)
					->select('vpr.job_id', 'pricings.type_of_emp', 'pricings.starting_range', 'pricings.ending_range', 'pricings.flat_rate','pricings.price')
					->join('vendor_pricing_revenue as vpr', 'vpr.emp_id', '=', 'pricings.emp_id')
					->get();
		if(is_array($jobs) && count($jobs)>0) {
			$job_id = $jobs[0]->job_id;
			$verndorPriceInfo = DB::table("vendor_pricing_revenue as vpr")
				->select('vpr.id','vpr.permanent_price', 'vpr.contract_price', 'vpr.flat_rate', 'jo.salary_min', 'jo.salaryType','jo.billrate')
				->join('job_orders as jo', 'jo.id', '=', 'vpr.job_id')
				->where('vpr.job_id', $job_id)
				->get();
			$priceValue = "";
			$flatPriceValue = "";
			$flag=0;
			$created_at = date('Y-m-d h:i:s');

			if($jobs[0]->type_of_emp =="Permanent") {
				foreach($jobs as $key =>$value){
					if($value->price!="8.33" && !empty($value->price) && $value->type_of_emp=="Flat Rate"){
						
						$flatPriceValue = ($verndorPriceInfo[0]->salary_min * $value->price)/100;
						$flag=1;
					} else {
						
						if($value->starting_range <= $verndorPriceInfo[0]->salary_min && $value->ending_range  >=$verndorPriceInfo[0]->salary_min) {
							if(!empty($verndorPriceInfo[0]->salary_min)) {
								$priceValue = ($verndorPriceInfo[0]->salary_min * $value->price)/100;
							}
						}
					}
				}
				if($flag==1) {
					DB::update("update vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', updated_at='".$created_at."' where id='".$verndorPriceInfo[0]->id."'");
				} else {
					DB::update("update vendor_pricing_revenue set permanent_price='".$priceValue."', updated_at='".$created_at."' where id='".$verndorPriceInfo[0]->id."'");
				}
			} else if($jobs[0]->type_of_emp =="Contract To Hire"){
				$billrate = $verndorPriceInfo[0]->billrate;
				$salaryType = $verndorPriceInfo[0]->salaryType;
				
				if($salaryType=='Per Year')
				{
					$yearlyPay = $billrate * 1;
				}
				else if($salaryType=='Per Month')
				{
					$yearlyPay = $billrate * 12;
				}
				else if($salaryType=='Per Week')
				{
					$yearlyPay = $billrate * 52;
				}
				else if($salaryType=='Per Day')
				{
					$yearlyPay = $billrate * 365;
				}
				else if($salaryType=='Per Hour')
				{
					$yearlyPay = $billrate * 8 * 365;
				}
				
				$contractMonthlyPay = $yearlyPay / 12;
				foreach($jobs as $k =>$v) {
					if($v->type_of_emp=="Contract To Hire") {
						$priceValue = round(($contractMonthlyPay * $v->price)/100);
					}
				}
				$created_at = date('Y-m-d h:i:s');
				DB::update("update vendor_pricing_revenue set contract_price='".$priceValue."', updated_at='".$created_at."'  where id='".$verndorPriceInfo[0]->id."'");
				
			}
		}
		// old jobs 
		$oldJobs = DB::table('associations as a')
		->select('a.job_id','a.vendor_id', 'job_citys.city_id', 'jo.job_type_id', 'jo.salary_min', 'jo.salaryType','jo.billrate')
		->where('a.employer_id', $emp_id)
		->join('job_orders as jo', 'a.job_id', '=', 'jo.id')
		->join('job_citys', 'job_citys.job_id', '=', 'jo.id')
		->get();
		//print_r($oldJobs);exit;
		if(is_array($oldJobs) && count($oldJobs)>0) {
			
			foreach($oldJobs as $ky =>$val) {
				$flag=0;
				$countries = DB::table("cities")->select('country_id')->where('id',$val->city_id)->get();
				
				$country_id = $countries[0]->country_id;
				
				$jobs = DB::table("pricings")->where("emp_id", $emp_id)->where('country_id', $country_id)->get();
				$created_at = date('Y-m-d h:i:s');
				
				if($val->job_type_id=="1") {
					
					foreach($jobs as $key =>$value){
						
						if($value->price!="8.33" && !empty($value->price) && $value->type_of_emp=="Flat Rate"){
							
							$flatPriceValue = ($val->salary_min * $value->price)/100;
							$flag=1;
						} else {
								
							if($value->starting_range <= $val->salary_min && $value->ending_range  >= $val->salary_min) {
								
								if(!empty($val->salary_min)) {
									$priceValue = ($val->salary_min * $value->price)/100;
								}
							}
						}
					}
				
					$checkVendorPricing = DB::table('vendor_pricing_revenue')
											->where('job_id', $val->job_id)
											->where('emp_id', $emp_id)
											->get();
					if(is_array($checkVendorPricing) && count($checkVendorPricing)>0) {
						$checkAccMPricing = DB::table('vendor_accountmanager_share')
											->where('job_id', $val->job_id)
											->get();
						
						
						if($flag==1) {
							DB::update("update vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1' where job_id='".$val->job_id."' and emp_id='".$emp_id."'");
							if(is_array($checkAccMPricing) && count($checkAccMPricing)>0) {
								$vendor_price = ($flatPriceValue * 50) / 100;
								DB::update("update vendor_accountmanager_share set vendor_accountmanager_original_price='".$flatPriceValue."', account_manager_price='".$flatPriceValue."', vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'  where job_id='".$val->job_id."'");
							}
						} else {
							DB::update("update vendor_pricing_revenue set permanent_price='".$priceValue."' where job_id='".$val->job_id."' and emp_id='".$emp_id."'");
							
							if(is_array($checkAccMPricing) && count($checkAccMPricing)>0) {
							
								$vendor_price = ($priceValue * 50) / 100;
								DB::update("update vendor_accountmanager_share set vendor_accountmanager_original_price='".$priceValue."', account_manager_price='".$priceValue."',vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'  where job_id='".$val->job_id."'");
							}
						}
					} else {
						if($flag==1) {					
							DB::insert("insert into vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
							$vendor_price = ($flatPriceValue * 50) / 100;
							DB::insert("insert into vendor_accountmanager_share set job_id='".$val->job_id."', vendor_accountmanager_original_price='".$flatPriceValue."',account_manager_price='".$flatPriceValue."', vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'");
						} else {
							DB::insert("insert into vendor_pricing_revenue set permanent_price='".$priceValue."', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
							
							$vendor_price = ($priceValue * 50) / 100;
							DB::insert("insert into vendor_accountmanager_share set job_id='".$val->job_id."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."',vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'");
						}
					}
				} else if($val->job_type_id=="2"){
					$billrate = $val->billrate;
					$salaryType = $val->salaryType;
					
					if($salaryType=='Per Year')
					{
						$yearlyPay = $billrate * 1;
					}
					else if($salaryType=='Per Month')
					{
						$yearlyPay = $billrate * 12;
					}
					else if($salaryType=='Per Week')
					{
						$yearlyPay = $billrate * 52;
					}
					else if($salaryType=='Per Day')
					{
						$yearlyPay = $billrate * 365;
					}
					else if($salaryType=='Per Hour')
					{
						$yearlyPay = $billrate * 8 * 365;
					}
					
					$contractMonthlyPay = $yearlyPay / 12;
					$pricePercent = 0;
					foreach($jobs as $k => $v) {
						if($v->type_of_emp=="Contract To Hire") {
							$pricePercent = $v->price;
						}
					}
					$priceValue = round(($contractMonthlyPay * $pricePercent)/100);
					$checkVendorPricing = DB::table('vendor_pricing_revenue')
											->where('job_id', $val->job_id)
											->where('emp_id', $emp_id)
											->get();
					if(is_array($checkVendorPricing) && count($checkVendorPricing)>0) {
						DB::update("update vendor_pricing_revenue set contract_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."'  where job_id='".$val->job_id."' and emp_id='".$emp_id."'");
						$checkAccMPricing = DB::table('vendor_accountmanager_share')
											->where('job_id', $val->job_id)
											->get();
						if(is_array($checkAccMPricing) && count($checkAccMPricing)>0) {
							$vendor_price = ($priceValue * 50) / 100;
							DB::update("update vendor_accountmanager_share set vendor_accountmanager_original_price='".$priceValue."', account_manager_price='".$priceValue."', vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'  where job_id='".$val->job_id."'");
						}
					} else {
						DB::insert("insert into vendor_pricing_revenue set contract_price='".$priceValue."', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
						
						$vendor_price = ($priceValue * 50) / 100;
						DB::insert("insert into vendor_accountmanager_share set job_id='".$val->job_id."', vendor_accountmanager_original_price='".$priceValue."',account_manager_price='".$priceValue."', vendor_price='" . $vendor_price . "', created_at='".$created_at."', updated_at='".$created_at."'");
					}
				}
			}
		}	
	}
	
	public function getEmpidpricingcountry($id)
    {
      $authuser = Auth::user();
	  $allCountries = DB::table('pricings as p')
		->select('p.id', 'p.country_id', 'c.name')
		->groupBy('p.country_id')
		->where('p.emp_id', $id)
		->orderBy('p.created_at')
		->join('countries as c', 'c.id', '=', 'p.country_id')
		->get();
	
      $empidpricing_country = array();	
	  if(is_array($allCountries) && count($allCountries)>0) {
		  foreach($allCountries as $key => $pricing) {
			  
			$empCountryPrice = Pricing::where('emp_id', $id)
                        ->where('country_id', $pricing->country_id)
						->get()->toArray();
			$empidpricing_country[] = array('country_id'=>$pricing->country_id,
											  'country_name'=>$pricing->name,
											  'priceList' =>$empCountryPrice
											);
        
		  }
	  }             
       return response()->success(compact('empidpricing_country'));
    }
	public function getMultiplecountries()
    {
      	// $authuser = Auth::user();
		$multiplecountries = DB::table('countries')->where('name', '!=', NULL)
					->get();     
		return response()->success(compact('multiplecountries'));
	}
    public function getCostpluspricingcountry($id)
    {
      $authuser = Auth::user();
	  $allCountries = DB::table('costplus_pricings as p')
		->select('p.id', 'p.country_id', 'c.name')
		->groupBy('p.country_id')
		->where('p.vendor_id', $id)
		->join('countries as c', 'c.id', '=', 'p.country_id')
		->get();
	
      $empidpricing_country = array();	
	  if(is_array($allCountries) && count($allCountries)>0) {
		  foreach($allCountries as $key => $pricing) {
			  
			$empCountryPrice = Costplus_pricing::where('vendor_id', $id)
                        ->where('country_id', $pricing->country_id)
						->get()->toArray();
			$empidpricing_country[] = array('country_id'=>$pricing->country_id,
											  'country_name'=>$pricing->name,
											  'priceList' =>$empCountryPrice
											);
        
		  }
	  }             
       return response()->success(compact('empidpricing_country'));
    }
	public function postCostpluspricing() {
		
		$vendor_id = Input::get('vendor_id');
        $country_id = Input::get('country_id');
		$country = Country::select('id', 'currency','name')->where('id', $country_id)->get();
		$contries = json_decode($country);
		
		$countryPrice = DB::table('country_pricing')
							->select('id', 'country_slap1','country_slap2','country_slap3', 'country_slap4', 'country_slap5', 'country_slap6')
							->where('country_name', 'LIKE', '%' .$contries[0]->name.'%')->take(1)->get();
		
		$count_id = $countryPrice[0]->id;
		unset($countryPrice[0]->id);
		unset($countryPrice[0]->country_slap1);
		$countryPrice = array_values((array) $countryPrice[0]);
		
		$countryPricePercents = DB::table('country_pricing_percent')
								->select('country_slap2','country_slap3','country_slap4','country_slap5','country_slap6')
								->where('country_id', $count_id)->get();
		$countryPricePercents = array_values((array) $countryPricePercents[0]);
		
		$priceCheck = DB::table('costplus_pricings')->where('vendor_id', $vendor_id)->whereNull('default_country')->where('country_id', $country_id)->count();
		if($priceCheck==0) {
			for($i=0; $i<count($countryPricePercents); $i++) {
				$prices = explode("-", $countryPrice[$i]);
				$price = new Costplus_pricing();
				$price->country_id = $country_id;
				$price->type_of_emp = 'Permanent';
				$price->starting_range = $prices[0];
				$price->ending_range = $prices[1];
				$price->price = $countryPricePercents[$i];
				$price->price_type = 'percentage';
				$price->vendor_id = $vendor_id;
				$price->save();
			}
			$countryPrice = DB::table('country_pricing')
								->select('country_slap1','contract_percent')
								->where('country_currency', $contries[0]->currency)->take(1)->get();
								
			$priceCon = new Costplus_pricing();
			$priceCon->country_id = $country_id;
			$priceCon->type_of_emp = 'Contract To Hire';
			$priceCon->flat_rate = "";//$countryPrice[0]->country_slap1;
			$priceCon->price = $countryPrice[0]->contract_percent;
			$priceCon->price_type = 'percentage';
			$priceCon->vendor_id = $vendor_id;
			$priceCon->save();
		
			
			$cnPricePercents = DB::table('country_pricing_percent')
									->select('country_slap1')
									->where('country_id', $count_id)->get();
			$priceFlat = new Costplus_pricing();
			$priceFlat->country_id = $country_id;
			$priceFlat->type_of_emp = 'Permanent';
			$priceFlat->flat_rate = ""; //$countryPrice[0]->country_slap1;
			$priceFlat->price = $cnPricePercents[0]->country_slap1;
			$priceFlat->price_type = 'percentage';
			$priceFlat->vendor_id = $vendor_id;
			$priceFlat->save();
		}
		
		$allCountries = DB::table('costplus_pricings as p')
			->select('p.id', 'p.country_id', 'c.name')
			->groupBy('p.country_id')
			->where('p.vendor_id', $vendor_id)
			->join('countries as c', 'c.id', '=', 'p.country_id')
			->get();
			
		  $priceInfo = array();	
		  if(is_array($allCountries) && count($allCountries)>0) {
			  foreach($allCountries as $key => $pricing) {
				  
				$empCountryPrice = Costplus_pricing::where('vendor_id', $vendor_id)
							->where('country_id', $pricing->country_id)
							->get()->toArray();
				$priceInfo[] = array('country_id'=>$pricing->country_id,
												  'country_name'=>$pricing->name,
												  'priceList' =>$empCountryPrice
												);
			
			  }
		  }
		
		return response()->success(compact('priceInfo'));

	}
	public function postCostpluschangemanipulation(Request $req) {
		$pricings = $req->all();
		$emp_id = 0;
		$country_id = 0;
		if(is_array($pricings) && count($pricings)>0) {
			foreach($pricings as $ky => $val) {
				$this->activity_logging($val['emp_id'], $val['country_id']);
				$emp_id = $val['emp_id'];
				$country_id = $val['country_id'];
				$priceObj = Costplus_pricing::find($val['id']);
				if($val['type_of_emp']=="Flat Rate") {
					$priceObj->flat_rate = "";
				} else if($val['type_of_emp']=="Contract To Hire") {
					$priceObj->flat_rate = "";
				}else {
					$priceObj->starting_range = $val['starting_range'];
					$priceObj->ending_range = $val['ending_range'];
				}
				$priceObj->price = $val['price'];
				$priceObj->save();
			}
		}
		
		$jobs = DB::table('costplus_pricings as cp')->where('cp.vendor_id', $emp_id)
					->where('cp.country_id', $country_id)
					->select('vpr.job_id', 'cp.type_of_emp', 'cp.starting_range', 'cp.ending_range', 'cp.flat_rate','cp.price')
					->join('vendor_pricing_revenue as vpr', 'vpr.emp_id', '=', 'cp.emp_id')
					->get();
		if(is_array($jobs) && count($jobs)>0) {
			$job_id = $jobs[0]->job_id;
			$verndorPriceInfo = DB::table("vendor_pricing_revenue as vpr")
				->select('vpr.id','vpr.permanent_price', 'vpr.contract_price', 'vpr.flat_rate', 'jo.salary_min', 'jo.salaryType','jo.billrate')
				->join('job_orders as jo', 'jo.id', '=', 'vpr.job_id')
				->where('vpr.job_id', $job_id)
				->get();
			$priceValue = "";
			$flatPriceValue = "";
			$flag=0;
			$created_at = date('Y-m-d h:i:s');
			if($jobs[0]->type_of_emp =="Permanent") {
				foreach($jobs as $key =>$value){
					if($value->price!="8.33" && !empty($value->price) && $value->type_of_emp=="Flat Rate"){
						
						$flatPriceValue = ($verndorPriceInfo[0]->salary_min * $value->price)/100;
						$flag=1;
					} else {
						
						if($value->starting_range <= $verndorPriceInfo[0]->salary_min && $value->ending_range  >=$verndorPriceInfo[0]->salary_min) {
							$priceValue = ($verndorPriceInfo[0]->salary_min * $value->price)/100;
						}
					}
				}
				if($flag==1) {
					DB::update("update vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', created_at='".$created_at."', updated_at='".$created_at."' where id='".$verndorPriceInfo[0]->id."'");
				} else {
					DB::update("update vendor_pricing_revenue set permanent_price='".$priceValue."', created_at='".$created_at."', updated_at='".$created_at."' where id='".$verndorPriceInfo[0]->id."'");
				}
			} else if($jobs[0]->type_of_emp =="Contract To Hire"){
				$billrate = $verndorPriceInfo[0]->billrate;
				$salaryType = $verndorPriceInfo[0]->salaryType;
				
				if($salaryType=='Per Year')
				{
					$yearlyPay = $billrate * 1;
				}
				else if($salaryType=='Per Month')
				{
					$yearlyPay = $billrate * 12;
				}
				else if($salaryType=='Per Week')
				{
					$yearlyPay = $billrate * 52;
				}
				else if($salaryType=='Per Day')
				{
					$yearlyPay = $billrate * 365;
				}
				else if($salaryType=='Per Hour')
				{
					$yearlyPay = $billrate * 8 * 365;
				}
				
				$contractMonthlyPay = $yearlyPay / 12;
				foreach($jobs as $k =>$v) {
					if($v->type_of_emp=="Contract To Hire") {
						$priceValue = round(($contractMonthlyPay * $v->price)/100);
					}
				}
				$created_at = date('Y-m-d h:i:s');
				DB::update("update vendor_pricing_revenue set contract_price='".$priceValue."' where id='".$verndorPriceInfo[0]->id."', created_at='".$created_at."', updated_at='".$created_at."'");
				
			}
		}
		// old jobs 
		$oldJobs = DB::table('associations as a')
		->select('a.job_id', 'job_citys.city_id', 'jo.job_type_id', 'jo.salary_min', 'jo.salaryType','jo.billrate')
		->where('a.employer_id', $emp_id)
		->join('job_orders as jo', 'a.job_id', '=', 'jo.id')
		->join('job_citys', 'job_citys.job_id', '=', 'jo.id')
		->get();
		
		if(is_array($oldJobs) && count($oldJobs)>0) {
			foreach($oldJobs as $ky =>$val) {
				$flag=0;
				$countries = DB::table("cities")->select('country_id')->where('id',$val->city_id)->get();
				$country_id = $countries[0]->country_id;
				
				$jobs = DB::table("pricings")->where("emp_id", $emp_id)->where('country_id', $country_id)->get();
				$created_at = date('Y-m-d h:i:s');
				
				if($val->job_type_id=="1") {
					
					foreach($jobs as $key =>$value){
						if($value->price!="8.33" && !empty($value->price) && $value->type_of_emp=="Flat Rate"){
							
							$flatPriceValue = ($val->salary_min * $value->price)/100;
							$flag=1;
						} else {
							
							if($value->starting_range <= $val->salary_min && $value->ending_range  >= $val->salary_min) {
								$priceValue = ($oldJobs[0]->salary_min * $value->price)/100;
							}
						}
					}
					$checkVendorPricing = DB::table('vendor_pricing_revenue')
											->where('job_id', $val->job_id)
											->where('emp_id', $emp_id)
											->get();
					if(is_array($checkVendorPricing) && count($checkVendorPricing)>0) {
						if($flag==1) {
							DB::update("update vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1' where job_id='".$val->job_id."' and emp_id='".$emp_id."'");
						} else {
							DB::update("update vendor_pricing_revenue set permanent_price='".$priceValue."' where job_id='".$val->job_id."' and emp_id='".$emp_id."'");
						}
					} else {
						if($flag==1) {					
							DB::insert("insert into vendor_pricing_revenue set permanent_price='".$flatPriceValue."', flat_rate='".$flatPriceValue."', flag='1', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
						} else {
							DB::insert("insert into vendor_pricing_revenue set permanent_price='".$priceValue."', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
						}
					}
				} else if($val->job_type_id=="2"){
					$billrate = $val->billrate;
					$salaryType = $val->salaryType;
					
					if($salaryType=='Per Year')
					{
						$yearlyPay = $billrate * 1;
					}
					else if($salaryType=='Per Month')
					{
						$yearlyPay = $billrate * 12;
					}
					else if($salaryType=='Per Week')
					{
						$yearlyPay = $billrate * 52;
					}
					else if($salaryType=='Per Day')
					{
						$yearlyPay = $billrate * 365;
					}
					else if($salaryType=='Per Hour')
					{
						$yearlyPay = $billrate * 8 * 365;
					}
					
					$contractMonthlyPay = $yearlyPay / 12;
					$pricePercent = 0;
					foreach($jobs as $k => $v) {
						if($v->type_of_emp=="Contract To Hire") {
							$pricePercent = $v->price;
						}
					}
					$priceValue = round(($contractMonthlyPay * $pricePercent)/100);
					$checkVendorPricing = DB::table('vendor_pricing_revenue')
											->where('job_id', $val->job_id)
											->where('emp_id', $emp_id)
											->get();
					if(is_array($checkVendorPricing) && count($checkVendorPricing)>0) {
						DB::update("update vendor_pricing_revenue set contract_price='".$priceValue."' where job_id='".$val->job_id."' and emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
					} else {
						DB::insert("insert into vendor_pricing_revenue set contract_price='".$priceValue."', job_id='".$val->job_id."', emp_id='".$emp_id."', created_at='".$created_at."', updated_at='".$created_at."'");
					}
				}
			}
		}	
	}
	public function getCountrydetailsbyid($id)
    {
		$countrydetailsbyid = DB::table('countries')->where('id', $id)
					->get();     
		return response()->success(compact('countrydetailsbyid'));
	}
}