<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Requests\Filetotext;
use App\User;
use App\Candidate;
use App\CandidateExperiences;
use App\CandidateSkillsets;
use App\SoftSkills;
use App\CandidateSkills;
use App\CandidateNotecs;
use App\CompaniesEmployer;
use App\Skills;
use App\SkillCategories;
use App\ActionWords;
use App\SkillBroadcategories;
use App\CandidateSoftSkills;
use App\CandidateOperationalSkills;
use App\CandidateEducations;
use App\AiCompetencySe;
use App\CandidateDetails;
use App\AiPersonalityInsight;
use App\Employeespectrums;
use App\SegregatedSkill;
use App\UniversityGroup;
use App\ManagementWord;
use Carbon\Carbon;
use App\Models\ClearBitCompany;
use App\Activity;
use App\Models\NasdaqCompany;
use App\Models\WorldTopCompany;
use App\Models\TalentMine;
use App\Models\WorldUniversity;
use App\CandidateApiInfo;
use App\Recommendations;
use App\EmailInfo;
use App\SegregatedPublication;
use App\SegregatedCertification;
use App\CandidateAchievements;
use Auth;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Position;
use Bican\Roles\Models\Jobtype;
use Bican\Roles\Models\Requirement;
use Bican\Roles\Models\Role;
use App\UserAsset;
use App\Association;
use App\CollageNames;
use Hash;
use Input;
use Validator;
use GuzzleHttp\Client;
use DateTime;
use DateTimeZone;
use DB;
use Session;
use Storage;
use App\Colors;
use App\JobOrders;
use App\Currency;

class RchilliController extends Controller
{
    public function postResumetotext()
    {
        $authuser = Auth::user();
        $authId=null;
        try{
            $files = Input::file('file');
            if(count($files[0]) == 1){
                $file_name = $files[0]->getClientOriginalName();
                $file_type = $files[0]->getmimeType();
                $path = base_path()."/public/user_assets/".$authId;
                $destinationPath = 'user_assets/'.$authId;
                $url = "/user_assets/";
                $files[0]->move($destinationPath,$files[0]->getClientOriginalName());
            }
            $assetId = null;
            $docObj = new Filetotext($files[0]->getClientOriginalName());

            $return = $docObj->convertToText();
            $candidate_data = str_replace(",", " ", $return);
            $candidate_data = str_replace("+","plus",$candidate_data);
            $candidate_data = strtolower(str_replace( array("&", "!","|","||",":", '"', "'", "?","+",". ","."," ,",", ","/ ","/"," /"," - " ), '', $candidate_data));
            $candidate_data = str_replace(" -", " ", $candidate_data);
            $candidate_data = str_replace("- ", " ", $candidate_data);
            $candidate_data = str_replace("-", " ", $candidate_data);
            // $skill_data=Skills::with('boradcategories')->get(['id','name','skill_category_id']);
            // print_r($candidate_data);
            $skill_data =SkillCategories::get(['id','name','skill_broadcategory_id']);

            // print_r($skill_data);limit(20)->
            $skills_dta = array();
            foreach($skill_data as $skills_filter) {
                array_push($skills_dta, $skills_filter['name'].'||'.$skills_filter['id'].'||'.$skills_filter['skill_broadcategory_id']);
            }
            $resumetotext = array();
            $broad_cat_details=array();
            reset($skills_dta);

            while (list($key, $val) = each($skills_dta)){
                $arr = explode("||", $val, 3);

                if($arr[0] != "" && $arr[0] != null && $arr[0] != ''){

                    $first = $arr[0];
                    $weigtage_req=0;
                    $req_opr_skills=0;
                    $req_can_skills=0;
                    $req_summ_skills=0;
                    $req_objective_skills=0;
                    $req_exe_summary_skills=0;
                    $req_skill_value=$first;
                    $req_skill_key=$key;
                    $a=0;
                    foreach($resumetotext as $data) {
                        $data = explode("||", $data, 3);
                        //print_r($data[0]. '!='. $first);
                        if($data[0] != $first){
                            $a=0;
                        }else{
                            $a=1;
                        }
                    }
                    $req_skill_value = strtolower(str_replace( array( " /","*"," *","* ", "/ ","/", '[', "]", " [","[ ","(",")" ), '', $req_skill_value));
                    if($a == 0){
                        $req_skill_value = str_replace("+","plus",$req_skill_value);
                        if(preg_match("~\b$req_skill_value\b~", $candidate_data) == 1) {
                            $resumetotext[] = $val;
                            $broad_cat_details[]=$arr[2];
                            $candidate_data = str_replace($req_skill_value, " ", $candidate_data);
                        }}
                }
            }
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch
        $broad_res_value=array_count_values($broad_cat_details);
        $maxIndex = array_search(max($broad_res_value), $broad_res_value);
        $resumetotext=SkillBroadcategories::where("id",$maxIndex)->get(['id','name']);
        return response()->success(compact('resumetotext'));
    }
    public function postResumetotextyes()
    {
        $authuser = Auth::user();
        $authId=null;
        try{
            $files = Input::file('file');
            if(count($files[0]) == 1){
                $file_name = $files[0]->getClientOriginalName();
                $file_type = $files[0]->getmimeType();
                $path = base_path()."/public/user_assets/".$authId;
                $destinationPath = 'user_assets/'.$authId;
                $url = "/user_assets/";
                $files[0]->move($destinationPath,$files[0]->getClientOriginalName());
            }
            $assetId = null;
            $docObj = new Filetotext($files[0]->getClientOriginalName());
            $return = $docObj->convertToText();
            $candidate_data = str_replace(",", " ", $return);
            $candidate_data = str_replace("+","plus",$candidate_data);
            $candidate_data = str_replace("#","sharp",$candidate_data);
            $candidate_data = strtolower(str_replace( array(" as ","&", "!","|","||",":", '"', "'", "?","+",". ","."," ,",", ","/ ","/"," /"," - ","-", "\r", "\n" ), ' ', $candidate_data));
            $candidate_data = str_replace("\n", " ", $candidate_data);
            $candidate_data = str_replace(" d ", " ", $candidate_data);
            //print_r($candidate_data);
            $candidate_data = str_replace(" -", " ", $candidate_data);
            $candidate_data = str_replace("- ", " ", $candidate_data);
            $candidate_data = str_replace("-", " ", $candidate_data);
            //$skill_data=Skills::with('boradcategories')->get(['id','name','skill_category_id']);
            $weightage=0;
            $cat_id=Input::get('cat_id');
            $skill_data = SkillBroadcategories::with('skillcategories')->where('id',$cat_id)->get();
            //$skill_data = SkillBroadcategories::with('skillcategories.skills')->where('id',$cat_id)->get();
            $skills_dta = array();
            foreach($skill_data as $skills_filter) {
                //print_r($skills_filter['skillcategories']);
                foreach($skills_filter['skillcategories'] as $a) {
                    array_push($skills_dta, $a['name'].'||'.$a['id'].'||'.$skills_filter['name'].'||'.$weightage);
                }

            }
            /*print_r($skills_dta);
          exit;*/
            $resumetotextyes = array();
            $resumetotextyes1 = array();
            $var_value = array();
            reset($skills_dta);
            while (list($key, $val) = each($skills_dta)){
                $arr = explode("||", $val, 4);
                if($arr[0] != "" && $arr[0] != null && $arr[0] != ''){
                    $first = $arr[0];
                    $weigtage_req=0;
                    $req_opr_skills=0;
                    $req_can_skills=0;
                    $req_summ_skills=0;
                    $req_objective_skills=0;
                    $req_exe_summary_skills=0;
                    $req_skill_value=$first;
                    $req_skill_key=$key;
                    $a=0;
                    foreach($resumetotextyes1 as $data) {
                        $data = explode("||", $data, 4);
                        if($data[0] != $first){
                            $a=0;
                        }else{
                            $a=1;
                        }
                    }
                    $req_skill_value = strtolower(str_replace( array( " /","*"," *","* ", "/ ","/", '[', "]", " [","[ ","(",")" ), '', $req_skill_value));
                    if($a == 0){
                        $req_skill_value = str_replace("+","plus",$req_skill_value);
                        $req_skill_value = str_replace("#","sharp",$req_skill_value);
                        //$req_skill_value = "Ar";
                        if(preg_match("~\b$req_skill_value\b~", $candidate_data) == 1) {
                            $data[3] = substr_count($candidate_data,$req_skill_value);
                            $arr = explode("||", $val, 4);
                            $arr[3]=$data[3];
                            $numbers = ['skill_name'=>$arr[0],'skill_id'=>$arr[1],'broad_cat'=>$arr[2], 'weightage'=>$arr[3]];
                            array_push($resumetotextyes,$numbers);
                            $val= implode("||",$arr);
                            $resumetotextyes1[] = $val;
                            $candidate_data = str_replace($req_skill_value, " ", $candidate_data);
                        }}
                }
            }
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch


        usort($resumetotextyes, $docObj->build_sorter('weightage'));
        return response()->success(compact('resumetotextyes'));
    }
    public function build_sorter($key) {
        return function ($a, $b) use ($key) {
            return strnatcmp($a[$key], $b[$key]);
        };
    }
    public function getBroadskills(){
        $authuser = Auth::user();
        $broadskills = SkillBroadcategories::get();
        return response()->success(compact('broadskills'));

    }
    public function get_skillblock_ratio($candidate_id) {
        
        $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword!='skills'");
        $keywords = array();
        $skill_value_count = array();
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
            foreach($skillblockInfo as $key => $value) {
                $keywords[] = $value->keyword;
                $skill_value_count[] = count(explode(',', $value->skill_value));
            }
            $skill_value_count_sum = array_sum($skill_value_count);
            $skill_value_percent = round(100/$skill_value_count_sum,2);
            
            $skillBlock = array();
            if(is_array($keywords) && count($keywords)>0) {
                for($i=0; $i< count($keywords); $i++) {
                    
                    $skill_value = $skill_value_count[$i] * $skill_value_percent;
                    $skillBlock[$keywords[$i]] = $skill_value;
                }
            }
        }
        return response()->success(compact('skillBlock'));
    }
    public function getSkillBlockInformation($candidate_id) {
        
        $skillblockInfo = DB::select("select sr.*, c.html_code, cd.detail_resume from skillblock_resume as sr inner join candidates as c on sr.candidate_id=c.id inner join candidate_details as cd on cd.candidate_id=sr.candidate_id  where sr.candidate_id='".$candidate_id."'");
        
        return response()->success(compact('skillblockInfo'));
        
    }
   public function postPrivatearea()
    {  
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        
        $r_req_fields = !empty(Input::get('req_fields'))?Input::get('req_fields'):'';
        // echo 'test:'.$r_req_fields;exit;
        if($r_req_fields == 1){ //SRILATHA code start if
            $r_file = !empty(Input::file('file'))?Input::file('file'):'';
            $r_fullname = !empty(Input::get('fullname'))?Input::get('fullname'):'';
            $r_location = !empty(Input::get('location'))?Input::get('location'):'';
            $r_summery = !empty(Input::get('summery'))?Input::get('summery'):'';
            $r_email = !empty(Input::get('email'))?Input::get('email'):'';
            $r_mobile = !empty(Input::get('mobile'))?Input::get('mobile'):'';
            $r_country_code = !empty(Input::get('country_code'))?Input::get('country_code'):'';
            $skillsets = Input::get('skills');

            if(!empty($skillsets)) {
                $a_skill= array();
                foreach($skillsets as $skillset_key => $skillset_val) {
                    foreach($skillset_val as $skillset) {
                        $a_skill[] = $skillset;
                    }
                }
                $implode_skills = implode(",",$a_skill);
            } 

            $r_skills = !empty($implode_skills)?$implode_skills:'';
            //Start try
            $json= Input::get('json');
             $assetId =$json['assetId'];
            $path =$json['path'];
            if(empty($r_email)){
                $email = $json['Email'][0]['EmailAddress'];
            } else {
                $email = $r_email;
            }
          /*   if($authuser->parent_id) {
                $candidateId=Candidate::where('email',$email)
                    ->where('vendor_id',$authId)->get()->toArray();
            } else {
                $candidateId=Candidate::where('email',$email)
                    ->where('vendor_id',$authuser->id)
                    ->get()->toArray();
            } */

            $candidateId=Candidate::where('email',$email)
            ->where('vendor_id',$authuser->id)
            ->get()->toArray();                       
            if(count($candidateId)==0) {
            $summary='';
            if(!empty($json["WorkedPeriod"]["TotalExperienceInYear"])){
                $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            } else {
                $expe=0;
            }
            
            
                $asset_create_response = null;
                if ( Input::hasFile('file') )
                {
                    $files = array();
                    $files = Input::file('file');
                    $i = 0; foreach ($files as $value) {$i++;}
                    if($i == 0) {
                        $file_name = $files->getClientOriginalName();
                        $file_type = $files->getClientMimeType();
                        $path = base_path()."/public/user_assets/".$authId;
                        $destinationPath = 'user_assets/'.$authId;
                        $url = "/user_assets/".$authId;
                        $files->move($destinationPath,$files->getClientOriginalName());
                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authId,
                        ]); 
                    } else {
                        foreach ($files as $singlefile) {
                            $file_name = $singlefile->getClientOriginalName();
                            $file_type = $singlefile->getClientMimeType();
                            $path = base_path()."/public/user_assets/".$authId;
                            $destinationPath = 'user_assets/'.$authId;
                            $url = "/user_assets/".$authId;
                            $singlefile->move($destinationPath, $singlefile->getClientOriginalName());
                            $assets_create = UserAsset::create([
                                'file_name' => $file_name,
                                'file_type' => $file_type,
                                'path' => $path,
                                'url' => $url,
                                'user_id' => $authId,
                            ]);
                        }//foreach
                    } // else
                    $assetId = $assets_create->id;   // Assign Id of asset

                    if($authuser->parent_id) {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'vendor_user_id' => $authuser->id,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    } else {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    }
                } //If
                //End of save raw asset
                //Choose candidate summary if exists.
                $summary = '';
                $executiveSummary=null;
                $managementSummary=null;
                if( $json["Summary"] ){
                    $summary = (String) $json["Summary"];
                }  elseif( $json["ExecutiveSummary"] ){
                    $executiveSummary = (String) $json["ExecutiveSummary"];
                } elseif( $json["ManagementSummary"] ){
                    $managementSummary = (String) $json["ManagementSummary"];
                }
                $executiveSummary = (String) $json["ExecutiveSummary"];
                $managementSummary = (String) $json["ManagementSummary"];
                if($json["DateOfBirth"]){
                    $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
                }
                //Getting skill set object
                $SkillSet=$json["SegregatedSkill"];
                $allSkills = null;
                $operationalSkills = null;
                $softSkills=null;
                $operationalSkills=null;
                //concatenate all the skills and assign to a variable.
                $skillsData = array();
                if(is_array($SkillSet) && count($SkillSet)) {
                    foreach($SkillSet as $skill)
                    {
                        $skillsData[] = $skill["Skill"];
                    }
                }
                $skillsDataStr = implode(',', $skillsData);
                /*  echo "<pre>";print_r($json);echo "</pre>";*/
                if(!empty($json["CurrentLocation"])){
                    $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
                }else{
                    $curentlocation="";
                }
                if(!empty($json["PreferredLocation"])){
                    $PreferredLocation=$json["PreferredLocation"];
                }else{
                    $PreferredLocation="";
                }
                $alternate_email="";
                if(!empty($json["Email"])){
                    $email_new=$json["Email"][0]["EmailAddress"];
                }else{
                    $email_new="";
                }
                if(!empty($json["PhoneNumber"])){
                    $mobile_new=$json["PhoneNumber"][0]["OriginalNumber"];
                }else{
                    $mobile_new="";
                }
                $recomon="";
                if(is_array($json["Recommendations"]) && count($json["Recommendations"])>0) {
                    foreach ($json["Recommendations"] as $recomondation) {
                        if(strlen($recomon) > 0){
                            $recomon = $recomon.', ';
                        }
                        $recomon = $recomon.$recomondation["PersonName"];
                    }
                }
                if((String) !empty($json["WorkedPeriod"]["TotalExperienceInYear"])){
                    $tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
                } else {  $tot_exp=0;}
                $FullName = (!empty($json["Name"]["FullName"]))?$json["Name"]["FullName"]:$r_fullname;
                $CurrentLocation = !empty($curentlocation)?$curentlocation:$r_location;
                $Summary = !empty($summary)?$summary:$r_summery;
                $Email = !empty($email_new)?$email_new:$r_email;
                
                $Mobile = (!empty($mobile_new))?$mobile_new:$r_mobile;
                if(!empty($json['PhoneNumber'])) {
                    //$arrayPhone = explode(" ",$json["FormattedMobile"],2);
                    $country_code = $json["PhoneNumber"][0]["ISDCode"];
                    $Mobile = $json["PhoneNumber"][0]["OriginalNumber"];
                } else {
                    $country_code = $r_country_code;
                    $Mobile = $r_mobile;
                }
                
                $languages_known="";
                if(!empty($json["LanguageKnown"])){
                if(is_array($json["LanguageKnown"]) && count($json["LanguageKnown"])>0) {
                    foreach ($json["LanguageKnown"] as $recomondation) {
                        if(strlen($languages_known) > 0){
                            $languages_known = $languages_known.', ';
                        }
                        $languages_known = $languages_known.$recomondation["Language"];
                    }
                }
            }
                $candidate = Candidate::create([
                    'full_name' => (String) $FullName,
                    'email' => (String) $email,
                    'phone' => (String) $Mobile,
                    'mobile' => (String) $Mobile,
                    'country_code' => (String) $country_code,
                    'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                    'gender' => (String) $json["Gender"],
                    'job_profile' => (String) $json["JobProfile"],
                    'address' => (String) $json["Address"][0]["State"],
                    'city' => (String) $json["Address"][0]["City"],
                    'state' => (String) $json["Address"][0]["State"],
                    'country' => (String) $json["Address"][0]["Country"],
                    'zip' => (String) $json["Address"][0]["ZipCode"],
                    'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                    'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                    'total_experience_in_year' => $tot_exp,
                    'asset_id' => $assetId,
                    'vendor_id' => $authuser->id,
                    'vendor_user_id' => ($authuser->parent_id) ? $authuser->id : 'null',
                    'summary' => $Summary,
                    'path' =>  $path ,
                    'title' => (String) $json["Name"]["TitleName"],
                    'first_name' => (String) $json["Name"]["FirstName"],
                    'middle_name' => (String) $json["Name"]["MiddleName"],
                    'last_name' => (String) $json["Name"]["LastName"],
                    'father_name' => (String) $json["FatherName"],
                    'mother_name' => (String) $json["MotherName"],
                    'marital_status' => (String) $json["MaritalStatus"],
                    'nationality' => (String) $json["Nationality"],
                    'language_known' => (String) $languages_known,
                    'unique_id' => (String) $json["UniqueID"],
                    'license_no' => (String) $json["LicenseNo"],
                    'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                    'pan_no' => (String) $json["PanNo"],
                    'visa_status' => (String) $json["VisaStatus"],
                    'alternate_email' =>(String) $alternate_email,
                    'cover_letter' => (String) $json["Coverletter"],
                    'certification' => (String) $json["Certification"],
                    'publication' => (String) $json["Publication"],
                    'current_location' =>(String) $CurrentLocation,
                    'preferred_location' =>(String) $PreferredLocation,
                    'availability' => (String) $json["Availability"],
                    'objectives' => (String) $json["Objectives"],
                    'candidate_references' => (String) $json["References"],
                    'parsing_date' => (String) $json["ParsingDate"],
                    'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                    'resume_file_name' => (String) $json["ResumeFileName"],
                    'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                    //'permanent_address' => (String) $dummy,
                    // 'permanent_city' => (String) $dummy,
                    // 'permanent_state' => (String) $dummy,
                    // 'permanent_country' => (String) $dummy,
                    // 'permanent_zip_code' => (String) $dummy,
                    // 'formatted_permanent_address' =>(String) $dummy,
                    'industry_category' => (String) $json["Category"],
                    'industry_sub_category' => (String) $json["SubCategory"],
                    'is_privatearea' => 0,
                    'executive_summary' => $executiveSummary,
                    'management_summary' => $managementSummary,
                    'hobbies'=>(!empty($json['Hobbies'])) ? $json['Hobbies'] : "",
                    'candidate_achievements'=>$json['Achievements'],
                    'html_code'=>(!empty($json['HtmlResume'])) ? $json['HtmlResume'] : "",
                    'qualification'=>$json['Qualification'],
                    'note'=>Input::get('description'),
                ]);
                    $candidate_skills = CandidateSkills::create([
                        'skills' => (string) $json["SkillKeywords"],
                        'candidate_id' => $candidate->id,
                    ]);
                    $candidate_skill = CandidateSkillsets::create([
                        'skill_set' => $skillsDataStr,
                        'candidate_id' => $candidate->id,
                    ]);
                    $SkillBlock = $json["SkillKeywords"];
                       $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    $skillDataInfo = array();
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        
                    foreach($skillsResumes as $skills) {
                    $SkillBlock = preg_replace('/:/', '~', $skills);
                    $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                    $SkillBlockArr = explode('~', $SkillBlock);
                    
                    if(count($SkillBlockArr)==1) {
                        $SkillBlockArr = explode(',', $SkillBlockArr[0]);
                         
                        foreach($SkillBlockArr as $key =>$value) {
                            
                            if(!empty($value)) {
                                if(strpos($value, '/')) {
                                    $valueArr = explode('/', $value);
                                    foreach($valueArr as $kyr =>$valr) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($valr))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->general_skills."', value='".addslashes($sval->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($value))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                }
                            }
                        }
                    } else {
                        $skillInfo =    explode(':', $skills);
                        $skillDataInfo[] = array($skillInfo[0]=> $skillInfo[1]);
                    }
                    }
                    if(is_array($skillDataInfo) && count($skillDataInfo)>0) {
                        foreach($skillDataInfo as $skey =>$svalue) {
                            foreach($svalue as $ky =>$val) {
                                DB::insert("insert into skillblock_temp set keyword='".$ky."', value='".addslashes($val)."'");
                            }
                        }   
                    }
                }
                    
            $SkillBlock = $json["SkillBlock"];
            $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);

            $skillsResumes = explode('~', $SkillBlock);
            //print_r($skillsResumes);exit;
            $skillDataInfo = array();
            if(is_array($skillsResumes) && count($skillsResumes)>0) {

                foreach($skillsResumes as $skills) {
                    
                    $SkillBlock = preg_replace('/:/', '~', $skills);
                    $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                    $SkillBlockArr = explode('~', $SkillBlock);
                    
                    if(count($SkillBlockArr)==1) {
                        $SkillBlockArr = explode(',', $SkillBlockArr[0]);
                         
                        foreach($SkillBlockArr as $key =>$value) {
                            
                            if(!empty($value)) {
                                if(strpos($value, '/')) {
                                    $valueArr = explode('/', $value);
                                    foreach($valueArr as $kyr =>$valr) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($valr))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($value))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                }
                            }
                        }
                    } else {
                        $skillInfo =    explode(':', $skills);
                        $skillDataInfo[] = array($skillInfo[0]=> $skillInfo[1]);
                    }
                }
                if(is_array($skillDataInfo) && count($skillDataInfo)>0) {
                    foreach($skillDataInfo as $skey =>$svalue) {
                        foreach($svalue as $ky =>$val) {
                            DB::insert("insert into skillblock_temp set keyword='".$ky."', value='".addslashes($val)."'");
                        }
                    }
                }
                //print_r($skillDataInfo);exit;
        //exit;
        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
            
            if(is_array($skillData) && count($skillData)>0) {
                foreach($skillData as $ky => $val) {
                    $keyvalArr = array_unique(explode(',',$val->keyval));
                    $keyval = implode(',', $keyvalArr);
                    if(!empty($keyval)){
                        if($val->keyword=="skills") {
                            DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
                        } else {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

                        }
                    }
                }
            }
            DB::delete('delete from skillblock_temp');
        }
         
                /* $request->session()->put('candidate', $candidate);*/

                $candidate_response = response()->success(compact('candidate'));

                $lastCandidateId = $candidate->id;

                $allSkills = !empty($allSkills)?$allSkills:$r_skills;
                $json_skills = !empty($json["Skills"])?$json["Skills"]:$r_skills;
                $operationalSkills = !empty($operationalSkills)?$operationalSkills:$r_skills;
                $softSkills = !empty($softSkills)?$softSkills:$r_skills;

                //Saving Condidate All Skills.
                $candidate_operational_skills = CandidateOperationalSkills::create([
                    'operational_skills' => (string) $operationalSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
                $candidate_soft_skills = CandidateSoftSkills::create([
                    'soft_skills' => (string) $softSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
                // for only now
                if(!empty($json["SegregatedQualification"]) && count($json["SegregatedQualification"])>0) {
                foreach ($json["SegregatedQualification"] as $edu)
                {
                    if(!empty($edu["Institution"]))
                    {
                        $startDate = str_replace('/', '-', $edu["StartDate"]);
                        $endDate = str_replace('/', '-', $edu["EndDate"]);
                        $candidate_educations = CandidateEducations::create([
                            'institution_name' => $edu["Institution"]["Name"],
                            'institution_city' => $edu["Institution"]["Location"]["City"],
                            'degree' => $edu["Degree"]["DegreeName"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' => date('Y-m-d', strtotime($endDate)),
                            'aggregate' => $edu["Aggregate"]["Value"],
                            'measure_type' => $edu["Aggregate"]["MeasureType"],
                            'institution_type' => $edu["Institution"]["Type"],
                            'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                            'state' => $edu["Institution"]["Location"]["State"],
                            'country' => $edu["Institution"]["Location"]["Country"],
                            'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                            'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                            'candidate_id' => $lastCandidateId,
                        ]);
                        $candidate_educations_response = response()->success(compact('candidate_educations'));
                    }

                }       //foreach
                }
                ///candidate-details//need to create model and send it to database
                $recomon="";
                if(is_array($json["Recommendations"]) && count($json["Recommendations"])>0) {
                foreach ($json["Recommendations"] as $recomondation) {
                    if(strlen($recomon) > 0){
                        $recomon = $recomon.', ';
                    }
                    $recomon = $recomon.$recomondation["PersonName"];
                }
                }
                $websites="";
                if(is_array($json["WebSite"]) && count($json["WebSite"])>0) {
                foreach ($json["WebSite"] as $recomondation) {
                    if(strlen($websites) > 0){
                        $websites = $websites.', ';
                    }
                    $websites = $websites.$recomondation["Url"];
                }
                }
                $candidate_details = CandidateDetails::create([
                    'gapperiod' => (string) $json["GapPeriod"],
                    'averageStay' =>(string) $json["AverageStay"],
                    'LongestStay' =>(string) $json["LongestStay"],
                    'recommendations' =>(string) $recomon,
                    'detail_resume' =>(string) $json["DetailResume"],
                    'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                    'websites' => (string) $websites,
                    //'overalldata' => (string) $json,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_details_response = response()->success(compact('candidate_details'));

                if(is_array($json["SegregatedSkill"]) && count($json["SegregatedSkill"]) >0) {
                foreach ($json["SegregatedSkill"] as $edu)
                {
                    $segregatedskills = SegregatedSkill::create([
                        'type' => (string) $edu["Type"],
                        'skill' =>(string) $edu["Skill"],
                        'Ontology' =>(string) $edu["Ontology"],
                        'alias' =>(string) $edu["Alias"],
                        'formattedname' =>(string) $edu["FormattedName"],
                        'evidence' =>(string) $edu["Evidence"],
                        'lastused' =>(string) $edu["LastUsed"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $segregatedskills_response = response()->success(compact('segregatedskills'));
                }
              }
                if(!empty($json["SegregatedPublication"])){
                 foreach ($json["SegregatedPublication"] as $edui)
                {
                    $segregated_publication = SegregatedPublication::create([
                        'publication_title' => (string) $edui["PublicationTitle"],
                        'publisher_name' =>(string) $edui["Publisher"],
                        'publication_number' =>$edui["PublicationNumber"],
                        'publication_url' =>(string) $edui["PublicationUrl"],
                        'authors' =>(string) $edui["Authors"],
                        'description' =>(string) $edui["Description"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $segregated_publication_response = response()->success(compact('segregated_publication'));

                }
               }
                    /* foreach ($json["EmailInfo"] as $edui)
                {
                    print_r($edui);exit();
                    $email_info = EmailInfo::create([
                        'email_to' =>  $edui["EmailTo"],
                        'email_body' => $edui["EmailBody"],
                        'emai_reply_to' =>$edui["EmailReplyTo"],
                        'email_signature' => $edui["EmailSignature"],
                        'emai_from' => $edui["EmailFrom"],
                        'email_subject' => $edui["EmailSubject"],
                        'email_cc' => $edui["EmailCC"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $email_info_response = response()->success(compact('email_info'));

                }*/
                if(!empty($json["Recommendations"]) && count($json["Recommendations"])>0) {
                foreach ($json["Recommendations"] as $edui)
                {
                    $recommendations = Recommendations::create([
                        'person_name' => (string) $edui["PersonName"],
                        'company_name' =>(string) $edui["CompanyName"],
                        'relation' =>$edui["Relation"],
                        'position_title' =>(string) $edui["PositionTitle"],
                        'description' =>(string) $edui["Description"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $recommendations_response = response()->success(compact('recommendations'));

                }
            }
                       /*foreach ($json["ApiInfo"] as $edui)
                {
                    $api_info = CandidateApiInfo::create([
                        'metered' =>  $edui["Metered"],
                        'credit_left' => $edui["CreditLeft"],
                        'account_expiry_date' =>$edui["AccountExpiryDate"],
                        'build_version' => $edui["BuildVersion"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $api_info_response = response()->success(compact('api_info'));

                }*/
                if(!empty($json["SegregatedCertification"]) && count($json["SegregatedCertification"])>0) {
                foreach ($json["SegregatedCertification"] as $edui)
                {
                    $segregated_certification = SegregatedCertification::create([
                       'certification_title' => $edui["CertificationTitle"],
                        'authority' => $edui["Authority"],
                        'certification_code' =>$edui["CertificationCode"],
                        'is_expiry' => $edui["IsExpiry"],
                        'start_date' => $edui["StartDate"],
                        'end_date' =>$edui["EndDate"],
                        'certificationUrl' =>  $edui["CertificationUrl"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $segregated_certification_response = response()->success(compact('segregated_certification'));

                }

            }
            if(!empty($json["SegregatedAchievement"]) && count($json["SegregatedAchievement"])>0) {
                foreach ($json["SegregatedAchievement"] as $edui)
                {
                    $candidate_achievements = CandidateAchievements::create([
                        'award_title' => $edui["AwardTitle"],
                        'issuer' =>$edui["Issuer"],
                        'experience' =>  $json["Experience"],
                        'associated_with' => $edui["AssociatedWith"],
                        'issuing_date' => $edui["IssuingDate"],
                        'description' =>$edui["Description"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_achievements_response = response()->success(compact('candidate_achievements'));
                }
            }
                $candidate_note = !empty(Input::get('description'))?Input::get('description'):'';
                $candidate_notes = CandidateNotecs::create([
                    'candidate_id' => $lastCandidateId,
                    'note' => (string) $candidate_note
                ]);
                }
                if(count($candidateId) != 0) {
                    return response()->error("Profile already exists in Candidate area.");
                }       

                return response()->success(compact('candidate_notes'));
            
            //SRILATHA code end if
        }else{
            $authuser = Auth::user();
            $authId=null;
            if($authuser->parent_id) {$authId=$authuser->parent_id;}
            else {$authId=$authuser->id;}
            $jsonResult = null;
          //  $APIURL="https://hirextra8.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";//OLd API
            $APIURL="https://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
            try
            {
                $file = Input::file('file');
                $description=Input::get('description');
                $assetId = null;
                $imagedata = file_get_contents($file);
                $base64 = base64_encode($imagedata);
                $key='Y0CPAOKBPGW';
                $version = "8.0.0";
                $subUserId = "Hirextra8";
                $data = array(
                    "filedata" => $base64,
                    "filename" => $file->getClientOriginalName(),
                    "userkey" => $key,
                    "version" => $version,
                    "subuserid" => $subUserId
                );
                $str_data = json_encode($data);
                $ch = curl_init($APIURL);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Content-Length: ' . strlen($str_data))
                );
                $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
                $err =curl_error($ch);
                curl_close($ch);
                if ($err) {
                    echo "cURL Error #:" . $err;
                } 
            } //try
            catch (Exception $e)
            {
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            } //catch

          //  echo 'RESUME DATA:'; print_r($jsonResult);exit;
            // $jsonResult = json_decode($jsonResult, true);
            $jsonResult = json_decode($jsonResult, true);
            $json=$jsonResult["ResumeParserData"];
            
            $fullname = 0; 
            if(!empty($json['Name']['FullName'])) {
                $fullname = $json['Name']['FullName'];
            }
            $location = 0;
            if(!empty($json['SegregatedQualification'][3]['Institution']['Location']['City'])) {
                $location = $json['SegregatedQualification'][3]['Institution']['Location']['City'];
            }
            if(empty($location)) {
                $location = $json['SegregatedExperience'][0]['Location']['City'];
            }
            $summary = 0;
            if(!empty($json['Summary'])) {
                $summary = $json['Summary'];
            }
            $email = 0;
            if(!empty($json['Email'][0]['EmailAddress'])) {
                $email = $json['Email'][0]['EmailAddress'];
            }
            $mobile = 0;
            if(!empty($json["PhoneNumber"][0]["Number"])) {
                $mobile = $json["PhoneNumber"][0]["Number"];
            }
            $country_code = 0;
            if(!empty($json['ResumeCountry']['CountryCode']['IsoAlpha2'])) {
                $country_code = $json['ResumeCountry']['CountryCode']['IsoAlpha2'];
            }
            
            $SkillSet=$json["SegregatedSkill"];
            
            $operationalSkills = null;
            $softSkills=null;
            $operationalSkills=null;
            //concatenate all the skills and assign to a variable.
            $skillsData = array();
            if(!empty($SkillSet) && count($SkillSet)>0) {
            foreach($SkillSet as $skill)
            {
                $skillsData[] = $skill["Skill"];
            }
            }
            $skillsDataStr = implode(',', $skillsData);
            $summary='';
            $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            $Email = $json["Email"];
            $EmailAddress = "";
            if(is_array($Email)  && count($Email)>0) {
                $EmailAddress = $Email[0]['EmailAddress'];
                
                if(empty($EmailAddress)) {
                    $EmailAddress = $json["Email"];
                }
            }
            
            if($authuser->parent_id) {
                $candidateId=Candidate::where('email',$EmailAddress)
                    ->where('vendor_id',$authuser->id)
                    ->get()->toArray();;
            } else {
                $candidateId=Candidate::where('email',$EmailAddress)
                    ->where('vendor_id',$authuser->id)
                    ->get()->toArray();
            }
                      
            if(count($candidateId)==0) {
                
                $asset_create_response = null;
                if ( Input::hasFile('file') )
                {
                    $files = array();
                    $files = Input::file('file');
                    $i = 0; 
                    if($i == 0) {
                        $file_name = $files->getClientOriginalName();
                        $file_type = $files->getClientMimeType();
                        $path = base_path()."/public/user_assets/".$authId;
                        $destinationPath = 'user_assets/'.$authId;
                        $url = "/user_assets/".$authId;
                        $files->move($destinationPath,$files->getClientOriginalName());
                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authId,
                        ]);
                    } 
                    $assetId = $assets_create->id;   // Assign Id of asset

                    if($authuser->parent_id) {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'vendor_user_id' => $authuser->id,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    } else {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    }
                } //If
                //End of save raw asset
                //Choose candidate summary if exists.
                $summary = '';
                $executiveSummary=null;
                $managementSummary=null;
                if( $json["Summary"] )
                { $summary = (String) $json["Summary"]; }
                elseif( $json["ExecutiveSummary"] )
                { $executiveSummary = (String) $json["ExecutiveSummary"]; }
                elseif( $json["ManagementSummary"] )
                { $managementSummary = (String) $json["ManagementSummary"]; }
                $executiveSummary = (String) $json["ExecutiveSummary"];
                $managementSummary = (String) $json["ManagementSummary"];

                if($json["DateOfBirth"]){
                    $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
                }
                if($json["PhoneNumber"]){
                    $country_code = $json["PhoneNumber"][0]["ISDCode"];
                }else{
                    $country_code = "";
                }
                //print_r($json); exit;
                if($json["CurrentLocation"]){
                    $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
                }else{
                    $curentlocation="";
                }
                if($json["PreferredLocation"]){
                    $PreferredLocation=$json["PreferredLocation"];
                }else{
                    $PreferredLocation="";
                }
                $alternate_email="";
                if($json["Email"]){
                    $email_new=$json["Email"][0]["EmailAddress"];
                }else{
                    $email="";
                }
                if($json["PhoneNumber"]){
                    $mobile_new=$json["PhoneNumber"][0]["Number"];
                }else{
                    $mobile_new="";
                }

                $languages_known="";
              if(!empty($json["LanguageKnown"])){
                foreach ($json["LanguageKnown"] as $recomondation) {
                    if(strlen($languages_known) > 0){
                        $languages_known = $languages_known.', ';
                    }
                    $languages_known = $languages_known.$recomondation["Language"];
                }
                }
                
                if((String) $json["WorkedPeriod"]["TotalExperienceInYear"] =='' || (String) $json["WorkedPeriod"]["TotalExperienceInYear"]==null){
                    $tot_exp=0;
                } else {$tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];}
                //Insert candidate record
                // echo 'SRILATHA:';print_r($json["CurrentLocation"]);exit;
                // && !empty($summary) && !empty($email) && !empty($mobile) && !empty($country_code) && !empty($skill)&& !empty($location)
                
                if(!empty($fullname) && !empty($location) && !empty($summary) && !empty($email) && !empty($mobile) && !empty($country_code)) {
                    $candidate = Candidate::create([
                        'full_name' => (String) $fullname,
                        'email' => (String) $email,
                        'phone' => (String) $mobile,
                        'mobile' => (String) $mobile,
                        'country_code' => (String) $country_code,
                        'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                        'gender' => (String) $json["Gender"],
                        'job_profile' => (String) $json["JobProfile"],
                        'address' => (String) $json["Address"][0]["State"],
                        'city' => (String) $json["Address"][0]["City"],
                        'state' => (String) $json["Address"][0]["State"],
                        'country' => (String) $json["Address"][0]["Country"],
                        'zip' => (String) $json["Address"][0]["ZipCode"],
                        'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                        'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                        'total_experience_in_year' => $tot_exp,
                        'asset_id' => $assetId,
                        'vendor_id' => $authuser->id,
                        'vendor_user_id' => ($authuser->parent_id) ? $authuser->id : 'null',
                        'summary' => $summary,
                        'path' =>  $path,
                        'title' => (String) $json["Name"]["TitleName"],
                        'first_name' => (String) $json["Name"]["FirstName"],
                        'middle_name' => (String) $json["Name"]["MiddleName"],
                        'last_name' => (String) $json["Name"]["LastName"],
                        'father_name' => (String) $json["FatherName"],
                        'mother_name' => (String) $json["MotherName"],
                        'marital_status' => (String) $json["MaritalStatus"],
                        'nationality' => (String) $json["Nationality"],
                        'language_known' => (String) $languages_known,
                        'unique_id' => (String) $json["UniqueID"],
                        'license_no' => (String) $json["LicenseNo"],
                        'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                        'pan_no' => (String) $json["PanNo"],
                        'visa_status' => (String) $json["VisaStatus"],
                        'alternate_email' =>(String) $alternate_email,
                        'cover_letter' => (String) $json["Coverletter"],
                        'certification' => (String) $json["Certification"],
                        'publication' => (String) $json["Publication"],
                        'current_location' =>(String) $location,
                        'preferred_location' =>(String) $PreferredLocation,
                        'availability' => (String) $json["Availability"],
                        'objectives' => (String) $json["Objectives"],
                        'candidate_references' => (String) $json["References"],
                        'parsing_date' => (String) $json["ParsingDate"],
                        'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                        'resume_file_name' => (String) $json["ResumeFileName"],
                        'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                        //'permanent_address' => (String) $dummy,
                        // 'permanent_city' => (String) $dummy,
                        // 'permanent_state' => (String) $dummy,
                        // 'permanent_country' => (String) $dummy,
                        // 'permanent_zip_code' => (String) $dummy,
                        // 'formatted_permanent_address' =>(String) $dummy,
                        'industry_category' => (String) $json["Category"],
                        'industry_sub_category' => (String) $json["SubCategory"],
                        'is_privatearea' => 0,
                        'executive_summary' => $executiveSummary,
                        'management_summary' => $managementSummary,
                        'hobbies'=>$json['Hobbies'],
                        'candidate_achievements'=>$json['Achievements'],
                        'html_code'=>$json['HtmlResume'],
                        'qualification'=>$json['Qualification'],
                        'note'=>Input::get('description'),
                    ]);
                    $candidate_skills = CandidateSkills::create([
                        'skills' => (string) $json["SkillKeywords"],
                        'candidate_id' => $candidate->id,
                    ]);
                    $candidate_skill = CandidateSkillsets::create([
                    'skill_set' => $skillsDataStr,
                    'candidate_id' => $candidate->id,
                ]);
                    $SkillBlock = $json["SkillKeywords"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        
                    foreach($skillsResumes as $skills) {
                    $SkillBlock = preg_replace('/:/', '~', $skills);
                    $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                    $SkillBlockArr = explode('~', $SkillBlock);
                    
                    if(count($SkillBlockArr)==1) {
                        $SkillBlockArr = explode(',', $SkillBlockArr[0]);
                         
                        foreach($SkillBlockArr as $key =>$value) {
                            
                            if(!empty($value)) {
                                if(strpos($value, '/')) {
                                    $valueArr = explode('/', $value);
                                    foreach($valueArr as $kyr =>$valr) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($valr))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($value))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                }
                            }
                        }
                    } else {
                        $skillInfo =    explode(':', $skills);
                        $skillDataInfo[] = array($skillInfo[0]=> $skillInfo[1]);
                    }
                    }
                   if(!empty($skillDataInfo)){
                    if(is_array($skillDataInfo) && count($skillDataInfo)>0) {
                        foreach($skillDataInfo as $skey =>$svalue) {
                            foreach($svalue as $ky =>$val) {
                                DB::insert("insert into skillblock_temp set keyword='".$ky."', value='".addslashes($val)."'");
                            }
                        }   
                    }
                }
            }
                    
            $SkillBlock = $json["SkillBlock"];
            $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);

            $skillsResumes = explode('~', $SkillBlock);
            //print_r($skillsResumes);exit;
            $skillDataInfo = array();
            if(is_array($skillsResumes) && count($skillsResumes)>0) {

                foreach($skillsResumes as $skills) {
                    
                    $SkillBlock = preg_replace('/:/', '~', $skills);
                    $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                    $SkillBlockArr = explode('~', $SkillBlock);
                    
                    if(count($SkillBlockArr)==1) {
                        $SkillBlockArr = explode(',', $SkillBlockArr[0]);
                         
                        foreach($SkillBlockArr as $key =>$value) {
                            
                            if(!empty($value)) {
                                if(strpos($value, '/')) {
                                    $valueArr = explode('/', $value);
                                    foreach($valueArr as $kyr =>$valr) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($valr))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords = '".addslashes(trim($value))."'";
                                        ///echo "<br>".$sql;
                                        $skillInfo = DB::select($sql);
                                        
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            foreach($skillInfo as $ky=>$val) {
                                                DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                            }
                                        } else {
                                            if(strpos($value, ' ')) {
                                                $valueArr = explode(',', $value);
                                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valueArr[0]))."'";
                                                
                                                $spaceskillInfo = DB::select($sql);
                                                if(is_array($spaceskillInfo) && count($spaceskillInfo)>0) {
                                                    foreach($spaceskillInfo as $sky=>$sval) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$sval->skill_name."', value='".addslashes($sval->skillblock_keywords)."'");
                                                    }
                                                }   
                                            } else {
                                                $sql = "select * from soft_skills where able_to_listen='$value'";
                                                $softskillInfo = DB::select($sql);
                                                if(is_array($softskillInfo) && count($softskillInfo)>0) {
                                                    foreach($softskillInfo as $skey =>$svalue) {
                                                        DB::insert("insert into skillblock_temp set keyword='".$svalue->general_skills."', value='".addslashes($svalue->able_to_listen)."'");
                                                    }
                                                } else {
                                                
                                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                                }
                                            }
                                        }
                                }
                            }
                        }
                    } else {
                        $skillInfo =    explode(':', $skills);
                        $skillDataInfo[] = array($skillInfo[0]=> $skillInfo[1]);
                    }
                }
        if(is_array($skillDataInfo) && count($skillDataInfo)>0) {
            foreach($skillDataInfo as $skey =>$svalue) {
                foreach($svalue as $ky =>$val) {
                    DB::insert("insert into skillblock_temp set keyword='".$ky."', value='".addslashes($val)."'");
                }
            }   
        }
        //print_r($skillDataInfo);exit;
        //exit;
    $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
            
    if(is_array($skillData) && count($skillData)>0) {
        foreach($skillData as $ky => $val) {
            $keyvalArr = array_unique(explode(',',$val->keyval));
            $keyval = implode(',', $keyvalArr);
            if(!empty($keyval)){
                if($val->keyword=="skills") {
                    DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
                } else {
                        DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

                }
            }
        }
    }
    DB::delete('delete from skillblock_temp');
}
            

                    return response()->success(compact('candidate'));
                } else {
                    $error_location = $error_exp = $error_summery = $error_email = $error_phone = $error_mobile =
                    $error_fullname = $error_skills = $error_country_code = "";

                    if(empty($json["Name"]["FullName"])) {
                        $error_fullname = '1';
                    }else{
                        $error_fullname = 0;
                    }
                    if($json["PhoneNumber"]){
                        $error_country_code = '1';
                    }else{
                        $error_country_code = 0;
                    }
                    if(empty($curentlocation)) {
                        $error_location = '1';
                    }else{
                        $error_location = 0;
                    }

                    if(empty($json["WorkedPeriod"]["TotalExperienceInYear"])){
                        $error_exp = 1;
                    }else{
                        $error_exp = 0;
                    }

                    if($json["Summary"] || $json["ExecutiveSummary"] || $json["ManagementSummary"]){
                        $error_summery = 0;
                    }else{
                        $error_summery = 1;
                    }
                    if(empty($email)){
                        $error_email = '1';
                    }else{
                        $error_email = 0;
                    }

                    if(empty($mobile_new)){
                        $error_phone = 1;
                    }else{
                        $error_phone = 0;
                    }

                    if(empty($json["SkillKeywords"])){
                        $error_skills = 1;
                    }else{
                        $error_skills = 0;
                    }
                    $fileuploadarr = [ 'fullname'=> $error_fullname,
                        'location'=>$error_location,
                        'summary'=>$error_summery,
                        'email'=>$error_email,
                        'mobile'=>$error_phone,
                        'skills'=>$error_skills,
                        'country_code' => $error_country_code
                        ];
                    $json['assetId'] = $assetId;
                    $json['path'] = $path;
                    $fileuploadarr['json'] = $json;
                    
                    return response()->error(compact('fileuploadarr'));
                }   

                $lastCandidateId = $candidate->id;
               if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"] as $exp)
                {
                    if($exp['Employer'] != null && $exp["JobProfile"]["Title"] != null) {
                        $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                        //print_r($startDate);
                        $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'2 print_r le ke print karo
                        //print_r($endDate);kya problem hi
                        $candidate_exp = CandidateExperiences::create([
                            'employer_name' => $exp["Employer"]["EmployerName"],
                            'job_title' => $exp["JobProfile"]["Title"],
                            'empoyer_city' => $exp["Location"]["City"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' =>  date('Y-m-d', strtotime($endDate)),
                            'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                            'current_employer_name' => $json["CurrentEmployer"],
                            'total_experienceIn_months' => $json["WorkedPeriod"]["TotalExperienceInMonths"],
                            'total_experienceIn_year' => $json["WorkedPeriod"]["TotalExperienceInYear"],
                            'total_experienceIn_range' => $json["WorkedPeriod"]["TotalExperienceRange"],
                            'custom_fields' => $json["CustomFields"],
                            'candidate_id' => $lastCandidateId,
                        ]);
                        $candidate_exp_response = response()->success(compact('candidate_exp'));
                    } //candidate work history foreach
                }
             } //if
                //Insert a record into candidateskillssets table
                
                //$candidate_skills_Set_response = response()->success(compact('candidate_skill'));
                $skills_new = '';
                $candidate_skills = CandidateSkills::create([
                    'skills' => (string) $json["SkillKeywords"],//isko for each lagake aur implode karna hi
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_skills_response = response()->success(compact('candidate_skills'));

                $candidate_operational_skills = CandidateOperationalSkills::create([
                    'operational_skills' => (string) $operationalSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
                $candidate_soft_skills = CandidateSoftSkills::create([
                    'soft_skills' => (string) $softSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
                // for only now
              foreach ($json["SegregatedQualification"] as $edu)
            {
                if(!empty($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);
                    //print_r($edu["Degree"]["DegreeName"]);exit;
                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["Location"]["City"],
                        'degree' => $edu["Degree"]["DegreeName"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'measure_type' => $edu["Aggregate"]["MeasureType"],

                        'institution_type' => $edu["Institution"]["Type"],
                        'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                        'state' => $edu["Institution"]["Location"]["State"],
                        'country' => $edu["Institution"]["Location"]["Country"],
                        'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                        'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                        $candidate_educations_response = response()->success(compact('candidate_educations'));
                    }
                } //foreach
                ///candidate-details//need to create model and send it to database
                $recomon="";
                foreach ($json["Recommendations"] as $recomondation) {
                    if(strlen($recomon) > 0){
                        $recomon = $recomon.', ';
                    }
                    $recomon = $recomon.$recomondation["PersonName"];
                }
                $websites="";
                foreach ($json["WebSite"] as $recomondation) {
                    if(strlen($websites) > 0){
                        $websites = $websites.', ';
                    }
                    $websites = $websites.$recomondation["Url"];
                }
                $candidate_details = CandidateDetails::create([
                    'gapperiod' => (string) $json["GapPeriod"],
                    'averageStay' =>(string) $json["AverageStay"],
                    'LongestStay' =>(string) $json["LongestStay"],
                    'recommendations' =>(string) $recomon,
                    'detail_resume' =>(string) $json["DetailResume"],
                    'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                    'websites' => (string) $websites,
                    //'overalldata' => (string) $json,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_details_response = response()->success(compact('candidate_details'));



                foreach ($json["SegregatedSkill"] as $edu)
                {
                    $segregatedskills = SegregatedSkill::create([
                        'type' => (string) $edu["Type"],
                        'skill' =>(string) $edu["Skill"],
                        'Ontology' =>(string) $edu["Ontology"],
                        'alias' =>(string) $edu["Alias"],
                        'formattedname' =>(string) $edu["FormattedName"],
                        'evidence' =>(string) $edu["Evidence"],
                        'lastused' =>(string) $edu["LastUsed"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $segregatedskills_response = response()->success(compact('segregatedskills'));

                }

                 foreach ($json["SegregatedPublication"] as $edui)
            {
                $segregated_publication = SegregatedPublication::create([
                    'publication_title' => (string) $edui["PublicationTitle"],
                    'publisher_name' =>(string) $edui["Publisher"],
                    'publication_number' =>$edui["PublicationNumber"],
                    'publication_url' =>(string) $edui["PublicationUrl"],
                    'authors' =>(string) $edui["Authors"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_publication_response = response()->success(compact('segregated_publication'));

            }

                /* foreach ($json["EmailInfo"] as $edui)
            {
                print_r($edui);exit();
                $email_info = EmailInfo::create([
                    'email_to' =>  $edui["EmailTo"],
                    'email_body' => $edui["EmailBody"],
                    'emai_reply_to' =>$edui["EmailReplyTo"],
                    'email_signature' => $edui["EmailSignature"],
                    'emai_from' => $edui["EmailFrom"],
                    'email_subject' => $edui["EmailSubject"],
                    'email_cc' => $edui["EmailCC"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $email_info_response = response()->success(compact('email_info'));

            }*/

            foreach ($json["Recommendations"] as $edui)
            {
                $recommendations = Recommendations::create([
                    'person_name' => (string) $edui["PersonName"],
                    'company_name' =>(string) $edui["CompanyName"],
                    'relation' =>$edui["Relation"],
                    'position_title' =>(string) $edui["PositionTitle"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $recommendations_response = response()->success(compact('recommendations'));

            }

                   /*foreach ($json["ApiInfo"] as $edui)
            {
                $api_info = CandidateApiInfo::create([
                    'metered' =>  $edui["Metered"],
                    'credit_left' => $edui["CreditLeft"],
                    'account_expiry_date' =>$edui["AccountExpiryDate"],
                    'build_version' => $edui["BuildVersion"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $api_info_response = response()->success(compact('api_info'));

            }*/

            foreach ($json["SegregatedCertification"] as $edui)
            {
                $segregated_certification = SegregatedCertification::create([
                   'certification_title' => $edui["CertificationTitle"],
                    'authority' => $edui["Authority"],
                    'certification_code' =>$edui["CertificationCode"],
                    'is_expiry' => $edui["IsExpiry"],
                    'start_date' => $edui["StartDate"],
                    'end_date' =>$edui["EndDate"],
                    'certificationUrl' =>  $edui["CertificationUrl"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_certification_response = response()->success(compact('segregated_certification'));

            }


            foreach ($json["SegregatedAchievement"] as $edui)
            {
                $candidate_achievements = CandidateAchievements::create([
                    'award_title' => $edui["AwardTitle"],
                    'issuer' =>$edui["Issuer"],
                    'experience' =>  $json["Experience"],
                    'associated_with' => $edui["AssociatedWith"],
                    'issuing_date' => $edui["IssuingDate"],
                    'description' =>$edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_achievements_response = response()->success(compact('candidate_achievements'));

            }
                //Insert Successfull resume posting activity record
                if($authuser->parent_id) {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'vendor_user_id' => $authuser->id,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                } else {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                }
                $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
                return $candidate->id;
                
            }
            if(count($candidateId) != 0) {
                return response()->error("Profile already exists in Candidate area.");
            } else {
                return response()->error("Profile already exists and submitted Please try with new Profile.");
            }
        }
    }

    public function postPrivateareamultiple()
    {   
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}

        $r_req_fields = !empty(Input::get('req_fields'))?Input::get('req_fields'):'';

       // echo $authId.'___________'.$r_req_fields;
        if($r_req_fields == 1){ //SRILATHA code start if
            // echo 'test1';exit;
            $r_file = !empty(Input::file('file'))?Input::file('file'):'';
            //print_r($r_file);exit;
            $r_fullname = !empty(Input::get('fullname'))?Input::get('fullname'):'';
            $r_location = !empty(Input::get('location'))?Input::get('location'):'';
            $r_summery = !empty(Input::get('summery'))?Input::get('summery'):'';
            $r_email = !empty(Input::get('email'))?Input::get('email'):'';
            $r_mobile = !empty(Input::get('mobile'))?Input::get('mobile'):'';
            $r_country_code = !empty(Input::get('country_code'))?Input::get('country_code'):'';
            $skillsets = Input::get('skills');
            if(!empty($skillsets)){
                $a_skill= array();
                foreach($skillsets as $skillset_key => $skillset_val){
                    foreach($skillset_val as $skillset){
                        $a_skill[] = $skillset;
                    }
                }
                $implode_skills = implode(",",$a_skill);
            }
            $r_skills = !empty($implode_skills)?$implode_skills:'';

            $json = Input::get('json');
            $assetId =$json['assetId'];
            $path =$json['path'];
            // echo '';print_r($json);exit;
            $summary='';
            $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            if(empty($r_email)){
                $email = $json['Email'][0]['EmailAddress'];
            } else {
                $email = $r_email;
            }
            if($authuser->parent_id) {
                $candidateId=Candidate::where('email',$email)
                    ->where('vendor_id',$authId)
                    ->get()->toArray();;
            } else {
                $candidateId=Candidate::where('email',$email)
                    ->where('vendor_id',$authId)
                    ->get()->toArray();
            }
            
           // print_r($candidateId);exit;
            if(count($candidateId)==0) {
                $asset_create_response = null;
                if ( Input::hasFile('file') )
                {
                    $files = array();
                    $files = Input::file('file');
                    $i = 0; foreach ($files as $value) {$i++;}
                    if($i == 0) {
                        $file_name = $files->getClientOriginalName();
                        $file_type = $files->getClientMimeType();
                        $path = base_path()."/public/user_assets/".$authId;
                        $destinationPath = 'user_assets/'.$authId;
                        $url = "/user_assets/".$authId;
                        $files->move($destinationPath,$files->getClientOriginalName());
                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authId,
                        ]);
                    } else {
                        foreach ($files as $singlefile) {
                            $file_name = $singlefile->getClientOriginalName();
                            $file_type = $singlefile->getClientMimeType();
                            $path = base_path()."/public/user_assets/".$authId;
                            $destinationPath = 'user_assets/'.$authId;
                            $url = "/user_assets/".$authId;
                            $singlefile->move($destinationPath, $singlefile->getClientOriginalName());
                            $assets_create = UserAsset::create([
                                'file_name' => $file_name,
                                'file_type' => $file_type,
                                'path' => $path,
                                'url' => $url,
                                'user_id' => $authId,
                            ]);
                        }//foreach
                    } // else
                    $assetId = $assets_create->id;   // Assign Id of asset

                    if($authuser->parent_id) {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'vendor_user_id' => $authuser->id,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    } else {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    }
                } //If
                //End of save raw asset
                //Choose candidate summary if exists.
                $summary = '';
                $executiveSummary=null;
                $managementSummary=null;
                if( $json["Summary"] ){
                    $summary = (String) $json["Summary"];
                }  elseif( $json["ExecutiveSummary"] ){
                    $executiveSummary = (String) $json["ExecutiveSummary"];
                } elseif( $json["ManagementSummary"] ){
                    $managementSummary = (String) $json["ManagementSummary"];
                }
                $executiveSummary = (String) $json["ExecutiveSummary"];
                $managementSummary = (String) $json["ManagementSummary"];
                if($json["DateOfBirth"]){
                    $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
                }
                //Getting skill set object
                if(!empty($json["SegregatedSkill"])){
                    $SkillSet=$json["SegregatedSkill"];
                   } else {
                    $SkillSet=array(); 
                   }
                $allSkills = null;
                $operationalSkills = null;
                $softSkills=null;
                $operationalSkills=null;
                //concatenate all the skills and assign to a variable.
                foreach($SkillSet as $skill)
                {
                    if( $allSkills)  {
                        $allSkills = $allSkills.', '. $skill["Skill"];
                        if($skill["Type"] == "SoftSkill"){
                            if($softSkills) {
                                $softSkills = $softSkills.', '. $skill["Skill"];
                            } else {
                                $softSkills = $skill["Skill"];
                            }
                        }
                        if($skill["Type"] == "OperationalSkill"){
                            if($operationalSkills) {
                                $operationalSkills = $operationalSkills.', '. $skill["Skill"];
                            } else {
                                $operationalSkills = $skill["Skill"];
                            }
                        }
                    } else {$allSkills = $skill["Skill"]; }
                }
                /*  echo "<pre>";print_r($json);echo "</pre>";*/
                if(!empty($json["CurrentLocation"])){
                    $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
                }else{
                    $curentlocation="";
                }
                if(!empty($curentlocation)) {
                    $curentlocation = $r_location;
                }
                if(!empty($json["PreferredLocation"])){
                    $PreferredLocation=$json["PreferredLocation"];
                }else{
                    $PreferredLocation="";
                }
                $alternate_email="";
                if(!empty($json["Email"])){
                    $email_new=$json["Email"][0]["EmailAddress"];
                }else{
                    $email_new="";
                }
                if(!empty($json["PhoneNumber"])){
                    $mobile_new=$json["PhoneNumber"][0]["OriginalNumber"];
                }else{
                    $mobile_new="";
                }
                $recomon="";
                if(!empty($json["Recommendations"])){
                    foreach ($json["Recommendations"] as $recomondation) {
                        if(strlen($recomon) > 0){
                            $recomon = $recomon.', ';
                        }
                        $recomon = $recomon.$recomondation["PersonName"];
                    }
                }                
                if((String) !empty($json["WorkedPeriod"]["TotalExperienceInYear"])){
                    $tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];                    
                } else {$tot_exp=0;}
                $FullName = !empty($json["Name"]["FullName"])?$json["Name"]["FullName"]:$r_fullname;
                $cl = !empty($curentlocation)?$curentlocation:$r_location;
                $Summary = !empty($summary)?$summary:$r_summery;
                $Email = !empty($email_new)?$email_new:$r_email;
                $Mobile = !empty($mobile_new)?$mobile_new:$r_mobile;
                if(!empty($json['PhoneNumber'])) {
                    //$arrayPhone = explode(" ",$json["FormattedMobile"],2);
                    $country_code = $json["PhoneNumber"][0]["ISDCode"];
                    $Mobile = $json["PhoneNumber"][0]["OriginalNumber"];
                } else {
                    $country_code = $r_country_code;
                    $Mobile = $r_mobile;
                }
                $languages_known="";
                if(!empty($json["LanguageKnown"])){
                foreach ($json["LanguageKnown"] as $recomondation) {
                    if(strlen($languages_known) > 0){
                        $languages_known = $languages_known.', ';
                    }
                    $languages_known = $languages_known.$recomondation["Language"];
                }
               }
           
                $candidate = Candidate::create([
                    'full_name' => (String) $FullName,                    
                    'current_location' => (String) $cl,
                    'email' => (String) $Email,
                    'phone' => (String) $Mobile,
                    'mobile' => (String) $Mobile,
                    'country_code' => (String) $country_code,
                    'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                    'gender' => (String) $json["Gender"],
                    'job_profile' => (String) $json["JobProfile"],
                    'address' => (String) $json["Address"][0]["State"],
                    'city' => (String) $json["Address"][0]["City"],
                    'state' => (String) $json["Address"][0]["State"],
                    'country' => (String) $json["Address"][0]["Country"],
                    'zip' => (String) $json["Address"][0]["ZipCode"],
                    'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                    'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                    'total_experience_in_year' => $tot_exp,
                    'asset_id' => !empty($assetId)?$assetId:'',
                    'vendor_id' => $authuser->id,
                    'vendor_user_id' => ($authuser->parent_id) ? $authuser->id : 'null',
                    'summary' => $Summary,
                    'path' =>  $path ,
                    'title' => (String) $json["Name"]["TitleName"],
                    'first_name' => (String) $json["Name"]["FirstName"],
                    'middle_name' => (String) $json["Name"]["MiddleName"],
                    'last_name' => (String) $json["Name"]["LastName"],
                    'father_name' => (String) $json["FatherName"],
                    'mother_name' => (String) $json["MotherName"],
                    'marital_status' => (String) $json["MaritalStatus"],
                    'nationality' => (String) $json["Nationality"],
                    'language_known' => (String) $languages_known,
                    'unique_id' => (String) $json["UniqueID"],
                    'license_no' => (String) $json["LicenseNo"],
                    'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                    'pan_no' => (String) $json["PanNo"],
                    'visa_status' => (String) $json["VisaStatus"],
                    'alternate_email' =>(String) $alternate_email,
                    'cover_letter' => (String) $json["Coverletter"],
                    'certification' => (String) $json["Certification"],
                    'publication' => (String) $json["Publication"],
                    'preferred_location' =>(String) $PreferredLocation,
                    'availability' => (String) $json["Availability"],
                    'objectives' => (String) $json["Objectives"],
                    'candidate_references' => (String) $json["References"],
                    'parsing_date' => (String) $json["ParsingDate"],
                    'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                    'resume_file_name' => (String) $json["ResumeFileName"],
                    'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                    //'permanent_address' => (String) $dummy,
                    // 'permanent_city' => (String) $dummy,
                    // 'permanent_state' => (String) $dummy,
                    // 'permanent_country' => (String) $dummy,
                    // 'permanent_zip_code' => (String) $dummy,
                    // 'formatted_permanent_address' =>(String) $dummy,
                    'industry_category' => (String) $json["Category"],
                    'industry_sub_category' => (String) $json["SubCategory"],
                    'is_privatearea' => 0,
                    'executive_summary' => $executiveSummary,
                    'management_summary' => $managementSummary,
                    'hobbies'=>!empty($json['Hobbies'])?$json['Hobbies']:'',
                    'candidate_achievements'=>$json['Achievements'],
                    'qualification'=>$json['Qualification'],
                    'html_code'=>!empty($json['HtmlResume'])?$json['HtmlResume']:'',
                    'note'=>Input::get('description'),
                ]);
                $SkillBlock = $json["SkillKeywords"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    $SkillBlock = $json["SkillBlock"];
                    
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
                                
                        if(is_array($skillData) && count($skillData)>0) {
                            foreach($skillData as $ky => $val) {
                                $keyval = substr($val->keyval, 45);
                                if(!empty($keyval)){
                                    if($val->keyword=="skills") {
                                        DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
                                    } else {
                                            DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

                                    }
                                }
                            }
                        }
                        DB::delete('delete from skillblock_temp');
                    }
            

                $candidate_response = response()->success(compact('candidate'));
            

            $lastCandidateId = $candidate->id;

            $allSkills = !empty($allSkills)?$allSkills:$r_skills;
            $json_skills = !empty($json["Skills"])?$json["Skills"]:$r_skills;
            $operationalSkills = !empty($operationalSkills)?$operationalSkills:$r_skills;
            $softSkills = !empty($softSkills)?$softSkills:$r_skills;

            //Saving Condidate All Skills.
            $candidate_skill = CandidateSkillsets::create([
                'skill_set' => (string) $allSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_Set_response = response()->success(compact('candidate_skill'));
            $skills_new = '';
            $candidate_skills = CandidateSkills::create([
                'skills' => (string) $json["SkillKeywords"],//isko for each lagake aur implode karna hi
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_response = response()->success(compact('candidate_skills'));

            $candidate_operational_skills = CandidateOperationalSkills::create([
                'operational_skills' => (string) $operationalSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
            $candidate_soft_skills = CandidateSoftSkills::create([
                'soft_skills' => (string) $softSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
            // for only now
             foreach ($json["SegregatedQualification"] as $edu)
            {
                if(!empty($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);
                    //print_r($edu["Degree"]["DegreeName"]);exit;
                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["Location"]["City"],
                        'degree' => $edu["Degree"]["DegreeName"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'measure_type' => $edu["Aggregate"]["MeasureType"],

                        'institution_type' => $edu["Institution"]["Type"],
                        'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                        'state' => $edu["Institution"]["Location"]["State"],
                        'country' => $edu["Institution"]["Location"]["Country"],
                        'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                        'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_educations_response = response()->success(compact('candidate_educations'));
                }
            } //foreach
            ///candidate-details//need to create model and send it to database
            $recomon="";
            foreach ($json["Recommendations"] as $recomondation) {
                if(strlen($recomon) > 0){
                    $recomon = $recomon.', ';
                }
                $recomon = $recomon.$recomondation["PersonName"];
            }
            $websites="";
            foreach ($json["WebSite"] as $recomondation) {
                if(strlen($websites) > 0){
                    $websites = $websites.', ';
                }
                $websites = $websites.$recomondation["Url"];
            }
            $candidate_details = CandidateDetails::create([
                'gapperiod' => (string) $json["GapPeriod"],
                'averageStay' =>(string) $json["AverageStay"],
                'LongestStay' =>(string) $json["LongestStay"],
                'recommendations' =>(string) $recomon,
                'detail_resume' =>(string) $json["DetailResume"],
                'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                'websites' => (string) $websites,
                //'overalldata' => (string) $json,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_details_response = response()->success(compact('candidate_details'));


            foreach ($json["SegregatedSkill"] as $edu)
            {
                $segregatedskills = SegregatedSkill::create([
                    'type' => (string) $edu["Type"],
                    'skill' =>(string) $edu["Skill"],
                    'Ontology' =>(string) $edu["Ontology"],
                    'alias' =>(string) $edu["Alias"],
                    'formattedname' =>(string) $edu["FormattedName"],
                    'evidence' =>(string) $edu["Evidence"],
                    'lastused' =>(string) $edu["LastUsed"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregatedskills_response = response()->success(compact('segregatedskills'));

            }

            foreach ($json["SegregatedPublication"] as $edui)
            {
                $segregated_publication = SegregatedPublication::create([
                    'publication_title' => (string) $edui["PublicationTitle"],
                    'publisher_name' =>(string) $edui["Publisher"],
                    'publication_number' =>$edui["PublicationNumber"],
                    'publication_url' =>(string) $edui["PublicationUrl"],
                    'authors' =>(string) $edui["Authors"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_publication_response = response()->success(compact('segregated_publication'));

            }

                /* foreach ($json["EmailInfo"] as $edui)
            {
                print_r($edui);exit();
                $email_info = EmailInfo::create([
                    'email_to' =>  $edui["EmailTo"],
                    'email_body' => $edui["EmailBody"],
                    'emai_reply_to' =>$edui["EmailReplyTo"],
                    'email_signature' => $edui["EmailSignature"],
                    'emai_from' => $edui["EmailFrom"],
                    'email_subject' => $edui["EmailSubject"],
                    'email_cc' => $edui["EmailCC"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $email_info_response = response()->success(compact('email_info'));

            }*/

            foreach ($json["Recommendations"] as $edui)
            {
                $recommendations = Recommendations::create([
                    'person_name' => (string) $edui["PersonName"],
                    'company_name' =>(string) $edui["CompanyName"],
                    'relation' =>$edui["Relation"],
                    'position_title' =>(string) $edui["PositionTitle"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $recommendations_response = response()->success(compact('recommendations'));

            }

                   /*foreach ($json["ApiInfo"] as $edui)
            {
                $api_info = CandidateApiInfo::create([
                    'metered' =>  $edui["Metered"],
                    'credit_left' => $edui["CreditLeft"],
                    'account_expiry_date' =>$edui["AccountExpiryDate"],
                    'build_version' => $edui["BuildVersion"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $api_info_response = response()->success(compact('api_info'));

            }*/

            foreach ($json["SegregatedCertification"] as $edui)
            {
                $segregated_certification = SegregatedCertification::create([
                   'certification_title' => $edui["CertificationTitle"],
                    'authority' => $edui["Authority"],
                    'certification_code' =>$edui["CertificationCode"],
                    'is_expiry' => $edui["IsExpiry"],
                    'start_date' => $edui["StartDate"],
                    'end_date' =>$edui["EndDate"],
                    'certificationUrl' =>  $edui["CertificationUrl"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_certification_response = response()->success(compact('segregated_certification'));

            }


            foreach ($json["SegregatedAchievement"] as $edui)
            {
                $candidate_achievements = CandidateAchievements::create([
                    'award_title' => $edui["AwardTitle"],
                    'issuer' =>$edui["Issuer"],
                    'experience' =>  $json["Experience"],
                    'associated_with' => $edui["AssociatedWith"],
                    'issuing_date' => $edui["IssuingDate"],
                    'description' =>$edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_achievements_response = response()->success(compact('candidate_achievements'));

            }

            if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"] as $exp)
                {
                    if($exp['Employer'] != null && $exp["JobProfile"]["Title"] != null) {
                        $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                        //print_r($startDate);
                        $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'2 print_r le ke print karo
                        //print_r($endDate);kya problem hi
                        $candidate_exp = CandidateExperiences::create([
                            'employer_name' => $exp["Employer"]["EmployerName"],
                            'job_title' => $exp["JobProfile"]["Title"],
                            'empoyer_city' => $exp["Location"]["City"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' =>  date('Y-m-d', strtotime($endDate)),
                            'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                            'current_employer_name' => $json["CurrentEmployer"],
                            'total_experienceIn_months' => $json["WorkedPeriod"]["TotalExperienceInMonths"],
                            'total_experienceIn_year' => $json["WorkedPeriod"]["TotalExperienceInYear"],
                             'total_experienceIn_range' => $json["WorkedPeriod"]["TotalExperienceRange"],
                             'custom_fields' => $json["CustomFields"],

                            'candidate_id' => $lastCandidateId,
                        ]);
                        //print_r("ok");
                        $candidate_exp_response = response()->success(compact('candidate_exp'));
                    }
                }
                //candidate work history foreach
            } //if

            $candidate_note = !empty(Input::get('description'))?Input::get('description'):'';
            $candidate_notes = CandidateNotecs::create([
                'candidate_id' => $lastCandidateId,
                'note' => (string) $candidate_note
            ]);
            $candidate_notes_response = response()->success(compact('candidate_notes'));

            $inc = Input::get('inc');
            return response()->success(++$inc);
            }
            if(count($candidateId) >0){
                $inc = Input::get('inc');
                $candarray = ['incdata' => ++$inc,
                    'error'   => $json["ResumeFileName"]." Profile already exists and submitted."];
                return response()->error(compact('candarray'));
            }
            //SRILATHA code end if
        }else{
            $authuser = Auth::user();
            $authId=null;
            if($authuser->parent_id) {$authId=$authuser->parent_id;}
            else {$authId=$authuser->id;}
            //print_r($authId);die;
            // Rchilli CURL
            $jsonResult = null;
           // $APIURL="http://hirextra8.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";//OLD API
           $APIURL="https://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
            try
            {
                $file = Input::file('file');
                $description=Input::get('description');
                $assetId = null;
                $imagedata = file_get_contents($file);
                $base64 = base64_encode($imagedata);
                $key='Y0CPAOKBPGW';
                $version = "8.0.0";
                $subUserId = "Kumar Vuppala";
                $data = array(
                    "filedata" => $base64,
                    "filename" => $file->getClientOriginalName(),
                    "userkey" => $key,
                    "version" => $version,
                    "subuserid" => $subUserId
                );
                $str_data = json_encode($data);
                $ch = curl_init($APIURL);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Content-Length: ' . strlen($str_data))
                );
                 //print_r(curl_exec($ch)); exit;
                 $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
                 $err =curl_error($ch);
                 curl_close($ch);
                 if ($err) {
                     echo "cURL Error #:" . $err;
                 } 
                
                
            } //try
            catch (Exception $e)
            {
                echo 'Caught exception: ',  $e->getMessage(), "\n";
            } //catch
            //$inc = Input::get('inc');
           
            // if($jsonResult["error"]['errorcode'] == 1018) {

            //     $inc = Input::get('inc');
            //     $candarray = ['incdata' => ++$inc,
            //         'error'   => "Profile format is not supported plz check with the format"];
            //     return response()->error(compact('candarray'));
            //     //return json_decode(array($candidate->id, $inc++));
            //     // return json_decode(response()->error("Profile already exists in Candidate area."), ++$inc);
            // }
            $jsonResult = json_decode($jsonResult, true);
            $json=$jsonResult["ResumeParserData"];
            $summary='';
            $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            $fullname = 0; 
            if(!empty($json['Name']['FullName'])) {
                $fullname = $json['Name']['FullName'];
            }
            $location = 0;
            if(!empty($json['SegregatedQualification'][3]['Institution']['Location']['City'])) {
                $location = $json['SegregatedQualification'][3]['Institution']['Location']['City'];
            }
            if(empty($location)) {
                $location = $json['SegregatedExperience'][0]['Location']['City'];
            }
            $summary = 0;
            if(!empty($json['Summary'])) {
                $summary = $json['Summary'];
            }
            $email = 0;
            if(!empty($json['Email'][0]['EmailAddress'])) {
                $email = $json['Email'][0]['EmailAddress'];
            }
            $mobile = 0;
            if(!empty($json["PhoneNumber"][0]["Number"])) {
                $mobile = $json["PhoneNumber"][0]["Number"];
            }
            $country_code = 0;
            if(!empty($json['ResumeCountry']['CountryCode']['IsoAlpha2'])) {
                $country_code = $json['ResumeCountry']['CountryCode']['IsoAlpha2'];
            }
            
            $SkillSet=$json["SegregatedSkill"];
            
            $operationalSkills = null;
            $softSkills=null;
            $operationalSkills=null;
            //concatenate all the skills and assign to a variable.
            $skillsData = array();
            foreach($SkillSet as $skill)
            {
                $skillsData[] = $skill["Skill"];
            }
            $skillsDataStr = implode(',', $skillsData);
            $summary='';
            $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            $Email = $json["Email"];
            $EmailAddress = "";
            if(is_array($Email) && count($Email)>0) {
                $EmailAddress = $Email[0]['EmailAddress'];
                
                if(empty($EmailAddress)) {
                    $EmailAddress = $json["Email"];
                }
            }
            
            if($authuser->parent_id) {
                $candidateId=Candidate::where('email',$EmailAddress)
                    ->where('vendor_id',$authId)
                    ->first();
            } else {
                $candidateId=Candidate::where('email',$EmailAddress)
                    ->where('vendor_id',$authId)
                    ->first();
            }
            
            if(!empty($candidateId->id)){
                $inc = Input::get('inc');
                $candarray = ['incdata' => ++$inc,
                    'error'   => $json["ResumeFileName"]." Profile already exists and submitted."];
                return response()->error(compact('candarray'));
            }

            if(!$candidateId) {
                $asset_create_response = null;
                if ( Input::hasFile('file') )
                {
                    $files = array();
                    $files = Input::file('file');
                    $i = 0; foreach ($files as $value) {$i++;}
                    if($i == 0) {
                        $file_name = $files->getClientOriginalName();
                        $file_type = $files->getClientMimeType();
                        $path = base_path()."/public/user_assets/".$authId;
                        $destinationPath = 'user_assets/'.$authId;
                        $url = "/user_assets/".$authId;
                        $files->move($destinationPath,$files->getClientOriginalName());
                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authId,
                        ]);
                    } else {
                        foreach ($files as $singlefile) {
                            $file_name = $singlefile->getClientOriginalName();
                            $file_type = $singlefile->getClientMimeType();
                            $path = base_path()."/public/user_assets/".$authId;
                            $destinationPath = 'user_assets/'.$authId;
                            $url = "/user_assets/".$authId;
                            $singlefile->move($destinationPath, $singlefile->getClientOriginalName());
                            $assets_create = UserAsset::create([
                                'file_name' => $file_name,
                                'file_type' => $file_type,
                                'path' => $path,
                                'url' => $url,
                                'user_id' => $authId,
                            ]);
                        }//foreach
                    } // else
                    $assetId = $assets_create->id;   // Assign Id of asset

                    if($authuser->parent_id) {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'vendor_user_id' => $authuser->id,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    } else {
                        $candidateResumePostIn = Activity::create([
                            'vendor_id' => $authId,
                            'name' => 'Saved Uploaded resumes in private drive.'
                        ]);
                    }
                } //If
                //End of save raw asset
                //Choose candidate summary if exists.
                $summary = '';
                $executiveSummary=null;
                $managementSummary=null;
                if( $json["Summary"] )
                { $summary = (String) $json["Summary"]; }
                elseif( $json["ExecutiveSummary"] )
                { $executiveSummary = (String) $json["ExecutiveSummary"]; }
                elseif( $json["ManagementSummary"] )
                { $managementSummary = (String) $json["ManagementSummary"]; }
                $executiveSummary = (String) $json["ExecutiveSummary"];
                $managementSummary = (String) $json["ManagementSummary"];

                if($json["DateOfBirth"]){
                    $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
                }
                if($json["PhoneNumber"]){
                    $country_code = $json["PhoneNumber"][0]["ISDCode"];
                }else{
                    $country_code = "";
                }
                //print_r($json); exit;
                if($json["CurrentLocation"]){
                    $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
                }else{
                    $curentlocation="";
                }
                if($json["PreferredLocation"]){
                    $PreferredLocation=$json["PreferredLocation"];
                }else{
                    $PreferredLocation="";
                }
                $alternate_email="";
                if($json["Email"]){
                    $email_new=$json["Email"][0]["EmailAddress"];
                }else{
                    $email="";
                }
                if($json["PhoneNumber"]){
                    $mobile_new=$json["PhoneNumber"][0]["Number"];
                }else{
                    $mobile_new="";
                }

                $languages_known="";
                foreach ($json["LanguageKnown"] as $recomondation) {
                    if(strlen($languages_known) > 0){
                        $languages_known = $languages_known.', ';
                    }
                    $languages_known = $languages_known.$recomondation["Language"];
                }
                
                if((String) $json["WorkedPeriod"]["TotalExperienceInYear"] =='' || (String) $json["WorkedPeriod"]["TotalExperienceInYear"]==null){
                    $tot_exp=0;
                } else {$tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];}
                //Insert candidate record
                // echo 'SRILATHA:';print_r($json["CurrentLocation"]);exit;
               // print_r($json);
               // echo $fullname."_____L".$location."_____________S".$summary."_________E".$email."_____________M".$mobile;
               if(!empty($fullname) && !empty($location) && !empty($summary) && !empty($email) && !empty($mobile) ) {
                    $candidate_name_suc=$fullname;
                    $candidate = Candidate::create([
                        'full_name' => (String) $fullname,
                        'email' => (String) $email,
                        'phone' => (String) $mobile,
                        'mobile' => (String) $mobile,
                        'country_code' => (String) $country_code,
                        'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                        'gender' => (String) $json["Gender"],
                        'job_profile' => (String) $json["JobProfile"],
                        'address' => (String) $json["Address"][0]["State"],
                        'city' => (String) $json["Address"][0]["City"],
                        'state' => (String) $json["Address"][0]["State"],
                        'country' => (String) $json["Address"][0]["Country"],
                        'zip' => (String) $json["Address"][0]["ZipCode"],
                        'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                        'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                        'total_experience_in_year' => $tot_exp,
                        'asset_id' => $assetId,
                        'vendor_id' => $authuser->id,
                        'vendor_user_id' => ($authuser->parent_id) ? $authuser->id : 'null',
                        'summary' => $summary,
                        'path' =>  $path,
                        'title' => (String) $json["Name"]["TitleName"],
                        'first_name' => (String) $json["Name"]["FirstName"],
                        'middle_name' => (String) $json["Name"]["MiddleName"],
                        'last_name' => (String) $json["Name"]["LastName"],
                        'father_name' => (String) $json["FatherName"],
                        'mother_name' => (String) $json["MotherName"],
                        'marital_status' => (String) $json["MaritalStatus"],
                        'nationality' => (String) $json["Nationality"],
                        'language_known' => (String) $languages_known,
                        'unique_id' => (String) $json["UniqueID"],
                        'license_no' => (String) $json["LicenseNo"],
                        'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                        'pan_no' => (String) $json["PanNo"],
                        'visa_status' => (String) $json["VisaStatus"],
                        'alternate_email' =>(String) $alternate_email,
                        'cover_letter' => (String) $json["Coverletter"],
                        'certification' => (String) $json["Certification"],
                        'publication' => (String) $json["Publication"],
                        'current_location' =>(String) $curentlocation,
                        'preferred_location' =>(String) $PreferredLocation,
                        'availability' => (String) $json["Availability"],
                        'objectives' => (String) $json["Objectives"],
                        'candidate_references' => (String) $json["References"],
                        'parsing_date' => (String) $json["ParsingDate"],
                        'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                        'resume_file_name' => (String) $json["ResumeFileName"],
                        'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                        //'permanent_address' => (String) $dummy,
                        // 'permanent_city' => (String) $dummy,
                        // 'permanent_state' => (String) $dummy,
                        // 'permanent_country' => (String) $dummy,
                        // 'permanent_zip_code' => (String) $dummy,
                        // 'formatted_permanent_address' =>(String) $dummy,
                        'industry_category' => (String) $json["Category"],
                        'industry_sub_category' => (String) $json["SubCategory"],
                        'is_privatearea' => 0,
                        'executive_summary' => $executiveSummary,
                        'management_summary' => $managementSummary,
                        'hobbies'=>$json['Hobbies'],
                        'candidate_achievements'=>$json['Achievements'],
                        'html_code'=>$json['HtmlResume'],
                        'qualification'=>$json['Qualification'],
                        'note'=>Input::get('description'),
                    ]);
                    $candidate_skills = CandidateSkills::create([
                        'skills' => (string) $json["SkillKeywords"],
                        'candidate_id' => $candidate->id,
                    ]);
                    $candidate_skill = CandidateSkillsets::create([
                    'skill_set' => $skillsDataStr,
                    'candidate_id' => $candidate->id,
                ]);
                    $SkillBlock = $json["SkillKeywords"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    //echo "i am here"; exit();
                    $SkillBlock = $json["SkillBlock"];
                    
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
                                
                        if(is_array($skillData) && count($skillData)>0) {
                            foreach($skillData as $ky => $val) {
                                $keyval = substr($val->keyval, 45);
                                if(!empty($keyval)){
                                    if($val->keyword=="skills") {
                                        DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
                                    } else {
                                            DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

                                    }
                                }
                            }
                        }
                        DB::delete('delete from skillblock_temp');
                    }
            
                    $candidate_response = response()->success(compact('candidate'));
                    $inc = Input::get('inc');

                    $success_array = ['candidate_id' => $candidate->id,'inc_data' => ++$inc,'message'=> $candidate_name_suc."profile is uploaded."];
                    return response()->success(compact('success_array'));
                }else{
                    //echo "i am here else";die();
                    $error_location = $error_exp = $error_summery = $error_email = $error_phone = $error_mobile =
                    $error_fullname = $error_skills = $error_country_code = "";

                    if(empty($json["Name"]["FullName"])) {
                        $error_fullname = '1';
                    }else{
                        $error_fullname = 0;
                    }
                   
                    if($json["PhoneNumber"]){
                        $error_country_code = '1';
                    }else{
                        $error_country_code = 0;
                    }
                    if(empty($curentlocation)) {
                        $error_location = '1';
                    }else{
                        $error_location = 0;
                    }

                    if(empty($json["WorkedPeriod"]["TotalExperienceInYear"])){
                        $error_exp = 1;
                    }else{
                        $error_exp = 0;
                    }

                    if($json["Summary"] || $json["ExecutiveSummary"] || $json["ManagementSummary"]){
                        $error_summery = 0;
                    }else{
                        $error_summery = 1;
                    }
                    if(empty($email)){
                        $error_email = '1';
                    }else{
                        $error_email = 0;
                    }

                    if(empty($mobile_new)){
                        $error_phone = 1;
                    }else{
                        $error_phone = 0;
                    }

                    if(empty($json["SkillKeywords"])){
                        $error_skills = 1;
                    }else{
                        $error_skills = 0;
                    }
                    $fileuploadarr = [ 'fullname'=> $error_fullname,
                        'location'=>$error_location,
                        'summary'=>$error_summery,
                        'email'=>$error_email,
                        'mobile'=>$error_phone,
                        'skills'=>$error_skills,
                        'country_code' => $error_country_code,
                        'inc'=>Input::get('inc')
                        ];

                        //echo "i am here else"; print_r($fileuploadarr);
                     $json['assetId'] = $assetId;
                    // echo "i am here else assetid"; 
                    $json['path'] = $path; 
                    //echo "i am here else path";  
                    //echo "i am here else json";
                    $fileuploadarr['json'] = $json;
                    //print_r($json);

                    return response()->error(compact('fileuploadarr'));
                    //return response()->success(compact('fileuploadarr'));
                    //echo "i am here else path";die;
              
                }



                // else {
                //  return response()->error($json["FullName"].' Location is required.');
                // }

                // Assign last candidate ID
                $lastCandidateId = $candidate->id;
                if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                            foreach ($json["SegregatedExperience"] as $exp)
                            {
                                if($exp['Employer'] != null && $exp["JobProfile"]["Title"] != null) {
                                    $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                                    //print_r($startDate);
                                    $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'2 print_r le ke print karo
                                    //print_r($endDate);kya problem hi
                                    $candidate_exp = CandidateExperiences::create([
                                        'employer_name' => $exp["Employer"]["EmployerName"],
                                        'job_title' => $exp["JobProfile"]["Title"],
                                        'empoyer_city' => $exp["Location"]["City"],
                                        'start_date' => date('Y-m-d', strtotime($startDate)),
                                        'end_date' =>  date('Y-m-d', strtotime($endDate)),
                                        'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                                        'current_employer_name' => $json["CurrentEmployer"],
                                        'total_experienceIn_months' => $json["WorkedPeriod"]["TotalExperienceInMonths"],
                                        'total_experienceIn_year' => $json["WorkedPeriod"]["TotalExperienceInYear"],
                                        'total_experienceIn_range' => $json["WorkedPeriod"]["TotalExperienceRange"],
                                        'custom_fields' => $json["CustomFields"],

                                        'candidate_id' => $lastCandidateId,
                                    ]);
                                    //print_r("ok");
                                    $candidate_exp_response = response()->success(compact('candidate_exp'));
                                }
                            }
                            //candidate work history foreach
                 } //if
                //Insert a record into candidateskillssets table
                
                $skills_new = '';
                
                $candidate_operational_skills = CandidateOperationalSkills::create([
                    'operational_skills' => (string) $operationalSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
                $candidate_soft_skills = CandidateSoftSkills::create([
                    'soft_skills' => (string) $softSkills,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
                // for only now
                foreach ($json["SegregatedQualification"] as $edu)
                    {
                    if(!empty($edu["Institution"]))
                    {
                        $startDate = str_replace('/', '-', $edu["StartDate"]);
                        $endDate = str_replace('/', '-', $edu["EndDate"]);
                        //print_r($edu["Degree"]["DegreeName"]);exit;
                        //Insert a record into candidateskillssets table
                        $candidate_educations = CandidateEducations::create([
                            'institution_name' => $edu["Institution"]["Name"],
                            'institution_city' => $edu["Institution"]["Location"]["City"],
                            'degree' => $edu["Degree"]["DegreeName"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' => date('Y-m-d', strtotime($endDate)),
                            'aggregate' => $edu["Aggregate"]["Value"],
                            'measure_type' => $edu["Aggregate"]["MeasureType"],

                            'institution_type' => $edu["Institution"]["Type"],
                            'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                            'state' => $edu["Institution"]["Location"]["State"],
                            'country' => $edu["Institution"]["Location"]["Country"],
                            'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                            'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                            'candidate_id' => $lastCandidateId,
                        ]);
                        $candidate_educations_response = response()->success(compact('candidate_educations'));
                    }
                } //foreach
                ///candidate-details//need to create model and send it to database
                $recomon="";
                foreach ($json["Recommendations"] as $recomondation) {
                    if(strlen($recomon) > 0){
                        $recomon = $recomon.', ';
                    }
                    $recomon = $recomon.$recomondation["PersonName"];
                }
                $websites="";
                foreach ($json["WebSite"] as $recomondation) {
                    if(strlen($websites) > 0){
                        $websites = $websites.', ';
                    }
                    $websites = $websites.$recomondation["Url"];
                }
                $candidate_details = CandidateDetails::create([
                    'gapperiod' => (string) $json["GapPeriod"],
                    'averageStay' =>(string) $json["AverageStay"],
                    'LongestStay' =>(string) $json["LongestStay"],
                    'recommendations' =>(string) $recomon,
                    'detail_resume' =>(string) $json["DetailResume"],
                    'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                    'websites' => (string) $websites,
                    //'overalldata' => (string) $json,
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_details_response = response()->success(compact('candidate_details'));


                foreach ($json["SegregatedSkill"] as $edu)
                {
                    $segregatedskills = SegregatedSkill::create([
                        'type' => (string) $edu["Type"],
                        'skill' =>(string) $edu["Skill"],
                        'Ontology' =>(string) $edu["Ontology"],
                        'alias' =>(string) $edu["Alias"],
                        'formattedname' =>(string) $edu["FormattedName"],
                        'evidence' =>(string) $edu["Evidence"],
                        'lastused' =>(string) $edu["LastUsed"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $segregatedskills_response = response()->success(compact('segregatedskills'));

                }

                foreach ($json["SegregatedPublication"] as $edui)
            {
                $segregated_publication = SegregatedPublication::create([
                    'publication_title' => (string) $edui["PublicationTitle"],
                    'publisher_name' =>(string) $edui["Publisher"],
                    'publication_number' =>$edui["PublicationNumber"],
                    'publication_url' =>(string) $edui["PublicationUrl"],
                    'authors' =>(string) $edui["Authors"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_publication_response = response()->success(compact('segregated_publication'));

            }

                /* foreach ($json["EmailInfo"] as $edui)
            {
                print_r($edui);exit();
                $email_info = EmailInfo::create([
                    'email_to' =>  $edui["EmailTo"],
                    'email_body' => $edui["EmailBody"],
                    'emai_reply_to' =>$edui["EmailReplyTo"],
                    'email_signature' => $edui["EmailSignature"],
                    'emai_from' => $edui["EmailFrom"],
                    'email_subject' => $edui["EmailSubject"],
                    'email_cc' => $edui["EmailCC"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $email_info_response = response()->success(compact('email_info'));

            }*/

            foreach ($json["Recommendations"] as $edui)
            {
                $recommendations = Recommendations::create([
                    'person_name' => (string) $edui["PersonName"],
                    'company_name' =>(string) $edui["CompanyName"],
                    'relation' =>$edui["Relation"],
                    'position_title' =>(string) $edui["PositionTitle"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $recommendations_response = response()->success(compact('recommendations'));

            }

                   /*foreach ($json["ApiInfo"] as $edui)
            {
                $api_info = CandidateApiInfo::create([
                    'metered' =>  $edui["Metered"],
                    'credit_left' => $edui["CreditLeft"],
                    'account_expiry_date' =>$edui["AccountExpiryDate"],
                    'build_version' => $edui["BuildVersion"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $api_info_response = response()->success(compact('api_info'));

            }*/

            foreach ($json["SegregatedCertification"] as $edui)
            {
                $segregated_certification = SegregatedCertification::create([
                   'certification_title' => $edui["CertificationTitle"],
                    'authority' => $edui["Authority"],
                    'certification_code' =>$edui["CertificationCode"],
                    'is_expiry' => $edui["IsExpiry"],
                    'start_date' => $edui["StartDate"],
                    'end_date' =>$edui["EndDate"],
                    'certificationUrl' =>  $edui["CertificationUrl"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_certification_response = response()->success(compact('segregated_certification'));

            }


            foreach ($json["SegregatedAchievement"] as $edui)
            {
                $candidate_achievements = CandidateAchievements::create([
                    'award_title' => $edui["AwardTitle"],
                    'issuer' =>$edui["Issuer"],
                    'experience' =>  $json["Experience"],
                    'associated_with' => $edui["AssociatedWith"],
                    'issuing_date' => $edui["IssuingDate"],
                    'description' =>$edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $candidate_achievements_response = response()->success(compact('candidate_achievements'));

            }
                //Insert Successfull resume posting activity record
                if($authuser->parent_id) {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'vendor_user_id' => $authuser->id,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                } else {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                }
                $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
                $inc = Input::get('inc');
                
                $candarray = ['incdata' => ++$inc,
                    'candidate_id'   => $candidate->id];
                return response()->success(compact('candarray'));
               // return json_decode($candidate->id, ++$inc);
                /*} */
                /*}*/
            }
            $inc = Input::get('inc');

            if(count($candidateId) != 0) {

                $inc = Input::get('inc');
                $candarray = ['incdata' => ++$inc,
                    'error'   => $json['FullName']."Profile already exists in Candidate area."];
                return response()->error(compact('candarray'));
                //return json_decode(array($candidate->id, $inc++));
                // return json_decode(response()->error("Profile already exists in Candidate area."), ++$inc);
            } else {
                return json_decode(response()->error($json['FullName']."Profile already exists and submitted Please try with new Profile."), ++$inc);
            }
        }
    } //postResume function
 

 
    public function postResume()
    {
    $authuser = Auth::user();
    $jsonResult = null;
   // $APIURL="https://hirextra8.rchilli.com/RChilliParser/Rchilli/parseResumeBinary"; //Old Api
    $APIURL="https://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
    try
    {
        $file = Input::file('file');
        $jobId = Input::get('jobId');
        $assetId = null;
        $imagedata = file_get_contents($file);
        $base64 = base64_encode($imagedata);
        $key='Y0CPAOKBPGW';
        $version = "8.0.0";
        $subUserId = "Kumar Vuppala";
        $data = array(
            "filedata" => $base64,
            "filename" => $file->getClientOriginalName(),
            "userkey" => $key,
            "version" => $version,
            "subuserid" => $subUserId
        );

        $str_data = json_encode($data);
        $ch = curl_init($APIURL);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($str_data))
        );
        $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
        $err =curl_error($ch);
        curl_close($ch);
        if ($err) {
            echo "cURL Error #:" . $err;
        } 
    } //try
    catch (Exception $e)
    { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch

    $jsonResult = json_decode($jsonResult, true);
    if(!empty($jsonResult['error'])&&$jsonResult['error']['errorcode']==1014){
        return response()->error("Profile format is invalid.");
    }

    // $jsonResult = json_decode($jsonResult, true);
    if(!empty($jsonResult['error'])&&$jsonResult['error']['errorcode']==1021){
        return response()->error("File Conversion Error.");
    }
    // $jsonResult = json_decode($jsonResult, true);

    //$json=$jsonResult["ResumeParserData"];

    $json=$jsonResult["ResumeParserData"];

    $summary='';
    $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
    if(!empty($json["Email"][0]["EmailAddress"])) {
        $emailAddr = $json["Email"][0]["EmailAddress"];
    } else {
        $emailAddr = '';
    }
    $candidateId = Candidate::where('Email',$emailAddr)
            //->where('total_experience_in_year',$expe)
            ->where('vendor_id',$authuser->id)
            ->get();
    $checkifcan = 0;
    if(count($candidateId) != 0) {
            $checkifcan = Association::where('vendor_id',$authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->where('job_id',$jobId)
                ->where('candidate_id', $candidateId[0]->id)
                ->count();
                
    }

    $path ="";
    if( $checkifcan == 0  ) {
    // Save raw asset
    $asset_create_response = null;
    if ( Input::hasFile('file') )
    {
        $files = Input::file('file');
        if($files){
            $file_name = $files->getClientOriginalName();
            $file_type = $files->getClientMimeType();
            $path = base_path()."/public/user_assets/".$authuser->id;
            $destinationPath = 'user_assets/'.$authuser->id;
            $url = "/user_assets/".$authuser->id;
            $files->move($destinationPath, $files->getClientOriginalName());

            //Insert assets record
            $assets_create = UserAsset::create([
                'file_name' => $file_name,
                'file_type' => $file_type,
                'path' => $path,
                'url' => $url,
                'user_id' => $authuser->id,
            ]);
            //$asset_create_response =  response()->success(compact('assets_create'));

        }
        $assetId = $assets_create->id;   // Assign Id of asset
        $candidateResumePostIn = Activity::create([
            'person_id' => $authuser->id,
            'name' => 'Saved Uploaded resumes in private drive.',
        ]);

    }
    // print_r("97");
    // $assets_create = UserAsset::where('file_name',$json['ResumeFileName'])->orderBy('id','desc')->first()->id;
    $json['assetId'] = $assets_create;
    // print_r("97-1");
    $json['path'] = base_path()."/public/user_assets/".$authuser->id;
    // print_r("97-2");
    //Start Because of this returning 500 error @nagarjuna 10/09/2022
    //$currencyname = JobOrders::where('id',$jobId)->first()->currency;
    
    // $getcurrency =  Currency::where('code',$currencyname)->first()->symbol;
    //print_r($json['currency_job']);
        //$json['currency_job'] = $currencyname;
    //End Because of this returning 500 error @nagarjuna 10/09/2022
    // print_r("97-5");
    if($emailAddr == '')
    {
        DB::insert("insert into candidate_json set job_id='".$jobId."', json='".base64_encode(serialize($json))."', flag='0', user_id='".$authuser->id."', created_at='".date('Y-m-d h:i:s')."', updated_at='".date('Y-m-d h:i:s')."'");
    }
    else{
        DB::insert("insert into candidate_json set job_id='".$jobId."', json='".base64_encode(serialize($json))."',email='".$emailAddr."', flag='0', user_id='".$authuser->id."',created_at='".date('Y-m-d h:i:s')."', updated_at='".date('Y-m-d h:i:s')."'");
    }
    }
    $SkillBlock = $json["SkillBlock"];
    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
    $SkillBlock = preg_replace('/[^a-zA-Z0-9]+ /','~', $SkillBlock);
    $skillsResumes = explode('~', $SkillBlock);
    $skillDataInfo = array();
    if(is_array($skillsResumes) && count($skillsResumes)>0) {

        foreach($skillsResumes as $skills) {
            
            $SkillBlock = preg_replace('/:/', '~', $skills);
            $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
            $SkillBlockArr = explode('~', $SkillBlock);
            if(count($SkillBlockArr)==1) {
                $SkillBlockArr = explode(',', $SkillBlockArr[0]);
                
                foreach($SkillBlockArr as $key =>$value) {
                    
                    if(!empty($value)) {
                        if(strpos($value, '/')) {
                            $valueArr = explode('/', $value);                   
                            foreach($valueArr as $kyr =>$valr) {
                                $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($valr))."'";
                                ///echo "<br>".$sql;
                                $skillInfo = DB::select($sql);
                                
                                if(is_array($skillInfo) && count($skillInfo)>0) {
                                    foreach($skillInfo as $ky=>$val) {
                                        DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                    }
                                } else {

                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($valr))."'");
                                }
                            }
                        } else {
                            $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where sv.skillblock_keywords='".addslashes(trim($value))."'";
                                ///echo "<br>".$sql;
                                $skillInfo = DB::select($sql);
                                
                                if(is_array($skillInfo) && count($skillInfo)>0) {
                                    foreach($skillInfo as $ky=>$val) {
                                        DB::insert("insert into skillblock_temp set keyword='".$val->skill_name."', value='".addslashes($val->skillblock_keywords)."'");
                                    }
                                } else {

                                    DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes(trim($value))."'");
                                }
                        }
                    }
                }
            } else {
                $skillInfo =    explode(':', $skills);
                $skillDataInfo[] = array($skillInfo[0]=> $skillInfo[1]);;
            }
        }
        //exit;
        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
      //  print_r("99");
        if(is_array($skillData) && count($skillData)>0) {
            foreach($skillData as $ky => $val) {
                $keyval = $val->keyval;
                if(!empty($keyval)){
                    if($val->keyword=="skills") {
                        $skillDataInfo[] = array($val->keyword => $keyval);
                    } else {
                        $skillDataInfo[] = array($val->keyword => $keyval);

                    }
                }
            }
        }
         
        $json['skillblockdata'] = $skillDataInfo;

        DB::delete('delete from skillblock_temp');

    }
    //print_r("100"); exit;   
    $json['assetId'] = $assetId;
    $json['path'] = $path;
    //Start Because of this returning 500 error @nagarjuna 10/09/2022
    if(isset($jobId)){
    $currencyname = JobOrders::where('id',$jobId)->first()->currency;
    $getcurrency =  Currency::where('code',$currencyname)->first()->symbol;
    //
    $json["CurrentSalary"]["Currency"] = $currencyname;
    $json["ExpectedSalary"]["Currency"] = $currencyname;
    $json['currency_job'] = $getcurrency;
    }
    //print_r($json);exit;
    //End Because of this returning 500 error @nagarjuna 10/09/2022
    if( $checkifcan == 0  ) {
        return response()->success(compact('json'));
    }
    else{
        return response()->error("Profile already exists and submitted.");
    }
} //postResume functiondd


    public function postResumeuser()
    {
        $authuser = Auth::user();
        // Rchilli CURL
        $jsonResult = null;
        $APIURL="http://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
        try
        {
            $file = Input::file('file');
            $jobId = Input::get('jobId');

            $assetId = null;

            $imagedata = file_get_contents($file);
            $base64 = base64_encode($imagedata);
            $key='Y0CPAOKBPGW';
            $version = "7.0.0";
            $subUserId = "Hirextra";
            $data = array(
                "filedata" => $base64,
                "filename" => $file->getClientOriginalName(),
                "userkey" => $key,
                "version" => $version,
                "subuserid" => $subUserId
            );

            $str_data = json_encode($data);
            $ch = curl_init($APIURL);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
        } //try
        catch (Exception $e)
        { 
            echo 'Caught exception: ',  $e->getMessage(), "\n";
         } //catch

        $jsonResult = json_decode($jsonResult, true);

        $json=$jsonResult["ResumeParserData"];
        $summary='';
        $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
//if($json["Email"] != '' || $json["Email"] != null){

        $candidateId = Candidate::where('Email',$json["Email"])
            ->where('total_experience_in_year',$expe)
            ->where('vendor_id',$authuser->parent_id)
            ->first();
        $checkifcan = 0;
        if(count($candidateId) != 0) {
            $checkifcan = Association::where('vendor_id',$authuser->id)
                ->whereNotNull('accountmanager_id')
                ->whereNotNull('employer_id')
                ->where('job_id',$jobId)
                ->where('candidate_id', $candidateId->id)
                ->count();
        }

        //  }
        if( ($checkifcan == 0) && (count($candidateId) == 0) ) {
            // Save raw asset
            $asset_create_response = null;

            if ( Input::hasFile('file') )
            {
                $files = Input::file('file');

                if(count($files) == 1){

                    $file_name = $files->getClientOriginalName();
                    $file_type = $files->getmimeType();
                    $path = base_path()."/public/user_assets/".$authuser->id;
                    $destinationPath = 'user_assets/'.$authuser->id;
                    $url = "/user_assets/".$authuser->id;
                    $files->move($destinationPath, $files->getClientOriginalName());

                    //Insert assets record
                    $assets_create = UserAsset::create([
                        'file_name' => $file_name,
                        'file_type' => $file_type,
                        'path' => $path,
                        'url' => $url,
                        'user_id' => $authuser->id,
                    ]);
                    //$asset_create_response =  response()->success(compact('assets_create'));

                } else {

                    foreach ($files as $singlefile) {
                        $file_name = $singlefile->getClientOriginalName();
                        $file_type = $singlefile->getmimeType();
                        $path = base_path()."/public/user_assets/".$authuser->id;
                        $destinationPath = 'user_assets/'.$authuser->id;
                        $url = "/user_assets/".$authuser->id;
                        $singlefile->move($destinationPath, $singlefile->getClientOriginalName());

                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authuser->id,
                        ]);
                        //$asset_create_response =  response()->success(compact('assets_create'));

                    }//foreach
                } // else
                $assetId = $assets_create->id;   // Assign Id of asset
                //Insert Successfull resume posting activity record
                $candidateResumePostIn = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Saved Uploaded resumes in private drive.',
                ]);
                //$candidateResumePostInResponse =  response()->success(compact('candidateResumePostIn'));
                //return $asset_create_response;
            } //If
            //End of save raw asset

            //Choose candidate summary if exists.
            $summary = '';
            if( $json["Summary"] )
            { $summary = (String) $json["Summary"]; }
            elseif( $json["ExecutiveSummary"] )
            { $summary = (String) $json["ExecutiveSummary"]; }
            elseif( $json["ManagementSummary"] )
            { $summary = (String) $json["ManagementSummary"]; }

            //echo $assetId;    exit();

            if($json["DateOfBirth"]){
                $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
            }

            // $path = base_path()."/user_assets/".$authuser->id;
            //        $destinationPath = '../user_assets/'.$authuser->id;
            //        $file->move($destinationPath, $file->getClientOriginalName());


            //Insert candidate record
            $candidate = Candidate::create([
                'full_name' => (String) $json["FullName"],
                'email' => (String) $json["Email"],
                'phone' => (String) $json["Phone"],
                'mobile' => (String) $json["Mobile"],
                'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                'gender' => (String) $json["Gender"],
                'job_profile' => (String) $json["JobProfile"],
                'address' => (String) $json["Address"],
                'city' => (String) $json["City"],
                'state' => (String) $json["State"],
                'country' => (String) $json["Country"],
                'zip' => (String) $json["ZipCode"],
                'current_salary' => (String) $json["CurrentSalary"],
                'expected_salary' => (String) $json["ExpectedSalary"],
                'total_experience_in_year' => (String) $json["WorkedPeriod"]["TotalExperienceInYear"],
                'asset_id' => $assetId,
                'summary' => $summary,
                'path' =>  $path ,
                'vendor_id' => $authuser->id,
            ]);
            $candidate_response = response()->success(compact('candidate'));

            // Assign last candidate ID
            $lastCandidateId = $candidate->id;
            if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"]["WorkHistory"] as $exp)
                {
                    $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                    $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'
                    $candidate_exp = CandidateExperiences::create([
                        'employer_name' => $exp["Employer"],
                        'job_title' => $exp["JobProfile"]["Title"],
                        'empoyer_city' => $exp["JobLocation"]["EmployerCity"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' =>  date('Y-m-d', strtotime($endDate)),
                        'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_exp_response = response()->success(compact('candidate_exp'));
                } //candidate work history foreach
            } //if

            $SkillSet=$json["SkillKeywords"]["SkillSet"];
            $allSkills = null;

            //concatenate all the skills and assign to a variable.
            foreach($SkillSet as $skill)
            {
                if( $allSkills)  {$allSkills = $allSkills.', '. $skill["Skill"]; }
                else  { $allSkills = $skill["Skill"]; }
            }

            //Insert a record into candidateskillssets table
            $candidate_skill = CandidateSkillsets::create([
                'skill_set' => (string) $allSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_response = response()->success(compact('candidate_skill'));

            foreach ($json["SegregatedQualification"]["EducationSplit"] as $edu)
            {
                if(!empty($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);

                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["City"],
                        'degree' => $edu["Degree"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_educations_response = response()->success(compact('candidate_educations'));
                }
            } //foreach

            //Insert Successfull resume posting activity record
            $candidateResumePostIn = Activity::create([
                'person_id' => $authuser->id,
                'resume_id' => $lastCandidateId,
                'name' => 'Uploaded resume successfully',
            ]);
            $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
            return $candidate->id;
        }
        if( ($checkifcan == 0) && (count($candidateId) != 0) ) {
            return $candidateId->id;
        }
        else{
            return response()->error("Profile already exists and submitted.");
        }

    } //postResume function
    public function postResumecandidate()
    {
        $authuser = Auth::user();
        // Rchilli CURL
        $jsonResult = null;
        $APIURL="http://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
        try
        {
            $file = Input::file('file');
            $note = Input::get('note');
            /*print_r($note);
    exit;*/
            $assetId = null;

            $imagedata = file_get_contents($file);
            $base64 = base64_encode($imagedata);
            $key='Y0CPAOKBPGW';
            $version = "7.0.0";
            $subUserId = "Hirextra";
            $data = array(
                "filedata" => $base64,
                "filename" => $file->getClientOriginalName(),
                "userkey" => $key,
                "version" => $version,
                "subuserid" => $subUserId
            );

            $str_data = json_encode($data);
            $ch = curl_init($APIURL);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch

        $jsonResult = json_decode($jsonResult, true);

        $json=$jsonResult["ResumeParserData"];
        $summary='';
        $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
        $candidateId = Candidate::where('Email',$json["Email"])
            ->where('total_experience_in_year',$expe)
            ->where('vendor_id',$authuser->id)
            ->count();
        if( $candidateId == 0 ) {
            // Save raw asset
            $asset_create_response = null;

            if ( Input::hasFile('file') )
            {
                $files = Input::file('file');

                if(count($files) == 1){

                    $file_name = $files->getClientOriginalName();
                    $file_type = $files->getmimeType();
                    $path = base_path()."/public/user_assets/".$authuser->id;
                    $destinationPath = 'user_assets/'.$authuser->id;
                    $url = "/user_assets/".$authuser->id;
                    $files->move($destinationPath, $files->getClientOriginalName());

                    //Insert assets record
                    $assets_create = UserAsset::create([
                        'file_name' => $file_name,
                        'file_type' => $file_type,
                        'path' => $path,
                        'url' => $url,
                        'user_id' => $authuser->id,
                    ]);
                    //$asset_create_response =  response()->success(compact('assets_create'));

                } else {

                    foreach ($files as $singlefile) {
                        $file_name = $singlefile->getClientOriginalName();
                        $file_type = $singlefile->getmimeType();
                        $path = base_path()."/public/user_assets/".$authuser->id;
                        $destinationPath = 'user_assets/'.$authuser->id;
                        $url = "/user_assets/".$authuser->id;
                        $singlefile->move($destinationPath, $singlefile->getClientOriginalName());

                        //Insert assets record
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authuser->id,
                        ]);
                        //$asset_create_response =  response()->success(compact('assets_create'));

                    }//foreach
                } // else
                $assetId = $assets_create->id;   // Assign Id of asset
                //Insert Successfull resume posting activity record
                $candidateResumePostIn = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Saved Uploaded resumes in private drive.',
                ]);
                //$candidateResumePostInResponse =  response()->success(compact('candidateResumePostIn'));
                //return $asset_create_response;
            } //If
            //End of save raw asset

            //Choose candidate summary if exists.
            $summary = '';
            if( $json["Summary"] )
            { $summary = (String) $json["Summary"]; }
            elseif( $json["ExecutiveSummary"] )
            { $summary = (String) $json["ExecutiveSummary"]; }
            elseif( $json["ManagementSummary"] )
            { $summary = (String) $json["ManagementSummary"]; }

            //echo $assetId;    exit();

            if($json["DateOfBirth"]){
                $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
            }

            // $path = base_path()."/user_assets/".$authuser->id;
            //        $destinationPath = '../user_assets/'.$authuser->id;
            //        $file->move($destinationPath, $file->getClientOriginalName());


            //Insert candidate record
            $candidate = Candidate::create([
                'full_name' => (String) $json["FullName"],
                'email' => (String) $json["Email"],
                'phone' => (String) $json["Phone"],
                'mobile' => (String) $json["Mobile"],
                'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                'gender' => (String) $json["Gender"],
                'job_profile' => (String) $json["JobProfile"],
                'address' => (String) $json["Address"],
                'city' => (String) $json["City"],
                'state' => (String) $json["State"],
                'country' => (String) $json["Country"],
                'zip' => (String) $json["ZipCode"],
                'current_salary' => (String) $json["CurrentSalary"],
                'expected_salary' => (String) $json["ExpectedSalary"],
                'total_experience_in_year' => (String) $json["WorkedPeriod"]["TotalExperienceInYear"],
                'asset_id' => $assetId,
                'summary' => $summary,
                'path' =>  $path ,
                'vendor_id' => $authuser->id,
                'note'=>$note,
            ]);
            $candidate_response = response()->success(compact('candidate'));

            // Assign last candidate ID
            $lastCandidateId = $candidate->id;
            if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"]["WorkHistory"] as $exp)
                {
                    $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                    $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'
                    $candidate_exp = CandidateExperiences::create([
                        'employer_name' => $exp["Employer"],
                        'job_title' => $exp["JobProfile"]["Title"],
                        'empoyer_city' => $exp["JobLocation"]["EmployerCity"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' =>  date('Y-m-d', strtotime($endDate)),
                        'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_exp_response = response()->success(compact('candidate_exp'));
                } //candidate work history foreach
            } //if

            $SkillSet=$json["SkillKeywords"]["SkillSet"];
            $allSkills = null;

            //concatenate all the skills and assign to a variable.
            foreach($SkillSet as $skill)
            {
                if( $allSkills)  {$allSkills = $allSkills.', '. $skill["Skill"]; }
                else  { $allSkills = $skill["Skill"]; }
            }

            //Insert a record into candidateskillssets table
            $candidate_skill = CandidateSkillsets::create([
                'skill_set' => (string) $allSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_response = response()->success(compact('candidate_skill'));

            foreach ($json["SegregatedQualification"]["EducationSplit"] as $edu)
            {
                if(!empty($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);

                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["City"],
                        'degree' => $edu["Degree"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_educations_response = response()->success(compact('candidate_educations'));
                }
            } //foreach

            //Insert Successfull resume posting activity record
            $candidateResumePostIn = Activity::create([
                'person_id' => $authuser->id,
                'resume_id' => $lastCandidateId,
                'name' => 'Uploaded resume successfully',
            ]);
            $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
            return $candidate->id;
        }
        else{
            return response()->error("Profile already exists and submitted.");
        }

    } // postResumecandidate

    public function postJd()
    {
        $authuser = Auth::user();
        $jsonResult = null;
        $APIURL="https://jdrest.rchilli.com/JDParser/RChilli/ParseJD";
        // $APIURL="http://hirextra3.rchilli.com/JDParser/RChilli/ParseJD";
        try
        {
            $file = Input::file('file');
            $assetId = null;
            $imagedata = file_get_contents($file);
            $base64 = base64_encode($imagedata);
            $key='Y0CPAOKBPGW';
            $version = "3.1";
            $subUserId = "Kumar Vuppala";
            // $subUserId = "Hirextra";
            $data = array(
                "filedata" => $base64,
                "filename" => $file->getClientOriginalName(),
                "userkey" => $key,
                "version" => $version,
                "subuserid" => $subUserId
            );
            $str_data = json_encode($data);
            $ch = curl_init($APIURL);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
            $err =curl_error($ch);
            curl_close($ch);
            if ($err) {
                echo "cURL Error #:" . $err;
            } 
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch
        $jsonResult = json_decode($jsonResult, true);
        return $jsonResult;
    } // postjd


    public function postJdtext()
    {
        $authuser = Auth::user();
        $jsonResult = null;
        $APIURL="https://jdrest.rchilli.com/JDParser/RChilli/ParseJDText";
        try
        {
            $text = Input::get('text');
            $base64 = base64_encode($text);
            $key='Y0CPAOKBPGW';
            $version = "3.1";
            $subUserId = "hirextrajd";
            $data = array(
                "base64text" => $base64,
                "userkey" => $key,
                "version" => $version,
                "subuserid" => $subUserId
            );
            $str_data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch,CURLOPT_URL,"https://jdrest.rchilli.com/JDParser/RChilli/ParseJDText");
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch
        $jsonResult = json_decode($jsonResult, true);
        return $jsonResult;
    } // postjdtext
    public function postProfilepic()
    {   
       $authuser = Auth::user();

        $files = Input::file('file');
        //print_r($files) ; exit;
        if ( Input::hasFile('file') && count($files) == 1)
        {
            $file_name = $files[0]->getClientOriginalName();
            $file_type = $files[0]->getmimeType();
            $path = base_path()."/public/user_assets/".$authuser->id;
            $destinationPath = 'user_assets/'.$authuser->id;
            $url = "/user_assets/".$authuser->id;
            $files[0]->move($destinationPath, $files[0]->getClientOriginalName());
            $assets_create = UserAsset::create([
                'file_name' => $file_name,
                'file_type' => $file_type,
                'path' => $path,
                'url' => $url,
                'user_id' => $authuser->id,
            ]);
            $assetId = $assets_create->id;
            $userData = ['path' => $path,'file_name'=>$file_name];
            $affectedRows = User::where('id', '=', intval($authuser->id))->update($userData);
            if($affectedRows == 1){
                $assetId = $assets_create->id;
                $candidateResumePostIn = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Saved Uploaded profile pic in private drive.',
                ]);
                $Profileupload =  response()->success('Image submitted successfully');
                return $Profileupload;
            }
            else{
                $Profileupload =  response()->success('Profile Not submitted please try again');
                return $Profileupload;
            }

        }
        else
        {
            return response()->error("Image Not Found Please Try Again.");
        }
    }

    public function postProfileuploaddetails()
    {   
        $authuser = Auth::user();
        $userData = ['email'=>Input::get('email'),
                     'first_name'=>Input::get('first_name'),
                     'last_name'=>Input::get('last_name')
                 ];
        $affectedRows = User::where('id', '=', intval($authuser->id))->update($userData);
        $Profileupload =  response()->success('Details Updated successfully');
        return $Profileupload; 
    }
    public function postProfileupload()
    {
        $authuser = Auth::user();

        $files = Input::file('file');
        if ( Input::hasFile('file') && count($files) == 1)
        {
            $file_name = $files->getClientOriginalName();
            $file_type = $files->getmimeType();
            $path = base_path()."/public/user_assets/".$authuser->id;
            $destinationPath = 'user_assets/'.$authuser->id;
            $url = "/user_assets/".$authuser->id;
            $files->move($destinationPath, $files->getClientOriginalName());
            $assets_create = UserAsset::create([
                'file_name' => $file_name,
                'file_type' => $file_type,
                'path' => $path,
                'url' => $url,
                'user_id' => $authuser->id,
            ]);
            $assetId = $assets_create->id;
            $userData = ['path' => $path,'file_name'=>$file_name];
            $affectedRows = User::where('id', '=', intval($authuser->id))->update($userData);
            if($affectedRows == 1){
                $assetId = $assets_create->id;
                $candidateResumePostIn = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Saved Uploaded profile pic in private drive.',
                ]);
                $Profileupload =  response()->success('Image submitted successfully');
                return $Profileupload;
            }
            else{
                $Profileupload =  response()->success('Profile Not submitted please try again');
                return $Profileupload;
            }

        }
        else
        {
            return response()->error("Image Not Found Please Try Again.");
        }
    }

    public function postResumeskillsengine()
    {
        $authuser = Auth::user();
        $joborderId = Input::get('jobId');
        $candId = Input::get('candidateId');

        $candidate = Candidate::where('id',$candId)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('experiences')->with('educations')->first();
        $text = json_encode($candidate);

        // SkillsEngine CURL
        $jsonResult = null;
        $APIURL="https://api.skillsengine.com/api/token";
        $APIURLTest = "https://api.skillsengine.com/api/test";
        $APIURLResult = "https://api.skillsengine.com/v2/competencies/analyze/flatten";
        $client_id = "7c44822a8438d192dc801d454ee24a5746c9368fc3e6f886dcdc3d6c334ca206";
        $client_secret = "ff4de0db0a7cc4da5b3b70b87b9ba2a8b2a5c3ab05c6275b268ee545940ebb26";
        try
        {
            $data = array(
                "grant_type" => 'client_credentials',
                "client_id" => $client_id,
                "client_secret" => $client_secret
            );

            $str_data = json_encode($data);
            $ch = curl_init($APIURL);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = json_decode(curl_exec($ch)); //Assign rchilli response to a variable
            //echo $jsonResult->access_token;
            if($jsonResult->access_token) {
                $chnew = curl_init($APIURLTest);
                curl_setopt($chnew, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: Bearer '.$jsonResult->access_token
                ));
                curl_setopt($chnew, CURLOPT_RETURNTRANSFER, 1);
                $jsonNewResult = json_decode(curl_exec($chnew));
                if($jsonNewResult->message == "Token is authorized") {
                    $data = array(
                        "text" => $text,
                        "bias" => 0.4
                    );

                    $str_data = json_encode($data);
                    $ch = curl_init($APIURLResult);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                            'Content-Type: application/json',
                            'Authorization: Bearer '.$jsonResult->access_token,
                            'Content-Length: ' . strlen($str_data))
                    );
                    $jsonResult = curl_exec($ch);
                    if($jsonResult) {
                        $comp = new AiCompetencySe;
                        $comp->job_id = $joborderId;
                        $comp->candidate_id = $candId;
                        $comp->vendor_id = $authuser->id;
                        $comp->response = $jsonResult;
                        $comp->save();
                    }

                    $resumeskillsengine = json_decode($jsonResult);
                    return response()->success(compact('resumeskillsengine'));

                }

            }
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch

        return response()->error("Competency AI not available at this moment, please contact support.");
    }

    public function postCandidateskillsengine() {
        $authuser = Auth::user();
        $joborderId = Input::get('jobId');
        $candId = Input::get('candidateId');

        /*$association = Association::where('job_id',$joborderId)->where('candidate_id',$candId)->whereNotNull('vendor_id')->first();
      $vendor_id = $association->vendor_id;*/

        $candidateskills = AiCompetencySe::where('job_id',$joborderId)
            ->where('candidate_id',$candId)
            /*->where('vendor_id',$vendor_id)*/
            ->limit(1)
            ->get();
        if(count($candidateskills) > 0) {
            foreach ($candidateskills as $key => $candidate) {
                $candidateskillsengine = json_decode($candidate->response);
            }
            return response()->success(compact('candidateskillsengine'));
        } else {
            return response()->error("no data available");
        }

    }
    public function postResumepersonalityinsights() {
        $authuser = Auth::user();
        $joborderId = Input::get('jobId');
        $candId = Input::get('candidateId');

        $candidate = Candidate::where('id',$candId)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('experiences')->with('educations')->first();
        // if($candidate->html_code) {
        //     $text = $candidate->html_code;
        // } else {
            $text = $candidate->full_name." ".$candidate->hobbies." ".$candidate->language_known." ".$candidate->job_profile." ".$candidate->executive_summary." ".$candidate->management_summary." ".$candidate->objectives." ".$candidate->preferences." ".$candidate->achievements." ".$candidate->summary." ".$candidate->industry_category." ".$candidate->industry_sub_category;
        // }
        //$text = file_get_contents('http://app.hirextra.com/user_assets/100110/ArvindCQ (1).doc');

        // PI CURL
        $jsonResult = null;
        // $APIURLResult = "https://gateway.watsonplatform.net/personality-insights/api/v3/profile?version=2017-10-13&consumption_preferences=true&raw_scores=true";
        // $APIURLResult = "https://api.us-south.personality-insights.watson.cloud.ibm.com/instances/627acf70-2427-4f93-9f26-4bc92b92dee0/v3/profile?version=2017-10-13&consumption_preferences=true&raw_scores=true";
        // $APIURLResult = "https://api.humantic.ai/v1/user-profile?apikey=chrexec_b45e04b445ee13e9d4dbc29bbb331364&id=". $candId ."&persona=sales";
        try
        {
            // $ch = curl_init($APIURLResult);
            // curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            // curl_setopt($ch, CURLOPT_POSTFIELDS, $text);
            // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            // curl_setopt($ch, CURLOPT_USERPWD, 'apikey:a8vgacke7f5zfXfKhj22yEXE00fv3QKsxDFOIcjASUHi');
            // curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            // curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            //         'Content-Type: text/html'
            //     )
            // );
            // $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
            // $jsonCheck = json_decode($jsonResult);

            // $ch = curl_init($APIURLResult);
            // curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            // curl_setopt($ch, CURLOPT_POSTFIELDS, $text);
            // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            // curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            //         'Content-Type: text/html'
            //     )
            // );
            // $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
            // $jsonCheck = json_decode($jsonResult);

            /*********** WhaiiIBMProxy Start *************/
            
            $curl = curl_init();
            // $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $json['DetailResume']); // Removes special chars.;
            $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $text); // Removes special chars.;
            $post_fields = "{ \n \"contentItems\":[  \n {  \n \"content\":\"$con_j\",  \n \"contenttype\": \"text/plain\"  \n   \n   \n   \n }  \n ]  \n }";
            curl_setopt_array($curl, array(
            //   CURLOPT_URL => 'https://whaiipiapi.azure-api.net/WhaiiIBMProxy/v1/sendPiRequest'; old api not working;
              CURLOPT_URL => 'http://88.202.183.32:1729/hirextra/personality/traits',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>$post_fields,
              CURLOPT_HTTPHEADER => array(
                // 'Authorization: b0a3232d88744b87af4955ab874aab3c',
                'Content-Type: application/json'
              ),
            ));
            
            $jsonResult = curl_exec($curl);
            $jsonCheck = json_decode($jsonResult);
            
            /*********** WhaiiIBMProxy End *************/

            if(isset($jsonCheck->error)) {
                return response()->error("Not able to provide Personality Insights API for this profile.");
            }
            if($jsonResult) {
                $comp = new AiPersonalityInsight;
                $comp->job_id = $joborderId;
                $comp->candidate_id = $candId;
                $comp->vendor_id = $authuser->id;
                $comp->response = $jsonResult;
                $comp->save();
            }

            $resumepersonalityinsights = json_decode($jsonResult);
            return response()->success(compact('resumepersonalityinsights'));
        } //try
        catch (Exception $e)
        { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch

        return response()->error("Personality Insights AI not available at this moment, please contact support.");
    }

    public function postCandidatepersonalityinsights() {
        $authuser = Auth::user();
        $joborderId = Input::get('jobId');
        $candId = Input::get('candidateId');
        $association = Association::where('job_id',$joborderId)->where('candidate_id',$candId)->whereNotNull('vendor_id')->first();
        $vendor_id = $association->vendor_id;
        $candidateskills = AiPersonalityInsight::where('job_id',$joborderId)
            ->where('candidate_id',$candId)
            ->limit(1)
            ->get();
        if(count($candidateskills) > 0) {
            foreach ($candidateskills as $key => $candidate) {$candidatepersonalityinsights = json_decode($candidate->response);}
            return response()->success(compact('candidatepersonalityinsights'));
        } else {
            // return response()->error("no data available");
            $candidate = Candidate::where('id',$candId)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('experiences')->with('educations')->first();

            $text = $candidate->full_name." ".$candidate->hobbies." ".$candidate->language_known." ".$candidate->job_profile." ".$candidate->executive_summary." ".$candidate->management_summary." ".$candidate->objectives." ".$candidate->preferences." ".$candidate->achievements." ".$candidate->summary." ".$candidate->industry_category." ".$candidate->industry_sub_category;
            
            /*********** WhaiiIBMProxy Start *************/
            
            $curl = curl_init();
            // $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $json['DetailResume']); // Removes special chars.;
            $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $text); // Removes special chars.;
            $post_fields = "{ \n \"contentItems\":[  \n {  \n \"content\":\"$con_j\",  \n \"contenttype\": \"text/plain\"  \n   \n   \n   \n }  \n ]  \n }";
            curl_setopt_array($curl, array(
            //   CURLOPT_URL => 'https://whaiipiapi.azure-api.net/WhaiiIBMProxy/v1/sendPiRequest', old api 
            CURLOPT_URL => 'http://88.202.183.32:1729/hirextra/personality/traits',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>$post_fields,
              CURLOPT_HTTPHEADER => array(
                'Authorization: b0a3232d88744b87af4955ab874aab3c',
                'Content-Type: application/json'
              ),
            ));
            
            $jsonResult = curl_exec($curl);
            $candidatepersonalityinsights = json_decode($jsonResult);
            
            /*********** WhaiiIBMProxy End *************/
            
            return response()->success(compact('candidatepersonalityinsights'));
        }
    }
    public function postCandidateemployerspectrum() {
        $authuser = Auth::user();
        $candId = Input::get('candidateId');
        $candidateemployerspectrum = Employeespectrums::where('candidate',$candId)
            ->get();
        if(count($candidateemployerspectrum)>0) {
            return response()->success(compact('candidateemployerspectrum'));
        } else {return response()->error("no data available");}
    }
    public function postTimezone() {
        $authuser = Auth::user();
        $timezone = Input::get('timezone');
        $timezone_name = Input::get('timezone_name');
        date_default_timezone_set('UTC');

        $datetime = new DateTime($timezone);
        //echo $datetime->format('Y-m-d H:i:s') . "\n";
        $la_time = new DateTimeZone($timezone_name);
        $datetime->setTimezone($la_time);
        //echo $datetime->format('Y-m-d H:i:s');
        return response()->success(compact('datetime'));
    }
    public function postSoftskillsget(){
        $reqtags = Input::get('requiredTags');
        $check = Input::get('check');

        foreach($reqtags as $reqtag) {
            $rtags[] = $reqtag['text'];
        }
        //echo "<pre>"; print_r($rtags); echo "</pre>";

        $softskills = DB::table('soft_skills')
            ->select('able_to_listen')
            ->orderBy('able_to_listen','DESC')
            ->get();
        $softskills = (array) $softskills;

        //echo "<hr><pre>"; print_r($softskills); echo "</pre>";

        foreach($softskills as $k => $softskill) {
            if (!in_array($softskill->able_to_listen, $reqtags)) {
                $res[] = $softskill->able_to_listen;
            }
            //echo "<hr><pre>"; print_r($softskill->able_to_listen); echo "</pre>";
        }

        // echo "<hr><pre>"; print_r($res); echo "</pre>";
        $result=array_udiff($rtags, $res, 'strcasecmp');
        //$result=array_diff($rtags, $res);
        // print_r($result);
        // print_r("--------");

        foreach($result as $k => $res1) {
            $res2[] = array('text' => $res1);
        }
        // print_r($res2);
        // echo "<hr><pre>"; print_r($res2); echo "</pre>";
        //echo "<hr><hr><hr><pre>"; print_r($res2); echo "</pre>";

        return response()->success(compact('res2'));
        // return response()->success($res2);
    }

    ///paste it 
    public function getCandidatetalentminees($id)
    {
        static $responce = array();
        $decryption_canid = base64_decode($id);
        $id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);
        $returnData = self::getCandidateTalentMine($id);
        return $returnData;
        //        dd($candidate_exp);
    } 
    
public function getCandidateTalentMine($id)
    {
      
      static $responce = array();

        $candidateDetails = Candidate::with(['getExperience', 'getCandidateDetails', 'getSpectrums', 'getTalentMine'])
            ->where('id', $id)
            ->first();
        if (!empty($candidateDetails->getTalentMine) && count($candidateDetails->getTalentMine) == 0)
         {
            $candidate_exp = $candidateDetails->getExperience;
        
            $candidateEducationArray = $candidateDetails->educations->pluck('institution_name')->toArray();

            try {
                $worldUniversity = WorldUniversity::whereIn('university', $candidateEducationArray)->get();              
               } catch (\Exception $e) {
               
                   $worldUniversity=[];
               }
                     
                $candidateUnivercityCodes = [];
              $currentCompany = '';

            if (count($candidate_exp) > 0) {
                $currentCompany = $candidate_exp->first();
            }

            if (isset($candidateDetails->getCandidateDetails) && $candidateDetails->getCandidateDetails->current_working_email != '') {
                $checkemail=$candidateDetails->getCandidateDetails->current_working_email;
                if(strpos($checkemail, '@') !== false){
                   $checkemailval=1;
                } else{
                    $checkemailval=2;
                }
            if($checkemailval ==1){
               $getinfo = getClearbitApi($candidateDetails->getCandidateDetails->current_working_email, 'email');
            }else{
                $getinfo = getClearbitApi($candidateDetails->getCandidateDetails->current_working_email, 'domain');
            }

            } 
            else {
                 $getinfo = false;
            }
            

            $balance_well_being_compType = 0;
            $balance_well_being_EmpHeadCount = 0;
            $balance_well_being_Revenue = 0;
            $balance_well_being_UserExp = 0;
            $balance_well_being_FoundedYear = 0;
            $balance_well_being_LocationofHQ = 0;

            $benefits_perks_compType = 0;
            $benefits_perks_Revenue = 0;
            $benefits_perks_UserExp = 0;
            $benefits_perks_AvgStay = 0;

            $business_reputation_compType = 0;
            $business_reputation_EmpHeadCount = 0;
            $business_reputation_FoundedYear = 0;
            $business_reputation_Revenue = 0;
            $business_reputation_JobCountryCheck = 0;


            $career_progression_compType =  0;
            $career_progression_EmpHeadCount =  0;
            $career_progression_FoundedYear =  0;
            $career_progression_UserExpGap =  0;
            $career_progression_AvgStay =  0;


            $company_culture_compType = 0;
            $company_culture_EmpHeadCount = 0;
            $company_culture_FoundedYear = 0;
            $company_culture_Revenue = 0;
            $company_culture_EduCountryCheck = 0;
             $company_culture_JobCountryCheck = 0;


            $change_stability_compType = 0;
            $change_stability_EmpHeadCount = 0;
            $change_stability_Revenue = 0;
            $change_stability_EduCountryCheck = 0;
            $change_stability_AvgStay = 0;


            $innovation_technology_compType = 0;
            $innovation_technology_EmpHeadCount = 0;
            $innovation_technology_FoundedYear = 0;
            $innovation_technology_Revenue = 0;
            $innovation_technology_EduCountryCheck = 0;


            $job_satisfaction_compType = 0;
            $job_satisfaction_EmpHeadCount = 0;
            $job_satisfaction_Revenue = 0;
            $job_satisfaction_FoundedYear = 0;
            $job_satisfaction_UserExp = 0;
            $job_satisfaction_AvgStay = 0;

            $remuneration_compType = 0;
            $remuneration_EmpHeadCount = 0;
            $remuneration_Revenue = 0;
            $remuneration_UserExp = 0;
            $remuneration_AvgStay = 0;

            $team_people_compType = 0;
            $team_people_EmpHeadCount = 0;
            $team_people_Revenue = 0;
            $team_people_UserExp = 0;
            $team_people_AvgStay = 0;


            $globalization_compType = 0;
            $globalization_EmpHeadCount = 0;
            $globalization_Revenue = 0;
            $globalization_FoundedYear = 0;
            $globalization_JobCountryCheck = 0;


            if (count($candidateUnivercityCodes) > 0) {
                $validareEduCodesArray = ['UK', 'US', 'EU'];
                $overlap = array_intersect($validareEduCodesArray, $candidateUnivercityCodes);
                $counts = array_count_values($overlap);

                if (count($counts) > 0) {
                    $company_culture_JobCountryCheck = -7;
                    $change_stability_EduCountryCheck = -8;
                    $innovation_technology_EduCountryCheck = -8;

                }

            }
            




            if (!empty($getinfo)) {


                if ($getinfo->type == 'public') {
                    $balance_well_being_compType = 20;
                    $benefits_perks_compType = 40;
                    $business_reputation_compType = 20;
                    $career_progression_compType = 20;
                    $change_stability_compType = 20;
                    $innovation_technology_compType = 20;
                    $job_satisfaction_compType = 20;
                    $remuneration_compType = 20;
                    $team_people_compType = 20;
                    $globalization_compType = 20;
                } else {
                    $balance_well_being_compType = 10;
                    $benefits_perks_compType = 20;
                    $business_reputation_compType = 5;
                    $career_progression_compType = 10;
                    $change_stability_compType = 10;
                    $innovation_technology_compType = 10;
                    $job_satisfaction_compType = 10;
                    $remuneration_compType = 10;
                    $team_people_compType = 10;
                    $globalization_compType = 10;
                }


                $metrics = json_decode($getinfo->metrics, true);
                $geo = json_decode($getinfo->geo, true);

                if (!empty($metrics)) {

                    if ($metrics['employees'] != '') {
                        $empcount = $metrics['employees'];
                        switch (true) {
                            case $empcount <= 100:
                                $balance_well_being_EmpHeadCount = 10;
                                $business_reputation_EmpHeadCount = 10;
                                $career_progression_EmpHeadCount = 10;
                                $change_stability_EmpHeadCount = 10;
                                $innovation_technology_EmpHeadCount = 10;
                                $job_satisfaction_EmpHeadCount = 10;
                                $remuneration_EmpHeadCount = 10;
                                $team_people_EmpHeadCount = 10;
                                $globalization_EmpHeadCount = 10;
                                break;
                            case $empcount <= 500:
                                $balance_well_being_EmpHeadCount = 15;
                                $business_reputation_EmpHeadCount = 15;
                                $career_progression_EmpHeadCount = 15;
                                $change_stability_EmpHeadCount = 15;
                                $innovation_technology_EmpHeadCount = 15;
                                $job_satisfaction_EmpHeadCount = 15;
                                $remuneration_EmpHeadCount = 15;
                                $team_people_EmpHeadCount = 15;
                                $globalization_EmpHeadCount = 15;
                                break;
                            case $empcount > 500:
                                $balance_well_being_EmpHeadCount = 20;
                                $business_reputation_EmpHeadCount = 20;
                                $career_progression_EmpHeadCount = 20;
                                $change_stability_EmpHeadCount = 20;
                                $innovation_technology_EmpHeadCount = 20;
                                $job_satisfaction_EmpHeadCount = 20;
                                $remuneration_EmpHeadCount = 20;
                                $team_people_EmpHeadCount = 20;
                                $globalization_EmpHeadCount = 20;
                                break;
                        }
                    }

                    if ($metrics['annualRevenue'] != '') {
                        $annualRevenue = $metrics['annualRevenue'];
                        switch (true) {
                            case $annualRevenue <= 5000000:
                                $balance_well_being_Revenue = 10;
                                $benefits_perks_Revenue = 10;
                                $business_reputation_Revenue = 10;
                                $change_stability_Revenue = 10;
                                $innovation_technology_Revenue = 10;
                                $job_satisfaction_Revenue = 10;
                                $remuneration_Revenue = 10;
                                $team_people_Revenue = 10;
                                $globalization_Revenue = 10;
                                break;
                            case $annualRevenue <= 1000000:
                                $balance_well_being_Revenue = 12.5;
                                $benefits_perks_Revenue = 12.5;
                                $business_reputation_Revenue = 12.5;
                                $change_stability_Revenue = 12.5;
                                $innovation_technology_Revenue = 12.5;
                                $job_satisfaction_Revenue = 12.5;
                                $remuneration_Revenue = 12.5;
                                $team_people_Revenue = 12.5;
                                $globalization_Revenue = 12.5;

                                break;
                            case $annualRevenue <= 5000000:
                                $balance_well_being_Revenue = 15;
                                $benefits_perks_Revenue = 15;
                                $business_reputation_Revenue = 15;
                                $change_stability_Revenue = 15;
                                $innovation_technology_Revenue = 15;
                                $job_satisfaction_Revenue = 15;
                                $remuneration_Revenue = 15;
                                $team_people_Revenue = 15;
                                $globalization_Revenue = 15;
                                break;
                            case $annualRevenue > 5000000:
                                $balance_well_being_Revenue = 20;
                                $benefits_perks_Revenue = 20;
                                $business_reputation_Revenue = 20;
                                $change_stability_Revenue = 20;
                                $innovation_technology_Revenue = 20;
                                $job_satisfaction_Revenue = 20;
                                $remuneration_Revenue = 20;
                                $team_people_Revenue = 20;
                                $globalization_Revenue = 20;
                                break;
                        }
                    }

                    $foundedYearData = $getinfo->foundedYear;
                    $business_reputation_FoundedYear = 0;
                    $career_progression_FoundedYear = 0;


                    $foundedYearDatadbDate = \Carbon\Carbon::parse($foundedYearData . '-01-01');
                    $foundedYearsCalc = \Carbon\Carbon::now()->diffInYears($foundedYearDatadbDate);

                    switch (true) {
                        case in_array($foundedYearsCalc, range(0, 3)) :
                            $business_reputation_FoundedYear = 5;
                            $career_progression_FoundedYear = 5;
                            $innovation_technology_FoundedYear = 5;
                            $job_satisfaction_FoundedYear = 5;
                            $globalization_FoundedYear = 5;
                            break;
                        case in_array($foundedYearsCalc, range(3, 7)):
                            $business_reputation_FoundedYear = 10;
                            $career_progression_FoundedYear = 10;
                            $innovation_technology_FoundedYear = 10;
                            $job_satisfaction_FoundedYear = 10;
                            $globalization_FoundedYear = 10;
                            break;
                        case in_array($foundedYearsCalc, range(7, 12)):
                            $business_reputation_FoundedYear = 15;
                            $career_progression_FoundedYear = 15;
                            $innovation_technology_FoundedYear = 15;
                            $job_satisfaction_FoundedYear = 15;
                            $globalization_FoundedYear = 15;
                            break;
                        case in_array($foundedYearsCalc, range(12, 50000)):
                            $business_reputation_FoundedYear = 20;
                            $career_progression_FoundedYear = 20;
                            $innovation_technology_FoundedYear = 20;
                            $job_satisfaction_FoundedYear = 20;
                            $globalization_FoundedYear = 20;
                            break;
                    }
                }

                if (!empty($geo)) {
                    if ($geo['countryCode'] != '') {
                        $validareCountryCodesArray = ['UK', 'US', 'EU'];
                        $countryCode = $geo['countryCode'];
                        if (!in_array($countryCode, $validareCountryCodesArray)) {
                            $business_reputation_JobCountryCheck = -10;
                            $globalization_JobCountryCheck = -10;
                        }
                    }
                }


                switch (true) {
                    case in_array($candidateDetails->total_experience_in_year, range(15, 20)):
                        $balance_well_being_UserExp = -5;
                        $benefits_perks_UserExp = -5;
                        break;
                        //break;
                    case in_array($candidateDetails->total_experience_in_year, range(20, 300)):
                        $balance_well_being_UserExp = 8;
                        $benefits_perks_UserExp = -9;
                        break;
                }

                switch (true) {
                    case in_array($candidateDetails->total_experience_in_year, range(10, 15)):
                        $job_satisfaction_UserExp = -5;
                        $remuneration_UserExp = -5;
                        $team_people_UserExp = -5;
                        break;
                    case in_array($candidateDetails->total_experience_in_year, range(15, 300)):
                        $job_satisfaction_UserExp = -10;
                        $remuneration_UserExp = -11;
                        $team_people_UserExp = -12;
                        break;
                }

                switch (true) {
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(12, 24)):
                        $benefits_perks_AvgStay = 5;
                        $career_progression_AvgStay = 5;
                        $change_stability_AvgStay = 5;
                        $job_satisfaction_AvgStay = 5;
                        $remuneration_AvgStay = 5;
                        $team_people_AvgStay = 5;
                        break;
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(24, 48)):
                        $benefits_perks_AvgStay = 10;
                        $career_progression_AvgStay = 10;
                        $change_stability_AvgStay = 10;
                        $job_satisfaction_AvgStay = 10;
                        $remuneration_AvgStay = 10;
                        $team_people_AvgStay = 10;
                        break;
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(48, 100000)):
                        $benefits_perks_AvgStay = 20;
                        $career_progression_AvgStay = 20;
                        $change_stability_AvgStay = 20;
                        $job_satisfaction_AvgStay = 20;
                        $remuneration_AvgStay = 20;
                        $team_people_AvgStay = 20;
                        break;
                }


                $jobGaps = array();

                if ($candidateDetails->total_experience_in_year > 0) {
                    $candidateExperiencesData = isset($candidateDetails->getExperience) ? $candidateDetails->getExperience->sortBy(function ($col) {
                        return $col->start_date;
                    })->values()->all() : [];
                    if (count($candidateExperiencesData) > 0) {
                        foreach ($candidateExperiencesData as $key => $candidateExperiencesDat) {
                            if (isset($candidateExperiencesData[$key + 1]->start_date)) {
                                $endthisJobDate = $candidateExperiencesDat->end_date;
                                $nextJobStartDate = $candidateExperiencesData[$key + 1]->start_date;
                            } else {
                                if ($candidateExperiencesDat->is_current_employer == 1) {
                                    $endthisJobDate = date('Y-m-d');
                                    $nextJobStartDate = date('Y-m-d');
                                } else {
                                    $endthisJobDate = $candidateExperiencesDat->end_date;
                                    $nextJobStartDate = date('Y-m-d');
                                }
                            }
                            $to = new Carbon($endthisJobDate);
                            $from = new Carbon($nextJobStartDate);
                            $diff_in_months = $to->diffInMonths($from);
                            if ($diff_in_months > 0) {
                                $jobGaps[] = $diff_in_months;
                            }
                        }
                    }
                }


                if (count($jobGaps) > 0) {
                    $career_progression_UserExpGap = -10;
                } else {
                    $career_progression_UserExpGap = 10;
                }

                $balance_well_being_Data = (
                    $balance_well_being_compType +
                    $balance_well_being_EmpHeadCount +
                    $balance_well_being_Revenue +
                    $balance_well_being_UserExp
                );


                if ($balance_well_being_Data > 0) {
                    if ($balance_well_being_Data > 60) {
                        $balance_well_being_Data = 60;
                    }
                    $responce['balance_well_being'] = $balance_well_being_Data;
                }



                $benefits_perks_data = (
                    $benefits_perks_compType +
                    $benefits_perks_Revenue +
                    $benefits_perks_AvgStay +
                    $benefits_perks_UserExp
                );

                if ($benefits_perks_data > 0) {
                    if ($benefits_perks_data > 60) {
                        $benefits_perks_data = 60;
                    }
                    $responce['benefits_perks'] = $benefits_perks_data;
                }



                $business_reputation_data = (
                    $business_reputation_compType +
                    $business_reputation_EmpHeadCount +
                    $business_reputation_FoundedYear +
                    $business_reputation_Revenue +
                    $business_reputation_JobCountryCheck
                );

                if ($business_reputation_data > 0) {
                    if ($business_reputation_data > 60) {
                        $business_reputation_data = 60;
                    }
                    $responce['business_reputation'] = $business_reputation_data;
                }


                $career_progression_data = (
                    $career_progression_compType +
                    $career_progression_EmpHeadCount +
                    $career_progression_FoundedYear +
                    $career_progression_AvgStay +
                    $career_progression_UserExpGap
                );
                if ($career_progression_data > 0) {
                    if ($career_progression_data > 60) {
                        $career_progression_data = 60;
                    }
                    $responce['career_progression'] = $career_progression_data;
                }


                $company_culture_data = (
                    $company_culture_compType +
                    $company_culture_EmpHeadCount +
                    $company_culture_FoundedYear +
                    $company_culture_Revenue +
                    $company_culture_JobCountryCheck
                );
                if ($company_culture_data > 0) {
                    if ($company_culture_data > 60) {
                        $company_culture_data = 60;
                    }
                    $responce['company_culture'] = $company_culture_data;
                }

                $change_stability_data = (
                    $change_stability_compType +
                    $change_stability_EmpHeadCount +
                    $change_stability_AvgStay +
                    $change_stability_Revenue +
                    $change_stability_EduCountryCheck
                );
                if ($change_stability_data > 0) {
                    if ($change_stability_data > 60) {
                        $change_stability_data = 60;
                    }
                    $responce['change_stability'] = $change_stability_data;
                }


                $innovation_technology_data = (
                    $innovation_technology_compType +
                    $innovation_technology_EmpHeadCount +
                    $innovation_technology_FoundedYear +
                    $innovation_technology_Revenue +
                    $innovation_technology_EduCountryCheck
                );
                if ($innovation_technology_data > 0) {
                    if ($innovation_technology_data > 60) {
                        $innovation_technology_data = 60;
                    }
                    $responce['innovation_technology'] = $innovation_technology_data;
                }


                $job_satisfaction_data = (
                    $job_satisfaction_compType +
                    $job_satisfaction_EmpHeadCount +
                    $job_satisfaction_Revenue +
                    $job_satisfaction_FoundedYear +
                    $job_satisfaction_AvgStay +
                    $job_satisfaction_UserExp
                );

                if ($job_satisfaction_data > 0) {
                    if ($job_satisfaction_data > 60) {
                        $job_satisfaction_data = 60;
                    }
                    $responce['job_satisfaction'] = $job_satisfaction_data;
                }


                $remuneration_data = (
                    $remuneration_compType +
                    $remuneration_EmpHeadCount +
                    $remuneration_Revenue +
                    $remuneration_AvgStay +
                    $remuneration_UserExp
                );
                if ($remuneration_data > 0) {
                    if ($remuneration_data > 60) {
                        $remuneration_data = 60;
                    }
                    $responce['remuneration'] = $remuneration_data;
                }

                $team_people_data = (
                    $team_people_compType +
                    $team_people_EmpHeadCount +
                    $team_people_Revenue +
                    $team_people_AvgStay +
                    $team_people_UserExp
                );
                if ($team_people_data > 0) {
                    if ($team_people_data > 60) {
                        $team_people_data = 60;
                    }
                    $responce['team_people'] = $team_people_data;
                }


                $globalization_data = (
                    $globalization_compType +
                    $globalization_EmpHeadCount +
                    $globalization_Revenue +
                    $globalization_FoundedYear +
                    $globalization_JobCountryCheck
                );
                if ($globalization_data > 0) {
                    if ($globalization_data > 60) {
                        $globalization_data = 60;
                    }
                    $responce['globalization'] = $globalization_data;
                }


            } else {
                $responce = [];
            }




            if (count($responce) > 0) {
                $responce['candidate_id'] = $id;
                $responce['ip'] = $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);
                $employee_spectrum = TalentMine::create($responce);

                unset($responce['candidate_id']);
                unset($responce['ip']);
            }
         }
          else {
            if(!empty($candidateDetails->getTalentMine)){
            $oldTalemtMone = $candidateDetails->getTalentMine->first();

            $responce = array(
                'balance_well_being' => $oldTalemtMone->balance_well_being,
                'benefits_perks' => $oldTalemtMone->benefits_perks,
                'business_reputation' => $oldTalemtMone->business_reputation,
                'career_progression' => $oldTalemtMone->career_progression,
                'company_culture' => $oldTalemtMone->company_culture,
                'change_stability' => $oldTalemtMone->change_stability,

                'innovation_technology' => $oldTalemtMone->innovation_technology,
                'job_satisfaction' => $oldTalemtMone->job_satisfaction,
                'remuneration' => $oldTalemtMone->remuneration,
                'team_people' => $oldTalemtMone->team_people,
                'globalization' => $oldTalemtMone->globalization,
            );
        }
        }

        $returnData = array();
        if (count($responce) > 0) {
            foreach ($responce as $list => $value) {
                $localItem = array();
                $localItem['color'] = '';
                $localItem['img'] = '';
                $localItem['img_path'] = '';
                $localItem['name'] = $list;
                $localItem['alias'] = $list;
                $localItem['value'] = $value;
                if (isset($value) && $value != '') {
                    switch (true) {
                        case in_array($value, range(0, 48)):
                            $localItem['color'] = '#FFF';
                            break;
                        case in_array($value, range(48, 59)):
                            $localItem['color'] = '#f1c232';
                            break;
                        case in_array($value, range(60, 100)):
                            $localItem['color'] = '#38761d';
                            break;
                    }
                }


                $imageColor = $localItem['color'];

                $localItem['name'] = ucwords(str_replace('_', ' ', $list));




                $descriptionValue = ($value > 70) ? 'Excellent' : 'Satisfactory  ';


                switch ($list) {
                    case 'balance_well_being':

                        $localItem['img_path'] = 'hx_tm_balance_well_being.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;
                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . ' can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. With this the resource is inclined towards the health of both physical and psychological health and works out to keep it vibrant within the team. ';
                                break;
                            case in_array($value, range(60, 100)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . '  can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This shows that the resource can understand the importance of both physical and psychological health in the workplace which will be supporting to elevate the well-being within the team.
';
                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M580.449,1240.766c-3.711-3.716-6.377-14.331-6.377-23.892c0-13.809-3.184-19.116-15.928-25.493
        c-21.23-10.62-37.168-37.7-37.168-61.064c0-29.741,15.4-48.33,56.289-69.033c39.834-20.713,48.32-33.989,26.025-42.49
        c-9.561-3.716-19.658-3.184-36.113,2.656c-30.801,10.625-33.447,10.093-40.889-7.427c-10.615-25.498-5.313-38.77,18.584-47.793
        c11.68-4.258,23.896-11.685,27.617-16.47c7.959-10.62,18.047-1.06,14.336,13.813c-2.129,7.427-10.088,12.739-26.553,16.987
        c-23.896,6.372-26.543,9.028-18.594,21.772c3.711,5.85,7.988,5.85,22.842,0.527c25.488-9.556,56.289-3.179,63.73,13.281
        c10.625,23.901,1.582,38.237-37.178,57.886c-44.072,22.3-49.922,29.204-50.986,56.821c-0.518,18.052,2.656,24.424,16.992,37.168
        c9.561,8.496,20.723,15.4,24.971,15.4c5.84,0,7.959,5.84,7.959,21.24c0,17.524,1.592,21.245,10.098,21.245
        c8.486,0,10.615-4.253,12.207-19.648c1.592-17.524,3.721-20.186,20.186-24.429c22.822-5.845,22.295-5.313,18.057-16.465
        c-2.666-6.899-6.914-8.491-20.195-5.303c-40.352,9.023-61.592,0.522-61.592-24.434c0-16.992,10.098-27.085,43.545-41.948
        c30.801-13.809,46.719-33.462,46.719-57.358c0-24.951-7.422-36.636-32.91-52.568c-15.928-10.088-19.658-15.4-15.4-19.648
        c4.775-4.78,11.152-3.716,25.488,4.248c28.672,15.933,41.426,36.108,41.426,66.377c0,34.517-12.754,50.981-57.363,74.351
        c-19.639,10.083-35.576,21.772-35.576,25.488c0,11.147,15.938,13.804,41.426,6.899c27.607-7.432,35.576-3.188,41.416,22.305
        c2.646,13.271,1.064,18.057-8.506,26.021c-6.377,5.308-16.445,9.561-21.768,9.561c-7.949,0-10.088,3.716-10.088,17.524
        c0,9.561-2.656,20.176-6.367,23.892C612.842,1248.735,588.418,1248.735,580.449,1240.766z"/>
    <path fill="#2c303b" d="M54.731,1138.808c-27.612-14.868-40.352-53.101-27.085-79.121c9.556-18.057,91.343-99.302,100.371-99.302
        s90.801,81.245,100.361,99.302c26.025,50.977-32.397,105.674-84.434,78.589c-13.271-6.899-16.997-6.899-30.269,0
        C95.625,1147.842,71.196,1148.369,54.731,1138.808z M116.328,1113.32l11.689-11.147l12.212,11.147
        c6.904,6.372,19.648,13.271,29.204,14.868c13.804,2.661,19.116,0.532,33.457-13.271c24.951-25.493,19.644-41.426-32.393-93.467
        l-42.48-42.48l-41.953,41.958c-23.369,22.832-43.013,47.256-44.604,54.155c-3.188,16.997,9.556,44.077,23.892,49.927
        C81.279,1131.377,101.465,1126.592,116.328,1113.32z"/>
    <path fill="#2c303b" d="M343.086,1025.698c-40.889-10.62-62.134-56.289-43.022-92.925c7.441-14.346,7.441-14.863-5.308-18.057
        c-6.904-1.602-38.228-2.129-70.093-1.074c-41.953,1.602-65.317,5.313-88.687,14.351c-49.38,18.589-54.697,19.116-69.565,5.84
        c-26.021-24.956-11.68-46.733,45.674-69.565c52.573-21.24,101.958-32.393,134.878-30.801l27.085,1.592l1.592-54.687
        c1.064-39.834,3.184-53.633,7.964-52.051c4.248,1.064,6.904,21.25,7.969,63.73l1.587,62.139h-46.729
        c-50.977,0-68.501,3.711-130.103,27.07c-41.943,16.465-50.444,24.434-39.824,38.77c5.84,7.432,11.147,6.367,53.633-7.959
        c50.981-18.057,39.297-17.002,228.877-17.002c182.139,0,176.826-0.537,225.684,17.002c39.824,13.799,46.191,14.858,53.105,7.959
        c12.754-12.754,0.537-23.369-50.977-43.545c-40.371-15.918-55.762-19.131-105.674-21.777l-58.428-3.184l0.547-59.473
        c0-32.93,1.592-61.074,3.193-63.203c10.078-9.561,14.863,7.979,14.863,53.115v49.385l44.062,3.174
        c23.906,2.139,54.18,6.914,67.441,11.162c41.963,12.744,92.939,35.576,99.307,44.6c11.689,14.883,8.506,37.178-6.904,47.266
        c-13.271,8.496-15.4,8.496-57.344-6.899c-38.77-13.813-49.395-15.405-106.738-15.405c-60.537,0-63.73,0.537-62.139,10.625
        c10.088,57.349,2.656,76.992-32.383,93.462C363.799,1029.424,360.596,1029.951,343.086,1025.698z M383.437,1002.861
        c15.41-8.491,27.09-35.571,23.369-53.628c-6.377-29.204-44.609-45.669-72.222-31.323c-15.4,8.486-27.08,35.571-23.364,53.628
        C317.593,1000.742,355.83,1017.207,383.437,1002.861z"/>
    <path fill="#2c303b" d="M160.405,723.545c-19.121-7.969-29.199-29.209-24.429-50.449c5.308-24.424,20.186-32.402,73.286-39.824
        c65.317-9.57,78.057-9.033,78.057,0.527c0,4.238-3.184,7.959-6.367,7.959c-3.721,0-30.801,3.721-60.005,7.979
        c-56.289,7.969-73.813,18.057-67.974,39.824c5.84,22.295,14.863,23.896,72.217,13.809c66.382-12.217,79.131-12.754,81.782-4.775
        c2.656,7.432-2.124,8.486-76.47,22.295C184.839,728.848,174.214,729.385,160.405,723.545z"/>
    <path fill="#2c303b" d="M429.639,710.273c-56.826-10.615-108.862-22.305-114.697-25.488c-23.901-12.744-21.245-53.643,3.711-66.914
        c14.341-7.432,25.488-6.367,124.795,6.904c96.123,13.262,110.986,16.465,122.666,27.607c23.896,22.314,11.689,69.561-20.176,75.42
        C539.033,729.385,487.002,721.426,429.639,710.273z M554.971,702.314c10.088-10.098,10.615-23.379,1.582-36.133
        c-5.303-6.895-27.607-11.67-101.963-21.768c-117.881-16.465-127.974-16.465-135.405-2.656c-12.212,22.842-1.06,28.145,99.302,48.33
        C526.826,712.393,543.818,713.984,554.971,702.314z"/>
</g>
</svg>';
                        break;

                    case 'benefits_perks':
                        $localItem['img_path'] = 'hx_tm_benefits_perks.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . 'as per the inputs given in the resume. This result plays an important role for this resource to opt any role in the company and seems to be inclined for any discussions.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . ' as per the inputs. Whereas this result denotes that this factor shows predominant effect besides other factors, while being negotiable and flexible.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M120.85,5043.911c-3.887-4.897-3.638-14.683,0.503-18.687c1.631-1.768,4.268-3.145,5.645-3.145
        s4.014,1.377,5.645,3.145c6.65,6.514,2.764,21.948-5.645,21.948C124.614,5047.172,122.48,5046.044,120.85,5043.911z"/>
    <path fill="#2c303b" d="M518.037,5044.541c-3.887-2.261-6.025-9.033-4.512-13.555c1.494-4.141,6.641-7.651,11.152-7.651
        c4.395,0,10.039,6.65,10.039,11.67C534.717,5042.778,524.805,5048.427,518.037,5044.541z"/>
    <path fill="#2c303b" d="M291.216,5032.114c-25.469-4.014-45.288-22.075-51.812-47.295c-4.893-18.691,0.122-40.898,12.422-55.195
        c2.378-2.891,4.385-5.518,4.385-5.898c0-0.376-27.349-0.757-60.845-0.757c-59.214,0-60.967-0.117-63.35-2.505
        c-2.388-2.378-2.505-4.141-2.505-44.536s0.117-42.153,2.505-44.531c2.383-2.388,4.136-2.51,26.343-2.51h23.833v-80.166
        c0-79.16,0-80.166,2.637-83.428c3.516-4.512,10.039-4.512,13.55,0c2.637,3.262,2.637,4.268,2.637,83.555v80.039h56.45l56.455-0.127
        v-55.078c0-38.262,0.376-56.074,1.382-58.203c2.886-6.406,12.92-6.904,16.06-0.879c0.874,1.621,1.377,21.328,1.377,58.33v55.957
        h28.228h28.232v-60.84c0-59.219,0.127-60.977,2.5-63.359c3.135-3.145,10.156-3.262,12.93-0.254
        c1.875,2.012,2.129,8.779,2.373,63.105l0.381,60.718l56.826,0.376l56.709,0.376v-92.085v-92.08l2.891-2.627
        c3.633-3.389,8.398-3.516,12.295-0.381l2.998,2.373l0.381,92.344l0.244,92.334h23.594c23.076,0,23.711,0.122,26.348,2.881
        c2.754,2.886,2.754,3.516,2.754,44.287c0,40.02-0.117,41.523-2.51,44.165l-2.627,2.749H525.81h-61.475l4.893,6.03
        c21.709,25.972,19.443,63.096-5.02,86.812c-3.008,2.886-9.902,7.402-15.43,10.156c-29.355,14.434-66.484,6.03-84.805-19.189
        l-3.379-4.766l-2.51,4.014c-6.025,9.785-19.702,19.565-32.373,23.584C316.426,5032.373,300.752,5033.627,291.216,5032.114z
         M325.591,5010.288c9.282-4.517,19.946-16.06,23.081-24.844c1.885-5.64,2.256-10.659,2.256-33.618v-26.968l-22.583-0.254
        c-37.759-0.498-47.793,1.885-59.839,14.302c-8.652,8.906-12.544,18.071-12.544,30.239c0,20.952,11.919,37.129,31.992,43.652
        c3.511,1.133,9.531,1.631,17.939,1.382C316.685,5013.798,319.692,5013.173,325.591,5010.288z M439.375,5010.537
        c9.785-4.512,16.436-10.781,21.328-20.073c3.633-6.772,4.385-9.404,4.766-18.564c0.625-13.667-2.393-22.207-11.035-31.738
        c-8.789-9.531-16.309-13.296-29.727-14.683c-12.559-1.255-45.674-1.499-50.938-0.498l-3.516,0.757l0.371,27.72
        c0.371,26.973,0.508,28.101,3.633,34.751c5.4,11.416,16.943,21.455,28.486,24.717c3.506,0.874,10.654,1.504,17.803,1.255
        C430.205,5013.93,433.73,5013.173,439.375,5010.537z M288.203,4875.927v-28.853h-70.254h-70.254l-0.371,27.598
        c-0.127,15.181,0,28.228,0.371,29.106c0.376,1.382,14.551,1.631,70.503,1.382l70.005-0.376V4875.927z M414.912,4875.927v-28.853
        l-54.199-0.376l-54.316-0.249v29.478v29.482l54.316-0.249l54.199-0.376V4875.927z M573.603,4875.927v-29.351l-69.873,0.244
        l-70,0.254l-0.381,27.598c-0.117,15.181,0,28.228,0.254,29.106c0.498,1.255,15.059,1.631,70.371,1.631h69.629V4875.927z"/>
    <path fill="#2c303b" d="M599.951,5029.609c-1.875-1.885-2.51-4.141-2.51-8.906c0-7.026,1.377-10.415,5.02-12.422
        c6.279-3.384,12.549,2.764,12.549,12.295C615.01,5030.366,605.977,5035.625,599.951,5029.609z"/>
    <path fill="#2c303b" d="M89.487,5012.548c-3.262-4.141-3.389-7.275-0.127-10.537c2.007-2.012,4.141-2.51,10.41-2.51
        c9.033,0,12.173,2.134,12.173,7.9c0,5.771-4.014,8.408-12.422,8.408C92.998,5015.81,91.743,5015.429,89.487,5012.548z"/>
    <path fill="#2c303b" d="M144.561,5013.3c-3.135-3.135-3.262-8.906-0.249-11.665c3.135-2.891,16.812-3.013,19.565-0.249
        c3.267,3.384,3.643,7.021,1.133,10.532c-2.134,2.759-3.638,3.267-10.161,3.638C148.452,5015.81,146.694,5015.429,144.561,5013.3z"
        />
    <path fill="' . $imageColor . '" d="M568.584,4998.247c-1.377-1.377-2.51-3.887-2.51-5.645c0-5.522,4.023-8.159,12.559-8.159
        c8.525,0,12.539,2.637,12.539,8.159s-4.014,8.154-12.539,8.154C572.734,5000.756,570.596,5000.253,568.584,4998.247z"/>
    <path fill="#2c303b" d="M623.408,4998.5c-2.754-3.145-2.637-9.414,0.127-11.924c1.631-1.504,4.648-2.134,9.912-2.134
        c8.408,0,12.041,2.388,12.041,8.159c0,5.767-3.633,8.154-12.285,8.154C627.295,5000.756,624.922,5000.253,623.408,4998.5z"/>
    <path fill="#2c303b" d="M123.735,4991.718c-4.263-2.256-5.518-5.02-5.518-11.914c0-7.778,2.886-11.665,8.779-11.665
        c5.522,0,8.784,4.263,8.784,11.665c0,3.262-0.503,7.148-1.255,8.403C132.895,4991.347,126.87,4993.349,123.735,4991.718z"/>
    <path fill="#2c303b" d="M600.586,4975.039c-2.637-2.51-3.145-4.268-3.145-10.034c0-8.027,2.764-11.924,8.652-11.924
        c10.039,0,12.432,19.448,3.018,23.711C604.844,4978.803,603.965,4978.549,600.586,4975.039z"/>
    <path fill="#2c303b" d="M69.16,4923.603c-4.009-2.266-6.519-7.905-5.391-12.422c1.006-4.39,6.147-8.281,10.786-8.281
        c5.024,0,11.04,6.025,11.04,11.167C85.596,4921.972,76.064,4927.49,69.16,4923.603z"/>
    <path fill="#2c303b" d="M620.273,4778.701c-6.025-5.645-4.883-14.307,2.383-17.939c5.771-2.764,11.67-0.996,14.434,4.395
        C642.49,4775.566,628.809,4786.611,620.273,4778.701z"/>
    <path fill="#2c303b" d="M290.713,4688.75c-14.678-4.766-50.181-23.33-90.83-47.295l-35.625-21.074l-57.329,20.322
        c-62.1,21.963-62.729,22.08-65.869,14.688c-2.886-7.031-0.498-10.283,10.415-14.434c25.215-9.658,111.401-39.521,113.911-39.385
        c1.631,0,20.073,10.039,40.894,22.324c41.03,24.082,76.025,42.656,88.447,46.787c4.644,1.641,11.04,2.637,15.684,2.637
        c15.43-0.127,128.594-12.295,132.48-14.297c8.398-4.258,12.793-13.428,11.035-22.832c-1.133-5.898-9.15-13.926-15.176-15.059
        c-2.764-0.498-25.469,1.387-55.703,4.521c-55.825,5.762-57.71,5.645-66.362-0.879c-9.287-7.031-12.295-21.709-6.655-32.744
        c3.14-6.143,11.67-12.168,18.691-13.291c14.561-2.266,148.672-14.688,153.936-14.18c5.264,0.371,15.674,5.508,63.975,30.986
        c85.566,45.039,78.535,42.031,86.689,38.135c7.148-3.389,10.166-13.174,6.66-21.074c-1.143-2.256-21.836-16.191-68.75-46.045
        c-37.012-23.584-69.502-43.906-72.275-45.156c-2.754-1.133-10.908-3.135-18.184-4.268c-22.207-3.643-80.791-14.063-134.106-23.838
        c-38.135-7.148-53.193-9.414-61.475-9.414c-10.034,0-19.946,2.266-122.065,27.598c-61.094,15.186-112.778,27.598-114.785,27.598
        c-7.529,0-11.421-10.4-5.645-15.176c1.753-1.377,45.156-12.666,115.288-30.234l112.656-27.969h15.059
        c13.672,0.117,21.323,1.25,80.288,12.285c35.869,6.65,78.789,14.434,95.352,17.188c36.377,6.152,41.26,7.158,47.285,10.176
        c2.637,1.377,34.502,21.318,70.879,44.531c71.006,45.156,75.4,48.418,78.789,59.961c2.383,7.9,2.383,12.422,0,20.322
        c-2.393,8.281-9.17,15.938-17.559,19.951c-5.908,3.008-8.037,3.389-15.938,2.881l-9.16-0.371l-66.494-35
        c-58.965-31.113-67.109-35-71.885-34.873c-2.881,0.117-37.393,3.379-76.523,7.148c-76.274,7.529-75.518,7.393-75.518,14.414
        c0,4.404,3.506,7.529,8.525,7.529c2.261,0,25.977-2.246,52.822-5.02c40.273-4.258,49.805-4.883,54.824-3.76
        c18.809,4.268,30.986,19.199,30.986,38.008c0,16.445-11.67,32.119-27.354,36.631c-6.768,1.885-127.207,14.443-137.876,14.307
        C303.633,4692.011,296.23,4690.507,290.713,4688.75z"/>
</g>
</svg>
';
                        break;
                    case 'business_reputation':
                        $localItem['img_path'] = 'hx_tm_business_reputation.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. Whereas, this resource is unique and looking for a matured environments to continue career with profoundness.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. This component is been a vital criteria considering the earlier companies and career which is been chosen by this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M416.699,1263.086c-9.219-9.214-9.219-10.298,0.547-20.059c9.756-9.761,9.756-9.761,16.27,0.542
        c4.873,8.135,4.873,12.471-0.547,19.517C426.455,1272.309,425.381,1272.309,416.699,1263.086z"/>
    <path fill="#70BF44" d="M481.23,1214.282c-8.672-9.219-9.219-11.387-2.178-16.812c4.355-3.794,8.691-8.672,9.766-11.929
        c1.084-2.71,7.598,0,13.564,6.514l11.924,11.929l-11.924,10.298C490.996,1224.59,490.996,1224.59,481.23,1214.282z"/>
    <path fill="#2c303b" d="M332.642,1203.437c-46.089-11.929-54.229-79.175-12.466-103.579c24.941-15.181,47.178-11.929,68.32,9.224
        c14.648,14.644,18.438,22.773,18.438,40.127C406.934,1188.252,371.699,1213.745,332.642,1203.437z M374.941,1117.759
        c-7.051-5.967-17.896-10.845-24.941-10.845s-17.896,4.878-24.941,10.845l-13.018,10.303H350h37.959L374.941,1117.759z"/>
    <path fill="#2c303b" d="M452.49,1135.112c-8.672-13.555,3.252-23.862,15.732-14.644c8.672,5.967,8.672,7.046-0.547,15.186
        C459.004,1143.784,457.373,1143.784,452.49,1135.112z"/>
    <path fill="#2c303b" d="M263.232,1065.693c-29.282-15.181-78.633-69.409-78.633-86.758c0-8.14,78.096-103.037,87.314-106.299
        c5.42-1.621,0.537-90.01-9.219-173.525l-3.262-26.035h32.539h32.544l3.252,28.75c1.631,15.176,4.336,47.715,5.967,71.582
        c4.883,66.152,8.125,84.062,16.265,84.062s11.387-19.004,16.27-89.492c1.621-26.582,4.336-59.102,6.504-72.109l2.715-22.793h31.992
        h32.529l-3.242,26.035c-9.766,91.094-14.102,171.904-8.682,173.525c7.588,2.715,87.314,98.159,87.314,104.663
        c0,10.313-26.035,46.099-48.271,66.167c-26.025,23.315-42.295,30.908-68.32,30.908h-18.438l1.084-39.585
        c0.537-41.763-5.42-63.447-13.018-43.936c-2.168,5.43-4.346,19.531-4.346,30.918c-0.537,17.891-2.158,20.063-14.092,20.063
        c-11.929,0-13.555-2.173-14.102-20.063c0-11.387-2.163-25.488-4.336-30.918c-7.593-19.512-14.106,2.72-13.013,44.473l1.079,39.048
        h-20.063C288.716,1074.375,272.451,1070.576,263.232,1065.693z M276.787,976.763v-49.346l-15.186,17.896
        c-32.529,39.043-31.992,35.254-9.214,58.564c11.934,11.929,21.689,21.694,22.773,21.694
        C276.25,1025.571,276.787,1003.33,276.787,976.763z M447.607,1003.877c22.773-23.311,23.32-19.521-8.672-58.027
        c-14.102-16.27-14.639-16.802-17.9-5.42c-4.883,17.896-3.789,85.142,1.084,85.142
        C424.297,1025.571,435.674,1015.806,447.607,1003.877z"/>
    <path fill="#2c303b" d="M338.618,1066.24c-2.173-4.883-1.094-11.392,2.163-14.648c8.125-8.125,23.857-0.532,21.699,10.313
        C360.303,1074.375,342.954,1077.632,338.618,1066.24z"/>
    <path fill="#2c303b" d="M124.946,689.893c0-2.168,4.883-10.84,11.392-18.984l11.387-14.629l-14.644-18.438l-14.097-18.984h32.539
        H184.6v27.109v27.109h18.979c15.186,0,18.979,2.168,18.979,10.859c0,10.293-3.794,10.84-48.804,10.84
        C146.645,694.775,124.946,692.607,124.946,689.893z"/>
    <path fill="#2c303b" d="M477.441,683.935c0-8.691,3.789-10.859,18.975-10.859H515.4v-27.109v-27.109h33.076h32.539l-14.102,18.984
        l-14.648,18.438l11.396,14.629c6.504,8.145,11.387,16.816,11.387,18.984c0,2.715-21.699,4.883-48.809,4.883
        C481.23,694.775,477.441,694.228,477.441,683.935z"/>
    <path fill="#2c303b" d="M190.024,632.412v-35.254H350h159.971v35.254v35.234H350H190.024V632.412z M267.568,625.361
        c-3.247-12.461-21.689-12.461-24.941,0c-3.257,11.934,11.929,22.227,21.147,14.648
        C267.568,637.295,269.194,630.244,267.568,625.361z M313.667,639.463c6.509-9.219,0.547-23.32-9.766-23.32
        c-4.336,0-9.756,3.789-11.382,8.125c-3.804,8.145,3.789,21.699,11.382,21.699C306.074,645.967,310.41,642.725,313.667,639.463z
         M363.555,627.529c0-8.672-3.252-11.387-13.555-11.387c-10.313,0-13.555,2.715-13.555,11.934c0,6.504,3.242,12.461,7.046,14.102
        C354.883,645.967,363.555,640.01,363.555,627.529z M405.859,639.463c6.504-9.219,0.537-23.32-9.766-23.32
        c-4.346,0-9.756,3.789-11.387,8.125c-3.789,8.145,3.789,21.699,11.387,21.699C398.262,645.967,402.598,642.725,405.859,639.463z
         M457.92,625.908c-3.252-13.008-27.656-14.648-26.582-2.168c0,4.883,2.178,11.914,4.883,15.723
        C442.187,649.209,460.625,637.842,457.92,625.908z"/>
</g>
</svg>';
                        break;
                    case 'career_progression':

                        $localItem['img_path'] = 'hx_tm_career_rogression.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. The career progression for this resource is deemed to be attaining the closeness towards to the fulfilment and hence it is satisfactory.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. This attribute for this resource sees towards the ultimate professional goals, step by step. The progression of this resource is non-vulnerable and is followed in order to reach the goal.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'company_culture':
                        $localItem['img_path'] = 'hx_tm_company_culture.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource can become a fit and get accustomed with the company cultural practices in time as per the earlier companies and hence deemed as a good fit. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource is been into similar company environments earlier and should be an appropriate cultural fit as per the defined policies, processes and cultural practices as per the company.';

                                break;
                        }
                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M25.052,14.046c1.584,5.316,4.274,7.801,8.519,7.936
        c2.337,0.074,4.374-0.711,6.094-2.272c1.713-1.554,2.543-3.582,2.855-5.844c2.295,0.763,3.66,2.43,3.676,4.663
        c0.043,6.099,0.043,12.197,0,18.295c-0.016,2.374-1.256,3.955-3.09,4.246c-1.096,0.175-1.658-0.148-1.705-1.367
        c-0.102-2.621-0.25-5.244-0.477-7.857c-0.361-4.128-3.143-6.699-7.314-6.824c-2.753-0.083-5.519,0.011-8.258-0.227
        c-2.272-0.197-3.528-1.533-3.811-3.794c-0.151-1.214-0.115-2.502,0.119-3.7C22.006,15.543,23.186,14.448,25.052,14.046z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M17.948,61.804c3.734-3.795,4.531-7.516,2.43-11.352
        c-2.042-3.728-5.59-4.946-10.966-3.765c-0.943-1.188-1.028-2.439,0.095-3.676c0.874-0.962,1.977-1.771,3.103-2.438
        c4.702-2.781,9.446-5.495,14.187-8.211c2.262-1.296,3.959-1.164,5.329,0.34c0.957,1.052,0.932,1.404-0.239,2.188
        c-2.031,1.358-4.087,2.68-6.116,4.042c-3.838,2.578-4.773,6.647-2.467,10.694c1.011,1.773,2.046,3.532,3.074,5.296
        c1.868,3.206,1.266,5.494-1.948,7.337c-0.576,0.33-1.157,0.672-1.772,0.914C21.089,63.791,18.835,63.432,17.948,61.804z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M60.823,44.183c-5.352-1.4-8.875-0.182-11.281,3.891
        c-2.033,3.442-1.1,7.292,2.766,11.392c-1.84,1.604-3.883,1.886-5.873,0.751c-5.252-2.994-10.501-5.995-15.737-9.02
        c-1.616-0.934-2.613-2.278-2.361-4.263c0.188-1.484,0.903-1.954,2.199-1.355c2.094,0.967,4.194,1.935,6.208,3.051
        c4.003,2.22,7.632,1.504,10.21-2.272c1.301-1.902,2.422-3.93,3.57-5.933c1.029-1.799,2.316-3.312,4.572-3.077
        c2.393,0.248,4.4,1.396,5.66,3.534C61.37,41.924,61.442,43.069,60.823,44.183z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M57.151,59.835c-4.354-0.032-7.746-3.501-7.688-7.86
        c0.055-4.273,3.389-7.507,7.729-7.497c4.445,0.011,7.752,3.364,7.693,7.802C64.831,56.469,61.353,59.865,57.151,59.835z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M20.552,54.742c-0.013,4.199-3.464,7.641-7.661,7.641
        c-4.304,0-7.761-3.414-7.777-7.679c-0.016-4.195,3.426-7.748,7.54-7.782C17.016,46.886,20.565,50.4,20.552,54.742z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M26.139,13.237c0.047-4.259,3.604-7.729,7.815-7.624
        c4.211,0.104,7.563,3.563,7.538,7.778c-0.025,4.29-3.469,7.69-7.755,7.661C29.479,21.023,26.091,17.538,26.139,13.237z"/>
</g>
</svg>
';
                        break;
                    case 'change_stability':
                        $localItem['img_path'] = 'hx_tm_change_stability.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. The duration worked within each company and the acceptance for the situational changes in the organization is addressed well and accustomed by this resource.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. Considering the employment stay in each company and the balanced growth in experience show this resource is stable. Also, as per the movement between roles or responsibilities proves the inclination to changes. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,224.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M304.404,2189.38c-30.679-4.971-53.77-11.689-79.482-23.672c-90.586-41.787-152.241-120.684-173.569-222.08
        c-5.259-24.834-4.38-88.54,1.46-115.415c20.459-92.627,79.194-168.896,161.011-209.521
        c104.316-52.002,223.247-41.191,317.622,28.643c51.436,38.281,92.344,99.648,110.742,166.27
        c6.143,21.904,7.021,30.967,6.729,77.422c-0.293,48.516-0.879,54.653-8.193,78.911c-10.508,35.352-26.289,68.662-44.697,94.38
        c-8.486,11.685-15.498,22.212-15.498,23.374c0,1.172,16.084,18.115,35.664,37.695l35.938,35.942h-91.455h-91.182v-91.172v-91.46
        l31.562,31.558c17.236,17.246,32.734,31.27,34.482,31.27c4.971,0,26.592-34.482,36.23-57.856
        c14.033-33.022,18.418-56.694,18.418-95.562c0-26.289-1.758-40.898-6.436-58.438c-21.924-82.393-79.189-143.174-161.006-171.514
        c-26.592-9.063-29.805-9.355-71.587-9.648c-37.114,0-47.344,1.172-66.626,6.719c-44.116,12.568-82.69,36.523-113.667,70.713
        c-80.068,87.666-85.024,218.281-12.271,312.949c25.132,32.729,62.529,60.786,100.518,75.396
        c24.834,9.639,61.074,17.822,78.896,17.822h11.982l-0.879,30.098l-0.874,29.805l-10.229,0.586
        C332.456,2192.885,317.261,2191.421,304.404,2189.38z"/>
    <path fill="#2c303b" d="M319.893,2066.362c-39.741-15.2-62.822-49.971-60.195-91.46c4.38-75.391,92.334-111.914,149.307-61.655
        c20.176,17.524,29.814,39.443,29.521,66.909c0,35.649-17.822,65.161-49.092,80.942
        C371.016,2070.449,337.129,2073.081,319.893,2066.362z"/>
    <path fill="#2c303b" d="M306.45,1825.293c-21.621-4.102-49.38-13.74-66.621-23.672c-18.12-10.234-42.08-30.967-42.08-36.24
        c0-6.123,34.771-35.938,55.518-47.617c56.104-31.563,127.7-33.018,183.804-4.092c21.328,11.094,45.869,30.098,58.73,45.283
        l7.012,8.77l-14.326,12.861c-16.943,14.902-53.77,33.896-78.887,40.605C388.848,1826.748,328.369,1829.082,306.45,1825.293z"/>
</g>
</svg>
';
                        break;

                    case 'innovation_technology':
                        $localItem['img_path'] = 'hx_tm_innovation_technology.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Being in an advanced environment it is evident that this resource is supporting the project besides possessing creative thought process to support the new and upcoming technologies as and when the projects demands. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Capable to contemplate and get adapted to work in the new technologies so as to support the project, besides planning for the trainings in the upcoming technical skill. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,280.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M350.488,2755.049c0-14.639-1.665-19.653-7.1-21.328c-4.185-1.255-16.313-6.27-27.598-11.289l-19.658-8.784
        l-11.704,11.294c-13.804,13.379-22.163,14.214-31.362,3.76c-9.619-10.454-8.779-17.139,3.345-30.103l10.454-10.879l-12.544-28.433
        c-11.709-25.088-14.219-28.018-24.253-27.598c-20.493,1.675-21.743,0.42-21.743-16.309c0-16.724,0-16.724,17.563-17.979
        c16.724-1.25,17.559-1.675,24.668-23.833c4.18-12.129,9.614-24.673,12.124-27.603c2.93-3.34,0.84-7.939-6.27-14.634
        c-12.544-11.704-13.384-21.323-2.93-30.527c10.459-9.614,18.818-8.779,29.692,2.93l9.619,10.034l13.379-7.944
        c7.109-4.6,20.073-10.039,28.848-12.544c14.639-3.765,15.469-5.02,15.469-20.493c0-16.724,0-16.724,16.738-16.724
        c16.719,0,19.219,2.93,17.129,20.073c-1.25,7.944,7.539,17.563,15.488,17.563c3.75,0,14.629,4.18,24.668,8.779l18.398,8.779
        l9.609-8.779c11.289-10.869,20.078-11.289,28.848-1.255c9.629,10.874,8.789,18.818-2.93,29.688
        c-9.609,9.204-10.02,10.454-3.75,19.658c3.34,5.435,8.789,17.979,11.719,27.598c4.59,17.139,5.84,17.983,22.578,19.233
        c17.129,1.255,17.129,1.675,17.129,17.979c0,16.729-1.23,17.983-21.738,16.309c-10.039-0.42-12.539,2.51-24.258,27.598
        l-12.539,28.433l10.449,10.879c12.559,12.964,13.379,21.323,2.93,30.522c-10.859,9.619-17.148,8.779-30.527-3.765l-11.699-11.284
        l-15.469,7.524c-8.789,4.18-20.488,8.779-26.348,10.454c-9.629,2.51-10.879,5.02-11.289,21.323l-0.43,18.398l-17.139,1.255
        l-17.568,1.255V2755.049z M402.773,2694.834c46.816-21.328,67.734-71.924,48.496-115.83
        c-17.559-39.307-43.066-55.615-86.563-56.035c-22.158,0-28.428,2.095-45.991,13.799c-28.018,18.403-41.396,43.491-40.977,76.108
        c0.415,28.433,7.104,43.901,27.598,63.56C332.515,2702.778,370.156,2709.887,402.773,2694.834z"/>
    <path fill="#2c303b" d="M346.313,2674.76c-3.345-1.255-11.709-6.27-17.979-10.869l-11.709-7.949l9.619-5.015
        c7.524-4.185,11.284-4.185,17.979,0.415c4.6,2.925,15.054,5.435,23.413,5.435c18.809,0,41.406-17.139,41.406-30.942
        c0-5.02,2.93-13.379,6.68-18.813l6.699-9.619l7.52,11.289c7.539,11.294,7.129,11.709-3.77,30.522
        c-5.84,10.459-15.879,22.583-22.148,27.183C392.734,2674.76,358.437,2679.78,346.313,2674.76z"/>
    <path fill="#2c303b" d="M302.412,2610.781c-3.77-6.689-4.604-12.544-2.51-12.544c2.085,0,4.595-4.18,6.27-9.614
        c1.255-5.02,8.779-15.894,17.144-23.838c14.214-13.799,16.724-14.634,43.071-14.634c22.168,0,30.527,1.67,39.316,8.779
        c10.859,8.364,10.859,8.779,2.5,13.799c-6.699,4.185-10.879,3.765-23.008-1.67c-12.539-5.854-17.559-6.274-30.938-2.51
        c-17.144,5.02-28.848,17.983-28.848,31.777c-0.425,8.364-9.204,22.998-13.804,22.998
        C309.932,2623.325,306.172,2617.89,302.412,2610.781z"/>
    <path fill="#2c303b" d="M197.871,2523.388c-24.673-10.034-34.712-43.906-25.093-81.543c4.185-15.479,5.02-26.768,2.51-33.037
        c-2.925-7.109-2.09-13.789,2.095-21.738c2.925-5.859,7.524-18.398,10.034-27.188c2.925-11.289,8.779-18.809,20.908-26.758
        c17.563-11.289,20.068-19.238,11.289-34.707c-8.364-15.059-25.093-25.078-60.635-37.227
        c-32.617-10.449-34.287-11.699-38.052-26.328c-2.09-8.379-5.015-36.367-6.689-61.895l-2.51-47.246h58.54h58.96v16.738
        c0,9.18,0.84,16.699,2.095,16.699c1.25,0,10.034-3.75,18.813-8.34c10.874-5.449,16.729-11.289,16.729-16.738
        c0-7.52,2.93-8.359,29.268-8.359h29.277v32.617c0,30.938,4.595,70.664,10.454,93.672c2.505,9.609,1.25,11.289-11.294,13.809
        c-27.178,5.84-53.525,30.508-53.525,50.176c0,3.34,7.524,10.859,16.729,17.129c10.869,7.539,17.979,15.898,20.908,26.348
        c2.51,8.359,7.944,20.898,11.289,28.008c4.6,9.219,5.439,15.059,2.505,20.508c-2.505,4.16-3.34,19.219-2.085,33.442
        c1.67,25.508,1.67,25.923-10.874,30.942c-10.874,4.6-14.219,4.6-22.578-1.25c-16.729-11.714-31.782-8.369-51.855,11.704
        c-13.799,13.804-18.398,21.328-18.398,31.362C216.685,2527.573,212.925,2529.238,197.871,2523.388z M261.846,2279.179
        c2.51-2.93,2.93-7.52,0.835-10.879c-1.67-3.34-2.51-16.289-1.25-28.848l2.51-23.418l-14.219,8.789
        c-12.129,7.109-14.224,10.449-12.964,21.738c0.415,7.109-0.835,16.738-3.345,21.328c-3.345,6.27-2.51,8.789,2.93,12.129
        C246.797,2285.879,256.831,2285.449,261.846,2279.179z M250.137,2206.426c8.784-5.02,12.964-11.289,14.639-23.008
        c1.67-9.199,1.67-17.559,0.415-18.809c-1.25-1.68-9.199,0.84-17.144,5.43c-13.384,7.109-14.634,9.629-14.634,25.527
        c0,10.02,1.25,17.969,2.51,17.969C237.173,2213.535,243.867,2210.195,250.137,2206.426z"/>
    <path fill="#2c303b" d="M517.754,2514.189c0-10.034-4.609-17.559-18.398-31.362c-20.078-20.073-35.117-23.418-51.836-11.704
        c-21.348,14.629-44.746-10.874-34.707-37.637c2.09-5.439,2.91-17.568,1.66-27.178c-1.25-9.199-0.41-19.238,2.09-22.168
        c2.09-2.93,6.27-13.379,8.789-22.578c3.34-12.969,8.77-20.078,21.309-28.438c17.578-11.719,19.668-16.719,12.148-33.457
        c-7.109-14.629-30.117-29.258-65.664-40.547c-28.008-8.789-30.527-10.449-34.277-24.258c-2.1-8.379-4.189-36.367-4.189-61.895
        v-47.246h56.455h56.445v16.738c0,9.18,1.68,16.699,3.77,16.699c10.02,0,33.867-17.969,33.867-25.488
        c0-7.539,3.77-7.949,58.965-7.949h59.375l-2.93,47.246c-1.68,25.527-4.609,53.516-7.109,61.895
        c-3.75,14.629-5.43,15.879-39.297,26.758c-28.438,9.199-38.887,15.059-50.195,28.008c-19.219,20.918-18.809,29.707,2.09,43.496
        c12.129,8.359,17.988,15.898,21.758,28.438c2.5,9.199,7.52,21.328,10.859,26.758c5.039,7.539,5.039,11.719,0.84,21.738
        c-2.91,7.539-4.18,19.668-2.5,32.207c4.18,29.688-3.34,63.975-16.738,75.684C525.293,2530.913,517.754,2530.083,517.754,2514.189z
         M500.625,2279.179c2.5-3.34,3.34-7.109,1.66-8.359c-1.25-1.68-2.09-14.219-1.66-28.438l0.82-25.488l-13.789,7.93
        c-11.699,7.109-13.809,10.449-12.559,21.738c0.43,7.109-0.84,16.738-2.93,20.918
        C464.238,2281.699,489.746,2292.148,500.625,2279.179z M488.477,2206.426c14.219-9.609,16.738-13.789,16.738-29.277
        c0-15.879-2.93-16.719-20.488-6.25c-11.289,6.25-12.969,9.59-12.969,25.078C471.758,2215.625,473.437,2216.894,488.477,2206.426z
         M576.289,2152.89c0-9.609-1.25-10.43-20.488-10.43c-21.328,0-28.008,4.18-23.809,14.629c1.66,4.59,8.77,6.25,23.398,6.25
        C575.039,2163.34,576.289,2162.519,576.289,2152.89z"/>
</g>
</svg>
';
                        break;
                    case 'job_satisfaction':
                        $localItem['img_path'] = 'hx_tm_jobsatisfaction.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume. Where the average work duration in the earlier companies are considerable with which it can be said that the sustainability of this resource talent is reliable.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume.
                                    Where the period worked for the companies earlier by this resource is admirable, which shows the contentment, satisfaction and acceptance in working with those companies.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'remuneration':
                        $localItem['img_path'] = 'hx_tm_remuneration.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . '  as per the inputs given in the resume. This resource can be considered for this role in view of the remuneration and potentials acquired which are admirable with which the company can foresee the value add in this candidature.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . ' as per the inputs given in the resume.
For this resource the remuneration attribute counts in various other factors while it is not just residing on the monetary, which shows the maturity and reliability to consider this candidature.  ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M13.757,14.409c-2.602,1.371-3.902,3.27-4.113,6.047c-0.352,4.781,2.953,8.438,7.558,8.438
        c4.886-0.035,8.507-4.641,7.453-9.457c-0.703-3.34-4.148-6.012-7.734-6.012C16.183,13.424,14.812,13.846,13.757,14.409z"/>
    <path fill="#2c303b" d="M50.635,13.917c-6.328,2.25-6.891,11.074-0.879,14.098c4.957,2.461,10.546-0.668,11.038-6.152
        c0.176-1.758,0.07-2.355-0.738-3.973C58.298,14.268,54.325,12.617,50.635,13.917z"/>
    <path fill="#2c303b" d="M33.338,25.167c-0.105,0.457-0.843,1.23-1.617,1.758c-2.602,1.723-3.41,3.973-2.25,6.398
        c0.633,1.3,2.355,2.285,5.238,2.988c2.145,0.527,2.637,0.879,2.637,1.934c0,1.441-2.566,2.109-4.008,1.02
        c-0.809-0.598-4.078-0.738-4.078-0.176c0,0.949,1.125,2.355,2.39,3.094c0.809,0.422,1.547,1.09,1.652,1.477
        c0.176,0.563,0.527,0.703,1.969,0.703c1.477,0,1.723-0.105,1.723-0.668c0-0.422,0.598-1.02,1.582-1.582
        c1.863-1.09,2.637-2.426,2.637-4.465c0-2.004-1.582-3.585-4.43-4.324c-2.848-0.773-3.797-1.336-3.938-2.215
        c-0.246-1.758,2.883-2.496,4.078-0.984c0.598,0.738,0.984,0.879,2.496,0.879c1.055,0,1.793-0.141,1.793-0.387
        c0-1.09-1.266-2.848-2.672-3.656c-1.16-0.668-1.547-1.125-1.547-1.758c0-0.809-0.141-0.879-1.723-0.879
        C33.76,24.323,33.514,24.428,33.338,25.167z"/>
    <path fill="#2c303b" d="M11.155,30.616c-2.496,0.633-4.394,2.215-5.695,4.71c-0.492,0.95-1.371,8.333-2.32,19.125L3,56.314h8.542
        c8.507,0,8.578,0,8.578-0.738c0-0.457-0.95-1.758-2.285-3.164c-2.004-2.145-4.043-5.273-4.043-6.258
        c0-0.176,0.422-0.457,0.984-0.668c0.914-0.316,1.02-0.211,2.18,1.758c2.566,4.43,7.523,7.875,12.866,8.965
        c3.41,0.703,4.887,0.422,5.766-1.055c1.652-2.672,0.457-4.5-3.586-5.52c-4.359-1.09-6.609-2.496-8.296-5.203
        c-1.266-2.039-1.617-3.023-2.355-6.469c-0.668-3.235-2.144-5.343-4.429-6.503C15.128,30.581,12.667,30.229,11.155,30.616z"/>
    <path fill="#2c303b" d="M55.45,30.616c-3.796,0.984-5.59,3.27-6.679,8.472c-0.668,3.234-1.863,5.484-3.797,7.277
        c-1.863,1.723-3.059,2.391-5.309,2.953c-1.441,0.352-1.652,0.527-1.477,1.16c0.527,1.828,0.598,3.34,0.281,4.535
        c-0.211,0.703-0.246,1.371-0.07,1.477c0.422,0.246,5.379-1.09,7.102-1.969c0.844-0.387,2.004-1.125,2.637-1.582
        c1.512-1.16,1.863-1.055,1.863,0.457c0,0.738,0.105,1.688,0.21,2.109l0.212,0.809h8.437h8.472l-0.211-2.039
        c-0.105-1.09-0.387-3.973-0.598-6.398c-1.055-12.129-1.16-12.516-2.883-14.589C61.884,31.213,58.017,29.948,55.45,30.616z"/>
</g>
</svg>
';
                        break;
                    case 'team_people':
                        $localItem['img_path'] = 'hx_tm_team_people.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This profile shows the uniqueness in presenting the matured outcome with which the team and the management can easily acknowledge this resource in the company.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. In view of the environment worked by this resource gave consistent exposure which upholds the efficiency on the deliverables with which the company can become a beneficiary. ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M20.375,14.82c0-4.591,3.722-8.313,8.313-8.313c4.59,0,8.313,3.721,8.313,8.313
        c0,4.59-3.722,8.312-8.313,8.312C24.096,23.132,20.375,19.41,20.375,14.82z M32.683,28.795c0.083-1.81,0.706-3.485,1.708-4.87
        c-0.704-0.148-1.431-0.226-2.177-0.226h-7.053c-0.744,0-1.47,0.078-2.17,0.223c1.067,1.48,1.705,3.288,1.715,5.244
        c1.297-0.714,2.785-1.12,4.365-1.12C30.354,28.046,31.574,28.313,32.683,28.795z M34.09,29.541
        c2.414,1.513,4.107,4.075,4.417,7.049c0.983,0.459,2.077,0.725,3.235,0.725c4.23,0,7.657-3.429,7.657-7.659
        s-3.427-7.658-7.657-7.658C37.55,21.998,34.153,25.365,34.09,29.541z M29.072,45.222c4.229,0,7.659-3.429,7.659-7.658
        c0-4.229-3.43-7.658-7.659-7.658c-4.229,0-7.659,3.429-7.659,7.658C21.413,41.793,24.842,45.222,29.072,45.222z M32.32,45.743
        h-6.498c-5.407,0-9.807,4.399-9.807,9.806v7.948l0.021,0.125l0.547,0.17c5.16,1.611,9.643,2.15,13.333,2.15
        c7.206,0,11.384-2.055,11.641-2.187l0.512-0.259h0.054v-7.948C42.125,50.143,37.728,45.743,32.32,45.743z M44.992,37.838h-6.448
        c-0.07,2.58-1.172,4.903-2.914,6.574c4.806,1.429,8.322,5.886,8.322,11.149v2.449c6.367-0.233,10.036-2.038,10.277-2.159
        l0.513-0.261h0.054v-7.949C54.797,42.235,50.397,37.838,44.992,37.838z M46.717,21.834c2.413,1.514,4.106,4.076,4.415,7.049
        c0.984,0.46,2.077,0.725,3.235,0.725c4.231,0,7.66-3.429,7.66-7.658c0-4.23-3.429-7.658-7.66-7.658
        C50.178,14.292,46.779,17.66,46.717,21.834z M57.617,30.131h-6.448c-0.069,2.581-1.17,4.904-2.912,6.574
        c4.807,1.43,8.322,5.886,8.322,11.151v2.449c6.366-0.234,10.036-2.038,10.277-2.16l0.511-0.26h0.056v-7.95
        C67.423,34.53,63.023,30.131,57.617,30.131z M15.634,37.314c1.499,0,2.892-0.438,4.073-1.182c0.375-2.449,1.688-4.589,3.563-6.046
        c0.008-0.144,0.021-0.286,0.021-0.431c0-4.229-3.43-7.658-7.657-7.658c-4.231,0-7.659,3.428-7.659,7.658
        C7.976,33.887,11.403,37.314,15.634,37.314z M22.512,44.412c-1.733-1.662-2.831-3.974-2.912-6.539
        c-0.239-0.018-0.475-0.035-0.719-0.035h-6.497c-5.408,0-9.807,4.397-9.807,9.805v7.948l0.021,0.124l0.548,0.171
        c4.138,1.294,7.833,1.889,11.042,2.075v-2.4C14.189,50.298,17.705,45.84,22.512,44.412z"/>
</g>
</svg>
';
                        break;

                    case 'globalization':
                        $localItem['img_path'] = 'hx_tm_globalization.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . '  as per the inputs provided in resume. This resource can easily get accustomed to the diversified employee backgrounds considering the exposure in working for similar environments in the earlier companies.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . ' as per the inputs provided in resume. Since the working experience depicts multi-national environments the profile, this resources can become handy and can get acquainted to the global policies and processes and diversified cultural backgrounds in the company which paves path easily in accepting this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<path fill="#2c303b" d="M34.189,3.016c-11.344,3.66-16.468,10.246-16.468,21.775c0,9.333,9.698,19.029,19.031,19.029
    c9.148,0,16.65-4.208,19.396-10.978C61.27,20.582,57.063,9.054,46.084,4.297C39.496,1.551,38.582,1.551,34.189,3.016z
     M35.289,12.165c-1.83,1.83-3.477-0.915-1.83-3.294c1.098-2.013,1.464-2.013,2.194,0C36.02,10.152,35.837,11.615,35.289,12.165z
     M43.34,11.067c0,1.098-0.732,1.28-1.83,0.732c-0.916-0.548-1.83-2.013-1.83-2.928c0-1.099,0.914-1.281,1.83-0.732
    C42.607,8.688,43.34,10.152,43.34,11.067z M29.616,10.884c-0.548,0.915-2.013,1.83-2.928,1.83c-1.098,0-1.28-0.915-0.732-1.83
    c0.548-1.099,2.013-1.83,2.928-1.83C29.982,9.054,30.164,9.786,29.616,10.884z M50.658,10.884c0,0.915-0.732,1.83-1.828,1.83
    c-0.916,0-1.832-0.915-1.832-1.83c0-1.099,0.916-1.83,1.832-1.83C49.926,9.054,50.658,9.786,50.658,10.884z M26.871,18.204
    c0,2.012-1.281,3.659-2.745,3.659c-2.745,0-3.843-3.843-1.463-6.038C24.858,13.446,26.871,14.543,26.871,18.204z M36.02,18.204
    c0,2.012-1.282,3.659-2.745,3.659c-2.744,0-3.843-3.843-1.463-6.038C34.006,13.446,36.02,14.543,36.02,18.204z M45.719,18.204
    c0.73,2.744,0,3.659-2.563,3.659c-2.195,0-3.477-1.281-3.477-3.659c0-2.013,1.098-3.66,2.563-3.66
    C43.521,14.543,45.168,16.19,45.719,18.204z M53.951,16.739c3.293,3.294,2.746,5.124-1.463,5.124c-2.379,0-3.658-1.281-3.658-3.659
    C48.83,13.995,50.658,13.446,53.951,16.739z M26.871,28.267c0,1.463-1.281,2.745-2.745,2.745s-2.745-1.281-2.745-2.745
    c0-1.464,1.281-2.745,2.745-2.745S26.871,26.803,26.871,28.267z M36.02,28.267c0,1.463-1.282,2.745-2.745,2.745
    c-1.463,0-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745C34.738,25.522,36.02,26.803,36.02,28.267z M45.168,28.267
    c0,1.463-1.281,2.745-2.744,2.745s-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745S45.168,26.803,45.168,28.267z
     M55.783,27.718c-1.281,3.476-6.953,4.026-6.953,0.732c0-1.83,1.645-2.928,3.842-2.928C54.867,25.522,56.148,26.437,55.783,27.718z
     M28.701,36.502c0,0.914-0.366,1.829-0.732,1.829c-0.549,0-1.465-0.915-2.013-1.829c-0.548-1.098-0.183-1.83,0.732-1.83
    C27.786,34.672,28.701,35.404,28.701,36.502z M36.02,37.416c0,1.464-0.367,2.745-0.731,2.745c-0.366,0-1.1-1.281-1.83-2.745
    c-0.55-1.463-0.184-2.744,0.73-2.744C35.289,34.672,36.02,35.953,36.02,37.416z M43.34,36.318c0,1.098-0.732,2.379-1.83,2.927
    c-0.916,0.549-1.83-0.182-1.83-1.646c0-1.646,0.914-2.927,1.83-2.927C42.607,34.672,43.34,35.404,43.34,36.318z M50.658,35.404
    c0,0.549-0.732,1.463-1.828,2.012c-0.916,0.548-1.832,0.183-1.832-0.733c0-1.097,0.916-2.011,1.832-2.011
    C49.926,34.672,50.658,35.038,50.658,35.404z"/>
<path fill="#2c303b" d="M1.254,52.055v11.895h5.489h5.49V52.055V40.161h-5.49H1.254V52.055z"/>
<path fill="#2c303b" d="M16.258,52.055l0.548,8.602l10.979,3.84l10.979,3.662l15.002-8.053c14.822-7.684,16.836-9.514,13.725-11.529
    c-2.379-1.462-15.371,2.564-18.848,5.676c-2.012,1.645-5.854,2.377-10.979,1.83l-8.05-0.734l8.783-0.182
    c7.137-0.365,8.6-0.914,8.6-3.844c0-2.746-1.83-3.66-8.6-4.575c-4.94-0.549-11.895-1.646-15.736-2.194l-6.954-1.099L16.258,52.055z"
    />
</svg>
';
                        break;
                }

                


                if ($localItem['value'] != '') {
                    $returnData[] = $localItem;
                }


            }
        }

        $finalReponce = array();

        if (count($returnData) > 0) {
            foreach ($returnData as $returnDat) {
                if ($returnDat['value'] > 47) {
                    $finalReponce[] = $returnDat;
                }
            }
        }


        return $finalReponce;
    }
    
    public function getCandidateTalentMinemult($id)
    {
        static $responce = array();
        $candidateDetails = Candidate::with(['getExperience', 'getCandidateDetails', 'getSpectrums', 'getTalentMine'])
            ->where('id', $id)
            ->first();
   
        if (count($candidateDetails->getTalentMine) == 0) {
            $candidate_exp = $candidateDetails->getExperience;
            $candidateEducationArray = $candidateDetails->educations->pluck('institution_name')->toArray();
            try {
                $worldUniversity = WorldUniversity::whereIn('university', $candidateEducationArray)->get();            
            } catch (\Exception $e) {
            
                $worldUniversity=[];
            }
                $candidateUnivercityCodes = [];           
           
            $currentCompany = '';
            if (count($candidate_exp) > 0) {
                $currentCompany = $candidate_exp->first();
            }
            if (isset($candidateDetails->getCandidateDetails) && $candidateDetails->getCandidateDetails->current_working_email != '') {
                $checkemail=$candidateDetails->getCandidateDetails->current_working_email;
                if(strpos($checkemail, '@') !== false){
                   $checkemailval=1;
                } else{
                    $checkemailval=2;
                }
                if($checkemailval ==1){
                $getinfo = getClearbitApi($candidateDetails->getCandidateDetails->current_working_email, 'email');
                } else {
                    $getinfo = getClearbitApi($candidateDetails->getCandidateDetails->current_working_email, 'domain');
                }
            } else {
                 $getinfo = false;
            }
            $balance_well_being_compType = 0;
            $balance_well_being_EmpHeadCount = 0;
            $balance_well_being_Revenue = 0;
            $balance_well_being_UserExp = 0;
            $balance_well_being_FoundedYear = 0;
            $balance_well_being_LocationofHQ = 0;

            $benefits_perks_compType = 0;
            $benefits_perks_Revenue = 0;
            $benefits_perks_UserExp = 0;
            $benefits_perks_AvgStay = 0;

            $business_reputation_compType = 0;
            $business_reputation_EmpHeadCount = 0;
            $business_reputation_FoundedYear = 0;
            $business_reputation_Revenue = 0;
            $business_reputation_JobCountryCheck = 0;


            $career_progression_compType =  0;
            $career_progression_EmpHeadCount =  0;
            $career_progression_FoundedYear =  0;
            $career_progression_UserExpGap =  0;
            $career_progression_AvgStay =  0;


            $company_culture_compType = 0;
            $company_culture_EmpHeadCount = 0;
            $company_culture_FoundedYear = 0;
            $company_culture_Revenue = 0;
            $company_culture_EduCountryCheck = 0;
             $company_culture_JobCountryCheck = 0;


            $change_stability_compType = 0;
            $change_stability_EmpHeadCount = 0;
            $change_stability_Revenue = 0;
            $change_stability_EduCountryCheck = 0;
            $change_stability_AvgStay = 0;


            $innovation_technology_compType = 0;
            $innovation_technology_EmpHeadCount = 0;
            $innovation_technology_FoundedYear = 0;
            $innovation_technology_Revenue = 0;
            $innovation_technology_EduCountryCheck = 0;


            $job_satisfaction_compType = 0;
            $job_satisfaction_EmpHeadCount = 0;
            $job_satisfaction_Revenue = 0;
            $job_satisfaction_FoundedYear = 0;
            $job_satisfaction_UserExp = 0;
            $job_satisfaction_AvgStay = 0;

            $remuneration_compType = 0;
            $remuneration_EmpHeadCount = 0;
            $remuneration_Revenue = 0;
            $remuneration_UserExp = 0;
            $remuneration_AvgStay = 0;

            $team_people_compType = 0;
            $team_people_EmpHeadCount = 0;
            $team_people_Revenue = 0;
            $team_people_UserExp = 0;
            $team_people_AvgStay = 0;


            $globalization_compType = 0;
            $globalization_EmpHeadCount = 0;
            $globalization_Revenue = 0;
            $globalization_FoundedYear = 0;
            $globalization_JobCountryCheck = 0;

            if (count($candidateUnivercityCodes) > 0) {
                $validareEduCodesArray = ['UK', 'US', 'EU'];
                $overlap = array_intersect($validareEduCodesArray, $candidateUnivercityCodes);
                $counts = array_count_values($overlap);
                if (count($counts) > 0) {
                    $company_culture_JobCountryCheck = -7;
                    $change_stability_EduCountryCheck = -8;
                    $innovation_technology_EduCountryCheck = -8;
                }
            }

       
            if (!empty($getinfo)) {
                if ($getinfo->type == 'public') {
                    $balance_well_being_compType = 20;
                    $benefits_perks_compType = 40;
                    $business_reputation_compType = 20;
                    $career_progression_compType = 20;
                    $change_stability_compType = 20;
                    $innovation_technology_compType = 20;
                    $job_satisfaction_compType = 20;
                    $remuneration_compType = 20;
                    $team_people_compType = 20;
                    $globalization_compType = 20;
                } else {
                    $balance_well_being_compType = 10;
                    $benefits_perks_compType = 20;
                    $business_reputation_compType = 5;
                    $career_progression_compType = 10;
                    $change_stability_compType = 10;
                    $innovation_technology_compType = 10;
                    $job_satisfaction_compType = 10;
                    $remuneration_compType = 10;
                    $team_people_compType = 10;
                    $globalization_compType = 10;
                }
                $metrics = json_decode($getinfo->metrics, true);
                $geo = json_decode($getinfo->geo, true);
                if (!empty($metrics)) {
                    if ($metrics['employees'] != '') {
                        $empcount = $metrics['employees'];
                        switch (true) {
                            case $empcount <= 100:
                                $balance_well_being_EmpHeadCount = 10;
                                $business_reputation_EmpHeadCount = 10;
                                $career_progression_EmpHeadCount = 10;
                                $change_stability_EmpHeadCount = 10;
                                $innovation_technology_EmpHeadCount = 10;
                                $job_satisfaction_EmpHeadCount = 10;
                                $remuneration_EmpHeadCount = 10;
                                $team_people_EmpHeadCount = 10;
                                $globalization_EmpHeadCount = 10;
                                break;
                            case $empcount <= 500:
                                $balance_well_being_EmpHeadCount = 15;
                                $business_reputation_EmpHeadCount = 15;
                                $career_progression_EmpHeadCount = 15;
                                $change_stability_EmpHeadCount = 15;
                                $innovation_technology_EmpHeadCount = 15;
                                $job_satisfaction_EmpHeadCount = 15;
                                $remuneration_EmpHeadCount = 15;
                                $team_people_EmpHeadCount = 15;
                                $globalization_EmpHeadCount = 15;
                                break;
                            case $empcount > 500:
                                $balance_well_being_EmpHeadCount = 20;
                                $business_reputation_EmpHeadCount = 20;
                                $career_progression_EmpHeadCount = 20;
                                $change_stability_EmpHeadCount = 20;
                                $innovation_technology_EmpHeadCount = 20;
                                $job_satisfaction_EmpHeadCount = 20;
                                $remuneration_EmpHeadCount = 20;
                                $team_people_EmpHeadCount = 20;
                                $globalization_EmpHeadCount = 20;
                                break;
                        }
                    }

                    if ($metrics['annualRevenue'] != '') {
                        $annualRevenue = $metrics['annualRevenue'];
                        switch (true) {
                            case $annualRevenue <= 5000000:
                                $balance_well_being_Revenue = 10;
                                $benefits_perks_Revenue = 10;
                                $business_reputation_Revenue = 10;
                                $change_stability_Revenue = 10;
                                $innovation_technology_Revenue = 10;
                                $job_satisfaction_Revenue = 10;
                                $remuneration_Revenue = 10;
                                $team_people_Revenue = 10;
                                $globalization_Revenue = 10;
                                break;
                            case $annualRevenue <= 1000000:
                                $balance_well_being_Revenue = 12.5;
                                $benefits_perks_Revenue = 12.5;
                                $business_reputation_Revenue = 12.5;
                                $change_stability_Revenue = 12.5;
                                $innovation_technology_Revenue = 12.5;
                                $job_satisfaction_Revenue = 12.5;
                                $remuneration_Revenue = 12.5;
                                $team_people_Revenue = 12.5;
                                $globalization_Revenue = 12.5;

                                break;
                            case $annualRevenue <= 5000000:
                                $balance_well_being_Revenue = 15;
                                $benefits_perks_Revenue = 15;
                                $business_reputation_Revenue = 15;
                                $change_stability_Revenue = 15;
                                $innovation_technology_Revenue = 15;
                                $job_satisfaction_Revenue = 15;
                                $remuneration_Revenue = 15;
                                $team_people_Revenue = 15;
                                $globalization_Revenue = 15;
                                break;
                            case $annualRevenue > 5000000:
                                $balance_well_being_Revenue = 20;
                                $benefits_perks_Revenue = 20;
                                $business_reputation_Revenue = 20;
                                $change_stability_Revenue = 20;
                                $innovation_technology_Revenue = 20;
                                $job_satisfaction_Revenue = 20;
                                $remuneration_Revenue = 20;
                                $team_people_Revenue = 20;
                                $globalization_Revenue = 20;
                                break;
                        }
                    }

                    $foundedYearData = $getinfo->foundedYear;
                    $business_reputation_FoundedYear = 0;
                    $career_progression_FoundedYear = 0;
                    $foundedYearDatadbDate = \Carbon\Carbon::parse($foundedYearData . '-01-01');
                    $foundedYearsCalc = \Carbon\Carbon::now()->diffInYears($foundedYearDatadbDate);
                    switch (true) {
                        case in_array($foundedYearsCalc, range(0, 3)) :
                            $business_reputation_FoundedYear = 5;
                            $career_progression_FoundedYear = 5;
                            $innovation_technology_FoundedYear = 5;
                            $job_satisfaction_FoundedYear = 5;
                            $globalization_FoundedYear = 5;
                            break;
                        case in_array($foundedYearsCalc, range(3, 7)):
                            $business_reputation_FoundedYear = 10;
                            $career_progression_FoundedYear = 10;
                            $innovation_technology_FoundedYear = 10;
                            $job_satisfaction_FoundedYear = 10;
                            $globalization_FoundedYear = 10;
                            break;
                        case in_array($foundedYearsCalc, range(7, 12)):
                            $business_reputation_FoundedYear = 15;
                            $career_progression_FoundedYear = 15;
                            $innovation_technology_FoundedYear = 15;
                            $job_satisfaction_FoundedYear = 15;
                            $globalization_FoundedYear = 15;
                            break;
                        case in_array($foundedYearsCalc, range(12, 50000)):
                            $business_reputation_FoundedYear = 20;
                            $career_progression_FoundedYear = 20;
                            $innovation_technology_FoundedYear = 20;
                            $job_satisfaction_FoundedYear = 20;
                            $globalization_FoundedYear = 20;
                            break;
                    }
                }

                if (!empty($geo)) {
                    if ($geo['countryCode'] != '') {
                        $validareCountryCodesArray = ['UK', 'US', 'EU'];
                        $countryCode = $geo['countryCode'];
                        if (!in_array($countryCode, $validareCountryCodesArray)) {
                            $business_reputation_JobCountryCheck = -10;
                            $globalization_JobCountryCheck = -10;
                        }
                    }
                }
                switch (true) {
                    case in_array($candidateDetails->total_experience_in_year, range(15, 20)):
                        $balance_well_being_UserExp = -5;
                        $benefits_perks_UserExp = -5;
                        break;
                        //break;
                    case in_array($candidateDetails->total_experience_in_year, range(20, 300)):
                        $balance_well_being_UserExp = 8;
                        $benefits_perks_UserExp = -9;
                        break;
                }

                switch (true) {
                    case in_array($candidateDetails->total_experience_in_year, range(10, 15)):
                        $job_satisfaction_UserExp = -5;
                        $remuneration_UserExp = -5;
                        $team_people_UserExp = -5;
                        break;
                    case in_array($candidateDetails->total_experience_in_year, range(15, 300)):
                        $job_satisfaction_UserExp = -10;
                        $remuneration_UserExp = -11;
                        $team_people_UserExp = -12;
                        break;
                }

                switch (true) {
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(12, 24)):
                        $benefits_perks_AvgStay = 5;
                        $career_progression_AvgStay = 5;
                        $change_stability_AvgStay = 5;
                        $job_satisfaction_AvgStay = 5;
                        $remuneration_AvgStay = 5;
                        $team_people_AvgStay = 5;
                        break;
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(24, 48)):
                        $benefits_perks_AvgStay = 10;
                        $career_progression_AvgStay = 10;
                        $change_stability_AvgStay = 10;
                        $job_satisfaction_AvgStay = 10;
                        $remuneration_AvgStay = 10;
                        $team_people_AvgStay = 10;
                        break;
                    case in_array($candidateDetails->getCandidateDetails->averageStay, range(48, 100000)):
                        $benefits_perks_AvgStay = 20;
                        $career_progression_AvgStay = 20;
                        $change_stability_AvgStay = 20;
                        $job_satisfaction_AvgStay = 20;
                        $remuneration_AvgStay = 20;
                        $team_people_AvgStay = 20;
                        break;
                }
                $jobGaps = array();

                if ($candidateDetails->total_experience_in_year > 0) {
                    $candidateExperiencesData = isset($candidateDetails->getExperience) ? $candidateDetails->getExperience->sortBy(function ($col) {
                        return $col->start_date;
                    })->values()->all() : [];
                    if (count($candidateExperiencesData) > 0) {
                        foreach ($candidateExperiencesData as $key => $candidateExperiencesDat) {
                            if (isset($candidateExperiencesData[$key + 1]->start_date)) {
                                $endthisJobDate = $candidateExperiencesDat->end_date;
                                $nextJobStartDate = $candidateExperiencesData[$key + 1]->start_date;
                            } else {
                                if ($candidateExperiencesDat->is_current_employer == 1) {
                                    $endthisJobDate = date('Y-m-d');
                                    $nextJobStartDate = date('Y-m-d');
                                } else {
                                    $endthisJobDate = $candidateExperiencesDat->end_date;
                                    $nextJobStartDate = date('Y-m-d');
                                }
                            }
                            $to = new Carbon($endthisJobDate);
                            $from = new Carbon($nextJobStartDate);
                            $diff_in_months = $to->diffInMonths($from);
                            if ($diff_in_months > 0) {
                                $jobGaps[] = $diff_in_months;
                            }
                        }
                    }
                }

                if (count($jobGaps) > 0) {
                    $career_progression_UserExpGap = -10;
                } else {
                    $career_progression_UserExpGap = 10;
                }
          
                $balance_well_being_Data = (
                    $balance_well_being_compType +
                    $balance_well_being_EmpHeadCount +
                    $balance_well_being_Revenue +
                    $balance_well_being_UserExp
                );


                if ($balance_well_being_Data > 0) {
                    if ($balance_well_being_Data > 60) {
                        $balance_well_being_Data = 60;
                    }
                    $responce['balance_well_being'] = $balance_well_being_Data;
                }

              
                $benefits_perks_data = (
                    $benefits_perks_compType +
                    $benefits_perks_Revenue +
                    $benefits_perks_AvgStay +
                    $benefits_perks_UserExp
                );

                if ($benefits_perks_data > 0) {
                    if ($benefits_perks_data > 60) {
                        $benefits_perks_data = 60;
                    }
                    $responce['benefits_perks'] = $benefits_perks_data;
                }

           
                $business_reputation_data = (
                    $business_reputation_compType +
                    $business_reputation_EmpHeadCount +
                    $business_reputation_FoundedYear +
                    $business_reputation_Revenue +
                    $business_reputation_JobCountryCheck
                );

                if ($business_reputation_data > 0) {
                    if ($business_reputation_data > 60) {
                        $business_reputation_data = 60;
                    }
                    $responce['business_reputation'] = $business_reputation_data;
                }

     

                $career_progression_data = (
                    $career_progression_compType +
                    $career_progression_EmpHeadCount +
                    $career_progression_FoundedYear +
                    $career_progression_AvgStay +
                    $career_progression_UserExpGap
                );
                if ($career_progression_data > 0) {
                    if ($career_progression_data > 60) {
                        $career_progression_data = 60;
                    }
                    $responce['career_progression'] = $career_progression_data;
                }

                $company_culture_data = (
                    $company_culture_compType +
                    $company_culture_EmpHeadCount +
                    $company_culture_FoundedYear +
                    $company_culture_Revenue +
                    $company_culture_JobCountryCheck
                );
                if ($company_culture_data > 0) {
                    if ($company_culture_data > 60) {
                        $company_culture_data = 60;
                    }
                    $responce['company_culture'] = $company_culture_data;
                }
         
                $change_stability_data = (
                    $change_stability_compType +
                    $change_stability_EmpHeadCount +
                    $change_stability_AvgStay +
                    $change_stability_Revenue +
                    $change_stability_EduCountryCheck
                );
                if ($change_stability_data > 0) {
                    if ($change_stability_data > 60) {
                        $change_stability_data = 60;
                    }
                    $responce['change_stability'] = $change_stability_data;
                }

            
                $innovation_technology_data = (
                    $innovation_technology_compType +
                    $innovation_technology_EmpHeadCount +
                    $innovation_technology_FoundedYear +
                    $innovation_technology_Revenue +
                    $innovation_technology_EduCountryCheck
                );
                if ($innovation_technology_data > 0) {
                    if ($innovation_technology_data > 60) {
                        $innovation_technology_data = 60;
                    }
                    $responce['innovation_technology'] = $innovation_technology_data;
                }

       
                $job_satisfaction_data = (
                    $job_satisfaction_compType +
                    $job_satisfaction_EmpHeadCount +
                    $job_satisfaction_Revenue +
                    $job_satisfaction_FoundedYear +
                    $job_satisfaction_AvgStay +
                    $job_satisfaction_UserExp
                );

                if ($job_satisfaction_data > 0) {
                    if ($job_satisfaction_data > 60) {
                        $job_satisfaction_data = 60;
                    }
                    $responce['job_satisfaction'] = $job_satisfaction_data;
                }

        
                $remuneration_data = (
                    $remuneration_compType +
                    $remuneration_EmpHeadCount +
                    $remuneration_Revenue +
                    $remuneration_AvgStay +
                    $remuneration_UserExp
                );
                if ($remuneration_data > 0) {
                    if ($remuneration_data > 60) {
                        $remuneration_data = 60;
                    }
                    $responce['remuneration'] = $remuneration_data;
                }
            
                $team_people_data = (
                    $team_people_compType +
                    $team_people_EmpHeadCount +
                    $team_people_Revenue +
                    $team_people_AvgStay +
                    $team_people_UserExp
                );
                if ($team_people_data > 0) {
                    if ($team_people_data > 60) {
                        $team_people_data = 60;
                    }
                    $responce['team_people'] = $team_people_data;
                }

               
                $globalization_data = (
                    $globalization_compType +
                    $globalization_EmpHeadCount +
                    $globalization_Revenue +
                    $globalization_FoundedYear +
                    $globalization_JobCountryCheck
                );
                if ($globalization_data > 0) {
                    if ($globalization_data > 60) {
                        $globalization_data = 60;
                    }
                    $responce['globalization'] = $globalization_data;
                }

            } else {
                $responce = [];
            }

          

            if (count($responce) > 0) {
                $responce['candidate_id'] = $id;
                $responce['ip'] = $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);
                $employee_spectrum = TalentMine::create($responce);
                unset($responce['candidate_id']);
                unset($responce['ip']);
            }
        } else {
            $oldTalemtMone = $candidateDetails->getTalentMine->first();
         
            $responce = array(
                'balance_well_being' => $oldTalemtMone->balance_well_being,
                'benefits_perks' => $oldTalemtMone->benefits_perks,
                'business_reputation' => $oldTalemtMone->business_reputation,
                'career_progression' => $oldTalemtMone->career_progression,
                'company_culture' => $oldTalemtMone->company_culture,
                'change_stability' => $oldTalemtMone->change_stability,
                'diversity_inclusion' => $oldTalemtMone->diversity_inclusion,
                'environmental_social_governance' => $oldTalemtMone->environmental_social_governance,
                'innovation_technology' => $oldTalemtMone->innovation_technology,
                'job_satisfaction' => $oldTalemtMone->job_satisfaction,
                'remuneration' => $oldTalemtMone->remuneration,
                'team_people' => $oldTalemtMone->team_people,
                'globalization' => $oldTalemtMone->globalization,
            );
        }
       
        $returnData = array();
        if (count($responce) > 0) {
            foreach ($responce as $list => $value) {
                $localItem = array();
                $localItem['color'] = '';
                $localItem['img'] = '';
                $localItem['img_path'] = '';
                $localItem['name'] = $list;
                $localItem['alias'] = $list;
                $localItem['value'] = $value;
                if (isset($value) && $value != '') {
                    switch (true) {
                        case in_array($value, range(0, 48)):
                            $localItem['color'] = '#FFF';
                            break;
                        case in_array($value, range(48, 59)):
                            $localItem['color'] = '#f1c232';
                            break;
                        case in_array($value, range(60, 100)):
                            $localItem['color'] = '#38761d';
                            break;
                    }
                }
                $imageColor = $localItem['color'];
                
                $localItem['name'] = ucwords(str_replace('_', ' ', $list));
                $descriptionValue = ($value > 70) ? 'Excellent' : 'Satisfactory  ';

                switch ($list) {
                    case 'balance_well_being':
                        $localItem['img_path'] = 'hx_tm_balance_well_being.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;
                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . ' can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. With this the resource is inclined towards the health of both physical and psychological health and works out to keep it vibrant within the team. ';
                                break;
                            case in_array($value, range(60, 100)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . '  can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This shows that the resource can understand the importance of both physical and psychological health in the workplace which will be supporting to elevate the well-being within the team.';
                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M580.449,1240.766c-3.711-3.716-6.377-14.331-6.377-23.892c0-13.809-3.184-19.116-15.928-25.493
        c-21.23-10.62-37.168-37.7-37.168-61.064c0-29.741,15.4-48.33,56.289-69.033c39.834-20.713,48.32-33.989,26.025-42.49
        c-9.561-3.716-19.658-3.184-36.113,2.656c-30.801,10.625-33.447,10.093-40.889-7.427c-10.615-25.498-5.313-38.77,18.584-47.793
        c11.68-4.258,23.896-11.685,27.617-16.47c7.959-10.62,18.047-1.06,14.336,13.813c-2.129,7.427-10.088,12.739-26.553,16.987
        c-23.896,6.372-26.543,9.028-18.594,21.772c3.711,5.85,7.988,5.85,22.842,0.527c25.488-9.556,56.289-3.179,63.73,13.281
        c10.625,23.901,1.582,38.237-37.178,57.886c-44.072,22.3-49.922,29.204-50.986,56.821c-0.518,18.052,2.656,24.424,16.992,37.168
        c9.561,8.496,20.723,15.4,24.971,15.4c5.84,0,7.959,5.84,7.959,21.24c0,17.524,1.592,21.245,10.098,21.245
        c8.486,0,10.615-4.253,12.207-19.648c1.592-17.524,3.721-20.186,20.186-24.429c22.822-5.845,22.295-5.313,18.057-16.465
        c-2.666-6.899-6.914-8.491-20.195-5.303c-40.352,9.023-61.592,0.522-61.592-24.434c0-16.992,10.098-27.085,43.545-41.948
        c30.801-13.809,46.719-33.462,46.719-57.358c0-24.951-7.422-36.636-32.91-52.568c-15.928-10.088-19.658-15.4-15.4-19.648
        c4.775-4.78,11.152-3.716,25.488,4.248c28.672,15.933,41.426,36.108,41.426,66.377c0,34.517-12.754,50.981-57.363,74.351
        c-19.639,10.083-35.576,21.772-35.576,25.488c0,11.147,15.938,13.804,41.426,6.899c27.607-7.432,35.576-3.188,41.416,22.305
        c2.646,13.271,1.064,18.057-8.506,26.021c-6.377,5.308-16.445,9.561-21.768,9.561c-7.949,0-10.088,3.716-10.088,17.524
        c0,9.561-2.656,20.176-6.367,23.892C612.842,1248.735,588.418,1248.735,580.449,1240.766z"/>
    <path fill="#2c303b" d="M54.731,1138.808c-27.612-14.868-40.352-53.101-27.085-79.121c9.556-18.057,91.343-99.302,100.371-99.302
        s90.801,81.245,100.361,99.302c26.025,50.977-32.397,105.674-84.434,78.589c-13.271-6.899-16.997-6.899-30.269,0
        C95.625,1147.842,71.196,1148.369,54.731,1138.808z M116.328,1113.32l11.689-11.147l12.212,11.147
        c6.904,6.372,19.648,13.271,29.204,14.868c13.804,2.661,19.116,0.532,33.457-13.271c24.951-25.493,19.644-41.426-32.393-93.467
        l-42.48-42.48l-41.953,41.958c-23.369,22.832-43.013,47.256-44.604,54.155c-3.188,16.997,9.556,44.077,23.892,49.927
        C81.279,1131.377,101.465,1126.592,116.328,1113.32z"/>
    <path fill="#2c303b" d="M343.086,1025.698c-40.889-10.62-62.134-56.289-43.022-92.925c7.441-14.346,7.441-14.863-5.308-18.057
        c-6.904-1.602-38.228-2.129-70.093-1.074c-41.953,1.602-65.317,5.313-88.687,14.351c-49.38,18.589-54.697,19.116-69.565,5.84
        c-26.021-24.956-11.68-46.733,45.674-69.565c52.573-21.24,101.958-32.393,134.878-30.801l27.085,1.592l1.592-54.687
        c1.064-39.834,3.184-53.633,7.964-52.051c4.248,1.064,6.904,21.25,7.969,63.73l1.587,62.139h-46.729
        c-50.977,0-68.501,3.711-130.103,27.07c-41.943,16.465-50.444,24.434-39.824,38.77c5.84,7.432,11.147,6.367,53.633-7.959
        c50.981-18.057,39.297-17.002,228.877-17.002c182.139,0,176.826-0.537,225.684,17.002c39.824,13.799,46.191,14.858,53.105,7.959
        c12.754-12.754,0.537-23.369-50.977-43.545c-40.371-15.918-55.762-19.131-105.674-21.777l-58.428-3.184l0.547-59.473
        c0-32.93,1.592-61.074,3.193-63.203c10.078-9.561,14.863,7.979,14.863,53.115v49.385l44.062,3.174
        c23.906,2.139,54.18,6.914,67.441,11.162c41.963,12.744,92.939,35.576,99.307,44.6c11.689,14.883,8.506,37.178-6.904,47.266
        c-13.271,8.496-15.4,8.496-57.344-6.899c-38.77-13.813-49.395-15.405-106.738-15.405c-60.537,0-63.73,0.537-62.139,10.625
        c10.088,57.349,2.656,76.992-32.383,93.462C363.799,1029.424,360.596,1029.951,343.086,1025.698z M383.437,1002.861
        c15.41-8.491,27.09-35.571,23.369-53.628c-6.377-29.204-44.609-45.669-72.222-31.323c-15.4,8.486-27.08,35.571-23.364,53.628
        C317.593,1000.742,355.83,1017.207,383.437,1002.861z"/>
    <path fill="#2c303b" d="M160.405,723.545c-19.121-7.969-29.199-29.209-24.429-50.449c5.308-24.424,20.186-32.402,73.286-39.824
        c65.317-9.57,78.057-9.033,78.057,0.527c0,4.238-3.184,7.959-6.367,7.959c-3.721,0-30.801,3.721-60.005,7.979
        c-56.289,7.969-73.813,18.057-67.974,39.824c5.84,22.295,14.863,23.896,72.217,13.809c66.382-12.217,79.131-12.754,81.782-4.775
        c2.656,7.432-2.124,8.486-76.47,22.295C184.839,728.848,174.214,729.385,160.405,723.545z"/>
    <path fill="#2c303b" d="M429.639,710.273c-56.826-10.615-108.862-22.305-114.697-25.488c-23.901-12.744-21.245-53.643,3.711-66.914
        c14.341-7.432,25.488-6.367,124.795,6.904c96.123,13.262,110.986,16.465,122.666,27.607c23.896,22.314,11.689,69.561-20.176,75.42
        C539.033,729.385,487.002,721.426,429.639,710.273z M554.971,702.314c10.088-10.098,10.615-23.379,1.582-36.133
        c-5.303-6.895-27.607-11.67-101.963-21.768c-117.881-16.465-127.974-16.465-135.405-2.656c-12.212,22.842-1.06,28.145,99.302,48.33
        C526.826,712.393,543.818,713.984,554.971,702.314z"/>
</g>
</svg>';
                        break;
                    case 'benefits_perks':
                        $localItem['img_path'] = 'hx_tm_benefits_perks.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . 'as per the inputs given in the resume. This result plays an important role for this resource to opt any role in the company and seems to be inclined for any discussions.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . ' as per the inputs. Whereas this result denotes that this factor shows predominant effect besides other factors, while being negotiable and flexible.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M120.85,5043.911c-3.887-4.897-3.638-14.683,0.503-18.687c1.631-1.768,4.268-3.145,5.645-3.145
        s4.014,1.377,5.645,3.145c6.65,6.514,2.764,21.948-5.645,21.948C124.614,5047.172,122.48,5046.044,120.85,5043.911z"/>
    <path fill="#2c303b" d="M518.037,5044.541c-3.887-2.261-6.025-9.033-4.512-13.555c1.494-4.141,6.641-7.651,11.152-7.651
        c4.395,0,10.039,6.65,10.039,11.67C534.717,5042.778,524.805,5048.427,518.037,5044.541z"/>
    <path fill="#2c303b" d="M291.216,5032.114c-25.469-4.014-45.288-22.075-51.812-47.295c-4.893-18.691,0.122-40.898,12.422-55.195
        c2.378-2.891,4.385-5.518,4.385-5.898c0-0.376-27.349-0.757-60.845-0.757c-59.214,0-60.967-0.117-63.35-2.505
        c-2.388-2.378-2.505-4.141-2.505-44.536s0.117-42.153,2.505-44.531c2.383-2.388,4.136-2.51,26.343-2.51h23.833v-80.166
        c0-79.16,0-80.166,2.637-83.428c3.516-4.512,10.039-4.512,13.55,0c2.637,3.262,2.637,4.268,2.637,83.555v80.039h56.45l56.455-0.127
        v-55.078c0-38.262,0.376-56.074,1.382-58.203c2.886-6.406,12.92-6.904,16.06-0.879c0.874,1.621,1.377,21.328,1.377,58.33v55.957
        h28.228h28.232v-60.84c0-59.219,0.127-60.977,2.5-63.359c3.135-3.145,10.156-3.262,12.93-0.254
        c1.875,2.012,2.129,8.779,2.373,63.105l0.381,60.718l56.826,0.376l56.709,0.376v-92.085v-92.08l2.891-2.627
        c3.633-3.389,8.398-3.516,12.295-0.381l2.998,2.373l0.381,92.344l0.244,92.334h23.594c23.076,0,23.711,0.122,26.348,2.881
        c2.754,2.886,2.754,3.516,2.754,44.287c0,40.02-0.117,41.523-2.51,44.165l-2.627,2.749H525.81h-61.475l4.893,6.03
        c21.709,25.972,19.443,63.096-5.02,86.812c-3.008,2.886-9.902,7.402-15.43,10.156c-29.355,14.434-66.484,6.03-84.805-19.189
        l-3.379-4.766l-2.51,4.014c-6.025,9.785-19.702,19.565-32.373,23.584C316.426,5032.373,300.752,5033.627,291.216,5032.114z
         M325.591,5010.288c9.282-4.517,19.946-16.06,23.081-24.844c1.885-5.64,2.256-10.659,2.256-33.618v-26.968l-22.583-0.254
        c-37.759-0.498-47.793,1.885-59.839,14.302c-8.652,8.906-12.544,18.071-12.544,30.239c0,20.952,11.919,37.129,31.992,43.652
        c3.511,1.133,9.531,1.631,17.939,1.382C316.685,5013.798,319.692,5013.173,325.591,5010.288z M439.375,5010.537
        c9.785-4.512,16.436-10.781,21.328-20.073c3.633-6.772,4.385-9.404,4.766-18.564c0.625-13.667-2.393-22.207-11.035-31.738
        c-8.789-9.531-16.309-13.296-29.727-14.683c-12.559-1.255-45.674-1.499-50.938-0.498l-3.516,0.757l0.371,27.72
        c0.371,26.973,0.508,28.101,3.633,34.751c5.4,11.416,16.943,21.455,28.486,24.717c3.506,0.874,10.654,1.504,17.803,1.255
        C430.205,5013.93,433.73,5013.173,439.375,5010.537z M288.203,4875.927v-28.853h-70.254h-70.254l-0.371,27.598
        c-0.127,15.181,0,28.228,0.371,29.106c0.376,1.382,14.551,1.631,70.503,1.382l70.005-0.376V4875.927z M414.912,4875.927v-28.853
        l-54.199-0.376l-54.316-0.249v29.478v29.482l54.316-0.249l54.199-0.376V4875.927z M573.603,4875.927v-29.351l-69.873,0.244
        l-70,0.254l-0.381,27.598c-0.117,15.181,0,28.228,0.254,29.106c0.498,1.255,15.059,1.631,70.371,1.631h69.629V4875.927z"/>
    <path fill="#2c303b" d="M599.951,5029.609c-1.875-1.885-2.51-4.141-2.51-8.906c0-7.026,1.377-10.415,5.02-12.422
        c6.279-3.384,12.549,2.764,12.549,12.295C615.01,5030.366,605.977,5035.625,599.951,5029.609z"/>
    <path fill="#2c303b" d="M89.487,5012.548c-3.262-4.141-3.389-7.275-0.127-10.537c2.007-2.012,4.141-2.51,10.41-2.51
        c9.033,0,12.173,2.134,12.173,7.9c0,5.771-4.014,8.408-12.422,8.408C92.998,5015.81,91.743,5015.429,89.487,5012.548z"/>
    <path fill="#2c303b" d="M144.561,5013.3c-3.135-3.135-3.262-8.906-0.249-11.665c3.135-2.891,16.812-3.013,19.565-0.249
        c3.267,3.384,3.643,7.021,1.133,10.532c-2.134,2.759-3.638,3.267-10.161,3.638C148.452,5015.81,146.694,5015.429,144.561,5013.3z"
        />
    <path fill="' . $imageColor . '" d="M568.584,4998.247c-1.377-1.377-2.51-3.887-2.51-5.645c0-5.522,4.023-8.159,12.559-8.159
        c8.525,0,12.539,2.637,12.539,8.159s-4.014,8.154-12.539,8.154C572.734,5000.756,570.596,5000.253,568.584,4998.247z"/>
    <path fill="#2c303b" d="M623.408,4998.5c-2.754-3.145-2.637-9.414,0.127-11.924c1.631-1.504,4.648-2.134,9.912-2.134
        c8.408,0,12.041,2.388,12.041,8.159c0,5.767-3.633,8.154-12.285,8.154C627.295,5000.756,624.922,5000.253,623.408,4998.5z"/>
    <path fill="#2c303b" d="M123.735,4991.718c-4.263-2.256-5.518-5.02-5.518-11.914c0-7.778,2.886-11.665,8.779-11.665
        c5.522,0,8.784,4.263,8.784,11.665c0,3.262-0.503,7.148-1.255,8.403C132.895,4991.347,126.87,4993.349,123.735,4991.718z"/>
    <path fill="#2c303b" d="M600.586,4975.039c-2.637-2.51-3.145-4.268-3.145-10.034c0-8.027,2.764-11.924,8.652-11.924
        c10.039,0,12.432,19.448,3.018,23.711C604.844,4978.803,603.965,4978.549,600.586,4975.039z"/>
    <path fill="#2c303b" d="M69.16,4923.603c-4.009-2.266-6.519-7.905-5.391-12.422c1.006-4.39,6.147-8.281,10.786-8.281
        c5.024,0,11.04,6.025,11.04,11.167C85.596,4921.972,76.064,4927.49,69.16,4923.603z"/>
    <path fill="#2c303b" d="M620.273,4778.701c-6.025-5.645-4.883-14.307,2.383-17.939c5.771-2.764,11.67-0.996,14.434,4.395
        C642.49,4775.566,628.809,4786.611,620.273,4778.701z"/>
    <path fill="#2c303b" d="M290.713,4688.75c-14.678-4.766-50.181-23.33-90.83-47.295l-35.625-21.074l-57.329,20.322
        c-62.1,21.963-62.729,22.08-65.869,14.688c-2.886-7.031-0.498-10.283,10.415-14.434c25.215-9.658,111.401-39.521,113.911-39.385
        c1.631,0,20.073,10.039,40.894,22.324c41.03,24.082,76.025,42.656,88.447,46.787c4.644,1.641,11.04,2.637,15.684,2.637
        c15.43-0.127,128.594-12.295,132.48-14.297c8.398-4.258,12.793-13.428,11.035-22.832c-1.133-5.898-9.15-13.926-15.176-15.059
        c-2.764-0.498-25.469,1.387-55.703,4.521c-55.825,5.762-57.71,5.645-66.362-0.879c-9.287-7.031-12.295-21.709-6.655-32.744
        c3.14-6.143,11.67-12.168,18.691-13.291c14.561-2.266,148.672-14.688,153.936-14.18c5.264,0.371,15.674,5.508,63.975,30.986
        c85.566,45.039,78.535,42.031,86.689,38.135c7.148-3.389,10.166-13.174,6.66-21.074c-1.143-2.256-21.836-16.191-68.75-46.045
        c-37.012-23.584-69.502-43.906-72.275-45.156c-2.754-1.133-10.908-3.135-18.184-4.268c-22.207-3.643-80.791-14.063-134.106-23.838
        c-38.135-7.148-53.193-9.414-61.475-9.414c-10.034,0-19.946,2.266-122.065,27.598c-61.094,15.186-112.778,27.598-114.785,27.598
        c-7.529,0-11.421-10.4-5.645-15.176c1.753-1.377,45.156-12.666,115.288-30.234l112.656-27.969h15.059
        c13.672,0.117,21.323,1.25,80.288,12.285c35.869,6.65,78.789,14.434,95.352,17.188c36.377,6.152,41.26,7.158,47.285,10.176
        c2.637,1.377,34.502,21.318,70.879,44.531c71.006,45.156,75.4,48.418,78.789,59.961c2.383,7.9,2.383,12.422,0,20.322
        c-2.393,8.281-9.17,15.938-17.559,19.951c-5.908,3.008-8.037,3.389-15.938,2.881l-9.16-0.371l-66.494-35
        c-58.965-31.113-67.109-35-71.885-34.873c-2.881,0.117-37.393,3.379-76.523,7.148c-76.274,7.529-75.518,7.393-75.518,14.414
        c0,4.404,3.506,7.529,8.525,7.529c2.261,0,25.977-2.246,52.822-5.02c40.273-4.258,49.805-4.883,54.824-3.76
        c18.809,4.268,30.986,19.199,30.986,38.008c0,16.445-11.67,32.119-27.354,36.631c-6.768,1.885-127.207,14.443-137.876,14.307
        C303.633,4692.011,296.23,4690.507,290.713,4688.75z"/>
</g>
</svg>
';
                        break;
                    case 'business_reputation':
                        $localItem['img_path'] = 'hx_tm_business_reputation.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. Whereas, this resource is unique and looking for a matured environments to continue career with profoundness.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. This component is been a vital criteria considering the earlier companies and career which is been chosen by this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M416.699,1263.086c-9.219-9.214-9.219-10.298,0.547-20.059c9.756-9.761,9.756-9.761,16.27,0.542
        c4.873,8.135,4.873,12.471-0.547,19.517C426.455,1272.309,425.381,1272.309,416.699,1263.086z"/>
    <path fill="#70BF44" d="M481.23,1214.282c-8.672-9.219-9.219-11.387-2.178-16.812c4.355-3.794,8.691-8.672,9.766-11.929
        c1.084-2.71,7.598,0,13.564,6.514l11.924,11.929l-11.924,10.298C490.996,1224.59,490.996,1224.59,481.23,1214.282z"/>
    <path fill="#2c303b" d="M332.642,1203.437c-46.089-11.929-54.229-79.175-12.466-103.579c24.941-15.181,47.178-11.929,68.32,9.224
        c14.648,14.644,18.438,22.773,18.438,40.127C406.934,1188.252,371.699,1213.745,332.642,1203.437z M374.941,1117.759
        c-7.051-5.967-17.896-10.845-24.941-10.845s-17.896,4.878-24.941,10.845l-13.018,10.303H350h37.959L374.941,1117.759z"/>
    <path fill="#2c303b" d="M452.49,1135.112c-8.672-13.555,3.252-23.862,15.732-14.644c8.672,5.967,8.672,7.046-0.547,15.186
        C459.004,1143.784,457.373,1143.784,452.49,1135.112z"/>
    <path fill="#2c303b" d="M263.232,1065.693c-29.282-15.181-78.633-69.409-78.633-86.758c0-8.14,78.096-103.037,87.314-106.299
        c5.42-1.621,0.537-90.01-9.219-173.525l-3.262-26.035h32.539h32.544l3.252,28.75c1.631,15.176,4.336,47.715,5.967,71.582
        c4.883,66.152,8.125,84.062,16.265,84.062s11.387-19.004,16.27-89.492c1.621-26.582,4.336-59.102,6.504-72.109l2.715-22.793h31.992
        h32.529l-3.242,26.035c-9.766,91.094-14.102,171.904-8.682,173.525c7.588,2.715,87.314,98.159,87.314,104.663
        c0,10.313-26.035,46.099-48.271,66.167c-26.025,23.315-42.295,30.908-68.32,30.908h-18.438l1.084-39.585
        c0.537-41.763-5.42-63.447-13.018-43.936c-2.168,5.43-4.346,19.531-4.346,30.918c-0.537,17.891-2.158,20.063-14.092,20.063
        c-11.929,0-13.555-2.173-14.102-20.063c0-11.387-2.163-25.488-4.336-30.918c-7.593-19.512-14.106,2.72-13.013,44.473l1.079,39.048
        h-20.063C288.716,1074.375,272.451,1070.576,263.232,1065.693z M276.787,976.763v-49.346l-15.186,17.896
        c-32.529,39.043-31.992,35.254-9.214,58.564c11.934,11.929,21.689,21.694,22.773,21.694
        C276.25,1025.571,276.787,1003.33,276.787,976.763z M447.607,1003.877c22.773-23.311,23.32-19.521-8.672-58.027
        c-14.102-16.27-14.639-16.802-17.9-5.42c-4.883,17.896-3.789,85.142,1.084,85.142
        C424.297,1025.571,435.674,1015.806,447.607,1003.877z"/>
    <path fill="#2c303b" d="M338.618,1066.24c-2.173-4.883-1.094-11.392,2.163-14.648c8.125-8.125,23.857-0.532,21.699,10.313
        C360.303,1074.375,342.954,1077.632,338.618,1066.24z"/>
    <path fill="#2c303b" d="M124.946,689.893c0-2.168,4.883-10.84,11.392-18.984l11.387-14.629l-14.644-18.438l-14.097-18.984h32.539
        H184.6v27.109v27.109h18.979c15.186,0,18.979,2.168,18.979,10.859c0,10.293-3.794,10.84-48.804,10.84
        C146.645,694.775,124.946,692.607,124.946,689.893z"/>
    <path fill="#2c303b" d="M477.441,683.935c0-8.691,3.789-10.859,18.975-10.859H515.4v-27.109v-27.109h33.076h32.539l-14.102,18.984
        l-14.648,18.438l11.396,14.629c6.504,8.145,11.387,16.816,11.387,18.984c0,2.715-21.699,4.883-48.809,4.883
        C481.23,694.775,477.441,694.228,477.441,683.935z"/>
    <path fill="#2c303b" d="M190.024,632.412v-35.254H350h159.971v35.254v35.234H350H190.024V632.412z M267.568,625.361
        c-3.247-12.461-21.689-12.461-24.941,0c-3.257,11.934,11.929,22.227,21.147,14.648
        C267.568,637.295,269.194,630.244,267.568,625.361z M313.667,639.463c6.509-9.219,0.547-23.32-9.766-23.32
        c-4.336,0-9.756,3.789-11.382,8.125c-3.804,8.145,3.789,21.699,11.382,21.699C306.074,645.967,310.41,642.725,313.667,639.463z
         M363.555,627.529c0-8.672-3.252-11.387-13.555-11.387c-10.313,0-13.555,2.715-13.555,11.934c0,6.504,3.242,12.461,7.046,14.102
        C354.883,645.967,363.555,640.01,363.555,627.529z M405.859,639.463c6.504-9.219,0.537-23.32-9.766-23.32
        c-4.346,0-9.756,3.789-11.387,8.125c-3.789,8.145,3.789,21.699,11.387,21.699C398.262,645.967,402.598,642.725,405.859,639.463z
         M457.92,625.908c-3.252-13.008-27.656-14.648-26.582-2.168c0,4.883,2.178,11.914,4.883,15.723
        C442.187,649.209,460.625,637.842,457.92,625.908z"/>
</g>
</svg>';
                        break;
                    case 'career_progression':

                        $localItem['img_path'] = 'hx_tm_career_rogression.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. The career progression for this resource is deemed to be attaining the closeness towards to the fulfilment and hence it is satisfactory.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. This attribute for this resource sees towards the ultimate professional goals, step by step. The progression of this resource is non-vulnerable and is followed in order to reach the goal.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'company_culture':
                        $localItem['img_path'] = 'hx_tm_company_culture.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource can become a fit and get accustomed with the company cultural practices in time as per the earlier companies and hence deemed as a good fit. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource is been into similar company environments earlier and should be an appropriate cultural fit as per the defined policies, processes and cultural practices as per the company.';

                                break;
                        }
                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M25.052,14.046c1.584,5.316,4.274,7.801,8.519,7.936
        c2.337,0.074,4.374-0.711,6.094-2.272c1.713-1.554,2.543-3.582,2.855-5.844c2.295,0.763,3.66,2.43,3.676,4.663
        c0.043,6.099,0.043,12.197,0,18.295c-0.016,2.374-1.256,3.955-3.09,4.246c-1.096,0.175-1.658-0.148-1.705-1.367
        c-0.102-2.621-0.25-5.244-0.477-7.857c-0.361-4.128-3.143-6.699-7.314-6.824c-2.753-0.083-5.519,0.011-8.258-0.227
        c-2.272-0.197-3.528-1.533-3.811-3.794c-0.151-1.214-0.115-2.502,0.119-3.7C22.006,15.543,23.186,14.448,25.052,14.046z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M17.948,61.804c3.734-3.795,4.531-7.516,2.43-11.352
        c-2.042-3.728-5.59-4.946-10.966-3.765c-0.943-1.188-1.028-2.439,0.095-3.676c0.874-0.962,1.977-1.771,3.103-2.438
        c4.702-2.781,9.446-5.495,14.187-8.211c2.262-1.296,3.959-1.164,5.329,0.34c0.957,1.052,0.932,1.404-0.239,2.188
        c-2.031,1.358-4.087,2.68-6.116,4.042c-3.838,2.578-4.773,6.647-2.467,10.694c1.011,1.773,2.046,3.532,3.074,5.296
        c1.868,3.206,1.266,5.494-1.948,7.337c-0.576,0.33-1.157,0.672-1.772,0.914C21.089,63.791,18.835,63.432,17.948,61.804z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M60.823,44.183c-5.352-1.4-8.875-0.182-11.281,3.891
        c-2.033,3.442-1.1,7.292,2.766,11.392c-1.84,1.604-3.883,1.886-5.873,0.751c-5.252-2.994-10.501-5.995-15.737-9.02
        c-1.616-0.934-2.613-2.278-2.361-4.263c0.188-1.484,0.903-1.954,2.199-1.355c2.094,0.967,4.194,1.935,6.208,3.051
        c4.003,2.22,7.632,1.504,10.21-2.272c1.301-1.902,2.422-3.93,3.57-5.933c1.029-1.799,2.316-3.312,4.572-3.077
        c2.393,0.248,4.4,1.396,5.66,3.534C61.37,41.924,61.442,43.069,60.823,44.183z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M57.151,59.835c-4.354-0.032-7.746-3.501-7.688-7.86
        c0.055-4.273,3.389-7.507,7.729-7.497c4.445,0.011,7.752,3.364,7.693,7.802C64.831,56.469,61.353,59.865,57.151,59.835z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M20.552,54.742c-0.013,4.199-3.464,7.641-7.661,7.641
        c-4.304,0-7.761-3.414-7.777-7.679c-0.016-4.195,3.426-7.748,7.54-7.782C17.016,46.886,20.565,50.4,20.552,54.742z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M26.139,13.237c0.047-4.259,3.604-7.729,7.815-7.624
        c4.211,0.104,7.563,3.563,7.538,7.778c-0.025,4.29-3.469,7.69-7.755,7.661C29.479,21.023,26.091,17.538,26.139,13.237z"/>
</g>
</svg>
';
                        break;
                    case 'change_stability':
                        $localItem['img_path'] = 'hx_tm_change_stability.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. The duration worked within each company and the acceptance for the situational changes in the organization is addressed well and accustomed by this resource.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. Considering the employment stay in each company and the balanced growth in experience show this resource is stable. Also, as per the movement between roles or responsibilities proves the inclination to changes. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,224.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M304.404,2189.38c-30.679-4.971-53.77-11.689-79.482-23.672c-90.586-41.787-152.241-120.684-173.569-222.08
        c-5.259-24.834-4.38-88.54,1.46-115.415c20.459-92.627,79.194-168.896,161.011-209.521
        c104.316-52.002,223.247-41.191,317.622,28.643c51.436,38.281,92.344,99.648,110.742,166.27
        c6.143,21.904,7.021,30.967,6.729,77.422c-0.293,48.516-0.879,54.653-8.193,78.911c-10.508,35.352-26.289,68.662-44.697,94.38
        c-8.486,11.685-15.498,22.212-15.498,23.374c0,1.172,16.084,18.115,35.664,37.695l35.938,35.942h-91.455h-91.182v-91.172v-91.46
        l31.562,31.558c17.236,17.246,32.734,31.27,34.482,31.27c4.971,0,26.592-34.482,36.23-57.856
        c14.033-33.022,18.418-56.694,18.418-95.562c0-26.289-1.758-40.898-6.436-58.438c-21.924-82.393-79.189-143.174-161.006-171.514
        c-26.592-9.063-29.805-9.355-71.587-9.648c-37.114,0-47.344,1.172-66.626,6.719c-44.116,12.568-82.69,36.523-113.667,70.713
        c-80.068,87.666-85.024,218.281-12.271,312.949c25.132,32.729,62.529,60.786,100.518,75.396
        c24.834,9.639,61.074,17.822,78.896,17.822h11.982l-0.879,30.098l-0.874,29.805l-10.229,0.586
        C332.456,2192.885,317.261,2191.421,304.404,2189.38z"/>
    <path fill="#2c303b" d="M319.893,2066.362c-39.741-15.2-62.822-49.971-60.195-91.46c4.38-75.391,92.334-111.914,149.307-61.655
        c20.176,17.524,29.814,39.443,29.521,66.909c0,35.649-17.822,65.161-49.092,80.942
        C371.016,2070.449,337.129,2073.081,319.893,2066.362z"/>
    <path fill="#2c303b" d="M306.45,1825.293c-21.621-4.102-49.38-13.74-66.621-23.672c-18.12-10.234-42.08-30.967-42.08-36.24
        c0-6.123,34.771-35.938,55.518-47.617c56.104-31.563,127.7-33.018,183.804-4.092c21.328,11.094,45.869,30.098,58.73,45.283
        l7.012,8.77l-14.326,12.861c-16.943,14.902-53.77,33.896-78.887,40.605C388.848,1826.748,328.369,1829.082,306.45,1825.293z"/>
</g>
</svg>
';
                        break;

                    case 'innovation_technology':
                        $localItem['img_path'] = 'hx_tm_innovation_technology.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Being in an advanced environment it is evident that this resource is supporting the project besides possessing creative thought process to support the new and upcoming technologies as and when the projects demands. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Capable to contemplate and get adapted to work in the new technologies so as to support the project, besides planning for the trainings in the upcoming technical skill. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,280.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M350.488,2755.049c0-14.639-1.665-19.653-7.1-21.328c-4.185-1.255-16.313-6.27-27.598-11.289l-19.658-8.784
        l-11.704,11.294c-13.804,13.379-22.163,14.214-31.362,3.76c-9.619-10.454-8.779-17.139,3.345-30.103l10.454-10.879l-12.544-28.433
        c-11.709-25.088-14.219-28.018-24.253-27.598c-20.493,1.675-21.743,0.42-21.743-16.309c0-16.724,0-16.724,17.563-17.979
        c16.724-1.25,17.559-1.675,24.668-23.833c4.18-12.129,9.614-24.673,12.124-27.603c2.93-3.34,0.84-7.939-6.27-14.634
        c-12.544-11.704-13.384-21.323-2.93-30.527c10.459-9.614,18.818-8.779,29.692,2.93l9.619,10.034l13.379-7.944
        c7.109-4.6,20.073-10.039,28.848-12.544c14.639-3.765,15.469-5.02,15.469-20.493c0-16.724,0-16.724,16.738-16.724
        c16.719,0,19.219,2.93,17.129,20.073c-1.25,7.944,7.539,17.563,15.488,17.563c3.75,0,14.629,4.18,24.668,8.779l18.398,8.779
        l9.609-8.779c11.289-10.869,20.078-11.289,28.848-1.255c9.629,10.874,8.789,18.818-2.93,29.688
        c-9.609,9.204-10.02,10.454-3.75,19.658c3.34,5.435,8.789,17.979,11.719,27.598c4.59,17.139,5.84,17.983,22.578,19.233
        c17.129,1.255,17.129,1.675,17.129,17.979c0,16.729-1.23,17.983-21.738,16.309c-10.039-0.42-12.539,2.51-24.258,27.598
        l-12.539,28.433l10.449,10.879c12.559,12.964,13.379,21.323,2.93,30.522c-10.859,9.619-17.148,8.779-30.527-3.765l-11.699-11.284
        l-15.469,7.524c-8.789,4.18-20.488,8.779-26.348,10.454c-9.629,2.51-10.879,5.02-11.289,21.323l-0.43,18.398l-17.139,1.255
        l-17.568,1.255V2755.049z M402.773,2694.834c46.816-21.328,67.734-71.924,48.496-115.83
        c-17.559-39.307-43.066-55.615-86.563-56.035c-22.158,0-28.428,2.095-45.991,13.799c-28.018,18.403-41.396,43.491-40.977,76.108
        c0.415,28.433,7.104,43.901,27.598,63.56C332.515,2702.778,370.156,2709.887,402.773,2694.834z"/>
    <path fill="#2c303b" d="M346.313,2674.76c-3.345-1.255-11.709-6.27-17.979-10.869l-11.709-7.949l9.619-5.015
        c7.524-4.185,11.284-4.185,17.979,0.415c4.6,2.925,15.054,5.435,23.413,5.435c18.809,0,41.406-17.139,41.406-30.942
        c0-5.02,2.93-13.379,6.68-18.813l6.699-9.619l7.52,11.289c7.539,11.294,7.129,11.709-3.77,30.522
        c-5.84,10.459-15.879,22.583-22.148,27.183C392.734,2674.76,358.437,2679.78,346.313,2674.76z"/>
    <path fill="#2c303b" d="M302.412,2610.781c-3.77-6.689-4.604-12.544-2.51-12.544c2.085,0,4.595-4.18,6.27-9.614
        c1.255-5.02,8.779-15.894,17.144-23.838c14.214-13.799,16.724-14.634,43.071-14.634c22.168,0,30.527,1.67,39.316,8.779
        c10.859,8.364,10.859,8.779,2.5,13.799c-6.699,4.185-10.879,3.765-23.008-1.67c-12.539-5.854-17.559-6.274-30.938-2.51
        c-17.144,5.02-28.848,17.983-28.848,31.777c-0.425,8.364-9.204,22.998-13.804,22.998
        C309.932,2623.325,306.172,2617.89,302.412,2610.781z"/>
    <path fill="#2c303b" d="M197.871,2523.388c-24.673-10.034-34.712-43.906-25.093-81.543c4.185-15.479,5.02-26.768,2.51-33.037
        c-2.925-7.109-2.09-13.789,2.095-21.738c2.925-5.859,7.524-18.398,10.034-27.188c2.925-11.289,8.779-18.809,20.908-26.758
        c17.563-11.289,20.068-19.238,11.289-34.707c-8.364-15.059-25.093-25.078-60.635-37.227
        c-32.617-10.449-34.287-11.699-38.052-26.328c-2.09-8.379-5.015-36.367-6.689-61.895l-2.51-47.246h58.54h58.96v16.738
        c0,9.18,0.84,16.699,2.095,16.699c1.25,0,10.034-3.75,18.813-8.34c10.874-5.449,16.729-11.289,16.729-16.738
        c0-7.52,2.93-8.359,29.268-8.359h29.277v32.617c0,30.938,4.595,70.664,10.454,93.672c2.505,9.609,1.25,11.289-11.294,13.809
        c-27.178,5.84-53.525,30.508-53.525,50.176c0,3.34,7.524,10.859,16.729,17.129c10.869,7.539,17.979,15.898,20.908,26.348
        c2.51,8.359,7.944,20.898,11.289,28.008c4.6,9.219,5.439,15.059,2.505,20.508c-2.505,4.16-3.34,19.219-2.085,33.442
        c1.67,25.508,1.67,25.923-10.874,30.942c-10.874,4.6-14.219,4.6-22.578-1.25c-16.729-11.714-31.782-8.369-51.855,11.704
        c-13.799,13.804-18.398,21.328-18.398,31.362C216.685,2527.573,212.925,2529.238,197.871,2523.388z M261.846,2279.179
        c2.51-2.93,2.93-7.52,0.835-10.879c-1.67-3.34-2.51-16.289-1.25-28.848l2.51-23.418l-14.219,8.789
        c-12.129,7.109-14.224,10.449-12.964,21.738c0.415,7.109-0.835,16.738-3.345,21.328c-3.345,6.27-2.51,8.789,2.93,12.129
        C246.797,2285.879,256.831,2285.449,261.846,2279.179z M250.137,2206.426c8.784-5.02,12.964-11.289,14.639-23.008
        c1.67-9.199,1.67-17.559,0.415-18.809c-1.25-1.68-9.199,0.84-17.144,5.43c-13.384,7.109-14.634,9.629-14.634,25.527
        c0,10.02,1.25,17.969,2.51,17.969C237.173,2213.535,243.867,2210.195,250.137,2206.426z"/>
    <path fill="#2c303b" d="M517.754,2514.189c0-10.034-4.609-17.559-18.398-31.362c-20.078-20.073-35.117-23.418-51.836-11.704
        c-21.348,14.629-44.746-10.874-34.707-37.637c2.09-5.439,2.91-17.568,1.66-27.178c-1.25-9.199-0.41-19.238,2.09-22.168
        c2.09-2.93,6.27-13.379,8.789-22.578c3.34-12.969,8.77-20.078,21.309-28.438c17.578-11.719,19.668-16.719,12.148-33.457
        c-7.109-14.629-30.117-29.258-65.664-40.547c-28.008-8.789-30.527-10.449-34.277-24.258c-2.1-8.379-4.189-36.367-4.189-61.895
        v-47.246h56.455h56.445v16.738c0,9.18,1.68,16.699,3.77,16.699c10.02,0,33.867-17.969,33.867-25.488
        c0-7.539,3.77-7.949,58.965-7.949h59.375l-2.93,47.246c-1.68,25.527-4.609,53.516-7.109,61.895
        c-3.75,14.629-5.43,15.879-39.297,26.758c-28.438,9.199-38.887,15.059-50.195,28.008c-19.219,20.918-18.809,29.707,2.09,43.496
        c12.129,8.359,17.988,15.898,21.758,28.438c2.5,9.199,7.52,21.328,10.859,26.758c5.039,7.539,5.039,11.719,0.84,21.738
        c-2.91,7.539-4.18,19.668-2.5,32.207c4.18,29.688-3.34,63.975-16.738,75.684C525.293,2530.913,517.754,2530.083,517.754,2514.189z
         M500.625,2279.179c2.5-3.34,3.34-7.109,1.66-8.359c-1.25-1.68-2.09-14.219-1.66-28.438l0.82-25.488l-13.789,7.93
        c-11.699,7.109-13.809,10.449-12.559,21.738c0.43,7.109-0.84,16.738-2.93,20.918
        C464.238,2281.699,489.746,2292.148,500.625,2279.179z M488.477,2206.426c14.219-9.609,16.738-13.789,16.738-29.277
        c0-15.879-2.93-16.719-20.488-6.25c-11.289,6.25-12.969,9.59-12.969,25.078C471.758,2215.625,473.437,2216.894,488.477,2206.426z
         M576.289,2152.89c0-9.609-1.25-10.43-20.488-10.43c-21.328,0-28.008,4.18-23.809,14.629c1.66,4.59,8.77,6.25,23.398,6.25
        C575.039,2163.34,576.289,2162.519,576.289,2152.89z"/>
</g>
</svg>
';
                        break;
                    case 'job_satisfaction':
                        $localItem['img_path'] = 'hx_tm_jobsatisfaction.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume. Where the average work duration in the earlier companies are considerable with which it can be said that the sustainability of this resource talent is reliable.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume.
                                    Where the period worked for the companies earlier by this resource is admirable, which shows the contentment, satisfaction and acceptance in working with those companies.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'remuneration':
                        $localItem['img_path'] = 'hx_tm_remuneration.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . '  as per the inputs given in the resume. This resource can be considered for this role in view of the remuneration and potentials acquired which are admirable with which the company can foresee the value add in this candidature.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . ' as per the inputs given in the resume.
For this resource the remuneration attribute counts in various other factors while it is not just residing on the monetary, which shows the maturity and reliability to consider this candidature.  ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M13.757,14.409c-2.602,1.371-3.902,3.27-4.113,6.047c-0.352,4.781,2.953,8.438,7.558,8.438
        c4.886-0.035,8.507-4.641,7.453-9.457c-0.703-3.34-4.148-6.012-7.734-6.012C16.183,13.424,14.812,13.846,13.757,14.409z"/>
    <path fill="#2c303b" d="M50.635,13.917c-6.328,2.25-6.891,11.074-0.879,14.098c4.957,2.461,10.546-0.668,11.038-6.152
        c0.176-1.758,0.07-2.355-0.738-3.973C58.298,14.268,54.325,12.617,50.635,13.917z"/>
    <path fill="#2c303b" d="M33.338,25.167c-0.105,0.457-0.843,1.23-1.617,1.758c-2.602,1.723-3.41,3.973-2.25,6.398
        c0.633,1.3,2.355,2.285,5.238,2.988c2.145,0.527,2.637,0.879,2.637,1.934c0,1.441-2.566,2.109-4.008,1.02
        c-0.809-0.598-4.078-0.738-4.078-0.176c0,0.949,1.125,2.355,2.39,3.094c0.809,0.422,1.547,1.09,1.652,1.477
        c0.176,0.563,0.527,0.703,1.969,0.703c1.477,0,1.723-0.105,1.723-0.668c0-0.422,0.598-1.02,1.582-1.582
        c1.863-1.09,2.637-2.426,2.637-4.465c0-2.004-1.582-3.585-4.43-4.324c-2.848-0.773-3.797-1.336-3.938-2.215
        c-0.246-1.758,2.883-2.496,4.078-0.984c0.598,0.738,0.984,0.879,2.496,0.879c1.055,0,1.793-0.141,1.793-0.387
        c0-1.09-1.266-2.848-2.672-3.656c-1.16-0.668-1.547-1.125-1.547-1.758c0-0.809-0.141-0.879-1.723-0.879
        C33.76,24.323,33.514,24.428,33.338,25.167z"/>
    <path fill="#2c303b" d="M11.155,30.616c-2.496,0.633-4.394,2.215-5.695,4.71c-0.492,0.95-1.371,8.333-2.32,19.125L3,56.314h8.542
        c8.507,0,8.578,0,8.578-0.738c0-0.457-0.95-1.758-2.285-3.164c-2.004-2.145-4.043-5.273-4.043-6.258
        c0-0.176,0.422-0.457,0.984-0.668c0.914-0.316,1.02-0.211,2.18,1.758c2.566,4.43,7.523,7.875,12.866,8.965
        c3.41,0.703,4.887,0.422,5.766-1.055c1.652-2.672,0.457-4.5-3.586-5.52c-4.359-1.09-6.609-2.496-8.296-5.203
        c-1.266-2.039-1.617-3.023-2.355-6.469c-0.668-3.235-2.144-5.343-4.429-6.503C15.128,30.581,12.667,30.229,11.155,30.616z"/>
    <path fill="#2c303b" d="M55.45,30.616c-3.796,0.984-5.59,3.27-6.679,8.472c-0.668,3.234-1.863,5.484-3.797,7.277
        c-1.863,1.723-3.059,2.391-5.309,2.953c-1.441,0.352-1.652,0.527-1.477,1.16c0.527,1.828,0.598,3.34,0.281,4.535
        c-0.211,0.703-0.246,1.371-0.07,1.477c0.422,0.246,5.379-1.09,7.102-1.969c0.844-0.387,2.004-1.125,2.637-1.582
        c1.512-1.16,1.863-1.055,1.863,0.457c0,0.738,0.105,1.688,0.21,2.109l0.212,0.809h8.437h8.472l-0.211-2.039
        c-0.105-1.09-0.387-3.973-0.598-6.398c-1.055-12.129-1.16-12.516-2.883-14.589C61.884,31.213,58.017,29.948,55.45,30.616z"/>
</g>
</svg>
';
                        break;
                    case 'team_people':
                        $localItem['img_path'] = 'hx_tm_team_people.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This profile shows the uniqueness in presenting the matured outcome with which the team and the management can easily acknowledge this resource in the company.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. In view of the environment worked by this resource gave consistent exposure which upholds the efficiency on the deliverables with which the company can become a beneficiary. ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M20.375,14.82c0-4.591,3.722-8.313,8.313-8.313c4.59,0,8.313,3.721,8.313,8.313
        c0,4.59-3.722,8.312-8.313,8.312C24.096,23.132,20.375,19.41,20.375,14.82z M32.683,28.795c0.083-1.81,0.706-3.485,1.708-4.87
        c-0.704-0.148-1.431-0.226-2.177-0.226h-7.053c-0.744,0-1.47,0.078-2.17,0.223c1.067,1.48,1.705,3.288,1.715,5.244
        c1.297-0.714,2.785-1.12,4.365-1.12C30.354,28.046,31.574,28.313,32.683,28.795z M34.09,29.541
        c2.414,1.513,4.107,4.075,4.417,7.049c0.983,0.459,2.077,0.725,3.235,0.725c4.23,0,7.657-3.429,7.657-7.659
        s-3.427-7.658-7.657-7.658C37.55,21.998,34.153,25.365,34.09,29.541z M29.072,45.222c4.229,0,7.659-3.429,7.659-7.658
        c0-4.229-3.43-7.658-7.659-7.658c-4.229,0-7.659,3.429-7.659,7.658C21.413,41.793,24.842,45.222,29.072,45.222z M32.32,45.743
        h-6.498c-5.407,0-9.807,4.399-9.807,9.806v7.948l0.021,0.125l0.547,0.17c5.16,1.611,9.643,2.15,13.333,2.15
        c7.206,0,11.384-2.055,11.641-2.187l0.512-0.259h0.054v-7.948C42.125,50.143,37.728,45.743,32.32,45.743z M44.992,37.838h-6.448
        c-0.07,2.58-1.172,4.903-2.914,6.574c4.806,1.429,8.322,5.886,8.322,11.149v2.449c6.367-0.233,10.036-2.038,10.277-2.159
        l0.513-0.261h0.054v-7.949C54.797,42.235,50.397,37.838,44.992,37.838z M46.717,21.834c2.413,1.514,4.106,4.076,4.415,7.049
        c0.984,0.46,2.077,0.725,3.235,0.725c4.231,0,7.66-3.429,7.66-7.658c0-4.23-3.429-7.658-7.66-7.658
        C50.178,14.292,46.779,17.66,46.717,21.834z M57.617,30.131h-6.448c-0.069,2.581-1.17,4.904-2.912,6.574
        c4.807,1.43,8.322,5.886,8.322,11.151v2.449c6.366-0.234,10.036-2.038,10.277-2.16l0.511-0.26h0.056v-7.95
        C67.423,34.53,63.023,30.131,57.617,30.131z M15.634,37.314c1.499,0,2.892-0.438,4.073-1.182c0.375-2.449,1.688-4.589,3.563-6.046
        c0.008-0.144,0.021-0.286,0.021-0.431c0-4.229-3.43-7.658-7.657-7.658c-4.231,0-7.659,3.428-7.659,7.658
        C7.976,33.887,11.403,37.314,15.634,37.314z M22.512,44.412c-1.733-1.662-2.831-3.974-2.912-6.539
        c-0.239-0.018-0.475-0.035-0.719-0.035h-6.497c-5.408,0-9.807,4.397-9.807,9.805v7.948l0.021,0.124l0.548,0.171
        c4.138,1.294,7.833,1.889,11.042,2.075v-2.4C14.189,50.298,17.705,45.84,22.512,44.412z"/>
</g>
</svg>
';
                        break;

                    case 'globalization':
                        $localItem['img_path'] = 'hx_tm_globalization.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . '  as per the inputs provided in resume. This resource can easily get accustomed to the diversified employee backgrounds considering the exposure in working for similar environments in the earlier companies.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . ' as per the inputs provided in resume. Since the working experience depicts multi-national environments the profile, this resources can become handy and can get acquainted to the global policies and processes and diversified cultural backgrounds in the company which paves path easily in accepting this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<path fill="#2c303b" d="M34.189,3.016c-11.344,3.66-16.468,10.246-16.468,21.775c0,9.333,9.698,19.029,19.031,19.029
    c9.148,0,16.65-4.208,19.396-10.978C61.27,20.582,57.063,9.054,46.084,4.297C39.496,1.551,38.582,1.551,34.189,3.016z
     M35.289,12.165c-1.83,1.83-3.477-0.915-1.83-3.294c1.098-2.013,1.464-2.013,2.194,0C36.02,10.152,35.837,11.615,35.289,12.165z
     M43.34,11.067c0,1.098-0.732,1.28-1.83,0.732c-0.916-0.548-1.83-2.013-1.83-2.928c0-1.099,0.914-1.281,1.83-0.732
    C42.607,8.688,43.34,10.152,43.34,11.067z M29.616,10.884c-0.548,0.915-2.013,1.83-2.928,1.83c-1.098,0-1.28-0.915-0.732-1.83
    c0.548-1.099,2.013-1.83,2.928-1.83C29.982,9.054,30.164,9.786,29.616,10.884z M50.658,10.884c0,0.915-0.732,1.83-1.828,1.83
    c-0.916,0-1.832-0.915-1.832-1.83c0-1.099,0.916-1.83,1.832-1.83C49.926,9.054,50.658,9.786,50.658,10.884z M26.871,18.204
    c0,2.012-1.281,3.659-2.745,3.659c-2.745,0-3.843-3.843-1.463-6.038C24.858,13.446,26.871,14.543,26.871,18.204z M36.02,18.204
    c0,2.012-1.282,3.659-2.745,3.659c-2.744,0-3.843-3.843-1.463-6.038C34.006,13.446,36.02,14.543,36.02,18.204z M45.719,18.204
    c0.73,2.744,0,3.659-2.563,3.659c-2.195,0-3.477-1.281-3.477-3.659c0-2.013,1.098-3.66,2.563-3.66
    C43.521,14.543,45.168,16.19,45.719,18.204z M53.951,16.739c3.293,3.294,2.746,5.124-1.463,5.124c-2.379,0-3.658-1.281-3.658-3.659
    C48.83,13.995,50.658,13.446,53.951,16.739z M26.871,28.267c0,1.463-1.281,2.745-2.745,2.745s-2.745-1.281-2.745-2.745
    c0-1.464,1.281-2.745,2.745-2.745S26.871,26.803,26.871,28.267z M36.02,28.267c0,1.463-1.282,2.745-2.745,2.745
    c-1.463,0-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745C34.738,25.522,36.02,26.803,36.02,28.267z M45.168,28.267
    c0,1.463-1.281,2.745-2.744,2.745s-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745S45.168,26.803,45.168,28.267z
     M55.783,27.718c-1.281,3.476-6.953,4.026-6.953,0.732c0-1.83,1.645-2.928,3.842-2.928C54.867,25.522,56.148,26.437,55.783,27.718z
     M28.701,36.502c0,0.914-0.366,1.829-0.732,1.829c-0.549,0-1.465-0.915-2.013-1.829c-0.548-1.098-0.183-1.83,0.732-1.83
    C27.786,34.672,28.701,35.404,28.701,36.502z M36.02,37.416c0,1.464-0.367,2.745-0.731,2.745c-0.366,0-1.1-1.281-1.83-2.745
    c-0.55-1.463-0.184-2.744,0.73-2.744C35.289,34.672,36.02,35.953,36.02,37.416z M43.34,36.318c0,1.098-0.732,2.379-1.83,2.927
    c-0.916,0.549-1.83-0.182-1.83-1.646c0-1.646,0.914-2.927,1.83-2.927C42.607,34.672,43.34,35.404,43.34,36.318z M50.658,35.404
    c0,0.549-0.732,1.463-1.828,2.012c-0.916,0.548-1.832,0.183-1.832-0.733c0-1.097,0.916-2.011,1.832-2.011
    C49.926,34.672,50.658,35.038,50.658,35.404z"/>
<path fill="#2c303b" d="M1.254,52.055v11.895h5.489h5.49V52.055V40.161h-5.49H1.254V52.055z"/>
<path fill="#2c303b" d="M16.258,52.055l0.548,8.602l10.979,3.84l10.979,3.662l15.002-8.053c14.822-7.684,16.836-9.514,13.725-11.529
    c-2.379-1.462-15.371,2.564-18.848,5.676c-2.012,1.645-5.854,2.377-10.979,1.83l-8.05-0.734l8.783-0.182
    c7.137-0.365,8.6-0.914,8.6-3.844c0-2.746-1.83-3.66-8.6-4.575c-4.94-0.549-11.895-1.646-15.736-2.194l-6.954-1.099L16.258,52.055z"
    />
</svg>
';
                        break;
        case 'diversity_inclusion':
                        $localItem['img_path'] = 'hx_tm_globalization.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . '  as per the inputs provided in resume. This resource can easily get accustomed to the diversified employee backgrounds considering the exposure in working for similar environments in the earlier companies.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . ' as per the inputs provided in resume. Since the working experience depicts multi-national environments the profile, this resources can become handy and can get acquainted to the global policies and processes and diversified cultural backgrounds in the company which paves path easily in accepting this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<path fill="#2c303b" d="M34.189,3.016c-11.344,3.66-16.468,10.246-16.468,21.775c0,9.333,9.698,19.029,19.031,19.029
    c9.148,0,16.65-4.208,19.396-10.978C61.27,20.582,57.063,9.054,46.084,4.297C39.496,1.551,38.582,1.551,34.189,3.016z
     M35.289,12.165c-1.83,1.83-3.477-0.915-1.83-3.294c1.098-2.013,1.464-2.013,2.194,0C36.02,10.152,35.837,11.615,35.289,12.165z
     M43.34,11.067c0,1.098-0.732,1.28-1.83,0.732c-0.916-0.548-1.83-2.013-1.83-2.928c0-1.099,0.914-1.281,1.83-0.732
    C42.607,8.688,43.34,10.152,43.34,11.067z M29.616,10.884c-0.548,0.915-2.013,1.83-2.928,1.83c-1.098,0-1.28-0.915-0.732-1.83
    c0.548-1.099,2.013-1.83,2.928-1.83C29.982,9.054,30.164,9.786,29.616,10.884z M50.658,10.884c0,0.915-0.732,1.83-1.828,1.83
    c-0.916,0-1.832-0.915-1.832-1.83c0-1.099,0.916-1.83,1.832-1.83C49.926,9.054,50.658,9.786,50.658,10.884z M26.871,18.204
    c0,2.012-1.281,3.659-2.745,3.659c-2.745,0-3.843-3.843-1.463-6.038C24.858,13.446,26.871,14.543,26.871,18.204z M36.02,18.204
    c0,2.012-1.282,3.659-2.745,3.659c-2.744,0-3.843-3.843-1.463-6.038C34.006,13.446,36.02,14.543,36.02,18.204z M45.719,18.204
    c0.73,2.744,0,3.659-2.563,3.659c-2.195,0-3.477-1.281-3.477-3.659c0-2.013,1.098-3.66,2.563-3.66
    C43.521,14.543,45.168,16.19,45.719,18.204z M53.951,16.739c3.293,3.294,2.746,5.124-1.463,5.124c-2.379,0-3.658-1.281-3.658-3.659
    C48.83,13.995,50.658,13.446,53.951,16.739z M26.871,28.267c0,1.463-1.281,2.745-2.745,2.745s-2.745-1.281-2.745-2.745
    c0-1.464,1.281-2.745,2.745-2.745S26.871,26.803,26.871,28.267z M36.02,28.267c0,1.463-1.282,2.745-2.745,2.745
    c-1.463,0-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745C34.738,25.522,36.02,26.803,36.02,28.267z M45.168,28.267
    c0,1.463-1.281,2.745-2.744,2.745s-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745S45.168,26.803,45.168,28.267z
     M55.783,27.718c-1.281,3.476-6.953,4.026-6.953,0.732c0-1.83,1.645-2.928,3.842-2.928C54.867,25.522,56.148,26.437,55.783,27.718z
     M28.701,36.502c0,0.914-0.366,1.829-0.732,1.829c-0.549,0-1.465-0.915-2.013-1.829c-0.548-1.098-0.183-1.83,0.732-1.83
    C27.786,34.672,28.701,35.404,28.701,36.502z M36.02,37.416c0,1.464-0.367,2.745-0.731,2.745c-0.366,0-1.1-1.281-1.83-2.745
    c-0.55-1.463-0.184-2.744,0.73-2.744C35.289,34.672,36.02,35.953,36.02,37.416z M43.34,36.318c0,1.098-0.732,2.379-1.83,2.927
    c-0.916,0.549-1.83-0.182-1.83-1.646c0-1.646,0.914-2.927,1.83-2.927C42.607,34.672,43.34,35.404,43.34,36.318z M50.658,35.404
    c0,0.549-0.732,1.463-1.828,2.012c-0.916,0.548-1.832,0.183-1.832-0.733c0-1.097,0.916-2.011,1.832-2.011
    C49.926,34.672,50.658,35.038,50.658,35.404z"/>
<path fill="#2c303b" d="M1.254,52.055v11.895h5.489h5.49V52.055V40.161h-5.49H1.254V52.055z"/>
<path fill="#2c303b" d="M16.258,52.055l0.548,8.602l10.979,3.84l10.979,3.662l15.002-8.053c14.822-7.684,16.836-9.514,13.725-11.529
    c-2.379-1.462-15.371,2.564-18.848,5.676c-2.012,1.645-5.854,2.377-10.979,1.83l-8.05-0.734l8.783-0.182
    c7.137-0.365,8.6-0.914,8.6-3.844c0-2.746-1.83-3.66-8.6-4.575c-4.94-0.549-11.895-1.646-15.736-2.194l-6.954-1.099L16.258,52.055z"
    />
</svg>
';
                        break;
            case 'environmental_social_governance':
                    
                        $localItem['img_path'] = 'hx_tm_globalization.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . '  as per the inputs provided in resume. This resource can easily get accustomed to the diversified employee backgrounds considering the exposure in working for similar environments in the earlier companies.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . ' as per the inputs provided in resume. Since the working experience depicts multi-national environments the profile, this resources can become handy and can get acquainted to the global policies and processes and diversified cultural backgrounds in the company which paves path easily in accepting this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<path fill="#2c303b" d="M34.189,3.016c-11.344,3.66-16.468,10.246-16.468,21.775c0,9.333,9.698,19.029,19.031,19.029
    c9.148,0,16.65-4.208,19.396-10.978C61.27,20.582,57.063,9.054,46.084,4.297C39.496,1.551,38.582,1.551,34.189,3.016z
     M35.289,12.165c-1.83,1.83-3.477-0.915-1.83-3.294c1.098-2.013,1.464-2.013,2.194,0C36.02,10.152,35.837,11.615,35.289,12.165z
     M43.34,11.067c0,1.098-0.732,1.28-1.83,0.732c-0.916-0.548-1.83-2.013-1.83-2.928c0-1.099,0.914-1.281,1.83-0.732
    C42.607,8.688,43.34,10.152,43.34,11.067z M29.616,10.884c-0.548,0.915-2.013,1.83-2.928,1.83c-1.098,0-1.28-0.915-0.732-1.83
    c0.548-1.099,2.013-1.83,2.928-1.83C29.982,9.054,30.164,9.786,29.616,10.884z M50.658,10.884c0,0.915-0.732,1.83-1.828,1.83
    c-0.916,0-1.832-0.915-1.832-1.83c0-1.099,0.916-1.83,1.832-1.83C49.926,9.054,50.658,9.786,50.658,10.884z M26.871,18.204
    c0,2.012-1.281,3.659-2.745,3.659c-2.745,0-3.843-3.843-1.463-6.038C24.858,13.446,26.871,14.543,26.871,18.204z M36.02,18.204
    c0,2.012-1.282,3.659-2.745,3.659c-2.744,0-3.843-3.843-1.463-6.038C34.006,13.446,36.02,14.543,36.02,18.204z M45.719,18.204
    c0.73,2.744,0,3.659-2.563,3.659c-2.195,0-3.477-1.281-3.477-3.659c0-2.013,1.098-3.66,2.563-3.66
    C43.521,14.543,45.168,16.19,45.719,18.204z M53.951,16.739c3.293,3.294,2.746,5.124-1.463,5.124c-2.379,0-3.658-1.281-3.658-3.659
    C48.83,13.995,50.658,13.446,53.951,16.739z M26.871,28.267c0,1.463-1.281,2.745-2.745,2.745s-2.745-1.281-2.745-2.745
    c0-1.464,1.281-2.745,2.745-2.745S26.871,26.803,26.871,28.267z M36.02,28.267c0,1.463-1.282,2.745-2.745,2.745
    c-1.463,0-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745C34.738,25.522,36.02,26.803,36.02,28.267z M45.168,28.267
    c0,1.463-1.281,2.745-2.744,2.745s-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745S45.168,26.803,45.168,28.267z
     M55.783,27.718c-1.281,3.476-6.953,4.026-6.953,0.732c0-1.83,1.645-2.928,3.842-2.928C54.867,25.522,56.148,26.437,55.783,27.718z
     M28.701,36.502c0,0.914-0.366,1.829-0.732,1.829c-0.549,0-1.465-0.915-2.013-1.829c-0.548-1.098-0.183-1.83,0.732-1.83
    C27.786,34.672,28.701,35.404,28.701,36.502z M36.02,37.416c0,1.464-0.367,2.745-0.731,2.745c-0.366,0-1.1-1.281-1.83-2.745
    c-0.55-1.463-0.184-2.744,0.73-2.744C35.289,34.672,36.02,35.953,36.02,37.416z M43.34,36.318c0,1.098-0.732,2.379-1.83,2.927
    c-0.916,0.549-1.83-0.182-1.83-1.646c0-1.646,0.914-2.927,1.83-2.927C42.607,34.672,43.34,35.404,43.34,36.318z M50.658,35.404
    c0,0.549-0.732,1.463-1.828,2.012c-0.916,0.548-1.832,0.183-1.832-0.733c0-1.097,0.916-2.011,1.832-2.011
    C49.926,34.672,50.658,35.038,50.658,35.404z"/>
<path fill="#2c303b" d="M1.254,52.055v11.895h5.489h5.49V52.055V40.161h-5.49H1.254V52.055z"/>
<path fill="#2c303b" d="M16.258,52.055l0.548,8.602l10.979,3.84l10.979,3.662l15.002-8.053c14.822-7.684,16.836-9.514,13.725-11.529
    c-2.379-1.462-15.371,2.564-18.848,5.676c-2.012,1.645-5.854,2.377-10.979,1.83l-8.05-0.734l8.783-0.182
    c7.137-0.365,8.6-0.914,8.6-3.844c0-2.746-1.83-3.66-8.6-4.575c-4.94-0.549-11.895-1.646-15.736-2.194l-6.954-1.099L16.258,52.055z"
    />
</svg>
';
                        break;
                }


                    $returnData[] = $localItem;
         


            }
        }

        $finalReponce = array();

        if (count($returnData) > 0) {
            foreach ($returnData as $returnDat) {
              
                    $finalReponce[] = $returnDat;
               
            }
        }


        return $finalReponce;

    }



    public function getCandidateSpectrum($id)
    {
        $authuser = Auth::user();
        $problem_solver = 37.33;
        $optimist_points = 37.33;
        $leader = 0;
        $yesman = 0;
        $planned_one = 0;

        $responce = array();
        $responce['candidate'] = 0;
        $responce['leader'] = 0;
        $responce['optimist_points'] = 37.33;
        $responce['innovator_points'] = 0;
        $responce['problem_solver_percentage'] = 37.33;
        $responce['planned_one'] = 0;
        $responce['yesman'] = 0;
        $responce['ip'] = $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);


        $responce['candidate'] = $id;

        $candidateDetails = Candidate::with(['getExperience', 'getSpectrums'])
            ->where('id', $id)
            ->first();

        $employersData = CompaniesEmployer::whereNotNull('name')->get();


        $yesmanMNCompaneies = array();


        if (!empty($candidateDetails->getSpectrums) && count($candidateDetails->getSpectrums) == 0) {

            $candidate_exp = $candidateDetails->getExperience->where('is_current_employer', '0');

            if (count($candidate_exp) > 0) {
                $exp_can = array();
                foreach ($candidate_exp as $exp) {
                    $start_date = date_create($exp->start_date);
                    $end_date = date_create($exp->end_date);
                    $diff = date_diff($start_date, $end_date);
                    $months_diff = round(($diff->format("%a")) / 30);
                    $exp->diff = $months_diff;
                    $exp_can[] = $exp->diff;


                    $employers = $employersData->filter(function ($item) use ($exp) {
                        return strtolower($item->name) == strtolower($exp->employer_name);
                    });

//                    $employers = $employersData->where('name', 'LIKE', '%' . $exp->employer_name . '%');


                    if (count($employers) > 0) {
                        $yesmanMNCompaneies[] = $employers;
                        $yesman = 37.9;
                    } else {
                        $yesman = 67.33;
                    }


                }
                if (count($exp_can) > 1) {
                    for ($x = 0; $x < count($exp_can); $x++) {
                        if (count($exp_can) == $x + 1) {
                        } else {
                            if ($exp_can[$x] < $exp_can[$x + 1]) {
                                $planned_one = 18.33;
                            } else {
                                $planned_one = 33.33;
                            }
                        }
                    }
                } else if (count($exp_can) == 1) {
                    $planned_one = 33.33;
                }
            }


            $candidate_educations = $candidateDetails->educations->filter(function ($user, $key) {
                return $user->institution_name != null;
            });


//            $candidate_educations =  $candidateDetails->educations
//                ->where('institution_name', '!=', '');

//            dd($candidate_educations);

            $candidate_educationsNames = $candidate_educations->pluck(['institution_name']);

            // $candidate_educationsNames->push('University of Oxford');

            // $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
            //     ->orderBy('rank', 'asc')
            //     ->first();
            try {

                $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
                              ->orderBy('rank', 'asc')
                              ->first();
              
              } catch (\Exception $e) {
              
                  $UniversityGroupData=[];
              }

            $innovatorUniversityPoints = '';
            $innovatorExperiencePoints = '';


            if (!empty($UniversityGroupData)) {
                $innovatorUniversityPoints = $UniversityGroupData->point;
            } else {
                $innovatorUniversityPoints = 38.33;
            }

//            $total_experience_in_year = (int) 15;
            $total_experience_in_year = (int)$candidateDetails->total_experience_in_year;

            switch (true) {
                case in_array($total_experience_in_year, range(1, 2)):
                    $innovatorExperiencePoints = 4;
                    break;
                case in_array($total_experience_in_year, range(3, 4)):
                    $innovatorExperiencePoints = 6;
                    break;
                case in_array($total_experience_in_year, range(5, 6)):
                    $innovatorExperiencePoints = 8;
                    break;
                case in_array($total_experience_in_year, range(7, 8)):
                    $innovatorExperiencePoints = 10;
                    break;
                case in_array($total_experience_in_year, range(9, 10)):
                    $innovatorExperiencePoints = 12;
                    break;
                case in_array($total_experience_in_year, range(11, 12)):
                    $innovatorExperiencePoints = 14;
                    break;
                case in_array($total_experience_in_year, range(13, 14)):
                    $innovatorExperiencePoints = 16;
                    break;
                case in_array($total_experience_in_year, range(15, 40)):
                    $innovatorExperiencePoints = 18;
                    break;
                default:
                    $innovatorExperiencePoints = 2;
                    break;
            }

            $responce['innovator_points'] = ($innovatorUniversityPoints + $innovatorExperiencePoints);

//            START THE PROBLEM SOLVER
            $candidate_text = $candidateDetails->objectives . ' ' . $candidateDetails->note . ' ' . $candidateDetails->html_code;
            $candidate_text = strip_tags(strtolower($candidate_text));
            $candidate_text = htmlentities($candidate_text);
            $candidate_text = html_entity_decode($candidate_text);
            $candidate_text = htmlspecialchars($candidate_text);
            $candidate_text = strtolower(str_replace(
                array(
                    "head",
                    "{",
                    "[",
                    "/",
                    "&",
                    "!",
                    '"',
                    ".",
                    "'",
                    "?",
                    "(",
                    ")",
                    "-",
                    ",",
                    "/",
                    "\r",
                    "\n",
                    ";",
                    "#",
                    ":"
                ), '', $candidate_text));
             $candidate_text = preg_replace('/[^A-Za-z0-9 ]/', '', $candidate_text);


            $candidate_text = explode(" ", $candidate_text);
            $candidate_text = array_unique($candidate_text);
            $candidate_text = array_filter($candidate_text);
            foreach ($candidate_text as $key=>&$value) {
                if (strlen($value) < 3) {
                    unset($candidate_text[$key]);
                }
            }

//            $candidate_text = array_slice($candidate_text, 0, 5000);

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $candidate_SoftSkills = SoftSkills::whereIn('able_to_listen', $candidate_text)->count();
            $candidate_ManagementWord = ManagementWord::whereIn('word', $candidate_text)->count();

            $candidate_ActionWordsSoftSkills = ($candidate_ActionWords + $candidate_SoftSkills);
            $candidate_ActionWordsSoftSkillsPints = ($candidate_ActionWordsSoftSkills * 1.3);
            $candidate_ManagementWordPints = ($candidate_ManagementWord * 2.7);
            $problem_solverExperiencePoints = 0;

            switch (true) {
                case in_array($total_experience_in_year, range(2, 4)):
                    $problem_solverExperiencePoints = 12.7;
                    break;
                case in_array($total_experience_in_year, range(5, 40)):
                    $problem_solverExperiencePoints = 17.7;
                    break;
                default:
                    $problem_solverExperiencePoints = 7.2;
                    break;
            }


            $problem_solverPoints = ($candidate_ActionWordsSoftSkillsPints + $candidate_ManagementWordPints + $problem_solverExperiencePoints);

            if ($problem_solverPoints > 75) {
                $problem_solverPoints = 75;
            }

            $responce['problem_solver_percentage'] = $problem_solverPoints;
//           END THE PROBLEM SOLVER


//            START OPTIMIST

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $optimist_ActionWordsPoints = ($candidate_ActionWords * 1.33);
            if ($optimist_ActionWordsPoints > 75) {
                $optimist_ActionWordsPoints = 75;
            }
            $responce['optimist_points'] = $optimist_ActionWordsPoints;
//            END OPTIMIST


//   START LEADER

//            dd($UniversityGroupData);

            $leaderUniversityRank = isset($UniversityGroupData->rank) ? $UniversityGroupData->rank : null;

            switch (true) {
                case in_array($leaderUniversityRank, range(1, 5)):
                    $LeaderUniversityPoints = 18.3;
                    break;
                case in_array($leaderUniversityRank, range(6, 10)):
                    $LeaderUniversityPoints = 15.3;
                    break;
                case in_array($leaderUniversityRank, range(11, 15)):
                    $LeaderUniversityPoints = 12.3;
                    break;
                case in_array($leaderUniversityRank, range(16, 20)):
                    $LeaderUniversityPoints = 9.3;
                    break;
                case in_array($leaderUniversityRank, range(21, 25)):
                    $LeaderUniversityPoints = 6.3;
                    break;
                default:
                    $LeaderUniversityPoints = 5;
                    break;
            }

            switch (true) {
                case in_array($total_experience_in_year, range(0, 7)):
                    $leaderExperiencePoints = 33.7;
                    break;
                case in_array($total_experience_in_year, range(8, 11)):
                    $leaderExperiencePoints = 43.7;
                    break;
                case in_array($total_experience_in_year, range(12, 17)):
                    $leaderExperiencePoints = 53.7;
                    break;
                case in_array($total_experience_in_year, range(18, 40)):
                    $leaderExperiencePoints = 63.7;
                    break;
                default:
                    $leaderExperiencePoints = 7.2;
                    break;
            }

//            dd($LeaderUniversityPoints, $leaderExperiencePoints);

            $leaderPoints = ($LeaderUniversityPoints + $leaderExperiencePoints);
            $responce['leader'] = $leaderPoints;
//   END LEADER

//   START THE PLANNED ONE
            $candidateExperiencesData = $candidateDetails->getExperience->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $jobGaps = array();

            if (count($candidateExperiencesData) > 0) {
                foreach ($candidateExperiencesData as $key => $candidateExperiencesDat) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
//                        dd($candidateExperiencesDat);
                    if (isset($candidateExperiencesData[$key + 1]->start_date)) {
//                        dd($candidateExperiencesData[$key + 1]->start_date);

                        $endthisJobDate = $candidateExperiencesDat->end_date;
                        $nextJobStartDate = $candidateExperiencesData[$key + 1]->start_date;

                    } else {
                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $endthisJobDate = date('Y-m-d');
                            $nextJobStartDate = date('Y-m-d');
                        } else {
                            $endthisJobDate = $candidateExperiencesDat->end_date;
                            $nextJobStartDate = date('Y-m-d');
                        }

                    }

                    $to = new Carbon($endthisJobDate);
                    $from = new Carbon($nextJobStartDate);
                    $diff_in_months = $to->diffInMonths($from);

//                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);

                    if ($diff_in_months > 0) {
                        $jobGaps[] = $diff_in_months;
                    }

                }

            }

            $leaderGapsPoints = 0;
            if (count($jobGaps) > 0) {
                $leaderGapsPoints = 23.33;
            } else {
                $leaderGapsPoints = 33.33;
            }

            $currentWorkingCompany = $candidateDetails->getExperience->where('is_current_employer', '1')->first();
            $currentWorking_in_YearsPoints = 0;
            if ($currentWorkingCompany != '') {
                $to = new Carbon($currentWorkingCompany->start_date);
                $from = Carbon::now();
                $currentWorking_in_Years = $to->diffInYears($from);

                switch (true) {
                    case in_array($currentWorking_in_Years, range(4, 5)):
                        $currentWorking_in_YearsPoints = 20.7;
                        break;
                    case in_array($currentWorking_in_Years, range(6, 7)):
                        $currentWorking_in_YearsPoints = 25.7;
                        break;
                    case in_array($currentWorking_in_Years, range(8, 40)):
                        $currentWorking_in_YearsPoints = 15.7;
                        break;

                    default:
                        $currentWorking_in_YearsPoints = 0;
                        break;
                }
            }

//            $candidate_operational_skillData = $candidateDetails->candidate_operational_skill;
//            $candidate_operational_skill_text = '';
//            if (count($candidate_operational_skillData) > 0) {
//                foreach ($candidate_operational_skillData as $item) {
//                    $candidate_operational_skill_text .=strtolower($item->operational_skills);
//                }
//            }
//
//           $candidate_operational_skillArray= explode(',', $candidate_operational_skill_text);
//            $candidate_operational_skillArray= array_filter($candidate_operational_skillArray);


//            dd($candidate_operational_skill_text);

            if (in_array('training', $candidate_text) || in_array('trained', $candidate_text) || in_array('impart', $candidate_text)) {
                $trainingsPoints = 15.9;
            } else {
                $trainingsPoints = 0;
            }

            $candidateEducationsData = $candidateDetails->educations->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $educationGaps = array();
            if (count($candidateEducationsData) > 0) {
                foreach ($candidateEducationsData as $key => $itemData) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
                    if (isset($candidateEducationsData[$key + 1]->start_date)) {

                        $endthisEduDate = $itemData->end_date;
                        $nextEduStartDate = $candidateEducationsData[$key + 1]->start_date;

                    }

                    if (isset($endthisEduDate)) {
                        $to = new Carbon($endthisEduDate);
                        $from = new Carbon($nextEduStartDate);
                        $eduGapsInYears = $to->diffInYears($from);

                        //                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);

                        if ($eduGapsInYears > 0) {
                            $educationGaps[] = $eduGapsInYears;
                        }

                    }

                }

            }


            $leaderEduGapsPoints = 0;
            if ($total_experience_in_year == 0) {
                if (count($educationGaps) > 0) {
                    $leaderEduGapsPoints = 40;
                } else {
                    $leaderEduGapsPoints = 55.7;
                }
            }
            $responce['planned_one'] = ($leaderGapsPoints + $currentWorking_in_YearsPoints + $trainingsPoints + $leaderEduGapsPoints);


//   END THE PLANNED ONE
//   START THE yesman


            $midLevelOrMNCCompanyPints = 0;
            $midLevelOrLastCompanyPints = 0;

            $chackMidLevelCompany = false;
            $chackMNCCompany = false;
            $chackLastCompanyMidLevel = false;

            if (count($yesmanMNCompaneies) > 0) {
                $chackMNCCompany = true;
            } else {
                $chackMidLevelCompany = true;
            }
            if ($currentWorkingCompany != '') {
                $yesmanLastWorkingMNCompaneies = $employersData->filter(function ($item) use ($currentWorkingCompany) {
//                return strtolower($item->name) == strtolower('Apple Inc');
                    return strtolower($item->name) == strtolower($currentWorkingCompany->employer_name);
                });

                if (!empty($yesmanLastWorkingMNCompaneies)) {
                    $chackLastCompanyMidLevel = true;
                }
            }


            if ($chackMidLevelCompany == true) {


                $MidLevelCompanyWorkingDurationsInMonsthArray = array();


                $candidateWorkingDurationData = $candidateDetails->getExperience->sortBy(function ($col) {
                    return $col->start_date;
                })->values()->all();

                if (count($candidateWorkingDurationData) > 0) {
                    foreach ($candidateWorkingDurationData as $key => $candidateWorkingDurationItem) {

                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = date('Y-m-d');
                        } else {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = $candidateWorkingDurationItem->end_date;
                        }

                        $to = new Carbon($startJobDate);
                        $from = new Carbon($endJobStartDate);
                        $duration_in_months = $to->diffInMonths($from);
                        if ($duration_in_months > 0) {
                            $MidLevelCompanyWorkingDurationsInMonsthArray[] = $duration_in_months;
                        }

                    }

                }

//                dump(max($MidLevelCompanyWorkingDurationsInMonsthArray));

                if (count($MidLevelCompanyWorkingDurationsInMonsthArray)> 0 && 24 < max($MidLevelCompanyWorkingDurationsInMonsthArray)) {


                    $midLevelOrMNCCompanyPints = 67.33;
                } else {
                    $midLevelOrMNCCompanyPints = 53.33;

                }
            } else {

                if ($chackLastCompanyMidLevel == true) {
                    $midLevelOrLastCompanyPints = 12.33;
                }
                if ($chackMNCCompany == true) {
                    $midLevelOrMNCCompanyPints = 37.90;
                }

            }

            $responce['yesman'] = ($midLevelOrMNCCompanyPints + $midLevelOrLastCompanyPints);


            $employee_spectrum = Employeespectrums::create($responce);


        } else {
           if(!empty($candidateDetails->getSpectrums)){
            $responce['candidate'] = $candidateDetails->getSpectrums->first()->candidate;
            $responce['leader'] = (int)$candidateDetails->getSpectrums->first()->leader;
            $responce['optimist_points'] = (int)$candidateDetails->getSpectrums->first()->optimist_points;
            $responce['innovator_points'] = (int)$candidateDetails->getSpectrums->first()->innovator_points;
            $responce['problem_solver_percentage'] = (int)$candidateDetails->getSpectrums->first()->problem_solver_percentage;
            $responce['planned_one'] = (int)$candidateDetails->getSpectrums->first()->planned_one;
            $responce['yesman'] = (int)$candidateDetails->getSpectrums->first()->yesman;
            $responce['ip'] = $candidateDetails->getSpectrums->first()->ip;

          }
        }
        return $responce;

//            return response()->success(compact('candidatespecdetails'));
    }

    public function getCandidateSpectrummultip($id)
    {
        $authuser = Auth::user();
        $problem_solver = 37.33;
        $optimist_points = 37.33;
        $leader = 0;
        $yesman = 0;
        $planned_one = 0;

        $responce = array();
        $responce['candidate'] = 0;
        $responce['leader'] = 0;
        $responce['optimist_points'] = 37.33;
        $responce['innovator_points'] = 0;
        $responce['problem_solver_percentage'] = 37.33;
        $responce['planned_one'] = 0;
        $responce['yesman'] = 0;
        $responce['ip'] = $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);


        $responce['candidate'] = $id;

        $candidateDetails = Candidate::with(['getExperience', 'getSpectrums'])
            ->where('id', $id)
            ->first();

        $employersData = CompaniesEmployer::whereNotNull('name')->get();


        $yesmanMNCompaneies = array();


        if (count($candidateDetails->getSpectrums) == 0) {

            $candidate_exp = $candidateDetails->getExperience->where('is_current_employer', '0');

            if (count($candidate_exp) > 0) {
                $exp_can = array();
                foreach ($candidate_exp as $exp) {
                    $start_date = date_create($exp->start_date);
                    $end_date = date_create($exp->end_date);
                    $diff = date_diff($start_date, $end_date);
                    $months_diff = round(($diff->format("%a")) / 30);
                    $exp->diff = $months_diff;
                    $exp_can[] = $exp->diff;


                    $employers = $employersData->filter(function ($item) use ($exp) {
                        return strtolower($item->name) == strtolower($exp->employer_name);
                    });

//                    $employers = $employersData->where('name', 'LIKE', '%' . $exp->employer_name . '%');


                    if (count($employers) > 0) {
                        $yesmanMNCompaneies[] = $employers;
                        $yesman = 37.9;
                    } else {
                        $yesman = 67.33;
                    }


                }
                if (count($exp_can) > 1) {
                    for ($x = 0; $x < count($exp_can); $x++) {
                        if (count($exp_can) == $x + 1) {
                        } else {
                            if ($exp_can[$x] < $exp_can[$x + 1]) {
                                $planned_one = 18.33;
                            } else {
                                $planned_one = 33.33;
                            }
                        }
                    }
                } else if (count($exp_can) == 1) {
                    $planned_one = 33.33;
                }
            }


            $candidate_educations = $candidateDetails->educations->filter(function ($user, $key) {
                return $user->institution_name != null;
            });


//            $candidate_educations =  $candidateDetails->educations
//                ->where('institution_name', '!=', '');

//            dd($candidate_educations);

            $candidate_educationsNames = $candidate_educations->pluck(['institution_name']);

            // $candidate_educationsNames->push('University of Oxford');

            // $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
            //     ->orderBy('rank', 'asc')
            //     ->first();
            try {

                $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
                              ->orderBy('rank', 'asc')
                              ->first();
              
              } catch (\Exception $e) {
              
                  $UniversityGroupData=[];
              }

            $innovatorUniversityPoints = '';
            $innovatorExperiencePoints = '';


            if (!empty($UniversityGroupData)) {
                $innovatorUniversityPoints = $UniversityGroupData->point;
            } else {
                $innovatorUniversityPoints = 38.33;
            }

//            $total_experience_in_year = (int) 15;
            $total_experience_in_year = (int)$candidateDetails->total_experience_in_year;

            switch (true) {
                case in_array($total_experience_in_year, range(1, 2)):
                    $innovatorExperiencePoints = 4;
                    break;
                case in_array($total_experience_in_year, range(3, 4)):
                    $innovatorExperiencePoints = 6;
                    break;
                case in_array($total_experience_in_year, range(5, 6)):
                    $innovatorExperiencePoints = 8;
                    break;
                case in_array($total_experience_in_year, range(7, 8)):
                    $innovatorExperiencePoints = 10;
                    break;
                case in_array($total_experience_in_year, range(9, 10)):
                    $innovatorExperiencePoints = 12;
                    break;
                case in_array($total_experience_in_year, range(11, 12)):
                    $innovatorExperiencePoints = 14;
                    break;
                case in_array($total_experience_in_year, range(13, 14)):
                    $innovatorExperiencePoints = 16;
                    break;
                case in_array($total_experience_in_year, range(15, 40)):
                    $innovatorExperiencePoints = 18;
                    break;
                default:
                    $innovatorExperiencePoints = 2;
                    break;
            }

            $responce['innovator_points'] = ($innovatorUniversityPoints + $innovatorExperiencePoints);

//            START THE PROBLEM SOLVER
            $candidate_text = $candidateDetails->objectives . ' ' . $candidateDetails->note . ' ' . $candidateDetails->html_code;
            $candidate_text = strip_tags(strtolower($candidate_text));
            $candidate_text = htmlentities($candidate_text);
            $candidate_text = html_entity_decode($candidate_text);
            $candidate_text = htmlspecialchars($candidate_text);
            $candidate_text = strtolower(str_replace(
                array(
                    "head",
                    "{",
                    "[",
                    "/",
                    "&",
                    "!",
                    '"',
                    ".",
                    "'",
                    "?",
                    "(",
                    ")",
                    "-",
                    ",",
                    "/",
                    "\r",
                    "\n",
                    ";",
                    "#",
                    ":"
                ), '', $candidate_text));
             $candidate_text = preg_replace('/[^A-Za-z0-9 ]/', '', $candidate_text);


            $candidate_text = explode(" ", $candidate_text);
            $candidate_text = array_unique($candidate_text);
            $candidate_text = array_filter($candidate_text);

//            $candidate_text = array_slice($candidate_text, 0, 5000);

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $candidate_SoftSkills = SoftSkills::whereIn('able_to_listen', $candidate_text)->count();
            $candidate_ManagementWord = ManagementWord::whereIn('word', $candidate_text)->count();

            $candidate_ActionWordsSoftSkills = ($candidate_ActionWords + $candidate_SoftSkills);
            $candidate_ActionWordsSoftSkillsPints = ($candidate_ActionWordsSoftSkills * 1.3);
            $candidate_ManagementWordPints = ($candidate_ManagementWord * 2.7);
            $problem_solverExperiencePoints = 0;

            switch (true) {
                case in_array($total_experience_in_year, range(2, 4)):
                    $problem_solverExperiencePoints = 12.7;
                    break;
                case in_array($total_experience_in_year, range(5, 40)):
                    $problem_solverExperiencePoints = 17.7;
                    break;
                default:
                    $problem_solverExperiencePoints = 7.2;
                    break;
            }


            $problem_solverPoints = ($candidate_ActionWordsSoftSkillsPints + $candidate_ManagementWordPints + $problem_solverExperiencePoints);

            if ($problem_solverPoints > 75) {
                $problem_solverPoints = 75;
            }

            $responce['problem_solver_percentage'] = $problem_solverPoints;
//           END THE PROBLEM SOLVER


//            START OPTIMIST

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $optimist_ActionWordsPoints = ($candidate_ActionWords * 1.33);
            if ($optimist_ActionWordsPoints > 75) {
                $optimist_ActionWordsPoints = 75;
            }
            $responce['optimist_points'] = $optimist_ActionWordsPoints;
//            END OPTIMIST


//   START LEADER

//            dd($UniversityGroupData);

            $leaderUniversityRank = isset($UniversityGroupData->rank) ? $UniversityGroupData->rank : null;

            switch (true) {
                case in_array($leaderUniversityRank, range(1, 5)):
                    $LeaderUniversityPoints = 18.3;
                    break;
                case in_array($leaderUniversityRank, range(6, 10)):
                    $LeaderUniversityPoints = 15.3;
                    break;
                case in_array($leaderUniversityRank, range(11, 15)):
                    $LeaderUniversityPoints = 12.3;
                    break;
                case in_array($leaderUniversityRank, range(16, 20)):
                    $LeaderUniversityPoints = 9.3;
                    break;
                case in_array($leaderUniversityRank, range(21, 25)):
                    $LeaderUniversityPoints = 6.3;
                    break;
                default:
                    $LeaderUniversityPoints = 5;
                    break;
            }

            switch (true) {
                case in_array($total_experience_in_year, range(0, 7)):
                    $leaderExperiencePoints = 33.7;
                    break;
                case in_array($total_experience_in_year, range(8, 11)):
                    $leaderExperiencePoints = 43.7;
                    break;
                case in_array($total_experience_in_year, range(12, 17)):
                    $leaderExperiencePoints = 53.7;
                    break;
                case in_array($total_experience_in_year, range(18, 40)):
                    $leaderExperiencePoints = 63.7;
                    break;
                default:
                    $leaderExperiencePoints = 7.2;
                    break;
            }

//            dd($LeaderUniversityPoints, $leaderExperiencePoints);

            $leaderPoints = ($LeaderUniversityPoints + $leaderExperiencePoints);
            $responce['leader'] = $leaderPoints;
//   END LEADER

//   START THE PLANNED ONE
            $candidateExperiencesData = $candidateDetails->getExperience->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $jobGaps = array();

            if (count($candidateExperiencesData) > 0) {
                foreach ($candidateExperiencesData as $key => $candidateExperiencesDat) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
//                        dd($candidateExperiencesDat);
                    if (isset($candidateExperiencesData[$key + 1]->start_date)) {
//                        dd($candidateExperiencesData[$key + 1]->start_date);

                        $endthisJobDate = $candidateExperiencesDat->end_date;
                        $nextJobStartDate = $candidateExperiencesData[$key + 1]->start_date;

                    } else {
                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $endthisJobDate = date('Y-m-d');
                            $nextJobStartDate = date('Y-m-d');
                        } else {
                            $endthisJobDate = $candidateExperiencesDat->end_date;
                            $nextJobStartDate = date('Y-m-d');
                        }

                    }

                    $to = new Carbon($endthisJobDate);
                    $from = new Carbon($nextJobStartDate);
                    $diff_in_months = $to->diffInMonths($from);

//                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);

                    if ($diff_in_months > 0) {
                        $jobGaps[] = $diff_in_months;
                    }

                }

            }

            $leaderGapsPoints = 0;
            if (count($jobGaps) > 0) {
                $leaderGapsPoints = 23.33;
            } else {
                $leaderGapsPoints = 33.33;
            }

            $currentWorkingCompany = $candidateDetails->getExperience->where('is_current_employer', '1')->first();
            $currentWorking_in_YearsPoints = 0;
            if ($currentWorkingCompany != '') {
                $to = new Carbon($currentWorkingCompany->start_date);
                $from = Carbon::now();
                $currentWorking_in_Years = $to->diffInYears($from);

                switch (true) {
                    case in_array($currentWorking_in_Years, range(4, 5)):
                        $currentWorking_in_YearsPoints = 20.7;
                        break;
                    case in_array($currentWorking_in_Years, range(6, 7)):
                        $currentWorking_in_YearsPoints = 25.7;
                        break;
                    case in_array($currentWorking_in_Years, range(8, 40)):
                        $currentWorking_in_YearsPoints = 15.7;
                        break;

                    default:
                        $currentWorking_in_YearsPoints = 0;
                        break;
                }
            }

//            $candidate_operational_skillData = $candidateDetails->candidate_operational_skill;
//            $candidate_operational_skill_text = '';
//            if (count($candidate_operational_skillData) > 0) {
//                foreach ($candidate_operational_skillData as $item) {
//                    $candidate_operational_skill_text .=strtolower($item->operational_skills);
//                }
//            }
//
//           $candidate_operational_skillArray= explode(',', $candidate_operational_skill_text);
//            $candidate_operational_skillArray= array_filter($candidate_operational_skillArray);


//            dd($candidate_operational_skill_text);

            if (in_array('training', $candidate_text) || in_array('trained', $candidate_text) || in_array('impart', $candidate_text)) {
                $trainingsPoints = 15.9;
            } else {
                $trainingsPoints = 0;
            }

            $candidateEducationsData = $candidateDetails->educations->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $educationGaps = array();
            if (count($candidateEducationsData) > 0) {
                foreach ($candidateEducationsData as $key => $itemData) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
                    if (isset($candidateEducationsData[$key + 1]->start_date)) {

                        $endthisEduDate = $itemData->end_date;
                        $nextEduStartDate = $candidateEducationsData[$key + 1]->start_date;

                    }

                    if (isset($endthisEduDate)) {
                        $to = new Carbon($endthisEduDate);
                        $from = new Carbon($nextEduStartDate);
                        $eduGapsInYears = $to->diffInYears($from);

                        //                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);

                        if ($eduGapsInYears > 0) {
                            $educationGaps[] = $eduGapsInYears;
                        }

                    }

                }

            }


            $leaderEduGapsPoints = 0;
            if ($total_experience_in_year == 0) {
                if (count($educationGaps) > 0) {
                    $leaderEduGapsPoints = 40;
                } else {
                    $leaderEduGapsPoints = 55.7;
                }
            }
            $responce['planned_one'] = ($leaderGapsPoints + $currentWorking_in_YearsPoints + $trainingsPoints + $leaderEduGapsPoints);


//   END THE PLANNED ONE
//   START THE yesman


            $midLevelOrMNCCompanyPints = 0;
            $midLevelOrLastCompanyPints = 0;

            $chackMidLevelCompany = false;
            $chackMNCCompany = false;
            $chackLastCompanyMidLevel = false;

            if (count($yesmanMNCompaneies) > 0) {
                $chackMNCCompany = true;
            } else {
                $chackMidLevelCompany = true;
            }
            if ($currentWorkingCompany != '') {
                $yesmanLastWorkingMNCompaneies = $employersData->filter(function ($item) use ($currentWorkingCompany) {
//                return strtolower($item->name) == strtolower('Apple Inc');
                    return strtolower($item->name) == strtolower($currentWorkingCompany->employer_name);
                });

                if (!empty($yesmanLastWorkingMNCompaneies)) {
                    $chackLastCompanyMidLevel = true;
                }
            }


            if ($chackMidLevelCompany == true) {


                $MidLevelCompanyWorkingDurationsInMonsthArray = array();


                $candidateWorkingDurationData = $candidateDetails->getExperience->sortBy(function ($col) {
                    return $col->start_date;
                })->values()->all();

                if (count($candidateWorkingDurationData) > 0) {
                    foreach ($candidateWorkingDurationData as $key => $candidateWorkingDurationItem) {

                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = date('Y-m-d');
                        } else {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = $candidateWorkingDurationItem->end_date;
                        }

                        $to = new Carbon($startJobDate);
                        $from = new Carbon($endJobStartDate);
                        $duration_in_months = $to->diffInMonths($from);
                        if ($duration_in_months > 0) {
                            $MidLevelCompanyWorkingDurationsInMonsthArray[] = $duration_in_months;
                        }

                    }

                }

//                dump(max($MidLevelCompanyWorkingDurationsInMonsthArray));

                if (count($MidLevelCompanyWorkingDurationsInMonsthArray)> 0 && 24 < max($MidLevelCompanyWorkingDurationsInMonsthArray)) {


                    $midLevelOrMNCCompanyPints = 67.33;
                } else {
                    $midLevelOrMNCCompanyPints = 53.33;

                }
            } else {

                if ($chackLastCompanyMidLevel == true) {
                    $midLevelOrLastCompanyPints = 12.33;
                }
                if ($chackMNCCompany == true) {
                    $midLevelOrMNCCompanyPints = 37.90;
                }

            }

            $responce['yesman'] = ($midLevelOrMNCCompanyPints + $midLevelOrLastCompanyPints);


            $employee_spectrum = Employeespectrums::create($responce);


        } else {

            $responce['candidate'] = $candidateDetails->getSpectrums->first()->candidate;
            $responce['leader'] = (int)$candidateDetails->getSpectrums->first()->leader;
            $responce['optimist_points'] = (int)$candidateDetails->getSpectrums->first()->optimist_points;
            $responce['innovator_points'] = (int)$candidateDetails->getSpectrums->first()->innovator_points;
            $responce['problem_solver_percentage'] = (int)$candidateDetails->getSpectrums->first()->problem_solver_percentage;
            $responce['planned_one'] = (int)$candidateDetails->getSpectrums->first()->planned_one;
            $responce['yesman'] = (int)$candidateDetails->getSpectrums->first()->yesman;
            $responce['ip'] = $candidateDetails->getSpectrums->first()->ip;


        }
        return $responce;

//            return response()->success(compact('candidatespecdetails'));
    }

    public function getCandidatespecdetails($id)
    {
        $authuser = Auth::user();
        $problem_solver = 37.33;
        $optimist_points = 37.33;
        $leader = 0;
        $yesman = 0;
        $planned_one = 0;

        $responce = array();
        $responce['candidate'] = '';
        $responce['leader'] = '';
        $responce['optimist_points'] = '';
        $responce['innovator_points'] = '';
        $responce['problem_solver_percentage'] = '';
        $responce['planned_one'] = '';
        $responce['yesman'] = '';
        $responce['ip'] = $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);


        $decryption_canid = base64_decode($id);
        $id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);

        $responce['candidate'] = $id;

        $candidateDetails = Candidate::with(['experiences', 'getSpectrums'])
            ->where('id', $id)
            ->first();

        $employersData = CompaniesEmployer::whereNotNull('name')->get();


        $yesmanMNCompaneies = array();


        if (count($candidateDetails->getSpectrums) == 0) {

            $candidate_exp = $candidateDetails->experiences->where('is_current_employer', '0');

            if (count($candidate_exp) > 0) {
                $exp_can = array();
                foreach ($candidate_exp as $exp) {
                    $start_date = date_create($exp->start_date);
                    $end_date = date_create($exp->end_date);
                    $diff = date_diff($start_date, $end_date);
                    $months_diff = round(($diff->format("%a")) / 30);
                    $exp->diff = $months_diff;
                    $exp_can[] = $exp->diff;


                    $employers = $employersData->filter(function ($item) use ($exp) {
                        return strtolower($item->name) == strtolower($exp->employer_name);
                    });

//                    $employers = $employersData->where('name', 'LIKE', '%' . $exp->employer_name . '%');


                    if (count($employers) > 0) {
                        $yesmanMNCompaneies[] = $employers;
                        $yesman = 37.9;
                    } else {
                        $yesman = 67.33;
                    }


                }
                if (count($exp_can) > 1) {
                    for ($x = 0; $x < count($exp_can); $x++) {
                        if (count($exp_can) == $x + 1) {
                        } else {
                            if ($exp_can[$x] < $exp_can[$x + 1]) {
                                $planned_one = 18.33;
                            } else {
                                $planned_one = 33.33;
                            }
                        }
                    }
                } else if (count($exp_can) == 1) {
                    $planned_one = 33.33;
                }
            }


            $candidate_educations = $candidateDetails->educations->filter(function ($user, $key) {
                return $user->institution_name != null;
            });


//            $candidate_educations =  $candidateDetails->educations
//                ->where('institution_name', '!=', '');

//            dd($candidate_educations);

            $candidate_educationsNames = $candidate_educations->pluck(['institution_name']);

            // $candidate_educationsNames->push('University of Oxford');

            // $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
            //     ->orderBy('rank', 'asc')
            //     ->first();
            try {

                $UniversityGroupData = UniversityGroup::whereIn('university', $candidate_educationsNames->toArray())
                             ->orderBy('rank', 'asc')
                             ->first();
             
             } catch (\Exception $e) {
             
                 $UniversityGroupData=[];
             }

            $innovatorUniversityPoints = '';
            $innovatorExperiencePoints = '';


            if (!empty($UniversityGroupData)) {
                $innovatorUniversityPoints = $UniversityGroupData->point;
            } else {
                $innovatorUniversityPoints = 38.33;
            }

//            $total_experience_in_year = (int) 15;
            $total_experience_in_year = (int)$candidateDetails->total_experience_in_year;

            switch (true) {
                case in_array($total_experience_in_year, range(1, 2)):
                    $innovatorExperiencePoints = 4;
                    break;
                case in_array($total_experience_in_year, range(3, 4)):
                    $innovatorExperiencePoints = 6;
                    break;
                case in_array($total_experience_in_year, range(5, 6)):
                    $innovatorExperiencePoints = 8;
                    break;
                case in_array($total_experience_in_year, range(7, 8)):
                    $innovatorExperiencePoints = 10;
                    break;
                case in_array($total_experience_in_year, range(9, 10)):
                    $innovatorExperiencePoints = 12;
                    break;
                case in_array($total_experience_in_year, range(11, 12)):
                    $innovatorExperiencePoints = 14;
                    break;
                case in_array($total_experience_in_year, range(13, 14)):
                    $innovatorExperiencePoints = 16;
                    break;
                case in_array($total_experience_in_year, range(15, 40)):
                    $innovatorExperiencePoints = 18;
                    break;
                default:
                    $innovatorExperiencePoints = 2;
                    break;
            }

            $responce['innovator_points'] = ($innovatorUniversityPoints + $innovatorExperiencePoints);

//            START THE PROBLEM SOLVER
            $candidate_text = $candidateDetails->objectives . ' ' . $candidateDetails->note . ' ' . $candidateDetails->html_code;
            $candidate_text = strip_tags(strtolower($candidate_text));
            $candidate_text = htmlentities($candidate_text);
            $candidate_text = html_entity_decode($candidate_text);
            $candidate_text = htmlspecialchars($candidate_text);
            $candidate_text = strtolower(str_replace(
                array(
                    "head",
                    "{",
                    "[",
                    "/",
                    "&",
                    "!",
                    '"',
                    ".",
                    "'",
                    "?",
                    "(",
                    ")",
                    "-",
                    ",",
                    "/",
                    "\r",
                    "\n"
                ), '', $candidate_text));
             $candidate_text = preg_replace('/[^A-Za-z0-9 ]/', '', $candidate_text);

            $candidate_text = explode(" ", $candidate_text);
            $candidate_text = array_unique($candidate_text);
            $candidate_text = array_filter($candidate_text);

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $candidate_SoftSkills = SoftSkills::whereIn('able_to_listen', $candidate_text)->count();
            $candidate_ManagementWord = ManagementWord::whereIn('word', $candidate_text)->count();

            $candidate_ActionWordsSoftSkills = ($candidate_ActionWords + $candidate_SoftSkills);
            $candidate_ActionWordsSoftSkillsPints = ($candidate_ActionWordsSoftSkills * 1.3);
            $candidate_ManagementWordPints = ($candidate_ManagementWord * 2.7);
            $problem_solverExperiencePoints = 0;

            switch (true) {
                case in_array($total_experience_in_year, range(2, 4)):
                    $problem_solverExperiencePoints = 12.7;
                    break;
                case in_array($total_experience_in_year, range(5, 40)):
                    $problem_solverExperiencePoints = 17.7;
                    break;
                default:
                    $problem_solverExperiencePoints = 7.2;
                    break;
            }


            $problem_solverPoints = ($candidate_ActionWordsSoftSkillsPints + $candidate_ManagementWordPints + $problem_solverExperiencePoints);

            if ($problem_solverPoints > 75) {
                $problem_solverPoints = 75;
            }

            $responce['problem_solver_percentage'] = $problem_solverPoints;
//           END THE PROBLEM SOLVER


//            START OPTIMIST

            $candidate_ActionWords = ActionWords::whereIn('skill_name', $candidate_text)->count();
            $optimist_ActionWordsPoints = ($candidate_ActionWords * 1.33);
            if ($optimist_ActionWordsPoints > 75) {
                $optimist_ActionWordsPoints = 75;
            }
            $responce['optimist_points'] = $optimist_ActionWordsPoints;
//            END OPTIMIST


//   START LEADER

//            dd($UniversityGroupData);

            $leaderUniversityRank = isset($UniversityGroupData->rank)? $UniversityGroupData->rank: null;

            switch (true) {
                case in_array( $leaderUniversityRank, range(1, 5)):
                    $LeaderUniversityPoints = 18.3;
                    break;
                case in_array( $leaderUniversityRank, range(6, 10)):
                    $LeaderUniversityPoints = 15.3;
                    break;
                case in_array( $leaderUniversityRank, range(11, 15)):
                    $LeaderUniversityPoints = 12.3;
                    break;
                case in_array( $leaderUniversityRank, range(16, 20)):
                    $LeaderUniversityPoints = 9.3;
                    break;
                case in_array( $leaderUniversityRank, range(21, 25)):
                    $LeaderUniversityPoints = 6.3;
                    break;
                default:
                    $LeaderUniversityPoints = 5;
                    break;
            }

            switch (true) {
                case in_array($total_experience_in_year, range(0, 7)):
                    $leaderExperiencePoints = 33.7;
                    break;
                case in_array($total_experience_in_year, range(8, 11)):
                    $leaderExperiencePoints = 43.7;
                    break;
                case in_array($total_experience_in_year, range(12, 17)):
                    $leaderExperiencePoints = 53.7;
                    break;
                case in_array($total_experience_in_year, range(18, 40)):
                    $leaderExperiencePoints = 63.7;
                    break;
                default:
                    $leaderExperiencePoints = 7.2;
                    break;
            }

//            dd($LeaderUniversityPoints, $leaderExperiencePoints);

            $leaderPoints = ($LeaderUniversityPoints + $leaderExperiencePoints);
            $responce['leader'] = $leaderPoints;
//   END LEADER

//   START THE PLANNED ONE
            $candidateExperiencesData = $candidateDetails->experiences->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $jobGaps = array();

            if (count($candidateExperiencesData) > 0) {
                foreach ($candidateExperiencesData as $key => $candidateExperiencesDat) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
//                        dd($candidateExperiencesDat);
                    if (isset($candidateExperiencesData[$key + 1]->start_date)) {
//                        dd($candidateExperiencesData[$key + 1]->start_date);

                        $endthisJobDate = $candidateExperiencesDat->end_date;
                        $nextJobStartDate = $candidateExperiencesData[$key + 1]->start_date;

                    } else {
                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $endthisJobDate = date('Y-m-d');
                            $nextJobStartDate = date('Y-m-d');
                        } else {
                            $endthisJobDate = $candidateExperiencesDat->end_date;
                            $nextJobStartDate = date('Y-m-d');
                        }

                    }

                    $to = new Carbon($endthisJobDate);
                    $from = new Carbon($nextJobStartDate);
                    $diff_in_months = $to->diffInMonths($from);

//                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);

                    if ($diff_in_months > 0) {
                        $jobGaps[] = $diff_in_months;
                    }

                }

            }

            $leaderGapsPoints = 0;
            if (count($jobGaps) > 0) {
                $leaderGapsPoints = 23.33;
            } else {
                $leaderGapsPoints = 33.33;
            }

            $currentWorkingCompany = $candidateDetails->experiences->where('is_current_employer', '1')->first();
$currentWorking_in_YearsPoints = 0;
if($currentWorkingCompany!=''){
            $to = new Carbon($currentWorkingCompany->start_date);
            $from = Carbon::now();
            $currentWorking_in_Years = $to->diffInYears($from);

            switch (true) {
                case in_array($currentWorking_in_Years, range(4, 5)):
                    $currentWorking_in_YearsPoints = 20.7;
                    break;
                case in_array($currentWorking_in_Years, range(6, 7)):
                    $currentWorking_in_YearsPoints = 25.7;
                    break;
                case in_array($currentWorking_in_Years, range(8, 40)):
                    $currentWorking_in_YearsPoints = 15.7;
                    break;

                default:
                    $currentWorking_in_YearsPoints = 0;
                    break;
            }
}

//            $candidate_operational_skillData = $candidateDetails->candidate_operational_skill;
//            $candidate_operational_skill_text = '';
//            if (count($candidate_operational_skillData) > 0) {
//                foreach ($candidate_operational_skillData as $item) {
//                    $candidate_operational_skill_text .=strtolower($item->operational_skills);
//                }
//            }
//
//           $candidate_operational_skillArray= explode(',', $candidate_operational_skill_text);
//            $candidate_operational_skillArray= array_filter($candidate_operational_skillArray);


//            dd($candidate_operational_skill_text);

            if (in_array('training', $candidate_text) || in_array('trained', $candidate_text) || in_array('impart', $candidate_text)) {
                $trainingsPoints = 15.9;
            } else {
                $trainingsPoints = 0;
            }

            $candidateEducationsData = $candidateDetails->educations->sortBy(function ($col) {
                return $col->start_date;
            })->values()->all();

            $educationGaps = array();
            if (count($candidateEducationsData) > 0) {
                foreach ($candidateEducationsData as $key => $itemData) {

//                    dump($key.'-> '.$candidateExperiencesDat->start_date . ' = ' . $candidateExperiencesDat->end_date);
                    if (isset($candidateEducationsData[$key + 1]->start_date)) {

                        $endthisEduDate = $itemData->end_date;
                        $nextEduStartDate = $candidateEducationsData[$key + 1]->start_date;

                    }

                    if(isset($endthisEduDate)){
                       $to = new Carbon($endthisEduDate);
                                        $from = new Carbon($nextEduStartDate);
                                        $eduGapsInYears = $to->diffInYears($from);
                    
                    //                    dump($endthisJobDate . ' = ' . $nextJobStartDate . '---'.$diff_in_months);
                    
                                        if ($eduGapsInYears > 0) {
                                            $educationGaps[] = $eduGapsInYears;
                                        }
                     
                    }

                }

            }


            $leaderEduGapsPoints = 0;
            if ($total_experience_in_year == 0) {
                if (count($educationGaps) > 0) {
                    $leaderEduGapsPoints = 40;
                } else {
                    $leaderEduGapsPoints = 55.7;
                }
            }
            $responce['planned_one'] = ($leaderGapsPoints + $currentWorking_in_YearsPoints + $trainingsPoints + $leaderEduGapsPoints);


//   END THE PLANNED ONE
//   START THE yesman


            $midLevelOrMNCCompanyPints = 0;
            $midLevelOrLastCompanyPints = 0;

            $chackMidLevelCompany = false;
            $chackMNCCompany = false;
            $chackLastCompanyMidLevel = false;

            if (count($yesmanMNCompaneies) > 0) {
                $chackMNCCompany = true;
            } else {
                $chackMidLevelCompany = true;
            }
if($currentWorkingCompany!=''){
            $yesmanLastWorkingMNCompaneies = $employersData->filter(function ($item) use ($currentWorkingCompany) {
//                return strtolower($item->name) == strtolower('Apple Inc');
                return strtolower($item->name) == strtolower($currentWorkingCompany->employer_name);
            });

            if (!empty($yesmanLastWorkingMNCompaneies)) {
                $chackLastCompanyMidLevel = true;
            }
}
            if ($chackMidLevelCompany == true) {


                $MidLevelCompanyWorkingDurationsInMonsthArray = array();


                $candidateWorkingDurationData = $candidateDetails->experiences->sortBy(function ($col) {
                    return $col->start_date;
                })->values()->all();

                if (count($candidateWorkingDurationData) > 0) {
                    foreach ($candidateWorkingDurationData as $key => $candidateWorkingDurationItem) {

                        if ($candidateExperiencesDat->is_current_employer == 1) {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = date('Y-m-d');
                        } else {
                            $startJobDate = $candidateWorkingDurationItem->start_date;
                            $endJobStartDate = $candidateWorkingDurationItem->end_date;
                        }

                        $to = new Carbon($startJobDate);
                        $from = new Carbon($endJobStartDate);
                        $duration_in_months = $to->diffInMonths($from);
                        if ($duration_in_months > 0) {
                            $MidLevelCompanyWorkingDurationsInMonsthArray[] = $duration_in_months;
                        }

                    }

                }

//                dump(max($MidLevelCompanyWorkingDurationsInMonsthArray));

                if (24 < max($MidLevelCompanyWorkingDurationsInMonsthArray)) {


                    $midLevelOrMNCCompanyPints = 67.33;
                } else {
                    $midLevelOrMNCCompanyPints = 53.33;

                }
            } else {

                if ($chackLastCompanyMidLevel == true) {
                    $midLevelOrLastCompanyPints = 12.33;
                }
                if ($chackMNCCompany == true) {
                    $midLevelOrMNCCompanyPints = 37.90;
                }

            }

            $responce['yesman'] = ($midLevelOrMNCCompanyPints + $midLevelOrLastCompanyPints);


            $employee_spectrum = Employeespectrums::create($responce);


        } else {

            $responce['candidate'] = $candidateDetails->getSpectrums->first()->candidate;
            $responce['leader'] = $candidateDetails->getSpectrums->first()->leader;
            $responce['optimist_points'] = $candidateDetails->getSpectrums->first()->optimist_points;
            $responce['innovator_points'] = $candidateDetails->getSpectrums->first()->innovator_points;
            $responce['problem_solver_percentage'] = $candidateDetails->getSpectrums->first()->problem_solver_percentage;
            $responce['planned_one'] = $candidateDetails->getSpectrums->first()->planned_one;
            $responce['yesman'] = $candidateDetails->getSpectrums->first()->yesman;
            $responce['ip'] = $candidateDetails->getSpectrums->first()->ip;


        }


        $responce['talentmone'] = self::getCandidateTalentMine($id);


        return response()->success($responce);

//            return response()->success(compact('candidatespecdetails'));
    }

    public function postLocationadd()
    {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        //print_r($authId);die;
        // Rchilli CURL
        $jsonResult = null;
       // $APIURL="http://hirextra8.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";//OLD API
        $APIURL="https://rest.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
        try
        {
            $file = Input::file('file');
            $description=Input::get('description');
            $assetId = null;
            $imagedata = file_get_contents($file[0]);
            $base64 = base64_encode($imagedata);
            $key='Y0CPAOKBPGW';
            $version = "8.0.0";
            $subUserId = "Hirextra8";
            $data = array(
                "filedata" => $base64,
                "filename" => $file[0]->getClientOriginalName(),
                "userkey" => $key,
                "version" => $version,
                "subuserid" => $subUserId
            );
            $str_data = json_encode($data);
            $ch = curl_init($APIURL);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($str_data))
            );
            $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
        } //try
        catch (Exception $e)
        {
            echo 'Caught exception: ',  $e->getMessage(), "\n";
        } //catch
        $jsonResult = json_decode($jsonResult, true);
        
        $json=$jsonResult["ResumeParserData"];
        $summary='';
        $expe=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];

        if($authuser->parent_id) {
            $candidateId=Candidate::where('Email',$json["Email"])
                ->where('total_experience_in_year',$expe)
                ->where('vendor_id',$authId)
                /*->where('vendor_user_id',$authuser->id)*/
                ->first();
        } else {
            $candidateId=Candidate::where('Email',$json["Email"])
                ->where('total_experience_in_year',$expe)
                ->where('vendor_id',$authId)
                ->first();
        }

        if(!$candidateId) {
            $asset_create_response = null;
            if ( Input::hasFile('file') )
            {
                $files = array();
                $files = Input::file('file');
                $i = 0; foreach ($files as $value) {$i++;}
                if($i == 1) {
                    $file_name = $files[0]->getClientOriginalName();
                    $file_type = $files[0]->getmimeType();
                    $path = base_path()."/public/user_assets/".$authId;
                    $destinationPath = 'user_assets/'.$authId;
                    $url = "/user_assets/".$authId;
                    $files[0]->move($destinationPath,$files[0]->getClientOriginalName());
                    //Insert assets record
                    $assets_create = UserAsset::create([
                        'file_name' => $file_name,
                        'file_type' => $file_type,
                        'path' => $path,
                        'url' => $url,
                        'user_id' => $authId,
                    ]);
                } else {
                    foreach ($files as $singlefile) {
                        $file_name = $singlefile->getClientOriginalName();
                        $file_type = $singlefile->getmimeType();
                        $path = base_path()."/public/user_assets/".$authId;
                        $destinationPath = 'user_assets/'.$authId;
                        $url = "/user_assets/".$authId;
                        $singlefile->move($destinationPath, $singlefile->getClientOriginalName());
                        $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $authId,
                        ]);
                    }//foreach
                } // else
                $assetId = $assets_create->id;   // Assign Id of asset

                if($authuser->parent_id) {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'vendor_user_id' => $authuser->id,
                        'name' => 'Saved Uploaded resumes in private drive.'
                    ]);
                } else {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'name' => 'Saved Uploaded resumes in private drive.'
                    ]);
                }
            } //If
            //End of save raw asset
            //Choose candidate summary if exists.
            $summary = '';
            $executiveSummary=null;
            $managementSummary=null;
            if( $json["Summary"] ){
                $summary = (String) $json["Summary"];
            }   elseif( $json["ExecutiveSummary"] ){
                $executiveSummary = (String) $json["ExecutiveSummary"];
            } elseif( $json["ManagementSummary"] ){
                $managementSummary = (String) $json["ManagementSummary"];
            }
            if($json["DateOfBirth"]){
                $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
            }
            //Getting skill set object
            $SkillSet=$json["SkillKeywords"]["SkillSet"];
            $allSkills = null;
            $operationalSkills = null;
            $softSkills=null;
            $operationalSkills=null;
            //concatenate all the skills and assign to a variable.
            foreach($SkillSet as $skill)
            {
                if( $allSkills)  {
                    $allSkills = $allSkills.', '. $skill["Skill"];
                    if($skill["Type"] == "SoftSkill"){
                        if($softSkills) {
                            $softSkills = $softSkills.', '. $skill["Skill"];
                        } else {
                            $softSkills = $skill["Skill"];
                        }
                    }
                    if($skill["Type"] == "OperationalSkill"){
                        if($operationalSkills) {
                            $operationalSkills = $operationalSkills.', '. $skill["Skill"];
                        } else {
                            $operationalSkills = $skill["Skill"];
                        }
                    }
                } else {$allSkills = $skill["Skill"]; }
            }
            if((String) $json["WorkedPeriod"]["TotalExperienceInYear"] =='' || (String) $json["WorkedPeriod"]["TotalExperienceInYear"]==null){
                $tot_exp=0;
            } else {$tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];}
            //Insert candidate record

            $validator=$this->validate(request(), [
                'current_location' => 'required'

            ]);
            if($validator->fails())
            {
                $candidate = Candidate::create([
                    'full_name' => (String) $json["FullName"],
                    'email' => (String) $json["Email"],
                    'phone' => (String) $json["Phone"],
                    'mobile' => (String) $json["Mobile"],
                    'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                    'gender' => (String) $json["Gender"],
                    'job_profile' => (String) $json["JobProfile"],
                    'address' => (String) $json["Address"],
                    'city' => (String) $json["City"],
                    'state' => (String) $json["State"],
                    'country' => (String) $json["Country"],
                    'zip' => (String) $json["ZipCode"],
                    'current_salary' => (String) $json["CurrentSalary"],
                    'expected_salary' => (String) $json["ExpectedSalary"],
                    'total_experience_in_year' => $tot_exp,
                    'asset_id' => $assetId,
                    'vendor_id' => $authId,
                    'vendor_user_id' => ($authuser->parent_id) ? $authuser->id : 'null',
                    'summary' => $summary,
                    'path' =>  $path ,
                    'title' => (String) $json["TitleName"],
                    'first_name' => (String) $json["FirstName"],
                    'middle_name' => (String) $json["Middlename"],
                    'last_name' => (String) $json["LastName"],
                    'father_name' => (String) $json["FatherName"],
                    'mother_name' => (String) $json["MotherName"],
                    'marital_status' => (String) $json["MaritalStatus"],
                    'nationality' => (String) $json["Nationality"],
                    'language_known' => (String) $json["LanguageKnown"],
                    'unique_id' => (String) $json["UniqueID"],
                    'license_no' => (String) $json["LicenseNo"],
                    'passport_no' => (String) $json["PassportNo"],
                    'pan_no' => (String) $json["PanNo"],
                    'visa_status' => (String) $json["VisaStatus"],
                    'alternate_email' => (String) $json["AlternateEmail"],
                    'cover_letter' => (String) $json["Coverletter"],
                    'certification' => (String) $json["Certification"],
                    'publication' => (String) $json["Publication"],
                    'current_location' => (String) $json["CurrentLocation"],
                    'preferred_location' => (String) $json["PreferredLocation"],
                    'availability' => (String) $json["Availability"],
                    'objectives' => (String) $json["Objectives"],
                    'candidate_references' => (String) $json["References"],
                    'parsing_date' => (String) $json["ParsingDate"],
                    'resume_language' => (String) $json["ResumeLanguage"],
                    'resume_file_name' => (String) $json["ResumeFileName"],
                    'formatted_address' => (String) $json["FormattedAddress"],
                    'permanent_address' => (String) $json["PermanentAddress"],
                    'permanent_city' => (String) $json["PermanentCity"],
                    'permanent_state' => (String) $json["PermanentState"],
                    'permanent_country' => (String) $json["PermanentCountry"],
                    'permanent_zip_code' => (String) $json["PermanentZipCode"],
                    'formatted_permanent_address' => (String) $json["FormattedPermanentAddress"],
                    'industry_category' => (String) $json["Category"],
                    'industry_sub_category' => (String) $json["SubCategory"],
                    'is_privatearea' => 0,
                    'executive_summary' => $executiveSummary,
                    'management_summary' => $managementSummary,
                    'hobbies'=>$json['Hobbies'],
                    'candidate_achievements'=>$json['Achievements'],
                    'html_code'=>$json['HtmlResume'],
                    'note'=>Input::get('description'),

                ]);

                $candidate_response = response()->success(compact('candidate'));
                // Assign last candidate ID
                $lastCandidateId = $candidate->id;
                if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                    foreach ($json["SegregatedExperience"]["WorkHistory"] as $exp)
                    {
                        $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                        $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'
                        $candidate_exp = CandidateExperiences::create([
                            'employer_name' => $exp["Employer"],
                            'job_title' => $exp["JobProfile"]["Title"],
                            'empoyer_city' => $exp["JobLocation"]["EmployerCity"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' =>  date('Y-m-d', strtotime($endDate)),
                            'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                            'candidate_id' => $lastCandidateId
                        ]);
                        $candidate_exp_response = response()->success(compact('candidate_exp'));
                    } //candidate work history foreach
                } //if
                //Insert a record into candidateskillssets table
                $candidate_skill = CandidateSkillsets::create([
                    'skill_set' => (string) $allSkills,
                    'candidate_id' => $lastCandidateId
                ]);
                $candidate_skills_Set_response = response()->success(compact('candidate_skill'));
                $candidate_skills = CandidateSkills::create([
                    'skills' => (string) $json["Skills"],
                    'candidate_id' => $lastCandidateId
                ]);
                $candidate_skills_response = response()->success(compact('candidate_skills'));
                $candidate_operational_skills = CandidateOperationalSkills::create([
                    'operational_skills' => (string) $operationalSkills,
                    'candidate_id' => $lastCandidateId
                ]);
                $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
                $candidate_soft_skills = CandidateSoftSkills::create([
                    'soft_skills' => (string) $softSkills,
                    'candidate_id' => $lastCandidateId
                ]);
                $candidate_soft_skills_response=response()->success(compact('candidate_soft_skills'));
                foreach ($json["SegregatedQualification"]["EducationSplit"] as $edu)
                {
                    if(isset($edu["Institution"]))
                    {
                        $startDate = str_replace('/', '-', $edu["StartDate"]);
                        $endDate = str_replace('/', '-', $edu["EndDate"]);
                        //Insert a record into candidateskillssets table
                        $candidate_educations = CandidateEducations::create([
                            'institution_name' => $edu["Institution"]["Name"],
                            'institution_city' => $edu["Institution"]["City"],
                            'degree' => $edu["Degree"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' => date('Y-m-d', strtotime($endDate)),
                            'aggregate' => $edu["Aggregate"]["Value"],
                            'candidate_id' => $lastCandidateId
                        ]);
                        $candidate_educations_response = response()->success(compact('candidate_educations'));
                    }
                } //foreach
                //Insert Successfull resume posting activity record
                if($authuser->parent_id) {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'vendor_user_id' => $authuser->id,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                } else {
                    $candidateResumePostIn = Activity::create([
                        'vendor_id' => $authId,
                        'resume_id' => $lastCandidateId,
                        'name' => 'Uploaded resume successfully'
                    ]);
                }
                $postedResumeResponse =  response()->success(compact('candidateResumePostIn'));
                return $candidate->id;

            }
            if(count($candidateId) != 0) {
                return response()->error("Profile already exists in Candidate area.");
            } else {
                return response()->error("Profile already exists and submitted Please try with new Profile.");
            }   }

    }

    public function postCandidatecompare()
    {
        $type = Input::get('type');
        $candidate = Input::get('candidate');
        $colors = Input::get('color');
        $joborderId = Input::get('jobId');
        if(is_array($candidate) && count($candidate)==0) {
            $candidatecompare = "";
             return response()->success(compact('candidatecompare'));
        }  
        if($type=="employeespectrum") {
            $candidatecompare = self::getCandidateemployerspectrummul($candidate);
            if(count( $candidatecompare)==0){
                 $candidatecompare = self::getCandidateSpectrum($candidate);
            }
            $compareArr = array();
            $opt_names = array();
            $opt_values = array();
            if($candidatecompare) {
                foreach($candidatecompare as $key => $value){
                    $comArr = array();
                    $names = array('The Innovator', 'The Leader', 'The Planned One', 'The Problem Solver', 'The Optimist',"The Yes Man");
                    $k=0;
                    foreach($value as $keys => $val) {
                    //$opt_names [$key][] = $keys;
                    $opt_names [$key] = $names;//empSpectrumTitles($keys);
                    $opt_values[$key][] = ceil($val);
                        $k++;
                    }
                    $compareArr['values'] = $opt_values;
                    $compareArr['names'] = $opt_names;
                    $compareArr['colors'] = $colors;
                }
            }
            $candidatecompare = $compareArr;
        } else if($type=="talentmining") {
            $candidatecompare = self::getCandidateTalentMinemultiple($candidate);
            $compareArr = array();
            $opt_names = array();
            $opt_values = array();
            if($candidatecompare) {
                foreach($candidatecompare as $key => $value){
                    foreach($value as $keys => $val) {
                        $opt_names[$key][] = $val['name'];
                        $opt_values[$key][] = ceil($val['value']);
                    }
                    $compareArr['values'] = $opt_values;
                    $compareArr['names'] = $opt_names;
                    $compareArr['colors'] = $colors;
                }
            }
            $candidatecompare = $compareArr;
        } else if($type=="personality") {
            if(is_array($candidate) == 1){
                    foreach($candidate as $key => $va){
                        $candidatecompare = self::getCandidatePersonalityinsights($va, $joborderId);
                        $compareArr = array();
                        $opt_names = array();
                        $opt_values = array();
                        if($candidatecompare) {
                            foreach($candidatecompare as $key => $value){
                                $comArr = array();
                                $names = array('Openness', 'Conscientiousness', 'Extraversion', 'Agreeableness', 'Emotional range');
                                $k=0;
                                foreach($value->personality as $keys => $val) {
                                    $opt_values[$key][] = ($val->percentile)*100;
                                    $opt_names [$key] = $names;//empSpectrumTitles($keys);
                                    $k++;
                                }
                                $compareArr['values'] = $opt_values;
                                $compareArr['names'] = $opt_names;
                                $compareArr['colors'] = $colors;
                            }
                        }
                        $candidatecompare = $compareArr;
                    }
            }else{
                    $candidatecompare = self::getCandidatePersonalityinsights($candidate, $joborderId);
                    //print_r($candidatecompare);exit;
                    $compareArr = array();
                    $opt_names = array();
                    $opt_values = array();
                    if($candidatecompare) {
                        foreach($candidatecompare as $key => $value){
                            $comArr = array();
                            $names = array('Openness', 'Conscientiousness', 'Extraversion', 'Agreeableness', 'Emotional range');
                            $k=0;
                            foreach($value->personality as $keys => $val) {
                                $opt_values[$key][] = $val->percentile;
                                $opt_names [$key] = $names;//empSpectrumTitles($keys);
                                $k++;
                            }
                            $compareArr['values'] = $opt_values;
                            $compareArr['names'] = $opt_names;
                            $compareArr['colors'] = $colors;
                        }
                    }
                    $candidatecompare = $compareArr;
                }  
        }
        return response()->success(compact('candidatecompare'));
    }

    public function getCandidateTalentMinemulti($ids) {
        static $responce = array();
        if(count($ids)){
            foreach ($ids as $id) {
            $responce [] =   self::getCandidateTalentMine($id);
            }
        }
        return $responce;
    }
    public function getCandidateTalentMinemultiple($ids) {
        static $responce = array();
        if(count($ids)){
            foreach ($ids as $id) {
                $talentData = self::getCandidateTalentMinemult($id);
                if(is_array($talentData) && count($talentData)>0) {
                    $responce[] = $talentData;
                } else {
                    $talentArr = array(
                                    array('name'=>'Balance Well Being', 'value'=>0),
                                    array('name'=>'Benefits Perks', 'value'=>0),
                                    array('name'=>'Business Reputation', 'value'=>0),
                                    array('name'=>'Career Progression', 'value'=>0),
                                    array('name'=>'Company Culture', 'value'=>0),
                                    array('name'=>'Change Stability', 'value'=>0),
                                    array('name'=>'Diversity Inclusion', 'value'=>0),
                                    array('name'=>'Environmental Social Governance', 'value'=>0),
                                    array('name'=>'Innovation Technology', 'value'=>0),
                                    array('name'=>'Job Satisfaction', 'value'=>0),
                                    array('name'=>'Remuneration', 'value'=>0),
                                    array('name'=>'Team People', 'value'=>0),
                                    array('name'=>'Globalization', 'value'=>0)
                                );
                    $responce[] = $talentArr;
                }
                
            }
        }
        //print_r($responce);
        //exit;
        return $responce;
    }
    public function getCandidateemployerspectrummul($candIds) {
        $candidateemployerspectrum = Employeespectrums::select('innovator_points','leader','planned_one','problem_solver_percentage','optimist_points','yesman')->whereIn('candidate', $candIds)
            ->get()->toArray();
        return $candidateemployerspectrum;;
    }
    public function getCandidatePersonalityinsights($candId, $joborderId) {
        static $responce = array();
        $authuser = Auth::user();
        $decryption_jobid = base64_decode($joborderId);
        $job_id = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        $association = Association::where('job_id',$job_id)->where('candidate_id',$candId)->whereNotNull('vendor_id')->first();
        $vendor_id = $association->vendor_id;
        $candidateskills = AiPersonalityInsight::where('job_id',$job_id)
            ->where('candidate_id',$candId)
            ->limit(1)
            ->get();
        if(count($candidateskills) < 0) {
            foreach ($candidateskills as $key => $candidate) {
                $responce[] = json_decode($candidate->response);
            }
            // print_r($candidatepersonalityinsights);extt;
        } else {
            $candidate = Candidate::where('id',$candId)->with('asset')->with('candidate_skill')->with('candidate_soft_skill')->with('candidate_operational_skill')->with('skill')->with('experiences')->with('educations')->first();
            $text = $candidate->full_name." ".$candidate->hobbies." ".$candidate->language_known." ".$candidate->job_profile." ".$candidate->executive_summary." ".$candidate->management_summary." ".$candidate->objectives." ".$candidate->preferences." ".$candidate->achievements." ".$candidate->summary." ".$candidate->industry_category." ".$candidate->industry_sub_category;
            /*********** WhaiiIBMProxy Start *************/
            
            $curl = curl_init();
            // $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $json['DetailResume']); // Removes special chars.;
            $con_j = preg_replace('/[^A-Za-z0-9\-]/', ' ', $text); // Removes special chars.;
            $post_fields = "{ \n \"contentItems\":[  \n {  \n \"content\":\"$con_j\",  \n \"contenttype\": \"text/plain\"  \n   \n   \n   \n }  \n ]  \n }";
            curl_setopt_array($curl, array(
           // CURLOPT_URL => 'https://whaiipiapi.azure-api.net/WhaiiIBMProxy/v1/sendPiRequest', // old api
            CURLOPT_URL => 'http://88.202.183.32:1729/hirextra/personality/traits',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>$post_fields,
            CURLOPT_HTTPHEADER => array(
                // 'Authorization: b0a3232d88744b87af4955ab874aab3c',
                'Content-Type: application/json'
            ),
            ));
            
            $jsonResult = curl_exec($curl);
            $responce[] = json_decode($jsonResult);
            
            /*********** WhaiiIBMProxy End *************/
        }
        return $responce;
    }
    public function postSkillblockinformations($cand_id='') {
        $candidate_id= Input::get('candidate_id');
        if(!empty($cand_id)) {
           $candidate_id= $cand_id;;
 
        }

        $colors =array('name' =>'#b1f363','name' =>'#7dc5fd','name' =>'#ff9696','name' =>'#90dc62','name' =>'#b0d5e0','name' =>'#fe75a3','name' =>'#dd83ff','name' =>'#2f62e6','name' =>'#6ee58a','#a6dce8','#cfde39','#82559e','#fda444','#7adcf8','#d6f686');        //echo $candidate_id;exit;

        $skillblockInfo = DB::select("select sr.*, c.html_code,c.full_name, c.marital_status, cd.detail_resume,cd.LongestStay,cd.   averageStay,cd.gapperiod from skillblock_resume as sr inner join candidates as c on sr.candidate_id=c.id inner join candidate_details as cd on cd.candidate_id=sr.candidate_id  where sr.candidate_id='".$candidate_id."'");
        
               $colors =Colors::get()->toArray();
        $i=0;
        
        foreach($skillblockInfo as $key=>$value) {
            //print_r($colors[$i]->name);exit();
            if($i < 27) {
                $value->color = $colors[$i]['name'];
            }
            $i++;
        }
       // print_r($skillblockInfo);exit;
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {

            if(isset($skillblockInfo[0]->html_code)) {
                $skillblockInfo[0]->html_code = preg_replace('/font-family/','',$skillblockInfo[0]->html_code);
                $skillblockInfo[0]->html_code = preg_replace('/font-style/','',$skillblockInfo[0]->html_code);
           
                $pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
                preg_match_all($pattern, $skillblockInfo[0]->html_code, $matches);
        
            if(isset($matches[0][0])) {
                $mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6);
                $skillblockInfo[0]->html_code = preg_replace('/'.$matches[0][0].'/', $mask_email, $skillblockInfo[0]->html_code);
            }
            $phonePattern ='/[0-9]{2}[\s][0-9]{8}|[0-9]{3}[\s][0-9]{8}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{6}/';
            //$phonePattern = '/^\+\d(\d{3})(\d{3})(\d{4})$/';
            preg_match_all($phonePattern, $skillblockInfo[0]->html_code, $phonematches);
            //print_r($phonematches); exit;
            if(isset($phonematches[0][0])) {
                $mask_phone = substr_replace($phonematches[0][0], str_repeat("X", strlen($phonematches[0][0])-1), 1, strlen($phonematches[0][0])-2); 
                $skillblockInfo[0]->html_code = preg_replace('/'.$phonematches[0][0].'/', $mask_phone, $skillblockInfo[0]->html_code);
            }

            }
            
        }

        if(!empty($cand_id)) {
             return $skillblockInfo;
       
       } else {
            return response()->success(compact('skillblockInfo'));
       }
                
    }
    public function postCandidateskill() {
        $candidate_id= Input::get('candidate_id');
        $skills=  Input::get('skills');//'GENERAL TERMS';
       $candArr = array();
       $candidInfo = array();
       $candidInfo1 = array();
       $candidInfo2 = array();
        $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword='".$skills."'");
        // print_r($skillblockInfo);exit;
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
            foreach($skillblockInfo as $ky => $words) {
               
                $skill = $words->skill_value;
                $skillArr = explode(',', $skill);
               
                foreach($skillArr as $k => $skill_name) {
                    $skill_name = addslashes($skill_name);
                    $candidateInfo = DB::select("select lastused, experienceinmonths, skill from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($skill_name)."'");
                    // echo $skill_name;
                    // print_r($candidate_id);
                    
                    
                    $expinMonth = 0;
                    if(is_array($candidateInfo) && count($candidateInfo)>0) {
                      
                        foreach($candidateInfo as $key => $value) {
                            // $lastused = "";
                            if(!empty($value->experienceinmonths) || !empty($value->lastused)) {
                                if(!empty($value->experienceinmonths)) {
                                    $expinMonth = $value->experienceinmonths;
                                } else if(!empty($value->lastused)){  
                                    $candInfo = DB::select("select total_experience_in_year, parsing_date, created_at from candidates where id='".$candidate_id."'");
                                    //print_r($candInfo);exit;
                                    if(is_array($candInfo) && count($candInfo)>0) {
                                        $dateArr = explode('/', $value->lastused);
                                        $lastusedDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
                                        $lastusedDate = date('Y-m-d', strtotime($lastusedDate));
                                        $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
    
                                        if($candInfo[0]->parsing_date!="") {
                                            
                                            $paprsingDate = explode(' ', $candInfo[0]->parsing_date);
                                            $parsDate = explode('/', $paprsingDate[0]);
                                            $datePars = $parsDate[2].'-'.$parsDate[1].'-'.$parsDate[0];
                                            $paprsingDate = date('Y-m-d', strtotime($datePars));
                                            //echo $paprsingDate.'=='.$lastusedDate; exit;
                                            if($paprsingDate==$lastusedDate) {
                                                
                                                $time = new DateTime($paprsingDate);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                //echo $total_experience_in_year.'=='.$expDate;exit;
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = date("d/m/Y");
                                                $currentSkill = "(Current Skill)";
                                            } else {
                                                $created_at = $candInfo[0]->created_at;
                                                $time = new DateTime($created_at);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                            }
                                        } else if($candInfo[0]->parsing_date=="") {
                                                $created_at = $candInfo[0]->created_at;
                                                $time = new DateTime($created_at);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                        }
                                    }
                                }
                                 $candidInfo[] = ['name'=>$value->skill, 'y'=>round($expinMonth),'lastused'=>$lastused, 'current'=>$currentSkill];
                                }

                        }
                        // $candArr['names'] = $candidInfo;
                        // $candArr['values'] = $candidInfo1;
                        // $candArr['lastused'] = $candidInfo2;
                    }
                }
                
            }
        }
        return response()->success(compact('candidInfo'));
    }
    // public function postCandidateskillsingle() {
    //     $candidate_id= Input::get('candidate_id');
    //     $skills=  Input::get('skills');//'GENERAL TERMS';
    //     $skillblockname = Input::get('skillblockname');
    //    $candArr = array();
    //    $candidInfo = array();
    //    $candidInfo1 = array();
    //    $candidInfo2 = array();
    //     $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword='".$skills."'");
    //     //print_r($skillblockInfo);exit;
    //     if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
    //         foreach($skillblockInfo as $ky => $words) {
               
    //             $skill = $words->skill_value;
    //             $skillArr = explode(',', $skill);
               
    //             foreach($skillArr as $k => $skill_name) {
                    
    //                 $candidateInfo = DB::select("select lastused, experienceinmonths, skill from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($skill_name)."' and skill like'%".trim($skillblockname)."%'");
    //                 /*echo $skill_name;
    //                 print_r($candidate_id);
    //                 print_r($candidateInfo);
    //                 exit;
    //                 */
    //                 $expinMonth = 0;
    //                 if(is_array($candidateInfo) && count($candidateInfo)>0) {
    //                     foreach($candidateInfo as $key => $value) {
    //                         $lastused = "";
    //                         if(!empty($value->experienceinmonths) || !empty($value->lastused)) {
    //                             if(!empty($value->experienceinmonths)) {
    //                                 $expinMonth = $value->experienceinmonths;
    //                             } else if(!empty($value->lastused)){  
    //                                 $candInfo = DB::select("select total_experience_in_year, parsing_date, created_at from candidates where id='".$candidate_id."'");
    //                                 //print_r($candInfo);exit;
    //                                 if(is_array($candInfo) && count($candInfo)>0) {
    //                                     $dateArr = explode('/', $value->lastused);
    //                                     $lastusedDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
    //                                     $lastusedDate = date('Y-m-d', strtotime($lastusedDate));
    //                                     $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
    
    //                                     if($candInfo[0]->parsing_date!="") {
                                            
    //                                         $paprsingDate = explode(' ', $candInfo[0]->parsing_date);
    //                                         $parsDate = explode('/', $paprsingDate[0]);
    //                                         $datePars = $parsDate[2].'-'.$parsDate[1].'-'.$parsDate[0];
    //                                         $paprsingDate = date('Y-m-d', strtotime($datePars));
    //                                         //echo $paprsingDate.'=='.$lastusedDate; exit;
    //                                         if($paprsingDate==$lastusedDate) {
                                                
    //                                             $time = new DateTime($paprsingDate);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             //echo $total_experience_in_year.'=='.$expDate;exit;
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
                                                
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = date("d/m/Y");
    //                                             $currentSkill = "(Current Skill)";
    //                                         } else {
    //                                             $created_at = $candInfo[0]->created_at;
    //                                             $time = new DateTime($created_at);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = $value->lastused;
    //                                             $currentSkill ="";
    //                                         }
    //                                     } else if($candInfo[0]->parsing_date=="") {
    //                                             $created_at = $candInfo[0]->created_at;
    //                                             $time = new DateTime($created_at);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = $value->lastused;
    //                                             $currentSkill ="";
    //                                     }
    //                                 }
    //                             }
    //                              $candidInfo[] = ['name'=>$value->skill, 'y'=>round($expinMonth),'lastused'=>$lastused, 'current'=>$currentSkill];
    //                             }

    //                     }
    //                     // $candArr['names'] = $candidInfo;
    //                     // $candArr['values'] = $candidInfo1;
    //                     // $candArr['lastused'] = $candidInfo2;
    //                 }
    //             }
                
    //         }
    //     }
    //     return response()->success(compact('candidInfo'));
    // }
    public function postCandidateskillsingle() {

        $candidate_id= Input::get('candidate_id');
        $skills=  Input::get('skills');
        $skillblockname = addslashes(Input::get('skillblockname'));
        $type = Input::get('type');
       $candArr = array();
       $candidInfo = array();
       $candidInfo1 = array();
       $candidInfo2 = array();
       $canddateOntoArr = array();
       $candidateAliasArr = array();
       $canddateOntoData=[];

       if(trim($skillblockname) == '') {
        return response()->success(compact('candidInfo'));
       }
       if($type=="Ontology") {
            $canddateOntoData = DB::select("select Ontology from segregatedskills where candidate_id='".$candidate_id."'  and skill='".trim($skillblockname)."'");
        }
        $candidateAliasArray=[];
        if($type=="alias") {
            $candidateAliasData = DB::select("select alias from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($skillblockname)."'");
            
            if(is_array($candidateAliasData) && count($candidateAliasData)>0) {

                $candidateAliasArrayData = explode(',', $candidateAliasData[0]->alias);

              $candidateAliasArrayData = array_map('trim', $candidateAliasArrayData);

                $genarateData= array();
                $genarateData['name']= $skillblockname;
                $genarateData['value']= 10;
                $genarateData['type']= 'green';
                $genarateData['level']= '#ec107e';
                $genarateData['children']=getArrayChildren( $candidateAliasArrayData);

               $candidateAliasArray = $genarateData;

                
                
            }
        }
        $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword='".$skills."'");

        $candInfo = DB::select("select total_experience_in_year from candidates where id='".$candidate_id."'");
        
        $total_experience_in_year_new = 0;
        if(is_array($candInfo) && count($candInfo) >0) {
            $total_experience_in_year_new = round($candInfo[0]->total_experience_in_year*12);
        }
        //print_r($skillblockInfo);exit;
        
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
            foreach($skillblockInfo as $ky => $words) {
               
                $skill = $words->skill_value;
                $skillArr = explode(',', $skill);
                $skillArr = array_unique($skillArr);
                
                foreach($skillArr as $k => $skill_name) {
                    $skill_name = addslashes($skill_name);
                    $candidateInfo = DB::select("select lastused, experienceinmonths, skill from segregatedskills where candidate_id='".$candidate_id."' and (skill='".trim($skill_name)."' AND skill like '%".trim($skillblockname)."%')");
                    
                    /*echo $skill_name;
                    print_r($candidate_id);
                    print_r($candidateInfo);
                    exit;
                    */
                    
                    $expinMonth = 0;
                    if(is_array($candidateInfo) && count($candidateInfo)>0) {
                        foreach($candidateInfo as $key => $value) {
                            $lastused = "";
                            if(!empty($value->experienceinmonths) || !empty($value->lastused)) {
                                
                                if(!empty($value->experienceinmonths)) {
                                    $expinMonth = $value->experienceinmonths;
                                }
                                if(!empty($value->lastused)){
                                    $candInfo = DB::select("select total_experience_in_year, parsing_date, created_at from candidates where id='".$candidate_id."'");
                                    //print_r($candInfo);exit;
                                    if(is_array($candInfo) && count($candInfo)>0) {
                                        $dateArr = explode('/', $value->lastused);
                                        $lastusedDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
                                        $lastusedDate = date('Y-m-d', strtotime($lastusedDate));
                                        $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
    
                                        if($candInfo[0]->parsing_date!="") {
                                            
                                            $paprsingDate = explode(' ', $candInfo[0]->parsing_date);
                                            $parsDate = explode('/', $paprsingDate[0]);
                                            $datePars = $parsDate[2].'-'.$parsDate[1].'-'.$parsDate[0];
                                            $paprsingDate = date('Y-m-d', strtotime($datePars));
                                            //echo $paprsingDate.'=='.$lastusedDate; exit;
                                            if($paprsingDate==$lastusedDate) {
                                                $lastused = date("d/m/Y");
                                                $currentSkill = "(Current Skill)";
                                            } else {
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                            }
                                        } else if($candInfo[0]->parsing_date=="") {
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                        }
                                    }
                                }
                                if(round($expinMonth) > $total_experience_in_year_new)
                                {
                                    $yy = $total_experience_in_year_new;
                                    $candidInfo[] = ['name'=>$value->skill, 'y'=>$yy,'lastused'=>$lastused, 'current'=>$currentSkill, 'ontology'=>$canddateOntoData, 'alias'=>$candidateAliasArray,'type'=>$type, 'experience_in_month' =>$total_experience_in_year_new];
                                     }
                                     else{
                                         $candidInfo[] = ['name'=>$value->skill, 'y'=>round($expinMonth),'lastused'=>$lastused, 'current'=>$currentSkill, 'ontology'=>$canddateOntoData, 'alias'=>$candidateAliasArray,'type'=>$type, 'experience_in_month' =>$total_experience_in_year_new];
                                     }
                                                                   
                               
                            }
                        }
                       
                    }
                }
                
            }
        }
        //$candidInfo['ontology'] = $canddateOntoData;
        //$candidInfo['alias'] = $candidateAliasData;
        return response()->success(compact('candidInfo'));
    }
    public function postAddskillblock() {
        $candidate_id = Input::get('candidate_id');
        $skillblock = Input::get('skillblock');
        $skillvalue = Input::get('skillvalue');

        $skillInfo = DB::select("select * from skillblock_resume where candidate_id='$candidate_id' and keyword='$skillblock'");
        if(is_array($skillInfo) && count($skillInfo)>0) {
            $error = "Skillblock key value already exits.";
            return response()->error('Skillblock key value already exits.');
        }else {
        DB::insert("insert into skillblock_resume set candidate_id='$candidate_id', keyword='$skillblock', flag='1'");

        
        $skillblockInfo =  $this->postSkillblockinformations($candidate_id);
            
         return response()->success(compact('skillblockInfo'));
        }
    }

    public function postDeleteskillblock() {
        $candidate_id = Input::get('candidate_id');
        $skillblock = Input::get('skillblock');
       
      $match =   DB::delete("delete from skillblock_resume where candidate_id='$candidate_id' and keyword='$skillblock' and flag =1");
      if($match == 0)
      {
        $skillblockInfo =  $this->postSkillblockinformations($candidate_id);
            
         return response()->success(compact('skillblockInfo'));
      }
      else{
        $skillblockInfo =  $this->postSkillblockinformations($candidate_id);
        return response()->success(compact('skillblockInfo'));
      }
      
    }
    
    public function postMoveskillblock($cand_id='') {
        $candidate_id = Input::get('candidate_id');
        $skillblock = Input::get('skillblock');
        $skillvalue = Input::get('skillvalue');

        $skillInfo = DB::select("select * from skillblock_resume where candidate_id='$candidate_id' and skill_value='$skillvalue'");
        if(is_array($skillInfo) && count($skillInfo)>0) {
            $error = "Skillblock key value already exits.";
            return response()->success(compact('error'));
        }else {

            $skillblockData = DB::select("select id, skill_value from skillblock_resume where candidate_id='$candidate_id' and keyword='$skillblock'");
            //print_r($skillblockData);exit;
            if(is_array($skillblockData) && count($skillblockData)>0) {
                
                    if(strpos($skillblockData[0]->skill_value, ',')) {

                        $skillArr = explode(",", trim($skillblockData[0]->skill_value));
                       // $skillvalue = $skillblockData[0]->skill_value;
                        if(is_array($skillArr)) {
                            foreach($skillArr as $key => $value) {
                                $skillDataArr[] = trim($value);
                            }
                            if(!in_array(trim($skillvalue), $skillDataArr)) {
                                $skillvalue = $skillblockData[0]->skill_value.','.$skillvalue;
                            } else {
                                $skillvalue = $skillblockData[0]->skill_value;
                            }
                        } 
                    } else {
                        if(!empty($skillblockData[0]->skill_value)) {
                            $skillvalue = $skillblockData[0]->skill_value.','.$skillvalue;
                        } 
                    }
                    DB::update("update skillblock_resume set skill_value='$skillvalue' where id='".$skillblockData[0]->id."'");

                
            } else {
                DB::insert("insert into skillblock_resume set candidate_id='$candidate_id', keyword='$skillblock', skill_value='$skillvalue', flag='1'");

            }
            $skillblockInfo =  $this->postSkillblockinformations($candidate_id);
                
             return response()->success(compact('skillblockInfo'));
        }
    }

    public function postSkilltypefiledata(){
        $authuser = Auth::user();
        $skillType = Input::get('skillType');
        $job_id = Input::get('job_id');
        //print_r($skillType);
       // print_r($job_id);
        
        $vendor = $authuser->id;
        // print_r($vendor);
            $privateAreaCheck = Input::get('privateAreaCheck');
            //print_r($privateAreaCheck);exit;
        if($privateAreaCheck == 1){
            $private = "y";
        }else{$private = "n";}
        if($skillType == 'preferredSkills'){
            $skills_dump = DB::select("select sr.skills_preferred from job_orders as sr  where sr.id='".$job_id."'");
            $skills = $skills_dump[0]->skills_preferred;
        }else if($skillType == 'requiredSkills'){
            $skills_dump = DB::select("select sr.skills_required from job_orders as sr  where sr.id='".$job_id."'");
            $skills = $skills_dump[0]->skills_required;
        }
        $array_skills = explode(',', $skills);
        $location_dump = DB::select("select lo.city_name from job_citys as lo  where lo.job_id='".$job_id."'");
        $loc_dta = array();
        foreach ($location_dump as  $value) {
                $variable = substr($value->city_name, 0, strpos($value->city_name, "/"));
                //print_r($variable);
                array_push($loc_dta, $variable);
            }
            // $location = json_encode($loc_dta);
            //print_r($location);
        $APIURL_SM="http://88.202.183.32:1720/python/hirextra/skills/match";
        $data_pd = array(
            "skills" => $array_skills,
            "location" =>$loc_dta,
            "vendor" => $vendor,
            "private" =>$private
        );

        $str_data_sm = json_encode($data_pd);
            // print_r($str_data_sm);exit;
        $ch = curl_init($APIURL_SM);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data_sm);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($str_data_sm))
        );
        $candidateIds = curl_exec($ch);       
        $can_resp_dump = json_decode($candidateIds,true);
     
            //$can_dump = {"ids":[33498,33524,33543]};

        //$CandidateInfo = Candidate::whereIn('id', $candidateIds)->get();
        //write here a code based on responce from api call
        //print_r($can_resp_dump["ids"]);
        $can_id_dta = array();
        foreach($can_resp_dump["ids"] as $item) {
            array_push($can_id_dta, $item);
        }
        // print_r($can_id_dta);
        $candidates = Candidate::whereIn('id', $can_id_dta)
                        ->with('skill')
                        ->with('first_association')
                        ->orderBy('updated_at', 'desc')
                        ->get();
                        //print_r("candidates data: ");
                        //print_r($candidates);
        foreach ($candidates as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $numbers = ['encrypted_canId'=>$encrypted];
            $candidate['numbers'] = $numbers;
            $candidate['notes'] ="";
            $assingedvendorcandidates =  DB::table('candidate_points')->select('over_all_status')->where('candidate_id', $candidate['id'])->first();       

            $candidate['candidate_points']=$assingedvendorcandidates;
            $candidate_exp =  DB::table('candidate_experiences')->select('total_experienceIn_year')->where('candidate_id', $candidate['id'])->first();
            $candidate['candidate_exp']=$candidate_exp;
            $candidate_details =  DB::table('candidate_details')->select('gapperiod','averageStay','LongestStay')->where('candidate_id', $candidate['id'])->first();
            $candidate['candidate_details']=$candidate_details;

        }

        foreach ($candidates as $key => $all_associations) {
            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;
            foreach ($all_associations['first_association'] as $key => $value) {
                if($value['candidate_status'] != null) {
                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }
                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach
            if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;
        }  // outer foreach
        //print_r($candidates);
        return response()->success(compact('candidates'));
    }

    public function postOntologymap() {
        $skills=  Input::get('resume');
             $candidateInfo = DB::select("select * from ontology ");
             foreach ($candidateInfo as  $value) {
                if(strpos($skills, $value->skill))
                {
                   $skills= preg_replace('/\b'.$value->skill.'\b/', '<span class="ontologyslap dalfis solarbuddi">'.$value->skill.'</span>', $skills);
                }
            }
           
        return response()->success(compact('skills'));
    }
     public function postDetailedresumemm() {
       
        $id=  Input::get('id');
        $color=  Input::get('color');
        $skills=  Input::get('htmlcode');
        $vall = Input::get('value');

       
       $val = explode(',', $vall);
       if($val[0]== '')
       {
        $removed = array_shift($val);
         $candidateInfo = DB::select("select * from skillblock_resume where id='$id'");
          $val=str_replace("/","",$val);

             foreach ($val as  $value) {
            if($value == ' C' || $value == ' C++' || $value ==' C#' || $value == 'C++' || $value == 'C' )
             {
                         
             }
             else{

                $skills= preg_replace("/".$value."\b/i", "<span class='nextsalsolnip dalfin' style='background:".$color."'>".$value."</span>", $skills); 
                
             }

       }
   }
       else{
            $candidateInfo = DB::select("select * from skillblock_resume where id='$id'");
             $val=str_replace("/","",$val);

             foreach ($val as  $value) {
               // print_r($value);exit();
            if($value == ' C' || $value == ' C++' || $value ==' C#' || $value == 'C++' || $value == 'C' )
             {
                         
             }
             else{

                $skills= preg_replace("/".$value."\b/i", "<span class='nextsalsolnip dalfin' style='background:".$color."'>".$value."</span>", $skills); 
                
             }
       }
       
        //print_r($removed);exit();
      
  
            }
           
        return response()->success(compact('skills'));
    }
    public function postDetailedresumemmdelete() {
       
        $id=  Input::get('id');
        $color=  Input::get('color');

        $skills=  Input::get('htmlcode');
        $vall = Input::get('value');
       
       $val = explode(',', $vall);
             $candidateInfo = DB::select("select * from skillblock_resume where id='$id'");
             //print_r($val);exit();
             foreach ($val as  $value) {
                /*if(strpos($skills, $value->skill))
                {*/
                   $skills= str_replace('<span class=\"nextsalsolnip dalfin\" style=\"background:#46BFBD\"> Unix.</span>', $value, $skills);
               // }
            }
           
        return response()->success(compact('skills'));
    }
    public function postOntologytitle()
    {
         $title=  Input::get('skillontology');
        // print_r($title); exit;
        $candidate_id = Input::get('candidate_id');
        $matchtitle = DB::select("select Ontology from segregatedskills where skill='$title' AND candidate_id='$candidate_id'");
        return response()->success(compact('matchtitle'));
    }

         public function postAnalyse()
    {
        $title=  Input::get('data');
        $skills=  Input::get('htmlcode');
        $candidate_id = Input::get('candidate_id');

        $matchtitle = DB::select("select * from candidate_details where candidate_id = $candidate_id and detail_resume like'%".$title."%' ");
        $candidate_location = \App\VendorCandidateNotes::select('present_location','relocate_locations')->where('candidate_id',$candidate_id)->get()->toArray();
        $present_loc = explode("/", $candidate_location[0]['present_location']);
        $relocate_loc = explode("/", $candidate_location[0]['relocate_locations']);

        if($present_loc[0] == $title || $relocate_loc[0] ==  $title)
        {
            $CandidateLocation = "Location Is Match"; 

            $candidInfo[] = ['companydata'=>$CandidateLocation,'alias'=>''];
        }
        else{
            $CandidateLocation = $title." Location is Not Match";
        
        

        $candidateAliasArray=[];
       
        $candidateAliasData = DB::select("select alias from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($title)."'");

            if(is_array($candidateAliasData) && count($candidateAliasData)>0) {

              $candidateAliasArrayData = explode(',', $candidateAliasData[0]->alias);

              $candidateAliasArrayData = array_map('trim', $candidateAliasArrayData);

                $genarateData= array();
                $genarateData['name']= $title;
                $genarateData['value']= 10;
                $genarateData['type']= 'green';
                $genarateData['level']= '#ec107e';
                $genarateData['children']=getArrayChildren( $candidateAliasArrayData);

               $candidateAliasArray = $genarateData;
            }
            else{
                $ApiDataa = $title." not found";
            }

        $candInfo = DB::select("select total_experience_in_year,parsing_date,first_name,last_name from candidates where id='".$candidate_id."'");
        $last = explode(' ', $candInfo[0]->parsing_date);
        $lastused = $last[0];
        $candidate_name = $candInfo[0]->first_name.' '. $candInfo[0]->last_name;
        $total_experience_in_year_new = 0;
        if(is_array($candInfo) && count($candInfo) >0) {
            $total_experience_in_year_new = round($candInfo[0]->total_experience_in_year*12);
            $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
        }

            if(isset($matchtitle) && count($matchtitle)>0)
            {

            if(is_array($candidateAliasArray) && count($candidateAliasArray)>0)
            {
                $ApiDataa = $title." not found";
            }
            else{
               $checkDomain = CandidateExperiences::where('employer_name', $title)->first();
               if((!empty($checkDomain)) && $checkDomain['empoyer_city'] !='' &&  $checkDomain['end_date'] != ''  &&  $checkDomain['start_date'] != '' && $checkDomain['job_title'] && $checkDomain['total_experienceIn_year'] != Null )
               {
                $ApiDataa = "Worked as a " .$checkDomain['job_title']. " in " .$checkDomain['employer_name']. " located in " .$checkDomain['empoyer_city']. " city from " .$checkDomain['start_date']. " to ".$checkDomain['end_date']. " had  a total experience of ".$checkDomain['total_experienceIn_year']. " years";
               }
               else if((!empty($checkDomain)) && $checkDomain['empoyer_city'] !='' &&  $checkDomain['start_date'] != '' && $checkDomain['job_title'] && $checkDomain['total_experienceIn_year'] != Null)
               {
                $ApiDataa =  "Worked as a " .$checkDomain['job_title']. " in " .$checkDomain['employer_name']. " located in " .$checkDomain['empoyer_city']. " city currently from " .$checkDomain['start_date']. " and had  a total experience of ".$checkDomain['total_experienceIn_year']. " years";
               }


               else if((!empty($checkDomain))  &&  $checkDomain['end_date'] != '' &&  $checkDomain['start_date'] != '' && $checkDomain['job_title']  )
               {
                $ApiDataa =  "Worked as a " .$checkDomain['job_title']. " in " .$checkDomain['employer_name']. " from " .$checkDomain['start_date']. " to ".$checkDomain['end_date'];
               }


              else if((!empty($checkDomain)) && $checkDomain['empoyer_city'] !=''  && $checkDomain['job_title'] && $checkDomain['total_experienceIn_year'] != Null )
               {
                $ApiDataa = "Worked as a " .$checkDomain['job_title']. " in " .$checkDomain['employer_name']. " located in " .$checkDomain['empoyer_city']. " city had  a total experience of ".$checkDomain['total_experienceIn_year']. " years";
               }


              else if((!empty($checkDomain)) && $checkDomain['empoyer_city'] !='' &&  $checkDomain['end_date'] != ''  &&  $checkDomain['start_date'] != '' && $checkDomain['job_title'] )
               {
                $ApiDataa = "Worked as a " .$checkDomain['job_title']. " in " .$checkDomain['employer_name']. " located in " .$checkDomain['empoyer_city']. " city from " .$checkDomain['start_date']. " to ".$checkDomain['end_date'];
               }


           else if (empty($checkDomain)) {
                $curl = \curl_init();
                \curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://company.clearbit.com/v1/domains/find?name=' .$title,        
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                    ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);
               
                $ApiData = json_decode($response, true);
                if(isset($ApiData['error']['message']) == 'Unknown company.')
                {
                    $ApiDataa = $title. " Data Not Found";
                }
                else{
                if(!empty($ApiData))
                {
                $curl = \curl_init();
                \curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://person-stream.clearbit.com/v2/combined/find?email=' .'abc@'.$ApiData['domain'],
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                    ),
                ));
                $responsee = curl_exec($curl);
                curl_close($curl);
                $ApiDataa = json_decode($responsee, true);
                }
                $ApiDataa = $title.' Not Found';
            }
                
            } 
        }
    }
    else{
    $ApiDataa = $title.' Not Found';
   }
            


        $releated_skill = DB::select("select alias from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($title)."'");

        

        
        
       $candidInfo[] = ['lastused'=>$lastused, 'alias'=>$candidateAliasArray,'experience_in_month' => $total_experience_in_year_new,'experience_in_years' =>$total_experience_in_year,'candidate_name' =>$candidate_name,'releated_skill' =>$releated_skill,'companydata' => $ApiDataa,'location'=>$CandidateLocation];
       }
        return response()->success(compact('candidInfo'));
    }

         public function postTalentmining()
    {
        $title=  Input::get('data');
        $skills=  Input::get('htmlcode');
        $candidate_id = Input::get('candidate_id');

        $matchtitle = DB::select("select * from candidate_details where candidate_id = $candidate_id and detail_resume like'%".$title."%' ");
        if(isset($matchtitle) && count($matchtitle)>0) {

        $candidateAliasArray=[];
       
        $candidateAliasData = DB::select("select alias from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($title)."'");

        if(is_array($candidateAliasData) && count($candidateAliasData)>0) {
            $ApiDataa = Null;
        }
        else{
            $checkDomain = ClearBitCompany::where('name', $title)->first();

            if (empty($checkDomain)) {
                $curl = \curl_init();
                \curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://company.clearbit.com/v1/domains/find?name=' .$title,        
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                    ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);
               
                $ApiData = json_decode($response, true);
                //print_r($ApiData);exit();
                if(!empty($ApiData))
                {
                $curl = \curl_init();
                \curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://person-stream.clearbit.com/v2/combined/find?email=' .'abc@'.$ApiData['domain'],
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                    ),
                ));
                $responsee = curl_exec($curl);
                curl_close($curl);
                $ApiDataa = json_decode($responsee, true);
                }
                else{
                    $ApiDataa = "Company Data Not Found";
                }
            } 
            else{
                $ApiDataa = $checkDomain;
            }
        }

       $candidInfo[] = ['Company_data' => $ApiDataa];
   }
   else{
    $candidInfo = 'Data Not Found';
   }
       
        return response()->success(compact('candidInfo'));
    }


    
   public function postMatchcheck()
    {
        $candidate_id = Input::get('candidate_id');
        $job_id = Input::get('job_id');
        
        $currentjob = JobOrders::where('id',$job_id)->select('skills_preferred','skills_required')->get()->toArray();
        $skills_preferred = explode(',', $currentjob[0]['skills_preferred']);
        $skills_required = explode(',', $currentjob[0]['skills_required']);
        
        $mergeskill = array_merge($skills_preferred, $skills_required);
              $authuser = Auth::user();

 

            if($authuser->role_id == 10)
        {
           $jobs=Association::where('accountmanager_id',$authuser->id)
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->with('job')
                                ->get(); 
        }
        else if($authuser->role_id == 5)
        {
            $jobs=Association::where('employer_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->with('job')
                                ->get();
        }
        else if($authuser->role_id == 6)
        {
         $jobs=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->with('job')
                                ->get();   
        }
            foreach ($jobs as  $value) {
            $job_skills_preferred = explode(',', $value['job']['skills_preferred']);
            $job_skills_required = explode(',', $value['job']['skills_required']);
            
            $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);
            $value['matchskill'] = array_intersect($mergedJobSkills,$mergeskill);
            
             }
              if($authuser->role_id == 10)
        {
             $match=Association::where('accountmanager_id',$authuser->id)
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->where('candidate_id', $candidate_id)
                                ->where('job_id', $job_id)
                                ->with('Candidate')
                                ->with('CandidatePoints')
                                ->whereHas('CandidatePoints', function ($query) use ($job_id) {
                $query->where('job_id', '=', $job_id);
            })->get();
        }
        else if($authuser->role_id == 6)
        {
            $match=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->where('candidate_id', $candidate_id)
                                ->where('job_id', $job_id)
                                ->with('Candidate')
                                ->with('CandidatePoints')
                                ->whereHas('CandidatePoints', function ($query) use ($job_id) {
                $query->where('job_id', '=', $job_id);
            })->get();
        }
        elseif ($authuser->role_id == 5) {
             $match=Association::where('employer_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->where('candidate_id', $candidate_id)
                                ->where('job_id', $job_id)
                                ->with('Candidate')
                                ->with('CandidatePoints')
                                ->whereHas('CandidatePoints', function ($query) use ($job_id) {
                $query->where('job_id', '=', $job_id);
            })->get();
        }


            $matchometer = $match[0]['CandidatePoints'];
                               
             return response()->success(compact('jobs','matchometer'));
    }
     public function postTalentminingskillmatch()
    {
        $title=  Input::get('data');
        $skills=  Input::get('htmlcode');
        $candidate = Input::get('candidate_id');

    
        static $responce = array();


        $candidateDetails = Candidate::with(['getTalentMine'])->where('id', $candidate)
            ->first();

            if (!empty($candidateDetails->getTalentMine) && count($candidateDetails->getTalentMine) == 0)
            {
                $checkDomain = ClearBitCompany::where('name', 'LIKE', '%' .$title )->first();
                if (empty($checkDomain)) {
    
                    $curl = \curl_init();
                    \curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://company.clearbit.com/v1/domains/find?name=' .$title,        
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);
                   
                    $ApiData = json_decode($response, true);
                    //print_r($ApiData);exit();
                    if(!empty($ApiData))
                    {
                    $curl = \curl_init();
                    \curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://person-stream.clearbit.com/v2/combined/find?email=' .'abc@'.$ApiData['domain'],
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Bearer ' . \Config::get('app.api_clearbit')
                        ),
                    ));
                    $responsee = curl_exec($curl);
                    curl_close($curl);
                    $getinfo = json_decode($responsee, true);
                    }
                    else{
                        $getinfo = "Company Data Not Found";
                    }
                }
                else{
    
                    $getinfoo = json_decode($checkDomain, true);
                    //print_r($getinfoo);exit();
                }
    
                $balance_well_being_compType = 0;
                $balance_well_being_EmpHeadCount = 0;
                $balance_well_being_Revenue = 0;
                $balance_well_being_UserExp = 0;
                $balance_well_being_FoundedYear = 0;
                $balance_well_being_LocationofHQ = 0;
    
                $benefits_perks_compType = 0;
                $benefits_perks_Revenue = 0;
                $benefits_perks_UserExp = 0;
                $benefits_perks_AvgStay = 0;
    
                $business_reputation_compType = 0;
                $business_reputation_EmpHeadCount = 0;
                $business_reputation_FoundedYear = 0;
                $business_reputation_Revenue = 0;
                $business_reputation_JobCountryCheck = 0;
    
    
                $career_progression_compType =  0;
                $career_progression_EmpHeadCount =  0;
                $career_progression_FoundedYear =  0;
                $career_progression_UserExpGap =  0;
                $career_progression_AvgStay =  0;
    
    
                $company_culture_compType = 0;
                $company_culture_EmpHeadCount = 0;
                $company_culture_FoundedYear = 0;
                $company_culture_Revenue = 0;
                $company_culture_EduCountryCheck = 0;
                 $company_culture_JobCountryCheck = 0;
    
    
                $change_stability_compType = 0;
                $change_stability_EmpHeadCount = 0;
                $change_stability_Revenue = 0;
                $change_stability_EduCountryCheck = 0;
                $change_stability_AvgStay = 0;
    
    
                $innovation_technology_compType = 0;
                $innovation_technology_EmpHeadCount = 0;
                $innovation_technology_FoundedYear = 0;
                $innovation_technology_Revenue = 0;
                $innovation_technology_EduCountryCheck = 0;
    
    
                $job_satisfaction_compType = 0;
                $job_satisfaction_EmpHeadCount = 0;
                $job_satisfaction_Revenue = 0;
                $job_satisfaction_FoundedYear = 0;
                $job_satisfaction_UserExp = 0;
                $job_satisfaction_AvgStay = 0;
    
                $remuneration_compType = 0;
                $remuneration_EmpHeadCount = 0;
                $remuneration_Revenue = 0;
                $remuneration_UserExp = 0;
                $remuneration_AvgStay = 0;
    
                $team_people_compType = 0;
                $team_people_EmpHeadCount = 0;
                $team_people_Revenue = 0;
                $team_people_UserExp = 0;
                $team_people_AvgStay = 0;
    
    
                $globalization_compType = 0;
                $globalization_EmpHeadCount = 0;
                $globalization_Revenue = 0;
                $globalization_FoundedYear = 0;
                $globalization_JobCountryCheck = 0;
    
                //  balance_well_being
    
                if (!empty($getinfo)) {
    
                    //print_r($getinfo);exit();
                    if ($getinfo == "Company Data Not Found" || $getinfo['company']['type'] == 'public' || $getinfo['company']['type'] == 'private' ) {
                        $balance_well_being_compType = 20;
                        $benefits_perks_compType = 40;
                        $business_reputation_compType = 20;
                        $career_progression_compType = 20;
                        $change_stability_compType = 20;
                        $innovation_technology_compType = 20;
                        $job_satisfaction_compType = 20;
                        $remuneration_compType = 20;
                        $team_people_compType = 20;
                        $globalization_compType = 20;
                    }
                     else {
                        $balance_well_being_compType = 10;
                        $benefits_perks_compType = 20;
                        $business_reputation_compType = 5;
                        $career_progression_compType = 10;
                        $change_stability_compType = 10;
                        $innovation_technology_compType = 10;
                        $job_satisfaction_compType = 10;
                        $remuneration_compType = 10;
                        $team_people_compType = 10;
                        $globalization_compType = 10;
                    }
    
    
                    //$metrics = json_decode($getinfo['metrics'], true);
                    //$geo = json_decode($getinfo['company']['geo'], true);
    
                    if (!empty($getinfo['company']['metrics'])) {
    
                        if ($getinfo['company']['metrics']['employees'] != '') {
                            $empcount = $getinfo['company']['metrics']['employees'];
                            switch (true) {
                                case $empcount <= 100:
                                    $balance_well_being_EmpHeadCount = 10;
                                    $business_reputation_EmpHeadCount = 10;
                                    $career_progression_EmpHeadCount = 10;
                                    $change_stability_EmpHeadCount = 10;
                                    $innovation_technology_EmpHeadCount = 10;
                                    $job_satisfaction_EmpHeadCount = 10;
                                    $remuneration_EmpHeadCount = 10;
                                    $team_people_EmpHeadCount = 10;
                                    $globalization_EmpHeadCount = 10;
                                    break;
                                case $empcount <= 500:
                                    $balance_well_being_EmpHeadCount = 15;
                                    $business_reputation_EmpHeadCount = 15;
                                    $career_progression_EmpHeadCount = 15;
                                    $change_stability_EmpHeadCount = 15;
                                    $innovation_technology_EmpHeadCount = 15;
                                    $job_satisfaction_EmpHeadCount = 15;
                                    $remuneration_EmpHeadCount = 15;
                                    $team_people_EmpHeadCount = 15;
                                    $globalization_EmpHeadCount = 15;
                                    break;
                                case $empcount > 500:
                                    $balance_well_being_EmpHeadCount = 20;
                                    $business_reputation_EmpHeadCount = 20;
                                    $career_progression_EmpHeadCount = 20;
                                    $change_stability_EmpHeadCount = 20;
                                    $innovation_technology_EmpHeadCount = 20;
                                    $job_satisfaction_EmpHeadCount = 20;
                                    $remuneration_EmpHeadCount = 20;
                                    $team_people_EmpHeadCount = 20;
                                    $globalization_EmpHeadCount = 20;
                                    break;
                            }
                        }
    
                        if ($getinfo['company']['metrics']['annualRevenue'] != '') {
                            $annualRevenue = $getinfo['company']['metrics']['annualRevenue'];
                            switch (true) {
                                case $annualRevenue <= 5000000:
                                    $balance_well_being_Revenue = 10;
                                    $benefits_perks_Revenue = 10;
                                    $business_reputation_Revenue = 10;
                                    $change_stability_Revenue = 10;
                                    $innovation_technology_Revenue = 10;
                                    $job_satisfaction_Revenue = 10;
                                    $remuneration_Revenue = 10;
                                    $team_people_Revenue = 10;
                                    $globalization_Revenue = 10;
                                    break;
                                case $annualRevenue <= 1000000:
                                    $balance_well_being_Revenue = 12.5;
                                    $benefits_perks_Revenue = 12.5;
                                    $business_reputation_Revenue = 12.5;
                                    $change_stability_Revenue = 12.5;
                                    $innovation_technology_Revenue = 12.5;
                                    $job_satisfaction_Revenue = 12.5;
                                    $remuneration_Revenue = 12.5;
                                    $team_people_Revenue = 12.5;
                                    $globalization_Revenue = 12.5;
    
                                    break;
                                case $annualRevenue <= 5000000:
                                    $balance_well_being_Revenue = 15;
                                    $benefits_perks_Revenue = 15;
                                    $business_reputation_Revenue = 15;
                                    $change_stability_Revenue = 15;
                                    $innovation_technology_Revenue = 15;
                                    $job_satisfaction_Revenue = 15;
                                    $remuneration_Revenue = 15;
                                    $team_people_Revenue = 15;
                                    $globalization_Revenue = 15;
                                    break;
                                case $annualRevenue > 5000000:
                                    $balance_well_being_Revenue = 20;
                                    $benefits_perks_Revenue = 20;
                                    $business_reputation_Revenue = 20;
                                    $change_stability_Revenue = 20;
                                    $innovation_technology_Revenue = 20;
                                    $job_satisfaction_Revenue = 20;
                                    $remuneration_Revenue = 20;
                                    $team_people_Revenue = 20;
                                    $globalization_Revenue = 20;
                                    break;
                            }
                        }
    
                        $foundedYearData = $getinfo['company']['foundedYear'];
                        $business_reputation_FoundedYear = 0;
                        $career_progression_FoundedYear = 0;
    
    
                        $foundedYearDatadbDate = \Carbon\Carbon::parse($foundedYearData . '-01-01');
                        $foundedYearsCalc = \Carbon\Carbon::now()->diffInYears($foundedYearDatadbDate);
    
                        switch (true) {
                            case in_array($foundedYearsCalc, range(0, 3)) :
                                $business_reputation_FoundedYear = 5;
                                $career_progression_FoundedYear = 5;
                                $innovation_technology_FoundedYear = 5;
                                $job_satisfaction_FoundedYear = 5;
                                $globalization_FoundedYear = 5;
                                break;
                            case in_array($foundedYearsCalc, range(3, 7)):
                                $business_reputation_FoundedYear = 10;
                                $career_progression_FoundedYear = 10;
                                $innovation_technology_FoundedYear = 10;
                                $job_satisfaction_FoundedYear = 10;
                                $globalization_FoundedYear = 10;
                                break;
                            case in_array($foundedYearsCalc, range(7, 12)):
                                $business_reputation_FoundedYear = 15;
                                $career_progression_FoundedYear = 15;
                                $innovation_technology_FoundedYear = 15;
                                $job_satisfaction_FoundedYear = 15;
                                $globalization_FoundedYear = 15;
                                break;
                            case in_array($foundedYearsCalc, range(12, 50000)):
                                $business_reputation_FoundedYear = 20;
                                $career_progression_FoundedYear = 20;
                                $innovation_technology_FoundedYear = 20;
                                $job_satisfaction_FoundedYear = 20;
                                $globalization_FoundedYear = 20;
                                break;
                        }
                    }
    
                    if (!empty($getinfo['company']['geo'])) {
                        if ($getinfo['company']['geo']['countryCode'] != '') {
                            $validareCountryCodesArray = ['UK', 'US', 'EU'];
                            $countryCode = $getinfo['company']['geo']['countryCode'];
                            if (!in_array($countryCode, $validareCountryCodesArray)) {
                                $business_reputation_JobCountryCheck = -10;
                                $globalization_JobCountryCheck = -10;
                            }
                        }
                    }
    
                // balance_well_being
                    $balance_well_being_Data = (
                        $balance_well_being_compType +
                        $balance_well_being_EmpHeadCount +
                        $balance_well_being_Revenue +
                        $balance_well_being_UserExp
                    );
    
    
                    if ($balance_well_being_Data > 0) {
                        if ($balance_well_being_Data > 60) {
                            $balance_well_being_Data = 60;
                        }
                        $responce['balance_well_being'] = $balance_well_being_Data;
                    }
    
    
                // benefits_perks
                    $benefits_perks_data = (
                        $benefits_perks_compType +
                        $benefits_perks_Revenue +
                        $benefits_perks_AvgStay +
                        $benefits_perks_UserExp
                    );
    
                    if ($benefits_perks_data > 0) {
                        if ($benefits_perks_data > 60) {
                            $benefits_perks_data = 60;
                        }
                        $responce['benefits_perks'] = $benefits_perks_data;
                    }
    
                // business_reputation
    
                    $business_reputation_data = (
                        $business_reputation_compType +
                        $business_reputation_EmpHeadCount +
                        $business_reputation_FoundedYear +
                        $business_reputation_Revenue +
                        $business_reputation_JobCountryCheck
                    );
    
                    if ($business_reputation_data > 0) {
                        if ($business_reputation_data > 60) {
                            $business_reputation_data = 60;
                        }
                        $responce['business_reputation'] = $business_reputation_data;
                    }
                // career_progression
    
                    $career_progression_data = (
                        $career_progression_compType +
                        $career_progression_EmpHeadCount +
                        $career_progression_FoundedYear +
                        $career_progression_AvgStay +
                        $career_progression_UserExpGap
                    );
                    if ($career_progression_data > 0) {
                        if ($career_progression_data > 60) {
                            $career_progression_data = 60;
                        }
                        $responce['career_progression'] = $career_progression_data;
                    }
    
                // company_culture
                    $company_culture_data = (
                        $company_culture_compType +
                        $company_culture_EmpHeadCount +
                        $company_culture_FoundedYear +
                        $company_culture_Revenue +
                        $company_culture_JobCountryCheck
                    );
                    if ($company_culture_data > 0) {
                        if ($company_culture_data > 60) {
                            $company_culture_data = 60;
                        }
                        $responce['company_culture'] = $company_culture_data;
                    }
                // change_stability
                    $change_stability_data = (
                        $change_stability_compType +
                        $change_stability_EmpHeadCount +
                        $change_stability_AvgStay +
                        $change_stability_Revenue +
                        $change_stability_EduCountryCheck
                    );
                    if ($change_stability_data > 0) {
                        if ($change_stability_data > 60) {
                            $change_stability_data = 60;
                        }
                        $responce['change_stability'] = $change_stability_data;
                    }
    
                // innovation_technology
                    $innovation_technology_data = (
                        $innovation_technology_compType +
                        $innovation_technology_EmpHeadCount +
                        $innovation_technology_FoundedYear +
                        $innovation_technology_Revenue +
                        $innovation_technology_EduCountryCheck
                    );
                    if ($innovation_technology_data > 0) {
                        if ($innovation_technology_data > 60) {
                            $innovation_technology_data = 60;
                        }
                        $responce['innovation_technology'] = $innovation_technology_data;
                    }
    
                // job_satisfaction
                    $job_satisfaction_data = (
                        $job_satisfaction_compType +
                        $job_satisfaction_EmpHeadCount +
                        $job_satisfaction_Revenue +
                        $job_satisfaction_FoundedYear +
                        $job_satisfaction_AvgStay +
                        $job_satisfaction_UserExp
                    );
    
                    if ($job_satisfaction_data > 0) {
                        if ($job_satisfaction_data > 60) {
                            $job_satisfaction_data = 60;
                        }
                        $responce['job_satisfaction'] = $job_satisfaction_data;
                    }
    
                // remuneration
                    $remuneration_data = (
                        $remuneration_compType +
                        $remuneration_EmpHeadCount +
                        $remuneration_Revenue +
                        $remuneration_AvgStay +
                        $remuneration_UserExp
                    );
                    if ($remuneration_data > 0) {
                        if ($remuneration_data > 60) {
                            $remuneration_data = 60;
                        }
                        $responce['remuneration'] = $remuneration_data;
                    }
                // team_people
                    $team_people_data = (
                        $team_people_compType +
                        $team_people_EmpHeadCount +
                        $team_people_Revenue +
                        $team_people_AvgStay +
                        $team_people_UserExp
                    );
                    if ($team_people_data > 0) {
                        if ($team_people_data > 60) {
                            $team_people_data = 60;
                        }
                        $responce['team_people'] = $team_people_data;
                    }
    
                // globalization
                    $globalization_data = (
                        $globalization_compType +
                        $globalization_EmpHeadCount +
                        $globalization_Revenue +
                        $globalization_FoundedYear +
                        $globalization_JobCountryCheck
                    );
                    if ($globalization_data > 0) {
                        if ($globalization_data > 60) {
                            $globalization_data = 60;
                        }
                        $responce['globalization'] = $globalization_data;
                    }
                }
                else if (!empty($getinfoo))
                { 
                    if ($getinfoo['type'] == 'public' || $getinfoo['type'] == 'private') {
                        $balance_well_being_compType = 20;
                        $benefits_perks_compType = 40;
                        $business_reputation_compType = 20;
                        $career_progression_compType = 20;
                        $change_stability_compType = 20;
                        $innovation_technology_compType = 20;
                        $job_satisfaction_compType = 20;
                        $remuneration_compType = 20;
                        $team_people_compType = 20;
                        $globalization_compType = 20;
                    } else {
                        $balance_well_being_compType = 10;
                        $benefits_perks_compType = 20;
                        $business_reputation_compType = 5;
                        $career_progression_compType = 10;
                        $change_stability_compType = 10;
                        $innovation_technology_compType = 10;
                        $job_satisfaction_compType = 10;
                        $remuneration_compType = 10;
                        $team_people_compType = 10;
                        $globalization_compType = 10;
                    }
    
    
                   /* $metrics = json_decode($getinfoo['metrics'], true);
                    $geo = json_decode($getinfoo['company']['geo'], true);*/
                    $metrics = json_decode($getinfoo['metrics'], true);
                    $geo = json_decode($getinfoo['geo'], true);
                    //print_r($metrics);exit();
                    if (!empty($metrics)) {
                        if ($metrics['employees'] != '') {
                            $empcount = $metrics['employees'];
                            switch (true) {
                                case $empcount <= 100:
                                    $balance_well_being_EmpHeadCount = 10;
                                    $business_reputation_EmpHeadCount = 10;
                                    $career_progression_EmpHeadCount = 10;
                                    $change_stability_EmpHeadCount = 10;
                                    $innovation_technology_EmpHeadCount = 10;
                                    $job_satisfaction_EmpHeadCount = 10;
                                    $remuneration_EmpHeadCount = 10;
                                    $team_people_EmpHeadCount = 10;
                                    $globalization_EmpHeadCount = 10;
                                    break;
                                case $empcount <= 500:
                                    $balance_well_being_EmpHeadCount = 15;
                                    $business_reputation_EmpHeadCount = 15;
                                    $career_progression_EmpHeadCount = 15;
                                    $change_stability_EmpHeadCount = 15;
                                    $innovation_technology_EmpHeadCount = 15;
                                    $job_satisfaction_EmpHeadCount = 15;
                                    $remuneration_EmpHeadCount = 15;
                                    $team_people_EmpHeadCount = 15;
                                    $globalization_EmpHeadCount = 15;
                                    break;
                                case $empcount > 500:
                                    $balance_well_being_EmpHeadCount = 20;
                                    $business_reputation_EmpHeadCount = 20;
                                    $career_progression_EmpHeadCount = 20;
                                    $change_stability_EmpHeadCount = 20;
                                    $innovation_technology_EmpHeadCount = 20;
                                    $job_satisfaction_EmpHeadCount = 20;
                                    $remuneration_EmpHeadCount = 20;
                                    $team_people_EmpHeadCount = 20;
                                    $globalization_EmpHeadCount = 20;
                                    break;
                            }
                        }
    
                        if ($metrics['annualRevenue'] != '') {
                            $annualRevenue = $metrics['annualRevenue'];
                            switch (true) {
                                case $annualRevenue <= 5000000:
                                    $balance_well_being_Revenue = 10;
                                    $benefits_perks_Revenue = 10;
                                    $business_reputation_Revenue = 10;
                                    $change_stability_Revenue = 10;
                                    $innovation_technology_Revenue = 10;
                                    $job_satisfaction_Revenue = 10;
                                    $remuneration_Revenue = 10;
                                    $team_people_Revenue = 10;
                                    $globalization_Revenue = 10;
                                    break;
                                case $annualRevenue <= 1000000:
                                    $balance_well_being_Revenue = 12.5;
                                    $benefits_perks_Revenue = 12.5;
                                    $business_reputation_Revenue = 12.5;
                                    $change_stability_Revenue = 12.5;
                                    $innovation_technology_Revenue = 12.5;
                                    $job_satisfaction_Revenue = 12.5;
                                    $remuneration_Revenue = 12.5;
                                    $team_people_Revenue = 12.5;
                                    $globalization_Revenue = 12.5;
    
                                    break;
                                case $annualRevenue <= 5000000:
                                    $balance_well_being_Revenue = 15;
                                    $benefits_perks_Revenue = 15;
                                    $business_reputation_Revenue = 15;
                                    $change_stability_Revenue = 15;
                                    $innovation_technology_Revenue = 15;
                                    $job_satisfaction_Revenue = 15;
                                    $remuneration_Revenue = 15;
                                    $team_people_Revenue = 15;
                                    $globalization_Revenue = 15;
                                    break;
                                case $annualRevenue > 5000000:
                                    $balance_well_being_Revenue = 20;
                                    $benefits_perks_Revenue = 20;
                                    $business_reputation_Revenue = 20;
                                    $change_stability_Revenue = 20;
                                    $innovation_technology_Revenue = 20;
                                    $job_satisfaction_Revenue = 20;
                                    $remuneration_Revenue = 20;
                                    $team_people_Revenue = 20;
                                    $globalization_Revenue = 20;
                                    break;
                            }
                        }
    
                        $foundedYearData = $getinfoo['foundedYear'];
                        $business_reputation_FoundedYear = 0;
                        $career_progression_FoundedYear = 0;
    
    
                        $foundedYearDatadbDate = \Carbon\Carbon::parse($foundedYearData . '-01-01');
                        $foundedYearsCalc = \Carbon\Carbon::now()->diffInYears($foundedYearDatadbDate);
    
                        switch (true) {
                            case in_array($foundedYearsCalc, range(0, 3)) :
                                $business_reputation_FoundedYear = 5;
                                $career_progression_FoundedYear = 5;
                                $innovation_technology_FoundedYear = 5;
                                $job_satisfaction_FoundedYear = 5;
                                $globalization_FoundedYear = 5;
                                break;
                            case in_array($foundedYearsCalc, range(3, 7)):
                                $business_reputation_FoundedYear = 10;
                                $career_progression_FoundedYear = 10;
                                $innovation_technology_FoundedYear = 10;
                                $job_satisfaction_FoundedYear = 10;
                                $globalization_FoundedYear = 10;
                                break;
                            case in_array($foundedYearsCalc, range(7, 12)):
                                $business_reputation_FoundedYear = 15;
                                $career_progression_FoundedYear = 15;
                                $innovation_technology_FoundedYear = 15;
                                $job_satisfaction_FoundedYear = 15;
                                $globalization_FoundedYear = 15;
                                break;
                            case in_array($foundedYearsCalc, range(12, 50000)):
                                $business_reputation_FoundedYear = 20;
                                $career_progression_FoundedYear = 20;
                                $innovation_technology_FoundedYear = 20;
                                $job_satisfaction_FoundedYear = 20;
                                $globalization_FoundedYear = 20;
                                break;
                        }
                    }
    
                    if (!empty($geo)) {
                        if ($geo['countryCode'] != '') {
                            $validareCountryCodesArray = ['UK', 'US', 'EU'];
                            $countryCode = $geo['countryCode'];
                            if (!in_array($countryCode, $validareCountryCodesArray)) {
                                $business_reputation_JobCountryCheck = -10;
                                $globalization_JobCountryCheck = -10;
                            }
                        }
                    }
    
                    $balance_well_being_Data = (
                        $balance_well_being_compType +
                        $balance_well_being_EmpHeadCount +
                        $balance_well_being_Revenue +
                        $balance_well_being_UserExp
                    );
    
                    if ($balance_well_being_Data > 0) {
                        if ($balance_well_being_Data > 60) {
                            $balance_well_being_Data = 60;
                        }
                        $responce['balance_well_being'] = $balance_well_being_Data;
                    }
    
    
                // benefits_perks
                    $benefits_perks_data = (
                        $benefits_perks_compType +
                        $benefits_perks_Revenue +
                        $benefits_perks_AvgStay +
                        $benefits_perks_UserExp
                    );
    
                    if ($benefits_perks_data > 0) {
                        if ($benefits_perks_data > 60) {
                            $benefits_perks_data = 60;
                        }
                        $responce['benefits_perks'] = $benefits_perks_data;
                    }
    
                // business_reputation
    
                    $business_reputation_data = (
                        $business_reputation_compType +
                        $business_reputation_EmpHeadCount +
                        $business_reputation_FoundedYear +
                        $business_reputation_Revenue +
                        $business_reputation_JobCountryCheck
                    );
    
                    if ($business_reputation_data > 0) {
                        if ($business_reputation_data > 60) {
                            $business_reputation_data = 60;
                        }
                        $responce['business_reputation'] = $business_reputation_data;
                    }
                // career_progression
    
                    $career_progression_data = (
                        $career_progression_compType +
                        $career_progression_EmpHeadCount +
                        $career_progression_FoundedYear +
                        $career_progression_AvgStay +
                        $career_progression_UserExpGap
                    );
                    if ($career_progression_data > 0) {
                        if ($career_progression_data > 60) {
                            $career_progression_data = 60;
                        }
                        $responce['career_progression'] = $career_progression_data;
                    }
    
                // company_culture
                    $company_culture_data = (
                        $company_culture_compType +
                        $company_culture_EmpHeadCount +
                        $company_culture_FoundedYear +
                        $company_culture_Revenue +
                        $company_culture_JobCountryCheck
                    );
                    if ($company_culture_data > 0) {
                        if ($company_culture_data > 60) {
                            $company_culture_data = 60;
                        }
                        $responce['company_culture'] = $company_culture_data;
                    }
                // change_stability
                    $change_stability_data = (
                        $change_stability_compType +
                        $change_stability_EmpHeadCount +
                        $change_stability_AvgStay +
                        $change_stability_Revenue +
                        $change_stability_EduCountryCheck
                    );
                    if ($change_stability_data > 0) {
                        if ($change_stability_data > 60) {
                            $change_stability_data = 60;
                        }
                        $responce['change_stability'] = $change_stability_data;
                    }
    
                // innovation_technology
                    $innovation_technology_data = (
                        $innovation_technology_compType +
                        $innovation_technology_EmpHeadCount +
                        $innovation_technology_FoundedYear +
                        $innovation_technology_Revenue +
                        $innovation_technology_EduCountryCheck
                    );
                    if ($innovation_technology_data > 0) {
                        if ($innovation_technology_data > 60) {
                            $innovation_technology_data = 60;
                        }
                        $responce['innovation_technology'] = $innovation_technology_data;
                    }
    
                // job_satisfaction
                    $job_satisfaction_data = (
                        $job_satisfaction_compType +
                        $job_satisfaction_EmpHeadCount +
                        $job_satisfaction_Revenue +
                        $job_satisfaction_FoundedYear +
                        $job_satisfaction_AvgStay +
                        $job_satisfaction_UserExp
                    );
    
                    if ($job_satisfaction_data > 0) {
                        if ($job_satisfaction_data > 60) {
                            $job_satisfaction_data = 60;
                        }
                        $responce['job_satisfaction'] = $job_satisfaction_data;
                    }
    
                // remuneration
                    $remuneration_data = (
                        $remuneration_compType +
                        $remuneration_EmpHeadCount +
                        $remuneration_Revenue +
                        $remuneration_AvgStay +
                        $remuneration_UserExp
                    );
                    if ($remuneration_data > 0) {
                        if ($remuneration_data > 60) {
                            $remuneration_data = 60;
                        }
                        $responce['remuneration'] = $remuneration_data;
                    }
                // team_people
                    $team_people_data = (
                        $team_people_compType +
                        $team_people_EmpHeadCount +
                        $team_people_Revenue +
                        $team_people_AvgStay +
                        $team_people_UserExp
                    );
                    if ($team_people_data > 0) {
                        if ($team_people_data > 60) {
                            $team_people_data = 60;
                        }
                        $responce['team_people'] = $team_people_data;
                    }
    
                // globalization
                    $globalization_data = (
                        $globalization_compType +
                        $globalization_EmpHeadCount +
                        $globalization_Revenue +
                        $globalization_FoundedYear +
                        $globalization_JobCountryCheck
                    );
    
                    if ($globalization_data > 0) {
                        if ($globalization_data > 60) {
                            $globalization_data = 60;
                        }
                        $responce['globalization'] = $globalization_data;
                    }
                }
                else {
                    $responce = [];
                }
            }
            else {
                    if(!empty($candidateDetails->getTalentMine)){
                    $oldTalemtMone = $candidateDetails->getTalentMine->first();
                    $responce = array(
                        'balance_well_being' => $oldTalemtMone->balance_well_being,
                        'benefits_perks' => $oldTalemtMone->benefits_perks,
                        'business_reputation' => $oldTalemtMone->business_reputation,
                        'career_progression' => $oldTalemtMone->career_progression,
                        'company_culture' => $oldTalemtMone->company_culture,
                        'change_stability' => $oldTalemtMone->change_stability,
        
                        'innovation_technology' => $oldTalemtMone->innovation_technology,
                        'job_satisfaction' => $oldTalemtMone->job_satisfaction,
                        'remuneration' => $oldTalemtMone->remuneration,
                        'team_people' => $oldTalemtMone->team_people,
                        'globalization' => $oldTalemtMone->globalization,
                    );
                }
            }
            


//            dd($responce);


            //   diversity_inclusion
//            if (count($candidate_exp) > 0) {
//                foreach ($candidate_exp as $item) {
//                    if (in_array($item->employer_name, $NasdaqCompanyLists)) {
//                        $responce['diversity_inclusion'] = 72.33;
//                    }
//                }
//            }

  
//        dd($responce);
        $returnData = array();
        if (count($responce) > 0) {
            //\Log::info(print_r($responce, true));
            foreach ($responce as $list => $value) {
                $localItem = array();
                $localItem['color'] = '';
                $localItem['img'] = '';
                $localItem['img_path'] = '';
                $localItem['name'] = $list;
                $localItem['alias'] = $list;
                $localItem['value'] = $value;
                if (isset($value) && $value != '') {
                    switch (true) {
                        case in_array($value, range(0, 48)):
                            $localItem['color'] = '#FFF';
                            break;
                        case in_array($value, range(48, 59)):
                            $localItem['color'] = '#f1c232';
                            break;
                        case in_array($value, range(60, 100)):
                            $localItem['color'] = '#38761d';
                            break;
                    }
                }
                $imageColor = $localItem['color'];

                $localItem['name'] = ucwords(str_replace('_', ' ', $list));

//                dd($candidateDetails);


                $descriptionValue = ($value > 70) ? 'Excellent' : 'Satisfactory  ';


                switch ($list) {
                    case 'balance_well_being':

                        $localItem['img_path'] = 'hx_tm_balance_well_being.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;
                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . ' can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. With this the resource is inclined towards the health of both physical and psychological health and works out to keep it vibrant within the team. ';
                                break;
                            case in_array($value, range(60, 100)):
                                $localItem['description'] = 'The Balance and Well-being component of  ' . $candidateDetails->full_name . '  can be taken as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This shows that the resource can understand the importance of both physical and psychological health in the workplace which will be supporting to elevate the well-being within the team.
';
                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M580.449,1240.766c-3.711-3.716-6.377-14.331-6.377-23.892c0-13.809-3.184-19.116-15.928-25.493
        c-21.23-10.62-37.168-37.7-37.168-61.064c0-29.741,15.4-48.33,56.289-69.033c39.834-20.713,48.32-33.989,26.025-42.49
        c-9.561-3.716-19.658-3.184-36.113,2.656c-30.801,10.625-33.447,10.093-40.889-7.427c-10.615-25.498-5.313-38.77,18.584-47.793
        c11.68-4.258,23.896-11.685,27.617-16.47c7.959-10.62,18.047-1.06,14.336,13.813c-2.129,7.427-10.088,12.739-26.553,16.987
        c-23.896,6.372-26.543,9.028-18.594,21.772c3.711,5.85,7.988,5.85,22.842,0.527c25.488-9.556,56.289-3.179,63.73,13.281
        c10.625,23.901,1.582,38.237-37.178,57.886c-44.072,22.3-49.922,29.204-50.986,56.821c-0.518,18.052,2.656,24.424,16.992,37.168
        c9.561,8.496,20.723,15.4,24.971,15.4c5.84,0,7.959,5.84,7.959,21.24c0,17.524,1.592,21.245,10.098,21.245
        c8.486,0,10.615-4.253,12.207-19.648c1.592-17.524,3.721-20.186,20.186-24.429c22.822-5.845,22.295-5.313,18.057-16.465
        c-2.666-6.899-6.914-8.491-20.195-5.303c-40.352,9.023-61.592,0.522-61.592-24.434c0-16.992,10.098-27.085,43.545-41.948
        c30.801-13.809,46.719-33.462,46.719-57.358c0-24.951-7.422-36.636-32.91-52.568c-15.928-10.088-19.658-15.4-15.4-19.648
        c4.775-4.78,11.152-3.716,25.488,4.248c28.672,15.933,41.426,36.108,41.426,66.377c0,34.517-12.754,50.981-57.363,74.351
        c-19.639,10.083-35.576,21.772-35.576,25.488c0,11.147,15.938,13.804,41.426,6.899c27.607-7.432,35.576-3.188,41.416,22.305
        c2.646,13.271,1.064,18.057-8.506,26.021c-6.377,5.308-16.445,9.561-21.768,9.561c-7.949,0-10.088,3.716-10.088,17.524
        c0,9.561-2.656,20.176-6.367,23.892C612.842,1248.735,588.418,1248.735,580.449,1240.766z"/>
    <path fill="#2c303b" d="M54.731,1138.808c-27.612-14.868-40.352-53.101-27.085-79.121c9.556-18.057,91.343-99.302,100.371-99.302
        s90.801,81.245,100.361,99.302c26.025,50.977-32.397,105.674-84.434,78.589c-13.271-6.899-16.997-6.899-30.269,0
        C95.625,1147.842,71.196,1148.369,54.731,1138.808z M116.328,1113.32l11.689-11.147l12.212,11.147
        c6.904,6.372,19.648,13.271,29.204,14.868c13.804,2.661,19.116,0.532,33.457-13.271c24.951-25.493,19.644-41.426-32.393-93.467
        l-42.48-42.48l-41.953,41.958c-23.369,22.832-43.013,47.256-44.604,54.155c-3.188,16.997,9.556,44.077,23.892,49.927
        C81.279,1131.377,101.465,1126.592,116.328,1113.32z"/>
    <path fill="#2c303b" d="M343.086,1025.698c-40.889-10.62-62.134-56.289-43.022-92.925c7.441-14.346,7.441-14.863-5.308-18.057
        c-6.904-1.602-38.228-2.129-70.093-1.074c-41.953,1.602-65.317,5.313-88.687,14.351c-49.38,18.589-54.697,19.116-69.565,5.84
        c-26.021-24.956-11.68-46.733,45.674-69.565c52.573-21.24,101.958-32.393,134.878-30.801l27.085,1.592l1.592-54.687
        c1.064-39.834,3.184-53.633,7.964-52.051c4.248,1.064,6.904,21.25,7.969,63.73l1.587,62.139h-46.729
        c-50.977,0-68.501,3.711-130.103,27.07c-41.943,16.465-50.444,24.434-39.824,38.77c5.84,7.432,11.147,6.367,53.633-7.959
        c50.981-18.057,39.297-17.002,228.877-17.002c182.139,0,176.826-0.537,225.684,17.002c39.824,13.799,46.191,14.858,53.105,7.959
        c12.754-12.754,0.537-23.369-50.977-43.545c-40.371-15.918-55.762-19.131-105.674-21.777l-58.428-3.184l0.547-59.473
        c0-32.93,1.592-61.074,3.193-63.203c10.078-9.561,14.863,7.979,14.863,53.115v49.385l44.062,3.174
        c23.906,2.139,54.18,6.914,67.441,11.162c41.963,12.744,92.939,35.576,99.307,44.6c11.689,14.883,8.506,37.178-6.904,47.266
        c-13.271,8.496-15.4,8.496-57.344-6.899c-38.77-13.813-49.395-15.405-106.738-15.405c-60.537,0-63.73,0.537-62.139,10.625
        c10.088,57.349,2.656,76.992-32.383,93.462C363.799,1029.424,360.596,1029.951,343.086,1025.698z M383.437,1002.861
        c15.41-8.491,27.09-35.571,23.369-53.628c-6.377-29.204-44.609-45.669-72.222-31.323c-15.4,8.486-27.08,35.571-23.364,53.628
        C317.593,1000.742,355.83,1017.207,383.437,1002.861z"/>
    <path fill="#2c303b" d="M160.405,723.545c-19.121-7.969-29.199-29.209-24.429-50.449c5.308-24.424,20.186-32.402,73.286-39.824
        c65.317-9.57,78.057-9.033,78.057,0.527c0,4.238-3.184,7.959-6.367,7.959c-3.721,0-30.801,3.721-60.005,7.979
        c-56.289,7.969-73.813,18.057-67.974,39.824c5.84,22.295,14.863,23.896,72.217,13.809c66.382-12.217,79.131-12.754,81.782-4.775
        c2.656,7.432-2.124,8.486-76.47,22.295C184.839,728.848,174.214,729.385,160.405,723.545z"/>
    <path fill="#2c303b" d="M429.639,710.273c-56.826-10.615-108.862-22.305-114.697-25.488c-23.901-12.744-21.245-53.643,3.711-66.914
        c14.341-7.432,25.488-6.367,124.795,6.904c96.123,13.262,110.986,16.465,122.666,27.607c23.896,22.314,11.689,69.561-20.176,75.42
        C539.033,729.385,487.002,721.426,429.639,710.273z M554.971,702.314c10.088-10.098,10.615-23.379,1.582-36.133
        c-5.303-6.895-27.607-11.67-101.963-21.768c-117.881-16.465-127.974-16.465-135.405-2.656c-12.212,22.842-1.06,28.145,99.302,48.33
        C526.826,712.393,543.818,713.984,554.971,702.314z"/>
</g>
</svg>';
                        break;
                    case 'benefits_perks':
                        $localItem['img_path'] = 'hx_tm_benefits_perks.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . 'as per the inputs given in the resume. This result plays an important role for this resource to opt any role in the company and seems to be inclined for any discussions.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Benefits & Perks component is ' . $value . ' as per the inputs. Whereas this result denotes that this factor shows predominant effect besides other factors, while being negotiable and flexible.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M120.85,5043.911c-3.887-4.897-3.638-14.683,0.503-18.687c1.631-1.768,4.268-3.145,5.645-3.145
        s4.014,1.377,5.645,3.145c6.65,6.514,2.764,21.948-5.645,21.948C124.614,5047.172,122.48,5046.044,120.85,5043.911z"/>
    <path fill="#2c303b" d="M518.037,5044.541c-3.887-2.261-6.025-9.033-4.512-13.555c1.494-4.141,6.641-7.651,11.152-7.651
        c4.395,0,10.039,6.65,10.039,11.67C534.717,5042.778,524.805,5048.427,518.037,5044.541z"/>
    <path fill="#2c303b" d="M291.216,5032.114c-25.469-4.014-45.288-22.075-51.812-47.295c-4.893-18.691,0.122-40.898,12.422-55.195
        c2.378-2.891,4.385-5.518,4.385-5.898c0-0.376-27.349-0.757-60.845-0.757c-59.214,0-60.967-0.117-63.35-2.505
        c-2.388-2.378-2.505-4.141-2.505-44.536s0.117-42.153,2.505-44.531c2.383-2.388,4.136-2.51,26.343-2.51h23.833v-80.166
        c0-79.16,0-80.166,2.637-83.428c3.516-4.512,10.039-4.512,13.55,0c2.637,3.262,2.637,4.268,2.637,83.555v80.039h56.45l56.455-0.127
        v-55.078c0-38.262,0.376-56.074,1.382-58.203c2.886-6.406,12.92-6.904,16.06-0.879c0.874,1.621,1.377,21.328,1.377,58.33v55.957
        h28.228h28.232v-60.84c0-59.219,0.127-60.977,2.5-63.359c3.135-3.145,10.156-3.262,12.93-0.254
        c1.875,2.012,2.129,8.779,2.373,63.105l0.381,60.718l56.826,0.376l56.709,0.376v-92.085v-92.08l2.891-2.627
        c3.633-3.389,8.398-3.516,12.295-0.381l2.998,2.373l0.381,92.344l0.244,92.334h23.594c23.076,0,23.711,0.122,26.348,2.881
        c2.754,2.886,2.754,3.516,2.754,44.287c0,40.02-0.117,41.523-2.51,44.165l-2.627,2.749H525.81h-61.475l4.893,6.03
        c21.709,25.972,19.443,63.096-5.02,86.812c-3.008,2.886-9.902,7.402-15.43,10.156c-29.355,14.434-66.484,6.03-84.805-19.189
        l-3.379-4.766l-2.51,4.014c-6.025,9.785-19.702,19.565-32.373,23.584C316.426,5032.373,300.752,5033.627,291.216,5032.114z
         M325.591,5010.288c9.282-4.517,19.946-16.06,23.081-24.844c1.885-5.64,2.256-10.659,2.256-33.618v-26.968l-22.583-0.254
        c-37.759-0.498-47.793,1.885-59.839,14.302c-8.652,8.906-12.544,18.071-12.544,30.239c0,20.952,11.919,37.129,31.992,43.652
        c3.511,1.133,9.531,1.631,17.939,1.382C316.685,5013.798,319.692,5013.173,325.591,5010.288z M439.375,5010.537
        c9.785-4.512,16.436-10.781,21.328-20.073c3.633-6.772,4.385-9.404,4.766-18.564c0.625-13.667-2.393-22.207-11.035-31.738
        c-8.789-9.531-16.309-13.296-29.727-14.683c-12.559-1.255-45.674-1.499-50.938-0.498l-3.516,0.757l0.371,27.72
        c0.371,26.973,0.508,28.101,3.633,34.751c5.4,11.416,16.943,21.455,28.486,24.717c3.506,0.874,10.654,1.504,17.803,1.255
        C430.205,5013.93,433.73,5013.173,439.375,5010.537z M288.203,4875.927v-28.853h-70.254h-70.254l-0.371,27.598
        c-0.127,15.181,0,28.228,0.371,29.106c0.376,1.382,14.551,1.631,70.503,1.382l70.005-0.376V4875.927z M414.912,4875.927v-28.853
        l-54.199-0.376l-54.316-0.249v29.478v29.482l54.316-0.249l54.199-0.376V4875.927z M573.603,4875.927v-29.351l-69.873,0.244
        l-70,0.254l-0.381,27.598c-0.117,15.181,0,28.228,0.254,29.106c0.498,1.255,15.059,1.631,70.371,1.631h69.629V4875.927z"/>
    <path fill="#2c303b" d="M599.951,5029.609c-1.875-1.885-2.51-4.141-2.51-8.906c0-7.026,1.377-10.415,5.02-12.422
        c6.279-3.384,12.549,2.764,12.549,12.295C615.01,5030.366,605.977,5035.625,599.951,5029.609z"/>
    <path fill="#2c303b" d="M89.487,5012.548c-3.262-4.141-3.389-7.275-0.127-10.537c2.007-2.012,4.141-2.51,10.41-2.51
        c9.033,0,12.173,2.134,12.173,7.9c0,5.771-4.014,8.408-12.422,8.408C92.998,5015.81,91.743,5015.429,89.487,5012.548z"/>
    <path fill="#2c303b" d="M144.561,5013.3c-3.135-3.135-3.262-8.906-0.249-11.665c3.135-2.891,16.812-3.013,19.565-0.249
        c3.267,3.384,3.643,7.021,1.133,10.532c-2.134,2.759-3.638,3.267-10.161,3.638C148.452,5015.81,146.694,5015.429,144.561,5013.3z"
        />
    <path fill="' . $imageColor . '" d="M568.584,4998.247c-1.377-1.377-2.51-3.887-2.51-5.645c0-5.522,4.023-8.159,12.559-8.159
        c8.525,0,12.539,2.637,12.539,8.159s-4.014,8.154-12.539,8.154C572.734,5000.756,570.596,5000.253,568.584,4998.247z"/>
    <path fill="#2c303b" d="M623.408,4998.5c-2.754-3.145-2.637-9.414,0.127-11.924c1.631-1.504,4.648-2.134,9.912-2.134
        c8.408,0,12.041,2.388,12.041,8.159c0,5.767-3.633,8.154-12.285,8.154C627.295,5000.756,624.922,5000.253,623.408,4998.5z"/>
    <path fill="#2c303b" d="M123.735,4991.718c-4.263-2.256-5.518-5.02-5.518-11.914c0-7.778,2.886-11.665,8.779-11.665
        c5.522,0,8.784,4.263,8.784,11.665c0,3.262-0.503,7.148-1.255,8.403C132.895,4991.347,126.87,4993.349,123.735,4991.718z"/>
    <path fill="#2c303b" d="M600.586,4975.039c-2.637-2.51-3.145-4.268-3.145-10.034c0-8.027,2.764-11.924,8.652-11.924
        c10.039,0,12.432,19.448,3.018,23.711C604.844,4978.803,603.965,4978.549,600.586,4975.039z"/>
    <path fill="#2c303b" d="M69.16,4923.603c-4.009-2.266-6.519-7.905-5.391-12.422c1.006-4.39,6.147-8.281,10.786-8.281
        c5.024,0,11.04,6.025,11.04,11.167C85.596,4921.972,76.064,4927.49,69.16,4923.603z"/>
    <path fill="#2c303b" d="M620.273,4778.701c-6.025-5.645-4.883-14.307,2.383-17.939c5.771-2.764,11.67-0.996,14.434,4.395
        C642.49,4775.566,628.809,4786.611,620.273,4778.701z"/>
    <path fill="#2c303b" d="M290.713,4688.75c-14.678-4.766-50.181-23.33-90.83-47.295l-35.625-21.074l-57.329,20.322
        c-62.1,21.963-62.729,22.08-65.869,14.688c-2.886-7.031-0.498-10.283,10.415-14.434c25.215-9.658,111.401-39.521,113.911-39.385
        c1.631,0,20.073,10.039,40.894,22.324c41.03,24.082,76.025,42.656,88.447,46.787c4.644,1.641,11.04,2.637,15.684,2.637
        c15.43-0.127,128.594-12.295,132.48-14.297c8.398-4.258,12.793-13.428,11.035-22.832c-1.133-5.898-9.15-13.926-15.176-15.059
        c-2.764-0.498-25.469,1.387-55.703,4.521c-55.825,5.762-57.71,5.645-66.362-0.879c-9.287-7.031-12.295-21.709-6.655-32.744
        c3.14-6.143,11.67-12.168,18.691-13.291c14.561-2.266,148.672-14.688,153.936-14.18c5.264,0.371,15.674,5.508,63.975,30.986
        c85.566,45.039,78.535,42.031,86.689,38.135c7.148-3.389,10.166-13.174,6.66-21.074c-1.143-2.256-21.836-16.191-68.75-46.045
        c-37.012-23.584-69.502-43.906-72.275-45.156c-2.754-1.133-10.908-3.135-18.184-4.268c-22.207-3.643-80.791-14.063-134.106-23.838
        c-38.135-7.148-53.193-9.414-61.475-9.414c-10.034,0-19.946,2.266-122.065,27.598c-61.094,15.186-112.778,27.598-114.785,27.598
        c-7.529,0-11.421-10.4-5.645-15.176c1.753-1.377,45.156-12.666,115.288-30.234l112.656-27.969h15.059
        c13.672,0.117,21.323,1.25,80.288,12.285c35.869,6.65,78.789,14.434,95.352,17.188c36.377,6.152,41.26,7.158,47.285,10.176
        c2.637,1.377,34.502,21.318,70.879,44.531c71.006,45.156,75.4,48.418,78.789,59.961c2.383,7.9,2.383,12.422,0,20.322
        c-2.393,8.281-9.17,15.938-17.559,19.951c-5.908,3.008-8.037,3.389-15.938,2.881l-9.16-0.371l-66.494-35
        c-58.965-31.113-67.109-35-71.885-34.873c-2.881,0.117-37.393,3.379-76.523,7.148c-76.274,7.529-75.518,7.393-75.518,14.414
        c0,4.404,3.506,7.529,8.525,7.529c2.261,0,25.977-2.246,52.822-5.02c40.273-4.258,49.805-4.883,54.824-3.76
        c18.809,4.268,30.986,19.199,30.986,38.008c0,16.445-11.67,32.119-27.354,36.631c-6.768,1.885-127.207,14.443-137.876,14.307
        C303.633,4692.011,296.23,4690.507,290.713,4688.75z"/>
</g>
</svg>
';
                        break;
                    case 'business_reputation':
                        $localItem['img_path'] = 'hx_tm_business_reputation.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. Whereas, this resource is unique and looking for a matured environments to continue career with profoundness.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Considering the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm is able to identify the relevance of vital criteria and found to be' . $value . '. This component is been a vital criteria considering the earlier companies and career which is been chosen by this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,128.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M416.699,1263.086c-9.219-9.214-9.219-10.298,0.547-20.059c9.756-9.761,9.756-9.761,16.27,0.542
        c4.873,8.135,4.873,12.471-0.547,19.517C426.455,1272.309,425.381,1272.309,416.699,1263.086z"/>
    <path fill="#70BF44" d="M481.23,1214.282c-8.672-9.219-9.219-11.387-2.178-16.812c4.355-3.794,8.691-8.672,9.766-11.929
        c1.084-2.71,7.598,0,13.564,6.514l11.924,11.929l-11.924,10.298C490.996,1224.59,490.996,1224.59,481.23,1214.282z"/>
    <path fill="#2c303b" d="M332.642,1203.437c-46.089-11.929-54.229-79.175-12.466-103.579c24.941-15.181,47.178-11.929,68.32,9.224
        c14.648,14.644,18.438,22.773,18.438,40.127C406.934,1188.252,371.699,1213.745,332.642,1203.437z M374.941,1117.759
        c-7.051-5.967-17.896-10.845-24.941-10.845s-17.896,4.878-24.941,10.845l-13.018,10.303H350h37.959L374.941,1117.759z"/>
    <path fill="#2c303b" d="M452.49,1135.112c-8.672-13.555,3.252-23.862,15.732-14.644c8.672,5.967,8.672,7.046-0.547,15.186
        C459.004,1143.784,457.373,1143.784,452.49,1135.112z"/>
    <path fill="#2c303b" d="M263.232,1065.693c-29.282-15.181-78.633-69.409-78.633-86.758c0-8.14,78.096-103.037,87.314-106.299
        c5.42-1.621,0.537-90.01-9.219-173.525l-3.262-26.035h32.539h32.544l3.252,28.75c1.631,15.176,4.336,47.715,5.967,71.582
        c4.883,66.152,8.125,84.062,16.265,84.062s11.387-19.004,16.27-89.492c1.621-26.582,4.336-59.102,6.504-72.109l2.715-22.793h31.992
        h32.529l-3.242,26.035c-9.766,91.094-14.102,171.904-8.682,173.525c7.588,2.715,87.314,98.159,87.314,104.663
        c0,10.313-26.035,46.099-48.271,66.167c-26.025,23.315-42.295,30.908-68.32,30.908h-18.438l1.084-39.585
        c0.537-41.763-5.42-63.447-13.018-43.936c-2.168,5.43-4.346,19.531-4.346,30.918c-0.537,17.891-2.158,20.063-14.092,20.063
        c-11.929,0-13.555-2.173-14.102-20.063c0-11.387-2.163-25.488-4.336-30.918c-7.593-19.512-14.106,2.72-13.013,44.473l1.079,39.048
        h-20.063C288.716,1074.375,272.451,1070.576,263.232,1065.693z M276.787,976.763v-49.346l-15.186,17.896
        c-32.529,39.043-31.992,35.254-9.214,58.564c11.934,11.929,21.689,21.694,22.773,21.694
        C276.25,1025.571,276.787,1003.33,276.787,976.763z M447.607,1003.877c22.773-23.311,23.32-19.521-8.672-58.027
        c-14.102-16.27-14.639-16.802-17.9-5.42c-4.883,17.896-3.789,85.142,1.084,85.142
        C424.297,1025.571,435.674,1015.806,447.607,1003.877z"/>
    <path fill="#2c303b" d="M338.618,1066.24c-2.173-4.883-1.094-11.392,2.163-14.648c8.125-8.125,23.857-0.532,21.699,10.313
        C360.303,1074.375,342.954,1077.632,338.618,1066.24z"/>
    <path fill="#2c303b" d="M124.946,689.893c0-2.168,4.883-10.84,11.392-18.984l11.387-14.629l-14.644-18.438l-14.097-18.984h32.539
        H184.6v27.109v27.109h18.979c15.186,0,18.979,2.168,18.979,10.859c0,10.293-3.794,10.84-48.804,10.84
        C146.645,694.775,124.946,692.607,124.946,689.893z"/>
    <path fill="#2c303b" d="M477.441,683.935c0-8.691,3.789-10.859,18.975-10.859H515.4v-27.109v-27.109h33.076h32.539l-14.102,18.984
        l-14.648,18.438l11.396,14.629c6.504,8.145,11.387,16.816,11.387,18.984c0,2.715-21.699,4.883-48.809,4.883
        C481.23,694.775,477.441,694.228,477.441,683.935z"/>
    <path fill="#2c303b" d="M190.024,632.412v-35.254H350h159.971v35.254v35.234H350H190.024V632.412z M267.568,625.361
        c-3.247-12.461-21.689-12.461-24.941,0c-3.257,11.934,11.929,22.227,21.147,14.648
        C267.568,637.295,269.194,630.244,267.568,625.361z M313.667,639.463c6.509-9.219,0.547-23.32-9.766-23.32
        c-4.336,0-9.756,3.789-11.382,8.125c-3.804,8.145,3.789,21.699,11.382,21.699C306.074,645.967,310.41,642.725,313.667,639.463z
         M363.555,627.529c0-8.672-3.252-11.387-13.555-11.387c-10.313,0-13.555,2.715-13.555,11.934c0,6.504,3.242,12.461,7.046,14.102
        C354.883,645.967,363.555,640.01,363.555,627.529z M405.859,639.463c6.504-9.219,0.537-23.32-9.766-23.32
        c-4.346,0-9.756,3.789-11.387,8.125c-3.789,8.145,3.789,21.699,11.387,21.699C398.262,645.967,402.598,642.725,405.859,639.463z
         M457.92,625.908c-3.252-13.008-27.656-14.648-26.582-2.168c0,4.883,2.178,11.914,4.883,15.723
        C442.187,649.209,460.625,637.842,457.92,625.908z"/>
</g>
</svg>';
                        break;
                    case 'career_progression':

                        $localItem['img_path'] = 'hx_tm_career_rogression.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. The career progression for this resource is deemed to be attaining the closeness towards to the fulfilment and hence it is satisfactory.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Career Progression component as ' . $value . '. Our HX: Talent Mining algorithm compared career progression attribute with several thousands of similar professionals. This attribute for this resource sees towards the ultimate professional goals, step by step. The progression of this resource is non-vulnerable and is followed in order to reach the goal.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'company_culture':
                        $localItem['img_path'] = 'hx_tm_company_culture.svg';
                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource can become a fit and get accustomed with the company cultural practices in time as per the earlier companies and hence deemed as a good fit. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Based on the available data from ' . $candidateDetails->full_name . '‘s Resume our AI Algorithm rated this offering is as ' . $value . '. This resource is been into similar company environments earlier and should be an appropriate cultural fit as per the defined policies, processes and cultural practices as per the company.';

                                break;
                        }
                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve"><g><path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M25.052,14.046c1.584,5.316,4.274,7.801,8.519,7.936
        c2.337,0.074,4.374-0.711,6.094-2.272c1.713-1.554,2.543-3.582,2.855-5.844c2.295,0.763,3.66,2.43,3.676,4.663
        c0.043,6.099,0.043,12.197,0,18.295c-0.016,2.374-1.256,3.955-3.09,4.246c-1.096,0.175-1.658-0.148-1.705-1.367
        c-0.102-2.621-0.25-5.244-0.477-7.857c-0.361-4.128-3.143-6.699-7.314-6.824c-2.753-0.083-5.519,0.011-8.258-0.227
        c-2.272-0.197-3.528-1.533-3.811-3.794c-0.151-1.214-0.115-2.502,0.119-3.7C22.006,15.543,23.186,14.448,25.052,14.046z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M17.948,61.804c3.734-3.795,4.531-7.516,2.43-11.352
        c-2.042-3.728-5.59-4.946-10.966-3.765c-0.943-1.188-1.028-2.439,0.095-3.676c0.874-0.962,1.977-1.771,3.103-2.438
        c4.702-2.781,9.446-5.495,14.187-8.211c2.262-1.296,3.959-1.164,5.329,0.34c0.957,1.052,0.932,1.404-0.239,2.188
        c-2.031,1.358-4.087,2.68-6.116,4.042c-3.838,2.578-4.773,6.647-2.467,10.694c1.011,1.773,2.046,3.532,3.074,5.296
        c1.868,3.206,1.266,5.494-1.948,7.337c-0.576,0.33-1.157,0.672-1.772,0.914C21.089,63.791,18.835,63.432,17.948,61.804z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M60.823,44.183c-5.352-1.4-8.875-0.182-11.281,3.891
        c-2.033,3.442-1.1,7.292,2.766,11.392c-1.84,1.604-3.883,1.886-5.873,0.751c-5.252-2.994-10.501-5.995-15.737-9.02
        c-1.616-0.934-2.613-2.278-2.361-4.263c0.188-1.484,0.903-1.954,2.199-1.355c2.094,0.967,4.194,1.935,6.208,3.051
        c4.003,2.22,7.632,1.504,10.21-2.272c1.301-1.902,2.422-3.93,3.57-5.933c1.029-1.799,2.316-3.312,4.572-3.077
        c2.393,0.248,4.4,1.396,5.66,3.534C61.37,41.924,61.442,43.069,60.823,44.183z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M57.151,59.835c-4.354-0.032-7.746-3.501-7.688-7.86
        c0.055-4.273,3.389-7.507,7.729-7.497c4.445,0.011,7.752,3.364,7.693,7.802C64.831,56.469,61.353,59.865,57.151,59.835z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M20.552,54.742c-0.013,4.199-3.464,7.641-7.661,7.641
        c-4.304,0-7.761-3.414-7.777-7.679c-0.016-4.195,3.426-7.748,7.54-7.782C17.016,46.886,20.565,50.4,20.552,54.742z"/>
    <path fill-rule="evenodd" clip-rule="evenodd" fill="#2c303b" d="M26.139,13.237c0.047-4.259,3.604-7.729,7.815-7.624
        c4.211,0.104,7.563,3.563,7.538,7.778c-0.025,4.29-3.469,7.69-7.755,7.661C29.479,21.023,26.091,17.538,26.139,13.237z"/>
</g>
</svg>
';
                        break;
                    case 'change_stability':
                        $localItem['img_path'] = 'hx_tm_change_stability.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. The duration worked within each company and the acceptance for the situational changes in the organization is addressed well and accustomed by this resource.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Change and Stability component is ' . $value . ' as per the inputs given in the resume. Considering the employment stay in each company and the balanced growth in experience show this resource is stable. Also, as per the movement between roles or responsibilities proves the inclination to changes. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,224.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M304.404,2189.38c-30.679-4.971-53.77-11.689-79.482-23.672c-90.586-41.787-152.241-120.684-173.569-222.08
        c-5.259-24.834-4.38-88.54,1.46-115.415c20.459-92.627,79.194-168.896,161.011-209.521
        c104.316-52.002,223.247-41.191,317.622,28.643c51.436,38.281,92.344,99.648,110.742,166.27
        c6.143,21.904,7.021,30.967,6.729,77.422c-0.293,48.516-0.879,54.653-8.193,78.911c-10.508,35.352-26.289,68.662-44.697,94.38
        c-8.486,11.685-15.498,22.212-15.498,23.374c0,1.172,16.084,18.115,35.664,37.695l35.938,35.942h-91.455h-91.182v-91.172v-91.46
        l31.562,31.558c17.236,17.246,32.734,31.27,34.482,31.27c4.971,0,26.592-34.482,36.23-57.856
        c14.033-33.022,18.418-56.694,18.418-95.562c0-26.289-1.758-40.898-6.436-58.438c-21.924-82.393-79.189-143.174-161.006-171.514
        c-26.592-9.063-29.805-9.355-71.587-9.648c-37.114,0-47.344,1.172-66.626,6.719c-44.116,12.568-82.69,36.523-113.667,70.713
        c-80.068,87.666-85.024,218.281-12.271,312.949c25.132,32.729,62.529,60.786,100.518,75.396
        c24.834,9.639,61.074,17.822,78.896,17.822h11.982l-0.879,30.098l-0.874,29.805l-10.229,0.586
        C332.456,2192.885,317.261,2191.421,304.404,2189.38z"/>
    <path fill="#2c303b" d="M319.893,2066.362c-39.741-15.2-62.822-49.971-60.195-91.46c4.38-75.391,92.334-111.914,149.307-61.655
        c20.176,17.524,29.814,39.443,29.521,66.909c0,35.649-17.822,65.161-49.092,80.942
        C371.016,2070.449,337.129,2073.081,319.893,2066.362z"/>
    <path fill="#2c303b" d="M306.45,1825.293c-21.621-4.102-49.38-13.74-66.621-23.672c-18.12-10.234-42.08-30.967-42.08-36.24
        c0-6.123,34.771-35.938,55.518-47.617c56.104-31.563,127.7-33.018,183.804-4.092c21.328,11.094,45.869,30.098,58.73,45.283
        l7.012,8.77l-14.326,12.861c-16.943,14.902-53.77,33.896-78.887,40.605C388.848,1826.748,328.369,1829.082,306.45,1825.293z"/>
</g>
</svg>
';
                        break;

                    case 'innovation_technology':
                        $localItem['img_path'] = 'hx_tm_innovation_technology.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Being in an advanced environment it is evident that this resource is supporting the project besides possessing creative thought process to support the new and upcoming technologies as and when the projects demands. ';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For ' . $candidateDetails->full_name . '’s this innovation and technology offering is as ' . $value . ' based out of our HX: Talent Mining algorithm compared between several professionals. Capable to contemplate and get adapted to work in the new technologies so as to support the project, besides planning for the trainings in the upcoming technical skill. ';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g transform="translate(0.000000,280.000000) scale(0.100000,-0.100000)">
    <path fill="#2c303b" d="M350.488,2755.049c0-14.639-1.665-19.653-7.1-21.328c-4.185-1.255-16.313-6.27-27.598-11.289l-19.658-8.784
        l-11.704,11.294c-13.804,13.379-22.163,14.214-31.362,3.76c-9.619-10.454-8.779-17.139,3.345-30.103l10.454-10.879l-12.544-28.433
        c-11.709-25.088-14.219-28.018-24.253-27.598c-20.493,1.675-21.743,0.42-21.743-16.309c0-16.724,0-16.724,17.563-17.979
        c16.724-1.25,17.559-1.675,24.668-23.833c4.18-12.129,9.614-24.673,12.124-27.603c2.93-3.34,0.84-7.939-6.27-14.634
        c-12.544-11.704-13.384-21.323-2.93-30.527c10.459-9.614,18.818-8.779,29.692,2.93l9.619,10.034l13.379-7.944
        c7.109-4.6,20.073-10.039,28.848-12.544c14.639-3.765,15.469-5.02,15.469-20.493c0-16.724,0-16.724,16.738-16.724
        c16.719,0,19.219,2.93,17.129,20.073c-1.25,7.944,7.539,17.563,15.488,17.563c3.75,0,14.629,4.18,24.668,8.779l18.398,8.779
        l9.609-8.779c11.289-10.869,20.078-11.289,28.848-1.255c9.629,10.874,8.789,18.818-2.93,29.688
        c-9.609,9.204-10.02,10.454-3.75,19.658c3.34,5.435,8.789,17.979,11.719,27.598c4.59,17.139,5.84,17.983,22.578,19.233
        c17.129,1.255,17.129,1.675,17.129,17.979c0,16.729-1.23,17.983-21.738,16.309c-10.039-0.42-12.539,2.51-24.258,27.598
        l-12.539,28.433l10.449,10.879c12.559,12.964,13.379,21.323,2.93,30.522c-10.859,9.619-17.148,8.779-30.527-3.765l-11.699-11.284
        l-15.469,7.524c-8.789,4.18-20.488,8.779-26.348,10.454c-9.629,2.51-10.879,5.02-11.289,21.323l-0.43,18.398l-17.139,1.255
        l-17.568,1.255V2755.049z M402.773,2694.834c46.816-21.328,67.734-71.924,48.496-115.83
        c-17.559-39.307-43.066-55.615-86.563-56.035c-22.158,0-28.428,2.095-45.991,13.799c-28.018,18.403-41.396,43.491-40.977,76.108
        c0.415,28.433,7.104,43.901,27.598,63.56C332.515,2702.778,370.156,2709.887,402.773,2694.834z"/>
    <path fill="#2c303b" d="M346.313,2674.76c-3.345-1.255-11.709-6.27-17.979-10.869l-11.709-7.949l9.619-5.015
        c7.524-4.185,11.284-4.185,17.979,0.415c4.6,2.925,15.054,5.435,23.413,5.435c18.809,0,41.406-17.139,41.406-30.942
        c0-5.02,2.93-13.379,6.68-18.813l6.699-9.619l7.52,11.289c7.539,11.294,7.129,11.709-3.77,30.522
        c-5.84,10.459-15.879,22.583-22.148,27.183C392.734,2674.76,358.437,2679.78,346.313,2674.76z"/>
    <path fill="#2c303b" d="M302.412,2610.781c-3.77-6.689-4.604-12.544-2.51-12.544c2.085,0,4.595-4.18,6.27-9.614
        c1.255-5.02,8.779-15.894,17.144-23.838c14.214-13.799,16.724-14.634,43.071-14.634c22.168,0,30.527,1.67,39.316,8.779
        c10.859,8.364,10.859,8.779,2.5,13.799c-6.699,4.185-10.879,3.765-23.008-1.67c-12.539-5.854-17.559-6.274-30.938-2.51
        c-17.144,5.02-28.848,17.983-28.848,31.777c-0.425,8.364-9.204,22.998-13.804,22.998
        C309.932,2623.325,306.172,2617.89,302.412,2610.781z"/>
    <path fill="#2c303b" d="M197.871,2523.388c-24.673-10.034-34.712-43.906-25.093-81.543c4.185-15.479,5.02-26.768,2.51-33.037
        c-2.925-7.109-2.09-13.789,2.095-21.738c2.925-5.859,7.524-18.398,10.034-27.188c2.925-11.289,8.779-18.809,20.908-26.758
        c17.563-11.289,20.068-19.238,11.289-34.707c-8.364-15.059-25.093-25.078-60.635-37.227
        c-32.617-10.449-34.287-11.699-38.052-26.328c-2.09-8.379-5.015-36.367-6.689-61.895l-2.51-47.246h58.54h58.96v16.738
        c0,9.18,0.84,16.699,2.095,16.699c1.25,0,10.034-3.75,18.813-8.34c10.874-5.449,16.729-11.289,16.729-16.738
        c0-7.52,2.93-8.359,29.268-8.359h29.277v32.617c0,30.938,4.595,70.664,10.454,93.672c2.505,9.609,1.25,11.289-11.294,13.809
        c-27.178,5.84-53.525,30.508-53.525,50.176c0,3.34,7.524,10.859,16.729,17.129c10.869,7.539,17.979,15.898,20.908,26.348
        c2.51,8.359,7.944,20.898,11.289,28.008c4.6,9.219,5.439,15.059,2.505,20.508c-2.505,4.16-3.34,19.219-2.085,33.442
        c1.67,25.508,1.67,25.923-10.874,30.942c-10.874,4.6-14.219,4.6-22.578-1.25c-16.729-11.714-31.782-8.369-51.855,11.704
        c-13.799,13.804-18.398,21.328-18.398,31.362C216.685,2527.573,212.925,2529.238,197.871,2523.388z M261.846,2279.179
        c2.51-2.93,2.93-7.52,0.835-10.879c-1.67-3.34-2.51-16.289-1.25-28.848l2.51-23.418l-14.219,8.789
        c-12.129,7.109-14.224,10.449-12.964,21.738c0.415,7.109-0.835,16.738-3.345,21.328c-3.345,6.27-2.51,8.789,2.93,12.129
        C246.797,2285.879,256.831,2285.449,261.846,2279.179z M250.137,2206.426c8.784-5.02,12.964-11.289,14.639-23.008
        c1.67-9.199,1.67-17.559,0.415-18.809c-1.25-1.68-9.199,0.84-17.144,5.43c-13.384,7.109-14.634,9.629-14.634,25.527
        c0,10.02,1.25,17.969,2.51,17.969C237.173,2213.535,243.867,2210.195,250.137,2206.426z"/>
    <path fill="#2c303b" d="M517.754,2514.189c0-10.034-4.609-17.559-18.398-31.362c-20.078-20.073-35.117-23.418-51.836-11.704
        c-21.348,14.629-44.746-10.874-34.707-37.637c2.09-5.439,2.91-17.568,1.66-27.178c-1.25-9.199-0.41-19.238,2.09-22.168
        c2.09-2.93,6.27-13.379,8.789-22.578c3.34-12.969,8.77-20.078,21.309-28.438c17.578-11.719,19.668-16.719,12.148-33.457
        c-7.109-14.629-30.117-29.258-65.664-40.547c-28.008-8.789-30.527-10.449-34.277-24.258c-2.1-8.379-4.189-36.367-4.189-61.895
        v-47.246h56.455h56.445v16.738c0,9.18,1.68,16.699,3.77,16.699c10.02,0,33.867-17.969,33.867-25.488
        c0-7.539,3.77-7.949,58.965-7.949h59.375l-2.93,47.246c-1.68,25.527-4.609,53.516-7.109,61.895
        c-3.75,14.629-5.43,15.879-39.297,26.758c-28.438,9.199-38.887,15.059-50.195,28.008c-19.219,20.918-18.809,29.707,2.09,43.496
        c12.129,8.359,17.988,15.898,21.758,28.438c2.5,9.199,7.52,21.328,10.859,26.758c5.039,7.539,5.039,11.719,0.84,21.738
        c-2.91,7.539-4.18,19.668-2.5,32.207c4.18,29.688-3.34,63.975-16.738,75.684C525.293,2530.913,517.754,2530.083,517.754,2514.189z
         M500.625,2279.179c2.5-3.34,3.34-7.109,1.66-8.359c-1.25-1.68-2.09-14.219-1.66-28.438l0.82-25.488l-13.789,7.93
        c-11.699,7.109-13.809,10.449-12.559,21.738c0.43,7.109-0.84,16.738-2.93,20.918
        C464.238,2281.699,489.746,2292.148,500.625,2279.179z M488.477,2206.426c14.219-9.609,16.738-13.789,16.738-29.277
        c0-15.879-2.93-16.719-20.488-6.25c-11.289,6.25-12.969,9.59-12.969,25.078C471.758,2215.625,473.437,2216.894,488.477,2206.426z
         M576.289,2152.89c0-9.609-1.25-10.43-20.488-10.43c-21.328,0-28.008,4.18-23.809,14.629c1.66,4.59,8.77,6.25,23.398,6.25
        C575.039,2163.34,576.289,2162.519,576.289,2152.89z"/>
</g>
</svg>
';
                        break;
                    case 'job_satisfaction':
                        $localItem['img_path'] = 'hx_tm_jobsatisfaction.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume. Where the average work duration in the earlier companies are considerable with which it can be said that the sustainability of this resource talent is reliable.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Job Satisfaction component is ' . $value . ' as per the inputs given in the resume.
                                    Where the period worked for the companies earlier by this resource is admirable, which shows the contentment, satisfaction and acceptance in working with those companies.';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M45.978,14.07c-0.179,0.49-1.025,1.336-1.871,1.915c-2.093,1.425-2.895,3.829-2.048,5.922
        c0.757,1.737,1.736,2.361,5.388,3.34c2.359,0.623,2.672,0.846,2.806,1.915c0.134,0.935-0.09,1.291-1.024,1.736
        s-1.381,0.4-2.449-0.223c-1.336-0.801-4.898-1.024-4.898-0.356c0,0.846,2.271,3.117,3.251,3.25c0.623,0.089,1.023,0.49,1.112,1.113
        c0.135,0.846,0.446,1.024,1.915,1.024c1.336,0,1.737-0.179,1.737-0.802c0.044-0.401,0.668-1.158,1.426-1.648
        c1.78-1.158,3.206-3.874,2.849-5.388c-0.444-1.781-2.314-3.206-4.942-3.74c-3.295-0.668-4.142-1.38-3.429-2.851
        c0.4-0.935,0.847-1.157,2.092-1.157c1.07,0,1.738,0.267,2.095,0.891c0.444,0.667,1.068,0.89,2.448,0.89h1.915l-0.579-1.469
        c-0.312-0.757-1.336-1.915-2.227-2.494c-0.89-0.579-1.647-1.469-1.647-1.915C49.896,12.823,46.422,12.868,45.978,14.07z"/>
    <path fill="#2c303b" d="M22.243,17.187c-1.426,1.469-1.604,2.583-0.624,4.454c1.648,3.25,6.902,2.048,6.902-1.604
        c0-2.004-0.401-2.761-1.826-3.474C24.825,15.584,23.711,15.762,22.243,17.187z"/>
    <path fill="#2c303b" d="M16.676,25.425c-2.36,1.514-3.563,2.671-4.988,4.854c-2.004,3.028-2.093,4.319-0.267,4.319
        c0.712,0,1.514-0.623,2.627-2.092c1.647-2.138,3.339-3.607,3.339-2.895c0,0.268-0.401,1.781-0.935,3.429
        c-1.248,4.097-0.802,4.675,4.408,6.278c2.137,0.668,3.918,1.248,4.008,1.293c0.044,0.043,0.312,1.379,0.624,2.938
        c0.267,1.559,0.668,3.117,0.891,3.385c0.668,0.801,2.449,0.713,2.761-0.133c0.4-1.115,0.267-4.143-0.312-7.082l-0.579-2.672
        l-3.162-1.246l-3.162-1.291l0.579-2.004c0.356-1.113,0.712-2.093,0.846-2.227c0.134-0.133,0.846,0.268,1.559,0.891
        c2.627,2.182,7.614,3.117,7.614,1.425c0-0.668-1.959-2.182-3.429-2.627c-0.535-0.177-1.959-1.424-3.117-2.76
        c-2.137-2.538-3.874-3.741-5.388-3.741C20.149,23.466,18.368,24.356,16.676,25.425z"/>
    <path fill="#2c303b" d="M4.608,35.89l-1.425,2.671l1.425,1.025c0.801,0.578,2.494,1.736,3.785,2.537
        c2.672,1.693,2.627,1.738,4.587-2.047c0.757-1.516,0.846-2.004,0.445-2.539c-0.668-0.757-6.368-4.275-6.991-4.275
        C6.211,33.262,5.365,34.465,4.608,35.89z"/>
    <path fill="#2c303b" d="M51.633,36.78c-0.579,0.446-2.45,1.56-4.187,2.495c-1.692,0.934-4.008,2.27-5.121,2.938
        s-3.206,1.914-4.676,2.762c-1.47,0.801-5.165,2.939-8.238,4.719c-3.073,1.781-7.526,4.364-9.886,5.745
        c-2.405,1.381-4.364,2.672-4.364,2.85s1.871,0.313,4.142,0.313c4.586,0,4.498,0.045,9.352-3.875
        c1.647-1.336,3.072-2.36,3.162-2.271c0.134,0.088-0.268,1.29-0.846,2.626c-0.624,1.336-1.069,2.717-1.113,2.984
        c0,0.447,2.671,0.58,12.023,0.58h12.023v-1.471c0-0.758-0.401-3.785-0.846-6.679c-0.446-2.895-0.624-5.344-0.446-5.479
        c0.223-0.088,0.802,0.668,1.382,1.693c0.534,1.068,1.201,2.271,1.468,2.672c0.224,0.445,1.114,2.047,1.916,3.563
        c3.251,6.056,2.894,5.7,6.367,5.655c1.691-0.045,3.073-0.268,3.073-0.49c0-0.266-1.514-2.939-3.341-6.013
        c-1.825-3.027-3.34-5.609-3.34-5.699c0-0.133-0.846-1.559-1.824-3.205C53.502,35.266,53.502,35.311,51.633,36.78z"/>
    <path fill="#2c303b" d="M16.275,42.971c0,1.869-0.179,4.676-0.356,6.189c-0.356,2.449-0.312,2.85,0.356,3.117
        c0.445,0.133,1.113,0.088,1.514-0.18c0.891-0.578,2.315-5.297,2.583-8.684c0.223-2.803,0.178-2.848-2.984-3.605l-1.113-0.268
        V42.971z"/>
</g>
</svg>
';
                        break;
                    case 'remuneration':
                        $localItem['img_path'] = 'hx_tm_remuneration.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . '  as per the inputs given in the resume. This resource can be considered for this role in view of the remuneration and potentials acquired which are admirable with which the company can foresee the value add in this candidature.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'Our HX: Talent Mining with the aid of the Algorithm has screened the Resume of ' . $candidateDetails->full_name . ' and found that the Remuneration component is ' . $value . ' as per the inputs given in the resume.
For this resource the remuneration attribute counts in various other factors while it is not just residing on the monetary, which shows the maturity and reliability to consider this candidature.  ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M13.757,14.409c-2.602,1.371-3.902,3.27-4.113,6.047c-0.352,4.781,2.953,8.438,7.558,8.438
        c4.886-0.035,8.507-4.641,7.453-9.457c-0.703-3.34-4.148-6.012-7.734-6.012C16.183,13.424,14.812,13.846,13.757,14.409z"/>
    <path fill="#2c303b" d="M50.635,13.917c-6.328,2.25-6.891,11.074-0.879,14.098c4.957,2.461,10.546-0.668,11.038-6.152
        c0.176-1.758,0.07-2.355-0.738-3.973C58.298,14.268,54.325,12.617,50.635,13.917z"/>
    <path fill="#2c303b" d="M33.338,25.167c-0.105,0.457-0.843,1.23-1.617,1.758c-2.602,1.723-3.41,3.973-2.25,6.398
        c0.633,1.3,2.355,2.285,5.238,2.988c2.145,0.527,2.637,0.879,2.637,1.934c0,1.441-2.566,2.109-4.008,1.02
        c-0.809-0.598-4.078-0.738-4.078-0.176c0,0.949,1.125,2.355,2.39,3.094c0.809,0.422,1.547,1.09,1.652,1.477
        c0.176,0.563,0.527,0.703,1.969,0.703c1.477,0,1.723-0.105,1.723-0.668c0-0.422,0.598-1.02,1.582-1.582
        c1.863-1.09,2.637-2.426,2.637-4.465c0-2.004-1.582-3.585-4.43-4.324c-2.848-0.773-3.797-1.336-3.938-2.215
        c-0.246-1.758,2.883-2.496,4.078-0.984c0.598,0.738,0.984,0.879,2.496,0.879c1.055,0,1.793-0.141,1.793-0.387
        c0-1.09-1.266-2.848-2.672-3.656c-1.16-0.668-1.547-1.125-1.547-1.758c0-0.809-0.141-0.879-1.723-0.879
        C33.76,24.323,33.514,24.428,33.338,25.167z"/>
    <path fill="#2c303b" d="M11.155,30.616c-2.496,0.633-4.394,2.215-5.695,4.71c-0.492,0.95-1.371,8.333-2.32,19.125L3,56.314h8.542
        c8.507,0,8.578,0,8.578-0.738c0-0.457-0.95-1.758-2.285-3.164c-2.004-2.145-4.043-5.273-4.043-6.258
        c0-0.176,0.422-0.457,0.984-0.668c0.914-0.316,1.02-0.211,2.18,1.758c2.566,4.43,7.523,7.875,12.866,8.965
        c3.41,0.703,4.887,0.422,5.766-1.055c1.652-2.672,0.457-4.5-3.586-5.52c-4.359-1.09-6.609-2.496-8.296-5.203
        c-1.266-2.039-1.617-3.023-2.355-6.469c-0.668-3.235-2.144-5.343-4.429-6.503C15.128,30.581,12.667,30.229,11.155,30.616z"/>
    <path fill="#2c303b" d="M55.45,30.616c-3.796,0.984-5.59,3.27-6.679,8.472c-0.668,3.234-1.863,5.484-3.797,7.277
        c-1.863,1.723-3.059,2.391-5.309,2.953c-1.441,0.352-1.652,0.527-1.477,1.16c0.527,1.828,0.598,3.34,0.281,4.535
        c-0.211,0.703-0.246,1.371-0.07,1.477c0.422,0.246,5.379-1.09,7.102-1.969c0.844-0.387,2.004-1.125,2.637-1.582
        c1.512-1.16,1.863-1.055,1.863,0.457c0,0.738,0.105,1.688,0.21,2.109l0.212,0.809h8.437h8.472l-0.211-2.039
        c-0.105-1.09-0.387-3.973-0.598-6.398c-1.055-12.129-1.16-12.516-2.883-14.589C61.884,31.213,58.017,29.948,55.45,30.616z"/>
</g>
</svg>
';
                        break;
                    case 'team_people':
                        $localItem['img_path'] = 'hx_tm_team_people.svg';


                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. This profile shows the uniqueness in presenting the matured outcome with which the team and the management can easily acknowledge this resource in the company.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'We found ' . $candidateDetails->full_name . '’s Team and People component as ' . $value . ' as per our HX: Talent Mining algorithm compared between innumerable similar professionals. In view of the environment worked by this resource gave consistent exposure which upholds the efficiency on the deliverables with which the company can become a beneficiary. ';

                                break;
                        }


                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<g>
    <path fill="#2c303b" d="M20.375,14.82c0-4.591,3.722-8.313,8.313-8.313c4.59,0,8.313,3.721,8.313,8.313
        c0,4.59-3.722,8.312-8.313,8.312C24.096,23.132,20.375,19.41,20.375,14.82z M32.683,28.795c0.083-1.81,0.706-3.485,1.708-4.87
        c-0.704-0.148-1.431-0.226-2.177-0.226h-7.053c-0.744,0-1.47,0.078-2.17,0.223c1.067,1.48,1.705,3.288,1.715,5.244
        c1.297-0.714,2.785-1.12,4.365-1.12C30.354,28.046,31.574,28.313,32.683,28.795z M34.09,29.541
        c2.414,1.513,4.107,4.075,4.417,7.049c0.983,0.459,2.077,0.725,3.235,0.725c4.23,0,7.657-3.429,7.657-7.659
        s-3.427-7.658-7.657-7.658C37.55,21.998,34.153,25.365,34.09,29.541z M29.072,45.222c4.229,0,7.659-3.429,7.659-7.658
        c0-4.229-3.43-7.658-7.659-7.658c-4.229,0-7.659,3.429-7.659,7.658C21.413,41.793,24.842,45.222,29.072,45.222z M32.32,45.743
        h-6.498c-5.407,0-9.807,4.399-9.807,9.806v7.948l0.021,0.125l0.547,0.17c5.16,1.611,9.643,2.15,13.333,2.15
        c7.206,0,11.384-2.055,11.641-2.187l0.512-0.259h0.054v-7.948C42.125,50.143,37.728,45.743,32.32,45.743z M44.992,37.838h-6.448
        c-0.07,2.58-1.172,4.903-2.914,6.574c4.806,1.429,8.322,5.886,8.322,11.149v2.449c6.367-0.233,10.036-2.038,10.277-2.159
        l0.513-0.261h0.054v-7.949C54.797,42.235,50.397,37.838,44.992,37.838z M46.717,21.834c2.413,1.514,4.106,4.076,4.415,7.049
        c0.984,0.46,2.077,0.725,3.235,0.725c4.231,0,7.66-3.429,7.66-7.658c0-4.23-3.429-7.658-7.66-7.658
        C50.178,14.292,46.779,17.66,46.717,21.834z M57.617,30.131h-6.448c-0.069,2.581-1.17,4.904-2.912,6.574
        c4.807,1.43,8.322,5.886,8.322,11.151v2.449c6.366-0.234,10.036-2.038,10.277-2.16l0.511-0.26h0.056v-7.95
        C67.423,34.53,63.023,30.131,57.617,30.131z M15.634,37.314c1.499,0,2.892-0.438,4.073-1.182c0.375-2.449,1.688-4.589,3.563-6.046
        c0.008-0.144,0.021-0.286,0.021-0.431c0-4.229-3.43-7.658-7.657-7.658c-4.231,0-7.659,3.428-7.659,7.658
        C7.976,33.887,11.403,37.314,15.634,37.314z M22.512,44.412c-1.733-1.662-2.831-3.974-2.912-6.539
        c-0.239-0.018-0.475-0.035-0.719-0.035h-6.497c-5.408,0-9.807,4.397-9.807,9.805v7.948l0.021,0.124l0.548,0.171
        c4.138,1.294,7.833,1.889,11.042,2.075v-2.4C14.189,50.298,17.705,45.84,22.512,44.412z"/>
</g>
</svg>
';
                        break;

                    case 'globalization':
                        $localItem['img_path'] = 'hx_tm_globalization.svg';

                        switch (true) {
                            case in_array($value, range(0, 48)):
                                $localItem['description'] = '';
                                break;

                            case in_array($value, range(48, 59)):
                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . '  as per the inputs provided in resume. This resource can easily get accustomed to the diversified employee backgrounds considering the exposure in working for similar environments in the earlier companies.';
                                break;
                            case in_array($value, range(60, 100)):

                                $localItem['description'] = 'For this offering as per our HX: Talent Mining with the aid of the Algorithm for ' . $candidateDetails->full_name . ' as ' . $value . ' as per the inputs provided in resume. Since the working experience depicts multi-national environments the profile, this resources can become handy and can get acquainted to the global policies and processes and diversified cultural backgrounds in the company which paves path easily in accepting this resource.';

                                break;
                        }

                        $localItem['img'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="40px" height="40px" viewBox="0 0 70 70" enable-background="new 0 0 70 70" xml:space="preserve">
<path fill="#2c303b" d="M34.189,3.016c-11.344,3.66-16.468,10.246-16.468,21.775c0,9.333,9.698,19.029,19.031,19.029
    c9.148,0,16.65-4.208,19.396-10.978C61.27,20.582,57.063,9.054,46.084,4.297C39.496,1.551,38.582,1.551,34.189,3.016z
     M35.289,12.165c-1.83,1.83-3.477-0.915-1.83-3.294c1.098-2.013,1.464-2.013,2.194,0C36.02,10.152,35.837,11.615,35.289,12.165z
     M43.34,11.067c0,1.098-0.732,1.28-1.83,0.732c-0.916-0.548-1.83-2.013-1.83-2.928c0-1.099,0.914-1.281,1.83-0.732
    C42.607,8.688,43.34,10.152,43.34,11.067z M29.616,10.884c-0.548,0.915-2.013,1.83-2.928,1.83c-1.098,0-1.28-0.915-0.732-1.83
    c0.548-1.099,2.013-1.83,2.928-1.83C29.982,9.054,30.164,9.786,29.616,10.884z M50.658,10.884c0,0.915-0.732,1.83-1.828,1.83
    c-0.916,0-1.832-0.915-1.832-1.83c0-1.099,0.916-1.83,1.832-1.83C49.926,9.054,50.658,9.786,50.658,10.884z M26.871,18.204
    c0,2.012-1.281,3.659-2.745,3.659c-2.745,0-3.843-3.843-1.463-6.038C24.858,13.446,26.871,14.543,26.871,18.204z M36.02,18.204
    c0,2.012-1.282,3.659-2.745,3.659c-2.744,0-3.843-3.843-1.463-6.038C34.006,13.446,36.02,14.543,36.02,18.204z M45.719,18.204
    c0.73,2.744,0,3.659-2.563,3.659c-2.195,0-3.477-1.281-3.477-3.659c0-2.013,1.098-3.66,2.563-3.66
    C43.521,14.543,45.168,16.19,45.719,18.204z M53.951,16.739c3.293,3.294,2.746,5.124-1.463,5.124c-2.379,0-3.658-1.281-3.658-3.659
    C48.83,13.995,50.658,13.446,53.951,16.739z M26.871,28.267c0,1.463-1.281,2.745-2.745,2.745s-2.745-1.281-2.745-2.745
    c0-1.464,1.281-2.745,2.745-2.745S26.871,26.803,26.871,28.267z M36.02,28.267c0,1.463-1.282,2.745-2.745,2.745
    c-1.463,0-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745C34.738,25.522,36.02,26.803,36.02,28.267z M45.168,28.267
    c0,1.463-1.281,2.745-2.744,2.745s-2.744-1.281-2.744-2.745c0-1.464,1.281-2.745,2.744-2.745S45.168,26.803,45.168,28.267z
     M55.783,27.718c-1.281,3.476-6.953,4.026-6.953,0.732c0-1.83,1.645-2.928,3.842-2.928C54.867,25.522,56.148,26.437,55.783,27.718z
     M28.701,36.502c0,0.914-0.366,1.829-0.732,1.829c-0.549,0-1.465-0.915-2.013-1.829c-0.548-1.098-0.183-1.83,0.732-1.83
    C27.786,34.672,28.701,35.404,28.701,36.502z M36.02,37.416c0,1.464-0.367,2.745-0.731,2.745c-0.366,0-1.1-1.281-1.83-2.745
    c-0.55-1.463-0.184-2.744,0.73-2.744C35.289,34.672,36.02,35.953,36.02,37.416z M43.34,36.318c0,1.098-0.732,2.379-1.83,2.927
    c-0.916,0.549-1.83-0.182-1.83-1.646c0-1.646,0.914-2.927,1.83-2.927C42.607,34.672,43.34,35.404,43.34,36.318z M50.658,35.404
    c0,0.549-0.732,1.463-1.828,2.012c-0.916,0.548-1.832,0.183-1.832-0.733c0-1.097,0.916-2.011,1.832-2.011
    C49.926,34.672,50.658,35.038,50.658,35.404z"/>
<path fill="#2c303b" d="M1.254,52.055v11.895h5.489h5.49V52.055V40.161h-5.49H1.254V52.055z"/>
<path fill="#2c303b" d="M16.258,52.055l0.548,8.602l10.979,3.84l10.979,3.662l15.002-8.053c14.822-7.684,16.836-9.514,13.725-11.529
    c-2.379-1.462-15.371,2.564-18.848,5.676c-2.012,1.645-5.854,2.377-10.979,1.83l-8.05-0.734l8.783-0.182
    c7.137-0.365,8.6-0.914,8.6-3.844c0-2.746-1.83-3.66-8.6-4.575c-4.94-0.549-11.895-1.646-15.736-2.194l-6.954-1.099L16.258,52.055z"
    />
</svg>
';
                        break;
                }

                if ($localItem['value'] != '') {
                    $returnData[] = $localItem;
                }
            }
        }

        $finalReponce = array();

        if (count($returnData) > 0) {
            foreach ($returnData as $returnDat) {
                if ($returnDat['value'] > 47) {
                    $finalReponce[] = $returnDat;
                }
            }
        }
        if(count($finalReponce) == 0) {
            $finalReponce[] = "Talent Mining Not Found";
        }
        //return $finalReponce;
        return response()->success(compact('finalReponce'));

    }

 
    
}