<?php

namespace App\Http\Controllers;
use DB;
use App\User;
use Auth;
use App\BellNotifications;
use App\EmployerUserJobs;
use App\VendorRevenue;
use App\VendorRevenueRule;
use App\Pricing;
use App\City;
use App\Company;
use Carbon\Carbon;
use App\EducationAssociations;
use App\JobOrders;
use App\TalentpoolDeviationRequests;
use App\JobType;
use App\JobCitys;
use App\JobSkills;
use App\Country;
use App\JobLanguage;
use App\ProcessSurvey;
use App\Industries;
use App\Talentpools;
use App\Association;
use DateTime;
use DateInterval;
use date_add;
use App\GdprData;
use date_interval_create_from_date_string;
use App\TalentpoolSkill;
use App\TalentpoolLocation;
use App\TalentpoolRequests;
//use App\VendorRevenueRule;
//use App\VendorRevenue;
use App\Skills;
use App\SkillBroadcategories;
use App\SkillCategories;
use App\Activity;
use App\ContracttohireCalculation;
use App\Http\Requests\Filetotext;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use Mail; 
class TalentpoolController extends Controller
{
    
  public function getIndex(){
    $authuser = Auth::user();
      $talentpools = Talentpools::where('vendor_id',$authuser->id)->get();
      foreach ( $talentpools as $talentpooldata) {
          $skill_names = array();
          $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$talentpooldata['id'])->with('skill_category')
                     ->get();
                     foreach ( $fetchtalantpoolskills as $talentpool_skill) {
                      array_push($skill_names,$talentpool_skill['skill_category']['name']);
                             }
                             $skills_data = implode(" , ",$skill_names);

       $numbers = ['skills'=>$skills_data];                        
      $talentpooldata['skills_data']=  $numbers;   
     }
      return response()->success(compact('talentpools'));
  }
  public function getAlltalentpools(){
    $authuser = Auth::user();
    $alltalentpools = Talentpools::where('status',1)->get();
    foreach ( $alltalentpools as $talentpool) {
        $skill_names = array();
        $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$talentpool['id'])->with('skill_category')->get();
        foreach ( $fetchtalantpoolskills as $talentpool_skill) {
          array_push($skill_names,$talentpool_skill['skill_category']['name']);
        }
        $skills_data = implode(" , ",$skill_names);
        $countpools = Association::where('employer_id',$authuser->id)->where('talentpool_id',$talentpool['id'])->count();
        $numbers = ['request_count'=>$countpools ,'skills'=>$skills_data ];                        
        $talentpool['requests']=  $numbers;   
    }

      return response()->success(compact('alltalentpools'));
  }
  public function getUserdata(){
      $userdata = Auth::user();
      return response()->success($userdata->role_id);
  }
  public function postCreatequestion(Request $request) {
      $authuser = Auth::user();
      $updateCurrentUsercontext = ProcessSurvey::create([
          'question' => $request['name'],
          'answertype' => $request['explain'],
          'role_id' => $authuser->role_id
      ]);
      return response()->success("Created success");
  }
  public function postTalentpools(){
      $authuser = Auth::user();
      $tp_name= strtoupper(Input::get('name'));
      $tp_name = str_replace(" ", "", $tp_name);
      $result = substr($tp_name, 0, 3);
      $length=5;
      $rate_type=Input::get('rateType');
      $min_rate=Input::get('minRate');
      $max_rate=Input::get('maxRate');
      if($rate_type == 'Per Month'){
        $min_rate_hour=((int)$min_rate / 30) / 8;
        $max_rate_hour=((int)$max_rate / 30) / 8;
      }else if($rate_type == 'Per Week'){
        $min_rate_hour=((int)$min_rate / 7) / 8;
        $max_rate_hour=((int)$max_rate / 7) / 8;
      }else if($rate_type == 'Per Day'){
        $min_rate_hour=((int)$min_rate) / 8;
        $max_rate_hour=((int)$max_rate) / 8;
      }else if($rate_type == 'Per Year'){
        $min_rate_hour=((int)$min_rate / 365) / 8;
        $max_rate_hour=((int)$max_rate / 365) / 8;
      }else if($rate_type == 'Per Hour'){
        $min_rate_hour=$min_rate;
        $max_rate_hour=$max_rate;
      }
      $randm_num=substr(str_shuffle(str_repeat($x='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
      $result = $result.$randm_num;
      $talentpools = Talentpools::create([
              'name' => Input::get('name'),
              'description' => Input::get('description'),
              'vendor_id' => $authuser->id,
              'availability' => Input::get('availability'),
              'relocate' => Input::get('relocate'),
              'status' => Input::get('status_active'),
              'min_rate' => $min_rate_hour,
              'max_rate' => $max_rate_hour,
              'rate_type' => Input::get('rateType'),
              'currency_type'=>Input::get('currencyType'),
              'candidate_name' => Input::get('candidate_name'),
              'resume_name' => Input::get('resume_name'),
              'talentpool_code'=> $result,
              'min_rate_hour'=> round($min_rate_hour),
              'max_rate_hour'=> round($max_rate_hour)
      ]);
      $locationsIds = Input::get('location');
      if(count($locationsIds)){
          foreach ($locationsIds as $value) {
              TalentpoolLocation::create([
                  'location_id'=>$value['id'],
                  'talentpool_id' => $talentpools->id,
              ]);
          }
      }
      $skills = Input::get('requiredTags');
      if(count($skills)){
            foreach ($skills as $value) {
              TalentpoolSkill::create([
                'talentpool_id' => $talentpools->id,
                'experience' => $value['experience'],
                'skill_id' => $value['skill_id'],
              ]);
            } 
      }
      //Insert Successfull status create activity record
      $newPool = Activity::create([
              'person_id' => $authuser->id,
              'name' => 'Created new talentpool.',
      ]);
      $newTalentpool=  response()->success(compact('newTalentpool'));
      return response()->success(compact('talentpools'));
  }
  public function postTalentpoolsupdate(){
    $authuser = Auth::user();
    $talentpooldata = [
      'name' => Input::get('name'),
      'description' => Input::get('description'),
      'availability' => Input::get('availability'),
      'relocate' => Input::get('relocate'),
      'status' => Input::get('status'),
      'min_rate' => Input::get('minRate'),
      'max_rate' => Input::get('maxRate'),
      'rate_type' => Input::get('rateType'),
      'candidate_name' => Input::get('candidate_name'),
              ];
    $talentpools = Talentpools::where('id', '=', intval(Input::get('talantPoolId')))->update($talentpooldata);
    $talentpoolskillsdelete=TalentpoolSkill::where('talentpool_id','=',intval(Input::get('talantPoolId')))->delete();
    $skills = Input::get('requiredTags');
    if(count($skills)){
      foreach ($skills as $value) {
        TalentpoolSkill::create([
          'talentpool_id' => Input::get('talantPoolId'),
          'experience' => $value['experience'],
          'skill_id' => $value['skill_id'],
        ]);
      } 
    }
    $locationsdelete=TalentpoolLocation::where('talentpool_id','=',intval(Input::get('talantPoolId')))->delete();
    $locationsIds = Input::get('location');
    if(count($locationsIds)){
      foreach ($locationsIds as $value) {
          TalentpoolLocation::create([
              'location_id'=>$value['id'],
              'talentpool_id' => Input::get('talantPoolId'),
          ]);
      }
    }
    //Insert Successfull status create activity record
    $newPool = Activity::create([
            'person_id' => $authuser->id,
            'name' => 'Updated talentpool skills and status.',
    ]);
    return response()->success("Updated Successfully");
  }
  public function postTalentpoolsintrest(){
      $authuser = Auth::user();
      $amId = Association::where('employer_id',$authuser->id)
                          ->whereNotNull('accountmanager_id')
                          ->whereNull('job_id')
                          ->whereNull('vendor_id')
                          ->first()->accountmanager_id;
      $vendoravailability = Association::where('accountmanager_id',$amId)
                          ->where('vendor_id',Input::get('vendor_id'))
                          ->whereNull('job_id')
                          ->count();
      if($vendoravailability == 0){
          $association_info = Association::where('employer_id',$authuser->id)
                                      ->whereNull('job_id')
                                      ->whereNull('vendor_id')
                                      ->whereNotNull('accountmanager_id')
                                      ->with('employer')
                                      ->with('accountmanager')
                                      ->get();
          $userassociation = new Association();
          $userassociation->admin_id = 1;
          $userassociation->vendor_id = Input::get('vendor_id');
          $userassociation->accountmanager_id = $amId;
          $userassociation->save();  
          $vendor_data = User::where('id',Input::get('vendor_id'))->get();
          $t_data = Talentpools::where('id',Input::get('talantPoolId'))->get();
         /* Mail::send('emails.notifyAmNewVendorassignedForTalentpool', ['userName' => $association_info[0]['accountmanager']['first_name'], 'candidateName' => '', 'talentpoolName' => $t_data[0]['name'] ,'vendor_name' =>$vendor_data[0]['first_name'], 'vendor_id' => $vendor_data[0]['id'],'employer_name' => $association_info[0]['employer']['first_name'],'employer_id' => $association_info[0]['employer']['id'],'text' => 'This Vendor is assigned to you.'], function ($m) use($association_info, $vendor_data,$t_data) {
             $m->to($association_info[0]['accountmanager']['email'], 'Vendor Assigned.')->subject('Vendor Assigned because of Talentpool Request.');
          });*/
          $talentpool_creation = new TalentpoolRequests();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = Input::get('vendor_id');
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talantPoolId');
          $talentpool_creation->job_id = Input::get('jobid');
          $talentpool_creation->save();

          $talentpool_creation = new Association();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = Input::get('vendor_id');
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talantPoolId');
         // $talentpool_creation->job_id = Input::get('jobid');
          $talentpool_creation->save();  
          $newPool = Activity::create([
                  'person_id' => $authuser->id,
                  'name' => 'Employer requested this talentpool.',
          ]);
      }else{
          $talentpool_creation = new TalentpoolRequests();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = Input::get('vendor_id');
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talantPoolId');
          $talentpool_creation->job_id = Input::get('jobid');
          $talentpool_creation->save();
          
          $talentpool_creation = new Association();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = Input::get('vendor_id');
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talantPoolId');
          $talentpool_creation->save();    
            $newPool = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Employer requested this talentpool.',
            ]); 
      }
      return response()->success("Request has been sent");
  }
  public function postSelecttalentpool(){
      $authuser = Auth::user();
      $job_id = Input::get('jobid');
      $t_data = Talentpools::where('id',Input::get('talentpool_id'))->get();
      //print_r(Input::get('talantPoolId'));
      $vendor_id = $t_data[0]['vendor_id'];
     // print_r($t_data);
      $amId = Association::where('employer_id',$authuser->id)
                          ->whereNotNull('accountmanager_id')
                          ->whereNull('job_id')
                          ->whereNull('vendor_id')
                          ->first()->accountmanager_id;
      $vendoravailability = Association::where('accountmanager_id',$amId)
                          ->where('vendor_id',Input::get('vendor_id'))
                          ->whereNull('job_id')
                          ->count();
      $job = JobOrders::where('id', '=', intval($job_id))
                            ->with('JobCitys')
                            ->with('Industry')
                            ->with('JobType')
                            ->get();
      $association_info = Association::where('employer_id',$authuser->id)
                                      ->whereNull('job_id')
                                      ->whereNull('vendor_id')
                                      ->whereNotNull('accountmanager_id')
                                      ->with('employer')
                                      ->with('accountmanager')
                                      ->get();
    if($vendoravailability == 0){
          /*$association_info = Association::where('employer_id',$authuser->id)
                                      ->whereNull('job_id')
                                      ->whereNull('vendor_id')
                                      ->whereNotNull('accountmanager_id')
                                      ->with('employer')
                                      ->with('accountmanager')
                                      ->get();*/
          $userassociation = new Association();
          $userassociation->admin_id = 1;
          $userassociation->vendor_id = $vendor_id;
          $userassociation->accountmanager_id = $amId;
          $userassociation->save();  
          
          $vendor_data = User::where('id',$vendor_id)->get();
         
    
          $talentpool_creation = new TalentpoolRequests();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = $vendor_id;
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talentpool_id');
          $talentpool_creation->job_id = Input::get('jobid');
          $talentpool_creation->vendor_bill_rate = Input::get('vendor_bill_rate');
          $talentpool_creation->hirextra_margin_rate = Input::get('hirextra_margin_rate');
          $talentpool_creation->save();

          $ass_create = new Association();
          $ass_create->admin_id = 1;
          $ass_create->vendor_id = $vendor_id;
          $ass_create->accountmanager_id =$amId;
          $ass_create->employer_id =  $authuser->id;
          $ass_create->talentpool_id = Input::get('talentpool_id');
         // $talentpool_creation->job_id = Input::get('jobid');
          $ass_create->save();  
          $newPool = Activity::create([
                  'person_id' => $authuser->id,
                  'name' => 'Employer requested this talentpool.',
          ]);
           $job_ass_data = Association::where('accountmanager_id',$amId)
                                   ->where('employer_id',$authuser->id)
                                   ->where('vendor_id',$vendor_id)
                                   ->where('job_id',$job_id)
                                   ->count();
        if($job_ass_data <= 0){
          $citysData=NULL;
          $citys=$job[0]->JobCitys;
          foreach ($citys as $key => $value) {
              $citysData[$key] = $value->city_name;
          }// foreach
          if($citysData!=NULL){
          $citys= implode(",",$citysData);
          }
          $country = Country::where('is_enabled',1)->first();
          $countryId = $country->id;

          if(! ( $countryId == 1 || $countryId == 3 || ( $countryId >= 25 && $countryId <= 50)) )
              { $countryId = Country::where('id',2)->first()->id; }
         
          $price = array();
          $timeLimit = array();

          $revenue=VendorRevenueRule::where('country_id',$countryId)
                      ->whereNotNull('time_limit')
                      ->orderBy('time_limit', 'ASC')
                      ->with('country')
                      ->get();

          foreach ($revenue as $key => $value) {
              $timeLimit[$key] = $value->time_limit;
              $price[$key] = $value->price;
          }// foreach

          $vendorRevenueValues = VendorRevenue::where("job_id",$job_id)
                        ->where('default_revenue',0)
                        ->whereNull('vendor_id')
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->whereNotNull('est_revenue_4')
                        ->whereNotNull('est_revenue_5')
                        ->first();

            $vendorassociation = new Association();
            $vendorassociation->admin_id = 1;
            $vendorassociation->accountmanager_id = $amId;
            $vendorassociation->employer_id = JobOrders::where('id',$job_id)->first()->user_id;
            $vendorassociation->vendor_id = $vendor_id;
            $vendorassociation->job_id = $job_id;
            $vendorassociation->job_status = 4;
            $vendorassociation->status_updated_by = $authuser->id;
            $vendorassociation->is_talentpool = 1;
            $vendorassociation->save();

            $amassociation = User::where('id', Input::get('vendor_id'))->first();

            $vendoractivity = new Activity();
            $vendoractivity->name = "Job assigned to vendor";
            $vendoractivity->admin_id = 1;
            $vendoractivity->accountmanager_id = $amId;
            $vendoractivity->employer_id = JobOrders::where('id',$job_id)->first()->user_id;
            $vendoractivity->vendor_id = $vendor_id;
            $vendoractivity->job_id = $job_id;
            $vendoractivity->job_status = 4;
            $vendoractivity->activity_by = $amId;
            $vendoractivity->is_vendor_sourcing_activity = 0;
            $vendoractivity->save();

            $vendoractivity_vsa = new Activity();
            $vendoractivity_vsa->name = "Job assigned to vendor";
            $vendoractivity_vsa->admin_id = 1;
            $vendoractivity_vsa->accountmanager_id = $amId;
            $vendoractivity_vsa->employer_id=JobOrders::where('id',$job_id)->first()->user_id;
            $vendoractivity_vsa->vendor_id = $vendor_id;
            $vendoractivity_vsa->job_id = $job_id;
            $vendoractivity_vsa->job_status = 4;
            $vendoractivity_vsa->activity_by = $amId;
            $vendoractivity_vsa->is_vendor_sourcing_activity = 1;
            $vendoractivity_vsa->save();

            $hrs =date('H');
            $msg = "";
            //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
            if ($hrs >  0) $msg = "Good Morning";      // After 6am
            if ($hrs > 12) $msg = "Good Afternoon";    // After 12pm
            if ($hrs > 17) $msg = "Good Evening";      // After 5pm
            if ($hrs > 23) $msg = "Good Day";        // After 10pm

            $vendorrevenue = new VendorRevenue();
            $vendorrevenue->job_id = (int) $job_id;
            $vendorrevenue->vendor_id = (int) $vendor_id;
            $vendorrevenue->default_revenue = 0;
            $vendorrevenue->est_revenue_1 = $vendorRevenueValues->est_revenue_1;
            $vendorrevenue->est_revenue_2 = $vendorRevenueValues->est_revenue_2;
            $vendorrevenue->est_revenue_3 = $vendorRevenueValues->est_revenue_3;
            $vendorrevenue->est_revenue_4 = $vendorRevenueValues->est_revenue_4;
            $vendorrevenue->est_revenue_5 = $vendorRevenueValues->est_revenue_5;
            $vendorrevenue->save();
            

            $within5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[0]." minutes")); 
            $after5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[1]." minutes"));
            $after24hours = date('H:i d-m-Y', strtotime("now ".$timeLimit[2]." minutes"));
            $after7d = date('H:i d-m-Y', strtotime("now ".$timeLimit[3]." minutes"));
            $after30d = date('H:i d-m-Y', strtotime("now ".$timeLimit[4]." minutes"));
            $currency =  $country->currency;

           Mail::send('emails.makeMoneyContractType', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys,'price1' => $vendorRevenueValues->est_revenue_1, 'price2' => $vendorRevenueValues->est_revenue_2, 'price3' => $vendorRevenueValues->est_revenue_3,'price4' => $vendorRevenueValues->est_revenue_4,'price5' => $vendorRevenueValues->est_revenue_5, 'within5hrs' => $within5hrs, 'after5hrs' => $after5hrs, 'after24hours' => $after24hours, 'after7d' => $after7d,'after30d' => $after30d, 'currencySymbol' => $currency ], function ($m) use($amassociation){
                    $m->to($amassociation->email, 'New job assignment')->subject('New job assigned to you');
            });
              
            Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info[0]['accountmanager']['first_name'], 'candidateName' => '', 'vendorName' => $amassociation->first_name,'jobName' => $association_info[0]['job']['name'], 'jobId' => $job_id,'jobCode' => $association_info['job']['job_internal_code'],'text' => 'Job Assigned to Vendor'], function ($m) use($association_info) {
                 $m->to($association_info[0]['accountmanager']['email'], 'Job Assigned to Vendor')->subject('Job Assigned to Vendor');
            });
            $number = $amassociation->mobile;
            $countryCode = $country->ISD_code;
            $ch = curl_init();
            $user="kv@hirextra.com";
            $password="Kumar786%";
            $receipientno = $countryCode.$number; 
            $originator = "HRXTRA";
            $msgtxt="Your account manager ".$association_info[0]['accountmanager']['first_name']." assigned a new job";
            curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $job[0]->status = 8;
            $job[0]->save(); 
          }   
    }else{
          $talentpool_creation = new TalentpoolRequests();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = $vendor_id;
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talentpool_id');
          $talentpool_creation->job_id = Input::get('jobid');
          $talentpool_creation->vendor_bill_rate = Input::get('vendor_bill_rate');
          $talentpool_creation->hirextra_margin_rate = Input::get('hirextra_margin_rate');
          $talentpool_creation->save();
          
          $talentpool_creation = new Association();
          $talentpool_creation->admin_id = 1;
          $talentpool_creation->vendor_id = $vendor_id;
          $talentpool_creation->accountmanager_id =$amId;
          $talentpool_creation->employer_id =  $authuser->id;
          $talentpool_creation->talentpool_id = Input::get('talentpool_id');
          $talentpool_creation->save();    
            $newPool = Activity::create([
                    'person_id' => $authuser->id,
                    'name' => 'Employer requested this talentpool.',
            ]); 
            $job_ass_data = Association::where('accountmanager_id',$amId)
                                   ->where('employer_id',$authuser->id)
                                   ->where('vendor_id',$vendor_id)
                                   ->where('job_id',$job_id)
                                   ->count();
      if($job_ass_data <= 0){
        $citysData=NULL;
        $citys=$job[0]->JobCitys;
        foreach ($citys as $key => $value) {
            $citysData[$key] = $value->city_name;
        }// foreach
        if($citysData!=NULL){
        $citys= implode(",",$citysData);
        }
        $country = Country::where('is_enabled',1)->first();
        $countryId = $country->id;

        if(! ( $countryId == 1 || $countryId == 3 || ( $countryId >= 25 && $countryId <= 50)) )
            { $countryId = Country::where('id',2)->first()->id; }
       
        $price = array();
        $timeLimit = array();
        $revenue=VendorRevenueRule::where('country_id',$countryId)
                    ->whereNotNull('time_limit')
                    ->orderBy('time_limit', 'ASC')
                    ->with('country')
                    ->get();

        foreach ($revenue as $key => $value) {
            $timeLimit[$key] = $value->time_limit;
            $price[$key] = $value->price;
        }

        $vendorRevenueValues = VendorRevenue::where("job_id",$job_id)
                        ->where('default_revenue',0)
                        ->whereNull('vendor_id')
                        ->whereNotNull('est_revenue_1')
                        ->whereNotNull('est_revenue_2')
                        ->whereNotNull('est_revenue_3')
                        ->whereNotNull('est_revenue_4')
                        ->whereNotNull('est_revenue_5')
                        ->first();

            $vendorassociation = new Association();
            $vendorassociation->admin_id = 1;
            $vendorassociation->accountmanager_id = $amId;
            $vendorassociation->employer_id = JobOrders::where('id',$job_id)->first()->user_id;
            $vendorassociation->vendor_id = $vendor_id;
            $vendorassociation->job_id = $job_id;
            $vendorassociation->job_status = 4;
            $vendorassociation->is_talentpool = 1;
            $vendorassociation->status_updated_by = $authuser->id;
            $vendorassociation->save();

            $amassociation = User::where('id', $vendor_id)->first();

            $vendoractivity = new Activity();
            $vendoractivity->name = "Job assigned to vendor";
            $vendoractivity->admin_id = 1;
            $vendoractivity->accountmanager_id = $amId;
            $vendoractivity->employer_id = JobOrders::where('id',$job_id)->first()->user_id;
            $vendoractivity->vendor_id = $vendor_id;
            $vendoractivity->job_id = $job_id;
            $vendoractivity->job_status = 4;
            $vendoractivity->activity_by = $amId;
            $vendoractivity->is_vendor_sourcing_activity = 0;
            $vendoractivity->save();

            $vendoractivity_vsa = new Activity();
            $vendoractivity_vsa->name = "Job assigned to vendor";
            $vendoractivity_vsa->admin_id = 1;
            $vendoractivity_vsa->accountmanager_id = $amId;
            $vendoractivity_vsa->employer_id=JobOrders::where('id',$job_id)->first()->user_id;
            $vendoractivity_vsa->vendor_id = $vendor_id;
            $vendoractivity_vsa->job_id = $job_id;
            $vendoractivity_vsa->job_status = 4;
            $vendoractivity_vsa->activity_by = $amId;
            $vendoractivity_vsa->is_vendor_sourcing_activity = 1;
            $vendoractivity_vsa->save();

            $hrs =date('H');
            $msg = "";
            //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
            if ($hrs >  0) $msg = "Good Morning";      // After 6am
            if ($hrs > 12) $msg = "Good Afternoon";    // After 12pm
            if ($hrs > 17) $msg = "Good Evening";      // After 5pm
            if ($hrs > 23) $msg = "Good Day";        // After 10pm
            $vendorrevenue = new VendorRevenue();
            $vendorrevenue->job_id = (int) $job_id;
            $vendorrevenue->vendor_id = (int) $vendor_id;
            $vendorrevenue->default_revenue = 0;
            $vendorrevenue->est_revenue_1 = $vendorRevenueValues->est_revenue_1;
            $vendorrevenue->est_revenue_2 = $vendorRevenueValues->est_revenue_2;
            $vendorrevenue->est_revenue_3 = $vendorRevenueValues->est_revenue_3;
            $vendorrevenue->est_revenue_4 = $vendorRevenueValues->est_revenue_4;
            $vendorrevenue->est_revenue_5 = $vendorRevenueValues->est_revenue_5;
            $vendorrevenue->save();
            

            $within5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[0]." minutes")); 
            $after5hrs = date('H:i d-m-Y', strtotime("now ".$timeLimit[1]." minutes"));
            $after24hours = date('H:i d-m-Y', strtotime("now ".$timeLimit[2]." minutes"));
            $after7d = date('H:i d-m-Y', strtotime("now ".$timeLimit[3]." minutes"));
            $after30d = date('H:i d-m-Y', strtotime("now ".$timeLimit[4]." minutes"));
            $currency =  $country->currency;

            Mail::send('emails.makeMoneyContractType', ['msg' => $msg, 'name' => $amassociation->first_name, 'industry' => $job[0]->Industry->name, 'vacancies' => $job[0]->vacancies, 'jobName' => $job[0]->name, 'CityPin' => $citys,'price1' => $vendorRevenueValues->est_revenue_1, 'price2' => $vendorRevenueValues->est_revenue_2, 'price3' => $vendorRevenueValues->est_revenue_3,'price4' => $vendorRevenueValues->est_revenue_4,'price5' => $vendorRevenueValues->est_revenue_5, 'within5hrs' => $within5hrs, 'after5hrs' => $after5hrs, 'after24hours' => $after24hours, 'after7d' => $after7d,'after30d' => $after30d, 'currencySymbol' => $currency ], function ($m) use($amassociation){
                    $m->to($amassociation->email, 'New job assignment')->subject('New job assigned to you');
            });
            Mail::send('emails.notifyAmJobAssignedApplications', ['userName' => $association_info[0]['accountmanager']['first_name'], 'candidateName' => '', 'vendorName' => $amassociation->first_name,'jobName' => $association_info[0]['job']['name'], 'jobId' => $job_id,'jobCode' => $association_info[0]['job']['job_internal_code'],'text' => 'Job Assigned to Vendor'], function ($m) use($association_info) {
                 $m->to($association_info[0]['accountmanager']['email'], 'Job Assigned to Vendor')->subject('Job Assigned to Vendor');
            });
            $number = $amassociation->mobile;
            $countryCode = $country->ISD_code;
            $ch = curl_init();
            $user="kv@hirextra.com";
            $password="Kumar786%";
            $receipientno = $countryCode.$number; 
            $originator = "HRXTRA";
            $msgtxt="Your account manager ".$association_info[0]['accountmanager']['first_name']." assigned a new job";
            curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
            $buffer = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $job[0]->status = 8;
            $job[0]->save(); 
      }}
      return response()->success("Request has been sent");
  }
  public function getFetchtalantpool($id){  
    $authuser = Auth::user();
    if($authuser->role_id == 10){
       $talentpool_req_data = ['am_seen' => 0];
      $talentpools_req_updat = TalentpoolRequests::where('talentpool_id',$id)->where('accountmanager_id',$authuser->id)->update($talentpool_req_data);
    }
    if($authuser->role_id == 6){
       $talentpool_req_data = ['vendor_seen' => 0];
      $talentpools_req_updat = TalentpoolRequests::where('talentpool_id',$id)->where('vendor_id',$authuser->id)->update($talentpool_req_data);
    }
    $fetchtalantpool = Talentpools::where('id',$id)->with('talentlocations.city')->get();
    foreach ( $fetchtalantpool as $talentpool) {
        $countpools = Association::where('employer_id',$authuser->id)
                            ->where('talentpool_id',$talentpool['id'])
                            ->count();
        $numbers = ['request_count'=>$countpools];                        
        $talentpool['requests']=  $numbers;   
    }
    return  response()->success(compact('fetchtalantpool'));
  }
  public function postTalentpoolsskill(){
    $authuser = Auth::user();
    $talentpoolskill = TalentpoolSkill::create([
              'talentpool_id' => Input::get('talentpool_id'),
              'experience' => Input::get('experience'),
              'skill_id' => Input::get('skill_id'),
    ]);
    $talentpoolskill = TalentpoolSkill::where('talentpool_id',Input::get('talentpool_id'))
                     ->get();
      //Insert Successfull status create activity record
    $newPool = Activity::create([
            'person_id' => $authuser->id,
            'name' => 'Created new talentpool skill.',
    ]);
    return response()->success(compact('talentpoolskill'));
  }
  public function postTalentpoolssearch(){
      $authuser = Auth::user();
      $min_rate = Input::get('minRate');
      $max_rate = Input::get('maxRate');
      $rate_type = Input::get('rateType');
      $locations = Input::get('locations');
      $req_skills = Input::get('requiredTags');
      if($rate_type == 'Per Month'){
        $min_rate_hour=((int)$min_rate / 30) / 8;
        $max_rate_hour=((int)$max_rate / 30) / 8;
      }else if($rate_type == 'Per Week'){
        $min_rate_hour=((int)$min_rate / 7) / 8;
        $max_rate_hour=((int)$max_rate / 7) / 8;
      }else if($rate_type == 'Per Day'){
        $min_rate_hour=((int)$min_rate) / 8;
        $max_rate_hour=((int)$max_rate) / 8;
      }else if($rate_type == 'Per Year'){
        $min_rate_hour=((int)$min_rate / 365) / 8;
        $max_rate_hour=((int)$max_rate / 365) / 8;
      }else if($rate_type == 'Per Hour'){
        $min_rate_hour=$min_rate;
        $max_rate_hour=$max_rate;
      }
      $locationsIds = Input::get('locations');
        $locations_data = array();
      if(count($locationsIds)){
          foreach ($locationsIds as $value) {
             array_push($locations_data, $value['id']);
          }
      }
      if(count($locations_data) > 0){
        $talentpoolssearch= Talentpools::where('min_rate_hour','>=',$min_rate_hour)->where('status',1)
                          ->where('max_rate_hour','<=',$max_rate_hour)->with('talentlocations')
                          ->whereHas('talentlocations',function($query) use ($locations_data){
                           $query->whereIn('location_id',$locations_data);
                           })
                          ->get();
      }else{
        $talentpoolssearch= Talentpools::where('min_rate_hour','>=',$min_rate_hour)->where('status',1)
                          ->where('max_rate_hour','<=',$max_rate_hour)->with('talentlocations')
                          ->get();
      }
      if(count($talentpoolssearch) > 0){
        foreach($talentpoolssearch as $talentpools){
          $skill_names = array();
          $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$talentpools->id)->with('skill_category')->get();
          foreach ( $fetchtalantpoolskills as $talentpool_skill) {
            array_push($skill_names,strtolower($talentpool_skill['skill_category']['name']));
          } 
          $req_skill_names = array();
          foreach ($req_skills as $req_pool_skill) {
          array_push($req_skill_names,strtolower($req_pool_skill['text']));
          } 
          $result=array_intersect($req_skill_names,$skill_names);
          $talentpools->count_numbers=count($result);
          $talentpools->matched_skills=implode(" , ",$result);
          $talentpools->skills=implode(" , ",$skill_names);
        }
      }
     return response()->success(compact('talentpoolssearch'));
  }
  public function postTalentpoolsprofilesdata(){
        $authuser = Auth::user();
        $job_id=Input::get('job_id');
        $job_data = JobOrders::where('id',$job_id)->get(['billrate','salaryType','skills_required','skills_preferred','salaryType','payment_mode','payment_terms']);
        $deduct_rate = ContracttohireCalculation::where('method',$job_data[0]['payment_mode'])->where('duration',$job_data[0]['payment_terms'])->get(['deduction_rate']);
        $req_skills = $job_data[0]['skills_required'];
        $req_skills=explode(",",$req_skills);
        $pref_skills = $job_data[0]['skills_preferred'];
        $pref_skills=explode(",",$pref_skills);
        $job_citys = JobCitys::where('job_id',$job_id)->get(['city_name']);
        $billrate_type = $job_data[0]['salaryType'];
        if($billrate_type == 'Per Month'){
          $emp_billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;
        }
        if($job_data[0]['payment_mode'] == 'Collect and Pay' && $job_data[0]['payment_terms'] == 'Immediate')
           {
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
           $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Collect and Pay' && $job_data[0]['payment_terms'] == '15 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '15 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
           $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '30 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '45 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '60 days')
        {
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;  
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '90 days')
        { 
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '180 days')
        { 
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
            $ten_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*10;
            $twenty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*20;
            $therty_per = $hirextra_margin_rate + ($hirextra_margin_rate/100)*30;
        }
        $talentpoolsprofilesdata= Talentpools::where('status',1)
                              ->where('min_rate_hour','>',$hirextra_billrate)
                              ->groupBy('vendor_id')
                              ->with('vendor.company')
                              ->get();

        foreach($talentpoolsprofilesdata as $vendor)
          {
            $talentpoolsprofiles_data= Talentpools::where('status',1)
                        ->where('vendor_id',$vendor['vendor_id'])
                        ->where('min_rate_hour','>',$hirextra_billrate)
                        ->get();

            $zero_count = 0;
            $ten_count = 0;
            $twen_count = 0;
            $thty_count = 0;
            $thty_plus = 0;
            foreach($talentpoolsprofiles_data as $profiles)
            {
              if($profiles['min_rate_hour'] == $ten_per){
                $zero_count = $zero_count+1;
              }
              else if($profiles['min_rate_hour'] < $ten_per){
                $ten_count = $ten_count+1;
              }else if(($profiles['min_rate_hour'] < $twenty_per) && ($profiles['min_rate_hour'] > $ten_per)){
                $twen_count = $twen_count+1;
              }else if(($profiles['min_rate_hour'] < $therty_per) && ($profiles['min_rate_hour'] > $twenty_per)){
                $thty_count = $thty_count+1;
              }else if($profiles['min_rate_hour'] > $therty_per){
                $thty_plus = $thty_plus+1;
              }

            }
             $can_name = $vendor['vendor']['company']['name'];
            if(strlen($can_name) > 3){$parts = str_split($can_name, 3);}
            if(strlen($can_name) <= 3){ $parts = str_split($can_name, 2);}
            for ($x = 0; $x < count($parts); $x++) {
              if($x%2==0)
              {}
              else
              {
                if(strlen($parts[$x]) == 1){$parts[$x] = 'x';}else if(strlen($parts[$x]) == 2){
                  $parts[$x] = 'xx';
                }else if(strlen($parts[$x]) == 3){$parts[$x] = 'xxx';}else if(strlen($parts[$x]) == 4){
                  $parts[$x] = 'xxxx';}else{$parts[$x] = 'xxx';}
              }
            }
            $vendor['vendor_name'] = implode($parts); 
            $vendor['zero_count'] = $zero_count;
              $vendor['ten_count'] = $ten_count;
              $vendor['twen_count'] = $twen_count;
              $vendor['thty_count'] = $thty_count;
              $vendor['thty_plus'] = $thty_plus;
              $zero_count = 0;
              $ten_count = 0;
              $twen_count = 0;
              $thty_count = 0;
              $thty_plus = 0;
          }
        return response()->success(compact('talentpoolsprofilesdata'));
  }
   public function postTalentpoolsdata(){
        $authuser = Auth::user();
        $job_id=Input::get('job_id');
        $job_data = JobOrders::where('id',$job_id)->get(['billrate','salaryType','skills_required','skills_preferred','salaryType','payment_mode','payment_terms']);
        $deduct_rate = ContracttohireCalculation::where('method',$job_data[0]['payment_mode'])->where('duration',$job_data[0]['payment_terms'])->get(['deduction_rate']);
        $req_skills = $job_data[0]['skills_required'];
        $req_skills=explode(",",$req_skills);
        $pref_skills = $job_data[0]['skills_preferred'];
        $pref_skills=explode(",",$pref_skills);
        $job_citys = JobCitys::where('job_id',$job_id)->get(['city_name']);
        $billrate_type = $job_data[0]['salaryType'];
        if($billrate_type == 'Per Month'){
          $emp_billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;
        }
        if($job_data[0]['payment_mode'] == 'Collect and Pay' && $job_data[0]['payment_terms'] == 'Immediate')
           {
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }else if($job_data[0]['payment_mode'] == 'Collect and Pay' && $job_data[0]['payment_terms'] == '15 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '15 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
           // print_r($hirextra_billrate);
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '30 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '45 days'){
           $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '60 days')
        {
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;  
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '90 days')
        { 
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }else if($job_data[0]['payment_mode'] == 'Pay and Collect' && $job_data[0]['payment_terms'] == '180 days')
        { 
            $billrate_per_hour = ($job_data[0]['billrate'] / 30 ) / 8 ;  
            $hirextra_billrate = $billrate_per_hour - ($billrate_per_hour *($deduct_rate[0]['deduction_rate'] / 100));
            $hirextra_margin_rate = $billrate_per_hour - $hirextra_billrate;
        }
        $locations_data = array();
        foreach($job_citys as $citys) {
                array_push($locations_data, $citys->city_name);    
        }
        if(count($locations_data) > 0){
            $talentpoolsdata= Talentpools::where('status',1)->where('vendor_id',Input::get('vendor_id'))->where('min_rate_hour','>',$hirextra_billrate)->with('talentlocations')->with('vendor')->get();
        }else{
            $talentpoolsdata= Talentpools::where('status',1)->where('vendor_id',Input::get('vendor_id'))
                              ->where('min_rate_hour','>',$hirextra_billrate)->with('talentlocations')->with('vendor')->get();
        }
        if(count($talentpoolsdata) > 0){
          foreach($talentpoolsdata as $talentpools1){
            $talentpoolsrequests= TalentpoolRequests::where('job_id',$job_id)->where('talentpool_id',$talentpools1['id'])->count();
            if($talentpoolsrequests > 0){$talentpools1->talentpool_requst = 1;$talentpools1->job_id = $job_id;}
            else if($talentpoolsrequests <= 0){$talentpools1->talentpool_requst = 0;$talentpools1->job_id = $job_id;}
              
              if(((int)$talentpools1['min_rate_hour'] <= (int)$hirextra_billrate) && ((int)$talentpools1['max_rate_hour'] >= (int)$hirextra_billrate)){
                        $candidate_cost = $job_data[0]['billrate'];
                        $dev = '0';
                        $candidate_cost = $job_data[0]['billrate'];
                        $talentpools1['dev'] = $dev;
                        $talentpools1['candidate_cost'] = round($candidate_cost);
                        $talentpools1->job_type = $job_data[0]['salaryType'];
                        $talentpools1['hirextra_margin_rate'] = ($hirextra_margin_rate * 30 * 8);
                        $talentpools1['vendor_bill_rate'] = ($hirextra_billrate * 30 * 8);
              }
              if(((int)$talentpools1['min_rate_hour'] < (int)$hirextra_billrate) && ((int)$talentpools1['max_rate_hour'] < (int)$hirextra_billrate)){
                        $dev = '0';
                        $candidate_cost = $job_data[0]['billrate'];
                        $talentpools1['dev'] = $dev;
                        $talentpools1['candidate_cost'] = round($candidate_cost);
                        $talentpools1->job_type = $job_data[0]['salaryType'];
                        $talentpools1['hirextra_margin_rate'] = ($hirextra_margin_rate * 30 * 8);
                        $talentpools1['vendor_bill_rate'] = ($hirextra_billrate * 30 * 8);
                }
              if(((int)$talentpools1['min_rate_hour'] > (int)$hirextra_billrate) && ((int)$talentpools1['max_rate_hour'] > $hirextra_billrate)){
                        $dev_rate_cost = $talentpools1['min_rate_hour']-$hirextra_billrate;
                        if($job_data[0]['salaryType'] == 'Per Month'){
                        $candidate_cost = ($dev_rate_cost * 30 * 8) + $job_data[0]['billrate'];
                        }
                        $dev = ((int)$dev_rate_cost / (int)$emp_billrate_per_hour) * 100;
                        $talentpools1['dev'] = round($dev);
                        $talentpools1['candidate_cost'] = round($candidate_cost);
                        $talentpools1['hirextra_margin_rate'] = ($hirextra_margin_rate * 30 * 8);
                        $talentpools1['vendor_bill_rate'] = ($hirextra_billrate * 30 * 8);
                        $talentpools1->job_type = $job_data[0]['salaryType'];
                  }
          }
          foreach($talentpoolsdata as $talentpools){
            $can_name = $talentpools['candidate_name'];
            if(strlen($can_name) > 3){$parts = str_split($can_name, 3);}
            if(strlen($can_name) <= 3){ $parts = str_split($can_name, 2);}
            for ($x = 0; $x < count($parts); $x++) {
              if($x%2==0)
              {}
              else
              {
                if(strlen($parts[$x]) == 1){$parts[$x] = 'x';}else if(strlen($parts[$x]) == 2){
                  $parts[$x] = 'xx';
                }else if(strlen($parts[$x]) == 3){$parts[$x] = 'xxx';}else if(strlen($parts[$x]) == 4){
                  $parts[$x] = 'xxxx';}else{$parts[$x] = 'xxx';}
              }
            }
            $talentpools['candidate_name'] = implode($parts); 
            $first_name = $talentpools['vendor']['first_name'];
            if(strlen($first_name) > 3){$parts1 = str_split($first_name, 3);}
            if(strlen($first_name) <= 3){ $parts1 = str_split($first_name, 2);}
            for ($x = 0; $x < count($parts1); $x++) {
              if($x%2==0)
              {}
              else
              {
                if(strlen($parts1[$x]) == 1){$parts1[$x] = 'x';}else if(strlen($parts1[$x]) == 2){
                  $parts[$x] = 'xx';
                }else if(strlen($parts1[$x]) == 3){$parts1[$x] = 'xxx';}else if(strlen($parts1[$x]) == 4){
                  $parts1[$x] = 'xxxx';}else{$parts1[$x] = 'xxx';}
              }
            }
            $talentpools['vendor']['first_name'] = implode($parts1);
            $last_name = $talentpools['vendor']['last_name'];
            if(strlen($last_name) > 3){$parts2 = str_split($last_name, 3);}
            if(strlen($last_name) <= 3){ $parts2 = str_split($last_name, 2);}
          
            $talentpools['vendor']['last_name'] = implode($parts2); 
            $skill_names = array();
            $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$talentpools->id)->with('skill_category')->get();
            foreach ( $fetchtalantpoolskills as $talentpool_skill) {
              array_push($skill_names,strtolower($talentpool_skill['skill_category']['name']));
            } 
            $req_skill_names = array();
            foreach ($req_skills as $req_pool_skill) {
            array_push($req_skill_names,strtolower($req_pool_skill));
            } 
            $result=array_intersect($req_skill_names,$skill_names);
            $talentpools->count_numbers=count($result);
            $talentpools->matched_skills=implode(" , ",$result);
            $talentpools->skills=implode(" , ",$skill_names);
          }
          foreach($talentpoolsdata as $talentpools){
            $pre_skill_names = array();
            $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$talentpools->id)->with('skill_category')->get();
            foreach ( $fetchtalantpoolskills as $talentpool_skill) {
              array_push($pre_skill_names,strtolower($talentpool_skill['skill_category']['name']));
            } 
            $pref_skill_names = array();
            foreach ($pref_skills as $pre_pool_skill) {
            array_push($pref_skill_names,strtolower($pre_pool_skill));
            } 
            $result=array_intersect($pref_skill_names,$pre_skill_names);
            $talentpools->pre_count_numbers=count($result);
            $talentpools->pre_matched_skills=implode(" , ",$result);
            $talentpools->pre_skills=implode(" , ",$pre_skill_names);
          }
          foreach($talentpoolsdata as $talentpools){
            $total_skills_count = count($req_skills) + count($pref_skills);
            $match_count_skills = $talentpools['count_numbers'] + $talentpools['pre_count_numbers'];
            $matchedskills_percentage = ( $match_count_skills / $total_skills_count ) * 100;
            $talentpools->match_percentagge = round($matchedskills_percentage);
            $talentpools->hirextra_billrate = $hirextra_billrate;
            $talentpools->billrate = $job_data[0]['billrate'];
          }
        }
        return response()->success(compact('talentpoolsdata'));
  }
  public function postIndustriesverify(){
    $industriesverify=Industries::where('name', Input::get('name'))->get();
    $industriesverify['count']=count($industriesverify);
    return response()->success(compact('industriesverify'));
  }
  public function getFetchtalantpoolskills($id){
    $fetchtalantpoolskills = TalentpoolSkill::where('talentpool_id',$id)->with('skill_category.skill_broadcategory')
                     ->get();
    return  response()->success(compact('fetchtalantpoolskills'));
  }
  public function getSkillcategories($id){
    $skillcategories = SkillCategories::where('skill_broadcategory_id',$id)->get();
    return response()->success($skillcategories);
  }
  public function getSkills($id){
    $skills = Skills::where('skill_category_id',$id)->get();
    return response()->success($skills);
  }

/* ----------- Talentpool Jobs ----------------*/
  public function getAssignedalljobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $gdprJobId = array();
        $nongdprJobId = array();
        $gdprAssoStats = array();
        $nongdprAssoStats = array();
        $gdprSuccessJob = array();
        $vendorAccepted = array();
        $talentpool_jobs = array();
        $assignedalljobs =  Association::where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                         /*   ->whereIn('job_id',$talentpool_jobs)*/
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->whereHas('job',function($query) {
                                $query->where('is_talentpool',1);
                            })
                            ->get(); 
        foreach ($assignedalljobs as $job){
            if($job->job->gdprmandatory){
                $gdprJobId[] = $job->job_id;
            }else{
                $nongdprJobId[] = $job->job_id;                
            }
        }
        
         $gdprAssoStatsRaw =  Association::whereIn('job_id',$gdprJobId)->where('created_at','>=',$diff_date)
                            ->where('accountmanager_id',$authuser->id)->where('gdpr_status',1)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
        foreach ($gdprAssoStatsRaw as $stats){   
            $gdprAssoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );   
        }
        $nongdprAssoStatsRaw =  Association::whereIn('job_id',$nongdprJobId)->where('created_at','>=',$diff_date)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
        //});           
        foreach ($nongdprAssoStatsRaw as $stats){   
            $nongdprAssoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );                     
        }
        
        $bothgdprJobId = array_merge($gdprJobId, $nongdprJobId);
        //$gdprSuccessRaw = Cache::remember('getAssignedalljobs_gdprSuccessRaw', 60, function() use ($authuser, $bothgdprJobId, $diff_date) {
        $gdprSuccessRaw =  GdprData::whereIn('job_id',$bothgdprJobId)->where('created_at','>=',$diff_date)
                            ->where('status',1)
                            ->select('job_id', DB::raw('count(id) AS gdpr'))
                            ->groupBy('job_id')
                            ->get();
        //});             
        foreach ($gdprSuccessRaw as $stats){   
            $gdprSuccessJob[$stats->job_id] = $stats->gdpr;
        }     
        //$vendorAcceptedAtRaw = Cache::remember('getAssignedalljobs_gdprSuccessRaw', 60, function() use ($authuser, $bothgdprJobId, $diff_date) {
        $vendorAcceptedAtRaw =  Activity::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->whereIn('job_id',$bothgdprJobId)
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->select('job_id', 'created_at')
                            ->groupBy('job_id')
                            ->get();
        //});                    
        foreach ($vendorAcceptedAtRaw as $stats){   
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        } 
        
        reset($assignedalljobs);
        foreach ($assignedalljobs as $job){
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            $numbers['gdprSuccess'] = isset($gdprSuccessJob[$job['job_id']])?$gdprSuccessJob[$job['job_id']]:0;
            
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;
            
            $numbers['profilesReceived'] = 0;
            $numbers['rejectedProfiles'] = 0;
            $numbers['shortlistedProfiles'] = 0;
            $numbers['offeredProfiles'] = 0;
            $numbers['holdProfiles'] = 0;
            $numbers['interviwedProfiles'] = 0;

            if($job->job->gdprmandatory){
                if(!empty($gdprAssoStats[$job['job_id']])){
                    $numbers['profilesReceived'] = $gdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $gdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $gdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $gdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $gdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $gdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            }else{                
                if(!empty($nongdprAssoStats[$job['job_id']])){
                    $numbers['profilesReceived'] = $nongdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $nongdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $nongdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $nongdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $nongdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $nongdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }                
            }
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('assignedalljobs'));
    }
  public function getAssignedalljobsall()
    {
        $authuser = Auth::user();
        $gdprJobId = array();
        $nongdprJobId = array();
        $gdprAssoStats = array();
        $nongdprAssoStats = array();
        $gdprSuccessJob = array();
        $vendorAccepted = array();
        $assignedalljobsall = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->get();   
                    
        foreach ($assignedalljobsall as $job){
            if($job->job->gdprmandatory){
                $gdprJobId[] = $job->job_id;
            }else{
                $nongdprJobId[] = $job->job_id;                
            }
        }
        
        $gdprAssoStatsRaw = Association::whereIn('job_id',$gdprJobId)
                            ->where('accountmanager_id',$authuser->id)->where('gdpr_status',1)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1, 3, 20) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();

                            
        foreach ($gdprAssoStatsRaw as $stats){   
            $gdprAssoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );   
        }
        
        $nongdprAssoStatsRaw = Association::whereIn('job_id',$nongdprJobId)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1, 3, 20) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
                            
        foreach ($nongdprAssoStatsRaw as $stats){   
            $nongdprAssoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );                     
        }
        
        $bothgdprJobId = array_merge($gdprJobId, $nongdprJobId);
        $gdprSuccessRaw = GdprData::whereIn('job_id',$bothgdprJobId)
                            ->where('status',1)
                            ->select('job_id', DB::raw('count(id) AS gdpr'))
                            ->groupBy('job_id')
                            ->get();
                            
        foreach ($gdprSuccessRaw as $stats){   
            $gdprSuccessJob[$stats->job_id] = $stats->gdpr;
        }        
        
        $vendorAcceptedAtRaw=Activity::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->whereIn('job_id',$bothgdprJobId)
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->select('job_id', 'created_at')
                            ->groupBy('job_id')
                            ->get();
        foreach ($vendorAcceptedAtRaw as $stats){   
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }                             
        
        
        reset($assignedalljobsall);
        foreach ($assignedalljobsall as $job){
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            $numbers['gdprSuccess'] = isset($gdprSuccessJob[$job['job_id']])?$gdprSuccessJob[$job['job_id']]:0;
            
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;
            
            $numbers['profilesReceived'] = 0;
            $numbers['rejectedProfiles'] = 0;
            $numbers['shortlistedProfiles'] = 0;
            $numbers['offeredProfiles'] = 0;
            $numbers['holdProfiles'] = 0;
            $numbers['interviwedProfiles'] = 0;

            if($job->job->gdprmandatory){
                if(!empty($gdprAssoStats[$job['job_id']])){
                    $numbers['profilesReceived'] = $gdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $gdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $gdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $gdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $gdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $gdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }
            }else{                
                if(!empty($nongdprAssoStats[$job['job_id']])){
                    $numbers['profilesReceived'] = $nongdprAssoStats[$job['job_id']]['profilesReceived'];
                    $numbers['rejectedProfiles'] = $nongdprAssoStats[$job['job_id']]['rejectedProfiles'];
                    $numbers['shortlistedProfiles'] = $nongdprAssoStats[$job['job_id']]['shortlistedProfiles'];
                    $numbers['offeredProfiles'] = $nongdprAssoStats[$job['job_id']]['offeredProfiles'];
                    $numbers['holdProfiles'] = $nongdprAssoStats[$job['job_id']]['holdProfiles'];
                    $numbers['interviwedProfiles'] = $nongdprAssoStats[$job['job_id']]['interviwedProfiles'];
                }                
            }

            $job['numbers'] = $numbers;
        }
        return response()->success(compact('assignedalljobsall'));
    }
  public function getAmjoborderShow($id)
    {
        $authuser = Auth::user();
        $associationcount = Association::where('job_id',$id)
                            ->where('accountmanager_id',$authuser->id)
                            ->count();
                          
     if($associationcount >= 1){
       $joborders = JobOrders::where('is_talentpool',1)->with('status')->with('JobType')->with('JobCitys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->with('vendorcustomrevenues')->find($id);
        $joborders['new_updated_at'] = $joborders->created_at;
        $joborders['current_time']=Carbon::now();
        $closedjobProfileCount=(int) Association::where('job_id', $id)
                                ->where('accountmanager_id', $authuser->id)
                                ->whereIn('candidate_status', array(27, 28))
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->count();
                                
        $positions=(int) JobOrders::where('id', $id)->where('is_talentpool',1)->first()->vacancies;
        $joborders['checkifposclosed']=($positions == $closedjobProfileCount) ? 0 : 1 ;
        $joborders['positions_closed']=$closedjobProfileCount;

     }else{
        $joborders ="No data Found";
     }

     return response()->success($joborders);
    }
      public function getAmnumbers()
    {
        $authuser = Auth::user();

        $jobs_pending = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->with('job_closed.status')
                            ->whereNotNull('updated_at')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                            })
                            ->whereHas('job_closed',function($query){
                                $query->where('is_talentpool',1);
                            })
                             ->get();

            foreach ($jobs_pending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }
       
        $amnumbers[] = array('jobs_pending'=>$jobs_pending);
        return response()->success(compact('amnumbers'));
    }
    public function postJoborders() 
    {
        $authuser = Auth::user();
        $authId = null;
        $employerName = $authuser->first_name;
        if($authuser->parent_id){$authId = $authuser->parent_id;}
            else {$authId = $authuser->id;}
        if( !empty(Input::get('internalCode')) ) {
            $checkifInternal = JobOrders::where('job_internal_code', 'LIKE BINARY','%'.Input::get('internalCode').'%')->where('user_id',$authId)->count();        
        } else { $checkifInternal = false; }
        if(!$checkifInternal){
            $salaryType = Input::get('salaryType');
           if (Input::get('job_type_id') == 2) {
                $billrate = Input::get('billRate');
                $am_billRate = Input::get('am_billRate');
                $vendor_billRate = Input::get('vendor_billRate');
                $salaryType = Input::get('salaryType');
                $JobOrders = JobOrders::create([
                    'name' => Input::get('name'),
                    'currency' => Input::get('currency'),
                    'billrate' => $billrate,
                    'am_billRate' => $am_billRate,
                    'vendor_billRate' => $vendor_billRate,
                    'level' => Input::get('level'),
                    'salaryType' => $salaryType,
                    'experience' => Input::get('experience'),
                    'experience_to' => Input::get('experience_to'),
                    'vacancies' => Input::get('vacancies'),
                    'educationLevel' => '',
                    'language_id' => '',
                    'industry_id' => 0,
                    'deadline' => Input::get('deadline'),
                    'job_type_id' => Input::get('job_type_id'),
                    'user_id' => $authId,
                    'requirement_id' => 1,
                    'status' => 7,
                    'gdprmandatory' => 1,
                    'job_internal_code' => Input::get('internalCode'),
                    'description' => Input::get('description'),
                    'skills_preferred' => Input::get('preferredSkills'),
                    'skills_required' => Input::get('requiredSkills'),
                    'is_private' => Input::get('is_private'),
                    'joborder_number' => '',
                    'min_contract_term' => Input::get('min_contract_term'),
                    'max_contract_term' => Input::get('max_contract_term'),
                    'contract_term_type' => Input::get('contract_term_type'),
                    'expectedjoingdate' => date('Y-m-d',strtotime(Input::get('expectedjoingdate'))),
                    'is_talentpool' => Input::get('is_talentpool'),
                    'payment_mode' => Input::get('paymentMode'),
                    'payment_terms' => Input::get('paymentTerms')
                ]);
            }           
            //Activate a job
            if(Input::get('flag') == 1){
                $joborderData = ['status' => 3,];
                $actiavteJob = JobOrders::where('id', '=', intval($JobOrders->id))->update($joborderData);
            }
            $langIds = Input::get('languageId');
            if(count($langIds)){
                foreach ($langIds as $value) {
                    JobLanguage::create([
                        'language_id'=>$value['id'],
                        'job_id' => $JobOrders->id,
                    ]);
                }
            }
            $prefSkills=Input::get('preferredSkillsGraph');
            $reqSkills=Input::get('requiredSkillsGraph');
            if(count($prefSkills)) {
                foreach ($prefSkills as $value) {
                    JobSkills::create([
                        'skill_name'=>$value['text'],
                        'skill_percentage'=>$value['percentage'],
                        'skill_nooftimes'=>$value['noOfTimes'],
                        'is_requiredskill'=>0,
                        'job_id' => $JobOrders->id,
                    ]);
                }
            }  
            if(count($reqSkills)) {
                foreach ($reqSkills as $value) {
                    JobSkills::create([
                        'skill_name'=>$value['text'],
                        'skill_percentage'=>$value['percentage'],
                        'skill_nooftimes'=>$value['noOfTimes'],
                        'is_requiredskill'=>1,
                        'job_id' => $JobOrders->id,
                    ]);
                }
            }            
            $cityIds = Input::get('cityPin');
            if(count($cityIds)){
                foreach ($cityIds as $value) {
                    JobCitys::create([
                        'city_id'=>$value['id'],
                        'city_name'=>$value['name'],
                        'job_id' => $JobOrders->id,
                    ]);
                }
            }
            $eduQual = Input::get('educationLevel');
            if(count($eduQual)){
                foreach ($eduQual as $qual) {
                    $id = isset($qual['id']) ? $qual['id'] : '';
                    if($id) {
                        EducationAssociations::create(['qualification_id'=>$qual['id'],'job_id' => $JobOrders->id]);
                    } else {
                        $newedu = EducationQualification::create(['qualification'=>$qual['name']]);
                        EducationAssociations::create(['qualification_id'=>$newedu->id,'job_id' => $JobOrders->id]);
                    }
                }
            }
            $company = Company::where('id',$authuser->company_id)->get();
            $city = City::where('id',$company[0]->city_id)->get();
            $country = Country::where('id',$city[0]->country_id)->get();
            $jobNumber = $country[0]->country_code.'-'.$authId.'-'.Input::get('internalCode').'-'.$JobOrders->id;

            $jobOrder = JobOrders::find($JobOrders->id);
            $jobOrder->joborder_number = $jobNumber;
            if( Input::get('industry') == 0 ) {
                $newindustry=Industry::create(['name'=> Input::get('custom_industry_name')]);
                $jobOrder->industry_id = $newindustry->id;
            } else {$jobOrder->industry_id=Input::get('industry');}
            $jobOrder->save();
            $jobOrderNumberResponse=response()->success(compact('jobOrder'));
            $amassociation = Association::where('employer_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('job_id')
                                ->whereNull('candidate_id')
                                ->first();
            $jobassociation = new Association();
            $jobassociation->admin_id = 1;
            $jobassociation->accountmanager_id = $amassociation->accountmanager_id;
            $jobassociation->employer_id = $authId;
            $jobassociation->job_id = $JobOrders->id;
            $jobassociation->status_updated_by = $authId;
            $jobassociation->save();
            if(Input::get('flag') == 1)
            {
                //Revenue calculation START
                $job_id = $JobOrders->id;
                $job = JobOrders::where('id', '=', intval($job_id))->with('JobCitys')->with('JobType')->with('Industry')->get();
                $contract = $job[0]->JobType->name;
                $country = Country::where('id',intval(Input::get('countryId')))->first();
                $countryId = $country->id;
                if(! ( $countryId == 1 || $countryId == 3 || ( $countryId >= 25 && $countryId <= 50)) )
                {$countryId = Country::where('id',2)->first()->id;}
                //Check whether the revised price is not empty. 
                $checkRevised = Pricing::where('emp_id', JobOrders::where('id',$job_id)->first()->user_id)
                                ->whereNotNull('revised_price')
                                ->count();
                $monthlyPay = $job[0]->salary_min;
                $price = array();
                $timeLimit = array();
                if($checkRevised) {
                    $price = Pricing::where('emp_id', JobOrders::where('id',$job_id)->first()->user_id)
                                ->where('type_of_emp',$contract)
                                ->where(function ($query)  use($monthlyPay) {
                                        $query->where('ending_range', '>=' ,$monthlyPay)
                                        ->orWhereNull('ending_range');
                                })
                                ->whereNotNull('revised_price')
                                ->with('country')
                                ->first();
                  
                    $revenue = VendorRevenueRule::where('country_id',$countryId)
                                ->whereNotNull('time_limit')
                                ->orderBy('time_limit', 'ASC')
                                ->with('country')
                                ->get();
                                
                        $contractMonthlyPay = $monthlyPay / 12;
                       // print_r($monthlyPay);exit;
                        foreach ($revenue as $key => $value) {
                            if($job[0]->job_type_id != 2) { // If permanent
                                if($price->price_type=='percentage'){
                                    $priceShare = ($price->revised_price * $monthlyPay)/100;
                                    $price[$key] = ( (100-$value->price) * $priceShare)/100;
                                    $timeLimit[$key] = $value->time_limit;
                                } else {
                                    $price[$key]=round(((100-$value->price)*$price->revised_price)/100, 0);
                                    $timeLimit[$key] = $value->time_limit;
                                } 
                            } else if($job[0]->job_type_id == 2) { // If contract to hire
                                if($price->price_type=='percentage'){
                                    $priceShare = ($price->revised_price * $contractMonthlyPay)/100;
                                    $price[$key] = $contractMonthlyPay - $priceShare;
                                    $timeLimit[$key] = $value->time_limit;
                                } else {
                                    $price[$key]=$contractMonthlyPay - $price->revised_price;
                                    $timeLimit[$key] = $value->time_limit;
                                } 
                            }// if ($job[0]->job_type_id != 2)
                        }// foreach
                } 
                else {
                    if($job[0]->job_type_id == 2) {
                        $price = Pricing::where('country_id',$countryId)
                                    ->where('type_of_emp',$contract)
                                    ->with('country')
                                    ->first();    
                    } else {

                        $price = Pricing::where('country_id',$countryId)
                                ->where('type_of_emp',$contract)
                                ->where(function ($query)  use($monthlyPay) {
                                        $query->where('ending_range', '>=' ,$monthlyPay)
                                        ->orWhereNull('ending_range');
                                })
                                ->with('country')
                                ->first();
                    }                                  
                    $revenue = VendorRevenueRule::where('country_id',$countryId)
                                ->whereNotNull('time_limit')
                                ->orderBy('time_limit', 'ASC')
                                ->with('country')
                                ->get();

                        $priceShare = ($price->price * $monthlyPay)/100;
                        $contractMonthlyPay = $monthlyPay / 12;
                        foreach ($revenue as $key => $value) {
                            if($job[0]->job_type_id != 2) { // If permanent
                                $price[$key] = ( (100-$value->price) * $priceShare)/100;
                                $timeLimit[$key] = $value->time_limit;
                            } else if($job[0]->job_type_id == 2) { // If contract to hire
                                $hxShare = ($price->price * $contractMonthlyPay)/100;
                                $price[$key] = $contractMonthlyPay - $hxShare;
                                $timeLimit[$key] = $value->time_limit;
                            }
                        }//foreach
                } // else
                $vendorrevenue = new VendorRevenue();
                $vendorrevenue->job_id = (int) $job_id;
                $vendorrevenue->vendor_id = null;
                $vendorrevenue->default_revenue = 0;
                $vendorrevenue->est_revenue_1 = $price[0];
                $vendorrevenue->est_revenue_2 = $price[1];
                $vendorrevenue->est_revenue_3 = $price[2];
                $vendorrevenue->est_revenue_4 = $price[3];
                $vendorrevenue->est_revenue_5 = $price[4];
                $vendorrevenue->save();
                //Revenu calculation END  
                $jobactivity = new Activity();
                $jobactivity->name = "Job Created & Activated";
                $jobactivity->admin_id = 1;
                $jobactivity->accountmanager_id = $amassociation->accountmanager_id;
                $jobactivity->employer_id = $authId;
                $jobactivity->job_id = $JobOrders->id;
                $jobactivity->activity_by = $authId;
                $jobactivity->save();
                if($authuser->parent_id){
                    $jobactivity = new Activity();
                    $jobactivity->name = "Job Created & Activated";
                    $jobactivity->admin_id = 1;
                    $jobactivity->accountmanager_id = $amassociation->accountmanager_id;
                    $jobactivity->employer_id = $authId;
                    $jobactivity->employer_user_id = $authuser->id;
                    $jobactivity->job_id = $JobOrders->id;
                    $jobactivity->activity_by = $authuser->id;
                    $jobactivity->save();

                    $empuserjobactivity = new EmployerUserJobs();
                    $empuserjobactivity->employer_id = $authId;
                    $empuserjobactivity->employer_user_id = $authuser->id;
                    $empuserjobactivity->job_id = $JobOrders->id;
                    $empuserjobactivity->save();
                }
                //Email and SMS send functionality for job activation
                $amassociation = Association::where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->where('job_id', intval($JobOrders->id))
                            ->whereNull('vendor_id')
                            ->with('accountmanager')
                            ->get();
                $hrs =date('H');
                $msg = "";
                //if (hrs >  0) msg = "Mornin' Sunshine!"; // REALLY early
                if ($hrs >  0) $msg = "Good morning";      // After 6am
                if ($hrs > 12) $msg = "Good afternoon";    // After 12pm
                if ($hrs > 17) $msg = "Good evening";      // After 5pm
                if ($hrs > 23) $msg = "Go to bed!";        // After 10pm
                foreach ($job[0]['JobCitys'] as $key => $value) {
                    if(!empty($cities)) {$cities=$cities.', '.$value['city_name'];    }
                    else { $cities=$value['city_name'];  }
                  } 
                $country = Country::where('is_enabled',1)->first();
                $number = $amassociation[0]->accountmanager->mobile;
                $countryCode = $country->ISD_code;
                $ch = curl_init();
                $user="kv@hirextra.com";
                $password="Kumar786%";
                $receipientno = $countryCode.$number; 
                $originator = "HRXTRA";
                $msgtxt="Hello ".$amassociation[0]->accountmanager->first_name." your employer ".$employerName. " posted a new job ".$job[0]->name. " please check your dashboard for complete details.";
                
                curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                $buffer = curl_exec($ch);
                $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
            } //Input::get('flag') == 1
            $JobOrders =$JobOrders->id;
            $amId = Association::where('employer_id',$authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->whereNull('employer_user_id')
                        ->get();

        $jobactivity = new Activity();
        $jobactivity->name = "Assigned Talentpool To Account Manager Automatically";
        $jobactivity->admin_id = 1;
        $jobactivity->accountmanager_id = $amId[0]['accountmanager_id'];
        $jobactivity->employer_id =$authId;
        $jobactivity->job_id = $JobOrders;
        $jobactivity->activity_by = $amId[0]['accountmanager_id'];
        $jobactivity->save();
        //print_r($amId[0]['accountmanager_id']);
            return response()->success(compact('JobOrders'));
        } else { return response()->error("There is an existing Talentpool with same Internal Job Code.");}
    }
      public function getJoborderShow($id)
    {
        $authuser=Auth::user();
        $authId=null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        $associationcount=Association::where('job_id',$id)
                            ->where('vendor_id',$authId)
                            ->count();
        if($associationcount >= 1) {
            $joborders = JobOrders::with('status')->with('JobType')->with('JobCitys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('Industry')->find($id);
            $joborders['new_updated_at'] = $joborders->updated_at;
            $joborders['current_time'] = Carbon::now();
            
            $acceptedJob = Association::where('job_id',$id)
                                                ->where('vendor_id',$authId)
                                                ->where('job_status', 3)
                                                ->count();
            $closedjobProfileCount=(int) Association::where('job_id', $id)
                                    ->whereIn('candidate_status', array(27, 28))
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNotNull('candidate_id')
                                    ->count();
            $positions=(int) JobOrders::where('id', $id)->first()->vacancies;
            $joborders['checkifposclosed']=($positions == $closedjobProfileCount) ? 0 : 1 ;
            $joborders['positions_closed']=$closedjobProfileCount;
            $joborders['ifJobaccepted'] = $acceptedJob;

            $employer_id = JobOrders::where('id',$id)->first()->user_id;
             $accountmanager_id = Association::where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->where('employer_id',$employer_id)
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_user_id')
                                ->where('job_id',$id)
                                ->whereNull('candidate_id')
                                ->first()->accountmanager_id;
     
            $joborders['countResumes']= association::where('vendor_id',$authId)
                                ->where('accountmanager_id',$accountmanager_id)
                                ->where('employer_id',$employer_id)
                                ->where('job_id',$id)
                                ->whereNotNull('candidate_id')
                                ->count();  
            } 
            else { $joborders ="No data Found"; }
     return response()->success($joborders);
    }
  
    public function getTalentpoolreqdata($id)
    {
        $authuser=Auth::user();
        $talentpoolreqdata=TalentpoolRequests::where('job_id',$id)
                            ->where('vendor_id',$authuser->id)
                            ->get();
        return response()->success($talentpoolreqdata);
    }
     public function getEmpinterschedule()
    {
        $authuser = Auth::user();
        if($authuser->parent_id) {
            $empinterschedule = Association::where('employer_id',$authuser->parent_id)
                                            ->whereIn('candidate_status',[18,17,20,21,22,23])
                                            ->whereNotNull('interview_schedule_date')
                                            ->where('interview_schedule_date','!=',"")
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->whereNotNull('candidate_status')
                                            ->with(array('job','candidate','status'))
                                            ->whereHas('job',function($query){
                                              $query->where('is_talentpool','=',1);
                                              })
                                            ->get();
        } else {
            $empinterschedule = Association::where('employer_id',$authuser->id)
                                            ->whereIn('candidate_status',[18,17,20,21,22,23])
                                            ->whereNotNull('interview_schedule_date')
                                            ->where('interview_schedule_date','!=',"")
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->whereNotNull('candidate_status')              
                                            ->with(array('job','candidate','status'))
                                            ->whereHas('job',function($query){
                                              $query->where('is_talentpool','=',1);
                                              })
                                            ->get();
        }
        foreach($empinterschedule as $assoc) {
            $splitDate = explode(" ", $assoc['interview_schedule_date']);
            $startTime = null;
            $endDate = null;
            $rescheduleCheck = Activity::where('employer_id',intval($assoc['employer_id']))
                    ->where('vendor_id',intval($assoc['vendor_id']))
                    ->where('accountmanager_id',intval($assoc['accountmanager_id']))
                    ->where('candidate_id',intval($assoc['candidate_id']))
                    ->where('candidate_status',intval($assoc['candidate_status']))
                    ->where('job_id',intval($assoc['job_id']))
                    ->where('is_vendor_sourcing_activity',0)
                    ->whereNotNull('name')                    
                    ->whereNull('employer_user_id')
                    ->whereNull('vendor_user_id')
                    ->get();
            if(count($rescheduleCheck) > 1){ $assoc['swal_title'] = "Interview Rescheduled!"; }
            else { $assoc['swal_title'] = "Interview Scheduled!" ;}            
            $candidate_name = $assoc['candidate']['full_name'];
            $job_name = $assoc['job']['name'];
            $status = $assoc['status']['name'];
            $assoc['title'] = "\"". $candidate_name . "\" profile from job \"". $job_name . "\" has been " . $status . " at " . $assoc['interview_schedule_date'];
            $assoc['popup_message'] = "<b>'". $candidate_name . "'</b> profile for job <b>'". $job_name . "'</b> has been shortlisted for <b class='lower-case'>" . trim( substr( $status, strpos( $status, ' ', strpos( $status, ' ' ) + 1 ) ) ) . " </b> on <span class='popupDate'>". $splitDate[0] ."</span> at <span class='popupDate'>" .$splitDate[1]." ". $splitDate[2] . "</span>";
            $assoc['startTime'] = $startTime;
            $assoc['endTime'] = $endDate;
            $assoc['allDay'] = false;
        }
        return response()->success(compact('empinterschedule'));
    }
     public function getEmpmetricsno()
    {
        $authuser = Auth::user();
        $authId = null;
        $empjobids = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                        ->where('employer_user_id',$authuser->id)
                        ->lists('job_id');
            $jobsclosed=JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)->where('status',6)->where('user_id',$authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->get();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}

            $jobsclosed=JobOrders::where('status',6)->where('user_id',$authId)->where('is_talentpool',1)->count();
        }
        
        $amId = Association::where('employer_id',$authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('employer_id') 
                        ->get();

        $activityes = Activity::where('activity_by',$amId[0]['accountmanager_id'])->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();

        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);    
        } 

        if($authuser->parent_id){
            $jobspending = JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',4)
                                    ->count();
            $jobsinprogress = JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',8)
                                    ->count();
            $jobsinactive = JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',7)
                                    ->count();
            $jobsaccepted = JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',3)
                                    ->count();
            $jobsclosed = JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',6)
                                    ->count();                                   
            $profiles_received=Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                     ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                                $query->where('is_talentpool','=',1);
                                            })
                                    ->count();
            $profiles_rejected = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_srt_phone = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_srt_f2f = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_srt_final = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_interview = Association::whereIn('job_id',$empjobs)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_directinterview = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_skype = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();
            $profiles_walkin = Association::whereIn('job_id',$empjobs)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                      })->count();                               

            $profiles_selected=Association::whereIn('job_id',$empjobs)
                                ->whereIn('candidate_status',[27,28])
                                ->where('employer_id',$authId)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('job_id')
                                ->whereHas('job',function($query){
                                        $query->where('is_talentpool','=',1);
                                      })->count(); 
        } else {
            $jobspending=JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)
                                    ->where('status',4)
                                    ->count();
            $jobsinprogress = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)
                                    ->where('status',8)
                                    ->count();
            $jobsinactive = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)
                                    ->where('status',7)
                                    ->count();
            $jobsaccepted=JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)
                                    ->where('status',3)
                                    ->count();
            $jobsclosed=JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)
                                    ->where('status',6)
                                    ->count();                                   
            $profiles_received=Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                    ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                                $query->where('is_talentpool','=',1);
                                            })
                                    ->count(); 
            $profiles_rejected = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count(); 

            $profiles_srt_phone = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();
            $profiles_srt_f2f = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();
            $profiles_srt_final = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();                                
            $profiles_interview = Association::whereIn('job_id',$empjobids)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();
            $profiles_directinterview = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();
            $profiles_skype = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();                                               
            $profiles_walkin = Association::whereIn('job_id',$empjobids)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();                             
     
            $profiles_selected=Association::whereIn('job_id',$empjobids)
                                ->whereIn('candidate_status',[27,28])
                                ->where('employer_id',$authId)
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('job_id')
                                ->whereHas('job',function($query){
                                                $query->where('is_talentpool','=',1);
                                            })->count();                                        
        }

        $jobsrejected=JobOrders::where('user_id',$authId)->where('is_talentpool',1)
                                ->where('status',2)
                                ->with('status')
                                ->with('JobType')
                                ->with('Industry')
                                ->count();

        $vendorassignedholdjobs=JobOrders::where('user_id',$authId)->where('is_talentpool',1)
                                ->where('status',24)
                                ->count();

        $empmetricsno[]=array('jobs_submitted'=>count($empjobs), 'inprogress_jobs' => $jobsinprogress, 'inactive_jobs' => $jobsinactive, 'pending_jobs' => $jobspending, 'accepted_jobs' => $jobsaccepted,'rejected_jobs'=>$jobsrejected, 'closed_jobs'=>$jobsclosed, 'jobs_held'=> $vendorassignedholdjobs, 'profiles_interview'=>$profiles_interview, 'profiles_rejected'=>$profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_received' => $profiles_received, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected);

        return response()->success(compact('empmetricsno'));
    }
       public function getEmpmetrics($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $empjobids = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empjobs = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                        ->where('employer_user_id',$authuser->id)
                        ->lists('job_id');
            $jobsclosed=JobOrders::whereIn('id',$empjobs)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',6)->where('user_id',$authId)->count();
        } else {
            $authId = $authuser->id;
            $empjobs = JobOrders::where('user_id',$authId)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->get();
            foreach($empjobs as $job){array_push($empjobids, $job->id);}

            $jobsclosed=JobOrders::where('status',6)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authId)->count();
        }
        
        $amId = Association::where('employer_id',$authId)
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('employer_id') 
                        ->get();

        $activityes = Activity::where('activity_by',$amId[0]['accountmanager_id'])->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();

        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);    
        } 

        if($authuser->parent_id){
            $jobspending = JobOrders::whereIn('id',$empjobs)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',4)
                                    ->count();
            $jobsinprogress = JobOrders::whereIn('id',$empjobs)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',8)
                                    ->count();
            $jobsinactive = JobOrders::whereIn('id',$empjobs)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',7)
                                    ->count();
            $jobsaccepted = JobOrders::whereIn('id',$empjobs)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',3)
                                    ->count();
            $jobsclosed = JobOrders::whereIn('id',$empjobs)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('user_id',$authuser->parent_id)
                                    ->where('status',6)
                                    ->count();                                   
            $profiles_received=Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                     ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                            })
                                    ->count();
            $profiles_rejected = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_srt_phone = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_srt_f2f = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_srt_final = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_interview = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_directinterview = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_skype = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_walkin = Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();                                

            $profiles_selected=Association::whereIn('job_id',$empjobs)->where('created_at','>=',$diff_date)
                                ->whereIn('candidate_status',[27,28])
                                ->where('employer_id',$authId)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('job_id')
                                ->count(); 
        } else {
            $jobspending=JobOrders::where('user_id',$authuser->id)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('status',4)
                                    ->count();
            $jobsinprogress = JobOrders::where('user_id',$authuser->id)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('status',8)
                                    ->count();
            $jobsinactive = JobOrders::where('user_id',$authuser->id)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('status',7)
                                    ->count();
            $jobsaccepted=JobOrders::where('user_id',$authuser->id)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('status',3)
                                    ->count();
            $jobsclosed=JobOrders::where('user_id',$authuser->id)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                    ->where('status',6)
                                    ->count();                                   
            $profiles_received=Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->with('job.status')
                                    ->whereHas('job',function($query){
                                                $query->where('status','=',3);
                                            })
                                    ->count(); 
            $profiles_rejected = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereIn('candidate_status',[2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();    
            $profiles_srt_phone = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_srt_f2f = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_srt_final = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();                                
            $profiles_interview = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->whereNotIn('candidate_status',[19,7,2,1])
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
            $profiles_directinterview = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count(); 
            $profiles_skype = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();                                                         
            $profiles_walkin = Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                    ->whereNotIn('candidate_id',$activityData)
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('candidate_status')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();                                       
     
            $profiles_selected=Association::whereIn('job_id',$empjobids)->where('created_at','>=',$diff_date)
                                ->whereIn('candidate_status',[27,28])
                                ->where('employer_id',$authId)
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('job_id')
                                ->count();                                         
        }

        $jobsrejected=JobOrders::where('user_id',$authId)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                ->where('status',2)
                                ->with('status')
                                ->with('JobType')
                                ->with('Industry')
                                ->count();

        $vendorassignedholdjobs=JobOrders::where('user_id',$authId)->where('created_at','>=',$diff_date)->where('is_talentpool',1)
                                ->where('status',24)
                                ->count();

        $empmetrics[]=array('jobs_submitted'=>count($empjobs), 'inprogress_jobs' => $jobsinprogress, 'inactive_jobs' => $jobsinactive, 'pending_jobs' => $jobspending, 'accepted_jobs' => $jobsaccepted,'rejected_jobs'=>$jobsrejected, 'closed_jobs'=>$jobsclosed, 'jobs_held'=> $vendorassignedholdjobs, 'profiles_interview'=>$profiles_interview, 'profiles_rejected'=>$profiles_rejected, 'profiles_srt_phone' => $profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_received' => $profiles_received, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected);

        return response()->success(compact('empmetrics'));
    }
     public function getEmployerjobsfirst($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id) {
            $authId=null;
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                                ->where('employer_user_id',$authuser->id)
                                ->lists('job_id');
                               
            $employerjobsfirst = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($employerjobsfirst as $job) {

                $amIdData = Association::where('job_id',$job['id'])
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('candidate_id')
                                ->whereNull('vendor_id')
                                ->get(['accountmanager_id']);

                if(count($amIdData) >=1) {
                    $amId = Association::where('job_id',$job['id'])
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('candidate_id')
                                        ->whereNull('vendor_id')
                                        ->first()->accountmanager_id;
                
                    $candidates = Association::where('job_id',$job['id'])
                                        ->where('candidate_status', '<>', 19)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNull('vendor_user_id')
                                        ->with(array('Status','Candidate'))
                                        ->get();

                    $associationsIds = array();
                    foreach($candidates as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        } 
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $activityes = Activity::where('activity_by',$amId)->where('job_id',$job['id'])->whereIn('candidate_status',array(1,2))->get();
                    $activityData = array();
                    foreach($activityes as $activityesdata) {
                    array_push($activityData, $activityesdata->candidate_id);    
                    }
                    $assingedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $rejectedids = Association::where('job_id',$job['id'])
                                    ->whereIn('candidate_status',array(1, 2, 30))
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->get();

                    $associationsIds = array();
                    foreach($rejectedids as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $shortlistedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->count();
                    $selectedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',[27, 28])
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->count();
                    $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                    $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                    $numbers = ['profilesReceived'=>$assingedcandidates,'rejectedProfiles'=>$rejectedcandidates, 'shortlistedProfiles'=>$shortlistedcandidates,'offeredProfiles'=>$offeredProfiles,'interviwedProfiles'=>$interviwedProfiles,'selectedcandidates'=>$selectedcandidates, 'encrypted_jobId'=>$encrypted];
                    $job['numbers'] = $numbers;
                }
                else 
                {
                     $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived'=>0,'rejectedProfiles'=>0, 'shortlistedProfiles'=>0,'offeredProfiles'=>0, 'holdProfiles'=>0,'interviwedProfiles'=>0, 'encrypted_jobId'=>$encrypted];
                    $job['numbers'] = $numbers; 
                }
            }//foreach

        } else {  
            $employerjobsfirst = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($employerjobsfirst as $job) {
                $amIdData = Association::where('job_id',$job['id'])
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('candidate_id')
                                ->whereNull('vendor_id')
                                ->get(['accountmanager_id']);
                if(count($amIdData) >=1)
                {
                    $amId = Association::where('job_id',$job['id'])
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('candidate_id')
                                        ->whereNull('vendor_id')
                                        ->first()->accountmanager_id;
                
                    $candidates = Association::where('job_id',$job['id'])
                                        ->where('candidate_status', '<>', 19)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNull('vendor_user_id')
                                        ->with(array('Status','Candidate'))
                                        ->get();

                    $associationsIds = array();
                    foreach($candidates as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        } 
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $activityes = Activity::where('activity_by',$amId)->where('job_id',$job['id'])->whereIn('candidate_status',array(1,2))->get();
                    $activityData = array();
                    foreach($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);    
                    }
                    $assingedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $rejectedids = Association::where('job_id',$job['id'])
                                    ->whereIn('candidate_status',array(1, 2, 30))
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->get();

                    $associationsIds = array();
                    foreach($rejectedids as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->count();

                    $shortlistedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $selectedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',[27, 28])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $offeredProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$authuser->id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(27,28))
                                        ->count();
                    $interviwedProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$authuser->id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                        ->count();
                                   
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                    $numbers = ['profilesReceived'=>$assingedcandidates,'rejectedProfiles'=>$rejectedcandidates, 'shortlistedProfiles'=>$shortlistedcandidates,'selectedcandidates'=>$selectedcandidates, 'encrypted_jobId'=>$encrypted,'offeredProfiles'=>$offeredProfiles,'interviwedProfiles'=>$interviwedProfiles];
                    $job['numbers'] = $numbers;
                }
                else
                {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived'=>0,'rejectedProfiles'=>0, 'shortlistedProfiles'=>0,'offeredProfiles'=>0, 'holdProfiles'=>0,'interviwedProfiles'=>0, 'encrypted_jobId'=>$encrypted];
                        $job['numbers'] = $numbers; 
                }
            } // foreach
        } //else
       
        return response()->success(compact('employerjobsfirst'));
    }
    public function getFilterjobsinactive ($count) {
        $authuser = Auth::user();
        $authId = null;
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id){
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');

            $filterjobsinactive = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authuser->parent_id)->where('status',7)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobsinactive as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }
        }else {
            $filterjobsinactive = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',7)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobsinactive as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsinactive'));
    }

    public function getFilterjobsaccepted($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id){
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');

            $filterjobsaccepted = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authuser->parent_id)->where('status',3)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobsaccepted as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }else {
            $filterjobsaccepted = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',3)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobsaccepted as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count(); 
            $shorlistedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();                                                        
            $offeredProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count(); 

            $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
            $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsaccepted'));
    }

    public function getFilterjobspending ($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');

        if($authuser->parent_id) {
            $empActIds=EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $filterjobspending = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authuser->parent_id)->where('status',4)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobspending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count(); 
            $shorlistedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();                                                        
            $offeredProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count(); 

            $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
            $job['numbers'] = $numbers;



            }
            /*    $numbers = ['encrypted_jobId'=>$encrypted];
                $job['numbers'] = $numbers;
            }*/
        } else {
            $filterjobspending = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',4)->with('status')->with('JobType')->with('Industry')->get();

            foreach ($filterjobspending as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count(); 
            $shorlistedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();                                                        
            $offeredProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count(); 

            $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
            $job['numbers'] = $numbers;

            }

        }
        return response()->success(compact('filterjobspending'));
    }

    public function getFilterjobsclosed ($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id) {
            $empActIds=EmployerUserJobs::where('employer_id', $authuser->parent_id)
                            ->where('employer_user_id', $authuser->id)
                            ->lists('job_id');
            $filterjobsclosed = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authuser->parent_id)->where('status',6)->with('status')->with('JobType')->with('Industry')->get();                            
        } else {
            $filterjobsclosed = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',6)->with('status')->with('JobType')->with('Industry')->get();    
        }
            foreach ($filterjobsclosed as $job) {

                $commentData=Activity::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->where('job_status',6)
                                    ->where('activity_by',$authuser->id)
                                    ->get(['note']);
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles,'commentData'=>$commentData];
                $job['numbers'] = $numbers;
            }//foreach
        return response()->success(compact('filterjobsclosed'));
    }
    public function getEmployerholdjobs($count)
    {
        $authuser = Auth::user();
        $authId = null;
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $emp_user_job_ids = $jobids = array();
            foreach ($empActIds as $job) { array_push($emp_user_job_ids, $job); }
            $employerholdjobs = Association::whereIn('job_id',$emp_user_job_ids)->where('created_at','>=',$diff_date)
                                    ->whereNotNull('employer_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('candidate_id')
                                    ->with('job.JobType','job.status','job_id')
                                    ->whereHas('job',function($query){
                                        $query->where('status','=',24);
                                    })
                                    ->get();
            foreach ($employerholdjobs as $job) { array_push($jobids, $job->job_id); }
                $employerholdjobs=JobOrders::whereIn('id',$jobids)->where('is_talentpool',1)->where('created_at','>=',$diff_date)
                                                 ->where('status',24)
                                                 ->with(array('JobType','company','Industry','status'))
                                                 ->get();
                foreach ($employerholdjobs as $job) {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $receivedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } else {
            $jobids = array();
            $employerholdjobs = Association::whereNotNull('job_id')->where('created_at','>=',$diff_date)
                                ->where('employer_id',$authuser->id)
                                ->whereNull('vendor_user_id')
                                ->whereNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('candidate_id')
                                ->with('job.JobType','job.status')
                                ->whereHas('job',function($query){
                                    $query->where('status','=',24);
                                })
                                ->get();
            foreach ($employerholdjobs as $job) { array_push($jobids, $job->job_id); }
            $employerholdjobs=JobOrders::whereIn('id',$jobids)
                                        ->where('created_at','>=',$diff_date)
                                        ->where('is_talentpool',1)
                                        ->where('status',24)
                                        ->with(array('JobType','company','Industry','status'))
                                        ->get();
            foreach ($employerholdjobs as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        } // else
         return response()->success(compact('employerholdjobs'));
    }

    public function getJobsrejectedbyempam($count)            
    {                       
        $authuser = Auth::user();
        $authId = null;
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        if($authuser->parent_id) {
            $authId=$authuser->parent_id;
            $empActIds=EmployerUserJobs::where('employer_id',$authuser->parent_id)
                                            ->where('employer_user_id',$authuser->id)
                                            ->lists('job_id');
            $emp_usr_ids=array();
            foreach($empActIds as $job){ array_push($emp_usr_ids, $job); }                                     
            $jobsrejectedbyempam=JobOrders::whereIn('id',$emp_usr_ids)
                                            ->where('is_talentpool',1)
                                            ->where('created_at','>=',$diff_date)
                                            ->where('user_id',$authId)
                                            ->where('status',2)
                                            ->with('status')
                                            ->with('JobType')
                                            ->with('Industry')
                                            ->get();

            foreach ($jobsrejectedbyempam as $job)             
            {    
                $accountmanager_id=Association::where('employer_id',JobOrders::where('id',intval($job['id']))->first()->user_id)                                        
                                    ->whereNotNull('accountmanager_id')
                                    ->where('job_id',intval($job['id']))        
                                    ->whereNull('candidate_id')        
                                    ->first()->accountmanager_id;

                $commentData=Activity::where('job_id',$job['id'])
                                    ->where('admin_id',1)                                    
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('employer_id',JobOrders::where('id',intval($job['id']))->first()->user_id)
                                    ->where('activity_by',$accountmanager_id)
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->whereNotNull('comment')
                                    ->whereNotNull('name')                                    
                                    ->whereNull('vendor_id')                                    
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')         
                                    ->whereNull('job_status')           
                                    ->whereNull('candidate_id')             
                                    ->whereNull('candidate_status')         
                                    ->whereNull('note')                                    
                                    ->whereNull('reason_id')                                    
                                    ->whereNull('status_id')                                    
                                    ->whereNull('resume_id')                                    
                                    ->whereNull('requirement_id')         
                                    ->whereNull('company_id')           
                                    ->whereNull('vendor_checklist_id')
                                    ->first()->comment; 

                $note_data = ['note'=>$commentData];                                    
                $job['note'] = $note_data; 

                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach   

        } else {    
            $jobsrejectedbyempam = JobOrders::where('user_id',$authuser->id)
                                            ->where('is_talentpool',1)
                                            ->where('created_at','>=',$diff_date)
                                            ->where('status',2)
                                            ->with('status')
                                            ->with('JobType')
                                            ->with('Industry')
                                            ->get();
            foreach ($jobsrejectedbyempam as $job)             
            {    
                $accountmanager_id=Association::where('employer_id',JobOrders::where('id',intval($job['id']))->first()->user_id)
                                    ->whereNotNull('accountmanager_id')
                                    ->where('job_id',intval($job['id']))        
                                    ->whereNull('candidate_id')        
                                    ->first()->accountmanager_id;

                $commentData=Activity::where('job_id',$job['id'])
                                    ->where('admin_id',1)                                    
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('employer_id',JobOrders::where('id',intval($job['id']))->first()->user_id)                                    
                                    ->where('activity_by',$accountmanager_id)
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->whereNotNull('comment')                                    
                                    ->whereNotNull('name')                                    
                                    ->whereNull('vendor_id')                                    
                                    ->whereNull('employer_user_id')         
                                    ->whereNull('vendor_user_id')         
                                    ->whereNull('job_status')                                    
                                    ->whereNull('candidate_id')                                    
                                    ->whereNull('candidate_status')         
                                    ->whereNull('note')                                    
                                    ->whereNull('reason_id')                                    
                                    ->whereNull('status_id')                                    
                                    ->whereNull('resume_id')                                    
                                    ->whereNull('requirement_id')         
                                    ->whereNull('company_id')                                    
                                    ->whereNull('vendor_checklist_id')
                                    ->first()->comment;                    
                $note_data = ['note'=>$commentData];                                    
                $job['note'] = $note_data; 
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $receivedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }//foreach
        } // else 
        return response()->success(compact('jobsrejectedbyempam'));    
    }

    public function getFilterjobsinprogress ($count) {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');

        if($authuser->parent_id) {
            $empActIds=EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');
            $filterjobsinprogress = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('user_id',$authuser->parent_id)->where('status',8)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogress as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
              

            $receivedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count(); 
            $shorlistedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();                                                        
            $offeredProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['id'])
                                ->where('employer_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count(); 

            $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
            $job['numbers'] = $numbers;



            }
        } else {
            $filterjobsinprogress = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->where('created_at','>=',$diff_date)->where('status',8)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($filterjobsinprogress as $job) {
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
               
                $receivedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count(); 
                $shorlistedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(17,26))
                                    ->count();                                                        
                $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                $numbers = ['encrypted_jobId'=>$encrypted,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles];
                $job['numbers'] = $numbers;
            }
        }
        return response()->success(compact('filterjobsinprogress'));
    }

    public function getJobordersdata()
    {
        $authuser = Auth::user();
        if($authuser->parent_id) {
            $authId=null;
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                                ->where('employer_user_id',$authuser->id)
                                ->lists('job_id');
                               
            $jobordersdata = JobOrders::whereIn('id',$empActIds)->where('is_talentpool',1)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($jobordersdata as $job) {

                $amIdData = Association::where('job_id',$job['id'])
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('candidate_id')
                                ->whereNull('vendor_id')
                                ->get(['accountmanager_id']);

                if(count($amIdData) >=1) {
                    $amId = Association::where('job_id',$job['id'])
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('candidate_id')
                                        ->whereNull('vendor_id')
                                        ->first()->accountmanager_id;
                
                    $candidates = Association::where('job_id',$job['id'])
                                        ->where('candidate_status', '<>', 19)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNull('vendor_user_id')
                                        ->with(array('Status','Candidate'))
                                        ->get();

                    $associationsIds = array();
                    foreach($candidates as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        } 
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $activityes = Activity::where('activity_by',$amId)->where('job_id',$job['id'])->whereIn('candidate_status',array(1,2))->get();
                    $activityData = array();
                    foreach($activityes as $activityesdata) {
                    array_push($activityData, $activityesdata->candidate_id);    
                    }
                    $assingedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $rejectedids = Association::where('job_id',$job['id'])
                                    ->whereIn('candidate_status',array(1, 2, 30))
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->get();

                    $associationsIds = array();
                    foreach($rejectedids as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $shortlistedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->count();
                    $selectedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',[27, 28])
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->count();
                    $offeredProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                    $interviwedProfiles=Association::where('job_id',$job['id'])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count(); 

                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                    $numbers = ['profilesReceived'=>$assingedcandidates,'rejectedProfiles'=>$rejectedcandidates, 'shortlistedProfiles'=>$shortlistedcandidates,'offeredProfiles'=>$offeredProfiles,'interviwedProfiles'=>$interviwedProfiles,'selectedcandidates'=>$selectedcandidates, 'encrypted_jobId'=>$encrypted];
                    $job['numbers'] = $numbers;
                }
                else 
                {
                     $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived'=>0,'rejectedProfiles'=>0, 'shortlistedProfiles'=>0,'offeredProfiles'=>0, 'holdProfiles'=>0,'interviwedProfiles'=>0, 'encrypted_jobId'=>$encrypted];
                    $job['numbers'] = $numbers; 
                }
            }//foreach

        } else {  
            $jobordersdata = JobOrders::where('user_id',$authuser->id)->where('is_talentpool',1)->with('status')->with('JobType')->with('Industry')->get();
            foreach ($jobordersdata as $job) {
                $amIdData = Association::where('job_id',$job['id'])
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('candidate_id')
                                ->whereNull('vendor_id')
                                ->get(['accountmanager_id']);
                if(count($amIdData) >=1)
                {
                    $amId = Association::where('job_id',$job['id'])
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('candidate_id')
                                        ->whereNull('vendor_id')
                                        ->first()->accountmanager_id;
                
                    $candidates = Association::where('job_id',$job['id'])
                                        ->where('candidate_status', '<>', 19)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNull('vendor_user_id')
                                        ->with(array('Status','Candidate'))
                                        ->get();

                    $associationsIds = array();
                    foreach($candidates as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        } 
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $activityes = Activity::where('activity_by',$amId)->where('job_id',$job['id'])->whereIn('candidate_status',array(1,2))->get();
                    $activityData = array();
                    foreach($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);    
                    }
                    $assingedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();

                    $rejectedids = Association::where('job_id',$job['id'])
                                    ->whereIn('candidate_status',array(1, 2, 30))
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->get();

                    $associationsIds = array();
                    foreach($rejectedids as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->count();

                    $shortlistedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $selectedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',[27, 28])
                                    ->where('employer_id',$authuser->id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $offeredProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$authuser->id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(27,28))
                                        ->count();
                    $interviwedProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$authuser->id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                        ->count();
                                   
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                    $numbers = ['profilesReceived'=>$assingedcandidates,'rejectedProfiles'=>$rejectedcandidates, 'shortlistedProfiles'=>$shortlistedcandidates,'selectedcandidates'=>$selectedcandidates, 'encrypted_jobId'=>$encrypted,'offeredProfiles'=>$offeredProfiles,'interviwedProfiles'=>$interviwedProfiles];
                    $job['numbers'] = $numbers;
                }
                else
                {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['profilesReceived'=>0,'rejectedProfiles'=>0, 'shortlistedProfiles'=>0,'offeredProfiles'=>0, 'holdProfiles'=>0,'interviwedProfiles'=>0, 'encrypted_jobId'=>$encrypted];
                        $job['numbers'] = $numbers; 
                }
            } // foreach
        } //else
       
        return response()->success(compact('jobordersdata'));
    }
     public function getAmmetrics($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $associated_emp_Ids = array();
        $associated_emps = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->groupBy('employer_id')
                            ->select('employer_id')
                            ->get();
        foreach($associated_emps as $job) {array_push($associated_emp_Ids, $job->employer_id);}

        $alljobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count();
        $pendingjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                                $query->where('is_talentpool','=',1);
                            })
                             ->count();
        $yet_to_accept = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count(); 
        $in_progress = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count(); 
        $closedJobs = Association::whereNotNull('job_id')->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count();
        $rejected_by_am = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','=',2);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count();
        $rejected_by_vendor = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNull('candidate_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereHas('job',function($query) {
                                $query->where('is_talentpool','=',1);
                            })
                            ->where('job_status',2)
                            ->count();

        $amholdjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',24);
                                $query->where('is_talentpool','=',1);
                            })
                            ->count();  

        $profiles_gdpr=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                                $query->where('is_talentpool','=',1);
                            })
                            ->get();
        $profiles_gdpr_yes=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('gdpr_status',1)
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                                $query->where('is_talentpool','=',1);
                            })
                            ->get();
        $profiles = $profiles_gdpr->merge($profiles_gdpr_yes);
        $pending_profiles=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',19)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })
                            ->groupby('job_id')
                            ->get();
        $profiles_rejected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get(); 
        $profiles_srt_phone=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',17)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get(); 
        $profiles_srt_f2f=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',18)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get(); 
        $profiles_srt_final=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',20)
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get();
        $profiles_interview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->whereNotIn('candidate_status',[19,7,2,1])
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get();
        $profiles_directinterview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',23)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get(); 
        $profiles_skype=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',22)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get(); 

        $profiles_walkin=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',21)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->get();

        $profiles_selected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->whereIn('candidate_status',[27,28])
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                                $query->where('is_talentpool','=',1);
                            })->groupby('job_id')
                            ->count();                            

        $ammetrics[]=array('jobs_submitted'=>$alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor, 'amholdjobs' => $amholdjobs, 'profiles_received'=>$profiles,'profiles_pending'=>count($pending_profiles), 'profiles_rejected'=>$profiles_rejected , 'profiles_srt_phone'=>$profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected,'profiles_interview'=>$profiles_interview);

        return response()->success(compact('ammetrics'));                            
    }
      public function postDeviationrequestsent() 
    {
        $authuser = Auth::user();
        $talentpool_req_id = Input::get('talentpool_req_id');
        $vendor_deviation_rate = Input::get('vendor_deviation_rate');
        $vendor_deviation_note = Input::get('vendor_deviation_note');
        $vendor_deviation_request = Input::get('vendor_deviation_request');


      $accountmanager_id=TalentpoolRequests::where('id',$talentpool_req_id)->where('vendor_id',$authuser->id)->get(['accountmanager_id','job_id','hirextra_margin_rate','vendor_bill_rate','talentpool_id']);
      //print_r($accountmanager_id[0]['job_id']);
      $bill_rates=JobOrders::where('id',$accountmanager_id[0]['job_id'])->get(['billrate']);
    
        $deviation_create = TalentpoolDeviationRequests::create([
            'talentpool_request_id' => $talentpool_req_id,
            'talentpool_id' => $accountmanager_id[0]['talentpool_id'],
            'accountmanager_id' => $accountmanager_id[0]['accountmanager_id'],
            'vendor_id' => $authuser->id,
            'job_id' => $accountmanager_id[0]['job_id'],
            'billrate' => $bill_rates[0]['billrate'],
            'am_billRate' => $accountmanager_id[0]['hirextra_margin_rate'],
            'vendor_billRate' => $accountmanager_id[0]['vendor_bill_rate'],
            'vendor_deviation_rate' => $vendor_deviation_rate,
            'vendor_deviation_request' => $vendor_deviation_request,
            'vendor_deviation_note' => $vendor_deviation_note
        ]);
        $joborderData = ['vendor_deviation_request' => $vendor_deviation_request];
        $actiavteJob1 = TalentpoolRequests::where('id', '=', intval($talentpool_req_id))
                                            ->where('vendor_id',$authuser->id)
                                            ->update($joborderData);
      
        return response()->success("Created success");
    }
     public function getAlldeviationrequests() 
    {
        $authuser = Auth::user();
        $alldeviationrequests = TalentpoolDeviationRequests::where('accountmanager_id',$authuser->id)
                                ->with('job')->with('vendor')->with('vendor.company')
                                ->get();
        foreach ($alldeviationrequests as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('alldeviationrequests'));
    }
    public function getAmtalentpooldiviationrequest($count) 
    {
        $authuser = Auth::user();
        $amtalentpooldiviationrequest = TalentpoolDeviationRequests::where('accountmanager_id',$authuser->id)
                                ->where('id',$count)->with('job')->with('vendor')->with('vendor.company')
                                ->get();
        foreach ($amtalentpooldiviationrequest as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amtalentpooldiviationrequest'));
    }
     public function postAmacceptdeviationrequest() 
    {
        $authuser = Auth::user();
        $job_id = Input::get('job_id');
        $talentpool_req_id = Input::get('talentpool_req_id');
        $talentpool_id = Input::get('talentpool_id');
        $vendor_deviation_rate = Input::get('vendor_deviation_rate');
        //Updating Am Margin Rate
        $am_billRate = Input::get('am_billRate');
        $am_billRate_1 = $am_billRate - $vendor_deviation_rate;
        //Updating Vendor Rate
        $vendor_billRate = Input::get('vendor_billRate');
        $vendor_billRate_1 = $vendor_billRate + $vendor_deviation_rate;

        $vendor_deviation_request = Input::get('vendor_deviation_request');
        $am_deviation_status = Input::get('am_deviation_status');
        $vendor_id = Input::get('vendor_id');

        $joborderData1 = ['am_billRate' => $am_billRate_1, 'vendor_billRate' => $vendor_billRate_1, 'vendor_deviation_rate' => $vendor_deviation_rate, 'vendor_deviation_request' => $vendor_deviation_request, 'am_deviation_status' => $am_deviation_status];
        $actiavteJob1 = TalentpoolDeviationRequests::where('id', '=', intval($talentpool_req_id))
                                            ->where('vendor_id', '=', intval($vendor_id))
                                            ->update($joborderData1);

        $joborderData = ['hirextra_margin_rate' => $am_billRate_1, 'vendor_bill_rate' => $vendor_billRate_1, 'vendor_deviation_request' => $vendor_deviation_request];
        $actiavteJob = TalentpoolRequests::where('job_id', '=', intval($job_id))
                                           ->where('vendor_id', '=', intval($vendor_id))
                                           ->where('talentpool_id', '=', intval($talentpool_id))
                                            ->update($joborderData);

        return response()->success("Accepted Successfully");
    }
      public function postAmrejectdeviationrequest() 
    {
        $authuser = Auth::user();

        $job_id = Input::get('job_id');
        $talentpool_req_id = Input::get('talentpool_req_id');
        $talentpool_id = Input::get('talentpool_id');
        $vendor_deviation_rate = Input::get('vendor_deviation_rate');
        $vendor_deviation_request = Input::get('vendor_deviation_request');
        $am_deviation_status = Input::get('am_deviation_status');
        $vendor_id = Input::get('vendor_id');

        $joborderData = ['vendor_deviation_rate' => $vendor_deviation_rate, 'vendor_deviation_request' => $vendor_deviation_request, 'am_deviation_status' => $am_deviation_status];
        $actiavteJob = TalentpoolDeviationRequests::where('id', '=', intval($talentpool_req_id))
                                            ->update($joborderData);
        $joborderData1 = ['vendor_deviation_request' => $vendor_deviation_request];
        $actiavteJob1 = TalentpoolRequests::where('job_id', '=', intval($job_id))
                                           ->where('vendor_id', '=', intval($vendor_id))
                                           ->where('talentpool_id', '=', intval($talentpool_id))
                                            ->update($joborderData1);
        return response()->success("Rejected success");
    }
}