<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

//Adding DINGO API to perform API operations
$api = app('Dingo\Api\Routing\Router');

$api->version('v1', ['namespace' => 'App\Http\Controllers'], function ($api) {
    $api->group(['middleware' => ['api']], function ($api) {
        // Password Reset Routes...
        $api->post('auth/password/email', 'Auth\ResetPasswordController@sendResetLinkEmail');
        $api->post('auth/password/fpemail', 'Auth\ResetPasswordController@sendFPResetLinkEmail');
        $api->post('auth/password/validateemail_p', 'Auth\ResetPasswordController@sendFPResetLinkEmailvalidate');
        $api->post('auth/password/validateemail_pcreate', 'Auth\ResetPasswordController@sendFPResetLinkEmailvalidatecreate');
        $api->get('auth/password/verify', 'Auth\ResetPasswordController@verify');
        $api->get('auth/password/verifyps', 'Auth\ResetPasswordController@verifyps');
        $api->post('auth/password/reset', 'Auth\ResetPasswordController@reset');
        $api->post('auth/password/activate', 'Auth\ResetPasswordController@activate');
    });
    
    $api->group(['middleware' => ['api', 'api.auth']], function ($api) {
        $api->get('users/me', 'UserController@getMe');
        $api->put('users/me', 'UserController@putMe');
    });

    $api->group(['middleware' => ['api', 'api.auth']], function ($api) {
        $api->post('rchilliResume', 'RchilliController@postResume');
    });
});

// $api->version('v1', function($api) {
//     $api->get('/users', 'api\UserController@index'); //get all users
//     $api->get('/joborders', 'api\JobOrderController@index'); //get all jobs
//     $api->post('/joborders', 'api\JobOrderController@store'); //store job
//     $api->get('/joborders/{id}', 'api\JobOrderController@show'); //show job based on id
// });
