<?php

namespace App;

use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class JobOrders extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;


    public function JobType()
    {
        return $this->belongsTo('App\JobType');
    }
    public function Industry()
    {
        return $this->belongsTo('App\Industry', 'industry_id');
    }
    public function user(){
        return $this->belongsTo('App\User','user_id');
    }
    public function employer(){
        return $this->belongsTo('App\User','user_id');
    }
       public function company()
    {
        return $this->belongsTo('App\Company');
    }
    public function job()
    {
        return $this->belongsTo('App\JobOrders','id');
    }
    public function JobCitys()
    {
        return $this->hasMany('App\JobCitys','job_id','id');
    }

    public function getCity()
    {
        return $this->belongsTo(City::class,'city_id','id');
    }



    public function joblocations()
    {
        return $this->hasMany('App\JobCitys','job_id');
    }
    public function JobLanguages()
    {
        return $this->hasMany('App\JobLanguage','job_id');
    }
    public function Education()
    {
        return $this->hasMany('App\EducationAssociations','job_id');
    }
    public function status()
    {
        return $this->belongsTo('App\Status','status');
    }
     public function job_status()
    {
        return $this->belongsTo('App\Status','job_status');
    }
    public function association()
    {
        return $this->belongsTo('App\Association');
    }
     public function candidate()
    {
        return $this->belongsTo('App\Candidate');
    }
    public function Continents()
    {
        return $this->belongsTo('App\Continents','continents_id');
    }
     public function Predefinedquestionsanswers(){
        return $this->belongsTo('App\Predefinedquestionsanswers','job_id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['name',
        'location_id',
        'vacancies',
        'jobtypeid',
        'billrate',
        'am_billRate',
        'vendor_billRate',
        'vendor_deviation_rate',
        'vendor_deviation_request',
        'vendor_deviation_note',
        'am_deviation_status',
        'salary',
        'salary_min',
        'level',
        'currency',
        'salaryType',
        'experience',
        'experience_to',
        'experiencetype',
        'educationLevel',
        'description',
        'status',
        'requirement_id',
        'job_type_id',
        'language_id',
        'user_id',
        'joborder_number',
        'job_internal_code',
        'industry_id',
        'skills_preferred',
        'skills_required',
        'is_private',
        'max_contract_term',
        'min_contract_term',
        'contract_term_type',
        'expectedjoingdate',
        'updated_at',
        'gdprmandatory',
        'payment_mode',
        'payment_terms',
        'is_talentpool',
        'company_name',
        'company_desc',
        'work_autherization',
        'freshers_apply',
        'questions',
        'open_to_travel',
        'travel_percent',
        'relocate',
        'resumes',
        'note',
        'gdpr',
        'url',
        'nationality',
        'work_question',
        'work_question_2',
        'notice_period',
        'job_type_new',
        'continents_id',
		'blindhire'
    ];
    //'payment_mode','payment_terms'

    protected $appends = array('encryptedslug');

    public function getEncryptedslugAttribute()
    {
        $timestamp = 129346161081;
        $randomKey = '-';
        $encrypted = base64_encode($timestamp . $randomKey . $this->id);
        return $encrypted;
    }

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }

    public function vendors()
    {
        return $this->hasMany('App\JobUsers');
    }

    public function candidates()
    {
        return $this->hasMany('App\Candidates');
    }

    public function vendorrevenues()
    {
        return $this->hasMany('App\VendorRevenue','job_id');
    }

    public function vendorcustomrevenues()
    {
        return $this->hasMany('App\VendorRevenue','job_id')->where('vendor_id',NULL);
    }
}
