<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TalentMine extends Model
{
    protected $fillable = [
        'candidate_id',
        'balance_well_being',
        'benefits_perks',
        'business_reputation',
        'career_progression',
        'company_culture',
        'change_stability',
        'diversity_inclusion',
        'environmental_social_governance',
        'innovation_technology',
        'job_satisfaction',
        'remuneration',
        'team_people',
        'work_place',
        'globalization',
        'ip'
    ];


    public function getCandidate()
    {
        return $this->belongsTo(Candidate::class, 'candidate_id', 'id');
    }

}
