<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Model;

class Predefinedquestionsanswers extends Model implements AuthenticatableContract
{
    use Authenticatable;
    protected $table = 'predefined_questions_answers';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */ 
    protected $fillable = [
        'job_id','candidate_id','question_id','answer','amselect','accountmanager_id'
    ];

    public function job(){
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function candidate(){
        return $this->belongsTo('App\Candidate','candidate_id');
    }
     public function GdprData(){
        return $this->belongsTo('App\GdprData','job_id');
    }
     public function Predefinedquestionsanswers(){
        return $this->belongsTo('App\Predefinedquestionsanswers','job_id');
    }
   
    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        //'path', 'remember_token', 'oauth_provider_id', 'oauth_provider',
    ];
}
