<?php

namespace App;

use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class ProcessQuestionAnswers extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['processRole', 'processUserId', 'processUserName', 'questionId', 'questionAnswerRadio', 'processQuestionAnswerText', 'startTime', 'endTime'];

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function question()
    {
        return $this->belongsTo('App\ProcessSurvey', 'questionId');
    }
    public function employer()
    {
        return $this->belongsTo('App\User', 'processUserName');
    }
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }
}