<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Illuminate\Database\Eloquent\Model;

class TalentpoolDeviationRequests extends Model 
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public function job() {
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function vendor() {
        return $this->belongsTo('App\User','vendor_id');
    }
    public function talentpool() {
        return $this->belongsTo('App\Talentpools','talentpool_id');
    }
    public function talentpoolrequest() {
        return $this->belongsTo('App\TalentpoolRequests','talentpool_request_id');
    }
    
    
    protected $fillable = ['talentpool_request_id','accountmanager_id','accountmanager_id','vendor_id',
    'billrate','am_billRate','vendor_billRate','vendor_deviation_rate','vendor_deviation_request','vendor_deviation_note','job_id','talentpool_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
       // 'password', 'remember_token', 'oauth_provider_id', 'oauth_provider',
    ];
}
