<?php

namespace App;

use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class TalentpoolSkill extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;
public function skill()
    {
        return $this->belongsTo('App\Skills', 'skill_id');
    }
     public function skill_category() {
        return $this->belongsTo('App\SkillCategories','skill_id');
    }
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['talentpool_id','experience','skill_id'];

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }
}
