<?php

namespace App;

use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class Talentpools extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['name','description','vendor_id','location','availability','relocate','status','resume_name','min_rate','max_rate','rate_type','currency_type','candidate_name','talentpool_code','min_rate_hour','max_rate_hour'];

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
     public function talentlocations()
    {
        return $this->hasMany('App\TalentpoolLocation','talentpool_id');
    }

     public function vendor()
    {
        return $this->belongsTo('App\User','vendor_id');
    }

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }
}
