<?php

namespace App\Transformers\v1;

//we need to reference JobOrders Model
use App\JobOrders;

//Dingo includes fractal to help with transformations
use League\Fractal\TransformerAbstract;
use App\Http\Controllers\api\JobOrderController;



class JobOrderTransformer extends TransformerAbstract
{
	public function transform(JobOrders $joborder)
	{
		
		//specify what elements are going to be visible to the API
		return [
			
			'job_title' => $joborder->name,											//Job Title

			'company_name' => $joborder->employer['email'],						//Company/Employer E-mail
			
			'job_post_date' => $joborder->created_at->toDayDateTimeString(),		//Job Post Date
			
			'id' => (int) $joborder->id,										//Job ID

			//Job URL currently Empty
			

			'description' => $joborder->description,							//Job Description

			//Job Type(Permanent/Contract-to-Hire)
			'job_type_id' => $joborder->job_type_id,

			//Job City currently Empty
			//'JobCitys' => $joborder->JobCitys,
			'JobCitys' => $joborder->city,

			//Job State currently Empty
			//Job Country currently Empty

			//Job Category
			//'name' => $joborder->industry->name,
			'Industry' => $joborder->Industry['name'],

			//Job Company Logo currently Empty
			//Job Apply Email currently Empty
			'job_apply_email' => $joborder->employer['email']
			//API Endpoint URL currently Empty
			
		];
	}
}