<?php

// use Illuminate\Foundation\Auth\User as Authenticatable;

namespace App;

use Bican\Roles\Contracts\HasRoleAndPermission as HasRoleAndPermissionContract;
use Bican\Roles\Traits\HasRoleAndPermission;
use Illuminate\Auth\Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Database\Eloquent\Model;
/*
** Added header by Rajkumar on 25 sep 2019
*/
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Model implements AuthenticatableContract, CanResetPasswordContract, HasRoleAndPermissionContract, JWTSubject
{
    use Authenticatable, CanResetPassword, HasRoleAndPermission;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'avatar', 'oauth_provider', 'oauth_provider_id', 'payroll', 'job_type', 'vendor_code', 'is_global', 'startTime', 'endTime', 'processSurveyApprove','city_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden=['password', 'remember_token', 'oauth_provider_id', 'oauth_provider'];
    public function company()
    {
        return $this->belongsTo('App\Company');
    }
    public function role() {
        return $this->belongsTo('Bican\Roles\Models\Role');
    }
    public function associations() {
        return $this->hasMany('App\Association','employer_id');
    }
    public function vendorusersettings() {
        return $this->belongsTo('App\VendorUserSetting','id','vendor_user_id');
    }
    public function joborders() {
        return $this->hasMany('App\JobOrders');
    }
    public function vendorusersetting() {
        return $this->belongsTo('App\VendorUserSetting','id','vendor_user_id');
    }

    /*
    ** Added getJWTIdentifier, getJWTCustomClaims to this model by Rajkumar on 25 sep 2019
    */
    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
