<?php
namespace App;
use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class VendorUserJob extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['vendor_id','vendor_user_id','job_id','candidate_id','candidate_status'];
    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function vendoruser() {
        return $this->belongsTo('App\User','vendor_user_id');
    }
    public function vendorusersettings() {
        return $this->belongsTo('App\VendorUserSetting','vendor_user_id','vendor_user_id');
    }
    public function assingnedJob() {
        return $this->belongsTo('App\JobOrders','job_id');
    }
    public function job() {
        return $this->belongsTo('App\JobOrders','job_id');
    }
}