<?php
namespace App;
use Bican\Roles\Traits\Slugable;
use Illuminate\Database\Eloquent\Model;
use Bican\Roles\Traits\PermissionHasRelations;
use Bican\Roles\Contracts\PermissionHasRelations as PermissionHasRelationsContract;

class VendorUserSetting extends Model implements PermissionHasRelationsContract
{
    use Slugable, PermissionHasRelations;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['direct_submission_to_am','vendor_user_id','upload_cv_to_private_area','search_in_free_cvs','activate_vsa','candidate_area_access','min_jobs','max_jobs','auto_assign_job','auto_mode_keywords','priority'];
    /**
     * Create a new model instance.
     *
     * @param array $attributes
     * @return void
     */
    public function vendoruser() {
        return $this->belongsTo('App\User','vendor_user_id');
    }
}