<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('citypin');
            $table->string('salary');
            $table->string('salaryType');
            $table->integer('vacancies');
            $table->longText('description');
            $table->string('experience');
            $table->string('experienceType');
            $table->string('educationLevel');
            $table->string('language');
            $table->dateTime('deadline');
            $table->integer('requirement_id')->unsigned()->index();
            $table->foreign('requirement_id')->references('id')->on('requirements')->onDelete('cascade');
            $table->integer('job_type_id')->unsigned()->index();
            $table->foreign('job_type_id')->references('id')->on('job_types')->onDelete('cascade');
            $table->integer('user_id')->unsigned()->index();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('job_orders');
    }
}
