<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidates', function (Blueprint $table) {
            $table->increments('id');
            $table->string('full_name');
            $table->string('email');
			$table->string('phone');
			$table->string('mobile');
			$table->date('date_of_birth');
			$table->enum('gender', ['Male', 'Female', 'Other'])->default('Male');
			$table->string('job_profile');
			$table->string('address');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('zip');
			$table->string('current_salary');
			$table->string('expected_salary');
			$table->string('total_experience_in_year');
			$table->string('summary');
			$table->string('path');
			$table->integer('vendor_id')->nullable()->unsigned()->index();
			$table->foreign('vendor_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('candidates');
    }
}
