<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('position_id')->nullable()->unsigned()->index();
            $table->foreign('position_id')->references('id')->on('job_orders')->onDelete('cascade');
            $table->integer('person_id')->nullable()->unsigned()->index();
            $table->foreign('person_id')->references('id')->on('users')->onDelete('cascade');
            $table->integer('resume_id')->nullable()->unsigned()->index();
            $table->foreign('resume_id')->references('id')->on('candidates')->onDelete('cascade');
            $table->integer('requirement_id')->nullable()->unsigned()->index();
            $table->foreign('requirement_id')->references('id')->on('requirements')->onDelete('cascade');
            $table->integer('company_id')->nullable()->unsigned()->index();
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->string('name');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('activities');
    }
}
