<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateExperiencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidate_experiences', function (Blueprint $table) {
            $table->increments('id');
            $table->string('employer_name');
            $table->string('job_title');
			$table->string('empoyer_city');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('is_current_employer', ['1', '0'])->default('0');
			$table->integer('candidate_id')->unsigned()->index();
			$table->foreign('candidate_id')->references('id')->on('candidates')->onDelete('cascade');
             $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('candidate_experiences');
    }
}
