<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobResumesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_resumes', function (Blueprint $table) {
            $table->increments('id');
			$table->integer('job_id')->unsigned()->index();
            $table->foreign('job_id')->references('id')->on('job_orders')->onDelete('cascade');
            $table->integer('candidate_id')->unsigned()->index();
            $table->foreign('candidate_id')->references('id')->on('candidates')->onDelete('cascade');
            $table->enum('is_verified', ['2', '1', '0'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('job_resumes');
    }
}
