<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTalentMinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('talent_mines', function (Blueprint $table) {
           $table->increments('id');
            $table->integer('candidate_id')->nullable();
            $table->integer('balance_well_being')->nullable();
            $table->integer('benefits_perks')->nullable();
            $table->integer('business_reputation')->nullable();
            $table->integer('career_progression')->nullable();
            $table->integer('company_culture')->nullable();
            $table->integer('change_stability')->nullable();
            $table->integer('diversity_inclusion')->nullable();
            $table->integer('environmental_social_governance')->nullable();
            $table->integer('innovation_technology')->nullable();
            $table->integer('job_satisfaction')->nullable();
            $table->integer('remuneration')->nullable();
            $table->integer('team_people')->nullable();
            $table->integer('work_place')->nullable();
            $table->integer('globalization')->nullable();
            $table->string('ip')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('talent_mines');
    }
}
