<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClearBitCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clear_bit_companies', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('legalName')->nullable();
            $table->string('domain');
            $table->text('emailAddresses')->nullable();
            $table->text('phoneNumbers')->nullable();
            $table->text('category')->nullable();
            $table->text('tags')->nullable();
            $table->text('description')->nullable();
            $table->string('foundedYear')->nullable();
            $table->string('location')->nullable();
            $table->string('timeZone')->nullable();
            $table->string('utcOffset')->nullable();
            $table->text('geo')->nullable();
            $table->string('logo')->nullable();
            $table->text('facebook')->nullable();
            $table->text('linkedin')->nullable();
            $table->text('twitter')->nullable();
            $table->string('crunchbase')->nullable();
            $table->string('emailProvider')->nullable();
            $table->string('type')->nullable();
            $table->string('ticker')->nullable();
            $table->string('usEIN')->nullable();
            $table->string('phone')->nullable();
            $table->text('metrics')->nullable();
            $table->string('indexedAt')->nullable();
            $table->text('tech')->nullable();
            $table->text('techCategories')->nullable();
            $table->text('parent_domain')->nullable();
            $table->text('ultimateParent_domain')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clear_bit_companies');
    }
}
