<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::group(['middleware' => ['web']], function () {
    Route::get('/', 'AngularController@serveApp');

     //Route::get('/emp', 'AngularController@empServeApp');

    Route::get('/unsupported-browser', 'AngularController@unsupported');
    Route::get('user/verify/{verificationCode}', ['uses' => 'Auth\LoginController@verifyUserEmail']);
    Route::get('auth/{provider}', ['uses' => 'Auth\LoginController@redirectToProvider']);
    Route::get('auth/{provider}/callback', ['uses' => 'Auth\LoginController@handleProviderCallback']);
    Route::get('/api/authenticate/user', 'Auth\LoginController@getAuthenticatedUser');
    Route::post('/rchilliResume', 'RchilliController@postResume');
});

//Auth::routes();
/* Route::namespace('App\Http\Controllers')->group(function () {
    Auth::routes();
}); */