<?php

namespace App\Http\Controllers;

use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\Grade;
use App\Activity;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;

class GradeController extends Controller
{
    
    public function getIndex()
    {
        $grade = Grade::all();

        return response()->success(compact('grade'));
    }
 
  public function postGrade() 
    {
        $grade = Grade::create([
            'name' => Input::get('name'),
            'description' => Input::get('description'),
        ]);

        $authuser = Auth::user();
        //Insert Successfull grade create activity record
        $newGrade = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new grade.',
        ]);
        $newGradeResponse =  response()->success(compact('newGrade'));

        return response()->success(compact('grade'));
    }
public function getGrade($id)
    {
        $Grade = Grade::find($id);

    return response()->success($role);
    }
public function deleteGrade($id)
    {
        Grade::destroy($id);
         $authuser = Auth::user();
        //Insert Successfull grade delete activity record
        $deleteGrade = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted an existing grade.',
        ]);
        $deleteGradeResponse =  response()->success(compact('deleteGrade'));
        return response()->success('success');
    }
  public function getGradeShow($id)
    {
        $Grade = Grade::find($id);

        return response()->success($Grade);
    }
      public function putGradeShow()
    {
        $GradeForm = Input::get('data');
        $GradeData = [
            'name' => $GradeForm['name'],
            'description' => $GradeForm['description'],
        ];

        $affectedRows = Grade::where('id', '=', intval($GradeForm['id']))->update($GradeData);
        $Grade = Grade::find($GradeForm['id']);

        $authuser = Auth::user();
        //Insert Successfull grade update activity record
        $updateGrade = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Updated an existing grade.',
        ]);
        $updateGradeResponse =  response()->success(compact('updateGrade'));

      return response()->success('success');
    }
     
}