<?php

namespace App\Http\Controllers;

use App\User;
use DB;
use Auth;
use App\Models\JobOrdersQuestionAnswer;
use App\JobOrders;

use App\JobType;
use App\Predefinedquestionsanswers;

use App\Guests;

use App\Association;

use App\Activity;

use Bican\Roles\Models\Permission;

use Bican\Roles\Models\Role;

use Hash;

use Illuminate\Http\Request;

use Input;

use Validator;

use App\Country;

use App\Company;


use App\GdprData;
use App\Pricing;
use Mail;
use App\Candidate;
use App\CandidateExperiences;
use App\CandidateSkillsets;
use App\SoftSkills;
use App\CandidateSkills;
use App\CandidateNotecs;
use App\CompaniesEmployer;
use App\Skills;
use App\SkillCategories;
use App\ActionWords;
use App\SkillBroadcategories;
use App\CandidateSoftSkills;
use App\CandidateOperationalSkills;
use App\CandidateEducations;
use App\AiCompetencySe;
use App\CandidateDetails;
use App\AiPersonalityInsight;
use App\Employeespectrums;
use App\SegregatedSkill;
use App\UniversityGroup;
use App\ManagementWord;
use Carbon\Carbon;
use App\Models\ClearBitCompany;
use App\Models\NasdaqCompany;
use App\Models\WorldTopCompany;
use App\Models\TalentMine;
use App\Models\WorldUniversity;
use App\CandidateApiInfo;
use App\Recommendations;
use App\EmailInfo;
use App\SegregatedPublication;
use App\SegregatedCertification;
use App\CandidateAchievements;
use App\Colors;
use DateTime;
use DateTimeZone;
use App\UserAsset;
use Excel;
use App\Models\StuCandidate;
use App\Models\StuCandidateExp;
use App\Models\StuCandidateOther;
use App\Models\StuJob;
use App\Models\StuUser;
use App\Models\StuCreadit;
use App\Models\StuSubscription;
use App\Models\StuSubscriptionType;

class GuestController extends Controller

{

    

    public function getIndex()

    {

        $guests = Guests::all();

        return response()->success(compact('guests'));

    }

    public function getGdprdata($id)

    {

        $gdprdata = GdprData::where('encrypt_code',$id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->get();

        return response()->success($gdprdata);    

    }

    public function getShow($id)

    {

        $show = Guests::where('id', $id)

                        /*->roles()

                        ->select(['slug', 'roles.id', 'roles.name'])*/

                        ->get();

        return response()->success(compact('show'));

    }

    public function getGdpriddata($id)

    {

        $gdpriddata = GdprData::where('id',$id)->with('job.JobType')->with('job.industry')->with('job.JobCitys')->get();

        return response()->success($gdpriddata);    

    }

    public function postGdprupdate()

    {
        $authuser = Auth::user();
        $id = Input::get('id');

        $candidate_id = Input::get('candidate_id');

        $employer_id = Input::get('employer_id');

        $vendor_id = Input::get('vendor_id');

        $job_id = Input::get('job_id');

        $signature=Input::get('signature');

        $agreed_period=Input::get('agreed_period');

        $ip_address=Input::get('ip_address');

        $candidate_info = Candidate::where('id', $candidate_id)->get();

        $empAm = Association::select('accountmanager_id')->where('employer_id', $employer_id)

                             ->whereNotNull('accountmanager_id')

                             ->whereNull('candidate_id')

                             ->whereNull('vendor_id')

                             ->whereNull('job_id')

                             ->get();

       $ven_data = Association::where('vendor_id',$vendor_id)->where('job_id'    ,$job_id)

                            ->whereNotNull('accountmanager_id')

                            ->whereNotNull('employer_id')

                            ->whereNull('vendor_user_id')

                            ->whereNotNull('vendor_id')

                            ->whereNull('employer_user_id')

                            ->whereNull('candidate_id')

                            //->where('job_status',3)

                            ->with('accountmanager')

                            ->with('employer')

                            ->with('vendor')

                            ->with('job')

                            ->get();

        $am_data = User::where('id', $empAm[0]['accountmanager_id'])->get(['email','first_name']);

        $company_data = User::where('id', $employer_id)->with('company')->get();



        $gdprdata = [

            'signature' => $signature,

            'agreed_period' => $agreed_period,

            'ip_address' => $ip_address,

            'status'=>'1',

        ];



        $gdprRows = GdprData::where('id', '=', intval($id))->get();



        $affectedRows = GdprData::where('id', '=', intval($id))->update($gdprdata);



        $gdprupdate = ['gdpr_status' => 1];

        $association_update = Association::where('candidate_id', '=', intval($candidate_id))

                                            ->where('job_id',$job_id)

                                            ->update($gdprupdate);

        $candidate_info = Candidate::where('id', $candidate_id)->get();
         $companyid = User::select('company_id')->where("email", $ven_data[0]->vendor->email)->get();
         $vendorCompany = Company::select('name')->where('id', $companyid[0]->company_id)->get();
         $accountmanagerSubject = "Gears On!! " .$vendorCompany[0]->name. " Submitted profile for role ".$job_id."-".$gdprRows[0]->job_name ;

                $vendorSubject = "Bravo! Keep Going! You’ve Submitted profile for role ".$job_id." - ".$gdprRows[0]->job_name;
                Mail::send('emails.notifyInterestingCandidates', ['profileName' => $candidate_info[0]['full_name'], 'profileLocation' => $candidate_info[0]['city'], 'name' => $am_data[0]->first_name, 'profileIndustry' => $candidate_info[0]['job_profile'], 'job_name' => $gdprRows[0]->job_name, 'job_id' => $job_id, 'vendor_name' => $vendorCompany[0]->name, 'company_name' => $company_data[0]->company->name], function ($m) use($am_data, $accountmanagerSubject){

            $m->to($am_data[0]['email'], 'New Profile Submitted')->subject($accountmanagerSubject);

                });
                 Mail::send('emails.notifyInterestingCandidatesven', ['profileName' => $candidate_info[0]['full_name'], 'profileLocation' => $candidate_info[0]['city'], 'name' => $am_data[0]->first_name, 'profileIndustry' => $candidate_info[0]['job_profile'], 'job_name' => $gdprRows[0]->job_name, 'job_id' => $job_id, 'vendor_name' => $ven_data[0]->vendor->first_name, 'company_name' => $company_data[0]->company->name], function ($m) use($am_data, $vendorSubject, $ven_data){

            $m->to($ven_data[0]->vendor->email, 'New Profile Submitted')->subject($vendorSubject);

                 });


        return response()->success('Submitted successfully.');

    }

    public function postGdprupdatereject()

    {

        $id = Input::get('id');

       $agreed_period=Input::get('agreed_period');

       $ip_address=Input::get('ip_address');

       

       $gdprdata = [

            'agreed_period' => $agreed_period,

            'ip_address' => $ip_address,

            'status'=>'2',

        ];

        $affectedRows = GdprData::where('id', '=', intval($id))->update($gdprdata);

       return response()->success('Submitted successfully.');

    }

    public function getGuestsemployer() {

        $guestsemployer = Guests::Where('type','Employer')->Where('status','Pending')->get();
        return response()->success(compact('guestsemployer'));
    }



    public function getRejectedemployer() {

        $rejectedemployer = Guests::Where('type','Employer')->orWhere('type','Vendor')->Where('status','Rejected')->get();

        return response()->success(compact('rejectedemployer'));

    }

    public function getPendingemployervendor()
     {
          $alluser = User::get();
          foreach ($alluser as  $value) {
               $pendingemployervendor = Guests::Where('email', '=', $value->email)->Where('type','Employer')->orWhere('type','Vendor')->Where('status','Accepted')->get()->toArray();
            }
            return response()->success(compact('pendingemployervendor'));
    }

    public function getGuestdetails($id) {

        $guestdetails = Guests::Where('invitation_Code',$id)->get();
       
        $short_country = Country::where('ISD_code',str_replace('+', '', $guestdetails[0]->country_code))->get();

        $guestdetails['country_code_id'] = $short_country[0]['country_code'];

        return response()->success($guestdetails);
       
    }





    public function getGuestsvendor() {

        $guestsvendor = Guests::Where('type','Vendor')->Where('status','Pending')->get();

        return response()->success(compact('guestsvendor'));

    }



    public function getGuestusers() {

        $guestusers = Guests::whereIn('type', array('Vendor', 'Employer'))->Where('status','Pending')->get();

        //echo "<pre>"; print_r($guestusers); exit;

        return response()->success(compact('guestusers'));

    }





    public function postRegisteremployeraccept(Request $request)
    { 

        $guestData = [

            'status' => 'Accepted',

            'notes' =>$request->description,

            'account_manager'=>$request->account_manager,

        ];

        $affectedRows = Guests::where('id', '=', intval($request->id))->update($guestData);

        $country = Country::where('is_enabled',1)->first();
        
         Mail::send('emails.register_link_accept', ['userName' => $request->name,'email' => strtolower($request->email), 'mobile' => trim($request->mobile),'invitation_Code' => $request->invitation_Code,'description' => $request->description,'text' => 'You are invited to HireXtra. rejected.'], function ($m) use($request) {

             $m->to(strtolower($request->email), 'Thank You For Your Interest - HireXtra Team.')->subject('Your Application Status.');

         });

        $number = trim($request->mobile);

        $countryCode = $country->ISD_code;

        $ch = curl_init();

        $user="kv@hirextra.com";

        $password="hirextra";

        $receipientno = $countryCode.$number; 

        $originator = "Hirextra";

        $msgtxt = "Your Application Status.Please check your email- HireXtra Team.";

        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        curl_setopt($ch, CURLOPT_POST, 1);

        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");

        $buffer = curl_exec($ch);

        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

       return response()->success('Vendor Email Sent');

    }

    public function postRegisteremployerreject(Request $request)

    { $guestData = [

            'status' => 'Rejected',

            'notes' =>$request->description,

        ];

        $affectedRows = Guests::where('id', '=', intval($request->id))->update($guestData);

        $country = Country::where('is_enabled',1)->first();

        Mail::send('emails.register_link_reject', ['userName' => $request->name,'email' => strtolower($request->email), 'mobile' => trim($request->mobile),'invitation_Code' => $request->invitation_Code,'description' => $request->description,'text' => 'You are invited to HireXtra. rejected.'], function ($m) use($request) {

             $m->to(strtolower($request->email), 'Thank You For Your Interest - HireXtra Team.')->subject('Your Application Status.');

         });

        $number = trim($request->mobile);

        $countryCode = $country->ISD_code;

        $ch = curl_init();

        $user="kv@hirextra.com";

        $password="hirextra";

        $receipientno = $countryCode.$number; 

        $originator = "HireXtra";

        $msgtxt = "Your Application Status.Please check your email- HireXtra Team.";

        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        curl_setopt($ch, CURLOPT_POST, 1);

        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");

        $buffer = curl_exec($ch);

        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

       return response()->success('Vendor Email Sent');

    }

    public function postUsercreate(Request $request)

    {
        $country_code_id =  $request->timezone;
        $country_timezone = $country_code_id[0]["id"];
        $company = new Company();

        $company->name = trim($request->companyName);

        $company->telephone = trim($request->companyPhoneNumber);

        $company->address_line_1 = trim($request->streetAddress);

        $company->postal_code = trim($request->postalCode);

        $company->country_code = trim($request->country_code);

        $company->city_id = trim($request->city);
        $company->company_email = trim($request->company_email);
        $company->company_website = trim($request->company_website);
        $company->company_size = trim($request->company_size);
        $company->company_type = trim($request->company_type);
        $company->company_annual_revenue = trim($request->company_annual_revenue);
        $company->timeZone = $country_timezone;
        $company->company_description = trim($request->company_description);
        $company->company_tags = trim($request->company_tags);
        $company->company_social_media_links = trim($request->company_social_media_links);
        $company->company_technology_details = trim($request->company_technology_details);
        $company->save();

        $user = new User();

        $user->first_name = trim($request->firstName);

        $user->last_name = trim($request->lastName);

        $user->mobile = trim($request->contactmobile);

        $user->country_code = trim($request->country_code);

        $user->email = trim(strtolower($request->contactemail));

        $user->password = bcrypt($request->password);

        $user->email_verified = 1;

        $user->invitation_Code = trim($request->invitation_Code);

        $user->company_id = $company->id;

        $user->city_id = trim($request->city);

        if($request->usertype == 'Vendor'){

          $user->role_id = 6;

        }

        if($request->usertype == 'Employer'){

          $user->role_id = 5;

        }

        $user->save();

        // by mukesh
        $country_code = (int) $request->country_code;
        $country = Country::select('id', 'currency')->where('ISD_code', $country_code)->get();
        $contries = json_decode($country);
        
        $countryPrice = DB::table('country_pricing')
                            ->select('id', 'country_slap1','country_slap2','country_slap3', 'country_slap4', 'country_slap5', 'country_slap6')
                            ->where('country_currency', $contries[0]->currency)->take(1)->get();
        $count_id = $countryPrice[0]->id;
        unset($countryPrice[0]->id);
        unset($countryPrice[0]->country_slap1);
        $countryPrice = array_values((array) $countryPrice[0]);
        
        $countryPricePercents = DB::table('country_pricing_percent')
                                ->select('country_slap2','country_slap2','country_slap3','country_slap4','country_slap5','country_slap6')
                                ->where('country_id', $count_id)->get();
        $countryPricePercents = array_values((array) $countryPricePercents[0]);
        for($i=0; $i<count($countryPricePercents); $i++) {
            $prices = explode("-", $countryPrice[$i]);
            $price = new Pricing();
            $price->country_id = $contries[0]->id;
            $price->default_country = $contries[0]->id;
            $price->type_of_emp = 'Permanent';
            $price->starting_range = $prices[0];
            $price->ending_range = $prices[1];
            $price->price = $countryPricePercents[$i];
            $price->price_type = 'percentage';
            $price->emp_id = $user->id;
            $price->save();
        }
        $countryPrice = DB::table('country_pricing')
                            ->select('country_slap1','contract_percent')
                            ->where('country_currency', $contries[0]->currency)->take(1)->get();
                            
        $priceCon = new Pricing();
        $priceCon->country_id = $contries[0]->id;
        $priceCon->type_of_emp = 'Contract To Hire';
        $priceCon->default_country = $contries[0]->id;
        $priceCon->flat_rate = $countryPrice[0]->country_slap1;
        $priceCon->price = $countryPrice[0]->contract_percent;
        $priceCon->price_type = 'percentage';
        $priceCon->emp_id = $user->id;
        $priceCon->save();
    
        
        $cnPricePercents = DB::table('country_pricing_percent')
                                ->select('country_slap1')
                                ->where('country_id', $count_id)->get();
        $priceFlat = new Pricing();
        $priceFlat->country_id = $contries[0]->id;
        $priceFlat->type_of_emp = 'Flat Rate';
        $priceFlat->default_country = $contries[0]->id;
        $priceFlat->flat_rate = $countryPrice[0]->country_slap1;
        $priceFlat->price = $cnPricePercents[0]->country_slap1;
        $priceFlat->price_type = 'percentage';
        $priceFlat->emp_id = $user->id;
        $priceFlat->save();
    
        
        if($request->usertype == 'Vendor'){

          $roles = array(2,6,9);

          foreach ($roles as $setRole) {

            $user->attachRole($setRole);

          }

        }

        if($request->usertype == 'Employer'){

          $roles = array(2,5,8);

          foreach ($roles as $setRole) {

            $user->attachRole($setRole);

          }

        }

        $userassociation = new Association();

        $userassociation->admin_id = 1;

        if($request->usertype == 'Employer'){

          $userassociation->employer_id = $user->id;

        }

        if($request->usertype == 'Vendor'){

          $userassociation->vendor_id = $user->id;

        }

        $userassociation->accountmanager_id = $request->acountmanager;

        $userassociation->status_updated_by = 1;

        $userassociation->save();

        $country = Country::where('is_enabled',1)->first();

        Mail::send('emails.register_sucess', ['userName'=>$request->name,'email' => strtolower($request->contactemail), 'mobile' => trim($request->contactmobile),'invitation_Code' => $request->invitation_Code,'description' => $request->description,'text' => 'Thanks for Registering with Hirextra.'], function ($m) use($request) {

             $m->to(strtolower($request->contactemail), 'Thank You For Your Interest - HireXtra Team.')->subject('Your Registation Status.');

        });

        return response()->success(compact('user'));

    }
    public function getEmployerchecklistsource($job_id)
    {
        $decryption_jobid = base64_decode($job_id);
        $ids = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        $employerchecklistsource=   JobOrdersQuestionAnswer::select('answer as is_must','question_generate as Q_description','question_id','id','job_id','flag','question_type','original_queestions','created_at','user_id','updated_at')->where('job_id', $ids)->with('job')->get();
        return response()->success(compact('employerchecklistsource'));

    }
     public function getEmployerchecklistsourcee($job_id)
    {
        $employerchecklistsourcee=   JobOrdersQuestionAnswer::select('answer as is_must','question_generate as Q_description','question_id','id','job_id','flag','question_type','original_queestions','created_at','user_id','updated_at')->where('job_id', $job_id)->get();
        return response()->success(compact('employerchecklistsourcee'));

    }
    public function postQuestionanswers() {
        
        $job_id = Input::get('jobid');
        $candidate_id = Input::get('candidateid');
        $questions = Input::get('questions');

        $decryption_canid = base64_decode($candidate_id);
        $can_id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);
        $decryption_jobid = base64_decode($job_id);
        $ids = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        $inserted_sucess = "";
        foreach($questions as $key => $ques) {
            
            if(DB::insert("insert into predefined_questions_answers set job_id='".$ids."', candidate_id='".$can_id."', question_id='".$ques['question_id']."', answer='".$ques['is_must']."'")) {
                $inserted_sucess = "Inserted suceessfully.";
            }
        }
        return response()->success(compact('inserted_sucess'));
    }
    public function postQuestionanswerscheck() {
        
        $job_id = Input::get('jobid');
        $candidate_id = Input::get('candidateid');

        $decryption_canid = base64_decode($candidate_id);
        $can_id = substr($decryption_canid, strpos($decryption_canid, "-") + 1);
        $chkCandId = DB::table("predefined_questions_answers")->where('candidate_id', $can_id)->get();
        if(isset($chkCandId[0]->candidate_id)) {
            $retValue = 1;
        } else{
            $retValue = 0;
        }
        $decryption_jobid = base64_decode($job_id);
        $ids = substr($decryption_jobid, strpos($decryption_jobid, "-") + 1);
        $inserted_sucess="";

        return response()->success(compact('retValue'));
    }
        public function postQuestionanswerscheckk() {
        
        $job_id = Input::get('jobid');
        $candidate_id = Input::get('candidateid');
        
          $questionanswerscheckk = DB::table("job_orders_question_answers")->select('job_id','question_id','answer as is_must', 'question_generate as Q_description', 'flag','updated_at')->where('job_id',$job_id)->get();
          $val = DB::table("candidates")->select('full_name')->where('id',$candidate_id)->get();
          $candidatesname = explode('full_name',$val[0]->full_name);
          $val1 = DB::table("job_orders")->select('name')->where('id',$job_id)->get();
          $jobname = explode('name',$val1[0]->name);
          $ampredefinedd = DB::table('predefined_questions_answers')->where('job_id', $job_id)->where('candidate_id', $candidate_id)->count();
          if($ampredefinedd > 0 )
          {
            $ampredefined = 1;
          }
          else
          {
            $ampredefined = 0;
          }
      
        return response()->success(compact('questionanswerscheckk','candidatesname','jobname','ampredefined'));
    }

        public function postQuestionanswerss() 
        {
        $job_id = Input::get('jobid');
        $candidate_id = Input::get('candidateid');
        $questions = Input::get('questions');
        $amselect = Input::get('amselect');
        $accountmanager_id = Input::get('accountmanager_id');
        $date = date('Y-m-d h:i:s', time());
        $inserted_sucess = "";
        $user = DB::table("predefined_questions_answers")->where('candidate_id', '=', Input::get('candidateid'))->first();
                    if ($user === null) {
                    foreach($questions as $key => $ques) {
            
            if(DB::insert("insert into predefined_questions_answers set job_id='".$job_id."', candidate_id='".$candidate_id."', question_id='".$ques['question_id']."', answer='".$ques['is_must']."', amselect='".$amselect."', accountmanager_id='".$accountmanager_id."'")) {
                $inserted_sucess = "Inserted suceessfully.";
            }
        }
                      
                    }
        foreach($questions as $key => $ques) {
            
            if(DB::update("update predefined_questions_answers set job_id='".$job_id."', candidate_id='".$candidate_id."', question_id='".$ques['question_id']."', answer='".$ques['is_must']."', amselect='".$amselect."', accountmanager_id='".$accountmanager_id."' where job_id='".$job_id."' AND candidate_id='".$candidate_id."'")) {
                $inserted_sucess = "Inserted suceessfully.";
            }
        }
        return response()->success('success');
    }
    
      public function postResumeskill()
  {
      $file = Input::file('file');
        $jsonResult = null;
        $APIURL="http://hirextra8.rchilli.com/RChilliParser/Rchilli/parseResumeBinary";
        try
        {
        
        $assetId = null;
        $imagedata = file_get_contents($file);
        $base64 = base64_encode($imagedata);
        $key='Y0CPAOKBPGW';
        $version = "8.0.0";
        $subUserId = "Hirextra8";
        $data = array(
            "filedata" => $base64,
            "filename" => $file->getClientOriginalName(),
            "userkey" => $key,
            "version" => $version,
            "subuserid" => $subUserId
        );

        $str_data = json_encode($data);
        $ch = curl_init($APIURL);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($str_data))
        );
        $jsonResult = curl_exec($ch); //Assign rchilli response to a variable
    } //try
    catch (Exception $e)
    { echo 'Caught exception: ',  $e->getMessage(), "\n"; } //catch
    // //print_r($jsonResult);

    $jsonResult = json_decode($jsonResult, true);
    if(!empty($jsonResult['error'])&&$jsonResult['error']['errorcode']==1014){
        return response()->error("Profile format is invalid.");
    }

    $json=$jsonResult["ResumeParserData"];
           
    $path ="";
    // Save raw asset
    $asset_create_response = null;
    
    if ( Input::hasFile('file') )
    {
        $files = Input::file('file');
        ///print_r($files);
        if($files){
            $file_name = $files->getClientOriginalName();
            $file_type = $files->getClientMimeType();
            $path = base_path()."/assets/resumes/"."10102";
            $destinationPath = "10102";
            $url = "10102";
            $files->move($destinationPath, $files->getClientOriginalName());

            //Insert assets record
            $assets_create = UserAsset::create([
                'file_name' => $file_name,
                'file_type' => $file_type,
                'path' => $path,
                'url' => $url,
                'user_id' => "10102",
            ]);

        }
        $assetId = $assets_create->id;   // Assign Id of asset

    }
    $json['assetId'] = $assetId;
    $json['path'] = $path;



            $summary = '';
            $executiveSummary=null;
            $managementSummary=null;
            if( $json["Summary"] )
            { $summary = (String) $json["Summary"]; }
            elseif( $json["ExecutiveSummary"] )
            { $executiveSummary = (String) $json["ExecutiveSummary"]; }
            elseif( $json["ManagementSummary"] )
            { $managementSummary = (String) $json["ManagementSummary"]; }
            $executiveSummary = (String) $json["ExecutiveSummary"];
            $managementSummary = (String) $json["ManagementSummary"];

            if($json["DateOfBirth"]){
                $Dob = str_replace('/', '-', $json["DateOfBirth"]); //Replace '/' with '-'
            }
            if($json["CurrentLocation"]){
                $curentlocation=$json["CurrentLocation"][0]["City"].", ".$json["CurrentLocation"][0]["State"].", ".$json["CurrentLocation"][0]["Country"];
            }else{
                $curentlocation="";
            }
            if($json["PreferredLocation"]){
                $PreferredLocation=$json["PreferredLocation"];
            }else{
                $PreferredLocation="";
            }
            $alternate_email="";
            if($json["Email"]){
                $email_new=$json["Email"][0]["EmailAddress"];
            }else{
                $email_new="";
            }
            if($json["PhoneNumber"]){
                $mobile_new=$json["PhoneNumber"][0]["OriginalNumber"];
            }else{
                $mobile_new="";
            }
            $recomon="";

            $SkillSet=$json["SegregatedSkill"];
            $allSkills = null;
            $operationalSkills = null;
            $softSkills=null;
            $operationalSkills=null;
            //concatenate all the skills and assign to a variable.
            foreach($SkillSet as $skill)
            {
                if( $allSkills)  {

                    $allSkills = $allSkills.', '. $skill["Skill"];
                    if($skill["Type"] == "SoftSkill"){
                        $softSkills = $softSkills.', '. $skill["Skill"];
                    }
                    if($skill["Type"] == "OperationalSkill"){
                        $operationalSkills = $operationalSkills.', '. $skill["Skill"];
                    }
                }
                else  {
                    $allSkills = $skill["Skill"];
                }
            }
            if((String) $json["WorkedPeriod"]["TotalExperienceInYear"] =='' || (String) $json["WorkedPeriod"]["TotalExperienceInYear"]==null){
                $tot_exp=0;
            }else{
                $tot_exp=(String) $json["WorkedPeriod"]["TotalExperienceInYear"];
            }

            if( ($summary == '' || $summary == null) && ($executiveSummary == '' || $executiveSummary == null)){
                $summary = (String) $json["Name"]["FullName"] ." is having ". $tot_exp ." years experience with following skills ".$allSkills;
            }


            if($json["PhoneNumber"]){
                $country_code = $json["PhoneNumber"][0]["ISDCode"];

            }else{
                $country_code = "";
            }

            $alternate_email="";
               if(!empty($json["Nationality"]) ){
                $nationality=$json["Nationality"];
            }else{
                $nationality='';
            }
            //$phone_no = Input::get('phone');
            if($mobile_new){
                $mobileNo=$mobile_new;                
                $number = str_replace("-", "", $mobileNo);
                $number = str_replace(" ", "", $mobileNo);
                $mobile_new = $number;
            }else{
                $mobile_new="";
            }
            $recomon="";
            foreach ($json["Recommendations"] as $recomondation) {
                if(strlen($recomon) > 0){
                    $recomon = $recomon.', ';
                }
                $recomon = $recomon.$recomondation["PersonName"];
            }
            $languages_known="";
            foreach ($json["LanguageKnown"] as $recomondation) {
                if(strlen($languages_known) > 0){
                    $languages_known = $languages_known.', ';
                }
                $languages_known = $languages_known.$recomondation["Language"];
            }
            $job_profilee = $json['JobProfile'];
            $candidate = Candidate::create([
                'full_name' => (String) $json["Name"]["FullName"],
                'email' => (String) $email_new,
                'phone' => (String) $mobile_new,
                'mobile' => (String) $mobile_new,
                'country_code' => $country_code,
                'date_of_birth' =>  $json["DateOfBirth"] ? date('Y-m-d', strtotime($Dob)) : '',
                'gender' => (String) $json["Gender"],
                'job_profile' => $job_profilee,
                'address' => (String) $json["Address"][0]["Street"],
                'city' => (String) $json["Address"][0]["City"],
                'state' => (String) $json["Address"][0]["State"],
                'country' => (String) $json["Address"][0]["Country"],
                'zip' => (String) $json["Address"][0]["ZipCode"],
                'current_salary' => (String) $json["CurrentSalary"]["Amount"],
                'expected_salary' => (String) $json["ExpectedSalary"]["Amount"],
                'total_experience_in_year' => $tot_exp,
                'asset_id' => $json["assetId"],
               // 'vendor_id' => $authuser->id,
                'summary' => $summary,
                'path' =>  $json["path"],
                'title' => (String) $json["Name"]["TitleName"],
                'first_name' => (String) $json["Name"]["FirstName"],
                'middle_name' => (String) $json["Name"]["MiddleName"],
                'last_name' => (String) $json["Name"]["LastName"],
                'father_name' => (String) $json["FatherName"],
                'mother_name' => (String) $json["MotherName"],
                'marital_status' => (String) $json["MaritalStatus"],
                'nationality' =>  $json["Nationality"],
                'language_known' => (String) $languages_known,
                'unique_id' => (String) $json["UniqueID"],
                'license_no' => (String) $json["LicenseNo"],
                'passport_no' => (String) $json["PassportDetail"]["PassportNumber"],
                'pan_no' => (String) $json["PanNo"],
                'visa_status' => (String) $json["VisaStatus"],
                'alternate_email' =>(String) $alternate_email,
                'cover_letter' => (String) $json["Coverletter"],
                'certification' => (String) $json["Certification"],
                'publication' => (String) $json["Publication"],
                'current_location' =>(String) $curentlocation,
                'preferred_location' =>(String) $PreferredLocation,
                'availability' => (String) $json["Availability"],
                'objectives' => (String) $json["Objectives"],
                'candidate_references' => (String) $json["References"],
                'parsing_date' => (String) $json["ParsingDate"],
                'resume_language' =>(String) $json["ResumeLanguage"]["Language"],
                'resume_file_name' => (String) $json["ResumeFileName"],
                'formatted_address' => (String) $json["Address"][0]["FormattedAddress"],
                //'work_autherization' => $work_autherization,
                //'permanent_address' => (String) $dummy,
                // 'permanent_city' => (String) $dummy,
                // 'permanent_state' => (String) $dummy,
                // 'permanent_country' => (String) $dummy,
                // 'permanent_zip_code' => (String) $dummy,
                // 'formatted_permanent_address' =>(String) $dummy,
                'industry_category' => (String) $json["Category"],
                'industry_sub_category' => (String) $json["SubCategory"],
                'executive_summary' => $executiveSummary,
                'management_summary' => $managementSummary,
                'hobbies'=>$json['Hobbies'],
                'candidate_achievements'=>$json['Achievements'],
                'html_code'=>$json['HtmlResume'],
                'qualification'=>$json['Qualification'],
                //'note' => $note_description,
                //'is_privatearea'=>1
            ]);
             $SkillBlock = $json["SkillKeywords"];
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    $SkillBlock = $json["SkillBlock"];
                    
                    $SkillBlock = preg_replace('/\s{3}/', '~', $SkillBlock);
                    $skillsResumes = explode('~', $SkillBlock);
                    if(is_array($skillsResumes) && count($skillsResumes)>0) {
                        foreach($skillsResumes as $skills) {
                            
                            $skillArr = explode(':',$skills);
                            if(!empty($skillArr[1])) {
                                DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($skillArr[0])."', skill_value='".addslashes($skillArr[1])."', found_id='1'");
                            } else {
                                
                                $SkillBlock = preg_replace('/[\r,]/', '~', $skills);
                                $SkillBlock = preg_replace('/[~]+/', '~', $SkillBlock);
                                $SkillBlockArr = explode('~', $SkillBlock); 
                                $skillName = array();
                                $skillValue = array();
                                
                                foreach($SkillBlockArr as $key =>$value) {
                                    if(!empty($value)) {
                                        $sql = "select s.skill_name, sv.skillblock_keywords from skillblock_values as sv inner join skillblock as s on sv.skillblock_id = s.id where skillblock_keywords like'%".addslashes($value)."%'";
                                        
                                        $skillInfo = DB::select($sql);
                                        if(is_array($skillInfo) && count($skillInfo)>0) {
                                            DB::insert("insert into skillblock_temp set keyword='".$skillInfo[0]->skill_name."', value='".addslashes($skillInfo[0]->skillblock_keywords)."'");
                                        } else {
                                            DB::insert("insert into skillblock_temp set keyword='skills', value='".addslashes($value)."'");
                                        }
                                    }
                                }
                            }
                        }
                        $skillData = DB::select("select keyword, GROUP_CONCAT(value) as keyval from skillblock_temp group by keyword order by id");
                                
                        if(is_array($skillData) && count($skillData)>0) {
                            foreach($skillData as $ky => $val) {
                                $keyval = substr($val->keyval, 45);
                                if(!empty($keyval)){
                                    if($val->keyword=="skills") {
                                        DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='2'");
                                    } else {
                                            DB::insert("insert into skillblock_resume set candidate_id='".$candidate->id."', keyword='".addslashes($val->keyword)."', skill_value='".addslashes($keyval)."', found_id='1'");

                                    }
                                }
                            }
                        }
                        DB::delete('delete from skillblock_temp');
                    }
            

            $candidate_response = response()->success(compact('candidate'));

            // Assign last candidate ID
            $lastCandidateId = $candidate->id;
            if($json["WorkedPeriod"]["TotalExperienceInMonths"]) {
                foreach ($json["SegregatedExperience"] as $exp)
                {
                    if($exp['Employer'] != null && $exp["JobProfile"]["Title"] != null) {
                        $startDate = str_replace('/', '-', $exp["StartDate"]);//Replace '/' with '-'
                        //print_r($startDate);
                        $endDate = str_replace('/', '-', $exp["EndDate"]);//Replace '/' with '-'2 print_r le ke print karo
                        //print_r($endDate);kya problem hi
                        $candidate_exp = CandidateExperiences::create([
                            'employer_name' => $exp["Employer"]["EmployerName"],
                            'job_title' => $exp["JobProfile"]["Title"],
                            'empoyer_city' => $exp["Location"]["City"],
                            'start_date' => date('Y-m-d', strtotime($startDate)),
                            'end_date' =>  date('Y-m-d', strtotime($endDate)),
                            'is_current_employer' => ($exp["Employer"] == (String) $json["CurrentEmployer"]) ? 1 : 0 ,
                            'current_employer_name' => $json["CurrentEmployer"],
                            'total_experienceIn_months' => $json["WorkedPeriod"]["TotalExperienceInMonths"],
                            'total_experienceIn_year' => $json["WorkedPeriod"]["TotalExperienceInYear"],
                             'total_experienceIn_range' => $json["WorkedPeriod"]["TotalExperienceRange"],
                             'custom_fields' => $json["CustomFields"],

                            'candidate_id' => $lastCandidateId,
                        ]);
                        //print_r("ok");
                        $candidate_exp_response = response()->success(compact('candidate_exp'));
                    }
                }
                //candidate work history foreach
            } //if


            //Insert a record into candidateskillssets table
            $candidate_skill = CandidateSkillsets::create([
                'skill_set' => (string) $allSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_Set_response = response()->success(compact('candidate_skill'));
            $skills_new = '';
            $candidate_skills = CandidateSkills::create([
                'skills' => (string) $json["SkillKeywords"],//isko for each lagake aur implode karna hi
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_skills_response = response()->success(compact('candidate_skills'));

            $candidate_operational_skills = CandidateOperationalSkills::create([
                'operational_skills' => (string) $operationalSkills,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_operational_skills_response = response()->success(compact('candidate_operational_skills'));
            $candidate_soft_skills = CandidateSoftSkills::create([
                'soft_skills' => (string) $softSkills,
                'candidate_id' => $lastCandidateId,
            ]);

            $candidate_soft_skills_response = response()->success(compact('candidate_soft_skills'));
            // for only now
            foreach ($json["SegregatedQualification"] as $edu)
            {
                if(isset($edu["Institution"]))
                {
                    $startDate = str_replace('/', '-', $edu["StartDate"]);
                    $endDate = str_replace('/', '-', $edu["EndDate"]);
                    //print_r($edu["Degree"]["DegreeName"]);exit;
                    //Insert a record into candidateskillssets table
                    $candidate_educations = CandidateEducations::create([
                        'institution_name' => $edu["Institution"]["Name"],
                        'institution_city' => $edu["Institution"]["Location"]["City"],
                        'degree' => $edu["Degree"]["DegreeName"],
                        'start_date' => date('Y-m-d', strtotime($startDate)),
                        'end_date' => date('Y-m-d', strtotime($endDate)),
                        'aggregate' => $edu["Aggregate"]["Value"],
                        'measure_type' => $edu["Aggregate"]["MeasureType"],

                        'institution_type' => $edu["Institution"]["Type"],
                        'confidence_score' => $edu["Institution"]["ConfidenceScore"],
                        'state' => $edu["Institution"]["Location"]["State"],
                        'country' => $edu["Institution"]["Location"]["Country"],
                        'normalize_degree' => $edu["Degree"]["NormalizeDegree"],
                        'formatted_degree_period' => $edu["FormattedDegreePeriod"],
                        'candidate_id' => $lastCandidateId,
                    ]);
                    $candidate_educations_response = response()->success(compact('candidate_educations'));
                }
            } //foreach
            ///candidate-details//need to create model and send it to database
            $websites="";
            foreach ($json["WebSite"] as $recomondation) {
                if(strlen($websites) > 0){
                    $websites = $websites.', ';
                }
                $websites = $websites.$recomondation["Url"];
            }
            
            $candidate_details = CandidateDetails::create([
                'gapperiod' => (string) $json["GapPeriod"],
                'averageStay' =>(string) $json["AverageStay"],
                'LongestStay' =>(string) $json["LongestStay"],
                'recommendations' =>(string) $recomon,
                'detail_resume' =>(string) $json["DetailResume"],
                'template_output_data' =>(string) $json["TemplateOutput"]['TemplateOutputData'],
                'websites' => (string) $websites,
                //'overalldata' => (string) $json,
                'candidate_id' => $lastCandidateId,
            ]);
            $candidate_details_response = response()->success(compact('candidate_details'));


            foreach ($json["SegregatedSkill"] as $edu)
            {
                $segregatedskills = SegregatedSkill::create([
                    'type' => (string) $edu["Type"],
                    'skill' =>(string) $edu["Skill"],
                    'Ontology' =>(string) $edu["Ontology"],
                    'alias' =>(string) $edu["Alias"],
                    'formattedname' =>(string) $edu["FormattedName"],
                    'evidence' =>(string) $edu["Evidence"],
                    'lastused' =>(string) $edu["LastUsed"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregatedskills_response = response()->success(compact('segregatedskills'));

            }


            foreach ($json["SegregatedPublication"] as $edui)
            {
                $segregated_publication = SegregatedPublication::create([
                    'publication_title' => (string) $edui["PublicationTitle"],
                    'publisher_name' =>(string) $edui["Publisher"],
                    'publication_number' =>$edui["PublicationNumber"],
                    'publication_url' =>(string) $edui["PublicationUrl"],
                    'authors' =>(string) $edui["Authors"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_publication_response = response()->success(compact('segregated_publication'));

            }

            foreach ($json["Recommendations"] as $edui)
            {
                $recommendations = Recommendations::create([
                    'person_name' => (string) $edui["PersonName"],
                    'company_name' =>(string) $edui["CompanyName"],
                    'relation' =>$edui["Relation"],
                    'position_title' =>(string) $edui["PositionTitle"],
                    'description' =>(string) $edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $recommendations_response = response()->success(compact('recommendations'));

            }

            foreach ($json["SegregatedCertification"] as $edui)
            {
                $segregated_certification = SegregatedCertification::create([
                   'certification_title' => $edui["CertificationTitle"],
                    'authority' => $edui["Authority"],
                    'certification_code' =>$edui["CertificationCode"],
                    'is_expiry' => $edui["IsExpiry"],
                    'start_date' => $edui["StartDate"],
                    'end_date' =>$edui["EndDate"],
                    'certificationUrl' =>  $edui["CertificationUrl"],
                    'candidate_id' => $lastCandidateId,
                ]);
                $segregated_certification_response = response()->success(compact('segregated_certification'));

            }


            foreach ($json["SegregatedAchievement"] as $edui)
            {
                $candidate_achievements = CandidateAchievements::create([
                    'award_title' => $edui["AwardTitle"],
                    'issuer' =>$edui["Issuer"],
                    'experience' =>  $json["Experience"],
                    'associated_with' => $edui["AssociatedWith"],
                    'issuing_date' => $edui["IssuingDate"],
                    'description' =>$edui["Description"],
                    'candidate_id' => $lastCandidateId,
                ]);
               $candidate_achievements_response = response()->success(compact('candidate_achievements'));

            }



        return response()->success(compact('lastCandidateId'));
    
} //postResume functiondd
 public function postSkillblockinformations() {
        $candidate_id= Input::all();
        $candidate_id=$candidate_id['candidate_id'];
        $colors =array('name' =>'#b1f363','name' =>'#7dc5fd','name' =>'#ff9696','name' =>'#90dc62','name' =>'#b0d5e0','name' =>'#fe75a3','name' =>'#dd83ff','name' =>'#2f62e6','name' =>'#6ee58a','#a6dce8','#cfde39','#82559e','#fda444','#7adcf8','#d6f686');        //echo $candidate_id;exit;
        $skillblockInfo = DB::select("select sr.*, c.html_code,c.full_name, c.marital_status, cd.detail_resume from skillblock_resume as sr inner join candidates as c on sr.candidate_id=c.id inner join candidate_details as cd on cd.candidate_id=sr.candidate_id  where sr.candidate_id='".$candidate_id."' and sr.skill_value!=''");
        
               $colors =Colors::get();
        
        foreach($skillblockInfo as $key=>$value) {
            //print_r($value);exit();
            $value->color = $colors[$key]->name;
        }
        
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
           $skillblockInfo[0]->html_code = preg_replace('/font-family/','',$skillblockInfo[0]->html_code);
           $skillblockInfo[0]->html_code = preg_replace('/font-style/','',$skillblockInfo[0]->html_code);
           
           $pattern = '/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i';
            preg_match_all($pattern, $skillblockInfo[0]->html_code, $matches);
        
            if(isset($matches[0][0])) {
                $mask_email = substr_replace($matches[0][0], str_repeat("X", strlen($matches[0][0])), 2, strlen($matches[0][0])-6);
                $skillblockInfo[0]->html_code = preg_replace('/'.$matches[0][0].'/', $mask_email, $skillblockInfo[0]->html_code);
            }
            $phonePattern ='/[0-9]{2}[\s][0-9]{8}|[0-9]{3}[\s][0-9]{8}|[0-9]{3}[\s][0-9]{3}[\s][0-9]{4}|[0-9]{9}|[0-9]{3}[\-][0-9]{3}[\-][0-9]{6}/';
            //$phonePattern = '/^\+\d(\d{3})(\d{3})(\d{4})$/';
            preg_match_all($phonePattern, $skillblockInfo[0]->html_code, $phonematches);
            //print_r($phonematches); exit;
            if(isset($phonematches[0][0])) {
                $mask_phone = substr_replace($phonematches[0][0], str_repeat("X", strlen($phonematches[0][0])-1), 1, strlen($phonematches[0][0])-2); 
                $skillblockInfo[0]->html_code = preg_replace('/'.$phonematches[0][0].'/', $mask_phone, $skillblockInfo[0]->html_code);
            }
            
        }

        return response()->success(compact('skillblockInfo'));
                
    }
    // public function postCandidateskill() {
    //     $candidate_id= Input::get('candidate_id');

    //     $skills=  Input::get('skills');//'GENERAL TERMS';
    //    $candArr = array();
    //    $candidInfo = array();
    //    $candidInfo1 = array();
    //    $candidInfo2 = array();
    //     $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword='".$skills."'");
    //     //print_r($skillblockInfo);exit;
    //     if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
    //         foreach($skillblockInfo as $ky => $words) {
               
    //             $skill = $words->skill_value;
    //             $skillArr = explode(',', $skill);
               
    //             foreach($skillArr as $k => $skill_name) {
                    
    //                 $candidateInfo = DB::select("select lastused, experienceinmonths, skill from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($skill_name)."'");
    //                 //echo $skill_name;
    //                 //print_r($candidate_id);
    //                 //print_r($candidateInfo);
    //                 //exit;
                    
    //                 $expinMonth = 0;
    //                 if(is_array($candidateInfo) && count($candidateInfo)>0) {
    //                     foreach($candidateInfo as $key => $value) {
    //                         $lastused = "";
    //                         if(!empty($value->experienceinmonths) || !empty($value->lastused)) {
    //                             if(!empty($value->experienceinmonths)) {
    //                                 $expinMonth = $value->experienceinmonths;
    //                             } else if(!empty($value->lastused)){  
    //                                 $candInfo = DB::select("select total_experience_in_year, parsing_date, created_at from candidates where id='".$candidate_id."'");
    //                                 //print_r($candInfo);exit;
    //                                 if(is_array($candInfo) && count($candInfo)>0) {
    //                                     $dateArr = explode('/', $value->lastused);
    //                                     $lastusedDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
    //                                     $lastusedDate = date('Y-m-d', strtotime($lastusedDate));
    //                                     $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
    
    //                                     if($candInfo[0]->parsing_date!="") {
                                            
    //                                         $paprsingDate = explode(' ', $candInfo[0]->parsing_date);
    //                                         $parsDate = explode('/', $paprsingDate[0]);
    //                                         $datePars = $parsDate[2].'-'.$parsDate[1].'-'.$parsDate[0];
    //                                         $paprsingDate = date('Y-m-d', strtotime($datePars));
    //                                         //echo $paprsingDate.'=='.$lastusedDate; exit;
    //                                         if($paprsingDate==$lastusedDate) {
                                                
    //                                             $time = new DateTime($paprsingDate);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             //echo $total_experience_in_year.'=='.$expDate;exit;
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
                                                
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = date("d/m/Y");
    //                                             $currentSkill = "(Current Skill)";
    //                                         } else {
    //                                             $created_at = $candInfo[0]->created_at;
    //                                             $time = new DateTime($created_at);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = $value->lastused;
    //                                             $currentSkill ="";
    //                                         }
    //                                     } else if($candInfo[0]->parsing_date=="") {
    //                                             $created_at = $candInfo[0]->created_at;
    //                                             $time = new DateTime($created_at);
    //                                             $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
    //                                             $d1 = new DateTime($lastusedDate);
    //                                             $d2 = new DateTime($expDate);
    //                                             $interval = $d2->diff($d1);
    //                                             $years = $interval->format('%y');
    //                                             $month = $interval->format('%m');
    //                                             if($years!=0) {
    //                                                 $expinMonth = ($years * 12) + $month;
    //                                             } else {
    //                                                 $expinMonth = $month;
    //                                             }
    //                                             $lastused = $value->lastused;
    //                                             $currentSkill ="";
    //                                     }
    //                                 }
    //                             }
    //                              $candidInfo[] = ['name'=>$value->skill, 'y'=>round($expinMonth),'lastused'=>$lastused, 'current'=>$currentSkill];
    //                             }

    //                     }
    //                     // $candArr['names'] = $candidInfo;
    //                     // $candArr['values'] = $candidInfo1;
    //                     // $candArr['lastused'] = $candidInfo2;
    //                 }
    //             }
                
    //         }
    //     }
    //     return response()->success(compact('candidInfo'));
    // }
    public function postCandidateskill() {
       $candidate_id= Input::get('candidate_id');
       $skills=  Input::get('skills');//'GENERAL TERMS';
       $candArr = array();
       $candidInfo = array();
       $candidInfo1 = array();
       $candidInfo2 = array();
        $skillblockInfo = DB::select("select * from skillblock_resume where candidate_id='".$candidate_id."' and keyword='".$skills."'");
        //print_r($skillblockInfo);exit;
        $i=0;
        $j=0;
        $x=0;
        $z=0;
        if(is_array($skillblockInfo) && count($skillblockInfo)>0) {
            foreach($skillblockInfo as $ky => $words) {
               
                $skill = $words->skill_value;
                $skillArr = explode(',', $skill);
               
                foreach($skillArr as $k => $skill_name) {
                    
                    $candidateInfo = DB::select("select lastused, experienceinmonths, skill from segregatedskills where candidate_id='".$candidate_id."' and skill='".trim($skill_name)."'");
                    //echo $skill_name;
                    //print_r($candidate_id);
                    //print_r($candidateInfo);
                    //exit;
                    
                    $expinMonth = 0;
                    if(is_array($candidateInfo) && count($candidateInfo)>0) {
                        foreach($candidateInfo as $key => $value) {
                            $lastused = "";
                            if(!empty($value->experienceinmonths) || !empty($value->lastused)) {
                                if(!empty($value->experienceinmonths)) {
                                    $expinMonth = $value->experienceinmonths;
                                } else if(!empty($value->lastused)){  
                                    $candInfo = DB::select("select total_experience_in_year, parsing_date, created_at from candidates where id='".$candidate_id."'");
                                    //print_r($candInfo);exit;
                                    if(is_array($candInfo) && count($candInfo)>0) {
                                        $dateArr = explode('/', $value->lastused);
                                        $lastusedDate = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
                                        $lastusedDate = date('Y-m-d', strtotime($lastusedDate));
                                        $total_experience_in_year = round($candInfo[0]->total_experience_in_year);
    
                                        if($candInfo[0]->parsing_date!="") {
                                            
                                            $paprsingDate = explode(' ', $candInfo[0]->parsing_date);
                                            $parsDate = explode('/', $paprsingDate[0]);
                                            $datePars = $parsDate[2].'-'.$parsDate[1].'-'.$parsDate[0];
                                            $paprsingDate = date('Y-m-d', strtotime($datePars));
                                            //echo $paprsingDate.'=='.$lastusedDate; exit;
                                            if($paprsingDate==$lastusedDate) {
                                                
                                                $time = new DateTime($paprsingDate);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                //echo $total_experience_in_year.'=='.$expDate;exit;
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = date("d/m/Y");
                                                $currentSkill = "(Current Skill)";
                                            } else {
                                                $created_at = $candInfo[0]->created_at;
                                                $time = new DateTime($created_at);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                            }
                                        } else if($candInfo[0]->parsing_date=="") {
                                                $created_at = $candInfo[0]->created_at;
                                                $time = new DateTime($created_at);
                                                $expDate = $time->modify("-$total_experience_in_year year")->format('Y-m-d');
                                                $d1 = new DateTime($lastusedDate);
                                                $d2 = new DateTime($expDate);
                                                $interval = $d2->diff($d1);
                                                $years = $interval->format('%y');
                                                $month = $interval->format('%m');
                                                if($years!=0) {
                                                    $expinMonth = ($years * 12) + $month;
                                                } else {
                                                    $expinMonth = $month;
                                                }
                                                $lastused = $value->lastused;
                                                $currentSkill ="";
                                        }
                                    }
                                }
                                /* $candidInfo[] = ['name'=>$value->skill, 'y'=>round($expinMonth),'lastused'=>$lastused, 'current'=>$currentSkill];*/

     
                                $label[$i++] = $value->skill;
                                $last[$j++] = $lastused;
                                $data[$z++] = round($expinMonth);
                                $current[$x++] = $currentSkill;
                                /*$colorr = json_decode($color);
                                print_r($colorr);exit();*/
                                $color = ['#ffffff','#00cccc','#ff6633'];
                                $legend = true;
                                $type = "bar";

                                }
                               

                        }
                        // $candArr['names'] = $candidInfo;
                        // $candArr['values'] = $candidInfo1;
                        // $candArr['lastused'] = $candidInfo2;
                    }
                }
                
            }
        }
        return response()->success(compact('label','last','data','current','legend','type','color'));
    }
    public function postCompanysearches(Request $req) {
       $input = Input::get('title');
        $data[] = $input;
        $api_key = "6153c7f351d9fc310001025b79330c090e35d782dc7e7f3c45a307387f38b008";
        $outputneww=[];
         foreach ($data as $value) {
             $val = explode('Paste LinkedIn URLs below ":"' , $value);
             array_shift($val); 
             $val = str_replace('"','',$val);
             $val = str_replace('{','',$val);
             $val = str_replace(']','',$val);
             $val = str_replace(',','',$val);
             $val = str_replace('}','',$val);
         }
         foreach ($val as $key => $valuee) {
             $curl = curl_init();
             $url="https://api.peopledatalabs.com/v5/person/enrich?pretty=true&api_key=$api_key&profile=$valuee";
                curl_setopt($curl, CURLOPT_URL,$url );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        $output = curl_exec($curl);
                        $outputn = json_decode($output);
                       $items[]=$outputn;
                       
                        
            curl_close($curl);
         }
        // print_r($items);exit();
         foreach ($items as $key => $value) {

             if(($value->status) == 404 )
         {
            //$items = "no record";

         }

         else{
            //print_r($value);exit();
                $countries = $value->data->countries;
                if(!empty($countries))
                {
                    $countries_data = $countries[0];
                }
                else{
                    $countries_data = "";
                }
                $personal_emails = $value->data->personal_emails;
                if(!empty($personal_emails))
                {
                    $personal_emails_data = $personal_emails[0];
                }
                else{
                    $personal_emails_data = "";
                }
                $emails = $value->data->emails;
                if(!empty($emails))
                {
                    $emails_data = $emails[0]->address; 
                }
                else{
                    $emails_data = "";
                }
                $education = $value->data->education;
                if(!empty($education))
                {
                    $educationn = $education[0]->degrees;
                    if(!empty($educationn))
                    {
                        $education_data = $educationn[0];
                    }
                    else{
                        $education_data = "";
                    }
                }
                else{
                    $education_data = "";
                }
                 $interests[] = $value->data->interests;
                            if(is_array($interests) && count($interests) >0 )
                            {
                                foreach ($interests as $key => $valuee) {
                                    
                                    $interests_dataa = implode(",", $valuee);
                                    
                                    $interests_data = str_replace(["0","1","2"], ",", $interests_dataa);
                                }
                            }
                        
                            $skills[] = $value->data->skills;
                            if(is_array($skills) && count($skills) >0 )
                            {
                                foreach ($skills as $key => $valu) {
                                    $skills_dataa = implode(",", $valu);

                                    $skills_data = str_replace(["0","1","2"], ",", $skills_dataa);
                                }

                            }
                                
                $updated_at = date("Y-m-d h:i:s");
                $experience = $value->data->experience;
                $experiencecount = count($experience);
                if(!empty($experience))
                {
                 $experiencee =  $value->data->experience[0]->company->name;  
                }
                else{
                    $experiencee = "";
                }
                $candidateexist = StuCandidate::where('peopledata_id',$value->data->id)->get()->toArray();
                if(is_array($candidateexist) && count($candidateexist) > 0)
                {
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->updated_at = $updated_at;
                        $getcandidate_id->update();
                        $candidate_id_value = $candidateexist[0]['id'];
                        $value->candidate_id = $candidate_id_value;


                        DB::update("update stu_job set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_experiences set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_other set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");

                }
                else{
                            
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->user_id = 100;
                        $getcandidate_id->type_search = 1;
                        $getcandidate_id->first_name = $value->data->first_name;
                        $getcandidate_id->middle_name = $value->data->middle_name;
                        $getcandidate_id->last_name = $value->data->last_name;
                        $getcandidate_id->full_name = $value->data->full_name;
                        $getcandidate_id->gender = $value->data->gender;
                        $getcandidate_id->peopledata_id = $value->data->id;
                        $getcandidate_id->birth_date = $value->data->birth_date;
                        $getcandidate_id->birth_year = $value->data->birth_year;
                        $getcandidate_id->countries = $countries_data;
                        $getcandidate_id->personal_emails = $personal_emails_data;
                        $getcandidate_id->emails = $emails_data;
                        $getcandidate_id->work_email = $value->data->work_email;
                        $getcandidate_id->mobile_phone = $value->data->mobile_phone;
                        $getcandidate_id->industry = $value->data->industry;
                        $getcandidate_id->linkedin_id = $value->data->linkedin_id;
                        $getcandidate_id->linkedin_url = $value->data->linkedin_url;
                        $getcandidate_id->linkedin_username = $value->data->linkedin_username;
                        $getcandidate_id->location_continent = $value->data->location_continent;
                        $getcandidate_id->location_country = $value->data->location_country;
                        $getcandidate_id->location_locality = $value->data->location_locality;
                        $getcandidate_id->location_name = $value->data->location_name;
                        $getcandidate_id->location_region = $value->data->location_region;
                        $getcandidate_id->job_title = $value->data->job_title;
                        $getcandidate_id->education = $education_data;
                        $getcandidate_id->facebook_url = $value->data->facebook_url;
                        $getcandidate_id->github_url = $value->data->github_url;
                        $getcandidate_id->twitter_url = $value->data->twitter_url;
                        $getcandidate_id->experience = $experiencecount;
                        $getcandidate_id->company_name =$experiencee;
                        $getcandidate_id->save();
                        $candidate_id_value = $getcandidate_id->id;
                        $value->candidate_id = $candidate_id_value;


                        DB::insert("insert into stu_candidate_other set candidate_id='".$candidate_id_value."',interests='".$interests_data."', skills='".$skills_data."'");
                            DB::insert("insert into stu_job set candidate_id='".$candidate_id_value."', job_title='".$value->data->job_title."', job_title_role='".$value->data->job_title_role."',job_title_sub_role='".$value->data->job_title_sub_role."', job_company_founded='".$value->data->job_company_founded."',job_company_id='".$value->data->job_company_id."', job_company_industry='".$value->data->job_company_industry."',job_company_linkedin_id='".$value->data->job_company_linkedin_id."', job_company_linkedin_url='".$value->data->job_company_linkedin_url."',job_company_location_continent='".$value->data->job_company_location_continent."', job_company_location_country='".$value->data->job_company_location_country."',job_company_location_locality='".$value->data->job_company_location_locality."', job_company_location_name='".$value->data->job_company_location_name."',job_company_size='".$value->data->job_company_size."', job_company_website='".$value->data->job_company_website."',job_last_updated='".$value->data->job_last_updated."', job_start_date='".$value->data->job_start_date."'");




                    
                    foreach ($experience as $key => $val) {
                        $employer_city = $val->location_names;
                        if(!empty($employer_city))
                        {
                            $employer_city_data = $val->location_names[0];
                        }
                        DB::insert("insert into stu_candidate_experiences set candidate_id='".$candidate_id_value."',employer_name='".$val->company->name."', job_title='".$val->title->name."',employer_city='".$employer_city_data."', start_date='".$val->start_date."',end_date='".$val->end_date."', is_primary='".$val->is_primary."',facebook_url='".$val->company->facebook_url."', founded='".$val->company->founded."',industry='".$val->company->industry."', linkedin_url='".$val->company->linkedin_url."',twitter_url='".$val->company->twitter_url."', size='".$val->company->size."',website='".$val->company->website."'");
                        
                    }

                
                        
                        }
                    }

                }
                

       return response()->success(compact('items'));
         

  }

 public function postCompanysearchesperson(Request $req) {
       $input = Input::get('title');
        $data[] = $input;
        $api_key = "6153c7f351d9fc310001025b79330c090e35d782dc7e7f3c45a307387f38b008";
        
        $outputneww=[];
        $i = 1; 
         foreach ($data as $key => $valuee) {
            // print_r($valuee);exit();
             
                    $name = $valuee['jsondata'][$i]['Paste Name below'];
                     $companyname =$valuee['jsondata'][$i]['Paste Company Name below'];
                     $url="https://api.peopledatalabs.com/v5/person/enrich?pretty=true&api_key=$api_key&name=$name&company=$companyname";
                      $curl = curl_init();
                    curl_setopt($curl, CURLOPT_URL,$url );
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                            $output = curl_exec($curl);
                            $outputn = json_decode($output);
                           $items[]=$outputn;
                           
                            
                curl_close($curl);
                
                  
             $i = $i + 1;
                      
         }

        
    //print_r($items);exit;
         foreach ($items as $key => $value) {
             if(($value->status) == 400 )
         {
            $items = "no record";

         }
         else{
            //print_r($value);exit();
                $countries = $value->data->countries;
                if(!empty($countries))
                {
                    $countries_data = $countries[0];
                }
                else{
                    $countries_data = "";
                }
                $personal_emails = $value->data->personal_emails;
                if(!empty($personal_emails))
                {
                    $personal_emails_data = $personal_emails[0];
                }
                else{
                    $personal_emails_data = "";
                }
                $emails = $value->data->emails;
                if(!empty($emails))
                {
                    $emails_data = $emails[0]->address; 
                }
                else{
                    $emails_data = "";
                }
                $education = $value->data->education;
                if(!empty($education))
                {
                    $educationn = $education[0]->degrees;
                    if(!empty($educationn))
                    {
                        $education_data = $educationn[0];
                    }
                    else{
                        $education_data = "";
                    }
                }
                else{
                    $education_data = "";
                }
                 $interests[] = $value->data->interests;
                            if(is_array($interests) && count($interests) >0 )
                            {
                                foreach ($interests as $key => $valuee) {
                                    
                                    $interests_dataa = implode(",", $valuee);
                                    
                                    $interests_data = str_replace(["0","1","2"], ",", $interests_dataa);
                                }
                            }
                        
                            $skills[] = $value->data->skills;
                            if(is_array($skills) && count($skills) >0 )
                            {
                                foreach ($skills as $key => $valu) {
                                    $skills_dataa = implode(",", $valu);

                                    $skills_data = str_replace(["0","1","2"], ",", $skills_dataa);
                                }

                            }
                                
                $updated_at = date("Y-m-d h:i:s");
                $experience = $value->data->experience;
                $experiencecount = count($experience);
                $candidateexist = StuCandidate::where('peopledata_id',$value->data->id)->get()->toArray();
                if(is_array($candidateexist) && count($candidateexist) > 0)
                {
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->updated_at = $updated_at;
                        $getcandidate_id->update();
                        $candidate_id_value = $candidateexist[0]['id'];
                        $value->candidate_id = $candidate_id_value;
                        $value->updated_at =$candidateexist[0]['updated_at'];


                        DB::update("update stu_job set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_experiences set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_other set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");

                }
                else{
                            
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->user_id = 100;
                        $getcandidate_id->type_search = 1;
                        $getcandidate_id->first_name = $value->data->first_name;
                        $getcandidate_id->middle_name = $value->data->middle_name;
                        $getcandidate_id->last_name = $value->data->last_name;
                        $getcandidate_id->full_name = $value->data->full_name;
                        $getcandidate_id->gender = $value->data->gender;
                        $getcandidate_id->peopledata_id = $value->data->id;
                        $getcandidate_id->birth_date = $value->data->birth_date;
                        $getcandidate_id->birth_year = $value->data->birth_year;
                        $getcandidate_id->countries = $countries_data;
                        $getcandidate_id->personal_emails = $personal_emails_data;
                        $getcandidate_id->emails = $emails_data;
                        $getcandidate_id->work_email = $value->data->work_email;
                        $getcandidate_id->mobile_phone = $value->data->mobile_phone;
                        $getcandidate_id->industry = $value->data->industry;
                        $getcandidate_id->linkedin_id = $value->data->linkedin_id;
                        $getcandidate_id->linkedin_url = $value->data->linkedin_url;
                        $getcandidate_id->linkedin_username = $value->data->linkedin_username;
                        $getcandidate_id->location_continent = $value->data->location_continent;
                        $getcandidate_id->location_country = $value->data->location_country;
                        $getcandidate_id->location_locality = $value->data->location_locality;
                        $getcandidate_id->location_name = $value->data->location_name;
                        $getcandidate_id->location_region = $value->data->location_region;
                        $getcandidate_id->job_title = $value->data->job_title;
                        $getcandidate_id->education = $education_data;
                        $getcandidate_id->facebook_url = $value->data->facebook_url;
                        $getcandidate_id->github_url = $value->data->github_url;
                        $getcandidate_id->twitter_url = $value->data->twitter_url;
                        $getcandidate_id->experience = $experiencecount;
                        $getcandidate_id->save();
                        $candidate_id_value = $getcandidate_id->id;
                        $value->candidate_id = $candidate_id_value;
                        //$value->updated_at = $getcandidate_id->updated_at;


                        DB::insert("insert into stu_candidate_other set candidate_id='".$candidate_id_value."',interests='".$interests_data."', skills='".$skills_data."'");
                            DB::insert("insert into stu_job set candidate_id='".$candidate_id_value."', job_title='".$value->data->job_title."', job_title_role='".$value->data->job_title_role."',job_title_sub_role='".$value->data->job_title_sub_role."', job_company_founded='".$value->data->job_company_founded."',job_company_id='".$value->data->job_company_id."', job_company_industry='".$value->data->job_company_industry."',job_company_linkedin_id='".$value->data->job_company_linkedin_id."', job_company_linkedin_url='".$value->data->job_company_linkedin_url."',job_company_location_continent='".$value->data->job_company_location_continent."', job_company_location_country='".$value->data->job_company_location_country."',job_company_location_locality='".$value->data->job_company_location_locality."', job_company_location_name='".$value->data->job_company_location_name."',job_company_size='".$value->data->job_company_size."', job_company_website='".$value->data->job_company_website."',job_last_updated='".$value->data->job_last_updated."', job_start_date='".$value->data->job_start_date."'");




                    
                    foreach ($experience as $key => $val) {
                        $employer_city = $val->location_names;
                        if(!empty($employer_city))
                        {
                            $employer_city_data = $val->location_names[0];
                        }
                        DB::insert("insert into stu_candidate_experiences set candidate_id='".$candidate_id_value."',employer_name='".$val->company->name."', job_title='".$val->title->name."',employer_city='".$employer_city_data."', start_date='".$val->start_date."',end_date='".$val->end_date."', is_primary='".$val->is_primary."',facebook_url='".$val->company->facebook_url."', founded='".$val->company->founded."',industry='".$val->company->industry."', linkedin_url='".$val->company->linkedin_url."',twitter_url='".$val->company->twitter_url."', size='".$val->company->size."',website='".$val->company->website."'");
                        
                    }

                
                        
                        }
                    }

                }
                

       return response()->success(compact('items'));
         

  }
  public function postUserlogin()
    {
        $email = Input::get('email');
        $password =Input::get('password');
        $match = DB::select("select * from stu_user where email='".$email."' and password='".$password."'");

        if (count($match)>0)
         {
            $userid = DB::select("select id from stu_user where email='".$email."' and password='".$password."'");
            return response()->success(compact('userid'));
            
        } else {
           return response()->error("Pleae provide correct email and password");
        }

    }
        public function postUserdashboard() {
        $user_id = Input::get('user_id');
        $subcriptiondata = StuCreadit::where('user_id',$user_id)->get()->toArray();
        
        foreach ($subcriptiondata as $key => $value) {
            
            $value['totalcandidates'] =StuCandidate::where('user_id',$value['user_id'])->count();
        }

        foreach ($subcriptiondata as $key => $valuee) {
            
            $valuee =StuCandidate::where('user_id',$value['user_id'])->limit(5)->orderBy('id', 'desc')->get();
        }
       // print_r($subcriptiondata);
        $username = StuUser::where('id',$user_id)->first()->first_name;


        $dashboarddata[] = array('subcriptiondata'=>$value,'lastfivecandidate' =>$valuee,'first_name'=>$username);
        return response()->success(compact('dashboarddata'));
        
    }
    public function postSearchdata(Request $req) {

        $user_id = Input::get('user_id');
        $type_search = Input::get('type');
        $getdata = StuCandidate::where('user_id',$user_id )->where('type_search',$type_search)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        return response()->success(compact('getdata'));
        
    }
    
        public function postEmailsearch(Request $req) {
       $input = Input::get('title');
        $data[] = $input;
        $api_key = "6153c7f351d9fc310001025b79330c090e35d782dc7e7f3c45a307387f38b008";
        $outputneww=[];
         foreach ($data as $value) {
            $emaildata[] = $value["jsondata"];
         }
         foreach ($emaildata as $key => $valuee) {
            $getdataval = $valuee[$key]['Paste Emails below'];
            //print_r($getdataval);exit();
             $curl = curl_init();
             $url="https://api.peopledatalabs.com/v5/person/enrich?pretty=true&api_key=$api_key&email=$getdataval";
                curl_setopt($curl, CURLOPT_URL,$url );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        $output = curl_exec($curl);
                        $outputn = json_decode($output);
                       $items[]=$outputn;
                       
                        
            curl_close($curl);
         }
        // print_r($items);exit();
         foreach ($items as $key => $value) {

             if(($value->status) == 404 )
         {
            //$items = "no record";

         }

         else{
            //print_r($value);exit();
                $countries = $value->data->countries;
                if(!empty($countries))
                {
                    $countries_data = $countries[0];
                }
                else{
                    $countries_data = "";
                }
                $personal_emails = $value->data->personal_emails;
                if(!empty($personal_emails))
                {
                    $personal_emails_data = $personal_emails[0];
                }
                else{
                    $personal_emails_data = "";
                }
                $emails = $value->data->emails;
                if(!empty($emails))
                {
                    $emails_data = $emails[0]->address; 
                }
                else{
                    $emails_data = "";
                }
                $education = $value->data->education;
                if(!empty($education))
                {
                    $educationn = $education[0]->degrees;
                    if(!empty($educationn))
                    {
                        $education_data = $educationn[0];
                    }
                    else{
                        $education_data = "";
                    }
                }
                else{
                    $education_data = "";
                }
                 $interests[] = $value->data->interests;
                            if(is_array($interests) && count($interests) >0 )
                            {
                                foreach ($interests as $key => $valuee) {
                                    
                                    $interests_dataa = implode(",", $valuee);
                                    
                                    $interests_data = str_replace(["0","1","2"], ",", $interests_dataa);
                                }
                            }
                        
                            $skills[] = $value->data->skills;
                            if(is_array($skills) && count($skills) >0 )
                            {
                                foreach ($skills as $key => $valu) {
                                    $skills_dataa = implode(",", $valu);

                                    $skills_data = str_replace(["0","1","2"], ",", $skills_dataa);
                                }

                            }
                                
                $updated_at = date("Y-m-d h:i:s");
                $experience = $value->data->experience;
                $experiencecount = count($experience);
                if(!empty($experience))
                {
                 $experiencee =  $value->data->experience[0]->company->name;  
                }
                else{
                    $experiencee = "";
                }
                $candidateexist = StuCandidate::where('peopledata_id',$value->data->id)->get()->toArray();
                if(is_array($candidateexist) && count($candidateexist) > 0)
                {
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->updated_at = $updated_at;
                        $getcandidate_id->update();
                        $candidate_id_value = $candidateexist[0]['id'];
                        $value->candidate_id = $candidate_id_value;


                        DB::update("update stu_job set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_experiences set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");
                        DB::update("update stu_candidate_other set updated_at='".$updated_at."' where candidate_id='".$candidate_id_value."'");

                }
                else{
                            
                        $getcandidate_id = new StuCandidate;
                        $getcandidate_id->user_id = 100;
                        $getcandidate_id->type_search = 1;
                        $getcandidate_id->first_name = $value->data->first_name;
                        $getcandidate_id->middle_name = $value->data->middle_name;
                        $getcandidate_id->last_name = $value->data->last_name;
                        $getcandidate_id->full_name = $value->data->full_name;
                        $getcandidate_id->gender = $value->data->gender;
                        $getcandidate_id->peopledata_id = $value->data->id;
                        $getcandidate_id->birth_date = $value->data->birth_date;
                        $getcandidate_id->birth_year = $value->data->birth_year;
                        $getcandidate_id->countries = $countries_data;
                        $getcandidate_id->personal_emails = $personal_emails_data;
                        $getcandidate_id->emails = $emails_data;
                        $getcandidate_id->work_email = $value->data->work_email;
                        $getcandidate_id->mobile_phone = $value->data->mobile_phone;
                        $getcandidate_id->industry = $value->data->industry;
                        $getcandidate_id->linkedin_id = $value->data->linkedin_id;
                        $getcandidate_id->linkedin_url = $value->data->linkedin_url;
                        $getcandidate_id->linkedin_username = $value->data->linkedin_username;
                        $getcandidate_id->location_continent = $value->data->location_continent;
                        $getcandidate_id->location_country = $value->data->location_country;
                        $getcandidate_id->location_locality = $value->data->location_locality;
                        $getcandidate_id->location_name = $value->data->location_name;
                        $getcandidate_id->location_region = $value->data->location_region;
                        $getcandidate_id->job_title = $value->data->job_title;
                        $getcandidate_id->education = $education_data;
                        $getcandidate_id->facebook_url = $value->data->facebook_url;
                        $getcandidate_id->github_url = $value->data->github_url;
                        $getcandidate_id->twitter_url = $value->data->twitter_url;
                        $getcandidate_id->experience = $experiencecount;
                        $getcandidate_id->company_name =$experiencee;
                        $getcandidate_id->save();
                        $candidate_id_value = $getcandidate_id->id;
                        $value->candidate_id = $candidate_id_value;


                        DB::insert("insert into stu_candidate_other set candidate_id='".$candidate_id_value."',interests='".$interests_data."', skills='".$skills_data."'");
                            DB::insert("insert into stu_job set candidate_id='".$candidate_id_value."', job_title='".$value->data->job_title."', job_title_role='".$value->data->job_title_role."',job_title_sub_role='".$value->data->job_title_sub_role."', job_company_founded='".$value->data->job_company_founded."',job_company_id='".$value->data->job_company_id."', job_company_industry='".$value->data->job_company_industry."',job_company_linkedin_id='".$value->data->job_company_linkedin_id."', job_company_linkedin_url='".$value->data->job_company_linkedin_url."',job_company_location_continent='".$value->data->job_company_location_continent."', job_company_location_country='".$value->data->job_company_location_country."',job_company_location_locality='".$value->data->job_company_location_locality."', job_company_location_name='".$value->data->job_company_location_name."',job_company_size='".$value->data->job_company_size."', job_company_website='".$value->data->job_company_website."',job_last_updated='".$value->data->job_last_updated."', job_start_date='".$value->data->job_start_date."'");




                    
                    foreach ($experience as $key => $val) {
                        $employer_city = $val->location_names;
                        if(!empty($employer_city))
                        {
                            $employer_city_data = $val->location_names[0];
                        }
                        DB::insert("insert into stu_candidate_experiences set candidate_id='".$candidate_id_value."',employer_name='".$val->company->name."', job_title='".$val->title->name."',employer_city='".$employer_city_data."', start_date='".$val->start_date."',end_date='".$val->end_date."', is_primary='".$val->is_primary."',facebook_url='".$val->company->facebook_url."', founded='".$val->company->founded."',industry='".$val->company->industry."', linkedin_url='".$val->company->linkedin_url."',twitter_url='".$val->company->twitter_url."', size='".$val->company->size."',website='".$val->company->website."'");
                        
                    }

                
                        
                        }
                    }

                }
                

       return response()->success(compact('items'));
         

  }

  public function postPrivatearea()
    {
        $title[] = Input::get('title');
        $skills[] = Input::get('skills');
        foreach($title as $val)
        {
        $job_titlee = $val['Job_title'];
        $experience_min = $val['minExperience'];
        $experience_max = $val['maxExperience'];
        $company = $val['company'];
        $country = $val['country'];
        $city = $val['city'];
        //$skill = $val['skill'];
        $industry = $val['industry'];
        $user_id = Input::get('user_id');
        }
       

        $gatvalue = NUll;

        
    
        $get = explode(" ", $job_titlee);

        $match_skill = DB::select("select * from stu_soft_skill where name LIKE '%".$get[0]."%'");
        if(count($match_skill) > 0)
        {
            $job_title = $get[1];
        }
        else{
            $job_title = $job_titlee;
        }
        
        if($experience_max != '' or !empty($experience_max))
        {
              $getdata = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata) && count($getdata) > 0)
            {
                $gatvalue = $getdata;
            }

            $getdata1 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('industry',$industry)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
         if(($getdata1) && count($getdata1) >0){
            $gatvalue = $getdata1;
         }
         
            
        $getdata2 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata2) && count($getdata2) >0){
                $gatvalue = $getdata2;
            }

       
        $getdata3 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata3) && count($getdata3) >0){
                    $gatvalue = $getdata3;
                }
                

        
        $getdata4 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata4) && count($getdata4) >0){
                    $gatvalue = $getdata4;
                }
        
            $getdata5 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata5) && count($getdata5) >0){
                $gatvalue = $getdata5;
            }
            
        
        

            $getdata6 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata6) && count($getdata6) >0){
                $gatvalue = $getdata6;
            }
            

       
            $getdata7 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata7) && count($getdata7) > 0)
            {
                $gatvalue = $getdata7;
            }
            
        
            $getdata8 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata8) && count($getdata8) > 0)
            {
                $gatvalue = $getdata8;
            }   
            
        
            $getdata14 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->where('location_region','like', '%'.$city.'%')->where('company_name','like', '%'.$company.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata14) && count($getdata14) >0){
                $gatvalue = $getdata14;
            }
        }
        else{
             $getdata = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata) && count($getdata) > 0)
        {
            $gatvalue = $getdata;
        }
        
        
        $getdata1 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('industry',$industry)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
         if(($getdata1) && count($getdata1) >0){
            $gatvalue = $getdata1;
         }
         
            
        $getdata2 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata2) && count($getdata2) >0){
                $gatvalue = $getdata2;
            }

       
        $getdata3 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata3) && count($getdata3) >0){
                    $gatvalue = $getdata3;
                }
                

        
        $getdata4 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata4) && count($getdata4) >0){
                    $gatvalue = $getdata4;
                }
        
            $getdata5 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata5) && count($getdata5) >0){
                $gatvalue = $getdata5;
            }
            
        
        

            $getdata6 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata6) && count($getdata6) >0){
                $gatvalue = $getdata6;
            }
            

       
            $getdata7 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata7) && count($getdata7) > 0)
            {
                $gatvalue = $getdata7;
            }
            
        
            $getdata8 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata8) && count($getdata8) > 0)
            {
                $gatvalue = $getdata8;
            }
            
        
            
        
            $getdata14 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->where('location_region','like', '%'.$city.'%')->where('company_name','like', '%'.$company.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata14) && count($getdata14) >0){
                $gatvalue = $getdata14;
            }
        }
        
        $dataget = $gatvalue;

        
            
        
            if(empty($job_title))
            {
                $job_title = "";
            }
            if(empty($experience_min))
            {
                $experience_min = "";
            }
            if(empty($experience_max))
            {
                $experience_max = "";
            }
            if(empty($company))
            {
                $company = "";
            }
            if(empty($industry))
            {
                $industry = "";
            }

            if(empty($country))
            {
                $country = "";
            }
            if(empty($city))
            {
                $city = "";
            }
            if(empty($skills))
            {
                $skills = "";
            }
            foreach($skills as $skill)

            {
                $skillval = implode(",", $skill);
            }
            //$skilldata = implode(",", $skills);
            //print_r($skillval);exit();
        DB::insert("insert into stu_private_area set user_id='".$user_id."',job_title='".$job_titlee."', min_experience='".$experience_min."',company='".$company."', country='".$country."',city='".$city."', skill='".$skillval."',industry='".$industry."',max_experience='".$experience_max."'");
        
        return response()->success(compact('dataget'));

    }
    public function postPrivateareainnersearch()
    {
        $item[] = Input::get('item');
       
        foreach($item as $val)
        {
        $job_titlee = $val['job_title'];
        $experience_min = $val['min_experience'];
        $experience_max = $val['max_experience'];
        $company = $val['company'];
        $country = $val['country'];
        $city = $val['city'];
        $industry = $val['industry'];
        $skills = $val['skill'];
        $user_id = Input::get('user_id');
        
        $id = Input::get('id');
        }
       

        $gatvalue = NUll;

        
    
        $get = explode(" ", $job_titlee);

        $match_skill = DB::select("select * from stu_soft_skill where name LIKE '%".$get[0]."%'");
        if(count($match_skill) > 0)
        {
            $job_title = $get[1];
        }
        else{
            $job_title = $job_titlee;
        }
        
        if($experience_max != '' or !empty($experience_max))
        {
              $getdata = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata) && count($getdata) > 0)
            {
                $gatvalue = $getdata;
            }

            $getdata1 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('industry',$industry)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
         if(($getdata1) && count($getdata1) >0){
            $gatvalue = $getdata1;
         }
         
            
        $getdata2 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata2) && count($getdata2) >0){
                $gatvalue = $getdata2;
            }

       
        $getdata3 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata3) && count($getdata3) >0){
                    $gatvalue = $getdata3;
                }
                

        
        $getdata4 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata4) && count($getdata4) >0){
                    $gatvalue = $getdata4;
                }
        
            $getdata5 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata5) && count($getdata5) >0){
                $gatvalue = $getdata5;
            }
            
        
        

            $getdata6 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata6) && count($getdata6) >0){
                $gatvalue = $getdata6;
            }
            

       
            $getdata7 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata7) && count($getdata7) > 0)
            {
                $gatvalue = $getdata7;
            }
            
        
            $getdata8 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata8) && count($getdata8) > 0)
            {
                $gatvalue = $getdata8;
            }   
            
        
            $getdata14 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->whereBetween('experience',[$experience_min,$experience_max])->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->where('location_region','like', '%'.$city.'%')->where('company_name','like', '%'.$company.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata14) && count($getdata14) >0){
                $gatvalue = $getdata14;
            }
        }
        else{
             $getdata = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata) && count($getdata) > 0)
        {
            $gatvalue = $getdata;
        }
        
        
        $getdata1 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('industry',$industry)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
         if(($getdata1) && count($getdata1) >0){
            $gatvalue = $getdata1;
         }
         
            
        $getdata2 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata2) && count($getdata2) >0){
                $gatvalue = $getdata2;
            }

       
        $getdata3 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata3) && count($getdata3) >0){
                    $gatvalue = $getdata3;
                }
                

        
        $getdata4 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
        if(($getdata4) && count($getdata4) >0){
                    $gatvalue = $getdata4;
                }
        
            $getdata5 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries',$country)->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata5) && count($getdata5) >0){
                $gatvalue = $getdata5;
            }
            
        
        

            $getdata6 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('company_name',$company)->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata6) && count($getdata6) >0){
                $gatvalue = $getdata6;
            }
            

       
            $getdata7 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('location_region',$city)->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata7) && count($getdata7) > 0)
            {
                $gatvalue = $getdata7;
            }
            
        
            $getdata8 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata8) && count($getdata8) > 0)
            {
                $gatvalue = $getdata8;
            }
            
        
            
        
            $getdata14 = StuCandidate::where("user_id",$user_id)->where('job_title','like', '%'.$job_title)->where('experience',$experience_min)->where('countries','like', '%'.$country.'%')->where('industry','like', '%'.$industry.'%')->where('location_region','like', '%'.$city.'%')->where('company_name','like', '%'.$company.'%')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get();
            if(($getdata14) && count($getdata14) >0){
                $gatvalue = $getdata14;
            }
        }
        
        $dataget = $gatvalue;
        return response()->success(compact('dataget'));

    }
    public function postPrivateareacandidates(){
        $user_id=Input::get('user_id');
       $getdata = StuCandidate::where('user_id',$user_id )->orderby('id','desc')->with('Candidate_Exp')->with('Candidate_Other')->with('Candidate_job')->get(); 
       return response()->success(compact('getdata'));
    }
    public function postPrivateareasearches(){
        $user_id=Input::get('user_id');
       $getdata = DB::select("select * from stu_private_area where user_id='".$user_id."'");
       foreach ($getdata as $key => $value) {
          $value->skills = explode(",", $value->skill);
       }
       return response()->success(compact('getdata'));
    }
    public function getAdmindashboards() {
        $gettotaluser = StuUser::select('*')->count();
        $getsubscription = StuSubscription::select('*')->count();
        $getcreaditused = StuCreadit::select('*')->sum('use_credit');
        $getcreadittotal = StuCreadit::select('*')->sum('total_credit');
        $gettotalcandidate = StuCandidate::select('*')->count();
        $admindata[] = array('totaluser'=>$gettotaluser,'subcription' =>$getsubscription,'usecredit' =>$getcreaditused,'totalcredit'=>$getcreadittotal,'totalcandidate' => $gettotalcandidate);
        return response()->success(compact('admindata'));
        
    }
    public function getCandidatetotalldatas() {
        $getdata = StuCandidate::select('id','full_name','job_title','experience','mobile_phone','emails','updated_at')->get();
        return response()->success(compact('getdata'));
        
    }
    public function getTotalusers() {
        $getdata = StuUser::select('*')->get();
        foreach ($getdata as $key => $value) {
            $value->totalcandidates = StuCandidate::select('*')->where('user_id',$value['id'])->count();
        }
        return response()->success(compact('getdata'));
        
    }
    public function getCreadituseds() {
        $getsubscription = StuUser::select('id','first_name','last_name','updated_at')->get();
        foreach ($getsubscription as $key => $value) {
            $value->totalcredit = StuCreadit::where('user_id',$value['id'])->sum('total_credit');
            $value->usedcredit = StuCreadit::where('user_id',$value['id'])->sum('use_credit');
            $value->remainingcredit = StuCreadit::where('user_id',$value['id'])->sum('remain_credit');
        }
        return response()->success(compact('getsubscription'));
        
    }
    public function getSubscriptiondetails() {
        $getsubscription = StuSubscriptionType::select('*')->get();
        foreach ($getsubscription as $key => $value) {
            $value->user = StuSubscription::where('subscription_type',$value['id'])->count('user_id');
            $total = $value['type'];
            if($total == 'Yellow Belt')
            {
                $value->amount = $value->user * $value['amount'];
            }
           
            else if($total == 'Orange Belt'){
                $value->amount = $value->user * $value['amount'];
            }
            else if($total == 'Green Belt'){
                $value->amount = $value->user * $value['amount'];
            }
        }
        return response()->success(compact('getsubscription'));
        
    }

    public function getTotalusercandidates() {
       // $user_id = 100;
        $getdata = StuCandidate::select('id','full_name','job_title','experience','mobile_phone','emails','updated_at','industry')->get();
        return response()->success(compact('getdata'));
        
    }
    
     public function postProfiledatas() {
        $user_id = Input::get('user_id');
        $getdata = StuUser::where('id',$user_id)->get();
        
        return response()->success(compact('getdata'));
        
    }
}