<?php

namespace App\Http\Controllers;
use DB;
use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\JobCitys;
use App\Activity;
use App\EmployerUserJobs;
use App\VendorUserJob;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use DateTime;
use DateInterval;
use App\VendorActivities;
use App\JobUsers;
use App\JobResumes;
use App\Candidate;
use App\CandidateSkillsets;
use App\CandidateOperationalSkills;
use App\CandidateSkills;
use App\CandidateExperiences;
use App\BellNotifications;
use App\CandidatePoints;
use App\CandidateEducations;
use App\CandidateSoftSkills;
use App\Company;
use App\JobSkills;
use App\Jobtitle;
use App\GdprData;
use App\City;
use App\Country;
use App\Association;
use App\Reason;
use App\Status;
use App\Industry;
use App\Language;
use App\JobLanguage;
use App\Pricing;
use App\EducationQualification;
use App\EducationAssociations;
use App\VendorRevenue;
use App\VendorRevenueRule;
use App\SharableUrls;
use App\VendorUserSetting;
use App\ShareLinkActivitys;
use Mail;
use GuzzleHttp\Client;
use Carbon\Carbon;
use App\VendorCandidateNotes;
use App\ReferFriends;
use App\DeviationRequests;
use App\Employeespectrums;
use App\CompaniesEmployer;
use App\SoftSkills;
use App\Colors;
use App\CollageNames;
use App\ActionWords;
use App\Http\Controllers\RchilliController;
use App\Models\SkillblockResume;
use App\Models\CandidateDetails;
use App\Predefinedquestionsanswers;
use App\Models\JobOrdersQuestionAnswer;
use Cache;

class JobsOrdersController extends Controller
{
     public function postCheckprofilevalidity()
    {
        //Getting Present Logged in User Details
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId = $authuser->parent_id;}
        else {$authId = $authuser->id;}
        //Getting Job Id from URL
        $job_id = Input::get('jobs');
        //Getting No of Vacancies available for the job from URL
        $vacancies=Input::get('positions');
        //Getting Candidate Id from URL
        $candidate_id = Input::get('candidateId');

        //Getting Joborder Data and filtering procedure
        $jobskills = JobOrders::where('id',$job_id)->get();
        //Job Title spliting for search in skills of candidate
        $job_title= !empty($jobskills[0]['name'])?$jobskills[0]['name']:'';

        //Filtering Prefered Skills From JD
        $prefered_skills= !empty($jobskills[0]['skills_preferred'])?$jobskills[0]['skills_preferred']:'';
        $prefered_skills = str_replace(",", " ", $prefered_skills);
        $prefered_skills = str_replace(" ,", " ", $prefered_skills);
        $prefered_skills = str_replace(", ", " ", $prefered_skills);
        $prefered_skills = str_replace("-", " ", $prefered_skills);
        $prefered_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $prefered_skills));
        //Creating array
        $prefered_skills = explode(" ", $prefered_skills);
        //Fitered Data after removing duplicates
        $prefered_skills = array_unique($prefered_skills);
        //Fitered Data after removing Empty keys
        $prefered_skills = array_filter($prefered_skills);
        //Max weightage calculatin
        if(count($prefered_skills) != 0){
        $max_weightage= (100/count($prefered_skills));
        }
        $pref_skills_count=sizeof($prefered_skills);

        //Filtering required Skills From JD
        $required_skills= !empty($jobskills[0]['skills_required'])?$jobskills[0]['skills_required']:'';
        $required_skills = str_replace(",", " ", $required_skills);
        $required_skills = str_replace(" ,", " ", $required_skills);
        $required_skills = str_replace(", ", " ", $required_skills);
        $required_skills = str_replace("-", " ", $required_skills);
        $required_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $required_skills));
        //Creating array
        $required_skills = explode(" ", $required_skills);
        //Fitered Data after removing duplicates
        $required_skills = array_unique($required_skills);
        //Fitered Data after removing Empty keys
        $required_skills = array_filter($required_skills);
        //Max weigtage for req skills
        if(count($required_skills) != 0){
        $max_req_weightage= (100/count($required_skills));
        }
        $req_skills_count=count($required_skills);
        //JD QUALITY Calculation
        $jd_quality_number=$req_skills_count + $pref_skills_count;
        if($jd_quality_number >= 15){
            $jd_quality_status='Very Detailed';
        }elseif ($jd_quality_number >= 9) {
            $jd_quality_status='Detailed';
        }elseif ($jd_quality_number >= 20) {
            $jd_quality_status='Excellent';
        }elseif ($jd_quality_number < 9) {
            $jd_quality_status='Not Detailed';
        }
        //JD Qualifications
        $jobqualifications=EducationAssociations::where('job_id',$job_id)->with('educations')->get();
        $job_qualification = array();
        foreach($jobqualifications as $qlfctions) {
            array_push($job_qualification, $qlfctions->educations->qualification);
        }
        //JobCitys data
        $jobcitys=JobCitys::where('job_id',$job_id)->with('citys')->get();

        $job_city = array();
        foreach($jobcitys as $j_citys) {
            array_push($job_city, $j_citys->citys->name);
        }
      
        //Job Qualification data
        $job_edu_sets = EducationAssociations::where('job_id',$job_id)->with("educations")->get();
         $job_edu_deatils = array();
        foreach($job_edu_sets as $j_edu) {
            array_push($job_edu_deatils, $j_edu->educations->qualification);
        }

        //All candidate_skill_sets
        $candidate_skill_sets = CandidateSkillsets::where('candidate_id',$candidate_id)->get();
        $candidate_skill_sets = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_skill_sets));
        $candidate_skill_sets = str_replace(",", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace(" ,", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace(", ", " ", $candidate_skill_sets);
        $candidate_skill_sets = str_replace("-", " ", $candidate_skill_sets);
        //Creating array
        $candidate_skill_sets = explode(" ", $candidate_skill_sets);
         //Fitered Data after removing duplicates
        $candidate_skill_sets = array_unique($candidate_skill_sets);
        //Fitered Data after removing Empty keys
        $candidate_skill_sets = array_filter($candidate_skill_sets);
        //Getting Candidate Operational Skills
        $candidate_operational_skills = CandidateOperationalSkills::where('candidate_id',$candidate_id)->get(['operational_skills']);

        //Getting Candidate Skills
        $candidate_skills = CandidateSkills::where('candidate_id',$candidate_id)->get(['skills']);
        //Getting Candidate Summary
        $candidate_summarys = Candidate::where('id',$candidate_id)->get(['full_name','email','job_profile','city','summary','executive_summary','management_summary','objectives','preferred_location','total_experience_in_year','qualification']);
        if(!empty($candidate_summarys[0]['total_experience_in_year']) && isset($candidate_summarys[0]['total_experience_in_year'])){
        $candidateExp=$candidate_summarys[0]['total_experience_in_year'];
        }else{
            $candidateExp = '';
        }

        //Getting Candidate Quaification
        $candidate_qualif=CandidateEducations::where('candidate_id',$candidate_id)->get(['degree']);
        $candidate_qualification = array();
            foreach($candidate_qualif as $can_qlfctions) {
                array_push($candidate_qualification, $can_qlfctions['degree']);
            }
        //Getting Candidate Experiences
        $candidate_titles=CandidateExperiences::where('candidate_id',$candidate_id)->get(['job_title']);
        $candidate_title_data = array();
            foreach($candidate_titles as $can_titls) {
                array_push($candidate_title_data, $can_titls['job_title']);
            }

        //Getting candidate summery Data
        $candidate_summary_data = !empty($candidate_summarys[0]['summary'])?$candidate_summarys[0]['summary']:'';

        //Getting executive summery Data
        $candidate_executive_summary_data = !empty($candidate_summarys[0]['executive_summary'])?$candidate_summarys[0]['executive_summary']:'';

        //Getting Candidate Preffered Location
        $candidate_prefered= !empty($candidate_summarys[0]['preferred_location'])?$candidate_summarys[0]['preferred_location']:'';
        $candidate_prefered = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_prefered));
        $candidate_prefered = str_replace(",", " ", $candidate_prefered);
        $candidate_prefered = str_replace(" ,", " ", $candidate_prefered);
        $candidate_prefered = str_replace(", ", " ", $candidate_prefered);
        $candidate_prefered = str_replace("-", " ", $candidate_prefered);
        //Creating array
        $candidate_prefered = explode(" ", $candidate_prefered);
         //Fitered Data after removing duplicates
        $candidate_prefered = array_unique($candidate_prefered);
        //Fitered Data after removing Empty keys
        $candidate_prefered = array_filter($candidate_prefered);

        //Filtering Candidate operational_skills Data
        $operational_skills =  !empty($candidate_operational_skills[0]['operational_skills'])?$candidate_operational_skills[0]['operational_skills']:'';
        $operational_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $operational_skills));
        $operational_skills = str_replace(",", " ", $operational_skills);
        $operational_skills = str_replace(" ,", " ", $operational_skills);
        $operational_skills = str_replace(", ", " ", $operational_skills);
        $operational_skills = str_replace("-", " ", $operational_skills);
        //Creating array
        $operational_skills = explode(" ", $operational_skills);
         //Fitered Data after removing duplicates
        $operational_skills = array_unique($operational_skills);
        //Fitered Data after removing Empty keys
        $operational_skills = array_filter($operational_skills);

        //Filtering candidate skills Data
        $candidate_skills = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_skills));
        $candidate_skills = str_replace(",", " ", $candidate_skills);
        $candidate_skills = str_replace(". ", " ", $candidate_skills);
        $candidate_skills = str_replace(".", " ", $candidate_skills);
        $candidate_skills = str_replace(" ,", " ", $candidate_skills);
        $candidate_skills = str_replace(", ", " ", $candidate_skills);
        $candidate_skills = str_replace("-", " ", $candidate_skills);
        //Creating array
        $candidate_skills = explode(" ", $candidate_skills);
         //Fitered Data after removing duplicates
        $candidate_skills = array_unique($candidate_skills);
        //Fitered Data after removing Empty keys
        $candidate_skills = array_filter($candidate_skills);
        
        //Filtering candidate summary Data
        $candidate_summary=$candidate_summary_data;
        $candidate_summary = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_summary));
        $candidate_summary = str_replace(",", " ", $candidate_summary);
        $candidate_summary = str_replace(". ", " ", $candidate_summary);
        $candidate_summary = str_replace(".", " ", $candidate_summary);
        $candidate_summary = str_replace(" ,", " ", $candidate_summary);
        $candidate_summary = str_replace(", ", " ", $candidate_summary);
        $candidate_summary = str_replace("-", " ", $candidate_summary);
        //Creating array
        $candidate_summary = explode(" ", $candidate_summary);
         //Fitered Data after removing duplicates
        $candidate_summary = array_unique($candidate_summary);
        //Fitered Data after removing Empty keys
        $candidate_summary = array_filter($candidate_summary);
        //Filtering candidate executive summary_data Data
        $candidate_exe_summary=$candidate_executive_summary_data;
        $candidate_exe_summary = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_exe_summary));
        $candidate_exe_summary = str_replace(",", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(". ", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(".", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(" ,", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace(", ", " ", $candidate_exe_summary);
        $candidate_exe_summary = str_replace("-", " ", $candidate_exe_summary);
        //Creating array
        $candidate_exe_summary = explode(" ", $candidate_exe_summary);
         //Fitered Data after removing duplicates
        $candidate_exe_summary = array_unique($candidate_exe_summary);
        //Fitered Data after removing Empty keys
        $candidate_exe_summary = array_filter($candidate_exe_summary);
        //Filtering candidate Objective Data
        $candidate_objectives = !empty($candidate_summarys[0]['objectives'])?$candidate_summarys[0]['objectives']:'';
        $candidate_objectives = strtolower(str_replace( array( "&", "!", '"', ".", "'", "?", "\r", "\n" ), '', $candidate_objectives));
        $candidate_objectives = str_replace(",", " ", $candidate_objectives);
        $candidate_objectives = str_replace(". ", " ", $candidate_objectives);
        $candidate_objectives = str_replace(".", " ", $candidate_objectives);
        $candidate_objectives = str_replace(" ,", " ", $candidate_objectives);
        $candidate_objectives = str_replace(", ", " ", $candidate_objectives);
        $candidate_objectives = str_replace("-", " ", $candidate_objectives);
        //Creating array
        $candidate_objectives = explode(" ", $candidate_objectives);
         //Fitered Data after removing duplicates
        $candidate_objectives = array_unique($candidate_objectives);
        //Fitered Data after removing Empty keys
        $candidate_objectives = array_filter($candidate_objectives);
        $lst_count = array();
        $lst_count_req = array();
        $a=0;
             reset($required_skills);
             foreach($required_skills as $key=>$val){
            $weigtage_req=0;
            $req_opr_skills=0;
            $req_can_skills=0;
            $req_summ_skills=0;
            $req_objective_skills=0;
            $req_exe_summary_skills=0;
            $req_skill_value=$val;
            $req_skill_key=$key;
             if(count($operational_skills) > 0) {
             reset($operational_skills);
             foreach($operational_skills as $key=>$val){
                    $operational_skill_value=$val;
                    $operational_skill_key=$key;
                    if(strcasecmp($operational_skill_value,$req_skill_value)==0 ||
                         strcasecmp($req_skill_value,$operational_skill_value)==0)
                    {
                        $req_opr_skills=1;
                    }
                }
            }
             foreach($candidate_skills as $key=>$val){
                $candidate_skill_value=$val;
                $candidate_skill_key=$key;
                if(strcasecmp($candidate_skill_value,$req_skill_value)==0 ||
                  strcasecmp($req_skill_value,$candidate_skill_value)==0)
                {
                 $req_can_skills=1;

                }
            }
            reset($candidate_summary);

            foreach($candidate_summary as $key=>$val){
                $candidate_summary_value=$val;
                $candidate_summary_key=$key;
                if(strcasecmp($candidate_summary_value,$req_skill_value)==0 ||
                  strcasecmp($req_skill_value,$candidate_summary_value)==0)
                {
                   $req_summ_skills=1;

                }
            }
            if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                reset($candidate_exe_summary);
                foreach($candidate_exe_summary as $key=>$val)
                {
                    $candidate_exe_summary_value=$val;
                    $candidate_exe_summary_key=$key;
                if(strcasecmp($candidate_exe_summary_value,$req_skill_value) ==0 || strcasecmp($req_skill_value,$candidate_exe_summary_value) == 0)
                    {
                        $req_exe_summary_skills=1;
                    }
                }
            }
            if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                reset($candidate_objectives);
                foreach($candidate_objectives as $key=>$val)
                {
                    $candidate_objectives_value=$val;
                    $candidate_objectives_key=$key;
                    if(strcasecmp($candidate_objectives_value,$req_skill_value)==0 ||
                      strcasecmp($req_skill_value,$candidate_objectives_value)==0)
                    {
                        $req_objective_skills=1;
                    }
                }
            }

            if($req_opr_skills ==1 && $req_can_skills == 1 && $req_summ_skills ==1)
            {
                $weigtage_req=$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 1 && $req_summ_skills ==1)
            {
                $weigtage_req=(75/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==1)
            {
                $weigtage_req=(50/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 1 && $req_summ_skills ==0)
            {
                $weigtage_req=(50/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 0 && $req_summ_skills ==0)
            {
                $weigtage_req=(85/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 0 && $req_summ_skills ==1)
            {
                $weigtage_req=(93/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==1 && $req_can_skills == 1 && $req_summ_skills ==0)
            {
                $weigtage_req=(93/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_objective_skills == 1)
            {
                $weigtage_req=(15/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_exe_summary_skills == 1)
            {
                $weigtage_req=(15/100)*$max_req_weightage;
            }
            else if($req_opr_skills ==0 && $req_can_skills == 0 && $req_summ_skills ==0 && $req_exe_summary_skills == 0)
            {
                $weigtage_req="No data found in any of the tables ";
            }else{
                $weigtage_req="Please Contact Admin";
            }

          unset($required_skills[$req_skill_key]);
          $lst_count_req[] = $weigtage_req;
        }
        $required_skills_percentage=array_sum($lst_count_req);
        reset($prefered_skills);
        foreach($prefered_skills as $key=>$val){
            $weigtage=0;
            $pref_opr_skills=0;
            $pref_can_skills=0;
            $pref_summ_skills=0;
            $pref_objective_skills=0;
            $pref_exe_summary_skills=0;
            $prefered_skill_value=$val;
            $prefered_skill_key=$key;
            if(count($operational_skills) > 0) {
                reset($operational_skills);
                foreach($operational_skills as $key=>$val){
                    $operational_skill_value=$val;
                    $operational_skill_key=$key;
                    if(strcasecmp($operational_skill_value,$prefered_skill_value)==0 ||
                         strcasecmp($prefered_skill_value,$operational_skill_value)==0)
                    {
                        $pref_opr_skills=1;
                    }
                }
            }
          
                  foreach($candidate_skills as $key=>$val)
                {
                    $candidate_skill_value=$val;
                    $candidate_skill_key=$key;
                    if(strcasecmp($candidate_skill_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_skill_value)==0)
                    {
                     $pref_can_skills=1;
                    }
                }

                  reset($candidate_summary);
                  foreach($candidate_summary as $key=>$val){
                    $candidate_summary_value=$val;
                    $candidate_summary_key=$key;
                    if(strcasecmp($candidate_summary_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_summary_value)==0)
                    {
                       $pref_summ_skills=1;
                    }
                }
            
            if(count($candidate_exe_summary) > 0 && $pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
                reset($candidate_exe_summary);
                foreach($candidate_exe_summary as $key=>$val)
                {
                    $candidate_exe_summary_value=$val;
                    $candidate_exe_summary_key=$key;
                    if(strcasecmp($candidate_exe_summary_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_exe_summary_value)==0)
                    {
                        $pref_exe_summary_skills=1;
                    }
                }
           }
           if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
                reset($candidate_objectives);
               foreach($candidate_objectives as $key=>$val) 
                {
                    $candidate_objectives_value=$val;
                    $candidate_objectives_key=$key;
                    if(strcasecmp($candidate_objectives_value,$prefered_skill_value)==0 ||
                      strcasecmp($prefered_skill_value,$candidate_objectives_value)==0)
                    {
                        $pref_objective_skills=1;
                    }
                }
           }

           if($pref_opr_skills ==1 && $pref_can_skills == 1 && $pref_summ_skills ==1)
           {
            $weigtage=$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 1 && $pref_summ_skills ==1)
           {
            $weigtage=(75/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==1)
           {
            $weigtage=(50/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 1 && $pref_summ_skills ==0)
           {
            $weigtage=(50/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 0 && $pref_summ_skills ==0)
           {
            $weigtage=(85/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 0 && $pref_summ_skills ==1)
           {
            $weigtage=(93/100)*$max_weightage;
           }
           else if($pref_opr_skills ==1 && $pref_can_skills == 1 && $pref_summ_skills ==0)
           {
            $weigtage=(93/100)*$max_weightage;
           }
           else if(($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_objective_skills == 1) ||($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_exe_summary_skills == 1))
           {
            $weigtage=(15/100)*$max_weightage;
           }
           else if($pref_opr_skills ==0 && $pref_can_skills == 0 && $pref_summ_skills ==0 && $pref_exe_summary_skills == 0)
           {
            $weigtage="No data found in any of the tables";
           }

          unset($prefered_skills[$prefered_skill_key]);
          $lst_count[] = $weigtage;
        }

        $prefered_skills_percentage=array_sum($lst_count);
        $job_city_match=0;
        if(count($candidate_prefered)!=0){
            foreach($job_city as $key=>$val) {
                $job_city_value=$val;
                reset($candidate_prefered);
                foreach($candidate_prefered as $key=>$val) {
                    $candidate_prefered_value=$val;
                    $candidate_prefered_key=$key;
                    if(strcasecmp($candidate_prefered_value, $job_city_value)==0)
                    {
                        $job_city_match=1;
                    }
                    if(strcasecmp($job_city_value,$candidate_prefered_value)==0)
                    {
                        $job_city_match=1;
                    }
                }
            }
        }

        //After Adding candidate qualification when user submit candidate for Vendor assigned job
        $qualification_point_value=0;
        $qualification_points=0;
        if(count($job_edu_deatils) > 0 ) {
            reset($job_edu_deatils);
             foreach($job_edu_deatils as $key=>$val) {
               $job_edu_deatils_value=$val;
              $job_edu_deatils_key=$key;
              $cand_summary_quali  = !empty($candidate_summarys[0]['qualification'])?$candidate_summarys[0]['qualification']:'';
              if((strcasecmp($job_edu_deatils_value,$cand_summary_quali)== 0 )|| 
                         (strcasecmp($cand_summary_quali,$job_edu_deatils_value)== 0))
                      {

                        $qualification_points=$qualification_points+20;
                      }elseif($qualification_points == 0){
                        $qualification_points=8;

                }
                }
        }
        if($qualification_points >20){
            $qualification_points=20;
        }
        
        //Experiance Points
        if($candidateExp != null || $candidateExp != 0){
            if($jobskills[0]['experience'] <= $candidateExp){
            $exp_match_points=20;
            }else{$exp_match_points=5;}
        }else{
            $exp_match_points=5;
        }

        //Required Skills Points
        if($required_skills_percentage){
            $req_skills_points=0;
            if($required_skills_percentage < 20){
             $req_skills_points=5;
            }elseif ($required_skills_percentage >= 20 && $required_skills_percentage <= 50) {
                $req_skills_points=10;
            }elseif ($required_skills_percentage > 50 && $required_skills_percentage <= 80) {
                $req_skills_points=15;
            }elseif ($required_skills_percentage > 80 && $required_skills_percentage <= 100) {
                $req_skills_points=20;
            }
        }else{$req_skills_points=0;}

        //Preffered City( Location) Points
        if($job_city_match==1){
        $location_match_points=20;
        }else{
            $location_match_points=10;
        }

        //Preffered skills Points
        if($prefered_skills_percentage){
            $pref_skills_points=0;
            if($prefered_skills_percentage < 20){
             $pref_skills_points=5;
            }elseif ($prefered_skills_percentage >= 20 && $prefered_skills_percentage <= 50) {
                $pref_skills_points=10;
            }elseif ($prefered_skills_percentage > 50 && $prefered_skills_percentage <= 80) {
                $pref_skills_points=15;
            }elseif ($prefered_skills_percentage > 80 && $prefered_skills_percentage <= 100) {

                $pref_skills_points=20;
            }
        }
        else{$pref_skills_points=5;}

        //Position Matching Points
        $position_point_value=0;
        $job_title_points=0;
        if(count($candidate_title_data) > 0) {
            reset($candidate_title_data);

            foreach($candidate_title_data as $key=>$val) {
               $candidate_title_data_sets_value=$val;
              $candidate_title_data_sets_key=$key;
                $job_title = strtolower(str_replace( array( " /","*"," *","* ", "/ ","/", '[', "]", " [","[ ","(",")" ), '', $job_title));
                    if(strpos($job_title, $candidate_title_data_sets_value) > 0 || strpos($candidate_title_data_sets_value, $job_title) > 0)
                      {
                        $job_title_points=$job_title_points+20;
                      }
                      if($job_title_points == 0){
                        $job_title_points=10;
                      }
                }
        }else{
               $job_title_points=5;
        }
        if($job_title_points > 20){
           $job_title_points=20;
        }
        $required_skills_points=$req_skills_points;
        $preferred_skills_points=$pref_skills_points;
        $location_points=$location_match_points;
        $position_points=$job_title_points;
        $experience_points=$exp_match_points;

        $total_points=$req_skills_points+$pref_skills_points+$location_match_points+$job_title_points+$exp_match_points+$qualification_points;
        if($total_points >=100 && $total_points <= 120 ){
        //If no of total points are more then 100 but below 120:  Excellent Match
          $over_all_status="Excellent Match";
        }elseif ($total_points <=99 && $total_points >= 70 ) {
        //If no of points are less than or equal 99 but more then 70 : Good Match

          $over_all_status="Good Match";
        }elseif ($total_points <=69 && $total_points >= 50 ) {
        //If no of points is less or equal to 69 or equalling   but less than 50 :  Moderate Match
         $over_all_status="Moderate Match";
        }elseif ($total_points <=49 && $total_points >= 30 ) {
        //If no of points is less or equal 49 or but not less than 30 : Average  Match
        $over_all_status="Average Match";
        }
        elseif ($total_points <=29) {
        //If no of points is less, then or equalling   29:  Poor Match
         $over_all_status="Poor Match";
        }
        $skills_data_array=array($pref_skills_points,$req_skills_points,$location_match_points,$job_title_points,$exp_match_points,$qualification_points);
        $skills_matched  = count( array_keys( $skills_data_array, 20 ));

        $can_edu=!empty($candidate_summarys[0]['qualification'])?$candidate_summarys[0]['qualification']:'';
        $can_skills_count=count($operational_skills);
        $can_name=!empty($candidate_summarys[0]['full_name'])?$candidate_summarys[0]['full_name']:'';
        $can_email=!empty($candidate_summarys[0]['email'])?$candidate_summarys[0]['email']:'';
        $can_title=!empty($candidate_summarys[0]['job_profile'])?$candidate_summarys[0]['job_profile']:'';
        $can_location=!empty($candidate_summarys[0]['city'])?$candidate_summarys[0]['city']:'';
        $can_summary= !empty($candidate_summarys[0]['summary'])?$candidate_summarys[0]['summary']:'';
        $can_exe_summ=!empty($candidate_summarys[0]['executive_summary'])?$candidate_summarys[0]['executive_summary']:'';
        $can_mngmnt_summ=!empty($candidate_summarys[0]['management_summary'])?$candidate_summarys[0]['management_summary']:'';
        
        if($can_edu != '' && $can_skills_count > 10 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && $can_summary != '' && $can_mngmnt_summ != '' && $can_exe_summ != ''){
            $cv_quality ='Excellent';
        }elseif ($can_edu != '' && $can_skills_count > 5 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && ($can_summary != '' || $can_mngmnt_summ != '' || $can_exe_summ != '')) {
            $cv_quality='Moderate';
        }elseif ($can_edu != '' && $can_skills_count > 3 && $can_name != '' && $can_email != '' && $can_title != '' && $can_location != '' && ($can_summary != '' || $can_mngmnt_summ != '' || $can_exe_summ != '')) {
           $cv_quality='Fair';
        }else{
            $cv_quality='Poor';
        }

        $candidatepoints = new CandidatePoints();
                            $candidatepoints->job_id = $job_id;
                            $candidatepoints->candidate_id = $candidate_id;
                            $candidatepoints->required_skills_points = $required_skills_points;
                            $candidatepoints->preferred_skills_points = $preferred_skills_points;
                            $candidatepoints->location_points = $location_points;
                            $candidatepoints->experience_points = $experience_points;
                            $candidatepoints->position_points = $position_points;
                            $candidatepoints->qualification_points = $qualification_points;
                            $candidatepoints->total_points = $total_points;
                            $candidatepoints->over_all_status = $over_all_status;
                            $candidatepoints->jd_required_skills_count=$req_skills_count;
                            $candidatepoints->jd_preferred_skills_count=$pref_skills_count;
                            $candidatepoints->jd_all_skills_count=$jd_quality_number;
                            $candidatepoints->jd_quality_status=$jd_quality_status;
                            //$candidatepoints->cv_quality_status=$cv_quality;
        $candidatepoints->save();
        $employer_id = JobOrders::where('id',$job_id)->first()->user_id;
        $accountmanager_id = Association::where('vendor_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->where('employer_id',$employer_id)
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->where('job_id',$job_id)
                                    ->whereNull('candidate_id')
                                    ->first()->accountmanager_id;

        $assignedJob= association::where('vendor_id',$authId)
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('employer_id',$employer_id)
                                    ->where('job_id',$job_id)
                                    ->where('candidate_id',$candidate_id)
                                    ->count();
          return response()->success(compact('assignedJob'));
    }

    public function postSubmitcandidatesuserlist()
    {
        $authuser = Auth::user();
        $job_id = Input::get('jobs');
        $vacancies=Input::get('positions');
        $candidate_id = Input::get('candidateId');
        $employer_id = JobOrders::where('id',$job_id)->first()->user_id;

        $accountmanager_id = Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;

         $assignedJob= association::where('vendor_id',$authuser->parent_id)
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            ->where('candidate_id',$candidate_id)
                            ->count();
         $countResumes= association::where('vendor_id',$authuser->parent_id)
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$employer_id)
                            ->where('job_id',$job_id)
                            /*->where('job_id',$job_id)*/
                            ->whereNotNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->count();


                       $a= (int)$vacancies;
        if($countResumes<($a * 3)) {
            if($assignedJob==0) {
                    $candidateassociation = new Association();
                    $candidateassociation->admin_id = 1;
                    $candidateassociation->accountmanager_id = $accountmanager_id;
                    $candidateassociation->employer_id = $employer_id;
                    $candidateassociation->vendor_id =$authuser->parent_id;
                    $candidateassociation->job_id = $job_id;
                    $candidateassociation->candidate_id = $candidate_id;
                    $candidateassociation->candidate_status = 19;
                    $candidateassociation->status_updated_by = $authuser->parent_id;
                    $candidateassociation->save();


                    $candidateactivity = new Activity();
                    $candidateactivity->name = "Profile Submitted to Account Manager";
                    $candidateactivity->admin_id = 1;
                    $candidateactivity->accountmanager_id = $accountmanager_id;
                    $candidateactivity->employer_id = $employer_id;
                    $candidateactivity->vendor_id = $authuser->parent_id;
                    $candidateactivity->job_id = $job_id;
                    $candidateactivity->candidate_id = $candidate_id;
                    $candidateactivity->candidate_status = 19;
                    $candidateactivity->activity_by = $authuser->parent_id;
                    $candidateactivity->save();

                    $candidateassociation = new Association();
                    $candidateassociation->admin_id = 1;
                    $candidateassociation->accountmanager_id = $accountmanager_id;
                    $candidateassociation->employer_id = $employer_id;
                    $candidateassociation->vendor_id =$authuser->id;
                    $candidateassociation->job_id = $job_id;
                    $candidateassociation->candidate_id = $candidate_id;
                    $candidateassociation->candidate_status = 19;
                    $candidateassociation->status_updated_by = $authuser->id;
                    $candidateassociation->save();


                    $candidateactivity = new Activity();
                    $candidateactivity->name = "Profile Submitted to Account Manager";
                    $candidateactivity->admin_id = 1;
                    $candidateactivity->accountmanager_id = $accountmanager_id;
                    $candidateactivity->employer_id = $employer_id;
                    $candidateactivity->vendor_id = $authuser->id;
                    $candidateactivity->job_id = $job_id;
                    $candidateactivity->candidate_id = $candidate_id;
                    $candidateactivity->candidate_status = 19;
                    $candidateactivity->activity_by = $authuser->id;
                    $candidateactivity->save();

                    $jobresume = new JobResumes();
                    $jobresume->job_id = $job_id;
                    $jobresume->candidate_id = $candidate_id;
                    $jobresume->is_verified = 0;
                    $jobresume->save();
                    $jobResumeResponse = response()->success(compact('jobresume'));

                    // Update vendor revenue table default revenue value.
                     $vendorRevenue = VendorRevenue::where('vendor_id',$authuser->parent_id)
                                        ->where('job_id',$job_id)
                                        ->where('default_revenue',0)
                                        ->whereNotNull('est_revenue_1')
                                        ->whereNotNull('est_revenue_2')
                                        ->whereNotNull('est_revenue_3')
                                        ->whereNotNull('est_revenue_4')
                                        ->whereNotNull('est_revenue_5')
                                        ->first();

                    if(count($vendorRevenue) == 1) {
                        $carbon_date = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy5 = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy24 = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy7d = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy30d = Carbon::parse($vendorRevenue->created_at);
                        $dateCopy5->addHours(5);
                        $dateCopy24->addHours(24);
                        $dateCopy7d->addHours(168);
                        $dateCopy30d->addHours(720);
                        if(Carbon::now()->gt($dateCopy30d)) {
                            //After 30 days
                             $revenueData = ['default_revenue' => 5];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if((Carbon::now()->gt($dateCopy7d)) && (Carbon::now()->lt($dateCopy30d))) {
                            //After 7 Days
                             $revenueData = ['default_revenue' => 4];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if((Carbon::now()->gt($dateCopy24)) && (Carbon::now()->lt($dateCopy7d))) {
                            //After 24 hrs
                             $revenueData = ['default_revenue' => 3];
                             $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if ( (Carbon::now()->gt($dateCopy5)) && (Carbon::now()->lt($dateCopy24))) {
                            //After 5 hrs before 24 hrs
                            $revenueData = ['default_revenue' => 2];
                            $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->parent_id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        } else if (Carbon::now()->lt($dateCopy5)) {
                            //Within 5 hrs
                            $revenueData = ['default_revenue' => 1];
                            $vendorassignedjobs = VendorRevenue::where('job_id',$job_id)
                                                ->where('vendor_id',$authuser->parent_id)
                                                ->whereNotNull('est_revenue_1')
                                                ->whereNotNull('est_revenue_2')
                                                ->whereNotNull('est_revenue_3')
                                                ->whereNotNull('est_revenue_4')
                                                ->whereNotNull('est_revenue_5')
                                                ->update($revenueData);
                        }

                    }// Check if records are empty

                   //Insert Successfull candidate submission activity record
                     $newjobResume = Activity::create([
                        'person_id' => $authuser->parent_id,
                        'resume_id' => $candidate_id,
                        'name' => 'Profile submitted successfully.',
                     ]);

                        if(Input::get('vendorchecklist')):
                           $vendorchecklist = Input::get('vendorchecklist');
                           foreach($vendorchecklist as $emp):
                            $checklistassociation = new Association();
                            $checklistassociation->admin_id = 1;
                            $checklistassociation->job_id = $job_id;
                            $checklistassociation->candidate_id = $candidate_id;
                            $checklistassociation->employer_id = $employer_id;
                            $checklistassociation->accountmanager_id = $accountmanager_id;
                            $checklistassociation->vendor_checklist_id = $emp['id'];
                            $checklistassociation->save();

                            $checklistactivity = new Activity();
                            $checklistactivity->name = $emp['name'];
                            $checklistactivity->admin_id = 1;
                            $checklistactivity->accountmanager_id = $accountmanager_id;
                            $checklistactivity->employer_id = $employer_id;
                            $checklistactivity->vendor_id = $authuser->parent_id;
                            $checklistactivity->job_id = $job_id;
                            $checklistactivity->candidate_id = $candidate_id;
                            $checklistactivity->candidate_status = 19;
                            $checklistactivity->activity_by = $authuser->parent_id;
                            $checklistactivity->vendor_checklist_id = $emp['id'];
                            $checklistactivity->save();

                            $checklistactivity = new Activity();
                            $checklistactivity->name = $emp['name'];
                            $checklistactivity->admin_id = 1;
                            $checklistactivity->accountmanager_id = $accountmanager_id;
                            $checklistactivity->employer_id = $employer_id;
                            $checklistactivity->vendor_id = $authuser->id;
                            $checklistactivity->job_id = $job_id;
                            $checklistactivity->candidate_id = $candidate_id;
                            $checklistactivity->candidate_status = 19;
                            $checklistactivity->activity_by = $authuser->id;
                            $checklistactivity->vendor_checklist_id = $emp['id'];
                            $checklistactivity->save();
                           endforeach;
                         endif;


                $empAm = Association::where('vendor_id',$authuser->parent_id)
                                ->where('accountmanager_id',$accountmanager_id)
                                ->whereNotNull('employer_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_user_id')
                                ->where('job_id',$job_id)
                                ->whereNull('candidate_id')
                                ->with('accountmanager')
                                ->get();

                $candidate_info = Candidate::where('id', $candidate_id)->first();

                 Mail::send('emails.notifyInterestingCandidates', ['profileName' => $candidate_info->full_name, 'profileLocation' => $candidate_info->city, 'profileIndustry' => $candidate_info->job_profile], function ($m) use($empAm){
                 $m->to($empAm[0]->accountmanager->email, 'New Profile Submitted')->subject('New profile has been submitted');
                  });

                 $newjobResumeResponse = response()->success(compact('newjobResume'));
                 return $jobResumeResponse;
            }
            else{
                return response()->error("This Profile Already Submitted to Employer ,Please Try With different profile");
            }
        } else{
            return response()->error("You've already submitted the maximum number of profiles for the job ($job_id)");
        }
    }

    public function getVendorassignedclosedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $b = array();
        $authId = $assigntovUser = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');

              foreach($a as $c){array_push($b, $c);}
              $vendorassignedclosedjobs=Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',6);})
                            ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedclosedjobs = Association::where('vendor_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        }
        foreach ($vendorassignedclosedjobs as $job) {
            $note=Activity::where('job_id',intval($job['job_id']))->where('job_status',6)
                                ->get(['note']);
            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                ->whereNotNull('employer_id')
                                ->where('admin_id',1)
                                ->where('job_id',intval($job['job_id']))
                                ->whereNotNull('accountmanager_id')
                                ->where('activity_by',$authuser->id)
                                ->whereNotNull('status_id')
                                ->where('is_vendor_sourcing_activity',1)
                                ->with('activityuser.role','status','candidate')
                                ->with('job')
                                ->with('sourcingStatus')
                                ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted ,'note'=>$note];
            $job['numbers'] = $numbers;
        } //foreach
        return response()->success(compact('vendorassignedclosedjobs'));
    }

    public function getVendorassignedclosedjobsall()
    {
        $authuser = Auth::user();
        $b = array();
        $authId = $assigntovUser = null;
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');

              foreach($a as $c){array_push($b, $c);}
              $vendorassignedclosedjobsall=Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',6);})
                            ->get();
        } else {
            $authId = $authuser->id;
            $vendorassignedclosedjobsall = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        }
        foreach ($vendorassignedclosedjobsall as $job) {
            $note=Activity::where('job_id',intval($job['job_id']))->where('job_status',6)
                                ->get(['note']);
            $vendorSourcingStatus=Activity::select('vendor_id')->where('vendor_id',$authuser->id)
                                ->whereNotNull('employer_id')
                                ->where('admin_id',1)
                                ->where('job_id',intval($job['job_id']))
                                ->whereNotNull('accountmanager_id')
                                ->where('activity_by',$authuser->id)
                                ->whereNotNull('status_id')
                                ->where('is_vendor_sourcing_activity',1)
                                ->with('activityuser.role','status','candidate')
                                ->with('job')
                                ->with('sourcingStatus')
                                ->count();
            /*$vendorAcceptedAt=Activity::select('vendor_id')->where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();*/
            $receivedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
            $rejectedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            /*if(count($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}*/
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted ,'note'=>$note];
            $job['numbers'] = $numbers;
        } //foreach
        return response()->success(compact('vendorassignedclosedjobsall'));
    }

    public function getVendorassignedrejectedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $vendorassignedrejectedjobs = Association::where('vendor_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_status',[1,2,30])
                            ->with('job.JobType')
                            ->with('job_status')
                            ->with('job.status')
                            ->get();
        foreach ($vendorassignedrejectedjobs as $job) {
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->get();
            if(count($estimaterevenue) == 1) {
            foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
            }}

            if(count($estimaterevenue) > 1) {
                $finalRev=0;
                $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->where('vendor_id',$authId)->get();
                $jobassign=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                                   // print_r($jobassign);
                $firstprofile=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
                    if(count($firstprofile) > 0) {
                        $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                        $from = \Carbon\Carbon::parse($firstprofile[0]->created_at);
                        $diff_in_minutes = $to->diffInMinutes($from);
                        if(!$diff_in_minutes) {
                            $diff_in_minutes=$to->diffInSeconds($from);
                            if($diff_in_minutes<=59) $diff_in_minutes=1;
                        }
                        $estimaterevenue[0]['first_profile_submitted_in'] = $diff_in_minutes;
                        if($finalRev)
                            {$estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    } else {
                        $estimaterevenue[0]['first_profile_submitted_in'] = 0;
                        if($finalRev)
                            { $estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    }
                }
            }

            $acceptDate1=Activity::where('name','Vendor Rejected job')
                                    ->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->get(['created_at']);

            if(count($acceptDate1) > 0){$acceptDate= $acceptDate1[0]['created_at'];}
            else{$acceptDate=null; }

            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('employer_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}

            $job['numbers'] = array('vendorSourcing'=>$vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'est'=>$estimaterevenue,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles);$rejecteddate = ['rejecteddate'=>$acceptDate];$job['rejecteddate']=$rejecteddate;
        }//foreach
        return response()->success(compact('vendorassignedrejectedjobs'));
    }

    public function getVendorassignedrejectedjobsall($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $vendorassignedrejectedjobsall = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_status',[1,2,30])
                            ->with('job.JobType')
                            ->with('job_status')
                            ->with('job.status')
                            ->get();
        foreach ($vendorassignedrejectedjobsall as $job) {
            if($authuser->parent_id){ $authId=$authuser->parent_id; }
            else { $authId=$authuser->id; }

            $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->get();
            if(count($estimaterevenue) == 1) {
            foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
            }}

            if(count($estimaterevenue) > 1) {
                $finalRev=0;
                $estimaterevenue=VendorRevenue::where('job_id',$job->job_id)->where('vendor_id',$authId)->get();
                $jobassign=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                                   // print_r($jobassign);
                $firstprofile=Activity::where('job_id',$job->job_id)
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->orderBy('created_at', 'asc')
                                    ->get();
                foreach ($estimaterevenue as $rev) {
                $rev->est_revenue_1=round(intval($rev->est_revenue_1));
                $rev->est_revenue_2=round(intval($rev->est_revenue_2));
                $rev->est_revenue_3=round(intval($rev->est_revenue_3));
                $rev->est_revenue_4=round(intval($rev->est_revenue_4));
                $rev->est_revenue_5=round(intval($rev->est_revenue_5));
                    if(count($firstprofile) > 0) {
                        $to = \Carbon\Carbon::parse($jobassign[0]->created_at);
                        $from = \Carbon\Carbon::parse($firstprofile[0]->created_at);
                        $diff_in_minutes = $to->diffInMinutes($from);
                        if(!$diff_in_minutes) {
                            $diff_in_minutes=$to->diffInSeconds($from);
                            if($diff_in_minutes<=59) $diff_in_minutes=1;
                        }
                        $estimaterevenue[0]['first_profile_submitted_in'] = $diff_in_minutes;
                        if($finalRev)
                            {$estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    } else {
                        $estimaterevenue[0]['first_profile_submitted_in'] = 0;
                        if($finalRev)
                            { $estimaterevenue[0]['final_revenue']=round(intval($finalRev)); }
                    }
                }
            }

            $acceptDate1=Activity::where('name','Vendor Rejected job')
                                    ->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->get(['created_at']);

            if(count($acceptDate1) > 0){$acceptDate= $acceptDate1[0]['created_at'];}
            else{$acceptDate=null; }

            $vendorSourcingStatus=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('employer_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authuser->id)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('vendor_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}

            $job['numbers'] = array('vendorSourcing'=>$vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'est'=>$estimaterevenue,'profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles);$rejecteddate = ['rejecteddate'=>$acceptDate];$job['rejecteddate']=$rejecteddate;
        }//foreach
        return response()->success(compact('vendorassignedrejectedjobsall'));
    }

    public function getVendorassignedpendingjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $authId= $assigntovUser = null;
        $b = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
            foreach($a as $c){array_push($b, $c);}
            $vendorassignedpendingjobs = Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();

        } else {$authId = $authuser->id;
            $vendorassignedpendingjobs = Association::where('vendor_id',$authId)->where('created_at','>=',$diff_date)

                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        }

        foreach ($vendorassignedpendingjobs as $job) {

            $vendorSourcingStatus=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            $vendorAcceptedAt=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
                $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
                $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                    ->count();
                $offeredProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count();
                if(!$authuser->parent_id) {
                    $assigntovUser=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_user_id')
                                    ->where('job_id',intval($job['job_id']))
                                    ->with('vendoruser')
                                    ->get();
                    if(count($assigntovUser)) {
                        $assigntovUser=$assigntovUser[0]['vendoruser']['first_name'];
                    } else { $assigntovUser=null;}
                } else { $assigntovUser=null; }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);

                if($vendorAcceptedAt)
                    {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['job_accept_time'] = 0;}
                $possibleRevenues = DB::table('vendor_accountmanager_share')
                ->select('vendor_price')
                ->where('vendor_id', $authId)
                ->where('job_id', $job['job_id'])
                ->get();
                $numbers = ['profilesReceived'=>$receivedProfiles,'possibleRevenues' => $possibleRevenues,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'assigntovUser'=>$assigntovUser ];

                $job['numbers'] = $numbers;
        } //foreach


        return response()->success(compact('vendorassignedpendingjobs'));
    }

    public function getVendorassignedpendingjobsall()
    {
        $authuser = Auth::user();
        $authId= $assigntovUser = null;
        $b = array();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->groupBy('job_id')->lists('job_id');
            foreach($a as $c){array_push($b, $c);}
            $vendorassignedpendingjobsall = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereIn('job_id',$b)
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        } else {$authId = $authuser->id;
            $vendorassignedpendingjobsall = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',4)
                            ->with('job.JobType')
                            ->with('job_closed.status','job_assigned.vendorrevenues')
                            ->whereHas('job_closed',function($query){$query->where('status','=',8);})
                            ->get();
        }

        foreach ($vendorassignedpendingjobsall as $job) {

            $vendorSourcingStatus=Activity::select('vendor_id')->where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
            /*$vendorAcceptedAt=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->where('job_status',3)
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNotNull('accountmanager_id')
                                    ->where('activity_by',$authId)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();*/
            $receivedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->count();
                $rejectedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',[1,2,30])
                                    ->count();
                $shorlistedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                    ->count();
                $offeredProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(27,28))
                                    ->count();
                $holdProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereBetween('candidate_status',array(24,26))
                                    ->count();
                $interviwedProfiles=Association::select('job_id')->where('job_id',$job['job_id'])
                                    ->where('vendor_id',$authId)
                                    ->whereNotNull('candidate_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('employer_id')
                                    ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                    ->count();
                if(!$authuser->parent_id) {
                    $assigntovUser=Activity::where('vendor_id',$authuser->id)
                                    ->whereNotNull('vendor_user_id')
                                    ->where('job_id',intval($job['job_id']))
                                    ->with('vendoruser')
                                    ->get();
                    if(count($assigntovUser)) {
                        $assigntovUser=$assigntovUser[0]['vendoruser']['first_name'];
                    } else { $assigntovUser=null;}
                } else { $assigntovUser=null; }
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);

                /*if($vendorAcceptedAt)
                    {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['job_accept_time'] = 0;}*/
                $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'vendorSourcing' => $vendorSourcingStatus, 'encrypted_jobId'=>$encrypted,'assigntovUser'=>$assigntovUser ];

                $job['numbers'] = $numbers;
        } //foreach


        return response()->success(compact('vendorassignedpendingjobsall'));
    }

    public function getAssignedprogressjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$assignedprogressjobs_dummy = Cache::remember('getAssignedprogressjobs_assignedprogressjobs_dummy', 60, function() use ($authuser,$diff_date) {
        $assignedprogressjobs_dummy =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        //});

        foreach ($assignedprogressjobs_dummy as $job) {
            $jobId[] = $job->job_id;
            // echo "<pre>"; print_r($job); exit;
        }
        // echo "<pre>"; print_r($jobId);
        // DB::connection()->enableQueryLog();
        $assoStatsRaw =  Association::whereIn('job_id',$jobId)->where('created_at','>=',$diff_date)
                            ->where('accountmanager_id',$authuser->id)/*->where('gdpr_status','1')*/
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
                            /*$query = DB::getQueryLog();
                            $last_query = end($query);
        print_r($last_query); exit;*/
        foreach ($assoStatsRaw as $stats){
            $assoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }
        // print_r($assoStats[$stats->job_id], '1081aaaaaaaaaaaa');exit;
        //print_r($assoStats[$job['job_id']], '1081sdfjksdfankl');exit;

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $assignedToRaw =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $rejectedByRaw =  Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        //$vendorAcceptedAtRaw = Cache::remember('getAssignedprogressjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId,$diff_date) {
        $vendorAcceptedAtRaw =  Activity::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->whereIn('job_id',$jobId)
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->select('job_id', 'created_at')
                                    ->groupBy('job_id')
                                    ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats){
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }

        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;
            // echo "<pre>"; print_r(count(($assoStats[$job['job_id']])));
            if(isset($assoStats[$job['job_id']])) {
                // echo "<pre>"; echo "i am here"; exit;
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;

            if($assignedTo == $rejectedBy){
                $assignedprogressjobs_dummy->forget($key);
            }
        }
        $assignedprogressjobs = $assignedprogressjobs_dummy->values();
        return response()->success(compact('assignedprogressjobs'));
    }
    public function getAssignedprogressjobsall()
    {
        $authuser = Auth::user();
        $jobId = array();
        $assoStats = array();
        $assignedToStats = array();
        $rejectedByStats = array();
        $vendorAccepted = array();
        //$assignedprogressjobs_dummy = Cache::remember('getAssignedprogressjobs_assignedprogressjobs_dummy', 60, function() use ($authuser) {
        $assignedprogressjobs_dummy =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        //});

        foreach ($assignedprogressjobs_dummy as $job){
            $jobId[] = $job->job_id;
        }

        //$assoStatsRaw = Cache::remember('getAssignedprogressjobs_assoStatsRaw', 60, function() use ($authuser, $jobId) {
        $assoStatsRaw =  Association::whereIn('job_id',$jobId)
                            ->where('accountmanager_id',$authuser->id)/*->where('gdpr_status',1)*/
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->select('job_id',
                                DB::raw('count(id) AS profilesReceived'),
                                DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                            )
                            ->groupBy('job_id')
                            ->get();
        //});

        foreach ($assoStatsRaw as $stats){
            $assoStats[$stats->job_id]=array(
                "profilesReceived" => $stats->profilesReceived,
                "rejectedProfiles" => $stats->rejectedProfiles,
                "shortlistedProfiles" => $stats->shortlistedProfiles,
                "offeredProfiles" => $stats->offeredProfiles,
                "holdProfiles" => $stats->holdProfiles,
                "interviwedProfiles" => $stats->interviwedProfiles
            );
        }

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw =  Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        //$vendorAcceptedAtRaw = Cache::remember('getAssignedprogressjobs_vendorAcceptedAtRaw', 60, function() use ($authuser, $jobId) {
        $vendorAcceptedAtRaw =  Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->whereIn('job_id',$jobId)
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->select('job_id', 'created_at')
                                    ->groupBy('job_id')
                                    ->get();
        //});
        foreach ($vendorAcceptedAtRaw as $stats){
            $vendorAccepted[$stats->job_id] = $stats->created_at;
        }

        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers['encrypted_jobId'] = $encrypted;

            if(isset($assoStats[$job['job_id']])){
                $numbers['profilesReceived'] = $assoStats[$job['job_id']]['profilesReceived'];
                $numbers['rejectedProfiles'] = $assoStats[$job['job_id']]['rejectedProfiles'];
                $numbers['shortlistedProfiles'] = $assoStats[$job['job_id']]['shortlistedProfiles'];
                $numbers['offeredProfiles'] = $assoStats[$job['job_id']]['offeredProfiles'];
                $numbers['holdProfiles'] = $assoStats[$job['job_id']]['holdProfiles'];
                $numbers['interviwedProfiles'] = $assoStats[$job['job_id']]['interviwedProfiles'];
            } else {
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;
            }
            $job['numbers'] = $numbers;
            $job['assigned_to'] = $assignedTo;
            $job['rejected_by'] = $rejectedBy;
            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;
            $job['job_accept_time'] = isset($vendorAccepted[$job['job_id']])?$vendorAccepted[$job['job_id']]:0;

            if($assignedTo == $rejectedBy){
                $assignedprogressjobs_dummy->forget($key);
            }
        }
        $assignedprogressjobsall = $assignedprogressjobs_dummy->values();
        //print_r($assignedprogressjobs_dummy->values());
        return response()->success(compact('assignedprogressjobsall'));
    }
    public function getAdminassignedprogressjobs()
    {
        $authuser = Auth::user();
        $adminassignedprogressjobs = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        foreach ($adminassignedprogressjobs as $job) {
            $vendorAcceptedAt=Activity::where('admin_id',1)
                                ->where('accountmanager_id',intval($job['accountmanager_id']))
                                ->where('employer_id',intval($job['employer_id']))
                                ->whereNull('job_status')
                                ->where('job_id',intval($job['job_id']))
                                ->whereNull('vendor_id')
                                ->where('activity_by',intval($job['accountmanager_id']))
                                ->whereNull('status_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->first();
            $receivedProfiles=Association::where('job_id',$job->job['id'])
                    ->where('admin_id',$authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNotNull('employer_id')
                    ->count();
            $rejectedProfiles=Association::where('job_id',$job->job['id'])
                            ->where('admin_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->count();
            $shorlistedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'encrypted_jobId'=>$encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;

                if(($vendorAcceptedAt))
                    {$job['am_job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['am_job_accept_time'] = 0;}
        }

        return response()->success(compact('adminassignedprogressjobs'));
    }

    public function getAssignedclosedjobs($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $assignedclosedjobs = Association::whereNotNull('job_id')->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->where('accountmanager_id',$authuser->id)
                            ->with('employer')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();

        foreach ($assignedclosedjobs as $job) {
            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->where('job_id',intval($job['job_id']))
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();

            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles,'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles,  'encrypted_jobId'=>$encrypted, ];
            $job['numbers'] = $numbers;
            if(count($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
        }
        return response()->success(compact('assignedclosedjobs'));
    }

    public function getAssignedclosedjobsall()
    {
        $authuser = Auth::user();
        $assignedclosedjobsall = Association:: where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        foreach ($assignedclosedjobsall as $job) {
            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('employer_id')
                            ->where('admin_id',1)
                            ->whereNull('job_status')
                            ->where('job_id',intval($job['job_id']))
                            ->whereNull('vendor_id')
                            ->where('activity_by',$authuser->id)
                            ->whereNull('status_id')
                            ->where('is_vendor_sourcing_activity',0)
                            ->first();
            $receivedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',[1,2,30])
                                ->count();
            $shorlistedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,24,25,26,27,28,31))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job['job_id'])
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();

            $vendorAcceptedAt=Activity::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->where('admin_id',1)
                                    ->whereNull('job_status')
                                    ->where('job_id',intval($job['job_id']))
                                    ->whereNull('vendor_id')
                                    ->where('activity_by',$authuser->id)
                                    ->whereNull('status_id')
                                    ->where('is_vendor_sourcing_activity',0)
                                    ->first();

            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['encrypted_jobId'=>$encrypted];
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles,'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles,  'encrypted_jobId'=>$encrypted, ];
            $job['numbers'] = $numbers;
            if(($vendorAcceptedAt))
                {$job['job_accept_time'] = $vendorAcceptedAt['created_at'];}
            else {$job['job_accept_time'] = 0;}
        }
        return response()->success(compact('assignedclosedjobsall'));
    }

    public function getAdminassignedclosedjobs()
    {
        $authuser = Auth::user();
        $adminassignedclosedjobs = Association::whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->get();
        foreach ($adminassignedclosedjobs as $job) {
            $vendorAcceptedAt=Activity::where('admin_id',1)
                                ->where('accountmanager_id',intval($job['accountmanager_id']))
                                ->where('employer_id',intval($job['employer_id']))
                                ->whereNull('job_status')
                                ->where('job_id',intval($job['job_id']))
                                ->whereNull('vendor_id')
                                ->where('activity_by',intval($job['accountmanager_id']))
                                ->whereNull('status_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->first();
            $receivedProfiles=Association::where('job_id',$job->job['id'])
                    ->where('admin_id',$authuser->id)
                    ->whereNotNull('candidate_id')
                    ->whereNotNull('vendor_id')
                    ->whereNotNull('employer_id')
                    ->count();
            $rejectedProfiles=Association::where('job_id',$job->job['id'])
                            ->where('admin_id',$authuser->id)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereIn('candidate_status',[1,2,30])
                            ->count();
            $shorlistedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(17,26))
                                ->count();
            $offeredProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(27,28))
                                ->count();
            $holdProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereBetween('candidate_status',array(24,26))
                                ->count();
            $interviwedProfiles=Association::where('job_id',$job->job['id'])
                                ->where('admin_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                ->count();
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $numbers = ['profilesReceived'=>$receivedProfiles,'rejectedProfiles'=>$rejectedProfiles, 'shortlistedProfiles'=>$shorlistedProfiles,'offeredProfiles'=>$offeredProfiles, 'holdProfiles'=>$holdProfiles,'interviwedProfiles'=>$interviwedProfiles, 'encrypted_jobId'=>$encrypted];
            // $association['numbers'] = $numbers;
            $job['numbers'] = $numbers;
                if(count($vendorAcceptedAt))
                    {$job['am_job_accept_time'] = $vendorAcceptedAt['created_at'];}
                else {$job['am_job_accept_time'] = 0;}
        }

        return response()->success(compact('adminassignedclosedjobs'));
    }

    public function getEmployersummery()
    {
        $authuser = Auth::user();
        if($authuser->parent_id) {
            $authId=$authuser->parent_id;

            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->with('assingnedJob')
                            ->whereHas('assingnedJob',function($query){ $query->where('status','=',8); })
                            ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach($a as $c){array_push($b, $c);}

            $employersummery = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->groupBy('employer_id')->with('employer.company')->get();

        } else {
            $authId=$authuser->id;


            /*$employersummery = Association::where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                               ->get();*/

            /*$employersummery = Association::where('vendor_id',$authuser->parent_id)->whereNotNull('accountmanager_id')->whereNotNull('employer_id')->whereNull('employer_user_id')->whereIn('job_id',$b)->whereNull('candidate_id')->where('job_status',3)->groupBy('employer_id')->with('employer.company')->get();*/

            $employersummery=Association::where('vendor_id',$authId)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')
                                ->where('job_status',3)
                                ->groupBy('employer_id')
                                ->with('employer.company')
                                ->get();
        }

        foreach($employersummery as $employee)
            {
                $vendorselectedcandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->count();
                $vendordirectjoincandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',28)
                            ->count();
                $vendorphonecandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',17)
                            ->count();
                $vendorftfcandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',18)
                            ->count();
                 $vendorfintcandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',20)
                            ->count();
                $vendorwalkincandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',21)
                            ->count();
                $vendorskypecandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',22)
                            ->count();
                 $vendordirectcandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',23)
                            ->count();
                $vendorholecandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',24)
                            ->count();
                $vendorrascandidates = Association::where('vendor_id',$authuser->id)
                            ->where('employer_id',$employee->employer_id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',30)
                            ->count();
                $numbers = ['vendorselectedcandidates'=>$vendorselectedcandidates,'vendordirectjoincandidates'=>$vendordirectjoincandidates,'vendorphonecandidates'=>$vendorphonecandidates,'vendorftfcandidates'=>$vendorftfcandidates,'vendorfintcandidates'=>$vendorfintcandidates,'vendorwalkincandidates'=>$vendorwalkincandidates,'vendorskypecandidates'=>$vendorskypecandidates,'vendordirectcandidates'=>$vendordirectcandidates,'vendorholecandidates'=>$vendorholecandidates,'vendorrascandidates'=>$vendorrascandidates];
                $employee['numbers'] = $numbers;

                //echo ''; print_r($employee); echo '';
            }
            //die;
        return response()->success(compact('employersummery'));
    }

    public function getUseremployersummery()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $useremployersummery = Association::where('vendor_id',$supervendor[0]->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->groupBy('employer_id')
                            ->with('employer.company')
                           ->get();
        return response()->success(compact('useremployersummery'));
    }

    public function getEmpsummarydesc($id)
    {
        $authuser = Auth::user();
        if($authuser->parent_id){
            $authId = $authuser->parent_id;
             $profiles_submitted = Association::where('vendor_id',$authuser->parent_id)
                                ->whereNotNull('accountmanager_id')
                                /*->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*/
                                ->where('job_status',3)
                                 ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',8); })
                                //->where('created_at','>=',$diff_date)
                                 ->count();
                                

        $profiles_closed=Association::where('vendor_id',$authuser->parent_id)
                                ->whereNotNull('accountmanager_id')
                               /* ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*///->where('created_at','>=',$diff_date)
                                ->where('job_status',3)
                                ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',6); })
                                 ->count();
           
        } else {$authId = $authuser->id;
             $profiles_submitted = Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                                /*->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*/
                                ->where('job_status',3)
                                 ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',8); })
                                //->where('created_at','>=',$diff_date)
                                 ->count();
                                

        $profiles_closed=Association::where('vendor_id',$authuser->id)
                                ->whereNotNull('accountmanager_id')
                               /* ->whereNotNull('employer_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('job_id')
                                ->whereNull('candidate_id')*///->where('created_at','>=',$diff_date)
                                ->where('job_status',3)
                                ->with('job_closed.status')
                                ->whereHas('job_closed',function($query){ $query->where('status','=',6); })
                                 ->count();
            
        }
        $supervendor = User::where('id',$authuser)->get(['first_name','parent_id']);
        $candidates = array();
       

       

       
        $jobs_worked = Association::where('employer_id',$id)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();
        $empsummarydesc[] = array('profiles_submitted'=>$profiles_submitted,'profiles_closed'=>$profiles_closed,'employer_id'=>$id,'jobs_worked'=>$jobs_worked);
        return response()->success(compact('empsummarydesc'));
    }
    
	public function PostSubvendorperformance() {
        $vendor_id=Input::get('vendor_id');
		$venInfo = DB::table('users')->where('id', $vendor_id)->get();
		
		$vendoruserjobs = VendorUserJob::where('vendor_user_id',$vendor_id)->with('job')->groupBy('job_id')->get()->toArray();
		$noOfJobs = (is_array($vendoruserjobs)) ? count($vendoruserjobs) : "0";
		foreach($vendoruserjobs as $key =>$jobs) {
			$job_ids[] = $jobs['job_id'];
		}
		$kpiInfo = DB::table('kpi_weight')->where('vendor_id', $vendor_id)->get();
		
		$totalSubmit = Association::where('vendor_id', $vendor_id)
							->whereIn('job_id',$job_ids)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			//print_r($totalSubmit);exit;
			$submition_ratio = (!empty($kpiInfo[0]->submition_ratio)) ? $kpiInfo[0]->submition_ratio : '3';
			$submitiongreen = $submition_ratio;
			$submitionyellow = $submition_ratio/2;
			$submitionred = 0;
			$submitioncolor ="";
			if($totalSubmit!=0) {
				$submitionRatio = round($totalSubmit/$noOfWorkingDay,2);
			}else {
				$submitionRatio = 0;
			}
			
			if($submitionRatio >= $submitiongreen) {
				$submitioncolor = "#03d410";
			} else if($submitionRatio >= $submitionyellow && $submitionRatio < $submitiongreen) {

				$submitioncolor = "#ffcd00 ";
			} else {
				$submitioncolor = "#fc0c01";
			}
			
			$totalShortlist = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status',5)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$shortlisted_ratio = (isset($kpiInfo[0]->shortlisted_ratio)) ? $kpiInfo[0]->shortlisted_ratio : '1';
			
			$shortlistgreen = $shortlisted_ratio;
			$shortlistyellow = ((int)$shortlisted_ratio/2);
			$shortlistred = 0;
			$shortlistcolor ="";
			if($totalShortlist!=0) {
				$shortlistToSubmitionRatio = $totalShortlist/$totalSubmit;
			}else {
				$shortlistToSubmitionRatio = 0;
			}
			if($shortlistToSubmitionRatio >= $shortlistgreen) {
				$shortlistcolor = "#03d410";
			} else if($shortlistToSubmitionRatio >= $shortlistyellow && $shortlistToSubmitionRatio < $shortlistgreen) {

				$shortlistcolor = "#ffcd00 ";
			} else {
				$shortlistcolor = "#fc0c01";
			}
			$totInterview = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->whereIn('candidate_status',[9,10,13,17,18,20, 21, 22, 23])
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$interview_ratio = (!empty($kpiInfo[0]->interview_ratio)) ? $kpiInfo[0]->interview_ratio : '1';

			$interviewgreen = $interview_ratio;
			$interviewyellow = (!empty($interview_ratio)) ? $interview_ratio/2 : "0";
			$interviewred = 0;
			$interviewcolor ="";
			if($totInterview!=0) {
				$interviewToSubmitionRatio = round($totInterview/$totalSubmit,2);
			} else {
				$interviewToSubmitionRatio = 0;
			}
			if($interviewToSubmitionRatio >= $interviewgreen) {
				$interviewcolor = "#03d410";
			} else if($interviewToSubmitionRatio >= $interviewyellow && $interviewToSubmitionRatio < $interviewgreen) {

				$interviewcolor = "#ffcd00 ";
			} else {
				$interviewcolor = "#fc0c01";
			}
			
			$totSelect = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 3)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$selection_ratio = (isset($kpiInfo[0]->selection_ratio)) ? $kpiInfo[0]->selection_ratio : '1';
			$selectiongreen = $selection_ratio;
			$selectionyellow = $selection_ratio/2;
			$selectionred = 0;
			$selectioncolor ="";
			if($totSelect!=0) {
				$selectionToSubmitionRatio = round($totSelect/$totalSubmit,2);
			} else {
				$selectionToSubmitionRatio = 0;
			}
			if($selectionToSubmitionRatio >= $selectiongreen) {
				$selectioncolor = "#03d410";
			} else if($selectionToSubmitionRatio >= $selectionyellow && $selectionToSubmitionRatio < $selectiongreen) {

				$selectioncolor = "#ffcd00 ";
			} else {
				$selectioncolor = "#fc0c01";
			}
			
			$totCloser = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 44)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$closer_ratio = (isset($kpiInfo[0]->closer_ratio)) ? $kpiInfo[0]->closer_ratio : '1';
			
			$closergreen = $closer_ratio;
			$closeryellow = $closer_ratio/2;
			$closerred = 0;
			$closercolor ="";
			if($totCloser!=0) {
				$closerToSubmitionRatio = round($totCloser/$totalSubmit,2);
			} else {
				$closerToSubmitionRatio = 0;
			}
			if($closerToSubmitionRatio >= $closergreen) {
				$closercolor = "#03d410";
			} else if($closerToSubmitionRatio >= $closeryellow && $closerToSubmitionRatio < $closergreen) {

				$closercolor = "#ffcd00 ";
			} else {
				$closercolor = "#fc0c01";
			}
			
			$totJoin = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->where('candidate_status', 45)
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			$joining_ratio = (isset($kpiInfo[0]->joining_ratio)) ? $kpiInfo[0]->joining_ratio : '1';
			$joininggreen = $joining_ratio;
			$joiningyellow = $joining_ratio/2;
			$joiningred = 0;
			$joiningcolor ="";
			if($totJoin!=0) {
				$joiningToSubmitionRatio = round($totJoin/$totalSubmit,2);
			} else {
				$joiningToSubmitionRatio = 0;
			}
			if($joiningToSubmitionRatio >= $joininggreen) {
				$joiningcolor = "#03d410";
			} else if($joiningToSubmitionRatio >= $joiningyellow && $joiningToSubmitionRatio < $joininggreen) {

				$joiningcolor = "#ffcd00 ";
			} else {
				$joiningcolor = "#fc0c01";
			}
			
			$totalReject = Association::where('vendor_id',$vendor_id)
							->whereIn('job_id',$job_ids)
							->whereIn('candidate_status',array(1,2,30))
							->where('accountmanager_id',$authuser->id)
							->whereNotNull('candidate_status')
							->whereNotNull('accountmanager_id')
							->whereNotNull('candidate_id')
							->whereNotNull('employer_id')
							->whereNotNull('vendor_id')
							->whereNull('vendor_user_id')
							->count();
			if($totalReject!=0) {
				$totalRejectRatio = round(($totalReject *100)/$totalSubmit,2);
			} else {
				$totalRejectRatio = 0;
			}
			$rejectionratio = (isset($kpiInfo[0]->rejection_ratio)) ? $kpiInfo[0]->rejection_ratio : '20';	
			
			$rejectiongreen = $rejectionratio;
			$rejectionyellow = $rejectionratio/2;
			$rejectionred = 0;
			$rejectioncolor ="";
			if($totalRejectRatio >= $rejectiongreen) {
				$rejectioncolor = "#03d410";
			} else if($totalRejectRatio >= $rejectionyellow && $totalRejectRatio < $rejectiongreen) {

				$rejectioncolor = "#ffcd00 ";
			} else {
				$rejectioncolor = "#fc0c01";
			}
			
			$vendorInformation[] = array('name'=>$venInfo[0]->first_name,
										'vendor_id'=>$venInfo[0]->id, 
										'total_submition' =>array('submition_ratio'=>$submition_ratio,
																  'weight'=>$submition_ratio,
																  'red' =>$submitionred,
																  'yellow' =>$submitionyellow,
																  'green' =>$submitiongreen, 
																  'color'=>$submitioncolor
																),
										'total_shortlisted' =>array('shortlisted_ratio'=>$shortlisted_ratio,
																  'weight'=>$shortlisted_ratio,
																  'red' =>$shortlistred,
																  'yellow' =>$shortlistyellow,
																  'green' =>$shortlistgreen, 
																  'color'=>$shortlistcolor
																),
										'total_interview' =>array('interview_ratio'=>$interview_ratio,
																  'weight'=>$interview_ratio,
																  'red' =>$interviewred,
																  'yellow' =>$interviewyellow,
																  'green' =>$interviewgreen, 
																  'color'=>$interviewcolor
																),
										'total_selection' =>array('interview_ratio'=>$selection_ratio,
																  'weight'=>$selection_ratio,
																  'red' =>$selectionred,
																  'yellow' =>$selectionyellow,
																  'green' =>$selectiongreen, 
																  'color'=>$selectioncolor
																),
										'total_closer' =>array('closer_ratio'=>$closer_ratio,
																  'weight'=>$closer_ratio,
																  'red' =>$closerred,
																  'yellow' =>$closeryellow,
																  'green' =>$closergreen, 
																  'color'=>$closercolor
																),
										'total_joining' =>array('joining_ratio'=>$joining_ratio,
																  'weight'=>$joining_ratio,
																  'red' =>$joiningred,
																  'yellow' =>$joiningyellow,
																  'green' =>$joininggreen, 
																  'color'=>$joiningcolor
																),
										'total_rejection' =>array('rejectionratio'=>$rejectionratio,
																  'weight'=>$rejectionratio,
																  'red' =>$rejectionred,
																  'yellow' =>$rejectionyellow,
																  'green' =>$rejectiongreen, 
																  'color'=>$rejectioncolor
																),
										'submitionRatio' =>$submitionRatio,
										'shortlistToSubmitionRatio' =>$shortlistToSubmitionRatio,
										'interviewToSubmitionRatio' =>$interviewToSubmitionRatio,
										'selectionToSubmitionRatio' =>$selectionToSubmitionRatio,
										'closerToSubmitionRatio' =>$closerToSubmitionRatio,
										'joiningToSubmitionRatio' =>$joiningToSubmitionRatio,
										'totalRejectRatio' =>$totalRejectRatio
										);
		//print_r($vendorInformation);exit;
		return response()->success(compact('subvendorInformation'));
		
	}
    public function getVendorteamsummary($id)
    {	
		//$this->getSubvendorperformance($id);
		//exit;
        $authuser = Auth::user();
        $candidatesteam = $vendorUserjobIds = array();

        $vendoruserjobs=VendorUserJob::where('vendor_user_id',$id)->with('job')->groupBy('job_id')->get();

        foreach($vendoruserjobs as $job)
            {
                $thisJob = 0;
                array_push($vendorUserjobIds, $job->job_id);
                $thisJob=Association::where('job_id',intval($job->job_id))
                            ->whereNotNull('accountmanager_id')
                            ->where('candidate_status',19)
                            ->where('vendor_approval',0)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->where('vendor_id',$authuser->id)
                            ->whereNull('vendor_user_id')
                            ->get();
                if(count($thisJob)) :
                    $job['job']['activate_action_check'] = 1;
                else:
                    $job['job']['activate_action_check'] = 0;
                endif;
            }
        $vendoractivitycandidate = Association::where('vendor_id',$authuser->id)
                                ->whereIn('job_id',$vendorUserjobIds)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->get();
        foreach($vendoractivitycandidate as $can)
            {array_push($candidatesteam, $can->candidate_id);}

            $alljobs=Association::where('vendor_id',$authuser->id)
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNull('candidate_id')
                            ->with('job_assigned.status','job_assigned.vendorrevenues')
                            ->whereHas('job_assigned',function($query){
                                $query->where('status','=',8);
                            })
                            ->count();

            // $profiles_submitted=Association::where('vendor_id',$authuser->id)
            //                 ->whereIn('job_id',$vendorUserjobIds)
            //                 ->whereNotNull('candidate_id')
            //                 ->distinct('candidate_id')
            //                 ->count();

            $profiles_submitted=Activity::where('vendor_id',$authuser->id)
                                ->where('vendor_user_id',$id)
                                ->whereIn('job_id',$vendorUserjobIds)
                                ->whereNotNull('candidate_id')
                                ->where('is_vendor_sourcing_activity',0)
                                ->whereNull('status_id')
                                ->whereNull('job_status')
                                ->groupBy(array('candidate_id','job_id'))
                                ->get();

            $selectedprofiles = Association::whereIn('candidate_id',$candidatesteam)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->count();

            //$candidates = Candidate::where('vendor_id',$authuser->id)->count();

            $candidates = Association::where('vendor_id',$authuser->id)
                                    ->whereIn('job_id',$vendorUserjobIds)
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('accountmanager_id')
                                    ->get();

            $jobsclosed = Association::whereIn('candidate_id',$candidatesteam)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$vendorUserjobIds)
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                            ->count();

      $vendorteamsummary[] = array('jobs'=>$vendoruserjobs,'profiles_submitted'=>count($profiles_submitted),'alljobs'=>$alljobs,'candidates'=>count($candidates),'jobsclosed'=>$jobsclosed,'selectedprofiles'=>$selectedprofiles);
        return response()->success(compact('vendorteamsummary'));
    }

    public function postGetvendoruservsa()
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else{$authId=$authuser->id;}
        /*$authuser = Auth::user();
        $authId = $authuser->id;*/
        $jobId=Input::get('jobIds');
        $vendoruserId=Input::get('vendorId');

        $accountmanager_id=Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        foreach ($jobId as $key => $value) {
            $a=false;
            $a=Activity::where('vendor_id',$authId)
                        ->whereNotNull('employer_id')
                        ->where('vendor_user_id',$vendoruserId)
                        ->where('job_id',intval($value))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->where('activity_by',$authId)
                        /*->whereNotNull('status_id')*/
                        /*->where('is_vendor_sourcing_activity',1)*/
                        /*->with('activityuser.role','status','candidate')
                        ->with('job')
                        ->with('sourcingStatus')*/
                        ->get();
            if(count($a)){
                $getvendoruservsa[$key]=Activity::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->where('vendor_user_id',$vendoruserId)
                                    ->where('job_id',intval($value))
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('activity_by',$authId)
                                    /*->whereNotNull('status_id')
                                    ->where('is_vendor_sourcing_activity',1)*/
                                    /*->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')*/
                                    ->get();
            }
        }//foreach

        // if ($authuser->parent_id) :
        //     $vendorstattimeline=Activity::where('vendor_id',$authId)
        //                 ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
        //                 ->where('admin_id',1)
        //                 ->where('vendor_user_id',$authuser->id)
        //                 ->where('job_id',intval($jobId))
        //                 ->where('accountmanager_id',$accountmanager_id)
        //                 ->where('activity_by',$authId)
        //                 ->whereNotNull('status_id')
        //                 ->where('is_vendor_sourcing_activity',1)
        //                 ->with('activityuser.role','status','candidate')
        //                 ->with('job')
        //                 ->with('sourcingStatus')
        //                 ->get();
        // else :
        //     $vendorstattimeline=Activity::where('vendor_id',$authId)
        //                 ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
        //                 ->where('admin_id',1)
        //                 ->where('job_id',intval($jobId))
        //                 ->where('accountmanager_id',$accountmanager_id)
        //                 ->whereNull('vendor_user_id')
        //                 ->where('activity_by',$authId)
        //                 ->whereNotNull('status_id')
        //                 ->where('is_vendor_sourcing_activity',1)
        //                 ->with('activityuser.role','status','candidate')
        //                 ->with('job')
        //                 ->with('sourcingStatus')
        //                 ->get();
        // endif;
        return response()->success(compact('getvendoruservsa'));
    }

    public function getVendorsummary($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){
            $authId=$authuser->parent_id;
            $empActIds = EmployerUserJobs::where('employer_id',$authuser->parent_id)
                            ->where('employer_user_id',$authuser->id)
                            ->lists('job_id');

            $profiles_submitted=Association::whereIn('job_id',$empActIds)
                                        ->where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->count();

            $profiles_closed = Association::whereIn('job_id',$empActIds)
                                            ->where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->where('candidate_status',6)
                                            ->count();

            $jobs_worked = Association::whereIn('job_id',$empActIds)
                                        ->where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNull('candidate_id')->with('job')
                                        ->groupBy('job_id')
                                        ->get();
        } else {
            $authId=$authuser->id;
            $profiles_submitted=Association::where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->where('candidate_status', 31)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->count();
                                            
            $profiles_closed = Association::where('employer_id',$authId)
                                            ->where('vendor_id',$id)
                                            ->whereNotNull('accountmanager_id')
                                            ->whereNull('vendor_user_id')
                                            ->whereNull('employer_user_id')
                                            ->whereNotNull('job_id')
                                            ->whereNotNull('candidate_id')
                                            ->where('candidate_status',6)
                                            ->count();

            $jobs_worked = Association::where('employer_id',$authId)
                                        ->where('vendor_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNull('candidate_id')->with('job')
                                        ->groupBy('job_id')
                                        ->get();
        }
        $vendorsummary[] = array('profiles_submitted'=>$profiles_submitted,'profiles_closed'=>$profiles_closed,'vendor_id'=>$id,'jobs_worked'=>$jobs_worked);
        return response()->success(compact('vendorsummary'));
    }


    public function getAmprofilescount($id)
    {
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        $amprofilescount = [];
        if($job_details[0]['gdprmandatory']){
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                /*->where('gdpr_status',1)*/
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->count();
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')/*->where('gdpr_status',1)*/
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereIn('candidate_status',array(1,2,30))
                                ->whereNotNull('candidate_status')/*->where('gdpr_status',1)*/
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
        } else{
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                               // ->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })
                                ->count();
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereIn('candidate_status',array(1,2,30))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->count();
        }

        $aminactivecandidates_wgdpr = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            /*->where('gdpr_status',1)*/
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })->count();
        $aminactivecandidates_wogdpr= Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            //->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })->count();
        $aminactivecandidates = $aminactivecandidates_wgdpr + $aminactivecandidates_wogdpr;

        $numbers = ['amassignedpendingcandidates'=>$amassignedpendingcandidates,
                    'amshortlistedcandidates'=>$amshortlistedcandidates,
                    'amrejectedcandidates'=>$amrejectedcandidates,
                    'aminactivecandidates'=>$aminactivecandidates];
        $amprofilescount['numbers'] = $numbers;
        return response()->success(compact('amprofilescount'));
    }
    public function getAmassignedpendingcandidates($id)
    {	//$this->postAmrecruiterperformancethree();
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']){
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                /*->where('gdpr_status',1)*/
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor','vendor.company','job','candidate.candidate_operational_skill','candidate.educations','CandidateSkills','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                                ->with('CandidateDetails')
                                ->with('CandidateNotes')
                                ->with('GdprData')
                                //->with('Predefinedquestionsanswers')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->get();
        } else{
            $amassignedpendingcandidates = Association::where('job_id',$id)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                //->where('vendor_approval',1)
                                ->whereNull('vendor_user_id')
                                ->with(array('CandidatePoints','status','candidate','vendor','vendor.company','job','candidate.candidate_operational_skill','candidate.educations','CandidateSkills','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills','GdprData'))
                                ->with('CandidateDetail')
                                ->with('CandidateNotes')
                                //->with('Predefinedquestionsanswers')
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })
                                ->get();
        }
        //echo '<pre>'; print_r($amassignedpendingcandidates); die;

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        //echo $empTimezone.'empTimezone';
        foreach ($amassignedpendingcandidates as $candidate) {

            //echo '<pre>'; print_r($candidate['CandidateNotes']['updated_at']); echo '</pre>';

            $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
            $created_at = explode('-', $created_date);
            
            $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

            $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
                
            //echo '<pre>'; print_r($candidate->candidate['phone']); echo '</pre>----'; //die;
            if(isset($candidate->candidate['phone']) && !empty($candidate->candidate['phone']))
            {
                $candidate->candidate['phone']=str_replace("91-","",$candidate->candidate['phone']);
                $candidate->candidate['phone']=str_replace("+91","",$candidate->candidate['phone']);
                $candidate->candidate['phone']=str_replace("+91 ","",$candidate->candidate['phone']);
            }
            $shareData = ShareLinkActivitys::where('job_id',$id)
                        ->where('candidate_id',$candidate['candidate_id'])
                        ->where('accountmanager_id',$authuser->id)
                        ->get();



        $Rchilcntl = new RchilliController();
        $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);

        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);


        $candidate['talentmoning']= $candidateTalentMine;
        $candidate['candidateSpectrum']= $candidateSpectrum;
         $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

          $candidate['skils_block'] = $skils_block;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
             $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

            $candidate['marge_skills'] = $obj;
            $candidate['marge_skills2'] = $obj2;
            $candidate['sharealink'] = $shareData;
            $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                            ->where('candidate_id', $candidate['candidate_id'])
                            ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
			$candidateSkillblock = DB::table('skillblock_resume')->where('candidate_id', $candidate['candidate_id'])->get();
            $gdprData = DB::table('gdpr_datas')->where('candidate_id', $candidate['candidate_id'])->where('job_id', $id)->first();
			$candidate['candidateskillblocks'] = $candidateSkillblock;
            $candidate['gdprData'] = $gdprData;
             $predefinedInfo = DB::table('job_orders')->select('questions')->where('id',$id)->get();
                  if ($predefinedInfo[0]->questions == "NO" || $predefinedInfo[0]->questions == null || $predefinedInfo[0]->questions == '' )
                    {
                        $candidate['PredefinedquestionsanswersData'] = 1;
                    }
                else{
                  $Predefinedquestionsanswers = Predefinedquestionsanswers::where('candidate_id', $candidate['candidate_id'])->get();
                 if(($Predefinedquestionsanswers) && count($Predefinedquestionsanswers)>0) {
                    $candidate['PredefinedquestionsanswersData'] = 1;
                 } else {
                          $candidate['PredefinedquestionsanswersData'] = 0;
                        }
                }
            $colors =Colors::get();
            foreach($amassignedpendingcandidates as $key=>$value) {
                $value['color'] = $colors[$key]->name;
            }

        }
        return response()->success(compact('amassignedpendingcandidates'));
    }

    public function getAminactivecandidates($id)
    {
        $authuser = Auth::user();
        $aminactivecandidates_wgdpr = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            /*->where('gdpr_status',1)*/
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with('CandidatePoints')
                            ->with('gdprData')
                            ->with('Predefinedquestionsanswers')
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                            ->with('CandidateNotes')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',1);
                            })->get();
        $aminactivecandidates_wogdpr= Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->where('candidate_status',19)
                            ->whereNotNull('candidate_status')
                            //->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with('CandidatePoints')
                            ->with('gdprData')
                            ->with('Predefinedquestionsanswers')
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                            ->with('CandidateNotes')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })->get();
        $aminactivecandidates = $aminactivecandidates_wgdpr->merge($aminactivecandidates_wogdpr);
         $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
         $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
           
        foreach ($aminactivecandidates as $candidate) {
            $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

                $candidate['timezone'] = $empTimezone[0]['GMT_offset'];

        $Rchilcntl = new RchilliController();
        $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);

        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);


        $candidate['talentmoning']= $candidateTalentMine;
        $candidate['candidateSpectrum']= $candidateSpectrum;
         $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

          $candidate['skils_block'] = $skils_block;
          $gdprData = DB::table('gdpr_datas')->where('candidate_id', $candidate['candidate_id'])->where('job_id', $id)->first();
            $candidate['gdprData'] = $gdprData;
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted_jobId = base64_encode($timestamp . $randomKey . $id);
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
             $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                            ->where('candidate_id', $candidate['candidate_id'])
                            ->select('note_description')->get();
            $candidate['vendorcandidatenotes'] = $candidatenotes;
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid,'encrypted_jobId'=>$encrypted_jobId];
            $candidate['numbers'] = $numbers;
            $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
            $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
            $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
            $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

            $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $predefinedInfo = DB::table('job_orders')->select('questions')->where('id',$id)->get();
                  if ($predefinedInfo[0]->questions == "NO" || $predefinedInfo[0]->questions == null || $predefinedInfo[0]->questions == '' )
                    {
                        $candidate['PredefinedquestionsanswersData'] = 1;
                    }
                    else{
                  $Predefinedquestionsanswers = Predefinedquestionsanswers::where('candidate_id', $candidate['candidate_id'])->first();
                 if(($Predefinedquestionsanswers) && count($Predefinedquestionsanswers)>0) {
                    $candidate['PredefinedquestionsanswersData'] = 1;
                 } else {
                     $candidate['PredefinedquestionsanswersData'] = 0;
                 }
                    }
        }
		//print_r($aminactivecandidates);exit;
        return response()->success(compact('aminactivecandidates'));
    }

    public function getAmshortlistedcandidates($id)
    {
        $authuser = Auth::user();
		//$this->getAmrecruiterperformance();
		//exit;
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']) {
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                                ->whereNotIn('candidate_status',array(1,2,30,6,19))
                                ->whereNotNull('candidate_status')->where('gdpr_status',1)
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->with(array('Status','Candidate','Vendor',
'vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                                ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                                ->with('CandidateNotes')
                                 ->with('CandidatePoints')
                                 ->with('CandidateDetails')
                                ->whereHas('CandidatePoints',function($query) use ($id){
                                    $query->where('job_id','=',$id);
                                })->get();
		//print_r($amshortlistedcandidates);exit;
        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
           
            foreach ($amshortlistedcandidates as $candidate) {
                $created_date = date('Y-m-d-H-i-s', strtotime($candidate['CandidateNotes']['updated_at']));
                $created_at = explode('-', $created_date);
                
                $date = new \DateTime($candidate['CandidateNotes']['updated_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $candidate['CandidateNotes']['updated_at'] = $date->format('Y-m-d H:i:s');

                $candidate['timezone'] = $empTimezone[0]['GMT_offset'];
                $shareData = ShareLinkActivitys::where('job_id',$id)
                            ->where('candidate_id',$candidate['candidate_id'])
                            ->where('accountmanager_id',$authuser->id)
                            ->get();
                $Rchilcntl = new RchilliController();
                $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
                $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
                $candidate['talentmoning']= $candidateTalentMine;
                $candidate['candidateSpectrum']= $candidateSpectrum;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
                $candidate['skils_block'] = $skils_block;
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidate['sharealink'] = $shareData;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();

                $candidate['vendorcandidatenotes'] = $candidatenotes;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

                $candidate['skils_block'] = $skils_block;
            }
        } else {
            $amshortlistedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                        ->whereNotIn('candidate_status',array(1,2,30,6,19))
                        ->whereNotNull('candidate_status')
                        ->whereNotNull('accountmanager_id')
                        ->whereNotNull('candidate_id')
                        ->whereNotNull('employer_id')
                        ->whereNotNull('vendor_id')
                        ->whereNull('vendor_user_id')
                        ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job'))
                        ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                        ->with('CandidateNotes')
                         ->with('CandidatePoints')
                         ->with('CandidateDetails')
                        ->whereHas('CandidatePoints',function($query) use ($id){
                            $query->where('job_id','=',$id);
                        })->get();
			
            foreach ($amshortlistedcandidates as $candidate) {
                $shareData = ShareLinkActivitys::where('job_id',$id)
                            ->where('candidate_id',$candidate['candidate_id'])
                            ->where('accountmanager_id',$authuser->id)
                            ->get();
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills = explode(',', $candidate['CandidateSkills']['skills']);

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mached_skills_preferred = array_intersect($job_skills_preferred, $candidate_skills);
                $mached_skills_required = array_intersect($job_skills_required, $candidate_skills);
                $candidates_merge = array_merge($mached_skills_preferred, $mached_skills_required);

                $i = 0;
                $obj = new \stdClass;
                foreach($candidates_merge as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['sharealink'] = $shareData;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();
                $candidate['vendorcandidatenotes'] = $candidatenotes;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();

                $candidate['skils_block'] = $skils_block;
            }
        }
        return response()->success(compact('amshortlistedcandidates'));
    }

    public function getAmrejectedcandidates($id)
    {
        $authuser = Auth::user();
        $job_details=JobOrders::where('id',$id)->get(['gdprmandatory']);
        if($job_details[0]['gdprmandatory']){
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->whereNotNull('candidate_status')->where('gdpr_status',1)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                             ->with('CandidatePoints')
                             ->with('CandidateDetails')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->get();
            foreach ($amrejectedcandidates as $candidate) {
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);
                $Rchilcntl = new RchilliController();
                $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate['candidate_id']);
                $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate['candidate_id']);
                $candidate['talentmoning']= $candidateTalentMine;
                $candidate['candidateSpectrum']= $candidateSpectrum;
                $skils_block = SkillblockResume::where('candidate_id', $candidate['candidate_id'])->whereNotIn('found_id', [3,2])->get();
                $candidate['skils_block'] = $skils_block;

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();

                $candidate['vendorcandidatenotes'] = $candidatenotes;
            }
        } else {
            $amrejectedcandidates = Association::where('job_id',$id)->where('accountmanager_id',$authuser->id)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate','Vendor','vendor.company','CandidateSkills','job','CandidateOperationalSkills','CandidateSkillsets','CandidateSoftSkills'))
                            ->with(['candidate.experiences' => function($query){
                                    return $query;
                                }])
                             ->with('CandidatePoints')
                             ->with('CandidateDetails')
                            ->whereHas('CandidatePoints',function($query) use ($id){
                                $query->where('job_id','=',$id);
                            })->get();
            foreach ($amrejectedcandidates as $candidate) {
                $timestamp = 129310611081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $candidate['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
                $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
                $candidate['numbers'] = $numbers;
                $candidate_skills1 = explode(',', $candidate['CandidateSkills']['skills']);
                $candidate_skills2 = explode(',', $candidate['CandidateOperationalSkills']['operational_skills']);
                $candidate_skills3 = explode(',', $candidate['CandidateSkillsets']['skill_set']);
                $candidate_skills4 = explode(',', $candidate['CandidateSoftSkills']['soft_skills']);

                $mergedCandidateSkills = array_merge($candidate_skills1, $candidate_skills2, $candidate_skills3, $candidate_skills4);

                foreach($mergedCandidateSkills as $key => $item)
                {
                    $candidateSkills[$key] = trim(strtolower($item));
                }

                $job_skills_preferred = explode(',', $candidate['job']['skills_preferred']);
                $job_skills_required = explode(',', $candidate['job']['skills_required']);

                $mergedJobSkills = array_merge($job_skills_preferred, $job_skills_required);

                foreach($mergedJobSkills as $key => $item)
                {
                    $jobSkills[$key] = trim(strtolower($item));
                }

                $mached_skills_preferred = array_intersect($jobSkills, $candidateSkills);
                $mached_skills_preferred2 = array_diff($jobSkills, $candidateSkills);

                $i = 0;
                $obj = new \stdClass;
                foreach($mached_skills_preferred as $item) {
                    $obj->$i = (object) array($item);
                    $i++;
                }

                $j = 0;
                $obj2 = new \stdClass;
                foreach($mached_skills_preferred2 as $item2) {
                    $obj2->$j = (object) array($item2);
                    $j++;
                }

                $candidate['marge_skills'] = $obj;
                $candidate['marge_skills2'] = $obj2;
                $candidatenotes = VendorCandidateNotes::where('job_id', $id)
                                ->where('candidate_id', $candidate['candidate_id'])
                                ->select('note_description')->get();
                $candidate['vendorcandidatenotes'] = $candidatenotes;
            }
        }
        return response()->success(compact('amrejectedcandidates'));
    }

    public function postActivitycomment()
    {
        $authuser = Auth::user();
        $AdminData = explode(",", Input::get('admin_id'));
//print_r($AdminData[1]);

       /* $adminId=$AdminData[0];
        $accountmanagerId=$AdminData[1];
        $employerId=$AdminData[2];
        $vendorId=$AdminData[3];
        $jobId=$AdminData[4];
        $candidateId=$AdminData[5];*/
//echo $adminId.'--'$accountmanagerId.'---'.$employerId.'----'.$vendorId.'----'.$jobId.'----'$candidateId;

        $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');

        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $email,
            'accountmanager_id' => $accountmanagerId,
            'employer_id' => $employerId,
            'vendor_id' => $vendorId,
            'job_id' => $jobId,
            'name' => "Commented by vendor",
            'admin_id' => $adminId,
            'activity_by' => $authuser->id,
            'candidate_id' => $candidateId,
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivitycommentvendor()
    {
        $authuser = Auth::user();
        $AdminData = explode(",", Input::get('admin_id'));
        $adminId=$AdminData[0];
        $accountmanagerId=$AdminData[1];
        $employerId=$AdminData[2];
        $vendorId=$AdminData[3];
        $jobId=$AdminData[4];
        $candidateId=$AdminData[5];
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycommentvendor = Activity::create([
            'note' => $email,
            'accountmanager_id' => $accountmanagerId,
            'employer_id' => $employerId,
            'vendor_id' => $vendorId,
            'job_id' => $jobId,
            'name' => "Commented by vendor",
            'admin_id' => $adminId,
            'activity_by' => $authuser->id,
            'candidate_id' => $candidateId,
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivityusercomment()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->parent_id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->parent_id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitycomment = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        return response()->success('Comment Has been added');
    }

    public function postActivitydata()
    {
        $authuser = Auth::user();
        $AdminData = explode(",", Input::get('admin_id'));
        $adminId=$AdminData[0];
        $accountmanagerId=$AdminData[1];
        $employerId=$AdminData[2];
        $vendorId=$AdminData[3];
        $jobId=$AdminData[4];
        $candidateId=$AdminData[5];
        $activitydata = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }

    public function postActivitydatabyvendor()
    {
        $authuser = Auth::user();
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $activitydatabyvendor = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => $authuser->id,
            'job_id' => Input::get('job_id'),
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id')
        ]);
        return response()->success(compact('activitydatabyvendor'));
    }

    public function postActivitydatavendor()
    {
        $authuser = Auth::user();
        $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');
        $activitydatavendor = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydatavendor'));
    }

    public function postActivitydataam()
    {
        $authuser = Auth::user();
        $adminId=Input::get('admin_id');
        $accountmanagerId=Input::get('accountmanager_id');
        $employerId=Input::get('employer_id');
        $vendorId=Input::get('vendor_id');
        $jobId=Input::get('job_id');
        $candidateId=Input::get('candidate_id');
        $activitydataam = Activity::where('vendor_id',$vendorId)
                            ->where('admin_id',$adminId)
                            ->where('accountmanager_id',$accountmanagerId)
                            ->where('employer_id',$employerId)
                            ->where('job_id',$jobId)
                            ->where('candidate_id',$candidateId)
                            ->with('activityuser.role','status')
                            ->with('candidate')
                            ->get();
            $reasons_arr = array();
            foreach ($activitydataam as $job) {

                $accManagerCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
                $accManagerTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$accManagerCompanyID[0]->timezone)->get();

                $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');

                $date->setTimezone(new \DateTimeZone($accManagerTimezone[0]['timezone'])); 
                $job['created_at'] = $date->format('Y-m-d H:i:s');

                $job['timezone'] = $accManagerTimezone[0]['GMT_offset'];
                $job['accManagerTimezoneOffset'] = $accManagerTimezone[0]['GMT_offset'];

                //Fetching reasons based on rejected candidate data.
                $candidate_status_arr = [2,30];
                $reasons_arr[] = explode(',',$job['reason_id']);
                    if (in_array($job['candidate_status'], $candidate_status_arr)){
                        foreach($reasons_arr as $reason){
                            $reasonsData = Reason::select('name')->whereIn('id', $reason)->get()->toArray();
                        }
                    }else{
                            $reasonsData = [];
                    }
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
                $encrypted_canId = base64_encode($timestamp . $randomKey . $job['candidate_id']);
                $encrypted_statusid = base64_encode($timestamp . $randomKey . $job['candidate_status']);
                $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_canId, 'encrypted_canStatus'=>$encrypted_statusid,'reasonsData'=>$reasonsData];
                $job['numbers'] = $numbers;
                 $scheduled_date=Association::where('employer_id',$authuser->id)
                          ->where('vendor_id',$job['vendor_id'])
                          ->where('candidate_id',$job['candidate_id'])
                          ->where('candidate_status',$job['candidate_status'])
                          ->where('job_id',$job['job_id'])
                          ->whereNotNull('interview_schedule_date')
                          ->first();
            if($scheduled_date) {
                $job['interview_schedule_date'] = $scheduled_date->interview_schedule_date;
                $job['association_id'] = $scheduled_date->id;
            }
            else {
             $job['association_id'] = $job['interview_schedule_date'] = null;
            }
        }
            // echo '<pre>';  print_r($reasons_arr);exit;
        return response()->success(compact('activitydataam'));
    }

    public function postActivityuserdata()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $activitydata = Activity::where('vendor_id',$supervendor[0]->parent_id)
                            ->where('admin_id',Input::get('admin_id'))
                            ->where('accountmanager_id',Input::get('accountmanager_id'))
                            ->where('employer_id',Input::get('employer_id'))
                            ->where('job_id',Input::get('job_id'))
                            ->where('candidate_id',Input::get('candidate_id'))
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }
    public function postUseractivitydata()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $vendoractivitycandidate = VendorActivities::where('job_id',Input::get('job_id'))
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        $candidates = array();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
            $activitydata = Activity::whereIn('candidate_id',$candidates)->where('vendor_id',$supervendor[0]->parent_id)
                            ->where('admin_id',Input::get('admin_id'))
                            ->where('accountmanager_id',Input::get('accountmanager_id'))
                            ->where('employer_id',Input::get('employer_id'))
                            ->where('job_id',Input::get('job_id'))
                            ->where('candidate_id',Input::get('candidate_id'))
                            ->with('activityuser.role','status')
                            ->get();
        return response()->success(compact('activitydata'));
    }

    public function postActivitycommentemployer()
    {
        $authuser = Auth::user();
        $authId = null;
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        if($authuser->parent_id) {
             $mobile = $email;
             $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
             $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
             $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
             //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
             $activitycomment = Activity::create([
                'note' => $email,
                'accountmanager_id' => Input::get('accountmanager_id'),
                'employer_id' => $authuser->parent_id,
                'employer_user_id' => $authuser->id,
                'vendor_id' => Input::get('vendor_id'),
                'job_id' => Input::get('job_id'),
                'name' => "Commented by employer",
                'admin_id' => Input::get('admin_id'),
                'activity_by' => Input::get('employer_id'),
                'candidate_id' => Input::get('candidate_id'),
                'commentprivate' => Input::get('commentprivate')                
            ]);
        } else {
            $mobile = Input::get('name');
            $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
            $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
            $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
            //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
            $activitycomment = Activity::create([
                'note' => $email,
                'accountmanager_id' => Input::get('accountmanager_id'),
                'employer_id' => Input::get('employer_id'),
                'vendor_id' => Input::get('vendor_id'),
                'job_id' => Input::get('job_id'),
                'name' => "Commented by employer",
                'admin_id' => Input::get('admin_id'),
                'activity_by' => Input::get('employer_id'),
                'candidate_id' => Input::get('candidate_id'),
                'commentprivate' => Input::get('commentprivate')              
            ]);
        } //if   else
        return response()->success('Comment Has been added');
    }

    public function postActivitycommentam()
    {
        $authuser = Auth::user();
        $mobile = Input::get('name');
        $mobile_s = preg_replace('/(?<=\d)\s+(?=\d)/', '', $mobile);
        $mobile = preg_replace('/([0-9]+[\- ]?[0-9]{5,})/', '', $mobile_s);
        $email = preg_replace('/[a-z0-9_\-\+\.]+@[a-z0-9\-]+\.([a-z]{2,4})(?:\.[a-z]{2})?/i', '', $mobile);
        //$email=preg_replace('/ [a-zA-Z]\w*/', '', $email);
        $Activitycommentam = Activity::create([
            'note' => $email,
            'accountmanager_id' => Input::get('accountmanager_id'),
            'employer_id' => Input::get('employer_id'),
            'vendor_id' => Input::get('vendor_id'),
            'job_id' => Input::get('job_id'),
            'name' => "Commented by account manager",
            'admin_id' => Input::get('admin_id'),
            'activity_by' => $authuser->id,
            'candidate_id' => Input::get('candidate_id'),
        ]);
        return response()->success('Comment Has been added');
    }

    public function getVendorjobsclosed()
    {
        $authuser = Auth::user();
        $vendorjobsclosed = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->get();
        return response()->success(compact('vendorjobsclosed'));
    }

    public function getVendorteamjobsclosed()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $candidates = array();
        $vendoractivitycandidate = VendorActivities::whereNotNull('job_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
        $vendorteamjobsclosed = Association::whereIn('candidate_id',$candidates)->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->where('job_status',3)
                            ->with('job_closed.status')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',6);
                            })
                             ->get();
        return response()->success(compact('vendorteamjobsclosed'));
    }

    public function getVendorselectedprofiles()
    {
        $authuser = Auth::user();
        if($authuser->parent_id){
            $authId=$authuser->parent_id;
            $a=VendorUserJob::where('vendor_id',$authuser->parent_id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->with('assingnedJob')
                            ->whereHas('assingnedJob',function($query){ $query->where('status','=',8); })
                            ->groupBy('job_id')->lists('job_id');
            $b = array();
            foreach($a as $c){array_push($b, $c);}
            $vendorselectedprofiles = Association::where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereIn('job_id',$b)
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        } else {
            $vendorselectedprofiles = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',27)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        }

        foreach ($vendorselectedprofiles as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['job_id']);
            $encrypted_id = base64_encode($timestamp . $randomKey . $job['candidate_id']);
            $numbers = ['encrypted_jobId'=>$encrypted, 'encrypted_canId'=>$encrypted_id];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('vendorselectedprofiles'));
    }

    public function getVendoruserselectedprofiles()
    {
        $authuser = Auth::user();
        $supervendor = User::where('id',$authuser->id)->get(['first_name','parent_id']);
        $candidates = array();
        $vendoractivitycandidate = VendorActivities::whereNotNull('job_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_user_id')
                                ->get();
        foreach($vendoractivitycandidate as $can){array_push($candidates, $can->candidate_id);}
        $vendoruserselectedprofiles = Association::whereIn('candidate_id',$candidates)->where('vendor_id',$supervendor[0]->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',6)
                            ->with('candidate')
                            ->with('job')
                            ->get();
        return response()->success(compact('vendoruserselectedprofiles'));
    }

    public function getCandidatenumbers($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        $amId = Association::where('job_id',$id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('candidate_status', '<>', 19)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by',$amId)->where('job_id',$id)->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();
        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)
                                            ->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $pendingcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->where('candidate_status',31)
                            ->where('employer_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $candidatenumbers['totalcandidates'] = $assingedcandidates;
        $candidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $candidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $candidatenumbers['selectedcandidates'] = $selectedcandidates;
        $candidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('candidatenumbers'));
    }

    public function getVendorusercandidatenumbers($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id',$id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_user_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('vendor_user_id')
                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authuser->parent_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_user_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendorcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendorcandidatenumbers['rejectedcandidates'] = $rejectedids;
        $vendorcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendorcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendorcandidatenumbers['pendingcandidates'] = $pendingcandidates;

        return response()->success(compact('vendorcandidatenumbers'));
    }

    public function getVendorcandidatenumbers($id)
    {
        $authuser = Auth::user();
        $authId = null;
        if($authuser->parent_id){$authId=$authuser->parent_id;}
        else{$authId=$authuser->id;}
        $amId = Association::where('job_id',$id)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);    }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $assingedcandidates=Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);    }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {array_push($associationsIds, $candidate->id);}
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendorcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendorcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $vendorcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendorcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendorcandidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('vendorcandidatenumbers'));
    }

    public function postVendoruserjobcandidatenumbers()
    {
        $authuser = Auth::user();
        $vendorId= Input::get('vendorId');
        $id= Input::get('joborderId');
        $amId = Association::where('job_id',$id)
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('vendor_id',$vendorId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            array_push($associationsIds, $candidate->id);
        }
        $assingedcandidates = Association::whereIn('id',$associationsIds)->where('vendor_id',$vendorId)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)->whereIn('id',$associationsIds)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('vendor_id',$vendorId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $vendoruserjobcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $vendoruserjobcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $vendoruserjobcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $vendoruserjobcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $vendoruserjobcandidatenumbers['pendingcandidates'] = $pendingcandidates;

        return response()->success(compact('vendoruserjobcandidatenumbers'));
    }

    public function getAmcandidatenumbers($id)
    {
        $authuser = Auth::user();
        $amId = Association::where('job_id',$id)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $candidates = Association::where('job_id',$id)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($candidates as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $activityes = Activity::where('activity_by',$amId)->where('job_id',$id)->whereIn('candidate_status',array(1,2))->get();
        $activityData = array();
        foreach($activityes as $activityesdata) {
            array_push($activityData, $activityesdata->candidate_id);
        }
        /* $allcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->get();*/
        $assingedcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $rejectedids = Association::where('job_id',$id)
                            ->whereIn('candidate_status',array(1, 2, 30))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->with(array('Status','Candidate'))
                            ->get();
        $associationsIds = array();
        foreach($rejectedids as $candidate) {
            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                array_push($associationsIds, $candidate->id);
            }
        }
        $rejectedcandidates = Association::whereIn('id',$associationsIds)->whereNotIn('candidate_id',$activityData)
                                            ->with(array('Status','Candidate'))
                                            ->count();
        $pendingcandidates = Association::where('job_id',$id)
                            ->where('candidate_status',19)
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $shortlistedcandidates = Association::where('job_id',$id)->whereNotIn('candidate_id',$activityData)
                            ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26,31))
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $selectedcandidates = Association::where('job_id',$id)
                            ->whereIn('candidate_status',[27, 28])
                            ->where('accountmanager_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->with(array('Status','Candidate'))
                            ->count();
        $amcandidatenumbers['totalcandidates'] = $assingedcandidates;
        $amcandidatenumbers['rejectedcandidates'] = $rejectedcandidates;
        $amcandidatenumbers['shortlistedcandidates'] = $shortlistedcandidates;
        $amcandidatenumbers['selectedcandidates'] = $selectedcandidates;
        $amcandidatenumbers['pendingcandidates'] = $pendingcandidates;
        return response()->success(compact('amcandidatenumbers'));
    }

    public function getAmmetrics($count)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$count."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        $associated_emp_Ids = array();
        $associated_emps = Association::where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('employer')
                            ->groupBy('employer_id')
                            ->select('employer_id')
                            ->get();
        foreach($associated_emps as $job) {array_push($associated_emp_Ids, $job->employer_id);}
        $alljobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->count();
        $pendingjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',4);
                            })
                             ->count();
        /*$yet_to_accept = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                            })
                            ->count();*/
    $yet_to_accept = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->where('created_at','>=',$diff_date)
                            ->with('employer')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',3);
                            })
                            ->count();
   /* $yet_to_accept = Association::where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereHas('job_closed',function($query){
                                $query->where('status','=',3);
                            })
                            ->groupby('job_id')
                            ->havingRaw('count(vendor_id) < 1')
                            ->count();*/


        $assignedprogressjobs_dummy=Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->with('employer')
                            ->with('employer.company')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->get();

        $jobId = array();
        foreach ($assignedprogressjobs_dummy as $job){
            $jobId[] = $job->job_id;
        }

        //$assignedToRaw = Cache::remember('getAssignedprogressjobs_assignedToRaw', 60, function() use ($authuser, $jobId) {
        $assignedToRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('candidate_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->whereIn('job_id',$jobId)
                            ->with('job.JobType','job.status')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',7);
                            })
                            ->select('job_id', DB::raw('count(id) AS assignedTo'))
                            ->groupBy("job_id")
                            ->get();
        //});

        foreach ($assignedToRaw as $stats){
            $assignedToStats[$stats->job_id] = $stats->assignedTo;
        }

        //$rejectedByRaw = Cache::remember('getAssignedprogressjobs_rejectedByRaw', 60, function() use ($authuser, $jobId) {
        $rejectedByRaw =  Association::select('job_id')->where('accountmanager_id',$authuser->id)
                            ->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('candidate_id')
                            ->whereIn('job_id',$jobId)
                            ->where('job_status',2)
                            ->select('job_id', DB::raw('count(id) AS rejectedBy'))
                            ->groupBy('job_id')
                            ->groupBy('vendor_id')
                            ->get();
        //});

        foreach ($rejectedByRaw as $stats){
            $rejectedByStats[$stats->job_id] = $stats->rejectedBy;
        }

        $i = 0;
        reset($assignedprogressjobs_dummy);
        foreach ($assignedprogressjobs_dummy as $key => $job) {
            $assignedTo = isset($assignedToStats[$job['job_id']])?$assignedToStats[$job['job_id']]:0;
            $rejectedBy = isset($rejectedByStats[$job['job_id']])?$rejectedByStats[$job['job_id']]:0;


            $job['inprogress_vendors'] = $assignedTo - $rejectedBy;


            if($assignedTo == $rejectedBy){
                $i--;
                $assignedprogressjobs_dummy->forget($key);
            }
            $i++;
        }
        //$assignedprogressjobsall = $assignedprogressjobs_dummy->values();
        //print_r($assignedprogressjobs_dummy->values()); die;
        //echo $i; die;
        $in_progress = $i;



        /*$in_progress = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',8);
                            })
                            ->count(); */
        $closedJobs = Association::where('accountmanager_id',$authuser->id)
                            ->whereNotNull('job_id')
                            ->where('created_at','>=',$diff_date)
                            ->with('employer')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',6);
                            })
                            ->count();
        $rejected_by_am = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('status','=',2);
                            })
                            ->count();
        $rejected_by_vendor = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNull('candidate_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->where('job_status',2)
                            ->count();

        $amholdjobs = Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('job_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('candidate_id')
                            ->whereHas('job',function($query){
                                $query->where('status','=',24);
                            })
                            ->count();

        $profiles_gdpr=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })
                            ->get();
        $profiles_gdpr_yes=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('gdpr_status',1)
                            ->whereHas('job',function($query) {
                                $query->where('gdprmandatory','=',0);
                            })
                            ->get();
        $profiles = $profiles_gdpr->merge($profiles_gdpr_yes);
        $pending_profiles=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            //->whereNotNull('candidate_id')->where('gdpr_status',1)
                            ->where('candidate_status',19)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })
                            ->groupby('job_id')
                            ->get();
        $profiles_rejected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                           ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereIn('candidate_status',array(1,2,30))
                            ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_phone=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',17)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_f2f=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',18)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_srt_final=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',20)
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_interview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereNotIn('candidate_status',[19,7,2,1])
                            // ->with('job')
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_directinterview=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',23)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();
        $profiles_skype=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',22)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();

        $profiles_walkin=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->where('candidate_status',21)
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->get();

        $profiles_selected=Association::where('accountmanager_id',$authuser->id)->where('created_at','>=',$diff_date)
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')->where('gdpr_status',0)
                            ->whereIn('candidate_status',[27,28])
                            /*->with('job')*/
                            ->whereHas('job',function($query) {
                                $query->where('status','!=',6);
                            })->groupby('job_id')
                            ->count();

        $ammetrics[]=array('jobs_submitted'=>$alljobs, 'pending' => $pendingjobs, 'yet_to_accept' => $yet_to_accept, 'in_progress' => $in_progress, 'closedJobs' => $closedJobs, 'rejected_by_am' => $rejected_by_am, 'rejected_by_vendor' => $rejected_by_vendor, 'amholdjobs' => $amholdjobs, 'profiles_received'=>$profiles,'profiles_pending'=>count($pending_profiles), 'profiles_rejected'=>$profiles_rejected , 'profiles_srt_phone'=>$profiles_srt_phone, 'profiles_srt_f2f'=> $profiles_srt_f2f, 'profiles_srt_final' => $profiles_srt_final, 'profiles_directinterview' => $profiles_directinterview, 'profiles_skype' => $profiles_skype , 'profiles_walkin' => $profiles_walkin, 'profiles_selected' => $profiles_selected,'profiles_interview'=>$profiles_interview);
        return response()->success(compact('ammetrics'));
    }

    public function getVendordeviationrequest($id)
    {
        $authuser = Auth::user();

        if($authuser->parent_id) {
            $vendordeviationrequest = DeviationRequests::where('job_id', $id)
                                    ->where('vendor_user_id', $authuser->parent_id)
                                    ->get();
        } else {
            $vendordeviationrequest = DeviationRequests::where('job_id', $id)
                                    ->where('vendor_id', $authuser->id)
                                    ->get();
        }

        return response()->success(compact('vendordeviationrequest'));
    }

    public function postAmdeviationrequest()
    {
        $authuser = Auth::user();
        $vendor_id = Input::get('vendor_id');
        $job_id = Input::get('job_id');

        $amdeviationrequest = DeviationRequests::where('job_id', $job_id)
                                    ->where('vendor_id', $vendor_id)
                                    ->where('accountmanager_id', $authuser->id)
                                    ->get();

        return response()->success(compact('amdeviationrequest'));
    }
}
