<?php

namespace App\Http\Controllers;

use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\Language;
use App\Activity;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;

class LanguagesController extends Controller
{
    
    public function getIndex()
    {
        $languages = Languages::all();

        return response()->success(compact('languages'));
    }
 
  public function postLanguages() 
    {
        $languages = Languages::create([
            'name' => Input::get('name'),
            'iso_639-1' => Input::get('iso'),
            
        ]);

        $authuser = Auth::user();
        //Insert Successfull languages create activity record
        $newLanguages = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new languages.',
        ]);
        $newLanguagesResponse =  response()->success(compact('newLanguages'));

        return response()->success(compact('languages'));
    }
public function getLanguages($id)
    {
        $Languages = Languages::find($id);

    return response()->success($role);
    }
    public function getLanguagename()
    {
        $languagename=Language::whereNotNull('name')->groupBy('name')->select('id', 'name')->get();
        return response()->success(compact('languagename'));
    }
public function deleteLanguages($id)
    {
        Languages::destroy($id);
         $authuser = Auth::user();
        //Insert Successfull languages delete activity record
        $deleteLanguages = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted an existing languages.',
        ]);
        $deleteLanguagesResponse =  response()->success(compact('deleteLanguages'));
        return response()->success('success');
    }
  public function getLanguagesShow($id)
    {
        $Languages = Languages::find($id);

        return response()->success($Languages);
    }
      public function putLanguagesShow()
    {
        $LanguagesForm = Input::get('data');
        $LanguagesData = [
            'name' => $LanguagesForm['name']
        ];

        $affectedRows = Languages::where('id', '=', intval($LanguagesForm['id']))->update($LanguagesData);
        $Languages = Languages::find($LanguagesForm['id']);

        $authuser = Auth::user();
        //Insert Successfull languages update activity record
        $updateLanguages = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Updated an existing languages.',
        ]);
        $updateLanguagesResponse =  response()->success(compact('updateLanguages'));

      return response()->success('success');
    }
     
}