<?php

namespace App\Http\Controllers;

use App\User;
use App\ProcessSurvey;
use App\ProcessQuestionAnswers;
use Auth;
use App\Activity;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;

class ProcessSurveyController extends Controller
{
    
  public function getIndex()
    {
         $processurvey=ProcessSurvey::where('status',1)->get();                                      
        return response()->success(compact('processurvey'));
    }

    public function postCreatequestion(Request $request) {
        $authuser = Auth::user();
        $updateCurrentUsercontext = ProcessSurvey::create([
            'question' => $request['name'],
            'choiceA' => $request['choiceA'],
            'choiceB' => $request['choiceB'],
            'choiceC' => $request['choiceC'],
            'choiceD' => $request['choiceD'],
            'answertype' => $request['explain'],
            'role_id' => $authuser->role_id
        ]);
        // echo "<pre>"; print_r($updateCurrentUsercontext); exit;
        
        return response()->success("Created success");
    }


    public function getProcesssurveyreport($id) {
        $authuser = Auth::user();
        $processsurveyreport = ProcessQuestionAnswers::where('processUserName',$id)->whereNotNull('pqId')->with('question')->with('employer')->get();
        // echo "<pre>"; print_r($processsurveyreport); exit;
        return response()->success(compact('processsurveyreport'));
    }

    public function postSubmitsurvey() {
        $authuser = Auth::user();

        $duration = [
            'startTime' => Input::get('startTime'),
            'endTime' => Input::get('endTime'),
            'processSurveyApprove' => 1
        ];
       
        $affectedRows = User::where('id', '=', intval(Input::get('userId')))->update($duration);
        return response()->success("Created success");
    }

    public function postQstnapprove() {
        $authuser = Auth::user();

        $qstnapprove = [
            'is_alive' => 1
        ];
       
        $affectedRows = ProcessSurvey::where('id', '=', intval(Input::get('qstnID')))->update($qstnapprove);
        return response()->success("Created success");
    }

    public function getProcessusers()
    {
        $processusers = User::whereIn('role_id', array(11,12))->orderBy('first_name', 'asc')->with('company')->get();
        
        return response()->success(compact('processusers'));
    }
    
    public function getManagequestionsdata()
    {
        $authuser = Auth::user();
        $managequestionsdata = ProcessSurvey::whereNotNull('question')->get();
       
        return response()->success(compact('managequestionsdata'));
    }

    public function getQuestionsdata()
    {
        $authuser = Auth::user();
        $questionsdata = ProcessSurvey::where('is_alive', 1)->whereNotNull('question')->get();
       
        return response()->success(compact('questionsdata'));
    }

}