<?php
namespace App\Http\Controllers;
use App\Candidate;
use App\CandidateExperiences;
use App\CandidateEducations;
use App\CandidateSkillsets;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use App\SharableUrls;
use Carbon\Carbon;
use App\User;
use App\Association;
use App\Reason;
use App\Status;
use App\Activity;
use App\Country;
use Mail; 


class PublicprofileController extends Controller
{
    public function getPublicprofilenameShow($name){
      $publicprofile = Candidate::find($name);
     $publicprofile['candidate_experiences'] = $publicprofile
                            ->experiences()
                            ->select(['job_title','employer_name','start_date','end_date','is_current_employer'])
                            ->get();
    $publicprofile['candidate_skillsets'] = $publicprofile
                            ->skill()
                            ->select(['skill_set'])
                            ->get();
    $publicprofile['candidate_educations'] = $publicprofile
                            ->educations()
                            ->select(['institution_name','institution_city','degree','start_date','end_date','aggregate'])->orderBy('start_date', 'desc')
                            ->get();
            return response()->success($publicprofile);
    }


    public function postEmployerprofileaccess(){
        $mobile = Input::get('mobile');
        $token = Input::get('token');
        //decrypt token and check if the record is real
        $string = decrypt($token);
        if($string) {
            $share_ids = explode('|',$string);
            if(is_array($share_ids) && count($share_ids) > 0) {
                $sharedurl = SharableUrls::where('id',$share_ids[0])
                                ->where('employer_id',$share_ids[1])
                                ->where('job_id',$share_ids[2])
                                ->where('candidate_id',$share_ids[3])
                                ->where('action',0)
                                ->orderBy('created_at', 'DESC')
                                ->limit(1)
                                ->get();
                if(count($sharedurl) > 0) {
                    foreach ($sharedurl as $url) {
                        $carbon_date = Carbon::parse($url->created_at);
                        $dateCopy4 = Carbon::parse($url->created_at);
                        $dateCopy4->addHours(4);
                        if(Carbon::now()->lt($dateCopy4)) {
                            $user = User::find($share_ids[1]);
                            if($mobile == $user->mobile) {
                                $employerprofileaccess = Association::where('job_id',$url->job_id)
                                                ->where('candidate_id',$url->candidate_id)
                                                ->where('employer_id',$url->employer_id)
                                                ->where('accountmanager_id',$url->accountmanager_id)
                                                ->where('candidate_status',31)
                                                ->with('job','candidate','candidate.asset')
                                                ->limit(1)
                                                ->get();

                                if(count($employerprofileaccess) > 0) {
                                    return response()->success(compact('employerprofileaccess')); 
                                } else {
                                    return response()->error("Action already taken on profile");
                                }
                            }
                        }
                    }
                }
            }
        }
        return response()->error("The link is invalid or expired."); 
    }
        
    public function getReasontoreject()
    {
        $reasontoreject = Reason::where('status_id',2)->get();
        return response()->success(compact('reasontoreject'));
    }

    public function getReasontorejectas()
    {
        $reasontorejectas = Reason::where('status_id',30)->get();
        return response()->success(compact('reasontorejectas'));
    }

    public function getShorlistedstatus()
    {
        $shorlistedstatus = Status::where('parent_id', 5)->get();
        return response()->success(compact('shorlistedstatus'));
    }

     public function postDuplicatejob()
    {
        $jobid = Input::get('jobid');
        $note = Input::get('note');
        $dupcandId = Input::get('dupcandId');
        $employer_id =  Input::get('employer_id');
        $vendor_id = Input::get('vendor_id');
        $accountmanager_id = Input::get('accountmanager_id');       
         $employerName = User::where('id', '=', intval($employer_id))->first()->first_name;
         $employerEmail = User::where('id', '=', intval($employer_id))->first()->email;

        $associationData = [
            'candidate_status' => 1,
            'note' => $note,
            'status_updated_by' => $employer_id,
        ];
        
        $dupcandidate = Association::where('job_id',$jobid)
                            ->where('candidate_id',$dupcandId)
                            ->where('employer_id',$employer_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->update($associationData);

        $dupcandidateValue = Association::where('job_id',$jobid)
                            ->where('candidate_id',$dupcandId)
                            ->where('employer_id',$employer_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->first();


        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile marked as duplicate by Employer";
        $candidateactivity->note = $note;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->vendor_id = $vendor_id;
        $candidateactivity->employer_id = $employer_id;
        $candidateactivity->job_id = $jobid;
        $candidateactivity->candidate_id = $dupcandId;
        $candidateactivity->candidate_status = 1;   
        $candidateactivity->activity_by = $employer_id;   
        $candidateactivity->save();

        $association_info = Association::where('job_id',$jobid)
                            ->where('candidate_id',$dupcandId)
                            ->where('employer_id',$employer_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->with('accountmanager')
                            ->with('vendor')
                            ->with('candidate')
                            ->with('job')
                            ->get();

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile is duplicate one.'], function ($m) use($association_info) {
             $m->to($association_info[0]->vendor->email, 'Duplicate profile')->subject('Duplicate profile');
         });

        $country = Country::where('is_enabled',1)->get();
        $number = $association_info[0]->vendor->mobile;
         $city = \App\City::where('id',$dupcandId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Hello " .$association_info[0]->vendor->first_name. " Your submitted profile (" .$association_info[0]->candidate->full_name.") was marked as Duplicate for the [" .$association_info[0]->job->name."-".$association_info[0]->job->id."] by Employer-".$employerName;
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile is duplicate one.'], function ($m) use($association_info){
             $m->to($association_info[0]->accountmanager->email, 'Duplicate profile')->subject('Duplicate profile');
         });

        
        $number = $association_info[0]->accountmanager['mobile'];
         $city = \App\City::where('id',$dupcandId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Hello " .$association_info[0]->accountmanager->first_name. " Your submitted profile (" .$association_info[0]->candidate->full_name.") was marked as Duplicate for the [" .$association_info[0]->job->name."-".$association_info[0]->job->id."] by Employer-".$employerName;
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $employerName, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile is duplicate one.'], function ($m) use($employerEmail){
             $m->to($employerEmail, 'Duplicate profile')->subject('Duplicate profile');
         });

        $shareData = [
            'action' => 1,
        ];

        $urls = SharableUrls::where('job_id',$jobid)
                            ->where('candidate_id',$dupcandId)
                            ->where('employer_id',$employer_id)
                            ->update($shareData);

        return response()->success(compact('dupcandidate'));
    }

    public function postReasonstoreject()
    { 
        $jobid = Input::get('jobid');
        $note = Input::get('note');
        $reasonIds = Input::get('reasonIds');
        $employer_id =  Input::get('employer_id');
        $vendor_id = Input::get('vendor_id');
        $candId = Input::get('candId');
        $accountmanager_id = Input::get('accountmanager_id');  
        
        $employerName = User::where('id', '=', intval($employer_id))->first()['first_name'];
            $employerEmail = User::where('id', '=', intval($employer_id))->first()['email'];

        $associationData = [
            'candidate_status' => 2,
            'note' => $note,
            'reason_id' => $reasonIds,
            'status_updated_by' => $employer_id,
        ];

        $reasonstoreject = Association::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->update($associationData);

        $reasonstorejectValue = Association::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->first();

        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile rejected by Employer";
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->vendor_id = $vendor_id;
        $candidateactivity->employer_id = $employer_id;
        $candidateactivity->job_id = $jobid;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = 2;
        $candidateactivity->activity_by = $employer_id;
        $candidateactivity->note = $note;
        $candidateactivity->reason_id = $reasonIds;
        $candidateactivity->save();
        

        $association_info = Association::where('job_id',$jobid)
                    ->where('candidate_id',$candId)
                    ->where('employer_id',$employer_id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('vendor_id')
                    ->with('accountmanager')
                    ->with('vendor')
                    ->with('candidate')
                    ->with('job')
                    ->get();
      
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been rejected.'], function ($m) use($association_info){
             $m->to($association_info[0]->vendor->email, 'Rejected profile')->subject('Rejected profile');
         });

        $country = Country::where('is_enabled',1)->get();
        $number = $association_info[0]->vendor->mobile;
         $city = \App\City::where('id',$candId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Hello " .$association_info[0]->vendor->first_name. " Your submitted profile (".$association_info[0]->candidate->full_name.") has been rejected for the job [".$association_info[0]->job->name. "-" .$association_info[0]->job->id."] by Employer-".$employerName;
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been rejected.'], function ($m) use($association_info){
             $m->to($association_info[0]->accountmanager->email, 'Rejected profile')->subject('Rejected profile');
         });

        $number = $association_info[0]->accountmanager['mobile'];
         $city = \App\City::where('id',$candId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Hello " .$association_info[0]->accountmanager->first_name. " Your submitted profile (".$association_info[0]->candidate->full_name.") has been rejected for the job [".$association_info[0]->job->name. "-" .$association_info[0]->job->id."] by Employer-".$employerName;
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

         
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $employerName, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been rejected.'], function ($m) use($employerEmail){
             $m->to($employerEmail, 'Rejected profile')->subject('Rejected profile');
         });

        $shareData = [
            'action' => 1,
        ];

        $urls = SharableUrls::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)
                            ->update($shareData);

        return response()->success(compact('reasonstoreject'));
    }

    
    public function postShortlistedids()
    {
        $shortlistIds = Input::get('shortlistIds');
        $candId = Input::get('candId');
        $shrtListNote = Input::get('shrtListNote');
        $accountmanager_id = Input::get('accountmanager_id');
        $jobid = Input::get('jobid');
        $employer_id = Input::get('employer_id');
        $vendor_id = Input::get('vendor_id');
        $interview_schedule_date = Input::get('interview_schedule_date');
       
        $employerParent = User::where('id', '=', intval($employer_id))->first();
        $associationData = [
            'candidate_status' => $shortlistIds,
            'note' => $shrtListNote,
            'status_updated_by' => $employer_id,
            'interview_schedule_date' =>  $interview_schedule_date,
        ];

        $shortlistedids = Association::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)                            
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->update($associationData);

        $shortlistedidsValue = Association::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)
                            ->where('candidate_status',$shortlistIds)
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->first();

        $candidateactivity = new Activity();
        $candidateactivity->name = "Shortlisted by Employer";
        $candidateactivity->note = $shrtListNote;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->vendor_id = $vendor_id;
        $candidateactivity->employer_id = $employer_id;
        $candidateactivity->job_id = $jobid;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = $shortlistIds;
        $candidateactivity->activity_by = $employer_id;
        $candidateactivity->save();

        $association_info = Association::where('job_id',$jobid)
                    ->where('candidate_status', $shortlistIds)
                    ->where('candidate_id',$candId)
                    ->where('employer_id',$employer_id)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('vendor_id')
                    ->with('accountmanager')
                    ->with('vendor')
                    ->with('candidate')
                    ->with('job')
                    ->get();

       
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been shortlisted.'], function ($m) use($association_info){
             $m->to($association_info[0]->vendor->email, 'Shortlisted profile')->subject('Shortlisted profile');
         });

        $country = Country::where('is_enabled',1)->get();
        $number = $association_info[0]->vendor->mobile;
        $city = \App\City::where('id',$candId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been shortlisted.'], function ($m) use($association_info) {
             $m->to($association_info[0]->accountmanager['email'], 'Shortlisted profile')->subject('Shortlisted profile');
         });

         $number = $association_info[0]->accountmanager['mobile'];
        $city = \App\City::where('id',$candId['city_id'])->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $employerParent['first_name'], 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been shortlisted.'], function ($m) use($employerParent){
             $m->to($employerParent['email'], 'Shortlisted profile')->subject('Shortlisted profile');
         });

        $number = $employerParent->mobile;
        $countryCode = 91;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been shortlisted.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $shareData = [
            'action' => 1,
        ];

        $urls = SharableUrls::where('job_id',$jobid)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$employer_id)
                            ->update($shareData);

        return response()->success(compact('shortlistedids'));
    }

    public function postSelectedids()
    {
        $joborderId = Input::get('joborderId');
        $shortlistIds = Input::get('shortlistIds');
        $candId = Input::get('candId');
        $shrtListNote = Input::get('shrtListNote');
        $accountmanager_id = Input::get('accountmanager_id');
        $jobid = Input::get('jobid');
        $employer_id = Input::get('employer_id');
        $vendor_id = Input::get('vendor_id');
        $empId =  Input::get('empId');
        $authuser =User::find($empId);

        $authId = null;
        $employerParent = $authuser;
        if($authuser->parent_id){
            $employerParent = User::where('id', '=', intval($authuser->parent_id))->first();
            $authId=$authuser->parent_id;
        }else {$authId=$authuser->id;}

        $associationData = [
            'candidate_status' => $shortlistIds,
            'note' => $shrtListNote,
            'status_updated_by' => $authId,
        ];

        $selectedids = Association::where('job_id',$joborderId)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$authId)
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->update($associationData);

        $shortlistedidsValue = Association::where('job_id',$joborderId)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$authId)
                            ->where('candidate_status',$shortlistIds)
                            ->whereNotNull('candidate_status')
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('status_updated_by')
                            ->first();

        $candidateactivity = new Activity();
        $candidateactivity->name = "Profile selected by Employer";
        $candidateactivity->note = $shrtListNote;
        $candidateactivity->admin_id = 1;
        $candidateactivity->accountmanager_id = $accountmanager_id;
        $candidateactivity->vendor_id =$vendor_id;
        $candidateactivity->employer_id = $authId;
        $candidateactivity->job_id = $joborderId;
        $candidateactivity->candidate_id = $candId;
        $candidateactivity->candidate_status = $shortlistIds;
        $candidateactivity->activity_by = $authId;
        $candidateactivity->save();

        if($authuser->parent_id){
            $candidateactivity = new Activity();
            $candidateactivity->name = "Profile selected by Employer";
            $candidateactivity->note = $shrtListNote;
            $candidateactivity->admin_id = 1;
            $candidateactivity->accountmanager_id = $shortlistedidsValue->accountmanager_id;
            $candidateactivity->vendor_id = $shortlistedidsValue->vendor_id;
            $candidateactivity->employer_id = $authuser->parent_id;
            $candidateactivity->employer_user_id = $authuser->id;
            $candidateactivity->job_id = $joborderId;
            $candidateactivity->candidate_id = $candId;
            $candidateactivity->candidate_status = $shortlistIds;
            $candidateactivity->activity_by = $authuser->id;
            $candidateactivity->save();
        }
        
        $association_info=Association::where('job_id',$joborderId)
                    ->where('candidate_status', $shortlistIds)
                    ->where('candidate_id',$candId)
                    ->where('employer_id',$authId)
                    ->whereNotNull('accountmanager_id')
                    ->whereNotNull('vendor_id')
                    ->with('accountmanager')
                    ->with('vendor')
                    ->with('candidate')
                    ->with('job')
                    ->get();

        //TODO Send Email to vendor stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->vendor->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been selected.'], function ($m) use($association_info){
            $m->to($association_info[0]->vendor->email, 'Selected profile')->subject('Selected profile');
         });

        $country = Country::where('is_enabled',1)->get();
        $number = $association_info[0]->vendor->mobile;
        $countryCode = $country[0]->ISD_code;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

         //TODO Send Email to Am stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $association_info[0]->accountmanager->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been selected.'], function ($m) use($association_info) {
             $m->to($association_info[0]->accountmanager->email, 'Selected profile')->subject('Selected profile');
         });

        $number = $association_info[0]->accountmanager->mobile;
        $countryCode = $country[0]->ISD_code;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

         //TODO Send Email to Employer stating that profile is duplicate.
        Mail::send('emails.notifyCandidateJobStatusChange', ['userName' => $employerParent->first_name, 'candidateName' => $association_info[0]->candidate->full_name, 'jobName' => $association_info[0]->job->name,  'text' => 'This profile has been selected.'], function ($m) use($employerParent){
            $m->to($employerParent->email, 'Selected profile')->subject('Selected profile');
         });

        $number = $employerParent->mobile;
        $countryCode = $country[0]->ISD_code;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt="Your submitted profile ". $association_info[0]->candidate->full_name . " has been selected.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

    // Check if positions are still open
        $closedjobProfileCount = (int) Association::where('job_id', $joborderId)
                                ->where('employer_id', $authuser)
                                ->whereIn('candidate_status', array(27, 28))
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('vendor_user_id')
                                ->whereNotNull('vendor_id')
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->count();

        $positions=(int) JobOrders::where('id', $joborderId)
                                    ->where('user_id', $authId)
                                    ->first()->vacancies;
                    
        //Close job if all the positions are filled.
        if( $positions == $closedjobProfileCount ){
                $joborderData = ['status' => 6];
                $note = 'Closing this job due to all the positions are filled';
                $associationData = [
                    'candidate_status' => 6,
                    'note' => $note,
                    'status_updated_by' => $authId,
                ];
                $closejoborder = JobOrders::where('id',$joborderId)
                                    ->where('user_id', $authId)
                                    ->whereNotNull('status')
                                    ->update($joborderData);
                $association_update=Association::where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->where('job_id',$joborderId)
                                    ->whereNull('candidate_id')
                                    ->whereNotNull('status_updated_by')
                                    ->update($associationData);
             
                $candidateactivity = new Activity();
                $candidateactivity->name = 'Closed the job.';
                $candidateactivity->admin_id = 1;
                $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
                $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
                $candidateactivity->employer_id = $authId;
                $candidateactivity->job_id = $joborderId;
                $candidateactivity->candidate_id = $candId;
                $candidateactivity->candidate_status = 0;
                $candidateactivity->activity_by = $authId;
                $candidateactivity->save();

                if($authuser->parent_id){
                    $candidateactivity = new Activity();
                    $candidateactivity->name = 'Closed the job.';
                    $candidateactivity->admin_id = 1;
                    $candidateactivity->accountmanager_id = $reasonstorejectValue->accountmanager_id;
                    $candidateactivity->vendor_id = $reasonstorejectValue->vendor_id;
                    $candidateactivity->employer_id = $authuser->parent_id;
                    $candidateactivity->employer_user_id = $authuser->id;
                    $candidateactivity->job_id = $joborderId;
                    $candidateactivity->candidate_id = $candId;
                    $candidateactivity->candidate_status = 0;
                    $candidateactivity->activity_by = $authuser->id;
                    $candidateactivity->save();
                }
                //Get all the required info to send sms & email.
                $association_info = Association::where('job_id',$joborderId)
                                    ->where('candidate_status',6)
                                    ->whereNull('candidate_id')
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('vendor_id')
                                    ->with('accountmanager')
                                    ->with('candidate')
                                    ->with('job')
                                    ->first();

                $association_vendor_info = Association::where('job_id',$joborderId)
                                    ->whereNull('candidate_id')
                                    ->where('employer_id',$authId)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNotNull('vendor_id')
                                    ->groupBy('vendor_id')
                                    ->with('vendor')
                                    ->with('job')
                                    ->get();

            //Get the enabled country
            $country = Country::where('is_enabled',1)->first();
            //Foreach to send emails and
                foreach ($association_vendor_info as $vendor) {
                    //TODO Send Email to vendor stating that job is closed.
                    Mail::send('emails.notifyClosedJob', ['jobInternalCode' => $joborderId, 'jobTitle' => $association_info->job->name], function ($m) use($vendor) {
                         $m->to($vendor->vendor->email, 'Job is closed')->subject('Job is closed');
                     });
                    $number = $vendor->vendor->mobile;
                    $countryCode = $country->ISD_code;
                    $ch = curl_init();
                    $user="kv@hirextra.com";
                    $password="hirextra";
                    $receipientno = $countryCode.$number; 
                    $originator = "HRXTRA";
                    $msgtxt = "Job Title: ".$association_info->job->name." has been closed due to all the position are filled.";
                    curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                    $buffer = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                } // foreach close

                    //TODO Send Email to Am stating that job is closed.
                    Mail::send('emails.notifyClosedJob',['jobInternalCode'=>$joborderId, 'jobTitle'=>$association_info->job->name],function ($m) use($association_info) {
                        $m->to($association_info->accountmanager->email, 'Job is closed')->subject('Job is closed');
                     });
                    
                    $number = $association_info->accountmanager->mobile;
                    $countryCode = $country->ISD_code;
                    $ch = curl_init();
                    $user="kv@hirextra.com";
                    $password="hirextra";
                    $receipientno = $countryCode.$number; 
                    $originator = "HRXTRA";
                    $msgtxt = "Job Title: ".$association_info->job->name." has been closed due to all the position are filled";
                    curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                    $buffer = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                     //TODO Send Email to Employer stating that profile is duplicate.
                    Mail::send('emails.notifyClosedJob',['jobInternalCode'=>$joborderId, 'jobTitle'=>$association_info->job->name],function ($m) use($employerParent) {
                         $m->to($employerParent->email, 'Job is closed')->subject('Job is closed');
                     });
                    $number = $employerParent->mobile;
                    $countryCode = $country->ISD_code;
                    $ch = curl_init();
                    $user="kv@hirextra.com";
                    $password="hirextra";
                    $receipientno = $countryCode.$number; 
                    $originator = "HRXTRA";
                    $msgtxt = "Job Title: ".$association_info->job->name." has been closed due to all the position are filled";
                    curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
                    $buffer = curl_exec($ch);
                    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
            } // Check if all positions are filled.
        
        $shareData = [
            'action' => 1,
        ];

        $urls = SharableUrls::where('job_id',$joborderId)
                            ->where('candidate_id',$candId)
                            ->where('employer_id',$empId)
                            ->update($shareData);

        return response()->success(compact('selectedids'));
    }


}